/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.spatial;

import db.DBRecord;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.spatial.BoundedShape;
import ghidra.util.database.spatial.BoundingShape;
import ghidra.util.database.spatial.DBTreeRecord;
import java.util.Map;
import java.util.Objects;

public abstract class DBTreeDataRecord<DS extends BoundedShape<NS>, NS extends BoundingShape<NS>, T>
extends DBTreeRecord<DS, NS> {
    private final RecordEntry<DS, NS, T> entry = new RecordEntry<DS, NS, T>(){

        public String toString() {
            Object value = this.getValue();
            return String.format("<DataEntry(%d) %s=%s, parentKey=%d>", this.asRecord().getKey(), DBTreeDataRecord.this.getShape().description(), value == DBTreeDataRecord.this ? "record" : value, DBTreeDataRecord.this.getParentKey());
        }

        @Override
        public boolean equals(Object obj) {
            return this.doEquals(obj);
        }

        @Override
        public int hashCode() {
            return this.doHashCode();
        }

        @Override
        public DS getKey() {
            return DBTreeDataRecord.this.getShape();
        }

        @Override
        public T getValue() {
            return DBTreeDataRecord.this.getRecordValue();
        }

        @Override
        public T setValue(T value) {
            Object old = DBTreeDataRecord.this.getRecordValue();
            DBTreeDataRecord.this.setRecordValue(value);
            return old;
        }

        @Override
        public DBTreeDataRecord<DS, NS, T> asRecord() {
            return DBTreeDataRecord.this;
        }
    };

    public DBTreeDataRecord(DBCachedObjectStore<?> store, DBRecord record) {
        super(store, record);
    }

    protected abstract boolean shapeEquals(DS var1);

    public String toString() {
        T value = this.getRecordValue();
        return String.format("<Data(%d) %s=%s, parentKey=%d>", this.getKey(), this.getShape().description(), value == this ? "this" : value, this.getParentKey());
    }

    protected abstract void setRecordValue(T var1);

    protected abstract T getRecordValue();

    protected RecordEntry<DS, NS, T> asEntry() {
        return this.entry;
    }

    @Override
    protected int getDataCount() {
        return 1;
    }

    protected static interface RecordEntry<DS extends BoundedShape<NS>, NS extends BoundingShape<NS>, T>
    extends Map.Entry<DS, T> {
        public DBTreeDataRecord<DS, NS, T> asRecord();

        default public boolean doEquals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)obj;
            if (!Objects.equals(this.getKey(), that.getKey())) {
                return false;
            }
            return Objects.equals(this.getValue(), that.getValue());
        }

        default public int doHashCode() {
            return Objects.hashCode(this.getKey()) ^ Objects.hashCode(this.getValue());
        }
    }
}

