/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.Msg;
import java.util.function.BiConsumer;

public class TimedMsg {
    private static long last = 0L;

    private static synchronized void doMsg(BiConsumer<Object, String> msg, Object originator, String message) {
        if (last == 0L) {
            last = System.currentTimeMillis();
            msg.accept(originator, "(started) " + message);
        } else {
            long now = System.currentTimeMillis();
            long lapsed = now - last;
            last = now;
            msg.accept(originator, "(" + lapsed + " ms) " + message);
        }
    }

    public static void debug(Object originator, String message) {
        TimedMsg.doMsg(Msg::debug, originator, message);
    }
}

