/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.EventType;
import ghidra.program.model.address.Address;
import ghidra.program.util.ProgramEvent;

public class ProgramChangeRecord
extends DomainObjectChangeRecord {
    private Address start;
    private Address end;
    private Object affectedObj;

    public ProgramChangeRecord(ProgramEvent eventType, Address start, Address end, Object affected, Object oldValue, Object newValue) {
        super((EventType)eventType, oldValue, newValue);
        this.start = start;
        this.end = end;
        this.affectedObj = affected;
    }

    public ProgramChangeRecord(ProgramEvent eventType, Object oldValue, Object newValue) {
        this(eventType, null, null, null, oldValue, newValue);
    }

    public Address getStart() {
        return this.start;
    }

    public Address getEnd() {
        return this.end;
    }

    public Object getObject() {
        return this.affectedObj;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        if (this.affectedObj != null) {
            builder.append(", affected = " + String.valueOf(this.affectedObj));
        }
        if (this.start != null) {
            builder.append(", start = ");
            builder.append(this.start);
        }
        if (this.end != null) {
            builder.append(", end = ");
            builder.append(this.end);
        }
        return builder.toString();
    }
}

