/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.symbol;

import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;

public interface Namespace {
    public static final long GLOBAL_NAMESPACE_ID = 0L;
    public static final String DELIMITER = "::";
    @Deprecated
    public static final String NAMESPACE_DELIMITER = "::";

    public Symbol getSymbol();

    public boolean isExternal();

    public String getName();

    public String getName(boolean var1);

    default public List<String> getPathList(boolean omitLibrary) {
        if (this.isGlobal()) {
            return Collections.emptyList();
        }
        ArrayDeque<String> list = new ArrayDeque<String>();
        Namespace n = this;
        while (!(n.isGlobal() || omitLibrary && n.isLibrary())) {
            list.addFirst(n.getName());
            n = n.getParentNamespace();
        }
        return List.copyOf(list);
    }

    public long getID();

    public Namespace getParentNamespace();

    public AddressSetView getBody();

    public void setParentNamespace(Namespace var1) throws DuplicateNameException, InvalidInputException, CircularDependencyException;

    default public boolean isGlobal() {
        return this.getID() == 0L;
    }

    default public boolean isLibrary() {
        Symbol s = this.getSymbol();
        return s != null && s.getSymbolType() == SymbolType.LIBRARY;
    }
}

