/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.ToolButton;
import ghidra.framework.model.Project;
import ghidra.framework.model.ToolChest;
import ghidra.framework.model.ToolChestChangeListener;
import ghidra.framework.model.ToolSet;
import ghidra.framework.model.ToolTemplate;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JToolBar;

class ProjectToolBar
extends JToolBar
implements ToolChestChangeListener {
    private static final int TYPICAL_NUM_TOOLS = 5;
    private Map<String, ToolButton> toolButtonMap;
    private FrontEndPlugin plugin;
    private FrontEndTool tool;

    ProjectToolBar(FrontEndPlugin plugin) {
        this.plugin = plugin;
        this.tool = (FrontEndTool)plugin.getTool();
        this.toolButtonMap = new HashMap<String, ToolButton>(5);
        this.setBorder(BorderFactory.createTitledBorder("Tool Chest"));
        this.setActiveProject(plugin.getActiveProject());
        this.setOpaque(false);
        this.setFloatable(false);
    }

    @Override
    public void toolTemplateAdded(ToolTemplate toolConfig) {
        this.populateToolBar();
    }

    @Override
    public void toolSetAdded(ToolSet toolset) {
        ToolChest toolChest = this.tool.getProject().getLocalToolChest();
        this.toolTemplateAdded(toolChest.getToolTemplate(toolset.getName()));
    }

    @Override
    public void toolRemoved(String toolName) {
        if (!this.toolButtonMap.containsKey(toolName)) {
            return;
        }
        ToolButton button = this.toolButtonMap.get(toolName);
        this.remove((Component)((Object)button));
        this.toolButtonMap.remove(toolName);
        button.dispose();
        this.tool.getToolFrame().validate();
        this.repaint();
    }

    void setActiveProject(Project project) {
        this.clear();
        if (project == null) {
            return;
        }
        this.populateToolBar();
    }

    private void clear() {
        this.removeAll();
        for (ToolButton tb : this.toolButtonMap.values()) {
            tb.dispose();
        }
        this.toolButtonMap.clear();
        if (this.tool.isVisible()) {
            this.tool.getToolFrame().validate();
        }
    }

    private void populateToolBar() {
        ToolTemplate[] templates;
        this.removeAll();
        this.toolButtonMap.clear();
        ToolChest tc = this.plugin.getActiveProject().getLocalToolChest();
        for (ToolTemplate element : templates = tc.getToolTemplates()) {
            this.addConfig(element);
        }
        this.invalidate();
        this.tool.getToolFrame().validate();
        this.repaint();
    }

    private void addConfig(ToolTemplate toolConfig) {
        ToolButton button = new ToolButton(this.plugin, toolConfig);
        this.add((Component)((Object)button));
        this.toolButtonMap.put(toolConfig.getName(), button);
    }

    public ToolButton getToolButtonForToolConfig(ToolTemplate toolTemplate) {
        return this.toolButtonMap.get(toolTemplate.getName());
    }
}

