/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.progress;

import ghidra.app.plugin.core.debug.service.progress.DefaultCloseableTaskMonitor;
import ghidra.app.plugin.core.debug.service.progress.DefaultMonitorReceiver;
import ghidra.app.services.ProgressService;
import ghidra.debug.api.progress.CloseableTaskMonitor;
import ghidra.debug.api.progress.MonitorReceiver;
import ghidra.debug.api.progress.ProgressListener;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.datastruct.ListenerSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

@PluginInfo(category="Debugger", shortDescription="Service for monitoring task progress", description="Implements a pub-sub model for notifying of tasks and progress. Publishers can create\ntask monitors and update them using the TaskMonitor interface. Subscribers (there ought\nto only be one) are notified of the tasks and render progress in a component provider.\n", servicesProvided={ProgressService.class}, packageName="Debugger", status=PluginStatus.RELEASED)
public class ProgressServicePlugin
extends Plugin
implements ProgressService {
    ListenerSet<ProgressListener> listeners = new ListenerSet(ProgressListener.class, true);
    Set<MonitorReceiver> monitors = new HashSet<MonitorReceiver>();

    public ProgressServicePlugin(PluginTool tool) {
        super(tool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableTaskMonitor publishTask() {
        DefaultCloseableTaskMonitor monitor = new DefaultCloseableTaskMonitor(this);
        Set<MonitorReceiver> set = this.monitors;
        synchronized (set) {
            this.monitors.add(monitor.getReceiver());
        }
        ((ProgressListener)this.listeners.invoke()).monitorCreated((MonitorReceiver)monitor.getReceiver());
        return monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<MonitorReceiver> getAllMonitors() {
        Set<MonitorReceiver> set = this.monitors;
        synchronized (set) {
            return Set.copyOf(this.monitors);
        }
    }

    public void addProgressListener(ProgressListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.listeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disposeMonitor(DefaultMonitorReceiver monitor, ProgressListener.Disposal disposal) {
        boolean changed;
        Set<MonitorReceiver> set = this.monitors;
        synchronized (set) {
            changed = this.monitors.remove(monitor);
        }
        if (changed) {
            ((ProgressListener)this.listeners.invoke()).monitorDisposed((MonitorReceiver)monitor, disposal);
        }
    }
}

