/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.appearance.plugin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import org.gephi.appearance.api.RankingFunction;
import org.gephi.appearance.plugin.RankingElementColorTransformer;
import org.gephi.ui.appearance.plugin.RecentPalettes;
import org.gephi.ui.components.PaletteIcon;
import org.gephi.ui.components.gradientslider.GradientSlider;
import org.gephi.utils.PaletteUtils;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class RankingColorTransformerPanel
extends JPanel {
    private final RecentPalettes recentPalettes;
    private RankingElementColorTransformer colorTransformer;
    private final GradientSlider gradientSlider;
    private JButton colorSwatchButton;
    private JToolBar colorSwatchToolbar;
    private JPanel gradientPanel;
    private JLabel labelColor;

    public RankingColorTransformerPanel() {
        this.initComponents();
        this.recentPalettes = new RecentPalettes();
        this.gradientSlider = new GradientSlider(0);
        this.gradientSlider.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (RankingColorTransformerPanel.this.colorTransformer != null && (!RankingColorTransformerPanel.this.gradientSlider.isValueAdjusting() && evt.getPropertyName().equals("values") || evt.getPropertyName().equals("adjusting") && evt.getNewValue().equals(Boolean.FALSE))) {
                    Object[] colors = RankingColorTransformerPanel.this.gradientSlider.getColors();
                    float[] positions = RankingColorTransformerPanel.this.gradientSlider.getThumbPositions();
                    if (!Arrays.equals(positions, RankingColorTransformerPanel.this.colorTransformer.getColorPositions()) || !Arrays.deepEquals(colors, RankingColorTransformerPanel.this.colorTransformer.getColors())) {
                        RankingColorTransformerPanel.this.colorTransformer.setColors((Color[])Arrays.copyOf(colors, colors.length));
                        RankingColorTransformerPanel.this.colorTransformer.setColorPositions(Arrays.copyOf(positions, positions.length));
                        RankingColorTransformerPanel.this.addRecentPalette();
                    }
                }
            }
        });
        this.gradientPanel.add((Component)this.gradientSlider, "Center");
        this.colorSwatchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JPopupMenu popupMenu = RankingColorTransformerPanel.this.getPalettePopupMenu();
                popupMenu.show(RankingColorTransformerPanel.this.colorSwatchToolbar, -popupMenu.getPreferredSize().width, 0);
            }
        });
    }

    public void setup(RankingFunction function) {
        this.colorTransformer = (RankingElementColorTransformer)function.getTransformer();
        float[] positionsStart = this.colorTransformer.getColorPositions();
        Object[] colorsStart = this.colorTransformer.getColors();
        this.gradientSlider.setValues(positionsStart, colorsStart);
    }

    private JPopupMenu getPalettePopupMenu() {
        JMenuItem item;
        PaletteUtils.Palette p3;
        JPopupMenu popupMenu = new JPopupMenu();
        JMenu defaultMenu = new JMenu(NbBundle.getMessage(RankingColorTransformerPanel.class, (String)"PalettePopup.default"));
        for (PaletteUtils.Palette p : PaletteUtils.getSequencialPalettes()) {
            p3 = PaletteUtils.get3ClassPalette((PaletteUtils.Palette)p);
            item = new JMenuItem((Icon)new PaletteIcon(p3.getColors()));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RankingColorTransformerPanel.this.gradientSlider.setValues(p3.getPositions(), (Object[])p3.getColors());
                }
            });
            defaultMenu.add(item);
        }
        for (PaletteUtils.Palette p : PaletteUtils.getDivergingPalettes()) {
            p3 = PaletteUtils.get3ClassPalette((PaletteUtils.Palette)p);
            item = new JMenuItem((Icon)new PaletteIcon(p3.getColors()));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RankingColorTransformerPanel.this.gradientSlider.setValues(p3.getPositions(), (Object[])p3.getColors());
                }
            });
            defaultMenu.add(item);
        }
        popupMenu.add(defaultMenu);
        JMenuItem invertItem = new JMenuItem(NbBundle.getMessage(RankingColorTransformerPanel.class, (String)"PalettePopup.invert"));
        invertItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RankingColorTransformerPanel.this.gradientSlider.setValues(RankingColorTransformerPanel.this.invert(RankingColorTransformerPanel.this.gradientSlider.getThumbPositions()), (Object[])RankingColorTransformerPanel.this.invert(RankingColorTransformerPanel.this.gradientSlider.getColors()));
            }
        });
        popupMenu.add(invertItem);
        JMenu recentMenu = new JMenu(NbBundle.getMessage(RankingColorTransformerPanel.class, (String)"PalettePopup.recent"));
        for (final RankingElementColorTransformer.LinearGradient gradient : this.recentPalettes.getPalettes()) {
            JMenuItem item2 = new JMenuItem((Icon)new PaletteIcon(gradient.getColors()));
            item2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RankingColorTransformerPanel.this.gradientSlider.setValues(gradient.getPositions(), (Object[])gradient.getColors());
                }
            });
            recentMenu.add(item2);
        }
        popupMenu.add(recentMenu);
        return popupMenu;
    }

    private void addRecentPalette() {
        RankingElementColorTransformer.LinearGradient gradient = this.colorTransformer.getLinearGradient();
        this.recentPalettes.add(gradient);
    }

    private Color[] invert(Color[] source) {
        int len = source.length;
        Color[] res = new Color[len];
        for (int i = 0; i < len; ++i) {
            res[i] = source[len - 1 - i];
        }
        return res;
    }

    private float[] invert(float[] source) {
        int len = source.length;
        float[] res = new float[len];
        for (int i = 0; i < len; ++i) {
            res[i] = 1.0f - source[len - 1 - i];
        }
        return res;
    }

    private void initComponents() {
        this.labelColor = new JLabel();
        this.gradientPanel = new JPanel();
        this.colorSwatchToolbar = new JToolBar();
        this.colorSwatchButton = new JButton();
        this.setPreferredSize(new Dimension(225, 114));
        this.labelColor.setText(NbBundle.getMessage(RankingColorTransformerPanel.class, (String)"RankingColorTransformerPanel.labelColor.text"));
        this.gradientPanel.setOpaque(false);
        this.gradientPanel.setLayout(new BorderLayout());
        this.colorSwatchToolbar.setFloatable(false);
        this.colorSwatchToolbar.setRollover(true);
        this.colorSwatchToolbar.setOpaque(false);
        this.colorSwatchButton.setIcon(ImageUtilities.loadImageIcon((String)"AppearancePluginUI/color-swatch.png", (boolean)false));
        this.colorSwatchButton.setFocusable(false);
        this.colorSwatchButton.setHorizontalTextPosition(0);
        this.colorSwatchButton.setIconTextGap(0);
        this.colorSwatchButton.setMargin(new Insets(0, 0, 0, 0));
        this.colorSwatchButton.setVerticalTextPosition(3);
        this.colorSwatchToolbar.add(this.colorSwatchButton);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.labelColor).addGap(18, 18, 18).addComponent(this.gradientPanel, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.colorSwatchToolbar, -2, -1, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.colorSwatchToolbar, -2, 22, -2).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelColor, -2, 20, -2).addComponent(this.gradientPanel, -2, 17, -2)))).addContainerGap(88, Short.MAX_VALUE)));
    }
}

