/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.explorer.mindmapmode;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.FocusRequestor;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.explorer.mindmapmode.MMapExplorerController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

class SetNodeAlias
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private MMapExplorerController explorer;

    public SetNodeAlias(MMapExplorerController explorer) {
        super("SetNodeAliasAction");
        this.explorer = explorer;
    }

    public void actionPerformed(ActionEvent e) {
        NodeModel node = Controller.getCurrentModeController().getMapController().getSelectedNode();
        String alias = this.explorer.getAlias(node);
        String title = TextUtils.getText((String)this.getTextKey());
        JLabel aliasLabel = TranslatedElementFactory.createLabel((String)"node_alias");
        JTextField aliasInput = new JTextField(alias, 40);
        FocusRequestor.requestFocus((Component)aliasInput);
        JCheckBox globalNodeCheckBox = TranslatedElementFactory.createCheckBox((String)"globally_accessible");
        globalNodeCheckBox.setSelected(this.explorer.isGlobal(node));
        Box components = Box.createVerticalBox();
        components.add(aliasLabel);
        components.add(aliasInput);
        components.add(globalNodeCheckBox);
        if (0 == JOptionPane.showConfirmDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), components, title, 2, -1)) {
            this.explorer.setAlias(node, aliasInput.getText());
            this.explorer.makeGlobal(node, globalNodeCheckBox.isSelected());
        }
    }
}

