/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.ImportContext;
import com.tngtech.archunit.core.domain.InstanceofCheck;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaConstructorCall;
import com.tngtech.archunit.core.domain.JavaConstructorReference;
import com.tngtech.archunit.core.domain.JavaEnumConstant;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.domain.JavaGenericArrayType;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.core.domain.JavaMethodReference;
import com.tngtech.archunit.core.domain.JavaParameterizedType;
import com.tngtech.archunit.core.domain.JavaStaticInitializer;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.JavaTypeVariable;
import com.tngtech.archunit.core.domain.JavaWildcardType;
import com.tngtech.archunit.core.domain.ReferencedClassObject;
import com.tngtech.archunit.core.domain.Source;
import com.tngtech.archunit.core.domain.ThrowsClause;
import com.tngtech.archunit.core.domain.TryCatchBlock;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

@Internal
public class DomainObjectCreationContext {
    public static JavaClasses createJavaClasses(Map<String, JavaClass> selectedClasses, Collection<JavaClass> allClasses, ImportContext importContext) {
        return JavaClasses.of(selectedClasses, allClasses, importContext);
    }

    public static JavaClass createJavaClass(DomainBuilders.JavaClassBuilder builder) {
        return new JavaClass(builder);
    }

    public static void completeClassHierarchy(JavaClass javaClass, ImportContext importContext) {
        javaClass.completeClassHierarchyFrom(importContext);
    }

    public static void completeEnclosingDeclaration(JavaClass javaClass, ImportContext importContext) {
        javaClass.completeEnclosingDeclarationFrom(importContext);
    }

    public static void completeTypeParameters(JavaClass javaClass, ImportContext importContext) {
        javaClass.completeTypeParametersFrom(importContext);
    }

    public static void completeGenericSuperclass(JavaClass javaClass, ImportContext importContext) {
        javaClass.completeGenericSuperclassFrom(importContext);
    }

    public static void completeGenericInterfaces(JavaClass javaClass, ImportContext importContext) {
        javaClass.completeGenericInterfacesFrom(importContext);
    }

    public static void completeMembers(JavaClass javaClass, ImportContext importContext) {
        javaClass.completeMembers(importContext);
    }

    public static void completeAnnotations(JavaClass javaClass, ImportContext importContext) {
        javaClass.completeAnnotations(importContext);
    }

    public static <T extends HasDescription> JavaAnnotation<T> createJavaAnnotation(T owner, DomainBuilders.JavaAnnotationBuilder builder) {
        return new JavaAnnotation<T>(owner, builder);
    }

    public static JavaField createJavaField(DomainBuilders.JavaFieldBuilder builder) {
        return new JavaField(builder);
    }

    public static TryCatchBlock createTryCatchBlock(DomainBuilders.TryCatchBlockBuilder builder) {
        return new TryCatchBlock(builder);
    }

    public static JavaFieldAccess createJavaFieldAccess(DomainBuilders.JavaFieldAccessBuilder builder) {
        return new JavaFieldAccess(builder);
    }

    public static AccessTarget.FieldAccessTarget createFieldAccessTarget(DomainBuilders.FieldAccessTargetBuilder builder) {
        return new AccessTarget.FieldAccessTarget(builder);
    }

    public static JavaConstructor createJavaConstructor(DomainBuilders.JavaConstructorBuilder builder) {
        return new JavaConstructor(builder);
    }

    public static JavaConstructorCall createJavaConstructorCall(DomainBuilders.JavaConstructorCallBuilder builder) {
        return new JavaConstructorCall(builder);
    }

    public static JavaConstructorReference createJavaConstructorReference(DomainBuilders.JavaConstructorReferenceBuilder builder) {
        return new JavaConstructorReference(builder);
    }

    public static AccessTarget.ConstructorCallTarget createConstructorCallTarget(DomainBuilders.CodeUnitAccessTargetBuilder<JavaConstructor, AccessTarget.ConstructorCallTarget> builder) {
        return new AccessTarget.ConstructorCallTarget(builder);
    }

    public static AccessTarget.ConstructorReferenceTarget createConstructorReferenceTarget(DomainBuilders.CodeUnitAccessTargetBuilder<JavaConstructor, AccessTarget.ConstructorReferenceTarget> builder) {
        return new AccessTarget.ConstructorReferenceTarget(builder);
    }

    public static JavaMethod createJavaMethod(DomainBuilders.JavaMethodBuilder builder, Function<JavaMethod, Optional<Object>> createAnnotationDefaultValue) {
        return new JavaMethod(builder, createAnnotationDefaultValue);
    }

    public static JavaMethodCall createJavaMethodCall(DomainBuilders.JavaMethodCallBuilder builder) {
        return new JavaMethodCall(builder);
    }

    public static JavaMethodReference createJavaMethodReference(DomainBuilders.JavaMethodReferenceBuilder builder) {
        return new JavaMethodReference(builder);
    }

    public static AccessTarget.MethodCallTarget createMethodCallTarget(DomainBuilders.CodeUnitAccessTargetBuilder<JavaMethod, AccessTarget.MethodCallTarget> builder) {
        return new AccessTarget.MethodCallTarget(builder);
    }

    public static AccessTarget.MethodReferenceTarget createMethodReferenceTarget(DomainBuilders.CodeUnitAccessTargetBuilder<JavaMethod, AccessTarget.MethodReferenceTarget> builder) {
        return new AccessTarget.MethodReferenceTarget(builder);
    }

    public static JavaStaticInitializer createJavaStaticInitializer(DomainBuilders.JavaStaticInitializerBuilder builder) {
        return new JavaStaticInitializer(builder);
    }

    public static JavaEnumConstant createJavaEnumConstant(DomainBuilders.JavaEnumConstantBuilder builder) {
        return new JavaEnumConstant(builder);
    }

    public static Source createSource(URI uri, Optional<String> sourceFileName, boolean md5InClassSourcesEnabled) {
        return new Source(uri, sourceFileName, md5InClassSourcesEnabled);
    }

    public static ReferencedClassObject createReferencedClassObject(JavaCodeUnit codeUnit, JavaClass javaClass, int lineNumber, boolean declaredInLambda) {
        return ReferencedClassObject.from(codeUnit, javaClass, lineNumber, declaredInLambda);
    }

    public static <CODE_UNIT extends JavaCodeUnit> ThrowsClause<CODE_UNIT> createThrowsClause(CODE_UNIT codeUnit, List<JavaClass> types) {
        return ThrowsClause.from(codeUnit, types);
    }

    public static InstanceofCheck createInstanceofCheck(JavaCodeUnit codeUnit, JavaClass type, int lineNumber, boolean declaredInLambda) {
        return InstanceofCheck.from(codeUnit, type, lineNumber, declaredInLambda);
    }

    public static <OWNER extends HasDescription> JavaTypeVariable<OWNER> createTypeVariable(String name, OWNER owner, JavaClass erasure) {
        return new JavaTypeVariable<OWNER>(name, owner, erasure);
    }

    public static void completeTypeVariable(JavaTypeVariable<?> variable, List<JavaType> upperBounds) {
        variable.setUpperBounds(upperBounds);
    }

    public static JavaGenericArrayType createGenericArrayType(JavaType componentType, JavaClass erasure) {
        Preconditions.checkArgument(componentType instanceof JavaTypeVariable || componentType instanceof JavaGenericArrayType || componentType instanceof JavaParameterizedType, "Component type of a generic array type can only be a type variable, a generic array type or a parameterized type, but was %s. This is most likely a bug.", (Object)componentType);
        return new JavaGenericArrayType(componentType.getName() + "[]", componentType, erasure);
    }

    public static JavaWildcardType createWildcardType(DomainBuilders.JavaWildcardTypeBuilder<?> builder) {
        return new JavaWildcardType(builder);
    }
}

