/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.lang.reflect.Method;
import java.util.LinkedList;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.Util;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;

class BundleThread
extends Thread {
    private static final int OP_IDLE = 0;
    private static final int OP_BUNDLE_EVENT = 1;
    private static final int OP_START = 2;
    private static final int OP_STOP = 3;
    private static final int KEEP_ALIVE = 1000;
    static final String ABORT_ACTION_STOP = "stop";
    static final String ABORT_ACTION_MINPRIO = "minprio";
    static final String ABORT_ACTION_IGNORE = "ignore";
    private final FrameworkContext fwCtx;
    private long startStopTimeout = 0L;
    private final Object lock = new Object();
    private volatile BundleEvent be;
    private volatile BundleImpl bundle;
    private volatile int operation = 0;
    private volatile Object res;
    private volatile boolean doRun;
    static final Method stopMethod = BundleThread.initStopSupported();

    private static Method initStopSupported() {
        try {
            return Thread.class.getMethod(ABORT_ACTION_STOP, null);
        }
        catch (Throwable _t) {
            return null;
        }
    }

    static void checkWarnStopActionNotSupported(FrameworkContext fc) {
        String s = fc.props.getProperty("org.knopflerfish.framework.bundlethread.abort");
        if (ABORT_ACTION_STOP.equals(s) && null == stopMethod) {
            System.err.println("WARNING: Bundle thread abort action stop was requested but is not supported on this execution environment; using 'minprio' as abort action.");
        }
    }

    BundleThread(FrameworkContext fc) {
        super(fc.threadGroup, "BundleThread waiting");
        this.setDaemon(true);
        this.fwCtx = fc;
        this.doRun = true;
        String timeout = this.fwCtx.props.getProperty("org.knopflerfish.framework.bundlethread.timeout");
        if (timeout != null) {
            try {
                this.startStopTimeout = 1000 * Integer.parseInt(timeout);
            }
            catch (NumberFormatException nfe) {
                this.fwCtx.debug.println("Property org.knopflerfish.framework.bundlethread.timeout has a non integer value, ignoring");
            }
        }
        this.start();
    }

    void quit() {
        this.doRun = false;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.doRun) {
            Object object = this.lock;
            synchronized (object) {
                while (this.doRun && this.operation == 0) {
                    try {
                        this.lock.wait(1000L);
                        if (this.operation == 0) {
                            LinkedList<BundleThread> linkedList = this.fwCtx.bundleThreads;
                            synchronized (linkedList) {
                                if (this.fwCtx.bundleThreads.remove(this)) {
                                    return;
                                }
                                continue;
                            }
                        }
                        break;
                    }
                    catch (InterruptedException ie) {
                    }
                }
                if (!this.doRun) {
                    break;
                }
                Exception tmpres = null;
                try {
                    switch (this.operation) {
                        case 1: {
                            this.setName("BundleChanged #" + this.be.getBundle().getBundleId());
                            this.fwCtx.listeners.bundleChanged(this.be);
                            break;
                        }
                        case 2: {
                            this.setName("BundleStart #" + this.bundle.getBundleId());
                            tmpres = this.bundle.start0();
                            break;
                        }
                        case 3: {
                            this.setName("BundleStop #" + this.bundle.getBundleId());
                            tmpres = this.bundle.stop1();
                        }
                    }
                }
                catch (Throwable t) {
                    this.fwCtx.frameworkError(this.bundle, t, new FrameworkListener[0]);
                }
                this.operation = 0;
                this.res = tmpres;
            }
            object = this.fwCtx.resolver;
            synchronized (object) {
                this.fwCtx.resolver.notifyAll();
            }
        }
    }

    void bundleChanged(BundleEvent be) {
        this.be = be;
        this.startAndWait((BundleImpl)be.getBundle(), 1);
    }

    BundleException callStart0(BundleImpl b) {
        return (BundleException)this.startAndWait(b, 2);
    }

    BundleException callStop1(BundleImpl b) {
        return (BundleException)this.startAndWait(b, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object startAndWait(BundleImpl b, int op) {
        Object object = this.lock;
        synchronized (object) {
            this.res = Boolean.FALSE;
            this.bundle = b;
            this.operation = op;
            this.lock.notifyAll();
        }
        long left = 0L;
        if (op == 2 || op == 3) {
            b.aborted = null;
            left = this.startStopTimeout;
        }
        boolean timeout = false;
        boolean uninstall = false;
        long waitUntil = Util.timeMillis() + left;
        do {
            try {
                this.fwCtx.resolver.wait(left);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if ((op == 2 || op == 3) && b.getState() == 1) {
                uninstall = true;
                this.res = null;
                continue;
            }
            if (left <= 0L || (left = waitUntil - Util.timeMillis()) > 0L || (op != 2 || b.getState() != 8) && (op != 3 || b.getState() != 16)) continue;
            timeout = true;
            this.res = null;
        } while (this.res == Boolean.FALSE);
        if (b.aborted == null && (timeout || uninstall)) {
            b.aborted = Boolean.TRUE;
            String opType = op == 2 ? "start" : ABORT_ACTION_STOP;
            String reason = timeout ? "Time-out during bundle " + opType + "()" : "Bundle uninstalled during " + opType + "()";
            String s = this.fwCtx.props.getProperty("org.knopflerfish.framework.bundlethread.abort");
            if (s == null) {
                s = ABORT_ACTION_IGNORE;
            }
            this.fwCtx.debug.println("bundle thread aborted during " + opType + " of bundle #" + b.getBundleId() + ", abort action set to '" + s + "'");
            if (timeout) {
                if (op == 2) {
                    b.startFailed();
                } else {
                    b.bactivator = null;
                    b.stop2();
                }
            }
            this.quit();
            if (ABORT_ACTION_STOP.equalsIgnoreCase(s)) {
                if (null != stopMethod) {
                    try {
                        stopMethod.invoke((Object)this, (Object[])null);
                    }
                    catch (Throwable t) {
                        this.fwCtx.debug.println("bundle thread abort action stop failed: " + t.getMessage());
                        this.setPriority(1);
                    }
                } else {
                    this.setPriority(1);
                }
            } else if (ABORT_ACTION_MINPRIO.equalsIgnoreCase(s)) {
                this.setPriority(1);
            }
            this.res = new BundleException("Bundle#" + b.id + " " + opType + " failed", 7, new Exception(reason));
            b.resetBundleThread();
            return this.res;
        }
        LinkedList<BundleThread> linkedList = this.fwCtx.bundleThreads;
        synchronized (linkedList) {
            this.fwCtx.bundleThreads.addFirst(this);
            if (op != this.operation) {
                // empty if block
            }
            b.resetBundleThread();
            return this.res;
        }
    }

    boolean isExecutingBundleChanged() {
        return this.operation == 1;
    }
}

