<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" exclude-result-prefixes="msxsl" xmlns:exsl="http://exslt.org/common" exsl:keep_exsl_namespace=""
  xmlns:str="http://exslt.org/strings"
  xmlns:int="http://www.w3.org/2001/XMLSchema#int"
  xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean"
  syntax="norules">
  <xsl:output indent="yes" method="xml"/>
  <xsl:param name="runtool"/>
  <xsl:param name="isVTSSFlow">false</xsl:param>
  <xsl:template match="/">
    <common>
      <knobs>
        <xsl:variable name="pmuConditionsExtended" select="document('config://include/pmu_variables_extended.xsl')"/>
        <xsl:variable name="isExtendedIsaSupport" select="$pmuConditionsExtended//variables/isExtendedIsaSupport"/>
        <groupKnob id="groupForTraceEventConfig" boolean:visible="false">
            <xsl:if test="exsl:ctx('connectionType','') = 'adb' or exsl:ctx('OS') = 'Linux'">
               <xsl:attribute name="boolean:visible">true</xsl:attribute>
            </xsl:if>
            <knobs>
              <stringKnob id="atraceEventConfig" displayName="%AtraceEventConfig" cliName="atrace-config" boolean:visible="false">
                <xsl:if test="exsl:ctx('connectionType','') = 'adb'">
                   <xsl:attribute name="boolean:visible">true</xsl:attribute>
                </xsl:if>
                <knobProperty name="queryEventsOption">--atrace-config-list</knobProperty>
                <knobProperty name="knob_control_id">SWEventConfig</knobProperty>
                <description>
                  <xsl:choose>
                    <xsl:when test="$runtool = 'runss'">%AtraceEventConfigDescriptionSS</xsl:when>
                    <xsl:otherwise>%AtraceEventConfigDescriptionSA</xsl:otherwise>
                  </xsl:choose>
                </description>
                <value></value>
                <defaultValue></defaultValue>
              </stringKnob>
              <stringKnob id="ftraceEventConfig" displayName="%FtraceEventConfig" cliName="ftrace-config" boolean:visible="false">
                <xsl:if test="exsl:ctx('connectionType','') = 'adb' or exsl:ctx('targetOS') = 'Linux'">
                   <xsl:attribute name="boolean:visible">true</xsl:attribute>
                </xsl:if>
                <xsl:if test="$isExtendedIsaSupport='true'">
		  <xsl:attribute name="boolean:visible">false</xsl:attribute>
		</xsl:if>
                <knobProperty name="queryEventsOption">--ftrace-config-list</knobProperty>
                <knobProperty name="knob_control_id">SWEventConfig</knobProperty>
                <description>
                  <xsl:choose>
                    <xsl:when test="$runtool = 'runss'">%FtraceEventConfigDescriptionSS</xsl:when>
                    <xsl:otherwise>%FtraceEventConfigDescriptionSA</xsl:otherwise>
                  </xsl:choose>
                </description>
                <value></value>
                <defaultValue></defaultValue>
              </stringKnob>
              <booleanKnob id="enableCStateCollection" displayName="%EnableCStateCollection" boolean:visible="false" cliName="enable-cstate-collection">
                <xsl:if test="exsl:ctx('targetOS', '') = 'Linux' or exsl:ctx('targetOS', '') = 'Android'">
                  <xsl:attribute name="boolean:visible">true</xsl:attribute>
                </xsl:if>
                <xsl:if test="$isExtendedIsaSupport='true'">
		  <xsl:attribute name="boolean:visible">false</xsl:attribute>
		</xsl:if>
                <description>%EnableCStateCollectionDescription</description>
                <boolean:defaultValue>false</boolean:defaultValue>
              </booleanKnob>
              <booleanKnob id="enableInterruptsCollection" displayName="%EnableInterruptsCollection" boolean:visible="false" cliName="enable-interrupt-collection">
                <xsl:if test="exsl:ctx('targetOS', '') = 'Linux' or exsl:ctx('targetOS', '') = 'Android'">
                  <xsl:attribute name="boolean:visible">true</xsl:attribute>
                </xsl:if>
                <xsl:if test="$isExtendedIsaSupport='true'">
		  <xsl:attribute name="boolean:visible">false</xsl:attribute>
		</xsl:if>
                <boolean:defaultValue>false</boolean:defaultValue>
                <description>%EnableInterruptsCollectionDescription</description>
              </booleanKnob>
          </knobs>
        </groupKnob>
      </knobs>
      <collector>
        <xsl:if test="(exsl:ctx('ftraceEventConfig','') or exsl:ctx('enableCStateCollection', 0) or exsl:ctx('enableInterruptsCollection', 0) ) and
           (exsl:ctx('targetOS','')='Android' or (exsl:ctx('targetOS','') = 'Linux' and not(contains(exsl:ctx('connectionType',''), 'mic'))))">
          <xsl:variable name="isFtraceOk">
            <xsl:for-each select="str:tokenize(exsl:ctx('isFtraceAvailableKnob',''), ',')">
              <xsl:variable name="fraceStatus">
                <xsl:choose>
                  <xsl:when test=".='debugfsNotExists'">%DebugFSExistenceError</xsl:when>
                  <xsl:when test=".='debugfsNotAccessible'">%DebugFSAccessError</xsl:when>
                  <xsl:when test=".='debugfsOffInConfigs'">%DebugFSConfigError</xsl:when>
                  <xsl:when test=".='debugfsIsNotValidFsType'">%DebugFSInvalidTypeError</xsl:when>
                  <xsl:when test=".='ftraceAccessError'">
                    <xsl:choose>
                      <xsl:when test="not(contains(exsl:ctx('isFtraceAvailableKnob',''), 'debugfs'))">%FtraceAccessError</xsl:when>
                      <xsl:otherwise>notErrorOrWarning</xsl:otherwise>
                    </xsl:choose>
                  </xsl:when>
                  <xsl:when test=".='ftraceConfigError'">%FtraceConfigError</xsl:when>
                  <xsl:when test=".='ftraceUnknownError'">%FtraceUnknownError</xsl:when>
                  <xsl:when test=".='yes'">yes</xsl:when>
                  <xsl:otherwise>yes</xsl:otherwise>
                </xsl:choose>
              </xsl:variable>
              <xsl:choose>
                <xsl:when test="$fraceStatus = 'notErrorOrWarning'"></xsl:when>
                <xsl:when test="( $fraceStatus != 'yes' )">
                  <xsl:choose>
                    <xsl:when test="exsl:ctx('errorsAsWarnings',0)">
                      <xsl:value-of select="exsl:warning($fraceStatus)"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="exsl:error($fraceStatus)"/>
                    </xsl:otherwise>
                  </xsl:choose>
                </xsl:when>
                <xsl:otherwise>yes</xsl:otherwise>
              </xsl:choose>
            </xsl:for-each>
          </xsl:variable>
          <xsl:if test="$isFtraceOk != ''">
            <xsl:if test="exsl:ctx('ftraceEventConfig', '')">
              <collectorOption option="ftrace-config">
                <xsl:value-of select="exsl:ctx('ftraceEventConfig')"/>
              </collectorOption>
            </xsl:if>
            <xsl:if test="exsl:ctx('enableCStateCollection', 0)">
              <collectorOption option="ftrace-config">idle</collectorOption>
            </xsl:if>
            <xsl:if test="exsl:ctx('enableInterruptsCollection', 0)">
              <collectorOption option="ftrace-config">sched,irq,softirq</collectorOption>
            </xsl:if>
            <xsl:if test="$runtool = 'runsa'">
              <xsl:if test="exsl:ctx('collectIoWaits','') and exsl:ctx('isIowaitTracingAvailable','')='yes'">
                <collectorOption option="ftrace-function-groups">iowait</collectorOption>
              </xsl:if>
            </xsl:if>
          </xsl:if>
        </xsl:if>
        <xsl:if test="exsl:ctx('targetOS','')='Android' and exsl:ctx('atraceEventConfig','')">
          <xsl:choose>
            <xsl:when test="exsl:ctx('androidVersionMajor','') &lt; '4' or (exsl:ctx('androidVersionMajor','') = '4' and exsl:ctx('androidVersionMinor','') &lt; '3')">
              <xsl:choose>
                <xsl:when test="exsl:ctx('errorsAsWarnings',0)">
                  <xsl:value-of select="exsl:warning('%AndroidFrameworkEventsIsNotSupported')"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="exsl:error('%AndroidFrameworkEventsIsNotSupported')"/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:when test="($isVTSSFlow != 'false') and exsl:ctx('isVTSSPPDriverAvailable', 0)">
              <xsl:value-of select="exsl:error('%AndroidFrameworkEventsWithVTSS')"/>
            </xsl:when>
            <xsl:otherwise>
              <collectorOption option="atrace-config">
                <xsl:value-of select='exsl:ctx("atraceEventConfig")'/>
              </collectorOption>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
      </collector>
    </common>
  </xsl:template>
</xsl:stylesheet>
