<?xml version="1.0" encoding="utf-8"?>
<!--

 Copyright © 2009 Intel Corporation. All rights reserved.

 The information contained herein is the exclusive property of
 Intel Corporation and may not be disclosed, examined, or reproduced in
 whole or in part without explicit written authorization from the Company.

-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:exsl="http://exslt.org/common"
                exsl:keep_exsl_namespace=""
                xmlns:str="http://exslt.org/strings"
                xmlns:fnc="urn:functions"
                syntax="norules">
  <xsl:import href="config://include/gpu_common_functions.inc"/>
  <xsl:output indent="yes" method="xml"/>
  <xsl:template match="/">
    <variables>
      <isGpuHwStallReasonCollectionAvailable>
        <xsl:if test="fnc:is_gpu_hw_stall_reason_collection_available()">
          <xsl:text>true</xsl:text>
        </xsl:if>
      </isGpuHwStallReasonCollectionAvailable>
      <isGTPinLatencyCollectionAvailable>
        <xsl:if test="not(fnc:has_gpu_on_board('fnc:is_ptl'))">
          <xsl:text>true</xsl:text>
        </xsl:if>
      </isGTPinLatencyCollectionAvailable>
      <gpuTargets>
        <xsl:for-each select="str:split(exsl:ctx('targetGPUAtk', exsl:ctx('preferedGpuAdapter', 'none')), ',')">
          <xsl:variable name="splitByDot" select="str:split(., '.')"/>
          <xsl:variable name="tailSplitByColon" select="str:split($splitByDot[2], ':')"/>
          <gpuTarget>
            <gpuAdapterToUse>
              <xsl:value-of select="concat($splitByDot[1],'.',$tailSplitByColon[1])"/>
            </gpuAdapterToUse>
            <gpuTileToAdd>
              <xsl:if test="count($tailSplitByColon)=2">
                <xsl:value-of select="concat(':stack=',$tailSplitByColon[2])"/>
              </xsl:if>
            </gpuTileToAdd>
          </gpuTarget>
        </xsl:for-each>
      </gpuTargets>
    </variables>
  </xsl:template>
</xsl:stylesheet>
