<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="msxsl"
                xmlns:exsl="http://exslt.org/common"
                exsl:keep_exsl_namespace=""
                syntax="norules"
                xmlns:boolean="http://www.w3.org/2001/XMLSchema#boolean"
                xmlns:int="http://www.w3.org/2001/XMLSchema#int"
                xmlns:double="http://www.w3.org/2001/XMLSchema#double"
                xmlns:str="http://exslt.org/strings">
  <xsl:output indent="yes" method="xml"/>
  <xsl:template match="/">
    <device_cache_config>
      <xsl:choose>
        <xsl:when test="exsl:ctx('target_device') = 'gen9_gt2' or exsl:ctx('config') = 'gen9_gt2'">3:64w:4k/1:128w:512k/1:16w:8m</xsl:when>
        <xsl:when test="exsl:ctx('target_device') = 'gen9_gt3e' or exsl:ctx('config') = 'gen9_gt3e'">6:64w:4k/1:256w:1m/1:16w:8m/1:512w:64m</xsl:when>
        <xsl:when test="exsl:ctx('target_device') = 'gen9_gt4e' or exsl:ctx('config') = 'gen9_gt4e'">9:64w:4k/1:384w:1536k/1:16w:8m/1:512w:128m</xsl:when>
        <xsl:when test="exsl:ctx('target_device') = 'gen11_icl' or exsl:ctx('config') = 'gen11_icl'">8:64w:4k/1:384w:3m/1:16w:8m</xsl:when>
        <xsl:when test="exsl:ctx('target_device') = 'gen12_dg1' or exsl:ctx('config') = 'gen12_dg1'">6:64w:4k/1:512w:16m</xsl:when>
        <xsl:when test="exsl:ctx('target_device') = 'gen12_tgl' or exsl:ctx('config') = 'gen12_tgl'">6:64w:4k/1:480w:3840k/1:16w:12m</xsl:when>
        <xsl:when test="exsl:ctx('target_device') = 'xehp_sdv_480eu' or exsl:ctx('config') = 'xehp_sdv_480eu'">30:64w:4k/1:320w:10m</xsl:when>
        <xsl:when test="exsl:ctx('target_device') = 'xehpg_256xve' or exsl:ctx('config') = 'xehpg_256xve'">16:64w:4k/16:48w:192k/1:512w:8m</xsl:when>
        <xsl:when test="exsl:ctx('target_device') = 'xehpg_384xve' or exsl:ctx('config') = 'xehpg_384xve'">24:64w:4k/24:48w:192k/1:512w:16m</xsl:when>
        <xsl:when test="exsl:ctx('target_device') = 'xehpg_448xve' or exsl:ctx('config') = 'xehpg_448xve'">28:64w:4k/28:48w:192k/1:512w:16m</xsl:when>
        <xsl:when test="exsl:ctx('target_device') = 'xehpg_512xve' or exsl:ctx('config') = 'xehpg_512xve'">32:64w:4k/32:48w:192k/1:512w:16m</xsl:when>
        <xsl:when test="exsl:ctx('target_device') = 'pvc_xt_448xve' or exsl:ctx('config') = 'pvc_xt_448xve'">56:64w:4k/56:128w:512k/1:408w:204m</xsl:when>
        <xsl:when test="exsl:ctx('target_device') = 'pvc_xt_512xve' or exsl:ctx('config') = 'pvc_xt_512xve'">64:64w:4k/64:128w:512k/1:408w:204m</xsl:when>
        <!-- 'atsp' is an alias to 'xehp_sdv_480eu' -->
        <xsl:when test="exsl:ctx('target_device') = 'atsp' or exsl:ctx('config') = 'atsp'">30:64w:4k/1:320w:10m</xsl:when>
        <!-- 'pvc_xt' is an alias to 'pvc_xt_448xve' -->
        <xsl:when test="exsl:ctx('target_device') = 'pvc_xt' or exsl:ctx('config') = 'pvc_xt'">56:64w:4k/56:128w:512k/1:408w:204m</xsl:when>
        <!-- 'dg1' is an alias to 'gen12_dg1' -->
        <xsl:when test="exsl:ctx('target_device') = 'dg1' or exsl:ctx('config') = 'dg1'">6:64w:4k/1:512w:16m</xsl:when>
        <!-- 'dg2' and 'gen12_dg2' are an aliases to 'xehpg_448xve' -->
        <xsl:when test="exsl:ctx('target_device') = 'dg2' or exsl:ctx('config') = 'dg2'">28:64w:4k/28:48w:192k/1:512w:16m</xsl:when>
        <xsl:when test="exsl:ctx('target_device') = 'gen12_dg2' or exsl:ctx('config') = 'gen12_dg2'">28:64w:4k/28:48w:192k/1:512w:16m</xsl:when>
        <xsl:otherwise><xsl:text/></xsl:otherwise>
      </xsl:choose>
    </device_cache_config>
  </xsl:template>
</xsl:stylesheet>
