/*
 * Decompiled with CFR 0.152.
 */
import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class JavaAttach {
    private static FileWriter logWriter = null;
    private static String logFileName = "mrtehelpers";
    private static String dash = "-";
    private static String logExtension = ".log";
    private static String logDir = null;
    private static String logPid = null;

    public static void CreateLogFile() {
        try {
            String string = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Date());
            String string2 = logDir + File.separator + logFileName + dash + logPid + dash + string + logExtension;
            File file = new File(string2);
            logWriter = new FileWriter(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void WriteLogFile(String string) {
        try {
            if (logWriter != null) {
                logWriter.write(string + "\n");
                logWriter.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void InitLoging(String[] stringArray) {
        logDir = System.getenv("MRTEHELPERS_JAVA_ATTACH_LOG_PATH");
        if (logDir == null || logDir.isEmpty()) {
            if (stringArray.length < 2) {
                logDir = System.getProperty("java.io.tmpdir");
                logPid = "0";
            } else {
                logDir = stringArray[2];
                logPid = stringArray[0];
            }
        }
        JavaAttach.CreateLogFile();
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 1;
        JavaAttach.InitLoging(stringArray);
        JavaAttach.WriteLogFile("Attach is started ...");
        try {
            String string = System.getProperty("java.vm.vendor");
            if (string.contains("IBM")) {
                JavaAttach.WriteLogFile(string + " is not supported. Exit with JDK_NOT_SUPPORTED");
                System.exit(3);
            }
            AttachHotspotImpl attachHotspotImpl = new AttachHotspotImpl();
            n = attachHotspotImpl.run(stringArray);
        }
        catch (Throwable throwable) {
            JavaAttach.WriteLogFile("Exception: " + throwable + ". Exit with FALSE");
            System.exit(1);
        }
        JavaAttach.WriteLogFile("Attach is completed successfully");
        System.exit(n);
    }

    static class AttachHotspotImpl {
        AttachHotspotImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int run(String[] stringArray) throws IOException {
            VirtualMachine virtualMachine = null;
            String string = null;
            if (stringArray.length < 2) {
                JavaAttach.WriteLogFile("Wrong number arguments: " + stringArray.length + ". Exit with FALSE");
                return 1;
            }
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            JavaAttach.WriteLogFile("Target pid: " + string2);
            JavaAttach.WriteLogFile("Agent path: " + string3);
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                JavaAttach.WriteLogFile("NumberFormatException: " + numberFormatException + ". Exit with FALSE");
                return 1;
            }
            try {
                JavaAttach.WriteLogFile("Invoking VirtualMachine.attach(" + string2 + ") ...");
                virtualMachine = VirtualMachine.attach(string2);
                JavaAttach.WriteLogFile("VirtualMachine.attach exit");
                if (virtualMachine == null) {
                    JavaAttach.WriteLogFile("VirtualMachine.attach() failed. Exit with VM_NULL");
                    return 9;
                }
            }
            catch (SecurityException securityException) {
                JavaAttach.WriteLogFile("SecurityException: " + securityException + ". Exit with VM_NO_PERMISSION");
                return 7;
            }
            catch (AttachNotSupportedException attachNotSupportedException) {
                JavaAttach.WriteLogFile("AttachNotSupportedException: " + attachNotSupportedException + ". Exit with VM_JDK_NOT_ATTACHABLE");
                return 6;
            }
            catch (IOException iOException) {
                JavaAttach.WriteLogFile("IOException: " + iOException + ". Exit with VM_IO");
                return 8;
            }
            catch (NullPointerException nullPointerException) {
                JavaAttach.WriteLogFile("NullPointerException: " + nullPointerException + ". Exit with VM_NULL");
                return 9;
            }
            catch (Exception exception) {
                JavaAttach.WriteLogFile("java.lang.Exception: " + exception + ".");
            }
            JavaAttach.WriteLogFile("VirtualMachine.attach() completed successfully");
            JavaAttach.WriteLogFile("args: " + Arrays.toString(stringArray));
            JavaAttach.WriteLogFile("args.length: " + stringArray.length);
            if (stringArray.length > 2) {
                string = stringArray[2];
                for (int i = 3; i < stringArray.length; ++i) {
                    string = string + "," + stringArray[i];
                }
            }
            try {
                JavaAttach.WriteLogFile("Invoking VirtualMachine.loadAgentPath() ...");
                JavaAttach.WriteLogFile("    path: " + string3);
                JavaAttach.WriteLogFile("    options: " + string);
                virtualMachine.loadAgentPath(string3, string);
                JavaAttach.WriteLogFile("loadAgentPath exit");
            }
            catch (AgentLoadException agentLoadException) {
                JavaAttach.WriteLogFile("AgentLoadException: " + agentLoadException + ". Exit with ER_AGENT_INIT");
                int n = 5;
                return n;
            }
            catch (AgentInitializationException agentInitializationException) {
                JavaAttach.WriteLogFile("Agen_OnAttach returns " + agentInitializationException.returnValue());
                JavaAttach.WriteLogFile("AgentInitializationException: " + agentInitializationException + ". Exit with ER_AGENT_INIT");
                int n = 5;
                return n;
            }
            catch (IOException iOException) {
                JavaAttach.WriteLogFile("IOException: " + iOException + ". Exit with ER_AGENT_INIT");
                int n = 5;
                return n;
            }
            catch (NullPointerException nullPointerException) {
                JavaAttach.WriteLogFile("NullPointerException: " + nullPointerException + ". Exit with ER_AGENT_INIT");
                int n = 5;
                return n;
            }
            catch (Exception exception) {
                JavaAttach.WriteLogFile("java.lang.Exception: " + exception + ".");
            }
            finally {
                JavaAttach.WriteLogFile("VirtualMachine.loadAgentPath() completed successfully");
                try {
                    JavaAttach.WriteLogFile("Invoking VirtualMachine.detach() ...");
                    virtualMachine.detach();
                    JavaAttach.WriteLogFile("VirtualMachine.detach() completed successfully");
                }
                catch (IOException iOException) {
                    JavaAttach.WriteLogFile("IOException: " + iOException + ". Exit with ER_AGENT_INIT");
                    return 5;
                }
                catch (Exception exception) {
                    JavaAttach.WriteLogFile("java.lang.Exception: " + exception + ".");
                }
            }
            return 0;
        }
    }
}

