# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "vm availability-set list",
)
class List(AAZCommand):
    """List all availability sets in a subscription.
    """

    _aaz_info = {
        "version": "2025-04-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/providers/microsoft.compute/availabilitysets", "2025-04-01"],
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.compute/availabilitysets", "2025-04-01"],
        ]
    }

    AZ_SUPPORT_PAGINATION = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_paging(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.resource_group = AAZResourceGroupNameArg()
        _args_schema.expand = AAZStrArg(
            options=["--expand"],
            help="The expand expression to apply to the operation. Allowed values are 'virtualMachines/$ref'.",
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        condition_0 = has_value(self.ctx.subscription_id) and has_value(self.ctx.args.resource_group) is not True
        condition_1 = has_value(self.ctx.args.resource_group) and has_value(self.ctx.subscription_id)
        if condition_0:
            self.AvailabilitySetsListBySubscription(ctx=self.ctx)()
        if condition_1:
            self.AvailabilitySetsList(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance.value, client_flatten=True)
        next_link = self.deserialize_output(self.ctx.vars.instance.next_link)
        return result, next_link

    class AvailabilitySetsListBySubscription(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/providers/Microsoft.Compute/availabilitySets",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "$expand", self.ctx.args.expand,
                ),
                **self.serialize_query_param(
                    "api-version", "2025-04-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.next_link = AAZStrType(
                serialized_name="nextLink",
            )
            _schema_on_200.value = AAZListType(
                flags={"required": True},
            )

            value = cls._schema_on_200.value
            value.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element
            _element.id = AAZStrType(
                flags={"read_only": True},
            )
            _element.location = AAZStrType(
                flags={"required": True},
            )
            _element.name = AAZStrType(
                flags={"read_only": True},
            )
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.sku = AAZObjectType()
            _element.system_data = AAZObjectType(
                serialized_name="systemData",
                flags={"read_only": True},
            )
            _element.tags = AAZDictType()
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.value.Element.properties
            properties.platform_fault_domain_count = AAZIntType(
                serialized_name="platformFaultDomainCount",
            )
            properties.platform_update_domain_count = AAZIntType(
                serialized_name="platformUpdateDomainCount",
            )
            properties.proximity_placement_group = AAZObjectType(
                serialized_name="proximityPlacementGroup",
            )
            _ListHelper._build_schema_sub_resource_read(properties.proximity_placement_group)
            properties.scheduled_events_policy = AAZObjectType(
                serialized_name="scheduledEventsPolicy",
            )
            properties.statuses = AAZListType(
                flags={"read_only": True},
            )
            properties.virtual_machine_scale_set_migration_info = AAZObjectType(
                serialized_name="virtualMachineScaleSetMigrationInfo",
                flags={"read_only": True},
            )
            properties.virtual_machines = AAZListType(
                serialized_name="virtualMachines",
            )

            scheduled_events_policy = cls._schema_on_200.value.Element.properties.scheduled_events_policy
            scheduled_events_policy.all_instances_down = AAZObjectType(
                serialized_name="allInstancesDown",
            )
            scheduled_events_policy.scheduled_events_additional_publishing_targets = AAZObjectType(
                serialized_name="scheduledEventsAdditionalPublishingTargets",
            )
            scheduled_events_policy.user_initiated_reboot = AAZObjectType(
                serialized_name="userInitiatedReboot",
            )
            scheduled_events_policy.user_initiated_redeploy = AAZObjectType(
                serialized_name="userInitiatedRedeploy",
            )

            all_instances_down = cls._schema_on_200.value.Element.properties.scheduled_events_policy.all_instances_down
            all_instances_down.automatically_approve = AAZBoolType(
                serialized_name="automaticallyApprove",
            )

            scheduled_events_additional_publishing_targets = cls._schema_on_200.value.Element.properties.scheduled_events_policy.scheduled_events_additional_publishing_targets
            scheduled_events_additional_publishing_targets.event_grid_and_resource_graph = AAZObjectType(
                serialized_name="eventGridAndResourceGraph",
            )

            event_grid_and_resource_graph = cls._schema_on_200.value.Element.properties.scheduled_events_policy.scheduled_events_additional_publishing_targets.event_grid_and_resource_graph
            event_grid_and_resource_graph.enable = AAZBoolType()
            event_grid_and_resource_graph.scheduled_events_api_version = AAZStrType(
                serialized_name="scheduledEventsApiVersion",
            )

            user_initiated_reboot = cls._schema_on_200.value.Element.properties.scheduled_events_policy.user_initiated_reboot
            user_initiated_reboot.automatically_approve = AAZBoolType(
                serialized_name="automaticallyApprove",
            )

            user_initiated_redeploy = cls._schema_on_200.value.Element.properties.scheduled_events_policy.user_initiated_redeploy
            user_initiated_redeploy.automatically_approve = AAZBoolType(
                serialized_name="automaticallyApprove",
            )

            statuses = cls._schema_on_200.value.Element.properties.statuses
            statuses.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.statuses.Element
            _element.code = AAZStrType()
            _element.display_status = AAZStrType(
                serialized_name="displayStatus",
            )
            _element.level = AAZStrType()
            _element.message = AAZStrType()
            _element.time = AAZStrType()

            virtual_machine_scale_set_migration_info = cls._schema_on_200.value.Element.properties.virtual_machine_scale_set_migration_info
            virtual_machine_scale_set_migration_info.default_virtual_machine_scale_set_info = AAZObjectType(
                serialized_name="defaultVirtualMachineScaleSetInfo",
                flags={"read_only": True},
            )
            virtual_machine_scale_set_migration_info.migrate_to_virtual_machine_scale_set = AAZObjectType(
                serialized_name="migrateToVirtualMachineScaleSet",
                flags={"read_only": True},
            )
            _ListHelper._build_schema_sub_resource_read(virtual_machine_scale_set_migration_info.migrate_to_virtual_machine_scale_set)

            default_virtual_machine_scale_set_info = cls._schema_on_200.value.Element.properties.virtual_machine_scale_set_migration_info.default_virtual_machine_scale_set_info
            default_virtual_machine_scale_set_info.constrained_maximum_capacity = AAZBoolType(
                serialized_name="constrainedMaximumCapacity",
                flags={"read_only": True},
            )
            default_virtual_machine_scale_set_info.default_virtual_machine_scale_set = AAZObjectType(
                serialized_name="defaultVirtualMachineScaleSet",
                flags={"read_only": True},
            )
            _ListHelper._build_schema_sub_resource_read(default_virtual_machine_scale_set_info.default_virtual_machine_scale_set)

            virtual_machines = cls._schema_on_200.value.Element.properties.virtual_machines
            virtual_machines.Element = AAZObjectType()
            _ListHelper._build_schema_sub_resource_read(virtual_machines.Element)

            sku = cls._schema_on_200.value.Element.sku
            sku.capacity = AAZIntType()
            sku.name = AAZStrType()
            sku.tier = AAZStrType()

            system_data = cls._schema_on_200.value.Element.system_data
            system_data.created_at = AAZStrType(
                serialized_name="createdAt",
            )
            system_data.created_by = AAZStrType(
                serialized_name="createdBy",
            )
            system_data.created_by_type = AAZStrType(
                serialized_name="createdByType",
            )
            system_data.last_modified_at = AAZStrType(
                serialized_name="lastModifiedAt",
            )
            system_data.last_modified_by = AAZStrType(
                serialized_name="lastModifiedBy",
            )
            system_data.last_modified_by_type = AAZStrType(
                serialized_name="lastModifiedByType",
            )

            tags = cls._schema_on_200.value.Element.tags
            tags.Element = AAZStrType()

            return cls._schema_on_200

    class AvailabilitySetsList(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2025-04-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.next_link = AAZStrType(
                serialized_name="nextLink",
            )
            _schema_on_200.value = AAZListType(
                flags={"required": True},
            )

            value = cls._schema_on_200.value
            value.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element
            _element.id = AAZStrType(
                flags={"read_only": True},
            )
            _element.location = AAZStrType(
                flags={"required": True},
            )
            _element.name = AAZStrType(
                flags={"read_only": True},
            )
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.sku = AAZObjectType()
            _element.system_data = AAZObjectType(
                serialized_name="systemData",
                flags={"read_only": True},
            )
            _element.tags = AAZDictType()
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200.value.Element.properties
            properties.platform_fault_domain_count = AAZIntType(
                serialized_name="platformFaultDomainCount",
            )
            properties.platform_update_domain_count = AAZIntType(
                serialized_name="platformUpdateDomainCount",
            )
            properties.proximity_placement_group = AAZObjectType(
                serialized_name="proximityPlacementGroup",
            )
            _ListHelper._build_schema_sub_resource_read(properties.proximity_placement_group)
            properties.scheduled_events_policy = AAZObjectType(
                serialized_name="scheduledEventsPolicy",
            )
            properties.statuses = AAZListType(
                flags={"read_only": True},
            )
            properties.virtual_machine_scale_set_migration_info = AAZObjectType(
                serialized_name="virtualMachineScaleSetMigrationInfo",
                flags={"read_only": True},
            )
            properties.virtual_machines = AAZListType(
                serialized_name="virtualMachines",
            )

            scheduled_events_policy = cls._schema_on_200.value.Element.properties.scheduled_events_policy
            scheduled_events_policy.all_instances_down = AAZObjectType(
                serialized_name="allInstancesDown",
            )
            scheduled_events_policy.scheduled_events_additional_publishing_targets = AAZObjectType(
                serialized_name="scheduledEventsAdditionalPublishingTargets",
            )
            scheduled_events_policy.user_initiated_reboot = AAZObjectType(
                serialized_name="userInitiatedReboot",
            )
            scheduled_events_policy.user_initiated_redeploy = AAZObjectType(
                serialized_name="userInitiatedRedeploy",
            )

            all_instances_down = cls._schema_on_200.value.Element.properties.scheduled_events_policy.all_instances_down
            all_instances_down.automatically_approve = AAZBoolType(
                serialized_name="automaticallyApprove",
            )

            scheduled_events_additional_publishing_targets = cls._schema_on_200.value.Element.properties.scheduled_events_policy.scheduled_events_additional_publishing_targets
            scheduled_events_additional_publishing_targets.event_grid_and_resource_graph = AAZObjectType(
                serialized_name="eventGridAndResourceGraph",
            )

            event_grid_and_resource_graph = cls._schema_on_200.value.Element.properties.scheduled_events_policy.scheduled_events_additional_publishing_targets.event_grid_and_resource_graph
            event_grid_and_resource_graph.enable = AAZBoolType()
            event_grid_and_resource_graph.scheduled_events_api_version = AAZStrType(
                serialized_name="scheduledEventsApiVersion",
            )

            user_initiated_reboot = cls._schema_on_200.value.Element.properties.scheduled_events_policy.user_initiated_reboot
            user_initiated_reboot.automatically_approve = AAZBoolType(
                serialized_name="automaticallyApprove",
            )

            user_initiated_redeploy = cls._schema_on_200.value.Element.properties.scheduled_events_policy.user_initiated_redeploy
            user_initiated_redeploy.automatically_approve = AAZBoolType(
                serialized_name="automaticallyApprove",
            )

            statuses = cls._schema_on_200.value.Element.properties.statuses
            statuses.Element = AAZObjectType()

            _element = cls._schema_on_200.value.Element.properties.statuses.Element
            _element.code = AAZStrType()
            _element.display_status = AAZStrType(
                serialized_name="displayStatus",
            )
            _element.level = AAZStrType()
            _element.message = AAZStrType()
            _element.time = AAZStrType()

            virtual_machine_scale_set_migration_info = cls._schema_on_200.value.Element.properties.virtual_machine_scale_set_migration_info
            virtual_machine_scale_set_migration_info.default_virtual_machine_scale_set_info = AAZObjectType(
                serialized_name="defaultVirtualMachineScaleSetInfo",
                flags={"read_only": True},
            )
            virtual_machine_scale_set_migration_info.migrate_to_virtual_machine_scale_set = AAZObjectType(
                serialized_name="migrateToVirtualMachineScaleSet",
                flags={"read_only": True},
            )
            _ListHelper._build_schema_sub_resource_read(virtual_machine_scale_set_migration_info.migrate_to_virtual_machine_scale_set)

            default_virtual_machine_scale_set_info = cls._schema_on_200.value.Element.properties.virtual_machine_scale_set_migration_info.default_virtual_machine_scale_set_info
            default_virtual_machine_scale_set_info.constrained_maximum_capacity = AAZBoolType(
                serialized_name="constrainedMaximumCapacity",
                flags={"read_only": True},
            )
            default_virtual_machine_scale_set_info.default_virtual_machine_scale_set = AAZObjectType(
                serialized_name="defaultVirtualMachineScaleSet",
                flags={"read_only": True},
            )
            _ListHelper._build_schema_sub_resource_read(default_virtual_machine_scale_set_info.default_virtual_machine_scale_set)

            virtual_machines = cls._schema_on_200.value.Element.properties.virtual_machines
            virtual_machines.Element = AAZObjectType()
            _ListHelper._build_schema_sub_resource_read(virtual_machines.Element)

            sku = cls._schema_on_200.value.Element.sku
            sku.capacity = AAZIntType()
            sku.name = AAZStrType()
            sku.tier = AAZStrType()

            system_data = cls._schema_on_200.value.Element.system_data
            system_data.created_at = AAZStrType(
                serialized_name="createdAt",
            )
            system_data.created_by = AAZStrType(
                serialized_name="createdBy",
            )
            system_data.created_by_type = AAZStrType(
                serialized_name="createdByType",
            )
            system_data.last_modified_at = AAZStrType(
                serialized_name="lastModifiedAt",
            )
            system_data.last_modified_by = AAZStrType(
                serialized_name="lastModifiedBy",
            )
            system_data.last_modified_by_type = AAZStrType(
                serialized_name="lastModifiedByType",
            )

            tags = cls._schema_on_200.value.Element.tags
            tags.Element = AAZStrType()

            return cls._schema_on_200


class _ListHelper:
    """Helper class for List"""

    _schema_sub_resource_read = None

    @classmethod
    def _build_schema_sub_resource_read(cls, _schema):
        if cls._schema_sub_resource_read is not None:
            _schema.id = cls._schema_sub_resource_read.id
            return

        cls._schema_sub_resource_read = _schema_sub_resource_read = AAZObjectType()

        sub_resource_read = _schema_sub_resource_read
        sub_resource_read.id = AAZStrType()

        _schema.id = cls._schema_sub_resource_read.id


__all__ = ["List"]
