//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/clusters/reverse_connection/v3/reverse_connection.proto

package reverse_connectionv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on ReverseConnectionClusterConfig with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ReverseConnectionClusterConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ReverseConnectionClusterConfig with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// ReverseConnectionClusterConfigMultiError, or nil if none found.
func (m *ReverseConnectionClusterConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *ReverseConnectionClusterConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if d := m.GetCleanupInterval(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = ReverseConnectionClusterConfigValidationError{
				field:  "CleanupInterval",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := ReverseConnectionClusterConfigValidationError{
					field:  "CleanupInterval",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if utf8.RuneCountInString(m.GetHostIdFormat()) < 1 {
		err := ReverseConnectionClusterConfigValidationError{
			field:  "HostIdFormat",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ReverseConnectionClusterConfigMultiError(errors)
	}

	return nil
}

// ReverseConnectionClusterConfigMultiError is an error wrapping multiple
// validation errors returned by ReverseConnectionClusterConfig.ValidateAll()
// if the designated constraints aren't met.
type ReverseConnectionClusterConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ReverseConnectionClusterConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ReverseConnectionClusterConfigMultiError) AllErrors() []error { return m }

// ReverseConnectionClusterConfigValidationError is the validation error
// returned by ReverseConnectionClusterConfig.Validate if the designated
// constraints aren't met.
type ReverseConnectionClusterConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ReverseConnectionClusterConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ReverseConnectionClusterConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ReverseConnectionClusterConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ReverseConnectionClusterConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ReverseConnectionClusterConfigValidationError) ErrorName() string {
	return "ReverseConnectionClusterConfigValidationError"
}

// Error satisfies the builtin error interface
func (e ReverseConnectionClusterConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sReverseConnectionClusterConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ReverseConnectionClusterConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ReverseConnectionClusterConfigValidationError{}
