
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_samr.h"
#include "bin/default/librpc/gen_ndr/ndr_samr_c.h"

/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/lsa.h"
#include "librpc/gen_ndr/security.h"
static PyTypeObject samr_SamEntry_Type;
static PyTypeObject samr_SamArray_Type;
static PyTypeObject samr_DomInfo1_Type;
static PyTypeObject samr_DomGeneralInformation_Type;
static PyTypeObject samr_DomInfo3_Type;
static PyTypeObject samr_DomOEMInformation_Type;
static PyTypeObject samr_DomInfo5_Type;
static PyTypeObject samr_DomInfo6_Type;
static PyTypeObject samr_DomInfo7_Type;
static PyTypeObject samr_DomInfo8_Type;
static PyTypeObject samr_DomInfo9_Type;
static PyTypeObject samr_DomGeneralInformation2_Type;
static PyTypeObject samr_DomInfo12_Type;
static PyTypeObject samr_DomInfo13_Type;
static PyTypeObject samr_DomainInfo_Type;
static PyTypeObject samr_Ids_Type;
static PyTypeObject samr_GroupInfoAll_Type;
static PyTypeObject samr_GroupInfoAttributes_Type;
static PyTypeObject samr_GroupInfoDescription_Type;
static PyTypeObject samr_GroupInfo_Type;
static PyTypeObject samr_RidAttrArray_Type;
static PyTypeObject samr_AliasInfoAll_Type;
static PyTypeObject samr_AliasInfo_Type;
static PyTypeObject samr_UserInfo1_Type;
static PyTypeObject samr_UserInfo2_Type;
static PyTypeObject samr_LogonHours_Type;
static PyTypeObject samr_UserInfo3_Type;
static PyTypeObject samr_UserInfo4_Type;
static PyTypeObject samr_UserInfo5_Type;
static PyTypeObject samr_UserInfo6_Type;
static PyTypeObject samr_UserInfo7_Type;
static PyTypeObject samr_UserInfo8_Type;
static PyTypeObject samr_UserInfo9_Type;
static PyTypeObject samr_UserInfo10_Type;
static PyTypeObject samr_UserInfo11_Type;
static PyTypeObject samr_UserInfo12_Type;
static PyTypeObject samr_UserInfo13_Type;
static PyTypeObject samr_UserInfo14_Type;
static PyTypeObject samr_UserInfo16_Type;
static PyTypeObject samr_UserInfo17_Type;
static PyTypeObject samr_Password_Type;
static PyTypeObject samr_UserInfo18_Type;
static PyTypeObject samr_UserInfo20_Type;
static PyTypeObject samr_UserInfo21_Type;
static PyTypeObject samr_CryptPassword_Type;
static PyTypeObject samr_UserInfo23_Type;
static PyTypeObject samr_UserInfo24_Type;
static PyTypeObject samr_CryptPasswordEx_Type;
static PyTypeObject samr_UserInfo25_Type;
static PyTypeObject samr_UserInfo26_Type;
static PyTypeObject samr_EncryptedPasswordAES_Type;
static PyTypeObject samr_UserInfo31_Type;
static PyTypeObject samr_UserInfo32_Type;
static PyTypeObject samr_UserInfo_Type;
static PyTypeObject samr_RidWithAttribute_Type;
static PyTypeObject samr_RidWithAttributeArray_Type;
static PyTypeObject samr_DispEntryGeneral_Type;
static PyTypeObject samr_DispInfoGeneral_Type;
static PyTypeObject samr_DispEntryFull_Type;
static PyTypeObject samr_DispInfoFull_Type;
static PyTypeObject samr_DispEntryFullGroup_Type;
static PyTypeObject samr_DispInfoFullGroups_Type;
static PyTypeObject samr_DispEntryAscii_Type;
static PyTypeObject samr_DispInfoAscii_Type;
static PyTypeObject samr_DispInfo_Type;
static PyTypeObject samr_PwInfo_Type;
static PyTypeObject userPwdChangeFailureInformation_Type;
static PyTypeObject samr_ConnectInfo1_Type;
static PyTypeObject samr_ConnectInfo_Type;
static PyTypeObject samr_ValidationBlob_Type;
static PyTypeObject samr_ValidatePasswordInfo_Type;
static PyTypeObject samr_ValidatePasswordRepCtr_Type;
static PyTypeObject samr_ValidatePasswordRep_Type;
static PyTypeObject samr_ValidatePasswordReq3_Type;
static PyTypeObject samr_ValidatePasswordReq2_Type;
static PyTypeObject samr_ValidatePasswordReq1_Type;
static PyTypeObject samr_ValidatePasswordReq_Type;
static PyTypeObject samr_InterfaceType;
static PyTypeObject samr_Connect_Type;
static PyTypeObject samr_Close_Type;
static PyTypeObject samr_SetSecurity_Type;
static PyTypeObject samr_QuerySecurity_Type;
static PyTypeObject samr_Shutdown_Type;
static PyTypeObject samr_LookupDomain_Type;
static PyTypeObject samr_EnumDomains_Type;
static PyTypeObject samr_OpenDomain_Type;
static PyTypeObject samr_QueryDomainInfo_Type;
static PyTypeObject samr_SetDomainInfo_Type;
static PyTypeObject samr_CreateDomainGroup_Type;
static PyTypeObject samr_EnumDomainGroups_Type;
static PyTypeObject samr_CreateUser_Type;
static PyTypeObject samr_EnumDomainUsers_Type;
static PyTypeObject samr_CreateDomAlias_Type;
static PyTypeObject samr_EnumDomainAliases_Type;
static PyTypeObject samr_GetAliasMembership_Type;
static PyTypeObject samr_LookupNames_Type;
static PyTypeObject samr_LookupRids_Type;
static PyTypeObject samr_OpenGroup_Type;
static PyTypeObject samr_QueryGroupInfo_Type;
static PyTypeObject samr_SetGroupInfo_Type;
static PyTypeObject samr_AddGroupMember_Type;
static PyTypeObject samr_DeleteDomainGroup_Type;
static PyTypeObject samr_DeleteGroupMember_Type;
static PyTypeObject samr_QueryGroupMember_Type;
static PyTypeObject samr_SetMemberAttributesOfGroup_Type;
static PyTypeObject samr_OpenAlias_Type;
static PyTypeObject samr_QueryAliasInfo_Type;
static PyTypeObject samr_SetAliasInfo_Type;
static PyTypeObject samr_DeleteDomAlias_Type;
static PyTypeObject samr_AddAliasMember_Type;
static PyTypeObject samr_DeleteAliasMember_Type;
static PyTypeObject samr_GetMembersInAlias_Type;
static PyTypeObject samr_OpenUser_Type;
static PyTypeObject samr_DeleteUser_Type;
static PyTypeObject samr_QueryUserInfo_Type;
static PyTypeObject samr_SetUserInfo_Type;
static PyTypeObject samr_ChangePasswordUser_Type;
static PyTypeObject samr_GetGroupsForUser_Type;
static PyTypeObject samr_QueryDisplayInfo_Type;
static PyTypeObject samr_GetDisplayEnumerationIndex_Type;
static PyTypeObject samr_TestPrivateFunctionsDomain_Type;
static PyTypeObject samr_TestPrivateFunctionsUser_Type;
static PyTypeObject samr_GetUserPwInfo_Type;
static PyTypeObject samr_RemoveMemberFromForeignDomain_Type;
static PyTypeObject samr_QueryDomainInfo2_Type;
static PyTypeObject samr_QueryUserInfo2_Type;
static PyTypeObject samr_QueryDisplayInfo2_Type;
static PyTypeObject samr_GetDisplayEnumerationIndex2_Type;
static PyTypeObject samr_CreateUser2_Type;
static PyTypeObject samr_QueryDisplayInfo3_Type;
static PyTypeObject samr_AddMultipleMembersToAlias_Type;
static PyTypeObject samr_RemoveMultipleMembersFromAlias_Type;
static PyTypeObject samr_OemChangePasswordUser2_Type;
static PyTypeObject samr_ChangePasswordUser2_Type;
static PyTypeObject samr_GetDomPwInfo_Type;
static PyTypeObject samr_Connect2_Type;
static PyTypeObject samr_SetUserInfo2_Type;
static PyTypeObject samr_SetBootKeyInformation_Type;
static PyTypeObject samr_GetBootKeyInformation_Type;
static PyTypeObject samr_Connect3_Type;
static PyTypeObject samr_Connect4_Type;
static PyTypeObject samr_ChangePasswordUser3_Type;
static PyTypeObject samr_Connect5_Type;
static PyTypeObject samr_RidToSid_Type;
static PyTypeObject samr_SetDsrmPassword_Type;
static PyTypeObject samr_ValidatePassword_Type;
static PyTypeObject samr_ChangePasswordUser4_Type;

static PyTypeObject *lsa_String_Type;
static PyTypeObject *BaseObject_Type;
static PyTypeObject *lsa_BinaryString_Type;
static PyTypeObject *lsa_AsciiStringLarge_Type;
static PyTypeObject *lsa_StringLarge_Type;
static PyTypeObject *policy_handle_Type;
static PyTypeObject *sec_desc_buf_Type;
static PyTypeObject *dom_sid_Type;
static PyTypeObject *lsa_SidArray_Type;
static PyTypeObject *lsa_Strings_Type;
static PyTypeObject *lsa_AsciiString_Type;
static PyTypeObject *ClientConnection_Type;
static PyTypeObject *ndr_syntax_id_Type;

static PyObject *py_samr_SamEntry_get_idx(PyObject *obj, void *closure)
{
	struct samr_SamEntry *object = pytalloc_get_ptr(obj);
	PyObject *py_idx;
	py_idx = PyLong_FromUnsignedLongLong((uint32_t)(object->idx));
	return py_idx;
}

static int py_samr_SamEntry_set_idx(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SamEntry *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->idx");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->idx));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->idx = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_SamEntry_get_name(PyObject *obj, void *closure)
{
	struct samr_SamEntry *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->name);
	return py_name;
}

static int py_samr_SamEntry_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SamEntry *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_SamEntry_getsetters[] = {
	{
		.name = discard_const_p(char, "idx"),
		.get = py_samr_SamEntry_get_idx,
		.set = py_samr_SamEntry_set_idx,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "name"),
		.get = py_samr_SamEntry_get_name,
		.set = py_samr_SamEntry_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_samr_SamEntry_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_SamEntry, type);
}


static PyTypeObject samr_SamEntry_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.SamEntry",
	.tp_getset = py_samr_SamEntry_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_SamEntry_new,
};


static PyObject *py_samr_SamArray_get_count(PyObject *obj, void *closure)
{
	struct samr_SamArray *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_samr_SamArray_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SamArray *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_SamArray_get_entries(PyObject *obj, void *closure)
{
	struct samr_SamArray *object = pytalloc_get_ptr(obj);
	PyObject *py_entries;
	if (object->entries == NULL) {
		Py_RETURN_NONE;
	}
	if (object->entries == NULL) {
		py_entries = Py_None;
		Py_INCREF(py_entries);
	} else {
		py_entries = PyList_New(object->count);
		if (py_entries == NULL) {
			return NULL;
		}
		{
			int entries_cntr_1;
			for (entries_cntr_1 = 0; entries_cntr_1 < (object->count); entries_cntr_1++) {
				PyObject *py_entries_1;
				py_entries_1 = pytalloc_reference_ex(&samr_SamEntry_Type, object->entries, &(object->entries)[entries_cntr_1]);
				PyList_SetItem(py_entries, entries_cntr_1, py_entries_1);
			}
		}
	}
	return py_entries;
}

static int py_samr_SamArray_set_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SamArray *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->entries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->entries");
		return -1;
	}
	if (value == Py_None) {
		object->entries = NULL;
	} else {
		object->entries = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int entries_cntr_1;
			object->entries = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->entries, PyList_GET_SIZE(value));
			if (!object->entries) { return -1; }
			talloc_set_name_const(object->entries, "ARRAY: object->entries");
			for (entries_cntr_1 = 0; entries_cntr_1 < PyList_GET_SIZE(value); entries_cntr_1++) {
				if (PyList_GET_ITEM(value, entries_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->entries)[entries_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&samr_SamEntry_Type, PyList_GET_ITEM(value, entries_cntr_1), return -1;);
				if (talloc_reference(object->entries, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, entries_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->entries)[entries_cntr_1] = *(struct samr_SamEntry *)pytalloc_get_ptr(PyList_GET_ITEM(value, entries_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_samr_SamArray_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_samr_SamArray_get_count,
		.set = py_samr_SamArray_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "entries"),
		.get = py_samr_SamArray_get_entries,
		.set = py_samr_SamArray_set_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_SamEntry")
	},
	{ .name = NULL }
};

static PyObject *py_samr_SamArray_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_SamArray, type);
}


static PyTypeObject samr_SamArray_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.SamArray",
	.tp_getset = py_samr_SamArray_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_SamArray_new,
};


static PyObject *py_samr_DomInfo1_get_min_password_length(PyObject *obj, void *closure)
{
	struct samr_DomInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_min_password_length;
	py_min_password_length = PyLong_FromLong((uint16_t)(object->min_password_length));
	return py_min_password_length;
}

static int py_samr_DomInfo1_set_min_password_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->min_password_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->min_password_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->min_password_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DomInfo1_get_password_history_length(PyObject *obj, void *closure)
{
	struct samr_DomInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_password_history_length;
	py_password_history_length = PyLong_FromLong((uint16_t)(object->password_history_length));
	return py_password_history_length;
}

static int py_samr_DomInfo1_set_password_history_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password_history_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->password_history_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->password_history_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DomInfo1_get_password_properties(PyObject *obj, void *closure)
{
	struct samr_DomInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_password_properties;
	py_password_properties = PyLong_FromUnsignedLongLong((uint32_t)(object->password_properties));
	return py_password_properties;
}

static int py_samr_DomInfo1_set_password_properties(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password_properties");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->password_properties));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->password_properties = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DomInfo1_get_max_password_age(PyObject *obj, void *closure)
{
	struct samr_DomInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_max_password_age;
	py_max_password_age = PyLong_FromLongLong(object->max_password_age);
	return py_max_password_age;
}

static int py_samr_DomInfo1_set_max_password_age(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_password_age");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->max_password_age));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->max_password_age = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DomInfo1_get_min_password_age(PyObject *obj, void *closure)
{
	struct samr_DomInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_min_password_age;
	py_min_password_age = PyLong_FromLongLong(object->min_password_age);
	return py_min_password_age;
}

static int py_samr_DomInfo1_set_min_password_age(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->min_password_age");
		return -1;
	}
	{
		const long long int_max = ndr_sizeof2intmax(sizeof(object->min_password_age));
		const long long int_min = -int_max - 1;
		if (PyLong_Check(value)) {
			long long test_var;
			test_var = PyLong_AsLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var < int_min || test_var > int_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range %lld - %lld, got %lld",
				  PyLong_Type.tp_name, int_min, int_max, test_var);
				return -1;
			}
			object->min_password_age = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_DomInfo1_getsetters[] = {
	{
		.name = discard_const_p(char, "min_password_length"),
		.get = py_samr_DomInfo1_get_min_password_length,
		.set = py_samr_DomInfo1_set_min_password_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "password_history_length"),
		.get = py_samr_DomInfo1_get_password_history_length,
		.set = py_samr_DomInfo1_set_password_history_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "password_properties"),
		.get = py_samr_DomInfo1_get_password_properties,
		.set = py_samr_DomInfo1_set_password_properties,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_PasswordProperties")
	},
	{
		.name = discard_const_p(char, "max_password_age"),
		.get = py_samr_DomInfo1_get_max_password_age,
		.set = py_samr_DomInfo1_set_max_password_age,
		.doc = discard_const_p(char, "PIDL-generated element of base type dlong")
	},
	{
		.name = discard_const_p(char, "min_password_age"),
		.get = py_samr_DomInfo1_get_min_password_age,
		.set = py_samr_DomInfo1_set_min_password_age,
		.doc = discard_const_p(char, "PIDL-generated element of base type dlong")
	},
	{ .name = NULL }
};

static PyObject *py_samr_DomInfo1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_DomInfo1, type);
}

static PyObject *py_samr_DomInfo1_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct samr_DomInfo1 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_samr_DomInfo1);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_samr_DomInfo1_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct samr_DomInfo1 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_samr_DomInfo1);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_samr_DomInfo1);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_samr_DomInfo1_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct samr_DomInfo1 *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_samr_DomInfo1, "samr_DomInfo1", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_samr_DomInfo1, "samr_DomInfo1", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_samr_DomInfo1_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_samr_DomInfo1_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_DomInfo1_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_DomInfo1_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_DomInfo1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DomInfo1",
	.tp_getset = py_samr_DomInfo1_getsetters,
	.tp_methods = py_samr_DomInfo1_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DomInfo1_new,
};


static PyObject *py_samr_DomGeneralInformation_get_force_logoff_time(PyObject *obj, void *closure)
{
	struct samr_DomGeneralInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_force_logoff_time;
	py_force_logoff_time = PyLong_FromUnsignedLongLong(object->force_logoff_time);
	return py_force_logoff_time;
}

static int py_samr_DomGeneralInformation_set_force_logoff_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomGeneralInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->force_logoff_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->force_logoff_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->force_logoff_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DomGeneralInformation_get_oem_information(PyObject *obj, void *closure)
{
	struct samr_DomGeneralInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_oem_information;
	py_oem_information = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->oem_information);
	return py_oem_information;
}

static int py_samr_DomGeneralInformation_set_oem_information(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomGeneralInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->oem_information");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->oem_information = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_DomGeneralInformation_get_domain_name(PyObject *obj, void *closure)
{
	struct samr_DomGeneralInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->domain_name);
	return py_domain_name;
}

static int py_samr_DomGeneralInformation_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomGeneralInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->domain_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_DomGeneralInformation_get_primary(PyObject *obj, void *closure)
{
	struct samr_DomGeneralInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_primary;
	py_primary = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->primary);
	return py_primary;
}

static int py_samr_DomGeneralInformation_set_primary(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomGeneralInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->primary");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->primary = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_DomGeneralInformation_get_sequence_num(PyObject *obj, void *closure)
{
	struct samr_DomGeneralInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_sequence_num;
	py_sequence_num = PyLong_FromUnsignedLongLong(object->sequence_num);
	return py_sequence_num;
}

static int py_samr_DomGeneralInformation_set_sequence_num(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomGeneralInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sequence_num");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sequence_num));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sequence_num = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DomGeneralInformation_get_domain_server_state(PyObject *obj, void *closure)
{
	struct samr_DomGeneralInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_server_state;
	py_domain_server_state = PyLong_FromUnsignedLongLong((uint32_t)(object->domain_server_state));
	return py_domain_server_state;
}

static int py_samr_DomGeneralInformation_set_domain_server_state(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomGeneralInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_server_state");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->domain_server_state));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->domain_server_state = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DomGeneralInformation_get_role(PyObject *obj, void *closure)
{
	struct samr_DomGeneralInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_role;
	py_role = PyLong_FromUnsignedLongLong((uint32_t)(object->role));
	return py_role;
}

static int py_samr_DomGeneralInformation_set_role(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomGeneralInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->role");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->role));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->role = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DomGeneralInformation_get_unknown3(PyObject *obj, void *closure)
{
	struct samr_DomGeneralInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown3;
	py_unknown3 = PyLong_FromUnsignedLongLong((uint32_t)(object->unknown3));
	return py_unknown3;
}

static int py_samr_DomGeneralInformation_set_unknown3(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomGeneralInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unknown3");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->unknown3));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->unknown3 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DomGeneralInformation_get_num_users(PyObject *obj, void *closure)
{
	struct samr_DomGeneralInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_num_users;
	py_num_users = PyLong_FromUnsignedLongLong((uint32_t)(object->num_users));
	return py_num_users;
}

static int py_samr_DomGeneralInformation_set_num_users(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomGeneralInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_users");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_users));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_users = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DomGeneralInformation_get_num_groups(PyObject *obj, void *closure)
{
	struct samr_DomGeneralInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_num_groups;
	py_num_groups = PyLong_FromUnsignedLongLong((uint32_t)(object->num_groups));
	return py_num_groups;
}

static int py_samr_DomGeneralInformation_set_num_groups(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomGeneralInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_groups");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_groups));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_groups = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DomGeneralInformation_get_num_aliases(PyObject *obj, void *closure)
{
	struct samr_DomGeneralInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_num_aliases;
	py_num_aliases = PyLong_FromUnsignedLongLong((uint32_t)(object->num_aliases));
	return py_num_aliases;
}

static int py_samr_DomGeneralInformation_set_num_aliases(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomGeneralInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_aliases");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_aliases));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_aliases = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_DomGeneralInformation_getsetters[] = {
	{
		.name = discard_const_p(char, "force_logoff_time"),
		.get = py_samr_DomGeneralInformation_get_force_logoff_time,
		.set = py_samr_DomGeneralInformation_set_force_logoff_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "oem_information"),
		.get = py_samr_DomGeneralInformation_get_oem_information,
		.set = py_samr_DomGeneralInformation_set_oem_information,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "domain_name"),
		.get = py_samr_DomGeneralInformation_get_domain_name,
		.set = py_samr_DomGeneralInformation_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "primary"),
		.get = py_samr_DomGeneralInformation_get_primary,
		.set = py_samr_DomGeneralInformation_set_primary,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "sequence_num"),
		.get = py_samr_DomGeneralInformation_get_sequence_num,
		.set = py_samr_DomGeneralInformation_set_sequence_num,
		.doc = discard_const_p(char, "PIDL-generated element of base type udlong")
	},
	{
		.name = discard_const_p(char, "domain_server_state"),
		.get = py_samr_DomGeneralInformation_get_domain_server_state,
		.set = py_samr_DomGeneralInformation_set_domain_server_state,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_DomainServerState")
	},
	{
		.name = discard_const_p(char, "role"),
		.get = py_samr_DomGeneralInformation_get_role,
		.set = py_samr_DomGeneralInformation_set_role,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_Role")
	},
	{
		.name = discard_const_p(char, "unknown3"),
		.get = py_samr_DomGeneralInformation_get_unknown3,
		.set = py_samr_DomGeneralInformation_set_unknown3,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "num_users"),
		.get = py_samr_DomGeneralInformation_get_num_users,
		.set = py_samr_DomGeneralInformation_set_num_users,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "num_groups"),
		.get = py_samr_DomGeneralInformation_get_num_groups,
		.set = py_samr_DomGeneralInformation_set_num_groups,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "num_aliases"),
		.get = py_samr_DomGeneralInformation_get_num_aliases,
		.set = py_samr_DomGeneralInformation_set_num_aliases,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_samr_DomGeneralInformation_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_DomGeneralInformation, type);
}


static PyTypeObject samr_DomGeneralInformation_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DomGeneralInformation",
	.tp_getset = py_samr_DomGeneralInformation_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DomGeneralInformation_new,
};


static PyObject *py_samr_DomInfo3_get_force_logoff_time(PyObject *obj, void *closure)
{
	struct samr_DomInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_force_logoff_time;
	py_force_logoff_time = PyLong_FromUnsignedLongLong(object->force_logoff_time);
	return py_force_logoff_time;
}

static int py_samr_DomInfo3_set_force_logoff_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->force_logoff_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->force_logoff_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->force_logoff_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_DomInfo3_getsetters[] = {
	{
		.name = discard_const_p(char, "force_logoff_time"),
		.get = py_samr_DomInfo3_get_force_logoff_time,
		.set = py_samr_DomInfo3_set_force_logoff_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{ .name = NULL }
};

static PyObject *py_samr_DomInfo3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_DomInfo3, type);
}


static PyTypeObject samr_DomInfo3_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DomInfo3",
	.tp_getset = py_samr_DomInfo3_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DomInfo3_new,
};


static PyObject *py_samr_DomOEMInformation_get_oem_information(PyObject *obj, void *closure)
{
	struct samr_DomOEMInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_oem_information;
	py_oem_information = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->oem_information);
	return py_oem_information;
}

static int py_samr_DomOEMInformation_set_oem_information(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomOEMInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->oem_information");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->oem_information = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_DomOEMInformation_getsetters[] = {
	{
		.name = discard_const_p(char, "oem_information"),
		.get = py_samr_DomOEMInformation_get_oem_information,
		.set = py_samr_DomOEMInformation_set_oem_information,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_samr_DomOEMInformation_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_DomOEMInformation, type);
}


static PyTypeObject samr_DomOEMInformation_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DomOEMInformation",
	.tp_getset = py_samr_DomOEMInformation_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DomOEMInformation_new,
};


static PyObject *py_samr_DomInfo5_get_domain_name(PyObject *obj, void *closure)
{
	struct samr_DomInfo5 *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	py_domain_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->domain_name);
	return py_domain_name;
}

static int py_samr_DomInfo5_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomInfo5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->domain_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_DomInfo5_getsetters[] = {
	{
		.name = discard_const_p(char, "domain_name"),
		.get = py_samr_DomInfo5_get_domain_name,
		.set = py_samr_DomInfo5_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_samr_DomInfo5_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_DomInfo5, type);
}


static PyTypeObject samr_DomInfo5_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DomInfo5",
	.tp_getset = py_samr_DomInfo5_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DomInfo5_new,
};


static PyObject *py_samr_DomInfo6_get_primary(PyObject *obj, void *closure)
{
	struct samr_DomInfo6 *object = pytalloc_get_ptr(obj);
	PyObject *py_primary;
	py_primary = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->primary);
	return py_primary;
}

static int py_samr_DomInfo6_set_primary(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomInfo6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->primary");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->primary = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_DomInfo6_getsetters[] = {
	{
		.name = discard_const_p(char, "primary"),
		.get = py_samr_DomInfo6_get_primary,
		.set = py_samr_DomInfo6_set_primary,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_samr_DomInfo6_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_DomInfo6, type);
}


static PyTypeObject samr_DomInfo6_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DomInfo6",
	.tp_getset = py_samr_DomInfo6_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DomInfo6_new,
};


static PyObject *py_samr_DomInfo7_get_role(PyObject *obj, void *closure)
{
	struct samr_DomInfo7 *object = pytalloc_get_ptr(obj);
	PyObject *py_role;
	py_role = PyLong_FromUnsignedLongLong((uint32_t)(object->role));
	return py_role;
}

static int py_samr_DomInfo7_set_role(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomInfo7 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->role");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->role));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->role = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_DomInfo7_getsetters[] = {
	{
		.name = discard_const_p(char, "role"),
		.get = py_samr_DomInfo7_get_role,
		.set = py_samr_DomInfo7_set_role,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_Role")
	},
	{ .name = NULL }
};

static PyObject *py_samr_DomInfo7_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_DomInfo7, type);
}


static PyTypeObject samr_DomInfo7_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DomInfo7",
	.tp_getset = py_samr_DomInfo7_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DomInfo7_new,
};


static PyObject *py_samr_DomInfo8_get_sequence_num(PyObject *obj, void *closure)
{
	struct samr_DomInfo8 *object = pytalloc_get_ptr(obj);
	PyObject *py_sequence_num;
	py_sequence_num = PyLong_FromUnsignedLongLong(object->sequence_num);
	return py_sequence_num;
}

static int py_samr_DomInfo8_set_sequence_num(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomInfo8 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sequence_num");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sequence_num));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sequence_num = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DomInfo8_get_domain_create_time(PyObject *obj, void *closure)
{
	struct samr_DomInfo8 *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_create_time;
	py_domain_create_time = PyLong_FromUnsignedLongLong(object->domain_create_time);
	return py_domain_create_time;
}

static int py_samr_DomInfo8_set_domain_create_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomInfo8 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_create_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->domain_create_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->domain_create_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_DomInfo8_getsetters[] = {
	{
		.name = discard_const_p(char, "sequence_num"),
		.get = py_samr_DomInfo8_get_sequence_num,
		.set = py_samr_DomInfo8_set_sequence_num,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "domain_create_time"),
		.get = py_samr_DomInfo8_get_domain_create_time,
		.set = py_samr_DomInfo8_set_domain_create_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{ .name = NULL }
};

static PyObject *py_samr_DomInfo8_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_DomInfo8, type);
}


static PyTypeObject samr_DomInfo8_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DomInfo8",
	.tp_getset = py_samr_DomInfo8_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DomInfo8_new,
};


static PyObject *py_samr_DomInfo9_get_domain_server_state(PyObject *obj, void *closure)
{
	struct samr_DomInfo9 *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_server_state;
	py_domain_server_state = PyLong_FromUnsignedLongLong((uint32_t)(object->domain_server_state));
	return py_domain_server_state;
}

static int py_samr_DomInfo9_set_domain_server_state(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomInfo9 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_server_state");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->domain_server_state));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->domain_server_state = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_DomInfo9_getsetters[] = {
	{
		.name = discard_const_p(char, "domain_server_state"),
		.get = py_samr_DomInfo9_get_domain_server_state,
		.set = py_samr_DomInfo9_set_domain_server_state,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_DomainServerState")
	},
	{ .name = NULL }
};

static PyObject *py_samr_DomInfo9_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_DomInfo9, type);
}


static PyTypeObject samr_DomInfo9_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DomInfo9",
	.tp_getset = py_samr_DomInfo9_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DomInfo9_new,
};


static PyObject *py_samr_DomGeneralInformation2_get_general(PyObject *obj, void *closure)
{
	struct samr_DomGeneralInformation2 *object = pytalloc_get_ptr(obj);
	PyObject *py_general;
	py_general = pytalloc_reference_ex(&samr_DomGeneralInformation_Type, pytalloc_get_mem_ctx(obj), &object->general);
	return py_general;
}

static int py_samr_DomGeneralInformation2_set_general(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomGeneralInformation2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->general");
		return -1;
	}
	PY_CHECK_TYPE(&samr_DomGeneralInformation_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->general = *(struct samr_DomGeneralInformation *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_DomGeneralInformation2_get_lockout_duration(PyObject *obj, void *closure)
{
	struct samr_DomGeneralInformation2 *object = pytalloc_get_ptr(obj);
	PyObject *py_lockout_duration;
	py_lockout_duration = PyLong_FromUnsignedLongLong(object->lockout_duration);
	return py_lockout_duration;
}

static int py_samr_DomGeneralInformation2_set_lockout_duration(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomGeneralInformation2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lockout_duration");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lockout_duration));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lockout_duration = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DomGeneralInformation2_get_lockout_window(PyObject *obj, void *closure)
{
	struct samr_DomGeneralInformation2 *object = pytalloc_get_ptr(obj);
	PyObject *py_lockout_window;
	py_lockout_window = PyLong_FromUnsignedLongLong(object->lockout_window);
	return py_lockout_window;
}

static int py_samr_DomGeneralInformation2_set_lockout_window(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomGeneralInformation2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lockout_window");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lockout_window));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lockout_window = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DomGeneralInformation2_get_lockout_threshold(PyObject *obj, void *closure)
{
	struct samr_DomGeneralInformation2 *object = pytalloc_get_ptr(obj);
	PyObject *py_lockout_threshold;
	py_lockout_threshold = PyLong_FromLong((uint16_t)(object->lockout_threshold));
	return py_lockout_threshold;
}

static int py_samr_DomGeneralInformation2_set_lockout_threshold(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomGeneralInformation2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lockout_threshold");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lockout_threshold));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lockout_threshold = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_DomGeneralInformation2_getsetters[] = {
	{
		.name = discard_const_p(char, "general"),
		.get = py_samr_DomGeneralInformation2_get_general,
		.set = py_samr_DomGeneralInformation2_set_general,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_DomGeneralInformation")
	},
	{
		.name = discard_const_p(char, "lockout_duration"),
		.get = py_samr_DomGeneralInformation2_get_lockout_duration,
		.set = py_samr_DomGeneralInformation2_set_lockout_duration,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "lockout_window"),
		.get = py_samr_DomGeneralInformation2_get_lockout_window,
		.set = py_samr_DomGeneralInformation2_set_lockout_window,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "lockout_threshold"),
		.get = py_samr_DomGeneralInformation2_get_lockout_threshold,
		.set = py_samr_DomGeneralInformation2_set_lockout_threshold,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_samr_DomGeneralInformation2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_DomGeneralInformation2, type);
}


static PyTypeObject samr_DomGeneralInformation2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DomGeneralInformation2",
	.tp_getset = py_samr_DomGeneralInformation2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DomGeneralInformation2_new,
};


static PyObject *py_samr_DomInfo12_get_lockout_duration(PyObject *obj, void *closure)
{
	struct samr_DomInfo12 *object = pytalloc_get_ptr(obj);
	PyObject *py_lockout_duration;
	py_lockout_duration = PyLong_FromUnsignedLongLong(object->lockout_duration);
	return py_lockout_duration;
}

static int py_samr_DomInfo12_set_lockout_duration(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomInfo12 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lockout_duration");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lockout_duration));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lockout_duration = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DomInfo12_get_lockout_window(PyObject *obj, void *closure)
{
	struct samr_DomInfo12 *object = pytalloc_get_ptr(obj);
	PyObject *py_lockout_window;
	py_lockout_window = PyLong_FromUnsignedLongLong(object->lockout_window);
	return py_lockout_window;
}

static int py_samr_DomInfo12_set_lockout_window(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomInfo12 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lockout_window");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lockout_window));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lockout_window = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DomInfo12_get_lockout_threshold(PyObject *obj, void *closure)
{
	struct samr_DomInfo12 *object = pytalloc_get_ptr(obj);
	PyObject *py_lockout_threshold;
	py_lockout_threshold = PyLong_FromLong((uint16_t)(object->lockout_threshold));
	return py_lockout_threshold;
}

static int py_samr_DomInfo12_set_lockout_threshold(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomInfo12 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lockout_threshold");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lockout_threshold));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lockout_threshold = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_DomInfo12_getsetters[] = {
	{
		.name = discard_const_p(char, "lockout_duration"),
		.get = py_samr_DomInfo12_get_lockout_duration,
		.set = py_samr_DomInfo12_set_lockout_duration,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "lockout_window"),
		.get = py_samr_DomInfo12_get_lockout_window,
		.set = py_samr_DomInfo12_set_lockout_window,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "lockout_threshold"),
		.get = py_samr_DomInfo12_get_lockout_threshold,
		.set = py_samr_DomInfo12_set_lockout_threshold,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_samr_DomInfo12_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_DomInfo12, type);
}


static PyTypeObject samr_DomInfo12_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DomInfo12",
	.tp_getset = py_samr_DomInfo12_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DomInfo12_new,
};


static PyObject *py_samr_DomInfo13_get_sequence_num(PyObject *obj, void *closure)
{
	struct samr_DomInfo13 *object = pytalloc_get_ptr(obj);
	PyObject *py_sequence_num;
	py_sequence_num = PyLong_FromUnsignedLongLong(object->sequence_num);
	return py_sequence_num;
}

static int py_samr_DomInfo13_set_sequence_num(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomInfo13 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sequence_num");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->sequence_num));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->sequence_num = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DomInfo13_get_domain_create_time(PyObject *obj, void *closure)
{
	struct samr_DomInfo13 *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_create_time;
	py_domain_create_time = PyLong_FromUnsignedLongLong(object->domain_create_time);
	return py_domain_create_time;
}

static int py_samr_DomInfo13_set_domain_create_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomInfo13 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_create_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->domain_create_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->domain_create_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DomInfo13_get_modified_count_at_last_promotion(PyObject *obj, void *closure)
{
	struct samr_DomInfo13 *object = pytalloc_get_ptr(obj);
	PyObject *py_modified_count_at_last_promotion;
	py_modified_count_at_last_promotion = PyLong_FromUnsignedLongLong(object->modified_count_at_last_promotion);
	return py_modified_count_at_last_promotion;
}

static int py_samr_DomInfo13_set_modified_count_at_last_promotion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DomInfo13 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->modified_count_at_last_promotion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->modified_count_at_last_promotion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->modified_count_at_last_promotion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_DomInfo13_getsetters[] = {
	{
		.name = discard_const_p(char, "sequence_num"),
		.get = py_samr_DomInfo13_get_sequence_num,
		.set = py_samr_DomInfo13_set_sequence_num,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{
		.name = discard_const_p(char, "domain_create_time"),
		.get = py_samr_DomInfo13_get_domain_create_time,
		.set = py_samr_DomInfo13_set_domain_create_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "modified_count_at_last_promotion"),
		.get = py_samr_DomInfo13_get_modified_count_at_last_promotion,
		.set = py_samr_DomInfo13_set_modified_count_at_last_promotion,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{ .name = NULL }
};

static PyObject *py_samr_DomInfo13_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_DomInfo13, type);
}


static PyTypeObject samr_DomInfo13_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DomInfo13",
	.tp_getset = py_samr_DomInfo13_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DomInfo13_new,
};

static PyObject *py_import_samr_DomainInfo(TALLOC_CTX *mem_ctx, int level, union samr_DomainInfo *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&samr_DomInfo1_Type, mem_ctx, &in->info1);
			return ret;

		case 2:
			ret = pytalloc_reference_ex(&samr_DomGeneralInformation_Type, mem_ctx, &in->general);
			return ret;

		case 3:
			ret = pytalloc_reference_ex(&samr_DomInfo3_Type, mem_ctx, &in->info3);
			return ret;

		case 4:
			ret = pytalloc_reference_ex(&samr_DomOEMInformation_Type, mem_ctx, &in->oem);
			return ret;

		case 5:
			ret = pytalloc_reference_ex(&samr_DomInfo5_Type, mem_ctx, &in->info5);
			return ret;

		case 6:
			ret = pytalloc_reference_ex(&samr_DomInfo6_Type, mem_ctx, &in->info6);
			return ret;

		case 7:
			ret = pytalloc_reference_ex(&samr_DomInfo7_Type, mem_ctx, &in->info7);
			return ret;

		case 8:
			ret = pytalloc_reference_ex(&samr_DomInfo8_Type, mem_ctx, &in->info8);
			return ret;

		case 9:
			ret = pytalloc_reference_ex(&samr_DomInfo9_Type, mem_ctx, &in->info9);
			return ret;

		case 11:
			ret = pytalloc_reference_ex(&samr_DomGeneralInformation2_Type, mem_ctx, &in->general2);
			return ret;

		case 12:
			ret = pytalloc_reference_ex(&samr_DomInfo12_Type, mem_ctx, &in->info12);
			return ret;

		case 13:
			ret = pytalloc_reference_ex(&samr_DomInfo13_Type, mem_ctx, &in->info13);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union samr_DomainInfo *py_export_samr_DomainInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union samr_DomainInfo *ret = talloc_zero(mem_ctx, union samr_DomainInfo);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_DomInfo1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info1 = *(struct samr_DomInfo1 *)pytalloc_get_ptr(in);
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->general");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_DomGeneralInformation_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->general = *(struct samr_DomGeneralInformation *)pytalloc_get_ptr(in);
			break;

		case 3:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info3");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_DomInfo3_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info3 = *(struct samr_DomInfo3 *)pytalloc_get_ptr(in);
			break;

		case 4:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->oem");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_DomOEMInformation_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->oem = *(struct samr_DomOEMInformation *)pytalloc_get_ptr(in);
			break;

		case 5:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info5");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_DomInfo5_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info5 = *(struct samr_DomInfo5 *)pytalloc_get_ptr(in);
			break;

		case 6:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info6");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_DomInfo6_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info6 = *(struct samr_DomInfo6 *)pytalloc_get_ptr(in);
			break;

		case 7:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info7");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_DomInfo7_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info7 = *(struct samr_DomInfo7 *)pytalloc_get_ptr(in);
			break;

		case 8:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info8");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_DomInfo8_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info8 = *(struct samr_DomInfo8 *)pytalloc_get_ptr(in);
			break;

		case 9:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info9");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_DomInfo9_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info9 = *(struct samr_DomInfo9 *)pytalloc_get_ptr(in);
			break;

		case 11:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->general2");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_DomGeneralInformation2_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->general2 = *(struct samr_DomGeneralInformation2 *)pytalloc_get_ptr(in);
			break;

		case 12:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info12");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_DomInfo12_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info12 = *(struct samr_DomInfo12 *)pytalloc_get_ptr(in);
			break;

		case 13:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info13");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_DomInfo13_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info13 = *(struct samr_DomInfo13 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_samr_DomainInfo_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union samr_DomainInfo *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union samr_DomainInfo *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union samr_DomainInfo!");
		return NULL;
	}

	return py_import_samr_DomainInfo(mem_ctx, level, in);
}

static PyObject *py_samr_DomainInfo_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union samr_DomainInfo *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_samr_DomainInfo(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_samr_DomainInfo_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_DomainInfo_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_DomainInfo_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_samr_DomainInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject samr_DomainInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DomainInfo",
	.tp_getset = NULL,
	.tp_methods = py_samr_DomainInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DomainInfo_new,
};


static PyObject *py_samr_Ids_get_count(PyObject *obj, void *closure)
{
	struct samr_Ids *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_samr_Ids_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_Ids *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_Ids_get_ids(PyObject *obj, void *closure)
{
	struct samr_Ids *object = pytalloc_get_ptr(obj);
	PyObject *py_ids;
	if (object->ids == NULL) {
		Py_RETURN_NONE;
	}
	if (object->ids == NULL) {
		py_ids = Py_None;
		Py_INCREF(py_ids);
	} else {
		py_ids = PyList_New(object->count);
		if (py_ids == NULL) {
			return NULL;
		}
		{
			int ids_cntr_1;
			for (ids_cntr_1 = 0; ids_cntr_1 < (object->count); ids_cntr_1++) {
				PyObject *py_ids_1;
				py_ids_1 = PyLong_FromUnsignedLongLong((uint32_t)((object->ids)[ids_cntr_1]));
				PyList_SetItem(py_ids, ids_cntr_1, py_ids_1);
			}
		}
	}
	return py_ids;
}

static int py_samr_Ids_set_ids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_Ids *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->ids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ids");
		return -1;
	}
	if (value == Py_None) {
		object->ids = NULL;
	} else {
		object->ids = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int ids_cntr_1;
			object->ids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->ids, PyList_GET_SIZE(value));
			if (!object->ids) { return -1; }
			talloc_set_name_const(object->ids, "ARRAY: object->ids");
			for (ids_cntr_1 = 0; ids_cntr_1 < PyList_GET_SIZE(value); ids_cntr_1++) {
				if (PyList_GET_ITEM(value, ids_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->ids)[ids_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->ids)[ids_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, ids_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, ids_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->ids)[ids_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_samr_Ids_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_samr_Ids_get_count,
		.set = py_samr_Ids_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ids"),
		.get = py_samr_Ids_get_ids,
		.set = py_samr_Ids_set_ids,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_samr_Ids_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_Ids, type);
}


static PyTypeObject samr_Ids_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.Ids",
	.tp_getset = py_samr_Ids_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_Ids_new,
};


static PyObject *py_samr_GroupInfoAll_get_name(PyObject *obj, void *closure)
{
	struct samr_GroupInfoAll *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->name);
	return py_name;
}

static int py_samr_GroupInfoAll_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_GroupInfoAll *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_GroupInfoAll_get_attributes(PyObject *obj, void *closure)
{
	struct samr_GroupInfoAll *object = pytalloc_get_ptr(obj);
	PyObject *py_attributes;
	py_attributes = PyLong_FromUnsignedLongLong((uint32_t)(object->attributes));
	return py_attributes;
}

static int py_samr_GroupInfoAll_set_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_GroupInfoAll *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->attributes");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->attributes));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->attributes = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_GroupInfoAll_get_num_members(PyObject *obj, void *closure)
{
	struct samr_GroupInfoAll *object = pytalloc_get_ptr(obj);
	PyObject *py_num_members;
	py_num_members = PyLong_FromUnsignedLongLong((uint32_t)(object->num_members));
	return py_num_members;
}

static int py_samr_GroupInfoAll_set_num_members(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_GroupInfoAll *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_members");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_members));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_members = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_GroupInfoAll_get_description(PyObject *obj, void *closure)
{
	struct samr_GroupInfoAll *object = pytalloc_get_ptr(obj);
	PyObject *py_description;
	py_description = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->description);
	return py_description;
}

static int py_samr_GroupInfoAll_set_description(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_GroupInfoAll *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->description");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->description = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_GroupInfoAll_getsetters[] = {
	{
		.name = discard_const_p(char, "name"),
		.get = py_samr_GroupInfoAll_get_name,
		.set = py_samr_GroupInfoAll_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "attributes"),
		.get = py_samr_GroupInfoAll_get_attributes,
		.set = py_samr_GroupInfoAll_set_attributes,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_GroupAttrs")
	},
	{
		.name = discard_const_p(char, "num_members"),
		.get = py_samr_GroupInfoAll_get_num_members,
		.set = py_samr_GroupInfoAll_set_num_members,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "description"),
		.get = py_samr_GroupInfoAll_get_description,
		.set = py_samr_GroupInfoAll_set_description,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_samr_GroupInfoAll_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_GroupInfoAll, type);
}


static PyTypeObject samr_GroupInfoAll_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.GroupInfoAll",
	.tp_getset = py_samr_GroupInfoAll_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_GroupInfoAll_new,
};


static PyObject *py_samr_GroupInfoAttributes_get_attributes(PyObject *obj, void *closure)
{
	struct samr_GroupInfoAttributes *object = pytalloc_get_ptr(obj);
	PyObject *py_attributes;
	py_attributes = PyLong_FromUnsignedLongLong((uint32_t)(object->attributes));
	return py_attributes;
}

static int py_samr_GroupInfoAttributes_set_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_GroupInfoAttributes *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->attributes");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->attributes));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->attributes = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_GroupInfoAttributes_getsetters[] = {
	{
		.name = discard_const_p(char, "attributes"),
		.get = py_samr_GroupInfoAttributes_get_attributes,
		.set = py_samr_GroupInfoAttributes_set_attributes,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_GroupAttrs")
	},
	{ .name = NULL }
};

static PyObject *py_samr_GroupInfoAttributes_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_GroupInfoAttributes, type);
}


static PyTypeObject samr_GroupInfoAttributes_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.GroupInfoAttributes",
	.tp_getset = py_samr_GroupInfoAttributes_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_GroupInfoAttributes_new,
};


static PyObject *py_samr_GroupInfoDescription_get_description(PyObject *obj, void *closure)
{
	struct samr_GroupInfoDescription *object = pytalloc_get_ptr(obj);
	PyObject *py_description;
	py_description = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->description);
	return py_description;
}

static int py_samr_GroupInfoDescription_set_description(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_GroupInfoDescription *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->description");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->description = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_GroupInfoDescription_getsetters[] = {
	{
		.name = discard_const_p(char, "description"),
		.get = py_samr_GroupInfoDescription_get_description,
		.set = py_samr_GroupInfoDescription_set_description,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_samr_GroupInfoDescription_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_GroupInfoDescription, type);
}


static PyTypeObject samr_GroupInfoDescription_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.GroupInfoDescription",
	.tp_getset = py_samr_GroupInfoDescription_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_GroupInfoDescription_new,
};

static PyObject *py_import_samr_GroupInfo(TALLOC_CTX *mem_ctx, int level, union samr_GroupInfo *in)
{
	PyObject *ret;

	switch (level) {
		case GROUPINFOALL:
			ret = pytalloc_reference_ex(&samr_GroupInfoAll_Type, mem_ctx, &in->all);
			return ret;

		case GROUPINFONAME:
			ret = pytalloc_reference_ex(lsa_String_Type, mem_ctx, &in->name);
			return ret;

		case GROUPINFOATTRIBUTES:
			ret = pytalloc_reference_ex(&samr_GroupInfoAttributes_Type, mem_ctx, &in->attributes);
			return ret;

		case GROUPINFODESCRIPTION:
			ret = pytalloc_reference_ex(lsa_String_Type, mem_ctx, &in->description);
			return ret;

		case GROUPINFOALL2:
			ret = pytalloc_reference_ex(&samr_GroupInfoAll_Type, mem_ctx, &in->all2);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union samr_GroupInfo *py_export_samr_GroupInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union samr_GroupInfo *ret = talloc_zero(mem_ctx, union samr_GroupInfo);
	switch (level) {
		case GROUPINFOALL:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->all");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_GroupInfoAll_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->all = *(struct samr_GroupInfoAll *)pytalloc_get_ptr(in);
			break;

		case GROUPINFONAME:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->name");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(lsa_String_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name = *(struct lsa_String *)pytalloc_get_ptr(in);
			break;

		case GROUPINFOATTRIBUTES:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->attributes");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_GroupInfoAttributes_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->attributes = *(struct samr_GroupInfoAttributes *)pytalloc_get_ptr(in);
			break;

		case GROUPINFODESCRIPTION:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->description");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(lsa_String_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->description = *(struct lsa_String *)pytalloc_get_ptr(in);
			break;

		case GROUPINFOALL2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->all2");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_GroupInfoAll_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->all2 = *(struct samr_GroupInfoAll *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_samr_GroupInfo_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union samr_GroupInfo *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union samr_GroupInfo *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union samr_GroupInfo!");
		return NULL;
	}

	return py_import_samr_GroupInfo(mem_ctx, level, in);
}

static PyObject *py_samr_GroupInfo_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union samr_GroupInfo *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_samr_GroupInfo(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_samr_GroupInfo_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_GroupInfo_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_GroupInfo_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_samr_GroupInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject samr_GroupInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.GroupInfo",
	.tp_getset = NULL,
	.tp_methods = py_samr_GroupInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_GroupInfo_new,
};


static PyObject *py_samr_RidAttrArray_get_count(PyObject *obj, void *closure)
{
	struct samr_RidAttrArray *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_samr_RidAttrArray_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_RidAttrArray *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_RidAttrArray_get_rids(PyObject *obj, void *closure)
{
	struct samr_RidAttrArray *object = pytalloc_get_ptr(obj);
	PyObject *py_rids;
	if (object->rids == NULL) {
		Py_RETURN_NONE;
	}
	if (object->rids == NULL) {
		py_rids = Py_None;
		Py_INCREF(py_rids);
	} else {
		py_rids = PyList_New(object->count);
		if (py_rids == NULL) {
			return NULL;
		}
		{
			int rids_cntr_1;
			for (rids_cntr_1 = 0; rids_cntr_1 < (object->count); rids_cntr_1++) {
				PyObject *py_rids_1;
				py_rids_1 = PyLong_FromUnsignedLongLong((uint32_t)((object->rids)[rids_cntr_1]));
				PyList_SetItem(py_rids, rids_cntr_1, py_rids_1);
			}
		}
	}
	return py_rids;
}

static int py_samr_RidAttrArray_set_rids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_RidAttrArray *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->rids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rids");
		return -1;
	}
	if (value == Py_None) {
		object->rids = NULL;
	} else {
		object->rids = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int rids_cntr_1;
			object->rids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->rids, PyList_GET_SIZE(value));
			if (!object->rids) { return -1; }
			talloc_set_name_const(object->rids, "ARRAY: object->rids");
			for (rids_cntr_1 = 0; rids_cntr_1 < PyList_GET_SIZE(value); rids_cntr_1++) {
				if (PyList_GET_ITEM(value, rids_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->rids)[rids_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->rids)[rids_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, rids_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, rids_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->rids)[rids_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_samr_RidAttrArray_get_attributes(PyObject *obj, void *closure)
{
	struct samr_RidAttrArray *object = pytalloc_get_ptr(obj);
	PyObject *py_attributes;
	if (object->attributes == NULL) {
		Py_RETURN_NONE;
	}
	if (object->attributes == NULL) {
		py_attributes = Py_None;
		Py_INCREF(py_attributes);
	} else {
		py_attributes = PyList_New(object->count);
		if (py_attributes == NULL) {
			return NULL;
		}
		{
			int attributes_cntr_1;
			for (attributes_cntr_1 = 0; attributes_cntr_1 < (object->count); attributes_cntr_1++) {
				PyObject *py_attributes_1;
				py_attributes_1 = PyLong_FromUnsignedLongLong((uint32_t)((object->attributes)[attributes_cntr_1]));
				PyList_SetItem(py_attributes, attributes_cntr_1, py_attributes_1);
			}
		}
	}
	return py_attributes;
}

static int py_samr_RidAttrArray_set_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_RidAttrArray *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->attributes));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->attributes");
		return -1;
	}
	if (value == Py_None) {
		object->attributes = NULL;
	} else {
		object->attributes = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int attributes_cntr_1;
			object->attributes = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->attributes, PyList_GET_SIZE(value));
			if (!object->attributes) { return -1; }
			talloc_set_name_const(object->attributes, "ARRAY: object->attributes");
			for (attributes_cntr_1 = 0; attributes_cntr_1 < PyList_GET_SIZE(value); attributes_cntr_1++) {
				if (PyList_GET_ITEM(value, attributes_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->attributes)[attributes_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->attributes)[attributes_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, attributes_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, attributes_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->attributes)[attributes_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_samr_RidAttrArray_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_samr_RidAttrArray_get_count,
		.set = py_samr_RidAttrArray_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "rids"),
		.get = py_samr_RidAttrArray_get_rids,
		.set = py_samr_RidAttrArray_set_rids,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "attributes"),
		.get = py_samr_RidAttrArray_get_attributes,
		.set = py_samr_RidAttrArray_set_attributes,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_GroupAttrs")
	},
	{ .name = NULL }
};

static PyObject *py_samr_RidAttrArray_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_RidAttrArray, type);
}


static PyTypeObject samr_RidAttrArray_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.RidAttrArray",
	.tp_getset = py_samr_RidAttrArray_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_RidAttrArray_new,
};


static PyObject *py_samr_AliasInfoAll_get_name(PyObject *obj, void *closure)
{
	struct samr_AliasInfoAll *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	py_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->name);
	return py_name;
}

static int py_samr_AliasInfoAll_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_AliasInfoAll *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_AliasInfoAll_get_num_members(PyObject *obj, void *closure)
{
	struct samr_AliasInfoAll *object = pytalloc_get_ptr(obj);
	PyObject *py_num_members;
	py_num_members = PyLong_FromUnsignedLongLong((uint32_t)(object->num_members));
	return py_num_members;
}

static int py_samr_AliasInfoAll_set_num_members(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_AliasInfoAll *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_members");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_members));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_members = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_AliasInfoAll_get_description(PyObject *obj, void *closure)
{
	struct samr_AliasInfoAll *object = pytalloc_get_ptr(obj);
	PyObject *py_description;
	py_description = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->description);
	return py_description;
}

static int py_samr_AliasInfoAll_set_description(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_AliasInfoAll *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->description");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->description = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_AliasInfoAll_getsetters[] = {
	{
		.name = discard_const_p(char, "name"),
		.get = py_samr_AliasInfoAll_get_name,
		.set = py_samr_AliasInfoAll_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "num_members"),
		.get = py_samr_AliasInfoAll_get_num_members,
		.set = py_samr_AliasInfoAll_set_num_members,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "description"),
		.get = py_samr_AliasInfoAll_get_description,
		.set = py_samr_AliasInfoAll_set_description,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_samr_AliasInfoAll_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_AliasInfoAll, type);
}


static PyTypeObject samr_AliasInfoAll_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.AliasInfoAll",
	.tp_getset = py_samr_AliasInfoAll_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_AliasInfoAll_new,
};

static PyObject *py_import_samr_AliasInfo(TALLOC_CTX *mem_ctx, int level, union samr_AliasInfo *in)
{
	PyObject *ret;

	switch (level) {
		case ALIASINFOALL:
			ret = pytalloc_reference_ex(&samr_AliasInfoAll_Type, mem_ctx, &in->all);
			return ret;

		case ALIASINFONAME:
			ret = pytalloc_reference_ex(lsa_String_Type, mem_ctx, &in->name);
			return ret;

		case ALIASINFODESCRIPTION:
			ret = pytalloc_reference_ex(lsa_String_Type, mem_ctx, &in->description);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union samr_AliasInfo *py_export_samr_AliasInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union samr_AliasInfo *ret = talloc_zero(mem_ctx, union samr_AliasInfo);
	switch (level) {
		case ALIASINFOALL:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->all");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_AliasInfoAll_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->all = *(struct samr_AliasInfoAll *)pytalloc_get_ptr(in);
			break;

		case ALIASINFONAME:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->name");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(lsa_String_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->name = *(struct lsa_String *)pytalloc_get_ptr(in);
			break;

		case ALIASINFODESCRIPTION:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->description");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(lsa_String_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->description = *(struct lsa_String *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_samr_AliasInfo_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union samr_AliasInfo *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union samr_AliasInfo *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union samr_AliasInfo!");
		return NULL;
	}

	return py_import_samr_AliasInfo(mem_ctx, level, in);
}

static PyObject *py_samr_AliasInfo_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union samr_AliasInfo *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_samr_AliasInfo(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_samr_AliasInfo_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_AliasInfo_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_AliasInfo_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_samr_AliasInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject samr_AliasInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.AliasInfo",
	.tp_getset = NULL,
	.tp_methods = py_samr_AliasInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_AliasInfo_new,
};


static PyObject *py_samr_UserInfo1_get_account_name(PyObject *obj, void *closure)
{
	struct samr_UserInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	py_account_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->account_name);
	return py_account_name;
}

static int py_samr_UserInfo1_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->account_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->account_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo1_get_full_name(PyObject *obj, void *closure)
{
	struct samr_UserInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_full_name;
	py_full_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->full_name);
	return py_full_name;
}

static int py_samr_UserInfo1_set_full_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->full_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->full_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo1_get_primary_gid(PyObject *obj, void *closure)
{
	struct samr_UserInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_primary_gid;
	py_primary_gid = PyLong_FromUnsignedLongLong((uint32_t)(object->primary_gid));
	return py_primary_gid;
}

static int py_samr_UserInfo1_set_primary_gid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->primary_gid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->primary_gid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->primary_gid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo1_get_description(PyObject *obj, void *closure)
{
	struct samr_UserInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_description;
	py_description = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->description);
	return py_description;
}

static int py_samr_UserInfo1_set_description(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->description");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->description = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo1_get_comment(PyObject *obj, void *closure)
{
	struct samr_UserInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_comment;
	py_comment = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->comment);
	return py_comment;
}

static int py_samr_UserInfo1_set_comment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->comment");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->comment = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_UserInfo1_getsetters[] = {
	{
		.name = discard_const_p(char, "account_name"),
		.get = py_samr_UserInfo1_get_account_name,
		.set = py_samr_UserInfo1_set_account_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "full_name"),
		.get = py_samr_UserInfo1_get_full_name,
		.set = py_samr_UserInfo1_set_full_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "primary_gid"),
		.get = py_samr_UserInfo1_get_primary_gid,
		.set = py_samr_UserInfo1_set_primary_gid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "description"),
		.get = py_samr_UserInfo1_get_description,
		.set = py_samr_UserInfo1_set_description,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "comment"),
		.get = py_samr_UserInfo1_get_comment,
		.set = py_samr_UserInfo1_set_comment,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo1, type);
}


static PyTypeObject samr_UserInfo1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo1",
	.tp_getset = py_samr_UserInfo1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo1_new,
};


static PyObject *py_samr_UserInfo2_get_comment(PyObject *obj, void *closure)
{
	struct samr_UserInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_comment;
	py_comment = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->comment);
	return py_comment;
}

static int py_samr_UserInfo2_set_comment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->comment");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->comment = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo2_get_reserved(PyObject *obj, void *closure)
{
	struct samr_UserInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->reserved);
	return py_reserved;
}

static int py_samr_UserInfo2_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->reserved = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo2_get_country_code(PyObject *obj, void *closure)
{
	struct samr_UserInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_country_code;
	py_country_code = PyLong_FromLong((uint16_t)(object->country_code));
	return py_country_code;
}

static int py_samr_UserInfo2_set_country_code(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->country_code");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->country_code));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->country_code = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo2_get_code_page(PyObject *obj, void *closure)
{
	struct samr_UserInfo2 *object = pytalloc_get_ptr(obj);
	PyObject *py_code_page;
	py_code_page = PyLong_FromLong((uint16_t)(object->code_page));
	return py_code_page;
}

static int py_samr_UserInfo2_set_code_page(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->code_page");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->code_page));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->code_page = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_UserInfo2_getsetters[] = {
	{
		.name = discard_const_p(char, "comment"),
		.get = py_samr_UserInfo2_get_comment,
		.set = py_samr_UserInfo2_set_comment,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_samr_UserInfo2_get_reserved,
		.set = py_samr_UserInfo2_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "country_code"),
		.get = py_samr_UserInfo2_get_country_code,
		.set = py_samr_UserInfo2_set_country_code,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "code_page"),
		.get = py_samr_UserInfo2_get_code_page,
		.set = py_samr_UserInfo2_set_code_page,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo2, type);
}


static PyTypeObject samr_UserInfo2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo2",
	.tp_getset = py_samr_UserInfo2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo2_new,
};


static PyObject *py_samr_LogonHours_get_units_per_week(PyObject *obj, void *closure)
{
	struct samr_LogonHours *object = pytalloc_get_ptr(obj);
	PyObject *py_units_per_week;
	py_units_per_week = PyLong_FromLong((uint16_t)(object->units_per_week));
	return py_units_per_week;
}

static int py_samr_LogonHours_set_units_per_week(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_LogonHours *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->units_per_week");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->units_per_week));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->units_per_week = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_LogonHours_get_bits(PyObject *obj, void *closure)
{
	struct samr_LogonHours *object = pytalloc_get_ptr(obj);
	PyObject *py_bits;
	if (object->bits == NULL) {
		Py_RETURN_NONE;
	}
	if (object->bits == NULL) {
		py_bits = Py_None;
		Py_INCREF(py_bits);
	} else {
		py_bits = PyList_New(object->units_per_week / 8);
		if (py_bits == NULL) {
			return NULL;
		}
		{
			int bits_cntr_1;
			for (bits_cntr_1 = 0; bits_cntr_1 < (object->units_per_week / 8); bits_cntr_1++) {
				PyObject *py_bits_1;
				py_bits_1 = PyLong_FromLong((uint16_t)((object->bits)[bits_cntr_1]));
				PyList_SetItem(py_bits, bits_cntr_1, py_bits_1);
			}
		}
	}
	return py_bits;
}

static int py_samr_LogonHours_set_bits(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_LogonHours *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->bits));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->bits");
		return -1;
	}
	if (value == Py_None) {
		object->bits = NULL;
	} else {
		object->bits = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int bits_cntr_1;
			object->bits = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->bits, PyList_GET_SIZE(value));
			if (!object->bits) { return -1; }
			talloc_set_name_const(object->bits, "ARRAY: object->bits");
			for (bits_cntr_1 = 0; bits_cntr_1 < PyList_GET_SIZE(value); bits_cntr_1++) {
				if (PyList_GET_ITEM(value, bits_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->bits)[bits_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->bits)[bits_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, bits_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, bits_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->bits)[bits_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_samr_LogonHours_getsetters[] = {
	{
		.name = discard_const_p(char, "units_per_week"),
		.get = py_samr_LogonHours_get_units_per_week,
		.set = py_samr_LogonHours_set_units_per_week,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "bits"),
		.get = py_samr_LogonHours_get_bits,
		.set = py_samr_LogonHours_set_bits,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_samr_LogonHours_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_LogonHours, type);
}

static PyObject *py_samr_LogonHours_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct samr_LogonHours *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_samr_LogonHours);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_samr_LogonHours_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct samr_LogonHours *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_samr_LogonHours);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_samr_LogonHours);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_samr_LogonHours_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct samr_LogonHours *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_samr_LogonHours, "samr_LogonHours", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_samr_LogonHours, "samr_LogonHours", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_samr_LogonHours_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_samr_LogonHours_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_LogonHours_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_LogonHours_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_LogonHours_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.LogonHours",
	.tp_getset = py_samr_LogonHours_getsetters,
	.tp_methods = py_samr_LogonHours_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_LogonHours_new,
};


static PyObject *py_samr_UserInfo3_get_account_name(PyObject *obj, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	py_account_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->account_name);
	return py_account_name;
}

static int py_samr_UserInfo3_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->account_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->account_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo3_get_full_name(PyObject *obj, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_full_name;
	py_full_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->full_name);
	return py_full_name;
}

static int py_samr_UserInfo3_set_full_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->full_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->full_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo3_get_rid(PyObject *obj, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(object->rid));
	return py_rid;
}

static int py_samr_UserInfo3_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo3_get_primary_gid(PyObject *obj, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_primary_gid;
	py_primary_gid = PyLong_FromUnsignedLongLong((uint32_t)(object->primary_gid));
	return py_primary_gid;
}

static int py_samr_UserInfo3_set_primary_gid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->primary_gid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->primary_gid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->primary_gid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo3_get_home_directory(PyObject *obj, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_home_directory;
	py_home_directory = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->home_directory);
	return py_home_directory;
}

static int py_samr_UserInfo3_set_home_directory(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->home_directory");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->home_directory = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo3_get_home_drive(PyObject *obj, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_home_drive;
	py_home_drive = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->home_drive);
	return py_home_drive;
}

static int py_samr_UserInfo3_set_home_drive(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->home_drive");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->home_drive = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo3_get_logon_script(PyObject *obj, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_script;
	py_logon_script = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->logon_script);
	return py_logon_script;
}

static int py_samr_UserInfo3_set_logon_script(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_script");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->logon_script = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo3_get_profile_path(PyObject *obj, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_profile_path;
	py_profile_path = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->profile_path);
	return py_profile_path;
}

static int py_samr_UserInfo3_set_profile_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->profile_path");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->profile_path = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo3_get_workstations(PyObject *obj, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_workstations;
	py_workstations = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->workstations);
	return py_workstations;
}

static int py_samr_UserInfo3_set_workstations(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->workstations");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->workstations = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo3_get_last_logon(PyObject *obj, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_last_logon;
	py_last_logon = PyLong_FromUnsignedLongLong(object->last_logon);
	return py_last_logon;
}

static int py_samr_UserInfo3_set_last_logon(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_logon");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_logon));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_logon = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo3_get_last_logoff(PyObject *obj, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_last_logoff;
	py_last_logoff = PyLong_FromUnsignedLongLong(object->last_logoff);
	return py_last_logoff;
}

static int py_samr_UserInfo3_set_last_logoff(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_logoff");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_logoff));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_logoff = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo3_get_last_password_change(PyObject *obj, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_last_password_change;
	py_last_password_change = PyLong_FromUnsignedLongLong(object->last_password_change);
	return py_last_password_change;
}

static int py_samr_UserInfo3_set_last_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_password_change");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_password_change));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_password_change = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo3_get_allow_password_change(PyObject *obj, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_allow_password_change;
	py_allow_password_change = PyLong_FromUnsignedLongLong(object->allow_password_change);
	return py_allow_password_change;
}

static int py_samr_UserInfo3_set_allow_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->allow_password_change");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->allow_password_change));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->allow_password_change = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo3_get_force_password_change(PyObject *obj, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_force_password_change;
	py_force_password_change = PyLong_FromUnsignedLongLong(object->force_password_change);
	return py_force_password_change;
}

static int py_samr_UserInfo3_set_force_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->force_password_change");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->force_password_change));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->force_password_change = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo3_get_logon_hours(PyObject *obj, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_hours;
	py_logon_hours = pytalloc_reference_ex(&samr_LogonHours_Type, pytalloc_get_mem_ctx(obj), &object->logon_hours);
	return py_logon_hours;
}

static int py_samr_UserInfo3_set_logon_hours(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_hours");
		return -1;
	}
	PY_CHECK_TYPE(&samr_LogonHours_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->logon_hours = *(struct samr_LogonHours *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo3_get_bad_password_count(PyObject *obj, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_bad_password_count;
	py_bad_password_count = PyLong_FromLong((uint16_t)(object->bad_password_count));
	return py_bad_password_count;
}

static int py_samr_UserInfo3_set_bad_password_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->bad_password_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->bad_password_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->bad_password_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo3_get_logon_count(PyObject *obj, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_count;
	py_logon_count = PyLong_FromLong((uint16_t)(object->logon_count));
	return py_logon_count;
}

static int py_samr_UserInfo3_set_logon_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->logon_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->logon_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo3_get_acct_flags(PyObject *obj, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(obj);
	PyObject *py_acct_flags;
	py_acct_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->acct_flags));
	return py_acct_flags;
}

static int py_samr_UserInfo3_set_acct_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->acct_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->acct_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->acct_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_UserInfo3_getsetters[] = {
	{
		.name = discard_const_p(char, "account_name"),
		.get = py_samr_UserInfo3_get_account_name,
		.set = py_samr_UserInfo3_set_account_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "full_name"),
		.get = py_samr_UserInfo3_get_full_name,
		.set = py_samr_UserInfo3_set_full_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "rid"),
		.get = py_samr_UserInfo3_get_rid,
		.set = py_samr_UserInfo3_set_rid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "primary_gid"),
		.get = py_samr_UserInfo3_get_primary_gid,
		.set = py_samr_UserInfo3_set_primary_gid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "home_directory"),
		.get = py_samr_UserInfo3_get_home_directory,
		.set = py_samr_UserInfo3_set_home_directory,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "home_drive"),
		.get = py_samr_UserInfo3_get_home_drive,
		.set = py_samr_UserInfo3_set_home_drive,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "logon_script"),
		.get = py_samr_UserInfo3_get_logon_script,
		.set = py_samr_UserInfo3_set_logon_script,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "profile_path"),
		.get = py_samr_UserInfo3_get_profile_path,
		.set = py_samr_UserInfo3_set_profile_path,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "workstations"),
		.get = py_samr_UserInfo3_get_workstations,
		.set = py_samr_UserInfo3_set_workstations,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "last_logon"),
		.get = py_samr_UserInfo3_get_last_logon,
		.set = py_samr_UserInfo3_set_last_logon,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "last_logoff"),
		.get = py_samr_UserInfo3_get_last_logoff,
		.set = py_samr_UserInfo3_set_last_logoff,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "last_password_change"),
		.get = py_samr_UserInfo3_get_last_password_change,
		.set = py_samr_UserInfo3_set_last_password_change,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "allow_password_change"),
		.get = py_samr_UserInfo3_get_allow_password_change,
		.set = py_samr_UserInfo3_set_allow_password_change,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "force_password_change"),
		.get = py_samr_UserInfo3_get_force_password_change,
		.set = py_samr_UserInfo3_set_force_password_change,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "logon_hours"),
		.get = py_samr_UserInfo3_get_logon_hours,
		.set = py_samr_UserInfo3_set_logon_hours,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_LogonHours")
	},
	{
		.name = discard_const_p(char, "bad_password_count"),
		.get = py_samr_UserInfo3_get_bad_password_count,
		.set = py_samr_UserInfo3_set_bad_password_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "logon_count"),
		.get = py_samr_UserInfo3_get_logon_count,
		.set = py_samr_UserInfo3_set_logon_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "acct_flags"),
		.get = py_samr_UserInfo3_get_acct_flags,
		.set = py_samr_UserInfo3_set_acct_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_AcctFlags")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo3, type);
}


static PyTypeObject samr_UserInfo3_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo3",
	.tp_getset = py_samr_UserInfo3_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo3_new,
};


static PyObject *py_samr_UserInfo4_get_logon_hours(PyObject *obj, void *closure)
{
	struct samr_UserInfo4 *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_hours;
	py_logon_hours = pytalloc_reference_ex(&samr_LogonHours_Type, pytalloc_get_mem_ctx(obj), &object->logon_hours);
	return py_logon_hours;
}

static int py_samr_UserInfo4_set_logon_hours(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo4 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_hours");
		return -1;
	}
	PY_CHECK_TYPE(&samr_LogonHours_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->logon_hours = *(struct samr_LogonHours *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_UserInfo4_getsetters[] = {
	{
		.name = discard_const_p(char, "logon_hours"),
		.get = py_samr_UserInfo4_get_logon_hours,
		.set = py_samr_UserInfo4_set_logon_hours,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_LogonHours")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo4_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo4, type);
}


static PyTypeObject samr_UserInfo4_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo4",
	.tp_getset = py_samr_UserInfo4_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo4_new,
};


static PyObject *py_samr_UserInfo5_get_account_name(PyObject *obj, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	py_account_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->account_name);
	return py_account_name;
}

static int py_samr_UserInfo5_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->account_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->account_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo5_get_full_name(PyObject *obj, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(obj);
	PyObject *py_full_name;
	py_full_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->full_name);
	return py_full_name;
}

static int py_samr_UserInfo5_set_full_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->full_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->full_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo5_get_rid(PyObject *obj, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(object->rid));
	return py_rid;
}

static int py_samr_UserInfo5_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo5_get_primary_gid(PyObject *obj, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(obj);
	PyObject *py_primary_gid;
	py_primary_gid = PyLong_FromUnsignedLongLong((uint32_t)(object->primary_gid));
	return py_primary_gid;
}

static int py_samr_UserInfo5_set_primary_gid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->primary_gid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->primary_gid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->primary_gid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo5_get_home_directory(PyObject *obj, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(obj);
	PyObject *py_home_directory;
	py_home_directory = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->home_directory);
	return py_home_directory;
}

static int py_samr_UserInfo5_set_home_directory(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->home_directory");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->home_directory = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo5_get_home_drive(PyObject *obj, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(obj);
	PyObject *py_home_drive;
	py_home_drive = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->home_drive);
	return py_home_drive;
}

static int py_samr_UserInfo5_set_home_drive(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->home_drive");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->home_drive = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo5_get_logon_script(PyObject *obj, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_script;
	py_logon_script = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->logon_script);
	return py_logon_script;
}

static int py_samr_UserInfo5_set_logon_script(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_script");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->logon_script = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo5_get_profile_path(PyObject *obj, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(obj);
	PyObject *py_profile_path;
	py_profile_path = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->profile_path);
	return py_profile_path;
}

static int py_samr_UserInfo5_set_profile_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->profile_path");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->profile_path = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo5_get_description(PyObject *obj, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(obj);
	PyObject *py_description;
	py_description = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->description);
	return py_description;
}

static int py_samr_UserInfo5_set_description(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->description");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->description = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo5_get_workstations(PyObject *obj, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(obj);
	PyObject *py_workstations;
	py_workstations = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->workstations);
	return py_workstations;
}

static int py_samr_UserInfo5_set_workstations(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->workstations");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->workstations = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo5_get_last_logon(PyObject *obj, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(obj);
	PyObject *py_last_logon;
	py_last_logon = PyLong_FromUnsignedLongLong(object->last_logon);
	return py_last_logon;
}

static int py_samr_UserInfo5_set_last_logon(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_logon");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_logon));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_logon = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo5_get_last_logoff(PyObject *obj, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(obj);
	PyObject *py_last_logoff;
	py_last_logoff = PyLong_FromUnsignedLongLong(object->last_logoff);
	return py_last_logoff;
}

static int py_samr_UserInfo5_set_last_logoff(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_logoff");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_logoff));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_logoff = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo5_get_logon_hours(PyObject *obj, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_hours;
	py_logon_hours = pytalloc_reference_ex(&samr_LogonHours_Type, pytalloc_get_mem_ctx(obj), &object->logon_hours);
	return py_logon_hours;
}

static int py_samr_UserInfo5_set_logon_hours(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_hours");
		return -1;
	}
	PY_CHECK_TYPE(&samr_LogonHours_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->logon_hours = *(struct samr_LogonHours *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo5_get_bad_password_count(PyObject *obj, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(obj);
	PyObject *py_bad_password_count;
	py_bad_password_count = PyLong_FromLong((uint16_t)(object->bad_password_count));
	return py_bad_password_count;
}

static int py_samr_UserInfo5_set_bad_password_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->bad_password_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->bad_password_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->bad_password_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo5_get_logon_count(PyObject *obj, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_count;
	py_logon_count = PyLong_FromLong((uint16_t)(object->logon_count));
	return py_logon_count;
}

static int py_samr_UserInfo5_set_logon_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->logon_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->logon_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo5_get_last_password_change(PyObject *obj, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(obj);
	PyObject *py_last_password_change;
	py_last_password_change = PyLong_FromUnsignedLongLong(object->last_password_change);
	return py_last_password_change;
}

static int py_samr_UserInfo5_set_last_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_password_change");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_password_change));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_password_change = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo5_get_acct_expiry(PyObject *obj, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(obj);
	PyObject *py_acct_expiry;
	py_acct_expiry = PyLong_FromUnsignedLongLong(object->acct_expiry);
	return py_acct_expiry;
}

static int py_samr_UserInfo5_set_acct_expiry(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->acct_expiry");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->acct_expiry));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->acct_expiry = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo5_get_acct_flags(PyObject *obj, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(obj);
	PyObject *py_acct_flags;
	py_acct_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->acct_flags));
	return py_acct_flags;
}

static int py_samr_UserInfo5_set_acct_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo5 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->acct_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->acct_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->acct_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_UserInfo5_getsetters[] = {
	{
		.name = discard_const_p(char, "account_name"),
		.get = py_samr_UserInfo5_get_account_name,
		.set = py_samr_UserInfo5_set_account_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "full_name"),
		.get = py_samr_UserInfo5_get_full_name,
		.set = py_samr_UserInfo5_set_full_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "rid"),
		.get = py_samr_UserInfo5_get_rid,
		.set = py_samr_UserInfo5_set_rid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "primary_gid"),
		.get = py_samr_UserInfo5_get_primary_gid,
		.set = py_samr_UserInfo5_set_primary_gid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "home_directory"),
		.get = py_samr_UserInfo5_get_home_directory,
		.set = py_samr_UserInfo5_set_home_directory,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "home_drive"),
		.get = py_samr_UserInfo5_get_home_drive,
		.set = py_samr_UserInfo5_set_home_drive,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "logon_script"),
		.get = py_samr_UserInfo5_get_logon_script,
		.set = py_samr_UserInfo5_set_logon_script,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "profile_path"),
		.get = py_samr_UserInfo5_get_profile_path,
		.set = py_samr_UserInfo5_set_profile_path,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "description"),
		.get = py_samr_UserInfo5_get_description,
		.set = py_samr_UserInfo5_set_description,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "workstations"),
		.get = py_samr_UserInfo5_get_workstations,
		.set = py_samr_UserInfo5_set_workstations,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "last_logon"),
		.get = py_samr_UserInfo5_get_last_logon,
		.set = py_samr_UserInfo5_set_last_logon,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "last_logoff"),
		.get = py_samr_UserInfo5_get_last_logoff,
		.set = py_samr_UserInfo5_set_last_logoff,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "logon_hours"),
		.get = py_samr_UserInfo5_get_logon_hours,
		.set = py_samr_UserInfo5_set_logon_hours,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_LogonHours")
	},
	{
		.name = discard_const_p(char, "bad_password_count"),
		.get = py_samr_UserInfo5_get_bad_password_count,
		.set = py_samr_UserInfo5_set_bad_password_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "logon_count"),
		.get = py_samr_UserInfo5_get_logon_count,
		.set = py_samr_UserInfo5_set_logon_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "last_password_change"),
		.get = py_samr_UserInfo5_get_last_password_change,
		.set = py_samr_UserInfo5_set_last_password_change,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "acct_expiry"),
		.get = py_samr_UserInfo5_get_acct_expiry,
		.set = py_samr_UserInfo5_set_acct_expiry,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "acct_flags"),
		.get = py_samr_UserInfo5_get_acct_flags,
		.set = py_samr_UserInfo5_set_acct_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_AcctFlags")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo5_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo5, type);
}


static PyTypeObject samr_UserInfo5_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo5",
	.tp_getset = py_samr_UserInfo5_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo5_new,
};


static PyObject *py_samr_UserInfo6_get_account_name(PyObject *obj, void *closure)
{
	struct samr_UserInfo6 *object = pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	py_account_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->account_name);
	return py_account_name;
}

static int py_samr_UserInfo6_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->account_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->account_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo6_get_full_name(PyObject *obj, void *closure)
{
	struct samr_UserInfo6 *object = pytalloc_get_ptr(obj);
	PyObject *py_full_name;
	py_full_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->full_name);
	return py_full_name;
}

static int py_samr_UserInfo6_set_full_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo6 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->full_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->full_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_UserInfo6_getsetters[] = {
	{
		.name = discard_const_p(char, "account_name"),
		.get = py_samr_UserInfo6_get_account_name,
		.set = py_samr_UserInfo6_set_account_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "full_name"),
		.get = py_samr_UserInfo6_get_full_name,
		.set = py_samr_UserInfo6_set_full_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo6_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo6, type);
}


static PyTypeObject samr_UserInfo6_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo6",
	.tp_getset = py_samr_UserInfo6_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo6_new,
};


static PyObject *py_samr_UserInfo7_get_account_name(PyObject *obj, void *closure)
{
	struct samr_UserInfo7 *object = pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	py_account_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->account_name);
	return py_account_name;
}

static int py_samr_UserInfo7_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo7 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->account_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->account_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_UserInfo7_getsetters[] = {
	{
		.name = discard_const_p(char, "account_name"),
		.get = py_samr_UserInfo7_get_account_name,
		.set = py_samr_UserInfo7_set_account_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo7_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo7, type);
}


static PyTypeObject samr_UserInfo7_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo7",
	.tp_getset = py_samr_UserInfo7_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo7_new,
};


static PyObject *py_samr_UserInfo8_get_full_name(PyObject *obj, void *closure)
{
	struct samr_UserInfo8 *object = pytalloc_get_ptr(obj);
	PyObject *py_full_name;
	py_full_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->full_name);
	return py_full_name;
}

static int py_samr_UserInfo8_set_full_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo8 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->full_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->full_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_UserInfo8_getsetters[] = {
	{
		.name = discard_const_p(char, "full_name"),
		.get = py_samr_UserInfo8_get_full_name,
		.set = py_samr_UserInfo8_set_full_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo8_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo8, type);
}


static PyTypeObject samr_UserInfo8_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo8",
	.tp_getset = py_samr_UserInfo8_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo8_new,
};


static PyObject *py_samr_UserInfo9_get_primary_gid(PyObject *obj, void *closure)
{
	struct samr_UserInfo9 *object = pytalloc_get_ptr(obj);
	PyObject *py_primary_gid;
	py_primary_gid = PyLong_FromUnsignedLongLong((uint32_t)(object->primary_gid));
	return py_primary_gid;
}

static int py_samr_UserInfo9_set_primary_gid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo9 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->primary_gid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->primary_gid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->primary_gid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_UserInfo9_getsetters[] = {
	{
		.name = discard_const_p(char, "primary_gid"),
		.get = py_samr_UserInfo9_get_primary_gid,
		.set = py_samr_UserInfo9_set_primary_gid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo9_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo9, type);
}


static PyTypeObject samr_UserInfo9_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo9",
	.tp_getset = py_samr_UserInfo9_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo9_new,
};


static PyObject *py_samr_UserInfo10_get_home_directory(PyObject *obj, void *closure)
{
	struct samr_UserInfo10 *object = pytalloc_get_ptr(obj);
	PyObject *py_home_directory;
	py_home_directory = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->home_directory);
	return py_home_directory;
}

static int py_samr_UserInfo10_set_home_directory(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo10 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->home_directory");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->home_directory = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo10_get_home_drive(PyObject *obj, void *closure)
{
	struct samr_UserInfo10 *object = pytalloc_get_ptr(obj);
	PyObject *py_home_drive;
	py_home_drive = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->home_drive);
	return py_home_drive;
}

static int py_samr_UserInfo10_set_home_drive(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo10 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->home_drive");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->home_drive = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_UserInfo10_getsetters[] = {
	{
		.name = discard_const_p(char, "home_directory"),
		.get = py_samr_UserInfo10_get_home_directory,
		.set = py_samr_UserInfo10_set_home_directory,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "home_drive"),
		.get = py_samr_UserInfo10_get_home_drive,
		.set = py_samr_UserInfo10_set_home_drive,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo10_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo10, type);
}


static PyTypeObject samr_UserInfo10_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo10",
	.tp_getset = py_samr_UserInfo10_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo10_new,
};


static PyObject *py_samr_UserInfo11_get_logon_script(PyObject *obj, void *closure)
{
	struct samr_UserInfo11 *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_script;
	py_logon_script = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->logon_script);
	return py_logon_script;
}

static int py_samr_UserInfo11_set_logon_script(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo11 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_script");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->logon_script = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_UserInfo11_getsetters[] = {
	{
		.name = discard_const_p(char, "logon_script"),
		.get = py_samr_UserInfo11_get_logon_script,
		.set = py_samr_UserInfo11_set_logon_script,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo11_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo11, type);
}


static PyTypeObject samr_UserInfo11_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo11",
	.tp_getset = py_samr_UserInfo11_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo11_new,
};


static PyObject *py_samr_UserInfo12_get_profile_path(PyObject *obj, void *closure)
{
	struct samr_UserInfo12 *object = pytalloc_get_ptr(obj);
	PyObject *py_profile_path;
	py_profile_path = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->profile_path);
	return py_profile_path;
}

static int py_samr_UserInfo12_set_profile_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo12 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->profile_path");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->profile_path = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_UserInfo12_getsetters[] = {
	{
		.name = discard_const_p(char, "profile_path"),
		.get = py_samr_UserInfo12_get_profile_path,
		.set = py_samr_UserInfo12_set_profile_path,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo12_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo12, type);
}


static PyTypeObject samr_UserInfo12_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo12",
	.tp_getset = py_samr_UserInfo12_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo12_new,
};


static PyObject *py_samr_UserInfo13_get_description(PyObject *obj, void *closure)
{
	struct samr_UserInfo13 *object = pytalloc_get_ptr(obj);
	PyObject *py_description;
	py_description = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->description);
	return py_description;
}

static int py_samr_UserInfo13_set_description(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo13 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->description");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->description = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_UserInfo13_getsetters[] = {
	{
		.name = discard_const_p(char, "description"),
		.get = py_samr_UserInfo13_get_description,
		.set = py_samr_UserInfo13_set_description,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo13_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo13, type);
}


static PyTypeObject samr_UserInfo13_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo13",
	.tp_getset = py_samr_UserInfo13_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo13_new,
};


static PyObject *py_samr_UserInfo14_get_workstations(PyObject *obj, void *closure)
{
	struct samr_UserInfo14 *object = pytalloc_get_ptr(obj);
	PyObject *py_workstations;
	py_workstations = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->workstations);
	return py_workstations;
}

static int py_samr_UserInfo14_set_workstations(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo14 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->workstations");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->workstations = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_UserInfo14_getsetters[] = {
	{
		.name = discard_const_p(char, "workstations"),
		.get = py_samr_UserInfo14_get_workstations,
		.set = py_samr_UserInfo14_set_workstations,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo14_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo14, type);
}


static PyTypeObject samr_UserInfo14_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo14",
	.tp_getset = py_samr_UserInfo14_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo14_new,
};


static PyObject *py_samr_UserInfo16_get_acct_flags(PyObject *obj, void *closure)
{
	struct samr_UserInfo16 *object = pytalloc_get_ptr(obj);
	PyObject *py_acct_flags;
	py_acct_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->acct_flags));
	return py_acct_flags;
}

static int py_samr_UserInfo16_set_acct_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo16 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->acct_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->acct_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->acct_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_UserInfo16_getsetters[] = {
	{
		.name = discard_const_p(char, "acct_flags"),
		.get = py_samr_UserInfo16_get_acct_flags,
		.set = py_samr_UserInfo16_set_acct_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_AcctFlags")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo16_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo16, type);
}


static PyTypeObject samr_UserInfo16_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo16",
	.tp_getset = py_samr_UserInfo16_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo16_new,
};


static PyObject *py_samr_UserInfo17_get_acct_expiry(PyObject *obj, void *closure)
{
	struct samr_UserInfo17 *object = pytalloc_get_ptr(obj);
	PyObject *py_acct_expiry;
	py_acct_expiry = PyLong_FromUnsignedLongLong(object->acct_expiry);
	return py_acct_expiry;
}

static int py_samr_UserInfo17_set_acct_expiry(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo17 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->acct_expiry");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->acct_expiry));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->acct_expiry = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_UserInfo17_getsetters[] = {
	{
		.name = discard_const_p(char, "acct_expiry"),
		.get = py_samr_UserInfo17_get_acct_expiry,
		.set = py_samr_UserInfo17_set_acct_expiry,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo17_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo17, type);
}


static PyTypeObject samr_UserInfo17_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo17",
	.tp_getset = py_samr_UserInfo17_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo17_new,
};


static PyObject *py_samr_Password_get_hash(PyObject *obj, void *closure)
{
	struct samr_Password *object = pytalloc_get_ptr(obj);
	PyObject *py_hash;
	py_hash = PyList_New(16);
	if (py_hash == NULL) {
		return NULL;
	}
	{
		int hash_cntr_0;
		for (hash_cntr_0 = 0; hash_cntr_0 < (16); hash_cntr_0++) {
			PyObject *py_hash_0;
			py_hash_0 = PyLong_FromLong((uint16_t)((object->hash)[hash_cntr_0]));
			PyList_SetItem(py_hash, hash_cntr_0, py_hash_0);
		}
	}
	return py_hash;
}

static int py_samr_Password_set_hash(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_Password *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->hash");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int hash_cntr_0;
		if (ARRAY_SIZE(object->hash) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->hash),  PyList_GET_SIZE(value));
			return -1;
		}
		for (hash_cntr_0 = 0; hash_cntr_0 < PyList_GET_SIZE(value); hash_cntr_0++) {
			if (PyList_GET_ITEM(value, hash_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->hash)[hash_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->hash)[hash_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, hash_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, hash_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->hash)[hash_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_samr_Password_getsetters[] = {
	{
		.name = discard_const_p(char, "hash"),
		.get = py_samr_Password_get_hash,
		.set = py_samr_Password_set_hash,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_samr_Password_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_Password, type);
}

static PyObject *py_samr_Password_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct samr_Password *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_samr_Password);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_samr_Password_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct samr_Password *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_samr_Password);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_samr_Password);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_samr_Password_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct samr_Password *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_samr_Password, "samr_Password", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_samr_Password, "samr_Password", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_samr_Password_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_samr_Password_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_Password_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_Password_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_Password_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.Password",
	.tp_getset = py_samr_Password_getsetters,
	.tp_methods = py_samr_Password_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_Password_new,
};


static PyObject *py_samr_UserInfo18_get_nt_pwd(PyObject *obj, void *closure)
{
	struct samr_UserInfo18 *object = pytalloc_get_ptr(obj);
	PyObject *py_nt_pwd;
	py_nt_pwd = pytalloc_reference_ex(&samr_Password_Type, pytalloc_get_mem_ctx(obj), &object->nt_pwd);
	return py_nt_pwd;
}

static int py_samr_UserInfo18_set_nt_pwd(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo18 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nt_pwd");
		return -1;
	}
	PY_CHECK_TYPE(&samr_Password_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->nt_pwd = *(struct samr_Password *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo18_get_lm_pwd(PyObject *obj, void *closure)
{
	struct samr_UserInfo18 *object = pytalloc_get_ptr(obj);
	PyObject *py_lm_pwd;
	py_lm_pwd = pytalloc_reference_ex(&samr_Password_Type, pytalloc_get_mem_ctx(obj), &object->lm_pwd);
	return py_lm_pwd;
}

static int py_samr_UserInfo18_set_lm_pwd(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo18 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lm_pwd");
		return -1;
	}
	PY_CHECK_TYPE(&samr_Password_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->lm_pwd = *(struct samr_Password *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo18_get_nt_pwd_active(PyObject *obj, void *closure)
{
	struct samr_UserInfo18 *object = pytalloc_get_ptr(obj);
	PyObject *py_nt_pwd_active;
	py_nt_pwd_active = PyLong_FromLong((uint16_t)(object->nt_pwd_active));
	return py_nt_pwd_active;
}

static int py_samr_UserInfo18_set_nt_pwd_active(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo18 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nt_pwd_active");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nt_pwd_active));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nt_pwd_active = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo18_get_lm_pwd_active(PyObject *obj, void *closure)
{
	struct samr_UserInfo18 *object = pytalloc_get_ptr(obj);
	PyObject *py_lm_pwd_active;
	py_lm_pwd_active = PyLong_FromLong((uint16_t)(object->lm_pwd_active));
	return py_lm_pwd_active;
}

static int py_samr_UserInfo18_set_lm_pwd_active(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo18 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lm_pwd_active");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lm_pwd_active));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lm_pwd_active = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo18_get_password_expired(PyObject *obj, void *closure)
{
	struct samr_UserInfo18 *object = pytalloc_get_ptr(obj);
	PyObject *py_password_expired;
	py_password_expired = PyLong_FromLong((uint16_t)(object->password_expired));
	return py_password_expired;
}

static int py_samr_UserInfo18_set_password_expired(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo18 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password_expired");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->password_expired));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->password_expired = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_UserInfo18_getsetters[] = {
	{
		.name = discard_const_p(char, "nt_pwd"),
		.get = py_samr_UserInfo18_get_nt_pwd,
		.set = py_samr_UserInfo18_set_nt_pwd,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_Password")
	},
	{
		.name = discard_const_p(char, "lm_pwd"),
		.get = py_samr_UserInfo18_get_lm_pwd,
		.set = py_samr_UserInfo18_set_lm_pwd,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_Password")
	},
	{
		.name = discard_const_p(char, "nt_pwd_active"),
		.get = py_samr_UserInfo18_get_nt_pwd_active,
		.set = py_samr_UserInfo18_set_nt_pwd_active,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "lm_pwd_active"),
		.get = py_samr_UserInfo18_get_lm_pwd_active,
		.set = py_samr_UserInfo18_set_lm_pwd_active,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "password_expired"),
		.get = py_samr_UserInfo18_get_password_expired,
		.set = py_samr_UserInfo18_set_password_expired,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo18_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo18, type);
}


static PyTypeObject samr_UserInfo18_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo18",
	.tp_getset = py_samr_UserInfo18_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo18_new,
};


static PyObject *py_samr_UserInfo20_get_parameters(PyObject *obj, void *closure)
{
	struct samr_UserInfo20 *object = pytalloc_get_ptr(obj);
	PyObject *py_parameters;
	py_parameters = pytalloc_reference_ex(lsa_BinaryString_Type, pytalloc_get_mem_ctx(obj), &object->parameters);
	return py_parameters;
}

static int py_samr_UserInfo20_set_parameters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo20 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->parameters");
		return -1;
	}
	PY_CHECK_TYPE(lsa_BinaryString_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->parameters = *(struct lsa_BinaryString *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_UserInfo20_getsetters[] = {
	{
		.name = discard_const_p(char, "parameters"),
		.get = py_samr_UserInfo20_get_parameters,
		.set = py_samr_UserInfo20_set_parameters,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_BinaryString")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo20_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo20, type);
}


static PyTypeObject samr_UserInfo20_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo20",
	.tp_getset = py_samr_UserInfo20_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo20_new,
};


static PyObject *py_samr_UserInfo21_get_last_logon(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_last_logon;
	py_last_logon = PyLong_FromUnsignedLongLong(object->last_logon);
	return py_last_logon;
}

static int py_samr_UserInfo21_set_last_logon(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_logon");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_logon));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_logon = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo21_get_last_logoff(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_last_logoff;
	py_last_logoff = PyLong_FromUnsignedLongLong(object->last_logoff);
	return py_last_logoff;
}

static int py_samr_UserInfo21_set_last_logoff(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_logoff");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_logoff));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_logoff = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo21_get_last_password_change(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_last_password_change;
	py_last_password_change = PyLong_FromUnsignedLongLong(object->last_password_change);
	return py_last_password_change;
}

static int py_samr_UserInfo21_set_last_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_password_change");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_password_change));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_password_change = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo21_get_acct_expiry(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_acct_expiry;
	py_acct_expiry = PyLong_FromUnsignedLongLong(object->acct_expiry);
	return py_acct_expiry;
}

static int py_samr_UserInfo21_set_acct_expiry(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->acct_expiry");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->acct_expiry));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->acct_expiry = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo21_get_allow_password_change(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_allow_password_change;
	py_allow_password_change = PyLong_FromUnsignedLongLong(object->allow_password_change);
	return py_allow_password_change;
}

static int py_samr_UserInfo21_set_allow_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->allow_password_change");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->allow_password_change));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->allow_password_change = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo21_get_force_password_change(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_force_password_change;
	py_force_password_change = PyLong_FromUnsignedLongLong(object->force_password_change);
	return py_force_password_change;
}

static int py_samr_UserInfo21_set_force_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->force_password_change");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->force_password_change));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->force_password_change = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo21_get_account_name(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	py_account_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->account_name);
	return py_account_name;
}

static int py_samr_UserInfo21_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->account_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->account_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo21_get_full_name(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_full_name;
	py_full_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->full_name);
	return py_full_name;
}

static int py_samr_UserInfo21_set_full_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->full_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->full_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo21_get_home_directory(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_home_directory;
	py_home_directory = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->home_directory);
	return py_home_directory;
}

static int py_samr_UserInfo21_set_home_directory(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->home_directory");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->home_directory = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo21_get_home_drive(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_home_drive;
	py_home_drive = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->home_drive);
	return py_home_drive;
}

static int py_samr_UserInfo21_set_home_drive(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->home_drive");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->home_drive = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo21_get_logon_script(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_script;
	py_logon_script = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->logon_script);
	return py_logon_script;
}

static int py_samr_UserInfo21_set_logon_script(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_script");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->logon_script = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo21_get_profile_path(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_profile_path;
	py_profile_path = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->profile_path);
	return py_profile_path;
}

static int py_samr_UserInfo21_set_profile_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->profile_path");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->profile_path = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo21_get_description(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_description;
	py_description = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->description);
	return py_description;
}

static int py_samr_UserInfo21_set_description(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->description");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->description = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo21_get_workstations(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_workstations;
	py_workstations = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->workstations);
	return py_workstations;
}

static int py_samr_UserInfo21_set_workstations(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->workstations");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->workstations = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo21_get_comment(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_comment;
	py_comment = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->comment);
	return py_comment;
}

static int py_samr_UserInfo21_set_comment(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->comment");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->comment = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo21_get_parameters(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_parameters;
	py_parameters = pytalloc_reference_ex(lsa_BinaryString_Type, pytalloc_get_mem_ctx(obj), &object->parameters);
	return py_parameters;
}

static int py_samr_UserInfo21_set_parameters(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->parameters");
		return -1;
	}
	PY_CHECK_TYPE(lsa_BinaryString_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->parameters = *(struct lsa_BinaryString *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo21_get_lm_owf_password(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_lm_owf_password;
	py_lm_owf_password = pytalloc_reference_ex(lsa_BinaryString_Type, pytalloc_get_mem_ctx(obj), &object->lm_owf_password);
	return py_lm_owf_password;
}

static int py_samr_UserInfo21_set_lm_owf_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lm_owf_password");
		return -1;
	}
	PY_CHECK_TYPE(lsa_BinaryString_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->lm_owf_password = *(struct lsa_BinaryString *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo21_get_nt_owf_password(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_nt_owf_password;
	py_nt_owf_password = pytalloc_reference_ex(lsa_BinaryString_Type, pytalloc_get_mem_ctx(obj), &object->nt_owf_password);
	return py_nt_owf_password;
}

static int py_samr_UserInfo21_set_nt_owf_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nt_owf_password");
		return -1;
	}
	PY_CHECK_TYPE(lsa_BinaryString_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->nt_owf_password = *(struct lsa_BinaryString *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo21_get_private_data(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_private_data;
	py_private_data = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->private_data);
	return py_private_data;
}

static int py_samr_UserInfo21_set_private_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->private_data");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->private_data = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo21_get_buf_count(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_buf_count;
	py_buf_count = PyLong_FromUnsignedLongLong((uint32_t)(object->buf_count));
	return py_buf_count;
}

static int py_samr_UserInfo21_set_buf_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->buf_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->buf_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->buf_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo21_get_buffer(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_buffer;
	if (object->buffer == NULL) {
		Py_RETURN_NONE;
	}
	if (object->buffer == NULL) {
		py_buffer = Py_None;
		Py_INCREF(py_buffer);
	} else {
		py_buffer = PyList_New(object->buf_count);
		if (py_buffer == NULL) {
			return NULL;
		}
		{
			int buffer_cntr_1;
			for (buffer_cntr_1 = 0; buffer_cntr_1 < (object->buf_count); buffer_cntr_1++) {
				PyObject *py_buffer_1;
				py_buffer_1 = PyLong_FromLong((uint16_t)((object->buffer)[buffer_cntr_1]));
				PyList_SetItem(py_buffer, buffer_cntr_1, py_buffer_1);
			}
		}
	}
	return py_buffer;
}

static int py_samr_UserInfo21_set_buffer(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->buffer));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->buffer");
		return -1;
	}
	if (value == Py_None) {
		object->buffer = NULL;
	} else {
		object->buffer = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int buffer_cntr_1;
			object->buffer = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->buffer, PyList_GET_SIZE(value));
			if (!object->buffer) { return -1; }
			talloc_set_name_const(object->buffer, "ARRAY: object->buffer");
			for (buffer_cntr_1 = 0; buffer_cntr_1 < PyList_GET_SIZE(value); buffer_cntr_1++) {
				if (PyList_GET_ITEM(value, buffer_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->buffer)[buffer_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->buffer)[buffer_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, buffer_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, buffer_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->buffer)[buffer_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo21_get_rid(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(object->rid));
	return py_rid;
}

static int py_samr_UserInfo21_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo21_get_primary_gid(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_primary_gid;
	py_primary_gid = PyLong_FromUnsignedLongLong((uint32_t)(object->primary_gid));
	return py_primary_gid;
}

static int py_samr_UserInfo21_set_primary_gid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->primary_gid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->primary_gid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->primary_gid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo21_get_acct_flags(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_acct_flags;
	py_acct_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->acct_flags));
	return py_acct_flags;
}

static int py_samr_UserInfo21_set_acct_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->acct_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->acct_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->acct_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo21_get_fields_present(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_fields_present;
	py_fields_present = PyLong_FromUnsignedLongLong((uint32_t)(object->fields_present));
	return py_fields_present;
}

static int py_samr_UserInfo21_set_fields_present(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fields_present");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fields_present));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fields_present = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo21_get_logon_hours(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_hours;
	py_logon_hours = pytalloc_reference_ex(&samr_LogonHours_Type, pytalloc_get_mem_ctx(obj), &object->logon_hours);
	return py_logon_hours;
}

static int py_samr_UserInfo21_set_logon_hours(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_hours");
		return -1;
	}
	PY_CHECK_TYPE(&samr_LogonHours_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->logon_hours = *(struct samr_LogonHours *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo21_get_bad_password_count(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_bad_password_count;
	py_bad_password_count = PyLong_FromLong((uint16_t)(object->bad_password_count));
	return py_bad_password_count;
}

static int py_samr_UserInfo21_set_bad_password_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->bad_password_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->bad_password_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->bad_password_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo21_get_logon_count(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_count;
	py_logon_count = PyLong_FromLong((uint16_t)(object->logon_count));
	return py_logon_count;
}

static int py_samr_UserInfo21_set_logon_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->logon_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->logon_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo21_get_country_code(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_country_code;
	py_country_code = PyLong_FromLong((uint16_t)(object->country_code));
	return py_country_code;
}

static int py_samr_UserInfo21_set_country_code(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->country_code");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->country_code));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->country_code = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo21_get_code_page(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_code_page;
	py_code_page = PyLong_FromLong((uint16_t)(object->code_page));
	return py_code_page;
}

static int py_samr_UserInfo21_set_code_page(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->code_page");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->code_page));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->code_page = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo21_get_lm_password_set(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_lm_password_set;
	py_lm_password_set = PyLong_FromLong((uint16_t)(object->lm_password_set));
	return py_lm_password_set;
}

static int py_samr_UserInfo21_set_lm_password_set(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lm_password_set");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lm_password_set));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lm_password_set = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo21_get_nt_password_set(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_nt_password_set;
	py_nt_password_set = PyLong_FromLong((uint16_t)(object->nt_password_set));
	return py_nt_password_set;
}

static int py_samr_UserInfo21_set_nt_password_set(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->nt_password_set");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->nt_password_set));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->nt_password_set = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo21_get_password_expired(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_password_expired;
	py_password_expired = PyLong_FromLong((uint16_t)(object->password_expired));
	return py_password_expired;
}

static int py_samr_UserInfo21_set_password_expired(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password_expired");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->password_expired));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->password_expired = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_UserInfo21_get_private_data_sensitive(PyObject *obj, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(obj);
	PyObject *py_private_data_sensitive;
	py_private_data_sensitive = PyLong_FromLong((uint16_t)(object->private_data_sensitive));
	return py_private_data_sensitive;
}

static int py_samr_UserInfo21_set_private_data_sensitive(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo21 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->private_data_sensitive");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->private_data_sensitive));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->private_data_sensitive = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_UserInfo21_getsetters[] = {
	{
		.name = discard_const_p(char, "last_logon"),
		.get = py_samr_UserInfo21_get_last_logon,
		.set = py_samr_UserInfo21_set_last_logon,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "last_logoff"),
		.get = py_samr_UserInfo21_get_last_logoff,
		.set = py_samr_UserInfo21_set_last_logoff,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "last_password_change"),
		.get = py_samr_UserInfo21_get_last_password_change,
		.set = py_samr_UserInfo21_set_last_password_change,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "acct_expiry"),
		.get = py_samr_UserInfo21_get_acct_expiry,
		.set = py_samr_UserInfo21_set_acct_expiry,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "allow_password_change"),
		.get = py_samr_UserInfo21_get_allow_password_change,
		.set = py_samr_UserInfo21_set_allow_password_change,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "force_password_change"),
		.get = py_samr_UserInfo21_get_force_password_change,
		.set = py_samr_UserInfo21_set_force_password_change,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "account_name"),
		.get = py_samr_UserInfo21_get_account_name,
		.set = py_samr_UserInfo21_set_account_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "full_name"),
		.get = py_samr_UserInfo21_get_full_name,
		.set = py_samr_UserInfo21_set_full_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "home_directory"),
		.get = py_samr_UserInfo21_get_home_directory,
		.set = py_samr_UserInfo21_set_home_directory,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "home_drive"),
		.get = py_samr_UserInfo21_get_home_drive,
		.set = py_samr_UserInfo21_set_home_drive,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "logon_script"),
		.get = py_samr_UserInfo21_get_logon_script,
		.set = py_samr_UserInfo21_set_logon_script,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "profile_path"),
		.get = py_samr_UserInfo21_get_profile_path,
		.set = py_samr_UserInfo21_set_profile_path,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "description"),
		.get = py_samr_UserInfo21_get_description,
		.set = py_samr_UserInfo21_set_description,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "workstations"),
		.get = py_samr_UserInfo21_get_workstations,
		.set = py_samr_UserInfo21_set_workstations,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "comment"),
		.get = py_samr_UserInfo21_get_comment,
		.set = py_samr_UserInfo21_set_comment,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "parameters"),
		.get = py_samr_UserInfo21_get_parameters,
		.set = py_samr_UserInfo21_set_parameters,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_BinaryString")
	},
	{
		.name = discard_const_p(char, "lm_owf_password"),
		.get = py_samr_UserInfo21_get_lm_owf_password,
		.set = py_samr_UserInfo21_set_lm_owf_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_BinaryString")
	},
	{
		.name = discard_const_p(char, "nt_owf_password"),
		.get = py_samr_UserInfo21_get_nt_owf_password,
		.set = py_samr_UserInfo21_set_nt_owf_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_BinaryString")
	},
	{
		.name = discard_const_p(char, "private_data"),
		.get = py_samr_UserInfo21_get_private_data,
		.set = py_samr_UserInfo21_set_private_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "buf_count"),
		.get = py_samr_UserInfo21_get_buf_count,
		.set = py_samr_UserInfo21_set_buf_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "buffer"),
		.get = py_samr_UserInfo21_get_buffer,
		.set = py_samr_UserInfo21_set_buffer,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "rid"),
		.get = py_samr_UserInfo21_get_rid,
		.set = py_samr_UserInfo21_set_rid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "primary_gid"),
		.get = py_samr_UserInfo21_get_primary_gid,
		.set = py_samr_UserInfo21_set_primary_gid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "acct_flags"),
		.get = py_samr_UserInfo21_get_acct_flags,
		.set = py_samr_UserInfo21_set_acct_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_AcctFlags")
	},
	{
		.name = discard_const_p(char, "fields_present"),
		.get = py_samr_UserInfo21_get_fields_present,
		.set = py_samr_UserInfo21_set_fields_present,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_FieldsPresent")
	},
	{
		.name = discard_const_p(char, "logon_hours"),
		.get = py_samr_UserInfo21_get_logon_hours,
		.set = py_samr_UserInfo21_set_logon_hours,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_LogonHours")
	},
	{
		.name = discard_const_p(char, "bad_password_count"),
		.get = py_samr_UserInfo21_get_bad_password_count,
		.set = py_samr_UserInfo21_set_bad_password_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "logon_count"),
		.get = py_samr_UserInfo21_get_logon_count,
		.set = py_samr_UserInfo21_set_logon_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "country_code"),
		.get = py_samr_UserInfo21_get_country_code,
		.set = py_samr_UserInfo21_set_country_code,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "code_page"),
		.get = py_samr_UserInfo21_get_code_page,
		.set = py_samr_UserInfo21_set_code_page,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "lm_password_set"),
		.get = py_samr_UserInfo21_get_lm_password_set,
		.set = py_samr_UserInfo21_set_lm_password_set,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "nt_password_set"),
		.get = py_samr_UserInfo21_get_nt_password_set,
		.set = py_samr_UserInfo21_set_nt_password_set,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "password_expired"),
		.get = py_samr_UserInfo21_get_password_expired,
		.set = py_samr_UserInfo21_set_password_expired,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "private_data_sensitive"),
		.get = py_samr_UserInfo21_get_private_data_sensitive,
		.set = py_samr_UserInfo21_set_private_data_sensitive,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo21_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo21, type);
}


static PyTypeObject samr_UserInfo21_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo21",
	.tp_getset = py_samr_UserInfo21_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo21_new,
};


static PyObject *py_samr_CryptPassword_get_data(PyObject *obj, void *closure)
{
	struct samr_CryptPassword *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyList_New(516);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < (516); data_cntr_0++) {
			PyObject *py_data_0;
			py_data_0 = PyLong_FromLong((uint16_t)((object->data)[data_cntr_0]));
			PyList_SetItem(py_data, data_cntr_0, py_data_0);
		}
	}
	return py_data;
}

static int py_samr_CryptPassword_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_CryptPassword *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->data");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int data_cntr_0;
		if (ARRAY_SIZE(object->data) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->data),  PyList_GET_SIZE(value));
			return -1;
		}
		for (data_cntr_0 = 0; data_cntr_0 < PyList_GET_SIZE(value); data_cntr_0++) {
			if (PyList_GET_ITEM(value, data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->data)[data_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->data)[data_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->data)[data_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_samr_CryptPassword_getsetters[] = {
	{
		.name = discard_const_p(char, "data"),
		.get = py_samr_CryptPassword_get_data,
		.set = py_samr_CryptPassword_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_samr_CryptPassword_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_CryptPassword, type);
}

static PyObject *py_samr_CryptPassword_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct samr_CryptPassword *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_samr_CryptPassword);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_samr_CryptPassword_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct samr_CryptPassword *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_samr_CryptPassword);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_samr_CryptPassword);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_samr_CryptPassword_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct samr_CryptPassword *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_samr_CryptPassword, "samr_CryptPassword", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_samr_CryptPassword, "samr_CryptPassword", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_samr_CryptPassword_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_samr_CryptPassword_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_CryptPassword_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_CryptPassword_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_CryptPassword_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.CryptPassword",
	.tp_getset = py_samr_CryptPassword_getsetters,
	.tp_methods = py_samr_CryptPassword_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_CryptPassword_new,
};


static PyObject *py_samr_UserInfo23_get_info(PyObject *obj, void *closure)
{
	struct samr_UserInfo23 *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pytalloc_reference_ex(&samr_UserInfo21_Type, pytalloc_get_mem_ctx(obj), &object->info);
	return py_info;
}

static int py_samr_UserInfo23_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo23 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	PY_CHECK_TYPE(&samr_UserInfo21_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->info = *(struct samr_UserInfo21 *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo23_get_password(PyObject *obj, void *closure)
{
	struct samr_UserInfo23 *object = pytalloc_get_ptr(obj);
	PyObject *py_password;
	py_password = pytalloc_reference_ex(&samr_CryptPassword_Type, pytalloc_get_mem_ctx(obj), &object->password);
	return py_password;
}

static int py_samr_UserInfo23_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo23 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password");
		return -1;
	}
	PY_CHECK_TYPE(&samr_CryptPassword_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->password = *(struct samr_CryptPassword *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_UserInfo23_getsetters[] = {
	{
		.name = discard_const_p(char, "info"),
		.get = py_samr_UserInfo23_get_info,
		.set = py_samr_UserInfo23_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_UserInfo21")
	},
	{
		.name = discard_const_p(char, "password"),
		.get = py_samr_UserInfo23_get_password,
		.set = py_samr_UserInfo23_set_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_CryptPassword")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo23_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo23, type);
}


static PyTypeObject samr_UserInfo23_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo23",
	.tp_getset = py_samr_UserInfo23_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo23_new,
};


static PyObject *py_samr_UserInfo24_get_password(PyObject *obj, void *closure)
{
	struct samr_UserInfo24 *object = pytalloc_get_ptr(obj);
	PyObject *py_password;
	py_password = pytalloc_reference_ex(&samr_CryptPassword_Type, pytalloc_get_mem_ctx(obj), &object->password);
	return py_password;
}

static int py_samr_UserInfo24_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo24 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password");
		return -1;
	}
	PY_CHECK_TYPE(&samr_CryptPassword_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->password = *(struct samr_CryptPassword *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo24_get_password_expired(PyObject *obj, void *closure)
{
	struct samr_UserInfo24 *object = pytalloc_get_ptr(obj);
	PyObject *py_password_expired;
	py_password_expired = PyLong_FromLong((uint16_t)(object->password_expired));
	return py_password_expired;
}

static int py_samr_UserInfo24_set_password_expired(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo24 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password_expired");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->password_expired));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->password_expired = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_UserInfo24_getsetters[] = {
	{
		.name = discard_const_p(char, "password"),
		.get = py_samr_UserInfo24_get_password,
		.set = py_samr_UserInfo24_set_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_CryptPassword")
	},
	{
		.name = discard_const_p(char, "password_expired"),
		.get = py_samr_UserInfo24_get_password_expired,
		.set = py_samr_UserInfo24_set_password_expired,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo24_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo24, type);
}


static PyTypeObject samr_UserInfo24_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo24",
	.tp_getset = py_samr_UserInfo24_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo24_new,
};


static PyObject *py_samr_CryptPasswordEx_get_data(PyObject *obj, void *closure)
{
	struct samr_CryptPasswordEx *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyList_New(532);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < (532); data_cntr_0++) {
			PyObject *py_data_0;
			py_data_0 = PyLong_FromLong((uint16_t)((object->data)[data_cntr_0]));
			PyList_SetItem(py_data, data_cntr_0, py_data_0);
		}
	}
	return py_data;
}

static int py_samr_CryptPasswordEx_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_CryptPasswordEx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->data");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int data_cntr_0;
		if (ARRAY_SIZE(object->data) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->data),  PyList_GET_SIZE(value));
			return -1;
		}
		for (data_cntr_0 = 0; data_cntr_0 < PyList_GET_SIZE(value); data_cntr_0++) {
			if (PyList_GET_ITEM(value, data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->data)[data_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->data)[data_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->data)[data_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_samr_CryptPasswordEx_getsetters[] = {
	{
		.name = discard_const_p(char, "data"),
		.get = py_samr_CryptPasswordEx_get_data,
		.set = py_samr_CryptPasswordEx_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_samr_CryptPasswordEx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_CryptPasswordEx, type);
}


static PyTypeObject samr_CryptPasswordEx_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.CryptPasswordEx",
	.tp_getset = py_samr_CryptPasswordEx_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_CryptPasswordEx_new,
};


static PyObject *py_samr_UserInfo25_get_info(PyObject *obj, void *closure)
{
	struct samr_UserInfo25 *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pytalloc_reference_ex(&samr_UserInfo21_Type, pytalloc_get_mem_ctx(obj), &object->info);
	return py_info;
}

static int py_samr_UserInfo25_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo25 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	PY_CHECK_TYPE(&samr_UserInfo21_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->info = *(struct samr_UserInfo21 *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo25_get_password(PyObject *obj, void *closure)
{
	struct samr_UserInfo25 *object = pytalloc_get_ptr(obj);
	PyObject *py_password;
	py_password = pytalloc_reference_ex(&samr_CryptPasswordEx_Type, pytalloc_get_mem_ctx(obj), &object->password);
	return py_password;
}

static int py_samr_UserInfo25_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo25 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password");
		return -1;
	}
	PY_CHECK_TYPE(&samr_CryptPasswordEx_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->password = *(struct samr_CryptPasswordEx *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_UserInfo25_getsetters[] = {
	{
		.name = discard_const_p(char, "info"),
		.get = py_samr_UserInfo25_get_info,
		.set = py_samr_UserInfo25_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_UserInfo21")
	},
	{
		.name = discard_const_p(char, "password"),
		.get = py_samr_UserInfo25_get_password,
		.set = py_samr_UserInfo25_set_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_CryptPasswordEx")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo25_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo25, type);
}


static PyTypeObject samr_UserInfo25_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo25",
	.tp_getset = py_samr_UserInfo25_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo25_new,
};


static PyObject *py_samr_UserInfo26_get_password(PyObject *obj, void *closure)
{
	struct samr_UserInfo26 *object = pytalloc_get_ptr(obj);
	PyObject *py_password;
	py_password = pytalloc_reference_ex(&samr_CryptPasswordEx_Type, pytalloc_get_mem_ctx(obj), &object->password);
	return py_password;
}

static int py_samr_UserInfo26_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo26 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password");
		return -1;
	}
	PY_CHECK_TYPE(&samr_CryptPasswordEx_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->password = *(struct samr_CryptPasswordEx *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo26_get_password_expired(PyObject *obj, void *closure)
{
	struct samr_UserInfo26 *object = pytalloc_get_ptr(obj);
	PyObject *py_password_expired;
	py_password_expired = PyLong_FromLong((uint16_t)(object->password_expired));
	return py_password_expired;
}

static int py_samr_UserInfo26_set_password_expired(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo26 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password_expired");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->password_expired));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->password_expired = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_UserInfo26_getsetters[] = {
	{
		.name = discard_const_p(char, "password"),
		.get = py_samr_UserInfo26_get_password,
		.set = py_samr_UserInfo26_set_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_CryptPasswordEx")
	},
	{
		.name = discard_const_p(char, "password_expired"),
		.get = py_samr_UserInfo26_get_password_expired,
		.set = py_samr_UserInfo26_set_password_expired,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo26_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo26, type);
}


static PyTypeObject samr_UserInfo26_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo26",
	.tp_getset = py_samr_UserInfo26_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo26_new,
};


static PyObject *py_samr_EncryptedPasswordAES_get_auth_data(PyObject *obj, void *closure)
{
	struct samr_EncryptedPasswordAES *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_data;
	py_auth_data = PyList_New(64);
	if (py_auth_data == NULL) {
		return NULL;
	}
	{
		int auth_data_cntr_0;
		for (auth_data_cntr_0 = 0; auth_data_cntr_0 < (64); auth_data_cntr_0++) {
			PyObject *py_auth_data_0;
			py_auth_data_0 = PyLong_FromLong((uint16_t)((object->auth_data)[auth_data_cntr_0]));
			PyList_SetItem(py_auth_data, auth_data_cntr_0, py_auth_data_0);
		}
	}
	return py_auth_data;
}

static int py_samr_EncryptedPasswordAES_set_auth_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EncryptedPasswordAES *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auth_data");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int auth_data_cntr_0;
		if (ARRAY_SIZE(object->auth_data) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->auth_data),  PyList_GET_SIZE(value));
			return -1;
		}
		for (auth_data_cntr_0 = 0; auth_data_cntr_0 < PyList_GET_SIZE(value); auth_data_cntr_0++) {
			if (PyList_GET_ITEM(value, auth_data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->auth_data)[auth_data_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->auth_data)[auth_data_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, auth_data_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, auth_data_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->auth_data)[auth_data_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_samr_EncryptedPasswordAES_get_salt(PyObject *obj, void *closure)
{
	struct samr_EncryptedPasswordAES *object = pytalloc_get_ptr(obj);
	PyObject *py_salt;
	py_salt = PyList_New(16);
	if (py_salt == NULL) {
		return NULL;
	}
	{
		int salt_cntr_0;
		for (salt_cntr_0 = 0; salt_cntr_0 < (16); salt_cntr_0++) {
			PyObject *py_salt_0;
			py_salt_0 = PyLong_FromLong((uint16_t)((object->salt)[salt_cntr_0]));
			PyList_SetItem(py_salt, salt_cntr_0, py_salt_0);
		}
	}
	return py_salt;
}

static int py_samr_EncryptedPasswordAES_set_salt(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EncryptedPasswordAES *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->salt");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int salt_cntr_0;
		if (ARRAY_SIZE(object->salt) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->salt),  PyList_GET_SIZE(value));
			return -1;
		}
		for (salt_cntr_0 = 0; salt_cntr_0 < PyList_GET_SIZE(value); salt_cntr_0++) {
			if (PyList_GET_ITEM(value, salt_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->salt)[salt_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->salt)[salt_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, salt_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, salt_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->salt)[salt_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_samr_EncryptedPasswordAES_get_cipher_len(PyObject *obj, void *closure)
{
	struct samr_EncryptedPasswordAES *object = pytalloc_get_ptr(obj);
	PyObject *py_cipher_len;
	py_cipher_len = PyLong_FromUnsignedLongLong((uint32_t)(object->cipher_len));
	return py_cipher_len;
}

static int py_samr_EncryptedPasswordAES_set_cipher_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EncryptedPasswordAES *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->cipher_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->cipher_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->cipher_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_EncryptedPasswordAES_get_cipher(PyObject *obj, void *closure)
{
	struct samr_EncryptedPasswordAES *object = pytalloc_get_ptr(obj);
	PyObject *py_cipher;
	if (object->cipher == NULL) {
		Py_RETURN_NONE;
	}
	if (object->cipher == NULL) {
		py_cipher = Py_None;
		Py_INCREF(py_cipher);
	} else {
		py_cipher = PyList_New(object->cipher_len);
		if (py_cipher == NULL) {
			return NULL;
		}
		{
			int cipher_cntr_1;
			for (cipher_cntr_1 = 0; cipher_cntr_1 < (object->cipher_len); cipher_cntr_1++) {
				PyObject *py_cipher_1;
				py_cipher_1 = PyLong_FromLong((uint16_t)((object->cipher)[cipher_cntr_1]));
				PyList_SetItem(py_cipher, cipher_cntr_1, py_cipher_1);
			}
		}
	}
	return py_cipher;
}

static int py_samr_EncryptedPasswordAES_set_cipher(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EncryptedPasswordAES *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->cipher));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->cipher");
		return -1;
	}
	if (value == Py_None) {
		object->cipher = NULL;
	} else {
		object->cipher = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int cipher_cntr_1;
			object->cipher = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->cipher, PyList_GET_SIZE(value));
			if (!object->cipher) { return -1; }
			talloc_set_name_const(object->cipher, "ARRAY: object->cipher");
			for (cipher_cntr_1 = 0; cipher_cntr_1 < PyList_GET_SIZE(value); cipher_cntr_1++) {
				if (PyList_GET_ITEM(value, cipher_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->cipher)[cipher_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->cipher)[cipher_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, cipher_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, cipher_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->cipher)[cipher_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyObject *py_samr_EncryptedPasswordAES_get_PBKDF2Iterations(PyObject *obj, void *closure)
{
	struct samr_EncryptedPasswordAES *object = pytalloc_get_ptr(obj);
	PyObject *py_PBKDF2Iterations;
	py_PBKDF2Iterations = PyLong_FromUnsignedLongLong(object->PBKDF2Iterations);
	return py_PBKDF2Iterations;
}

static int py_samr_EncryptedPasswordAES_set_PBKDF2Iterations(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EncryptedPasswordAES *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->PBKDF2Iterations");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->PBKDF2Iterations));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->PBKDF2Iterations = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_EncryptedPasswordAES_getsetters[] = {
	{
		.name = discard_const_p(char, "auth_data"),
		.get = py_samr_EncryptedPasswordAES_get_auth_data,
		.set = py_samr_EncryptedPasswordAES_set_auth_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "salt"),
		.get = py_samr_EncryptedPasswordAES_get_salt,
		.set = py_samr_EncryptedPasswordAES_set_salt,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "cipher_len"),
		.get = py_samr_EncryptedPasswordAES_get_cipher_len,
		.set = py_samr_EncryptedPasswordAES_set_cipher_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "cipher"),
		.get = py_samr_EncryptedPasswordAES_get_cipher,
		.set = py_samr_EncryptedPasswordAES_set_cipher,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "PBKDF2Iterations"),
		.get = py_samr_EncryptedPasswordAES_get_PBKDF2Iterations,
		.set = py_samr_EncryptedPasswordAES_set_PBKDF2Iterations,
		.doc = discard_const_p(char, "PIDL-generated element of base type hyper")
	},
	{ .name = NULL }
};

static PyObject *py_samr_EncryptedPasswordAES_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_EncryptedPasswordAES, type);
}


static PyTypeObject samr_EncryptedPasswordAES_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.EncryptedPasswordAES",
	.tp_getset = py_samr_EncryptedPasswordAES_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_EncryptedPasswordAES_new,
};


static PyObject *py_samr_UserInfo31_get_password(PyObject *obj, void *closure)
{
	struct samr_UserInfo31 *object = pytalloc_get_ptr(obj);
	PyObject *py_password;
	py_password = pytalloc_reference_ex(&samr_EncryptedPasswordAES_Type, pytalloc_get_mem_ctx(obj), &object->password);
	return py_password;
}

static int py_samr_UserInfo31_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo31 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password");
		return -1;
	}
	PY_CHECK_TYPE(&samr_EncryptedPasswordAES_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->password = *(struct samr_EncryptedPasswordAES *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo31_get_password_expired(PyObject *obj, void *closure)
{
	struct samr_UserInfo31 *object = pytalloc_get_ptr(obj);
	PyObject *py_password_expired;
	py_password_expired = PyLong_FromLong((uint16_t)(object->password_expired));
	return py_password_expired;
}

static int py_samr_UserInfo31_set_password_expired(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo31 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password_expired");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->password_expired));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->password_expired = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_UserInfo31_getsetters[] = {
	{
		.name = discard_const_p(char, "password"),
		.get = py_samr_UserInfo31_get_password,
		.set = py_samr_UserInfo31_set_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_EncryptedPasswordAES")
	},
	{
		.name = discard_const_p(char, "password_expired"),
		.get = py_samr_UserInfo31_get_password_expired,
		.set = py_samr_UserInfo31_set_password_expired,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo31_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo31, type);
}


static PyTypeObject samr_UserInfo31_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo31",
	.tp_getset = py_samr_UserInfo31_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo31_new,
};


static PyObject *py_samr_UserInfo32_get_info(PyObject *obj, void *closure)
{
	struct samr_UserInfo32 *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pytalloc_reference_ex(&samr_UserInfo21_Type, pytalloc_get_mem_ctx(obj), &object->info);
	return py_info;
}

static int py_samr_UserInfo32_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo32 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	PY_CHECK_TYPE(&samr_UserInfo21_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->info = *(struct samr_UserInfo21 *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_UserInfo32_get_password(PyObject *obj, void *closure)
{
	struct samr_UserInfo32 *object = pytalloc_get_ptr(obj);
	PyObject *py_password;
	py_password = pytalloc_reference_ex(&samr_EncryptedPasswordAES_Type, pytalloc_get_mem_ctx(obj), &object->password);
	return py_password;
}

static int py_samr_UserInfo32_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_UserInfo32 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password");
		return -1;
	}
	PY_CHECK_TYPE(&samr_EncryptedPasswordAES_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->password = *(struct samr_EncryptedPasswordAES *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_UserInfo32_getsetters[] = {
	{
		.name = discard_const_p(char, "info"),
		.get = py_samr_UserInfo32_get_info,
		.set = py_samr_UserInfo32_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_UserInfo21")
	},
	{
		.name = discard_const_p(char, "password"),
		.get = py_samr_UserInfo32_get_password,
		.set = py_samr_UserInfo32_set_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_EncryptedPasswordAES")
	},
	{ .name = NULL }
};

static PyObject *py_samr_UserInfo32_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_UserInfo32, type);
}


static PyTypeObject samr_UserInfo32_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo32",
	.tp_getset = py_samr_UserInfo32_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo32_new,
};

static PyObject *py_import_samr_UserInfo(TALLOC_CTX *mem_ctx, int level, union samr_UserInfo *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&samr_UserInfo1_Type, mem_ctx, &in->info1);
			return ret;

		case 2:
			ret = pytalloc_reference_ex(&samr_UserInfo2_Type, mem_ctx, &in->info2);
			return ret;

		case 3:
			ret = pytalloc_reference_ex(&samr_UserInfo3_Type, mem_ctx, &in->info3);
			return ret;

		case 4:
			ret = pytalloc_reference_ex(&samr_UserInfo4_Type, mem_ctx, &in->info4);
			return ret;

		case 5:
			ret = pytalloc_reference_ex(&samr_UserInfo5_Type, mem_ctx, &in->info5);
			return ret;

		case 6:
			ret = pytalloc_reference_ex(&samr_UserInfo6_Type, mem_ctx, &in->info6);
			return ret;

		case 7:
			ret = pytalloc_reference_ex(&samr_UserInfo7_Type, mem_ctx, &in->info7);
			return ret;

		case 8:
			ret = pytalloc_reference_ex(&samr_UserInfo8_Type, mem_ctx, &in->info8);
			return ret;

		case 9:
			ret = pytalloc_reference_ex(&samr_UserInfo9_Type, mem_ctx, &in->info9);
			return ret;

		case 10:
			ret = pytalloc_reference_ex(&samr_UserInfo10_Type, mem_ctx, &in->info10);
			return ret;

		case 11:
			ret = pytalloc_reference_ex(&samr_UserInfo11_Type, mem_ctx, &in->info11);
			return ret;

		case 12:
			ret = pytalloc_reference_ex(&samr_UserInfo12_Type, mem_ctx, &in->info12);
			return ret;

		case 13:
			ret = pytalloc_reference_ex(&samr_UserInfo13_Type, mem_ctx, &in->info13);
			return ret;

		case 14:
			ret = pytalloc_reference_ex(&samr_UserInfo14_Type, mem_ctx, &in->info14);
			return ret;

		case 16:
			ret = pytalloc_reference_ex(&samr_UserInfo16_Type, mem_ctx, &in->info16);
			return ret;

		case 17:
			ret = pytalloc_reference_ex(&samr_UserInfo17_Type, mem_ctx, &in->info17);
			return ret;

		case 18:
			ret = pytalloc_reference_ex(&samr_UserInfo18_Type, mem_ctx, &in->info18);
			return ret;

		case 20:
			ret = pytalloc_reference_ex(&samr_UserInfo20_Type, mem_ctx, &in->info20);
			return ret;

		case 21:
			ret = pytalloc_reference_ex(&samr_UserInfo21_Type, mem_ctx, &in->info21);
			return ret;

		case 23:
			ret = pytalloc_reference_ex(&samr_UserInfo23_Type, mem_ctx, &in->info23);
			return ret;

		case 24:
			ret = pytalloc_reference_ex(&samr_UserInfo24_Type, mem_ctx, &in->info24);
			return ret;

		case 25:
			ret = pytalloc_reference_ex(&samr_UserInfo25_Type, mem_ctx, &in->info25);
			return ret;

		case 26:
			ret = pytalloc_reference_ex(&samr_UserInfo26_Type, mem_ctx, &in->info26);
			return ret;

		case 31:
			ret = pytalloc_reference_ex(&samr_UserInfo31_Type, mem_ctx, &in->info31);
			return ret;

		case 32:
			ret = pytalloc_reference_ex(&samr_UserInfo32_Type, mem_ctx, &in->info32);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union samr_UserInfo *py_export_samr_UserInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union samr_UserInfo *ret = talloc_zero(mem_ctx, union samr_UserInfo);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info1 = *(struct samr_UserInfo1 *)pytalloc_get_ptr(in);
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info2");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo2_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info2 = *(struct samr_UserInfo2 *)pytalloc_get_ptr(in);
			break;

		case 3:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info3");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo3_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info3 = *(struct samr_UserInfo3 *)pytalloc_get_ptr(in);
			break;

		case 4:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info4");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo4_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info4 = *(struct samr_UserInfo4 *)pytalloc_get_ptr(in);
			break;

		case 5:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info5");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo5_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info5 = *(struct samr_UserInfo5 *)pytalloc_get_ptr(in);
			break;

		case 6:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info6");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo6_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info6 = *(struct samr_UserInfo6 *)pytalloc_get_ptr(in);
			break;

		case 7:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info7");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo7_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info7 = *(struct samr_UserInfo7 *)pytalloc_get_ptr(in);
			break;

		case 8:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info8");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo8_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info8 = *(struct samr_UserInfo8 *)pytalloc_get_ptr(in);
			break;

		case 9:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info9");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo9_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info9 = *(struct samr_UserInfo9 *)pytalloc_get_ptr(in);
			break;

		case 10:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info10");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo10_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info10 = *(struct samr_UserInfo10 *)pytalloc_get_ptr(in);
			break;

		case 11:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info11");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo11_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info11 = *(struct samr_UserInfo11 *)pytalloc_get_ptr(in);
			break;

		case 12:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info12");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo12_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info12 = *(struct samr_UserInfo12 *)pytalloc_get_ptr(in);
			break;

		case 13:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info13");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo13_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info13 = *(struct samr_UserInfo13 *)pytalloc_get_ptr(in);
			break;

		case 14:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info14");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo14_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info14 = *(struct samr_UserInfo14 *)pytalloc_get_ptr(in);
			break;

		case 16:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info16");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo16_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info16 = *(struct samr_UserInfo16 *)pytalloc_get_ptr(in);
			break;

		case 17:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info17");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo17_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info17 = *(struct samr_UserInfo17 *)pytalloc_get_ptr(in);
			break;

		case 18:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info18");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo18_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info18 = *(struct samr_UserInfo18 *)pytalloc_get_ptr(in);
			break;

		case 20:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info20");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo20_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info20 = *(struct samr_UserInfo20 *)pytalloc_get_ptr(in);
			break;

		case 21:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info21");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo21_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info21 = *(struct samr_UserInfo21 *)pytalloc_get_ptr(in);
			break;

		case 23:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info23");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo23_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info23 = *(struct samr_UserInfo23 *)pytalloc_get_ptr(in);
			break;

		case 24:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info24");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo24_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info24 = *(struct samr_UserInfo24 *)pytalloc_get_ptr(in);
			break;

		case 25:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info25");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo25_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info25 = *(struct samr_UserInfo25 *)pytalloc_get_ptr(in);
			break;

		case 26:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info26");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo26_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info26 = *(struct samr_UserInfo26 *)pytalloc_get_ptr(in);
			break;

		case 31:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info31");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo31_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info31 = *(struct samr_UserInfo31 *)pytalloc_get_ptr(in);
			break;

		case 32:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info32");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_UserInfo32_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info32 = *(struct samr_UserInfo32 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_samr_UserInfo_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union samr_UserInfo *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union samr_UserInfo *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union samr_UserInfo!");
		return NULL;
	}

	return py_import_samr_UserInfo(mem_ctx, level, in);
}

static PyObject *py_samr_UserInfo_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union samr_UserInfo *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_samr_UserInfo(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_samr_UserInfo_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_UserInfo_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_UserInfo_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_samr_UserInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject samr_UserInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.UserInfo",
	.tp_getset = NULL,
	.tp_methods = py_samr_UserInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_UserInfo_new,
};


static PyObject *py_samr_RidWithAttribute_get_rid(PyObject *obj, void *closure)
{
	struct samr_RidWithAttribute *object = pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(object->rid));
	return py_rid;
}

static int py_samr_RidWithAttribute_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_RidWithAttribute *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_RidWithAttribute_get_attributes(PyObject *obj, void *closure)
{
	struct samr_RidWithAttribute *object = pytalloc_get_ptr(obj);
	PyObject *py_attributes;
	py_attributes = PyLong_FromUnsignedLongLong((uint32_t)(object->attributes));
	return py_attributes;
}

static int py_samr_RidWithAttribute_set_attributes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_RidWithAttribute *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->attributes");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->attributes));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->attributes = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_RidWithAttribute_getsetters[] = {
	{
		.name = discard_const_p(char, "rid"),
		.get = py_samr_RidWithAttribute_get_rid,
		.set = py_samr_RidWithAttribute_set_rid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "attributes"),
		.get = py_samr_RidWithAttribute_get_attributes,
		.set = py_samr_RidWithAttribute_set_attributes,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_GroupAttrs")
	},
	{ .name = NULL }
};

static PyObject *py_samr_RidWithAttribute_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_RidWithAttribute, type);
}

static PyObject *py_samr_RidWithAttribute_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct samr_RidWithAttribute *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_samr_RidWithAttribute);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_samr_RidWithAttribute_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct samr_RidWithAttribute *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_samr_RidWithAttribute);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_samr_RidWithAttribute);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_samr_RidWithAttribute_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct samr_RidWithAttribute *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_samr_RidWithAttribute, "samr_RidWithAttribute", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_samr_RidWithAttribute, "samr_RidWithAttribute", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_samr_RidWithAttribute_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_samr_RidWithAttribute_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_RidWithAttribute_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_RidWithAttribute_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_RidWithAttribute_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.RidWithAttribute",
	.tp_getset = py_samr_RidWithAttribute_getsetters,
	.tp_methods = py_samr_RidWithAttribute_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_RidWithAttribute_new,
};


static PyObject *py_samr_RidWithAttributeArray_get_count(PyObject *obj, void *closure)
{
	struct samr_RidWithAttributeArray *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_samr_RidWithAttributeArray_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_RidWithAttributeArray *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_RidWithAttributeArray_get_rids(PyObject *obj, void *closure)
{
	struct samr_RidWithAttributeArray *object = pytalloc_get_ptr(obj);
	PyObject *py_rids;
	if (object->rids == NULL) {
		Py_RETURN_NONE;
	}
	if (object->rids == NULL) {
		py_rids = Py_None;
		Py_INCREF(py_rids);
	} else {
		py_rids = PyList_New(object->count);
		if (py_rids == NULL) {
			return NULL;
		}
		{
			int rids_cntr_1;
			for (rids_cntr_1 = 0; rids_cntr_1 < (object->count); rids_cntr_1++) {
				PyObject *py_rids_1;
				py_rids_1 = pytalloc_reference_ex(&samr_RidWithAttribute_Type, object->rids, &(object->rids)[rids_cntr_1]);
				PyList_SetItem(py_rids, rids_cntr_1, py_rids_1);
			}
		}
	}
	return py_rids;
}

static int py_samr_RidWithAttributeArray_set_rids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_RidWithAttributeArray *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->rids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rids");
		return -1;
	}
	if (value == Py_None) {
		object->rids = NULL;
	} else {
		object->rids = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int rids_cntr_1;
			object->rids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->rids, PyList_GET_SIZE(value));
			if (!object->rids) { return -1; }
			talloc_set_name_const(object->rids, "ARRAY: object->rids");
			for (rids_cntr_1 = 0; rids_cntr_1 < PyList_GET_SIZE(value); rids_cntr_1++) {
				if (PyList_GET_ITEM(value, rids_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->rids)[rids_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&samr_RidWithAttribute_Type, PyList_GET_ITEM(value, rids_cntr_1), return -1;);
				if (talloc_reference(object->rids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, rids_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->rids)[rids_cntr_1] = *(struct samr_RidWithAttribute *)pytalloc_get_ptr(PyList_GET_ITEM(value, rids_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_samr_RidWithAttributeArray_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_samr_RidWithAttributeArray_get_count,
		.set = py_samr_RidWithAttributeArray_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "rids"),
		.get = py_samr_RidWithAttributeArray_get_rids,
		.set = py_samr_RidWithAttributeArray_set_rids,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_RidWithAttribute")
	},
	{ .name = NULL }
};

static PyObject *py_samr_RidWithAttributeArray_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_RidWithAttributeArray, type);
}

static PyObject *py_samr_RidWithAttributeArray_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct samr_RidWithAttributeArray *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_samr_RidWithAttributeArray);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_samr_RidWithAttributeArray_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct samr_RidWithAttributeArray *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_samr_RidWithAttributeArray);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_samr_RidWithAttributeArray);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_samr_RidWithAttributeArray_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct samr_RidWithAttributeArray *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_samr_RidWithAttributeArray, "samr_RidWithAttributeArray", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_samr_RidWithAttributeArray, "samr_RidWithAttributeArray", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_samr_RidWithAttributeArray_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_samr_RidWithAttributeArray_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_RidWithAttributeArray_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_RidWithAttributeArray_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_RidWithAttributeArray_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.RidWithAttributeArray",
	.tp_getset = py_samr_RidWithAttributeArray_getsetters,
	.tp_methods = py_samr_RidWithAttributeArray_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_RidWithAttributeArray_new,
};


static PyObject *py_samr_DispEntryGeneral_get_idx(PyObject *obj, void *closure)
{
	struct samr_DispEntryGeneral *object = pytalloc_get_ptr(obj);
	PyObject *py_idx;
	py_idx = PyLong_FromUnsignedLongLong((uint32_t)(object->idx));
	return py_idx;
}

static int py_samr_DispEntryGeneral_set_idx(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispEntryGeneral *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->idx");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->idx));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->idx = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DispEntryGeneral_get_rid(PyObject *obj, void *closure)
{
	struct samr_DispEntryGeneral *object = pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(object->rid));
	return py_rid;
}

static int py_samr_DispEntryGeneral_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispEntryGeneral *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DispEntryGeneral_get_acct_flags(PyObject *obj, void *closure)
{
	struct samr_DispEntryGeneral *object = pytalloc_get_ptr(obj);
	PyObject *py_acct_flags;
	py_acct_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->acct_flags));
	return py_acct_flags;
}

static int py_samr_DispEntryGeneral_set_acct_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispEntryGeneral *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->acct_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->acct_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->acct_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DispEntryGeneral_get_account_name(PyObject *obj, void *closure)
{
	struct samr_DispEntryGeneral *object = pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	py_account_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->account_name);
	return py_account_name;
}

static int py_samr_DispEntryGeneral_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispEntryGeneral *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->account_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->account_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_DispEntryGeneral_get_description(PyObject *obj, void *closure)
{
	struct samr_DispEntryGeneral *object = pytalloc_get_ptr(obj);
	PyObject *py_description;
	py_description = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->description);
	return py_description;
}

static int py_samr_DispEntryGeneral_set_description(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispEntryGeneral *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->description");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->description = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_DispEntryGeneral_get_full_name(PyObject *obj, void *closure)
{
	struct samr_DispEntryGeneral *object = pytalloc_get_ptr(obj);
	PyObject *py_full_name;
	py_full_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->full_name);
	return py_full_name;
}

static int py_samr_DispEntryGeneral_set_full_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispEntryGeneral *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->full_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->full_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_DispEntryGeneral_getsetters[] = {
	{
		.name = discard_const_p(char, "idx"),
		.get = py_samr_DispEntryGeneral_get_idx,
		.set = py_samr_DispEntryGeneral_set_idx,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "rid"),
		.get = py_samr_DispEntryGeneral_get_rid,
		.set = py_samr_DispEntryGeneral_set_rid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "acct_flags"),
		.get = py_samr_DispEntryGeneral_get_acct_flags,
		.set = py_samr_DispEntryGeneral_set_acct_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_AcctFlags")
	},
	{
		.name = discard_const_p(char, "account_name"),
		.get = py_samr_DispEntryGeneral_get_account_name,
		.set = py_samr_DispEntryGeneral_set_account_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "description"),
		.get = py_samr_DispEntryGeneral_get_description,
		.set = py_samr_DispEntryGeneral_set_description,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "full_name"),
		.get = py_samr_DispEntryGeneral_get_full_name,
		.set = py_samr_DispEntryGeneral_set_full_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_samr_DispEntryGeneral_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_DispEntryGeneral, type);
}


static PyTypeObject samr_DispEntryGeneral_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DispEntryGeneral",
	.tp_getset = py_samr_DispEntryGeneral_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DispEntryGeneral_new,
};


static PyObject *py_samr_DispInfoGeneral_get_count(PyObject *obj, void *closure)
{
	struct samr_DispInfoGeneral *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_samr_DispInfoGeneral_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispInfoGeneral *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DispInfoGeneral_get_entries(PyObject *obj, void *closure)
{
	struct samr_DispInfoGeneral *object = pytalloc_get_ptr(obj);
	PyObject *py_entries;
	if (object->entries == NULL) {
		Py_RETURN_NONE;
	}
	if (object->entries == NULL) {
		py_entries = Py_None;
		Py_INCREF(py_entries);
	} else {
		py_entries = PyList_New(object->count);
		if (py_entries == NULL) {
			return NULL;
		}
		{
			int entries_cntr_1;
			for (entries_cntr_1 = 0; entries_cntr_1 < (object->count); entries_cntr_1++) {
				PyObject *py_entries_1;
				py_entries_1 = pytalloc_reference_ex(&samr_DispEntryGeneral_Type, object->entries, &(object->entries)[entries_cntr_1]);
				PyList_SetItem(py_entries, entries_cntr_1, py_entries_1);
			}
		}
	}
	return py_entries;
}

static int py_samr_DispInfoGeneral_set_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispInfoGeneral *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->entries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->entries");
		return -1;
	}
	if (value == Py_None) {
		object->entries = NULL;
	} else {
		object->entries = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int entries_cntr_1;
			object->entries = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->entries, PyList_GET_SIZE(value));
			if (!object->entries) { return -1; }
			talloc_set_name_const(object->entries, "ARRAY: object->entries");
			for (entries_cntr_1 = 0; entries_cntr_1 < PyList_GET_SIZE(value); entries_cntr_1++) {
				if (PyList_GET_ITEM(value, entries_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->entries)[entries_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&samr_DispEntryGeneral_Type, PyList_GET_ITEM(value, entries_cntr_1), return -1;);
				if (talloc_reference(object->entries, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, entries_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->entries)[entries_cntr_1] = *(struct samr_DispEntryGeneral *)pytalloc_get_ptr(PyList_GET_ITEM(value, entries_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_samr_DispInfoGeneral_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_samr_DispInfoGeneral_get_count,
		.set = py_samr_DispInfoGeneral_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "entries"),
		.get = py_samr_DispInfoGeneral_get_entries,
		.set = py_samr_DispInfoGeneral_set_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_DispEntryGeneral")
	},
	{ .name = NULL }
};

static PyObject *py_samr_DispInfoGeneral_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_DispInfoGeneral, type);
}


static PyTypeObject samr_DispInfoGeneral_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DispInfoGeneral",
	.tp_getset = py_samr_DispInfoGeneral_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DispInfoGeneral_new,
};


static PyObject *py_samr_DispEntryFull_get_idx(PyObject *obj, void *closure)
{
	struct samr_DispEntryFull *object = pytalloc_get_ptr(obj);
	PyObject *py_idx;
	py_idx = PyLong_FromUnsignedLongLong((uint32_t)(object->idx));
	return py_idx;
}

static int py_samr_DispEntryFull_set_idx(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispEntryFull *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->idx");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->idx));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->idx = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DispEntryFull_get_rid(PyObject *obj, void *closure)
{
	struct samr_DispEntryFull *object = pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(object->rid));
	return py_rid;
}

static int py_samr_DispEntryFull_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispEntryFull *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DispEntryFull_get_acct_flags(PyObject *obj, void *closure)
{
	struct samr_DispEntryFull *object = pytalloc_get_ptr(obj);
	PyObject *py_acct_flags;
	py_acct_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->acct_flags));
	return py_acct_flags;
}

static int py_samr_DispEntryFull_set_acct_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispEntryFull *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->acct_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->acct_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->acct_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DispEntryFull_get_account_name(PyObject *obj, void *closure)
{
	struct samr_DispEntryFull *object = pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	py_account_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->account_name);
	return py_account_name;
}

static int py_samr_DispEntryFull_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispEntryFull *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->account_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->account_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_DispEntryFull_get_description(PyObject *obj, void *closure)
{
	struct samr_DispEntryFull *object = pytalloc_get_ptr(obj);
	PyObject *py_description;
	py_description = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->description);
	return py_description;
}

static int py_samr_DispEntryFull_set_description(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispEntryFull *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->description");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->description = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_DispEntryFull_getsetters[] = {
	{
		.name = discard_const_p(char, "idx"),
		.get = py_samr_DispEntryFull_get_idx,
		.set = py_samr_DispEntryFull_set_idx,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "rid"),
		.get = py_samr_DispEntryFull_get_rid,
		.set = py_samr_DispEntryFull_set_rid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "acct_flags"),
		.get = py_samr_DispEntryFull_get_acct_flags,
		.set = py_samr_DispEntryFull_set_acct_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_AcctFlags")
	},
	{
		.name = discard_const_p(char, "account_name"),
		.get = py_samr_DispEntryFull_get_account_name,
		.set = py_samr_DispEntryFull_set_account_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "description"),
		.get = py_samr_DispEntryFull_get_description,
		.set = py_samr_DispEntryFull_set_description,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_samr_DispEntryFull_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_DispEntryFull, type);
}


static PyTypeObject samr_DispEntryFull_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DispEntryFull",
	.tp_getset = py_samr_DispEntryFull_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DispEntryFull_new,
};


static PyObject *py_samr_DispInfoFull_get_count(PyObject *obj, void *closure)
{
	struct samr_DispInfoFull *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_samr_DispInfoFull_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispInfoFull *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DispInfoFull_get_entries(PyObject *obj, void *closure)
{
	struct samr_DispInfoFull *object = pytalloc_get_ptr(obj);
	PyObject *py_entries;
	if (object->entries == NULL) {
		Py_RETURN_NONE;
	}
	if (object->entries == NULL) {
		py_entries = Py_None;
		Py_INCREF(py_entries);
	} else {
		py_entries = PyList_New(object->count);
		if (py_entries == NULL) {
			return NULL;
		}
		{
			int entries_cntr_1;
			for (entries_cntr_1 = 0; entries_cntr_1 < (object->count); entries_cntr_1++) {
				PyObject *py_entries_1;
				py_entries_1 = pytalloc_reference_ex(&samr_DispEntryFull_Type, object->entries, &(object->entries)[entries_cntr_1]);
				PyList_SetItem(py_entries, entries_cntr_1, py_entries_1);
			}
		}
	}
	return py_entries;
}

static int py_samr_DispInfoFull_set_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispInfoFull *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->entries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->entries");
		return -1;
	}
	if (value == Py_None) {
		object->entries = NULL;
	} else {
		object->entries = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int entries_cntr_1;
			object->entries = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->entries, PyList_GET_SIZE(value));
			if (!object->entries) { return -1; }
			talloc_set_name_const(object->entries, "ARRAY: object->entries");
			for (entries_cntr_1 = 0; entries_cntr_1 < PyList_GET_SIZE(value); entries_cntr_1++) {
				if (PyList_GET_ITEM(value, entries_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->entries)[entries_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&samr_DispEntryFull_Type, PyList_GET_ITEM(value, entries_cntr_1), return -1;);
				if (talloc_reference(object->entries, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, entries_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->entries)[entries_cntr_1] = *(struct samr_DispEntryFull *)pytalloc_get_ptr(PyList_GET_ITEM(value, entries_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_samr_DispInfoFull_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_samr_DispInfoFull_get_count,
		.set = py_samr_DispInfoFull_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "entries"),
		.get = py_samr_DispInfoFull_get_entries,
		.set = py_samr_DispInfoFull_set_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_DispEntryFull")
	},
	{ .name = NULL }
};

static PyObject *py_samr_DispInfoFull_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_DispInfoFull, type);
}


static PyTypeObject samr_DispInfoFull_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DispInfoFull",
	.tp_getset = py_samr_DispInfoFull_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DispInfoFull_new,
};


static PyObject *py_samr_DispEntryFullGroup_get_idx(PyObject *obj, void *closure)
{
	struct samr_DispEntryFullGroup *object = pytalloc_get_ptr(obj);
	PyObject *py_idx;
	py_idx = PyLong_FromUnsignedLongLong((uint32_t)(object->idx));
	return py_idx;
}

static int py_samr_DispEntryFullGroup_set_idx(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispEntryFullGroup *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->idx");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->idx));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->idx = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DispEntryFullGroup_get_rid(PyObject *obj, void *closure)
{
	struct samr_DispEntryFullGroup *object = pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(object->rid));
	return py_rid;
}

static int py_samr_DispEntryFullGroup_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispEntryFullGroup *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DispEntryFullGroup_get_acct_flags(PyObject *obj, void *closure)
{
	struct samr_DispEntryFullGroup *object = pytalloc_get_ptr(obj);
	PyObject *py_acct_flags;
	py_acct_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->acct_flags));
	return py_acct_flags;
}

static int py_samr_DispEntryFullGroup_set_acct_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispEntryFullGroup *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->acct_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->acct_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->acct_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DispEntryFullGroup_get_account_name(PyObject *obj, void *closure)
{
	struct samr_DispEntryFullGroup *object = pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	py_account_name = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->account_name);
	return py_account_name;
}

static int py_samr_DispEntryFullGroup_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispEntryFullGroup *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->account_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->account_name = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_DispEntryFullGroup_get_description(PyObject *obj, void *closure)
{
	struct samr_DispEntryFullGroup *object = pytalloc_get_ptr(obj);
	PyObject *py_description;
	py_description = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->description);
	return py_description;
}

static int py_samr_DispEntryFullGroup_set_description(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispEntryFullGroup *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->description");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->description = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_DispEntryFullGroup_getsetters[] = {
	{
		.name = discard_const_p(char, "idx"),
		.get = py_samr_DispEntryFullGroup_get_idx,
		.set = py_samr_DispEntryFullGroup_set_idx,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "rid"),
		.get = py_samr_DispEntryFullGroup_get_rid,
		.set = py_samr_DispEntryFullGroup_set_rid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "acct_flags"),
		.get = py_samr_DispEntryFullGroup_get_acct_flags,
		.set = py_samr_DispEntryFullGroup_set_acct_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_GroupAttrs")
	},
	{
		.name = discard_const_p(char, "account_name"),
		.get = py_samr_DispEntryFullGroup_get_account_name,
		.set = py_samr_DispEntryFullGroup_set_account_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "description"),
		.get = py_samr_DispEntryFullGroup_get_description,
		.set = py_samr_DispEntryFullGroup_set_description,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_samr_DispEntryFullGroup_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_DispEntryFullGroup, type);
}


static PyTypeObject samr_DispEntryFullGroup_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DispEntryFullGroup",
	.tp_getset = py_samr_DispEntryFullGroup_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DispEntryFullGroup_new,
};


static PyObject *py_samr_DispInfoFullGroups_get_count(PyObject *obj, void *closure)
{
	struct samr_DispInfoFullGroups *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_samr_DispInfoFullGroups_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispInfoFullGroups *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DispInfoFullGroups_get_entries(PyObject *obj, void *closure)
{
	struct samr_DispInfoFullGroups *object = pytalloc_get_ptr(obj);
	PyObject *py_entries;
	if (object->entries == NULL) {
		Py_RETURN_NONE;
	}
	if (object->entries == NULL) {
		py_entries = Py_None;
		Py_INCREF(py_entries);
	} else {
		py_entries = PyList_New(object->count);
		if (py_entries == NULL) {
			return NULL;
		}
		{
			int entries_cntr_1;
			for (entries_cntr_1 = 0; entries_cntr_1 < (object->count); entries_cntr_1++) {
				PyObject *py_entries_1;
				py_entries_1 = pytalloc_reference_ex(&samr_DispEntryFullGroup_Type, object->entries, &(object->entries)[entries_cntr_1]);
				PyList_SetItem(py_entries, entries_cntr_1, py_entries_1);
			}
		}
	}
	return py_entries;
}

static int py_samr_DispInfoFullGroups_set_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispInfoFullGroups *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->entries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->entries");
		return -1;
	}
	if (value == Py_None) {
		object->entries = NULL;
	} else {
		object->entries = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int entries_cntr_1;
			object->entries = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->entries, PyList_GET_SIZE(value));
			if (!object->entries) { return -1; }
			talloc_set_name_const(object->entries, "ARRAY: object->entries");
			for (entries_cntr_1 = 0; entries_cntr_1 < PyList_GET_SIZE(value); entries_cntr_1++) {
				if (PyList_GET_ITEM(value, entries_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->entries)[entries_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&samr_DispEntryFullGroup_Type, PyList_GET_ITEM(value, entries_cntr_1), return -1;);
				if (talloc_reference(object->entries, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, entries_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->entries)[entries_cntr_1] = *(struct samr_DispEntryFullGroup *)pytalloc_get_ptr(PyList_GET_ITEM(value, entries_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_samr_DispInfoFullGroups_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_samr_DispInfoFullGroups_get_count,
		.set = py_samr_DispInfoFullGroups_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "entries"),
		.get = py_samr_DispInfoFullGroups_get_entries,
		.set = py_samr_DispInfoFullGroups_set_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_DispEntryFullGroup")
	},
	{ .name = NULL }
};

static PyObject *py_samr_DispInfoFullGroups_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_DispInfoFullGroups, type);
}


static PyTypeObject samr_DispInfoFullGroups_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DispInfoFullGroups",
	.tp_getset = py_samr_DispInfoFullGroups_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DispInfoFullGroups_new,
};


static PyObject *py_samr_DispEntryAscii_get_idx(PyObject *obj, void *closure)
{
	struct samr_DispEntryAscii *object = pytalloc_get_ptr(obj);
	PyObject *py_idx;
	py_idx = PyLong_FromUnsignedLongLong((uint32_t)(object->idx));
	return py_idx;
}

static int py_samr_DispEntryAscii_set_idx(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispEntryAscii *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->idx");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->idx));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->idx = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DispEntryAscii_get_account_name(PyObject *obj, void *closure)
{
	struct samr_DispEntryAscii *object = pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	py_account_name = pytalloc_reference_ex(lsa_AsciiStringLarge_Type, pytalloc_get_mem_ctx(obj), &object->account_name);
	return py_account_name;
}

static int py_samr_DispEntryAscii_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispEntryAscii *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->account_name");
		return -1;
	}
	PY_CHECK_TYPE(lsa_AsciiStringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->account_name = *(struct lsa_AsciiStringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_samr_DispEntryAscii_getsetters[] = {
	{
		.name = discard_const_p(char, "idx"),
		.get = py_samr_DispEntryAscii_get_idx,
		.set = py_samr_DispEntryAscii_set_idx,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "account_name"),
		.get = py_samr_DispEntryAscii_get_account_name,
		.set = py_samr_DispEntryAscii_set_account_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_AsciiStringLarge")
	},
	{ .name = NULL }
};

static PyObject *py_samr_DispEntryAscii_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_DispEntryAscii, type);
}


static PyTypeObject samr_DispEntryAscii_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DispEntryAscii",
	.tp_getset = py_samr_DispEntryAscii_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DispEntryAscii_new,
};


static PyObject *py_samr_DispInfoAscii_get_count(PyObject *obj, void *closure)
{
	struct samr_DispInfoAscii *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_samr_DispInfoAscii_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispInfoAscii *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DispInfoAscii_get_entries(PyObject *obj, void *closure)
{
	struct samr_DispInfoAscii *object = pytalloc_get_ptr(obj);
	PyObject *py_entries;
	if (object->entries == NULL) {
		Py_RETURN_NONE;
	}
	if (object->entries == NULL) {
		py_entries = Py_None;
		Py_INCREF(py_entries);
	} else {
		py_entries = PyList_New(object->count);
		if (py_entries == NULL) {
			return NULL;
		}
		{
			int entries_cntr_1;
			for (entries_cntr_1 = 0; entries_cntr_1 < (object->count); entries_cntr_1++) {
				PyObject *py_entries_1;
				py_entries_1 = pytalloc_reference_ex(&samr_DispEntryAscii_Type, object->entries, &(object->entries)[entries_cntr_1]);
				PyList_SetItem(py_entries, entries_cntr_1, py_entries_1);
			}
		}
	}
	return py_entries;
}

static int py_samr_DispInfoAscii_set_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DispInfoAscii *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->entries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->entries");
		return -1;
	}
	if (value == Py_None) {
		object->entries = NULL;
	} else {
		object->entries = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int entries_cntr_1;
			object->entries = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->entries, PyList_GET_SIZE(value));
			if (!object->entries) { return -1; }
			talloc_set_name_const(object->entries, "ARRAY: object->entries");
			for (entries_cntr_1 = 0; entries_cntr_1 < PyList_GET_SIZE(value); entries_cntr_1++) {
				if (PyList_GET_ITEM(value, entries_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->entries)[entries_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&samr_DispEntryAscii_Type, PyList_GET_ITEM(value, entries_cntr_1), return -1;);
				if (talloc_reference(object->entries, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, entries_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->entries)[entries_cntr_1] = *(struct samr_DispEntryAscii *)pytalloc_get_ptr(PyList_GET_ITEM(value, entries_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_samr_DispInfoAscii_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_samr_DispInfoAscii_get_count,
		.set = py_samr_DispInfoAscii_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "entries"),
		.get = py_samr_DispInfoAscii_get_entries,
		.set = py_samr_DispInfoAscii_set_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_DispEntryAscii")
	},
	{ .name = NULL }
};

static PyObject *py_samr_DispInfoAscii_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_DispInfoAscii, type);
}


static PyTypeObject samr_DispInfoAscii_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DispInfoAscii",
	.tp_getset = py_samr_DispInfoAscii_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DispInfoAscii_new,
};

static PyObject *py_import_samr_DispInfo(TALLOC_CTX *mem_ctx, int level, union samr_DispInfo *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&samr_DispInfoGeneral_Type, mem_ctx, &in->info1);
			return ret;

		case 2:
			ret = pytalloc_reference_ex(&samr_DispInfoFull_Type, mem_ctx, &in->info2);
			return ret;

		case 3:
			ret = pytalloc_reference_ex(&samr_DispInfoFullGroups_Type, mem_ctx, &in->info3);
			return ret;

		case 4:
			ret = pytalloc_reference_ex(&samr_DispInfoAscii_Type, mem_ctx, &in->info4);
			return ret;

		case 5:
			ret = pytalloc_reference_ex(&samr_DispInfoAscii_Type, mem_ctx, &in->info5);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union samr_DispInfo *py_export_samr_DispInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union samr_DispInfo *ret = talloc_zero(mem_ctx, union samr_DispInfo);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_DispInfoGeneral_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info1 = *(struct samr_DispInfoGeneral *)pytalloc_get_ptr(in);
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info2");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_DispInfoFull_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info2 = *(struct samr_DispInfoFull *)pytalloc_get_ptr(in);
			break;

		case 3:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info3");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_DispInfoFullGroups_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info3 = *(struct samr_DispInfoFullGroups *)pytalloc_get_ptr(in);
			break;

		case 4:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info4");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_DispInfoAscii_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info4 = *(struct samr_DispInfoAscii *)pytalloc_get_ptr(in);
			break;

		case 5:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info5");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_DispInfoAscii_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info5 = *(struct samr_DispInfoAscii *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_samr_DispInfo_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union samr_DispInfo *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union samr_DispInfo *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union samr_DispInfo!");
		return NULL;
	}

	return py_import_samr_DispInfo(mem_ctx, level, in);
}

static PyObject *py_samr_DispInfo_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union samr_DispInfo *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_samr_DispInfo(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_samr_DispInfo_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_DispInfo_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_DispInfo_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_samr_DispInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject samr_DispInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DispInfo",
	.tp_getset = NULL,
	.tp_methods = py_samr_DispInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DispInfo_new,
};


static PyObject *py_samr_PwInfo_get_min_password_length(PyObject *obj, void *closure)
{
	struct samr_PwInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_min_password_length;
	py_min_password_length = PyLong_FromLong((uint16_t)(object->min_password_length));
	return py_min_password_length;
}

static int py_samr_PwInfo_set_min_password_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_PwInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->min_password_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->min_password_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->min_password_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_PwInfo_get_password_properties(PyObject *obj, void *closure)
{
	struct samr_PwInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_password_properties;
	py_password_properties = PyLong_FromUnsignedLongLong((uint32_t)(object->password_properties));
	return py_password_properties;
}

static int py_samr_PwInfo_set_password_properties(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_PwInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password_properties");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->password_properties));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->password_properties = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_PwInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "min_password_length"),
		.get = py_samr_PwInfo_get_min_password_length,
		.set = py_samr_PwInfo_set_min_password_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "password_properties"),
		.get = py_samr_PwInfo_get_password_properties,
		.set = py_samr_PwInfo_set_password_properties,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_PasswordProperties")
	},
	{ .name = NULL }
};

static PyObject *py_samr_PwInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_PwInfo, type);
}


static PyTypeObject samr_PwInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.PwInfo",
	.tp_getset = py_samr_PwInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_PwInfo_new,
};


static PyObject *py_userPwdChangeFailureInformation_get_extendedFailureReason(PyObject *obj, void *closure)
{
	struct userPwdChangeFailureInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_extendedFailureReason;
	py_extendedFailureReason = PyLong_FromUnsignedLongLong((uint32_t)(object->extendedFailureReason));
	return py_extendedFailureReason;
}

static int py_userPwdChangeFailureInformation_set_extendedFailureReason(PyObject *py_obj, PyObject *value, void *closure)
{
	struct userPwdChangeFailureInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->extendedFailureReason");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->extendedFailureReason));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->extendedFailureReason = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_userPwdChangeFailureInformation_get_filterModuleName(PyObject *obj, void *closure)
{
	struct userPwdChangeFailureInformation *object = pytalloc_get_ptr(obj);
	PyObject *py_filterModuleName;
	py_filterModuleName = pytalloc_reference_ex(lsa_String_Type, pytalloc_get_mem_ctx(obj), &object->filterModuleName);
	return py_filterModuleName;
}

static int py_userPwdChangeFailureInformation_set_filterModuleName(PyObject *py_obj, PyObject *value, void *closure)
{
	struct userPwdChangeFailureInformation *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->filterModuleName");
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->filterModuleName = *(struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_userPwdChangeFailureInformation_getsetters[] = {
	{
		.name = discard_const_p(char, "extendedFailureReason"),
		.get = py_userPwdChangeFailureInformation_get_extendedFailureReason,
		.set = py_userPwdChangeFailureInformation_set_extendedFailureReason,
		.doc = discard_const_p(char, "PIDL-generated element of base type samPwdChangeReason")
	},
	{
		.name = discard_const_p(char, "filterModuleName"),
		.get = py_userPwdChangeFailureInformation_get_filterModuleName,
		.set = py_userPwdChangeFailureInformation_set_filterModuleName,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{ .name = NULL }
};

static PyObject *py_userPwdChangeFailureInformation_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct userPwdChangeFailureInformation, type);
}


static PyTypeObject userPwdChangeFailureInformation_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.userPwdChangeFailureInformation",
	.tp_getset = py_userPwdChangeFailureInformation_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_userPwdChangeFailureInformation_new,
};


static PyObject *py_samr_ConnectInfo1_get_client_version(PyObject *obj, void *closure)
{
	struct samr_ConnectInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_client_version;
	py_client_version = PyLong_FromUnsignedLongLong((uint32_t)(object->client_version));
	return py_client_version;
}

static int py_samr_ConnectInfo1_set_client_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ConnectInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->client_version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->client_version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->client_version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_ConnectInfo1_get_supported_features(PyObject *obj, void *closure)
{
	struct samr_ConnectInfo1 *object = pytalloc_get_ptr(obj);
	PyObject *py_supported_features;
	py_supported_features = PyLong_FromUnsignedLongLong((uint32_t)(object->supported_features));
	return py_supported_features;
}

static int py_samr_ConnectInfo1_set_supported_features(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ConnectInfo1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->supported_features");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->supported_features));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->supported_features = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_ConnectInfo1_getsetters[] = {
	{
		.name = discard_const_p(char, "client_version"),
		.get = py_samr_ConnectInfo1_get_client_version,
		.set = py_samr_ConnectInfo1_set_client_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_ConnectVersion")
	},
	{
		.name = discard_const_p(char, "supported_features"),
		.get = py_samr_ConnectInfo1_get_supported_features,
		.set = py_samr_ConnectInfo1_set_supported_features,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_SupportedFeatures")
	},
	{ .name = NULL }
};

static PyObject *py_samr_ConnectInfo1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_ConnectInfo1, type);
}


static PyTypeObject samr_ConnectInfo1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.ConnectInfo1",
	.tp_getset = py_samr_ConnectInfo1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_ConnectInfo1_new,
};

static PyObject *py_import_samr_ConnectInfo(TALLOC_CTX *mem_ctx, int level, union samr_ConnectInfo *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&samr_ConnectInfo1_Type, mem_ctx, &in->info1);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union samr_ConnectInfo *py_export_samr_ConnectInfo(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union samr_ConnectInfo *ret = talloc_zero(mem_ctx, union samr_ConnectInfo);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->info1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_ConnectInfo1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->info1 = *(struct samr_ConnectInfo1 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_samr_ConnectInfo_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union samr_ConnectInfo *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union samr_ConnectInfo *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union samr_ConnectInfo!");
		return NULL;
	}

	return py_import_samr_ConnectInfo(mem_ctx, level, in);
}

static PyObject *py_samr_ConnectInfo_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union samr_ConnectInfo *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_samr_ConnectInfo(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_samr_ConnectInfo_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_ConnectInfo_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_ConnectInfo_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_samr_ConnectInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject samr_ConnectInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.ConnectInfo",
	.tp_getset = NULL,
	.tp_methods = py_samr_ConnectInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_ConnectInfo_new,
};


static PyObject *py_samr_ValidationBlob_get_length(PyObject *obj, void *closure)
{
	struct samr_ValidationBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromUnsignedLongLong((uint32_t)(object->length));
	return py_length;
}

static int py_samr_ValidationBlob_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidationBlob *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_ValidationBlob_get_data(PyObject *obj, void *closure)
{
	struct samr_ValidationBlob *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	if (object->data == NULL) {
		Py_RETURN_NONE;
	}
	if (object->data == NULL) {
		py_data = Py_None;
		Py_INCREF(py_data);
	} else {
		py_data = PyList_New(object->length);
		if (py_data == NULL) {
			return NULL;
		}
		{
			int data_cntr_1;
			for (data_cntr_1 = 0; data_cntr_1 < (object->length); data_cntr_1++) {
				PyObject *py_data_1;
				py_data_1 = PyLong_FromLong((uint16_t)((object->data)[data_cntr_1]));
				PyList_SetItem(py_data, data_cntr_1, py_data_1);
			}
		}
	}
	return py_data;
}

static int py_samr_ValidationBlob_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidationBlob *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->data));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->data");
		return -1;
	}
	if (value == Py_None) {
		object->data = NULL;
	} else {
		object->data = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int data_cntr_1;
			object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
			if (!object->data) { return -1; }
			talloc_set_name_const(object->data, "ARRAY: object->data");
			for (data_cntr_1 = 0; data_cntr_1 < PyList_GET_SIZE(value); data_cntr_1++) {
				if (PyList_GET_ITEM(value, data_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->data)[data_cntr_1]");
					return -1;
				}
				{
					const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->data)[data_cntr_1]));
					if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_1))) {
						unsigned long long test_var;
						test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_1));
						if (PyErr_Occurred() != NULL) {
							return -1;
						}
						if (test_var > uint_max) {
							PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
							  PyLong_Type.tp_name, uint_max, test_var);
							return -1;
						}
						(object->data)[data_cntr_1] = test_var;
					} else {
						PyErr_Format(PyExc_TypeError, "Expected type %s",
						  PyLong_Type.tp_name);
						return -1;
					}
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_samr_ValidationBlob_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_samr_ValidationBlob_get_length,
		.set = py_samr_ValidationBlob_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_samr_ValidationBlob_get_data,
		.set = py_samr_ValidationBlob_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_samr_ValidationBlob_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_ValidationBlob, type);
}


static PyTypeObject samr_ValidationBlob_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.ValidationBlob",
	.tp_getset = py_samr_ValidationBlob_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_ValidationBlob_new,
};


static PyObject *py_samr_ValidatePasswordInfo_get_fields_present(PyObject *obj, void *closure)
{
	struct samr_ValidatePasswordInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_fields_present;
	py_fields_present = PyLong_FromUnsignedLongLong((uint32_t)(object->fields_present));
	return py_fields_present;
}

static int py_samr_ValidatePasswordInfo_set_fields_present(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidatePasswordInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fields_present");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fields_present));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fields_present = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_ValidatePasswordInfo_get_last_password_change(PyObject *obj, void *closure)
{
	struct samr_ValidatePasswordInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_last_password_change;
	py_last_password_change = PyLong_FromUnsignedLongLong(object->last_password_change);
	return py_last_password_change;
}

static int py_samr_ValidatePasswordInfo_set_last_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidatePasswordInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_password_change");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_password_change));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_password_change = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_ValidatePasswordInfo_get_bad_password_time(PyObject *obj, void *closure)
{
	struct samr_ValidatePasswordInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_bad_password_time;
	py_bad_password_time = PyLong_FromUnsignedLongLong(object->bad_password_time);
	return py_bad_password_time;
}

static int py_samr_ValidatePasswordInfo_set_bad_password_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidatePasswordInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->bad_password_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->bad_password_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->bad_password_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_ValidatePasswordInfo_get_lockout_time(PyObject *obj, void *closure)
{
	struct samr_ValidatePasswordInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_lockout_time;
	py_lockout_time = PyLong_FromUnsignedLongLong(object->lockout_time);
	return py_lockout_time;
}

static int py_samr_ValidatePasswordInfo_set_lockout_time(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidatePasswordInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lockout_time");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->lockout_time));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->lockout_time = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_ValidatePasswordInfo_get_bad_pwd_count(PyObject *obj, void *closure)
{
	struct samr_ValidatePasswordInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_bad_pwd_count;
	py_bad_pwd_count = PyLong_FromUnsignedLongLong((uint32_t)(object->bad_pwd_count));
	return py_bad_pwd_count;
}

static int py_samr_ValidatePasswordInfo_set_bad_pwd_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidatePasswordInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->bad_pwd_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->bad_pwd_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->bad_pwd_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_ValidatePasswordInfo_get_pwd_history_len(PyObject *obj, void *closure)
{
	struct samr_ValidatePasswordInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_pwd_history_len;
	py_pwd_history_len = PyLong_FromUnsignedLongLong((uint32_t)(object->pwd_history_len));
	return py_pwd_history_len;
}

static int py_samr_ValidatePasswordInfo_set_pwd_history_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidatePasswordInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pwd_history_len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pwd_history_len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pwd_history_len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_ValidatePasswordInfo_get_pwd_history(PyObject *obj, void *closure)
{
	struct samr_ValidatePasswordInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_pwd_history;
	if (object->pwd_history == NULL) {
		Py_RETURN_NONE;
	}
	if (object->pwd_history == NULL) {
		py_pwd_history = Py_None;
		Py_INCREF(py_pwd_history);
	} else {
		py_pwd_history = PyList_New(object->pwd_history_len);
		if (py_pwd_history == NULL) {
			return NULL;
		}
		{
			int pwd_history_cntr_1;
			for (pwd_history_cntr_1 = 0; pwd_history_cntr_1 < (object->pwd_history_len); pwd_history_cntr_1++) {
				PyObject *py_pwd_history_1;
				py_pwd_history_1 = pytalloc_reference_ex(&samr_ValidationBlob_Type, object->pwd_history, &(object->pwd_history)[pwd_history_cntr_1]);
				PyList_SetItem(py_pwd_history, pwd_history_cntr_1, py_pwd_history_1);
			}
		}
	}
	return py_pwd_history;
}

static int py_samr_ValidatePasswordInfo_set_pwd_history(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidatePasswordInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->pwd_history));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pwd_history");
		return -1;
	}
	if (value == Py_None) {
		object->pwd_history = NULL;
	} else {
		object->pwd_history = NULL;
		PY_CHECK_TYPE(&PyList_Type, value, return -1;);
		{
			int pwd_history_cntr_1;
			object->pwd_history = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->pwd_history, PyList_GET_SIZE(value));
			if (!object->pwd_history) { return -1; }
			talloc_set_name_const(object->pwd_history, "ARRAY: object->pwd_history");
			for (pwd_history_cntr_1 = 0; pwd_history_cntr_1 < PyList_GET_SIZE(value); pwd_history_cntr_1++) {
				if (PyList_GET_ITEM(value, pwd_history_cntr_1) == NULL) {
					PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->pwd_history)[pwd_history_cntr_1]");
					return -1;
				}
				PY_CHECK_TYPE(&samr_ValidationBlob_Type, PyList_GET_ITEM(value, pwd_history_cntr_1), return -1;);
				if (talloc_reference(object->pwd_history, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, pwd_history_cntr_1))) == NULL) {
					PyErr_NoMemory();
					return -1;
				}
				(object->pwd_history)[pwd_history_cntr_1] = *(struct samr_ValidationBlob *)pytalloc_get_ptr(PyList_GET_ITEM(value, pwd_history_cntr_1));
			}
		}
	}
	return 0;
}

static PyGetSetDef py_samr_ValidatePasswordInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "fields_present"),
		.get = py_samr_ValidatePasswordInfo_get_fields_present,
		.set = py_samr_ValidatePasswordInfo_set_fields_present,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_ValidateFieldsPresent")
	},
	{
		.name = discard_const_p(char, "last_password_change"),
		.get = py_samr_ValidatePasswordInfo_get_last_password_change,
		.set = py_samr_ValidatePasswordInfo_set_last_password_change,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME_hyper")
	},
	{
		.name = discard_const_p(char, "bad_password_time"),
		.get = py_samr_ValidatePasswordInfo_get_bad_password_time,
		.set = py_samr_ValidatePasswordInfo_set_bad_password_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME_hyper")
	},
	{
		.name = discard_const_p(char, "lockout_time"),
		.get = py_samr_ValidatePasswordInfo_get_lockout_time,
		.set = py_samr_ValidatePasswordInfo_set_lockout_time,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME_hyper")
	},
	{
		.name = discard_const_p(char, "bad_pwd_count"),
		.get = py_samr_ValidatePasswordInfo_get_bad_pwd_count,
		.set = py_samr_ValidatePasswordInfo_set_bad_pwd_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pwd_history_len"),
		.get = py_samr_ValidatePasswordInfo_get_pwd_history_len,
		.set = py_samr_ValidatePasswordInfo_set_pwd_history_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "pwd_history"),
		.get = py_samr_ValidatePasswordInfo_get_pwd_history,
		.set = py_samr_ValidatePasswordInfo_set_pwd_history,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_ValidationBlob")
	},
	{ .name = NULL }
};

static PyObject *py_samr_ValidatePasswordInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_ValidatePasswordInfo, type);
}


static PyTypeObject samr_ValidatePasswordInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.ValidatePasswordInfo",
	.tp_getset = py_samr_ValidatePasswordInfo_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_ValidatePasswordInfo_new,
};


static PyObject *py_samr_ValidatePasswordRepCtr_get_info(PyObject *obj, void *closure)
{
	struct samr_ValidatePasswordRepCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pytalloc_reference_ex(&samr_ValidatePasswordInfo_Type, pytalloc_get_mem_ctx(obj), &object->info);
	return py_info;
}

static int py_samr_ValidatePasswordRepCtr_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidatePasswordRepCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	PY_CHECK_TYPE(&samr_ValidatePasswordInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->info = *(struct samr_ValidatePasswordInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_ValidatePasswordRepCtr_get_status(PyObject *obj, void *closure)
{
	struct samr_ValidatePasswordRepCtr *object = pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyLong_FromLong((uint16_t)(object->status));
	return py_status;
}

static int py_samr_ValidatePasswordRepCtr_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidatePasswordRepCtr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->status");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->status));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->status = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_ValidatePasswordRepCtr_getsetters[] = {
	{
		.name = discard_const_p(char, "info"),
		.get = py_samr_ValidatePasswordRepCtr_get_info,
		.set = py_samr_ValidatePasswordRepCtr_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_ValidatePasswordInfo")
	},
	{
		.name = discard_const_p(char, "status"),
		.get = py_samr_ValidatePasswordRepCtr_get_status,
		.set = py_samr_ValidatePasswordRepCtr_set_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_ValidationStatus")
	},
	{ .name = NULL }
};

static PyObject *py_samr_ValidatePasswordRepCtr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_ValidatePasswordRepCtr, type);
}


static PyTypeObject samr_ValidatePasswordRepCtr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.ValidatePasswordRepCtr",
	.tp_getset = py_samr_ValidatePasswordRepCtr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_ValidatePasswordRepCtr_new,
};

static PyObject *py_import_samr_ValidatePasswordRep(TALLOC_CTX *mem_ctx, int level, union samr_ValidatePasswordRep *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&samr_ValidatePasswordRepCtr_Type, mem_ctx, &in->ctr1);
			return ret;

		case 2:
			ret = pytalloc_reference_ex(&samr_ValidatePasswordRepCtr_Type, mem_ctx, &in->ctr2);
			return ret;

		case 3:
			ret = pytalloc_reference_ex(&samr_ValidatePasswordRepCtr_Type, mem_ctx, &in->ctr3);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union samr_ValidatePasswordRep *py_export_samr_ValidatePasswordRep(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union samr_ValidatePasswordRep *ret = talloc_zero(mem_ctx, union samr_ValidatePasswordRep);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_ValidatePasswordRepCtr_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ctr1 = *(struct samr_ValidatePasswordRepCtr *)pytalloc_get_ptr(in);
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr2");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_ValidatePasswordRepCtr_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ctr2 = *(struct samr_ValidatePasswordRepCtr *)pytalloc_get_ptr(in);
			break;

		case 3:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ctr3");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_ValidatePasswordRepCtr_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ctr3 = *(struct samr_ValidatePasswordRepCtr *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_samr_ValidatePasswordRep_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union samr_ValidatePasswordRep *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union samr_ValidatePasswordRep *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union samr_ValidatePasswordRep!");
		return NULL;
	}

	return py_import_samr_ValidatePasswordRep(mem_ctx, level, in);
}

static PyObject *py_samr_ValidatePasswordRep_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union samr_ValidatePasswordRep *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_samr_ValidatePasswordRep(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_samr_ValidatePasswordRep_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_ValidatePasswordRep_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_ValidatePasswordRep_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_samr_ValidatePasswordRep_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject samr_ValidatePasswordRep_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.ValidatePasswordRep",
	.tp_getset = NULL,
	.tp_methods = py_samr_ValidatePasswordRep_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_ValidatePasswordRep_new,
};


static PyObject *py_samr_ValidatePasswordReq3_get_info(PyObject *obj, void *closure)
{
	struct samr_ValidatePasswordReq3 *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pytalloc_reference_ex(&samr_ValidatePasswordInfo_Type, pytalloc_get_mem_ctx(obj), &object->info);
	return py_info;
}

static int py_samr_ValidatePasswordReq3_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidatePasswordReq3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	PY_CHECK_TYPE(&samr_ValidatePasswordInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->info = *(struct samr_ValidatePasswordInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_ValidatePasswordReq3_get_password(PyObject *obj, void *closure)
{
	struct samr_ValidatePasswordReq3 *object = pytalloc_get_ptr(obj);
	PyObject *py_password;
	py_password = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->password);
	return py_password;
}

static int py_samr_ValidatePasswordReq3_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidatePasswordReq3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password");
		return -1;
	}
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->password = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_ValidatePasswordReq3_get_account(PyObject *obj, void *closure)
{
	struct samr_ValidatePasswordReq3 *object = pytalloc_get_ptr(obj);
	PyObject *py_account;
	py_account = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->account);
	return py_account;
}

static int py_samr_ValidatePasswordReq3_set_account(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidatePasswordReq3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->account");
		return -1;
	}
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->account = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_ValidatePasswordReq3_get_hash(PyObject *obj, void *closure)
{
	struct samr_ValidatePasswordReq3 *object = pytalloc_get_ptr(obj);
	PyObject *py_hash;
	py_hash = pytalloc_reference_ex(&samr_ValidationBlob_Type, pytalloc_get_mem_ctx(obj), &object->hash);
	return py_hash;
}

static int py_samr_ValidatePasswordReq3_set_hash(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidatePasswordReq3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->hash");
		return -1;
	}
	PY_CHECK_TYPE(&samr_ValidationBlob_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->hash = *(struct samr_ValidationBlob *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_ValidatePasswordReq3_get_pwd_must_change_at_next_logon(PyObject *obj, void *closure)
{
	struct samr_ValidatePasswordReq3 *object = pytalloc_get_ptr(obj);
	PyObject *py_pwd_must_change_at_next_logon;
	py_pwd_must_change_at_next_logon = PyLong_FromLong((uint16_t)(object->pwd_must_change_at_next_logon));
	return py_pwd_must_change_at_next_logon;
}

static int py_samr_ValidatePasswordReq3_set_pwd_must_change_at_next_logon(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidatePasswordReq3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pwd_must_change_at_next_logon");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pwd_must_change_at_next_logon));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pwd_must_change_at_next_logon = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_ValidatePasswordReq3_get_clear_lockout(PyObject *obj, void *closure)
{
	struct samr_ValidatePasswordReq3 *object = pytalloc_get_ptr(obj);
	PyObject *py_clear_lockout;
	py_clear_lockout = PyLong_FromLong((uint16_t)(object->clear_lockout));
	return py_clear_lockout;
}

static int py_samr_ValidatePasswordReq3_set_clear_lockout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidatePasswordReq3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->clear_lockout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->clear_lockout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->clear_lockout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_ValidatePasswordReq3_getsetters[] = {
	{
		.name = discard_const_p(char, "info"),
		.get = py_samr_ValidatePasswordReq3_get_info,
		.set = py_samr_ValidatePasswordReq3_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_ValidatePasswordInfo")
	},
	{
		.name = discard_const_p(char, "password"),
		.get = py_samr_ValidatePasswordReq3_get_password,
		.set = py_samr_ValidatePasswordReq3_set_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "account"),
		.get = py_samr_ValidatePasswordReq3_get_account,
		.set = py_samr_ValidatePasswordReq3_set_account,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "hash"),
		.get = py_samr_ValidatePasswordReq3_get_hash,
		.set = py_samr_ValidatePasswordReq3_set_hash,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_ValidationBlob")
	},
	{
		.name = discard_const_p(char, "pwd_must_change_at_next_logon"),
		.get = py_samr_ValidatePasswordReq3_get_pwd_must_change_at_next_logon,
		.set = py_samr_ValidatePasswordReq3_set_pwd_must_change_at_next_logon,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "clear_lockout"),
		.get = py_samr_ValidatePasswordReq3_get_clear_lockout,
		.set = py_samr_ValidatePasswordReq3_set_clear_lockout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_samr_ValidatePasswordReq3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_ValidatePasswordReq3, type);
}


static PyTypeObject samr_ValidatePasswordReq3_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.ValidatePasswordReq3",
	.tp_getset = py_samr_ValidatePasswordReq3_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_ValidatePasswordReq3_new,
};


static PyObject *py_samr_ValidatePasswordReq2_get_info(PyObject *obj, void *closure)
{
	struct samr_ValidatePasswordReq2 *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pytalloc_reference_ex(&samr_ValidatePasswordInfo_Type, pytalloc_get_mem_ctx(obj), &object->info);
	return py_info;
}

static int py_samr_ValidatePasswordReq2_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidatePasswordReq2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	PY_CHECK_TYPE(&samr_ValidatePasswordInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->info = *(struct samr_ValidatePasswordInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_ValidatePasswordReq2_get_password(PyObject *obj, void *closure)
{
	struct samr_ValidatePasswordReq2 *object = pytalloc_get_ptr(obj);
	PyObject *py_password;
	py_password = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->password);
	return py_password;
}

static int py_samr_ValidatePasswordReq2_set_password(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidatePasswordReq2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password");
		return -1;
	}
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->password = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_ValidatePasswordReq2_get_account(PyObject *obj, void *closure)
{
	struct samr_ValidatePasswordReq2 *object = pytalloc_get_ptr(obj);
	PyObject *py_account;
	py_account = pytalloc_reference_ex(lsa_StringLarge_Type, pytalloc_get_mem_ctx(obj), &object->account);
	return py_account;
}

static int py_samr_ValidatePasswordReq2_set_account(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidatePasswordReq2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->account");
		return -1;
	}
	PY_CHECK_TYPE(lsa_StringLarge_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->account = *(struct lsa_StringLarge *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_ValidatePasswordReq2_get_hash(PyObject *obj, void *closure)
{
	struct samr_ValidatePasswordReq2 *object = pytalloc_get_ptr(obj);
	PyObject *py_hash;
	py_hash = pytalloc_reference_ex(&samr_ValidationBlob_Type, pytalloc_get_mem_ctx(obj), &object->hash);
	return py_hash;
}

static int py_samr_ValidatePasswordReq2_set_hash(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidatePasswordReq2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->hash");
		return -1;
	}
	PY_CHECK_TYPE(&samr_ValidationBlob_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->hash = *(struct samr_ValidationBlob *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_ValidatePasswordReq2_get_password_matched(PyObject *obj, void *closure)
{
	struct samr_ValidatePasswordReq2 *object = pytalloc_get_ptr(obj);
	PyObject *py_password_matched;
	py_password_matched = PyLong_FromLong((uint16_t)(object->password_matched));
	return py_password_matched;
}

static int py_samr_ValidatePasswordReq2_set_password_matched(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidatePasswordReq2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password_matched");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->password_matched));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->password_matched = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_ValidatePasswordReq2_getsetters[] = {
	{
		.name = discard_const_p(char, "info"),
		.get = py_samr_ValidatePasswordReq2_get_info,
		.set = py_samr_ValidatePasswordReq2_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_ValidatePasswordInfo")
	},
	{
		.name = discard_const_p(char, "password"),
		.get = py_samr_ValidatePasswordReq2_get_password,
		.set = py_samr_ValidatePasswordReq2_set_password,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "account"),
		.get = py_samr_ValidatePasswordReq2_get_account,
		.set = py_samr_ValidatePasswordReq2_set_account,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_StringLarge")
	},
	{
		.name = discard_const_p(char, "hash"),
		.get = py_samr_ValidatePasswordReq2_get_hash,
		.set = py_samr_ValidatePasswordReq2_set_hash,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_ValidationBlob")
	},
	{
		.name = discard_const_p(char, "password_matched"),
		.get = py_samr_ValidatePasswordReq2_get_password_matched,
		.set = py_samr_ValidatePasswordReq2_set_password_matched,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_samr_ValidatePasswordReq2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_ValidatePasswordReq2, type);
}


static PyTypeObject samr_ValidatePasswordReq2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.ValidatePasswordReq2",
	.tp_getset = py_samr_ValidatePasswordReq2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_ValidatePasswordReq2_new,
};


static PyObject *py_samr_ValidatePasswordReq1_get_info(PyObject *obj, void *closure)
{
	struct samr_ValidatePasswordReq1 *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	py_info = pytalloc_reference_ex(&samr_ValidatePasswordInfo_Type, pytalloc_get_mem_ctx(obj), &object->info);
	return py_info;
}

static int py_samr_ValidatePasswordReq1_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidatePasswordReq1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	PY_CHECK_TYPE(&samr_ValidatePasswordInfo_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->info = *(struct samr_ValidatePasswordInfo *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_ValidatePasswordReq1_get_password_matched(PyObject *obj, void *closure)
{
	struct samr_ValidatePasswordReq1 *object = pytalloc_get_ptr(obj);
	PyObject *py_password_matched;
	py_password_matched = PyLong_FromLong((uint16_t)(object->password_matched));
	return py_password_matched;
}

static int py_samr_ValidatePasswordReq1_set_password_matched(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_ValidatePasswordReq1 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->password_matched");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->password_matched));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->password_matched = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_samr_ValidatePasswordReq1_getsetters[] = {
	{
		.name = discard_const_p(char, "info"),
		.get = py_samr_ValidatePasswordReq1_get_info,
		.set = py_samr_ValidatePasswordReq1_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_ValidatePasswordInfo")
	},
	{
		.name = discard_const_p(char, "password_matched"),
		.get = py_samr_ValidatePasswordReq1_get_password_matched,
		.set = py_samr_ValidatePasswordReq1_set_password_matched,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_samr_ValidatePasswordReq1_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct samr_ValidatePasswordReq1, type);
}


static PyTypeObject samr_ValidatePasswordReq1_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.ValidatePasswordReq1",
	.tp_getset = py_samr_ValidatePasswordReq1_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_ValidatePasswordReq1_new,
};

static PyObject *py_import_samr_ValidatePasswordReq(TALLOC_CTX *mem_ctx, int level, union samr_ValidatePasswordReq *in)
{
	PyObject *ret;

	switch (level) {
		case 1:
			ret = pytalloc_reference_ex(&samr_ValidatePasswordReq1_Type, mem_ctx, &in->req1);
			return ret;

		case 2:
			ret = pytalloc_reference_ex(&samr_ValidatePasswordReq2_Type, mem_ctx, &in->req2);
			return ret;

		case 3:
			ret = pytalloc_reference_ex(&samr_ValidatePasswordReq3_Type, mem_ctx, &in->req3);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union samr_ValidatePasswordReq *py_export_samr_ValidatePasswordReq(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union samr_ValidatePasswordReq *ret = talloc_zero(mem_ctx, union samr_ValidatePasswordReq);
	switch (level) {
		case 1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->req1");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_ValidatePasswordReq1_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->req1 = *(struct samr_ValidatePasswordReq1 *)pytalloc_get_ptr(in);
			break;

		case 2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->req2");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_ValidatePasswordReq2_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->req2 = *(struct samr_ValidatePasswordReq2 *)pytalloc_get_ptr(in);
			break;

		case 3:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->req3");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&samr_ValidatePasswordReq3_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->req3 = *(struct samr_ValidatePasswordReq3 *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_samr_ValidatePasswordReq_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union samr_ValidatePasswordReq *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union samr_ValidatePasswordReq *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union samr_ValidatePasswordReq!");
		return NULL;
	}

	return py_import_samr_ValidatePasswordReq(mem_ctx, level, in);
}

static PyObject *py_samr_ValidatePasswordReq_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union samr_ValidatePasswordReq *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_samr_ValidatePasswordReq(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_samr_ValidatePasswordReq_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_ValidatePasswordReq_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_ValidatePasswordReq_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_samr_ValidatePasswordReq_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject samr_ValidatePasswordReq_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.ValidatePasswordReq",
	.tp_getset = NULL,
	.tp_methods = py_samr_ValidatePasswordReq_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_ValidatePasswordReq_new,
};



static PyObject *py_samr_Connect_in_get_system_name(PyObject *obj, void *closure)
{
	struct samr_Connect *object = pytalloc_get_ptr(obj);
	PyObject *py_system_name;
	if (object->in.system_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->in.system_name == NULL) {
		py_system_name = Py_None;
		Py_INCREF(py_system_name);
	} else {
		py_system_name = PyLong_FromLong((uint16_t)(*object->in.system_name));
	}
	return py_system_name;
}

static int py_samr_Connect_in_set_system_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_Connect *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.system_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.system_name");
		return -1;
	}
	if (value == Py_None) {
		object->in.system_name = NULL;
	} else {
		object->in.system_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.system_name);
		if (object->in.system_name == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.system_name));
			if (PyLong_Check(value)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(value);
				if (PyErr_Occurred() != NULL) {
					return -1;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return -1;
				}
				*object->in.system_name = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return -1;
			}
		}
	}
	return 0;
}

static PyObject *py_samr_Connect_in_get_access_mask(PyObject *obj, void *closure)
{
	struct samr_Connect *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_samr_Connect_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_Connect *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_Connect_out_get_connect_handle(PyObject *obj, void *closure)
{
	struct samr_Connect *object = pytalloc_get_ptr(obj);
	PyObject *py_connect_handle;
	if (object->out.connect_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_connect_handle = pytalloc_reference_ex(policy_handle_Type, object->out.connect_handle, object->out.connect_handle);
	return py_connect_handle;
}

static int py_samr_Connect_out_set_connect_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_Connect *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.connect_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.connect_handle");
		return -1;
	}
	object->out.connect_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.connect_handle);
	if (object->out.connect_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.connect_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_Connect_get_result(PyObject *obj, void *closure)
{
	struct samr_Connect *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_Connect_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_Connect *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_Connect_getsetters[] = {
	{
		.name = discard_const_p(char, "in_system_name"),
		.get = py_samr_Connect_in_get_system_name,
		.set = py_samr_Connect_in_set_system_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_samr_Connect_in_get_access_mask,
		.set = py_samr_Connect_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_ConnectAccessMask")
	},
	{
		.name = discard_const_p(char, "out_connect_handle"),
		.get = py_samr_Connect_out_get_connect_handle,
		.set = py_samr_Connect_out_set_connect_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_Connect_get_result,
		.set = py_samr_Connect_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_Connect_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_Connect, type);
	struct samr_Connect *_self = (struct samr_Connect *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.connect_handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_samr_Connect_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(0);
}

static PyObject *py_samr_Connect_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_Connect *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_Connect_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[0];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_Connect_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_Connect_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_Connect_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_Connect_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_Connect_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_Connect *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_Connect_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[0];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_Connect_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_Connect_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_Connect_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_Connect_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_Connect_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_Connect *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_Connect_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[0];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_Connect_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_Connect_ndr_print(py_obj, args, kwargs, "samr_Connect_in", NDR_IN);
}

static PyObject *py_samr_Connect_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_Connect_ndr_print(py_obj, args, kwargs, "samr_Connect_out", NDR_OUT);
}

static PyMethodDef py_samr_Connect_methods[] = {
	{ "opnum", (PyCFunction)py_samr_Connect_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.Connect.opnum() -> 0 (0x00) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_Connect_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_Connect_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_Connect_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_Connect_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_Connect_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_Connect_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_Connect_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.Connect",
	.tp_getset = py_samr_Connect_getsetters,
	.tp_methods = py_samr_Connect_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_Connect_new,
};

static bool pack_py_samr_Connect_args_in(PyObject *args, PyObject *kwargs, struct samr_Connect *r)
{
	PyObject *py_system_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"system_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:samr_Connect", discard_const_p(char *, kwnames), &py_system_name, &py_access_mask)) {
		return false;
	}

	if (py_system_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.system_name");
		return false;
	}
	if (py_system_name == Py_None) {
		r->in.system_name = NULL;
	} else {
		r->in.system_name = talloc_ptrtype(r, r->in.system_name);
		if (r->in.system_name == NULL) {
			PyErr_NoMemory();
			return false;
		}
		{
			const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.system_name));
			if (PyLong_Check(py_system_name)) {
				unsigned long long test_var;
				test_var = PyLong_AsUnsignedLongLong(py_system_name);
				if (PyErr_Occurred() != NULL) {
					return false;
				}
				if (test_var > uint_max) {
					PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
					  PyLong_Type.tp_name, uint_max, test_var);
					return false;
				}
				*r->in.system_name = test_var;
			} else {
				PyErr_Format(PyExc_TypeError, "Expected type %s",
				  PyLong_Type.tp_name);
				return false;
			}
		}
	}
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_samr_Connect_args_out(struct samr_Connect *r, bool raise_result_exception)
{
	PyObject *py_connect_handle = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_connect_handle = pytalloc_reference_ex(policy_handle_Type, r->out.connect_handle, r->out.connect_handle);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_connect_handle);
	}
	if (result_size == 1) {
		result = py_connect_handle;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_samr_Close_in_get_handle(PyObject *obj, void *closure)
{
	struct samr_Close *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_samr_Close_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_Close *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_Close_out_get_handle(PyObject *obj, void *closure)
{
	struct samr_Close *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->out.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->out.handle, object->out.handle);
	return py_handle;
}

static int py_samr_Close_out_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_Close *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.handle");
		return -1;
	}
	object->out.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.handle);
	if (object->out.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_Close_get_result(PyObject *obj, void *closure)
{
	struct samr_Close *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_Close_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_Close *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_Close_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_samr_Close_in_get_handle,
		.set = py_samr_Close_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_handle"),
		.get = py_samr_Close_out_get_handle,
		.set = py_samr_Close_out_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_Close_get_result,
		.set = py_samr_Close_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_Close_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_Close, type);
	struct samr_Close *_self = (struct samr_Close *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_samr_Close_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(1);
}

static PyObject *py_samr_Close_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_Close *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_Close_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[1];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_Close_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_Close_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_Close_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_Close_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_Close_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_Close *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_Close_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[1];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_Close_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_Close_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_Close_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_Close_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_Close_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_Close *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_Close_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[1];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_Close_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_Close_ndr_print(py_obj, args, kwargs, "samr_Close_in", NDR_IN);
}

static PyObject *py_samr_Close_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_Close_ndr_print(py_obj, args, kwargs, "samr_Close_out", NDR_OUT);
}

static PyMethodDef py_samr_Close_methods[] = {
	{ "opnum", (PyCFunction)py_samr_Close_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.Close.opnum() -> 1 (0x01) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_Close_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_Close_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_Close_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_Close_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_Close_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_Close_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_Close_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.Close",
	.tp_getset = py_samr_Close_getsetters,
	.tp_methods = py_samr_Close_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_Close_new,
};

static bool pack_py_samr_Close_args_in(PyObject *args, PyObject *kwargs, struct samr_Close *r)
{
	PyObject *py_handle;
	const char *kwnames[] = {
		"handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:samr_Close", discard_const_p(char *, kwnames), &py_handle)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	return true;
}

static PyObject *unpack_py_samr_Close_args_out(struct samr_Close *r, bool raise_result_exception)
{
	PyObject *py_handle = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_handle = pytalloc_reference_ex(policy_handle_Type, r->out.handle, r->out.handle);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_handle);
	}
	if (result_size == 1) {
		result = py_handle;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_samr_SetSecurity_in_get_handle(PyObject *obj, void *closure)
{
	struct samr_SetSecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_samr_SetSecurity_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SetSecurity *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_SetSecurity_in_get_sec_info(PyObject *obj, void *closure)
{
	struct samr_SetSecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_sec_info;
	py_sec_info = PyLong_FromUnsignedLongLong((uint32_t)(object->in.sec_info));
	return py_sec_info;
}

static int py_samr_SetSecurity_in_set_sec_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SetSecurity *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.sec_info");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.sec_info));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.sec_info = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_SetSecurity_in_get_sdbuf(PyObject *obj, void *closure)
{
	struct samr_SetSecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_sdbuf;
	if (object->in.sdbuf == NULL) {
		Py_RETURN_NONE;
	}
	py_sdbuf = pytalloc_reference_ex(sec_desc_buf_Type, object->in.sdbuf, object->in.sdbuf);
	return py_sdbuf;
}

static int py_samr_SetSecurity_in_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SetSecurity *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.sdbuf));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.sdbuf");
		return -1;
	}
	object->in.sdbuf = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.sdbuf);
	if (object->in.sdbuf == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.sdbuf = (struct sec_desc_buf *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_SetSecurity_get_result(PyObject *obj, void *closure)
{
	struct samr_SetSecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_SetSecurity_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SetSecurity *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_SetSecurity_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_samr_SetSecurity_in_get_handle,
		.set = py_samr_SetSecurity_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_sec_info"),
		.get = py_samr_SetSecurity_in_get_sec_info,
		.set = py_samr_SetSecurity_in_set_sec_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_secinfo")
	},
	{
		.name = discard_const_p(char, "in_sdbuf"),
		.get = py_samr_SetSecurity_in_get_sdbuf,
		.set = py_samr_SetSecurity_in_set_sdbuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type sec_desc_buf")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_SetSecurity_get_result,
		.set = py_samr_SetSecurity_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_SetSecurity_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_SetSecurity, type);
	struct samr_SetSecurity *_self = (struct samr_SetSecurity *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.sdbuf = talloc_zero(mem_ctx, struct sec_desc_buf);
	return self;
}

static PyObject *py_samr_SetSecurity_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(2);
}

static PyObject *py_samr_SetSecurity_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_SetSecurity *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_SetSecurity_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[2];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_SetSecurity_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_SetSecurity_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_SetSecurity_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_SetSecurity_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_SetSecurity_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_SetSecurity *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_SetSecurity_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[2];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_SetSecurity_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_SetSecurity_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_SetSecurity_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_SetSecurity_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_SetSecurity_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_SetSecurity *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_SetSecurity_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[2];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_SetSecurity_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_SetSecurity_ndr_print(py_obj, args, kwargs, "samr_SetSecurity_in", NDR_IN);
}

static PyObject *py_samr_SetSecurity_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_SetSecurity_ndr_print(py_obj, args, kwargs, "samr_SetSecurity_out", NDR_OUT);
}

static PyMethodDef py_samr_SetSecurity_methods[] = {
	{ "opnum", (PyCFunction)py_samr_SetSecurity_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.SetSecurity.opnum() -> 2 (0x02) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetSecurity_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetSecurity_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetSecurity_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetSecurity_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetSecurity_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetSecurity_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_SetSecurity_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.SetSecurity",
	.tp_getset = py_samr_SetSecurity_getsetters,
	.tp_methods = py_samr_SetSecurity_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_SetSecurity_new,
};

static bool pack_py_samr_SetSecurity_args_in(PyObject *args, PyObject *kwargs, struct samr_SetSecurity *r)
{
	PyObject *py_handle;
	PyObject *py_sec_info;
	PyObject *py_sdbuf;
	const char *kwnames[] = {
		"handle", "sec_info", "sdbuf", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:samr_SetSecurity", discard_const_p(char *, kwnames), &py_handle, &py_sec_info, &py_sdbuf)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_sec_info == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.sec_info");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.sec_info));
		if (PyLong_Check(py_sec_info)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_sec_info);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.sec_info = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_sdbuf == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.sdbuf");
		return false;
	}
	r->in.sdbuf = talloc_ptrtype(r, r->in.sdbuf);
	if (r->in.sdbuf == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(sec_desc_buf_Type, py_sdbuf, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sdbuf)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sdbuf = (struct sec_desc_buf *)pytalloc_get_ptr(py_sdbuf);
	return true;
}

static PyObject *unpack_py_samr_SetSecurity_args_out(struct samr_SetSecurity *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromNTSTATUS(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_samr_QuerySecurity_in_get_handle(PyObject *obj, void *closure)
{
	struct samr_QuerySecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_handle;
	if (object->in.handle == NULL) {
		Py_RETURN_NONE;
	}
	py_handle = pytalloc_reference_ex(policy_handle_Type, object->in.handle, object->in.handle);
	return py_handle;
}

static int py_samr_QuerySecurity_in_set_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_QuerySecurity *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.handle");
		return -1;
	}
	object->in.handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.handle);
	if (object->in.handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_QuerySecurity_in_get_sec_info(PyObject *obj, void *closure)
{
	struct samr_QuerySecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_sec_info;
	py_sec_info = PyLong_FromUnsignedLongLong((uint32_t)(object->in.sec_info));
	return py_sec_info;
}

static int py_samr_QuerySecurity_in_set_sec_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_QuerySecurity *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.sec_info");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.sec_info));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.sec_info = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_QuerySecurity_out_get_sdbuf(PyObject *obj, void *closure)
{
	struct samr_QuerySecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_sdbuf;
	if (object->out.sdbuf == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.sdbuf == NULL) {
		py_sdbuf = Py_None;
		Py_INCREF(py_sdbuf);
	} else {
		py_sdbuf = pytalloc_reference_ex(sec_desc_buf_Type, *object->out.sdbuf, *object->out.sdbuf);
	}
	return py_sdbuf;
}

static int py_samr_QuerySecurity_out_set_sdbuf(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_QuerySecurity *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.sdbuf));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.sdbuf");
		return -1;
	}
	object->out.sdbuf = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.sdbuf);
	if (object->out.sdbuf == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.sdbuf = NULL;
	} else {
		*object->out.sdbuf = NULL;
		PY_CHECK_TYPE(sec_desc_buf_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.sdbuf = (struct sec_desc_buf *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_samr_QuerySecurity_get_result(PyObject *obj, void *closure)
{
	struct samr_QuerySecurity *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_QuerySecurity_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_QuerySecurity *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_QuerySecurity_getsetters[] = {
	{
		.name = discard_const_p(char, "in_handle"),
		.get = py_samr_QuerySecurity_in_get_handle,
		.set = py_samr_QuerySecurity_in_set_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_sec_info"),
		.get = py_samr_QuerySecurity_in_get_sec_info,
		.set = py_samr_QuerySecurity_in_set_sec_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_secinfo")
	},
	{
		.name = discard_const_p(char, "out_sdbuf"),
		.get = py_samr_QuerySecurity_out_get_sdbuf,
		.set = py_samr_QuerySecurity_out_set_sdbuf,
		.doc = discard_const_p(char, "PIDL-generated element of base type sec_desc_buf")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_QuerySecurity_get_result,
		.set = py_samr_QuerySecurity_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_QuerySecurity_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_QuerySecurity, type);
	struct samr_QuerySecurity *_self = (struct samr_QuerySecurity *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.handle = talloc_zero(mem_ctx, struct policy_handle);
	/* a pointer to a NULL pointer */
	_self->out.sdbuf = talloc_zero(mem_ctx, struct sec_desc_buf *);
	return self;
}

static PyObject *py_samr_QuerySecurity_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(3);
}

static PyObject *py_samr_QuerySecurity_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_QuerySecurity *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_QuerySecurity_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[3];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_QuerySecurity_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_QuerySecurity_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_QuerySecurity_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_QuerySecurity_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_QuerySecurity_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_QuerySecurity *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_QuerySecurity_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[3];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_QuerySecurity_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_QuerySecurity_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_QuerySecurity_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_QuerySecurity_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_QuerySecurity_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_QuerySecurity *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_QuerySecurity_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[3];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_QuerySecurity_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_QuerySecurity_ndr_print(py_obj, args, kwargs, "samr_QuerySecurity_in", NDR_IN);
}

static PyObject *py_samr_QuerySecurity_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_QuerySecurity_ndr_print(py_obj, args, kwargs, "samr_QuerySecurity_out", NDR_OUT);
}

static PyMethodDef py_samr_QuerySecurity_methods[] = {
	{ "opnum", (PyCFunction)py_samr_QuerySecurity_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.QuerySecurity.opnum() -> 3 (0x03) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QuerySecurity_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QuerySecurity_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QuerySecurity_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QuerySecurity_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QuerySecurity_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QuerySecurity_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_QuerySecurity_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.QuerySecurity",
	.tp_getset = py_samr_QuerySecurity_getsetters,
	.tp_methods = py_samr_QuerySecurity_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_QuerySecurity_new,
};

static bool pack_py_samr_QuerySecurity_args_in(PyObject *args, PyObject *kwargs, struct samr_QuerySecurity *r)
{
	PyObject *py_handle;
	PyObject *py_sec_info;
	const char *kwnames[] = {
		"handle", "sec_info", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:samr_QuerySecurity", discard_const_p(char *, kwnames), &py_handle, &py_sec_info)) {
		return false;
	}

	if (py_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.handle");
		return false;
	}
	r->in.handle = talloc_ptrtype(r, r->in.handle);
	if (r->in.handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.handle = (struct policy_handle *)pytalloc_get_ptr(py_handle);
	if (py_sec_info == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.sec_info");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.sec_info));
		if (PyLong_Check(py_sec_info)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_sec_info);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.sec_info = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_samr_QuerySecurity_args_out(struct samr_QuerySecurity *r, bool raise_result_exception)
{
	PyObject *py_sdbuf = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (*r->out.sdbuf == NULL) {
		py_sdbuf = Py_None;
		Py_INCREF(py_sdbuf);
	} else {
		py_sdbuf = pytalloc_reference_ex(sec_desc_buf_Type, *r->out.sdbuf, *r->out.sdbuf);
	}
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_sdbuf);
	}
	if (result_size == 1) {
		result = py_sdbuf;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_samr_Shutdown_in_get_connect_handle(PyObject *obj, void *closure)
{
	struct samr_Shutdown *object = pytalloc_get_ptr(obj);
	PyObject *py_connect_handle;
	if (object->in.connect_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_connect_handle = pytalloc_reference_ex(policy_handle_Type, object->in.connect_handle, object->in.connect_handle);
	return py_connect_handle;
}

static int py_samr_Shutdown_in_set_connect_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_Shutdown *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.connect_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.connect_handle");
		return -1;
	}
	object->in.connect_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.connect_handle);
	if (object->in.connect_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.connect_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_Shutdown_get_result(PyObject *obj, void *closure)
{
	struct samr_Shutdown *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_Shutdown_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_Shutdown *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_Shutdown_getsetters[] = {
	{
		.name = discard_const_p(char, "in_connect_handle"),
		.get = py_samr_Shutdown_in_get_connect_handle,
		.set = py_samr_Shutdown_in_set_connect_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_Shutdown_get_result,
		.set = py_samr_Shutdown_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_Shutdown_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_Shutdown, type);
	struct samr_Shutdown *_self = (struct samr_Shutdown *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.connect_handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_samr_Shutdown_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(4);
}

static PyObject *py_samr_Shutdown_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_Shutdown *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_Shutdown_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[4];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_Shutdown_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_Shutdown_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_Shutdown_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_Shutdown_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_Shutdown_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_Shutdown *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_Shutdown_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[4];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_Shutdown_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_Shutdown_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_Shutdown_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_Shutdown_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_Shutdown_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_Shutdown *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_Shutdown_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[4];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_Shutdown_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_Shutdown_ndr_print(py_obj, args, kwargs, "samr_Shutdown_in", NDR_IN);
}

static PyObject *py_samr_Shutdown_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_Shutdown_ndr_print(py_obj, args, kwargs, "samr_Shutdown_out", NDR_OUT);
}

static PyMethodDef py_samr_Shutdown_methods[] = {
	{ "opnum", (PyCFunction)py_samr_Shutdown_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.Shutdown.opnum() -> 4 (0x04) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_Shutdown_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_Shutdown_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_Shutdown_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_Shutdown_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_Shutdown_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_Shutdown_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_Shutdown_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.Shutdown",
	.tp_getset = py_samr_Shutdown_getsetters,
	.tp_methods = py_samr_Shutdown_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_Shutdown_new,
};

static bool pack_py_samr_Shutdown_args_in(PyObject *args, PyObject *kwargs, struct samr_Shutdown *r)
{
	PyObject *py_connect_handle;
	const char *kwnames[] = {
		"connect_handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:samr_Shutdown", discard_const_p(char *, kwnames), &py_connect_handle)) {
		return false;
	}

	if (py_connect_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.connect_handle");
		return false;
	}
	r->in.connect_handle = talloc_ptrtype(r, r->in.connect_handle);
	if (r->in.connect_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_connect_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_connect_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.connect_handle = (struct policy_handle *)pytalloc_get_ptr(py_connect_handle);
	return true;
}

static PyObject *unpack_py_samr_Shutdown_args_out(struct samr_Shutdown *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromNTSTATUS(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_samr_LookupDomain_in_get_connect_handle(PyObject *obj, void *closure)
{
	struct samr_LookupDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_connect_handle;
	if (object->in.connect_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_connect_handle = pytalloc_reference_ex(policy_handle_Type, object->in.connect_handle, object->in.connect_handle);
	return py_connect_handle;
}

static int py_samr_LookupDomain_in_set_connect_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_LookupDomain *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.connect_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.connect_handle");
		return -1;
	}
	object->in.connect_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.connect_handle);
	if (object->in.connect_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.connect_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_LookupDomain_in_get_domain_name(PyObject *obj, void *closure)
{
	struct samr_LookupDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	if (object->in.domain_name == NULL) {
		Py_RETURN_NONE;
	}
	py_domain_name = pytalloc_reference_ex(lsa_String_Type, object->in.domain_name, object->in.domain_name);
	return py_domain_name;
}

static int py_samr_LookupDomain_in_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_LookupDomain *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.domain_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain_name");
		return -1;
	}
	object->in.domain_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_name);
	if (object->in.domain_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.domain_name = (struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_LookupDomain_out_get_sid(PyObject *obj, void *closure)
{
	struct samr_LookupDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->out.sid == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.sid == NULL) {
		py_sid = Py_None;
		Py_INCREF(py_sid);
	} else {
		py_sid = pytalloc_reference_ex(dom_sid_Type, *object->out.sid, *object->out.sid);
	}
	return py_sid;
}

static int py_samr_LookupDomain_out_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_LookupDomain *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.sid");
		return -1;
	}
	object->out.sid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.sid);
	if (object->out.sid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.sid = NULL;
	} else {
		*object->out.sid = NULL;
		PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.sid = (struct dom_sid *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_samr_LookupDomain_get_result(PyObject *obj, void *closure)
{
	struct samr_LookupDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_LookupDomain_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_LookupDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_LookupDomain_getsetters[] = {
	{
		.name = discard_const_p(char, "in_connect_handle"),
		.get = py_samr_LookupDomain_in_get_connect_handle,
		.set = py_samr_LookupDomain_in_set_connect_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_domain_name"),
		.get = py_samr_LookupDomain_in_get_domain_name,
		.set = py_samr_LookupDomain_in_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "out_sid"),
		.get = py_samr_LookupDomain_out_get_sid,
		.set = py_samr_LookupDomain_out_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid2")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_LookupDomain_get_result,
		.set = py_samr_LookupDomain_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_LookupDomain_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_LookupDomain, type);
	struct samr_LookupDomain *_self = (struct samr_LookupDomain *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.connect_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.domain_name = talloc_zero(mem_ctx, struct lsa_String);
	/* a pointer to a NULL pointer */
	_self->out.sid = talloc_zero(mem_ctx, struct dom_sid2 *);
	return self;
}

static PyObject *py_samr_LookupDomain_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(5);
}

static PyObject *py_samr_LookupDomain_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_LookupDomain *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_LookupDomain_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[5];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_LookupDomain_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_LookupDomain_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_LookupDomain_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_LookupDomain_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_LookupDomain_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_LookupDomain *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_LookupDomain_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[5];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_LookupDomain_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_LookupDomain_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_LookupDomain_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_LookupDomain_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_LookupDomain_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_LookupDomain *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 6) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_LookupDomain_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[5];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_LookupDomain_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_LookupDomain_ndr_print(py_obj, args, kwargs, "samr_LookupDomain_in", NDR_IN);
}

static PyObject *py_samr_LookupDomain_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_LookupDomain_ndr_print(py_obj, args, kwargs, "samr_LookupDomain_out", NDR_OUT);
}

static PyMethodDef py_samr_LookupDomain_methods[] = {
	{ "opnum", (PyCFunction)py_samr_LookupDomain_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.LookupDomain.opnum() -> 5 (0x05) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_LookupDomain_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_LookupDomain_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_LookupDomain_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_LookupDomain_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_LookupDomain_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_LookupDomain_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_LookupDomain_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.LookupDomain",
	.tp_getset = py_samr_LookupDomain_getsetters,
	.tp_methods = py_samr_LookupDomain_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_LookupDomain_new,
};

static bool pack_py_samr_LookupDomain_args_in(PyObject *args, PyObject *kwargs, struct samr_LookupDomain *r)
{
	PyObject *py_connect_handle;
	PyObject *py_domain_name;
	const char *kwnames[] = {
		"connect_handle", "domain_name", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:samr_LookupDomain", discard_const_p(char *, kwnames), &py_connect_handle, &py_domain_name)) {
		return false;
	}

	if (py_connect_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.connect_handle");
		return false;
	}
	r->in.connect_handle = talloc_ptrtype(r, r->in.connect_handle);
	if (r->in.connect_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_connect_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_connect_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.connect_handle = (struct policy_handle *)pytalloc_get_ptr(py_connect_handle);
	if (py_domain_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain_name");
		return false;
	}
	r->in.domain_name = talloc_ptrtype(r, r->in.domain_name);
	if (r->in.domain_name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(lsa_String_Type, py_domain_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_domain_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.domain_name = (struct lsa_String *)pytalloc_get_ptr(py_domain_name);
	return true;
}

static PyObject *unpack_py_samr_LookupDomain_args_out(struct samr_LookupDomain *r, bool raise_result_exception)
{
	PyObject *py_sid = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (*r->out.sid == NULL) {
		py_sid = Py_None;
		Py_INCREF(py_sid);
	} else {
		py_sid = pytalloc_reference_ex(dom_sid_Type, *r->out.sid, *r->out.sid);
	}
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_sid);
	}
	if (result_size == 1) {
		result = py_sid;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_samr_EnumDomains_in_get_connect_handle(PyObject *obj, void *closure)
{
	struct samr_EnumDomains *object = pytalloc_get_ptr(obj);
	PyObject *py_connect_handle;
	if (object->in.connect_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_connect_handle = pytalloc_reference_ex(policy_handle_Type, object->in.connect_handle, object->in.connect_handle);
	return py_connect_handle;
}

static int py_samr_EnumDomains_in_set_connect_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomains *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.connect_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.connect_handle");
		return -1;
	}
	object->in.connect_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.connect_handle);
	if (object->in.connect_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.connect_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_EnumDomains_in_get_resume_handle(PyObject *obj, void *closure)
{
	struct samr_EnumDomains *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->in.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.resume_handle));
	return py_resume_handle;
}

static int py_samr_EnumDomains_in_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomains *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.resume_handle");
		return -1;
	}
	object->in.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.resume_handle);
	if (object->in.resume_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.resume_handle));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->in.resume_handle = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_EnumDomains_out_get_resume_handle(PyObject *obj, void *closure)
{
	struct samr_EnumDomains *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->out.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.resume_handle));
	return py_resume_handle;
}

static int py_samr_EnumDomains_out_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomains *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.resume_handle");
		return -1;
	}
	object->out.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.resume_handle);
	if (object->out.resume_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.resume_handle));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.resume_handle = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_EnumDomains_out_get_sam(PyObject *obj, void *closure)
{
	struct samr_EnumDomains *object = pytalloc_get_ptr(obj);
	PyObject *py_sam;
	if (object->out.sam == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.sam == NULL) {
		py_sam = Py_None;
		Py_INCREF(py_sam);
	} else {
		py_sam = pytalloc_reference_ex(&samr_SamArray_Type, *object->out.sam, *object->out.sam);
	}
	return py_sam;
}

static int py_samr_EnumDomains_out_set_sam(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomains *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.sam));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.sam");
		return -1;
	}
	object->out.sam = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.sam);
	if (object->out.sam == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.sam = NULL;
	} else {
		*object->out.sam = NULL;
		PY_CHECK_TYPE(&samr_SamArray_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.sam = (struct samr_SamArray *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_samr_EnumDomains_in_get_buf_size(PyObject *obj, void *closure)
{
	struct samr_EnumDomains *object = pytalloc_get_ptr(obj);
	PyObject *py_buf_size;
	py_buf_size = PyLong_FromUnsignedLongLong((uint32_t)(object->in.buf_size));
	return py_buf_size;
}

static int py_samr_EnumDomains_in_set_buf_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomains *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.buf_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.buf_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.buf_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_EnumDomains_out_get_num_entries(PyObject *obj, void *closure)
{
	struct samr_EnumDomains *object = pytalloc_get_ptr(obj);
	PyObject *py_num_entries;
	if (object->out.num_entries == NULL) {
		Py_RETURN_NONE;
	}
	py_num_entries = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.num_entries));
	return py_num_entries;
}

static int py_samr_EnumDomains_out_set_num_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomains *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.num_entries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.num_entries");
		return -1;
	}
	object->out.num_entries = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.num_entries);
	if (object->out.num_entries == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.num_entries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.num_entries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_EnumDomains_get_result(PyObject *obj, void *closure)
{
	struct samr_EnumDomains *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_EnumDomains_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomains *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_EnumDomains_getsetters[] = {
	{
		.name = discard_const_p(char, "in_connect_handle"),
		.get = py_samr_EnumDomains_in_get_connect_handle,
		.set = py_samr_EnumDomains_in_set_connect_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_resume_handle"),
		.get = py_samr_EnumDomains_in_get_resume_handle,
		.set = py_samr_EnumDomains_in_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_resume_handle"),
		.get = py_samr_EnumDomains_out_get_resume_handle,
		.set = py_samr_EnumDomains_out_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_sam"),
		.get = py_samr_EnumDomains_out_get_sam,
		.set = py_samr_EnumDomains_out_set_sam,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_SamArray")
	},
	{
		.name = discard_const_p(char, "in_buf_size"),
		.get = py_samr_EnumDomains_in_get_buf_size,
		.set = py_samr_EnumDomains_in_set_buf_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_num_entries"),
		.get = py_samr_EnumDomains_out_get_num_entries,
		.set = py_samr_EnumDomains_out_set_num_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_EnumDomains_get_result,
		.set = py_samr_EnumDomains_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_EnumDomains_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_EnumDomains, type);
	struct samr_EnumDomains *_self = (struct samr_EnumDomains *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.connect_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.resume_handle = talloc_zero(mem_ctx, uint32_t);
	_self->out.resume_handle = talloc_zero(mem_ctx, uint32_t);
	/* a pointer to a NULL pointer */
	_self->out.sam = talloc_zero(mem_ctx, struct samr_SamArray *);
	_self->out.num_entries = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_samr_EnumDomains_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(6);
}

static PyObject *py_samr_EnumDomains_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_EnumDomains *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_EnumDomains_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[6];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_EnumDomains_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_EnumDomains_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_EnumDomains_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_EnumDomains_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_EnumDomains_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_EnumDomains *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_EnumDomains_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[6];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_EnumDomains_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_EnumDomains_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_EnumDomains_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_EnumDomains_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_EnumDomains_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_EnumDomains *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 7) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_EnumDomains_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[6];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_EnumDomains_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_EnumDomains_ndr_print(py_obj, args, kwargs, "samr_EnumDomains_in", NDR_IN);
}

static PyObject *py_samr_EnumDomains_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_EnumDomains_ndr_print(py_obj, args, kwargs, "samr_EnumDomains_out", NDR_OUT);
}

static PyMethodDef py_samr_EnumDomains_methods[] = {
	{ "opnum", (PyCFunction)py_samr_EnumDomains_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.EnumDomains.opnum() -> 6 (0x06) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomains_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomains_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomains_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomains_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomains_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomains_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_EnumDomains_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.EnumDomains",
	.tp_getset = py_samr_EnumDomains_getsetters,
	.tp_methods = py_samr_EnumDomains_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_EnumDomains_new,
};

static bool pack_py_samr_EnumDomains_args_in(PyObject *args, PyObject *kwargs, struct samr_EnumDomains *r)
{
	PyObject *py_connect_handle;
	PyObject *py_resume_handle;
	PyObject *py_buf_size;
	const char *kwnames[] = {
		"connect_handle", "resume_handle", "buf_size", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:samr_EnumDomains", discard_const_p(char *, kwnames), &py_connect_handle, &py_resume_handle, &py_buf_size)) {
		return false;
	}

	if (py_connect_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.connect_handle");
		return false;
	}
	r->in.connect_handle = talloc_ptrtype(r, r->in.connect_handle);
	if (r->in.connect_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_connect_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_connect_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.connect_handle = (struct policy_handle *)pytalloc_get_ptr(py_connect_handle);
	if (py_resume_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.resume_handle");
		return false;
	}
	r->in.resume_handle = talloc_ptrtype(r, r->in.resume_handle);
	if (r->in.resume_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.resume_handle));
		if (PyLong_Check(py_resume_handle)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_resume_handle);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			*r->in.resume_handle = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_buf_size == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.buf_size");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.buf_size));
		if (PyLong_Check(py_buf_size)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_buf_size);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.buf_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_samr_EnumDomains_args_out(struct samr_EnumDomains *r, bool raise_result_exception)
{
	PyObject *py_resume_handle = NULL;
	PyObject *py_sam = NULL;
	PyObject *py_num_entries = NULL;
	PyObject *result = NULL;
	size_t result_size = 3;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.resume_handle));
	PyTuple_SetItem(result, 0, py_resume_handle);

	if (*r->out.sam == NULL) {
		py_sam = Py_None;
		Py_INCREF(py_sam);
	} else {
		py_sam = pytalloc_reference_ex(&samr_SamArray_Type, *r->out.sam, *r->out.sam);
	}
	PyTuple_SetItem(result, 1, py_sam);

	py_num_entries = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.num_entries));
	PyTuple_SetItem(result, 2, py_num_entries);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 3, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_samr_OpenDomain_in_get_connect_handle(PyObject *obj, void *closure)
{
	struct samr_OpenDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_connect_handle;
	if (object->in.connect_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_connect_handle = pytalloc_reference_ex(policy_handle_Type, object->in.connect_handle, object->in.connect_handle);
	return py_connect_handle;
}

static int py_samr_OpenDomain_in_set_connect_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_OpenDomain *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.connect_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.connect_handle");
		return -1;
	}
	object->in.connect_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.connect_handle);
	if (object->in.connect_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.connect_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_OpenDomain_in_get_access_mask(PyObject *obj, void *closure)
{
	struct samr_OpenDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_samr_OpenDomain_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_OpenDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_OpenDomain_in_get_sid(PyObject *obj, void *closure)
{
	struct samr_OpenDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	if (object->in.sid == NULL) {
		Py_RETURN_NONE;
	}
	py_sid = pytalloc_reference_ex(dom_sid_Type, object->in.sid, object->in.sid);
	return py_sid;
}

static int py_samr_OpenDomain_in_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_OpenDomain *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.sid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.sid");
		return -1;
	}
	object->in.sid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.sid);
	if (object->in.sid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.sid = (struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_OpenDomain_out_get_domain_handle(PyObject *obj, void *closure)
{
	struct samr_OpenDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_handle;
	if (object->out.domain_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_domain_handle = pytalloc_reference_ex(policy_handle_Type, object->out.domain_handle, object->out.domain_handle);
	return py_domain_handle;
}

static int py_samr_OpenDomain_out_set_domain_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_OpenDomain *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.domain_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.domain_handle");
		return -1;
	}
	object->out.domain_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.domain_handle);
	if (object->out.domain_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.domain_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_OpenDomain_get_result(PyObject *obj, void *closure)
{
	struct samr_OpenDomain *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_OpenDomain_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_OpenDomain *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_OpenDomain_getsetters[] = {
	{
		.name = discard_const_p(char, "in_connect_handle"),
		.get = py_samr_OpenDomain_in_get_connect_handle,
		.set = py_samr_OpenDomain_in_set_connect_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_samr_OpenDomain_in_get_access_mask,
		.set = py_samr_OpenDomain_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_DomainAccessMask")
	},
	{
		.name = discard_const_p(char, "in_sid"),
		.get = py_samr_OpenDomain_in_get_sid,
		.set = py_samr_OpenDomain_in_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid2")
	},
	{
		.name = discard_const_p(char, "out_domain_handle"),
		.get = py_samr_OpenDomain_out_get_domain_handle,
		.set = py_samr_OpenDomain_out_set_domain_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_OpenDomain_get_result,
		.set = py_samr_OpenDomain_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_OpenDomain_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_OpenDomain, type);
	struct samr_OpenDomain *_self = (struct samr_OpenDomain *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.connect_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.sid = talloc_zero(mem_ctx, struct dom_sid2);
	_self->out.domain_handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_samr_OpenDomain_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(7);
}

static PyObject *py_samr_OpenDomain_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_OpenDomain *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_OpenDomain_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[7];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_OpenDomain_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_OpenDomain_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_OpenDomain_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_OpenDomain_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_OpenDomain_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_OpenDomain *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_OpenDomain_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[7];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_OpenDomain_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_OpenDomain_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_OpenDomain_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_OpenDomain_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_OpenDomain_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_OpenDomain *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 8) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_OpenDomain_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[7];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_OpenDomain_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_OpenDomain_ndr_print(py_obj, args, kwargs, "samr_OpenDomain_in", NDR_IN);
}

static PyObject *py_samr_OpenDomain_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_OpenDomain_ndr_print(py_obj, args, kwargs, "samr_OpenDomain_out", NDR_OUT);
}

static PyMethodDef py_samr_OpenDomain_methods[] = {
	{ "opnum", (PyCFunction)py_samr_OpenDomain_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.OpenDomain.opnum() -> 7 (0x07) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_OpenDomain_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_OpenDomain_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_OpenDomain_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_OpenDomain_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_OpenDomain_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_OpenDomain_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_OpenDomain_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.OpenDomain",
	.tp_getset = py_samr_OpenDomain_getsetters,
	.tp_methods = py_samr_OpenDomain_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_OpenDomain_new,
};

static bool pack_py_samr_OpenDomain_args_in(PyObject *args, PyObject *kwargs, struct samr_OpenDomain *r)
{
	PyObject *py_connect_handle;
	PyObject *py_access_mask;
	PyObject *py_sid;
	const char *kwnames[] = {
		"connect_handle", "access_mask", "sid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:samr_OpenDomain", discard_const_p(char *, kwnames), &py_connect_handle, &py_access_mask, &py_sid)) {
		return false;
	}

	if (py_connect_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.connect_handle");
		return false;
	}
	r->in.connect_handle = talloc_ptrtype(r, r->in.connect_handle);
	if (r->in.connect_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_connect_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_connect_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.connect_handle = (struct policy_handle *)pytalloc_get_ptr(py_connect_handle);
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_sid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.sid");
		return false;
	}
	r->in.sid = talloc_ptrtype(r, r->in.sid);
	if (r->in.sid == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(dom_sid_Type, py_sid, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sid)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sid = (struct dom_sid *)pytalloc_get_ptr(py_sid);
	return true;
}

static PyObject *unpack_py_samr_OpenDomain_args_out(struct samr_OpenDomain *r, bool raise_result_exception)
{
	PyObject *py_domain_handle = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_domain_handle = pytalloc_reference_ex(policy_handle_Type, r->out.domain_handle, r->out.domain_handle);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_domain_handle);
	}
	if (result_size == 1) {
		result = py_domain_handle;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_samr_QueryDomainInfo_in_get_domain_handle(PyObject *obj, void *closure)
{
	struct samr_QueryDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_handle;
	if (object->in.domain_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_domain_handle = pytalloc_reference_ex(policy_handle_Type, object->in.domain_handle, object->in.domain_handle);
	return py_domain_handle;
}

static int py_samr_QueryDomainInfo_in_set_domain_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_QueryDomainInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.domain_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain_handle");
		return -1;
	}
	object->in.domain_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_handle);
	if (object->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_QueryDomainInfo_in_get_level(PyObject *obj, void *closure)
{
	struct samr_QueryDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromLong((uint16_t)(object->in.level));
	return py_level;
}

static int py_samr_QueryDomainInfo_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_QueryDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_QueryDomainInfo_out_get_info(PyObject *obj, void *closure)
{
	struct samr_QueryDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->out.info == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pyrpc_import_union(&samr_DomainInfo_Type, *object->out.info, object->in.level, *object->out.info, "union samr_DomainInfo");
		if (py_info == NULL) {
			return NULL;
		}
	}
	return py_info;
}

static int py_samr_QueryDomainInfo_out_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_QueryDomainInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.info");
		return -1;
	}
	object->out.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.info);
	if (object->out.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.info = NULL;
	} else {
		*object->out.info = NULL;
		{
			union samr_DomainInfo *info_switch_2;
			info_switch_2 = (union samr_DomainInfo *)pyrpc_export_union(&samr_DomainInfo_Type, pytalloc_get_mem_ctx(py_obj), object->in.level, value, "union samr_DomainInfo");
			if (info_switch_2 == NULL) {
				return -1;
			}
			*object->out.info = info_switch_2;
		}
	}
	return 0;
}

static PyObject *py_samr_QueryDomainInfo_get_result(PyObject *obj, void *closure)
{
	struct samr_QueryDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_QueryDomainInfo_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_QueryDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_QueryDomainInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "in_domain_handle"),
		.get = py_samr_QueryDomainInfo_in_get_domain_handle,
		.set = py_samr_QueryDomainInfo_in_set_domain_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_level"),
		.get = py_samr_QueryDomainInfo_in_get_level,
		.set = py_samr_QueryDomainInfo_in_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_DomainInfoClass")
	},
	{
		.name = discard_const_p(char, "out_info"),
		.get = py_samr_QueryDomainInfo_out_get_info,
		.set = py_samr_QueryDomainInfo_out_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_DomainInfo")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_QueryDomainInfo_get_result,
		.set = py_samr_QueryDomainInfo_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_QueryDomainInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_QueryDomainInfo, type);
	struct samr_QueryDomainInfo *_self = (struct samr_QueryDomainInfo *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.domain_handle = talloc_zero(mem_ctx, struct policy_handle);
	/* a pointer to a NULL pointer */
	_self->out.info = talloc_zero(mem_ctx, union samr_DomainInfo *);
	return self;
}

static PyObject *py_samr_QueryDomainInfo_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(8);
}

static PyObject *py_samr_QueryDomainInfo_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_QueryDomainInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_QueryDomainInfo_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[8];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_QueryDomainInfo_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_QueryDomainInfo_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_QueryDomainInfo_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_QueryDomainInfo_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_QueryDomainInfo_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_QueryDomainInfo *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_QueryDomainInfo_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[8];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_QueryDomainInfo_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_QueryDomainInfo_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_QueryDomainInfo_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_QueryDomainInfo_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_QueryDomainInfo_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_QueryDomainInfo *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 9) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_QueryDomainInfo_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[8];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_QueryDomainInfo_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_QueryDomainInfo_ndr_print(py_obj, args, kwargs, "samr_QueryDomainInfo_in", NDR_IN);
}

static PyObject *py_samr_QueryDomainInfo_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_QueryDomainInfo_ndr_print(py_obj, args, kwargs, "samr_QueryDomainInfo_out", NDR_OUT);
}

static PyMethodDef py_samr_QueryDomainInfo_methods[] = {
	{ "opnum", (PyCFunction)py_samr_QueryDomainInfo_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.QueryDomainInfo.opnum() -> 8 (0x08) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryDomainInfo_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryDomainInfo_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryDomainInfo_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryDomainInfo_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryDomainInfo_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryDomainInfo_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_QueryDomainInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.QueryDomainInfo",
	.tp_getset = py_samr_QueryDomainInfo_getsetters,
	.tp_methods = py_samr_QueryDomainInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_QueryDomainInfo_new,
};

static bool pack_py_samr_QueryDomainInfo_args_in(PyObject *args, PyObject *kwargs, struct samr_QueryDomainInfo *r)
{
	PyObject *py_domain_handle;
	PyObject *py_level;
	const char *kwnames[] = {
		"domain_handle", "level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:samr_QueryDomainInfo", discard_const_p(char *, kwnames), &py_domain_handle, &py_level)) {
		return false;
	}

	if (py_domain_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain_handle");
		return false;
	}
	r->in.domain_handle = talloc_ptrtype(r, r->in.domain_handle);
	if (r->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_domain_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_domain_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(py_domain_handle);
	if (py_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.level));
		if (PyLong_Check(py_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_samr_QueryDomainInfo_args_out(struct samr_QueryDomainInfo *r, bool raise_result_exception)
{
	PyObject *py_info = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (*r->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pyrpc_import_union(&samr_DomainInfo_Type, *r->out.info, r->in.level, *r->out.info, "union samr_DomainInfo");
		if (py_info == NULL) {
			return NULL;
		}
	}
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_info);
	}
	if (result_size == 1) {
		result = py_info;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_samr_SetDomainInfo_in_get_domain_handle(PyObject *obj, void *closure)
{
	struct samr_SetDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_handle;
	if (object->in.domain_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_domain_handle = pytalloc_reference_ex(policy_handle_Type, object->in.domain_handle, object->in.domain_handle);
	return py_domain_handle;
}

static int py_samr_SetDomainInfo_in_set_domain_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SetDomainInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.domain_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain_handle");
		return -1;
	}
	object->in.domain_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_handle);
	if (object->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_SetDomainInfo_in_get_level(PyObject *obj, void *closure)
{
	struct samr_SetDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromLong((uint16_t)(object->in.level));
	return py_level;
}

static int py_samr_SetDomainInfo_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SetDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_SetDomainInfo_in_get_info(PyObject *obj, void *closure)
{
	struct samr_SetDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->in.info == NULL) {
		Py_RETURN_NONE;
	}
	py_info = pyrpc_import_union(&samr_DomainInfo_Type, object->in.info, object->in.level, object->in.info, "union samr_DomainInfo");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_samr_SetDomainInfo_in_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SetDomainInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.info");
		return -1;
	}
	object->in.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.info);
	if (object->in.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		union samr_DomainInfo *info_switch_1;
		info_switch_1 = (union samr_DomainInfo *)pyrpc_export_union(&samr_DomainInfo_Type, pytalloc_get_mem_ctx(py_obj), object->in.level, value, "union samr_DomainInfo");
		if (info_switch_1 == NULL) {
			return -1;
		}
		object->in.info = info_switch_1;
	}
	return 0;
}

static PyObject *py_samr_SetDomainInfo_get_result(PyObject *obj, void *closure)
{
	struct samr_SetDomainInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_SetDomainInfo_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SetDomainInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_SetDomainInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "in_domain_handle"),
		.get = py_samr_SetDomainInfo_in_get_domain_handle,
		.set = py_samr_SetDomainInfo_in_set_domain_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_level"),
		.get = py_samr_SetDomainInfo_in_get_level,
		.set = py_samr_SetDomainInfo_in_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_DomainInfoClass")
	},
	{
		.name = discard_const_p(char, "in_info"),
		.get = py_samr_SetDomainInfo_in_get_info,
		.set = py_samr_SetDomainInfo_in_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_DomainInfo")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_SetDomainInfo_get_result,
		.set = py_samr_SetDomainInfo_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_SetDomainInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_SetDomainInfo, type);
	struct samr_SetDomainInfo *_self = (struct samr_SetDomainInfo *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.domain_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.info = talloc_zero(mem_ctx, union samr_DomainInfo);
	return self;
}

static PyObject *py_samr_SetDomainInfo_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(9);
}

static PyObject *py_samr_SetDomainInfo_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_SetDomainInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 10) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_SetDomainInfo_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[9];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_SetDomainInfo_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_SetDomainInfo_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_SetDomainInfo_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_SetDomainInfo_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_SetDomainInfo_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_SetDomainInfo *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 10) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_SetDomainInfo_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[9];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_SetDomainInfo_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_SetDomainInfo_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_SetDomainInfo_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_SetDomainInfo_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_SetDomainInfo_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_SetDomainInfo *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 10) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_SetDomainInfo_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[9];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_SetDomainInfo_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_SetDomainInfo_ndr_print(py_obj, args, kwargs, "samr_SetDomainInfo_in", NDR_IN);
}

static PyObject *py_samr_SetDomainInfo_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_SetDomainInfo_ndr_print(py_obj, args, kwargs, "samr_SetDomainInfo_out", NDR_OUT);
}

static PyMethodDef py_samr_SetDomainInfo_methods[] = {
	{ "opnum", (PyCFunction)py_samr_SetDomainInfo_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.SetDomainInfo.opnum() -> 9 (0x09) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetDomainInfo_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetDomainInfo_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetDomainInfo_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetDomainInfo_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetDomainInfo_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetDomainInfo_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_SetDomainInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.SetDomainInfo",
	.tp_getset = py_samr_SetDomainInfo_getsetters,
	.tp_methods = py_samr_SetDomainInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_SetDomainInfo_new,
};

static bool pack_py_samr_SetDomainInfo_args_in(PyObject *args, PyObject *kwargs, struct samr_SetDomainInfo *r)
{
	PyObject *py_domain_handle;
	PyObject *py_level;
	PyObject *py_info;
	const char *kwnames[] = {
		"domain_handle", "level", "info", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:samr_SetDomainInfo", discard_const_p(char *, kwnames), &py_domain_handle, &py_level, &py_info)) {
		return false;
	}

	if (py_domain_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain_handle");
		return false;
	}
	r->in.domain_handle = talloc_ptrtype(r, r->in.domain_handle);
	if (r->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_domain_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_domain_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(py_domain_handle);
	if (py_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.level));
		if (PyLong_Check(py_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_info == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.info");
		return false;
	}
	r->in.info = talloc_ptrtype(r, r->in.info);
	if (r->in.info == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		union samr_DomainInfo *info_switch_1;
		info_switch_1 = (union samr_DomainInfo *)pyrpc_export_union(&samr_DomainInfo_Type, r, r->in.level, py_info, "union samr_DomainInfo");
		if (info_switch_1 == NULL) {
			return false;
		}
		r->in.info = info_switch_1;
	}
	return true;
}

static PyObject *unpack_py_samr_SetDomainInfo_args_out(struct samr_SetDomainInfo *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromNTSTATUS(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_samr_CreateDomainGroup_in_get_domain_handle(PyObject *obj, void *closure)
{
	struct samr_CreateDomainGroup *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_handle;
	if (object->in.domain_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_domain_handle = pytalloc_reference_ex(policy_handle_Type, object->in.domain_handle, object->in.domain_handle);
	return py_domain_handle;
}

static int py_samr_CreateDomainGroup_in_set_domain_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_CreateDomainGroup *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.domain_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain_handle");
		return -1;
	}
	object->in.domain_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_handle);
	if (object->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_CreateDomainGroup_in_get_name(PyObject *obj, void *closure)
{
	struct samr_CreateDomainGroup *object = pytalloc_get_ptr(obj);
	PyObject *py_name;
	if (object->in.name == NULL) {
		Py_RETURN_NONE;
	}
	py_name = pytalloc_reference_ex(lsa_String_Type, object->in.name, object->in.name);
	return py_name;
}

static int py_samr_CreateDomainGroup_in_set_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_CreateDomainGroup *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.name");
		return -1;
	}
	object->in.name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.name);
	if (object->in.name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.name = (struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_CreateDomainGroup_in_get_access_mask(PyObject *obj, void *closure)
{
	struct samr_CreateDomainGroup *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_samr_CreateDomainGroup_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_CreateDomainGroup *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_CreateDomainGroup_out_get_group_handle(PyObject *obj, void *closure)
{
	struct samr_CreateDomainGroup *object = pytalloc_get_ptr(obj);
	PyObject *py_group_handle;
	if (object->out.group_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_group_handle = pytalloc_reference_ex(policy_handle_Type, object->out.group_handle, object->out.group_handle);
	return py_group_handle;
}

static int py_samr_CreateDomainGroup_out_set_group_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_CreateDomainGroup *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.group_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.group_handle");
		return -1;
	}
	object->out.group_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.group_handle);
	if (object->out.group_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.group_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_CreateDomainGroup_out_get_rid(PyObject *obj, void *closure)
{
	struct samr_CreateDomainGroup *object = pytalloc_get_ptr(obj);
	PyObject *py_rid;
	if (object->out.rid == NULL) {
		Py_RETURN_NONE;
	}
	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.rid));
	return py_rid;
}

static int py_samr_CreateDomainGroup_out_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_CreateDomainGroup *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.rid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.rid");
		return -1;
	}
	object->out.rid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.rid);
	if (object->out.rid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.rid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_CreateDomainGroup_get_result(PyObject *obj, void *closure)
{
	struct samr_CreateDomainGroup *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_CreateDomainGroup_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_CreateDomainGroup *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_CreateDomainGroup_getsetters[] = {
	{
		.name = discard_const_p(char, "in_domain_handle"),
		.get = py_samr_CreateDomainGroup_in_get_domain_handle,
		.set = py_samr_CreateDomainGroup_in_set_domain_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_name"),
		.get = py_samr_CreateDomainGroup_in_get_name,
		.set = py_samr_CreateDomainGroup_in_set_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_samr_CreateDomainGroup_in_get_access_mask,
		.set = py_samr_CreateDomainGroup_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_GroupAccessMask")
	},
	{
		.name = discard_const_p(char, "out_group_handle"),
		.get = py_samr_CreateDomainGroup_out_get_group_handle,
		.set = py_samr_CreateDomainGroup_out_set_group_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_rid"),
		.get = py_samr_CreateDomainGroup_out_get_rid,
		.set = py_samr_CreateDomainGroup_out_set_rid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_CreateDomainGroup_get_result,
		.set = py_samr_CreateDomainGroup_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_CreateDomainGroup_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_CreateDomainGroup, type);
	struct samr_CreateDomainGroup *_self = (struct samr_CreateDomainGroup *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.domain_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.name = talloc_zero(mem_ctx, struct lsa_String);
	_self->out.group_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.rid = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_samr_CreateDomainGroup_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(10);
}

static PyObject *py_samr_CreateDomainGroup_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_CreateDomainGroup *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_CreateDomainGroup_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[10];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_CreateDomainGroup_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_CreateDomainGroup_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_CreateDomainGroup_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_CreateDomainGroup_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_CreateDomainGroup_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_CreateDomainGroup *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_CreateDomainGroup_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[10];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_CreateDomainGroup_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_CreateDomainGroup_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_CreateDomainGroup_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_CreateDomainGroup_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_CreateDomainGroup_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_CreateDomainGroup *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 11) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_CreateDomainGroup_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[10];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_CreateDomainGroup_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_CreateDomainGroup_ndr_print(py_obj, args, kwargs, "samr_CreateDomainGroup_in", NDR_IN);
}

static PyObject *py_samr_CreateDomainGroup_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_CreateDomainGroup_ndr_print(py_obj, args, kwargs, "samr_CreateDomainGroup_out", NDR_OUT);
}

static PyMethodDef py_samr_CreateDomainGroup_methods[] = {
	{ "opnum", (PyCFunction)py_samr_CreateDomainGroup_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.CreateDomainGroup.opnum() -> 10 (0x0a) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_CreateDomainGroup_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_CreateDomainGroup_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_CreateDomainGroup_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_CreateDomainGroup_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_CreateDomainGroup_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_CreateDomainGroup_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_CreateDomainGroup_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.CreateDomainGroup",
	.tp_getset = py_samr_CreateDomainGroup_getsetters,
	.tp_methods = py_samr_CreateDomainGroup_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_CreateDomainGroup_new,
};

static bool pack_py_samr_CreateDomainGroup_args_in(PyObject *args, PyObject *kwargs, struct samr_CreateDomainGroup *r)
{
	PyObject *py_domain_handle;
	PyObject *py_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"domain_handle", "name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:samr_CreateDomainGroup", discard_const_p(char *, kwnames), &py_domain_handle, &py_name, &py_access_mask)) {
		return false;
	}

	if (py_domain_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain_handle");
		return false;
	}
	r->in.domain_handle = talloc_ptrtype(r, r->in.domain_handle);
	if (r->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_domain_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_domain_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(py_domain_handle);
	if (py_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.name");
		return false;
	}
	r->in.name = talloc_ptrtype(r, r->in.name);
	if (r->in.name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(lsa_String_Type, py_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.name = (struct lsa_String *)pytalloc_get_ptr(py_name);
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_samr_CreateDomainGroup_args_out(struct samr_CreateDomainGroup *r, bool raise_result_exception)
{
	PyObject *py_group_handle = NULL;
	PyObject *py_rid = NULL;
	PyObject *result = NULL;
	size_t result_size = 2;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_group_handle = pytalloc_reference_ex(policy_handle_Type, r->out.group_handle, r->out.group_handle);
	PyTuple_SetItem(result, 0, py_group_handle);

	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.rid));
	PyTuple_SetItem(result, 1, py_rid);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 2, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_samr_EnumDomainGroups_in_get_domain_handle(PyObject *obj, void *closure)
{
	struct samr_EnumDomainGroups *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_handle;
	if (object->in.domain_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_domain_handle = pytalloc_reference_ex(policy_handle_Type, object->in.domain_handle, object->in.domain_handle);
	return py_domain_handle;
}

static int py_samr_EnumDomainGroups_in_set_domain_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomainGroups *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.domain_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain_handle");
		return -1;
	}
	object->in.domain_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_handle);
	if (object->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_EnumDomainGroups_in_get_resume_handle(PyObject *obj, void *closure)
{
	struct samr_EnumDomainGroups *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->in.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.resume_handle));
	return py_resume_handle;
}

static int py_samr_EnumDomainGroups_in_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomainGroups *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.resume_handle");
		return -1;
	}
	object->in.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.resume_handle);
	if (object->in.resume_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.resume_handle));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->in.resume_handle = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_EnumDomainGroups_out_get_resume_handle(PyObject *obj, void *closure)
{
	struct samr_EnumDomainGroups *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->out.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.resume_handle));
	return py_resume_handle;
}

static int py_samr_EnumDomainGroups_out_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomainGroups *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.resume_handle");
		return -1;
	}
	object->out.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.resume_handle);
	if (object->out.resume_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.resume_handle));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.resume_handle = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_EnumDomainGroups_out_get_sam(PyObject *obj, void *closure)
{
	struct samr_EnumDomainGroups *object = pytalloc_get_ptr(obj);
	PyObject *py_sam;
	if (object->out.sam == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.sam == NULL) {
		py_sam = Py_None;
		Py_INCREF(py_sam);
	} else {
		py_sam = pytalloc_reference_ex(&samr_SamArray_Type, *object->out.sam, *object->out.sam);
	}
	return py_sam;
}

static int py_samr_EnumDomainGroups_out_set_sam(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomainGroups *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.sam));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.sam");
		return -1;
	}
	object->out.sam = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.sam);
	if (object->out.sam == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.sam = NULL;
	} else {
		*object->out.sam = NULL;
		PY_CHECK_TYPE(&samr_SamArray_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.sam = (struct samr_SamArray *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_samr_EnumDomainGroups_in_get_max_size(PyObject *obj, void *closure)
{
	struct samr_EnumDomainGroups *object = pytalloc_get_ptr(obj);
	PyObject *py_max_size;
	py_max_size = PyLong_FromUnsignedLongLong((uint32_t)(object->in.max_size));
	return py_max_size;
}

static int py_samr_EnumDomainGroups_in_set_max_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomainGroups *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.max_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.max_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.max_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_EnumDomainGroups_out_get_num_entries(PyObject *obj, void *closure)
{
	struct samr_EnumDomainGroups *object = pytalloc_get_ptr(obj);
	PyObject *py_num_entries;
	if (object->out.num_entries == NULL) {
		Py_RETURN_NONE;
	}
	py_num_entries = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.num_entries));
	return py_num_entries;
}

static int py_samr_EnumDomainGroups_out_set_num_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomainGroups *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.num_entries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.num_entries");
		return -1;
	}
	object->out.num_entries = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.num_entries);
	if (object->out.num_entries == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.num_entries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.num_entries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_EnumDomainGroups_get_result(PyObject *obj, void *closure)
{
	struct samr_EnumDomainGroups *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_EnumDomainGroups_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomainGroups *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_EnumDomainGroups_getsetters[] = {
	{
		.name = discard_const_p(char, "in_domain_handle"),
		.get = py_samr_EnumDomainGroups_in_get_domain_handle,
		.set = py_samr_EnumDomainGroups_in_set_domain_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_resume_handle"),
		.get = py_samr_EnumDomainGroups_in_get_resume_handle,
		.set = py_samr_EnumDomainGroups_in_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_resume_handle"),
		.get = py_samr_EnumDomainGroups_out_get_resume_handle,
		.set = py_samr_EnumDomainGroups_out_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_sam"),
		.get = py_samr_EnumDomainGroups_out_get_sam,
		.set = py_samr_EnumDomainGroups_out_set_sam,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_SamArray")
	},
	{
		.name = discard_const_p(char, "in_max_size"),
		.get = py_samr_EnumDomainGroups_in_get_max_size,
		.set = py_samr_EnumDomainGroups_in_set_max_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_num_entries"),
		.get = py_samr_EnumDomainGroups_out_get_num_entries,
		.set = py_samr_EnumDomainGroups_out_set_num_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_EnumDomainGroups_get_result,
		.set = py_samr_EnumDomainGroups_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_EnumDomainGroups_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_EnumDomainGroups, type);
	struct samr_EnumDomainGroups *_self = (struct samr_EnumDomainGroups *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.domain_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.resume_handle = talloc_zero(mem_ctx, uint32_t);
	_self->out.resume_handle = talloc_zero(mem_ctx, uint32_t);
	/* a pointer to a NULL pointer */
	_self->out.sam = talloc_zero(mem_ctx, struct samr_SamArray *);
	_self->out.num_entries = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_samr_EnumDomainGroups_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(11);
}

static PyObject *py_samr_EnumDomainGroups_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_EnumDomainGroups *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_EnumDomainGroups_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[11];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_EnumDomainGroups_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_EnumDomainGroups_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_EnumDomainGroups_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_EnumDomainGroups_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_EnumDomainGroups_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_EnumDomainGroups *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_EnumDomainGroups_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[11];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_EnumDomainGroups_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_EnumDomainGroups_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_EnumDomainGroups_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_EnumDomainGroups_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_EnumDomainGroups_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_EnumDomainGroups *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 12) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_EnumDomainGroups_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[11];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_EnumDomainGroups_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_EnumDomainGroups_ndr_print(py_obj, args, kwargs, "samr_EnumDomainGroups_in", NDR_IN);
}

static PyObject *py_samr_EnumDomainGroups_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_EnumDomainGroups_ndr_print(py_obj, args, kwargs, "samr_EnumDomainGroups_out", NDR_OUT);
}

static PyMethodDef py_samr_EnumDomainGroups_methods[] = {
	{ "opnum", (PyCFunction)py_samr_EnumDomainGroups_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.EnumDomainGroups.opnum() -> 11 (0x0b) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomainGroups_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomainGroups_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomainGroups_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomainGroups_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomainGroups_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomainGroups_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_EnumDomainGroups_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.EnumDomainGroups",
	.tp_getset = py_samr_EnumDomainGroups_getsetters,
	.tp_methods = py_samr_EnumDomainGroups_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_EnumDomainGroups_new,
};

static bool pack_py_samr_EnumDomainGroups_args_in(PyObject *args, PyObject *kwargs, struct samr_EnumDomainGroups *r)
{
	PyObject *py_domain_handle;
	PyObject *py_resume_handle;
	PyObject *py_max_size;
	const char *kwnames[] = {
		"domain_handle", "resume_handle", "max_size", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:samr_EnumDomainGroups", discard_const_p(char *, kwnames), &py_domain_handle, &py_resume_handle, &py_max_size)) {
		return false;
	}

	if (py_domain_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain_handle");
		return false;
	}
	r->in.domain_handle = talloc_ptrtype(r, r->in.domain_handle);
	if (r->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_domain_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_domain_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(py_domain_handle);
	if (py_resume_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.resume_handle");
		return false;
	}
	r->in.resume_handle = talloc_ptrtype(r, r->in.resume_handle);
	if (r->in.resume_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.resume_handle));
		if (PyLong_Check(py_resume_handle)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_resume_handle);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			*r->in.resume_handle = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_max_size == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.max_size");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.max_size));
		if (PyLong_Check(py_max_size)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_max_size);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.max_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_samr_EnumDomainGroups_args_out(struct samr_EnumDomainGroups *r, bool raise_result_exception)
{
	PyObject *py_resume_handle = NULL;
	PyObject *py_sam = NULL;
	PyObject *py_num_entries = NULL;
	PyObject *result = NULL;
	size_t result_size = 3;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.resume_handle));
	PyTuple_SetItem(result, 0, py_resume_handle);

	if (*r->out.sam == NULL) {
		py_sam = Py_None;
		Py_INCREF(py_sam);
	} else {
		py_sam = pytalloc_reference_ex(&samr_SamArray_Type, *r->out.sam, *r->out.sam);
	}
	PyTuple_SetItem(result, 1, py_sam);

	py_num_entries = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.num_entries));
	PyTuple_SetItem(result, 2, py_num_entries);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 3, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_samr_CreateUser_in_get_domain_handle(PyObject *obj, void *closure)
{
	struct samr_CreateUser *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_handle;
	if (object->in.domain_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_domain_handle = pytalloc_reference_ex(policy_handle_Type, object->in.domain_handle, object->in.domain_handle);
	return py_domain_handle;
}

static int py_samr_CreateUser_in_set_domain_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_CreateUser *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.domain_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain_handle");
		return -1;
	}
	object->in.domain_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_handle);
	if (object->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_CreateUser_in_get_account_name(PyObject *obj, void *closure)
{
	struct samr_CreateUser *object = pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	if (object->in.account_name == NULL) {
		Py_RETURN_NONE;
	}
	py_account_name = pytalloc_reference_ex(lsa_String_Type, object->in.account_name, object->in.account_name);
	return py_account_name;
}

static int py_samr_CreateUser_in_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_CreateUser *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.account_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.account_name");
		return -1;
	}
	object->in.account_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.account_name);
	if (object->in.account_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.account_name = (struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_CreateUser_in_get_access_mask(PyObject *obj, void *closure)
{
	struct samr_CreateUser *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_samr_CreateUser_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_CreateUser *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_CreateUser_out_get_user_handle(PyObject *obj, void *closure)
{
	struct samr_CreateUser *object = pytalloc_get_ptr(obj);
	PyObject *py_user_handle;
	if (object->out.user_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_user_handle = pytalloc_reference_ex(policy_handle_Type, object->out.user_handle, object->out.user_handle);
	return py_user_handle;
}

static int py_samr_CreateUser_out_set_user_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_CreateUser *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.user_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.user_handle");
		return -1;
	}
	object->out.user_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.user_handle);
	if (object->out.user_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.user_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_CreateUser_out_get_rid(PyObject *obj, void *closure)
{
	struct samr_CreateUser *object = pytalloc_get_ptr(obj);
	PyObject *py_rid;
	if (object->out.rid == NULL) {
		Py_RETURN_NONE;
	}
	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.rid));
	return py_rid;
}

static int py_samr_CreateUser_out_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_CreateUser *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.rid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.rid");
		return -1;
	}
	object->out.rid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.rid);
	if (object->out.rid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.rid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_CreateUser_get_result(PyObject *obj, void *closure)
{
	struct samr_CreateUser *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_CreateUser_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_CreateUser *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_CreateUser_getsetters[] = {
	{
		.name = discard_const_p(char, "in_domain_handle"),
		.get = py_samr_CreateUser_in_get_domain_handle,
		.set = py_samr_CreateUser_in_set_domain_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_account_name"),
		.get = py_samr_CreateUser_in_get_account_name,
		.set = py_samr_CreateUser_in_set_account_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_samr_CreateUser_in_get_access_mask,
		.set = py_samr_CreateUser_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_UserAccessMask")
	},
	{
		.name = discard_const_p(char, "out_user_handle"),
		.get = py_samr_CreateUser_out_get_user_handle,
		.set = py_samr_CreateUser_out_set_user_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_rid"),
		.get = py_samr_CreateUser_out_get_rid,
		.set = py_samr_CreateUser_out_set_rid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_CreateUser_get_result,
		.set = py_samr_CreateUser_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_CreateUser_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_CreateUser, type);
	struct samr_CreateUser *_self = (struct samr_CreateUser *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.domain_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.account_name = talloc_zero(mem_ctx, struct lsa_String);
	_self->out.user_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.rid = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_samr_CreateUser_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(12);
}

static PyObject *py_samr_CreateUser_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_CreateUser *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_CreateUser_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[12];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_CreateUser_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_CreateUser_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_CreateUser_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_CreateUser_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_CreateUser_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_CreateUser *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_CreateUser_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[12];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_CreateUser_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_CreateUser_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_CreateUser_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_CreateUser_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_CreateUser_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_CreateUser *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 13) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_CreateUser_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[12];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_CreateUser_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_CreateUser_ndr_print(py_obj, args, kwargs, "samr_CreateUser_in", NDR_IN);
}

static PyObject *py_samr_CreateUser_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_CreateUser_ndr_print(py_obj, args, kwargs, "samr_CreateUser_out", NDR_OUT);
}

static PyMethodDef py_samr_CreateUser_methods[] = {
	{ "opnum", (PyCFunction)py_samr_CreateUser_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.CreateUser.opnum() -> 12 (0x0c) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_CreateUser_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_CreateUser_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_CreateUser_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_CreateUser_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_CreateUser_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_CreateUser_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_CreateUser_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.CreateUser",
	.tp_getset = py_samr_CreateUser_getsetters,
	.tp_methods = py_samr_CreateUser_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_CreateUser_new,
};

static bool pack_py_samr_CreateUser_args_in(PyObject *args, PyObject *kwargs, struct samr_CreateUser *r)
{
	PyObject *py_domain_handle;
	PyObject *py_account_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"domain_handle", "account_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:samr_CreateUser", discard_const_p(char *, kwnames), &py_domain_handle, &py_account_name, &py_access_mask)) {
		return false;
	}

	if (py_domain_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain_handle");
		return false;
	}
	r->in.domain_handle = talloc_ptrtype(r, r->in.domain_handle);
	if (r->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_domain_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_domain_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(py_domain_handle);
	if (py_account_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.account_name");
		return false;
	}
	r->in.account_name = talloc_ptrtype(r, r->in.account_name);
	if (r->in.account_name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(lsa_String_Type, py_account_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_account_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.account_name = (struct lsa_String *)pytalloc_get_ptr(py_account_name);
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_samr_CreateUser_args_out(struct samr_CreateUser *r, bool raise_result_exception)
{
	PyObject *py_user_handle = NULL;
	PyObject *py_rid = NULL;
	PyObject *result = NULL;
	size_t result_size = 2;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_user_handle = pytalloc_reference_ex(policy_handle_Type, r->out.user_handle, r->out.user_handle);
	PyTuple_SetItem(result, 0, py_user_handle);

	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.rid));
	PyTuple_SetItem(result, 1, py_rid);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 2, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_samr_EnumDomainUsers_in_get_domain_handle(PyObject *obj, void *closure)
{
	struct samr_EnumDomainUsers *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_handle;
	if (object->in.domain_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_domain_handle = pytalloc_reference_ex(policy_handle_Type, object->in.domain_handle, object->in.domain_handle);
	return py_domain_handle;
}

static int py_samr_EnumDomainUsers_in_set_domain_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomainUsers *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.domain_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain_handle");
		return -1;
	}
	object->in.domain_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_handle);
	if (object->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_EnumDomainUsers_in_get_resume_handle(PyObject *obj, void *closure)
{
	struct samr_EnumDomainUsers *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->in.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.resume_handle));
	return py_resume_handle;
}

static int py_samr_EnumDomainUsers_in_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomainUsers *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.resume_handle");
		return -1;
	}
	object->in.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.resume_handle);
	if (object->in.resume_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.resume_handle));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->in.resume_handle = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_EnumDomainUsers_out_get_resume_handle(PyObject *obj, void *closure)
{
	struct samr_EnumDomainUsers *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->out.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.resume_handle));
	return py_resume_handle;
}

static int py_samr_EnumDomainUsers_out_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomainUsers *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.resume_handle");
		return -1;
	}
	object->out.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.resume_handle);
	if (object->out.resume_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.resume_handle));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.resume_handle = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_EnumDomainUsers_in_get_acct_flags(PyObject *obj, void *closure)
{
	struct samr_EnumDomainUsers *object = pytalloc_get_ptr(obj);
	PyObject *py_acct_flags;
	py_acct_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->in.acct_flags));
	return py_acct_flags;
}

static int py_samr_EnumDomainUsers_in_set_acct_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomainUsers *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.acct_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.acct_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.acct_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_EnumDomainUsers_out_get_sam(PyObject *obj, void *closure)
{
	struct samr_EnumDomainUsers *object = pytalloc_get_ptr(obj);
	PyObject *py_sam;
	if (object->out.sam == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.sam == NULL) {
		py_sam = Py_None;
		Py_INCREF(py_sam);
	} else {
		py_sam = pytalloc_reference_ex(&samr_SamArray_Type, *object->out.sam, *object->out.sam);
	}
	return py_sam;
}

static int py_samr_EnumDomainUsers_out_set_sam(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomainUsers *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.sam));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.sam");
		return -1;
	}
	object->out.sam = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.sam);
	if (object->out.sam == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.sam = NULL;
	} else {
		*object->out.sam = NULL;
		PY_CHECK_TYPE(&samr_SamArray_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.sam = (struct samr_SamArray *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_samr_EnumDomainUsers_in_get_max_size(PyObject *obj, void *closure)
{
	struct samr_EnumDomainUsers *object = pytalloc_get_ptr(obj);
	PyObject *py_max_size;
	py_max_size = PyLong_FromUnsignedLongLong((uint32_t)(object->in.max_size));
	return py_max_size;
}

static int py_samr_EnumDomainUsers_in_set_max_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomainUsers *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.max_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.max_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.max_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_EnumDomainUsers_out_get_num_entries(PyObject *obj, void *closure)
{
	struct samr_EnumDomainUsers *object = pytalloc_get_ptr(obj);
	PyObject *py_num_entries;
	if (object->out.num_entries == NULL) {
		Py_RETURN_NONE;
	}
	py_num_entries = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.num_entries));
	return py_num_entries;
}

static int py_samr_EnumDomainUsers_out_set_num_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomainUsers *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.num_entries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.num_entries");
		return -1;
	}
	object->out.num_entries = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.num_entries);
	if (object->out.num_entries == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.num_entries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.num_entries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_EnumDomainUsers_get_result(PyObject *obj, void *closure)
{
	struct samr_EnumDomainUsers *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_EnumDomainUsers_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomainUsers *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_EnumDomainUsers_getsetters[] = {
	{
		.name = discard_const_p(char, "in_domain_handle"),
		.get = py_samr_EnumDomainUsers_in_get_domain_handle,
		.set = py_samr_EnumDomainUsers_in_set_domain_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_resume_handle"),
		.get = py_samr_EnumDomainUsers_in_get_resume_handle,
		.set = py_samr_EnumDomainUsers_in_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_resume_handle"),
		.get = py_samr_EnumDomainUsers_out_get_resume_handle,
		.set = py_samr_EnumDomainUsers_out_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_acct_flags"),
		.get = py_samr_EnumDomainUsers_in_get_acct_flags,
		.set = py_samr_EnumDomainUsers_in_set_acct_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_AcctFlags")
	},
	{
		.name = discard_const_p(char, "out_sam"),
		.get = py_samr_EnumDomainUsers_out_get_sam,
		.set = py_samr_EnumDomainUsers_out_set_sam,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_SamArray")
	},
	{
		.name = discard_const_p(char, "in_max_size"),
		.get = py_samr_EnumDomainUsers_in_get_max_size,
		.set = py_samr_EnumDomainUsers_in_set_max_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_num_entries"),
		.get = py_samr_EnumDomainUsers_out_get_num_entries,
		.set = py_samr_EnumDomainUsers_out_set_num_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_EnumDomainUsers_get_result,
		.set = py_samr_EnumDomainUsers_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_EnumDomainUsers_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_EnumDomainUsers, type);
	struct samr_EnumDomainUsers *_self = (struct samr_EnumDomainUsers *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.domain_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.resume_handle = talloc_zero(mem_ctx, uint32_t);
	_self->out.resume_handle = talloc_zero(mem_ctx, uint32_t);
	/* a pointer to a NULL pointer */
	_self->out.sam = talloc_zero(mem_ctx, struct samr_SamArray *);
	_self->out.num_entries = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_samr_EnumDomainUsers_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(13);
}

static PyObject *py_samr_EnumDomainUsers_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_EnumDomainUsers *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 14) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_EnumDomainUsers_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[13];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_EnumDomainUsers_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_EnumDomainUsers_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_EnumDomainUsers_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_EnumDomainUsers_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_EnumDomainUsers_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_EnumDomainUsers *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 14) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_EnumDomainUsers_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[13];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_EnumDomainUsers_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_EnumDomainUsers_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_EnumDomainUsers_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_EnumDomainUsers_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_EnumDomainUsers_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_EnumDomainUsers *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 14) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_EnumDomainUsers_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[13];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_EnumDomainUsers_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_EnumDomainUsers_ndr_print(py_obj, args, kwargs, "samr_EnumDomainUsers_in", NDR_IN);
}

static PyObject *py_samr_EnumDomainUsers_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_EnumDomainUsers_ndr_print(py_obj, args, kwargs, "samr_EnumDomainUsers_out", NDR_OUT);
}

static PyMethodDef py_samr_EnumDomainUsers_methods[] = {
	{ "opnum", (PyCFunction)py_samr_EnumDomainUsers_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.EnumDomainUsers.opnum() -> 13 (0x0d) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomainUsers_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomainUsers_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomainUsers_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomainUsers_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomainUsers_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomainUsers_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_EnumDomainUsers_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.EnumDomainUsers",
	.tp_getset = py_samr_EnumDomainUsers_getsetters,
	.tp_methods = py_samr_EnumDomainUsers_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_EnumDomainUsers_new,
};

static bool pack_py_samr_EnumDomainUsers_args_in(PyObject *args, PyObject *kwargs, struct samr_EnumDomainUsers *r)
{
	PyObject *py_domain_handle;
	PyObject *py_resume_handle;
	PyObject *py_acct_flags;
	PyObject *py_max_size;
	const char *kwnames[] = {
		"domain_handle", "resume_handle", "acct_flags", "max_size", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOOO:samr_EnumDomainUsers", discard_const_p(char *, kwnames), &py_domain_handle, &py_resume_handle, &py_acct_flags, &py_max_size)) {
		return false;
	}

	if (py_domain_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain_handle");
		return false;
	}
	r->in.domain_handle = talloc_ptrtype(r, r->in.domain_handle);
	if (r->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_domain_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_domain_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(py_domain_handle);
	if (py_resume_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.resume_handle");
		return false;
	}
	r->in.resume_handle = talloc_ptrtype(r, r->in.resume_handle);
	if (r->in.resume_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.resume_handle));
		if (PyLong_Check(py_resume_handle)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_resume_handle);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			*r->in.resume_handle = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_acct_flags == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.acct_flags");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.acct_flags));
		if (PyLong_Check(py_acct_flags)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_acct_flags);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.acct_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_max_size == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.max_size");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.max_size));
		if (PyLong_Check(py_max_size)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_max_size);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.max_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_samr_EnumDomainUsers_args_out(struct samr_EnumDomainUsers *r, bool raise_result_exception)
{
	PyObject *py_resume_handle = NULL;
	PyObject *py_sam = NULL;
	PyObject *py_num_entries = NULL;
	PyObject *result = NULL;
	size_t result_size = 3;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.resume_handle));
	PyTuple_SetItem(result, 0, py_resume_handle);

	if (*r->out.sam == NULL) {
		py_sam = Py_None;
		Py_INCREF(py_sam);
	} else {
		py_sam = pytalloc_reference_ex(&samr_SamArray_Type, *r->out.sam, *r->out.sam);
	}
	PyTuple_SetItem(result, 1, py_sam);

	py_num_entries = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.num_entries));
	PyTuple_SetItem(result, 2, py_num_entries);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 3, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_samr_CreateDomAlias_in_get_domain_handle(PyObject *obj, void *closure)
{
	struct samr_CreateDomAlias *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_handle;
	if (object->in.domain_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_domain_handle = pytalloc_reference_ex(policy_handle_Type, object->in.domain_handle, object->in.domain_handle);
	return py_domain_handle;
}

static int py_samr_CreateDomAlias_in_set_domain_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_CreateDomAlias *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.domain_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain_handle");
		return -1;
	}
	object->in.domain_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_handle);
	if (object->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_CreateDomAlias_in_get_alias_name(PyObject *obj, void *closure)
{
	struct samr_CreateDomAlias *object = pytalloc_get_ptr(obj);
	PyObject *py_alias_name;
	if (object->in.alias_name == NULL) {
		Py_RETURN_NONE;
	}
	py_alias_name = pytalloc_reference_ex(lsa_String_Type, object->in.alias_name, object->in.alias_name);
	return py_alias_name;
}

static int py_samr_CreateDomAlias_in_set_alias_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_CreateDomAlias *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.alias_name));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.alias_name");
		return -1;
	}
	object->in.alias_name = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.alias_name);
	if (object->in.alias_name == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(lsa_String_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.alias_name = (struct lsa_String *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_CreateDomAlias_in_get_access_mask(PyObject *obj, void *closure)
{
	struct samr_CreateDomAlias *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_samr_CreateDomAlias_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_CreateDomAlias *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_CreateDomAlias_out_get_alias_handle(PyObject *obj, void *closure)
{
	struct samr_CreateDomAlias *object = pytalloc_get_ptr(obj);
	PyObject *py_alias_handle;
	if (object->out.alias_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_alias_handle = pytalloc_reference_ex(policy_handle_Type, object->out.alias_handle, object->out.alias_handle);
	return py_alias_handle;
}

static int py_samr_CreateDomAlias_out_set_alias_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_CreateDomAlias *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.alias_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.alias_handle");
		return -1;
	}
	object->out.alias_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.alias_handle);
	if (object->out.alias_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.alias_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_CreateDomAlias_out_get_rid(PyObject *obj, void *closure)
{
	struct samr_CreateDomAlias *object = pytalloc_get_ptr(obj);
	PyObject *py_rid;
	if (object->out.rid == NULL) {
		Py_RETURN_NONE;
	}
	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.rid));
	return py_rid;
}

static int py_samr_CreateDomAlias_out_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_CreateDomAlias *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.rid));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.rid");
		return -1;
	}
	object->out.rid = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.rid);
	if (object->out.rid == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.rid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_CreateDomAlias_get_result(PyObject *obj, void *closure)
{
	struct samr_CreateDomAlias *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_CreateDomAlias_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_CreateDomAlias *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_CreateDomAlias_getsetters[] = {
	{
		.name = discard_const_p(char, "in_domain_handle"),
		.get = py_samr_CreateDomAlias_in_get_domain_handle,
		.set = py_samr_CreateDomAlias_in_set_domain_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_alias_name"),
		.get = py_samr_CreateDomAlias_in_get_alias_name,
		.set = py_samr_CreateDomAlias_in_set_alias_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_samr_CreateDomAlias_in_get_access_mask,
		.set = py_samr_CreateDomAlias_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_AliasAccessMask")
	},
	{
		.name = discard_const_p(char, "out_alias_handle"),
		.get = py_samr_CreateDomAlias_out_get_alias_handle,
		.set = py_samr_CreateDomAlias_out_set_alias_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_rid"),
		.get = py_samr_CreateDomAlias_out_get_rid,
		.set = py_samr_CreateDomAlias_out_set_rid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_CreateDomAlias_get_result,
		.set = py_samr_CreateDomAlias_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_CreateDomAlias_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_CreateDomAlias, type);
	struct samr_CreateDomAlias *_self = (struct samr_CreateDomAlias *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.domain_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.alias_name = talloc_zero(mem_ctx, struct lsa_String);
	_self->out.alias_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.rid = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_samr_CreateDomAlias_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(14);
}

static PyObject *py_samr_CreateDomAlias_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_CreateDomAlias *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 15) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_CreateDomAlias_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[14];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_CreateDomAlias_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_CreateDomAlias_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_CreateDomAlias_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_CreateDomAlias_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_CreateDomAlias_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_CreateDomAlias *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 15) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_CreateDomAlias_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[14];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_CreateDomAlias_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_CreateDomAlias_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_CreateDomAlias_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_CreateDomAlias_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_CreateDomAlias_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_CreateDomAlias *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 15) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_CreateDomAlias_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[14];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_CreateDomAlias_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_CreateDomAlias_ndr_print(py_obj, args, kwargs, "samr_CreateDomAlias_in", NDR_IN);
}

static PyObject *py_samr_CreateDomAlias_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_CreateDomAlias_ndr_print(py_obj, args, kwargs, "samr_CreateDomAlias_out", NDR_OUT);
}

static PyMethodDef py_samr_CreateDomAlias_methods[] = {
	{ "opnum", (PyCFunction)py_samr_CreateDomAlias_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.CreateDomAlias.opnum() -> 14 (0x0e) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_CreateDomAlias_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_CreateDomAlias_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_CreateDomAlias_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_CreateDomAlias_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_CreateDomAlias_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_CreateDomAlias_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_CreateDomAlias_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.CreateDomAlias",
	.tp_getset = py_samr_CreateDomAlias_getsetters,
	.tp_methods = py_samr_CreateDomAlias_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_CreateDomAlias_new,
};

static bool pack_py_samr_CreateDomAlias_args_in(PyObject *args, PyObject *kwargs, struct samr_CreateDomAlias *r)
{
	PyObject *py_domain_handle;
	PyObject *py_alias_name;
	PyObject *py_access_mask;
	const char *kwnames[] = {
		"domain_handle", "alias_name", "access_mask", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:samr_CreateDomAlias", discard_const_p(char *, kwnames), &py_domain_handle, &py_alias_name, &py_access_mask)) {
		return false;
	}

	if (py_domain_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain_handle");
		return false;
	}
	r->in.domain_handle = talloc_ptrtype(r, r->in.domain_handle);
	if (r->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_domain_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_domain_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(py_domain_handle);
	if (py_alias_name == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.alias_name");
		return false;
	}
	r->in.alias_name = talloc_ptrtype(r, r->in.alias_name);
	if (r->in.alias_name == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(lsa_String_Type, py_alias_name, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_alias_name)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.alias_name = (struct lsa_String *)pytalloc_get_ptr(py_alias_name);
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_samr_CreateDomAlias_args_out(struct samr_CreateDomAlias *r, bool raise_result_exception)
{
	PyObject *py_alias_handle = NULL;
	PyObject *py_rid = NULL;
	PyObject *result = NULL;
	size_t result_size = 2;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_alias_handle = pytalloc_reference_ex(policy_handle_Type, r->out.alias_handle, r->out.alias_handle);
	PyTuple_SetItem(result, 0, py_alias_handle);

	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.rid));
	PyTuple_SetItem(result, 1, py_rid);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 2, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_samr_EnumDomainAliases_in_get_domain_handle(PyObject *obj, void *closure)
{
	struct samr_EnumDomainAliases *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_handle;
	if (object->in.domain_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_domain_handle = pytalloc_reference_ex(policy_handle_Type, object->in.domain_handle, object->in.domain_handle);
	return py_domain_handle;
}

static int py_samr_EnumDomainAliases_in_set_domain_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomainAliases *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.domain_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain_handle");
		return -1;
	}
	object->in.domain_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_handle);
	if (object->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_EnumDomainAliases_in_get_resume_handle(PyObject *obj, void *closure)
{
	struct samr_EnumDomainAliases *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->in.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->in.resume_handle));
	return py_resume_handle;
}

static int py_samr_EnumDomainAliases_in_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomainAliases *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.resume_handle");
		return -1;
	}
	object->in.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.resume_handle);
	if (object->in.resume_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->in.resume_handle));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->in.resume_handle = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_EnumDomainAliases_out_get_resume_handle(PyObject *obj, void *closure)
{
	struct samr_EnumDomainAliases *object = pytalloc_get_ptr(obj);
	PyObject *py_resume_handle;
	if (object->out.resume_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.resume_handle));
	return py_resume_handle;
}

static int py_samr_EnumDomainAliases_out_set_resume_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomainAliases *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.resume_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.resume_handle");
		return -1;
	}
	object->out.resume_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.resume_handle);
	if (object->out.resume_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.resume_handle));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.resume_handle = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_EnumDomainAliases_out_get_sam(PyObject *obj, void *closure)
{
	struct samr_EnumDomainAliases *object = pytalloc_get_ptr(obj);
	PyObject *py_sam;
	if (object->out.sam == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.sam == NULL) {
		py_sam = Py_None;
		Py_INCREF(py_sam);
	} else {
		py_sam = pytalloc_reference_ex(&samr_SamArray_Type, *object->out.sam, *object->out.sam);
	}
	return py_sam;
}

static int py_samr_EnumDomainAliases_out_set_sam(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomainAliases *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.sam));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.sam");
		return -1;
	}
	object->out.sam = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.sam);
	if (object->out.sam == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.sam = NULL;
	} else {
		*object->out.sam = NULL;
		PY_CHECK_TYPE(&samr_SamArray_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.sam = (struct samr_SamArray *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_samr_EnumDomainAliases_in_get_max_size(PyObject *obj, void *closure)
{
	struct samr_EnumDomainAliases *object = pytalloc_get_ptr(obj);
	PyObject *py_max_size;
	py_max_size = PyLong_FromUnsignedLongLong((uint32_t)(object->in.max_size));
	return py_max_size;
}

static int py_samr_EnumDomainAliases_in_set_max_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomainAliases *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.max_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.max_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.max_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_EnumDomainAliases_out_get_num_entries(PyObject *obj, void *closure)
{
	struct samr_EnumDomainAliases *object = pytalloc_get_ptr(obj);
	PyObject *py_num_entries;
	if (object->out.num_entries == NULL) {
		Py_RETURN_NONE;
	}
	py_num_entries = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.num_entries));
	return py_num_entries;
}

static int py_samr_EnumDomainAliases_out_set_num_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomainAliases *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.num_entries));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.num_entries");
		return -1;
	}
	object->out.num_entries = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.num_entries);
	if (object->out.num_entries == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.num_entries));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.num_entries = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_EnumDomainAliases_get_result(PyObject *obj, void *closure)
{
	struct samr_EnumDomainAliases *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_EnumDomainAliases_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_EnumDomainAliases *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_EnumDomainAliases_getsetters[] = {
	{
		.name = discard_const_p(char, "in_domain_handle"),
		.get = py_samr_EnumDomainAliases_in_get_domain_handle,
		.set = py_samr_EnumDomainAliases_in_set_domain_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_resume_handle"),
		.get = py_samr_EnumDomainAliases_in_get_resume_handle,
		.set = py_samr_EnumDomainAliases_in_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_resume_handle"),
		.get = py_samr_EnumDomainAliases_out_get_resume_handle,
		.set = py_samr_EnumDomainAliases_out_set_resume_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_sam"),
		.get = py_samr_EnumDomainAliases_out_get_sam,
		.set = py_samr_EnumDomainAliases_out_set_sam,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_SamArray")
	},
	{
		.name = discard_const_p(char, "in_max_size"),
		.get = py_samr_EnumDomainAliases_in_get_max_size,
		.set = py_samr_EnumDomainAliases_in_set_max_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_num_entries"),
		.get = py_samr_EnumDomainAliases_out_get_num_entries,
		.set = py_samr_EnumDomainAliases_out_set_num_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_EnumDomainAliases_get_result,
		.set = py_samr_EnumDomainAliases_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_EnumDomainAliases_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_EnumDomainAliases, type);
	struct samr_EnumDomainAliases *_self = (struct samr_EnumDomainAliases *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.domain_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.resume_handle = talloc_zero(mem_ctx, uint32_t);
	_self->out.resume_handle = talloc_zero(mem_ctx, uint32_t);
	/* a pointer to a NULL pointer */
	_self->out.sam = talloc_zero(mem_ctx, struct samr_SamArray *);
	_self->out.num_entries = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_samr_EnumDomainAliases_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(15);
}

static PyObject *py_samr_EnumDomainAliases_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_EnumDomainAliases *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 16) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_EnumDomainAliases_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[15];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_EnumDomainAliases_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_EnumDomainAliases_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_EnumDomainAliases_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_EnumDomainAliases_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_EnumDomainAliases_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_EnumDomainAliases *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 16) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_EnumDomainAliases_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[15];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_EnumDomainAliases_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_EnumDomainAliases_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_EnumDomainAliases_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_EnumDomainAliases_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_EnumDomainAliases_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_EnumDomainAliases *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 16) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_EnumDomainAliases_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[15];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_EnumDomainAliases_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_EnumDomainAliases_ndr_print(py_obj, args, kwargs, "samr_EnumDomainAliases_in", NDR_IN);
}

static PyObject *py_samr_EnumDomainAliases_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_EnumDomainAliases_ndr_print(py_obj, args, kwargs, "samr_EnumDomainAliases_out", NDR_OUT);
}

static PyMethodDef py_samr_EnumDomainAliases_methods[] = {
	{ "opnum", (PyCFunction)py_samr_EnumDomainAliases_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.EnumDomainAliases.opnum() -> 15 (0x0f) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomainAliases_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomainAliases_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomainAliases_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomainAliases_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomainAliases_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_EnumDomainAliases_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_EnumDomainAliases_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.EnumDomainAliases",
	.tp_getset = py_samr_EnumDomainAliases_getsetters,
	.tp_methods = py_samr_EnumDomainAliases_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_EnumDomainAliases_new,
};

static bool pack_py_samr_EnumDomainAliases_args_in(PyObject *args, PyObject *kwargs, struct samr_EnumDomainAliases *r)
{
	PyObject *py_domain_handle;
	PyObject *py_resume_handle;
	PyObject *py_max_size;
	const char *kwnames[] = {
		"domain_handle", "resume_handle", "max_size", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:samr_EnumDomainAliases", discard_const_p(char *, kwnames), &py_domain_handle, &py_resume_handle, &py_max_size)) {
		return false;
	}

	if (py_domain_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain_handle");
		return false;
	}
	r->in.domain_handle = talloc_ptrtype(r, r->in.domain_handle);
	if (r->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_domain_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_domain_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(py_domain_handle);
	if (py_resume_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.resume_handle");
		return false;
	}
	r->in.resume_handle = talloc_ptrtype(r, r->in.resume_handle);
	if (r->in.resume_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*r->in.resume_handle));
		if (PyLong_Check(py_resume_handle)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_resume_handle);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			*r->in.resume_handle = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_max_size == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.max_size");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.max_size));
		if (PyLong_Check(py_max_size)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_max_size);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.max_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_samr_EnumDomainAliases_args_out(struct samr_EnumDomainAliases *r, bool raise_result_exception)
{
	PyObject *py_resume_handle = NULL;
	PyObject *py_sam = NULL;
	PyObject *py_num_entries = NULL;
	PyObject *result = NULL;
	size_t result_size = 3;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_resume_handle = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.resume_handle));
	PyTuple_SetItem(result, 0, py_resume_handle);

	if (*r->out.sam == NULL) {
		py_sam = Py_None;
		Py_INCREF(py_sam);
	} else {
		py_sam = pytalloc_reference_ex(&samr_SamArray_Type, *r->out.sam, *r->out.sam);
	}
	PyTuple_SetItem(result, 1, py_sam);

	py_num_entries = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.num_entries));
	PyTuple_SetItem(result, 2, py_num_entries);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 3, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_samr_GetAliasMembership_in_get_domain_handle(PyObject *obj, void *closure)
{
	struct samr_GetAliasMembership *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_handle;
	if (object->in.domain_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_domain_handle = pytalloc_reference_ex(policy_handle_Type, object->in.domain_handle, object->in.domain_handle);
	return py_domain_handle;
}

static int py_samr_GetAliasMembership_in_set_domain_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_GetAliasMembership *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.domain_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain_handle");
		return -1;
	}
	object->in.domain_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_handle);
	if (object->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_GetAliasMembership_in_get_sids(PyObject *obj, void *closure)
{
	struct samr_GetAliasMembership *object = pytalloc_get_ptr(obj);
	PyObject *py_sids;
	if (object->in.sids == NULL) {
		Py_RETURN_NONE;
	}
	py_sids = pytalloc_reference_ex(lsa_SidArray_Type, object->in.sids, object->in.sids);
	return py_sids;
}

static int py_samr_GetAliasMembership_in_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_GetAliasMembership *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.sids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.sids");
		return -1;
	}
	object->in.sids = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.sids);
	if (object->in.sids == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(lsa_SidArray_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.sids = (struct lsa_SidArray *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_GetAliasMembership_out_get_rids(PyObject *obj, void *closure)
{
	struct samr_GetAliasMembership *object = pytalloc_get_ptr(obj);
	PyObject *py_rids;
	if (object->out.rids == NULL) {
		Py_RETURN_NONE;
	}
	py_rids = pytalloc_reference_ex(&samr_Ids_Type, object->out.rids, object->out.rids);
	return py_rids;
}

static int py_samr_GetAliasMembership_out_set_rids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_GetAliasMembership *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.rids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.rids");
		return -1;
	}
	object->out.rids = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.rids);
	if (object->out.rids == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&samr_Ids_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.rids = (struct samr_Ids *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_GetAliasMembership_get_result(PyObject *obj, void *closure)
{
	struct samr_GetAliasMembership *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_GetAliasMembership_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_GetAliasMembership *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_GetAliasMembership_getsetters[] = {
	{
		.name = discard_const_p(char, "in_domain_handle"),
		.get = py_samr_GetAliasMembership_in_get_domain_handle,
		.set = py_samr_GetAliasMembership_in_set_domain_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_sids"),
		.get = py_samr_GetAliasMembership_in_get_sids,
		.set = py_samr_GetAliasMembership_in_set_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_SidArray")
	},
	{
		.name = discard_const_p(char, "out_rids"),
		.get = py_samr_GetAliasMembership_out_get_rids,
		.set = py_samr_GetAliasMembership_out_set_rids,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_Ids")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_GetAliasMembership_get_result,
		.set = py_samr_GetAliasMembership_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_GetAliasMembership_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_GetAliasMembership, type);
	struct samr_GetAliasMembership *_self = (struct samr_GetAliasMembership *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.domain_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.sids = talloc_zero(mem_ctx, struct lsa_SidArray);
	_self->out.rids = talloc_zero(mem_ctx, struct samr_Ids);
	return self;
}

static PyObject *py_samr_GetAliasMembership_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(16);
}

static PyObject *py_samr_GetAliasMembership_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_GetAliasMembership *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 17) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_GetAliasMembership_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[16];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_GetAliasMembership_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_GetAliasMembership_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_GetAliasMembership_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_GetAliasMembership_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_GetAliasMembership_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_GetAliasMembership *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 17) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_GetAliasMembership_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[16];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_GetAliasMembership_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_GetAliasMembership_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_GetAliasMembership_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_GetAliasMembership_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_GetAliasMembership_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_GetAliasMembership *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 17) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_GetAliasMembership_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[16];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_GetAliasMembership_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_GetAliasMembership_ndr_print(py_obj, args, kwargs, "samr_GetAliasMembership_in", NDR_IN);
}

static PyObject *py_samr_GetAliasMembership_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_GetAliasMembership_ndr_print(py_obj, args, kwargs, "samr_GetAliasMembership_out", NDR_OUT);
}

static PyMethodDef py_samr_GetAliasMembership_methods[] = {
	{ "opnum", (PyCFunction)py_samr_GetAliasMembership_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.GetAliasMembership.opnum() -> 16 (0x10) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_GetAliasMembership_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_GetAliasMembership_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_GetAliasMembership_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_GetAliasMembership_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_GetAliasMembership_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_GetAliasMembership_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_GetAliasMembership_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.GetAliasMembership",
	.tp_getset = py_samr_GetAliasMembership_getsetters,
	.tp_methods = py_samr_GetAliasMembership_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_GetAliasMembership_new,
};

static bool pack_py_samr_GetAliasMembership_args_in(PyObject *args, PyObject *kwargs, struct samr_GetAliasMembership *r)
{
	PyObject *py_domain_handle;
	PyObject *py_sids;
	const char *kwnames[] = {
		"domain_handle", "sids", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:samr_GetAliasMembership", discard_const_p(char *, kwnames), &py_domain_handle, &py_sids)) {
		return false;
	}

	if (py_domain_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain_handle");
		return false;
	}
	r->in.domain_handle = talloc_ptrtype(r, r->in.domain_handle);
	if (r->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_domain_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_domain_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(py_domain_handle);
	if (py_sids == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.sids");
		return false;
	}
	r->in.sids = talloc_ptrtype(r, r->in.sids);
	if (r->in.sids == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(lsa_SidArray_Type, py_sids, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_sids)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.sids = (struct lsa_SidArray *)pytalloc_get_ptr(py_sids);
	return true;
}

static PyObject *unpack_py_samr_GetAliasMembership_args_out(struct samr_GetAliasMembership *r, bool raise_result_exception)
{
	PyObject *py_rids = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_rids = pytalloc_reference_ex(&samr_Ids_Type, r->out.rids, r->out.rids);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_rids);
	}
	if (result_size == 1) {
		result = py_rids;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_samr_LookupNames_in_get_domain_handle(PyObject *obj, void *closure)
{
	struct samr_LookupNames *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_handle;
	if (object->in.domain_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_domain_handle = pytalloc_reference_ex(policy_handle_Type, object->in.domain_handle, object->in.domain_handle);
	return py_domain_handle;
}

static int py_samr_LookupNames_in_set_domain_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_LookupNames *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.domain_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain_handle");
		return -1;
	}
	object->in.domain_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_handle);
	if (object->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_LookupNames_in_get_num_names(PyObject *obj, void *closure)
{
	struct samr_LookupNames *object = pytalloc_get_ptr(obj);
	PyObject *py_num_names;
	py_num_names = PyLong_FromUnsignedLongLong((uint32_t)(object->in.num_names));
	return py_num_names;
}

static int py_samr_LookupNames_in_set_num_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_LookupNames *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.num_names");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.num_names));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.num_names = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_LookupNames_in_get_names(PyObject *obj, void *closure)
{
	struct samr_LookupNames *object = pytalloc_get_ptr(obj);
	PyObject *py_names;
	py_names = PyList_New(object->in.num_names);
	if (py_names == NULL) {
		return NULL;
	}
	{
		int names_cntr_0;
		for (names_cntr_0 = 0; names_cntr_0 < (object->in.num_names); names_cntr_0++) {
			PyObject *py_names_0;
			py_names_0 = pytalloc_reference_ex(lsa_String_Type, object->in.names, &(object->in.names)[names_cntr_0]);
			PyList_SetItem(py_names, names_cntr_0, py_names_0);
		}
	}
	return py_names;
}

static int py_samr_LookupNames_in_set_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_LookupNames *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.names");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int names_cntr_0;
		object->in.names = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.names, PyList_GET_SIZE(value));
		if (!object->in.names) { return -1; }
		talloc_set_name_const(object->in.names, "ARRAY: object->in.names");
		for (names_cntr_0 = 0; names_cntr_0 < PyList_GET_SIZE(value); names_cntr_0++) {
			if (PyList_GET_ITEM(value, names_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.names)[names_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(lsa_String_Type, PyList_GET_ITEM(value, names_cntr_0), return -1;);
			if (talloc_reference(object->in.names, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, names_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->in.names)[names_cntr_0] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(value, names_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_samr_LookupNames_out_get_rids(PyObject *obj, void *closure)
{
	struct samr_LookupNames *object = pytalloc_get_ptr(obj);
	PyObject *py_rids;
	if (object->out.rids == NULL) {
		Py_RETURN_NONE;
	}
	py_rids = pytalloc_reference_ex(&samr_Ids_Type, object->out.rids, object->out.rids);
	return py_rids;
}

static int py_samr_LookupNames_out_set_rids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_LookupNames *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.rids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.rids");
		return -1;
	}
	object->out.rids = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.rids);
	if (object->out.rids == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&samr_Ids_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.rids = (struct samr_Ids *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_LookupNames_out_get_types(PyObject *obj, void *closure)
{
	struct samr_LookupNames *object = pytalloc_get_ptr(obj);
	PyObject *py_types;
	if (object->out.types == NULL) {
		Py_RETURN_NONE;
	}
	py_types = pytalloc_reference_ex(&samr_Ids_Type, object->out.types, object->out.types);
	return py_types;
}

static int py_samr_LookupNames_out_set_types(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_LookupNames *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.types));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.types");
		return -1;
	}
	object->out.types = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.types);
	if (object->out.types == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&samr_Ids_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.types = (struct samr_Ids *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_LookupNames_get_result(PyObject *obj, void *closure)
{
	struct samr_LookupNames *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_LookupNames_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_LookupNames *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_LookupNames_getsetters[] = {
	{
		.name = discard_const_p(char, "in_domain_handle"),
		.get = py_samr_LookupNames_in_get_domain_handle,
		.set = py_samr_LookupNames_in_set_domain_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_num_names"),
		.get = py_samr_LookupNames_in_get_num_names,
		.set = py_samr_LookupNames_in_set_num_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_names"),
		.get = py_samr_LookupNames_in_get_names,
		.set = py_samr_LookupNames_in_set_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_String")
	},
	{
		.name = discard_const_p(char, "out_rids"),
		.get = py_samr_LookupNames_out_get_rids,
		.set = py_samr_LookupNames_out_set_rids,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_Ids")
	},
	{
		.name = discard_const_p(char, "out_types"),
		.get = py_samr_LookupNames_out_get_types,
		.set = py_samr_LookupNames_out_set_types,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_Ids")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_LookupNames_get_result,
		.set = py_samr_LookupNames_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_LookupNames_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_LookupNames, type);
	struct samr_LookupNames *_self = (struct samr_LookupNames *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.domain_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.rids = talloc_zero(mem_ctx, struct samr_Ids);
	_self->out.types = talloc_zero(mem_ctx, struct samr_Ids);
	return self;
}

static PyObject *py_samr_LookupNames_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(17);
}

static PyObject *py_samr_LookupNames_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_LookupNames *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 18) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_LookupNames_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[17];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_LookupNames_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_LookupNames_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_LookupNames_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_LookupNames_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_LookupNames_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_LookupNames *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 18) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_LookupNames_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[17];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_LookupNames_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_LookupNames_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_LookupNames_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_LookupNames_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_LookupNames_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_LookupNames *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 18) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_LookupNames_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[17];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_LookupNames_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_LookupNames_ndr_print(py_obj, args, kwargs, "samr_LookupNames_in", NDR_IN);
}

static PyObject *py_samr_LookupNames_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_LookupNames_ndr_print(py_obj, args, kwargs, "samr_LookupNames_out", NDR_OUT);
}

static PyMethodDef py_samr_LookupNames_methods[] = {
	{ "opnum", (PyCFunction)py_samr_LookupNames_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.LookupNames.opnum() -> 17 (0x11) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_LookupNames_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_LookupNames_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_LookupNames_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_LookupNames_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_LookupNames_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_LookupNames_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_LookupNames_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.LookupNames",
	.tp_getset = py_samr_LookupNames_getsetters,
	.tp_methods = py_samr_LookupNames_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_LookupNames_new,
};

static bool pack_py_samr_LookupNames_args_in(PyObject *args, PyObject *kwargs, struct samr_LookupNames *r)
{
	PyObject *py_domain_handle;
	PyObject *py_names;
	const char *kwnames[] = {
		"domain_handle", "names", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:samr_LookupNames", discard_const_p(char *, kwnames), &py_domain_handle, &py_names)) {
		return false;
	}

	if (py_domain_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain_handle");
		return false;
	}
	r->in.domain_handle = talloc_ptrtype(r, r->in.domain_handle);
	if (r->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_domain_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_domain_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(py_domain_handle);
	PY_CHECK_TYPE(&PyList_Type, py_names, return false;);
	r->in.num_names = PyList_GET_SIZE(py_names);
	if (py_names == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.names");
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_names, return false;);
	{
		int names_cntr_0;
		r->in.names = talloc_array_ptrtype(r, r->in.names, PyList_GET_SIZE(py_names));
		if (!r->in.names) { return false; }
		talloc_set_name_const(r->in.names, "ARRAY: r->in.names");
		for (names_cntr_0 = 0; names_cntr_0 < PyList_GET_SIZE(py_names); names_cntr_0++) {
			if (PyList_GET_ITEM(py_names, names_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.names)[names_cntr_0]");
				return false;
			}
			PY_CHECK_TYPE(lsa_String_Type, PyList_GET_ITEM(py_names, names_cntr_0), return false;);
			if (talloc_reference(r->in.names, pytalloc_get_mem_ctx(PyList_GET_ITEM(py_names, names_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return false;
			}
			(r->in.names)[names_cntr_0] = *(struct lsa_String *)pytalloc_get_ptr(PyList_GET_ITEM(py_names, names_cntr_0));
		}
	}
	return true;
}

static PyObject *unpack_py_samr_LookupNames_args_out(struct samr_LookupNames *r, bool raise_result_exception)
{
	PyObject *py_rids = NULL;
	PyObject *py_types = NULL;
	PyObject *result = NULL;
	size_t result_size = 2;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_rids = pytalloc_reference_ex(&samr_Ids_Type, r->out.rids, r->out.rids);
	PyTuple_SetItem(result, 0, py_rids);

	py_types = pytalloc_reference_ex(&samr_Ids_Type, r->out.types, r->out.types);
	PyTuple_SetItem(result, 1, py_types);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 2, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_samr_LookupRids_in_get_domain_handle(PyObject *obj, void *closure)
{
	struct samr_LookupRids *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_handle;
	if (object->in.domain_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_domain_handle = pytalloc_reference_ex(policy_handle_Type, object->in.domain_handle, object->in.domain_handle);
	return py_domain_handle;
}

static int py_samr_LookupRids_in_set_domain_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_LookupRids *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.domain_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain_handle");
		return -1;
	}
	object->in.domain_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_handle);
	if (object->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_LookupRids_in_get_num_rids(PyObject *obj, void *closure)
{
	struct samr_LookupRids *object = pytalloc_get_ptr(obj);
	PyObject *py_num_rids;
	py_num_rids = PyLong_FromUnsignedLongLong((uint32_t)(object->in.num_rids));
	return py_num_rids;
}

static int py_samr_LookupRids_in_set_num_rids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_LookupRids *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.num_rids");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.num_rids));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.num_rids = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_LookupRids_in_get_rids(PyObject *obj, void *closure)
{
	struct samr_LookupRids *object = pytalloc_get_ptr(obj);
	PyObject *py_rids;
	py_rids = PyList_New(object->in.num_rids);
	if (py_rids == NULL) {
		return NULL;
	}
	{
		int rids_cntr_0;
		for (rids_cntr_0 = 0; rids_cntr_0 < (object->in.num_rids); rids_cntr_0++) {
			PyObject *py_rids_0;
			py_rids_0 = PyLong_FromUnsignedLongLong((uint32_t)((object->in.rids)[rids_cntr_0]));
			PyList_SetItem(py_rids, rids_cntr_0, py_rids_0);
		}
	}
	return py_rids;
}

static int py_samr_LookupRids_in_set_rids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_LookupRids *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.rids");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int rids_cntr_0;
		object->in.rids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.rids, PyList_GET_SIZE(value));
		if (!object->in.rids) { return -1; }
		talloc_set_name_const(object->in.rids, "ARRAY: object->in.rids");
		for (rids_cntr_0 = 0; rids_cntr_0 < PyList_GET_SIZE(value); rids_cntr_0++) {
			if (PyList_GET_ITEM(value, rids_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->in.rids)[rids_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->in.rids)[rids_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, rids_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, rids_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->in.rids)[rids_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_samr_LookupRids_out_get_names(PyObject *obj, void *closure)
{
	struct samr_LookupRids *object = pytalloc_get_ptr(obj);
	PyObject *py_names;
	if (object->out.names == NULL) {
		Py_RETURN_NONE;
	}
	py_names = pytalloc_reference_ex(lsa_Strings_Type, object->out.names, object->out.names);
	return py_names;
}

static int py_samr_LookupRids_out_set_names(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_LookupRids *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.names));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.names");
		return -1;
	}
	object->out.names = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.names);
	if (object->out.names == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(lsa_Strings_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.names = (struct lsa_Strings *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_LookupRids_out_get_types(PyObject *obj, void *closure)
{
	struct samr_LookupRids *object = pytalloc_get_ptr(obj);
	PyObject *py_types;
	if (object->out.types == NULL) {
		Py_RETURN_NONE;
	}
	py_types = pytalloc_reference_ex(&samr_Ids_Type, object->out.types, object->out.types);
	return py_types;
}

static int py_samr_LookupRids_out_set_types(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_LookupRids *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.types));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.types");
		return -1;
	}
	object->out.types = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.types);
	if (object->out.types == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&samr_Ids_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.types = (struct samr_Ids *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_LookupRids_get_result(PyObject *obj, void *closure)
{
	struct samr_LookupRids *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_LookupRids_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_LookupRids *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_LookupRids_getsetters[] = {
	{
		.name = discard_const_p(char, "in_domain_handle"),
		.get = py_samr_LookupRids_in_get_domain_handle,
		.set = py_samr_LookupRids_in_set_domain_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_num_rids"),
		.get = py_samr_LookupRids_in_get_num_rids,
		.set = py_samr_LookupRids_in_set_num_rids,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_rids"),
		.get = py_samr_LookupRids_in_get_rids,
		.set = py_samr_LookupRids_in_set_rids,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_names"),
		.get = py_samr_LookupRids_out_get_names,
		.set = py_samr_LookupRids_out_set_names,
		.doc = discard_const_p(char, "PIDL-generated element of base type lsa_Strings")
	},
	{
		.name = discard_const_p(char, "out_types"),
		.get = py_samr_LookupRids_out_get_types,
		.set = py_samr_LookupRids_out_set_types,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_Ids")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_LookupRids_get_result,
		.set = py_samr_LookupRids_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_LookupRids_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_LookupRids, type);
	struct samr_LookupRids *_self = (struct samr_LookupRids *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.domain_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.names = talloc_zero(mem_ctx, struct lsa_Strings);
	_self->out.types = talloc_zero(mem_ctx, struct samr_Ids);
	return self;
}

static PyObject *py_samr_LookupRids_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(18);
}

static PyObject *py_samr_LookupRids_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_LookupRids *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 19) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_LookupRids_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[18];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_LookupRids_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_LookupRids_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_LookupRids_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_LookupRids_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_LookupRids_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_LookupRids *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 19) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_LookupRids_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[18];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_LookupRids_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_LookupRids_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_LookupRids_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_LookupRids_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_LookupRids_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_LookupRids *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 19) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_LookupRids_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[18];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_LookupRids_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_LookupRids_ndr_print(py_obj, args, kwargs, "samr_LookupRids_in", NDR_IN);
}

static PyObject *py_samr_LookupRids_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_LookupRids_ndr_print(py_obj, args, kwargs, "samr_LookupRids_out", NDR_OUT);
}

static PyMethodDef py_samr_LookupRids_methods[] = {
	{ "opnum", (PyCFunction)py_samr_LookupRids_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.LookupRids.opnum() -> 18 (0x12) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_LookupRids_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_LookupRids_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_LookupRids_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_LookupRids_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_LookupRids_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_LookupRids_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_LookupRids_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.LookupRids",
	.tp_getset = py_samr_LookupRids_getsetters,
	.tp_methods = py_samr_LookupRids_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_LookupRids_new,
};

static bool pack_py_samr_LookupRids_args_in(PyObject *args, PyObject *kwargs, struct samr_LookupRids *r)
{
	PyObject *py_domain_handle;
	PyObject *py_rids;
	const char *kwnames[] = {
		"domain_handle", "rids", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:samr_LookupRids", discard_const_p(char *, kwnames), &py_domain_handle, &py_rids)) {
		return false;
	}

	if (py_domain_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain_handle");
		return false;
	}
	r->in.domain_handle = talloc_ptrtype(r, r->in.domain_handle);
	if (r->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_domain_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_domain_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(py_domain_handle);
	PY_CHECK_TYPE(&PyList_Type, py_rids, return false;);
	r->in.num_rids = PyList_GET_SIZE(py_rids);
	if (py_rids == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.rids");
		return false;
	}
	PY_CHECK_TYPE(&PyList_Type, py_rids, return false;);
	{
		int rids_cntr_0;
		r->in.rids = talloc_array_ptrtype(r, r->in.rids, PyList_GET_SIZE(py_rids));
		if (!r->in.rids) { return false; }
		talloc_set_name_const(r->in.rids, "ARRAY: r->in.rids");
		for (rids_cntr_0 = 0; rids_cntr_0 < PyList_GET_SIZE(py_rids); rids_cntr_0++) {
			if (PyList_GET_ITEM(py_rids, rids_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (r->in.rids)[rids_cntr_0]");
				return false;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((r->in.rids)[rids_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(py_rids, rids_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(py_rids, rids_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return false;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return false;
					}
					(r->in.rids)[rids_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return false;
				}
			}
		}
	}
	return true;
}

static PyObject *unpack_py_samr_LookupRids_args_out(struct samr_LookupRids *r, bool raise_result_exception)
{
	PyObject *py_names = NULL;
	PyObject *py_types = NULL;
	PyObject *result = NULL;
	size_t result_size = 2;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_names = pytalloc_reference_ex(lsa_Strings_Type, r->out.names, r->out.names);
	PyTuple_SetItem(result, 0, py_names);

	py_types = pytalloc_reference_ex(&samr_Ids_Type, r->out.types, r->out.types);
	PyTuple_SetItem(result, 1, py_types);

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 2, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_samr_OpenGroup_in_get_domain_handle(PyObject *obj, void *closure)
{
	struct samr_OpenGroup *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_handle;
	if (object->in.domain_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_domain_handle = pytalloc_reference_ex(policy_handle_Type, object->in.domain_handle, object->in.domain_handle);
	return py_domain_handle;
}

static int py_samr_OpenGroup_in_set_domain_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_OpenGroup *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.domain_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain_handle");
		return -1;
	}
	object->in.domain_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_handle);
	if (object->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_OpenGroup_in_get_access_mask(PyObject *obj, void *closure)
{
	struct samr_OpenGroup *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_samr_OpenGroup_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_OpenGroup *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_OpenGroup_in_get_rid(PyObject *obj, void *closure)
{
	struct samr_OpenGroup *object = pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(object->in.rid));
	return py_rid;
}

static int py_samr_OpenGroup_in_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_OpenGroup *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.rid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.rid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_OpenGroup_out_get_group_handle(PyObject *obj, void *closure)
{
	struct samr_OpenGroup *object = pytalloc_get_ptr(obj);
	PyObject *py_group_handle;
	if (object->out.group_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_group_handle = pytalloc_reference_ex(policy_handle_Type, object->out.group_handle, object->out.group_handle);
	return py_group_handle;
}

static int py_samr_OpenGroup_out_set_group_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_OpenGroup *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.group_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.group_handle");
		return -1;
	}
	object->out.group_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.group_handle);
	if (object->out.group_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.group_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_OpenGroup_get_result(PyObject *obj, void *closure)
{
	struct samr_OpenGroup *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_OpenGroup_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_OpenGroup *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_OpenGroup_getsetters[] = {
	{
		.name = discard_const_p(char, "in_domain_handle"),
		.get = py_samr_OpenGroup_in_get_domain_handle,
		.set = py_samr_OpenGroup_in_set_domain_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_samr_OpenGroup_in_get_access_mask,
		.set = py_samr_OpenGroup_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_GroupAccessMask")
	},
	{
		.name = discard_const_p(char, "in_rid"),
		.get = py_samr_OpenGroup_in_get_rid,
		.set = py_samr_OpenGroup_in_set_rid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_group_handle"),
		.get = py_samr_OpenGroup_out_get_group_handle,
		.set = py_samr_OpenGroup_out_set_group_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_OpenGroup_get_result,
		.set = py_samr_OpenGroup_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_OpenGroup_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_OpenGroup, type);
	struct samr_OpenGroup *_self = (struct samr_OpenGroup *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.domain_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.group_handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_samr_OpenGroup_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(19);
}

static PyObject *py_samr_OpenGroup_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_OpenGroup *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 20) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_OpenGroup_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[19];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_OpenGroup_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_OpenGroup_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_OpenGroup_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_OpenGroup_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_OpenGroup_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_OpenGroup *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 20) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_OpenGroup_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[19];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_OpenGroup_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_OpenGroup_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_OpenGroup_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_OpenGroup_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_OpenGroup_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_OpenGroup *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 20) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_OpenGroup_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[19];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_OpenGroup_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_OpenGroup_ndr_print(py_obj, args, kwargs, "samr_OpenGroup_in", NDR_IN);
}

static PyObject *py_samr_OpenGroup_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_OpenGroup_ndr_print(py_obj, args, kwargs, "samr_OpenGroup_out", NDR_OUT);
}

static PyMethodDef py_samr_OpenGroup_methods[] = {
	{ "opnum", (PyCFunction)py_samr_OpenGroup_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.OpenGroup.opnum() -> 19 (0x13) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_OpenGroup_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_OpenGroup_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_OpenGroup_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_OpenGroup_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_OpenGroup_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_OpenGroup_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_OpenGroup_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.OpenGroup",
	.tp_getset = py_samr_OpenGroup_getsetters,
	.tp_methods = py_samr_OpenGroup_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_OpenGroup_new,
};

static bool pack_py_samr_OpenGroup_args_in(PyObject *args, PyObject *kwargs, struct samr_OpenGroup *r)
{
	PyObject *py_domain_handle;
	PyObject *py_access_mask;
	PyObject *py_rid;
	const char *kwnames[] = {
		"domain_handle", "access_mask", "rid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:samr_OpenGroup", discard_const_p(char *, kwnames), &py_domain_handle, &py_access_mask, &py_rid)) {
		return false;
	}

	if (py_domain_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain_handle");
		return false;
	}
	r->in.domain_handle = talloc_ptrtype(r, r->in.domain_handle);
	if (r->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_domain_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_domain_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(py_domain_handle);
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_rid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.rid");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.rid));
		if (PyLong_Check(py_rid)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_rid);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_samr_OpenGroup_args_out(struct samr_OpenGroup *r, bool raise_result_exception)
{
	PyObject *py_group_handle = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_group_handle = pytalloc_reference_ex(policy_handle_Type, r->out.group_handle, r->out.group_handle);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_group_handle);
	}
	if (result_size == 1) {
		result = py_group_handle;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_samr_QueryGroupInfo_in_get_group_handle(PyObject *obj, void *closure)
{
	struct samr_QueryGroupInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_group_handle;
	if (object->in.group_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_group_handle = pytalloc_reference_ex(policy_handle_Type, object->in.group_handle, object->in.group_handle);
	return py_group_handle;
}

static int py_samr_QueryGroupInfo_in_set_group_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_QueryGroupInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.group_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.group_handle");
		return -1;
	}
	object->in.group_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.group_handle);
	if (object->in.group_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.group_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_QueryGroupInfo_in_get_level(PyObject *obj, void *closure)
{
	struct samr_QueryGroupInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromLong((uint16_t)(object->in.level));
	return py_level;
}

static int py_samr_QueryGroupInfo_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_QueryGroupInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_QueryGroupInfo_out_get_info(PyObject *obj, void *closure)
{
	struct samr_QueryGroupInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->out.info == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pyrpc_import_union(&samr_GroupInfo_Type, *object->out.info, object->in.level, *object->out.info, "union samr_GroupInfo");
		if (py_info == NULL) {
			return NULL;
		}
	}
	return py_info;
}

static int py_samr_QueryGroupInfo_out_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_QueryGroupInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.info");
		return -1;
	}
	object->out.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.info);
	if (object->out.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.info = NULL;
	} else {
		*object->out.info = NULL;
		{
			union samr_GroupInfo *info_switch_2;
			info_switch_2 = (union samr_GroupInfo *)pyrpc_export_union(&samr_GroupInfo_Type, pytalloc_get_mem_ctx(py_obj), object->in.level, value, "union samr_GroupInfo");
			if (info_switch_2 == NULL) {
				return -1;
			}
			*object->out.info = info_switch_2;
		}
	}
	return 0;
}

static PyObject *py_samr_QueryGroupInfo_get_result(PyObject *obj, void *closure)
{
	struct samr_QueryGroupInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_QueryGroupInfo_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_QueryGroupInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_QueryGroupInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "in_group_handle"),
		.get = py_samr_QueryGroupInfo_in_get_group_handle,
		.set = py_samr_QueryGroupInfo_in_set_group_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_level"),
		.get = py_samr_QueryGroupInfo_in_get_level,
		.set = py_samr_QueryGroupInfo_in_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_GroupInfoEnum")
	},
	{
		.name = discard_const_p(char, "out_info"),
		.get = py_samr_QueryGroupInfo_out_get_info,
		.set = py_samr_QueryGroupInfo_out_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_GroupInfo")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_QueryGroupInfo_get_result,
		.set = py_samr_QueryGroupInfo_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_QueryGroupInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_QueryGroupInfo, type);
	struct samr_QueryGroupInfo *_self = (struct samr_QueryGroupInfo *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.group_handle = talloc_zero(mem_ctx, struct policy_handle);
	/* a pointer to a NULL pointer */
	_self->out.info = talloc_zero(mem_ctx, union samr_GroupInfo *);
	return self;
}

static PyObject *py_samr_QueryGroupInfo_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(20);
}

static PyObject *py_samr_QueryGroupInfo_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_QueryGroupInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 21) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_QueryGroupInfo_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[20];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_QueryGroupInfo_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_QueryGroupInfo_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_QueryGroupInfo_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_QueryGroupInfo_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_QueryGroupInfo_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_QueryGroupInfo *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 21) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_QueryGroupInfo_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[20];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_QueryGroupInfo_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_QueryGroupInfo_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_QueryGroupInfo_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_QueryGroupInfo_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_QueryGroupInfo_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_QueryGroupInfo *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 21) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_QueryGroupInfo_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[20];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_QueryGroupInfo_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_QueryGroupInfo_ndr_print(py_obj, args, kwargs, "samr_QueryGroupInfo_in", NDR_IN);
}

static PyObject *py_samr_QueryGroupInfo_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_QueryGroupInfo_ndr_print(py_obj, args, kwargs, "samr_QueryGroupInfo_out", NDR_OUT);
}

static PyMethodDef py_samr_QueryGroupInfo_methods[] = {
	{ "opnum", (PyCFunction)py_samr_QueryGroupInfo_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.QueryGroupInfo.opnum() -> 20 (0x14) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryGroupInfo_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryGroupInfo_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryGroupInfo_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryGroupInfo_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryGroupInfo_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryGroupInfo_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_QueryGroupInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.QueryGroupInfo",
	.tp_getset = py_samr_QueryGroupInfo_getsetters,
	.tp_methods = py_samr_QueryGroupInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_QueryGroupInfo_new,
};

static bool pack_py_samr_QueryGroupInfo_args_in(PyObject *args, PyObject *kwargs, struct samr_QueryGroupInfo *r)
{
	PyObject *py_group_handle;
	PyObject *py_level;
	const char *kwnames[] = {
		"group_handle", "level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:samr_QueryGroupInfo", discard_const_p(char *, kwnames), &py_group_handle, &py_level)) {
		return false;
	}

	if (py_group_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.group_handle");
		return false;
	}
	r->in.group_handle = talloc_ptrtype(r, r->in.group_handle);
	if (r->in.group_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_group_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_group_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.group_handle = (struct policy_handle *)pytalloc_get_ptr(py_group_handle);
	if (py_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.level));
		if (PyLong_Check(py_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_samr_QueryGroupInfo_args_out(struct samr_QueryGroupInfo *r, bool raise_result_exception)
{
	PyObject *py_info = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (*r->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pyrpc_import_union(&samr_GroupInfo_Type, *r->out.info, r->in.level, *r->out.info, "union samr_GroupInfo");
		if (py_info == NULL) {
			return NULL;
		}
	}
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_info);
	}
	if (result_size == 1) {
		result = py_info;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_samr_SetGroupInfo_in_get_group_handle(PyObject *obj, void *closure)
{
	struct samr_SetGroupInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_group_handle;
	if (object->in.group_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_group_handle = pytalloc_reference_ex(policy_handle_Type, object->in.group_handle, object->in.group_handle);
	return py_group_handle;
}

static int py_samr_SetGroupInfo_in_set_group_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SetGroupInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.group_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.group_handle");
		return -1;
	}
	object->in.group_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.group_handle);
	if (object->in.group_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.group_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_SetGroupInfo_in_get_level(PyObject *obj, void *closure)
{
	struct samr_SetGroupInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromLong((uint16_t)(object->in.level));
	return py_level;
}

static int py_samr_SetGroupInfo_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SetGroupInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_SetGroupInfo_in_get_info(PyObject *obj, void *closure)
{
	struct samr_SetGroupInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->in.info == NULL) {
		Py_RETURN_NONE;
	}
	py_info = pyrpc_import_union(&samr_GroupInfo_Type, object->in.info, object->in.level, object->in.info, "union samr_GroupInfo");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_samr_SetGroupInfo_in_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SetGroupInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.info");
		return -1;
	}
	object->in.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.info);
	if (object->in.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		union samr_GroupInfo *info_switch_1;
		info_switch_1 = (union samr_GroupInfo *)pyrpc_export_union(&samr_GroupInfo_Type, pytalloc_get_mem_ctx(py_obj), object->in.level, value, "union samr_GroupInfo");
		if (info_switch_1 == NULL) {
			return -1;
		}
		object->in.info = info_switch_1;
	}
	return 0;
}

static PyObject *py_samr_SetGroupInfo_get_result(PyObject *obj, void *closure)
{
	struct samr_SetGroupInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_SetGroupInfo_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SetGroupInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_SetGroupInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "in_group_handle"),
		.get = py_samr_SetGroupInfo_in_get_group_handle,
		.set = py_samr_SetGroupInfo_in_set_group_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_level"),
		.get = py_samr_SetGroupInfo_in_get_level,
		.set = py_samr_SetGroupInfo_in_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_GroupInfoEnum")
	},
	{
		.name = discard_const_p(char, "in_info"),
		.get = py_samr_SetGroupInfo_in_get_info,
		.set = py_samr_SetGroupInfo_in_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_GroupInfo")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_SetGroupInfo_get_result,
		.set = py_samr_SetGroupInfo_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_SetGroupInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_SetGroupInfo, type);
	struct samr_SetGroupInfo *_self = (struct samr_SetGroupInfo *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.group_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->in.info = talloc_zero(mem_ctx, union samr_GroupInfo);
	return self;
}

static PyObject *py_samr_SetGroupInfo_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(21);
}

static PyObject *py_samr_SetGroupInfo_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_SetGroupInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 22) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_SetGroupInfo_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[21];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_SetGroupInfo_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_SetGroupInfo_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_SetGroupInfo_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_SetGroupInfo_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_SetGroupInfo_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_SetGroupInfo *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 22) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_SetGroupInfo_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[21];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_SetGroupInfo_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_SetGroupInfo_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_SetGroupInfo_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_SetGroupInfo_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_SetGroupInfo_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_SetGroupInfo *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 22) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_SetGroupInfo_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[21];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_SetGroupInfo_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_SetGroupInfo_ndr_print(py_obj, args, kwargs, "samr_SetGroupInfo_in", NDR_IN);
}

static PyObject *py_samr_SetGroupInfo_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_SetGroupInfo_ndr_print(py_obj, args, kwargs, "samr_SetGroupInfo_out", NDR_OUT);
}

static PyMethodDef py_samr_SetGroupInfo_methods[] = {
	{ "opnum", (PyCFunction)py_samr_SetGroupInfo_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.SetGroupInfo.opnum() -> 21 (0x15) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetGroupInfo_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetGroupInfo_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetGroupInfo_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetGroupInfo_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetGroupInfo_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetGroupInfo_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_SetGroupInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.SetGroupInfo",
	.tp_getset = py_samr_SetGroupInfo_getsetters,
	.tp_methods = py_samr_SetGroupInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_SetGroupInfo_new,
};

static bool pack_py_samr_SetGroupInfo_args_in(PyObject *args, PyObject *kwargs, struct samr_SetGroupInfo *r)
{
	PyObject *py_group_handle;
	PyObject *py_level;
	PyObject *py_info;
	const char *kwnames[] = {
		"group_handle", "level", "info", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:samr_SetGroupInfo", discard_const_p(char *, kwnames), &py_group_handle, &py_level, &py_info)) {
		return false;
	}

	if (py_group_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.group_handle");
		return false;
	}
	r->in.group_handle = talloc_ptrtype(r, r->in.group_handle);
	if (r->in.group_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_group_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_group_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.group_handle = (struct policy_handle *)pytalloc_get_ptr(py_group_handle);
	if (py_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.level));
		if (PyLong_Check(py_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_info == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.info");
		return false;
	}
	r->in.info = talloc_ptrtype(r, r->in.info);
	if (r->in.info == NULL) {
		PyErr_NoMemory();
		return false;
	}
	{
		union samr_GroupInfo *info_switch_1;
		info_switch_1 = (union samr_GroupInfo *)pyrpc_export_union(&samr_GroupInfo_Type, r, r->in.level, py_info, "union samr_GroupInfo");
		if (info_switch_1 == NULL) {
			return false;
		}
		r->in.info = info_switch_1;
	}
	return true;
}

static PyObject *unpack_py_samr_SetGroupInfo_args_out(struct samr_SetGroupInfo *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromNTSTATUS(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_samr_AddGroupMember_in_get_group_handle(PyObject *obj, void *closure)
{
	struct samr_AddGroupMember *object = pytalloc_get_ptr(obj);
	PyObject *py_group_handle;
	if (object->in.group_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_group_handle = pytalloc_reference_ex(policy_handle_Type, object->in.group_handle, object->in.group_handle);
	return py_group_handle;
}

static int py_samr_AddGroupMember_in_set_group_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_AddGroupMember *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.group_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.group_handle");
		return -1;
	}
	object->in.group_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.group_handle);
	if (object->in.group_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.group_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_AddGroupMember_in_get_rid(PyObject *obj, void *closure)
{
	struct samr_AddGroupMember *object = pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(object->in.rid));
	return py_rid;
}

static int py_samr_AddGroupMember_in_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_AddGroupMember *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.rid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.rid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_AddGroupMember_in_get_flags(PyObject *obj, void *closure)
{
	struct samr_AddGroupMember *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->in.flags));
	return py_flags;
}

static int py_samr_AddGroupMember_in_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_AddGroupMember *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_AddGroupMember_get_result(PyObject *obj, void *closure)
{
	struct samr_AddGroupMember *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_AddGroupMember_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_AddGroupMember *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_AddGroupMember_getsetters[] = {
	{
		.name = discard_const_p(char, "in_group_handle"),
		.get = py_samr_AddGroupMember_in_get_group_handle,
		.set = py_samr_AddGroupMember_in_set_group_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_rid"),
		.get = py_samr_AddGroupMember_in_get_rid,
		.set = py_samr_AddGroupMember_in_set_rid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_flags"),
		.get = py_samr_AddGroupMember_in_get_flags,
		.set = py_samr_AddGroupMember_in_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_AddGroupMember_get_result,
		.set = py_samr_AddGroupMember_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_AddGroupMember_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_AddGroupMember, type);
	struct samr_AddGroupMember *_self = (struct samr_AddGroupMember *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.group_handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_samr_AddGroupMember_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(22);
}

static PyObject *py_samr_AddGroupMember_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_AddGroupMember *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 23) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_AddGroupMember_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[22];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_AddGroupMember_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_AddGroupMember_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_AddGroupMember_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_AddGroupMember_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_AddGroupMember_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_AddGroupMember *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 23) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_AddGroupMember_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[22];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_AddGroupMember_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_AddGroupMember_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_AddGroupMember_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_AddGroupMember_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_AddGroupMember_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_AddGroupMember *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 23) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_AddGroupMember_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[22];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_AddGroupMember_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_AddGroupMember_ndr_print(py_obj, args, kwargs, "samr_AddGroupMember_in", NDR_IN);
}

static PyObject *py_samr_AddGroupMember_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_AddGroupMember_ndr_print(py_obj, args, kwargs, "samr_AddGroupMember_out", NDR_OUT);
}

static PyMethodDef py_samr_AddGroupMember_methods[] = {
	{ "opnum", (PyCFunction)py_samr_AddGroupMember_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.AddGroupMember.opnum() -> 22 (0x16) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_AddGroupMember_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_AddGroupMember_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_AddGroupMember_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_AddGroupMember_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_AddGroupMember_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_AddGroupMember_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_AddGroupMember_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.AddGroupMember",
	.tp_getset = py_samr_AddGroupMember_getsetters,
	.tp_methods = py_samr_AddGroupMember_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_AddGroupMember_new,
};

static bool pack_py_samr_AddGroupMember_args_in(PyObject *args, PyObject *kwargs, struct samr_AddGroupMember *r)
{
	PyObject *py_group_handle;
	PyObject *py_rid;
	PyObject *py_flags;
	const char *kwnames[] = {
		"group_handle", "rid", "flags", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:samr_AddGroupMember", discard_const_p(char *, kwnames), &py_group_handle, &py_rid, &py_flags)) {
		return false;
	}

	if (py_group_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.group_handle");
		return false;
	}
	r->in.group_handle = talloc_ptrtype(r, r->in.group_handle);
	if (r->in.group_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_group_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_group_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.group_handle = (struct policy_handle *)pytalloc_get_ptr(py_group_handle);
	if (py_rid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.rid");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.rid));
		if (PyLong_Check(py_rid)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_rid);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_flags == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.flags");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.flags));
		if (PyLong_Check(py_flags)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_flags);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_samr_AddGroupMember_args_out(struct samr_AddGroupMember *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromNTSTATUS(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_samr_DeleteDomainGroup_in_get_group_handle(PyObject *obj, void *closure)
{
	struct samr_DeleteDomainGroup *object = pytalloc_get_ptr(obj);
	PyObject *py_group_handle;
	if (object->in.group_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_group_handle = pytalloc_reference_ex(policy_handle_Type, object->in.group_handle, object->in.group_handle);
	return py_group_handle;
}

static int py_samr_DeleteDomainGroup_in_set_group_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DeleteDomainGroup *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.group_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.group_handle");
		return -1;
	}
	object->in.group_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.group_handle);
	if (object->in.group_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.group_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_DeleteDomainGroup_out_get_group_handle(PyObject *obj, void *closure)
{
	struct samr_DeleteDomainGroup *object = pytalloc_get_ptr(obj);
	PyObject *py_group_handle;
	if (object->out.group_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_group_handle = pytalloc_reference_ex(policy_handle_Type, object->out.group_handle, object->out.group_handle);
	return py_group_handle;
}

static int py_samr_DeleteDomainGroup_out_set_group_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DeleteDomainGroup *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.group_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.group_handle");
		return -1;
	}
	object->out.group_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.group_handle);
	if (object->out.group_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.group_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_DeleteDomainGroup_get_result(PyObject *obj, void *closure)
{
	struct samr_DeleteDomainGroup *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_DeleteDomainGroup_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DeleteDomainGroup *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_DeleteDomainGroup_getsetters[] = {
	{
		.name = discard_const_p(char, "in_group_handle"),
		.get = py_samr_DeleteDomainGroup_in_get_group_handle,
		.set = py_samr_DeleteDomainGroup_in_set_group_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_group_handle"),
		.get = py_samr_DeleteDomainGroup_out_get_group_handle,
		.set = py_samr_DeleteDomainGroup_out_set_group_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_DeleteDomainGroup_get_result,
		.set = py_samr_DeleteDomainGroup_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_DeleteDomainGroup_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_DeleteDomainGroup, type);
	struct samr_DeleteDomainGroup *_self = (struct samr_DeleteDomainGroup *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.group_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.group_handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_samr_DeleteDomainGroup_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(23);
}

static PyObject *py_samr_DeleteDomainGroup_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_DeleteDomainGroup *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 24) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_DeleteDomainGroup_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[23];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_DeleteDomainGroup_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_DeleteDomainGroup_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_DeleteDomainGroup_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_DeleteDomainGroup_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_DeleteDomainGroup_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_DeleteDomainGroup *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 24) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_DeleteDomainGroup_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[23];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_DeleteDomainGroup_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_DeleteDomainGroup_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_DeleteDomainGroup_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_DeleteDomainGroup_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_DeleteDomainGroup_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_DeleteDomainGroup *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 24) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_DeleteDomainGroup_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[23];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_DeleteDomainGroup_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_DeleteDomainGroup_ndr_print(py_obj, args, kwargs, "samr_DeleteDomainGroup_in", NDR_IN);
}

static PyObject *py_samr_DeleteDomainGroup_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_DeleteDomainGroup_ndr_print(py_obj, args, kwargs, "samr_DeleteDomainGroup_out", NDR_OUT);
}

static PyMethodDef py_samr_DeleteDomainGroup_methods[] = {
	{ "opnum", (PyCFunction)py_samr_DeleteDomainGroup_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.DeleteDomainGroup.opnum() -> 23 (0x17) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_DeleteDomainGroup_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_DeleteDomainGroup_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_DeleteDomainGroup_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_DeleteDomainGroup_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_DeleteDomainGroup_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_DeleteDomainGroup_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_DeleteDomainGroup_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DeleteDomainGroup",
	.tp_getset = py_samr_DeleteDomainGroup_getsetters,
	.tp_methods = py_samr_DeleteDomainGroup_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DeleteDomainGroup_new,
};

static bool pack_py_samr_DeleteDomainGroup_args_in(PyObject *args, PyObject *kwargs, struct samr_DeleteDomainGroup *r)
{
	PyObject *py_group_handle;
	const char *kwnames[] = {
		"group_handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:samr_DeleteDomainGroup", discard_const_p(char *, kwnames), &py_group_handle)) {
		return false;
	}

	if (py_group_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.group_handle");
		return false;
	}
	r->in.group_handle = talloc_ptrtype(r, r->in.group_handle);
	if (r->in.group_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_group_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_group_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.group_handle = (struct policy_handle *)pytalloc_get_ptr(py_group_handle);
	return true;
}

static PyObject *unpack_py_samr_DeleteDomainGroup_args_out(struct samr_DeleteDomainGroup *r, bool raise_result_exception)
{
	PyObject *py_group_handle = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_group_handle = pytalloc_reference_ex(policy_handle_Type, r->out.group_handle, r->out.group_handle);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_group_handle);
	}
	if (result_size == 1) {
		result = py_group_handle;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_samr_DeleteGroupMember_in_get_group_handle(PyObject *obj, void *closure)
{
	struct samr_DeleteGroupMember *object = pytalloc_get_ptr(obj);
	PyObject *py_group_handle;
	if (object->in.group_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_group_handle = pytalloc_reference_ex(policy_handle_Type, object->in.group_handle, object->in.group_handle);
	return py_group_handle;
}

static int py_samr_DeleteGroupMember_in_set_group_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DeleteGroupMember *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.group_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.group_handle");
		return -1;
	}
	object->in.group_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.group_handle);
	if (object->in.group_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.group_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_DeleteGroupMember_in_get_rid(PyObject *obj, void *closure)
{
	struct samr_DeleteGroupMember *object = pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(object->in.rid));
	return py_rid;
}

static int py_samr_DeleteGroupMember_in_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DeleteGroupMember *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.rid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.rid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_DeleteGroupMember_get_result(PyObject *obj, void *closure)
{
	struct samr_DeleteGroupMember *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_DeleteGroupMember_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_DeleteGroupMember *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_DeleteGroupMember_getsetters[] = {
	{
		.name = discard_const_p(char, "in_group_handle"),
		.get = py_samr_DeleteGroupMember_in_get_group_handle,
		.set = py_samr_DeleteGroupMember_in_set_group_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_rid"),
		.get = py_samr_DeleteGroupMember_in_get_rid,
		.set = py_samr_DeleteGroupMember_in_set_rid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_DeleteGroupMember_get_result,
		.set = py_samr_DeleteGroupMember_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_DeleteGroupMember_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_DeleteGroupMember, type);
	struct samr_DeleteGroupMember *_self = (struct samr_DeleteGroupMember *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.group_handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_samr_DeleteGroupMember_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(24);
}

static PyObject *py_samr_DeleteGroupMember_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_DeleteGroupMember *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 25) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_DeleteGroupMember_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[24];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_DeleteGroupMember_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_DeleteGroupMember_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_DeleteGroupMember_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_DeleteGroupMember_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_DeleteGroupMember_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_DeleteGroupMember *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 25) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_DeleteGroupMember_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[24];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_DeleteGroupMember_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_DeleteGroupMember_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_DeleteGroupMember_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_DeleteGroupMember_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_DeleteGroupMember_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_DeleteGroupMember *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 25) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_DeleteGroupMember_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[24];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_DeleteGroupMember_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_DeleteGroupMember_ndr_print(py_obj, args, kwargs, "samr_DeleteGroupMember_in", NDR_IN);
}

static PyObject *py_samr_DeleteGroupMember_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_DeleteGroupMember_ndr_print(py_obj, args, kwargs, "samr_DeleteGroupMember_out", NDR_OUT);
}

static PyMethodDef py_samr_DeleteGroupMember_methods[] = {
	{ "opnum", (PyCFunction)py_samr_DeleteGroupMember_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.DeleteGroupMember.opnum() -> 24 (0x18) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_DeleteGroupMember_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_DeleteGroupMember_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_DeleteGroupMember_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_DeleteGroupMember_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_DeleteGroupMember_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_DeleteGroupMember_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_DeleteGroupMember_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.DeleteGroupMember",
	.tp_getset = py_samr_DeleteGroupMember_getsetters,
	.tp_methods = py_samr_DeleteGroupMember_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_DeleteGroupMember_new,
};

static bool pack_py_samr_DeleteGroupMember_args_in(PyObject *args, PyObject *kwargs, struct samr_DeleteGroupMember *r)
{
	PyObject *py_group_handle;
	PyObject *py_rid;
	const char *kwnames[] = {
		"group_handle", "rid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:samr_DeleteGroupMember", discard_const_p(char *, kwnames), &py_group_handle, &py_rid)) {
		return false;
	}

	if (py_group_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.group_handle");
		return false;
	}
	r->in.group_handle = talloc_ptrtype(r, r->in.group_handle);
	if (r->in.group_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_group_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_group_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.group_handle = (struct policy_handle *)pytalloc_get_ptr(py_group_handle);
	if (py_rid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.rid");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.rid));
		if (PyLong_Check(py_rid)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_rid);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_samr_DeleteGroupMember_args_out(struct samr_DeleteGroupMember *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromNTSTATUS(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_samr_QueryGroupMember_in_get_group_handle(PyObject *obj, void *closure)
{
	struct samr_QueryGroupMember *object = pytalloc_get_ptr(obj);
	PyObject *py_group_handle;
	if (object->in.group_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_group_handle = pytalloc_reference_ex(policy_handle_Type, object->in.group_handle, object->in.group_handle);
	return py_group_handle;
}

static int py_samr_QueryGroupMember_in_set_group_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_QueryGroupMember *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.group_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.group_handle");
		return -1;
	}
	object->in.group_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.group_handle);
	if (object->in.group_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.group_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_QueryGroupMember_out_get_rids(PyObject *obj, void *closure)
{
	struct samr_QueryGroupMember *object = pytalloc_get_ptr(obj);
	PyObject *py_rids;
	if (object->out.rids == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.rids == NULL) {
		py_rids = Py_None;
		Py_INCREF(py_rids);
	} else {
		py_rids = pytalloc_reference_ex(&samr_RidAttrArray_Type, *object->out.rids, *object->out.rids);
	}
	return py_rids;
}

static int py_samr_QueryGroupMember_out_set_rids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_QueryGroupMember *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.rids));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.rids");
		return -1;
	}
	object->out.rids = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.rids);
	if (object->out.rids == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.rids = NULL;
	} else {
		*object->out.rids = NULL;
		PY_CHECK_TYPE(&samr_RidAttrArray_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.rids = (struct samr_RidAttrArray *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_samr_QueryGroupMember_get_result(PyObject *obj, void *closure)
{
	struct samr_QueryGroupMember *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_QueryGroupMember_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_QueryGroupMember *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_QueryGroupMember_getsetters[] = {
	{
		.name = discard_const_p(char, "in_group_handle"),
		.get = py_samr_QueryGroupMember_in_get_group_handle,
		.set = py_samr_QueryGroupMember_in_set_group_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "out_rids"),
		.get = py_samr_QueryGroupMember_out_get_rids,
		.set = py_samr_QueryGroupMember_out_set_rids,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_RidAttrArray")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_QueryGroupMember_get_result,
		.set = py_samr_QueryGroupMember_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_QueryGroupMember_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_QueryGroupMember, type);
	struct samr_QueryGroupMember *_self = (struct samr_QueryGroupMember *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.group_handle = talloc_zero(mem_ctx, struct policy_handle);
	/* a pointer to a NULL pointer */
	_self->out.rids = talloc_zero(mem_ctx, struct samr_RidAttrArray *);
	return self;
}

static PyObject *py_samr_QueryGroupMember_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(25);
}

static PyObject *py_samr_QueryGroupMember_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_QueryGroupMember *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 26) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_QueryGroupMember_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[25];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_QueryGroupMember_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_QueryGroupMember_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_QueryGroupMember_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_QueryGroupMember_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_QueryGroupMember_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_QueryGroupMember *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 26) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_QueryGroupMember_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[25];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_QueryGroupMember_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_QueryGroupMember_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_QueryGroupMember_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_QueryGroupMember_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_QueryGroupMember_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_QueryGroupMember *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 26) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_QueryGroupMember_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[25];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_QueryGroupMember_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_QueryGroupMember_ndr_print(py_obj, args, kwargs, "samr_QueryGroupMember_in", NDR_IN);
}

static PyObject *py_samr_QueryGroupMember_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_QueryGroupMember_ndr_print(py_obj, args, kwargs, "samr_QueryGroupMember_out", NDR_OUT);
}

static PyMethodDef py_samr_QueryGroupMember_methods[] = {
	{ "opnum", (PyCFunction)py_samr_QueryGroupMember_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.QueryGroupMember.opnum() -> 25 (0x19) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryGroupMember_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryGroupMember_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryGroupMember_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryGroupMember_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryGroupMember_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryGroupMember_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_QueryGroupMember_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.QueryGroupMember",
	.tp_getset = py_samr_QueryGroupMember_getsetters,
	.tp_methods = py_samr_QueryGroupMember_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_QueryGroupMember_new,
};

static bool pack_py_samr_QueryGroupMember_args_in(PyObject *args, PyObject *kwargs, struct samr_QueryGroupMember *r)
{
	PyObject *py_group_handle;
	const char *kwnames[] = {
		"group_handle", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O:samr_QueryGroupMember", discard_const_p(char *, kwnames), &py_group_handle)) {
		return false;
	}

	if (py_group_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.group_handle");
		return false;
	}
	r->in.group_handle = talloc_ptrtype(r, r->in.group_handle);
	if (r->in.group_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_group_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_group_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.group_handle = (struct policy_handle *)pytalloc_get_ptr(py_group_handle);
	return true;
}

static PyObject *unpack_py_samr_QueryGroupMember_args_out(struct samr_QueryGroupMember *r, bool raise_result_exception)
{
	PyObject *py_rids = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (*r->out.rids == NULL) {
		py_rids = Py_None;
		Py_INCREF(py_rids);
	} else {
		py_rids = pytalloc_reference_ex(&samr_RidAttrArray_Type, *r->out.rids, *r->out.rids);
	}
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_rids);
	}
	if (result_size == 1) {
		result = py_rids;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_samr_SetMemberAttributesOfGroup_in_get_group_handle(PyObject *obj, void *closure)
{
	struct samr_SetMemberAttributesOfGroup *object = pytalloc_get_ptr(obj);
	PyObject *py_group_handle;
	if (object->in.group_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_group_handle = pytalloc_reference_ex(policy_handle_Type, object->in.group_handle, object->in.group_handle);
	return py_group_handle;
}

static int py_samr_SetMemberAttributesOfGroup_in_set_group_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SetMemberAttributesOfGroup *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.group_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.group_handle");
		return -1;
	}
	object->in.group_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.group_handle);
	if (object->in.group_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.group_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_SetMemberAttributesOfGroup_in_get_unknown1(PyObject *obj, void *closure)
{
	struct samr_SetMemberAttributesOfGroup *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown1;
	py_unknown1 = PyLong_FromUnsignedLongLong((uint32_t)(object->in.unknown1));
	return py_unknown1;
}

static int py_samr_SetMemberAttributesOfGroup_in_set_unknown1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SetMemberAttributesOfGroup *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.unknown1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.unknown1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.unknown1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_SetMemberAttributesOfGroup_in_get_unknown2(PyObject *obj, void *closure)
{
	struct samr_SetMemberAttributesOfGroup *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown2;
	py_unknown2 = PyLong_FromUnsignedLongLong((uint32_t)(object->in.unknown2));
	return py_unknown2;
}

static int py_samr_SetMemberAttributesOfGroup_in_set_unknown2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SetMemberAttributesOfGroup *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.unknown2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.unknown2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.unknown2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_SetMemberAttributesOfGroup_get_result(PyObject *obj, void *closure)
{
	struct samr_SetMemberAttributesOfGroup *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_SetMemberAttributesOfGroup_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SetMemberAttributesOfGroup *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_SetMemberAttributesOfGroup_getsetters[] = {
	{
		.name = discard_const_p(char, "in_group_handle"),
		.get = py_samr_SetMemberAttributesOfGroup_in_get_group_handle,
		.set = py_samr_SetMemberAttributesOfGroup_in_set_group_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_unknown1"),
		.get = py_samr_SetMemberAttributesOfGroup_in_get_unknown1,
		.set = py_samr_SetMemberAttributesOfGroup_in_set_unknown1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_unknown2"),
		.get = py_samr_SetMemberAttributesOfGroup_in_get_unknown2,
		.set = py_samr_SetMemberAttributesOfGroup_in_set_unknown2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_SetMemberAttributesOfGroup_get_result,
		.set = py_samr_SetMemberAttributesOfGroup_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_SetMemberAttributesOfGroup_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_SetMemberAttributesOfGroup, type);
	struct samr_SetMemberAttributesOfGroup *_self = (struct samr_SetMemberAttributesOfGroup *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.group_handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_samr_SetMemberAttributesOfGroup_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(26);
}

static PyObject *py_samr_SetMemberAttributesOfGroup_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_SetMemberAttributesOfGroup *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 27) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_SetMemberAttributesOfGroup_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[26];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_SetMemberAttributesOfGroup_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_SetMemberAttributesOfGroup_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_SetMemberAttributesOfGroup_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_SetMemberAttributesOfGroup_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_SetMemberAttributesOfGroup_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_SetMemberAttributesOfGroup *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 27) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_SetMemberAttributesOfGroup_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[26];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_SetMemberAttributesOfGroup_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_SetMemberAttributesOfGroup_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_SetMemberAttributesOfGroup_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_SetMemberAttributesOfGroup_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_SetMemberAttributesOfGroup_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_SetMemberAttributesOfGroup *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 27) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_SetMemberAttributesOfGroup_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[26];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_SetMemberAttributesOfGroup_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_SetMemberAttributesOfGroup_ndr_print(py_obj, args, kwargs, "samr_SetMemberAttributesOfGroup_in", NDR_IN);
}

static PyObject *py_samr_SetMemberAttributesOfGroup_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_SetMemberAttributesOfGroup_ndr_print(py_obj, args, kwargs, "samr_SetMemberAttributesOfGroup_out", NDR_OUT);
}

static PyMethodDef py_samr_SetMemberAttributesOfGroup_methods[] = {
	{ "opnum", (PyCFunction)py_samr_SetMemberAttributesOfGroup_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.SetMemberAttributesOfGroup.opnum() -> 26 (0x1a) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetMemberAttributesOfGroup_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetMemberAttributesOfGroup_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetMemberAttributesOfGroup_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetMemberAttributesOfGroup_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetMemberAttributesOfGroup_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_SetMemberAttributesOfGroup_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_SetMemberAttributesOfGroup_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.SetMemberAttributesOfGroup",
	.tp_getset = py_samr_SetMemberAttributesOfGroup_getsetters,
	.tp_methods = py_samr_SetMemberAttributesOfGroup_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_SetMemberAttributesOfGroup_new,
};

static bool pack_py_samr_SetMemberAttributesOfGroup_args_in(PyObject *args, PyObject *kwargs, struct samr_SetMemberAttributesOfGroup *r)
{
	PyObject *py_group_handle;
	PyObject *py_unknown1;
	PyObject *py_unknown2;
	const char *kwnames[] = {
		"group_handle", "unknown1", "unknown2", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:samr_SetMemberAttributesOfGroup", discard_const_p(char *, kwnames), &py_group_handle, &py_unknown1, &py_unknown2)) {
		return false;
	}

	if (py_group_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.group_handle");
		return false;
	}
	r->in.group_handle = talloc_ptrtype(r, r->in.group_handle);
	if (r->in.group_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_group_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_group_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.group_handle = (struct policy_handle *)pytalloc_get_ptr(py_group_handle);
	if (py_unknown1 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.unknown1");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.unknown1));
		if (PyLong_Check(py_unknown1)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unknown1);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.unknown1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_unknown2 == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.unknown2");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.unknown2));
		if (PyLong_Check(py_unknown2)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unknown2);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.unknown2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_samr_SetMemberAttributesOfGroup_args_out(struct samr_SetMemberAttributesOfGroup *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromNTSTATUS(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_samr_OpenAlias_in_get_domain_handle(PyObject *obj, void *closure)
{
	struct samr_OpenAlias *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_handle;
	if (object->in.domain_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_domain_handle = pytalloc_reference_ex(policy_handle_Type, object->in.domain_handle, object->in.domain_handle);
	return py_domain_handle;
}

static int py_samr_OpenAlias_in_set_domain_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_OpenAlias *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.domain_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.domain_handle");
		return -1;
	}
	object->in.domain_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.domain_handle);
	if (object->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_OpenAlias_in_get_access_mask(PyObject *obj, void *closure)
{
	struct samr_OpenAlias *object = pytalloc_get_ptr(obj);
	PyObject *py_access_mask;
	py_access_mask = PyLong_FromUnsignedLongLong((uint32_t)(object->in.access_mask));
	return py_access_mask;
}

static int py_samr_OpenAlias_in_set_access_mask(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_OpenAlias *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.access_mask");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.access_mask));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_OpenAlias_in_get_rid(PyObject *obj, void *closure)
{
	struct samr_OpenAlias *object = pytalloc_get_ptr(obj);
	PyObject *py_rid;
	py_rid = PyLong_FromUnsignedLongLong((uint32_t)(object->in.rid));
	return py_rid;
}

static int py_samr_OpenAlias_in_set_rid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_OpenAlias *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.rid");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.rid));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_OpenAlias_out_get_alias_handle(PyObject *obj, void *closure)
{
	struct samr_OpenAlias *object = pytalloc_get_ptr(obj);
	PyObject *py_alias_handle;
	if (object->out.alias_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_alias_handle = pytalloc_reference_ex(policy_handle_Type, object->out.alias_handle, object->out.alias_handle);
	return py_alias_handle;
}

static int py_samr_OpenAlias_out_set_alias_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_OpenAlias *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.alias_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.alias_handle");
		return -1;
	}
	object->out.alias_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.alias_handle);
	if (object->out.alias_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.alias_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_OpenAlias_get_result(PyObject *obj, void *closure)
{
	struct samr_OpenAlias *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_OpenAlias_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_OpenAlias *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_OpenAlias_getsetters[] = {
	{
		.name = discard_const_p(char, "in_domain_handle"),
		.get = py_samr_OpenAlias_in_get_domain_handle,
		.set = py_samr_OpenAlias_in_set_domain_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_access_mask"),
		.get = py_samr_OpenAlias_in_get_access_mask,
		.set = py_samr_OpenAlias_in_set_access_mask,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_AliasAccessMask")
	},
	{
		.name = discard_const_p(char, "in_rid"),
		.get = py_samr_OpenAlias_in_get_rid,
		.set = py_samr_OpenAlias_in_set_rid,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_alias_handle"),
		.get = py_samr_OpenAlias_out_get_alias_handle,
		.set = py_samr_OpenAlias_out_set_alias_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_OpenAlias_get_result,
		.set = py_samr_OpenAlias_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_OpenAlias_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_OpenAlias, type);
	struct samr_OpenAlias *_self = (struct samr_OpenAlias *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.domain_handle = talloc_zero(mem_ctx, struct policy_handle);
	_self->out.alias_handle = talloc_zero(mem_ctx, struct policy_handle);
	return self;
}

static PyObject *py_samr_OpenAlias_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(27);
}

static PyObject *py_samr_OpenAlias_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_OpenAlias *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 28) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_OpenAlias_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[27];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_OpenAlias_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_OpenAlias_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_OpenAlias_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_OpenAlias_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_OpenAlias_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_OpenAlias *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 28) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_OpenAlias_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[27];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_OpenAlias_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_OpenAlias_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_OpenAlias_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_OpenAlias_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_OpenAlias_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_OpenAlias *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 28) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_OpenAlias_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[27];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_OpenAlias_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_OpenAlias_ndr_print(py_obj, args, kwargs, "samr_OpenAlias_in", NDR_IN);
}

static PyObject *py_samr_OpenAlias_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_OpenAlias_ndr_print(py_obj, args, kwargs, "samr_OpenAlias_out", NDR_OUT);
}

static PyMethodDef py_samr_OpenAlias_methods[] = {
	{ "opnum", (PyCFunction)py_samr_OpenAlias_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.OpenAlias.opnum() -> 27 (0x1b) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_OpenAlias_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_OpenAlias_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_OpenAlias_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_OpenAlias_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_OpenAlias_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_OpenAlias_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_OpenAlias_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.OpenAlias",
	.tp_getset = py_samr_OpenAlias_getsetters,
	.tp_methods = py_samr_OpenAlias_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_OpenAlias_new,
};

static bool pack_py_samr_OpenAlias_args_in(PyObject *args, PyObject *kwargs, struct samr_OpenAlias *r)
{
	PyObject *py_domain_handle;
	PyObject *py_access_mask;
	PyObject *py_rid;
	const char *kwnames[] = {
		"domain_handle", "access_mask", "rid", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OOO:samr_OpenAlias", discard_const_p(char *, kwnames), &py_domain_handle, &py_access_mask, &py_rid)) {
		return false;
	}

	if (py_domain_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.domain_handle");
		return false;
	}
	r->in.domain_handle = talloc_ptrtype(r, r->in.domain_handle);
	if (r->in.domain_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_domain_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_domain_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.domain_handle = (struct policy_handle *)pytalloc_get_ptr(py_domain_handle);
	if (py_access_mask == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.access_mask");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.access_mask));
		if (PyLong_Check(py_access_mask)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_access_mask);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.access_mask = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_rid == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.rid");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.rid));
		if (PyLong_Check(py_rid)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_rid);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.rid = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_samr_OpenAlias_args_out(struct samr_OpenAlias *r, bool raise_result_exception)
{
	PyObject *py_alias_handle = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_alias_handle = pytalloc_reference_ex(policy_handle_Type, r->out.alias_handle, r->out.alias_handle);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_alias_handle);
	}
	if (result_size == 1) {
		result = py_alias_handle;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_samr_QueryAliasInfo_in_get_alias_handle(PyObject *obj, void *closure)
{
	struct samr_QueryAliasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_alias_handle;
	if (object->in.alias_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_alias_handle = pytalloc_reference_ex(policy_handle_Type, object->in.alias_handle, object->in.alias_handle);
	return py_alias_handle;
}

static int py_samr_QueryAliasInfo_in_set_alias_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_QueryAliasInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.alias_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.alias_handle");
		return -1;
	}
	object->in.alias_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.alias_handle);
	if (object->in.alias_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.alias_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_QueryAliasInfo_in_get_level(PyObject *obj, void *closure)
{
	struct samr_QueryAliasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromLong((uint16_t)(object->in.level));
	return py_level;
}

static int py_samr_QueryAliasInfo_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_QueryAliasInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_QueryAliasInfo_out_get_info(PyObject *obj, void *closure)
{
	struct samr_QueryAliasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->out.info == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pyrpc_import_union(&samr_AliasInfo_Type, *object->out.info, object->in.level, *object->out.info, "union samr_AliasInfo");
		if (py_info == NULL) {
			return NULL;
		}
	}
	return py_info;
}

static int py_samr_QueryAliasInfo_out_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_QueryAliasInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.info");
		return -1;
	}
	object->out.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.info);
	if (object->out.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.info = NULL;
	} else {
		*object->out.info = NULL;
		{
			union samr_AliasInfo *info_switch_2;
			info_switch_2 = (union samr_AliasInfo *)pyrpc_export_union(&samr_AliasInfo_Type, pytalloc_get_mem_ctx(py_obj), object->in.level, value, "union samr_AliasInfo");
			if (info_switch_2 == NULL) {
				return -1;
			}
			*object->out.info = info_switch_2;
		}
	}
	return 0;
}

static PyObject *py_samr_QueryAliasInfo_get_result(PyObject *obj, void *closure)
{
	struct samr_QueryAliasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_QueryAliasInfo_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_QueryAliasInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_QueryAliasInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "in_alias_handle"),
		.get = py_samr_QueryAliasInfo_in_get_alias_handle,
		.set = py_samr_QueryAliasInfo_in_set_alias_handle,
		.doc = discard_const_p(char, "PIDL-generated element of base type policy_handle")
	},
	{
		.name = discard_const_p(char, "in_level"),
		.get = py_samr_QueryAliasInfo_in_get_level,
		.set = py_samr_QueryAliasInfo_in_set_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_AliasInfoEnum")
	},
	{
		.name = discard_const_p(char, "out_info"),
		.get = py_samr_QueryAliasInfo_out_get_info,
		.set = py_samr_QueryAliasInfo_out_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type samr_AliasInfo")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_samr_QueryAliasInfo_get_result,
		.set = py_samr_QueryAliasInfo_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type NTSTATUS")
	},
	{ .name = NULL }
};

static PyObject *py_samr_QueryAliasInfo_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct samr_QueryAliasInfo, type);
	struct samr_QueryAliasInfo *_self = (struct samr_QueryAliasInfo *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->in.alias_handle = talloc_zero(mem_ctx, struct policy_handle);
	/* a pointer to a NULL pointer */
	_self->out.info = talloc_zero(mem_ctx, union samr_AliasInfo *);
	return self;
}

static PyObject *py_samr_QueryAliasInfo_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(28);
}

static PyObject *py_samr_QueryAliasInfo_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_QueryAliasInfo *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 29) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_QueryAliasInfo_ndr_pack");
		return NULL;
	}
	call = &ndr_table_samr.calls[28];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_samr_QueryAliasInfo_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_QueryAliasInfo_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_samr_QueryAliasInfo_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_samr_QueryAliasInfo_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_samr_QueryAliasInfo_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_QueryAliasInfo *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_samr.num_calls < 29) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_QueryAliasInfo_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_samr.calls[28];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_samr_QueryAliasInfo_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_QueryAliasInfo_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_QueryAliasInfo_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_samr_QueryAliasInfo_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_samr_QueryAliasInfo_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct samr_QueryAliasInfo *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_samr.num_calls < 29) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_samr_QueryAliasInfo_ndr_print");
		return NULL;
	}
	call = &ndr_table_samr.calls[28];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_samr_QueryAliasInfo_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_QueryAliasInfo_ndr_print(py_obj, args, kwargs, "samr_QueryAliasInfo_in", NDR_IN);
}

static PyObject *py_samr_QueryAliasInfo_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_samr_QueryAliasInfo_ndr_print(py_obj, args, kwargs, "samr_QueryAliasInfo_out", NDR_OUT);
}

static PyMethodDef py_samr_QueryAliasInfo_methods[] = {
	{ "opnum", (PyCFunction)py_samr_QueryAliasInfo_ndr_opnum, METH_NOARGS|METH_CLASS,
		"samr.QueryAliasInfo.opnum() -> 28 (0x1c) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryAliasInfo_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryAliasInfo_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryAliasInfo_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryAliasInfo_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryAliasInfo_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_samr_QueryAliasInfo_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject samr_QueryAliasInfo_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "samr.QueryAliasInfo",
	.tp_getset = py_samr_QueryAliasInfo_getsetters,
	.tp_methods = py_samr_QueryAliasInfo_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_samr_QueryAliasInfo_new,
};

static bool pack_py_samr_QueryAliasInfo_args_in(PyObject *args, PyObject *kwargs, struct samr_QueryAliasInfo *r)
{
	PyObject *py_alias_handle;
	PyObject *py_level;
	const char *kwnames[] = {
		"alias_handle", "level", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:samr_QueryAliasInfo", discard_const_p(char *, kwnames), &py_alias_handle, &py_level)) {
		return false;
	}

	if (py_alias_handle == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.alias_handle");
		return false;
	}
	r->in.alias_handle = talloc_ptrtype(r, r->in.alias_handle);
	if (r->in.alias_handle == NULL) {
		PyErr_NoMemory();
		return false;
	}
	PY_CHECK_TYPE(policy_handle_Type, py_alias_handle, return false;);
	if (talloc_reference(r, pytalloc_get_mem_ctx(py_alias_handle)) == NULL) {
		PyErr_NoMemory();
		return false;
	}
	r->in.alias_handle = (struct policy_handle *)pytalloc_get_ptr(py_alias_handle);
	if (py_level == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.level");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.level));
		if (PyLong_Check(py_level)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_level);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_samr_QueryAliasInfo_args_out(struct samr_QueryAliasInfo *r, bool raise_result_exception)
{
	PyObject *py_info = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (NT_STATUS_IS_ERR(r->out.result)) {
			PyErr_SetNTSTATUS(r->out.result);
			return NULL;
		}

	} else {
		/* NTSTATUS will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (*r->out.info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pyrpc_import_union(&samr_AliasInfo_Type, *r->out.info, r->in.level, *r->out.info, "union samr_AliasInfo");
		if (py_info == NULL) {
			return NULL;
		}
	}
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_info);
	}
	if (result_size == 1) {
		result = py_info;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromNTSTATUS(r->out.result));
	}

	return result;
}


static PyObject *py_samr_SetAliasInfo_in_get_alias_handle(PyObject *obj, void *closure)
{
	struct samr_SetAliasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_alias_handle;
	if (object->in.alias_handle == NULL) {
		Py_RETURN_NONE;
	}
	py_alias_handle = pytalloc_reference_ex(policy_handle_Type, object->in.alias_handle, object->in.alias_handle);
	return py_alias_handle;
}

static int py_samr_SetAliasInfo_in_set_alias_handle(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SetAliasInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.alias_handle));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.alias_handle");
		return -1;
	}
	object->in.alias_handle = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.alias_handle);
	if (object->in.alias_handle == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(policy_handle_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->in.alias_handle = (struct policy_handle *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_samr_SetAliasInfo_in_get_level(PyObject *obj, void *closure)
{
	struct samr_SetAliasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_level;
	py_level = PyLong_FromLong((uint16_t)(object->in.level));
	return py_level;
}

static int py_samr_SetAliasInfo_in_set_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SetAliasInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_samr_SetAliasInfo_in_get_info(PyObject *obj, void *closure)
{
	struct samr_SetAliasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->in.info == NULL) {
		Py_RETURN_NONE;
	}
	py_info = pyrpc_import_union(&samr_AliasInfo_Type, object->in.info, object->in.level, object->in.info, "union samr_AliasInfo");
	if (py_info == NULL) {
		return NULL;
	}
	return py_info;
}

static int py_samr_SetAliasInfo_in_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SetAliasInfo *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->in.info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.info");
		return -1;
	}
	object->in.info = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->in.info);
	if (object->in.info == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		union samr_AliasInfo *info_switch_1;
		info_switch_1 = (union samr_AliasInfo *)pyrpc_export_union(&samr_AliasInfo_Type, pytalloc_get_mem_ctx(py_obj), object->in.level, value, "union samr_AliasInfo");
		if (info_switch_1 == NULL) {
			return -1;
		}
		object->in.info = info_switch_1;
	}
	return 0;
}

static PyObject *py_samr_SetAliasInfo_get_result(PyObject *obj, void *closure)
{
	struct samr_SetAliasInfo *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromNTSTATUS(object->out.result);
	return py_result;
}

static int py_samr_SetAliasInfo_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct samr_SetAliasInfo *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = NT_STATUS(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_samr_SetAliasInfo_getsetters[] = {
	{
		.name = discard_const_p(char, "in_