/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Assembly Matcher Source Fragment                                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: X86.td                                                               *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_ASSEMBLER_HEADER
#undef GET_ASSEMBLER_HEADER
  // This should be included into the middle of the declaration of
  // your subclasses implementation of MCTargetAsmParser.
  FeatureBitset ComputeAvailableFeatures(const FeatureBitset &FB) const;
  void convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                       const OperandVector &Operands);
  void convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) override;
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                uint64_t &ErrorInfo,
                                FeatureBitset &MissingFeatures,
                                bool matchingInlineAsm,
                                unsigned VariantID = 0);
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                uint64_t &ErrorInfo,
                                bool matchingInlineAsm,
                                unsigned VariantID = 0) {
    FeatureBitset MissingFeatures;
    return MatchInstructionImpl(Operands, Inst, ErrorInfo, MissingFeatures,
                                matchingInlineAsm, VariantID);
  }

#endif // GET_ASSEMBLER_HEADER


#ifdef GET_OPERAND_DIAGNOSTIC_TYPES
#undef GET_OPERAND_DIAGNOSTIC_TYPES

  Match_InvalidImmUnsignedi4,
  END_OPERAND_DIAGNOSTIC_TYPES
#endif // GET_OPERAND_DIAGNOSTIC_TYPES


#ifdef GET_REGISTER_MATCHER
#undef GET_REGISTER_MATCHER

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_Not64BitModeBit = 4,
  Feature_In64BitModeBit = 2,
  Feature_In16BitModeBit = 0,
  Feature_Not16BitModeBit = 3,
  Feature_In32BitModeBit = 1,
};

static MCRegister MatchRegisterName(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 2:	 // 34 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'h':	 // 1 string to match.
        return X86::AH;	 // "ah"
      case 'l':	 // 1 string to match.
        return X86::AL;	 // "al"
      case 'x':	 // 1 string to match.
        return X86::AX;	 // "ax"
      }
      break;
    case 'b':	 // 4 strings to match.
      switch (Name[1]) {
      default: break;
      case 'h':	 // 1 string to match.
        return X86::BH;	 // "bh"
      case 'l':	 // 1 string to match.
        return X86::BL;	 // "bl"
      case 'p':	 // 1 string to match.
        return X86::BP;	 // "bp"
      case 'x':	 // 1 string to match.
        return X86::BX;	 // "bx"
      }
      break;
    case 'c':	 // 4 strings to match.
      switch (Name[1]) {
      default: break;
      case 'h':	 // 1 string to match.
        return X86::CH;	 // "ch"
      case 'l':	 // 1 string to match.
        return X86::CL;	 // "cl"
      case 's':	 // 1 string to match.
        return X86::CS;	 // "cs"
      case 'x':	 // 1 string to match.
        return X86::CX;	 // "cx"
      }
      break;
    case 'd':	 // 5 strings to match.
      switch (Name[1]) {
      default: break;
      case 'h':	 // 1 string to match.
        return X86::DH;	 // "dh"
      case 'i':	 // 1 string to match.
        return X86::DI;	 // "di"
      case 'l':	 // 1 string to match.
        return X86::DL;	 // "dl"
      case 's':	 // 1 string to match.
        return X86::DS;	 // "ds"
      case 'x':	 // 1 string to match.
        return X86::DX;	 // "dx"
      }
      break;
    case 'e':	 // 1 string to match.
      if (Name[1] != 's')
        break;
      return X86::ES;	 // "es"
    case 'f':	 // 1 string to match.
      if (Name[1] != 's')
        break;
      return X86::FS;	 // "fs"
    case 'g':	 // 1 string to match.
      if (Name[1] != 's')
        break;
      return X86::GS;	 // "gs"
    case 'i':	 // 1 string to match.
      if (Name[1] != 'p')
        break;
      return X86::IP;	 // "ip"
    case 'k':	 // 8 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 1 string to match.
        return X86::K0;	 // "k0"
      case '1':	 // 1 string to match.
        return X86::K1;	 // "k1"
      case '2':	 // 1 string to match.
        return X86::K2;	 // "k2"
      case '3':	 // 1 string to match.
        return X86::K3;	 // "k3"
      case '4':	 // 1 string to match.
        return X86::K4;	 // "k4"
      case '5':	 // 1 string to match.
        return X86::K5;	 // "k5"
      case '6':	 // 1 string to match.
        return X86::K6;	 // "k6"
      case '7':	 // 1 string to match.
        return X86::K7;	 // "k7"
      }
      break;
    case 'r':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case '8':	 // 1 string to match.
        return X86::R8;	 // "r8"
      case '9':	 // 1 string to match.
        return X86::R9;	 // "r9"
      }
      break;
    case 's':	 // 4 strings to match.
      switch (Name[1]) {
      default: break;
      case 'i':	 // 1 string to match.
        return X86::SI;	 // "si"
      case 'p':	 // 1 string to match.
        return X86::SP;	 // "sp"
      case 's':	 // 1 string to match.
        return X86::SS;	 // "ss"
      case 't':	 // 1 string to match.
        return X86::ST0;	 // "st"
      }
      break;
    }
    break;
  case 3:	 // 89 strings to match.
    switch (Name[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(Name.data()+1, "pl", 2) != 0)
        break;
      return X86::BPL;	 // "bpl"
    case 'c':	 // 10 strings to match.
      if (Name[1] != 'r')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 1 string to match.
        return X86::CR0;	 // "cr0"
      case '1':	 // 1 string to match.
        return X86::CR1;	 // "cr1"
      case '2':	 // 1 string to match.
        return X86::CR2;	 // "cr2"
      case '3':	 // 1 string to match.
        return X86::CR3;	 // "cr3"
      case '4':	 // 1 string to match.
        return X86::CR4;	 // "cr4"
      case '5':	 // 1 string to match.
        return X86::CR5;	 // "cr5"
      case '6':	 // 1 string to match.
        return X86::CR6;	 // "cr6"
      case '7':	 // 1 string to match.
        return X86::CR7;	 // "cr7"
      case '8':	 // 1 string to match.
        return X86::CR8;	 // "cr8"
      case '9':	 // 1 string to match.
        return X86::CR9;	 // "cr9"
      }
      break;
    case 'd':	 // 11 strings to match.
      switch (Name[1]) {
      default: break;
      case 'i':	 // 1 string to match.
        if (Name[2] != 'l')
          break;
        return X86::DIL;	 // "dil"
      case 'r':	 // 10 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return X86::DR0;	 // "dr0"
        case '1':	 // 1 string to match.
          return X86::DR1;	 // "dr1"
        case '2':	 // 1 string to match.
          return X86::DR2;	 // "dr2"
        case '3':	 // 1 string to match.
          return X86::DR3;	 // "dr3"
        case '4':	 // 1 string to match.
          return X86::DR4;	 // "dr4"
        case '5':	 // 1 string to match.
          return X86::DR5;	 // "dr5"
        case '6':	 // 1 string to match.
          return X86::DR6;	 // "dr6"
        case '7':	 // 1 string to match.
          return X86::DR7;	 // "dr7"
        case '8':	 // 1 string to match.
          return X86::DR8;	 // "dr8"
        case '9':	 // 1 string to match.
          return X86::DR9;	 // "dr9"
        }
        break;
      }
      break;
    case 'e':	 // 10 strings to match.
      switch (Name[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (Name[2] != 'x')
          break;
        return X86::EAX;	 // "eax"
      case 'b':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'p':	 // 1 string to match.
          return X86::EBP;	 // "ebp"
        case 'x':	 // 1 string to match.
          return X86::EBX;	 // "ebx"
        }
        break;
      case 'c':	 // 1 string to match.
        if (Name[2] != 'x')
          break;
        return X86::ECX;	 // "ecx"
      case 'd':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'i':	 // 1 string to match.
          return X86::EDI;	 // "edi"
        case 'x':	 // 1 string to match.
          return X86::EDX;	 // "edx"
        }
        break;
      case 'i':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'p':	 // 1 string to match.
          return X86::EIP;	 // "eip"
        case 'z':	 // 1 string to match.
          return X86::EIZ;	 // "eiz"
        }
        break;
      case 's':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'i':	 // 1 string to match.
          return X86::ESI;	 // "esi"
        case 'p':	 // 1 string to match.
          return X86::ESP;	 // "esp"
        }
        break;
      }
      break;
    case 'f':	 // 8 strings to match.
      if (Name[1] != 'p')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 1 string to match.
        return X86::FP0;	 // "fp0"
      case '1':	 // 1 string to match.
        return X86::FP1;	 // "fp1"
      case '2':	 // 1 string to match.
        return X86::FP2;	 // "fp2"
      case '3':	 // 1 string to match.
        return X86::FP3;	 // "fp3"
      case '4':	 // 1 string to match.
        return X86::FP4;	 // "fp4"
      case '5':	 // 1 string to match.
        return X86::FP5;	 // "fp5"
      case '6':	 // 1 string to match.
        return X86::FP6;	 // "fp6"
      case '7':	 // 1 string to match.
        return X86::FP7;	 // "fp7"
      }
      break;
    case 'm':	 // 8 strings to match.
      if (Name[1] != 'm')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 1 string to match.
        return X86::MM0;	 // "mm0"
      case '1':	 // 1 string to match.
        return X86::MM1;	 // "mm1"
      case '2':	 // 1 string to match.
        return X86::MM2;	 // "mm2"
      case '3':	 // 1 string to match.
        return X86::MM3;	 // "mm3"
      case '4':	 // 1 string to match.
        return X86::MM4;	 // "mm4"
      case '5':	 // 1 string to match.
        return X86::MM5;	 // "mm5"
      case '6':	 // 1 string to match.
        return X86::MM6;	 // "mm6"
      case '7':	 // 1 string to match.
        return X86::MM7;	 // "mm7"
      }
      break;
    case 'r':	 // 38 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 10 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return X86::R10;	 // "r10"
        case '1':	 // 1 string to match.
          return X86::R11;	 // "r11"
        case '2':	 // 1 string to match.
          return X86::R12;	 // "r12"
        case '3':	 // 1 string to match.
          return X86::R13;	 // "r13"
        case '4':	 // 1 string to match.
          return X86::R14;	 // "r14"
        case '5':	 // 1 string to match.
          return X86::R15;	 // "r15"
        case '6':	 // 1 string to match.
          return X86::R16;	 // "r16"
        case '7':	 // 1 string to match.
          return X86::R17;	 // "r17"
        case '8':	 // 1 string to match.
          return X86::R18;	 // "r18"
        case '9':	 // 1 string to match.
          return X86::R19;	 // "r19"
        }
        break;
      case '2':	 // 10 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return X86::R20;	 // "r20"
        case '1':	 // 1 string to match.
          return X86::R21;	 // "r21"
        case '2':	 // 1 string to match.
          return X86::R22;	 // "r22"
        case '3':	 // 1 string to match.
          return X86::R23;	 // "r23"
        case '4':	 // 1 string to match.
          return X86::R24;	 // "r24"
        case '5':	 // 1 string to match.
          return X86::R25;	 // "r25"
        case '6':	 // 1 string to match.
          return X86::R26;	 // "r26"
        case '7':	 // 1 string to match.
          return X86::R27;	 // "r27"
        case '8':	 // 1 string to match.
          return X86::R28;	 // "r28"
        case '9':	 // 1 string to match.
          return X86::R29;	 // "r29"
        }
        break;
      case '3':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return X86::R30;	 // "r30"
        case '1':	 // 1 string to match.
          return X86::R31;	 // "r31"
        }
        break;
      case '8':	 // 3 strings to match.
        switch (Name[2]) {
        default: break;
        case 'b':	 // 1 string to match.
          return X86::R8B;	 // "r8b"
        case 'd':	 // 1 string to match.
          return X86::R8D;	 // "r8d"
        case 'w':	 // 1 string to match.
          return X86::R8W;	 // "r8w"
        }
        break;
      case '9':	 // 3 strings to match.
        switch (Name[2]) {
        default: break;
        case 'b':	 // 1 string to match.
          return X86::R9B;	 // "r9b"
        case 'd':	 // 1 string to match.
          return X86::R9D;	 // "r9d"
        case 'w':	 // 1 string to match.
          return X86::R9W;	 // "r9w"
        }
        break;
      case 'a':	 // 1 string to match.
        if (Name[2] != 'x')
          break;
        return X86::RAX;	 // "rax"
      case 'b':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'p':	 // 1 string to match.
          return X86::RBP;	 // "rbp"
        case 'x':	 // 1 string to match.
          return X86::RBX;	 // "rbx"
        }
        break;
      case 'c':	 // 1 string to match.
        if (Name[2] != 'x')
          break;
        return X86::RCX;	 // "rcx"
      case 'd':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'i':	 // 1 string to match.
          return X86::RDI;	 // "rdi"
        case 'x':	 // 1 string to match.
          return X86::RDX;	 // "rdx"
        }
        break;
      case 'i':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'p':	 // 1 string to match.
          return X86::RIP;	 // "rip"
        case 'z':	 // 1 string to match.
          return X86::RIZ;	 // "riz"
        }
        break;
      case 's':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'i':	 // 1 string to match.
          return X86::RSI;	 // "rsi"
        case 'p':	 // 1 string to match.
          return X86::RSP;	 // "rsp"
        }
        break;
      }
      break;
    case 's':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'i':	 // 1 string to match.
        if (Name[2] != 'l')
          break;
        return X86::SIL;	 // "sil"
      case 'p':	 // 1 string to match.
        if (Name[2] != 'l')
          break;
        return X86::SPL;	 // "spl"
      case 's':	 // 1 string to match.
        if (Name[2] != 'p')
          break;
        return X86::SSP;	 // "ssp"
      }
      break;
    }
    break;
  case 4:	 // 118 strings to match.
    switch (Name[0]) {
    default: break;
    case 'c':	 // 6 strings to match.
      if (memcmp(Name.data()+1, "r1", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return X86::CR10;	 // "cr10"
      case '1':	 // 1 string to match.
        return X86::CR11;	 // "cr11"
      case '2':	 // 1 string to match.
        return X86::CR12;	 // "cr12"
      case '3':	 // 1 string to match.
        return X86::CR13;	 // "cr13"
      case '4':	 // 1 string to match.
        return X86::CR14;	 // "cr14"
      case '5':	 // 1 string to match.
        return X86::CR15;	 // "cr15"
      }
      break;
    case 'd':	 // 6 strings to match.
      if (memcmp(Name.data()+1, "r1", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return X86::DR10;	 // "dr10"
      case '1':	 // 1 string to match.
        return X86::DR11;	 // "dr11"
      case '2':	 // 1 string to match.
        return X86::DR12;	 // "dr12"
      case '3':	 // 1 string to match.
        return X86::DR13;	 // "dr13"
      case '4':	 // 1 string to match.
        return X86::DR14;	 // "dr14"
      case '5':	 // 1 string to match.
        return X86::DR15;	 // "dr15"
      }
      break;
    case 'f':	 // 2 strings to match.
      if (Name[1] != 'p')
        break;
      switch (Name[2]) {
      default: break;
      case 'c':	 // 1 string to match.
        if (Name[3] != 'r')
          break;
        return X86::FPCW;	 // "fpcr"
      case 's':	 // 1 string to match.
        if (Name[3] != 'r')
          break;
        return X86::FPSW;	 // "fpsr"
      }
      break;
    case 'r':	 // 66 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 30 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          switch (Name[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            return X86::R10B;	 // "r10b"
          case 'd':	 // 1 string to match.
            return X86::R10D;	 // "r10d"
          case 'w':	 // 1 string to match.
            return X86::R10W;	 // "r10w"
          }
          break;
        case '1':	 // 3 strings to match.
          switch (Name[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            return X86::R11B;	 // "r11b"
          case 'd':	 // 1 string to match.
            return X86::R11D;	 // "r11d"
          case 'w':	 // 1 string to match.
            return X86::R11W;	 // "r11w"
          }
          break;
        case '2':	 // 3 strings to match.
          switch (Name[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            return X86::R12B;	 // "r12b"
          case 'd':	 // 1 string to match.
            return X86::R12D;	 // "r12d"
          case 'w':	 // 1 string to match.
            return X86::R12W;	 // "r12w"
          }
          break;
        case '3':	 // 3 strings to match.
          switch (Name[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            return X86::R13B;	 // "r13b"
          case 'd':	 // 1 string to match.
            return X86::R13D;	 // "r13d"
          case 'w':	 // 1 string to match.
            return X86::R13W;	 // "r13w"
          }
          break;
        case '4':	 // 3 strings to match.
          switch (Name[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            return X86::R14B;	 // "r14b"
          case 'd':	 // 1 string to match.
            return X86::R14D;	 // "r14d"
          case 'w':	 // 1 string to match.
            return X86::R14W;	 // "r14w"
          }
          break;
        case '5':	 // 3 strings to match.
          switch (Name[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            return X86::R15B;	 // "r15b"
          case 'd':	 // 1 string to match.
            return X86::R15D;	 // "r15d"
          case 'w':	 // 1 string to match.
            return X86::R15W;	 // "r15w"
          }
          break;
        case '6':	 // 3 strings to match.
          switch (Name[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            return X86::R16B;	 // "r16b"
          case 'd':	 // 1 string to match.
            return X86::R16D;	 // "r16d"
          case 'w':	 // 1 string to match.
            return X86::R16W;	 // "r16w"
          }
          break;
        case '7':	 // 3 strings to match.
          switch (Name[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            return X86::R17B;	 // "r17b"
          case 'd':	 // 1 string to match.
            return X86::R17D;	 // "r17d"
          case 'w':	 // 1 string to match.
            return X86::R17W;	 // "r17w"
          }
          break;
        case '8':	 // 3 strings to match.
          switch (Name[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            return X86::R18B;	 // "r18b"
          case 'd':	 // 1 string to match.
            return X86::R18D;	 // "r18d"
          case 'w':	 // 1 string to match.
            return X86::R18W;	 // "r18w"
          }
          break;
        case '9':	 // 3 strings to match.
          switch (Name[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            return X86::R19B;	 // "r19b"
          case 'd':	 // 1 string to match.
            return X86::R19D;	 // "r19d"
          case 'w':	 // 1 string to match.
            return X86::R19W;	 // "r19w"
          }
          break;
        }
        break;
      case '2':	 // 30 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          switch (Name[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            return X86::R20B;	 // "r20b"
          case 'd':	 // 1 string to match.
            return X86::R20D;	 // "r20d"
          case 'w':	 // 1 string to match.
            return X86::R20W;	 // "r20w"
          }
          break;
        case '1':	 // 3 strings to match.
          switch (Name[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            return X86::R21B;	 // "r21b"
          case 'd':	 // 1 string to match.
            return X86::R21D;	 // "r21d"
          case 'w':	 // 1 string to match.
            return X86::R21W;	 // "r21w"
          }
          break;
        case '2':	 // 3 strings to match.
          switch (Name[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            return X86::R22B;	 // "r22b"
          case 'd':	 // 1 string to match.
            return X86::R22D;	 // "r22d"
          case 'w':	 // 1 string to match.
            return X86::R22W;	 // "r22w"
          }
          break;
        case '3':	 // 3 strings to match.
          switch (Name[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            return X86::R23B;	 // "r23b"
          case 'd':	 // 1 string to match.
            return X86::R23D;	 // "r23d"
          case 'w':	 // 1 string to match.
            return X86::R23W;	 // "r23w"
          }
          break;
        case '4':	 // 3 strings to match.
          switch (Name[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            return X86::R24B;	 // "r24b"
          case 'd':	 // 1 string to match.
            return X86::R24D;	 // "r24d"
          case 'w':	 // 1 string to match.
            return X86::R24W;	 // "r24w"
          }
          break;
        case '5':	 // 3 strings to match.
          switch (Name[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            return X86::R25B;	 // "r25b"
          case 'd':	 // 1 string to match.
            return X86::R25D;	 // "r25d"
          case 'w':	 // 1 string to match.
            return X86::R25W;	 // "r25w"
          }
          break;
        case '6':	 // 3 strings to match.
          switch (Name[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            return X86::R26B;	 // "r26b"
          case 'd':	 // 1 string to match.
            return X86::R26D;	 // "r26d"
          case 'w':	 // 1 string to match.
            return X86::R26W;	 // "r26w"
          }
          break;
        case '7':	 // 3 strings to match.
          switch (Name[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            return X86::R27B;	 // "r27b"
          case 'd':	 // 1 string to match.
            return X86::R27D;	 // "r27d"
          case 'w':	 // 1 string to match.
            return X86::R27W;	 // "r27w"
          }
          break;
        case '8':	 // 3 strings to match.
          switch (Name[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            return X86::R28B;	 // "r28b"
          case 'd':	 // 1 string to match.
            return X86::R28D;	 // "r28d"
          case 'w':	 // 1 string to match.
            return X86::R28W;	 // "r28w"
          }
          break;
        case '9':	 // 3 strings to match.
          switch (Name[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            return X86::R29B;	 // "r29b"
          case 'd':	 // 1 string to match.
            return X86::R29D;	 // "r29d"
          case 'w':	 // 1 string to match.
            return X86::R29W;	 // "r29w"
          }
          break;
        }
        break;
      case '3':	 // 6 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          switch (Name[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            return X86::R30B;	 // "r30b"
          case 'd':	 // 1 string to match.
            return X86::R30D;	 // "r30d"
          case 'w':	 // 1 string to match.
            return X86::R30W;	 // "r30w"
          }
          break;
        case '1':	 // 3 strings to match.
          switch (Name[3]) {
          default: break;
          case 'b':	 // 1 string to match.
            return X86::R31B;	 // "r31b"
          case 'd':	 // 1 string to match.
            return X86::R31D;	 // "r31d"
          case 'w':	 // 1 string to match.
            return X86::R31W;	 // "r31w"
          }
          break;
        }
        break;
      }
      break;
    case 't':	 // 8 strings to match.
      if (memcmp(Name.data()+1, "mm", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return X86::TMM0;	 // "tmm0"
      case '1':	 // 1 string to match.
        return X86::TMM1;	 // "tmm1"
      case '2':	 // 1 string to match.
        return X86::TMM2;	 // "tmm2"
      case '3':	 // 1 string to match.
        return X86::TMM3;	 // "tmm3"
      case '4':	 // 1 string to match.
        return X86::TMM4;	 // "tmm4"
      case '5':	 // 1 string to match.
        return X86::TMM5;	 // "tmm5"
      case '6':	 // 1 string to match.
        return X86::TMM6;	 // "tmm6"
      case '7':	 // 1 string to match.
        return X86::TMM7;	 // "tmm7"
      }
      break;
    case 'x':	 // 10 strings to match.
      if (memcmp(Name.data()+1, "mm", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return X86::XMM0;	 // "xmm0"
      case '1':	 // 1 string to match.
        return X86::XMM1;	 // "xmm1"
      case '2':	 // 1 string to match.
        return X86::XMM2;	 // "xmm2"
      case '3':	 // 1 string to match.
        return X86::XMM3;	 // "xmm3"
      case '4':	 // 1 string to match.
        return X86::XMM4;	 // "xmm4"
      case '5':	 // 1 string to match.
        return X86::XMM5;	 // "xmm5"
      case '6':	 // 1 string to match.
        return X86::XMM6;	 // "xmm6"
      case '7':	 // 1 string to match.
        return X86::XMM7;	 // "xmm7"
      case '8':	 // 1 string to match.
        return X86::XMM8;	 // "xmm8"
      case '9':	 // 1 string to match.
        return X86::XMM9;	 // "xmm9"
      }
      break;
    case 'y':	 // 10 strings to match.
      if (memcmp(Name.data()+1, "mm", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return X86::YMM0;	 // "ymm0"
      case '1':	 // 1 string to match.
        return X86::YMM1;	 // "ymm1"
      case '2':	 // 1 string to match.
        return X86::YMM2;	 // "ymm2"
      case '3':	 // 1 string to match.
        return X86::YMM3;	 // "ymm3"
      case '4':	 // 1 string to match.
        return X86::YMM4;	 // "ymm4"
      case '5':	 // 1 string to match.
        return X86::YMM5;	 // "ymm5"
      case '6':	 // 1 string to match.
        return X86::YMM6;	 // "ymm6"
      case '7':	 // 1 string to match.
        return X86::YMM7;	 // "ymm7"
      case '8':	 // 1 string to match.
        return X86::YMM8;	 // "ymm8"
      case '9':	 // 1 string to match.
        return X86::YMM9;	 // "ymm9"
      }
      break;
    case 'z':	 // 10 strings to match.
      if (memcmp(Name.data()+1, "mm", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return X86::ZMM0;	 // "zmm0"
      case '1':	 // 1 string to match.
        return X86::ZMM1;	 // "zmm1"
      case '2':	 // 1 string to match.
        return X86::ZMM2;	 // "zmm2"
      case '3':	 // 1 string to match.
        return X86::ZMM3;	 // "zmm3"
      case '4':	 // 1 string to match.
        return X86::ZMM4;	 // "zmm4"
      case '5':	 // 1 string to match.
        return X86::ZMM5;	 // "zmm5"
      case '6':	 // 1 string to match.
        return X86::ZMM6;	 // "zmm6"
      case '7':	 // 1 string to match.
        return X86::ZMM7;	 // "zmm7"
      case '8':	 // 1 string to match.
        return X86::ZMM8;	 // "zmm8"
      case '9':	 // 1 string to match.
        return X86::ZMM9;	 // "zmm9"
      }
      break;
    }
    break;
  case 5:	 // 75 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(Name.data()+1, "lags", 4) != 0)
        break;
      return X86::EFLAGS;	 // "flags"
    case 'm':	 // 1 string to match.
      if (memcmp(Name.data()+1, "xcsr", 4) != 0)
        break;
      return X86::MXCSR;	 // "mxcsr"
    case 's':	 // 7 strings to match.
      if (memcmp(Name.data()+1, "t(", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '1':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return X86::ST1;	 // "st(1)"
      case '2':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return X86::ST2;	 // "st(2)"
      case '3':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return X86::ST3;	 // "st(3)"
      case '4':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return X86::ST4;	 // "st(4)"
      case '5':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return X86::ST5;	 // "st(5)"
      case '6':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return X86::ST6;	 // "st(6)"
      case '7':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return X86::ST7;	 // "st(7)"
      }
      break;
    case 'x':	 // 22 strings to match.
      if (memcmp(Name.data()+1, "mm", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '1':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return X86::XMM10;	 // "xmm10"
        case '1':	 // 1 string to match.
          return X86::XMM11;	 // "xmm11"
        case '2':	 // 1 string to match.
          return X86::XMM12;	 // "xmm12"
        case '3':	 // 1 string to match.
          return X86::XMM13;	 // "xmm13"
        case '4':	 // 1 string to match.
          return X86::XMM14;	 // "xmm14"
        case '5':	 // 1 string to match.
          return X86::XMM15;	 // "xmm15"
        case '6':	 // 1 string to match.
          return X86::XMM16;	 // "xmm16"
        case '7':	 // 1 string to match.
          return X86::XMM17;	 // "xmm17"
        case '8':	 // 1 string to match.
          return X86::XMM18;	 // "xmm18"
        case '9':	 // 1 string to match.
          return X86::XMM19;	 // "xmm19"
        }
        break;
      case '2':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return X86::XMM20;	 // "xmm20"
        case '1':	 // 1 string to match.
          return X86::XMM21;	 // "xmm21"
        case '2':	 // 1 string to match.
          return X86::XMM22;	 // "xmm22"
        case '3':	 // 1 string to match.
          return X86::XMM23;	 // "xmm23"
        case '4':	 // 1 string to match.
          return X86::XMM24;	 // "xmm24"
        case '5':	 // 1 string to match.
          return X86::XMM25;	 // "xmm25"
        case '6':	 // 1 string to match.
          return X86::XMM26;	 // "xmm26"
        case '7':	 // 1 string to match.
          return X86::XMM27;	 // "xmm27"
        case '8':	 // 1 string to match.
          return X86::XMM28;	 // "xmm28"
        case '9':	 // 1 string to match.
          return X86::XMM29;	 // "xmm29"
        }
        break;
      case '3':	 // 2 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return X86::XMM30;	 // "xmm30"
        case '1':	 // 1 string to match.
          return X86::XMM31;	 // "xmm31"
        }
        break;
      }
      break;
    case 'y':	 // 22 strings to match.
      if (memcmp(Name.data()+1, "mm", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '1':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return X86::YMM10;	 // "ymm10"
        case '1':	 // 1 string to match.
          return X86::YMM11;	 // "ymm11"
        case '2':	 // 1 string to match.
          return X86::YMM12;	 // "ymm12"
        case '3':	 // 1 string to match.
          return X86::YMM13;	 // "ymm13"
        case '4':	 // 1 string to match.
          return X86::YMM14;	 // "ymm14"
        case '5':	 // 1 string to match.
          return X86::YMM15;	 // "ymm15"
        case '6':	 // 1 string to match.
          return X86::YMM16;	 // "ymm16"
        case '7':	 // 1 string to match.
          return X86::YMM17;	 // "ymm17"
        case '8':	 // 1 string to match.
          return X86::YMM18;	 // "ymm18"
        case '9':	 // 1 string to match.
          return X86::YMM19;	 // "ymm19"
        }
        break;
      case '2':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return X86::YMM20;	 // "ymm20"
        case '1':	 // 1 string to match.
          return X86::YMM21;	 // "ymm21"
        case '2':	 // 1 string to match.
          return X86::YMM22;	 // "ymm22"
        case '3':	 // 1 string to match.
          return X86::YMM23;	 // "ymm23"
        case '4':	 // 1 string to match.
          return X86::YMM24;	 // "ymm24"
        case '5':	 // 1 string to match.
          return X86::YMM25;	 // "ymm25"
        case '6':	 // 1 string to match.
          return X86::YMM26;	 // "ymm26"
        case '7':	 // 1 string to match.
          return X86::YMM27;	 // "ymm27"
        case '8':	 // 1 string to match.
          return X86::YMM28;	 // "ymm28"
        case '9':	 // 1 string to match.
          return X86::YMM29;	 // "ymm29"
        }
        break;
      case '3':	 // 2 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return X86::YMM30;	 // "ymm30"
        case '1':	 // 1 string to match.
          return X86::YMM31;	 // "ymm31"
        }
        break;
      }
      break;
    case 'z':	 // 22 strings to match.
      if (memcmp(Name.data()+1, "mm", 2) != 0)
        break;
      switch (Name[3]) {
      default: break;
      case '1':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return X86::ZMM10;	 // "zmm10"
        case '1':	 // 1 string to match.
          return X86::ZMM11;	 // "zmm11"
        case '2':	 // 1 string to match.
          return X86::ZMM12;	 // "zmm12"
        case '3':	 // 1 string to match.
          return X86::ZMM13;	 // "zmm13"
        case '4':	 // 1 string to match.
          return X86::ZMM14;	 // "zmm14"
        case '5':	 // 1 string to match.
          return X86::ZMM15;	 // "zmm15"
        case '6':	 // 1 string to match.
          return X86::ZMM16;	 // "zmm16"
        case '7':	 // 1 string to match.
          return X86::ZMM17;	 // "zmm17"
        case '8':	 // 1 string to match.
          return X86::ZMM18;	 // "zmm18"
        case '9':	 // 1 string to match.
          return X86::ZMM19;	 // "zmm19"
        }
        break;
      case '2':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return X86::ZMM20;	 // "zmm20"
        case '1':	 // 1 string to match.
          return X86::ZMM21;	 // "zmm21"
        case '2':	 // 1 string to match.
          return X86::ZMM22;	 // "zmm22"
        case '3':	 // 1 string to match.
          return X86::ZMM23;	 // "zmm23"
        case '4':	 // 1 string to match.
          return X86::ZMM24;	 // "zmm24"
        case '5':	 // 1 string to match.
          return X86::ZMM25;	 // "zmm25"
        case '6':	 // 1 string to match.
          return X86::ZMM26;	 // "zmm26"
        case '7':	 // 1 string to match.
          return X86::ZMM27;	 // "zmm27"
        case '8':	 // 1 string to match.
          return X86::ZMM28;	 // "zmm28"
        case '9':	 // 1 string to match.
          return X86::ZMM29;	 // "zmm29"
        }
        break;
      case '3':	 // 2 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return X86::ZMM30;	 // "zmm30"
        case '1':	 // 1 string to match.
          return X86::ZMM31;	 // "zmm31"
        }
        break;
      }
      break;
    }
    break;
  case 6:	 // 3 strings to match.
    switch (Name[0]) {
    default: break;
    case 'e':	 // 1 string to match.
      if (memcmp(Name.data()+1, "flags", 5) != 0)
        break;
      return X86::_EFLAGS;	 // "eflags"
    case 'r':	 // 1 string to match.
      if (memcmp(Name.data()+1, "flags", 5) != 0)
        break;
      return X86::RFLAGS;	 // "rflags"
    case 't':	 // 1 string to match.
      if (memcmp(Name.data()+1, "mmcfg", 5) != 0)
        break;
      return X86::TMMCFG;	 // "tmmcfg"
    }
    break;
  case 7:	 // 3 strings to match.
    switch (Name[0]) {
    default: break;
    case 'd':	 // 1 string to match.
      if (memcmp(Name.data()+1, "irflag", 6) != 0)
        break;
      return X86::DF;	 // "dirflag"
    case 'f':	 // 1 string to match.
      if (memcmp(Name.data()+1, "s.base", 6) != 0)
        break;
      return X86::FS_BASE;	 // "fs.base"
    case 'g':	 // 1 string to match.
      if (memcmp(Name.data()+1, "s.base", 6) != 0)
        break;
      return X86::GS_BASE;	 // "gs.base"
    }
    break;
  }
  return X86::NoRegister;
}

#endif // GET_REGISTER_MATCHER


#ifdef GET_SUBTARGET_FEATURE_NAME
#undef GET_SUBTARGET_FEATURE_NAME

// User-level names for subtarget features that participate in
// instruction matching.
static const char *getSubtargetFeatureName(uint64_t Val) {
  switch(Val) {
  case Feature_Not64BitModeBit: return "Not 64-bit mode";
  case Feature_In64BitModeBit: return "64-bit mode";
  case Feature_In16BitModeBit: return "16-bit mode";
  case Feature_Not16BitModeBit: return "Not 16-bit mode";
  case Feature_In32BitModeBit: return "32-bit mode";
  default: return "(unknown)";
  }
}

#endif // GET_SUBTARGET_FEATURE_NAME


#ifdef GET_MATCHER_IMPLEMENTATION
#undef GET_MATCHER_IMPLEMENTATION

static void applyMnemonicAliases(StringRef &Mnemonic, const FeatureBitset &Features, unsigned VariantID) {
  switch (VariantID) {
  case 0:
      switch (Mnemonic.size()) {
      default: break;
      case 3:	 // 6 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 4 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'b':	 // 1 string to match.
            if (Mnemonic[2] != 'w')
              break;
            Mnemonic = "cbtw";	 // "cbw"
            return;
          case 'd':	 // 1 string to match.
            if (Mnemonic[2] != 'q')
              break;
            Mnemonic = "cltd";	 // "cdq"
            return;
          case 'q':	 // 1 string to match.
            if (Mnemonic[2] != 'o')
              break;
            Mnemonic = "cqto";	 // "cqo"
            return;
          case 'w':	 // 1 string to match.
            if (Mnemonic[2] != 'd')
              break;
            Mnemonic = "cwtd";	 // "cwd"
            return;
          }
          break;
        case 'p':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "op", 2) != 0)
            break;
          if (Features.test(Feature_In16BitModeBit))	 // "pop"
            Mnemonic = "popw";
          else if (Features.test(Feature_In32BitModeBit))
            Mnemonic = "popl";
          else if (Features.test(Feature_In64BitModeBit))
            Mnemonic = "popq";
          return;
        case 'r':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "et", 2) != 0)
            break;
          if (Features.test(Feature_In16BitModeBit))	 // "ret"
            Mnemonic = "retw";
          else if (Features.test(Feature_In32BitModeBit))
            Mnemonic = "retl";
          else if (Features.test(Feature_In64BitModeBit))
            Mnemonic = "retq";
          return;
        }
        break;
      case 4:	 // 18 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'a':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "ll", 2) != 0)
              break;
            if (Features.test(Feature_In16BitModeBit))	 // "call"
              Mnemonic = "callw";
            else if (Features.test(Feature_In32BitModeBit))
              Mnemonic = "calll";
            else if (Features.test(Feature_In64BitModeBit))
              Mnemonic = "callq";
            return;
          case 'd':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "qe", 2) != 0)
              break;
            Mnemonic = "cltq";	 // "cdqe"
            return;
          case 'w':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "de", 2) != 0)
              break;
            Mnemonic = "cwtl";	 // "cwde"
            return;
          }
          break;
        case 'i':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ret", 3) != 0)
            break;
          if (Features.test(Feature_In16BitModeBit))	 // "iret"
            Mnemonic = "iretw";
          else if (Features.test(Feature_Not16BitModeBit))
            Mnemonic = "iretl";
          return;
        case 'l':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'g':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if (Features.test(Feature_In16BitModeBit))	 // "lgdt"
              Mnemonic = "lgdtw";
            else if (Features.test(Feature_In32BitModeBit))
              Mnemonic = "lgdtl";
            else if (Features.test(Feature_In64BitModeBit))
              Mnemonic = "lgdtq";
            return;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if (Features.test(Feature_In16BitModeBit))	 // "lidt"
              Mnemonic = "lidtw";
            else if (Features.test(Feature_In32BitModeBit))
              Mnemonic = "lidtl";
            else if (Features.test(Feature_In64BitModeBit))
              Mnemonic = "lidtq";
            return;
          case 'r':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "et", 2) != 0)
              break;
            if (Features.test(Feature_In16BitModeBit))	 // "lret"
              Mnemonic = "lretw";
            else if (Features.test(Feature_Not16BitModeBit))
              Mnemonic = "lretl";
            return;
          }
          break;
        case 'p':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'o':	 // 2 strings to match.
            if (Mnemonic[2] != 'p')
              break;
            switch (Mnemonic[3]) {
            default: break;
            case 'a':	 // 1 string to match.
              if (Features.test(Feature_In16BitModeBit))	 // "popa"
                Mnemonic = "popaw";
              else if (Features.test(Feature_In32BitModeBit))
                Mnemonic = "popal";
              return;
            case 'f':	 // 1 string to match.
              if (Features.test(Feature_In16BitModeBit))	 // "popf"
                Mnemonic = "popfw";
              else if (Features.test(Feature_In32BitModeBit))
                Mnemonic = "popfl";
              else if (Features.test(Feature_In64BitModeBit))
                Mnemonic = "popfq";
              return;
            }
            break;
          case 'u':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "sh", 2) != 0)
              break;
            if (Features.test(Feature_In16BitModeBit))	 // "push"
              Mnemonic = "pushw";
            else if (Features.test(Feature_In32BitModeBit))
              Mnemonic = "pushl";
            else if (Features.test(Feature_In64BitModeBit))
              Mnemonic = "pushq";
            return;
          }
          break;
        case 'r':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "etn", 3) != 0)
            break;
          if (Features.test(Feature_In16BitModeBit))	 // "retn"
            Mnemonic = "retw";
          else if (Features.test(Feature_In32BitModeBit))
            Mnemonic = "retl";
          else if (Features.test(Feature_In64BitModeBit))
            Mnemonic = "retq";
          return;
        case 's':	 // 6 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'a':	 // 4 strings to match.
            if (Mnemonic[2] != 'l')
              break;
            switch (Mnemonic[3]) {
            default: break;
            case 'b':	 // 1 string to match.
              Mnemonic = "shlb";	 // "salb"
              return;
            case 'l':	 // 1 string to match.
              Mnemonic = "shll";	 // "sall"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "shlq";	 // "salq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "shlw";	 // "salw"
              return;
            }
            break;
          case 'g':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if (Features.test(Feature_In16BitModeBit))	 // "sgdt"
              Mnemonic = "sgdtw";
            else if (Features.test(Feature_In32BitModeBit))
              Mnemonic = "sgdtl";
            else if (Features.test(Feature_In64BitModeBit))
              Mnemonic = "sgdtq";
            return;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if (Features.test(Feature_In16BitModeBit))	 // "sidt"
              Mnemonic = "sidtw";
            else if (Features.test(Feature_In32BitModeBit))
              Mnemonic = "sidtl";
            else if (Features.test(Feature_In64BitModeBit))
              Mnemonic = "sidtq";
            return;
          }
          break;
        case 'u':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "d2a", 3) != 0)
            break;
          Mnemonic = "ud2";	 // "ud2a"
          return;
        }
        break;
      case 5:	 // 12 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'f':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ildq", 4) != 0)
            break;
          Mnemonic = "fildll";	 // "fildq"
          return;
        case 'p':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'o':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "pfd", 3) != 0)
              break;
            Mnemonic = "popfl";	 // "popfd"
            return;
          case 'u':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "sh", 2) != 0)
              break;
            switch (Mnemonic[4]) {
            default: break;
            case 'a':	 // 1 string to match.
              if (Features.test(Feature_In16BitModeBit))	 // "pusha"
                Mnemonic = "pushaw";
              else if (Features.test(Feature_In32BitModeBit))
                Mnemonic = "pushal";
              return;
            case 'f':	 // 1 string to match.
              if (Features.test(Feature_In16BitModeBit))	 // "pushf"
                Mnemonic = "pushfw";
              else if (Features.test(Feature_In32BitModeBit))
                Mnemonic = "pushfl";
              else if (Features.test(Feature_In64BitModeBit))
                Mnemonic = "pushfq";
              return;
            }
            break;
          }
          break;
        case 's':	 // 4 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3) != 0)
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'b':	 // 1 string to match.
            Mnemonic = "movsb";	 // "smovb"
            return;
          case 'l':	 // 1 string to match.
            Mnemonic = "movsl";	 // "smovl"
            return;
          case 'q':	 // 1 string to match.
            Mnemonic = "movsq";	 // "smovq"
            return;
          case 'w':	 // 1 string to match.
            Mnemonic = "movsw";	 // "smovw"
            return;
          }
          break;
        case 'u':	 // 3 strings to match.
          if (memcmp(Mnemonic.data()+1, "d2b", 3) != 0)
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'l':	 // 1 string to match.
            Mnemonic = "ud1l";	 // "ud2bl"
            return;
          case 'q':	 // 1 string to match.
            Mnemonic = "ud1q";	 // "ud2bq"
            return;
          case 'w':	 // 1 string to match.
            Mnemonic = "ud1w";	 // "ud2bw"
            return;
          }
          break;
        case 'v':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "errw", 4) != 0)
            break;
          Mnemonic = "verr";	 // "verrw"
          return;
        }
        break;
      case 6:	 // 15 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 6 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3) != 0)
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'c':	 // 3 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovbl";	 // "cmovcl"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmovbq";	 // "cmovcq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovbw";	 // "cmovcw"
              return;
            }
            break;
          case 'z':	 // 3 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovel";	 // "cmovzl"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmoveq";	 // "cmovzq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovew";	 // "cmovzw"
              return;
            }
            break;
          }
          break;
        case 'f':	 // 4 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'c':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "mov", 3) != 0)
              break;
            switch (Mnemonic[5]) {
            default: break;
            case 'a':	 // 1 string to match.
              Mnemonic = "fcmovnbe";	 // "fcmova"
              return;
            case 'z':	 // 1 string to match.
              Mnemonic = "fcmove";	 // "fcmovz"
              return;
            }
            break;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "stpq", 4) != 0)
              break;
            Mnemonic = "fistpll";	 // "fistpq"
            return;
          case 'l':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dcww", 4) != 0)
              break;
            Mnemonic = "fldcw";	 // "fldcww"
            return;
          }
          break;
        case 'l':	 // 2 strings to match.
          if (memcmp(Mnemonic.data()+1, "eave", 4) != 0)
            break;
          switch (Mnemonic[5]) {
          default: break;
          case 'l':	 // 1 string to match.
            if (Features.test(Feature_Not64BitModeBit))	 // "leavel"
              Mnemonic = "leave";
            return;
          case 'q':	 // 1 string to match.
            if (Features.test(Feature_In64BitModeBit))	 // "leaveq"
              Mnemonic = "leave";
            return;
          }
          break;
        case 'p':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ushfd", 5) != 0)
            break;
          Mnemonic = "pushfl";	 // "pushfd"
          return;
        case 's':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ysret", 5) != 0)
            break;
          Mnemonic = "sysretl";	 // "sysret"
          return;
        case 'x':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "saveq", 5) != 0)
            break;
          Mnemonic = "xsave64";	 // "xsaveq"
          return;
        }
        break;
      case 7:	 // 34 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 24 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3) != 0)
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'n':	 // 18 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'a':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovbel";	 // "cmovnal"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovbeq";	 // "cmovnaq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovbew";	 // "cmovnaw"
                return;
              }
              break;
            case 'b':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovael";	 // "cmovnbl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovaeq";	 // "cmovnbq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovaew";	 // "cmovnbw"
                return;
              }
              break;
            case 'c':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovael";	 // "cmovncl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovaeq";	 // "cmovncq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovaew";	 // "cmovncw"
                return;
              }
              break;
            case 'g':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovlel";	 // "cmovngl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovleq";	 // "cmovngq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovlew";	 // "cmovngw"
                return;
              }
              break;
            case 'l':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovgel";	 // "cmovnll"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovgeq";	 // "cmovnlq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovgew";	 // "cmovnlw"
                return;
              }
              break;
            case 'z':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovnel";	 // "cmovnzl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovneq";	 // "cmovnzq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovnew";	 // "cmovnzw"
                return;
              }
              break;
            }
            break;
          case 'p':	 // 6 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'e':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovpl";	 // "cmovpel"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovpq";	 // "cmovpeq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovpw";	 // "cmovpew"
                return;
              }
              break;
            case 'o':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovnpl";	 // "cmovpol"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovnpq";	 // "cmovpoq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovnpw";	 // "cmovpow"
                return;
              }
              break;
            }
            break;
          }
          break;
        case 'f':	 // 6 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'c':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "mov", 3) != 0)
              break;
            switch (Mnemonic[5]) {
            default: break;
            case 'a':	 // 1 string to match.
              if (Mnemonic[6] != 'e')
                break;
              Mnemonic = "fcmovnb";	 // "fcmovae"
              return;
            case 'n':	 // 1 string to match.
              if (Mnemonic[6] != 'a')
                break;
              Mnemonic = "fcmovbe";	 // "fcmovna"
              return;
            }
            break;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "sttpq", 5) != 0)
              break;
            Mnemonic = "fisttpll";	 // "fisttpq"
            return;
          case 'n':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "st", 2) != 0)
              break;
            switch (Mnemonic[4]) {
            default: break;
            case 'c':	 // 1 string to match.
              if (memcmp(Mnemonic.data()+5, "ww", 2) != 0)
                break;
              Mnemonic = "fnstcw";	 // "fnstcww"
              return;
            case 's':	 // 1 string to match.
              if (memcmp(Mnemonic.data()+5, "ww", 2) != 0)
                break;
              Mnemonic = "fnstsw";	 // "fnstsww"
              return;
            }
            break;
          case 'x':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "saveq", 5) != 0)
              break;
            Mnemonic = "fxsave64";	 // "fxsaveq"
            return;
          }
          break;
        case 's':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ysexit", 6) != 0)
            break;
          Mnemonic = "sysexitl";	 // "sysexit"
          return;
        case 'x':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'r':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "storq", 5) != 0)
              break;
            Mnemonic = "xrstor64";	 // "xrstorq"
            return;
          case 's':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "ave", 3) != 0)
              break;
            switch (Mnemonic[5]) {
            default: break;
            case 'c':	 // 1 string to match.
              if (Mnemonic[6] != 'q')
                break;
              Mnemonic = "xsavec64";	 // "xsavecq"
              return;
            case 's':	 // 1 string to match.
              if (Mnemonic[6] != 'q')
                break;
              Mnemonic = "xsaves64";	 // "xsavesq"
              return;
            }
            break;
          }
          break;
        }
        break;
      case 8:	 // 21 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 18 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'f':	 // 6 strings to match.
            if (memcmp(Mnemonic.data()+2, "cmov", 4) != 0)
              break;
            switch (Mnemonic[6]) {
            default: break;
            case 'c':	 // 3 strings to match.
              switch (Mnemonic[7]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cfcmovbl";	 // "cfcmovcl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cfcmovbq";	 // "cfcmovcq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cfcmovbw";	 // "cfcmovcw"
                return;
              }
              break;
            case 'z':	 // 3 strings to match.
              switch (Mnemonic[7]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cfcmovel";	 // "cfcmovzl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cfcmoveq";	 // "cfcmovzq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cfcmovew";	 // "cfcmovzw"
                return;
              }
              break;
            }
            break;
          case 'm':	 // 12 strings to match.
            if (memcmp(Mnemonic.data()+2, "ovn", 3) != 0)
              break;
            switch (Mnemonic[5]) {
            default: break;
            case 'a':	 // 3 strings to match.
              if (Mnemonic[6] != 'e')
                break;
              switch (Mnemonic[7]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovbl";	 // "cmovnael"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovbq";	 // "cmovnaeq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovbw";	 // "cmovnaew"
                return;
              }
              break;
            case 'b':	 // 3 strings to match.
              if (Mnemonic[6] != 'e')
                break;
              switch (Mnemonic[7]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmoval";	 // "cmovnbel"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovaq";	 // "cmovnbeq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovaw";	 // "cmovnbew"
                return;
              }
              break;
            case 'g':	 // 3 strings to match.
              if (Mnemonic[6] != 'e')
                break;
              switch (Mnemonic[7]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovll";	 // "cmovngel"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovlq";	 // "cmovngeq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovlw";	 // "cmovngew"
                return;
              }
              break;
            case 'l':	 // 3 strings to match.
              if (Mnemonic[6] != 'e')
                break;
              switch (Mnemonic[7]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovgl";	 // "cmovnlel"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovgq";	 // "cmovnleq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovgw";	 // "cmovnlew"
                return;
              }
              break;
            }
            break;
          }
          break;
        case 'f':	 // 2 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'c':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "movnae", 6) != 0)
              break;
            Mnemonic = "fcmovb";	 // "fcmovnae"
            return;
          case 'x':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "rstorq", 6) != 0)
              break;
            Mnemonic = "fxrstor64";	 // "fxrstorq"
            return;
          }
          break;
        case 'x':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "rstorsq", 7) != 0)
            break;
          Mnemonic = "xrstors64";	 // "xrstorsq"
          return;
        }
        break;
      case 9:	 // 25 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 24 strings to match.
          if (memcmp(Mnemonic.data()+1, "fcmov", 5) != 0)
            break;
          switch (Mnemonic[6]) {
          default: break;
          case 'n':	 // 18 strings to match.
            switch (Mnemonic[7]) {
            default: break;
            case 'a':	 // 3 strings to match.
              switch (Mnemonic[8]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cfcmovbel";	 // "cfcmovnal"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cfcmovbeq";	 // "cfcmovnaq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cfcmovbew";	 // "cfcmovnaw"
                return;
              }
              break;
            case 'b':	 // 3 strings to match.
              switch (Mnemonic[8]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cfcmovael";	 // "cfcmovnbl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cfcmovaeq";	 // "cfcmovnbq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cfcmovaew";	 // "cfcmovnbw"
                return;
              }
              break;
            case 'c':	 // 3 strings to match.
              switch (Mnemonic[8]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cfcmovael";	 // "cfcmovncl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cfcmovaeq";	 // "cfcmovncq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cfcmovaew";	 // "cfcmovncw"
                return;
              }
              break;
            case 'g':	 // 3 strings to match.
              switch (Mnemonic[8]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cfcmovlel";	 // "cfcmovngl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cfcmovleq";	 // "cfcmovngq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cfcmovlew";	 // "cfcmovngw"
                return;
              }
              break;
            case 'l':	 // 3 strings to match.
              switch (Mnemonic[8]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cfcmovgel";	 // "cfcmovnll"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cfcmovgeq";	 // "cfcmovnlq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cfcmovgew";	 // "cfcmovnlw"
                return;
              }
              break;
            case 'z':	 // 3 strings to match.
              switch (Mnemonic[8]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cfcmovnel";	 // "cfcmovnzl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cfcmovneq";	 // "cfcmovnzq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cfcmovnew";	 // "cfcmovnzw"
                return;
              }
              break;
            }
            break;
          case 'p':	 // 6 strings to match.
            switch (Mnemonic[7]) {
            default: break;
            case 'e':	 // 3 strings to match.
              switch (Mnemonic[8]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cfcmovpl";	 // "cfcmovpel"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cfcmovpq";	 // "cfcmovpeq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cfcmovpw";	 // "cfcmovpew"
                return;
              }
              break;
            case 'o':	 // 3 strings to match.
              switch (Mnemonic[8]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cfcmovnpl";	 // "cfcmovpol"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cfcmovnpq";	 // "cfcmovpoq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cfcmovnpw";	 // "cfcmovpow"
                return;
              }
              break;
            }
            break;
          }
          break;
        case 'x':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "saveoptq", 8) != 0)
            break;
          Mnemonic = "xsaveopt64";	 // "xsaveoptq"
          return;
        }
        break;
      case 10:	 // 12 strings to match.
        if (memcmp(Mnemonic.data()+0, "cfcmovn", 7) != 0)
          break;
        switch (Mnemonic[7]) {
        default: break;
        case 'a':	 // 3 strings to match.
          if (Mnemonic[8] != 'e')
            break;
          switch (Mnemonic[9]) {
          default: break;
          case 'l':	 // 1 string to match.
            Mnemonic = "cfcmovbl";	 // "cfcmovnael"
            return;
          case 'q':	 // 1 string to match.
            Mnemonic = "cfcmovbq";	 // "cfcmovnaeq"
            return;
          case 'w':	 // 1 string to match.
            Mnemonic = "cfcmovbw";	 // "cfcmovnaew"
            return;
          }
          break;
        case 'b':	 // 3 strings to match.
          if (Mnemonic[8] != 'e')
            break;
          switch (Mnemonic[9]) {
          default: break;
          case 'l':	 // 1 string to match.
            Mnemonic = "cfcmoval";	 // "cfcmovnbel"
            return;
          case 'q':	 // 1 string to match.
            Mnemonic = "cfcmovaq";	 // "cfcmovnbeq"
            return;
          case 'w':	 // 1 string to match.
            Mnemonic = "cfcmovaw";	 // "cfcmovnbew"
            return;
          }
          break;
        case 'g':	 // 3 strings to match.
          if (Mnemonic[8] != 'e')
            break;
          switch (Mnemonic[9]) {
          default: break;
          case 'l':	 // 1 string to match.
            Mnemonic = "cfcmovll";	 // "cfcmovngel"
            return;
          case 'q':	 // 1 string to match.
            Mnemonic = "cfcmovlq";	 // "cfcmovngeq"
            return;
          case 'w':	 // 1 string to match.
            Mnemonic = "cfcmovlw";	 // "cfcmovngew"
            return;
          }
          break;
        case 'l':	 // 3 strings to match.
          if (Mnemonic[8] != 'e')
            break;
          switch (Mnemonic[9]) {
          default: break;
          case 'l':	 // 1 string to match.
            Mnemonic = "cfcmovgl";	 // "cfcmovnlel"
            return;
          case 'q':	 // 1 string to match.
            Mnemonic = "cfcmovgq";	 // "cfcmovnleq"
            return;
          case 'w':	 // 1 string to match.
            Mnemonic = "cfcmovgw";	 // "cfcmovnlew"
            return;
          }
          break;
        }
        break;
      }
    break;
  case 1:
      switch (Mnemonic.size()) {
      default: break;
      case 3:	 // 1 string to match.
        if (memcmp(Mnemonic.data()+0, "sal", 3) != 0)
          break;
        Mnemonic = "shl";	 // "sal"
        return;
      case 4:	 // 7 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'l':	 // 2 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'g':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if (Features.test(Feature_In16BitModeBit))	 // "lgdt"
              Mnemonic = "lgdtw";
            else if (Features.test(Feature_In32BitModeBit))
              Mnemonic = "lgdtd";
            return;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if (Features.test(Feature_In16BitModeBit))	 // "lidt"
              Mnemonic = "lidtw";
            else if (Features.test(Feature_In32BitModeBit))
              Mnemonic = "lidtd";
            return;
          }
          break;
        case 'p':	 // 2 strings to match.
          if (memcmp(Mnemonic.data()+1, "op", 2) != 0)
            break;
          switch (Mnemonic[3]) {
          default: break;
          case 'a':	 // 1 string to match.
            if (Features.test(Feature_In16BitModeBit))	 // "popa"
              Mnemonic = "popaw";
            else if (Features.test(Feature_In32BitModeBit))
              Mnemonic = "popal";
            return;
          case 'f':	 // 1 string to match.
            if (Features.test(Feature_In64BitModeBit))	 // "popf"
              Mnemonic = "popfq";
            return;
          }
          break;
        case 'r':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "etn", 3) != 0)
            break;
          Mnemonic = "ret";	 // "retn"
          return;
        case 's':	 // 2 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'g':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if (Features.test(Feature_In16BitModeBit))	 // "sgdt"
              Mnemonic = "sgdtw";
            else if (Features.test(Feature_In32BitModeBit))
              Mnemonic = "sgdtd";
            return;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2) != 0)
              break;
            if (Features.test(Feature_In16BitModeBit))	 // "sidt"
              Mnemonic = "sidtw";
            else if (Features.test(Feature_In32BitModeBit))
              Mnemonic = "sidtd";
            return;
          }
          break;
        }
        break;
      case 5:	 // 6 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 2 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3) != 0)
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'c':	 // 1 string to match.
            Mnemonic = "cmovb";	 // "cmovc"
            return;
          case 'z':	 // 1 string to match.
            Mnemonic = "cmove";	 // "cmovz"
            return;
          }
          break;
        case 'p':	 // 4 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'o':	 // 2 strings to match.
            if (Mnemonic[2] != 'p')
              break;
            switch (Mnemonic[3]) {
            default: break;
            case 'a':	 // 1 string to match.
              if (Mnemonic[4] != 'd')
                break;
              if (Features.test(Feature_Not64BitModeBit))	 // "popad"
                Mnemonic = "popal";
              return;
            case 'f':	 // 1 string to match.
              if (Mnemonic[4] != 'w')
                break;
              if (Features.test(Feature_In32BitModeBit))	 // "popfw"
                Mnemonic = "popf";
              else if (Features.test(Feature_In64BitModeBit))
                Mnemonic = "popf";
              return;
            }
            break;
          case 'u':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "sh", 2) != 0)
              break;
            switch (Mnemonic[4]) {
            default: break;
            case 'a':	 // 1 string to match.
              if (Features.test(Feature_In16BitModeBit))	 // "pusha"
                Mnemonic = "pushaw";
              else if (Features.test(Feature_In32BitModeBit))
                Mnemonic = "pushal";
              return;
            case 'f':	 // 1 string to match.
              if (Features.test(Feature_In64BitModeBit))	 // "pushf"
                Mnemonic = "pushfq";
              return;
            }
            break;
          }
          break;
        }
        break;
      case 6:	 // 10 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 8 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3) != 0)
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'n':	 // 6 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'a':	 // 1 string to match.
              Mnemonic = "cmovbe";	 // "cmovna"
              return;
            case 'b':	 // 1 string to match.
              Mnemonic = "cmovae";	 // "cmovnb"
              return;
            case 'c':	 // 1 string to match.
              Mnemonic = "cmovae";	 // "cmovnc"
              return;
            case 'g':	 // 1 string to match.
              Mnemonic = "cmovle";	 // "cmovng"
              return;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovge";	 // "cmovnl"
              return;
            case 'z':	 // 1 string to match.
              Mnemonic = "cmovne";	 // "cmovnz"
              return;
            }
            break;
          case 'p':	 // 2 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'e':	 // 1 string to match.
              Mnemonic = "cmovp";	 // "cmovpe"
              return;
            case 'o':	 // 1 string to match.
              Mnemonic = "cmovnp";	 // "cmovpo"
              return;
            }
            break;
          }
          break;
        case 'p':	 // 2 strings to match.
          if (memcmp(Mnemonic.data()+1, "ush", 3) != 0)
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'a':	 // 1 string to match.
            if (Mnemonic[5] != 'd')
              break;
            if (Features.test(Feature_Not64BitModeBit))	 // "pushad"
              Mnemonic = "pushal";
            return;
          case 'f':	 // 1 string to match.
            if (Mnemonic[5] != 'w')
              break;
            if (Features.test(Feature_In32BitModeBit))	 // "pushfw"
              Mnemonic = "pushf";
            else if (Features.test(Feature_In64BitModeBit))
              Mnemonic = "pushf";
            return;
          }
          break;
        }
        break;
      case 7:	 // 8 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "cquire", 6) != 0)
            break;
          Mnemonic = "xacquire";	 // "acquire"
          return;
        case 'c':	 // 6 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'f':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "cmov", 4) != 0)
              break;
            switch (Mnemonic[6]) {
            default: break;
            case 'c':	 // 1 string to match.
              Mnemonic = "cfcmovb";	 // "cfcmovc"
              return;
            case 'z':	 // 1 string to match.
              Mnemonic = "cfcmove";	 // "cfcmovz"
              return;
            }
            break;
          case 'm':	 // 4 strings to match.
            if (memcmp(Mnemonic.data()+2, "ovn", 3) != 0)
              break;
            switch (Mnemonic[5]) {
            default: break;
            case 'a':	 // 1 string to match.
              if (Mnemonic[6] != 'e')
                break;
              Mnemonic = "cmovb";	 // "cmovnae"
              return;
            case 'b':	 // 1 string to match.
              if (Mnemonic[6] != 'e')
                break;
              Mnemonic = "cmova";	 // "cmovnbe"
              return;
            case 'g':	 // 1 string to match.
              if (Mnemonic[6] != 'e')
                break;
              Mnemonic = "cmovl";	 // "cmovnge"
              return;
            case 'l':	 // 1 string to match.
              if (Mnemonic[6] != 'e')
                break;
              Mnemonic = "cmovg";	 // "cmovnle"
              return;
            }
            break;
          }
          break;
        case 'r':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "elease", 6) != 0)
            break;
          Mnemonic = "xrelease";	 // "release"
          return;
        }
        break;
      case 8:	 // 8 strings to match.
        if (memcmp(Mnemonic.data()+0, "cfcmov", 6) != 0)
          break;
        switch (Mnemonic[6]) {
        default: break;
        case 'n':	 // 6 strings to match.
          switch (Mnemonic[7]) {
          default: break;
          case 'a':	 // 1 string to match.
            Mnemonic = "cfcmovbe";	 // "cfcmovna"
            return;
          case 'b':	 // 1 string to match.
            Mnemonic = "cfcmovae";	 // "cfcmovnb"
            return;
          case 'c':	 // 1 string to match.
            Mnemonic = "cfcmovae";	 // "cfcmovnc"
            return;
          case 'g':	 // 1 string to match.
            Mnemonic = "cfcmovle";	 // "cfcmovng"
            return;
          case 'l':	 // 1 string to match.
            Mnemonic = "cfcmovge";	 // "cfcmovnl"
            return;
          case 'z':	 // 1 string to match.
            Mnemonic = "cfcmovne";	 // "cfcmovnz"
            return;
          }
          break;
        case 'p':	 // 2 strings to match.
          switch (Mnemonic[7]) {
          default: break;
          case 'e':	 // 1 string to match.
            Mnemonic = "cfcmovp";	 // "cfcmovpe"
            return;
          case 'o':	 // 1 string to match.
            Mnemonic = "cfcmovnp";	 // "cfcmovpo"
            return;
          }
          break;
        }
        break;
      case 9:	 // 4 strings to match.
        if (memcmp(Mnemonic.data()+0, "cfcmovn", 7) != 0)
          break;
        switch (Mnemonic[7]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (Mnemonic[8] != 'e')
            break;
          Mnemonic = "cfcmovb";	 // "cfcmovnae"
          return;
        case 'b':	 // 1 string to match.
          if (Mnemonic[8] != 'e')
            break;
          Mnemonic = "cfcmova";	 // "cfcmovnbe"
          return;
        case 'g':	 // 1 string to match.
          if (Mnemonic[8] != 'e')
            break;
          Mnemonic = "cfcmovl";	 // "cfcmovnge"
          return;
        case 'l':	 // 1 string to match.
          if (Mnemonic[8] != 'e')
            break;
          Mnemonic = "cfcmovg";	 // "cfcmovnle"
          return;
        }
        break;
      }
    break;
  }
  switch (Mnemonic.size()) {
  default: break;
  case 2:	 // 2 strings to match.
    if (Mnemonic[0] != 'j')
      break;
    switch (Mnemonic[1]) {
    default: break;
    case 'c':	 // 1 string to match.
      Mnemonic = "jb";	 // "jc"
      return;
    case 'z':	 // 1 string to match.
      Mnemonic = "je";	 // "jz"
      return;
    }
    break;
  case 3:	 // 8 strings to match.
    if (Mnemonic[0] != 'j')
      break;
    switch (Mnemonic[1]) {
    default: break;
    case 'n':	 // 6 strings to match.
      switch (Mnemonic[2]) {
      default: break;
      case 'a':	 // 1 string to match.
        Mnemonic = "jbe";	 // "jna"
        return;
      case 'b':	 // 1 string to match.
        Mnemonic = "jae";	 // "jnb"
        return;
      case 'c':	 // 1 string to match.
        Mnemonic = "jae";	 // "jnc"
        return;
      case 'g':	 // 1 string to match.
        Mnemonic = "jle";	 // "jng"
        return;
      case 'l':	 // 1 string to match.
        Mnemonic = "jge";	 // "jnl"
        return;
      case 'z':	 // 1 string to match.
        Mnemonic = "jne";	 // "jnz"
        return;
      }
      break;
    case 'p':	 // 2 strings to match.
      switch (Mnemonic[2]) {
      default: break;
      case 'e':	 // 1 string to match.
        Mnemonic = "jp";	 // "jpe"
        return;
      case 'o':	 // 1 string to match.
        Mnemonic = "jnp";	 // "jpo"
        return;
      }
      break;
    }
    break;
  case 4:	 // 8 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'j':	 // 4 strings to match.
      if (Mnemonic[1] != 'n')
        break;
      switch (Mnemonic[2]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (Mnemonic[3] != 'e')
          break;
        Mnemonic = "jb";	 // "jnae"
        return;
      case 'b':	 // 1 string to match.
        if (Mnemonic[3] != 'e')
          break;
        Mnemonic = "ja";	 // "jnbe"
        return;
      case 'g':	 // 1 string to match.
        if (Mnemonic[3] != 'e')
          break;
        Mnemonic = "jl";	 // "jnge"
        return;
      case 'l':	 // 1 string to match.
        if (Mnemonic[3] != 'e')
          break;
        Mnemonic = "jg";	 // "jnle"
        return;
      }
      break;
    case 'r':	 // 2 strings to match.
      if (memcmp(Mnemonic.data()+1, "ep", 2) != 0)
        break;
      switch (Mnemonic[3]) {
      default: break;
      case 'e':	 // 1 string to match.
        Mnemonic = "rep";	 // "repe"
        return;
      case 'z':	 // 1 string to match.
        Mnemonic = "rep";	 // "repz"
        return;
      }
      break;
    case 's':	 // 2 strings to match.
      if (memcmp(Mnemonic.data()+1, "et", 2) != 0)
        break;
      switch (Mnemonic[3]) {
      default: break;
      case 'c':	 // 1 string to match.
        Mnemonic = "setb";	 // "setc"
        return;
      case 'z':	 // 1 string to match.
        Mnemonic = "sete";	 // "setz"
        return;
      }
      break;
    }
    break;
  case 5:	 // 11 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "wait", 4) != 0)
        break;
      Mnemonic = "wait";	 // "fwait"
      return;
    case 'l':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "oopz", 4) != 0)
        break;
      Mnemonic = "loope";	 // "loopz"
      return;
    case 'r':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "epnz", 4) != 0)
        break;
      Mnemonic = "repne";	 // "repnz"
      return;
    case 's':	 // 8 strings to match.
      if (memcmp(Mnemonic.data()+1, "et", 2) != 0)
        break;
      switch (Mnemonic[3]) {
      default: break;
      case 'n':	 // 6 strings to match.
        switch (Mnemonic[4]) {
        default: break;
        case 'a':	 // 1 string to match.
          Mnemonic = "setbe";	 // "setna"
          return;
        case 'b':	 // 1 string to match.
          Mnemonic = "setae";	 // "setnb"
          return;
        case 'c':	 // 1 string to match.
          Mnemonic = "setae";	 // "setnc"
          return;
        case 'g':	 // 1 string to match.
          Mnemonic = "setle";	 // "setng"
          return;
        case 'l':	 // 1 string to match.
          Mnemonic = "setge";	 // "setnl"
          return;
        case 'z':	 // 1 string to match.
          Mnemonic = "setne";	 // "setnz"
          return;
        }
        break;
      case 'p':	 // 2 strings to match.
        switch (Mnemonic[4]) {
        default: break;
        case 'e':	 // 1 string to match.
          Mnemonic = "setp";	 // "setpe"
          return;
        case 'o':	 // 1 string to match.
          Mnemonic = "setnp";	 // "setpo"
          return;
        }
        break;
      }
      break;
    }
    break;
  case 6:	 // 8 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "comip", 5) != 0)
        break;
      Mnemonic = "fcompi";	 // "fcomip"
      return;
    case 'l':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "oopnz", 5) != 0)
        break;
      Mnemonic = "loopne";	 // "loopnz"
      return;
    case 's':	 // 6 strings to match.
      if (memcmp(Mnemonic.data()+1, "et", 2) != 0)
        break;
      switch (Mnemonic[3]) {
      default: break;
      case 'n':	 // 4 strings to match.
        switch (Mnemonic[4]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (Mnemonic[5] != 'e')
            break;
          Mnemonic = "setb";	 // "setnae"
          return;
        case 'b':	 // 1 string to match.
          if (Mnemonic[5] != 'e')
            break;
          Mnemonic = "seta";	 // "setnbe"
          return;
        case 'g':	 // 1 string to match.
          if (Mnemonic[5] != 'e')
            break;
          Mnemonic = "setl";	 // "setnge"
          return;
        case 'l':	 // 1 string to match.
          if (Mnemonic[5] != 'e')
            break;
          Mnemonic = "setg";	 // "setnle"
          return;
        }
        break;
      case 'z':	 // 2 strings to match.
        if (Mnemonic[4] != 'u')
          break;
        switch (Mnemonic[5]) {
        default: break;
        case 'c':	 // 1 string to match.
          Mnemonic = "setzub";	 // "setzuc"
          return;
        case 'z':	 // 1 string to match.
          Mnemonic = "setzue";	 // "setzuz"
          return;
        }
        break;
      }
      break;
    }
    break;
  case 7:	 // 9 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "ucomip", 6) != 0)
        break;
      Mnemonic = "fucompi";	 // "fucomip"
      return;
    case 's':	 // 8 strings to match.
      if (memcmp(Mnemonic.data()+1, "etzu", 4) != 0)
        break;
      switch (Mnemonic[5]) {
      default: break;
      case 'n':	 // 6 strings to match.
        switch (Mnemonic[6]) {
        default: break;
        case 'a':	 // 1 string to match.
          Mnemonic = "setzube";	 // "setzuna"
          return;
        case 'b':	 // 1 string to match.
          Mnemonic = "setzuae";	 // "setzunb"
          return;
        case 'c':	 // 1 string to match.
          Mnemonic = "setzuae";	 // "setzunc"
          return;
        case 'g':	 // 1 string to match.
          Mnemonic = "setzule";	 // "setzung"
          return;
        case 'l':	 // 1 string to match.
          Mnemonic = "setzuge";	 // "setzunl"
          return;
        case 'z':	 // 1 string to match.
          Mnemonic = "setzune";	 // "setzunz"
          return;
        }
        break;
      case 'p':	 // 2 strings to match.
        switch (Mnemonic[6]) {
        default: break;
        case 'e':	 // 1 string to match.
          Mnemonic = "setzup";	 // "setzupe"
          return;
        case 'o':	 // 1 string to match.
          Mnemonic = "setzunp";	 // "setzupo"
          return;
        }
        break;
      }
      break;
    }
    break;
  case 8:	 // 6 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'c':	 // 2 strings to match.
      if (memcmp(Mnemonic.data()+1, "mp", 2) != 0)
        break;
      switch (Mnemonic[3]) {
      default: break;
      case 'c':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+4, "xadd", 4) != 0)
          break;
        Mnemonic = "cmpbxadd";	 // "cmpcxadd"
        return;
      case 'z':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+4, "xadd", 4) != 0)
          break;
        Mnemonic = "cmpexadd";	 // "cmpzxadd"
        return;
      }
      break;
    case 's':	 // 4 strings to match.
      if (memcmp(Mnemonic.data()+1, "etzun", 5) != 0)
        break;
      switch (Mnemonic[6]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (Mnemonic[7] != 'e')
          break;
        Mnemonic = "setzub";	 // "setzunae"
        return;
      case 'b':	 // 1 string to match.
        if (Mnemonic[7] != 'e')
          break;
        Mnemonic = "setzua";	 // "setzunbe"
        return;
      case 'g':	 // 1 string to match.
        if (Mnemonic[7] != 'e')
          break;
        Mnemonic = "setzul";	 // "setzunge"
        return;
      case 'l':	 // 1 string to match.
        if (Mnemonic[7] != 'e')
          break;
        Mnemonic = "setzug";	 // "setzunle"
        return;
      }
      break;
    }
    break;
  case 9:	 // 8 strings to match.
    if (memcmp(Mnemonic.data()+0, "cmp", 3) != 0)
      break;
    switch (Mnemonic[3]) {
    default: break;
    case 'n':	 // 6 strings to match.
      switch (Mnemonic[4]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+5, "xadd", 4) != 0)
          break;
        Mnemonic = "cmpbexadd";	 // "cmpnaxadd"
        return;
      case 'b':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+5, "xadd", 4) != 0)
          break;
        Mnemonic = "cmpaexadd";	 // "cmpnbxadd"
        return;
      case 'c':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+5, "xadd", 4) != 0)
          break;
        Mnemonic = "cmpaexadd";	 // "cmpncxadd"
        return;
      case 'g':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+5, "xadd", 4) != 0)
          break;
        Mnemonic = "cmplexadd";	 // "cmpngxadd"
        return;
      case 'l':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+5, "xadd", 4) != 0)
          break;
        Mnemonic = "cmpgexadd";	 // "cmpnlxadd"
        return;
      case 'z':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+5, "xadd", 4) != 0)
          break;
        Mnemonic = "cmpnexadd";	 // "cmpnzxadd"
        return;
      }
      break;
    case 'p':	 // 2 strings to match.
      switch (Mnemonic[4]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+5, "xadd", 4) != 0)
          break;
        Mnemonic = "cmppxadd";	 // "cmppexadd"
        return;
      case 'o':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+5, "xadd", 4) != 0)
          break;
        Mnemonic = "cmpnpxadd";	 // "cmppoxadd"
        return;
      }
      break;
    }
    break;
  case 10:	 // 4 strings to match.
    if (memcmp(Mnemonic.data()+0, "cmpn", 4) != 0)
      break;
    switch (Mnemonic[4]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+5, "exadd", 5) != 0)
        break;
      Mnemonic = "cmpbxadd";	 // "cmpnaexadd"
      return;
    case 'b':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+5, "exadd", 5) != 0)
        break;
      Mnemonic = "cmpaxadd";	 // "cmpnbexadd"
      return;
    case 'g':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+5, "exadd", 5) != 0)
        break;
      Mnemonic = "cmplxadd";	 // "cmpngexadd"
      return;
    case 'l':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+5, "exadd", 5) != 0)
        break;
      Mnemonic = "cmpgxadd";	 // "cmpnlexadd"
      return;
    }
    break;
  }
}

enum {
  Tie0_1_1,
  Tie0_2_2,
  Tie0_3_3,
  Tie0_4_4,
  Tie1_1_1,
  Tie1_2_2,
  Tie1_3_3,
  Tie1_4_4,
};

static const uint8_t TiedAsmOperandTable[][3] = {
  /* Tie0_1_1 */ { 0, 1, 1 },
  /* Tie0_2_2 */ { 0, 2, 2 },
  /* Tie0_3_3 */ { 0, 3, 3 },
  /* Tie0_4_4 */ { 0, 4, 4 },
  /* Tie1_1_1 */ { 1, 1, 1 },
  /* Tie1_2_2 */ { 1, 2, 2 },
  /* Tie1_3_3 */ { 1, 3, 3 },
  /* Tie1_4_4 */ { 1, 4, 4 },
};

namespace {
enum OperatorConversionKind {
  CVT_Done,
  CVT_Reg,
  CVT_Tied,
  CVT_imm_95_10,
  CVT_95_addImmOperands,
  CVT_95_addMemOperands,
  CVT_95_Reg,
  CVT_regAX,
  CVT_regEAX,
  CVT_regRAX,
  CVT_95_addAbsMemOperands,
  CVT_imm_95_7,
  CVT_imm_95_3,
  CVT_imm_95_2,
  CVT_imm_95_6,
  CVT_imm_95_4,
  CVT_imm_95_11,
  CVT_imm_95_15,
  CVT_imm_95_13,
  CVT_imm_95_12,
  CVT_imm_95_14,
  CVT_imm_95_5,
  CVT_imm_95_1,
  CVT_imm_95_9,
  CVT_imm_95_0,
  CVT_imm_95_8,
  CVT_95_addDstIdxOperands,
  CVT_95_addSrcIdxOperands,
  CVT_95_addGR32orGR64Operands,
  CVT_regST1,
  CVT_regST0,
  CVT_95_addGR16orGR32orGR64Operands,
  CVT_95_addMemOffsOperands,
  CVT_imm_95_17,
  CVT_imm_95_16,
  CVT_95_addTILEPairOperands,
  CVT_95_addAVX512RCOperands,
  CVT_95_addMaskPairOperands,
  CVT_NUM_CONVERTERS
};

enum InstructionConversionKind {
  Convert_NoOperands,
  Convert__imm_95_10,
  Convert__Imm1_0,
  Convert__Mem325_0__Reg1_1,
  Convert__Mem645_0__Reg1_1,
  Convert__Mem325_1__Reg1_0,
  Convert__Mem645_1__Reg1_0,
  Convert__Imm1_1,
  Convert__regAX__Tie0_1_1__ImmSExti16i81_1,
  Convert__regEAX__Tie0_1_1__ImmSExti32i81_1,
  Convert__regRAX__Tie0_1_1__ImmSExti64i81_1,
  Convert__ImmSExti64i321_1,
  Convert__Reg1_0__Tie0_1_1__Reg1_1,
  Convert__Reg1_0__Tie0_1_1__ImmSExti16i81_1,
  Convert__Reg1_0__Tie0_1_1__Imm1_1,
  Convert__Reg1_0__Tie0_1_1__Mem165_1,
  Convert__Reg1_0__Tie0_1_1__ImmSExti32i81_1,
  Convert__Reg1_0__Tie0_1_1__Mem325_1,
  Convert__Reg1_0__Tie0_1_1__ImmSExti64i81_1,
  Convert__Reg1_0__Tie0_1_1__ImmSExti64i321_1,
  Convert__Reg1_0__Tie0_1_1__Mem645_1,
  Convert__Reg1_0__Tie0_1_1__Mem85_1,
  Convert__Mem165_0__Reg1_1,
  Convert__Mem165_0__ImmSExti16i81_1,
  Convert__Mem165_0__Imm1_1,
  Convert__Mem325_0__ImmSExti32i81_1,
  Convert__Mem325_0__Imm1_1,
  Convert__Mem645_0__ImmSExti64i81_1,
  Convert__Mem645_0__ImmSExti64i321_1,
  Convert__Mem85_0__Reg1_1,
  Convert__Mem85_0__Imm1_1,
  Convert__Reg1_0__Reg1_1__Reg1_2,
  Convert__Reg1_0__Reg1_1__ImmSExti16i81_2,
  Convert__Reg1_0__Reg1_1__Imm1_2,
  Convert__Reg1_0__Reg1_1__Mem165_2,
  Convert__Reg1_0__Mem165_1__Reg1_2,
  Convert__Reg1_0__Mem165_1__ImmSExti16i81_2,
  Convert__Reg1_0__Mem165_1__Imm1_2,
  Convert__Reg1_0__Reg1_1__ImmSExti32i81_2,
  Convert__Reg1_0__Reg1_1__Mem325_2,
  Convert__Reg1_0__Mem325_1__Reg1_2,
  Convert__Reg1_0__Mem325_1__ImmSExti32i81_2,
  Convert__Reg1_0__Mem325_1__Imm1_2,
  Convert__Reg1_0__Reg1_1__ImmSExti64i81_2,
  Convert__Reg1_0__Reg1_1__ImmSExti64i321_2,
  Convert__Reg1_0__Reg1_1__Mem645_2,
  Convert__Reg1_0__Mem645_1__Reg1_2,
  Convert__Reg1_0__Mem645_1__ImmSExti64i81_2,
  Convert__Reg1_0__Mem645_1__ImmSExti64i321_2,
  Convert__Reg1_0__Reg1_1__Mem85_2,
  Convert__Reg1_0__Mem85_1__Reg1_2,
  Convert__Reg1_0__Mem85_1__Imm1_2,
  Convert__Reg1_1__Tie0_2_2__Reg1_0,
  Convert__Mem85_1__Reg1_0,
  Convert__Reg1_1__Tie0_2_2__Imm1_0,
  Convert__Mem85_1__Imm1_0,
  Convert__Reg1_1__Tie0_2_2__Mem85_0,
  Convert__Reg1_2__Reg1_1__Reg1_0,
  Convert__Reg1_2__Mem85_1__Reg1_0,
  Convert__Reg1_2__Reg1_1__Imm1_0,
  Convert__Reg1_2__Mem85_1__Imm1_0,
  Convert__Reg1_2__Reg1_1__Mem85_0,
  Convert__regEAX__Tie0_1_1__ImmSExti32i81_0,
  Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0,
  Convert__Mem325_1__ImmSExti32i81_0,
  Convert__Mem325_1__Imm1_0,
  Convert__Reg1_1__Tie0_2_2__Mem325_0,
  Convert__Reg1_2__Mem325_1__Reg1_0,
  Convert__Reg1_2__Reg1_1__ImmSExti32i81_0,
  Convert__Reg1_2__Mem325_1__ImmSExti32i81_0,
  Convert__Reg1_2__Mem325_1__Imm1_0,
  Convert__Reg1_2__Reg1_1__Mem325_0,
  Convert__regRAX__Tie0_1_1__ImmSExti64i81_0,
  Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0,
  Convert__Mem645_1__ImmSExti64i81_0,
  Convert__ImmSExti64i321_0,
  Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0,
  Convert__Mem645_1__ImmSExti64i321_0,
  Convert__Reg1_1__Tie0_2_2__Mem645_0,
  Convert__Reg1_2__Mem645_1__Reg1_0,
  Convert__Reg1_2__Reg1_1__ImmSExti64i81_0,
  Convert__Reg1_2__Mem645_1__ImmSExti64i81_0,
  Convert__Reg1_2__Reg1_1__ImmSExti64i321_0,
  Convert__Reg1_2__Mem645_1__ImmSExti64i321_0,
  Convert__Reg1_2__Reg1_1__Mem645_0,
  Convert__Mem165_1__Reg1_0,
  Convert__regAX__Tie0_1_1__ImmSExti16i81_0,
  Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0,
  Convert__Mem165_1__ImmSExti16i81_0,
  Convert__Mem165_1__Imm1_0,
  Convert__Reg1_1__Tie0_2_2__Mem165_0,
  Convert__Reg1_2__Mem165_1__Reg1_0,
  Convert__Reg1_2__Reg1_1__ImmSExti16i81_0,
  Convert__Reg1_2__Mem165_1__ImmSExti16i81_0,
  Convert__Reg1_2__Mem165_1__Imm1_0,
  Convert__Reg1_2__Reg1_1__Mem165_0,
  Convert__Reg1_1__Tie0_1_1__Reg1_0,
  Convert__Reg1_0__Tie0_1_1__Mem1285_1,
  Convert__Reg1_1__Tie0_1_1__Mem1285_0,
  Convert__Reg1_1__Tie0_1_1__Mem645_0,
  Convert__Reg1_1__Tie0_1_1__Mem325_0,
  Convert__Reg1_0__Tie0_1_1__Mem5_1,
  Convert__Reg1_1__Tie0_2_2__Mem5_0,
  Convert__Mem5_0,
  Convert__Reg1_1__Reg1_0,
  Convert__Reg1_0__Reg1_1,
  Convert__Reg1_0__Mem1285_1,
  Convert__Reg1_1__Mem1285_0,
  Convert__Reg1_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Mem1285_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Mem325_1,
  Convert__Reg1_0__Mem645_1,
  Convert__Reg1_1__Mem325_0,
  Convert__Reg1_1__Mem645_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Tie0_1_1__Mem1285_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_1__Tie0_2_2__Mem1285_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_1,
  Convert__Reg1_2__Tie0_1_1__Mem1285_1,
  Convert__Reg1_0__Mem165_1,
  Convert__Reg1_1__Tie0_1_1__Mem165_0,
  Convert__Reg1_0__Tie0_1_1,
  Convert__Reg1_0__ImmUnsignedi81_1,
  Convert__Mem325_1__ImmUnsignedi81_0,
  Convert__Mem165_0__ImmUnsignedi81_1,
  Convert__Mem325_0__ImmUnsignedi81_1,
  Convert__Mem645_0__ImmUnsignedi81_1,
  Convert__Reg1_0__Tie0_1_1__ImmUnsignedi81_1,
  Convert__Reg1_1__Tie0_2_2__ImmUnsignedi81_0,
  Convert__Mem645_1__ImmUnsignedi81_0,
  Convert__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_0,
  Convert__AbsMem1_0,
  Convert__Mem165_0,
  Convert__Mem325_0,
  Convert__Mem645_0,
  Convert__Imm1_1__Imm1_0,
  Convert__Reg1_1,
  Convert__Mem325_1,
  Convert__Mem645_1,
  Convert__Mem165_1,
  Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_7,
  Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_7,
  Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_7,
  Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_7,
  Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_7,
  Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_7,
  Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_7,
  Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_7,
  Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_7,
  Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_7,
  Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_7,
  Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_7,
  Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_7,
  Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_7,
  Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_7,
  Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_7,
  Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_7,
  Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_7,
  Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_7,
  Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_7,
  Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_7,
  Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_7,
  Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_7,
  Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_7,
  Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_7,
  Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_7,
  Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_3,
  Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_3,
  Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_3,
  Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_3,
  Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_3,
  Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_3,
  Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_3,
  Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_3,
  Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_3,
  Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_3,
  Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_3,
  Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_3,
  Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_3,
  Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_3,
  Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_3,
  Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_3,
  Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_3,
  Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_3,
  Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_3,
  Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_3,
  Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_3,
  Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3,
  Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_3,
  Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_3,
  Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_3,
  Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_3,
  Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_3,
  Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_3,
  Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_3,
  Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_3,
  Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_3,
  Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_3,
  Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_3,
  Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_3,
  Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_3,
  Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_3,
  Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_3,
  Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_3,
  Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_3,
  Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_3,
  Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_3,
  Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_3,
  Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_7,
  Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_7,
  Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_7,
  Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_7,
  Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_7,
  Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_7,
  Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_7,
  Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_7,
  Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_7,
  Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_7,
  Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_7,
  Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_7,
  Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_7,
  Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_7,
  Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_7,
  Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_7,
  Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_2,
  Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_2,
  Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_2,
  Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_2,
  Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_2,
  Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_2,
  Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_2,
  Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_2,
  Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_2,
  Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_2,
  Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_2,
  Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_2,
  Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_2,
  Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_2,
  Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_2,
  Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_2,
  Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_2,
  Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_2,
  Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_2,
  Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_2,
  Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_2,
  Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2,
  Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_2,
  Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_2,
  Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_2,
  Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_2,
  Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_6,
  Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_6,
  Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_6,
  Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_6,
  Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_6,
  Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_6,
  Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_6,
  Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_6,
  Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_6,
  Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_6,
  Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_6,
  Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_6,
  Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_6,
  Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_6,
  Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_6,
  Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_6,
  Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_6,
  Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_6,
  Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_6,
  Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_6,
  Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_6,
  Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_6,
  Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_6,
  Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_6,
  Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_6,
  Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_6,
  Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_6,
  Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_6,
  Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_6,
  Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_6,
  Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_6,
  Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_6,
  Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_6,
  Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_6,
  Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_6,
  Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_6,
  Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_6,
  Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_6,
  Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_6,
  Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_6,
  Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_6,
  Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_6,
  Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_2,
  Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_2,
  Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_2,
  Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_2,
  Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_2,
  Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_2,
  Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_2,
  Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_2,
  Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_2,
  Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_2,
  Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_2,
  Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_2,
  Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_2,
  Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_2,
  Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_2,
  Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_2,
  Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_4,
  Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_4,
  Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_4,
  Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_4,
  Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_4,
  Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_4,
  Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_4,
  Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_4,
  Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_4,
  Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_4,
  Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_4,
  Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_4,
  Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_4,
  Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_4,
  Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_4,
  Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_4,
  Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_4,
  Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_4,
  Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_4,
  Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_4,
  Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_4,
  Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_4,
  Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_4,
  Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_4,
  Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_4,
  Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_4,
  Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_4,
  Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_4,
  Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_4,
  Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_4,
  Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_4,
  Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_4,
  Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_4,
  Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_4,
  Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_4,
  Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_4,
  Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_4,
  Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_4,
  Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_4,
  Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_4,
  Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_4,
  Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_4,
  Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_11,
  Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_11,
  Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_11,
  Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_11,
  Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_11,
  Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_11,
  Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_11,
  Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_11,
  Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_11,
  Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_11,
  Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_11,
  Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_11,
  Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_11,
  Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_11,
  Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_11,
  Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_11,
  Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_11,
  Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_11,
  Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_11,
  Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_11,
  Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_11,
  Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_11,
  Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_11,
  Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_11,
  Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_11,
  Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_11,
  Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_11,
  Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_11,
  Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_11,
  Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_11,
  Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_11,
  Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_11,
  Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_11,
  Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_11,
  Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_11,
  Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_11,
  Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_11,
  Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_11,
  Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_11,
  Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_11,
  Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_11,
  Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_11,
  Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_15,
  Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_15,
  Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_15,
  Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_15,
  Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_15,
  Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_15,
  Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_15,
  Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_15,
  Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_15,
  Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_15,
  Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_15,
  Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_15,
  Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_15,
  Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_15,
  Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_15,
  Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_15,
  Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_15,
  Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_15,
  Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_15,
  Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_15,
  Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_15,
  Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_15,
  Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_15,
  Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_15,
  Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_15,
  Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_15,
  Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_13,
  Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_13,
  Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_13,
  Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_13,
  Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_13,
  Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_13,
  Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_13,
  Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_13,
  Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_13,
  Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_13,
  Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_13,
  Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_13,
  Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_13,
  Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_13,
  Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_13,
  Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_13,
  Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_13,
  Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_13,
  Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_13,
  Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_13,
  Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_13,
  Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_13,
  Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_13,
  Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_13,
  Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_13,
  Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_13,
  Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_13,
  Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_13,
  Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_13,
  Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_13,
  Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_13,
  Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_13,
  Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_13,
  Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_13,
  Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_13,
  Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_13,
  Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_13,
  Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_13,
  Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_13,
  Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_13,
  Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_13,
  Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_13,
  Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_15,
  Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_15,
  Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_15,
  Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_15,
  Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_15,
  Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_15,
  Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_15,
  Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_15,
  Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_15,
  Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_15,
  Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_15,
  Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_15,
  Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_15,
  Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_15,
  Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_15,
  Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_15,
  Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_12,
  Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_12,
  Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_12,
  Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_12,
  Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_12,
  Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_12,
  Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_12,
  Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_12,
  Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_12,
  Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_12,
  Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_12,
  Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_12,
  Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_12,
  Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_12,
  Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_12,
  Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_12,
  Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_12,
  Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_12,
  Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_12,
  Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_12,
  Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_12,
  Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_12,
  Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_12,
  Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_12,
  Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_12,
  Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_12,
  Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_14,
  Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_14,
  Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_14,
  Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_14,
  Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_14,
  Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_14,
  Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_14,
  Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_14,
  Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_14,
  Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_14,
  Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_14,
  Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_14,
  Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_14,
  Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_14,
  Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_14,
  Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_14,
  Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_14,
  Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_14,
  Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_14,
  Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_14,
  Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_14,
  Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_14,
  Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_14,
  Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_14,
  Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_14,
  Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_14,
  Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_14,
  Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_14,
  Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_14,
  Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_14,
  Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_14,
  Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_14,
  Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_14,
  Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_14,
  Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_14,
  Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_14,
  Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_14,
  Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_14,
  Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_14,
  Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_14,
  Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_14,
  Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_14,
  Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_12,
  Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_12,
  Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_12,
  Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_12,
  Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_12,
  Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_12,
  Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_12,
  Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_12,
  Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_12,
  Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_12,
  Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_12,
  Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_12,
  Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_12,
  Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_12,
  Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_12,
  Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_12,
  Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_5,
  Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_5,
  Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_5,
  Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_5,
  Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_5,
  Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_5,
  Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_5,
  Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_5,
  Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_5,
  Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_5,
  Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_5,
  Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_5,
  Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_5,
  Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_5,
  Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_5,
  Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_5,
  Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_5,
  Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_5,
  Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_5,
  Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_5,
  Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_5,
  Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_5,
  Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_5,
  Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_5,
  Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_5,
  Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_5,
  Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_5,
  Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_5,
  Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_5,
  Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_5,
  Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_5,
  Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_5,
  Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_5,
  Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_5,
  Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_5,
  Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_5,
  Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_5,
  Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_5,
  Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_5,
  Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_5,
  Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_5,
  Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_5,
  Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_1,
  Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_1,
  Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_1,
  Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_1,
  Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_1,
  Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_1,
  Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_1,
  Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_1,
  Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_1,
  Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_1,
  Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_1,
  Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_1,
  Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_1,
  Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_1,
  Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_1,
  Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_1,
  Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_1,
  Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_1,
  Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_1,
  Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_1,
  Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_1,
  Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_1,
  Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_1,
  Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_1,
  Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_1,
  Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_1,
  Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_1,
  Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_1,
  Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_1,
  Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_1,
  Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_1,
  Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_1,
  Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_1,
  Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_1,
  Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_1,
  Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_1,
  Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_1,
  Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_1,
  Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_1,
  Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_1,
  Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_1,
  Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_1,
  Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_9,
  Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_9,
  Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_9,
  Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_9,
  Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_9,
  Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_9,
  Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_9,
  Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_9,
  Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_9,
  Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_9,
  Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_9,
  Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_9,
  Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_9,
  Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_9,
  Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_9,
  Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_9,
  Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_9,
  Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_9,
  Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_9,
  Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_9,
  Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_9,
  Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_9,
  Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_9,
  Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_9,
  Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_9,
  Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_9,
  Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_9,
  Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_9,
  Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_9,
  Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_9,
  Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_9,
  Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_9,
  Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_9,
  Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_9,
  Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_9,
  Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_9,
  Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_9,
  Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_9,
  Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_9,
  Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_9,
  Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_9,
  Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_9,
  Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_0,
  Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_0,
  Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_0,
  Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_0,
  Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_0,
  Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_0,
  Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_0,
  Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_0,
  Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_0,
  Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_0,
  Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_0,
  Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_0,
  Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_0,
  Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_0,
  Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_0,
  Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_0,
  Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_0,
  Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_0,
  Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_0,
  Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_0,
  Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_0,
  Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_0,
  Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_0,
  Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_0,
  Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_0,
  Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_0,
  Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_0,
  Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_0,
  Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_0,
  Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_0,
  Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_0,
  Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_0,
  Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_0,
  Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_0,
  Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_0,
  Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_0,
  Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_0,
  Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_0,
  Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_0,
  Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_0,
  Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_0,
  Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_0,
  Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_8,
  Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_8,
  Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_8,
  Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_8,
  Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_8,
  Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_8,
  Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_8,
  Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_8,
  Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_8,
  Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_8,
  Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_8,
  Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_8,
  Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_8,
  Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_8,
  Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_8,
  Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_8,
  Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_8,
  Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_8,
  Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_8,
  Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_8,
  Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_8,
  Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_8,
  Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_8,
  Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_8,
  Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_8,
  Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_8,
  Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_8,
  Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_8,
  Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_8,
  Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_8,
  Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_8,
  Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_8,
  Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_8,
  Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_8,
  Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_8,
  Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_8,
  Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_8,
  Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_8,
  Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_8,
  Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_8,
  Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_8,
  Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_8,
  Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_10,
  Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_10,
  Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_10,
  Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_10,
  Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_10,
  Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_10,
  Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_10,
  Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_10,
  Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_10,
  Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_10,
  Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_10,
  Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_10,
  Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_10,
  Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_10,
  Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_10,
  Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_10,
  Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_10,
  Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_10,
  Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_10,
  Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_10,
  Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_10,
  Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_10,
  Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_10,
  Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_10,
  Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_10,
  Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_10,
  Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_10,
  Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_10,
  Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_10,
  Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_10,
  Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_10,
  Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_10,
  Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_10,
  Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_10,
  Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_10,
  Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_10,
  Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_10,
  Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_10,
  Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_10,
  Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_10,
  Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_10,
  Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_10,
  Convert__Reg1_0__Reg1_1__imm_95_7,
  Convert__Reg1_0__Mem165_1__imm_95_7,
  Convert__Reg1_0__Mem325_1__imm_95_7,
  Convert__Reg1_0__Mem645_1__imm_95_7,
  Convert__Mem165_0__Reg1_1__imm_95_7,
  Convert__Mem325_0__Reg1_1__imm_95_7,
  Convert__Mem645_0__Reg1_1__imm_95_7,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_7,
  Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_7,
  Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_7,
  Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_7,
  Convert__Reg1_0__Reg1_1__imm_95_3,
  Convert__Reg1_0__Mem165_1__imm_95_3,
  Convert__Reg1_0__Mem325_1__imm_95_3,
  Convert__Reg1_0__Mem645_1__imm_95_3,
  Convert__Mem165_0__Reg1_1__imm_95_3,
  Convert__Mem325_0__Reg1_1__imm_95_3,
  Convert__Mem645_0__Reg1_1__imm_95_3,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_3,
  Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_3,
  Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_3,
  Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_3,
  Convert__Reg1_1__Reg1_0__imm_95_3,
  Convert__Mem325_1__Reg1_0__imm_95_3,
  Convert__Reg1_1__Mem325_0__imm_95_3,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_3,
  Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_3,
  Convert__Mem645_1__Reg1_0__imm_95_3,
  Convert__Reg1_1__Mem645_0__imm_95_3,
  Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_3,
  Convert__Mem165_1__Reg1_0__imm_95_3,
  Convert__Reg1_1__Mem165_0__imm_95_3,
  Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_3,
  Convert__Reg1_1__Reg1_0__imm_95_7,
  Convert__Mem325_1__Reg1_0__imm_95_7,
  Convert__Reg1_1__Mem325_0__imm_95_7,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_7,
  Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_7,
  Convert__Mem645_1__Reg1_0__imm_95_7,
  Convert__Reg1_1__Mem645_0__imm_95_7,
  Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_7,
  Convert__Mem165_1__Reg1_0__imm_95_7,
  Convert__Reg1_1__Mem165_0__imm_95_7,
  Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_7,
  Convert__Reg1_0__Reg1_1__imm_95_2,
  Convert__Reg1_0__Mem165_1__imm_95_2,
  Convert__Reg1_0__Mem325_1__imm_95_2,
  Convert__Reg1_0__Mem645_1__imm_95_2,
  Convert__Mem165_0__Reg1_1__imm_95_2,
  Convert__Mem325_0__Reg1_1__imm_95_2,
  Convert__Mem645_0__Reg1_1__imm_95_2,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_2,
  Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_2,
  Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_2,
  Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_2,
  Convert__Reg1_0__Reg1_1__imm_95_6,
  Convert__Reg1_0__Mem165_1__imm_95_6,
  Convert__Reg1_0__Mem325_1__imm_95_6,
  Convert__Reg1_0__Mem645_1__imm_95_6,
  Convert__Mem165_0__Reg1_1__imm_95_6,
  Convert__Mem325_0__Reg1_1__imm_95_6,
  Convert__Mem645_0__Reg1_1__imm_95_6,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_6,
  Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_6,
  Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_6,
  Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_6,
  Convert__Reg1_1__Reg1_0__imm_95_6,
  Convert__Mem325_1__Reg1_0__imm_95_6,
  Convert__Reg1_1__Mem325_0__imm_95_6,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_6,
  Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_6,
  Convert__Mem645_1__Reg1_0__imm_95_6,
  Convert__Reg1_1__Mem645_0__imm_95_6,
  Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_6,
  Convert__Mem165_1__Reg1_0__imm_95_6,
  Convert__Reg1_1__Mem165_0__imm_95_6,
  Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_6,
  Convert__Reg1_1__Reg1_0__imm_95_2,
  Convert__Mem325_1__Reg1_0__imm_95_2,
  Convert__Reg1_1__Mem325_0__imm_95_2,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_2,
  Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_2,
  Convert__Mem645_1__Reg1_0__imm_95_2,
  Convert__Reg1_1__Mem645_0__imm_95_2,
  Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_2,
  Convert__Mem165_1__Reg1_0__imm_95_2,
  Convert__Reg1_1__Mem165_0__imm_95_2,
  Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_2,
  Convert__Reg1_0__Reg1_1__imm_95_4,
  Convert__Reg1_0__Mem165_1__imm_95_4,
  Convert__Reg1_0__Mem325_1__imm_95_4,
  Convert__Reg1_0__Mem645_1__imm_95_4,
  Convert__Mem165_0__Reg1_1__imm_95_4,
  Convert__Mem325_0__Reg1_1__imm_95_4,
  Convert__Mem645_0__Reg1_1__imm_95_4,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_4,
  Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_4,
  Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_4,
  Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_4,
  Convert__Reg1_1__Reg1_0__imm_95_4,
  Convert__Mem325_1__Reg1_0__imm_95_4,
  Convert__Reg1_1__Mem325_0__imm_95_4,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_4,
  Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_4,
  Convert__Mem645_1__Reg1_0__imm_95_4,
  Convert__Reg1_1__Mem645_0__imm_95_4,
  Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_4,
  Convert__Mem165_1__Reg1_0__imm_95_4,
  Convert__Reg1_1__Mem165_0__imm_95_4,
  Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_4,
  Convert__Reg1_0__Reg1_1__imm_95_15,
  Convert__Reg1_0__Mem165_1__imm_95_15,
  Convert__Reg1_0__Mem325_1__imm_95_15,
  Convert__Reg1_0__Mem645_1__imm_95_15,
  Convert__Mem165_0__Reg1_1__imm_95_15,
  Convert__Mem325_0__Reg1_1__imm_95_15,
  Convert__Mem645_0__Reg1_1__imm_95_15,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_15,
  Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_15,
  Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_15,
  Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_15,
  Convert__Reg1_0__Reg1_1__imm_95_13,
  Convert__Reg1_0__Mem165_1__imm_95_13,
  Convert__Reg1_0__Mem325_1__imm_95_13,
  Convert__Reg1_0__Mem645_1__imm_95_13,
  Convert__Mem165_0__Reg1_1__imm_95_13,
  Convert__Mem325_0__Reg1_1__imm_95_13,
  Convert__Mem645_0__Reg1_1__imm_95_13,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_13,
  Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_13,
  Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_13,
  Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_13,
  Convert__Reg1_1__Reg1_0__imm_95_13,
  Convert__Mem325_1__Reg1_0__imm_95_13,
  Convert__Reg1_1__Mem325_0__imm_95_13,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_13,
  Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_13,
  Convert__Mem645_1__Reg1_0__imm_95_13,
  Convert__Reg1_1__Mem645_0__imm_95_13,
  Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_13,
  Convert__Mem165_1__Reg1_0__imm_95_13,
  Convert__Reg1_1__Mem165_0__imm_95_13,
  Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_13,
  Convert__Reg1_1__Reg1_0__imm_95_15,
  Convert__Mem325_1__Reg1_0__imm_95_15,
  Convert__Reg1_1__Mem325_0__imm_95_15,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_15,
  Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_15,
  Convert__Mem645_1__Reg1_0__imm_95_15,
  Convert__Reg1_1__Mem645_0__imm_95_15,
  Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_15,
  Convert__Mem165_1__Reg1_0__imm_95_15,
  Convert__Reg1_1__Mem165_0__imm_95_15,
  Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_15,
  Convert__Reg1_0__Reg1_1__imm_95_12,
  Convert__Reg1_0__Mem165_1__imm_95_12,
  Convert__Reg1_0__Mem325_1__imm_95_12,
  Convert__Reg1_0__Mem645_1__imm_95_12,
  Convert__Mem165_0__Reg1_1__imm_95_12,
  Convert__Mem325_0__Reg1_1__imm_95_12,
  Convert__Mem645_0__Reg1_1__imm_95_12,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_12,
  Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_12,
  Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_12,
  Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_12,
  Convert__Reg1_0__Reg1_1__imm_95_14,
  Convert__Reg1_0__Mem165_1__imm_95_14,
  Convert__Reg1_0__Mem325_1__imm_95_14,
  Convert__Reg1_0__Mem645_1__imm_95_14,
  Convert__Mem165_0__Reg1_1__imm_95_14,
  Convert__Mem325_0__Reg1_1__imm_95_14,
  Convert__Mem645_0__Reg1_1__imm_95_14,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_14,
  Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_14,
  Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_14,
  Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_14,
  Convert__Reg1_1__Reg1_0__imm_95_14,
  Convert__Mem325_1__Reg1_0__imm_95_14,
  Convert__Reg1_1__Mem325_0__imm_95_14,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_14,
  Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_14,
  Convert__Mem645_1__Reg1_0__imm_95_14,
  Convert__Reg1_1__Mem645_0__imm_95_14,
  Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_14,
  Convert__Mem165_1__Reg1_0__imm_95_14,
  Convert__Reg1_1__Mem165_0__imm_95_14,
  Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_14,
  Convert__Reg1_1__Reg1_0__imm_95_12,
  Convert__Mem325_1__Reg1_0__imm_95_12,
  Convert__Reg1_1__Mem325_0__imm_95_12,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_12,
  Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_12,
  Convert__Mem645_1__Reg1_0__imm_95_12,
  Convert__Reg1_1__Mem645_0__imm_95_12,
  Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_12,
  Convert__Mem165_1__Reg1_0__imm_95_12,
  Convert__Reg1_1__Mem165_0__imm_95_12,
  Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_12,
  Convert__Reg1_0__Reg1_1__imm_95_5,
  Convert__Reg1_0__Mem165_1__imm_95_5,
  Convert__Reg1_0__Mem325_1__imm_95_5,
  Convert__Reg1_0__Mem645_1__imm_95_5,
  Convert__Mem165_0__Reg1_1__imm_95_5,
  Convert__Mem325_0__Reg1_1__imm_95_5,
  Convert__Mem645_0__Reg1_1__imm_95_5,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_5,
  Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_5,
  Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_5,
  Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_5,
  Convert__Reg1_1__Reg1_0__imm_95_5,
  Convert__Mem325_1__Reg1_0__imm_95_5,
  Convert__Reg1_1__Mem325_0__imm_95_5,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_5,
  Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_5,
  Convert__Mem645_1__Reg1_0__imm_95_5,
  Convert__Reg1_1__Mem645_0__imm_95_5,
  Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_5,
  Convert__Mem165_1__Reg1_0__imm_95_5,
  Convert__Reg1_1__Mem165_0__imm_95_5,
  Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_5,
  Convert__Reg1_0__Reg1_1__imm_95_1,
  Convert__Reg1_0__Mem165_1__imm_95_1,
  Convert__Reg1_0__Mem325_1__imm_95_1,
  Convert__Reg1_0__Mem645_1__imm_95_1,
  Convert__Mem165_0__Reg1_1__imm_95_1,
  Convert__Mem325_0__Reg1_1__imm_95_1,
  Convert__Mem645_0__Reg1_1__imm_95_1,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_1,
  Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_1,
  Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_1,
  Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_1,
  Convert__Reg1_1__Reg1_0__imm_95_1,
  Convert__Mem325_1__Reg1_0__imm_95_1,
  Convert__Reg1_1__Mem325_0__imm_95_1,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_1,
  Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_1,
  Convert__Mem645_1__Reg1_0__imm_95_1,
  Convert__Reg1_1__Mem645_0__imm_95_1,
  Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_1,
  Convert__Mem165_1__Reg1_0__imm_95_1,
  Convert__Reg1_1__Mem165_0__imm_95_1,
  Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_1,
  Convert__Reg1_0__Reg1_1__imm_95_11,
  Convert__Reg1_0__Mem165_1__imm_95_11,
  Convert__Reg1_0__Mem325_1__imm_95_11,
  Convert__Reg1_0__Mem645_1__imm_95_11,
  Convert__Mem165_0__Reg1_1__imm_95_11,
  Convert__Mem325_0__Reg1_1__imm_95_11,
  Convert__Mem645_0__Reg1_1__imm_95_11,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_11,
  Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_11,
  Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_11,
  Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_11,
  Convert__Reg1_1__Reg1_0__imm_95_11,
  Convert__Mem325_1__Reg1_0__imm_95_11,
  Convert__Reg1_1__Mem325_0__imm_95_11,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_11,
  Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_11,
  Convert__Mem645_1__Reg1_0__imm_95_11,
  Convert__Reg1_1__Mem645_0__imm_95_11,
  Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_11,
  Convert__Mem165_1__Reg1_0__imm_95_11,
  Convert__Reg1_1__Mem165_0__imm_95_11,
  Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_11,
  Convert__Reg1_0__Reg1_1__imm_95_9,
  Convert__Reg1_0__Mem165_1__imm_95_9,
  Convert__Reg1_0__Mem325_1__imm_95_9,
  Convert__Reg1_0__Mem645_1__imm_95_9,
  Convert__Mem165_0__Reg1_1__imm_95_9,
  Convert__Mem325_0__Reg1_1__imm_95_9,
  Convert__Mem645_0__Reg1_1__imm_95_9,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_9,
  Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_9,
  Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_9,
  Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_9,
  Convert__Reg1_1__Reg1_0__imm_95_9,
  Convert__Mem325_1__Reg1_0__imm_95_9,
  Convert__Reg1_1__Mem325_0__imm_95_9,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_9,
  Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_9,
  Convert__Mem645_1__Reg1_0__imm_95_9,
  Convert__Reg1_1__Mem645_0__imm_95_9,
  Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_9,
  Convert__Mem165_1__Reg1_0__imm_95_9,
  Convert__Reg1_1__Mem165_0__imm_95_9,
  Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_9,
  Convert__Reg1_0__Reg1_1__imm_95_0,
  Convert__Reg1_0__Mem165_1__imm_95_0,
  Convert__Reg1_0__Mem325_1__imm_95_0,
  Convert__Reg1_0__Mem645_1__imm_95_0,
  Convert__Mem165_0__Reg1_1__imm_95_0,
  Convert__Mem325_0__Reg1_1__imm_95_0,
  Convert__Mem645_0__Reg1_1__imm_95_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0,
  Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_0,
  Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_0,
  Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_0,
  Convert__Reg1_1__Reg1_0__imm_95_0,
  Convert__Mem325_1__Reg1_0__imm_95_0,
  Convert__Reg1_1__Mem325_0__imm_95_0,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_0,
  Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_0,
  Convert__Mem645_1__Reg1_0__imm_95_0,
  Convert__Reg1_1__Mem645_0__imm_95_0,
  Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_0,
  Convert__Mem165_1__Reg1_0__imm_95_0,
  Convert__Reg1_1__Mem165_0__imm_95_0,
  Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_0,
  Convert__Reg1_0__Reg1_1__imm_95_10,
  Convert__Reg1_0__Mem165_1__imm_95_10,
  Convert__Reg1_0__Mem325_1__imm_95_10,
  Convert__Reg1_0__Mem645_1__imm_95_10,
  Convert__Mem165_0__Reg1_1__imm_95_10,
  Convert__Mem325_0__Reg1_1__imm_95_10,
  Convert__Mem645_0__Reg1_1__imm_95_10,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_10,
  Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_10,
  Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_10,
  Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_10,
  Convert__Reg1_1__Reg1_0__imm_95_10,
  Convert__Mem325_1__Reg1_0__imm_95_10,
  Convert__Reg1_1__Mem325_0__imm_95_10,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_10,
  Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_10,
  Convert__Mem645_1__Reg1_0__imm_95_10,
  Convert__Reg1_1__Mem645_0__imm_95_10,
  Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_10,
  Convert__Mem165_1__Reg1_0__imm_95_10,
  Convert__Reg1_1__Mem165_0__imm_95_10,
  Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_10,
  Convert__Reg1_0__Reg1_1__imm_95_8,
  Convert__Reg1_0__Mem165_1__imm_95_8,
  Convert__Reg1_0__Mem325_1__imm_95_8,
  Convert__Reg1_0__Mem645_1__imm_95_8,
  Convert__Mem165_0__Reg1_1__imm_95_8,
  Convert__Mem325_0__Reg1_1__imm_95_8,
  Convert__Mem645_0__Reg1_1__imm_95_8,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_8,
  Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_8,
  Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_8,
  Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_8,
  Convert__Reg1_1__Reg1_0__imm_95_8,
  Convert__Mem325_1__Reg1_0__imm_95_8,
  Convert__Reg1_1__Mem325_0__imm_95_8,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_8,
  Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_8,
  Convert__Mem645_1__Reg1_0__imm_95_8,
  Convert__Reg1_1__Mem645_0__imm_95_8,
  Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_8,
  Convert__Mem165_1__Reg1_0__imm_95_8,
  Convert__Reg1_1__Mem165_0__imm_95_8,
  Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_8,
  Convert__Mem85_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_7,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_7,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_7,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_3,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_3,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_3,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_3,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_3,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_3,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_3,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_3,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_7,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_7,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_7,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_2,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_2,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_2,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_2,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_6,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_6,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_6,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_6,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_6,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_6,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_6,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_6,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_2,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_2,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_2,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_2,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_4,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_4,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_4,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_4,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_4,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_4,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_4,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_4,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_15,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_15,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_15,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_15,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_13,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_13,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_13,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_13,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_13,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_13,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_13,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_13,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_15,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_15,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_15,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_15,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_12,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_12,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_12,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_12,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_14,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_14,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_14,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_14,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_14,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_14,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_14,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_14,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_12,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_12,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_12,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_12,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_5,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_5,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_5,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_5,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_5,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_5,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_5,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_5,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_1,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_1,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_1,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_1,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_1,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_1,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_1,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_1,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_11,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_11,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_11,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_11,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_11,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_11,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_11,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_11,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_9,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_9,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_9,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_9,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_9,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_9,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_9,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_9,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_0,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_0,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_0,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_0,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_0,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_0,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_0,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_10,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_10,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_10,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_10,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_10,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_10,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_10,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_10,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_8,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_8,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_8,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_8,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_8,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_8,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_8,
  Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_8,
  Convert__regAX__ImmSExti16i81_1,
  Convert__regEAX__ImmSExti32i81_1,
  Convert__regRAX__ImmSExti64i81_1,
  Convert__Reg1_0__ImmSExti16i81_1,
  Convert__Reg1_0__Imm1_1,
  Convert__Reg1_0__ImmSExti32i81_1,
  Convert__Reg1_0__ImmSExti64i81_1,
  Convert__Reg1_0__ImmSExti64i321_1,
  Convert__Reg1_0__Mem85_1,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_3,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_3,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_3,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_3,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_7,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_7,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_7,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_7,
  Convert__Reg1_1__Imm1_0,
  Convert__Reg1_1__Mem85_0,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_6,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_6,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_6,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_6,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_2,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_2,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_2,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_2,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_4,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_4,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_4,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_4,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_13,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_13,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_13,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_13,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_15,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_15,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_15,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_15,
  Convert__regEAX__ImmSExti32i81_0,
  Convert__Reg1_1__ImmSExti32i81_0,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_14,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_14,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_14,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_14,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_12,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_12,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_12,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_12,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_5,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_5,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_5,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_5,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_1,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_1,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_1,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_1,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_11,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_11,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_11,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_11,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_9,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_9,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_9,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_9,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_0,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_0,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_0,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_0,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_10,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_10,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_10,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_10,
  Convert__regRAX__ImmSExti64i81_0,
  Convert__Reg1_1__ImmSExti64i81_0,
  Convert__Reg1_1__ImmSExti64i321_0,
  Convert__DstIdx161_1__SrcIdx162_0,
  Convert__DstIdx321_1__SrcIdx322_0,
  Convert__DstIdx641_1__SrcIdx642_0,
  Convert__DstIdx81_1__SrcIdx82_0,
  Convert__DstIdx81_0__SrcIdx82_1,
  Convert__Reg1_0__Tie0_1_1__Mem645_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0_1_1__Mem645_1__ImmUnsignedi81_0,
  Convert__DstIdx321_0__SrcIdx322_1,
  Convert__DstIdx641_0__SrcIdx642_1,
  Convert__Reg1_0__Tie0_1_1__Mem325_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0_1_1__Mem325_1__ImmUnsignedi81_0,
  Convert__DstIdx161_0__SrcIdx162_1,
  Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_8,
  Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_8,
  Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_8,
  Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_8,
  Convert__regAX__ImmSExti16i81_0,
  Convert__Reg1_1__ImmSExti16i81_0,
  Convert__Reg1_1__Mem165_0,
  Convert__Mem1285_0,
  Convert__Mem85_1,
  Convert__Reg1_0__Mem512_GR165_1,
  Convert__Reg1_0__Mem512_GR325_1,
  Convert__Reg1_0__Mem512_GR645_1,
  Convert__Reg1_1__Mem512_GR165_0,
  Convert__Reg1_1__Mem512_GR325_0,
  Convert__Reg1_1__Mem512_GR645_0,
  Convert__Imm1_0__Imm1_1,
  Convert__GR32orGR641_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem325_2__Reg1_1__ImmUnsignedi81_0,
  Convert__GR32orGR641_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Mem325_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Tie0_1_1__ImmUnsignedi81_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0_3_3__ImmUnsignedi81_1__ImmUnsignedi81_0,
  Convert__regST1,
  Convert__regST0,
  Convert__Mem805_0,
  Convert__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_0__ImmSExti16i81_1,
  Convert__Reg1_0__Reg1_0__Imm1_1,
  Convert__Reg1_0__Reg1_0__ImmSExti32i81_1,
  Convert__Reg1_0__Reg1_0__ImmSExti64i81_1,
  Convert__Reg1_0__Reg1_0__ImmSExti64i321_1,
  Convert__Reg1_1__Reg1_1__ImmSExti32i81_0,
  Convert__Reg1_1__Reg1_1__Imm1_0,
  Convert__Reg1_1__Reg1_1__ImmSExti64i81_0,
  Convert__Reg1_1__Reg1_1__ImmSExti64i321_0,
  Convert__Reg1_1__Reg1_1__ImmSExti16i81_0,
  Convert__ImmUnsignedi81_1,
  Convert__DstIdx161_0,
  Convert__DstIdx321_0,
  Convert__DstIdx81_0,
  Convert__DstIdx81_1,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__ImmUnsignedi81_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Tie0_4_4__Reg1_2__ImmUnsignedi81_1__ImmUnsignedi81_0,
  Convert__DstIdx321_1,
  Convert__DstIdx161_1,
  Convert__AbsMem1_0__imm_95_7,
  Convert__AbsMem1_0__imm_95_3,
  Convert__AbsMem1_0__imm_95_2,
  Convert__AbsMem1_0__imm_95_6,
  Convert__AbsMem1_0__imm_95_4,
  Convert__AbsMem1_0__imm_95_15,
  Convert__AbsMem1_0__imm_95_13,
  Convert__AbsMem1_0__imm_95_12,
  Convert__AbsMem1_0__imm_95_14,
  Convert__AbsMem1_0__imm_95_5,
  Convert__AbsMem1_0__imm_95_1,
  Convert__AbsMem1_0__imm_95_11,
  Convert__AbsMem1_0__imm_95_9,
  Convert__AbsMem1_0__imm_95_0,
  Convert__AbsMem1_0__imm_95_10,
  Convert__AbsMem1_0__imm_95_8,
  Convert__Reg1_0__GR16orGR32orGR641_1,
  Convert__Reg1_1__GR16orGR32orGR641_0,
  Convert__Mem5_1,
  Convert__Reg1_0__Mem5_1,
  Convert__Reg1_1__Mem5_0,
  Convert__SrcIdx162_0,
  Convert__SrcIdx322_0,
  Convert__SrcIdx642_0,
  Convert__SrcIdx82_0,
  Convert__SrcIdx82_1,
  Convert__SrcIdx162_1,
  Convert__SrcIdx322_1,
  Convert__SrcIdx642_1,
  Convert__MemOffs16_82_1,
  Convert__MemOffs32_82_1,
  Convert__MemOffs16_162_1,
  Convert__MemOffs32_162_1,
  Convert__MemOffs16_322_1,
  Convert__MemOffs32_322_1,
  Convert__MemOffs32_642_1,
  Convert__MemOffs16_162_0,
  Convert__MemOffs16_322_0,
  Convert__MemOffs16_82_0,
  Convert__MemOffs32_162_0,
  Convert__MemOffs32_322_0,
  Convert__MemOffs32_642_0,
  Convert__MemOffs32_82_0,
  Convert__MemOffs64_82_1,
  Convert__MemOffs64_162_1,
  Convert__MemOffs64_322_1,
  Convert__MemOffs64_642_1,
  Convert__MemOffs64_162_0,
  Convert__MemOffs64_322_0,
  Convert__MemOffs64_642_0,
  Convert__MemOffs64_82_0,
  Convert__Mem1285_1__Reg1_0,
  Convert__Mem1285_0__Reg1_1,
  Convert__GR32orGR641_1__Reg1_0,
  Convert__GR32orGR641_0__Reg1_1,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_17,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_17,
  Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_17,
  Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_17,
  Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_1,
  Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_1,
  Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_16,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_16,
  Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_16,
  Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_16,
  Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_0,
  Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_0,
  Convert__Mem85_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem85_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Mem645_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem645_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Mem165_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem165_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Tie0_1_1__GR32orGR641_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Tie0_1_1__Mem85_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0_1_1__GR32orGR641_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Tie0_1_1__Mem85_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Mem165_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0_1_1__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Mem645_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0,
  Convert__ImmSExti64i81_0,
  Convert__ImmSExti16i81_0,
  Convert__ImmSExti32i81_0,
  Convert__Mem85_0__ImmUnsignedi81_1,
  Convert__Reg1_0__Mem165_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Mem325_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Mem85_1__ImmUnsignedi81_2,
  Convert__Reg1_1__Tie0_2_2,
  Convert__Mem85_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Reg1_1,
  Convert__Reg1_2__Mem85_1,
  Convert__Reg1_2__Mem85_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Mem325_1,
  Convert__Reg1_2__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Mem645_1,
  Convert__Reg1_2__Mem165_1,
  Convert__Reg1_2__Mem165_1__ImmUnsignedi81_0,
  Convert__DstIdx641_0,
  Convert__DstIdx641_1,
  Convert__Reg1_0__imm_95_7,
  Convert__Mem85_0__imm_95_7,
  Convert__Reg1_0__imm_95_3,
  Convert__Mem85_0__imm_95_3,
  Convert__Reg1_0__imm_95_2,
  Convert__Mem85_0__imm_95_2,
  Convert__Reg1_0__imm_95_6,
  Convert__Mem85_0__imm_95_6,
  Convert__Reg1_0__imm_95_4,
  Convert__Mem85_0__imm_95_4,
  Convert__Reg1_0__imm_95_15,
  Convert__Mem85_0__imm_95_15,
  Convert__Reg1_0__imm_95_13,
  Convert__Mem85_0__imm_95_13,
  Convert__Reg1_0__imm_95_12,
  Convert__Mem85_0__imm_95_12,
  Convert__Reg1_0__imm_95_14,
  Convert__Mem85_0__imm_95_14,
  Convert__Reg1_0__imm_95_5,
  Convert__Mem85_0__imm_95_5,
  Convert__Reg1_0__imm_95_1,
  Convert__Mem85_0__imm_95_1,
  Convert__Reg1_0__imm_95_11,
  Convert__Mem85_0__imm_95_11,
  Convert__Reg1_0__imm_95_9,
  Convert__Mem85_0__imm_95_9,
  Convert__Reg1_0__imm_95_0,
  Convert__Mem85_0__imm_95_0,
  Convert__Reg1_0__imm_95_10,
  Convert__Mem85_0__imm_95_10,
  Convert__Reg1_0__imm_95_8,
  Convert__Mem85_0__imm_95_8,
  Convert__Reg1_0__Reg1_1__Reg1_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Mem165_1__Reg1_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Mem325_1__Reg1_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Mem645_1__Reg1_2__ImmUnsignedi81_3,
  Convert__Reg1_2__Tie0_3_3__Reg1_1,
  Convert__Mem325_2__Reg1_1,
  Convert__Reg1_2__Tie0_3_3__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_2__Reg1_1,
  Convert__Reg1_3__Mem325_2__Reg1_1,
  Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Mem325_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem645_2__Reg1_1,
  Convert__Reg1_3__Mem645_2__Reg1_1,
  Convert__Reg1_3__Mem645_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem165_2__Reg1_1,
  Convert__Reg1_3__Mem165_2__Reg1_1,
  Convert__Reg1_3__Mem165_2__Reg1_1__ImmUnsignedi81_0,
  Convert__TILEPair1_0__SibMem5_1,
  Convert__TILEPair1_1__SibMem5_0,
  Convert__Reg1_2__Tie0_3_3__Reg1_1__Reg1_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2,
  Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0,
  Convert__Reg1_0__SibMem5_1,
  Convert__Reg1_1__SibMem5_0,
  Convert__SibMem5_1__Reg1_0,
  Convert__SibMem5_0__Reg1_1,
  Convert__GR32orGR641_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem1285_2,
  Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem1285_5,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem1285_6,
  Convert__Reg1_0__Reg1_1__Mem1285_2,
  Convert__Reg1_0__Reg1_1__Mem2565_2,
  Convert__Reg1_0__Reg1_1__Mem5125_2,
  Convert__Reg1_2__Reg1_1__Mem1285_0,
  Convert__Reg1_2__Reg1_1__Mem2565_0,
  Convert__Reg1_2__Reg1_1__Mem5125_0,
  Convert__Reg1_3__Reg1_2__Mem165_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem2565_5,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem5125_5,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem1285_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem165_5,
  Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem2565_6,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem5125_6,
  Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem165_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem165_6,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem165_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__AVX512RC1_3,
  Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0,
  Convert__Reg1_3__Reg1_2__Mem645_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem645_5,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5__AVX512RC1_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6,
  Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__AVX512RC1_7,
  Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0,
  Convert__Reg1_3__Reg1_2__Mem325_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem325_5,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__Mem645_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem165_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__Mem165_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem325_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__Mem325_0,
  Convert__Reg1_0__Reg1_1__Mem1285_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Reg1_1__Mem2565_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Reg1_1__Mem5125_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__Mem325_2__ImmUnsignedi81_4,
  Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem1285_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem2565_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem5125_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem1285_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem2565_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem5125_6__ImmUnsignedi81_7,
  Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_8,
  Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__Mem645_2__ImmUnsignedi81_4,
  Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_7,
  Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_8,
  Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem1285_5,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem2565_5,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem5125_5,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5,
  Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3,
  Convert__Reg1_0__Reg1_1__Mem1285_2__Reg1_3,
  Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0,
  Convert__Reg1_0__Reg1_1__Mem2565_2__Reg1_3,
  Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem645_4,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0,
  Convert__Reg1_1__Reg1_3__Reg1_0,
  Convert__Reg1_0__Reg1_2__Reg1_5,
  Convert__Reg1_0__Reg1_2__Mem645_5,
  Convert__Reg1_1__Reg1_3__Mem645_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem1285_4,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0,
  Convert__Reg1_0__Reg1_2__Mem1285_5,
  Convert__Reg1_1__Reg1_3__Mem1285_0,
  Convert__Reg1_0__Mem2565_1,
  Convert__Reg1_1__Mem2565_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem2565_4,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0,
  Convert__Reg1_0__Reg1_2__Mem2565_5,
  Convert__Reg1_1__Reg1_3__Mem2565_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem325_4,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem325_0,
  Convert__Reg1_0__Reg1_2__Mem325_5,
  Convert__Reg1_1__Reg1_3__Mem325_0,
  Convert__Reg1_0__Reg1_1__Mem165_2__ImmUnsignedi81_4,
  Convert__Reg1_4__Reg1_3__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem1285_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem2565_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem5125_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem165_5__ImmUnsignedi81_7,
  Convert__Reg1_4__Reg1_6__Reg1_3__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__ImmUnsignedi81_4,
  Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_7,
  Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_1__Mem645_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Reg1_2__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__Mem165_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Reg1_2__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem165_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__Mem325_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Reg1_2__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_1__ImmUnsignedi81_0,
  Convert__Mem2565_1__Reg1_0,
  Convert__Mem5125_1__Reg1_0,
  Convert__Mem2565_0__Reg1_1,
  Convert__Mem5125_0__Reg1_1,
  Convert__Mem1285_1__Reg1_3__Reg1_0,
  Convert__Mem2565_1__Reg1_3__Reg1_0,
  Convert__Mem5125_1__Reg1_3__Reg1_0,
  Convert__Mem1285_0__Reg1_2__Reg1_4,
  Convert__Mem2565_0__Reg1_2__Reg1_4,
  Convert__Mem5125_0__Reg1_2__Reg1_4,
  Convert__Reg1_0__Mem5125_1,
  Convert__Reg1_1__Mem5125_0,
  Convert__Reg1_2__Mem165_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem5125_4,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem165_4,
  Convert__Reg1_0__Reg1_2__Mem5125_5,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0,
  Convert__Reg1_1__Reg1_3__Mem5125_0,
  Convert__Reg1_0__Reg1_2__Mem165_5,
  Convert__Reg1_2__Reg1_4__Mem165_0,
  Convert__Reg1_2__Mem325_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0,
  Convert__Reg1_2__Reg1_4__Mem325_0,
  Convert__Reg1_0__Reg1_1__AVX512RC1_2,
  Convert__Reg1_2__Reg1_1__AVX512RC1_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__AVX512RC1_5,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__AVX512RC1_6,
  Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0,
  Convert__Reg1_2__Mem645_0,
  Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0,
  Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0,
  Convert__Reg1_2__Reg1_4__Mem645_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1,
  Convert__Reg1_2__Reg1_4__Reg1_1,
  Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem2565_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem1285_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Mem2565_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Reg1_1__ImmUnsignedi81_3,
  Convert__Reg1_3__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__ImmUnsignedi81_5,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem645_2__Reg1_4__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem1285_2__Reg1_4__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem2565_2__Reg1_4__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem1285_0__Reg1_2__Reg1_4__ImmUnsignedi81_5,
  Convert__Mem2565_0__Reg1_2__Reg1_4__ImmUnsignedi81_5,
  Convert__Mem645_0__Reg1_2__Reg1_4__ImmUnsignedi81_5,
  Convert__Reg1_0__Reg1_2__Reg1_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__ImmUnsignedi81_7,
  Convert__Reg1_3__Reg1_5__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1,
  Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1,
  Convert__Reg1_0__Reg1_1__Reg1_3__AVX512RC1_2,
  Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1,
  Convert__Reg1_2__Tie0_3_3__Reg1_4__Reg1_1,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem2565_2,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem5125_2,
  Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem325_2,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem2565_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem5125_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem325_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__AVX512RC1_3,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6__AVX512RC1_7,
  Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem325_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem1285_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem2565_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem5125_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem645_2__ImmUnsignedi81_4,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__ImmUnsignedi81_4,
  Convert__Reg1_4__Tie0_1_1__Reg1_3__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_4__Tie0_1_1__Reg1_3__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem1285_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem2565_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem5125_6__ImmUnsignedi81_7,
  Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_8,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_8,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem325_2__ImmUnsignedi81_4,
  Convert__Reg1_4__Tie0_1_1__Reg1_3__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_8,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem645_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem325_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem165_2,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem165_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem165_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem645_2,
  Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem645_6,
  Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem645_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem165_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem1285_3,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem2565_3,
  Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0,
  Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem645_3,
  Convert__Reg1_0__Reg1_1__Mem645_2__Reg1_3,
  Convert__Reg1_3__Reg1_2__Mem645_1__Reg1_0,
  Convert__Reg1_3__Reg1_2__Reg1_1__Mem645_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem325_3,
  Convert__Reg1_0__Reg1_1__Mem325_2__Reg1_3,
  Convert__Reg1_3__Reg1_2__Mem325_1__Reg1_0,
  Convert__Reg1_3__Reg1_2__Reg1_1__Mem325_0,
  Convert__Reg1_0__Mem2565_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Mem5125_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Mem165_1__ImmUnsignedi81_3,
  Convert__Reg1_3__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__ImmUnsignedi81_5,
  Convert__Reg1_0__Reg1_2__Mem1285_4__ImmUnsignedi81_5,
  Convert__Reg1_0__Reg1_2__Mem2565_4__ImmUnsignedi81_5,
  Convert__Reg1_0__Reg1_2__Mem5125_4__ImmUnsignedi81_5,
  Convert__Reg1_0__Reg1_2__Mem165_4__ImmUnsignedi81_6,
  Convert__Reg1_3__Reg1_5__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Reg1_4__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Reg1_4__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Reg1_4__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Mem645_1__ImmUnsignedi81_3,
  Convert__Reg1_3__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem645_4__ImmUnsignedi81_6,
  Convert__Reg1_3__Reg1_5__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Mem325_1__ImmUnsignedi81_3,
  Convert__Reg1_3__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem325_4__ImmUnsignedi81_6,
  Convert__Reg1_3__Reg1_5__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem645_4__ImmUnsignedi81_5,
  Convert__Reg1_2__Reg1_4__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem165_4__ImmUnsignedi81_5,
  Convert__Reg1_2__Reg1_4__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem325_4__ImmUnsignedi81_5,
  Convert__Reg1_2__Reg1_4__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem64_RC1285_1__Tie1_1_1,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem64_RC1285_1__Tie1_3_3,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem64_RC128X5_4,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem64_RC256X5_4,
  Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem64_RC128X5_0,
  Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem64_RC256X5_0,
  Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem32_RC1285_1__Tie1_1_1,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem32_RC1285_1__Tie1_3_3,
  Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem32_RC2565_1__Tie1_1_1,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem32_RC2565_1__Tie1_3_3,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem32_RC128X5_4,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem32_RC256X5_4,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem32_RC5125_4,
  Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem32_RC128X5_0,
  Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem32_RC256X5_0,
  Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem32_RC5125_0,
  Convert__Reg1_1__Mem64_RC256X5_3,
  Convert__Reg1_2__Mem64_RC256X5_0,
  Convert__Reg1_1__Mem32_RC5125_3,
  Convert__Reg1_2__Mem32_RC5125_0,
  Convert__Reg1_1__Mem64_RC5125_3,
  Convert__Reg1_2__Mem64_RC5125_0,
  Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem64_RC2565_1__Tie1_1_1,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem64_RC2565_1__Tie1_3_3,
  Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem64_RC5125_4,
  Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem64_RC5125_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem1285_4__ImmUnsignedi81_5,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem2565_4__ImmUnsignedi81_5,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem5125_4__ImmUnsignedi81_5,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem1285_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem165_4__ImmUnsignedi81_6,
  Convert__Reg1_0__Reg1_2__Mem2565_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Reg1_2__Mem5125_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem165_5__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem645_4__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem645_5__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem325_4__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem325_5__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_8,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem165_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem165_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_7,
  Convert__Mem1285_2__Reg1_1__Reg1_0,
  Convert__Mem2565_2__Reg1_1__Reg1_0,
  Convert__Mem1285_0__Reg1_1__Reg1_2,
  Convert__Mem2565_0__Reg1_1__Reg1_2,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem165_5__ImmUnsignedi81_7,
  Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem165_6__ImmUnsignedi81_8,
  Convert__Reg1_0__Reg1_2__Reg1_4,
  Convert__Mem645_1__Reg1_3__Reg1_0,
  Convert__Mem645_0__Reg1_2__Reg1_4,
  Convert__Reg1_2__Tie0_3_3__Reg1_4__Reg1_1__Reg1_0,
  Convert__Mem165_1__Reg1_3__Reg1_0,
  Convert__Mem165_0__Reg1_2__Reg1_4,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem165_0,
  Convert__Reg1_1__Reg1_3__Mem165_0,
  Convert__Mem325_1__Reg1_3__Reg1_0,
  Convert__Mem325_0__Reg1_2__Reg1_4,
  Convert__VK4Pair1_2__Reg1_1__Reg1_0,
  Convert__VK8Pair1_2__Reg1_1__Reg1_0,
  Convert__VK16Pair1_2__Reg1_1__Reg1_0,
  Convert__VK16Pair1_0__Reg1_1__Reg1_2,
  Convert__VK16Pair1_0__Reg1_1__Mem5125_2,
  Convert__VK4Pair1_0__Reg1_1__Reg1_2,
  Convert__VK4Pair1_0__Reg1_1__Mem1285_2,
  Convert__VK8Pair1_0__Reg1_1__Reg1_2,
  Convert__VK8Pair1_0__Reg1_1__Mem2565_2,
  Convert__VK4Pair1_2__Reg1_1__Mem1285_0,
  Convert__VK8Pair1_2__Reg1_1__Mem2565_0,
  Convert__VK16Pair1_2__Reg1_1__Mem5125_0,
  Convert__VK16Pair1_0__Reg1_1__Mem325_2,
  Convert__VK4Pair1_0__Reg1_1__Mem325_2,
  Convert__VK8Pair1_0__Reg1_1__Mem325_2,
  Convert__VK16Pair1_3__Reg1_2__Mem325_0,
  Convert__VK4Pair1_3__Reg1_2__Mem325_0,
  Convert__VK8Pair1_3__Reg1_2__Mem325_0,
  Convert__VK2Pair1_2__Reg1_1__Reg1_0,
  Convert__VK2Pair1_0__Reg1_1__Reg1_2,
  Convert__VK2Pair1_0__Reg1_1__Mem1285_2,
  Convert__VK4Pair1_0__Reg1_1__Mem2565_2,
  Convert__VK8Pair1_0__Reg1_1__Mem5125_2,
  Convert__VK2Pair1_2__Reg1_1__Mem1285_0,
  Convert__VK4Pair1_2__Reg1_1__Mem2565_0,
  Convert__VK8Pair1_2__Reg1_1__Mem5125_0,
  Convert__VK2Pair1_0__Reg1_1__Mem645_2,
  Convert__VK4Pair1_0__Reg1_1__Mem645_2,
  Convert__VK8Pair1_0__Reg1_1__Mem645_2,
  Convert__VK2Pair1_3__Reg1_2__Mem645_0,
  Convert__VK4Pair1_3__Reg1_2__Mem645_0,
  Convert__VK8Pair1_3__Reg1_2__Mem645_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem85_4,
  Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem85_0,
  Convert__Reg1_0__Reg1_2__Mem85_5,
  Convert__Reg1_1__Reg1_3__Mem85_0,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_17,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_17,
  Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_17,
  Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_17,
  Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_17,
  Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_17,
  Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_17,
  Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_17,
  Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_1,
  Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_1,
  Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_1,
  Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_1,
  Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_1,
  Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_1,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_16,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_16,
  Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_16,
  Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_16,
  Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_16,
  Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_16,
  Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_16,
  Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_16,
  Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_0,
  Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_0,
  Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_0,
  Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_0,
  Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_0,
  Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__ImmUnsignedi41_4,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem1285_3__ImmUnsignedi41_4,
  Convert__Reg1_0__Reg1_1__Mem1285_2__Reg1_3__ImmUnsignedi41_4,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem2565_3__ImmUnsignedi41_4,
  Convert__Reg1_0__Reg1_1__Mem2565_2__Reg1_3__ImmUnsignedi41_4,
  Convert__Reg1_4__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi41_0,
  Convert__Reg1_4__Reg1_3__Mem1285_2__Reg1_1__ImmUnsignedi41_0,
  Convert__Reg1_4__Reg1_3__Mem2565_2__Reg1_1__ImmUnsignedi41_0,
  Convert__Reg1_4__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi41_0,
  Convert__Reg1_4__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi41_0,
  Convert__Reg1_0__Reg1_1__GR32orGR641_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Reg1_1__Mem85_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Reg1_2__GR32orGR641_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_2__Mem85_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Mem1285_1__Reg1_0,
  Convert__Reg1_0__Mem1285_1__Reg1_2,
  Convert__Reg1_3__Mem32_RC128X5_1__Tie0_4_4__Reg1_0,
  Convert__Reg1_3__Mem32_RC256X5_1__Tie0_4_4__Reg1_0,
  Convert__Reg1_3__Mem32_RC5125_1__Tie0_4_4__Reg1_0,
  Convert__Reg1_2__Mem32_RC128X5_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_2__Mem32_RC256X5_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_2__Mem32_RC5125_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_3__Mem64_RC128X5_1__Tie0_4_4__Reg1_0,
  Convert__Reg1_3__Mem64_RC256X5_1__Tie0_4_4__Reg1_0,
  Convert__Reg1_2__Mem64_RC128X5_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_2__Mem64_RC256X5_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_3__Mem64_RC5125_1__Tie0_4_4__Reg1_0,
  Convert__Reg1_2__Mem64_RC5125_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_0__Reg1_1__Tie0_1_1__Tie1_2_2,
  Convert__Reg1_1__Reg1_0__Tie0_2_2__Tie1_1_1,
  Convert__AbsMem161_0,
  Convert__regEAX__regEAX__Tie0_1_1__Tie1_1_1,
  CVT_NUM_SIGNATURES
};

} // end anonymous namespace

static const uint8_t ConversionTable[CVT_NUM_SIGNATURES][13] = {
  // Convert_NoOperands
  { CVT_Done },
  // Convert__imm_95_10
  { CVT_imm_95_10, 0, CVT_Done },
  // Convert__Imm1_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem325_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem645_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem325_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem645_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Imm1_1
  { CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regAX__Tie0_1_1__ImmSExti16i81_1
  { CVT_regAX, 0, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regEAX__Tie0_1_1__ImmSExti32i81_1
  { CVT_regEAX, 0, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regRAX__Tie0_1_1__ImmSExti64i81_1
  { CVT_regRAX, 0, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__ImmSExti64i321_1
  { CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ImmSExti16i81_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Imm1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ImmSExti32i81_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ImmSExti64i81_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ImmSExti64i321_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem85_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Mem165_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem165_0__ImmSExti16i81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem165_0__Imm1_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem325_0__ImmSExti32i81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem325_0__Imm1_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem645_0__ImmSExti64i81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem645_0__ImmSExti64i321_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem85_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem85_0__Imm1_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmSExti16i81_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Imm1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem165_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Mem165_1__ImmSExti16i81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem165_1__Imm1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmSExti32i81_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem325_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Mem325_1__ImmSExti32i81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem325_1__Imm1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmSExti64i81_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmSExti64i321_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem645_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Mem645_1__ImmSExti64i81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem645_1__ImmSExti64i321_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem85_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem85_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Mem85_1__Imm1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem85_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Imm1_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem85_1__Imm1_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem85_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Mem85_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem85_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem85_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__regEAX__Tie0_1_1__ImmSExti32i81_0
  { CVT_regEAX, 0, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem325_1__ImmSExti32i81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem325_1__Imm1_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem325_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmSExti32i81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmSExti32i81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem325_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem325_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__regRAX__Tie0_1_1__ImmSExti64i81_0
  { CVT_regRAX, 0, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ImmSExti64i321_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i321_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem645_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmSExti64i81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmSExti64i81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmSExti64i321_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmSExti64i321_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem645_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem165_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__regAX__Tie0_1_1__ImmSExti16i81_0
  { CVT_regAX, 0, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_1__ImmSExti16i81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_1__Imm1_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem165_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmSExti16i81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem165_1__ImmSExti16i81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem165_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem165_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem1285_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Mem1285_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Mem645_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Mem325_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem5_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem5_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem5_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_0
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Mem1285_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem1285_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem1285_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem325_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem645_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem325_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem645_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem1285_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem1285_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Mem1285_1
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem165_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Mem165_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__Reg1_0__ImmUnsignedi81_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem325_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_0__ImmUnsignedi81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem325_0__ImmUnsignedi81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem645_0__ImmUnsignedi81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ImmUnsignedi81_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__ImmUnsignedi81_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0
  { CVT_95_Reg, 1, CVT_Done },
  // Convert__AbsMem1_0
  { CVT_95_addAbsMemOperands, 1, CVT_Done },
  // Convert__Mem165_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem325_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem645_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Imm1_1__Imm1_0
  { CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1
  { CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem325_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Mem645_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Mem165_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_7
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_7
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_7
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_7
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_7
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_7
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_7
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_7
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_7
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_7
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_7
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_7
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_7
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_7
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_7
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_7
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_7
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_7
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_7
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_7
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_7
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_7
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_7
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_7
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_7
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_7
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_3
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_3
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_3
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_3
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_3
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_3
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_3
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_3
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_3
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_3
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_3
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_3
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_3
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_3
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_3
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_3
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_3
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_3
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_3
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_3
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_3
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_3
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_3
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_3
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_3
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_3
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_3
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_3
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_3
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_3
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_3
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_3
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_3
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_3
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_3
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_3
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_7
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_7
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_7
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_7
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_7
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_7
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_7
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_7
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_7
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_7
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_7
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_7
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_7
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_7
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_7
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_7
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_2
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_2
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_2
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_2
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_2
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_2
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_2
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_2
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_2
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_2
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_2
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_2
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_2
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_2
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_2
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_2
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_2
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_2
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_2
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_2
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_2
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_2
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_2
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_2
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_2
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_6
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_6
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_6
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_6
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_6
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_6
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_6
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_6
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_6
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_6
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_6
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_6
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_6
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_6
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_6
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_6
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_6
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_6
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_6
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_6
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_6
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_6
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_6
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_6
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_6
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_6
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_6
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_6
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_6
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_6
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_6
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_6
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_6
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_6
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_6
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_6
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_6
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_6
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_6
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_6
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_6
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_6
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_2
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_2
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_2
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_2
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_2
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_2
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_2
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_2
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_2
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_2
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_2
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_2
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_2
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_2
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_2
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_2
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_4
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_4
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_4
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_4
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_4
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_4
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_4
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_4
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_4
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_4
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_4
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_4
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_4
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_4
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_4
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_4
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_4
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_4
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_4
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_4
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_4
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_4
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_4
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_4
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_4
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_4
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_4
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_4
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_4
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_4
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_4
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_4
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_4
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_4
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_4
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_4
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_4
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_4
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_11
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_11
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_11
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_11
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_11
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_11
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_11
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_11
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_11
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_11
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_11
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_11
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_11
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_11
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_11
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_11
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_11
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_11
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_11
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_11
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_11
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_11
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_11
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_11
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_11
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_11
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_11
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_11
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_11
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_11
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_11
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_11
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_11
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_11
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_11
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_11
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_11
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_11
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_11
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_11
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_11
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_11
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_15
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_15
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_15
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_15
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_15
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_15
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_15
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_15
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_15
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_15
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_15
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_15
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_15
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_15
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_15
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_15
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_15
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_15
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_15
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_15
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_15
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_15
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_15
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_15
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_15
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_15
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_13
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_13
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_13
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_13
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_13
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_13
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_13
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_13
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_13
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_13
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_13
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_13
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_13
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_13
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_13
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_13
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_13
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_13
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_13
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_13
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_13
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_13
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_13
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_13
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_13
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_13
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_13
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_13
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_13
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_13
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_13
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_13
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_13
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_13
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_13
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_13
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_13
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_13
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_13
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_13
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_13
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_13
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_15
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_15
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_15
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_15
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_15
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_15
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_15
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_15
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_15
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_15
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_15
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_15
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_15
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_15
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_15
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_15
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_12
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_12
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_12
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_12
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_12
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_12
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_12
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_12
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_12
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_12
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_12
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_12
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_12
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_12
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_12
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_12
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_12
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_12
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_12
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_12
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_12
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_12
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_12
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_12
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_12
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_12
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_14
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_14
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_14
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_14
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_14
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_14
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_14
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_14
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_14
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_14
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_14
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_14
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_14
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_14
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_14
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_14
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_14
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_14
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_14
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_14
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_14
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_14
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_14
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_14
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_14
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_14
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_14
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_14
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_14
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_14
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_14
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_14
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_14
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_14
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_14
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_14
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_14
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_14
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_14
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_14
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_14
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_14
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_12
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_12
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_12
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_12
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_12
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_12
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_12
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_12
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_12
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_12
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_12
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_12
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_12
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_12
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_12
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_12
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_5
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_5
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_5
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_5
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_5
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_5
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_5
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_5
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_5
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_5
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_5
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_5
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_5
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_5
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_5
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_5
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_5
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_5
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_5
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_5
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_5
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_5
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_5
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_5
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_5
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_5
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_5
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_5
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_5
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_5
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_5
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_5
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_5
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_5
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_5
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_5
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_5
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_5
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_5
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_5
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_5
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_5
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_1
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_1
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_1
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_1
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_1
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_1
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_1
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_1
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_1
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_1
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_1
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_1
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_1
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_1
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_1
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_1
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_1
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_1
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_1
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_1
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_1
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_1
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_1
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_1
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_1
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_1
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_1
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_1
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_1
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_1
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_1
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_1
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_9
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_9
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_9
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_9
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_9
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_9
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_9
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_9
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_9
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_9
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_9
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_9
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_9
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_9
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_9
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_9
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_9
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_9
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_9
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_9
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_9
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_9
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_9
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_9
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_9
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_9
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_9
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_9
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_9
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_9
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_9
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_9
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_9
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_9
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_9
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_9
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_9
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_9
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_9
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_9
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_9
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_9
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_0
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_0
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_0
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_0
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_0
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_0
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_0
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_0
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_8
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_8
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_8
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_8
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_8
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_8
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_8
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_8
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_8
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_8
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_8
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_8
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_8
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_8
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_8
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_8
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_8
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_8
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_8
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_8
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_8
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_8
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_8
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_8
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_8
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_8
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_8
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_8
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_8
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_8
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_8
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_8
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_8
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_8
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_8
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_8
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_8
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_8
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_8
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_8
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_8
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_8
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_2__ImmUnsignedi41_0__imm_95_10
  { CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_10
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_2__ImmUnsignedi41_0__imm_95_10
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_2__ImmUnsignedi41_0__imm_95_10
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_10
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_2__ImmUnsignedi41_0__imm_95_10
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_10
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_10
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_2__ImmUnsignedi41_0__imm_95_10
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Mem85_2__ImmUnsignedi41_0__imm_95_10
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_10
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem165_1__ImmSExti16i81_2__ImmUnsignedi41_0__imm_95_10
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem165_1__Imm1_2__ImmUnsignedi41_0__imm_95_10
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_10
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem325_1__ImmSExti32i81_2__ImmUnsignedi41_0__imm_95_10
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem325_1__Imm1_2__ImmUnsignedi41_0__imm_95_10
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_10
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i81_2__ImmUnsignedi41_0__imm_95_10
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i321_2__ImmUnsignedi41_0__imm_95_10
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_10
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem85_1__Imm1_2__ImmUnsignedi41_0__imm_95_10
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_10
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_10
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_10
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_10
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_10
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_10
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_10
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_10
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_10
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_10
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_10
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_10
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_10
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_10
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_10
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_10
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_10
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_10
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_10
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_10
  { CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_10
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_7
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Mem165_1__imm_95_7
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Mem325_1__imm_95_7
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Mem645_1__imm_95_7
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem165_0__Reg1_1__imm_95_7
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem325_0__Reg1_1__imm_95_7
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem645_0__Reg1_1__imm_95_7
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_7
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_7
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_7
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_7
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_0__Mem165_1__imm_95_3
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_0__Mem325_1__imm_95_3
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_0__Mem645_1__imm_95_3
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem165_0__Reg1_1__imm_95_3
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem325_0__Reg1_1__imm_95_3
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem645_0__Reg1_1__imm_95_3
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_0__imm_95_3
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_0__imm_95_3
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_0__imm_95_3
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_3
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_3
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_0__imm_95_3
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_0__imm_95_3
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_3
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_0__imm_95_3
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_0__imm_95_3
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_3
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_0__imm_95_7
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_0__imm_95_7
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_0__imm_95_7
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_7
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_7
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_0__imm_95_7
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_0__imm_95_7
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_7
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_0__imm_95_7
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_0__imm_95_7
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_7
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__Mem165_1__imm_95_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__Mem325_1__imm_95_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__Mem645_1__imm_95_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem165_0__Reg1_1__imm_95_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem325_0__Reg1_1__imm_95_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem645_0__Reg1_1__imm_95_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_6
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_0__Mem165_1__imm_95_6
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_0__Mem325_1__imm_95_6
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_0__Mem645_1__imm_95_6
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem165_0__Reg1_1__imm_95_6
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem325_0__Reg1_1__imm_95_6
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem645_0__Reg1_1__imm_95_6
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_6
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_6
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_6
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_6
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_0__imm_95_6
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_0__imm_95_6
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_0__imm_95_6
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_6
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_6
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_0__imm_95_6
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_0__imm_95_6
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_6
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_0__imm_95_6
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_0__imm_95_6
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_6
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_0__imm_95_2
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_0__imm_95_2
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_0__imm_95_2
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_2
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_2
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_0__imm_95_2
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_0__imm_95_2
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_2
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_0__imm_95_2
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_0__imm_95_2
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_2
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_0__Mem165_1__imm_95_4
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_0__Mem325_1__imm_95_4
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_0__Mem645_1__imm_95_4
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem165_0__Reg1_1__imm_95_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem325_0__Reg1_1__imm_95_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem645_0__Reg1_1__imm_95_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_0__imm_95_4
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_0__imm_95_4
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_0__imm_95_4
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_4
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_4
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_0__imm_95_4
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_0__imm_95_4
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_4
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_0__imm_95_4
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_0__imm_95_4
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_4
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_15
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__Mem165_1__imm_95_15
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__Mem325_1__imm_95_15
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__Mem645_1__imm_95_15
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem165_0__Reg1_1__imm_95_15
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem325_0__Reg1_1__imm_95_15
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem645_0__Reg1_1__imm_95_15
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_15
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_15
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_15
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_15
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_13
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_0__Mem165_1__imm_95_13
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_0__Mem325_1__imm_95_13
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_0__Mem645_1__imm_95_13
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem165_0__Reg1_1__imm_95_13
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem325_0__Reg1_1__imm_95_13
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem645_0__Reg1_1__imm_95_13
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_13
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_13
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_13
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_13
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_0__imm_95_13
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_0__imm_95_13
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_0__imm_95_13
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_13
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_13
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_0__imm_95_13
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_0__imm_95_13
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_13
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_0__imm_95_13
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_0__imm_95_13
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_13
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_0__imm_95_15
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_0__imm_95_15
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_0__imm_95_15
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_15
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_15
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_0__imm_95_15
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_0__imm_95_15
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_15
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_0__imm_95_15
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_0__imm_95_15
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_15
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_12
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__Mem165_1__imm_95_12
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__Mem325_1__imm_95_12
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__Mem645_1__imm_95_12
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem165_0__Reg1_1__imm_95_12
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem325_0__Reg1_1__imm_95_12
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem645_0__Reg1_1__imm_95_12
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_12
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_12
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_12
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_12
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_14
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_0__Mem165_1__imm_95_14
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_0__Mem325_1__imm_95_14
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_0__Mem645_1__imm_95_14
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem165_0__Reg1_1__imm_95_14
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem325_0__Reg1_1__imm_95_14
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem645_0__Reg1_1__imm_95_14
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_14
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_14
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_14
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_14
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_0__imm_95_14
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_0__imm_95_14
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_0__imm_95_14
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_14
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_14
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_0__imm_95_14
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_0__imm_95_14
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_14
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_0__imm_95_14
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_0__imm_95_14
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_14
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_0__imm_95_12
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_0__imm_95_12
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_0__imm_95_12
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_12
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_12
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_0__imm_95_12
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_0__imm_95_12
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_12
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_0__imm_95_12
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_0__imm_95_12
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_12
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_5
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_0__Mem165_1__imm_95_5
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_0__Mem325_1__imm_95_5
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_0__Mem645_1__imm_95_5
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem165_0__Reg1_1__imm_95_5
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem325_0__Reg1_1__imm_95_5
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem645_0__Reg1_1__imm_95_5
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_5
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_5
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_5
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_5
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_0__imm_95_5
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_0__imm_95_5
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_0__imm_95_5
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_5
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_5
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_0__imm_95_5
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_0__imm_95_5
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_5
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_0__imm_95_5
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_0__imm_95_5
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_5
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Mem165_1__imm_95_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Mem325_1__imm_95_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Mem645_1__imm_95_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem165_0__Reg1_1__imm_95_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem325_0__Reg1_1__imm_95_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem645_0__Reg1_1__imm_95_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_0__imm_95_1
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_0__imm_95_1
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_0__imm_95_1
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_0__imm_95_1
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_0__imm_95_1
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_0__imm_95_1
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_0__imm_95_1
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_11
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_0__Mem165_1__imm_95_11
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_0__Mem325_1__imm_95_11
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_0__Mem645_1__imm_95_11
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem165_0__Reg1_1__imm_95_11
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem325_0__Reg1_1__imm_95_11
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem645_0__Reg1_1__imm_95_11
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_11
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_11
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_11
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_11
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_0__imm_95_11
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_0__imm_95_11
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_0__imm_95_11
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_11
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_11
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_0__imm_95_11
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_0__imm_95_11
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_11
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_0__imm_95_11
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_0__imm_95_11
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_11
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_9
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_0__Mem165_1__imm_95_9
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_0__Mem325_1__imm_95_9
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_0__Mem645_1__imm_95_9
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem165_0__Reg1_1__imm_95_9
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem325_0__Reg1_1__imm_95_9
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem645_0__Reg1_1__imm_95_9
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_9
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_9
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_9
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_9
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_0__imm_95_9
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_0__imm_95_9
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_0__imm_95_9
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_9
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_9
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_0__imm_95_9
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_0__imm_95_9
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_9
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_0__imm_95_9
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_0__imm_95_9
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_9
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Mem165_1__imm_95_0
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Mem325_1__imm_95_0
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Mem645_1__imm_95_0
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem165_0__Reg1_1__imm_95_0
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem325_0__Reg1_1__imm_95_0
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem645_0__Reg1_1__imm_95_0
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_0__imm_95_0
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_0__imm_95_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_0__imm_95_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_0__imm_95_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_0__imm_95_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_0__imm_95_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_0__imm_95_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_10
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_0__Mem165_1__imm_95_10
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_0__Mem325_1__imm_95_10
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_0__Mem645_1__imm_95_10
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem165_0__Reg1_1__imm_95_10
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem325_0__Reg1_1__imm_95_10
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem645_0__Reg1_1__imm_95_10
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_10
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_10
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_10
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_10
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_0__imm_95_10
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_0__imm_95_10
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_0__imm_95_10
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_10
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_10
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_0__imm_95_10
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_0__imm_95_10
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_10
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_0__imm_95_10
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_0__imm_95_10
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_10
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_8
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_0__Mem165_1__imm_95_8
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_0__Mem325_1__imm_95_8
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_0__Mem645_1__imm_95_8
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem165_0__Reg1_1__imm_95_8
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem325_0__Reg1_1__imm_95_8
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem645_0__Reg1_1__imm_95_8
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_8
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2__imm_95_8
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__imm_95_8
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__imm_95_8
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Reg1_0__imm_95_8
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem325_1__Reg1_0__imm_95_8
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Mem325_0__imm_95_8
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_8
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_8
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem645_1__Reg1_0__imm_95_8
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Mem645_0__imm_95_8
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_8
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem165_1__Reg1_0__imm_95_8
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Mem165_0__imm_95_8
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_8
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem85_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_0
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_7
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_7
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_7
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_7
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_6
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_6
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_6
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_6
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_2
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_2
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_2
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_2
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_4
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_4
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_4
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_4
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_15
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_15
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_15
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_15
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_13
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_13
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_13
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_13
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_13
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_13
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_13
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_13
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_15
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_15
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_15
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_15
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_12
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_12
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_12
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_12
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_14
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_14
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_14
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_14
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_14
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_14
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_14
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_14
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_12
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_12
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_12
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_12
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_5
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_5
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_5
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_5
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_1
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_1
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_1
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_1
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_11
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_11
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_11
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_11
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_11
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_11
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_11
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_11
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_9
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_9
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_9
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_9
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_9
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_9
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_9
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_9
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_0
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_0
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_0
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_0
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_10
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_10
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_10
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_10
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_10
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_10
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_10
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_10
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_8
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__imm_95_8
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__imm_95_8
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__imm_95_8
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_8
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_8
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_8
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_8
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__regAX__ImmSExti16i81_1
  { CVT_regAX, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regEAX__ImmSExti32i81_1
  { CVT_regEAX, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regRAX__ImmSExti64i81_1
  { CVT_regRAX, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmSExti16i81_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Imm1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmSExti32i81_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmSExti64i81_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmSExti64i321_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem85_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_3
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_7
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_7
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_7
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_7
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_1__Imm1_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem85_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_6
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_6
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_6
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_6
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_2
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_2
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_2
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_2
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_4
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_4
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_4
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_4
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_13
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_13
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_13
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_13
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_15
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_15
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_15
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_15
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_15, 0, CVT_Done },
  // Convert__regEAX__ImmSExti32i81_0
  { CVT_regEAX, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__ImmSExti32i81_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_14
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_14
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_14
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_14
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_12
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_12
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_12
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_12
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_5
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_5
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_5
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_5
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_1
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_1
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_1
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_1
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_11
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_11
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_11
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_11
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_9
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_9
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_9
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_9
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_10
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_10
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_10
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_10
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_10, 0, CVT_Done },
  // Convert__regRAX__ImmSExti64i81_0
  { CVT_regRAX, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i81_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i321_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx161_1__SrcIdx162_0
  { CVT_95_addDstIdxOperands, 2, CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__DstIdx321_1__SrcIdx322_0
  { CVT_95_addDstIdxOperands, 2, CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__DstIdx641_1__SrcIdx642_0
  { CVT_95_addDstIdxOperands, 2, CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__DstIdx81_1__SrcIdx82_0
  { CVT_95_addDstIdxOperands, 2, CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__DstIdx81_0__SrcIdx82_1
  { CVT_95_addDstIdxOperands, 1, CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem645_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx321_0__SrcIdx322_1
  { CVT_95_addDstIdxOperands, 1, CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__DstIdx641_0__SrcIdx642_1
  { CVT_95_addDstIdxOperands, 1, CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem325_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx161_0__SrcIdx162_1
  { CVT_95_addDstIdxOperands, 1, CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_8
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_8
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 3, CVT_95_Reg, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem325_0__Reg1_2__imm_95_8
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem645_0__Reg1_2__imm_95_8
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_imm_95_8, 0, CVT_Done },
  // Convert__regAX__ImmSExti16i81_0
  { CVT_regAX, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__ImmSExti16i81_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem165_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem1285_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem85_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem512_GR165_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem512_GR325_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem512_GR645_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem512_GR165_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem512_GR325_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem512_GR645_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Imm1_0__Imm1_1
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR32orGR641_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addGR32orGR64Operands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem325_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__GR32orGR641_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addGR32orGR64Operands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem325_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ImmUnsignedi81_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_3_3__ImmUnsignedi81_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_3_3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__regST1
  { CVT_regST1, 0, CVT_Done },
  // Convert__regST0
  { CVT_regST0, 0, CVT_Done },
  // Convert__Mem805_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__ImmUnsignedi81_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_0__ImmSExti16i81_1
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_0__Imm1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_0__ImmSExti32i81_1
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_0__ImmSExti64i81_1
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_0__ImmSExti64i321_1
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_1__Reg1_1__ImmSExti32i81_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__Imm1_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__ImmSExti64i81_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__ImmSExti64i321_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__ImmSExti16i81_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ImmUnsignedi81_1
  { CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__DstIdx161_0
  { CVT_95_addDstIdxOperands, 1, CVT_Done },
  // Convert__DstIdx321_0
  { CVT_95_addDstIdxOperands, 1, CVT_Done },
  // Convert__DstIdx81_0
  { CVT_95_addDstIdxOperands, 1, CVT_Done },
  // Convert__DstIdx81_1
  { CVT_95_addDstIdxOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__ImmUnsignedi81_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Tie0_4_4__Reg1_2__ImmUnsignedi81_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_4_4, CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx321_1
  { CVT_95_addDstIdxOperands, 2, CVT_Done },
  // Convert__DstIdx161_1
  { CVT_95_addDstIdxOperands, 2, CVT_Done },
  // Convert__AbsMem1_0__imm_95_7
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_3
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_2
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_6
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_4
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_15
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_13
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_12
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_14
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_5
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_1
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_11
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_9
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_0
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_10
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__AbsMem1_0__imm_95_8
  { CVT_95_addAbsMemOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_0__GR16orGR32orGR641_1
  { CVT_95_Reg, 1, CVT_95_addGR16orGR32orGR64Operands, 2, CVT_Done },
  // Convert__Reg1_1__GR16orGR32orGR641_0
  { CVT_95_Reg, 2, CVT_95_addGR16orGR32orGR64Operands, 1, CVT_Done },
  // Convert__Mem5_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem5_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem5_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__SrcIdx162_0
  { CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__SrcIdx322_0
  { CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__SrcIdx642_0
  { CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__SrcIdx82_0
  { CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__SrcIdx82_1
  { CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__SrcIdx162_1
  { CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__SrcIdx322_1
  { CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__SrcIdx642_1
  { CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__MemOffs16_82_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs32_82_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs16_162_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs32_162_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs16_322_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs32_322_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs32_642_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs16_162_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs16_322_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs16_82_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs32_162_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs32_322_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs32_642_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs32_82_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs64_82_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs64_162_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs64_322_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs64_642_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs64_162_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs64_322_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs64_642_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs64_82_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__Mem1285_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__GR32orGR641_1__Reg1_0
  { CVT_95_addGR32orGR64Operands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__GR32orGR641_0__Reg1_1
  { CVT_95_addGR32orGR64Operands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_17
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_17
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_17
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_17
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_1
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_16
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 1, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__imm_95_16
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_16
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_16
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem1285_1__imm_95_0
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Mem1285_0__imm_95_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem85_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem85_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem645_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem165_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__GR32orGR641_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addGR32orGR64Operands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem85_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__GR32orGR641_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addGR32orGR64Operands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Mem85_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Mem165_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem645_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ImmSExti64i81_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ImmSExti16i81_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ImmSExti32i81_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem85_0__ImmUnsignedi81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem165_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem325_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem85_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_Done },
  // Convert__Mem85_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_2__Mem85_1
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_2__Mem85_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem325_1
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem645_1
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_2__Mem165_1
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_2__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx641_0
  { CVT_95_addDstIdxOperands, 1, CVT_Done },
  // Convert__DstIdx641_1
  { CVT_95_addDstIdxOperands, 2, CVT_Done },
  // Convert__Reg1_0__imm_95_7
  { CVT_95_Reg, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_7
  { CVT_95_addMemOperands, 1, CVT_imm_95_7, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_3
  { CVT_95_Reg, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_3
  { CVT_95_addMemOperands, 1, CVT_imm_95_3, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_2
  { CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_2
  { CVT_95_addMemOperands, 1, CVT_imm_95_2, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_6
  { CVT_95_Reg, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_6
  { CVT_95_addMemOperands, 1, CVT_imm_95_6, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_4
  { CVT_95_Reg, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_4
  { CVT_95_addMemOperands, 1, CVT_imm_95_4, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_15
  { CVT_95_Reg, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_15
  { CVT_95_addMemOperands, 1, CVT_imm_95_15, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_13
  { CVT_95_Reg, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_13
  { CVT_95_addMemOperands, 1, CVT_imm_95_13, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_12
  { CVT_95_Reg, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_12
  { CVT_95_addMemOperands, 1, CVT_imm_95_12, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_14
  { CVT_95_Reg, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_14
  { CVT_95_addMemOperands, 1, CVT_imm_95_14, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_5
  { CVT_95_Reg, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_5
  { CVT_95_addMemOperands, 1, CVT_imm_95_5, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_1
  { CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_1
  { CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_11
  { CVT_95_Reg, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_11
  { CVT_95_addMemOperands, 1, CVT_imm_95_11, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_9
  { CVT_95_Reg, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_9
  { CVT_95_addMemOperands, 1, CVT_imm_95_9, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_0
  { CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_0
  { CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_10
  { CVT_95_Reg, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_10
  { CVT_95_addMemOperands, 1, CVT_imm_95_10, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_8
  { CVT_95_Reg, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Mem85_0__imm_95_8
  { CVT_95_addMemOperands, 1, CVT_imm_95_8, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Mem165_1__Reg1_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Mem325_1__Reg1_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Mem645_1__Reg1_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_2__Tie0_3_3__Reg1_1
  { CVT_95_Reg, 3, CVT_Tied, Tie0_3_3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem325_2__Reg1_1
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_2__Tie0_3_3__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_3_3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_3__Mem325_2__Reg1_1
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Mem325_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_2__Reg1_1
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_3__Mem645_2__Reg1_1
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_3__Mem645_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_2__Reg1_1
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_3__Mem165_2__Reg1_1
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_3__Mem165_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__TILEPair1_0__SibMem5_1
  { CVT_95_addTILEPairOperands, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__TILEPair1_1__SibMem5_0
  { CVT_95_addTILEPairOperands, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_3_3__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_3_3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__SibMem5_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__SibMem5_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__SibMem5_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__SibMem5_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__GR32orGR641_0
  { CVT_95_addGR32orGR64Operands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem1285_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem1285_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem1285_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem1285_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem1285_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem5125_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem2565_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem5125_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem165_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem2565_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem5125_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem2565_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem5125_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem1285_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem165_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem2565_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem5125_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem165_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem165_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem165_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__AVX512RC1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addAVX512RCOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem645_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem645_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5__AVX512RC1_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addAVX512RCOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__AVX512RC1_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addAVX512RCOperands, 8, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem325_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem325_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem645_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Mem645_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem165_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Mem165_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__Mem325_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Mem325_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem5125_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem1285_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem2565_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem5125_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem1285_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem2565_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem5125_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem1285_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem2565_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem5125_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Reg1_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem645_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem645_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Reg1_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem645_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem645_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem1285_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem1285_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem1285_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem1285_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem2565_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem2565_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem2565_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem2565_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem2565_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem2565_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem325_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem325_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem325_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem325_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem1285_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem2565_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem5125_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem165_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem165_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem2565_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem5125_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem2565_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem5125_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem1285_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem2565_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem5125_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Mem2565_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Mem5125_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_0__Mem5125_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem5125_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem165_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem5125_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem5125_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem165_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem5125_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem165_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem5125_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem165_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem165_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem325_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem325_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem325_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__AVX512RC1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__AVX512RC1_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addAVX512RCOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__AVX512RC1_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addAVX512RCOperands, 7, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem645_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0_2_2__Reg1_3__Reg1_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_2_2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_3_3__Reg1_4__Mem645_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem645_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem645_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem2565_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem2565_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_2__Reg1_4__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem1285_2__Reg1_4__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem2565_2__Reg1_4__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_2__Reg1_4__ImmUnsignedi81_5
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Mem2565_0__Reg1_2__Reg1_4__ImmUnsignedi81_5
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Mem645_0__Reg1_2__Reg1_4__ImmUnsignedi81_5
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Reg1_1
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_3__AVX512RC1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addAVX512RCOperands, 3, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addAVX512RCOperands, 2, CVT_Done },
  // Convert__Reg1_2__Tie0_3_3__Reg1_4__Reg1_1
  { CVT_95_Reg, 3, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem2565_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem5125_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem2565_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem5125_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem325_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem2565_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem5125_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem325_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__AVX512RC1_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addAVX512RCOperands, 4, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6__AVX512RC1_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addAVX512RCOperands, 8, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem325_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem1285_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem2565_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem5125_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem645_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Tie0_1_1__Reg1_3__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Tie0_1_1__Reg1_3__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem1285_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem2565_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem5125_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem325_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Tie0_1_1__Reg1_3__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem645_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem325_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem165_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem165_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem165_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Mem645_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_2__Mem645_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_5__Mem645_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem645_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_1__Mem165_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem1285_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem2565_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem645_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem645_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Mem645_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem325_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem325_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Mem325_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem2565_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem5125_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem165_1__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem1285_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem2565_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem5125_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem165_4__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem645_1__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem645_4__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem325_1__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem325_4__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem645_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem165_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem325_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem64_RC1285_1__Tie1_1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem64_RC1285_1__Tie1_3_3
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_3_3, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem64_RC128X5_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem64_RC256X5_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem64_RC128X5_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_4_4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem64_RC256X5_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_4_4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem32_RC1285_1__Tie1_1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem32_RC1285_1__Tie1_3_3
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_3_3, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem32_RC2565_1__Tie1_1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem32_RC2565_1__Tie1_3_3
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_3_3, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem32_RC128X5_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem32_RC256X5_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem32_RC5125_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem32_RC128X5_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_4_4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem32_RC256X5_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_4_4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem32_RC5125_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_4_4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem64_RC256X5_3
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_2__Mem64_RC256X5_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem32_RC5125_3
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_2__Mem32_RC5125_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem64_RC5125_3
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_2__Mem64_RC5125_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_1_1__Mem64_RC2565_1__Tie1_1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Mem64_RC2565_1__Tie1_3_3
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_addMemOperands, 2, CVT_Tied, Tie1_3_3, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0_1_1__Tie1_3_3__Mem64_RC5125_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_3_3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0_1_1__Tie1_4_4__Mem64_RC5125_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_4_4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem1285_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem2565_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem5125_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0_1_1__Reg1_4__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_1_1, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem1285_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem165_4__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem2565_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem5125_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem165_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem645_4__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem645_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem325_4__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem325_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem165_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0_1_1__Reg1_5__Reg1_2__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, Tie0_1_1, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem165_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Mem1285_2__Reg1_1__Reg1_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem2565_2__Reg1_1__Reg1_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_1__Reg1_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Mem2565_0__Reg1_1__Reg1_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Reg1_4__Mem165_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_4__Tie0_1_1__Reg1_6__Reg1_3__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, Tie0_1_1, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem165_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Mem645_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem645_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Tie0_3_3__Reg1_4__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem165_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem165_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem165_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem165_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem325_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem325_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__VK4Pair1_2__Reg1_1__Reg1_0
  { CVT_95_addMaskPairOperands, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__VK8Pair1_2__Reg1_1__Reg1_0
  { CVT_95_addMaskPairOperands, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__VK16Pair1_2__Reg1_1__Reg1_0
  { CVT_95_addMaskPairOperands, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__VK16Pair1_0__Reg1_1__Reg1_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__VK16Pair1_0__Reg1_1__Mem5125_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK4Pair1_0__Reg1_1__Reg1_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__VK4Pair1_0__Reg1_1__Mem1285_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK8Pair1_0__Reg1_1__Reg1_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__VK8Pair1_0__Reg1_1__Mem2565_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK4Pair1_2__Reg1_1__Mem1285_0
  { CVT_95_addMaskPairOperands, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__VK8Pair1_2__Reg1_1__Mem2565_0
  { CVT_95_addMaskPairOperands, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__VK16Pair1_2__Reg1_1__Mem5125_0
  { CVT_95_addMaskPairOperands, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__VK16Pair1_0__Reg1_1__Mem325_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK4Pair1_0__Reg1_1__Mem325_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK8Pair1_0__Reg1_1__Mem325_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK16Pair1_3__Reg1_2__Mem325_0
  { CVT_95_addMaskPairOperands, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__VK4Pair1_3__Reg1_2__Mem325_0
  { CVT_95_addMaskPairOperands, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__VK8Pair1_3__Reg1_2__Mem325_0
  { CVT_95_addMaskPairOperands, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__VK2Pair1_2__Reg1_1__Reg1_0
  { CVT_95_addMaskPairOperands, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__VK2Pair1_0__Reg1_1__Reg1_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__VK2Pair1_0__Reg1_1__Mem1285_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK4Pair1_0__Reg1_1__Mem2565_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK8Pair1_0__Reg1_1__Mem5125_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK2Pair1_2__Reg1_1__Mem1285_0
  { CVT_95_addMaskPairOperands, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__VK4Pair1_2__Reg1_1__Mem2565_0
  { CVT_95_addMaskPairOperands, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__VK8Pair1_2__Reg1_1__Mem5125_0
  { CVT_95_addMaskPairOperands, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__VK2Pair1_0__Reg1_1__Mem645_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK4Pair1_0__Reg1_1__Mem645_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK8Pair1_0__Reg1_1__Mem645_2
  { CVT_95_addMaskPairOperands, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__VK2Pair1_3__Reg1_2__Mem645_0
  { CVT_95_addMaskPairOperands, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__VK4Pair1_3__Reg1_2__Mem645_0
  { CVT_95_addMaskPairOperands, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__VK8Pair1_3__Reg1_2__Mem645_0
  { CVT_95_addMaskPairOperands, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_2__Mem85_4
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0_1_1__Reg1_3__Mem85_0
  { CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem85_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem85_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_17
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_17
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_17
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_17
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_17
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_17
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_17
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_17
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_16
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_16
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_16
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_16
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_16
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_16
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_16
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_16
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem5125_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem2565_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem5125_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__ImmUnsignedi41_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem1285_3__ImmUnsignedi41_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__Reg1_3__ImmUnsignedi41_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem2565_3__ImmUnsignedi41_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__Reg1_3__ImmUnsignedi41_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi41_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem1285_2__Reg1_1__ImmUnsignedi41_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem2565_2__Reg1_1__ImmUnsignedi41_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi41_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi41_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__GR32orGR641_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addGR32orGR64Operands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem85_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__GR32orGR641_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addGR32orGR64Operands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem85_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem1285_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Mem1285_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_3__Mem32_RC128X5_1__Tie0_4_4__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, Tie0_4_4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__Mem32_RC256X5_1__Tie0_4_4__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, Tie0_4_4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__Mem32_RC5125_1__Tie0_4_4__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, Tie0_4_4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Mem32_RC128X5_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Mem32_RC256X5_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Mem32_RC5125_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_3__Mem64_RC128X5_1__Tie0_4_4__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, Tie0_4_4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__Mem64_RC256X5_1__Tie0_4_4__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, Tie0_4_4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Mem64_RC128X5_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Mem64_RC256X5_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_3__Mem64_RC5125_1__Tie0_4_4__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, Tie0_4_4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Mem64_RC5125_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Tie0_1_1__Tie1_2_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_2_2, CVT_Done },
  // Convert__Reg1_1__Reg1_0__Tie0_2_2__Tie1_1_1
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Tied, Tie0_2_2, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__AbsMem161_0
  { CVT_95_addAbsMemOperands, 1, CVT_Done },
  // Convert__regEAX__regEAX__Tie0_1_1__Tie1_1_1
  { CVT_regEAX, 0, CVT_regEAX, 0, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_Done },
};

void X86AsmParser::
convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  Inst.setOpcode(Opcode);
  for (const uint8_t *p = Converter; *p; p += 2) {
    unsigned OpIdx = *(p + 1);
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      static_cast<X86Operand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_Tied: {
      assert(*(p + 1) < (size_t)(std::end(TiedAsmOperandTable) -
                              std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned TiedResOpnd = TiedAsmOperandTable[*(p + 1)][0];
      if (TiedResOpnd != (uint8_t)-1)
        Inst.addOperand(Inst.getOperand(TiedResOpnd));
      break;
    }
    case CVT_imm_95_10:
      Inst.addOperand(MCOperand::createImm(10));
      break;
    case CVT_95_addImmOperands:
      static_cast<X86Operand &>(*Operands[OpIdx]).addImmOperands(Inst, 1);
      break;
    case CVT_95_addMemOperands:
      static_cast<X86Operand &>(*Operands[OpIdx]).addMemOperands(Inst, 5);
      break;
    case CVT_95_Reg:
      static_cast<X86Operand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_regAX:
      Inst.addOperand(MCOperand::createReg(X86::AX));
      break;
    case CVT_regEAX:
      Inst.addOperand(MCOperand::createReg(X86::EAX));
      break;
    case CVT_regRAX:
      Inst.addOperand(MCOperand::createReg(X86::RAX));
      break;
    case CVT_95_addAbsMemOperands:
      static_cast<X86Operand &>(*Operands[OpIdx]).addAbsMemOperands(Inst, 1);
      break;
    case CVT_imm_95_7:
      Inst.addOperand(MCOperand::createImm(7));
      break;
    case CVT_imm_95_3:
      Inst.addOperand(MCOperand::createImm(3));
      break;
    case CVT_imm_95_2:
      Inst.addOperand(MCOperand::createImm(2));
      break;
    case CVT_imm_95_6:
      Inst.addOperand(MCOperand::createImm(6));
      break;
    case CVT_imm_95_4:
      Inst.addOperand(MCOperand::createImm(4));
      break;
    case CVT_imm_95_11:
      Inst.addOperand(MCOperand::createImm(11));
      break;
    case CVT_imm_95_15:
      Inst.addOperand(MCOperand::createImm(15));
      break;
    case CVT_imm_95_13:
      Inst.addOperand(MCOperand::createImm(13));
      break;
    case CVT_imm_95_12:
      Inst.addOperand(MCOperand::createImm(12));
      break;
    case CVT_imm_95_14:
      Inst.addOperand(MCOperand::createImm(14));
      break;
    case CVT_imm_95_5:
      Inst.addOperand(MCOperand::createImm(5));
      break;
    case CVT_imm_95_1:
      Inst.addOperand(MCOperand::createImm(1));
      break;
    case CVT_imm_95_9:
      Inst.addOperand(MCOperand::createImm(9));
      break;
    case CVT_imm_95_0:
      Inst.addOperand(MCOperand::createImm(0));
      break;
    case CVT_imm_95_8:
      Inst.addOperand(MCOperand::createImm(8));
      break;
    case CVT_95_addDstIdxOperands:
      static_cast<X86Operand &>(*Operands[OpIdx]).addDstIdxOperands(Inst, 1);
      break;
    case CVT_95_addSrcIdxOperands:
      static_cast<X86Operand &>(*Operands[OpIdx]).addSrcIdxOperands(Inst, 2);
      break;
    case CVT_95_addGR32orGR64Operands:
      static_cast<X86Operand &>(*Operands[OpIdx]).addGR32orGR64Operands(Inst, 1);
      break;
    case CVT_regST1:
      Inst.addOperand(MCOperand::createReg(X86::ST1));
      break;
    case CVT_regST0:
      Inst.addOperand(MCOperand::createReg(X86::ST0));
      break;
    case CVT_95_addGR16orGR32orGR64Operands:
      static_cast<X86Operand &>(*Operands[OpIdx]).addGR16orGR32orGR64Operands(Inst, 1);
      break;
    case CVT_95_addMemOffsOperands:
      static_cast<X86Operand &>(*Operands[OpIdx]).addMemOffsOperands(Inst, 2);
      break;
    case CVT_imm_95_17:
      Inst.addOperand(MCOperand::createImm(17));
      break;
    case CVT_imm_95_16:
      Inst.addOperand(MCOperand::createImm(16));
      break;
    case CVT_95_addTILEPairOperands:
      static_cast<X86Operand &>(*Operands[OpIdx]).addTILEPairOperands(Inst, 1);
      break;
    case CVT_95_addAVX512RCOperands:
      static_cast<X86Operand &>(*Operands[OpIdx]).addAVX512RCOperands(Inst, 1);
      break;
    case CVT_95_addMaskPairOperands:
      static_cast<X86Operand &>(*Operands[OpIdx]).addMaskPairOperands(Inst, 1);
      break;
    }
  }
}

void X86AsmParser::
convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  unsigned NumMCOperands = 0;
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p += 2) {
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      ++NumMCOperands;
      break;
    case CVT_Tied:
      ++NumMCOperands;
      break;
    case CVT_imm_95_10:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addMemOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 5;
      break;
    case CVT_95_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      NumMCOperands += 1;
      break;
    case CVT_regAX:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regEAX:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regRAX:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_addAbsMemOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_7:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_2:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_6:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_4:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_11:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_15:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_13:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_12:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_14:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_5:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_9:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_8:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addDstIdxOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addSrcIdxOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addGR32orGR64Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_regST1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regST0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_addGR16orGR32orGR64Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addMemOffsOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_imm_95_17:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_16:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addTILEPairOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addAVX512RCOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addMaskPairOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    }
  }
}

namespace {

/// MatchClassKind - The kinds of classes which participate in
/// instruction matching.
enum MatchClassKind {
  InvalidMatchClass = 0,
  OptionalMatchClass = 1,
  MCK__STAR_, // '*'
  MCK__123_, // '{'
  MCK__123_1to16_125_, // '{1to16}'
  MCK__123_1to2_125_, // '{1to2}'
  MCK__123_1to32_125_, // '{1to32}'
  MCK__123_1to4_125_, // '{1to4}'
  MCK__123_1to8_125_, // '{1to8}'
  MCK__123_sae_125_, // '{sae}'
  MCK__123_z_125_, // '{z}'
  MCK__125_, // '}'
  MCK_LAST_TOKEN = MCK__125_,
  MCK_Reg90, // derived register class
  MCK_Reg89, // derived register class
  MCK_Reg87, // derived register class
  MCK_Reg84, // derived register class
  MCK_Reg82, // derived register class
  MCK_Reg80, // derived register class
  MCK_Reg43, // derived register class
  MCK_Reg41, // derived register class
  MCK_Reg39, // derived register class
  MCK_Reg37, // derived register class
  MCK_AL, // register class 'AL'
  MCK_AX, // register class 'AX'
  MCK_CCR, // register class 'CCR'
  MCK_CL, // register class 'CL'
  MCK_CS, // register class 'CS'
  MCK_DFCCR, // register class 'DFCCR'
  MCK_DS, // register class 'DS'
  MCK_DX, // register class 'DX'
  MCK_EAX, // register class 'EAX'
  MCK_EBX, // register class 'EBX'
  MCK_ECX, // register class 'ECX'
  MCK_EDX, // register class 'EDX'
  MCK_ES, // register class 'ES'
  MCK_FPCCR, // register class 'FPCCR'
  MCK_FS, // register class 'FS'
  MCK_GS, // register class 'GS'
  MCK_RAX, // register class 'RAX'
  MCK_RBX, // register class 'RBX'
  MCK_RCX, // register class 'RCX'
  MCK_RDX, // register class 'RDX'
  MCK_RFP80_7, // register class 'RFP80_7'
  MCK_SS, // register class 'SS'
  MCK_ST0, // register class 'ST0'
  MCK_XMM0, // register class 'XMM0'
  MCK_Reg86, // derived register class
  MCK_Reg85, // derived register class
  MCK_Reg83, // derived register class
  MCK_Reg81, // derived register class
  MCK_Reg79, // derived register class
  MCK_Reg77, // derived register class
  MCK_Reg75, // derived register class
  MCK_GR32_AD, // register class 'GR32_AD'
  MCK_GR32_ArgRef, // register class 'GR32_ArgRef,GR32_DC'
  MCK_GR32_BPSP, // register class 'GR32_BPSP'
  MCK_GR32_BSI, // register class 'GR32_BSI'
  MCK_GR32_CB, // register class 'GR32_CB'
  MCK_GR32_DIBP, // register class 'GR32_DIBP'
  MCK_GR32_SIDI, // register class 'GR32_SIDI'
  MCK_GR64_AD, // register class 'GR64_AD'
  MCK_GR64_ArgRef, // register class 'GR64_ArgRef'
  MCK_Reg119, // derived register class
  MCK_Reg46, // derived register class
  MCK_Reg17, // derived register class
  MCK_Reg65, // derived register class
  MCK_GR16_ABCD, // register class 'GR16_ABCD'
  MCK_GR32_ABCD, // register class 'GR32_ABCD'
  MCK_GR32_TC, // register class 'GR32_TC'
  MCK_GR64_ABCD, // register class 'GR64_ABCD'
  MCK_GR8_ABCD_H, // register class 'GR8_ABCD_H'
  MCK_GR8_ABCD_L, // register class 'GR8_ABCD_L'
  MCK_TILEPAIR, // register class 'TILEPAIR'
  MCK_VK16PAIR, // register class 'VK16PAIR,VK1PAIR,VK2PAIR,VK4PAIR,VK8PAIR'
  MCK_Reg71, // derived register class
  MCK_Reg70, // derived register class
  MCK_Reg58, // derived register class
  MCK_Reg73, // derived register class
  MCK_Reg59, // derived register class
  MCK_SEGMENT_REG, // register class 'SEGMENT_REG'
  MCK_Reg72, // derived register class
  MCK_Reg68, // derived register class
  MCK_Reg63, // derived register class
  MCK_Reg62, // derived register class
  MCK_GR32_NOREX_NOSP, // register class 'GR32_NOREX_NOSP'
  MCK_GR64_NOREX_NOSP, // register class 'GR64_NOREX_NOSP'
  MCK_RFP32, // register class 'RFP32,RFP64,RFP80'
  MCK_VK16WM, // register class 'VK16WM,VK1WM,VK2WM,VK4WM,VK8WM,VK32WM,VK64WM'
  MCK_Reg69, // derived register class
  MCK_Reg66, // derived register class
  MCK_Reg64, // derived register class
  MCK_Reg49, // derived register class
  MCK_GR16_NOREX, // register class 'GR16_NOREX'
  MCK_GR32_NOREX, // register class 'GR32_NOREX'
  MCK_GR8_NOREX, // register class 'GR8_NOREX'
  MCK_RST, // register class 'RST'
  MCK_TILE, // register class 'TILE'
  MCK_VK1, // register class 'VK1,VK16,VK2,VK4,VK8,VK32,VK64'
  MCK_VR64, // register class 'VR64'
  MCK_Reg60, // derived register class
  MCK_Reg27, // derived register class
  MCK_GR64_NOREX, // register class 'GR64_NOREX'
  MCK_GR64_TCW64, // register class 'GR64_TCW64'
  MCK_GR64_TC, // register class 'GR64_TC'
  MCK_GR64PLTSafe, // register class 'GR64PLTSafe'
  MCK_GR32_NOREX2_NOSP, // register class 'GR32_NOREX2_NOSP'
  MCK_GR64_NOREX2_NOSP, // register class 'GR64_NOREX2_NOSP'
  MCK_Reg50, // derived register class
  MCK_CONTROL_REG, // register class 'CONTROL_REG'
  MCK_DEBUG_REG, // register class 'DEBUG_REG'
  MCK_FR16, // register class 'FR16,FR32,FR64,VR128'
  MCK_GR16_NOREX2, // register class 'GR16_NOREX2'
  MCK_GR32_NOREX2, // register class 'GR32_NOREX2'
  MCK_VR256, // register class 'VR256'
  MCK_VR512_0_15, // register class 'VR512_0_15'
  MCK_Reg26, // derived register class
  MCK_GR64_NOREX2, // register class 'GR64_NOREX2'
  MCK_GR8_NOREX2, // register class 'GR8_NOREX2'
  MCK_GRH8, // register class 'GRH8'
  MCK_GR32_NOSP, // register class 'GR32_NOSP'
  MCK_GR64_NOSP, // register class 'GR64_NOSP'
  MCK_Reg53, // derived register class
  MCK_FR16X, // register class 'FR16X,FR32X,FR64X,VR128X'
  MCK_GR16, // register class 'GR16'
  MCK_GR32, // register class 'GR32'
  MCK_VR256X, // register class 'VR256X'
  MCK_VR512, // register class 'VR512'
  MCK_Reg23, // derived register class
  MCK_GR64, // register class 'GR64'
  MCK_GRH16, // register class 'GRH16'
  MCK_LOW32_ADDR_ACCESS, // register class 'LOW32_ADDR_ACCESS'
  MCK_LOW32_ADDR_ACCESS_RBP, // register class 'LOW32_ADDR_ACCESS_RBP'
  MCK_GR8, // register class 'GR8'
  MCK_LAST_REGISTER = MCK_GR8,
  MCK_AVX512RC, // user defined class 'AVX512RCOperand'
  MCK_ImmSExti64i8, // user defined class 'ImmSExti64i8AsmOperand'
  MCK_ImmSExti16i8, // user defined class 'ImmSExti16i8AsmOperand'
  MCK_ImmSExti32i8, // user defined class 'ImmSExti32i8AsmOperand'
  MCK_ImmSExti64i32, // user defined class 'ImmSExti64i32AsmOperand'
  MCK_Imm, // user defined class 'ImmAsmOperand'
  MCK_ImmUnsignedi4, // user defined class 'ImmUnsignedi4AsmOperand'
  MCK_ImmUnsignedi8, // user defined class 'ImmUnsignedi8AsmOperand'
  MCK_TILEPair, // user defined class 'TILEPairAsmOperand'
  MCK_VK16Pair, // user defined class 'VK16PairAsmOperand'
  MCK_VK1Pair, // user defined class 'VK1PairAsmOperand'
  MCK_VK2Pair, // user defined class 'VK2PairAsmOperand'
  MCK_VK4Pair, // user defined class 'VK4PairAsmOperand'
  MCK_VK8Pair, // user defined class 'VK8PairAsmOperand'
  MCK_GR16orGR32orGR64, // user defined class 'X86GR16orGR32orGR64AsmOperand'
  MCK_GR32orGR64, // user defined class 'X86GR32orGR64AsmOperand'
  MCK_AbsMem16, // user defined class 'X86AbsMem16AsmOperand'
  MCK_DstIdx16, // user defined class 'X86DstIdx16Operand'
  MCK_DstIdx32, // user defined class 'X86DstIdx32Operand'
  MCK_DstIdx64, // user defined class 'X86DstIdx64Operand'
  MCK_DstIdx8, // user defined class 'X86DstIdx8Operand'
  MCK_MemOffs16_16, // user defined class 'X86MemOffs16_16AsmOperand'
  MCK_MemOffs16_32, // user defined class 'X86MemOffs16_32AsmOperand'
  MCK_MemOffs16_8, // user defined class 'X86MemOffs16_8AsmOperand'
  MCK_MemOffs32_16, // user defined class 'X86MemOffs32_16AsmOperand'
  MCK_MemOffs32_32, // user defined class 'X86MemOffs32_32AsmOperand'
  MCK_MemOffs32_64, // user defined class 'X86MemOffs32_64AsmOperand'
  MCK_MemOffs32_8, // user defined class 'X86MemOffs32_8AsmOperand'
  MCK_MemOffs64_16, // user defined class 'X86MemOffs64_16AsmOperand'
  MCK_MemOffs64_32, // user defined class 'X86MemOffs64_32AsmOperand'
  MCK_MemOffs64_64, // user defined class 'X86MemOffs64_64AsmOperand'
  MCK_MemOffs64_8, // user defined class 'X86MemOffs64_8AsmOperand'
  MCK_SrcIdx16, // user defined class 'X86SrcIdx16Operand'
  MCK_SrcIdx32, // user defined class 'X86SrcIdx32Operand'
  MCK_SrcIdx64, // user defined class 'X86SrcIdx64Operand'
  MCK_SrcIdx8, // user defined class 'X86SrcIdx8Operand'
  MCK_AbsMem, // user defined class 'X86AbsMemAsmOperand'
  MCK_Mem128, // user defined class 'X86Mem128AsmOperand'
  MCK_Mem16, // user defined class 'X86Mem16AsmOperand'
  MCK_Mem256, // user defined class 'X86Mem256AsmOperand'
  MCK_Mem32, // user defined class 'X86Mem32AsmOperand'
  MCK_Mem32_RC128, // user defined class 'X86Mem32_RC128Operand'
  MCK_Mem32_RC128X, // user defined class 'X86Mem32_RC128XOperand'
  MCK_Mem32_RC256, // user defined class 'X86Mem32_RC256Operand'
  MCK_Mem32_RC256X, // user defined class 'X86Mem32_RC256XOperand'
  MCK_Mem32_RC512, // user defined class 'X86Mem32_RC512Operand'
  MCK_Mem512, // user defined class 'X86Mem512AsmOperand'
  MCK_Mem512_GR16, // user defined class 'X86Mem512_GR16Operand'
  MCK_Mem512_GR32, // user defined class 'X86Mem512_GR32Operand'
  MCK_Mem512_GR64, // user defined class 'X86Mem512_GR64Operand'
  MCK_Mem64, // user defined class 'X86Mem64AsmOperand'
  MCK_Mem64_RC128, // user defined class 'X86Mem64_RC128Operand'
  MCK_Mem64_RC128X, // user defined class 'X86Mem64_RC128XOperand'
  MCK_Mem64_RC256, // user defined class 'X86Mem64_RC256Operand'
  MCK_Mem64_RC256X, // user defined class 'X86Mem64_RC256XOperand'
  MCK_Mem64_RC512, // user defined class 'X86Mem64_RC512Operand'
  MCK_Mem80, // user defined class 'X86Mem80AsmOperand'
  MCK_Mem8, // user defined class 'X86Mem8AsmOperand'
  MCK_SibMem, // user defined class 'X86SibMemOperand'
  MCK_Mem, // user defined class 'X86MemAsmOperand'
  NumMatchClassKinds
};

} // end anonymous namespace

static unsigned getDiagKindFromRegisterClass(MatchClassKind RegisterClass) {
  return MCTargetAsmParser::Match_InvalidOperand;
}

static MatchClassKind matchTokenString(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 1:	 // 3 strings to match.
    switch (Name[0]) {
    default: break;
    case '*':	 // 1 string to match.
      return MCK__STAR_;	 // "*"
    case '{':	 // 1 string to match.
      return MCK__123_;	 // "{"
    case '}':	 // 1 string to match.
      return MCK__125_;	 // "}"
    }
    break;
  case 3:	 // 1 string to match.
    if (memcmp(Name.data()+0, "{z}", 3) != 0)
      break;
    return MCK__123_z_125_;	 // "{z}"
  case 5:	 // 1 string to match.
    if (memcmp(Name.data()+0, "{sae}", 5) != 0)
      break;
    return MCK__123_sae_125_;	 // "{sae}"
  case 6:	 // 3 strings to match.
    if (memcmp(Name.data()+0, "{1to", 4) != 0)
      break;
    switch (Name[4]) {
    default: break;
    case '2':	 // 1 string to match.
      if (Name[5] != '}')
        break;
      return MCK__123_1to2_125_;	 // "{1to2}"
    case '4':	 // 1 string to match.
      if (Name[5] != '}')
        break;
      return MCK__123_1to4_125_;	 // "{1to4}"
    case '8':	 // 1 string to match.
      if (Name[5] != '}')
        break;
      return MCK__123_1to8_125_;	 // "{1to8}"
    }
    break;
  case 7:	 // 2 strings to match.
    if (memcmp(Name.data()+0, "{1to", 4) != 0)
      break;
    switch (Name[4]) {
    default: break;
    case '1':	 // 1 string to match.
      if (memcmp(Name.data()+5, "6}", 2) != 0)
        break;
      return MCK__123_1to16_125_;	 // "{1to16}"
    case '3':	 // 1 string to match.
      if (memcmp(Name.data()+5, "2}", 2) != 0)
        break;
      return MCK__123_1to32_125_;	 // "{1to32}"
    }
    break;
  }
  return InvalidMatchClass;
}

/// isSubclass - Compute whether \p A is a subclass of \p B.
static bool isSubclass(MatchClassKind A, MatchClassKind B) {
  if (A == B)
    return true;

  [[maybe_unused]] static constexpr struct {
    uint32_t Offset;
    uint16_t Start;
    uint16_t Length;
  } Table[] = {
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 46, 86},
    {86, 61, 68},
    {154, 47, 82},
    {236, 46, 86},
    {322, 48, 81},
    {403, 49, 80},
    {483, 55, 77},
    {560, 55, 77},
    {637, 58, 74},
    {711, 56, 76},
    {787, 71, 62},
    {849, 66, 58},
    {907, 0, 0},
    {907, 71, 62},
    {969, 79, 1},
    {970, 0, 0},
    {970, 79, 1},
    {971, 66, 58},
    {1029, 53, 79},
    {1108, 56, 76},
    {1184, 54, 78},
    {1262, 53, 79},
    {1341, 79, 1},
    {1342, 0, 0},
    {1342, 79, 1},
    {1343, 79, 1},
    {1344, 60, 69},
    {1413, 50, 79},
    {1492, 51, 78},
    {1570, 52, 77},
    {1647, 0, 0},
    {1647, 79, 1},
    {1648, 95, 1},
    {1649, 110, 13},
    {1662, 101, 31},
    {1693, 91, 38},
    {1731, 85, 44},
    {1775, 76, 53},
    {1828, 85, 44},
    {1872, 69, 60},
    {1932, 63, 66},
    {1998, 64, 68},
    {2066, 64, 68},
    {2134, 93, 39},
    {2173, 84, 48},
    {2221, 67, 65},
    {2286, 84, 48},
    {2334, 84, 48},
    {2382, 63, 66},
    {2448, 80, 49},
    {2497, 73, 1},
    {2498, 65, 64},
    {2562, 67, 65},
    {2627, 75, 54},
    {2681, 92, 32},
    {2713, 84, 48},
    {2761, 93, 39},
    {2800, 85, 44},
    {2844, 94, 39},
    {2883, 94, 39},
    {2922, 0, 0},
    {2922, 0, 0},
    {2922, 77, 52},
    {2974, 83, 46},
    {3020, 78, 51},
    {3071, 80, 49},
    {3120, 83, 46},
    {3166, 0, 0},
    {3166, 89, 40},
    {3206, 88, 41},
    {3247, 90, 39},
    {3286, 101, 28},
    {3314, 93, 39},
    {3353, 91, 38},
    {3391, 0, 0},
    {3391, 97, 1},
    {3392, 102, 27},
    {3419, 102, 27},
    {3446, 99, 30},
    {3476, 101, 28},
    {3504, 111, 13},
    {3517, 100, 32},
    {3549, 117, 16},
    {3565, 0, 0},
    {3565, 0, 0},
    {3565, 0, 0},
    {3565, 0, 0},
    {3565, 103, 26},
    {3591, 115, 17},
    {3608, 116, 13},
    {3621, 116, 13},
    {3634, 116, 13},
    {3647, 106, 23},
    {3670, 112, 20},
    {3690, 107, 22},
    {3712, 116, 13},
    {3725, 0, 0},
    {3725, 0, 0},
    {3725, 122, 1},
    {3726, 123, 1},
    {3727, 115, 17},
    {3744, 125, 1},
    {3745, 126, 1},
    {3746, 127, 5},
    {3751, 128, 1},
    {3752, 132, 1},
    {3753, 0, 0},
    {3753, 124, 8},
    {3761, 121, 8},
    {3769, 128, 1},
    {3770, 0, 0},
    {3770, 0, 0},
    {3770, 127, 5},
    {3775, 0, 0},
    {3775, 0, 0},
    {3775, 131, 1},
    {3776, 0, 0},
    {3776, 0, 0},
    {3776, 131, 1},
    {3777, 0, 0},
    {3777, 0, 0},
    {3777, 0, 0},
    {3777, 135, 4},
    {3781, 137, 2},
    {3783, 138, 1},
    {3784, 138, 1},
    {3785, 0, 0},
    {3785, 0, 0},
    {3785, 0, 0},
    {3785, 0, 0},
    {3785, 0, 0},
    {3785, 0, 0},
    {3785, 0, 0},
    {3785, 0, 0},
    {3785, 0, 0},
    {3785, 0, 0},
    {3785, 0, 0},
    {3785, 169, 24},
    {3809, 171, 22},
    {3831, 173, 20},
    {3851, 183, 10},
    {3861, 190, 3},
    {3864, 171, 22},
    {3886, 173, 20},
    {3906, 190, 3},
    {3909, 171, 22},
    {3931, 173, 20},
    {3951, 183, 10},
    {3961, 190, 3},
    {3964, 171, 22},
    {3986, 173, 20},
    {4006, 183, 10},
    {4016, 190, 3},
    {4019, 171, 22},
    {4041, 173, 20},
    {4061, 183, 10},
    {4071, 190, 3},
    {4074, 192, 1},
    {4075, 192, 1},
    {4076, 192, 1},
    {4077, 192, 1},
    {4078, 192, 1},
    {4079, 192, 1},
    {4080, 192, 1},
    {4081, 192, 1},
    {4082, 192, 1},
    {4083, 192, 1},
    {4084, 192, 1},
    {4085, 192, 1},
    {4086, 192, 1},
    {4087, 192, 1},
    {4088, 192, 1},
    {4089, 192, 1},
    {4090, 192, 1},
    {4091, 192, 1},
    {4092, 192, 1},
    {4093, 192, 1},
    {4094, 192, 1},
    {4095, 192, 1},
    {4096, 192, 1},
    {4097, 0, 0},
  };

  static constexpr uint8_t Data[] = {
    0x01,
    0x00,
    0x00,
    0x20,
    0x20,
    0x04,
    0x80,
    0x03,
    0x40,
    0x00,
    0x74,
    0x00,
    0x40,
    0x06,
    0x0E,
    0x90,
    0x19,
    0x20,
    0x06,
    0x06,
    0x00,
    0x10,
    0x40,
    0x52,
    0x58,
    0x40,
    0x47,
    0x80,
    0x10,
    0x78,
    0x00,
    0x00,
    0x00,
    0x00,
    0x08,
    0x02,
    0x4C,
    0x03,
    0xC6,
    0x60,
    0x0E,
    0x00,
    0x00,
    0x40,
    0xB1,
    0x30,
    0xA0,
    0x36,
    0x40,
    0x0C,
    0x1C,
    0x00,
    0x00,
    0x40,
    0xB1,
    0x30,
    0xA0,
    0x36,
    0x40,
    0x0C,
    0x0C,
    0x00,
    0x01,
    0x00,
    0x00,
    0x02,
    0x01,
    0x90,
    0x00,
    0xC9,
    0x09,
    0x00,
    0x00,
    0x20,
    0x40,
    0x20,
    0x04,
    0x12,
    0x21,
    0x79,
    0x00,
    0x00,
    0x80,
    0x00,
    0x81,
    0x10,
    0x48,
    0x84,
    0xE4,
    0x04,
    0x00,
    0x00,
    0x08,
    0x10,
    0x08,
    0x81,
    0x44,
    0x48,
    0x0E,
    0x00,
    0x00,
    0x04,
    0x00,
    0x00,
    0x02,
    0x00,
    0x03,
    0x00,
    0x00,
    0x08,
    0x00,
    0x40,
    0x00,
    0x0C,
    0x00,
    0x00,
    0x04,
    0x00,
    0x00,
    0x02,
    0x00,
    0x0F,
    0x00,
    0x00,
    0x20,
    0x00,
    0x00,
    0x01,
    0x30,
    0x00,
    0x19,
    0x00,
    0x10,
    0x20,
    0x10,
    0x02,
    0x89,
    0x90,
    0x3C,
    0x80,
    0x00,
    0x00,
    0x01,
    0x02,
    0x21,
    0x90,
    0x08,
    0xC9,
    0x09,
    0x64,
    0x00,
    0x40,
    0x80,
    0x40,
    0x08,
    0x24,
    0x42,
    0xF2,
    0x00,
    0x32,
    0x00,
    0x20,
    0x40,
    0x20,
    0x04,
    0x12,
    0x21,
    0xF9,
    0x29,
    0xC2,
    0xF7,
    0xF2,
    0x80,
    0xDE,
    0x00,
    0x31,
    0x70,
    0x00,
    0x00,
    0x01,
    0x00,
    0x41,
    0x00,
    0x69,
    0x80,
    0x18,
    0x38,
    0x00,
    0x45,
    0xF8,
    0x5E,
    0x1E,
    0xD0,
    0x1B,
    0x20,
    0x06,
    0x06,
    0xA4,
    0x08,
    0xDF,
    0xCB,
    0x03,
    0x7A,
    0x03,
    0xC4,
    0xC0,
    0x03,
    0x60,
    0x00,
    0x20,
    0x00,
    0x32,
    0x80,
    0x20,
    0x40,
    0x08,
    0x0C,
    0x02,
    0x48,
    0x03,
    0xC4,
    0xC0,
    0x62,
    0x61,
    0x40,
    0x6D,
    0x80,
    0x18,
    0x18,
    0x04,
    0x90,
    0x06,
    0x88,
    0x81,
    0x01,
    0x00,
    0x41,
    0x00,
    0x69,
    0x80,
    0x18,
    0x58,
    0x84,
    0xEF,
    0xE5,
    0x01,
    0xBD,
    0x01,
    0x62,
    0x60,
    0x06,
    0x00,
    0x04,
    0x08,
    0x84,
    0x40,
    0x22,
    0x24,
    0x67,
    0x00,
    0x40,
    0x80,
    0x40,
    0x08,
    0x24,
    0x42,
    0x72,
    0x20,
    0x00,
    0x12,
    0x20,
    0x39,
    0x40,
    0x20,
    0x04,
    0x12,
    0x21,
    0x39,
    0x00,
    0x40,
    0x80,
    0x40,
    0x08,
    0x24,
    0x42,
    0x72,
    0x80,
    0x40,
    0x08,
    0x24,
    0x42,
    0x72,
    0x80,
    0x40,
    0x08,
    0x24,
    0x42,
    0x72,
    0x11,
    0xBE,
    0x97,
    0x07,
    0xF4,
    0x06,
    0x88,
    0x81,
    0x01,
    0x02,
    0x40,
    0x0C,
    0x10,
    0x03,
    0x47,
    0xF8,
    0x5E,
    0x1E,
    0xD0,
    0x1B,
    0x20,
    0x06,
    0x0E,
    0x00,
    0x08,
    0x10,
    0x08,
    0x81,
    0x44,
    0x48,
    0x4E,
    0x0A,
    0x0B,
    0xE8,
    0x08,
    0x10,
    0x02,
    0x03,
    0x00,
    0x10,
    0x00,
    0x03,
    0x04,
    0x42,
    0x20,
    0x11,
    0x92,
    0x03,
    0x01,
    0x90,
    0x00,
    0xC9,
    0x41,
    0x00,
    0x69,
    0x80,
    0x18,
    0x18,
    0x00,
    0x00,
    0x08,
    0x00,
    0x0C,
    0x00,
    0x00,
    0x04,
    0x00,
    0xE6,
    0xE0,
    0x00,
    0xB9,
    0x01,
    0x62,
    0x60,
    0x08,
    0x00,
    0x07,
    0x80,
    0x00,
    0x18,
    0x0B,
    0x03,
    0x6A,
    0x03,
    0xC4,
    0xC0,
    0x81,
    0x03,
    0x64,
    0x06,
    0x88,
    0x81,
    0x01,
    0x01,
    0x15,
    0x01,
    0x42,
    0x60,
    0x00,
    0x88,
    0x01,
    0x62,
    0xE0,
    0x00,
    0x32,
    0x02,
    0x84,
    0xC0,
    0x00,
    0xB1,
    0x01,
    0x62,
    0x60,
    0x01,
    0x20,
    0x00,
    0x06,
    0x42,
    0x20,
    0x11,
    0x92,
    0x03,
    0x48,
    0x03,
    0xC4,
    0xC0,
    0x03,
    0x40,
    0x00,
    0x0C,
    0x01,
    0x42,
    0x60,
    0x64,
    0x80,
    0x18,
    0x18,
    0x04,
    0x08,
    0x81,
    0x01,
    0x30,
    0x00,
    0x12,
    0x20,
    0x39,
    0x00,
    0x30,
    0x02,
    0x84,
    0xC0,
    0x00,
    0x88,
    0x01,
    0x30,
    0x00,
    0x06,
    0xC0,
    0x01,
    0x62,
    0x60,
    0x22,
    0x24,
    0x07,
    0x88,
    0x81,
    0x21,
    0xF0,
    0x00,
    0xC9,
    0xC7,
    0x93,
    0x03,
    0xE7,
    0xFF,
    0x03,
    0x00,
    0x00,
    0x03,
    0x00,
    0xC0,
    0x00,
    0x00,
    0x0C,
    0xB0,
    0x01,
    0x00,
    0x60,
    0x00,
    0x00,
    0x36,
    0x00,
    0x00,
    0x0C,
    0x00,
    0xC0,
    0x00,
    0x1B,
    0x00,
    0x00,
    0x06,
    0x00,
    0x60,
    0x80,
    0x0D,
    0x00,
    0x00,
    0x03,
    0x00,
    0x30,
    0xC0,
    0xFE,
    0xFF,
    0xFF,
    0x01,
  };

  auto &Entry = Table[A];
  unsigned Idx = B - Entry.Start;
  if (Idx >= Entry.Length)
    return false;
  Idx += Entry.Offset;
  return (Data[Idx / 8] >> (Idx % 8)) & 1;
}

static unsigned validateOperandClass(MCParsedAsmOperand &GOp, MatchClassKind Kind) {
  X86Operand &Operand = (X86Operand &)GOp;
  if (Kind == InvalidMatchClass)
    return MCTargetAsmParser::Match_InvalidOperand;

  if (Operand.isToken() && Kind <= MCK_LAST_TOKEN)
    return isSubclass(matchTokenString(Operand.getToken()), Kind) ?
             MCTargetAsmParser::Match_Success :
             MCTargetAsmParser::Match_InvalidOperand;

  switch (Kind) {
  default: break;
  case MCK_AVX512RC: {
    DiagnosticPredicate DP(Operand.isAVX512RC());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_ImmSExti64i8: {
    DiagnosticPredicate DP(Operand.isImmSExti64i8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_ImmSExti16i8: {
    DiagnosticPredicate DP(Operand.isImmSExti16i8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_ImmSExti32i8: {
    DiagnosticPredicate DP(Operand.isImmSExti32i8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_ImmSExti64i32: {
    DiagnosticPredicate DP(Operand.isImmSExti64i32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Imm: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_ImmUnsignedi4: {
    DiagnosticPredicate DP(Operand.isImmUnsignedi4());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return X86AsmParser::Match_InvalidImmUnsignedi4;
    break;
  }
  case MCK_ImmUnsignedi8: {
    DiagnosticPredicate DP(Operand.isImmUnsignedi8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_TILEPair: {
    DiagnosticPredicate DP(Operand.isTILEPair());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_VK16Pair: {
    DiagnosticPredicate DP(Operand.isVK16Pair());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_VK1Pair: {
    DiagnosticPredicate DP(Operand.isVK1Pair());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_VK2Pair: {
    DiagnosticPredicate DP(Operand.isVK2Pair());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_VK4Pair: {
    DiagnosticPredicate DP(Operand.isVK4Pair());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_VK8Pair: {
    DiagnosticPredicate DP(Operand.isVK8Pair());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GR16orGR32orGR64: {
    DiagnosticPredicate DP(Operand.isGR16orGR32orGR64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GR32orGR64: {
    DiagnosticPredicate DP(Operand.isGR32orGR64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_AbsMem16: {
    DiagnosticPredicate DP(Operand.isAbsMem16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_DstIdx16: {
    DiagnosticPredicate DP(Operand.isDstIdx16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_DstIdx32: {
    DiagnosticPredicate DP(Operand.isDstIdx32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_DstIdx64: {
    DiagnosticPredicate DP(Operand.isDstIdx64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_DstIdx8: {
    DiagnosticPredicate DP(Operand.isDstIdx8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_MemOffs16_16: {
    DiagnosticPredicate DP(Operand.isMemOffs16_16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_MemOffs16_32: {
    DiagnosticPredicate DP(Operand.isMemOffs16_32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_MemOffs16_8: {
    DiagnosticPredicate DP(Operand.isMemOffs16_8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_MemOffs32_16: {
    DiagnosticPredicate DP(Operand.isMemOffs32_16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_MemOffs32_32: {
    DiagnosticPredicate DP(Operand.isMemOffs32_32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_MemOffs32_64: {
    DiagnosticPredicate DP(Operand.isMemOffs32_64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_MemOffs32_8: {
    DiagnosticPredicate DP(Operand.isMemOffs32_8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_MemOffs64_16: {
    DiagnosticPredicate DP(Operand.isMemOffs64_16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_MemOffs64_32: {
    DiagnosticPredicate DP(Operand.isMemOffs64_32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_MemOffs64_64: {
    DiagnosticPredicate DP(Operand.isMemOffs64_64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_MemOffs64_8: {
    DiagnosticPredicate DP(Operand.isMemOffs64_8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_SrcIdx16: {
    DiagnosticPredicate DP(Operand.isSrcIdx16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_SrcIdx32: {
    DiagnosticPredicate DP(Operand.isSrcIdx32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_SrcIdx64: {
    DiagnosticPredicate DP(Operand.isSrcIdx64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_SrcIdx8: {
    DiagnosticPredicate DP(Operand.isSrcIdx8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_AbsMem: {
    DiagnosticPredicate DP(Operand.isAbsMem());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Mem128: {
    DiagnosticPredicate DP(Operand.isMem128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Mem16: {
    DiagnosticPredicate DP(Operand.isMem16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Mem256: {
    DiagnosticPredicate DP(Operand.isMem256());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Mem32: {
    DiagnosticPredicate DP(Operand.isMem32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Mem32_RC128: {
    DiagnosticPredicate DP(Operand.isMem32_RC128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Mem32_RC128X: {
    DiagnosticPredicate DP(Operand.isMem32_RC128X());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Mem32_RC256: {
    DiagnosticPredicate DP(Operand.isMem32_RC256());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Mem32_RC256X: {
    DiagnosticPredicate DP(Operand.isMem32_RC256X());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Mem32_RC512: {
    DiagnosticPredicate DP(Operand.isMem32_RC512());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Mem512: {
    DiagnosticPredicate DP(Operand.isMem512());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Mem512_GR16: {
    DiagnosticPredicate DP(Operand.isMem512_GR16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Mem512_GR32: {
    DiagnosticPredicate DP(Operand.isMem512_GR32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Mem512_GR64: {
    DiagnosticPredicate DP(Operand.isMem512_GR64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Mem64: {
    DiagnosticPredicate DP(Operand.isMem64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Mem64_RC128: {
    DiagnosticPredicate DP(Operand.isMem64_RC128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Mem64_RC128X: {
    DiagnosticPredicate DP(Operand.isMem64_RC128X());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Mem64_RC256: {
    DiagnosticPredicate DP(Operand.isMem64_RC256());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Mem64_RC256X: {
    DiagnosticPredicate DP(Operand.isMem64_RC256X());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Mem64_RC512: {
    DiagnosticPredicate DP(Operand.isMem64_RC512());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Mem80: {
    DiagnosticPredicate DP(Operand.isMem80());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Mem8: {
    DiagnosticPredicate DP(Operand.isMem8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_SibMem: {
    DiagnosticPredicate DP(Operand.isSibMem());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Mem: {
    DiagnosticPredicate DP(Operand.isMem());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  } // end switch (Kind)

  if (Operand.isReg()) {
    static constexpr uint16_t Table[X86::NUM_TARGET_REGS] = {
      InvalidMatchClass,
      MCK_GR8_ABCD_H,
      MCK_AL,
      MCK_AX,
      MCK_GR8_ABCD_H,
      MCK_GR8_ABCD_L,
      MCK_GR16_NOREX,
      MCK_GRH8,
      MCK_GR8_NOREX2,
      MCK_GR16_ABCD,
      MCK_GR8_ABCD_H,
      MCK_CL,
      MCK_CS,
      MCK_GR16_ABCD,
      MCK_DFCCR,
      MCK_GR8_ABCD_H,
      MCK_GR16_NOREX,
      MCK_GRH8,
      MCK_GR8_NOREX2,
      MCK_GR8_ABCD_L,
      MCK_DS,
      MCK_DX,
      MCK_EAX,
      MCK_Reg41,
      MCK_EBX,
      MCK_ECX,
      MCK_Reg39,
      MCK_EDX,
      MCK_CCR,
      InvalidMatchClass,
      InvalidMatchClass,
      MCK_ES,
      MCK_Reg37,
      MCK_Reg43,
      InvalidMatchClass,
      MCK_FPCCR,
      MCK_FS,
      InvalidMatchClass,
      MCK_GS,
      InvalidMatchClass,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      InvalidMatchClass,
      InvalidMatchClass,
      MCK_RAX,
      MCK_Reg84,
      MCK_RBX,
      MCK_RCX,
      MCK_Reg82,
      MCK_RDX,
      InvalidMatchClass,
      MCK_Reg90,
      InvalidMatchClass,
      MCK_Reg80,
      MCK_Reg87,
      MCK_GR16_NOREX,
      MCK_GRH8,
      MCK_GR8_NOREX2,
      MCK_GR16_NOREX,
      MCK_GRH8,
      MCK_GR8_NOREX2,
      MCK_SS,
      InvalidMatchClass,
      InvalidMatchClass,
      MCK_CONTROL_REG,
      MCK_CONTROL_REG,
      MCK_CONTROL_REG,
      MCK_CONTROL_REG,
      MCK_CONTROL_REG,
      MCK_CONTROL_REG,
      MCK_CONTROL_REG,
      MCK_CONTROL_REG,
      MCK_CONTROL_REG,
      MCK_CONTROL_REG,
      MCK_CONTROL_REG,
      MCK_CONTROL_REG,
      MCK_CONTROL_REG,
      MCK_CONTROL_REG,
      MCK_CONTROL_REG,
      MCK_CONTROL_REG,
      MCK_DEBUG_REG,
      MCK_DEBUG_REG,
      MCK_DEBUG_REG,
      MCK_DEBUG_REG,
      MCK_DEBUG_REG,
      MCK_DEBUG_REG,
      MCK_DEBUG_REG,
      MCK_DEBUG_REG,
      MCK_DEBUG_REG,
      MCK_DEBUG_REG,
      MCK_DEBUG_REG,
      MCK_DEBUG_REG,
      MCK_DEBUG_REG,
      MCK_DEBUG_REG,
      MCK_DEBUG_REG,
      MCK_DEBUG_REG,
      MCK_RFP32,
      MCK_RFP32,
      MCK_RFP32,
      MCK_RFP32,
      MCK_RFP32,
      MCK_RFP32,
      MCK_RFP32,
      MCK_RFP80_7,
      MCK_VR64,
      MCK_VR64,
      MCK_VR64,
      MCK_VR64,
      MCK_VR64,
      MCK_VR64,
      MCK_VR64,
      MCK_VR64,
      MCK_Reg71,
      MCK_Reg71,
      MCK_GR64_ArgRef,
      MCK_Reg89,
      MCK_GR64PLTSafe,
      MCK_GR64PLTSafe,
      MCK_GR64PLTSafe,
      MCK_GR64PLTSafe,
      MCK_ST0,
      MCK_RST,
      MCK_RST,
      MCK_RST,
      MCK_RST,
      MCK_RST,
      MCK_RST,
      MCK_RST,
      MCK_XMM0,
      MCK_FR16,
      MCK_FR16,
      MCK_FR16,
      MCK_FR16,
      MCK_FR16,
      MCK_FR16,
      MCK_FR16,
      MCK_FR16,
      MCK_FR16,
      MCK_FR16,
      MCK_FR16,
      MCK_FR16,
      MCK_FR16,
      MCK_FR16,
      MCK_FR16,
      MCK_GR8_NOREX2,
      MCK_GR8_NOREX2,
      MCK_GR8_NOREX2,
      MCK_GR8_NOREX2,
      MCK_GR8_NOREX2,
      MCK_GR8_NOREX2,
      MCK_GR8_NOREX2,
      MCK_GR8_NOREX2,
      MCK_GRH8,
      MCK_GRH8,
      MCK_GRH8,
      MCK_GRH8,
      MCK_GRH8,
      MCK_GRH8,
      MCK_GRH8,
      MCK_GRH8,
      MCK_GR32_NOREX2_NOSP,
      MCK_GR32_NOREX2_NOSP,
      MCK_GR32_NOREX2_NOSP,
      MCK_GR32_NOREX2_NOSP,
      MCK_GR32_NOREX2_NOSP,
      MCK_GR32_NOREX2_NOSP,
      MCK_GR32_NOREX2_NOSP,
      MCK_GR32_NOREX2_NOSP,
      MCK_GR16_NOREX2,
      MCK_GR16_NOREX2,
      MCK_GR16_NOREX2,
      MCK_GR16_NOREX2,
      MCK_GR16_NOREX2,
      MCK_GR16_NOREX2,
      MCK_GR16_NOREX2,
      MCK_GR16_NOREX2,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_VR256,
      MCK_VR256,
      MCK_VR256,
      MCK_VR256,
      MCK_VR256,
      MCK_VR256,
      MCK_VR256,
      MCK_VR256,
      MCK_VR256,
      MCK_VR256,
      MCK_VR256,
      MCK_VR256,
      MCK_VR256,
      MCK_VR256,
      MCK_VR256,
      MCK_VR256,
      MCK_VK1,
      MCK_VK16WM,
      MCK_VK16WM,
      MCK_VK16WM,
      MCK_VK16WM,
      MCK_VK16WM,
      MCK_VK16WM,
      MCK_VK16WM,
      MCK_FR16X,
      MCK_FR16X,
      MCK_FR16X,
      MCK_FR16X,
      MCK_FR16X,
      MCK_FR16X,
      MCK_FR16X,
      MCK_FR16X,
      MCK_FR16X,
      MCK_FR16X,
      MCK_FR16X,
      MCK_FR16X,
      MCK_FR16X,
      MCK_FR16X,
      MCK_FR16X,
      MCK_FR16X,
      MCK_VR256X,
      MCK_VR256X,
      MCK_VR256X,
      MCK_VR256X,
      MCK_VR256X,
      MCK_VR256X,
      MCK_VR256X,
      MCK_VR256X,
      MCK_VR256X,
      MCK_VR256X,
      MCK_VR256X,
      MCK_VR256X,
      MCK_VR256X,
      MCK_VR256X,
      MCK_VR256X,
      MCK_VR256X,
      MCK_VR512_0_15,
      MCK_VR512_0_15,
      MCK_VR512_0_15,
      MCK_VR512_0_15,
      MCK_VR512_0_15,
      MCK_VR512_0_15,
      MCK_VR512_0_15,
      MCK_VR512_0_15,
      MCK_VR512_0_15,
      MCK_VR512_0_15,
      MCK_VR512_0_15,
      MCK_VR512_0_15,
      MCK_VR512_0_15,
      MCK_VR512_0_15,
      MCK_VR512_0_15,
      MCK_VR512_0_15,
      MCK_VR512,
      MCK_VR512,
      MCK_VR512,
      MCK_VR512,
      MCK_VR512,
      MCK_VR512,
      MCK_VR512,
      MCK_VR512,
      MCK_VR512,
      MCK_VR512,
      MCK_VR512,
      MCK_VR512,
      MCK_VR512,
      MCK_VR512,
      MCK_VR512,
      MCK_VR512,
      MCK_VK16PAIR,
      MCK_Reg119,
      MCK_Reg119,
      MCK_Reg119,
      InvalidMatchClass,
      MCK_TILE,
      MCK_TILE,
      MCK_TILE,
      MCK_TILE,
      MCK_TILE,
      MCK_TILE,
      MCK_TILE,
      MCK_TILE,
      MCK_TILEPAIR,
      MCK_TILEPAIR,
      MCK_TILEPAIR,
      MCK_TILEPAIR,
      MCK_GR64_NOSP,
      MCK_GR64_NOSP,
      MCK_GR64_NOSP,
      MCK_GR64_NOSP,
      MCK_GR64_NOSP,
      MCK_GR64_NOSP,
      MCK_GR64_NOSP,
      MCK_GR64_NOSP,
      MCK_GR64_NOSP,
      MCK_GR64_NOSP,
      MCK_GR64_NOSP,
      MCK_GR64_NOSP,
      MCK_GR64_NOSP,
      MCK_GR64_NOSP,
      MCK_GR64_NOSP,
      MCK_GR64_NOSP,
      MCK_GR8,
      MCK_GR8,
      MCK_GR8,
      MCK_GR8,
      MCK_GR8,
      MCK_GR8,
      MCK_GR8,
      MCK_GR8,
      MCK_GR8,
      MCK_GR8,
      MCK_GR8,
      MCK_GR8,
      MCK_GR8,
      MCK_GR8,
      MCK_GR8,
      MCK_GR8,
      MCK_GRH8,
      MCK_GRH8,
      MCK_GRH8,
      MCK_GRH8,
      MCK_GRH8,
      MCK_GRH8,
      MCK_GRH8,
      MCK_GRH8,
      MCK_GRH8,
      MCK_GRH8,
      MCK_GRH8,
      MCK_GRH8,
      MCK_GRH8,
      MCK_GRH8,
      MCK_GRH8,
      MCK_GRH8,
      MCK_GR32_NOSP,
      MCK_GR32_NOSP,
      MCK_GR32_NOSP,
      MCK_GR32_NOSP,
      MCK_GR32_NOSP,
      MCK_GR32_NOSP,
      MCK_GR32_NOSP,
      MCK_GR32_NOSP,
      MCK_GR32_NOSP,
      MCK_GR32_NOSP,
      MCK_GR32_NOSP,
      MCK_GR32_NOSP,
      MCK_GR32_NOSP,
      MCK_GR32_NOSP,
      MCK_GR32_NOSP,
      MCK_GR32_NOSP,
      MCK_GR16,
      MCK_GR16,
      MCK_GR16,
      MCK_GR16,
      MCK_GR16,
      MCK_GR16,
      MCK_GR16,
      MCK_GR16,
      MCK_GR16,
      MCK_GR16,
      MCK_GR16,
      MCK_GR16,
      MCK_GR16,
      MCK_GR16,
      MCK_GR16,
      MCK_GR16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
      MCK_GRH16,
    };

    MCRegister Reg = Operand.getReg();
    MatchClassKind OpKind = Reg.isPhysical() ? (MatchClassKind)Table[Reg.id()] : InvalidMatchClass;
    return isSubclass(OpKind, Kind) ? (unsigned)MCTargetAsmParser::Match_Success :
                                      getDiagKindFromRegisterClass(Kind);
  }

  if (Kind > MCK_LAST_TOKEN && Kind <= MCK_LAST_REGISTER)
    return getDiagKindFromRegisterClass(Kind);

  return MCTargetAsmParser::Match_InvalidOperand;
}

#ifndef NDEBUG
const char *getMatchClassName(MatchClassKind Kind) {
  switch (Kind) {
  case InvalidMatchClass: return "InvalidMatchClass";
  case OptionalMatchClass: return "OptionalMatchClass";
  case MCK__STAR_: return "MCK__STAR_";
  case MCK__123_: return "MCK__123_";
  case MCK__123_1to16_125_: return "MCK__123_1to16_125_";
  case MCK__123_1to2_125_: return "MCK__123_1to2_125_";
  case MCK__123_1to32_125_: return "MCK__123_1to32_125_";
  case MCK__123_1to4_125_: return "MCK__123_1to4_125_";
  case MCK__123_1to8_125_: return "MCK__123_1to8_125_";
  case MCK__123_sae_125_: return "MCK__123_sae_125_";
  case MCK__123_z_125_: return "MCK__123_z_125_";
  case MCK__125_: return "MCK__125_";
  case MCK_Reg90: return "MCK_Reg90";
  case MCK_Reg89: return "MCK_Reg89";
  case MCK_Reg87: return "MCK_Reg87";
  case MCK_Reg84: return "MCK_Reg84";
  case MCK_Reg82: return "MCK_Reg82";
  case MCK_Reg80: return "MCK_Reg80";
  case MCK_Reg43: return "MCK_Reg43";
  case MCK_Reg41: return "MCK_Reg41";
  case MCK_Reg39: return "MCK_Reg39";
  case MCK_Reg37: return "MCK_Reg37";
  case MCK_AL: return "MCK_AL";
  case MCK_AX: return "MCK_AX";
  case MCK_CCR: return "MCK_CCR";
  case MCK_CL: return "MCK_CL";
  case MCK_CS: return "MCK_CS";
  case MCK_DFCCR: return "MCK_DFCCR";
  case MCK_DS: return "MCK_DS";
  case MCK_DX: return "MCK_DX";
  case MCK_EAX: return "MCK_EAX";
  case MCK_EBX: return "MCK_EBX";
  case MCK_ECX: return "MCK_ECX";
  case MCK_EDX: return "MCK_EDX";
  case MCK_ES: return "MCK_ES";
  case MCK_FPCCR: return "MCK_FPCCR";
  case MCK_FS: return "MCK_FS";
  case MCK_GS: return "MCK_GS";
  case MCK_RAX: return "MCK_RAX";
  case MCK_RBX: return "MCK_RBX";
  case MCK_RCX: return "MCK_RCX";
  case MCK_RDX: return "MCK_RDX";
  case MCK_RFP80_7: return "MCK_RFP80_7";
  case MCK_SS: return "MCK_SS";
  case MCK_ST0: return "MCK_ST0";
  case MCK_XMM0: return "MCK_XMM0";
  case MCK_Reg86: return "MCK_Reg86";
  case MCK_Reg85: return "MCK_Reg85";
  case MCK_Reg83: return "MCK_Reg83";
  case MCK_Reg81: return "MCK_Reg81";
  case MCK_Reg79: return "MCK_Reg79";
  case MCK_Reg77: return "MCK_Reg77";
  case MCK_Reg75: return "MCK_Reg75";
  case MCK_GR32_AD: return "MCK_GR32_AD";
  case MCK_GR32_ArgRef: return "MCK_GR32_ArgRef";
  case MCK_GR32_BPSP: return "MCK_GR32_BPSP";
  case MCK_GR32_BSI: return "MCK_GR32_BSI";
  case MCK_GR32_CB: return "MCK_GR32_CB";
  case MCK_GR32_DIBP: return "MCK_GR32_DIBP";
  case MCK_GR32_SIDI: return "MCK_GR32_SIDI";
  case MCK_GR64_AD: return "MCK_GR64_AD";
  case MCK_GR64_ArgRef: return "MCK_GR64_ArgRef";
  case MCK_Reg119: return "MCK_Reg119";
  case MCK_Reg46: return "MCK_Reg46";
  case MCK_Reg17: return "MCK_Reg17";
  case MCK_Reg65: return "MCK_Reg65";
  case MCK_GR16_ABCD: return "MCK_GR16_ABCD";
  case MCK_GR32_ABCD: return "MCK_GR32_ABCD";
  case MCK_GR32_TC: return "MCK_GR32_TC";
  case MCK_GR64_ABCD: return "MCK_GR64_ABCD";
  case MCK_GR8_ABCD_H: return "MCK_GR8_ABCD_H";
  case MCK_GR8_ABCD_L: return "MCK_GR8_ABCD_L";
  case MCK_TILEPAIR: return "MCK_TILEPAIR";
  case MCK_VK16PAIR: return "MCK_VK16PAIR";
  case MCK_Reg71: return "MCK_Reg71";
  case MCK_Reg70: return "MCK_Reg70";
  case MCK_Reg58: return "MCK_Reg58";
  case MCK_Reg73: return "MCK_Reg73";
  case MCK_Reg59: return "MCK_Reg59";
  case MCK_SEGMENT_REG: return "MCK_SEGMENT_REG";
  case MCK_Reg72: return "MCK_Reg72";
  case MCK_Reg68: return "MCK_Reg68";
  case MCK_Reg63: return "MCK_Reg63";
  case MCK_Reg62: return "MCK_Reg62";
  case MCK_GR32_NOREX_NOSP: return "MCK_GR32_NOREX_NOSP";
  case MCK_GR64_NOREX_NOSP: return "MCK_GR64_NOREX_NOSP";
  case MCK_RFP32: return "MCK_RFP32";
  case MCK_VK16WM: return "MCK_VK16WM";
  case MCK_Reg69: return "MCK_Reg69";
  case MCK_Reg66: return "MCK_Reg66";
  case MCK_Reg64: return "MCK_Reg64";
  case MCK_Reg49: return "MCK_Reg49";
  case MCK_GR16_NOREX: return "MCK_GR16_NOREX";
  case MCK_GR32_NOREX: return "MCK_GR32_NOREX";
  case MCK_GR8_NOREX: return "MCK_GR8_NOREX";
  case MCK_RST: return "MCK_RST";
  case MCK_TILE: return "MCK_TILE";
  case MCK_VK1: return "MCK_VK1";
  case MCK_VR64: return "MCK_VR64";
  case MCK_Reg60: return "MCK_Reg60";
  case MCK_Reg27: return "MCK_Reg27";
  case MCK_GR64_NOREX: return "MCK_GR64_NOREX";
  case MCK_GR64_TCW64: return "MCK_GR64_TCW64";
  case MCK_GR64_TC: return "MCK_GR64_TC";
  case MCK_GR64PLTSafe: return "MCK_GR64PLTSafe";
  case MCK_GR32_NOREX2_NOSP: return "MCK_GR32_NOREX2_NOSP";
  case MCK_GR64_NOREX2_NOSP: return "MCK_GR64_NOREX2_NOSP";
  case MCK_Reg50: return "MCK_Reg50";
  case MCK_CONTROL_REG: return "MCK_CONTROL_REG";
  case MCK_DEBUG_REG: return "MCK_DEBUG_REG";
  case MCK_FR16: return "MCK_FR16";
  case MCK_GR16_NOREX2: return "MCK_GR16_NOREX2";
  case MCK_GR32_NOREX2: return "MCK_GR32_NOREX2";
  case MCK_VR256: return "MCK_VR256";
  case MCK_VR512_0_15: return "MCK_VR512_0_15";
  case MCK_Reg26: return "MCK_Reg26";
  case MCK_GR64_NOREX2: return "MCK_GR64_NOREX2";
  case MCK_GR8_NOREX2: return "MCK_GR8_NOREX2";
  case MCK_GRH8: return "MCK_GRH8";
  case MCK_GR32_NOSP: return "MCK_GR32_NOSP";
  case MCK_GR64_NOSP: return "MCK_GR64_NOSP";
  case MCK_Reg53: return "MCK_Reg53";
  case MCK_FR16X: return "MCK_FR16X";
  case MCK_GR16: return "MCK_GR16";
  case MCK_GR32: return "MCK_GR32";
  case MCK_VR256X: return "MCK_VR256X";
  case MCK_VR512: return "MCK_VR512";
  case MCK_Reg23: return "MCK_Reg23";
  case MCK_GR64: return "MCK_GR64";
  case MCK_GRH16: return "MCK_GRH16";
  case MCK_LOW32_ADDR_ACCESS: return "MCK_LOW32_ADDR_ACCESS";
  case MCK_LOW32_ADDR_ACCESS_RBP: return "MCK_LOW32_ADDR_ACCESS_RBP";
  case MCK_GR8: return "MCK_GR8";
  case MCK_AVX512RC: return "MCK_AVX512RC";
  case MCK_ImmSExti64i8: return "MCK_ImmSExti64i8";
  case MCK_ImmSExti16i8: return "MCK_ImmSExti16i8";
  case MCK_ImmSExti32i8: return "MCK_ImmSExti32i8";
  case MCK_ImmSExti64i32: return "MCK_ImmSExti64i32";
  case MCK_Imm: return "MCK_Imm";
  case MCK_ImmUnsignedi4: return "MCK_ImmUnsignedi4";
  case MCK_ImmUnsignedi8: return "MCK_ImmUnsignedi8";
  case MCK_TILEPair: return "MCK_TILEPair";
  case MCK_VK16Pair: return "MCK_VK16Pair";
  case MCK_VK1Pair: return "MCK_VK1Pair";
  case MCK_VK2Pair: return "MCK_VK2Pair";
  case MCK_VK4Pair: return "MCK_VK4Pair";
  case MCK_VK8Pair: return "MCK_VK8Pair";
  case MCK_GR16orGR32orGR64: return "MCK_GR16orGR32orGR64";
  case MCK_GR32orGR64: return "MCK_GR32orGR64";
  case MCK_AbsMem16: return "MCK_AbsMem16";
  case MCK_DstIdx16: return "MCK_DstIdx16";
  case MCK_DstIdx32: return "MCK_DstIdx32";
  case MCK_DstIdx64: return "MCK_DstIdx64";
  case MCK_DstIdx8: return "MCK_DstIdx8";
  case MCK_MemOffs16_16: return "MCK_MemOffs16_16";
  case MCK_MemOffs16_32: return "MCK_MemOffs16_32";
  case MCK_MemOffs16_8: return "MCK_MemOffs16_8";
  case MCK_MemOffs32_16: return "MCK_MemOffs32_16";
  case MCK_MemOffs32_32: return "MCK_MemOffs32_32";
  case MCK_MemOffs32_64: return "MCK_MemOffs32_64";
  case MCK_MemOffs32_8: return "MCK_MemOffs32_8";
  case MCK_MemOffs64_16: return "MCK_MemOffs64_16";
  case MCK_MemOffs64_32: return "MCK_MemOffs64_32";
  case MCK_MemOffs64_64: return "MCK_MemOffs64_64";
  case MCK_MemOffs64_8: return "MCK_MemOffs64_8";
  case MCK_SrcIdx16: return "MCK_SrcIdx16";
  case MCK_SrcIdx32: return "MCK_SrcIdx32";
  case MCK_SrcIdx64: return "MCK_SrcIdx64";
  case MCK_SrcIdx8: return "MCK_SrcIdx8";
  case MCK_AbsMem: return "MCK_AbsMem";
  case MCK_Mem128: return "MCK_Mem128";
  case MCK_Mem16: return "MCK_Mem16";
  case MCK_Mem256: return "MCK_Mem256";
  case MCK_Mem32: return "MCK_Mem32";
  case MCK_Mem32_RC128: return "MCK_Mem32_RC128";
  case MCK_Mem32_RC128X: return "MCK_Mem32_RC128X";
  case MCK_Mem32_RC256: return "MCK_Mem32_RC256";
  case MCK_Mem32_RC256X: return "MCK_Mem32_RC256X";
  case MCK_Mem32_RC512: return "MCK_Mem32_RC512";
  case MCK_Mem512: return "MCK_Mem512";
  case MCK_Mem512_GR16: return "MCK_Mem512_GR16";
  case MCK_Mem512_GR32: return "MCK_Mem512_GR32";
  case MCK_Mem512_GR64: return "MCK_Mem512_GR64";
  case MCK_Mem64: return "MCK_Mem64";
  case MCK_Mem64_RC128: return "MCK_Mem64_RC128";
  case MCK_Mem64_RC128X: return "MCK_Mem64_RC128X";
  case MCK_Mem64_RC256: return "MCK_Mem64_RC256";
  case MCK_Mem64_RC256X: return "MCK_Mem64_RC256X";
  case MCK_Mem64_RC512: return "MCK_Mem64_RC512";
  case MCK_Mem80: return "MCK_Mem80";
  case MCK_Mem8: return "MCK_Mem8";
  case MCK_SibMem: return "MCK_SibMem";
  case MCK_Mem: return "MCK_Mem";
  case NumMatchClassKinds: return "NumMatchClassKinds";
  }
  llvm_unreachable("unhandled MatchClassKind!");
}

#endif // NDEBUG
FeatureBitset X86AsmParser::
ComputeAvailableFeatures(const FeatureBitset &FB) const {
  FeatureBitset Features;
  if (!FB[X86::Is64Bit])
    Features.set(Feature_Not64BitModeBit);
  if (FB[X86::Is64Bit])
    Features.set(Feature_In64BitModeBit);
  if (FB[X86::Is16Bit])
    Features.set(Feature_In16BitModeBit);
  if (!FB[X86::Is16Bit])
    Features.set(Feature_Not16BitModeBit);
  if (FB[X86::Is32Bit])
    Features.set(Feature_In32BitModeBit);
  return Features;
}

static bool checkAsmTiedOperandConstraints(const X86AsmParser&AsmParser,
                               unsigned Kind, const OperandVector &Operands,
                               uint64_t &ErrorInfo) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p += 2) {
    switch (*p) {
    case CVT_Tied: {
      unsigned OpIdx = *(p + 1);
      assert(OpIdx < (size_t)(std::end(TiedAsmOperandTable) -
                              std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned OpndNum1 = TiedAsmOperandTable[OpIdx][1];
      unsigned OpndNum2 = TiedAsmOperandTable[OpIdx][2];
      if (OpndNum1 != OpndNum2) {
        auto &SrcOp1 = Operands[OpndNum1];
        auto &SrcOp2 = Operands[OpndNum2];
        if (!AsmParser.areEqualRegs(*SrcOp1, *SrcOp2)) {
          ErrorInfo = OpndNum2;
          return false;
        }
      }
      break;
    }
    default:
      break;
    }
  }
  return true;
}

static const char MnemonicTable[] =
    "\000\003aaa\003aad\004aadd\005aaddl\005aaddq\003aam\004aand\005aandl\005"
    "aandq\003aas\003adc\004adcb\004adcl\004adcq\004adcw\004adcx\005adcxl\005"
    "adcxq\003add\004addb\004addl\005addpd\005addps\004addq\006addr16\006add"
    "r32\005addsd\005addss\010addsubpd\010addsubps\004addw\004adox\005adoxl\005"
    "adoxq\006aesdec\013aesdec128kl\013aesdec256kl\naesdeclast\017aesdecwide"
    "128kl\017aesdecwide256kl\006aesenc\013aesenc128kl\013aesenc256kl\naesen"
    "clast\017aesencwide128kl\017aesencwide256kl\006aesimc\017aeskeygenassis"
    "t\003and\004andb\004andl\004andn\005andnl\006andnpd\006andnps\005andnq\005"
    "andpd\005andps\004andq\004andw\003aor\004aorl\004aorq\004arpl\004axor\005"
    "axorl\005axorq\005bextr\006bextrl\006bextrq\007blcfill\010blcfilll\010b"
    "lcfillq\004blci\005blcic\006blcicl\006blcicq\005blcil\005blciq\006blcms"
    "k\007blcmskl\007blcmskq\004blcs\005blcsl\005blcsq\007blendpd\007blendps"
    "\010blendvpd\010blendvps\007blsfill\010blsfilll\010blsfillq\004blsi\005"
    "blsic\006blsicl\006blsicq\005blsil\005blsiq\006blsmsk\007blsmskl\007bls"
    "mskq\004blsr\005blsrl\005blsrq\005bound\003bsf\004bsfl\004bsfq\004bsfw\003"
    "bsr\004bsrl\004bsrq\004bsrw\005bswap\006bswapl\006bswapq\002bt\003btc\004"
    "btcl\004btcq\004btcw\003btl\003btq\003btr\004btrl\004btrq\004btrw\003bt"
    "s\004btsl\004btsq\004btsw\003btw\004bzhi\005bzhil\005bzhiq\004call\005c"
    "alll\005callq\005callw\004cbtw\003cbw\005ccmpa\006ccmpab\006ccmpae\007c"
    "cmpaeb\007ccmpael\007ccmpaeq\007ccmpaew\006ccmpal\006ccmpaq\006ccmpaw\005"
    "ccmpb\006ccmpbb\006ccmpbe\007ccmpbeb\007ccmpbel\007ccmpbeq\007ccmpbew\006"
    "ccmpbl\006ccmpbq\006ccmpbw\005ccmpc\006ccmpcb\006ccmpcl\006ccmpcq\006cc"
    "mpcw\005ccmpe\006ccmpeb\006ccmpel\006ccmpeq\006ccmpew\005ccmpf\006ccmpf"
    "b\006ccmpfl\006ccmpfq\006ccmpfw\005ccmpg\006ccmpgb\006ccmpge\007ccmpgeb"
    "\007ccmpgel\007ccmpgeq\007ccmpgew\006ccmpgl\006ccmpgq\006ccmpgw\005ccmp"
    "l\006ccmplb\006ccmple\007ccmpleb\007ccmplel\007ccmpleq\007ccmplew\006cc"
    "mpll\006ccmplq\006ccmplw\006ccmpna\007ccmpnab\007ccmpnae\010ccmpnaeb\010"
    "ccmpnael\010ccmpnaeq\010ccmpnaew\007ccmpnal\007ccmpnaq\007ccmpnaw\006cc"
    "mpnb\007ccmpnbb\007ccmpnbe\010ccmpnbeb\010ccmpnbel\010ccmpnbeq\010ccmpn"
    "bew\007ccmpnbl\007ccmpnbq\007ccmpnbw\006ccmpnc\007ccmpncb\007ccmpncl\007"
    "ccmpncq\007ccmpncw\006ccmpne\007ccmpneb\007ccmpnel\007ccmpneq\007ccmpne"
    "w\006ccmpng\007ccmpngb\007ccmpnge\010ccmpngeb\010ccmpngel\010ccmpngeq\010"
    "ccmpngew\007ccmpngl\007ccmpngq\007ccmpngw\006ccmpnl\007ccmpnlb\007ccmpn"
    "le\010ccmpnleb\010ccmpnlel\010ccmpnleq\010ccmpnlew\007ccmpnll\007ccmpnl"
    "q\007ccmpnlw\006ccmpno\007ccmpnob\007ccmpnol\007ccmpnoq\007ccmpnow\006c"
    "cmpns\007ccmpnsb\007ccmpnsl\007ccmpnsq\007ccmpnsw\006ccmpnz\007ccmpnzb\007"
    "ccmpnzl\007ccmpnzq\007ccmpnzw\005ccmpo\006ccmpob\006ccmpol\006ccmpoq\006"
    "ccmpow\005ccmps\006ccmpsb\006ccmpsl\006ccmpsq\006ccmpsw\005ccmpt\006ccm"
    "ptb\006ccmptl\006ccmptq\006ccmptw\005ccmpz\006ccmpzb\006ccmpzl\006ccmpz"
    "q\006ccmpzw\003cdq\004cdqe\007cfcmova\010cfcmovae\tcfcmovael\tcfcmovaeq"
    "\tcfcmovaew\010cfcmoval\010cfcmovaq\010cfcmovaw\007cfcmovb\010cfcmovbe\t"
    "cfcmovbel\tcfcmovbeq\tcfcmovbew\010cfcmovbl\010cfcmovbq\010cfcmovbw\007"
    "cfcmove\010cfcmovel\010cfcmoveq\010cfcmovew\007cfcmovg\010cfcmovge\tcfc"
    "movgel\tcfcmovgeq\tcfcmovgew\010cfcmovgl\010cfcmovgq\010cfcmovgw\007cfc"
    "movl\010cfcmovle\tcfcmovlel\tcfcmovleq\tcfcmovlew\010cfcmovll\010cfcmov"
    "lq\010cfcmovlw\010cfcmovne\tcfcmovnel\tcfcmovneq\tcfcmovnew\010cfcmovno"
    "\tcfcmovnol\tcfcmovnoq\tcfcmovnow\010cfcmovnp\tcfcmovnpl\tcfcmovnpq\tcf"
    "cmovnpw\010cfcmovns\tcfcmovnsl\tcfcmovnsq\tcfcmovnsw\007cfcmovo\010cfcm"
    "ovol\010cfcmovoq\010cfcmovow\007cfcmovp\010cfcmovpl\010cfcmovpq\010cfcm"
    "ovpw\007cfcmovs\010cfcmovsl\010cfcmovsq\010cfcmovsw\004clac\003clc\003c"
    "ld\010cldemote\007clflush\nclflushopt\004clgi\003cli\003clr\004clrb\004"
    "clrl\004clrq\010clrssbsy\004clrw\004cltd\004cltq\004clts\004clui\004clw"
    "b\006clzero\003cmc\005cmova\006cmovae\007cmovael\007cmovaeq\007cmovaew\006"
    "cmoval\006cmovaq\006cmovaw\005cmovb\006cmovbe\007cmovbel\007cmovbeq\007"
    "cmovbew\006cmovbl\006cmovbq\006cmovbw\005cmove\006cmovel\006cmoveq\006c"
    "movew\005cmovg\006cmovge\007cmovgel\007cmovgeq\007cmovgew\006cmovgl\006"
    "cmovgq\006cmovgw\005cmovl\006cmovle\007cmovlel\007cmovleq\007cmovlew\006"
    "cmovll\006cmovlq\006cmovlw\006cmovne\007cmovnel\007cmovneq\007cmovnew\006"
    "cmovno\007cmovnol\007cmovnoq\007cmovnow\006cmovnp\007cmovnpl\007cmovnpq"
    "\007cmovnpw\006cmovns\007cmovnsl\007cmovnsq\007cmovnsw\005cmovo\006cmov"
    "ol\006cmovoq\006cmovow\005cmovp\006cmovpl\006cmovpq\006cmovpw\005cmovs\006"
    "cmovsl\006cmovsq\006cmovsw\003cmp\tcmpaexadd\010cmpaxadd\004cmpb\tcmpbe"
    "xadd\010cmpbxadd\010cmpexadd\tcmpgexadd\010cmpgxadd\004cmpl\tcmplexadd\010"
    "cmplxadd\tcmpnexadd\tcmpnoxadd\tcmpnpxadd\tcmpnsxadd\010cmpoxadd\005cmp"
    "pd\005cmpps\010cmppxadd\004cmpq\004cmps\005cmpsb\005cmpsd\005cmpsl\005c"
    "mpsq\005cmpss\005cmpsw\010cmpsxadd\004cmpw\007cmpxchg\ncmpxchg16b\tcmpx"
    "chg8b\010cmpxchgb\010cmpxchgl\010cmpxchgq\010cmpxchgw\006comisd\006comi"
    "ss\005cpuid\003cqo\004cqto\005crc32\006crc32b\006crc32l\006crc32q\006cr"
    "c32w\002cs\006ctesta\007ctestab\007ctestae\010ctestaeb\010ctestael\010c"
    "testaeq\010ctestaew\007ctestal\007ctestaq\007ctestaw\006ctestb\007ctest"
    "bb\007ctestbe\010ctestbeb\010ctestbel\010ctestbeq\010ctestbew\007ctestb"
    "l\007ctestbq\007ctestbw\006ctestc\007ctestcb\007ctestcl\007ctestcq\007c"
    "testcw\006cteste\007ctesteb\007ctestel\007ctesteq\007ctestew\006ctestf\007"
    "ctestfb\007ctestfl\007ctestfq\007ctestfw\006ctestg\007ctestgb\007ctestg"
    "e\010ctestgeb\010ctestgel\010ctestgeq\010ctestgew\007ctestgl\007ctestgq"
    "\007ctestgw\006ctestl\007ctestlb\007ctestle\010ctestleb\010ctestlel\010"
    "ctestleq\010ctestlew\007ctestll\007ctestlq\007ctestlw\007ctestna\010cte"
    "stnab\010ctestnae\tctestnaeb\tctestnael\tctestnaeq\tctestnaew\010ctestn"
    "al\010ctestnaq\010ctestnaw\007ctestnb\010ctestnbb\010ctestnbe\tctestnbe"
    "b\tctestnbel\tctestnbeq\tctestnbew\010ctestnbl\010ctestnbq\010ctestnbw\007"
    "ctestnc\010ctestncb\010ctestncl\010ctestncq\010ctestncw\007ctestne\010c"
    "testneb\010ctestnel\010ctestneq\010ctestnew\007ctestng\010ctestngb\010c"
    "testnge\tctestngeb\tctestngel\tctestngeq\tctestngew\010ctestngl\010ctes"
    "tngq\010ctestngw\007ctestnl\010ctestnlb\010ctestnle\tctestnleb\tctestnl"
    "el\tctestnleq\tctestnlew\010ctestnll\010ctestnlq\010ctestnlw\007ctestno"
    "\010ctestnob\010ctestnol\010ctestnoq\010ctestnow\007ctestns\010ctestnsb"
    "\010ctestnsl\010ctestnsq\010ctestnsw\007ctestnz\010ctestnzb\010ctestnzl"
    "\010ctestnzq\010ctestnzw\006ctesto\007ctestob\007ctestol\007ctestoq\007"
    "ctestow\006ctests\007ctestsb\007ctestsl\007ctestsq\007ctestsw\006ctestt"
    "\007ctesttb\007ctesttl\007ctesttq\007ctesttw\006ctestz\007ctestzb\007ct"
    "estzl\007ctestzq\007ctestzw\010cvtdq2pd\010cvtdq2ps\010cvtpd2dq\010cvtp"
    "d2pi\010cvtpd2ps\010cvtpi2pd\010cvtpi2ps\010cvtps2dq\010cvtps2pd\010cvt"
    "ps2pi\010cvtsd2si\tcvtsd2sil\tcvtsd2siq\010cvtsd2ss\010cvtsi2sd\tcvtsi2"
    "sdl\tcvtsi2sdq\010cvtsi2ss\tcvtsi2ssl\tcvtsi2ssq\010cvtss2sd\010cvtss2s"
    "i\tcvtss2sil\tcvtss2siq\tcvttpd2dq\tcvttpd2pi\tcvttps2dq\tcvttps2pi\tcv"
    "ttsd2si\ncvttsd2sil\ncvttsd2siq\tcvttss2si\ncvttss2sil\ncvttss2siq\003c"
    "wd\004cwde\004cwtd\004cwtl\003daa\003das\006data16\003dec\004decb\004de"
    "cl\004decq\004decw\003div\004divb\004divl\005divpd\005divps\004divq\005"
    "divsd\005divss\004divw\004dppd\004dpps\002ds\004emms\005encls\005enclu\005"
    "enclv\014encodekey128\014encodekey256\007endbr32\007endbr64\006enqcmd\007"
    "enqcmds\005enter\005erets\005eretu\002es\textractps\005extrq\005f2xm1\004"
    "fabs\004fadd\005faddl\005faddp\005fadds\004fbld\005fbstp\004fchs\006fcm"
    "ovb\007fcmovbe\006fcmove\007fcmovnb\010fcmovnbe\007fcmovne\007fcmovnu\006"
    "fcmovu\004fcom\005fcomi\005fcoml\005fcomp\006fcompi\006fcompl\006fcompp"
    "\006fcomps\005fcoms\004fcos\007fdecstp\004fdiv\005fdivl\005fdivp\005fdi"
    "vr\006fdivrl\006fdivrp\006fdivrs\005fdivs\005femms\005ffree\006ffreep\005"
    "fiadd\006fiaddl\006fiadds\005ficom\006ficoml\006ficomp\007ficompl\007fi"
    "comps\006ficoms\005fidiv\006fidivl\006fidivr\007fidivrl\007fidivrs\006f"
    "idivs\004fild\005fildl\006fildll\005filds\005fimul\006fimull\006fimuls\007"
    "fincstp\004fist\005fistl\005fistp\006fistpl\007fistpll\006fistps\005fis"
    "ts\006fisttp\007fisttpl\010fisttpll\007fisttps\005fisub\006fisubl\006fi"
    "subr\007fisubrl\007fisubrs\006fisubs\003fld\004fld1\005fldcw\006fldenv\004"
    "fldl\006fldl2e\006fldl2t\006fldlg2\006fldln2\005fldpi\004flds\004fldt\004"
    "fldz\004fmul\005fmull\005fmulp\005fmuls\006fnclex\006fninit\004fnop\006"
    "fnsave\006fnstcw\007fnstenv\006fnstsw\006fpatan\005fprem\006fprem1\005f"
    "ptan\007frndint\006frstor\002fs\006fscale\004fsin\007fsincos\005fsqrt\003"
    "fst\004fstl\004fstp\005fstpl\005fstps\005fstpt\004fsts\004fsub\005fsubl"
    "\005fsubp\005fsubr\006fsubrl\006fsubrp\006fsubrs\005fsubs\004ftst\005fu"
    "com\006fucomi\006fucomp\007fucompi\007fucompp\004fxam\004fxch\007fxrsto"
    "r\tfxrstor64\006fxsave\010fxsave64\007fxtract\005fyl2x\007fyl2xp1\006ge"
    "tsec\020gf2p8affineinvqb\015gf2p8affineqb\tgf2p8mulb\002gs\006haddpd\006"
    "haddps\003hlt\006hreset\006hsubpd\006hsubps\004idiv\005idivb\005idivl\005"
    "idivq\005idivw\004imul\005imulb\005imull\005imulq\005imulw\006imulzu\007"
    "imulzul\007imulzuq\007imulzuw\002in\003inb\003inc\004incb\004incl\004in"
    "cq\007incsspd\007incsspq\004incw\003inl\003ins\004insb\004insd\010inser"
    "tps\007insertq\004insl\004insw\003int\004int3\004into\004invd\006invept"
    "\006invlpg\007invlpga\007invlpgb\007invpcid\007invvpid\003inw\004iret\005"
    "iretd\005iretl\005iretq\005iretw\002ja\003jae\002jb\003jbe\004jcxz\002j"
    "e\005jecxz\002jg\003jge\002jl\003jle\003jmp\006jmpabs\004jmpl\004jmpq\004"
    "jmpw\003jne\003jno\003jnp\003jns\002jo\002jp\005jrcxz\002js\005kaddb\005"
    "kaddd\005kaddq\005kaddw\005kandb\005kandd\006kandnb\006kandnd\006kandnq"
    "\006kandnw\005kandq\005kandw\005kmovb\005kmovd\005kmovq\005kmovw\005kno"
    "tb\005knotd\005knotq\005knotw\004korb\004kord\004korq\010kortestb\010ko"
    "rtestd\010kortestq\010kortestw\004korw\010kshiftlb\010kshiftld\010kshif"
    "tlq\010kshiftlw\010kshiftrb\010kshiftrd\010kshiftrq\010kshiftrw\006ktes"
    "tb\006ktestd\006ktestq\006ktestw\010kunpckbw\010kunpckdq\010kunpckwd\006"
    "kxnorb\006kxnord\006kxnorq\006kxnorw\005kxorb\005kxord\005kxorq\005kxor"
    "w\004lahf\003lar\004larl\004larq\004larw\005lcall\006lcalll\006lcallq\006"
    "lcallw\005lddqu\007ldmxcsr\003lds\004ldsl\004ldsw\tldtilecfg\003lea\004"
    "leal\004leaq\005leave\004leaw\003les\004lesl\004lesw\006lfence\003lfs\004"
    "lfsl\004lfsq\004lfsw\004lgdt\005lgdtd\005lgdtl\005lgdtq\005lgdtw\003lgs"
    "\004lgsl\004lgsq\004lgsw\004lidt\005lidtd\005lidtl\005lidtq\005lidtw\004"
    "ljmp\005ljmpl\005ljmpq\005ljmpw\004lkgs\004lldt\005lldtw\006llwpcb\004l"
    "msw\005lmsww\tloadiwkey\004lock\004lods\005lodsb\005lodsd\005lodsl\005l"
    "odsq\005lodsw\004loop\005loope\006loopne\005lretl\005lretq\005lretw\003"
    "lsl\004lsll\004lslq\004lslw\003lss\004lssl\004lssq\004lssw\003ltr\004lt"
    "rw\006lwpins\006lwpval\005lzcnt\006lzcntl\006lzcntq\006lzcntw\nmaskmovd"
    "qu\010maskmovq\005maxpd\005maxps\005maxsd\005maxss\006mfence\005minpd\005"
    "minps\005minsd\005minss\007monitor\010monitorx\007montmul\003mov\005mov"
    ".s\006movabs\007movabsb\007movabsl\007movabsq\007movabsw\006movapd\010m"
    "ovapd.s\006movaps\010movaps.s\004movb\006movb.s\005movbe\006movbel\006m"
    "ovbeq\006movbew\004movd\007movddup\tmovdir64b\007movdiri\007movdq2q\006"
    "movdqa\010movdqa.s\006movdqu\010movdqu.s\007movhlps\006movhpd\006movhps"
    "\004movl\006movl.s\007movlhps\006movlpd\006movlps\010movmskpd\010movmsk"
    "ps\007movntdq\010movntdqa\006movnti\007movntil\007movntiq\007movntpd\007"
    "movntps\006movntq\007movntsd\007movntss\004movq\006movq.s\007movq2dq\005"
    "movrs\006movrsb\006movrsl\006movrsq\006movrsw\004movs\005movsb\006movsb"
    "l\006movsbq\006movsbw\005movsd\007movsd.s\010movshdup\005movsl\010movsl"
    "dup\006movslq\005movsq\005movss\007movss.s\005movsw\006movswl\006movswq"
    "\005movsx\006movsxd\006movupd\010movupd.s\006movups\010movups.s\004movw"
    "\006movw.s\006movzbl\006movzbq\006movzbw\006movzwl\006movzwq\005movzx\007"
    "mpsadbw\003mul\004mulb\004mull\005mulpd\005mulps\004mulq\005mulsd\005mu"
    "lss\004mulw\004mulx\005mulxl\005mulxq\005mwait\006mwaitx\003neg\004negb"
    "\004negl\004negq\004negw\003nop\004nopl\004nopq\004nopw\003not\004notb\004"
    "notl\004notq\004notw\002or\003orb\003orl\004orpd\004orps\003orq\003orw\003"
    "out\004outb\004outl\004outs\005outsb\005outsd\005outsl\005outsw\004outw"
    "\005pabsb\005pabsd\005pabsw\010packssdw\010packsswb\010packusdw\010pack"
    "uswb\005paddb\005paddd\005paddq\006paddsb\006paddsw\007paddusb\007paddu"
    "sw\005paddw\007palignr\004pand\005pandn\005pause\005pavgb\007pavgusb\005"
    "pavgw\010pblendvb\007pblendw\006pbndkb\014pclmulhqhqdq\014pclmulhqlqdq\014"
    "pclmullqhqdq\014pclmullqlqdq\tpclmulqdq\007pcmpeqb\007pcmpeqd\007pcmpeq"
    "q\007pcmpeqw\tpcmpestri\tpcmpestrm\007pcmpgtb\007pcmpgtd\007pcmpgtq\007"
    "pcmpgtw\tpcmpistri\tpcmpistrm\007pconfig\004pdep\005pdepl\005pdepq\004p"
    "ext\005pextl\005pextq\006pextrb\006pextrd\006pextrq\006pextrw\005pf2id\005"
    "pf2iw\005pfacc\005pfadd\007pfcmpeq\007pfcmpge\007pfcmpgt\005pfmax\005pf"
    "min\005pfmul\006pfnacc\007pfpnacc\005pfrcp\010pfrcpit1\010pfrcpit2\010p"
    "frsqit1\007pfrsqrt\005pfsub\006pfsubr\006phaddd\007phaddsw\006phaddw\np"
    "hminposuw\006phsubd\007phsubsw\006phsubw\005pi2fd\005pi2fw\006pinsrb\006"
    "pinsrd\006pinsrq\006pinsrw\tpmaddubsw\007pmaddwd\006pmaxsb\006pmaxsd\006"
    "pmaxsw\006pmaxub\006pmaxud\006pmaxuw\006pminsb\006pminsd\006pminsw\006p"
    "minub\006pminud\006pminuw\010pmovmskb\010pmovsxbd\010pmovsxbq\010pmovsx"
    "bw\010pmovsxdq\010pmovsxwd\010pmovsxwq\010pmovzxbd\010pmovzxbq\010pmovz"
    "xbw\010pmovzxdq\010pmovzxwd\010pmovzxwq\006pmuldq\010pmulhrsw\007pmulhr"
    "w\007pmulhuw\006pmulhw\006pmulld\006pmullw\007pmuludq\003pop\004pop2\005"
    "pop2p\005popal\005popaw\006popcnt\007popcntl\007popcntq\007popcntw\004p"
    "opf\005popfd\005popfl\005popfq\005popfw\004popl\004popp\004popq\004popw"
    "\003por\010prefetch\013prefetchit0\013prefetchit1\013prefetchnta\014pre"
    "fetchrst2\nprefetcht0\nprefetcht1\nprefetcht2\tprefetchw\013prefetchwt1"
    "\006psadbw\006pshufb\006pshufd\007pshufhw\007pshuflw\006pshufw\006psign"
    "b\006psignd\006psignw\005pslld\006pslldq\005psllq\005psllw\006psmash\005"
    "psrad\005psraw\005psrld\006psrldq\005psrlq\005psrlw\005psubb\005psubd\005"
    "psubq\006psubsb\006psubsw\007psubusb\007psubusw\005psubw\006pswapd\005p"
    "test\007ptwrite\010ptwritel\010ptwriteq\tpunpckhbw\tpunpckhdq\npunpckhq"
    "dq\tpunpckhwd\tpunpcklbw\tpunpckldq\npunpcklqdq\tpunpcklwd\004push\005p"
    "ush2\006push2p\006pushal\006pushaw\005pushf\006pushfd\006pushfl\006push"
    "fq\006pushfw\005pushl\005pushp\005pushq\005pushw\tpvalidate\004pxor\003"
    "rcl\004rclb\004rcll\004rclq\004rclw\005rcpps\005rcpss\003rcr\004rcrb\004"
    "rcrl\004rcrq\004rcrw\010rdfsbase\trdfsbasel\trdfsbaseq\010rdgsbase\trdg"
    "sbasel\trdgsbaseq\005rdmsr\trdmsrlist\005rdpid\006rdpkru\005rdpmc\005rd"
    "pru\006rdrand\007rdrandl\007rdrandq\007rdrandw\006rdseed\007rdseedl\007"
    "rdseedq\007rdseedw\006rdsspd\006rdsspq\005rdtsc\006rdtscp\003rep\005rep"
    "ne\003ret\004retf\005retfq\004retl\004retq\004retw\005rex64\trmpadjust\010"
    "rmpquery\trmpupdate\003rol\004rolb\004roll\004rolq\004rolw\003ror\004ro"
    "rb\004rorl\004rorq\004rorw\004rorx\005rorxl\005rorxq\007roundpd\007roun"
    "dps\007roundsd\007roundss\003rsm\007rsqrtps\007rsqrtss\010rstorssp\004s"
    "ahf\004salc\003sar\004sarb\004sarl\004sarq\004sarw\004sarx\005sarxl\005"
    "sarxq\013saveprevssp\003sbb\004sbbb\004sbbl\004sbbq\004sbbw\004scas\005"
    "scasb\005scasd\005scasl\005scasq\005scasw\010seamcall\007seamops\007sea"
    "mret\010senduipi\tserialize\004seta\005setae\004setb\005setbe\004sete\004"
    "setg\005setge\004setl\005setle\005setne\005setno\005setnp\005setns\004s"
    "eto\004setp\004sets\010setssbsy\006setzua\007setzuae\006setzub\007setzu"
    "be\006setzue\006setzug\007setzuge\006setzul\007setzule\007setzune\007se"
    "tzuno\007setzunp\007setzuns\006setzuo\006setzup\006setzus\006sfence\004"
    "sgdt\005sgdtd\005sgdtl\005sgdtq\005sgdtw\010sha1msg1\010sha1msg2\tsha1n"
    "exte\tsha1rnds4\nsha256msg1\nsha256msg2\013sha256rnds2\003shl\004shlb\004"
    "shld\005shldl\005shldq\005shldw\004shll\004shlq\004shlw\004shlx\005shlx"
    "l\005shlxq\003shr\004shrb\004shrd\005shrdl\005shrdq\005shrdw\004shrl\004"
    "shrq\004shrw\004shrx\005shrxl\005shrxq\006shufpd\006shufps\004sidt\005s"
    "idtd\005sidtl\005sidtq\005sidtw\006skinit\004sldt\005sldtl\005sldtq\005"
    "sldtw\006slwpcb\004smsw\005smswl\005smswq\005smsww\006sqrtpd\006sqrtps\006"
    "sqrtsd\006sqrtss\002ss\004stac\003stc\003std\004stgi\003sti\007stmxcsr\004"
    "stos\005stosb\005stosd\005stosl\005stosq\005stosw\003str\004strl\004str"
    "q\004strw\tsttilecfg\004stui\003sub\004subb\004subl\005subpd\005subps\004"
    "subq\005subsd\005subss\004subw\006swapgs\007syscall\010sysenter\007syse"
    "xit\010sysexitl\010sysexitq\006sysret\007sysretl\007sysretq\006t1mskc\007"
    "t1mskcl\007t1mskcq\013t2rpntlvwz0\015t2rpntlvwz0rs\017t2rpntlvwz0rst1\015"
    "t2rpntlvwz0t1\013t2rpntlvwz1\015t2rpntlvwz1rs\017t2rpntlvwz1rst1\015t2r"
    "pntlvwz1t1\014tcmmimfp16ps\014tcmmrlfp16ps\021tconjtcmmimfp16ps\ntconjt"
    "fp16\013tcvtrowd2ps\017tcvtrowps2bf16h\017tcvtrowps2bf16l\015tcvtrowps2"
    "phh\015tcvtrowps2phl\006tdcall\ttdpbf16ps\010tdpbf8ps\ttdpbhf8ps\007tdp"
    "bssd\007tdpbsud\007tdpbusd\007tdpbuud\ttdpfp16ps\ttdphbf8ps\010tdphf8ps"
    "\004test\005testb\005testl\005testq\006testui\005testw\ttileloadd\013ti"
    "leloaddrs\015tileloaddrst1\013tileloaddt1\ntilemovrow\013tilerelease\nt"
    "ilestored\010tilezero\007tlbsync\013tmmultf32ps\006tpause\015ttcmmimfp1"
    "6ps\015ttcmmrlfp16ps\nttdpbf16ps\nttdpfp16ps\014ttmmultf32ps\013ttransp"
    "osed\005tzcnt\006tzcntl\006tzcntq\006tzcntw\005tzmsk\006tzmskl\006tzmsk"
    "q\007ucomisd\007ucomiss\003ud1\004ud1l\004ud1q\004ud1w\003ud2\005uiret\010"
    "umonitor\006umwait\010unpckhpd\010unpckhps\010unpcklpd\010unpcklps\006u"
    "rdmsr\006uwrmsr\tv4fmaddps\tv4fmaddss\nv4fnmaddps\nv4fnmaddss\010vaddbf"
    "16\006vaddpd\006vaddph\006vaddps\006vaddsd\006vaddsh\006vaddss\tvaddsub"
    "pd\tvaddsubps\007vaesdec\013vaesdeclast\007vaesenc\013vaesenclast\007va"
    "esimc\020vaeskeygenassist\007valignd\007valignq\007vandnpd\007vandnps\006"
    "vandpd\006vandps\016vbcstnebf162ps\014vbcstnesh2ps\tvblendmpd\tvblendmp"
    "s\010vblendpd\010vblendps\tvblendvpd\tvblendvps\016vbroadcastf128\017vb"
    "roadcastf32x2\017vbroadcastf32x4\017vbroadcastf32x8\017vbroadcastf64x2\017"
    "vbroadcastf64x4\016vbroadcasti128\017vbroadcasti32x2\017vbroadcasti32x4"
    "\017vbroadcasti32x8\017vbroadcasti64x2\017vbroadcasti64x4\014vbroadcast"
    "sd\014vbroadcastss\010vcmpbf16\006vcmppd\006vcmpph\006vcmpps\006vcmpsd\006"
    "vcmpsh\006vcmpss\nvcomisbf16\007vcomisd\007vcomish\007vcomiss\013vcompr"
    "esspd\013vcompressps\007vcomxsd\007vcomxsh\007vcomxss\013vcvt2ph2bf8\014"
    "vcvt2ph2bf8s\013vcvt2ph2hf8\014vcvt2ph2hf8s\013vcvt2ps2phx\014vcvtbf162"
    "ibs\015vcvtbf162iubs\016vcvtbiasph2bf8\017vcvtbiasph2bf8s\016vcvtbiasph"
    "2hf8\017vcvtbiasph2hf8s\tvcvtdq2pd\tvcvtdq2ph\nvcvtdq2phx\nvcvtdq2phy\t"
    "vcvtdq2ps\nvcvthf82ph\016vcvtne2ps2bf16\016vcvtneebf162ps\014vcvtneeph2"
    "ps\016vcvtneobf162ps\014vcvtneoph2ps\015vcvtneps2bf16\016vcvtneps2bf16x"
    "\016vcvtneps2bf16y\tvcvtpd2dq\nvcvtpd2dqx\nvcvtpd2dqy\tvcvtpd2ph\nvcvtp"
    "d2phx\nvcvtpd2phy\nvcvtpd2phz\tvcvtpd2ps\nvcvtpd2psx\nvcvtpd2psy\tvcvtp"
    "d2qq\nvcvtpd2udq\013vcvtpd2udqx\013vcvtpd2udqy\nvcvtpd2uqq\nvcvtph2bf8\013"
    "vcvtph2bf8s\014vcvtph2bf8sx\014vcvtph2bf8sy\013vcvtph2bf8x\013vcvtph2bf"
    "8y\tvcvtph2dq\nvcvtph2hf8\013vcvtph2hf8s\014vcvtph2hf8sx\014vcvtph2hf8s"
    "y\013vcvtph2hf8x\013vcvtph2hf8y\nvcvtph2ibs\013vcvtph2iubs\tvcvtph2pd\t"
    "vcvtph2ps\nvcvtph2psx\tvcvtph2qq\nvcvtph2udq\nvcvtph2uqq\tvcvtph2uw\010"
    "vcvtph2w\tvcvtps2dq\nvcvtps2ibs\013vcvtps2iubs\tvcvtps2pd\tvcvtps2ph\nv"
    "cvtps2phx\013vcvtps2phxx\013vcvtps2phxy\tvcvtps2qq\nvcvtps2udq\nvcvtps2"
    "uqq\tvcvtqq2pd\tvcvtqq2ph\nvcvtqq2phx\nvcvtqq2phy\nvcvtqq2phz\tvcvtqq2p"
    "s\nvcvtqq2psx\nvcvtqq2psy\tvcvtsd2sh\tvcvtsd2si\nvcvtsd2sil\nvcvtsd2siq"
    "\tvcvtsd2ss\nvcvtsd2usi\013vcvtsd2usil\013vcvtsd2usiq\tvcvtsh2sd\tvcvts"
    "h2si\nvcvtsh2sil\nvcvtsh2siq\tvcvtsh2ss\nvcvtsh2usi\013vcvtsh2usil\013v"
    "cvtsh2usiq\tvcvtsi2sd\nvcvtsi2sdl\nvcvtsi2sdq\tvcvtsi2sh\nvcvtsi2shl\nv"
    "cvtsi2shq\tvcvtsi2ss\nvcvtsi2ssl\nvcvtsi2ssq\tvcvtss2sd\tvcvtss2sh\tvcv"
    "tss2si\nvcvtss2sil\nvcvtss2siq\nvcvtss2usi\013vcvtss2usil\013vcvtss2usi"
    "q\015vcvttbf162ibs\016vcvttbf162iubs\nvcvttpd2dq\013vcvttpd2dqs\014vcvt"
    "tpd2dqsx\014vcvttpd2dqsy\013vcvttpd2dqx\013vcvttpd2dqy\nvcvttpd2qq\013v"
    "cvttpd2qqs\013vcvttpd2udq\014vcvttpd2udqs\015vcvttpd2udqsx\015vcvttpd2u"
    "dqsy\014vcvttpd2udqx\014vcvttpd2udqy\013vcvttpd2uqq\014vcvttpd2uqqs\nvc"
    "vttph2dq\013vcvttph2ibs\014vcvttph2iubs\nvcvttph2qq\013vcvttph2udq\013v"
    "cvttph2uqq\nvcvttph2uw\tvcvttph2w\nvcvttps2dq\013vcvttps2dqs\013vcvttps"
    "2ibs\014vcvttps2iubs\nvcvttps2qq\013vcvttps2qqs\013vcvttps2udq\014vcvtt"
    "ps2udqs\013vcvttps2uqq\014vcvttps2uqqs\nvcvttsd2si\013vcvttsd2sil\013vc"
    "vttsd2siq\013vcvttsd2sis\013vcvttsd2usi\014vcvttsd2usil\014vcvttsd2usiq"
    "\014vcvttsd2usis\nvcvttsh2si\013vcvttsh2sil\013vcvttsh2siq\013vcvttsh2u"
    "si\014vcvttsh2usil\014vcvttsh2usiq\nvcvttss2si\013vcvttss2sil\013vcvtts"
    "s2siq\013vcvttss2sis\013vcvttss2usi\014vcvttss2usil\014vcvttss2usiq\014"
    "vcvttss2usis\nvcvtudq2pd\nvcvtudq2ph\013vcvtudq2phx\013vcvtudq2phy\nvcv"
    "tudq2ps\nvcvtuqq2pd\nvcvtuqq2ph\013vcvtuqq2phx\013vcvtuqq2phy\013vcvtuq"
    "q2phz\nvcvtuqq2ps\013vcvtuqq2psx\013vcvtuqq2psy\nvcvtusi2sd\013vcvtusi2"
    "sdl\013vcvtusi2sdq\nvcvtusi2sh\013vcvtusi2shl\013vcvtusi2shq\nvcvtusi2s"
    "s\013vcvtusi2ssl\013vcvtusi2ssq\tvcvtuw2ph\010vcvtw2ph\tvdbpsadbw\010vd"
    "ivbf16\006vdivpd\006vdivph\006vdivps\006vdivsd\006vdivsh\006vdivss\tvdp"
    "bf16ps\005vdppd\007vdpphps\005vdpps\004verr\004verw\007vexp2pd\007vexp2"
    "ps\tvexpandpd\tvexpandps\014vextractf128\015vextractf32x4\015vextractf3"
    "2x8\015vextractf64x2\015vextractf64x4\014vextracti128\015vextracti32x4\015"
    "vextracti32x8\015vextracti64x2\015vextracti64x4\nvextractps\nvfcmaddcph"
    "\nvfcmaddcsh\tvfcmulcph\tvfcmulcsh\013vfixupimmpd\013vfixupimmps\013vfi"
    "xupimmsd\013vfixupimmss\015vfmadd132bf16\013vfmadd132pd\013vfmadd132ph\013"
    "vfmadd132ps\013vfmadd132sd\013vfmadd132sh\013vfmadd132ss\015vfmadd213bf"
    "16\013vfmadd213pd\013vfmadd213ph\013vfmadd213ps\013vfmadd213sd\013vfmad"
    "d213sh\013vfmadd213ss\015vfmadd231bf16\013vfmadd231pd\013vfmadd231ph\013"
    "vfmadd231ps\013vfmadd231sd\013vfmadd231sh\013vfmadd231ss\tvfmaddcph\tvf"
    "maddcsh\010vfmaddpd\010vfmaddps\010vfmaddsd\010vfmaddss\016vfmaddsub132"
    "pd\016vfmaddsub132ph\016vfmaddsub132ps\016vfmaddsub213pd\016vfmaddsub21"
    "3ph\016vfmaddsub213ps\016vfmaddsub231pd\016vfmaddsub231ph\016vfmaddsub2"
    "31ps\013vfmaddsubpd\013vfmaddsubps\015vfmsub132bf16\013vfmsub132pd\013v"
    "fmsub132ph\013vfmsub132ps\013vfmsub132sd\013vfmsub132sh\013vfmsub132ss\015"
    "vfmsub213bf16\013vfmsub213pd\013vfmsub213ph\013vfmsub213ps\013vfmsub213"
    "sd\013vfmsub213sh\013vfmsub213ss\015vfmsub231bf16\013vfmsub231pd\013vfm"
    "sub231ph\013vfmsub231ps\013vfmsub231sd\013vfmsub231sh\013vfmsub231ss\016"
    "vfmsubadd132pd\016vfmsubadd132ph\016vfmsubadd132ps\016vfmsubadd213pd\016"
    "vfmsubadd213ph\016vfmsubadd213ps\016vfmsubadd231pd\016vfmsubadd231ph\016"
    "vfmsubadd231ps\013vfmsubaddpd\013vfmsubaddps\010vfmsubpd\010vfmsubps\010"
    "vfmsubsd\010vfmsubss\010vfmulcph\010vfmulcsh\016vfnmadd132bf16\014vfnma"
    "dd132pd\014vfnmadd132ph\014vfnmadd132ps\014vfnmadd132sd\014vfnmadd132sh"
    "\014vfnmadd132ss\016vfnmadd213bf16\014vfnmadd213pd\014vfnmadd213ph\014v"
    "fnmadd213ps\014vfnmadd213sd\014vfnmadd213sh\014vfnmadd213ss\016vfnmadd2"
    "31bf16\014vfnmadd231pd\014vfnmadd231ph\014vfnmadd231ps\014vfnmadd231sd\014"
    "vfnmadd231sh\014vfnmadd231ss\tvfnmaddpd\tvfnmaddps\tvfnmaddsd\tvfnmadds"
    "s\016vfnmsub132bf16\014vfnmsub132pd\014vfnmsub132ph\014vfnmsub132ps\014"
    "vfnmsub132sd\014vfnmsub132sh\014vfnmsub132ss\016vfnmsub213bf16\014vfnms"
    "ub213pd\014vfnmsub213ph\014vfnmsub213ps\014vfnmsub213sd\014vfnmsub213sh"
    "\014vfnmsub213ss\016vfnmsub231bf16\014vfnmsub231pd\014vfnmsub231ph\014v"
    "fnmsub231ps\014vfnmsub231sd\014vfnmsub231sh\014vfnmsub231ss\tvfnmsubpd\t"
    "vfnmsubps\tvfnmsubsd\tvfnmsubss\014vfpclassbf16\015vfpclassbf16x\015vfp"
    "classbf16y\015vfpclassbf16z\nvfpclasspd\013vfpclasspdx\013vfpclasspdy\013"
    "vfpclasspdz\nvfpclassph\013vfpclassphx\013vfpclassphy\013vfpclassphz\nv"
    "fpclassps\013vfpclasspsx\013vfpclasspsy\013vfpclasspsz\nvfpclasssd\nvfp"
    "classsh\nvfpclassss\007vfrczpd\007vfrczps\007vfrczsd\007vfrczss\nvgathe"
    "rdpd\nvgatherdps\015vgatherpf0dpd\015vgatherpf0dps\015vgatherpf0qpd\015"
    "vgatherpf0qps\015vgatherpf1dpd\015vgatherpf1dps\015vgatherpf1qpd\015vga"
    "therpf1qps\nvgatherqpd\nvgatherqps\013vgetexpbf16\tvgetexppd\tvgetexpph"
    "\tvgetexpps\tvgetexpsd\tvgetexpsh\tvgetexpss\014vgetmantbf16\nvgetmantp"
    "d\nvgetmantph\nvgetmantps\nvgetmantsd\nvgetmantsh\nvgetmantss\021vgf2p8"
    "affineinvqb\016vgf2p8affineqb\nvgf2p8mulb\007vhaddpd\007vhaddps\007vhsu"
    "bpd\007vhsubps\013vinsertf128\014vinsertf32x4\014vinsertf32x8\014vinser"
    "tf64x2\014vinsertf64x4\013vinserti128\014vinserti32x4\014vinserti32x8\014"
    "vinserti64x2\014vinserti64x4\tvinsertps\006vlddqu\010vldmxcsr\013vmaskm"
    "ovdqu\nvmaskmovpd\nvmaskmovps\010vmaxbf16\006vmaxpd\006vmaxph\006vmaxps"
    "\006vmaxsd\006vmaxsh\006vmaxss\006vmcall\007vmclear\006vmfunc\010vminbf"
    "16\013vminmaxbf16\tvminmaxpd\tvminmaxph\tvminmaxps\tvminmaxsd\tvminmaxs"
    "h\tvminmaxss\006vminpd\006vminph\006vminps\006vminsd\006vminsh\006vmins"
    "s\010vmlaunch\006vmload\007vmmcall\007vmovapd\tvmovapd.s\007vmovaps\tvm"
    "ovaps.s\005vmovd\007vmovd.s\010vmovddup\007vmovdqa\tvmovdqa.s\tvmovdqa3"
    "2\013vmovdqa32.s\tvmovdqa64\013vmovdqa64.s\007vmovdqu\tvmovdqu.s\tvmovd"
    "qu16\013vmovdqu16.s\tvmovdqu32\013vmovdqu32.s\tvmovdqu64\013vmovdqu64.s"
    "\010vmovdqu8\nvmovdqu8.s\010vmovhlps\007vmovhpd\007vmovhps\010vmovlhps\007"
    "vmovlpd\007vmovlps\tvmovmskpd\tvmovmskps\010vmovntdq\tvmovntdqa\010vmov"
    "ntpd\010vmovntps\005vmovq\007vmovq.s\007vmovrsb\007vmovrsd\007vmovrsq\007"
    "vmovrsw\006vmovsd\010vmovsd.s\006vmovsh\010vmovsh.s\tvmovshdup\tvmovsld"
    "up\006vmovss\010vmovss.s\007vmovupd\tvmovupd.s\007vmovups\tvmovups.s\005"
    "vmovw\007vmovw.s\010vmpsadbw\007vmptrld\007vmptrst\006vmread\007vmreadl"
    "\007vmreadq\010vmresume\005vmrun\006vmsave\010vmulbf16\006vmulpd\006vmu"
    "lph\006vmulps\006vmulsd\006vmulsh\006vmulss\007vmwrite\010vmwritel\010v"
    "mwriteq\006vmxoff\005vmxon\005vorpd\005vorps\015vp2intersectd\015vp2int"
    "ersectq\tvp4dpwssd\nvp4dpwssds\006vpabsb\006vpabsd\006vpabsq\006vpabsw\t"
    "vpackssdw\tvpacksswb\tvpackusdw\tvpackuswb\006vpaddb\006vpaddd\006vpadd"
    "q\007vpaddsb\007vpaddsw\010vpaddusb\010vpaddusw\006vpaddw\010vpalignr\005"
    "vpand\006vpandd\006vpandn\007vpandnd\007vpandnq\006vpandq\006vpavgb\006"
    "vpavgw\010vpblendd\tvpblendmb\tvpblendmd\tvpblendmq\tvpblendmw\tvpblend"
    "vb\010vpblendw\014vpbroadcastb\014vpbroadcastd\017vpbroadcastmb2q\017vp"
    "broadcastmw2d\014vpbroadcastq\014vpbroadcastw\015vpclmulhqhqdq\015vpclm"
    "ulhqlqdq\015vpclmullqhqdq\015vpclmullqlqdq\nvpclmulqdq\006vpcmov\006vpc"
    "mpb\006vpcmpd\010vpcmpeqb\010vpcmpeqd\010vpcmpeqq\010vpcmpeqw\nvpcmpest"
    "ri\nvpcmpestrm\010vpcmpgtb\010vpcmpgtd\010vpcmpgtq\010vpcmpgtw\nvpcmpis"
    "tri\nvpcmpistrm\006vpcmpq\007vpcmpub\007vpcmpud\007vpcmpuq\007vpcmpuw\006"
    "vpcmpw\006vpcomb\006vpcomd\013vpcompressb\013vpcompressd\013vpcompressq"
    "\013vpcompressw\006vpcomq\007vpcomub\007vpcomud\007vpcomuq\007vpcomuw\006"
    "vpcomw\013vpconflictd\013vpconflictq\010vpdpbssd\tvpdpbssds\010vpdpbsud"
    "\tvpdpbsuds\010vpdpbusd\tvpdpbusds\010vpdpbuud\tvpdpbuuds\010vpdpwssd\t"
    "vpdpwssds\010vpdpwsud\tvpdpwsuds\010vpdpwusd\tvpdpwusds\010vpdpwuud\tvp"
    "dpwuuds\nvperm2f128\nvperm2i128\006vpermb\006vpermd\010vpermi2b\010vper"
    "mi2d\tvpermi2pd\tvpermi2ps\010vpermi2q\010vpermi2w\nvpermil2pd\nvpermil"
    "2ps\tvpermilpd\tvpermilps\007vpermpd\007vpermps\006vpermq\010vpermt2b\010"
    "vpermt2d\tvpermt2pd\tvpermt2ps\010vpermt2q\010vpermt2w\006vpermw\tvpexp"
    "andb\tvpexpandd\tvpexpandq\tvpexpandw\007vpextrb\007vpextrd\007vpextrq\007"
    "vpextrw\nvpgatherdd\nvpgatherdq\nvpgatherqd\nvpgatherqq\010vphaddbd\010"
    "vphaddbq\010vphaddbw\007vphaddd\010vphadddq\010vphaddsw\tvphaddubd\tvph"
    "addubq\tvphaddubw\tvphaddudq\tvphadduwd\tvphadduwq\007vphaddw\010vphadd"
    "wd\010vphaddwq\013vphminposuw\010vphsubbw\007vphsubd\010vphsubdq\010vph"
    "subsw\007vphsubw\010vphsubwd\007vpinsrb\007vpinsrd\007vpinsrq\007vpinsr"
    "w\010vplzcntd\010vplzcntq\010vpmacsdd\tvpmacsdqh\tvpmacsdql\tvpmacssdd\n"
    "vpmacssdqh\nvpmacssdql\tvpmacsswd\tvpmacssww\010vpmacswd\010vpmacsww\nv"
    "pmadcsswd\tvpmadcswd\013vpmadd52huq\013vpmadd52luq\nvpmaddubsw\010vpmad"
    "dwd\nvpmaskmovd\nvpmaskmovq\007vpmaxsb\007vpmaxsd\007vpmaxsq\007vpmaxsw"
    "\007vpmaxub\007vpmaxud\007vpmaxuq\007vpmaxuw\007vpminsb\007vpminsd\007v"
    "pminsq\007vpminsw\007vpminub\007vpminud\007vpminuq\007vpminuw\010vpmovb"
    "2m\010vpmovd2m\007vpmovdb\007vpmovdw\010vpmovm2b\010vpmovm2d\010vpmovm2"
    "q\010vpmovm2w\tvpmovmskb\010vpmovq2m\007vpmovqb\007vpmovqd\007vpmovqw\010"
    "vpmovsdb\010vpmovsdw\010vpmovsqb\010vpmovsqd\010vpmovsqw\010vpmovswb\tv"
    "pmovsxbd\tvpmovsxbq\tvpmovsxbw\tvpmovsxdq\tvpmovsxwd\tvpmovsxwq\tvpmovu"
    "sdb\tvpmovusdw\tvpmovusqb\tvpmovusqd\tvpmovusqw\tvpmovuswb\010vpmovw2m\007"
    "vpmovwb\tvpmovzxbd\tvpmovzxbq\tvpmovzxbw\tvpmovzxdq\tvpmovzxwd\tvpmovzx"
    "wq\007vpmuldq\tvpmulhrsw\010vpmulhuw\007vpmulhw\007vpmulld\007vpmullq\007"
    "vpmullw\016vpmultishiftqb\010vpmuludq\010vpopcntb\010vpopcntd\010vpopcn"
    "tq\010vpopcntw\004vpor\005vpord\005vporq\006vpperm\006vprold\006vprolq\007"
    "vprolvd\007vprolvq\006vprord\006vprorq\007vprorvd\007vprorvq\006vprotb\006"
    "vprotd\006vprotq\006vprotw\007vpsadbw\013vpscatterdd\013vpscatterdq\013"
    "vpscatterqd\013vpscatterqq\006vpshab\006vpshad\006vpshaq\006vpshaw\006v"
    "pshlb\006vpshld\007vpshldd\007vpshldq\010vpshldvd\010vpshldvq\010vpshld"
    "vw\007vpshldw\006vpshlq\006vpshlw\007vpshrdd\007vpshrdq\010vpshrdvd\010"
    "vpshrdvq\010vpshrdvw\007vpshrdw\007vpshufb\014vpshufbitqmb\007vpshufd\010"
    "vpshufhw\010vpshuflw\007vpsignb\007vpsignd\007vpsignw\006vpslld\007vpsl"
    "ldq\006vpsllq\007vpsllvd\007vpsllvq\007vpsllvw\006vpsllw\006vpsrad\006v"
    "psraq\007vpsravd\007vpsravq\007vpsravw\006vpsraw\006vpsrld\007vpsrldq\006"
    "vpsrlq\007vpsrlvd\007vpsrlvq\007vpsrlvw\006vpsrlw\006vpsubb\006vpsubd\006"
    "vpsubq\007vpsubsb\007vpsubsw\010vpsubusb\010vpsubusw\006vpsubw\nvpternl"
    "ogd\nvpternlogq\006vptest\010vptestmb\010vptestmd\010vptestmq\010vptest"
    "mw\tvptestnmb\tvptestnmd\tvptestnmq\tvptestnmw\nvpunpckhbw\nvpunpckhdq\013"
    "vpunpckhqdq\nvpunpckhwd\nvpunpcklbw\nvpunpckldq\013vpunpcklqdq\nvpunpck"
    "lwd\005vpxor\006vpxord\006vpxorq\010vrangepd\010vrangeps\010vrangesd\010"
    "vrangess\010vrcp14pd\010vrcp14ps\010vrcp14sd\010vrcp14ss\010vrcp28pd\010"
    "vrcp28ps\010vrcp28sd\010vrcp28ss\010vrcpbf16\006vrcpph\006vrcpps\006vrc"
    "psh\006vrcpss\013vreducebf16\tvreducepd\tvreduceph\tvreduceps\tvreduces"
    "d\tvreducesh\tvreducess\015vrndscalebf16\013vrndscalepd\013vrndscaleph\013"
    "vrndscaleps\013vrndscalesd\013vrndscalesh\013vrndscaless\010vroundpd\010"
    "vroundps\010vroundsd\010vroundss\nvrsqrt14pd\nvrsqrt14ps\nvrsqrt14sd\nv"
    "rsqrt14ss\nvrsqrt28pd\nvrsqrt28ps\nvrsqrt28sd\nvrsqrt28ss\nvrsqrtbf16\010"
    "vrsqrtph\010vrsqrtps\010vrsqrtsh\010vrsqrtss\013vscalefbf16\tvscalefpd\t"
    "vscalefph\tvscalefps\tvscalefsd\tvscalefsh\tvscalefss\013vscatterdpd\013"
    "vscatterdps\016vscatterpf0dpd\016vscatterpf0dps\016vscatterpf0qpd\016vs"
    "catterpf0qps\016vscatterpf1dpd\016vscatterpf1dps\016vscatterpf1qpd\016v"
    "scatterpf1qps\013vscatterqpd\013vscatterqps\013vsha512msg1\013vsha512ms"
    "g2\014vsha512rnds2\nvshuff32x4\nvshuff64x2\nvshufi32x4\nvshufi64x2\007v"
    "shufpd\007vshufps\010vsm3msg1\010vsm3msg2\tvsm3rnds2\010vsm4key4\tvsm4r"
    "nds4\tvsqrtbf16\007vsqrtpd\007vsqrtph\007vsqrtps\007vsqrtsd\007vsqrtsh\007"
    "vsqrtss\010vstmxcsr\010vsubbf16\006vsubpd\006vsubph\006vsubps\006vsubsd"
    "\006vsubsh\006vsubss\007vtestpd\007vtestps\010vucomisd\010vucomish\010v"
    "ucomiss\010vucomxsd\010vucomxsh\010vucomxss\tvunpckhpd\tvunpckhps\tvunp"
    "cklpd\tvunpcklps\006vxorpd\006vxorps\010vzeroall\nvzeroupper\004wait\006"
    "wbinvd\010wbnoinvd\010wrfsbase\twrfsbasel\twrfsbaseq\010wrgsbase\twrgsb"
    "asel\twrgsbaseq\005wrmsr\twrmsrlist\007wrmsrns\006wrpkru\005wrssd\005wr"
    "ssq\006wrussd\006wrussq\006xabort\010xacquire\004xadd\005xaddb\005xaddl"
    "\005xaddq\005xaddw\006xbegin\004xchg\005xchgb\005xchgl\005xchgq\005xchg"
    "w\txcryptcbc\txcryptcfb\txcryptctr\txcryptecb\txcryptofb\004xend\006xge"
    "tbv\005xlatb\003xor\004xorb\004xorl\005xorpd\005xorps\004xorq\004xorw\010"
    "xrelease\txresldtrk\006xrstor\010xrstor64\007xrstors\txrstors64\005xsav"
    "e\007xsave64\006xsavec\010xsavec64\010xsaveopt\nxsaveopt64\006xsaves\010"
    "xsaves64\006xsetbv\005xsha1\007xsha256\006xstore\txstorerng\txsusldtrk\005"
    "xtest";

// Feature bitsets.
enum : uint8_t {
  AMFBS_None,
  AMFBS_In16BitMode,
  AMFBS_In32BitMode,
  AMFBS_In64BitMode,
  AMFBS_Not16BitMode,
  AMFBS_Not64BitMode,
};

static constexpr FeatureBitset FeatureBitsets[] = {
  {}, // AMFBS_None
  {Feature_In16BitModeBit, },
  {Feature_In32BitModeBit, },
  {Feature_In64BitModeBit, },
  {Feature_Not16BitModeBit, },
  {Feature_Not64BitModeBit, },
};

namespace {
  struct MatchEntry {
    uint16_t Mnemonic;
    uint16_t Opcode;
    uint16_t ConvertFn;
    uint8_t RequiredFeaturesIdx;
    uint8_t Classes[9];
    StringRef getMnemonic() const {
      return StringRef(MnemonicTable + Mnemonic + 1,
                       MnemonicTable[Mnemonic]);
    }
  };

  // Predicate for searching for an opcode.
  struct LessOpcode {
    bool operator()(const MatchEntry &LHS, StringRef RHS) {
      return LHS.getMnemonic() < RHS;
    }
    bool operator()(StringRef LHS, const MatchEntry &RHS) {
      return LHS < RHS.getMnemonic();
    }
    bool operator()(const MatchEntry &LHS, const MatchEntry &RHS) {
      return LHS.getMnemonic() < RHS.getMnemonic();
    }
  };
} // end anonymous namespace

static const MatchEntry MatchTable0[] = {
  { 1 /* aaa */, X86::AAA, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 5 /* aad */, X86::AAD8i8, Convert__imm_95_10, AMFBS_Not64BitMode, {  }, },
  { 5 /* aad */, X86::AAD8i8, Convert__Imm1_0, AMFBS_Not64BitMode, { MCK_Imm }, },
  { 14 /* aaddl */, X86::AADD32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 14 /* aaddl */, X86::AADD32mr_EVEX, Convert__Mem325_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 20 /* aaddq */, X86::AADD64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 20 /* aaddq */, X86::AADD64mr_EVEX, Convert__Mem645_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 26 /* aam */, X86::AAM8i8, Convert__imm_95_10, AMFBS_Not64BitMode, {  }, },
  { 26 /* aam */, X86::AAM8i8, Convert__Imm1_0, AMFBS_Not64BitMode, { MCK_Imm }, },
  { 35 /* aandl */, X86::AAND32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 35 /* aandl */, X86::AAND32mr_EVEX, Convert__Mem325_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 41 /* aandq */, X86::AAND64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 41 /* aandq */, X86::AAND64mr_EVEX, Convert__Mem645_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 47 /* aas */, X86::AAS, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 55 /* adcb */, X86::ADC8rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR8 }, },
  { 55 /* adcb */, X86::ADC8rr_EVEX, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_GR8 }, },
  { 55 /* adcb */, X86::ADC8mr, Convert__Mem85_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_Mem8 }, },
  { 55 /* adcb */, X86::ADC8mr_EVEX, Convert__Mem85_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_Mem8 }, },
  { 55 /* adcb */, X86::ADC8i8, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AL }, },
  { 55 /* adcb */, X86::ADC8ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR8 }, },
  { 55 /* adcb */, X86::ADC8ri_EVEX, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR8 }, },
  { 55 /* adcb */, X86::ADC8mi, Convert__Mem85_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem8 }, },
  { 55 /* adcb */, X86::ADC8mi_EVEX, Convert__Mem85_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem8 }, },
  { 55 /* adcb */, X86::ADC8rm, Convert__Reg1_1__Tie0_2_2__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR8 }, },
  { 55 /* adcb */, X86::ADC8rm_EVEX, Convert__Reg1_1__Tie0_2_2__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8, MCK_GR8 }, },
  { 55 /* adcb */, X86::ADC8rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_GR8, MCK_GR8 }, },
  { 55 /* adcb */, X86::ADC8mr_ND, Convert__Reg1_2__Mem85_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_Mem8, MCK_GR8 }, },
  { 55 /* adcb */, X86::ADC8ri_ND, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR8, MCK_GR8 }, },
  { 55 /* adcb */, X86::ADC8mi_ND, Convert__Reg1_2__Mem85_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem8, MCK_GR8 }, },
  { 55 /* adcb */, X86::ADC8rm_ND, Convert__Reg1_2__Reg1_1__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8, MCK_GR8, MCK_GR8 }, },
  { 60 /* adcl */, X86::ADC32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 60 /* adcl */, X86::ADC32rr_EVEX, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 60 /* adcl */, X86::ADC32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 60 /* adcl */, X86::ADC32mr_EVEX, Convert__Mem325_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 60 /* adcl */, X86::ADC32ri8, Convert__regEAX__Tie0_1_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_EAX }, },
  { 60 /* adcl */, X86::ADC32ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 60 /* adcl */, X86::ADC32ri8_EVEX, Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0, AMFBS_In64BitMode, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 60 /* adcl */, X86::ADC32mi8, Convert__Mem325_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 60 /* adcl */, X86::ADC32mi8_EVEX, Convert__Mem325_1__ImmSExti32i81_0, AMFBS_In64BitMode, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 60 /* adcl */, X86::ADC32i32, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_EAX }, },
  { 60 /* adcl */, X86::ADC32ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR32 }, },
  { 60 /* adcl */, X86::ADC32ri_EVEX, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR32 }, },
  { 60 /* adcl */, X86::ADC32mi, Convert__Mem325_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem32 }, },
  { 60 /* adcl */, X86::ADC32mi_EVEX, Convert__Mem325_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem32 }, },
  { 60 /* adcl */, X86::ADC32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 60 /* adcl */, X86::ADC32rm_EVEX, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 60 /* adcl */, X86::ADC32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 60 /* adcl */, X86::ADC32mr_ND, Convert__Reg1_2__Mem325_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 60 /* adcl */, X86::ADC32ri8_ND, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, AMFBS_In64BitMode, { MCK_ImmSExti32i8, MCK_GR32, MCK_GR32 }, },
  { 60 /* adcl */, X86::ADC32mi8_ND, Convert__Reg1_2__Mem325_1__ImmSExti32i81_0, AMFBS_In64BitMode, { MCK_ImmSExti32i8, MCK_Mem32, MCK_GR32 }, },
  { 60 /* adcl */, X86::ADC32ri_ND, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 60 /* adcl */, X86::ADC32mi_ND, Convert__Reg1_2__Mem325_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem32, MCK_GR32 }, },
  { 60 /* adcl */, X86::ADC32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 65 /* adcq */, X86::ADC64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 65 /* adcq */, X86::ADC64rr_EVEX, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 65 /* adcq */, X86::ADC64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 65 /* adcq */, X86::ADC64mr_EVEX, Convert__Mem645_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 65 /* adcq */, X86::ADC64ri8, Convert__regRAX__Tie0_1_1__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_RAX }, },
  { 65 /* adcq */, X86::ADC64ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 65 /* adcq */, X86::ADC64ri8_EVEX, Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 65 /* adcq */, X86::ADC64mi8, Convert__Mem645_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 65 /* adcq */, X86::ADC64mi8_EVEX, Convert__Mem645_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 65 /* adcq */, X86::ADC64i32, Convert__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 65 /* adcq */, X86::ADC64ri32, Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 65 /* adcq */, X86::ADC64ri32_EVEX, Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 65 /* adcq */, X86::ADC64mi32, Convert__Mem645_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 65 /* adcq */, X86::ADC64mi32_EVEX, Convert__Mem645_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 65 /* adcq */, X86::ADC64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 65 /* adcq */, X86::ADC64rm_EVEX, Convert__Reg1_1__Tie0_2_2__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 65 /* adcq */, X86::ADC64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 65 /* adcq */, X86::ADC64mr_ND, Convert__Reg1_2__Mem645_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 65 /* adcq */, X86::ADC64ri8_ND, Convert__Reg1_2__Reg1_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_GR64, MCK_GR64 }, },
  { 65 /* adcq */, X86::ADC64mi8_ND, Convert__Reg1_2__Mem645_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64, MCK_GR64 }, },
  { 65 /* adcq */, X86::ADC64ri32_ND, Convert__Reg1_2__Reg1_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_GR64, MCK_GR64 }, },
  { 65 /* adcq */, X86::ADC64mi32_ND, Convert__Reg1_2__Mem645_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64, MCK_GR64 }, },
  { 65 /* adcq */, X86::ADC64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 70 /* adcw */, X86::ADC16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 70 /* adcw */, X86::ADC16rr_EVEX, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 70 /* adcw */, X86::ADC16mr, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 70 /* adcw */, X86::ADC16mr_EVEX, Convert__Mem165_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 70 /* adcw */, X86::ADC16ri8, Convert__regAX__Tie0_1_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_AX }, },
  { 70 /* adcw */, X86::ADC16ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 70 /* adcw */, X86::ADC16ri8_EVEX, Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0, AMFBS_In64BitMode, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 70 /* adcw */, X86::ADC16mi8, Convert__Mem165_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 70 /* adcw */, X86::ADC16mi8_EVEX, Convert__Mem165_1__ImmSExti16i81_0, AMFBS_In64BitMode, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 70 /* adcw */, X86::ADC16i16, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AX }, },
  { 70 /* adcw */, X86::ADC16ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR16 }, },
  { 70 /* adcw */, X86::ADC16ri_EVEX, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR16 }, },
  { 70 /* adcw */, X86::ADC16mi, Convert__Mem165_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem16 }, },
  { 70 /* adcw */, X86::ADC16mi_EVEX, Convert__Mem165_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem16 }, },
  { 70 /* adcw */, X86::ADC16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 70 /* adcw */, X86::ADC16rm_EVEX, Convert__Reg1_1__Tie0_2_2__Mem165_0, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 70 /* adcw */, X86::ADC16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 70 /* adcw */, X86::ADC16mr_ND, Convert__Reg1_2__Mem165_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16, MCK_GR16 }, },
  { 70 /* adcw */, X86::ADC16ri8_ND, Convert__Reg1_2__Reg1_1__ImmSExti16i81_0, AMFBS_In64BitMode, { MCK_ImmSExti16i8, MCK_GR16, MCK_GR16 }, },
  { 70 /* adcw */, X86::ADC16mi8_ND, Convert__Reg1_2__Mem165_1__ImmSExti16i81_0, AMFBS_In64BitMode, { MCK_ImmSExti16i8, MCK_Mem16, MCK_GR16 }, },
  { 70 /* adcw */, X86::ADC16ri_ND, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR16, MCK_GR16 }, },
  { 70 /* adcw */, X86::ADC16mi_ND, Convert__Reg1_2__Mem165_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem16, MCK_GR16 }, },
  { 70 /* adcw */, X86::ADC16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 80 /* adcxl */, X86::ADCX32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 80 /* adcxl */, X86::ADCX32rr_EVEX, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 80 /* adcxl */, X86::ADCX32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 80 /* adcxl */, X86::ADCX32rm_EVEX, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 80 /* adcxl */, X86::ADCX32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 80 /* adcxl */, X86::ADCX32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 86 /* adcxq */, X86::ADCX64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 86 /* adcxq */, X86::ADCX64rr_EVEX, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 86 /* adcxq */, X86::ADCX64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 86 /* adcxq */, X86::ADCX64rm_EVEX, Convert__Reg1_1__Tie0_2_2__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 86 /* adcxq */, X86::ADCX64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 86 /* adcxq */, X86::ADCX64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 96 /* addb */, X86::ADD8rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR8 }, },
  { 96 /* addb */, X86::ADD8rr_NF, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_GR8 }, },
  { 96 /* addb */, X86::ADD8rr_EVEX, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_GR8 }, },
  { 96 /* addb */, X86::ADD8mr, Convert__Mem85_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_Mem8 }, },
  { 96 /* addb */, X86::ADD8mr_NF, Convert__Mem85_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_Mem8 }, },
  { 96 /* addb */, X86::ADD8mr_EVEX, Convert__Mem85_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_Mem8 }, },
  { 96 /* addb */, X86::ADD8i8, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AL }, },
  { 96 /* addb */, X86::ADD8ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR8 }, },
  { 96 /* addb */, X86::ADD8ri_NF, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR8 }, },
  { 96 /* addb */, X86::ADD8ri_EVEX, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR8 }, },
  { 96 /* addb */, X86::ADD8mi, Convert__Mem85_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem8 }, },
  { 96 /* addb */, X86::ADD8mi_NF, Convert__Mem85_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem8 }, },
  { 96 /* addb */, X86::ADD8mi_EVEX, Convert__Mem85_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem8 }, },
  { 96 /* addb */, X86::ADD8rm, Convert__Reg1_1__Tie0_2_2__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR8 }, },
  { 96 /* addb */, X86::ADD8rm_NF, Convert__Reg1_1__Tie0_2_2__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8, MCK_GR8 }, },
  { 96 /* addb */, X86::ADD8rm_EVEX, Convert__Reg1_1__Tie0_2_2__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8, MCK_GR8 }, },
  { 96 /* addb */, X86::ADD8rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_GR8, MCK_GR8 }, },
  { 96 /* addb */, X86::ADD8rr_NF_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_GR8, MCK_GR8 }, },
  { 96 /* addb */, X86::ADD8mr_ND, Convert__Reg1_2__Mem85_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_Mem8, MCK_GR8 }, },
  { 96 /* addb */, X86::ADD8mr_NF_ND, Convert__Reg1_2__Mem85_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_Mem8, MCK_GR8 }, },
  { 96 /* addb */, X86::ADD8ri_ND, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR8, MCK_GR8 }, },
  { 96 /* addb */, X86::ADD8ri_NF_ND, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR8, MCK_GR8 }, },
  { 96 /* addb */, X86::ADD8mi_ND, Convert__Reg1_2__Mem85_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem8, MCK_GR8 }, },
  { 96 /* addb */, X86::ADD8mi_NF_ND, Convert__Reg1_2__Mem85_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem8, MCK_GR8 }, },
  { 96 /* addb */, X86::ADD8rm_ND, Convert__Reg1_2__Reg1_1__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8, MCK_GR8, MCK_GR8 }, },
  { 96 /* addb */, X86::ADD8rm_NF_ND, Convert__Reg1_2__Reg1_1__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8, MCK_GR8, MCK_GR8 }, },
  { 101 /* addl */, X86::ADD32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32rr_NF, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32rr_EVEX, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 101 /* addl */, X86::ADD32mr_NF, Convert__Mem325_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 101 /* addl */, X86::ADD32mr_EVEX, Convert__Mem325_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 101 /* addl */, X86::ADD32ri8, Convert__regEAX__Tie0_1_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_EAX }, },
  { 101 /* addl */, X86::ADD32ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32ri8_NF, Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0, AMFBS_In64BitMode, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32ri8_EVEX, Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0, AMFBS_In64BitMode, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32mi8, Convert__Mem325_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 101 /* addl */, X86::ADD32mi8_NF, Convert__Mem325_1__ImmSExti32i81_0, AMFBS_In64BitMode, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 101 /* addl */, X86::ADD32mi8_EVEX, Convert__Mem325_1__ImmSExti32i81_0, AMFBS_In64BitMode, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 101 /* addl */, X86::ADD32i32, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_EAX }, },
  { 101 /* addl */, X86::ADD32ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32ri_NF, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32ri_EVEX, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32mi, Convert__Mem325_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem32 }, },
  { 101 /* addl */, X86::ADD32mi_NF, Convert__Mem325_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem32 }, },
  { 101 /* addl */, X86::ADD32mi_EVEX, Convert__Mem325_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem32 }, },
  { 101 /* addl */, X86::ADD32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32rm_NF, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32rm_EVEX, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32rr_NF_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32mr_ND, Convert__Reg1_2__Mem325_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32mr_NF_ND, Convert__Reg1_2__Mem325_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32ri8_ND, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, AMFBS_In64BitMode, { MCK_ImmSExti32i8, MCK_GR32, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32ri8_NF_ND, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, AMFBS_In64BitMode, { MCK_ImmSExti32i8, MCK_GR32, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32mi8_ND, Convert__Reg1_2__Mem325_1__ImmSExti32i81_0, AMFBS_In64BitMode, { MCK_ImmSExti32i8, MCK_Mem32, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32mi8_NF_ND, Convert__Reg1_2__Mem325_1__ImmSExti32i81_0, AMFBS_In64BitMode, { MCK_ImmSExti32i8, MCK_Mem32, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32ri_ND, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32ri_NF_ND, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32mi_ND, Convert__Reg1_2__Mem325_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem32, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32mi_NF_ND, Convert__Reg1_2__Mem325_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem32, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 101 /* addl */, X86::ADD32rm_NF_ND, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 106 /* addpd */, X86::ADDPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 106 /* addpd */, X86::ADDPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 112 /* addps */, X86::ADDPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 112 /* addps */, X86::ADDPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 118 /* addq */, X86::ADD64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64rr_NF, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64rr_EVEX, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 118 /* addq */, X86::ADD64mr_NF, Convert__Mem645_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 118 /* addq */, X86::ADD64mr_EVEX, Convert__Mem645_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 118 /* addq */, X86::ADD64ri8, Convert__regRAX__Tie0_1_1__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_RAX }, },
  { 118 /* addq */, X86::ADD64ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64ri8_NF, Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64ri8_EVEX, Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64mi8, Convert__Mem645_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 118 /* addq */, X86::ADD64mi8_NF, Convert__Mem645_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 118 /* addq */, X86::ADD64mi8_EVEX, Convert__Mem645_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 118 /* addq */, X86::ADD64i32, Convert__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 118 /* addq */, X86::ADD64ri32, Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64ri32_NF, Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64ri32_EVEX, Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64mi32, Convert__Mem645_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 118 /* addq */, X86::ADD64mi32_NF, Convert__Mem645_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 118 /* addq */, X86::ADD64mi32_EVEX, Convert__Mem645_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 118 /* addq */, X86::ADD64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64rm_NF, Convert__Reg1_1__Tie0_2_2__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64rm_EVEX, Convert__Reg1_1__Tie0_2_2__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64rr_NF_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64mr_ND, Convert__Reg1_2__Mem645_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64mr_NF_ND, Convert__Reg1_2__Mem645_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64ri8_ND, Convert__Reg1_2__Reg1_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_GR64, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64ri8_NF_ND, Convert__Reg1_2__Reg1_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_GR64, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64mi8_ND, Convert__Reg1_2__Mem645_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64mi8_NF_ND, Convert__Reg1_2__Mem645_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64ri32_ND, Convert__Reg1_2__Reg1_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_GR64, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64ri32_NF_ND, Convert__Reg1_2__Reg1_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_GR64, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64mi32_ND, Convert__Reg1_2__Mem645_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64mi32_NF_ND, Convert__Reg1_2__Mem645_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 118 /* addq */, X86::ADD64rm_NF_ND, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 123 /* addr16 */, X86::ADDR16_PREFIX, Convert_NoOperands, AMFBS_In32BitMode, {  }, },
  { 130 /* addr32 */, X86::ADDR32_PREFIX, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 137 /* addsd */, X86::ADDSDrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 137 /* addsd */, X86::ADDSDrm_Int, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 143 /* addss */, X86::ADDSSrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 143 /* addss */, X86::ADDSSrm_Int, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 149 /* addsubpd */, X86::ADDSUBPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 149 /* addsubpd */, X86::ADDSUBPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 158 /* addsubps */, X86::ADDSUBPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 158 /* addsubps */, X86::ADDSUBPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 167 /* addw */, X86::ADD16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16rr_NF, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16rr_EVEX, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16mr, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 167 /* addw */, X86::ADD16mr_NF, Convert__Mem165_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 167 /* addw */, X86::ADD16mr_EVEX, Convert__Mem165_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 167 /* addw */, X86::ADD16ri8, Convert__regAX__Tie0_1_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_AX }, },
  { 167 /* addw */, X86::ADD16ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16ri8_NF, Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0, AMFBS_In64BitMode, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16ri8_EVEX, Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0, AMFBS_In64BitMode, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16mi8, Convert__Mem165_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 167 /* addw */, X86::ADD16mi8_NF, Convert__Mem165_1__ImmSExti16i81_0, AMFBS_In64BitMode, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 167 /* addw */, X86::ADD16mi8_EVEX, Convert__Mem165_1__ImmSExti16i81_0, AMFBS_In64BitMode, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 167 /* addw */, X86::ADD16i16, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AX }, },
  { 167 /* addw */, X86::ADD16ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16ri_NF, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16ri_EVEX, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16mi, Convert__Mem165_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem16 }, },
  { 167 /* addw */, X86::ADD16mi_NF, Convert__Mem165_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem16 }, },
  { 167 /* addw */, X86::ADD16mi_EVEX, Convert__Mem165_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem16 }, },
  { 167 /* addw */, X86::ADD16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16rm_NF, Convert__Reg1_1__Tie0_2_2__Mem165_0, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16rm_EVEX, Convert__Reg1_1__Tie0_2_2__Mem165_0, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16rr_NF_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16mr_ND, Convert__Reg1_2__Mem165_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16mr_NF_ND, Convert__Reg1_2__Mem165_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16ri8_ND, Convert__Reg1_2__Reg1_1__ImmSExti16i81_0, AMFBS_In64BitMode, { MCK_ImmSExti16i8, MCK_GR16, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16ri8_NF_ND, Convert__Reg1_2__Reg1_1__ImmSExti16i81_0, AMFBS_In64BitMode, { MCK_ImmSExti16i8, MCK_GR16, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16mi8_ND, Convert__Reg1_2__Mem165_1__ImmSExti16i81_0, AMFBS_In64BitMode, { MCK_ImmSExti16i8, MCK_Mem16, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16mi8_NF_ND, Convert__Reg1_2__Mem165_1__ImmSExti16i81_0, AMFBS_In64BitMode, { MCK_ImmSExti16i8, MCK_Mem16, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16ri_ND, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR16, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16ri_NF_ND, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR16, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16mi_ND, Convert__Reg1_2__Mem165_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem16, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16mi_NF_ND, Convert__Reg1_2__Mem165_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem16, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 167 /* addw */, X86::ADD16rm_NF_ND, Convert__Reg1_2__Reg1_1__Mem165_0, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 177 /* adoxl */, X86::ADOX32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 177 /* adoxl */, X86::ADOX32rr_EVEX, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 177 /* adoxl */, X86::ADOX32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 177 /* adoxl */, X86::ADOX32rm_EVEX, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 177 /* adoxl */, X86::ADOX32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 177 /* adoxl */, X86::ADOX32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 183 /* adoxq */, X86::ADOX64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 183 /* adoxq */, X86::ADOX64rr_EVEX, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 183 /* adoxq */, X86::ADOX64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 183 /* adoxq */, X86::ADOX64rm_EVEX, Convert__Reg1_1__Tie0_2_2__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 183 /* adoxq */, X86::ADOX64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 183 /* adoxq */, X86::ADOX64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 189 /* aesdec */, X86::AESDECrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 189 /* aesdec */, X86::AESDECrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 196 /* aesdec128kl */, X86::AESDEC128KL, Convert__Reg1_1__Tie0_2_2__Mem5_0, AMFBS_None, { MCK_Mem, MCK_FR16 }, },
  { 208 /* aesdec256kl */, X86::AESDEC256KL, Convert__Reg1_1__Tie0_2_2__Mem5_0, AMFBS_None, { MCK_Mem, MCK_FR16 }, },
  { 220 /* aesdeclast */, X86::AESDECLASTrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 220 /* aesdeclast */, X86::AESDECLASTrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 231 /* aesdecwide128kl */, X86::AESDECWIDE128KL, Convert__Mem5_0, AMFBS_None, { MCK_Mem }, },
  { 247 /* aesdecwide256kl */, X86::AESDECWIDE256KL, Convert__Mem5_0, AMFBS_None, { MCK_Mem }, },
  { 263 /* aesenc */, X86::AESENCrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 263 /* aesenc */, X86::AESENCrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 270 /* aesenc128kl */, X86::AESENC128KL, Convert__Reg1_1__Tie0_2_2__Mem5_0, AMFBS_None, { MCK_Mem, MCK_FR16 }, },
  { 282 /* aesenc256kl */, X86::AESENC256KL, Convert__Reg1_1__Tie0_2_2__Mem5_0, AMFBS_None, { MCK_Mem, MCK_FR16 }, },
  { 294 /* aesenclast */, X86::AESENCLASTrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 294 /* aesenclast */, X86::AESENCLASTrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 305 /* aesencwide128kl */, X86::AESENCWIDE128KL, Convert__Mem5_0, AMFBS_None, { MCK_Mem }, },
  { 321 /* aesencwide256kl */, X86::AESENCWIDE256KL, Convert__Mem5_0, AMFBS_None, { MCK_Mem }, },
  { 337 /* aesimc */, X86::AESIMCrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 337 /* aesimc */, X86::AESIMCrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 344 /* aeskeygenassist */, X86::AESKEYGENASSIST128rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 344 /* aeskeygenassist */, X86::AESKEYGENASSIST128rm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 364 /* andb */, X86::AND8rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR8 }, },
  { 364 /* andb */, X86::AND8rr_NF, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_GR8 }, },
  { 364 /* andb */, X86::AND8rr_EVEX, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_GR8 }, },
  { 364 /* andb */, X86::AND8mr, Convert__Mem85_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_Mem8 }, },
  { 364 /* andb */, X86::AND8mr_NF, Convert__Mem85_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_Mem8 }, },
  { 364 /* andb */, X86::AND8mr_EVEX, Convert__Mem85_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_Mem8 }, },
  { 364 /* andb */, X86::AND8i8, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AL }, },
  { 364 /* andb */, X86::AND8ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR8 }, },
  { 364 /* andb */, X86::AND8ri_NF, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR8 }, },
  { 364 /* andb */, X86::AND8ri_EVEX, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR8 }, },
  { 364 /* andb */, X86::AND8mi, Convert__Mem85_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem8 }, },
  { 364 /* andb */, X86::AND8mi_NF, Convert__Mem85_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem8 }, },
  { 364 /* andb */, X86::AND8mi_EVEX, Convert__Mem85_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem8 }, },
  { 364 /* andb */, X86::AND8rm, Convert__Reg1_1__Tie0_2_2__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR8 }, },
  { 364 /* andb */, X86::AND8rm_NF, Convert__Reg1_1__Tie0_2_2__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8, MCK_GR8 }, },
  { 364 /* andb */, X86::AND8rm_EVEX, Convert__Reg1_1__Tie0_2_2__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8, MCK_GR8 }, },
  { 364 /* andb */, X86::AND8rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_GR8, MCK_GR8 }, },
  { 364 /* andb */, X86::AND8rr_NF_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_GR8, MCK_GR8 }, },
  { 364 /* andb */, X86::AND8mr_ND, Convert__Reg1_2__Mem85_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_Mem8, MCK_GR8 }, },
  { 364 /* andb */, X86::AND8mr_NF_ND, Convert__Reg1_2__Mem85_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_Mem8, MCK_GR8 }, },
  { 364 /* andb */, X86::AND8ri_ND, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR8, MCK_GR8 }, },
  { 364 /* andb */, X86::AND8ri_NF_ND, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR8, MCK_GR8 }, },
  { 364 /* andb */, X86::AND8mi_ND, Convert__Reg1_2__Mem85_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem8, MCK_GR8 }, },
  { 364 /* andb */, X86::AND8mi_NF_ND, Convert__Reg1_2__Mem85_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem8, MCK_GR8 }, },
  { 364 /* andb */, X86::AND8rm_ND, Convert__Reg1_2__Reg1_1__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8, MCK_GR8, MCK_GR8 }, },
  { 364 /* andb */, X86::AND8rm_NF_ND, Convert__Reg1_2__Reg1_1__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8, MCK_GR8, MCK_GR8 }, },
  { 369 /* andl */, X86::AND32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32rr_NF, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32rr_EVEX, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 369 /* andl */, X86::AND32mr_NF, Convert__Mem325_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 369 /* andl */, X86::AND32mr_EVEX, Convert__Mem325_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 369 /* andl */, X86::AND32ri8, Convert__regEAX__Tie0_1_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_EAX }, },
  { 369 /* andl */, X86::AND32ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32ri8_NF, Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0, AMFBS_In64BitMode, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32ri8_EVEX, Convert__Reg1_1__Tie0_2_2__ImmSExti32i81_0, AMFBS_In64BitMode, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32mi8, Convert__Mem325_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 369 /* andl */, X86::AND32mi8_NF, Convert__Mem325_1__ImmSExti32i81_0, AMFBS_In64BitMode, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 369 /* andl */, X86::AND32mi8_EVEX, Convert__Mem325_1__ImmSExti32i81_0, AMFBS_In64BitMode, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 369 /* andl */, X86::AND32i32, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_EAX }, },
  { 369 /* andl */, X86::AND32ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32ri_NF, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32ri_EVEX, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32mi, Convert__Mem325_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem32 }, },
  { 369 /* andl */, X86::AND32mi_NF, Convert__Mem325_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem32 }, },
  { 369 /* andl */, X86::AND32mi_EVEX, Convert__Mem325_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem32 }, },
  { 369 /* andl */, X86::AND32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32rm_NF, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32rm_EVEX, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32rr_NF_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32mr_ND, Convert__Reg1_2__Mem325_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32mr_NF_ND, Convert__Reg1_2__Mem325_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32ri8_ND, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, AMFBS_In64BitMode, { MCK_ImmSExti32i8, MCK_GR32, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32ri8_NF_ND, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, AMFBS_In64BitMode, { MCK_ImmSExti32i8, MCK_GR32, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32mi8_ND, Convert__Reg1_2__Mem325_1__ImmSExti32i81_0, AMFBS_In64BitMode, { MCK_ImmSExti32i8, MCK_Mem32, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32mi8_NF_ND, Convert__Reg1_2__Mem325_1__ImmSExti32i81_0, AMFBS_In64BitMode, { MCK_ImmSExti32i8, MCK_Mem32, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32ri_ND, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32ri_NF_ND, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32mi_ND, Convert__Reg1_2__Mem325_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem32, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32mi_NF_ND, Convert__Reg1_2__Mem325_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem32, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 369 /* andl */, X86::AND32rm_NF_ND, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 379 /* andnl */, X86::ANDN32rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 379 /* andnl */, X86::ANDN32rr_EVEX, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 379 /* andnl */, X86::ANDN32rr_NF, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 379 /* andnl */, X86::ANDN32rm, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 379 /* andnl */, X86::ANDN32rm_EVEX, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 379 /* andnl */, X86::ANDN32rm_NF, Convert__Reg1_2__Reg1_1__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 385 /* andnpd */, X86::ANDNPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 385 /* andnpd */, X86::ANDNPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 392 /* andnps */, X86::ANDNPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 392 /* andnps */, X86::ANDNPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 399 /* andnq */, X86::ANDN64rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 399 /* andnq */, X86::ANDN64rr_EVEX, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 399 /* andnq */, X86::ANDN64rr_NF, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 399 /* andnq */, X86::ANDN64rm, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 399 /* andnq */, X86::ANDN64rm_EVEX, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 399 /* andnq */, X86::ANDN64rm_NF, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 405 /* andpd */, X86::ANDPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 405 /* andpd */, X86::ANDPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 411 /* andps */, X86::ANDPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 411 /* andps */, X86::ANDPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 417 /* andq */, X86::AND64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64rr_NF, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64rr_EVEX, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 417 /* andq */, X86::AND64mr_NF, Convert__Mem645_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 417 /* andq */, X86::AND64mr_EVEX, Convert__Mem645_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 417 /* andq */, X86::AND64ri8, Convert__regRAX__Tie0_1_1__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_RAX }, },
  { 417 /* andq */, X86::AND64ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64ri8_NF, Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64ri8_EVEX, Convert__Reg1_1__Tie0_2_2__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64mi8, Convert__Mem645_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 417 /* andq */, X86::AND64mi8_NF, Convert__Mem645_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 417 /* andq */, X86::AND64mi8_EVEX, Convert__Mem645_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 417 /* andq */, X86::AND64i32, Convert__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 417 /* andq */, X86::AND64ri32, Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64ri32_NF, Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64ri32_EVEX, Convert__Reg1_1__Tie0_2_2__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64mi32, Convert__Mem645_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 417 /* andq */, X86::AND64mi32_NF, Convert__Mem645_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 417 /* andq */, X86::AND64mi32_EVEX, Convert__Mem645_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 417 /* andq */, X86::AND64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64rm_NF, Convert__Reg1_1__Tie0_2_2__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64rm_EVEX, Convert__Reg1_1__Tie0_2_2__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64rr_NF_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64mr_ND, Convert__Reg1_2__Mem645_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64mr_NF_ND, Convert__Reg1_2__Mem645_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64ri8_ND, Convert__Reg1_2__Reg1_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_GR64, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64ri8_NF_ND, Convert__Reg1_2__Reg1_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_GR64, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64mi8_ND, Convert__Reg1_2__Mem645_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64mi8_NF_ND, Convert__Reg1_2__Mem645_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64ri32_ND, Convert__Reg1_2__Reg1_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_GR64, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64ri32_NF_ND, Convert__Reg1_2__Reg1_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_GR64, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64mi32_ND, Convert__Reg1_2__Mem645_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64mi32_NF_ND, Convert__Reg1_2__Mem645_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 417 /* andq */, X86::AND64rm_NF_ND, Convert__Reg1_2__Reg1_1__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 422 /* andw */, X86::AND16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16rr_NF, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16rr_EVEX, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16mr, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 422 /* andw */, X86::AND16mr_NF, Convert__Mem165_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 422 /* andw */, X86::AND16mr_EVEX, Convert__Mem165_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 422 /* andw */, X86::AND16ri8, Convert__regAX__Tie0_1_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_AX }, },
  { 422 /* andw */, X86::AND16ri8, Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16ri8_NF, Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0, AMFBS_In64BitMode, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16ri8_EVEX, Convert__Reg1_1__Tie0_2_2__ImmSExti16i81_0, AMFBS_In64BitMode, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16mi8, Convert__Mem165_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 422 /* andw */, X86::AND16mi8_NF, Convert__Mem165_1__ImmSExti16i81_0, AMFBS_In64BitMode, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 422 /* andw */, X86::AND16mi8_EVEX, Convert__Mem165_1__ImmSExti16i81_0, AMFBS_In64BitMode, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 422 /* andw */, X86::AND16i16, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AX }, },
  { 422 /* andw */, X86::AND16ri, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16ri_NF, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16ri_EVEX, Convert__Reg1_1__Tie0_2_2__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16mi, Convert__Mem165_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem16 }, },
  { 422 /* andw */, X86::AND16mi_NF, Convert__Mem165_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem16 }, },
  { 422 /* andw */, X86::AND16mi_EVEX, Convert__Mem165_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem16 }, },
  { 422 /* andw */, X86::AND16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16rm_NF, Convert__Reg1_1__Tie0_2_2__Mem165_0, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16rm_EVEX, Convert__Reg1_1__Tie0_2_2__Mem165_0, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16rr_NF_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16mr_ND, Convert__Reg1_2__Mem165_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16mr_NF_ND, Convert__Reg1_2__Mem165_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16ri8_ND, Convert__Reg1_2__Reg1_1__ImmSExti16i81_0, AMFBS_In64BitMode, { MCK_ImmSExti16i8, MCK_GR16, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16ri8_NF_ND, Convert__Reg1_2__Reg1_1__ImmSExti16i81_0, AMFBS_In64BitMode, { MCK_ImmSExti16i8, MCK_GR16, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16mi8_ND, Convert__Reg1_2__Mem165_1__ImmSExti16i81_0, AMFBS_In64BitMode, { MCK_ImmSExti16i8, MCK_Mem16, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16mi8_NF_ND, Convert__Reg1_2__Mem165_1__ImmSExti16i81_0, AMFBS_In64BitMode, { MCK_ImmSExti16i8, MCK_Mem16, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16ri_ND, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR16, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16ri_NF_ND, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_GR16, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16mi_ND, Convert__Reg1_2__Mem165_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem16, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16mi_NF_ND, Convert__Reg1_2__Mem165_1__Imm1_0, AMFBS_In64BitMode, { MCK_Imm, MCK_Mem16, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 422 /* andw */, X86::AND16rm_NF_ND, Convert__Reg1_2__Reg1_1__Mem165_0, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 431 /* aorl */, X86::AOR32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 431 /* aorl */, X86::AOR32mr_EVEX, Convert__Mem325_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 436 /* aorq */, X86::AOR64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 436 /* aorq */, X86::AOR64mr_EVEX, Convert__Mem645_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 441 /* arpl */, X86::ARPL16rr, Convert__Reg1_1__Reg1_0, AMFBS_Not64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 441 /* arpl */, X86::ARPL16mr, Convert__Mem165_1__Reg1_0, AMFBS_Not64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 451 /* axorl */, X86::AXOR32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 451 /* axorl */, X86::AXOR32mr_EVEX, Convert__Mem325_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 457 /* axorq */, X86::AXOR64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 457 /* axorq */, X86::AXOR64mr_EVEX, Convert__Mem645_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 469 /* bextrl */, X86::BEXTR32rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 469 /* bextrl */, X86::BEXTR32rr_EVEX, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 469 /* bextrl */, X86::BEXTR32rr_NF, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 469 /* bextrl */, X86::BEXTR32rm, Convert__Reg1_2__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 469 /* bextrl */, X86::BEXTR32rm_EVEX, Convert__Reg1_2__Mem325_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 469 /* bextrl */, X86::BEXTR32rm_NF, Convert__Reg1_2__Mem325_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 469 /* bextrl */, X86::BEXTRI32ri, Convert__Reg1_2__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 469 /* bextrl */, X86::BEXTRI32mi, Convert__Reg1_2__Mem325_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem32, MCK_GR32 }, },
  { 476 /* bextrq */, X86::BEXTR64rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 476 /* bextrq */, X86::BEXTR64rr_EVEX, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 476 /* bextrq */, X86::BEXTR64rr_NF, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 476 /* bextrq */, X86::BEXTR64rm, Convert__Reg1_2__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 476 /* bextrq */, X86::BEXTR64rm_EVEX, Convert__Reg1_2__Mem645_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 476 /* bextrq */, X86::BEXTR64rm_NF, Convert__Reg1_2__Mem645_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 476 /* bextrq */, X86::BEXTRI64ri, Convert__Reg1_2__Reg1_1__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_GR64, MCK_GR64 }, },
  { 476 /* bextrq */, X86::BEXTRI64mi, Convert__Reg1_2__Mem645_1__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_Mem64, MCK_GR64 }, },
  { 491 /* blcfilll */, X86::BLCFILL32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 491 /* blcfilll */, X86::BLCFILL32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 500 /* blcfillq */, X86::BLCFILL64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 500 /* blcfillq */, X86::BLCFILL64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 520 /* blcicl */, X86::BLCIC32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 520 /* blcicl */, X86::BLCIC32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 527 /* blcicq */, X86::BLCIC64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 527 /* blcicq */, X86::BLCIC64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 534 /* blcil */, X86::BLCI32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 534 /* blcil */, X86::BLCI32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 540 /* blciq */, X86::BLCI64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 540 /* blciq */, X86::BLCI64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 553 /* blcmskl */, X86::BLCMSK32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 553 /* blcmskl */, X86::BLCMSK32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 561 /* blcmskq */, X86::BLCMSK64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 561 /* blcmskq */, X86::BLCMSK64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 574 /* blcsl */, X86::BLCS32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 574 /* blcsl */, X86::BLCS32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 580 /* blcsq */, X86::BLCS64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 580 /* blcsq */, X86::BLCS64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 586 /* blendpd */, X86::BLENDPDrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 586 /* blendpd */, X86::BLENDPDrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 594 /* blendps */, X86::BLENDPSrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 594 /* blendps */, X86::BLENDPSrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 602 /* blendvpd */, X86::BLENDVPDrr0, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 602 /* blendvpd */, X86::BLENDVPDrm0, Convert__Reg1_1__Tie0_2_2__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 602 /* blendvpd */, X86::BLENDVPDrr0, Convert__Reg1_2__Tie0_1_1__Reg1_1, AMFBS_None, { MCK_XMM0, MCK_FR16, MCK_FR16 }, },
  { 602 /* blendvpd */, X86::BLENDVPDrm0, Convert__Reg1_2__Tie0_1_1__Mem1285_1, AMFBS_None, { MCK_XMM0, MCK_Mem128, MCK_FR16 }, },
  { 611 /* blendvps */, X86::BLENDVPSrr0, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 611 /* blendvps */, X86::BLENDVPSrm0, Convert__Reg1_1__Tie0_2_2__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 611 /* blendvps */, X86::BLENDVPSrr0, Convert__Reg1_2__Tie0_1_1__Reg1_1, AMFBS_None, { MCK_XMM0, MCK_FR16, MCK_FR16 }, },
  { 611 /* blendvps */, X86::BLENDVPSrm0, Convert__Reg1_2__Tie0_1_1__Mem1285_1, AMFBS_None, { MCK_XMM0, MCK_Mem128, MCK_FR16 }, },
  { 628 /* blsfilll */, X86::BLSFILL32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 628 /* blsfilll */, X86::BLSFILL32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 637 /* blsfillq */, X86::BLSFILL64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 637 /* blsfillq */, X86::BLSFILL64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 657 /* blsicl */, X86::BLSIC32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 657 /* blsicl */, X86::BLSIC32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 664 /* blsicq */, X86::BLSIC64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 664 /* blsicq */, X86::BLSIC64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 671 /* blsil */, X86::BLSI32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 671 /* blsil */, X86::BLSI32rr_EVEX, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 671 /* blsil */, X86::BLSI32rr_NF, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 671 /* blsil */, X86::BLSI32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 671 /* blsil */, X86::BLSI32rm_EVEX, Convert__Reg1_1__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 671 /* blsil */, X86::BLSI32rm_NF, Convert__Reg1_1__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 677 /* blsiq */, X86::BLSI64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 677 /* blsiq */, X86::BLSI64rr_EVEX, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 677 /* blsiq */, X86::BLSI64rr_NF, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 677 /* blsiq */, X86::BLSI64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 677 /* blsiq */, X86::BLSI64rm_EVEX, Convert__Reg1_1__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 677 /* blsiq */, X86::BLSI64rm_NF, Convert__Reg1_1__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 690 /* blsmskl */, X86::BLSMSK32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 690 /* blsmskl */, X86::BLSMSK32rr_EVEX, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 690 /* blsmskl */, X86::BLSMSK32rr_NF, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 690 /* blsmskl */, X86::BLSMSK32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 690 /* blsmskl */, X86::BLSMSK32rm_EVEX, Convert__Reg1_1__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 690 /* blsmskl */, X86::BLSMSK32rm_NF, Convert__Reg1_1__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 698 /* blsmskq */, X86::BLSMSK64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 698 /* blsmskq */, X86::BLSMSK64rr_EVEX, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 698 /* blsmskq */, X86::BLSMSK64rr_NF, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 698 /* blsmskq */, X86::BLSMSK64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 698 /* blsmskq */, X86::BLSMSK64rm_EVEX, Convert__Reg1_1__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 698 /* blsmskq */, X86::BLSMSK64rm_NF, Convert__Reg1_1__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 711 /* blsrl */, X86::BLSR32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 711 /* blsrl */, X86::BLSR32rr_EVEX, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 711 /* blsrl */, X86::BLSR32rr_NF, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 711 /* blsrl */, X86::BLSR32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 711 /* blsrl */, X86::BLSR32rm_EVEX, Convert__Reg1_1__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 711 /* blsrl */, X86::BLSR32rm_NF, Convert__Reg1_1__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 717 /* blsrq */, X86::BLSR64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 717 /* blsrq */, X86::BLSR64rr_EVEX, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 717 /* blsrq */, X86::BLSR64rr_NF, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 717 /* blsrq */, X86::BLSR64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 717 /* blsrq */, X86::BLSR64rm_EVEX, Convert__Reg1_1__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 717 /* blsrq */, X86::BLSR64rm_NF, Convert__Reg1_1__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 723 /* bound */, X86::BOUNDS16rm, Convert__Reg1_0__Mem165_1, AMFBS_Not64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 723 /* bound */, X86::BOUNDS32rm, Convert__Reg1_0__Mem325_1, AMFBS_Not64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 733 /* bsfl */, X86::BSF32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 733 /* bsfl */, X86::BSF32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 738 /* bsfq */, X86::BSF64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 738 /* bsfq */, X86::BSF64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 743 /* bsfw */, X86::BSF16rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 743 /* bsfw */, X86::BSF16rm, Convert__Reg1_1__Tie0_1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 752 /* bsrl */, X86::BSR32rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 752 /* bsrl */, X86::BSR32rm, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 757 /* bsrq */, X86::BSR64rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 757 /* bsrq */, X86::BSR64rm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 762 /* bsrw */, X86::BSR16rr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 762 /* bsrw */, X86::BSR16rm, Convert__Reg1_1__Tie0_1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 773 /* bswapl */, X86::BSWAP32r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR32 }, },
  { 780 /* bswapq */, X86::BSWAP64r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR64 }, },
  { 787 /* bt */, X86::BT32mi8, Convert__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 790 /* btc */, X86::BTC32mi8, Convert__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 794 /* btcl */, X86::BTC32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 794 /* btcl */, X86::BTC32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 794 /* btcl */, X86::BTC32ri8, Convert__Reg1_1__Tie0_2_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32 }, },
  { 794 /* btcl */, X86::BTC32mi8, Convert__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 799 /* btcq */, X86::BTC64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 799 /* btcq */, X86::BTC64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 799 /* btcq */, X86::BTC64ri8, Convert__Reg1_1__Tie0_2_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR64 }, },
  { 799 /* btcq */, X86::BTC64mi8, Convert__Mem645_1__ImmUnsignedi81_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi8, MCK_Mem64 }, },
  { 804 /* btcw */, X86::BTC16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 804 /* btcw */, X86::BTC16mr, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 804 /* btcw */, X86::BTC16ri8, Convert__Reg1_1__Tie0_2_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR16 }, },
  { 804 /* btcw */, X86::BTC16mi8, Convert__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16 }, },
  { 809 /* btl */, X86::BT32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 809 /* btl */, X86::BT32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 809 /* btl */, X86::BT32ri8, Convert__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32 }, },
  { 809 /* btl */, X86::BT32mi8, Convert__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 813 /* btq */, X86::BT64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 813 /* btq */, X86::BT64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 813 /* btq */, X86::BT64ri8, Convert__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR64 }, },
  { 813 /* btq */, X86::BT64mi8, Convert__Mem645_1__ImmUnsignedi81_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi8, MCK_Mem64 }, },
  { 817 /* btr */, X86::BTR32mi8, Convert__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 821 /* btrl */, X86::BTR32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 821 /* btrl */, X86::BTR32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 821 /* btrl */, X86::BTR32ri8, Convert__Reg1_1__Tie0_2_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32 }, },
  { 821 /* btrl */, X86::BTR32mi8, Convert__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 826 /* btrq */, X86::BTR64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 826 /* btrq */, X86::BTR64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 826 /* btrq */, X86::BTR64ri8, Convert__Reg1_1__Tie0_2_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR64 }, },
  { 826 /* btrq */, X86::BTR64mi8, Convert__Mem645_1__ImmUnsignedi81_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi8, MCK_Mem64 }, },
  { 831 /* btrw */, X86::BTR16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 831 /* btrw */, X86::BTR16mr, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 831 /* btrw */, X86::BTR16ri8, Convert__Reg1_1__Tie0_2_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR16 }, },
  { 831 /* btrw */, X86::BTR16mi8, Convert__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16 }, },
  { 836 /* bts */, X86::BTS32mi8, Convert__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 840 /* btsl */, X86::BTS32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 840 /* btsl */, X86::BTS32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 840 /* btsl */, X86::BTS32ri8, Convert__Reg1_1__Tie0_2_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR32 }, },
  { 840 /* btsl */, X86::BTS32mi8, Convert__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32 }, },
  { 845 /* btsq */, X86::BTS64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 845 /* btsq */, X86::BTS64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 845 /* btsq */, X86::BTS64ri8, Convert__Reg1_1__Tie0_2_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR64 }, },
  { 845 /* btsq */, X86::BTS64mi8, Convert__Mem645_1__ImmUnsignedi81_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi8, MCK_Mem64 }, },
  { 850 /* btsw */, X86::BTS16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 850 /* btsw */, X86::BTS16mr, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 850 /* btsw */, X86::BTS16ri8, Convert__Reg1_1__Tie0_2_2__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR16 }, },
  { 850 /* btsw */, X86::BTS16mi8, Convert__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16 }, },
  { 855 /* btw */, X86::BT16rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 855 /* btw */, X86::BT16mr, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 855 /* btw */, X86::BT16ri8, Convert__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_GR16 }, },
  { 855 /* btw */, X86::BT16mi8, Convert__Mem165_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem16 }, },
  { 864 /* bzhil */, X86::BZHI32rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 864 /* bzhil */, X86::BZHI32rr_EVEX, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 864 /* bzhil */, X86::BZHI32rr_NF, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 864 /* bzhil */, X86::BZHI32rm, Convert__Reg1_2__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 864 /* bzhil */, X86::BZHI32rm_EVEX, Convert__Reg1_2__Mem325_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 864 /* bzhil */, X86::BZHI32rm_NF, Convert__Reg1_2__Mem325_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 870 /* bzhiq */, X86::BZHI64rr, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 870 /* bzhiq */, X86::BZHI64rr_EVEX, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 870 /* bzhiq */, X86::BZHI64rr_NF, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 870 /* bzhiq */, X86::BZHI64rm, Convert__Reg1_2__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 870 /* bzhiq */, X86::BZHI64rm_EVEX, Convert__Reg1_2__Mem645_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 870 /* bzhiq */, X86::BZHI64rm_NF, Convert__Reg1_2__Mem645_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 876 /* call */, X86::FARCALL32i, Convert__Imm1_1__Imm1_0, AMFBS_In32BitMode, { MCK_Imm, MCK_Imm }, },
  { 876 /* call */, X86::FARCALL16i, Convert__Imm1_1__Imm1_0, AMFBS_In16BitMode, { MCK_Imm, MCK_Imm }, },
  { 881 /* calll */, X86::CALLpcrel32, Convert__AbsMem1_0, AMFBS_Not64BitMode, { MCK_AbsMem }, },
  { 881 /* calll */, X86::CALL32r, Convert__Reg1_1, AMFBS_Not64BitMode, { MCK__STAR_, MCK_GR32 }, },
  { 881 /* calll */, X86::CALL32m, Convert__Mem325_1, AMFBS_Not64BitMode, { MCK__STAR_, MCK_Mem32 }, },
  { 881 /* calll */, X86::FARCALL32i, Convert__Imm1_1__Imm1_0, AMFBS_Not64BitMode, { MCK_Imm, MCK_Imm }, },
  { 887 /* callq */, X86::CALL64pcrel32, Convert__AbsMem1_0, AMFBS_In64BitMode, { MCK_AbsMem }, },
  { 887 /* callq */, X86::CALL64r, Convert__Reg1_1, AMFBS_In64BitMode, { MCK__STAR_, MCK_GR64 }, },
  { 887 /* callq */, X86::CALL64m, Convert__Mem645_1, AMFBS_In64BitMode, { MCK__STAR_, MCK_Mem64 }, },
  { 893 /* callw */, X86::CALLpcrel16, Convert__AbsMem1_0, AMFBS_Not64BitMode, { MCK_AbsMem }, },
  { 893 /* callw */, X86::CALL16r, Convert__Reg1_1, AMFBS_Not64BitMode, { MCK__STAR_, MCK_GR16 }, },
  { 893 /* callw */, X86::CALL16m, Convert__Mem165_1, AMFBS_Not64BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 893 /* callw */, X86::FARCALL16i, Convert__Imm1_1__Imm1_0, AMFBS_Not64BitMode, { MCK_Imm, MCK_Imm }, },
  { 899 /* cbtw */, X86::CBW, Convert_NoOperands, AMFBS_None, {  }, },
  { 914 /* ccmpab */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 914 /* ccmpab */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 914 /* ccmpab */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 914 /* ccmpab */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 914 /* ccmpab */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 928 /* ccmpaeb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 928 /* ccmpaeb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 928 /* ccmpaeb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 928 /* ccmpaeb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 928 /* ccmpaeb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 936 /* ccmpael */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 936 /* ccmpael */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 936 /* ccmpael */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 936 /* ccmpael */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 936 /* ccmpael */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 936 /* ccmpael */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 936 /* ccmpael */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 944 /* ccmpaeq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 944 /* ccmpaeq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 944 /* ccmpaeq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 944 /* ccmpaeq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 944 /* ccmpaeq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 944 /* ccmpaeq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 944 /* ccmpaeq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 952 /* ccmpaew */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 952 /* ccmpaew */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 952 /* ccmpaew */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 952 /* ccmpaew */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 952 /* ccmpaew */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 952 /* ccmpaew */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 952 /* ccmpaew */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 960 /* ccmpal */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 960 /* ccmpal */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 960 /* ccmpal */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 960 /* ccmpal */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 960 /* ccmpal */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 960 /* ccmpal */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 960 /* ccmpal */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 967 /* ccmpaq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 967 /* ccmpaq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 967 /* ccmpaq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 967 /* ccmpaq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 967 /* ccmpaq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 967 /* ccmpaq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 967 /* ccmpaq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 974 /* ccmpaw */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 974 /* ccmpaw */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 974 /* ccmpaw */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 974 /* ccmpaw */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 974 /* ccmpaw */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 974 /* ccmpaw */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 974 /* ccmpaw */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 987 /* ccmpbb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 987 /* ccmpbb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 987 /* ccmpbb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 987 /* ccmpbb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 987 /* ccmpbb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1001 /* ccmpbeb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1001 /* ccmpbeb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1001 /* ccmpbeb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1001 /* ccmpbeb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1001 /* ccmpbeb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1009 /* ccmpbel */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1009 /* ccmpbel */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1009 /* ccmpbel */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1009 /* ccmpbel */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1009 /* ccmpbel */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1009 /* ccmpbel */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1009 /* ccmpbel */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1017 /* ccmpbeq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1017 /* ccmpbeq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1017 /* ccmpbeq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1017 /* ccmpbeq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1017 /* ccmpbeq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1017 /* ccmpbeq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1017 /* ccmpbeq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1025 /* ccmpbew */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1025 /* ccmpbew */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1025 /* ccmpbew */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1025 /* ccmpbew */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1025 /* ccmpbew */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1025 /* ccmpbew */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1025 /* ccmpbew */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1033 /* ccmpbl */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1033 /* ccmpbl */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1033 /* ccmpbl */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1033 /* ccmpbl */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1033 /* ccmpbl */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1033 /* ccmpbl */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1033 /* ccmpbl */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1040 /* ccmpbq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1040 /* ccmpbq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1040 /* ccmpbq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1040 /* ccmpbq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1040 /* ccmpbq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1040 /* ccmpbq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1040 /* ccmpbq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1047 /* ccmpbw */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1047 /* ccmpbw */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1047 /* ccmpbw */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1047 /* ccmpbw */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1047 /* ccmpbw */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1047 /* ccmpbw */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1047 /* ccmpbw */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1060 /* ccmpcb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1060 /* ccmpcb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1060 /* ccmpcb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1060 /* ccmpcb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1060 /* ccmpcb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1067 /* ccmpcl */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1067 /* ccmpcl */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1067 /* ccmpcl */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1067 /* ccmpcl */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1067 /* ccmpcl */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1067 /* ccmpcl */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1067 /* ccmpcl */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1074 /* ccmpcq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1074 /* ccmpcq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1074 /* ccmpcq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1074 /* ccmpcq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1074 /* ccmpcq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1074 /* ccmpcq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1074 /* ccmpcq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1081 /* ccmpcw */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1081 /* ccmpcw */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1081 /* ccmpcw */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1081 /* ccmpcw */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1081 /* ccmpcw */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1081 /* ccmpcw */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1081 /* ccmpcw */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1094 /* ccmpeb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1094 /* ccmpeb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1094 /* ccmpeb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1094 /* ccmpeb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1094 /* ccmpeb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1101 /* ccmpel */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1101 /* ccmpel */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1101 /* ccmpel */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1101 /* ccmpel */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1101 /* ccmpel */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1101 /* ccmpel */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1101 /* ccmpel */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1108 /* ccmpeq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1108 /* ccmpeq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1108 /* ccmpeq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1108 /* ccmpeq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1108 /* ccmpeq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1108 /* ccmpeq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1108 /* ccmpeq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1115 /* ccmpew */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1115 /* ccmpew */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1115 /* ccmpew */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1115 /* ccmpew */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1115 /* ccmpew */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1115 /* ccmpew */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1115 /* ccmpew */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1128 /* ccmpfb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1128 /* ccmpfb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1128 /* ccmpfb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1128 /* ccmpfb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1128 /* ccmpfb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1135 /* ccmpfl */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1135 /* ccmpfl */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1135 /* ccmpfl */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1135 /* ccmpfl */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1135 /* ccmpfl */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1135 /* ccmpfl */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1135 /* ccmpfl */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1142 /* ccmpfq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1142 /* ccmpfq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1142 /* ccmpfq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1142 /* ccmpfq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1142 /* ccmpfq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1142 /* ccmpfq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1142 /* ccmpfq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1149 /* ccmpfw */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1149 /* ccmpfw */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1149 /* ccmpfw */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1149 /* ccmpfw */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1149 /* ccmpfw */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1149 /* ccmpfw */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1149 /* ccmpfw */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1162 /* ccmpgb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1162 /* ccmpgb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1162 /* ccmpgb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1162 /* ccmpgb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1162 /* ccmpgb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1176 /* ccmpgeb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1176 /* ccmpgeb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1176 /* ccmpgeb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1176 /* ccmpgeb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1176 /* ccmpgeb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1184 /* ccmpgel */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1184 /* ccmpgel */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1184 /* ccmpgel */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1184 /* ccmpgel */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1184 /* ccmpgel */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1184 /* ccmpgel */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1184 /* ccmpgel */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1192 /* ccmpgeq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1192 /* ccmpgeq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1192 /* ccmpgeq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1192 /* ccmpgeq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1192 /* ccmpgeq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1192 /* ccmpgeq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1192 /* ccmpgeq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1200 /* ccmpgew */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1200 /* ccmpgew */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1200 /* ccmpgew */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1200 /* ccmpgew */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1200 /* ccmpgew */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1200 /* ccmpgew */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1200 /* ccmpgew */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1208 /* ccmpgl */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1208 /* ccmpgl */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1208 /* ccmpgl */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1208 /* ccmpgl */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1208 /* ccmpgl */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1208 /* ccmpgl */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1208 /* ccmpgl */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1215 /* ccmpgq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1215 /* ccmpgq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1215 /* ccmpgq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1215 /* ccmpgq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1215 /* ccmpgq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1215 /* ccmpgq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1215 /* ccmpgq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1222 /* ccmpgw */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1222 /* ccmpgw */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1222 /* ccmpgw */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1222 /* ccmpgw */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1222 /* ccmpgw */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1222 /* ccmpgw */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1222 /* ccmpgw */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1235 /* ccmplb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1235 /* ccmplb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1235 /* ccmplb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1235 /* ccmplb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1235 /* ccmplb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1249 /* ccmpleb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1249 /* ccmpleb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1249 /* ccmpleb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1249 /* ccmpleb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1249 /* ccmpleb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1257 /* ccmplel */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1257 /* ccmplel */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1257 /* ccmplel */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1257 /* ccmplel */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1257 /* ccmplel */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1257 /* ccmplel */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1257 /* ccmplel */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1265 /* ccmpleq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1265 /* ccmpleq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1265 /* ccmpleq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1265 /* ccmpleq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1265 /* ccmpleq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1265 /* ccmpleq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1265 /* ccmpleq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1273 /* ccmplew */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1273 /* ccmplew */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1273 /* ccmplew */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1273 /* ccmplew */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1273 /* ccmplew */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1273 /* ccmplew */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1273 /* ccmplew */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1281 /* ccmpll */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1281 /* ccmpll */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1281 /* ccmpll */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1281 /* ccmpll */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1281 /* ccmpll */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1281 /* ccmpll */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1281 /* ccmpll */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1288 /* ccmplq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1288 /* ccmplq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1288 /* ccmplq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1288 /* ccmplq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1288 /* ccmplq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1288 /* ccmplq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1288 /* ccmplq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1295 /* ccmplw */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1295 /* ccmplw */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1295 /* ccmplw */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1295 /* ccmplw */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1295 /* ccmplw */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1295 /* ccmplw */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1295 /* ccmplw */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1309 /* ccmpnab */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1309 /* ccmpnab */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1309 /* ccmpnab */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1309 /* ccmpnab */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1309 /* ccmpnab */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1325 /* ccmpnaeb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1325 /* ccmpnaeb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1325 /* ccmpnaeb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1325 /* ccmpnaeb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1325 /* ccmpnaeb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1334 /* ccmpnael */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1334 /* ccmpnael */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1334 /* ccmpnael */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1334 /* ccmpnael */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1334 /* ccmpnael */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1334 /* ccmpnael */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1334 /* ccmpnael */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1343 /* ccmpnaeq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1343 /* ccmpnaeq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1343 /* ccmpnaeq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1343 /* ccmpnaeq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1343 /* ccmpnaeq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1343 /* ccmpnaeq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1343 /* ccmpnaeq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1352 /* ccmpnaew */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1352 /* ccmpnaew */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1352 /* ccmpnaew */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1352 /* ccmpnaew */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1352 /* ccmpnaew */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1352 /* ccmpnaew */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1352 /* ccmpnaew */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1361 /* ccmpnal */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1361 /* ccmpnal */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1361 /* ccmpnal */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1361 /* ccmpnal */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1361 /* ccmpnal */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1361 /* ccmpnal */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1361 /* ccmpnal */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1369 /* ccmpnaq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1369 /* ccmpnaq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1369 /* ccmpnaq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1369 /* ccmpnaq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1369 /* ccmpnaq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1369 /* ccmpnaq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1369 /* ccmpnaq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1377 /* ccmpnaw */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1377 /* ccmpnaw */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1377 /* ccmpnaw */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1377 /* ccmpnaw */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1377 /* ccmpnaw */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1377 /* ccmpnaw */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1377 /* ccmpnaw */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1392 /* ccmpnbb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1392 /* ccmpnbb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1392 /* ccmpnbb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1392 /* ccmpnbb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1392 /* ccmpnbb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1408 /* ccmpnbeb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1408 /* ccmpnbeb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1408 /* ccmpnbeb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1408 /* ccmpnbeb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1408 /* ccmpnbeb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1417 /* ccmpnbel */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1417 /* ccmpnbel */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1417 /* ccmpnbel */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1417 /* ccmpnbel */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1417 /* ccmpnbel */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1417 /* ccmpnbel */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1417 /* ccmpnbel */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1426 /* ccmpnbeq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1426 /* ccmpnbeq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1426 /* ccmpnbeq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1426 /* ccmpnbeq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1426 /* ccmpnbeq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1426 /* ccmpnbeq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1426 /* ccmpnbeq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1435 /* ccmpnbew */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1435 /* ccmpnbew */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1435 /* ccmpnbew */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1435 /* ccmpnbew */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1435 /* ccmpnbew */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1435 /* ccmpnbew */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1435 /* ccmpnbew */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1444 /* ccmpnbl */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1444 /* ccmpnbl */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1444 /* ccmpnbl */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1444 /* ccmpnbl */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1444 /* ccmpnbl */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1444 /* ccmpnbl */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1444 /* ccmpnbl */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1452 /* ccmpnbq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1452 /* ccmpnbq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1452 /* ccmpnbq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1452 /* ccmpnbq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1452 /* ccmpnbq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1452 /* ccmpnbq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1452 /* ccmpnbq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1460 /* ccmpnbw */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1460 /* ccmpnbw */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1460 /* ccmpnbw */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1460 /* ccmpnbw */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1460 /* ccmpnbw */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1460 /* ccmpnbw */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1460 /* ccmpnbw */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1475 /* ccmpncb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1475 /* ccmpncb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1475 /* ccmpncb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1475 /* ccmpncb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1475 /* ccmpncb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1483 /* ccmpncl */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1483 /* ccmpncl */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1483 /* ccmpncl */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1483 /* ccmpncl */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1483 /* ccmpncl */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1483 /* ccmpncl */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1483 /* ccmpncl */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1491 /* ccmpncq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1491 /* ccmpncq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1491 /* ccmpncq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1491 /* ccmpncq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1491 /* ccmpncq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1491 /* ccmpncq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1491 /* ccmpncq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1499 /* ccmpncw */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1499 /* ccmpncw */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1499 /* ccmpncw */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1499 /* ccmpncw */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1499 /* ccmpncw */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1499 /* ccmpncw */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1499 /* ccmpncw */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1514 /* ccmpneb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1514 /* ccmpneb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1514 /* ccmpneb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1514 /* ccmpneb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1514 /* ccmpneb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1522 /* ccmpnel */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1522 /* ccmpnel */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1522 /* ccmpnel */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1522 /* ccmpnel */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1522 /* ccmpnel */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1522 /* ccmpnel */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1522 /* ccmpnel */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1530 /* ccmpneq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1530 /* ccmpneq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1530 /* ccmpneq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1530 /* ccmpneq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1530 /* ccmpneq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1530 /* ccmpneq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1530 /* ccmpneq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1538 /* ccmpnew */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1538 /* ccmpnew */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1538 /* ccmpnew */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1538 /* ccmpnew */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1538 /* ccmpnew */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1538 /* ccmpnew */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1538 /* ccmpnew */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1553 /* ccmpngb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1553 /* ccmpngb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1553 /* ccmpngb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1553 /* ccmpngb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1553 /* ccmpngb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1569 /* ccmpngeb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1569 /* ccmpngeb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1569 /* ccmpngeb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1569 /* ccmpngeb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1569 /* ccmpngeb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1578 /* ccmpngel */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1578 /* ccmpngel */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1578 /* ccmpngel */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1578 /* ccmpngel */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1578 /* ccmpngel */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1578 /* ccmpngel */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1578 /* ccmpngel */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1587 /* ccmpngeq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1587 /* ccmpngeq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1587 /* ccmpngeq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1587 /* ccmpngeq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1587 /* ccmpngeq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1587 /* ccmpngeq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1587 /* ccmpngeq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1596 /* ccmpngew */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1596 /* ccmpngew */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1596 /* ccmpngew */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1596 /* ccmpngew */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1596 /* ccmpngew */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1596 /* ccmpngew */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1596 /* ccmpngew */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1605 /* ccmpngl */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1605 /* ccmpngl */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1605 /* ccmpngl */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1605 /* ccmpngl */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1605 /* ccmpngl */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1605 /* ccmpngl */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1605 /* ccmpngl */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1613 /* ccmpngq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1613 /* ccmpngq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1613 /* ccmpngq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1613 /* ccmpngq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1613 /* ccmpngq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1613 /* ccmpngq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1613 /* ccmpngq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1621 /* ccmpngw */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1621 /* ccmpngw */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1621 /* ccmpngw */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1621 /* ccmpngw */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1621 /* ccmpngw */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1621 /* ccmpngw */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1621 /* ccmpngw */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1636 /* ccmpnlb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1636 /* ccmpnlb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1636 /* ccmpnlb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1636 /* ccmpnlb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1636 /* ccmpnlb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1652 /* ccmpnleb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1652 /* ccmpnleb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1652 /* ccmpnleb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1652 /* ccmpnleb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1652 /* ccmpnleb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1661 /* ccmpnlel */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1661 /* ccmpnlel */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1661 /* ccmpnlel */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1661 /* ccmpnlel */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1661 /* ccmpnlel */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1661 /* ccmpnlel */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1661 /* ccmpnlel */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1670 /* ccmpnleq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1670 /* ccmpnleq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1670 /* ccmpnleq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1670 /* ccmpnleq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1670 /* ccmpnleq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1670 /* ccmpnleq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1670 /* ccmpnleq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1679 /* ccmpnlew */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1679 /* ccmpnlew */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1679 /* ccmpnlew */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1679 /* ccmpnlew */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1679 /* ccmpnlew */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1679 /* ccmpnlew */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1679 /* ccmpnlew */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1688 /* ccmpnll */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1688 /* ccmpnll */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1688 /* ccmpnll */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1688 /* ccmpnll */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1688 /* ccmpnll */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1688 /* ccmpnll */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1688 /* ccmpnll */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1696 /* ccmpnlq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1696 /* ccmpnlq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1696 /* ccmpnlq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1696 /* ccmpnlq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1696 /* ccmpnlq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1696 /* ccmpnlq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1696 /* ccmpnlq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1704 /* ccmpnlw */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1704 /* ccmpnlw */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1704 /* ccmpnlw */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1704 /* ccmpnlw */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1704 /* ccmpnlw */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1704 /* ccmpnlw */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1704 /* ccmpnlw */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1719 /* ccmpnob */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1719 /* ccmpnob */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1719 /* ccmpnob */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1719 /* ccmpnob */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1719 /* ccmpnob */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1727 /* ccmpnol */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1727 /* ccmpnol */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1727 /* ccmpnol */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1727 /* ccmpnol */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1727 /* ccmpnol */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1727 /* ccmpnol */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1727 /* ccmpnol */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1735 /* ccmpnoq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1735 /* ccmpnoq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1735 /* ccmpnoq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1735 /* ccmpnoq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1735 /* ccmpnoq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1735 /* ccmpnoq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1735 /* ccmpnoq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1743 /* ccmpnow */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1743 /* ccmpnow */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1743 /* ccmpnow */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1743 /* ccmpnow */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1743 /* ccmpnow */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1743 /* ccmpnow */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1743 /* ccmpnow */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1758 /* ccmpnsb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1758 /* ccmpnsb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1758 /* ccmpnsb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1758 /* ccmpnsb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1758 /* ccmpnsb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1766 /* ccmpnsl */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1766 /* ccmpnsl */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1766 /* ccmpnsl */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1766 /* ccmpnsl */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1766 /* ccmpnsl */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1766 /* ccmpnsl */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1766 /* ccmpnsl */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1774 /* ccmpnsq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1774 /* ccmpnsq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1774 /* ccmpnsq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1774 /* ccmpnsq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1774 /* ccmpnsq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1774 /* ccmpnsq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1774 /* ccmpnsq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1782 /* ccmpnsw */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1782 /* ccmpnsw */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1782 /* ccmpnsw */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1782 /* ccmpnsw */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1782 /* ccmpnsw */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1782 /* ccmpnsw */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1782 /* ccmpnsw */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1797 /* ccmpnzb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1797 /* ccmpnzb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1797 /* ccmpnzb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1797 /* ccmpnzb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1797 /* ccmpnzb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1805 /* ccmpnzl */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1805 /* ccmpnzl */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1805 /* ccmpnzl */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1805 /* ccmpnzl */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1805 /* ccmpnzl */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1805 /* ccmpnzl */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1805 /* ccmpnzl */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1813 /* ccmpnzq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1813 /* ccmpnzq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1813 /* ccmpnzq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1813 /* ccmpnzq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1813 /* ccmpnzq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1813 /* ccmpnzq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1813 /* ccmpnzq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1821 /* ccmpnzw */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1821 /* ccmpnzw */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1821 /* ccmpnzw */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1821 /* ccmpnzw */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1821 /* ccmpnzw */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1821 /* ccmpnzw */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1821 /* ccmpnzw */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1835 /* ccmpob */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1835 /* ccmpob */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1835 /* ccmpob */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1835 /* ccmpob */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1835 /* ccmpob */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1842 /* ccmpol */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1842 /* ccmpol */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1842 /* ccmpol */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1842 /* ccmpol */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1842 /* ccmpol */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1842 /* ccmpol */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1842 /* ccmpol */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1849 /* ccmpoq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1849 /* ccmpoq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1849 /* ccmpoq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1849 /* ccmpoq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1849 /* ccmpoq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1849 /* ccmpoq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1849 /* ccmpoq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1856 /* ccmpow */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1856 /* ccmpow */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1856 /* ccmpow */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1856 /* ccmpow */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1856 /* ccmpow */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1856 /* ccmpow */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1856 /* ccmpow */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1869 /* ccmpsb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1869 /* ccmpsb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1869 /* ccmpsb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1869 /* ccmpsb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1869 /* ccmpsb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1876 /* ccmpsl */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1876 /* ccmpsl */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1876 /* ccmpsl */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1876 /* ccmpsl */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1876 /* ccmpsl */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1876 /* ccmpsl */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1876 /* ccmpsl */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1883 /* ccmpsq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1883 /* ccmpsq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1883 /* ccmpsq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1883 /* ccmpsq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1883 /* ccmpsq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1883 /* ccmpsq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1883 /* ccmpsq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1890 /* ccmpsw */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1890 /* ccmpsw */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1890 /* ccmpsw */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1890 /* ccmpsw */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1890 /* ccmpsw */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1890 /* ccmpsw */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1890 /* ccmpsw */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1903 /* ccmptb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1903 /* ccmptb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1903 /* ccmptb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1903 /* ccmptb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1903 /* ccmptb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1910 /* ccmptl */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1910 /* ccmptl */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1910 /* ccmptl */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1910 /* ccmptl */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1910 /* ccmptl */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1910 /* ccmptl */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1910 /* ccmptl */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1917 /* ccmptq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1917 /* ccmptq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1917 /* ccmptq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1917 /* ccmptq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1917 /* ccmptq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1917 /* ccmptq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1917 /* ccmptq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1924 /* ccmptw */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1924 /* ccmptw */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1924 /* ccmptw */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1924 /* ccmptw */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1924 /* ccmptw */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1924 /* ccmptw */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1924 /* ccmptw */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1937 /* ccmpzb */, X86::CCMP8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 1937 /* ccmpzb */, X86::CCMP8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 1937 /* ccmpzb */, X86::CCMP8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 1937 /* ccmpzb */, X86::CCMP8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 1937 /* ccmpzb */, X86::CCMP8rm, Convert__Reg1_2__Mem85_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 1944 /* ccmpzl */, X86::CCMP32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 1944 /* ccmpzl */, X86::CCMP32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 1944 /* ccmpzl */, X86::CCMP32ri8, Convert__Reg1_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1944 /* ccmpzl */, X86::CCMP32mi8, Convert__Mem325_2__ImmSExti32i81_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1944 /* ccmpzl */, X86::CCMP32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 1944 /* ccmpzl */, X86::CCMP32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 1944 /* ccmpzl */, X86::CCMP32rm, Convert__Reg1_2__Mem325_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 1951 /* ccmpzq */, X86::CCMP64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 1951 /* ccmpzq */, X86::CCMP64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 1951 /* ccmpzq */, X86::CCMP64ri8, Convert__Reg1_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1951 /* ccmpzq */, X86::CCMP64mi8, Convert__Mem645_2__ImmSExti64i81_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1951 /* ccmpzq */, X86::CCMP64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1951 /* ccmpzq */, X86::CCMP64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1951 /* ccmpzq */, X86::CCMP64rm, Convert__Reg1_2__Mem645_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 1958 /* ccmpzw */, X86::CCMP16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 1958 /* ccmpzw */, X86::CCMP16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 1958 /* ccmpzw */, X86::CCMP16ri8, Convert__Reg1_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1958 /* ccmpzw */, X86::CCMP16mi8, Convert__Mem165_2__ImmSExti16i81_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1958 /* ccmpzw */, X86::CCMP16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 1958 /* ccmpzw */, X86::CCMP16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 1958 /* ccmpzw */, X86::CCMP16rm, Convert__Reg1_2__Mem165_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 1991 /* cfcmovael */, X86::CFCMOV32rr, Convert__Reg1_1__Reg1_0__imm_95_3, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 1991 /* cfcmovael */, X86::CFCMOV32mr, Convert__Mem325_1__Reg1_0__imm_95_3, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 1991 /* cfcmovael */, X86::CFCMOV32rm, Convert__Reg1_1__Mem325_0__imm_95_3, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 1991 /* cfcmovael */, X86::CFCMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_3, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 1991 /* cfcmovael */, X86::CFCMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_3, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2001 /* cfcmovaeq */, X86::CFCMOV64rr, Convert__Reg1_1__Reg1_0__imm_95_3, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 2001 /* cfcmovaeq */, X86::CFCMOV64mr, Convert__Mem645_1__Reg1_0__imm_95_3, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 2001 /* cfcmovaeq */, X86::CFCMOV64rm, Convert__Reg1_1__Mem645_0__imm_95_3, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 2001 /* cfcmovaeq */, X86::CFCMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_3, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2001 /* cfcmovaeq */, X86::CFCMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_3, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2011 /* cfcmovaew */, X86::CFCMOV16rr, Convert__Reg1_1__Reg1_0__imm_95_3, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 2011 /* cfcmovaew */, X86::CFCMOV16mr, Convert__Mem165_1__Reg1_0__imm_95_3, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 2011 /* cfcmovaew */, X86::CFCMOV16rm, Convert__Reg1_1__Mem165_0__imm_95_3, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 2011 /* cfcmovaew */, X86::CFCMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_3, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2011 /* cfcmovaew */, X86::CFCMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_3, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2021 /* cfcmoval */, X86::CFCMOV32rr, Convert__Reg1_1__Reg1_0__imm_95_7, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 2021 /* cfcmoval */, X86::CFCMOV32mr, Convert__Mem325_1__Reg1_0__imm_95_7, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 2021 /* cfcmoval */, X86::CFCMOV32rm, Convert__Reg1_1__Mem325_0__imm_95_7, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 2021 /* cfcmoval */, X86::CFCMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_7, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2021 /* cfcmoval */, X86::CFCMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_7, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2030 /* cfcmovaq */, X86::CFCMOV64rr, Convert__Reg1_1__Reg1_0__imm_95_7, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 2030 /* cfcmovaq */, X86::CFCMOV64mr, Convert__Mem645_1__Reg1_0__imm_95_7, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 2030 /* cfcmovaq */, X86::CFCMOV64rm, Convert__Reg1_1__Mem645_0__imm_95_7, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 2030 /* cfcmovaq */, X86::CFCMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_7, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2030 /* cfcmovaq */, X86::CFCMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_7, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2039 /* cfcmovaw */, X86::CFCMOV16rr, Convert__Reg1_1__Reg1_0__imm_95_7, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 2039 /* cfcmovaw */, X86::CFCMOV16mr, Convert__Mem165_1__Reg1_0__imm_95_7, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 2039 /* cfcmovaw */, X86::CFCMOV16rm, Convert__Reg1_1__Mem165_0__imm_95_7, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 2039 /* cfcmovaw */, X86::CFCMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_7, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2039 /* cfcmovaw */, X86::CFCMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_7, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2065 /* cfcmovbel */, X86::CFCMOV32rr, Convert__Reg1_1__Reg1_0__imm_95_6, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 2065 /* cfcmovbel */, X86::CFCMOV32mr, Convert__Mem325_1__Reg1_0__imm_95_6, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 2065 /* cfcmovbel */, X86::CFCMOV32rm, Convert__Reg1_1__Mem325_0__imm_95_6, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 2065 /* cfcmovbel */, X86::CFCMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_6, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2065 /* cfcmovbel */, X86::CFCMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_6, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2075 /* cfcmovbeq */, X86::CFCMOV64rr, Convert__Reg1_1__Reg1_0__imm_95_6, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 2075 /* cfcmovbeq */, X86::CFCMOV64mr, Convert__Mem645_1__Reg1_0__imm_95_6, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 2075 /* cfcmovbeq */, X86::CFCMOV64rm, Convert__Reg1_1__Mem645_0__imm_95_6, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 2075 /* cfcmovbeq */, X86::CFCMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_6, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2075 /* cfcmovbeq */, X86::CFCMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_6, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2085 /* cfcmovbew */, X86::CFCMOV16rr, Convert__Reg1_1__Reg1_0__imm_95_6, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 2085 /* cfcmovbew */, X86::CFCMOV16mr, Convert__Mem165_1__Reg1_0__imm_95_6, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 2085 /* cfcmovbew */, X86::CFCMOV16rm, Convert__Reg1_1__Mem165_0__imm_95_6, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 2085 /* cfcmovbew */, X86::CFCMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_6, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2085 /* cfcmovbew */, X86::CFCMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_6, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2095 /* cfcmovbl */, X86::CFCMOV32rr, Convert__Reg1_1__Reg1_0__imm_95_2, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 2095 /* cfcmovbl */, X86::CFCMOV32mr, Convert__Mem325_1__Reg1_0__imm_95_2, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 2095 /* cfcmovbl */, X86::CFCMOV32rm, Convert__Reg1_1__Mem325_0__imm_95_2, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 2095 /* cfcmovbl */, X86::CFCMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_2, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2095 /* cfcmovbl */, X86::CFCMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_2, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2104 /* cfcmovbq */, X86::CFCMOV64rr, Convert__Reg1_1__Reg1_0__imm_95_2, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 2104 /* cfcmovbq */, X86::CFCMOV64mr, Convert__Mem645_1__Reg1_0__imm_95_2, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 2104 /* cfcmovbq */, X86::CFCMOV64rm, Convert__Reg1_1__Mem645_0__imm_95_2, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 2104 /* cfcmovbq */, X86::CFCMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_2, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2104 /* cfcmovbq */, X86::CFCMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_2, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2113 /* cfcmovbw */, X86::CFCMOV16rr, Convert__Reg1_1__Reg1_0__imm_95_2, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 2113 /* cfcmovbw */, X86::CFCMOV16mr, Convert__Mem165_1__Reg1_0__imm_95_2, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 2113 /* cfcmovbw */, X86::CFCMOV16rm, Convert__Reg1_1__Mem165_0__imm_95_2, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 2113 /* cfcmovbw */, X86::CFCMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_2, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2113 /* cfcmovbw */, X86::CFCMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_2, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2130 /* cfcmovel */, X86::CFCMOV32rr, Convert__Reg1_1__Reg1_0__imm_95_4, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 2130 /* cfcmovel */, X86::CFCMOV32mr, Convert__Mem325_1__Reg1_0__imm_95_4, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 2130 /* cfcmovel */, X86::CFCMOV32rm, Convert__Reg1_1__Mem325_0__imm_95_4, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 2130 /* cfcmovel */, X86::CFCMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_4, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2130 /* cfcmovel */, X86::CFCMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_4, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2139 /* cfcmoveq */, X86::CFCMOV64rr, Convert__Reg1_1__Reg1_0__imm_95_4, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 2139 /* cfcmoveq */, X86::CFCMOV64mr, Convert__Mem645_1__Reg1_0__imm_95_4, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 2139 /* cfcmoveq */, X86::CFCMOV64rm, Convert__Reg1_1__Mem645_0__imm_95_4, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 2139 /* cfcmoveq */, X86::CFCMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_4, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2139 /* cfcmoveq */, X86::CFCMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_4, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2148 /* cfcmovew */, X86::CFCMOV16rr, Convert__Reg1_1__Reg1_0__imm_95_4, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 2148 /* cfcmovew */, X86::CFCMOV16mr, Convert__Mem165_1__Reg1_0__imm_95_4, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 2148 /* cfcmovew */, X86::CFCMOV16rm, Convert__Reg1_1__Mem165_0__imm_95_4, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 2148 /* cfcmovew */, X86::CFCMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_4, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2148 /* cfcmovew */, X86::CFCMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_4, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2174 /* cfcmovgel */, X86::CFCMOV32rr, Convert__Reg1_1__Reg1_0__imm_95_13, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 2174 /* cfcmovgel */, X86::CFCMOV32mr, Convert__Mem325_1__Reg1_0__imm_95_13, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 2174 /* cfcmovgel */, X86::CFCMOV32rm, Convert__Reg1_1__Mem325_0__imm_95_13, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 2174 /* cfcmovgel */, X86::CFCMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_13, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2174 /* cfcmovgel */, X86::CFCMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_13, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2184 /* cfcmovgeq */, X86::CFCMOV64rr, Convert__Reg1_1__Reg1_0__imm_95_13, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 2184 /* cfcmovgeq */, X86::CFCMOV64mr, Convert__Mem645_1__Reg1_0__imm_95_13, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 2184 /* cfcmovgeq */, X86::CFCMOV64rm, Convert__Reg1_1__Mem645_0__imm_95_13, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 2184 /* cfcmovgeq */, X86::CFCMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_13, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2184 /* cfcmovgeq */, X86::CFCMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_13, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2194 /* cfcmovgew */, X86::CFCMOV16rr, Convert__Reg1_1__Reg1_0__imm_95_13, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 2194 /* cfcmovgew */, X86::CFCMOV16mr, Convert__Mem165_1__Reg1_0__imm_95_13, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 2194 /* cfcmovgew */, X86::CFCMOV16rm, Convert__Reg1_1__Mem165_0__imm_95_13, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 2194 /* cfcmovgew */, X86::CFCMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_13, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2194 /* cfcmovgew */, X86::CFCMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_13, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2204 /* cfcmovgl */, X86::CFCMOV32rr, Convert__Reg1_1__Reg1_0__imm_95_15, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 2204 /* cfcmovgl */, X86::CFCMOV32mr, Convert__Mem325_1__Reg1_0__imm_95_15, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 2204 /* cfcmovgl */, X86::CFCMOV32rm, Convert__Reg1_1__Mem325_0__imm_95_15, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 2204 /* cfcmovgl */, X86::CFCMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_15, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2204 /* cfcmovgl */, X86::CFCMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_15, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2213 /* cfcmovgq */, X86::CFCMOV64rr, Convert__Reg1_1__Reg1_0__imm_95_15, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 2213 /* cfcmovgq */, X86::CFCMOV64mr, Convert__Mem645_1__Reg1_0__imm_95_15, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 2213 /* cfcmovgq */, X86::CFCMOV64rm, Convert__Reg1_1__Mem645_0__imm_95_15, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 2213 /* cfcmovgq */, X86::CFCMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_15, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2213 /* cfcmovgq */, X86::CFCMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_15, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2222 /* cfcmovgw */, X86::CFCMOV16rr, Convert__Reg1_1__Reg1_0__imm_95_15, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 2222 /* cfcmovgw */, X86::CFCMOV16mr, Convert__Mem165_1__Reg1_0__imm_95_15, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 2222 /* cfcmovgw */, X86::CFCMOV16rm, Convert__Reg1_1__Mem165_0__imm_95_15, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 2222 /* cfcmovgw */, X86::CFCMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_15, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2222 /* cfcmovgw */, X86::CFCMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_15, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2248 /* cfcmovlel */, X86::CFCMOV32rr, Convert__Reg1_1__Reg1_0__imm_95_14, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 2248 /* cfcmovlel */, X86::CFCMOV32mr, Convert__Mem325_1__Reg1_0__imm_95_14, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 2248 /* cfcmovlel */, X86::CFCMOV32rm, Convert__Reg1_1__Mem325_0__imm_95_14, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 2248 /* cfcmovlel */, X86::CFCMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_14, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2248 /* cfcmovlel */, X86::CFCMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_14, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2258 /* cfcmovleq */, X86::CFCMOV64rr, Convert__Reg1_1__Reg1_0__imm_95_14, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 2258 /* cfcmovleq */, X86::CFCMOV64mr, Convert__Mem645_1__Reg1_0__imm_95_14, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 2258 /* cfcmovleq */, X86::CFCMOV64rm, Convert__Reg1_1__Mem645_0__imm_95_14, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 2258 /* cfcmovleq */, X86::CFCMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_14, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2258 /* cfcmovleq */, X86::CFCMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_14, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2268 /* cfcmovlew */, X86::CFCMOV16rr, Convert__Reg1_1__Reg1_0__imm_95_14, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 2268 /* cfcmovlew */, X86::CFCMOV16mr, Convert__Mem165_1__Reg1_0__imm_95_14, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 2268 /* cfcmovlew */, X86::CFCMOV16rm, Convert__Reg1_1__Mem165_0__imm_95_14, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 2268 /* cfcmovlew */, X86::CFCMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_14, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2268 /* cfcmovlew */, X86::CFCMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_14, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2278 /* cfcmovll */, X86::CFCMOV32rr, Convert__Reg1_1__Reg1_0__imm_95_12, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 2278 /* cfcmovll */, X86::CFCMOV32mr, Convert__Mem325_1__Reg1_0__imm_95_12, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 2278 /* cfcmovll */, X86::CFCMOV32rm, Convert__Reg1_1__Mem325_0__imm_95_12, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 2278 /* cfcmovll */, X86::CFCMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_12, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2278 /* cfcmovll */, X86::CFCMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_12, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2287 /* cfcmovlq */, X86::CFCMOV64rr, Convert__Reg1_1__Reg1_0__imm_95_12, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 2287 /* cfcmovlq */, X86::CFCMOV64mr, Convert__Mem645_1__Reg1_0__imm_95_12, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 2287 /* cfcmovlq */, X86::CFCMOV64rm, Convert__Reg1_1__Mem645_0__imm_95_12, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 2287 /* cfcmovlq */, X86::CFCMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_12, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2287 /* cfcmovlq */, X86::CFCMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_12, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2296 /* cfcmovlw */, X86::CFCMOV16rr, Convert__Reg1_1__Reg1_0__imm_95_12, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 2296 /* cfcmovlw */, X86::CFCMOV16mr, Convert__Mem165_1__Reg1_0__imm_95_12, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 2296 /* cfcmovlw */, X86::CFCMOV16rm, Convert__Reg1_1__Mem165_0__imm_95_12, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 2296 /* cfcmovlw */, X86::CFCMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_12, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2296 /* cfcmovlw */, X86::CFCMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_12, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2314 /* cfcmovnel */, X86::CFCMOV32rr, Convert__Reg1_1__Reg1_0__imm_95_5, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 2314 /* cfcmovnel */, X86::CFCMOV32mr, Convert__Mem325_1__Reg1_0__imm_95_5, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 2314 /* cfcmovnel */, X86::CFCMOV32rm, Convert__Reg1_1__Mem325_0__imm_95_5, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 2314 /* cfcmovnel */, X86::CFCMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_5, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2314 /* cfcmovnel */, X86::CFCMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_5, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2324 /* cfcmovneq */, X86::CFCMOV64rr, Convert__Reg1_1__Reg1_0__imm_95_5, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 2324 /* cfcmovneq */, X86::CFCMOV64mr, Convert__Mem645_1__Reg1_0__imm_95_5, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 2324 /* cfcmovneq */, X86::CFCMOV64rm, Convert__Reg1_1__Mem645_0__imm_95_5, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 2324 /* cfcmovneq */, X86::CFCMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_5, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2324 /* cfcmovneq */, X86::CFCMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_5, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2334 /* cfcmovnew */, X86::CFCMOV16rr, Convert__Reg1_1__Reg1_0__imm_95_5, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 2334 /* cfcmovnew */, X86::CFCMOV16mr, Convert__Mem165_1__Reg1_0__imm_95_5, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 2334 /* cfcmovnew */, X86::CFCMOV16rm, Convert__Reg1_1__Mem165_0__imm_95_5, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 2334 /* cfcmovnew */, X86::CFCMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_5, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2334 /* cfcmovnew */, X86::CFCMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_5, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2353 /* cfcmovnol */, X86::CFCMOV32rr, Convert__Reg1_1__Reg1_0__imm_95_1, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 2353 /* cfcmovnol */, X86::CFCMOV32mr, Convert__Mem325_1__Reg1_0__imm_95_1, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 2353 /* cfcmovnol */, X86::CFCMOV32rm, Convert__Reg1_1__Mem325_0__imm_95_1, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 2353 /* cfcmovnol */, X86::CFCMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_1, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2353 /* cfcmovnol */, X86::CFCMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_1, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2363 /* cfcmovnoq */, X86::CFCMOV64rr, Convert__Reg1_1__Reg1_0__imm_95_1, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 2363 /* cfcmovnoq */, X86::CFCMOV64mr, Convert__Mem645_1__Reg1_0__imm_95_1, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 2363 /* cfcmovnoq */, X86::CFCMOV64rm, Convert__Reg1_1__Mem645_0__imm_95_1, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 2363 /* cfcmovnoq */, X86::CFCMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_1, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2363 /* cfcmovnoq */, X86::CFCMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_1, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2373 /* cfcmovnow */, X86::CFCMOV16rr, Convert__Reg1_1__Reg1_0__imm_95_1, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 2373 /* cfcmovnow */, X86::CFCMOV16mr, Convert__Mem165_1__Reg1_0__imm_95_1, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 2373 /* cfcmovnow */, X86::CFCMOV16rm, Convert__Reg1_1__Mem165_0__imm_95_1, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 2373 /* cfcmovnow */, X86::CFCMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_1, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2373 /* cfcmovnow */, X86::CFCMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_1, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2392 /* cfcmovnpl */, X86::CFCMOV32rr, Convert__Reg1_1__Reg1_0__imm_95_11, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 2392 /* cfcmovnpl */, X86::CFCMOV32mr, Convert__Mem325_1__Reg1_0__imm_95_11, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 2392 /* cfcmovnpl */, X86::CFCMOV32rm, Convert__Reg1_1__Mem325_0__imm_95_11, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 2392 /* cfcmovnpl */, X86::CFCMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_11, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2392 /* cfcmovnpl */, X86::CFCMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_11, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2402 /* cfcmovnpq */, X86::CFCMOV64rr, Convert__Reg1_1__Reg1_0__imm_95_11, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 2402 /* cfcmovnpq */, X86::CFCMOV64mr, Convert__Mem645_1__Reg1_0__imm_95_11, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 2402 /* cfcmovnpq */, X86::CFCMOV64rm, Convert__Reg1_1__Mem645_0__imm_95_11, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 2402 /* cfcmovnpq */, X86::CFCMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_11, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2402 /* cfcmovnpq */, X86::CFCMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_11, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2412 /* cfcmovnpw */, X86::CFCMOV16rr, Convert__Reg1_1__Reg1_0__imm_95_11, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 2412 /* cfcmovnpw */, X86::CFCMOV16mr, Convert__Mem165_1__Reg1_0__imm_95_11, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 2412 /* cfcmovnpw */, X86::CFCMOV16rm, Convert__Reg1_1__Mem165_0__imm_95_11, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 2412 /* cfcmovnpw */, X86::CFCMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_11, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2412 /* cfcmovnpw */, X86::CFCMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_11, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2431 /* cfcmovnsl */, X86::CFCMOV32rr, Convert__Reg1_1__Reg1_0__imm_95_9, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 2431 /* cfcmovnsl */, X86::CFCMOV32mr, Convert__Mem325_1__Reg1_0__imm_95_9, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 2431 /* cfcmovnsl */, X86::CFCMOV32rm, Convert__Reg1_1__Mem325_0__imm_95_9, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 2431 /* cfcmovnsl */, X86::CFCMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_9, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2431 /* cfcmovnsl */, X86::CFCMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_9, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2441 /* cfcmovnsq */, X86::CFCMOV64rr, Convert__Reg1_1__Reg1_0__imm_95_9, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 2441 /* cfcmovnsq */, X86::CFCMOV64mr, Convert__Mem645_1__Reg1_0__imm_95_9, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 2441 /* cfcmovnsq */, X86::CFCMOV64rm, Convert__Reg1_1__Mem645_0__imm_95_9, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 2441 /* cfcmovnsq */, X86::CFCMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_9, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2441 /* cfcmovnsq */, X86::CFCMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_9, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2451 /* cfcmovnsw */, X86::CFCMOV16rr, Convert__Reg1_1__Reg1_0__imm_95_9, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 2451 /* cfcmovnsw */, X86::CFCMOV16mr, Convert__Mem165_1__Reg1_0__imm_95_9, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 2451 /* cfcmovnsw */, X86::CFCMOV16rm, Convert__Reg1_1__Mem165_0__imm_95_9, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 2451 /* cfcmovnsw */, X86::CFCMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_9, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2451 /* cfcmovnsw */, X86::CFCMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_9, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2469 /* cfcmovol */, X86::CFCMOV32rr, Convert__Reg1_1__Reg1_0__imm_95_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 2469 /* cfcmovol */, X86::CFCMOV32mr, Convert__Mem325_1__Reg1_0__imm_95_0, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 2469 /* cfcmovol */, X86::CFCMOV32rm, Convert__Reg1_1__Mem325_0__imm_95_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 2469 /* cfcmovol */, X86::CFCMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2469 /* cfcmovol */, X86::CFCMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2478 /* cfcmovoq */, X86::CFCMOV64rr, Convert__Reg1_1__Reg1_0__imm_95_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 2478 /* cfcmovoq */, X86::CFCMOV64mr, Convert__Mem645_1__Reg1_0__imm_95_0, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 2478 /* cfcmovoq */, X86::CFCMOV64rm, Convert__Reg1_1__Mem645_0__imm_95_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 2478 /* cfcmovoq */, X86::CFCMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2478 /* cfcmovoq */, X86::CFCMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2487 /* cfcmovow */, X86::CFCMOV16rr, Convert__Reg1_1__Reg1_0__imm_95_0, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 2487 /* cfcmovow */, X86::CFCMOV16mr, Convert__Mem165_1__Reg1_0__imm_95_0, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 2487 /* cfcmovow */, X86::CFCMOV16rm, Convert__Reg1_1__Mem165_0__imm_95_0, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 2487 /* cfcmovow */, X86::CFCMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_0, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2487 /* cfcmovow */, X86::CFCMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_0, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2504 /* cfcmovpl */, X86::CFCMOV32rr, Convert__Reg1_1__Reg1_0__imm_95_10, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 2504 /* cfcmovpl */, X86::CFCMOV32mr, Convert__Mem325_1__Reg1_0__imm_95_10, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 2504 /* cfcmovpl */, X86::CFCMOV32rm, Convert__Reg1_1__Mem325_0__imm_95_10, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 2504 /* cfcmovpl */, X86::CFCMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_10, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2504 /* cfcmovpl */, X86::CFCMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_10, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2513 /* cfcmovpq */, X86::CFCMOV64rr, Convert__Reg1_1__Reg1_0__imm_95_10, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 2513 /* cfcmovpq */, X86::CFCMOV64mr, Convert__Mem645_1__Reg1_0__imm_95_10, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 2513 /* cfcmovpq */, X86::CFCMOV64rm, Convert__Reg1_1__Mem645_0__imm_95_10, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 2513 /* cfcmovpq */, X86::CFCMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_10, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2513 /* cfcmovpq */, X86::CFCMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_10, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2522 /* cfcmovpw */, X86::CFCMOV16rr, Convert__Reg1_1__Reg1_0__imm_95_10, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 2522 /* cfcmovpw */, X86::CFCMOV16mr, Convert__Mem165_1__Reg1_0__imm_95_10, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 2522 /* cfcmovpw */, X86::CFCMOV16rm, Convert__Reg1_1__Mem165_0__imm_95_10, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 2522 /* cfcmovpw */, X86::CFCMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_10, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2522 /* cfcmovpw */, X86::CFCMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_10, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2539 /* cfcmovsl */, X86::CFCMOV32rr, Convert__Reg1_1__Reg1_0__imm_95_8, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 2539 /* cfcmovsl */, X86::CFCMOV32mr, Convert__Mem325_1__Reg1_0__imm_95_8, AMFBS_In64BitMode, { MCK_GR32, MCK_Mem32 }, },
  { 2539 /* cfcmovsl */, X86::CFCMOV32rm, Convert__Reg1_1__Mem325_0__imm_95_8, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 2539 /* cfcmovsl */, X86::CFCMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_8, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2539 /* cfcmovsl */, X86::CFCMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_8, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2548 /* cfcmovsq */, X86::CFCMOV64rr, Convert__Reg1_1__Reg1_0__imm_95_8, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 2548 /* cfcmovsq */, X86::CFCMOV64mr, Convert__Mem645_1__Reg1_0__imm_95_8, AMFBS_In64BitMode, { MCK_GR64, MCK_Mem64 }, },
  { 2548 /* cfcmovsq */, X86::CFCMOV64rm, Convert__Reg1_1__Mem645_0__imm_95_8, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 2548 /* cfcmovsq */, X86::CFCMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_8, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2548 /* cfcmovsq */, X86::CFCMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_8, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2557 /* cfcmovsw */, X86::CFCMOV16rr, Convert__Reg1_1__Reg1_0__imm_95_8, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 2557 /* cfcmovsw */, X86::CFCMOV16mr, Convert__Mem165_1__Reg1_0__imm_95_8, AMFBS_In64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 2557 /* cfcmovsw */, X86::CFCMOV16rm, Convert__Reg1_1__Mem165_0__imm_95_8, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 2557 /* cfcmovsw */, X86::CFCMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_8, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2557 /* cfcmovsw */, X86::CFCMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_8, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2566 /* clac */, X86::CLAC, Convert_NoOperands, AMFBS_None, {  }, },
  { 2571 /* clc */, X86::CLC, Convert_NoOperands, AMFBS_None, {  }, },
  { 2575 /* cld */, X86::CLD, Convert_NoOperands, AMFBS_None, {  }, },
  { 2579 /* cldemote */, X86::CLDEMOTE, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 2588 /* clflush */, X86::CLFLUSH, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 2596 /* clflushopt */, X86::CLFLUSHOPT, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 2607 /* clgi */, X86::CLGI, Convert_NoOperands, AMFBS_None, {  }, },
  { 2612 /* cli */, X86::CLI, Convert_NoOperands, AMFBS_None, {  }, },
  { 2620 /* clrb */, X86::XOR8rr, Convert__Reg1_0__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR8 }, },
  { 2625 /* clrl */, X86::XOR32rr, Convert__Reg1_0__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR32 }, },
  { 2630 /* clrq */, X86::XOR64rr, Convert__Reg1_0__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR64 }, },
  { 2635 /* clrssbsy */, X86::CLRSSBSY, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 2644 /* clrw */, X86::XOR16rr, Convert__Reg1_0__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR16 }, },
  { 2649 /* cltd */, X86::CDQ, Convert_NoOperands, AMFBS_None, {  }, },
  { 2654 /* cltq */, X86::CDQE, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 2659 /* clts */, X86::CLTS, Convert_NoOperands, AMFBS_None, {  }, },
  { 2664 /* clui */, X86::CLUI, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 2669 /* clwb */, X86::CLWB, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 2674 /* clzero */, X86::CLZERO32r, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 2674 /* clzero */, X86::CLZERO64r, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 2674 /* clzero */, X86::CLZERO32r, Convert_NoOperands, AMFBS_Not64BitMode, { MCK_EAX }, },
  { 2674 /* clzero */, X86::CLZERO64r, Convert_NoOperands, AMFBS_In64BitMode, { MCK_RAX }, },
  { 2681 /* cmc */, X86::CMC, Convert_NoOperands, AMFBS_None, {  }, },
  { 2698 /* cmovael */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_3, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 2698 /* cmovael */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_3, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 2698 /* cmovael */, X86::CMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_3, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2698 /* cmovael */, X86::CMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_3, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2706 /* cmovaeq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_3, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2706 /* cmovaeq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_3, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 2706 /* cmovaeq */, X86::CMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_3, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2706 /* cmovaeq */, X86::CMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_3, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2714 /* cmovaew */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_3, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 2714 /* cmovaew */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_3, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 2714 /* cmovaew */, X86::CMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_3, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2714 /* cmovaew */, X86::CMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_3, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2722 /* cmoval */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_7, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 2722 /* cmoval */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_7, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 2722 /* cmoval */, X86::CMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_7, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2722 /* cmoval */, X86::CMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_7, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2729 /* cmovaq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_7, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2729 /* cmovaq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_7, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 2729 /* cmovaq */, X86::CMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_7, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2729 /* cmovaq */, X86::CMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_7, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2736 /* cmovaw */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_7, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 2736 /* cmovaw */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_7, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 2736 /* cmovaw */, X86::CMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_7, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2736 /* cmovaw */, X86::CMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_7, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2756 /* cmovbel */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_6, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 2756 /* cmovbel */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_6, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 2756 /* cmovbel */, X86::CMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_6, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2756 /* cmovbel */, X86::CMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_6, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2764 /* cmovbeq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_6, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2764 /* cmovbeq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_6, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 2764 /* cmovbeq */, X86::CMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_6, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2764 /* cmovbeq */, X86::CMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_6, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2772 /* cmovbew */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_6, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 2772 /* cmovbew */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_6, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 2772 /* cmovbew */, X86::CMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_6, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2772 /* cmovbew */, X86::CMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_6, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2780 /* cmovbl */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_2, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 2780 /* cmovbl */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_2, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 2780 /* cmovbl */, X86::CMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_2, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2780 /* cmovbl */, X86::CMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_2, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2787 /* cmovbq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_2, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2787 /* cmovbq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_2, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 2787 /* cmovbq */, X86::CMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_2, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2787 /* cmovbq */, X86::CMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_2, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2794 /* cmovbw */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_2, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 2794 /* cmovbw */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_2, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 2794 /* cmovbw */, X86::CMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_2, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2794 /* cmovbw */, X86::CMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_2, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2807 /* cmovel */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_4, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 2807 /* cmovel */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_4, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 2807 /* cmovel */, X86::CMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_4, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2807 /* cmovel */, X86::CMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_4, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2814 /* cmoveq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_4, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2814 /* cmoveq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_4, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 2814 /* cmoveq */, X86::CMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_4, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2814 /* cmoveq */, X86::CMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_4, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2821 /* cmovew */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_4, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 2821 /* cmovew */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_4, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 2821 /* cmovew */, X86::CMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_4, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2821 /* cmovew */, X86::CMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_4, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2841 /* cmovgel */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_13, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 2841 /* cmovgel */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_13, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 2841 /* cmovgel */, X86::CMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_13, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2841 /* cmovgel */, X86::CMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_13, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2849 /* cmovgeq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_13, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2849 /* cmovgeq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_13, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 2849 /* cmovgeq */, X86::CMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_13, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2849 /* cmovgeq */, X86::CMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_13, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2857 /* cmovgew */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_13, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 2857 /* cmovgew */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_13, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 2857 /* cmovgew */, X86::CMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_13, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2857 /* cmovgew */, X86::CMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_13, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2865 /* cmovgl */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_15, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 2865 /* cmovgl */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_15, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 2865 /* cmovgl */, X86::CMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_15, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2865 /* cmovgl */, X86::CMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_15, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2872 /* cmovgq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_15, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2872 /* cmovgq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_15, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 2872 /* cmovgq */, X86::CMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_15, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2872 /* cmovgq */, X86::CMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_15, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2879 /* cmovgw */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_15, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 2879 /* cmovgw */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_15, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 2879 /* cmovgw */, X86::CMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_15, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2879 /* cmovgw */, X86::CMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_15, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2899 /* cmovlel */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_14, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 2899 /* cmovlel */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_14, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 2899 /* cmovlel */, X86::CMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_14, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2899 /* cmovlel */, X86::CMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_14, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2907 /* cmovleq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_14, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2907 /* cmovleq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_14, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 2907 /* cmovleq */, X86::CMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_14, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2907 /* cmovleq */, X86::CMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_14, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2915 /* cmovlew */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_14, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 2915 /* cmovlew */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_14, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 2915 /* cmovlew */, X86::CMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_14, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2915 /* cmovlew */, X86::CMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_14, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2923 /* cmovll */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_12, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 2923 /* cmovll */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_12, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 2923 /* cmovll */, X86::CMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_12, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2923 /* cmovll */, X86::CMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_12, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2930 /* cmovlq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_12, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2930 /* cmovlq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_12, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 2930 /* cmovlq */, X86::CMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_12, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2930 /* cmovlq */, X86::CMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_12, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2937 /* cmovlw */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_12, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 2937 /* cmovlw */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_12, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 2937 /* cmovlw */, X86::CMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_12, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2937 /* cmovlw */, X86::CMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_12, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2951 /* cmovnel */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_5, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 2951 /* cmovnel */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_5, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 2951 /* cmovnel */, X86::CMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_5, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2951 /* cmovnel */, X86::CMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_5, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2959 /* cmovneq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_5, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2959 /* cmovneq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_5, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 2959 /* cmovneq */, X86::CMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_5, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2959 /* cmovneq */, X86::CMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_5, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2967 /* cmovnew */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_5, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 2967 /* cmovnew */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_5, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 2967 /* cmovnew */, X86::CMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_5, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2967 /* cmovnew */, X86::CMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_5, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 2982 /* cmovnol */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 2982 /* cmovnol */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_1, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 2982 /* cmovnol */, X86::CMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_1, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 2982 /* cmovnol */, X86::CMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_1, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 2990 /* cmovnoq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2990 /* cmovnoq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_1, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 2990 /* cmovnoq */, X86::CMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_1, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 2990 /* cmovnoq */, X86::CMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_1, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 2998 /* cmovnow */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_1, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 2998 /* cmovnow */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_1, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 2998 /* cmovnow */, X86::CMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_1, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 2998 /* cmovnow */, X86::CMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_1, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 3013 /* cmovnpl */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_11, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3013 /* cmovnpl */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_11, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 3013 /* cmovnpl */, X86::CMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_11, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 3013 /* cmovnpl */, X86::CMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_11, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 3021 /* cmovnpq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_11, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 3021 /* cmovnpq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_11, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 3021 /* cmovnpq */, X86::CMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_11, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 3021 /* cmovnpq */, X86::CMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_11, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 3029 /* cmovnpw */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_11, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 3029 /* cmovnpw */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_11, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 3029 /* cmovnpw */, X86::CMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_11, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 3029 /* cmovnpw */, X86::CMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_11, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 3044 /* cmovnsl */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_9, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3044 /* cmovnsl */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_9, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 3044 /* cmovnsl */, X86::CMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_9, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 3044 /* cmovnsl */, X86::CMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_9, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 3052 /* cmovnsq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_9, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 3052 /* cmovnsq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_9, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 3052 /* cmovnsq */, X86::CMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_9, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 3052 /* cmovnsq */, X86::CMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_9, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 3060 /* cmovnsw */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_9, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 3060 /* cmovnsw */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_9, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 3060 /* cmovnsw */, X86::CMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_9, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 3060 /* cmovnsw */, X86::CMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_9, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 3074 /* cmovol */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3074 /* cmovol */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 3074 /* cmovol */, X86::CMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 3074 /* cmovol */, X86::CMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 3081 /* cmovoq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 3081 /* cmovoq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 3081 /* cmovoq */, X86::CMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 3081 /* cmovoq */, X86::CMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 3088 /* cmovow */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 3088 /* cmovow */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 3088 /* cmovow */, X86::CMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_0, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 3088 /* cmovow */, X86::CMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_0, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 3101 /* cmovpl */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_10, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3101 /* cmovpl */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_10, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 3101 /* cmovpl */, X86::CMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_10, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 3101 /* cmovpl */, X86::CMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_10, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 3108 /* cmovpq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_10, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 3108 /* cmovpq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_10, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 3108 /* cmovpq */, X86::CMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_10, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 3108 /* cmovpq */, X86::CMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_10, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 3115 /* cmovpw */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_10, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 3115 /* cmovpw */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_10, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 3115 /* cmovpw */, X86::CMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_10, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 3115 /* cmovpw */, X86::CMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_10, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 3128 /* cmovsl */, X86::CMOV32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_8, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3128 /* cmovsl */, X86::CMOV32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0__imm_95_8, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 3128 /* cmovsl */, X86::CMOV32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_8, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 3128 /* cmovsl */, X86::CMOV32rm_ND, Convert__Reg1_2__Reg1_1__Mem325_0__imm_95_8, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 3135 /* cmovsq */, X86::CMOV64rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_8, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 3135 /* cmovsq */, X86::CMOV64rm, Convert__Reg1_1__Tie0_2_2__Mem645_0__imm_95_8, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 3135 /* cmovsq */, X86::CMOV64rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_8, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 3135 /* cmovsq */, X86::CMOV64rm_ND, Convert__Reg1_2__Reg1_1__Mem645_0__imm_95_8, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 3142 /* cmovsw */, X86::CMOV16rr, Convert__Reg1_1__Tie0_2_2__Reg1_0__imm_95_8, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 3142 /* cmovsw */, X86::CMOV16rm, Convert__Reg1_1__Tie0_2_2__Mem165_0__imm_95_8, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 3142 /* cmovsw */, X86::CMOV16rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_8, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16, MCK_GR16 }, },
  { 3142 /* cmovsw */, X86::CMOV16rm_ND, Convert__Reg1_2__Reg1_1__Mem165_0__imm_95_8, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16, MCK_GR16 }, },
  { 3153 /* cmpaexadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_3, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3153 /* cmpaexadd */, X86::CMPCCXADDmr32_EVEX, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_3, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3153 /* cmpaexadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_3, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3153 /* cmpaexadd */, X86::CMPCCXADDmr64_EVEX, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_3, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3163 /* cmpaxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_7, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3163 /* cmpaxadd */, X86::CMPCCXADDmr32_EVEX, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_7, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3163 /* cmpaxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_7, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3163 /* cmpaxadd */, X86::CMPCCXADDmr64_EVEX, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_7, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3172 /* cmpb */, X86::CMP8rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR8 }, },
  { 3172 /* cmpb */, X86::CMP8mr, Convert__Mem85_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_Mem8 }, },
  { 3172 /* cmpb */, X86::CMP8i8, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AL }, },
  { 3172 /* cmpb */, X86::CMP8ri, Convert__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR8 }, },
  { 3172 /* cmpb */, X86::CMP8mi, Convert__Mem85_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem8 }, },
  { 3172 /* cmpb */, X86::CMP8mi8, Convert__Mem85_1__Imm1_0, AMFBS_Not64BitMode, { MCK_Imm, MCK_Mem8 }, },
  { 3172 /* cmpb */, X86::CMP8rm, Convert__Reg1_1__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR8 }, },
  { 3177 /* cmpbexadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_6, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3177 /* cmpbexadd */, X86::CMPCCXADDmr32_EVEX, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_6, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3177 /* cmpbexadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_6, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3177 /* cmpbexadd */, X86::CMPCCXADDmr64_EVEX, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_6, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3187 /* cmpbxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_2, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3187 /* cmpbxadd */, X86::CMPCCXADDmr32_EVEX, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_2, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3187 /* cmpbxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_2, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3187 /* cmpbxadd */, X86::CMPCCXADDmr64_EVEX, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_2, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3196 /* cmpexadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_4, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3196 /* cmpexadd */, X86::CMPCCXADDmr32_EVEX, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_4, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3196 /* cmpexadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_4, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3196 /* cmpexadd */, X86::CMPCCXADDmr64_EVEX, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_4, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3205 /* cmpgexadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_13, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3205 /* cmpgexadd */, X86::CMPCCXADDmr32_EVEX, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_13, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3205 /* cmpgexadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_13, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3205 /* cmpgexadd */, X86::CMPCCXADDmr64_EVEX, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_13, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3215 /* cmpgxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_15, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3215 /* cmpgxadd */, X86::CMPCCXADDmr32_EVEX, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_15, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3215 /* cmpgxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_15, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3215 /* cmpgxadd */, X86::CMPCCXADDmr64_EVEX, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_15, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3224 /* cmpl */, X86::CMP32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3224 /* cmpl */, X86::CMP32mr, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 3224 /* cmpl */, X86::CMP32ri8, Convert__regEAX__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_EAX }, },
  { 3224 /* cmpl */, X86::CMP32ri8, Convert__Reg1_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 3224 /* cmpl */, X86::CMP32mi8, Convert__Mem325_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 3224 /* cmpl */, X86::CMP32i32, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_EAX }, },
  { 3224 /* cmpl */, X86::CMP32ri, Convert__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR32 }, },
  { 3224 /* cmpl */, X86::CMP32mi, Convert__Mem325_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem32 }, },
  { 3224 /* cmpl */, X86::CMP32rm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 3229 /* cmplexadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_14, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3229 /* cmplexadd */, X86::CMPCCXADDmr32_EVEX, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_14, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3229 /* cmplexadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_14, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3229 /* cmplexadd */, X86::CMPCCXADDmr64_EVEX, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_14, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3239 /* cmplxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_12, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3239 /* cmplxadd */, X86::CMPCCXADDmr32_EVEX, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_12, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3239 /* cmplxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_12, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3239 /* cmplxadd */, X86::CMPCCXADDmr64_EVEX, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_12, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3248 /* cmpnexadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_5, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3248 /* cmpnexadd */, X86::CMPCCXADDmr32_EVEX, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_5, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3248 /* cmpnexadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_5, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3248 /* cmpnexadd */, X86::CMPCCXADDmr64_EVEX, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_5, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3258 /* cmpnoxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_1, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3258 /* cmpnoxadd */, X86::CMPCCXADDmr32_EVEX, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_1, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3258 /* cmpnoxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_1, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3258 /* cmpnoxadd */, X86::CMPCCXADDmr64_EVEX, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_1, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3268 /* cmpnpxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_11, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3268 /* cmpnpxadd */, X86::CMPCCXADDmr32_EVEX, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_11, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3268 /* cmpnpxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_11, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3268 /* cmpnpxadd */, X86::CMPCCXADDmr64_EVEX, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_11, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3278 /* cmpnsxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_9, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3278 /* cmpnsxadd */, X86::CMPCCXADDmr32_EVEX, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_9, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3278 /* cmpnsxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_9, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3278 /* cmpnsxadd */, X86::CMPCCXADDmr64_EVEX, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_9, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3288 /* cmpoxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3288 /* cmpoxadd */, X86::CMPCCXADDmr32_EVEX, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3288 /* cmpoxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3288 /* cmpoxadd */, X86::CMPCCXADDmr64_EVEX, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3297 /* cmppd */, X86::CMPPDrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 3297 /* cmppd */, X86::CMPPDrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 3303 /* cmpps */, X86::CMPPSrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 3303 /* cmpps */, X86::CMPPSrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 3309 /* cmppxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_10, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3309 /* cmppxadd */, X86::CMPCCXADDmr32_EVEX, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_10, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3309 /* cmppxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_10, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3309 /* cmppxadd */, X86::CMPCCXADDmr64_EVEX, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_10, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3318 /* cmpq */, X86::CMP64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 3318 /* cmpq */, X86::CMP64mr, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 3318 /* cmpq */, X86::CMP64ri8, Convert__regRAX__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_RAX }, },
  { 3318 /* cmpq */, X86::CMP64ri8, Convert__Reg1_1__ImmSExti64i81_0, AMFBS_None, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 3318 /* cmpq */, X86::CMP64mi8, Convert__Mem645_1__ImmSExti64i81_0, AMFBS_In64BitMode, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 3318 /* cmpq */, X86::CMP64i32, Convert__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 3318 /* cmpq */, X86::CMP64ri32, Convert__Reg1_1__ImmSExti64i321_0, AMFBS_None, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 3318 /* cmpq */, X86::CMP64mi32, Convert__Mem645_1__ImmSExti64i321_0, AMFBS_In64BitMode, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 3318 /* cmpq */, X86::CMP64rm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 3328 /* cmpsb */, X86::CMPSB, Convert__DstIdx81_0__SrcIdx82_1, AMFBS_None, { MCK_DstIdx8, MCK_SrcIdx8 }, },
  { 3334 /* cmpsd */, X86::CMPSDrri_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 3334 /* cmpsd */, X86::CMPSDrmi_Int, Convert__Reg1_2__Tie0_1_1__Mem645_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR16 }, },
  { 3340 /* cmpsl */, X86::CMPSL, Convert__DstIdx321_0__SrcIdx322_1, AMFBS_None, { MCK_DstIdx32, MCK_SrcIdx32 }, },
  { 3346 /* cmpsq */, X86::CMPSQ, Convert__DstIdx641_0__SrcIdx642_1, AMFBS_In64BitMode, { MCK_DstIdx64, MCK_SrcIdx64 }, },
  { 3352 /* cmpss */, X86::CMPSSrri_Int, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 3352 /* cmpss */, X86::CMPSSrmi_Int, Convert__Reg1_2__Tie0_1_1__Mem325_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR16 }, },
  { 3358 /* cmpsw */, X86::CMPSW, Convert__DstIdx161_0__SrcIdx162_1, AMFBS_None, { MCK_DstIdx16, MCK_SrcIdx16 }, },
  { 3364 /* cmpsxadd */, X86::CMPCCXADDmr32, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_8, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3364 /* cmpsxadd */, X86::CMPCCXADDmr32_EVEX, Convert__Reg1_1__Tie0_2_2__Mem325_2__Reg1_0__imm_95_8, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_Mem32 }, },
  { 3364 /* cmpsxadd */, X86::CMPCCXADDmr64, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_8, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3364 /* cmpsxadd */, X86::CMPCCXADDmr64_EVEX, Convert__Reg1_1__Tie0_2_2__Mem645_2__Reg1_0__imm_95_8, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64, MCK_Mem64 }, },
  { 3373 /* cmpw */, X86::CMP16rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 3373 /* cmpw */, X86::CMP16mr, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 3373 /* cmpw */, X86::CMP16ri8, Convert__regAX__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_AX }, },
  { 3373 /* cmpw */, X86::CMP16ri8, Convert__Reg1_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 3373 /* cmpw */, X86::CMP16mi8, Convert__Mem165_1__ImmSExti16i81_0, AMFBS_None, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 3373 /* cmpw */, X86::CMP16i16, Convert__Imm1_0, AMFBS_None, { MCK_Imm, MCK_AX }, },
  { 3373 /* cmpw */, X86::CMP16ri, Convert__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR16 }, },
  { 3373 /* cmpw */, X86::CMP16mi, Convert__Mem165_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_Mem16 }, },
  { 3373 /* cmpw */, X86::CMP16rm, Convert__Reg1_1__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR16 }, },
  { 3386 /* cmpxchg16b */, X86::CMPXCHG16B, Convert__Mem1285_0, AMFBS_In64BitMode, { MCK_Mem128 }, },
  { 3397 /* cmpxchg8b */, X86::CMPXCHG8B, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 3407 /* cmpxchgb */, X86::CMPXCHG8rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR8 }, },
  { 3407 /* cmpxchgb */, X86::CMPXCHG8rm, Convert__Mem85_1__Reg1_0, AMFBS_None, { MCK_GR8, MCK_Mem8 }, },
  { 3416 /* cmpxchgl */, X86::CMPXCHG32rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3416 /* cmpxchgl */, X86::CMPXCHG32rm, Convert__Mem325_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_Mem32 }, },
  { 3425 /* cmpxchgq */, X86::CMPXCHG64rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 3425 /* cmpxchgq */, X86::CMPXCHG64rm, Convert__Mem645_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_Mem64 }, },
  { 3434 /* cmpxchgw */, X86::CMPXCHG16rr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR16 }, },
  { 3434 /* cmpxchgw */, X86::CMPXCHG16rm, Convert__Mem165_1__Reg1_0, AMFBS_None, { MCK_GR16, MCK_Mem16 }, },
  { 3443 /* comisd */, X86::COMISDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 3443 /* comisd */, X86::COMISDrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 3450 /* comiss */, X86::COMISSrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 3450 /* comiss */, X86::COMISSrm, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 3457 /* cpuid */, X86::CPUID, Convert_NoOperands, AMFBS_None, {  }, },
  { 3467 /* cqto */, X86::CQO, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 3478 /* crc32b */, X86::CRC32r32r8, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR32 }, },
  { 3478 /* crc32b */, X86::CRC32r32r8_EVEX, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_GR32 }, },
  { 3478 /* crc32b */, X86::CRC32r64r8, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR8, MCK_GR64 }, },
  { 3478 /* crc32b */, X86::CRC32r64r8_EVEX, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_GR64 }, },
  { 3478 /* crc32b */, X86::CRC32r32m8, Convert__Reg1_1__Tie0_2_2__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR32 }, },
  { 3478 /* crc32b */, X86::CRC32r32m8_EVEX, Convert__Reg1_1__Tie0_2_2__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8, MCK_GR32 }, },
  { 3478 /* crc32b */, X86::CRC32r64m8, Convert__Reg1_1__Tie0_2_2__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_GR64 }, },
  { 3478 /* crc32b */, X86::CRC32r64m8_EVEX, Convert__Reg1_1__Tie0_2_2__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8, MCK_GR64 }, },
  { 3485 /* crc32l */, X86::CRC32r32r32, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3485 /* crc32l */, X86::CRC32r32r32_EVEX, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 3485 /* crc32l */, X86::CRC32r32m32, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 3485 /* crc32l */, X86::CRC32r32m32_EVEX, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 3492 /* crc32q */, X86::CRC32r64r64, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 3492 /* crc32q */, X86::CRC32r64r64_EVEX, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 3492 /* crc32q */, X86::CRC32r64m64, Convert__Reg1_1__Tie0_2_2__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 3492 /* crc32q */, X86::CRC32r64m64_EVEX, Convert__Reg1_1__Tie0_2_2__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 3499 /* crc32w */, X86::CRC32r32r16, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR16, MCK_GR32 }, },
  { 3499 /* crc32w */, X86::CRC32r32r16_EVEX, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR16, MCK_GR32 }, },
  { 3499 /* crc32w */, X86::CRC32r32m16, Convert__Reg1_1__Tie0_2_2__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_GR32 }, },
  { 3499 /* crc32w */, X86::CRC32r32m16_EVEX, Convert__Reg1_1__Tie0_2_2__Mem165_0, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR32 }, },
  { 3506 /* cs */, X86::CS_PREFIX, Convert_NoOperands, AMFBS_None, {  }, },
  { 3516 /* ctestab */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 3516 /* ctestab */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 3516 /* ctestab */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 3516 /* ctestab */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 3516 /* ctestab */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 3532 /* ctestaeb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 3532 /* ctestaeb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 3532 /* ctestaeb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 3532 /* ctestaeb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 3532 /* ctestaeb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 3541 /* ctestael */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 3541 /* ctestael */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 3541 /* ctestael */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 3541 /* ctestael */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 3541 /* ctestael */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 3550 /* ctestaeq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 3550 /* ctestaeq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 3550 /* ctestaeq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 3550 /* ctestaeq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 3550 /* ctestaeq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 3559 /* ctestaew */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 3559 /* ctestaew */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 3559 /* ctestaew */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 3559 /* ctestaew */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 3559 /* ctestaew */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 3568 /* ctestal */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 3568 /* ctestal */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 3568 /* ctestal */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 3568 /* ctestal */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 3568 /* ctestal */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 3576 /* ctestaq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 3576 /* ctestaq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 3576 /* ctestaq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 3576 /* ctestaq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 3576 /* ctestaq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 3584 /* ctestaw */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 3584 /* ctestaw */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 3584 /* ctestaw */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 3584 /* ctestaw */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 3584 /* ctestaw */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 3599 /* ctestbb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 3599 /* ctestbb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 3599 /* ctestbb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 3599 /* ctestbb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 3599 /* ctestbb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 3615 /* ctestbeb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 3615 /* ctestbeb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 3615 /* ctestbeb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 3615 /* ctestbeb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 3615 /* ctestbeb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 3624 /* ctestbel */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 3624 /* ctestbel */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 3624 /* ctestbel */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 3624 /* ctestbel */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 3624 /* ctestbel */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 3633 /* ctestbeq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 3633 /* ctestbeq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 3633 /* ctestbeq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 3633 /* ctestbeq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 3633 /* ctestbeq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 3642 /* ctestbew */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 3642 /* ctestbew */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 3642 /* ctestbew */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 3642 /* ctestbew */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 3642 /* ctestbew */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 3651 /* ctestbl */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 3651 /* ctestbl */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 3651 /* ctestbl */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 3651 /* ctestbl */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 3651 /* ctestbl */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 3659 /* ctestbq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 3659 /* ctestbq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 3659 /* ctestbq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 3659 /* ctestbq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 3659 /* ctestbq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 3667 /* ctestbw */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 3667 /* ctestbw */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 3667 /* ctestbw */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 3667 /* ctestbw */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 3667 /* ctestbw */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 3682 /* ctestcb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 3682 /* ctestcb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 3682 /* ctestcb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 3682 /* ctestcb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 3682 /* ctestcb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 3690 /* ctestcl */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 3690 /* ctestcl */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 3690 /* ctestcl */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 3690 /* ctestcl */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 3690 /* ctestcl */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 3698 /* ctestcq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 3698 /* ctestcq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 3698 /* ctestcq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 3698 /* ctestcq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 3698 /* ctestcq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 3706 /* ctestcw */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 3706 /* ctestcw */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 3706 /* ctestcw */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 3706 /* ctestcw */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 3706 /* ctestcw */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 3721 /* ctesteb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 3721 /* ctesteb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 3721 /* ctesteb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 3721 /* ctesteb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 3721 /* ctesteb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 3729 /* ctestel */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 3729 /* ctestel */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 3729 /* ctestel */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 3729 /* ctestel */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 3729 /* ctestel */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 3737 /* ctesteq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 3737 /* ctesteq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 3737 /* ctesteq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 3737 /* ctesteq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 3737 /* ctesteq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 3745 /* ctestew */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 3745 /* ctestew */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 3745 /* ctestew */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 3745 /* ctestew */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 3745 /* ctestew */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 3760 /* ctestfb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 3760 /* ctestfb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 3760 /* ctestfb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 3760 /* ctestfb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 3760 /* ctestfb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 3768 /* ctestfl */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 3768 /* ctestfl */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 3768 /* ctestfl */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 3768 /* ctestfl */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 3768 /* ctestfl */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 3776 /* ctestfq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 3776 /* ctestfq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 3776 /* ctestfq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 3776 /* ctestfq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 3776 /* ctestfq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 3784 /* ctestfw */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 3784 /* ctestfw */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 3784 /* ctestfw */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 3784 /* ctestfw */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 3784 /* ctestfw */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_11, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 3799 /* ctestgb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 3799 /* ctestgb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 3799 /* ctestgb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 3799 /* ctestgb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 3799 /* ctestgb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 3815 /* ctestgeb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 3815 /* ctestgeb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 3815 /* ctestgeb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 3815 /* ctestgeb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 3815 /* ctestgeb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 3824 /* ctestgel */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 3824 /* ctestgel */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 3824 /* ctestgel */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 3824 /* ctestgel */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 3824 /* ctestgel */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 3833 /* ctestgeq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 3833 /* ctestgeq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 3833 /* ctestgeq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 3833 /* ctestgeq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 3833 /* ctestgeq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 3842 /* ctestgew */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 3842 /* ctestgew */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 3842 /* ctestgew */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 3842 /* ctestgew */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 3842 /* ctestgew */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 3851 /* ctestgl */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 3851 /* ctestgl */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 3851 /* ctestgl */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 3851 /* ctestgl */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 3851 /* ctestgl */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 3859 /* ctestgq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 3859 /* ctestgq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 3859 /* ctestgq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 3859 /* ctestgq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 3859 /* ctestgq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 3867 /* ctestgw */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 3867 /* ctestgw */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 3867 /* ctestgw */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 3867 /* ctestgw */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 3867 /* ctestgw */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 3882 /* ctestlb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 3882 /* ctestlb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 3882 /* ctestlb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 3882 /* ctestlb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 3882 /* ctestlb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 3898 /* ctestleb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 3898 /* ctestleb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 3898 /* ctestleb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 3898 /* ctestleb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 3898 /* ctestleb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 3907 /* ctestlel */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 3907 /* ctestlel */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 3907 /* ctestlel */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 3907 /* ctestlel */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 3907 /* ctestlel */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 3916 /* ctestleq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 3916 /* ctestleq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 3916 /* ctestleq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 3916 /* ctestleq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 3916 /* ctestleq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 3925 /* ctestlew */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 3925 /* ctestlew */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 3925 /* ctestlew */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 3925 /* ctestlew */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 3925 /* ctestlew */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 3934 /* ctestll */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 3934 /* ctestll */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 3934 /* ctestll */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 3934 /* ctestll */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 3934 /* ctestll */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 3942 /* ctestlq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 3942 /* ctestlq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 3942 /* ctestlq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 3942 /* ctestlq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 3942 /* ctestlq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 3950 /* ctestlw */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 3950 /* ctestlw */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 3950 /* ctestlw */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 3950 /* ctestlw */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 3950 /* ctestlw */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 3966 /* ctestnab */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 3966 /* ctestnab */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 3966 /* ctestnab */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 3966 /* ctestnab */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 3966 /* ctestnab */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 3984 /* ctestnaeb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 3984 /* ctestnaeb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 3984 /* ctestnaeb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 3984 /* ctestnaeb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 3984 /* ctestnaeb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 3994 /* ctestnael */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 3994 /* ctestnael */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 3994 /* ctestnael */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 3994 /* ctestnael */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 3994 /* ctestnael */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 4004 /* ctestnaeq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 4004 /* ctestnaeq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 4004 /* ctestnaeq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 4004 /* ctestnaeq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 4004 /* ctestnaeq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 4014 /* ctestnaew */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 4014 /* ctestnaew */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 4014 /* ctestnaew */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 4014 /* ctestnaew */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 4014 /* ctestnaew */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_2, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 4024 /* ctestnal */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 4024 /* ctestnal */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 4024 /* ctestnal */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 4024 /* ctestnal */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 4024 /* ctestnal */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 4033 /* ctestnaq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 4033 /* ctestnaq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 4033 /* ctestnaq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 4033 /* ctestnaq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 4033 /* ctestnaq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 4042 /* ctestnaw */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 4042 /* ctestnaw */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 4042 /* ctestnaw */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 4042 /* ctestnaw */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 4042 /* ctestnaw */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_6, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 4059 /* ctestnbb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 4059 /* ctestnbb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 4059 /* ctestnbb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 4059 /* ctestnbb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 4059 /* ctestnbb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 4077 /* ctestnbeb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 4077 /* ctestnbeb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 4077 /* ctestnbeb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 4077 /* ctestnbeb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 4077 /* ctestnbeb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 4087 /* ctestnbel */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 4087 /* ctestnbel */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 4087 /* ctestnbel */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 4087 /* ctestnbel */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 4087 /* ctestnbel */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 4097 /* ctestnbeq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 4097 /* ctestnbeq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 4097 /* ctestnbeq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 4097 /* ctestnbeq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 4097 /* ctestnbeq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 4107 /* ctestnbew */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 4107 /* ctestnbew */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 4107 /* ctestnbew */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 4107 /* ctestnbew */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 4107 /* ctestnbew */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_7, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 4117 /* ctestnbl */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 4117 /* ctestnbl */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 4117 /* ctestnbl */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 4117 /* ctestnbl */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 4117 /* ctestnbl */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 4126 /* ctestnbq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 4126 /* ctestnbq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 4126 /* ctestnbq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 4126 /* ctestnbq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 4126 /* ctestnbq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 4135 /* ctestnbw */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 4135 /* ctestnbw */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 4135 /* ctestnbw */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 4135 /* ctestnbw */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 4135 /* ctestnbw */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 4152 /* ctestncb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 4152 /* ctestncb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 4152 /* ctestncb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 4152 /* ctestncb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 4152 /* ctestncb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 4161 /* ctestncl */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 4161 /* ctestncl */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 4161 /* ctestncl */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 4161 /* ctestncl */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 4161 /* ctestncl */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 4170 /* ctestncq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 4170 /* ctestncq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 4170 /* ctestncq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 4170 /* ctestncq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 4170 /* ctestncq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 4179 /* ctestncw */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 4179 /* ctestncw */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 4179 /* ctestncw */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 4179 /* ctestncw */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 4179 /* ctestncw */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_3, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 4196 /* ctestneb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 4196 /* ctestneb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 4196 /* ctestneb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 4196 /* ctestneb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 4196 /* ctestneb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 4205 /* ctestnel */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 4205 /* ctestnel */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 4205 /* ctestnel */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 4205 /* ctestnel */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 4205 /* ctestnel */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 4214 /* ctestneq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 4214 /* ctestneq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 4214 /* ctestneq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 4214 /* ctestneq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 4214 /* ctestneq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 4223 /* ctestnew */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 4223 /* ctestnew */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 4223 /* ctestnew */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 4223 /* ctestnew */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 4223 /* ctestnew */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 4240 /* ctestngb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 4240 /* ctestngb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 4240 /* ctestngb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 4240 /* ctestngb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 4240 /* ctestngb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 4258 /* ctestngeb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 4258 /* ctestngeb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 4258 /* ctestngeb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 4258 /* ctestngeb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 4258 /* ctestngeb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 4268 /* ctestngel */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 4268 /* ctestngel */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 4268 /* ctestngel */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 4268 /* ctestngel */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 4268 /* ctestngel */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 4278 /* ctestngeq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 4278 /* ctestngeq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 4278 /* ctestngeq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 4278 /* ctestngeq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 4278 /* ctestngeq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 4288 /* ctestngew */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 4288 /* ctestngew */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 4288 /* ctestngew */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 4288 /* ctestngew */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 4288 /* ctestngew */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_12, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 4298 /* ctestngl */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 4298 /* ctestngl */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 4298 /* ctestngl */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 4298 /* ctestngl */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 4298 /* ctestngl */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 4307 /* ctestngq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 4307 /* ctestngq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 4307 /* ctestngq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 4307 /* ctestngq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 4307 /* ctestngq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 4316 /* ctestngw */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 4316 /* ctestngw */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 4316 /* ctestngw */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 4316 /* ctestngw */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 4316 /* ctestngw */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_14, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 4333 /* ctestnlb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 4333 /* ctestnlb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 4333 /* ctestnlb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 4333 /* ctestnlb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 4333 /* ctestnlb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 4351 /* ctestnleb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 4351 /* ctestnleb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 4351 /* ctestnleb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 4351 /* ctestnleb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 4351 /* ctestnleb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 4361 /* ctestnlel */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 4361 /* ctestnlel */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 4361 /* ctestnlel */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 4361 /* ctestnlel */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 4361 /* ctestnlel */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 4371 /* ctestnleq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 4371 /* ctestnleq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 4371 /* ctestnleq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 4371 /* ctestnleq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 4371 /* ctestnleq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 4381 /* ctestnlew */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 4381 /* ctestnlew */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 4381 /* ctestnlew */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 4381 /* ctestnlew */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 4381 /* ctestnlew */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_15, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 4391 /* ctestnll */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 4391 /* ctestnll */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 4391 /* ctestnll */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 4391 /* ctestnll */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 4391 /* ctestnll */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 4400 /* ctestnlq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 4400 /* ctestnlq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 4400 /* ctestnlq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 4400 /* ctestnlq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 4400 /* ctestnlq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 4409 /* ctestnlw */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 4409 /* ctestnlw */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 4409 /* ctestnlw */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 4409 /* ctestnlw */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 4409 /* ctestnlw */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_13, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 4426 /* ctestnob */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 4426 /* ctestnob */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 4426 /* ctestnob */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 4426 /* ctestnob */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 4426 /* ctestnob */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 4435 /* ctestnol */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 4435 /* ctestnol */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 4435 /* ctestnol */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 4435 /* ctestnol */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 4435 /* ctestnol */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 4444 /* ctestnoq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 4444 /* ctestnoq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 4444 /* ctestnoq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 4444 /* ctestnoq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 4444 /* ctestnoq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 4453 /* ctestnow */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 4453 /* ctestnow */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 4453 /* ctestnow */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 4453 /* ctestnow */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 4453 /* ctestnow */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_1, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 4470 /* ctestnsb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 4470 /* ctestnsb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 4470 /* ctestnsb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 4470 /* ctestnsb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 4470 /* ctestnsb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 4479 /* ctestnsl */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 4479 /* ctestnsl */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 4479 /* ctestnsl */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 4479 /* ctestnsl */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 4479 /* ctestnsl */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 4488 /* ctestnsq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 4488 /* ctestnsq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 4488 /* ctestnsq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 4488 /* ctestnsq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 4488 /* ctestnsq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 4497 /* ctestnsw */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 4497 /* ctestnsw */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 4497 /* ctestnsw */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 4497 /* ctestnsw */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 4497 /* ctestnsw */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_9, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 4514 /* ctestnzb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 4514 /* ctestnzb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 4514 /* ctestnzb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 4514 /* ctestnzb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 4514 /* ctestnzb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 4523 /* ctestnzl */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 4523 /* ctestnzl */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 4523 /* ctestnzl */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 4523 /* ctestnzl */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 4523 /* ctestnzl */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 4532 /* ctestnzq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 4532 /* ctestnzq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 4532 /* ctestnzq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 4532 /* ctestnzq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 4532 /* ctestnzq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 4541 /* ctestnzw */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 4541 /* ctestnzw */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 4541 /* ctestnzw */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 4541 /* ctestnzw */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 4541 /* ctestnzw */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_5, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 4557 /* ctestob */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 4557 /* ctestob */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 4557 /* ctestob */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 4557 /* ctestob */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 4557 /* ctestob */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 4565 /* ctestol */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 4565 /* ctestol */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 4565 /* ctestol */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 4565 /* ctestol */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 4565 /* ctestol */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 4573 /* ctestoq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 4573 /* ctestoq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 4573 /* ctestoq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 4573 /* ctestoq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 4573 /* ctestoq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 4581 /* ctestow */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 4581 /* ctestow */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 4581 /* ctestow */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 4581 /* ctestow */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 4581 /* ctestow */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_0, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 4596 /* ctestsb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 4596 /* ctestsb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 4596 /* ctestsb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 4596 /* ctestsb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 4596 /* ctestsb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 4604 /* ctestsl */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 4604 /* ctestsl */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 4604 /* ctestsl */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 4604 /* ctestsl */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 4604 /* ctestsl */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 4612 /* ctestsq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 4612 /* ctestsq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 4612 /* ctestsq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 4612 /* ctestsq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 4612 /* ctestsq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 4620 /* ctestsw */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 4620 /* ctestsw */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 4620 /* ctestsw */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 4620 /* ctestsw */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 4620 /* ctestsw */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_8, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 4635 /* ctesttb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 4635 /* ctesttb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 4635 /* ctesttb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 4635 /* ctesttb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 4635 /* ctesttb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 4643 /* ctesttl */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 4643 /* ctesttl */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 4643 /* ctesttl */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 4643 /* ctesttl */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 4643 /* ctesttl */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 4651 /* ctesttq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 4651 /* ctesttq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 4651 /* ctesttq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 4651 /* ctesttq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 4651 /* ctesttq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 4659 /* ctesttw */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 4659 /* ctesttw */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 4659 /* ctesttw */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 4659 /* ctesttw */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 4659 /* ctesttw */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_10, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 4674 /* ctestzb */, X86::CTEST8rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_GR8 }, },
  { 4674 /* ctestzb */, X86::CTEST8mr, Convert__Mem85_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR8, MCK_Mem8 }, },
  { 4674 /* ctestzb */, X86::CTEST8ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR8 }, },
  { 4674 /* ctestzb */, X86::CTEST8mi, Convert__Mem85_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem8 }, },
  { 4674 /* ctestzb */, X86::CTEST8mr, Convert__Mem85_1__Reg1_2__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem8, MCK_GR8 }, },
  { 4682 /* ctestzl */, X86::CTEST32rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_GR32 }, },
  { 4682 /* ctestzl */, X86::CTEST32mr, Convert__Mem325_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR32, MCK_Mem32 }, },
  { 4682 /* ctestzl */, X86::CTEST32ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR32 }, },
  { 4682 /* ctestzl */, X86::CTEST32mi, Convert__Mem325_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem32 }, },
  { 4682 /* ctestzl */, X86::CTEST32mr, Convert__Mem325_1__Reg1_2__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem32, MCK_GR32 }, },
  { 4690 /* ctestzq */, X86::CTEST64rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_GR64 }, },
  { 4690 /* ctestzq */, X86::CTEST64mr, Convert__Mem645_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR64, MCK_Mem64 }, },
  { 4690 /* ctestzq */, X86::CTEST64ri32, Convert__Reg1_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_GR64 }, },
  { 4690 /* ctestzq */, X86::CTEST64mi32, Convert__Mem645_2__ImmSExti64i321_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 4690 /* ctestzq */, X86::CTEST64mr, Convert__Mem645_1__Reg1_2__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem64, MCK_GR64 }, },
  { 4698 /* ctestzw */, X86::CTEST16rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_GR16 }, },
  { 4698 /* ctestzw */, X86::CTEST16mr, Convert__Mem165_2__Reg1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_GR16, MCK_Mem16 }, },
  { 4698 /* ctestzw */, X86::CTEST16ri, Convert__Reg1_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_GR16 }, },
  { 4698 /* ctestzw */, X86::CTEST16mi, Convert__Mem165_2__Imm1_1__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Imm, MCK_Mem16 }, },
  { 4698 /* ctestzw */, X86::CTEST16mr, Convert__Mem165_1__Reg1_2__ImmUnsignedi41_0__imm_95_4, AMFBS_In64BitMode, { MCK_ImmUnsignedi4, MCK_Mem16, MCK_GR16 }, },
  { 4706 /* cvtdq2pd */, X86::CVTDQ2PDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4706 /* cvtdq2pd */, X86::CVTDQ2PDrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 4715 /* cvtdq2ps */, X86::CVTDQ2PSrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4715 /* cvtdq2ps */, X86::CVTDQ2PSrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 4724 /* cvtpd2dq */, X86::CVTPD2DQrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4724 /* cvtpd2dq */, X86::CVTPD2DQrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 4733 /* cvtpd2pi */, X86::MMX_CVTPD2PIrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_VR64 }, },
  { 4733 /* cvtpd2pi */, X86::MMX_CVTPD2PIrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR64 }, },
  { 4742 /* cvtpd2ps */, X86::CVTPD2PSrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4742 /* cvtpd2ps */, X86::CVTPD2PSrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 4751 /* cvtpi2pd */, X86::MMX_CVTPI2PDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_FR16 }, },
  { 4751 /* cvtpi2pd */, X86::MMX_CVTPI2PDrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 4760 /* cvtpi2ps */, X86::MMX_CVTPI2PSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_VR64, MCK_FR16 }, },
  { 4760 /* cvtpi2ps */, X86::MMX_CVTPI2PSrm, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 4769 /* cvtps2dq */, X86::CVTPS2DQrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4769 /* cvtps2dq */, X86::CVTPS2DQrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 4778 /* cvtps2pd */, X86::CVTPS2PDrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4778 /* cvtps2pd */, X86::CVTPS2PDrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 4787 /* cvtps2pi */, X86::MMX_CVTPS2PIrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_VR64 }, },
  { 4787 /* cvtps2pi */, X86::MMX_CVTPS2PIrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 4796 /* cvtsd2si */, X86::CVTSD2SIrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32 }, },
  { 4796 /* cvtsd2si */, X86::CVTSD2SI64rr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR64 }, },
  { 4796 /* cvtsd2si */, X86::CVTSD2SIrm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR32 }, },
  { 4796 /* cvtsd2si */, X86::CVTSD2SI64rm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 4805 /* cvtsd2sil */, X86::CVTSD2SIrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32 }, },
  { 4805 /* cvtsd2sil */, X86::CVTSD2SIrm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR32 }, },
  { 4815 /* cvtsd2siq */, X86::CVTSD2SI64rr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR64 }, },
  { 4815 /* cvtsd2siq */, X86::CVTSD2SI64rm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 4825 /* cvtsd2ss */, X86::CVTSD2SSrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4825 /* cvtsd2ss */, X86::CVTSD2SSrm_Int, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 4834 /* cvtsi2sd */, X86::CVTSI2SDrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_FR16 }, },
  { 4834 /* cvtsi2sd */, X86::CVTSI642SDrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_FR16 }, },
  { 4834 /* cvtsi2sd */, X86::CVTSI2SDrm_Int, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 4843 /* cvtsi2sdl */, X86::CVTSI2SDrr_Int, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_FR16 }, },
  { 4843 /* cvtsi2sdl */, X86::CVTSI2SDrm_Int, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 4853 /* cvtsi2sdq */, X86::CVTSI642SDrr_Int, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_FR16 }, },
  { 4853 /* cvtsi2sdq */, X86::CVTSI642SDrm_Int, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 4863 /* cvtsi2ss */, X86::CVTSI2SSrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_FR16 }, },
  { 4863 /* cvtsi2ss */, X86::CVTSI642SSrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_GR64, MCK_FR16 }, },
  { 4863 /* cvtsi2ss */, X86::CVTSI2SSrm_Int, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 4872 /* cvtsi2ssl */, X86::CVTSI2SSrr_Int, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_FR16 }, },
  { 4872 /* cvtsi2ssl */, X86::CVTSI2SSrm_Int, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 4882 /* cvtsi2ssq */, X86::CVTSI642SSrr_Int, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR64, MCK_FR16 }, },
  { 4882 /* cvtsi2ssq */, X86::CVTSI642SSrm_Int, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 4892 /* cvtss2sd */, X86::CVTSS2SDrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4892 /* cvtss2sd */, X86::CVTSS2SDrm_Int, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 4901 /* cvtss2si */, X86::CVTSS2SIrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32 }, },
  { 4901 /* cvtss2si */, X86::CVTSS2SI64rr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR64 }, },
  { 4901 /* cvtss2si */, X86::CVTSS2SIrm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 4901 /* cvtss2si */, X86::CVTSS2SI64rm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR64 }, },
  { 4910 /* cvtss2sil */, X86::CVTSS2SIrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32 }, },
  { 4910 /* cvtss2sil */, X86::CVTSS2SIrm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 4920 /* cvtss2siq */, X86::CVTSS2SI64rr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR64 }, },
  { 4920 /* cvtss2siq */, X86::CVTSS2SI64rm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR64 }, },
  { 4930 /* cvttpd2dq */, X86::CVTTPD2DQrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4930 /* cvttpd2dq */, X86::CVTTPD2DQrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 4940 /* cvttpd2pi */, X86::MMX_CVTTPD2PIrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_VR64 }, },
  { 4940 /* cvttpd2pi */, X86::MMX_CVTTPD2PIrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_VR64 }, },
  { 4950 /* cvttps2dq */, X86::CVTTPS2DQrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 4950 /* cvttps2dq */, X86::CVTTPS2DQrm, Convert__Reg1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 4960 /* cvttps2pi */, X86::MMX_CVTTPS2PIrr, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_VR64 }, },
  { 4960 /* cvttps2pi */, X86::MMX_CVTTPS2PIrm, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_VR64 }, },
  { 4970 /* cvttsd2si */, X86::CVTTSD2SIrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32 }, },
  { 4970 /* cvttsd2si */, X86::CVTTSD2SI64rr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR64 }, },
  { 4970 /* cvttsd2si */, X86::CVTTSD2SIrm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR32 }, },
  { 4970 /* cvttsd2si */, X86::CVTTSD2SI64rm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 4980 /* cvttsd2sil */, X86::CVTTSD2SIrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32 }, },
  { 4980 /* cvttsd2sil */, X86::CVTTSD2SIrm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR32 }, },
  { 4991 /* cvttsd2siq */, X86::CVTTSD2SI64rr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR64 }, },
  { 4991 /* cvttsd2siq */, X86::CVTTSD2SI64rm_Int, Convert__Reg1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_GR64 }, },
  { 5002 /* cvttss2si */, X86::CVTTSS2SIrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32 }, },
  { 5002 /* cvttss2si */, X86::CVTTSS2SI64rr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR64 }, },
  { 5002 /* cvttss2si */, X86::CVTTSS2SIrm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 5002 /* cvttss2si */, X86::CVTTSS2SI64rm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR64 }, },
  { 5012 /* cvttss2sil */, X86::CVTTSS2SIrr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR32 }, },
  { 5012 /* cvttss2sil */, X86::CVTTSS2SIrm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 5023 /* cvttss2siq */, X86::CVTTSS2SI64rr_Int, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_GR64 }, },
  { 5023 /* cvttss2siq */, X86::CVTTSS2SI64rm_Int, Convert__Reg1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR64 }, },
  { 5043 /* cwtd */, X86::CWD, Convert_NoOperands, AMFBS_None, {  }, },
  { 5048 /* cwtl */, X86::CWDE, Convert_NoOperands, AMFBS_None, {  }, },
  { 5053 /* daa */, X86::DAA, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 5057 /* das */, X86::DAS, Convert_NoOperands, AMFBS_Not64BitMode, {  }, },
  { 5061 /* data16 */, X86::DATA16_PREFIX, Convert_NoOperands, AMFBS_None, {  }, },
  { 5072 /* decb */, X86::DEC8r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR8 }, },
  { 5072 /* decb */, X86::DEC8r_NF, Convert__Reg1_0__Tie0_1_1, AMFBS_In64BitMode, { MCK_GR8 }, },
  { 5072 /* decb */, X86::DEC8r_EVEX, Convert__Reg1_0__Tie0_1_1, AMFBS_In64BitMode, { MCK_GR8 }, },
  { 5072 /* decb */, X86::DEC8m, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 5072 /* decb */, X86::DEC8m_NF, Convert__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8 }, },
  { 5072 /* decb */, X86::DEC8m_EVEX, Convert__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8 }, },
  { 5072 /* decb */, X86::DEC8r_ND, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_GR8 }, },
  { 5072 /* decb */, X86::DEC8r_NF_ND, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR8, MCK_GR8 }, },
  { 5072 /* decb */, X86::DEC8m_ND, Convert__Reg1_1__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8, MCK_GR8 }, },
  { 5072 /* decb */, X86::DEC8m_NF_ND, Convert__Reg1_1__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8, MCK_GR8 }, },
  { 5077 /* decl */, X86::DEC32r_alt, Convert__Reg1_0__Tie0_1_1, AMFBS_Not64BitMode, { MCK_GR32 }, },
  { 5077 /* decl */, X86::DEC32r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR32 }, },
  { 5077 /* decl */, X86::DEC32r_NF, Convert__Reg1_0__Tie0_1_1, AMFBS_In64BitMode, { MCK_GR32 }, },
  { 5077 /* decl */, X86::DEC32r_EVEX, Convert__Reg1_0__Tie0_1_1, AMFBS_In64BitMode, { MCK_GR32 }, },
  { 5077 /* decl */, X86::DEC32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5077 /* decl */, X86::DEC32m_NF, Convert__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32 }, },
  { 5077 /* decl */, X86::DEC32m_EVEX, Convert__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32 }, },
  { 5077 /* decl */, X86::DEC32r_ND, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 5077 /* decl */, X86::DEC32r_NF_ND, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 5077 /* decl */, X86::DEC32m_ND, Convert__Reg1_1__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 5077 /* decl */, X86::DEC32m_NF_ND, Convert__Reg1_1__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 5082 /* decq */, X86::DEC64r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR64 }, },
  { 5082 /* decq */, X86::DEC64r_NF, Convert__Reg1_0__Tie0_1_1, AMFBS_In64BitMode, { MCK_GR64 }, },
  { 5082 /* decq */, X86::DEC64r_EVEX, Convert__Reg1_0__Tie0_1_1, AMFBS_In64BitMode, { MCK_GR64 }, },
  { 5082 /* decq */, X86::DEC64m, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 5082 /* decq */, X86::DEC64m_NF, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 5082 /* decq */, X86::DEC64m_EVEX, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 5082 /* decq */, X86::DEC64r_ND, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 5082 /* decq */, X86::DEC64r_NF_ND, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR64, MCK_GR64 }, },
  { 5082 /* decq */, X86::DEC64m_ND, Convert__Reg1_1__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 5082 /* decq */, X86::DEC64m_NF_ND, Convert__Reg1_1__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64, MCK_GR64 }, },
  { 5087 /* decw */, X86::DEC16r_alt, Convert__Reg1_0__Tie0_1_1, AMFBS_Not64BitMode, { MCK_GR16 }, },
  { 5087 /* decw */, X86::DEC16r, Convert__Reg1_0__Tie0_1_1, AMFBS_None, { MCK_GR16 }, },
  { 5087 /* decw */, X86::DEC16r_NF, Convert__Reg1_0__Tie0_1_1, AMFBS_In64BitMode, { MCK_GR16 }, },
  { 5087 /* decw */, X86::DEC16r_EVEX, Convert__Reg1_0__Tie0_1_1, AMFBS_In64BitMode, { MCK_GR16 }, },
  { 5087 /* decw */, X86::DEC16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 5087 /* decw */, X86::DEC16m_NF, Convert__Mem165_0, AMFBS_In64BitMode, { MCK_Mem16 }, },
  { 5087 /* decw */, X86::DEC16m_EVEX, Convert__Mem165_0, AMFBS_In64BitMode, { MCK_Mem16 }, },
  { 5087 /* decw */, X86::DEC16r_ND, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 5087 /* decw */, X86::DEC16r_NF_ND, Convert__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 5087 /* decw */, X86::DEC16m_ND, Convert__Reg1_1__Mem165_0, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 5087 /* decw */, X86::DEC16m_NF_ND, Convert__Reg1_1__Mem165_0, AMFBS_In64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 5096 /* divb */, X86::DIV8r, Convert__Reg1_0, AMFBS_None, { MCK_GR8 }, },
  { 5096 /* divb */, X86::DIV8r_NF, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR8 }, },
  { 5096 /* divb */, X86::DIV8r_EVEX, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR8 }, },
  { 5096 /* divb */, X86::DIV8m, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 5096 /* divb */, X86::DIV8m_NF, Convert__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8 }, },
  { 5096 /* divb */, X86::DIV8m_EVEX, Convert__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8 }, },
  { 5096 /* divb */, X86::DIV8r, Convert__Reg1_0, AMFBS_None, { MCK_GR8, MCK_AL }, },
  { 5096 /* divb */, X86::DIV8m, Convert__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_AL }, },
  { 5101 /* divl */, X86::DIV32r, Convert__Reg1_0, AMFBS_None, { MCK_GR32 }, },
  { 5101 /* divl */, X86::DIV32r_NF, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR32 }, },
  { 5101 /* divl */, X86::DIV32r_EVEX, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR32 }, },
  { 5101 /* divl */, X86::DIV32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5101 /* divl */, X86::DIV32m_NF, Convert__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32 }, },
  { 5101 /* divl */, X86::DIV32m_EVEX, Convert__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32 }, },
  { 5101 /* divl */, X86::DIV32r, Convert__Reg1_0, AMFBS_None, { MCK_GR32, MCK_EAX }, },
  { 5101 /* divl */, X86::DIV32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_EAX }, },
  { 5106 /* divpd */, X86::DIVPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5106 /* divpd */, X86::DIVPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5112 /* divps */, X86::DIVPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5112 /* divps */, X86::DIVPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 5118 /* divq */, X86::DIV64r, Convert__Reg1_0, AMFBS_None, { MCK_GR64 }, },
  { 5118 /* divq */, X86::DIV64r_NF, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR64 }, },
  { 5118 /* divq */, X86::DIV64r_EVEX, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR64 }, },
  { 5118 /* divq */, X86::DIV64m, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 5118 /* divq */, X86::DIV64m_NF, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 5118 /* divq */, X86::DIV64m_EVEX, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 5118 /* divq */, X86::DIV64r, Convert__Reg1_0, AMFBS_None, { MCK_GR64, MCK_RAX }, },
  { 5118 /* divq */, X86::DIV64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_RAX }, },
  { 5123 /* divsd */, X86::DIVSDrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5123 /* divsd */, X86::DIVSDrm_Int, Convert__Reg1_1__Tie0_1_1__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_FR16 }, },
  { 5129 /* divss */, X86::DIVSSrr_Int, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5129 /* divss */, X86::DIVSSrm_Int, Convert__Reg1_1__Tie0_1_1__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_FR16 }, },
  { 5135 /* divw */, X86::DIV16r, Convert__Reg1_0, AMFBS_None, { MCK_GR16 }, },
  { 5135 /* divw */, X86::DIV16r_NF, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR16 }, },
  { 5135 /* divw */, X86::DIV16r_EVEX, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR16 }, },
  { 5135 /* divw */, X86::DIV16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 5135 /* divw */, X86::DIV16m_NF, Convert__Mem165_0, AMFBS_In64BitMode, { MCK_Mem16 }, },
  { 5135 /* divw */, X86::DIV16m_EVEX, Convert__Mem165_0, AMFBS_In64BitMode, { MCK_Mem16 }, },
  { 5135 /* divw */, X86::DIV16r, Convert__Reg1_0, AMFBS_None, { MCK_GR16, MCK_AX }, },
  { 5135 /* divw */, X86::DIV16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_AX }, },
  { 5140 /* dppd */, X86::DPPDrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 5140 /* dppd */, X86::DPPDrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 5145 /* dpps */, X86::DPPSrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 5145 /* dpps */, X86::DPPSrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 5150 /* ds */, X86::DS_PREFIX, Convert_NoOperands, AMFBS_None, {  }, },
  { 5153 /* emms */, X86::MMX_EMMS, Convert_NoOperands, AMFBS_None, {  }, },
  { 5158 /* encls */, X86::ENCLS, Convert_NoOperands, AMFBS_None, {  }, },
  { 5164 /* enclu */, X86::ENCLU, Convert_NoOperands, AMFBS_None, {  }, },
  { 5170 /* enclv */, X86::ENCLV, Convert_NoOperands, AMFBS_None, {  }, },
  { 5176 /* encodekey128 */, X86::ENCODEKEY128, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 5189 /* encodekey256 */, X86::ENCODEKEY256, Convert__Reg1_1__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 5202 /* endbr32 */, X86::ENDBR32, Convert_NoOperands, AMFBS_None, {  }, },
  { 5210 /* endbr64 */, X86::ENDBR64, Convert_NoOperands, AMFBS_None, {  }, },
  { 5218 /* enqcmd */, X86::ENQCMD16, Convert__Reg1_1__Mem512_GR165_0, AMFBS_Not64BitMode, { MCK_Mem512_GR16, MCK_GR16 }, },
  { 5218 /* enqcmd */, X86::ENQCMD32, Convert__Reg1_1__Mem512_GR325_0, AMFBS_None, { MCK_Mem512_GR32, MCK_GR32 }, },
  { 5218 /* enqcmd */, X86::ENQCMD32_EVEX, Convert__Reg1_1__Mem512_GR325_0, AMFBS_In64BitMode, { MCK_Mem512_GR32, MCK_GR32 }, },
  { 5218 /* enqcmd */, X86::ENQCMD64, Convert__Reg1_1__Mem512_GR645_0, AMFBS_None, { MCK_Mem512_GR64, MCK_GR64 }, },
  { 5218 /* enqcmd */, X86::ENQCMD64_EVEX, Convert__Reg1_1__Mem512_GR645_0, AMFBS_In64BitMode, { MCK_Mem512_GR64, MCK_GR64 }, },
  { 5225 /* enqcmds */, X86::ENQCMDS16, Convert__Reg1_1__Mem512_GR165_0, AMFBS_Not64BitMode, { MCK_Mem512_GR16, MCK_GR16 }, },
  { 5225 /* enqcmds */, X86::ENQCMDS32, Convert__Reg1_1__Mem512_GR325_0, AMFBS_None, { MCK_Mem512_GR32, MCK_GR32 }, },
  { 5225 /* enqcmds */, X86::ENQCMDS32_EVEX, Convert__Reg1_1__Mem512_GR325_0, AMFBS_In64BitMode, { MCK_Mem512_GR32, MCK_GR32 }, },
  { 5225 /* enqcmds */, X86::ENQCMDS64, Convert__Reg1_1__Mem512_GR645_0, AMFBS_None, { MCK_Mem512_GR64, MCK_GR64 }, },
  { 5225 /* enqcmds */, X86::ENQCMDS64_EVEX, Convert__Reg1_1__Mem512_GR645_0, AMFBS_In64BitMode, { MCK_Mem512_GR64, MCK_GR64 }, },
  { 5233 /* enter */, X86::ENTER, Convert__Imm1_0__Imm1_1, AMFBS_None, { MCK_Imm, MCK_Imm }, },
  { 5239 /* erets */, X86::ERETS, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 5245 /* eretu */, X86::ERETU, Convert_NoOperands, AMFBS_In64BitMode, {  }, },
  { 5251 /* es */, X86::ES_PREFIX, Convert_NoOperands, AMFBS_None, {  }, },
  { 5254 /* extractps */, X86::EXTRACTPSrri, Convert__GR32orGR641_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_GR32orGR64 }, },
  { 5254 /* extractps */, X86::EXTRACTPSmri, Convert__Mem325_2__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_Mem32 }, },
  { 5264 /* extrq */, X86::EXTRQ, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 5264 /* extrq */, X86::EXTRQI, Convert__Reg1_2__Tie0_3_3__ImmUnsignedi81_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_ImmUnsignedi8, MCK_FR16 }, },
  { 5270 /* f2xm1 */, X86::F2XM1, Convert_NoOperands, AMFBS_None, {  }, },
  { 5276 /* fabs */, X86::ABS_F, Convert_NoOperands, AMFBS_None, {  }, },
  { 5281 /* fadd */, X86::ADD_FPrST0, Convert__regST1, AMFBS_None, {  }, },
  { 5281 /* fadd */, X86::ADD_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 5281 /* fadd */, X86::ADD_FST0r, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 5281 /* fadd */, X86::ADD_FrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 5281 /* fadd */, X86::ADD_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 5286 /* faddl */, X86::ADD_F64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 5292 /* faddp */, X86::ADD_FPrST0, Convert__regST1, AMFBS_None, {  }, },
  { 5292 /* faddp */, X86::ADD_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 5292 /* faddp */, X86::ADD_FPrST0, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 5292 /* faddp */, X86::ADD_FPrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 5292 /* faddp */, X86::ADD_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 5298 /* fadds */, X86::ADD_F32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5304 /* fbld */, X86::FBLDm, Convert__Mem805_0, AMFBS_None, { MCK_Mem80 }, },
  { 5309 /* fbstp */, X86::FBSTPm, Convert__Mem805_0, AMFBS_None, { MCK_Mem80 }, },
  { 5315 /* fchs */, X86::CHS_F, Convert_NoOperands, AMFBS_None, {  }, },
  { 5320 /* fcmovb */, X86::CMOVB_F, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 5327 /* fcmovbe */, X86::CMOVBE_F, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 5335 /* fcmove */, X86::CMOVE_F, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 5342 /* fcmovnb */, X86::CMOVNB_F, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 5350 /* fcmovnbe */, X86::CMOVNBE_F, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 5359 /* fcmovne */, X86::CMOVNE_F, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 5367 /* fcmovnu */, X86::CMOVNP_F, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 5375 /* fcmovu */, X86::CMOVP_F, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 5382 /* fcom */, X86::COM_FST0r, Convert__regST1, AMFBS_None, {  }, },
  { 5382 /* fcom */, X86::COM_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 5387 /* fcomi */, X86::COM_FIr, Convert__regST1, AMFBS_None, {  }, },
  { 5387 /* fcomi */, X86::COM_FIr, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 5387 /* fcomi */, X86::COM_FIr, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 5387 /* fcomi */, X86::COM_FIr, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 5393 /* fcoml */, X86::FCOM64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 5399 /* fcomp */, X86::COMP_FST0r, Convert__regST1, AMFBS_None, {  }, },
  { 5399 /* fcomp */, X86::COMP_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 5405 /* fcompi */, X86::COM_FIPr, Convert__regST1, AMFBS_None, {  }, },
  { 5405 /* fcompi */, X86::COM_FIPr, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 5405 /* fcompi */, X86::COM_FIPr, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 5405 /* fcompi */, X86::COM_FIPr, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 5412 /* fcompl */, X86::FCOMP64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 5419 /* fcompp */, X86::FCOMPP, Convert_NoOperands, AMFBS_None, {  }, },
  { 5426 /* fcomps */, X86::FCOMP32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5433 /* fcoms */, X86::FCOM32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5439 /* fcos */, X86::FCOS, Convert_NoOperands, AMFBS_None, {  }, },
  { 5444 /* fdecstp */, X86::FDECSTP, Convert_NoOperands, AMFBS_None, {  }, },
  { 5452 /* fdiv */, X86::DIV_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 5452 /* fdiv */, X86::DIV_FST0r, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 5452 /* fdiv */, X86::DIVR_FrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 5452 /* fdiv */, X86::DIV_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 5457 /* fdivl */, X86::DIV_F64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 5463 /* fdivp */, X86::DIVR_FPrST0, Convert__regST1, AMFBS_None, {  }, },
  { 5463 /* fdivp */, X86::DIVR_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 5463 /* fdivp */, X86::DIVR_FPrST0, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 5463 /* fdivp */, X86::DIVR_FPrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 5463 /* fdivp */, X86::DIVR_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 5469 /* fdivr */, X86::DIVR_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 5469 /* fdivr */, X86::DIVR_FST0r, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 5469 /* fdivr */, X86::DIV_FrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 5469 /* fdivr */, X86::DIVR_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 5475 /* fdivrl */, X86::DIVR_F64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 5482 /* fdivrp */, X86::DIV_FPrST0, Convert__regST1, AMFBS_None, {  }, },
  { 5482 /* fdivrp */, X86::DIV_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 5482 /* fdivrp */, X86::DIV_FPrST0, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 5482 /* fdivrp */, X86::DIV_FPrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 5482 /* fdivrp */, X86::DIV_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 5489 /* fdivrs */, X86::DIVR_F32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5496 /* fdivs */, X86::DIV_F32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5502 /* femms */, X86::FEMMS, Convert_NoOperands, AMFBS_None, {  }, },
  { 5508 /* ffree */, X86::FFREE, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 5514 /* ffreep */, X86::FFREEP, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 5527 /* fiaddl */, X86::ADD_FI32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5534 /* fiadds */, X86::ADD_FI16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 5547 /* ficoml */, X86::FICOM32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5561 /* ficompl */, X86::FICOMP32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5569 /* ficomps */, X86::FICOMP16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 5577 /* ficoms */, X86::FICOM16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 5590 /* fidivl */, X86::DIV_FI32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5604 /* fidivrl */, X86::DIVR_FI32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5612 /* fidivrs */, X86::DIVR_FI16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 5620 /* fidivs */, X86::DIV_FI16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 5632 /* fildl */, X86::ILD_F32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5638 /* fildll */, X86::ILD_F64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 5645 /* filds */, X86::ILD_F16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 5657 /* fimull */, X86::MUL_FI32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5664 /* fimuls */, X86::MUL_FI16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 5671 /* fincstp */, X86::FINCSTP, Convert_NoOperands, AMFBS_None, {  }, },
  { 5684 /* fistl */, X86::IST_F32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5696 /* fistpl */, X86::IST_FP32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5703 /* fistpll */, X86::IST_FP64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 5711 /* fistps */, X86::IST_FP16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 5718 /* fists */, X86::IST_F16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 5731 /* fisttpl */, X86::ISTT_FP32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5739 /* fisttpll */, X86::ISTT_FP64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 5748 /* fisttps */, X86::ISTT_FP16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 5762 /* fisubl */, X86::SUB_FI32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5776 /* fisubrl */, X86::SUBR_FI32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5784 /* fisubrs */, X86::SUBR_FI16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 5792 /* fisubs */, X86::SUB_FI16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 5799 /* fld */, X86::LD_Frr, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 5803 /* fld1 */, X86::LD_F1, Convert_NoOperands, AMFBS_None, {  }, },
  { 5808 /* fldcw */, X86::FLDCW16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 5814 /* fldenv */, X86::FLDENVm, Convert__Mem5_0, AMFBS_None, { MCK_Mem }, },
  { 5821 /* fldl */, X86::LD_F64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 5826 /* fldl2e */, X86::FLDL2E, Convert_NoOperands, AMFBS_None, {  }, },
  { 5833 /* fldl2t */, X86::FLDL2T, Convert_NoOperands, AMFBS_None, {  }, },
  { 5840 /* fldlg2 */, X86::FLDLG2, Convert_NoOperands, AMFBS_None, {  }, },
  { 5847 /* fldln2 */, X86::FLDLN2, Convert_NoOperands, AMFBS_None, {  }, },
  { 5854 /* fldpi */, X86::FLDPI, Convert_NoOperands, AMFBS_None, {  }, },
  { 5860 /* flds */, X86::LD_F32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5865 /* fldt */, X86::LD_F80m, Convert__Mem805_0, AMFBS_None, { MCK_Mem80 }, },
  { 5870 /* fldz */, X86::LD_F0, Convert_NoOperands, AMFBS_None, {  }, },
  { 5875 /* fmul */, X86::MUL_FPrST0, Convert__regST1, AMFBS_None, {  }, },
  { 5875 /* fmul */, X86::MUL_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 5875 /* fmul */, X86::MUL_FST0r, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 5875 /* fmul */, X86::MUL_FrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 5875 /* fmul */, X86::MUL_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 5880 /* fmull */, X86::MUL_F64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 5886 /* fmulp */, X86::MUL_FPrST0, Convert__regST1, AMFBS_None, {  }, },
  { 5886 /* fmulp */, X86::MUL_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 5886 /* fmulp */, X86::MUL_FPrST0, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 5886 /* fmulp */, X86::MUL_FPrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 5886 /* fmulp */, X86::MUL_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 5892 /* fmuls */, X86::MUL_F32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 5898 /* fnclex */, X86::FNCLEX, Convert_NoOperands, AMFBS_None, {  }, },
  { 5905 /* fninit */, X86::FNINIT, Convert_NoOperands, AMFBS_None, {  }, },
  { 5912 /* fnop */, X86::FNOP, Convert_NoOperands, AMFBS_None, {  }, },
  { 5917 /* fnsave */, X86::FSAVEm, Convert__Mem5_0, AMFBS_None, { MCK_Mem }, },
  { 5924 /* fnstcw */, X86::FNSTCW16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 5931 /* fnstenv */, X86::FSTENVm, Convert__Mem5_0, AMFBS_None, { MCK_Mem }, },
  { 5939 /* fnstsw */, X86::FNSTSW16r, Convert_NoOperands, AMFBS_None, {  }, },
  { 5939 /* fnstsw */, X86::FNSTSW16r, Convert_NoOperands, AMFBS_None, { MCK_AX }, },
  { 5939 /* fnstsw */, X86::FNSTSWm, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 5946 /* fpatan */, X86::FPATAN, Convert_NoOperands, AMFBS_None, {  }, },
  { 5953 /* fprem */, X86::FPREM, Convert_NoOperands, AMFBS_None, {  }, },
  { 5959 /* fprem1 */, X86::FPREM1, Convert_NoOperands, AMFBS_None, {  }, },
  { 5966 /* fptan */, X86::FPTAN, Convert_NoOperands, AMFBS_None, {  }, },
  { 5972 /* frndint */, X86::FRNDINT, Convert_NoOperands, AMFBS_None, {  }, },
  { 5980 /* frstor */, X86::FRSTORm, Convert__Mem5_0, AMFBS_None, { MCK_Mem }, },
  { 5987 /* fs */, X86::FS_PREFIX, Convert_NoOperands, AMFBS_None, {  }, },
  { 5990 /* fscale */, X86::FSCALE, Convert_NoOperands, AMFBS_None, {  }, },
  { 5997 /* fsin */, X86::FSIN, Convert_NoOperands, AMFBS_None, {  }, },
  { 6002 /* fsincos */, X86::FSINCOS, Convert_NoOperands, AMFBS_None, {  }, },
  { 6010 /* fsqrt */, X86::SQRT_F, Convert_NoOperands, AMFBS_None, {  }, },
  { 6016 /* fst */, X86::ST_Frr, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 6020 /* fstl */, X86::ST_F64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 6025 /* fstp */, X86::ST_FPrr, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 6030 /* fstpl */, X86::ST_FP64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 6036 /* fstps */, X86::ST_FP32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 6042 /* fstpt */, X86::ST_FP80m, Convert__Mem805_0, AMFBS_None, { MCK_Mem80 }, },
  { 6048 /* fsts */, X86::ST_F32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 6053 /* fsub */, X86::SUB_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 6053 /* fsub */, X86::SUB_FST0r, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 6053 /* fsub */, X86::SUBR_FrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 6053 /* fsub */, X86::SUB_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 6058 /* fsubl */, X86::SUB_F64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 6064 /* fsubp */, X86::SUBR_FPrST0, Convert__regST1, AMFBS_None, {  }, },
  { 6064 /* fsubp */, X86::SUBR_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 6064 /* fsubp */, X86::SUBR_FPrST0, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 6064 /* fsubp */, X86::SUBR_FPrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 6064 /* fsubp */, X86::SUBR_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 6070 /* fsubr */, X86::SUBR_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 6070 /* fsubr */, X86::SUBR_FST0r, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 6070 /* fsubr */, X86::SUB_FrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 6070 /* fsubr */, X86::SUBR_FST0r, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 6076 /* fsubrl */, X86::SUBR_F64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64 }, },
  { 6083 /* fsubrp */, X86::SUB_FPrST0, Convert__regST1, AMFBS_None, {  }, },
  { 6083 /* fsubrp */, X86::SUB_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 6083 /* fsubrp */, X86::SUB_FPrST0, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 6083 /* fsubrp */, X86::SUB_FPrST0, Convert__Reg1_1, AMFBS_None, { MCK_ST0, MCK_RST }, },
  { 6083 /* fsubrp */, X86::SUB_FPrST0, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 6090 /* fsubrs */, X86::SUBR_F32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 6097 /* fsubs */, X86::SUB_F32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 6103 /* ftst */, X86::TST_F, Convert_NoOperands, AMFBS_None, {  }, },
  { 6108 /* fucom */, X86::UCOM_Fr, Convert__regST1, AMFBS_None, {  }, },
  { 6108 /* fucom */, X86::UCOM_Fr, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 6114 /* fucomi */, X86::UCOM_FIr, Convert__regST1, AMFBS_None, {  }, },
  { 6114 /* fucomi */, X86::UCOM_FIr, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 6114 /* fucomi */, X86::UCOM_FIr, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 6114 /* fucomi */, X86::UCOM_FIr, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 6121 /* fucomp */, X86::UCOM_FPr, Convert__regST1, AMFBS_None, {  }, },
  { 6121 /* fucomp */, X86::UCOM_FPr, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 6128 /* fucompi */, X86::UCOM_FIPr, Convert__regST1, AMFBS_None, {  }, },
  { 6128 /* fucompi */, X86::UCOM_FIPr, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 6128 /* fucompi */, X86::UCOM_FIPr, Convert__regST0, AMFBS_None, { MCK_ST0, MCK_ST0 }, },
  { 6128 /* fucompi */, X86::UCOM_FIPr, Convert__Reg1_0, AMFBS_None, { MCK_RST, MCK_ST0 }, },
  { 6136 /* fucompp */, X86::UCOM_FPPr, Convert_NoOperands, AMFBS_None, {  }, },
  { 6144 /* fxam */, X86::XAM_F, Convert_NoOperands, AMFBS_None, {  }, },
  { 6149 /* fxch */, X86::XCH_F, Convert__regST1, AMFBS_None, {  }, },
  { 6149 /* fxch */, X86::XCH_F, Convert__Reg1_0, AMFBS_None, { MCK_RST }, },
  { 6154 /* fxrstor */, X86::FXRSTOR, Convert__Mem5_0, AMFBS_None, { MCK_Mem }, },
  { 6162 /* fxrstor64 */, X86::FXRSTOR64, Convert__Mem5_0, AMFBS_In64BitMode, { MCK_Mem }, },
  { 6172 /* fxsave */, X86::FXSAVE, Convert__Mem5_0, AMFBS_None, { MCK_Mem }, },
  { 6179 /* fxsave64 */, X86::FXSAVE64, Convert__Mem5_0, AMFBS_In64BitMode, { MCK_Mem }, },
  { 6188 /* fxtract */, X86::FXTRACT, Convert_NoOperands, AMFBS_None, {  }, },
  { 6196 /* fyl2x */, X86::FYL2X, Convert_NoOperands, AMFBS_None, {  }, },
  { 6202 /* fyl2xp1 */, X86::FYL2XP1, Convert_NoOperands, AMFBS_None, {  }, },
  { 6210 /* getsec */, X86::GETSEC, Convert_NoOperands, AMFBS_None, {  }, },
  { 6217 /* gf2p8affineinvqb */, X86::GF2P8AFFINEINVQBrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 6217 /* gf2p8affineinvqb */, X86::GF2P8AFFINEINVQBrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 6234 /* gf2p8affineqb */, X86::GF2P8AFFINEQBrri, Convert__Reg1_2__Tie0_1_1__Reg1_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_FR16, MCK_FR16 }, },
  { 6234 /* gf2p8affineqb */, X86::GF2P8AFFINEQBrmi, Convert__Reg1_2__Tie0_1_1__Mem1285_1__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR16 }, },
  { 6248 /* gf2p8mulb */, X86::GF2P8MULBrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6248 /* gf2p8mulb */, X86::GF2P8MULBrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6258 /* gs */, X86::GS_PREFIX, Convert_NoOperands, AMFBS_None, {  }, },
  { 6261 /* haddpd */, X86::HADDPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6261 /* haddpd */, X86::HADDPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6268 /* haddps */, X86::HADDPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6268 /* haddps */, X86::HADDPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6275 /* hlt */, X86::HLT, Convert_NoOperands, AMFBS_None, {  }, },
  { 6279 /* hreset */, X86::HRESET, Convert__ImmUnsignedi81_0, AMFBS_None, { MCK_ImmUnsignedi8 }, },
  { 6286 /* hsubpd */, X86::HSUBPDrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6286 /* hsubpd */, X86::HSUBPDrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6293 /* hsubps */, X86::HSUBPSrr, Convert__Reg1_1__Tie0_1_1__Reg1_0, AMFBS_None, { MCK_FR16, MCK_FR16 }, },
  { 6293 /* hsubps */, X86::HSUBPSrm, Convert__Reg1_1__Tie0_1_1__Mem1285_0, AMFBS_None, { MCK_Mem128, MCK_FR16 }, },
  { 6305 /* idivb */, X86::IDIV8r, Convert__Reg1_0, AMFBS_None, { MCK_GR8 }, },
  { 6305 /* idivb */, X86::IDIV8r_NF, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR8 }, },
  { 6305 /* idivb */, X86::IDIV8r_EVEX, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR8 }, },
  { 6305 /* idivb */, X86::IDIV8m, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 6305 /* idivb */, X86::IDIV8m_NF, Convert__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8 }, },
  { 6305 /* idivb */, X86::IDIV8m_EVEX, Convert__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8 }, },
  { 6305 /* idivb */, X86::IDIV8r, Convert__Reg1_0, AMFBS_None, { MCK_GR8, MCK_AL }, },
  { 6305 /* idivb */, X86::IDIV8m, Convert__Mem85_0, AMFBS_None, { MCK_Mem8, MCK_AL }, },
  { 6311 /* idivl */, X86::IDIV32r, Convert__Reg1_0, AMFBS_None, { MCK_GR32 }, },
  { 6311 /* idivl */, X86::IDIV32r_NF, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR32 }, },
  { 6311 /* idivl */, X86::IDIV32r_EVEX, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR32 }, },
  { 6311 /* idivl */, X86::IDIV32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 6311 /* idivl */, X86::IDIV32m_NF, Convert__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32 }, },
  { 6311 /* idivl */, X86::IDIV32m_EVEX, Convert__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32 }, },
  { 6311 /* idivl */, X86::IDIV32r, Convert__Reg1_0, AMFBS_None, { MCK_GR32, MCK_EAX }, },
  { 6311 /* idivl */, X86::IDIV32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_EAX }, },
  { 6317 /* idivq */, X86::IDIV64r, Convert__Reg1_0, AMFBS_None, { MCK_GR64 }, },
  { 6317 /* idivq */, X86::IDIV64r_NF, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR64 }, },
  { 6317 /* idivq */, X86::IDIV64r_EVEX, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR64 }, },
  { 6317 /* idivq */, X86::IDIV64m, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 6317 /* idivq */, X86::IDIV64m_NF, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 6317 /* idivq */, X86::IDIV64m_EVEX, Convert__Mem645_0, AMFBS_In64BitMode, { MCK_Mem64 }, },
  { 6317 /* idivq */, X86::IDIV64r, Convert__Reg1_0, AMFBS_None, { MCK_GR64, MCK_RAX }, },
  { 6317 /* idivq */, X86::IDIV64m, Convert__Mem645_0, AMFBS_None, { MCK_Mem64, MCK_RAX }, },
  { 6323 /* idivw */, X86::IDIV16r, Convert__Reg1_0, AMFBS_None, { MCK_GR16 }, },
  { 6323 /* idivw */, X86::IDIV16r_NF, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR16 }, },
  { 6323 /* idivw */, X86::IDIV16r_EVEX, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR16 }, },
  { 6323 /* idivw */, X86::IDIV16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16 }, },
  { 6323 /* idivw */, X86::IDIV16m_NF, Convert__Mem165_0, AMFBS_In64BitMode, { MCK_Mem16 }, },
  { 6323 /* idivw */, X86::IDIV16m_EVEX, Convert__Mem165_0, AMFBS_In64BitMode, { MCK_Mem16 }, },
  { 6323 /* idivw */, X86::IDIV16r, Convert__Reg1_0, AMFBS_None, { MCK_GR16, MCK_AX }, },
  { 6323 /* idivw */, X86::IDIV16m, Convert__Mem165_0, AMFBS_None, { MCK_Mem16, MCK_AX }, },
  { 6334 /* imulb */, X86::IMUL8r, Convert__Reg1_0, AMFBS_None, { MCK_GR8 }, },
  { 6334 /* imulb */, X86::IMUL8r_NF, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR8 }, },
  { 6334 /* imulb */, X86::IMUL8r_EVEX, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR8 }, },
  { 6334 /* imulb */, X86::IMUL8m, Convert__Mem85_0, AMFBS_None, { MCK_Mem8 }, },
  { 6334 /* imulb */, X86::IMUL8m_NF, Convert__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8 }, },
  { 6334 /* imulb */, X86::IMUL8m_EVEX, Convert__Mem85_0, AMFBS_In64BitMode, { MCK_Mem8 }, },
  { 6340 /* imull */, X86::IMUL32r, Convert__Reg1_0, AMFBS_None, { MCK_GR32 }, },
  { 6340 /* imull */, X86::IMUL32r_NF, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR32 }, },
  { 6340 /* imull */, X86::IMUL32r_EVEX, Convert__Reg1_0, AMFBS_In64BitMode, { MCK_GR32 }, },
  { 6340 /* imull */, X86::IMUL32m, Convert__Mem325_0, AMFBS_None, { MCK_Mem32 }, },
  { 6340 /* imull */, X86::IMUL32m_NF, Convert__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32 }, },
  { 6340 /* imull */, X86::IMUL32m_EVEX, Convert__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32 }, },
  { 6340 /* imull */, X86::IMUL32rr, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 6340 /* imull */, X86::IMUL32rr_NF, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 6340 /* imull */, X86::IMUL32rr_EVEX, Convert__Reg1_1__Tie0_2_2__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32 }, },
  { 6340 /* imull */, X86::IMUL32rri8, Convert__Reg1_1__Reg1_1__ImmSExti32i81_0, AMFBS_None, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 6340 /* imull */, X86::IMUL32rri, Convert__Reg1_1__Reg1_1__Imm1_0, AMFBS_None, { MCK_Imm, MCK_GR32 }, },
  { 6340 /* imull */, X86::IMUL32rm, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_None, { MCK_Mem32, MCK_GR32 }, },
  { 6340 /* imull */, X86::IMUL32rm_NF, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 6340 /* imull */, X86::IMUL32rm_EVEX, Convert__Reg1_1__Tie0_2_2__Mem325_0, AMFBS_In64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 6340 /* imull */, X86::IMUL32rr_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 6340 /* imull */, X86::IMUL32rr_NF_ND, Convert__Reg1_2__Reg1_1__Reg1_0, AMFBS_In64BitMode, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 6340 /* imull */, X86::IMUL3