/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, dtv, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_dtv_dvbt_reference_signals = R"doc(Reference signals generator.

ETSI EN 300 744 Clause 4.5 
Data input format: 
complex(real(float), imag(float)). 
Data output format: 
complex(real(float), imag(float)).

Constructor Specific Documentation:

Create Reference signals generator.

Args:
    itemsize : size of an in/out item.
    ninput : input stream length.
    noutput : output stream length.
    constellation : constellation used.
    hierarchy : hierarchy used.
    code_rate_HP : high priority stream code rate.
    code_rate_LP : low priority stream code rate.
    guard_interval : guard interval used.
    transmission_mode : transmission mode used.
    include_cell_id : include or not Cell ID.
    cell_id : value of the Cell ID.)doc";


static const char* __doc_gr_dtv_dvbt_reference_signals_dvbt_reference_signals =
    R"doc()doc";


static const char* __doc_gr_dtv_dvbt_reference_signals_make = R"doc(Reference signals generator.

ETSI EN 300 744 Clause 4.5 
Data input format: 
complex(real(float), imag(float)). 
Data output format: 
complex(real(float), imag(float)).

Constructor Specific Documentation:

Create Reference signals generator.

Args:
    itemsize : size of an in/out item.
    ninput : input stream length.
    noutput : output stream length.
    constellation : constellation used.
    hierarchy : hierarchy used.
    code_rate_HP : high priority stream code rate.
    code_rate_LP : low priority stream code rate.
    guard_interval : guard interval used.
    transmission_mode : transmission mode used.
    include_cell_id : include or not Cell ID.
    cell_id : value of the Cell ID.)doc";
