/* mime-content-disposition.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from mime-content-disposition.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gmime/gmime.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_MIME_CONTENT_DISPOSITION_0_PROPERTY,
	GEARY_MIME_CONTENT_DISPOSITION_DISPOSITION_TYPE_PROPERTY,
	GEARY_MIME_CONTENT_DISPOSITION_IS_UNKNOWN_DISPOSITION_TYPE_PROPERTY,
	GEARY_MIME_CONTENT_DISPOSITION_ORIGINAL_DISPOSITION_TYPE_STRING_PROPERTY,
	GEARY_MIME_CONTENT_DISPOSITION_PARAMS_PROPERTY,
	GEARY_MIME_CONTENT_DISPOSITION_NUM_PROPERTIES
};
static GParamSpec* geary_mime_content_disposition_properties[GEARY_MIME_CONTENT_DISPOSITION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GearyMimeContentDispositionPrivate {
	GearyMimeDispositionType _disposition_type;
	gboolean _is_unknown_disposition_type;
	gchar* _original_disposition_type_string;
	GearyMimeContentParameters* _params;
};

static gint GearyMimeContentDisposition_private_offset;
static gpointer geary_mime_content_disposition_parent_class = NULL;

static void geary_mime_content_disposition_set_disposition_type (GearyMimeContentDisposition* self,
                                                          GearyMimeDispositionType value);
static void geary_mime_content_disposition_set_is_unknown_disposition_type (GearyMimeContentDisposition* self,
                                                                     gboolean value);
static void geary_mime_content_disposition_set_original_disposition_type_string (GearyMimeContentDisposition* self,
                                                                          const gchar* value);
static void geary_mime_content_disposition_set_params (GearyMimeContentDisposition* self,
                                                GearyMimeContentParameters* value);
VALA_EXTERN GearyMimeContentDisposition* geary_mime_content_disposition_new_from_gmime (GMimeContentDisposition* content_disposition);
VALA_EXTERN GearyMimeContentDisposition* geary_mime_content_disposition_construct_from_gmime (GType object_type,
                                                                                  GMimeContentDisposition* content_disposition);
VALA_EXTERN GearyMimeContentParameters* geary_mime_content_parameters_new_from_gmime (GMimeParamList* gmime);
VALA_EXTERN GearyMimeContentParameters* geary_mime_content_parameters_construct_from_gmime (GType object_type,
                                                                                GMimeParamList* gmime);
static void geary_mime_content_disposition_finalize (GObject * obj);
static GType geary_mime_content_disposition_get_type_once (void);
static void _vala_geary_mime_content_disposition_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_geary_mime_content_disposition_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);

static inline gpointer
geary_mime_content_disposition_get_instance_private (GearyMimeContentDisposition* self)
{
	return G_STRUCT_MEMBER_P (self, GearyMimeContentDisposition_private_offset);
}

GearyMimeDispositionType
geary_mime_content_disposition_get_disposition_type (GearyMimeContentDisposition* self)
{
	GearyMimeDispositionType result;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_DISPOSITION (self), 0);
	result = self->priv->_disposition_type;
	return result;
}

static void
geary_mime_content_disposition_set_disposition_type (GearyMimeContentDisposition* self,
                                                     GearyMimeDispositionType value)
{
	GearyMimeDispositionType old_value;
	g_return_if_fail (GEARY_MIME_IS_CONTENT_DISPOSITION (self));
	old_value = geary_mime_content_disposition_get_disposition_type (self);
	if (old_value != value) {
		self->priv->_disposition_type = value;
		g_object_notify_by_pspec ((GObject *) self, geary_mime_content_disposition_properties[GEARY_MIME_CONTENT_DISPOSITION_DISPOSITION_TYPE_PROPERTY]);
	}
}

gboolean
geary_mime_content_disposition_get_is_unknown_disposition_type (GearyMimeContentDisposition* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_DISPOSITION (self), FALSE);
	result = self->priv->_is_unknown_disposition_type;
	return result;
}

static void
geary_mime_content_disposition_set_is_unknown_disposition_type (GearyMimeContentDisposition* self,
                                                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (GEARY_MIME_IS_CONTENT_DISPOSITION (self));
	old_value = geary_mime_content_disposition_get_is_unknown_disposition_type (self);
	if (old_value != value) {
		self->priv->_is_unknown_disposition_type = value;
		g_object_notify_by_pspec ((GObject *) self, geary_mime_content_disposition_properties[GEARY_MIME_CONTENT_DISPOSITION_IS_UNKNOWN_DISPOSITION_TYPE_PROPERTY]);
	}
}

const gchar*
geary_mime_content_disposition_get_original_disposition_type_string (GearyMimeContentDisposition* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_DISPOSITION (self), NULL);
	_tmp0_ = self->priv->_original_disposition_type_string;
	result = _tmp0_;
	return result;
}

static void
geary_mime_content_disposition_set_original_disposition_type_string (GearyMimeContentDisposition* self,
                                                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_MIME_IS_CONTENT_DISPOSITION (self));
	old_value = geary_mime_content_disposition_get_original_disposition_type_string (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_original_disposition_type_string);
		self->priv->_original_disposition_type_string = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_mime_content_disposition_properties[GEARY_MIME_CONTENT_DISPOSITION_ORIGINAL_DISPOSITION_TYPE_STRING_PROPERTY]);
	}
}

GearyMimeContentParameters*
geary_mime_content_disposition_get_params (GearyMimeContentDisposition* self)
{
	GearyMimeContentParameters* result;
	GearyMimeContentParameters* _tmp0_;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_DISPOSITION (self), NULL);
	_tmp0_ = self->priv->_params;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_mime_content_disposition_set_params (GearyMimeContentDisposition* self,
                                           GearyMimeContentParameters* value)
{
	GearyMimeContentParameters* old_value;
	g_return_if_fail (GEARY_MIME_IS_CONTENT_DISPOSITION (self));
	old_value = geary_mime_content_disposition_get_params (self);
	if (old_value != value) {
		GearyMimeContentParameters* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_params);
		self->priv->_params = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_mime_content_disposition_properties[GEARY_MIME_CONTENT_DISPOSITION_PARAMS_PROPERTY]);
	}
}

/**
     * Create a Content-Disposition representation
     */
GearyMimeContentDisposition*
geary_mime_content_disposition_construct (GType object_type,
                                          const gchar* disposition,
                                          GearyMimeContentParameters* params)
{
	GearyMimeContentDisposition * self = NULL;
	gboolean is_unknown = FALSE;
	gboolean _tmp0_ = FALSE;
	GearyMimeDispositionType _tmp1_;
	GearyMimeContentParameters* _tmp2_ = NULL;
	GearyMimeContentParameters* _tmp3_;
	g_return_val_if_fail ((params == NULL) || GEARY_MIME_IS_CONTENT_PARAMETERS (params), NULL);
	self = (GearyMimeContentDisposition*) geary_base_object_construct (object_type);
	_tmp1_ = geary_mime_disposition_type_deserialize (disposition, &_tmp0_);
	is_unknown = _tmp0_;
	geary_mime_content_disposition_set_disposition_type (self, _tmp1_);
	geary_mime_content_disposition_set_is_unknown_disposition_type (self, is_unknown);
	geary_mime_content_disposition_set_original_disposition_type_string (self, disposition);
	_tmp3_ = _g_object_ref0 (params);
	_tmp2_ = _tmp3_;
	if (_tmp2_ == NULL) {
		GearyMimeContentParameters* _tmp4_;
		_tmp4_ = geary_mime_content_parameters_new (NULL);
		_g_object_unref0 (_tmp2_);
		_tmp2_ = _tmp4_;
	}
	geary_mime_content_disposition_set_params (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	return self;
}

GearyMimeContentDisposition*
geary_mime_content_disposition_new (const gchar* disposition,
                                    GearyMimeContentParameters* params)
{
	return geary_mime_content_disposition_construct (GEARY_MIME_TYPE_CONTENT_DISPOSITION, disposition, params);
}

/**
     * Create a simplified Content-Disposition representation.
     */
GearyMimeContentDisposition*
geary_mime_content_disposition_construct_simple (GType object_type,
                                                 GearyMimeDispositionType disposition_type)
{
	GearyMimeContentDisposition * self = NULL;
	GearyMimeContentParameters* _tmp0_;
	GearyMimeContentParameters* _tmp1_;
	self = (GearyMimeContentDisposition*) geary_base_object_construct (object_type);
	geary_mime_content_disposition_set_disposition_type (self, disposition_type);
	geary_mime_content_disposition_set_is_unknown_disposition_type (self, FALSE);
	geary_mime_content_disposition_set_original_disposition_type_string (self, NULL);
	_tmp0_ = geary_mime_content_parameters_new (NULL);
	_tmp1_ = _tmp0_;
	geary_mime_content_disposition_set_params (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	return self;
}

GearyMimeContentDisposition*
geary_mime_content_disposition_new_simple (GearyMimeDispositionType disposition_type)
{
	return geary_mime_content_disposition_construct_simple (GEARY_MIME_TYPE_CONTENT_DISPOSITION, disposition_type);
}

GearyMimeContentDisposition*
geary_mime_content_disposition_construct_from_gmime (GType object_type,
                                                     GMimeContentDisposition* content_disposition)
{
	GearyMimeContentDisposition * self = NULL;
	gboolean is_unknown = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GearyMimeDispositionType _tmp2_;
	const gchar* _tmp3_;
	GMimeParamList* _tmp4_;
	GearyMimeContentParameters* _tmp5_;
	GearyMimeContentParameters* _tmp6_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (content_disposition, g_mime_content_disposition_get_type ()), NULL);
	self = (GearyMimeContentDisposition*) geary_base_object_construct (object_type);
	_tmp0_ = g_mime_content_disposition_get_disposition (content_disposition);
	_tmp2_ = geary_mime_disposition_type_deserialize (_tmp0_, &_tmp1_);
	is_unknown = _tmp1_;
	geary_mime_content_disposition_set_disposition_type (self, _tmp2_);
	geary_mime_content_disposition_set_is_unknown_disposition_type (self, is_unknown);
	_tmp3_ = g_mime_content_disposition_get_disposition (content_disposition);
	geary_mime_content_disposition_set_original_disposition_type_string (self, _tmp3_);
	_tmp4_ = g_mime_content_disposition_get_parameters (content_disposition);
	_tmp5_ = geary_mime_content_parameters_new_from_gmime (_tmp4_);
	_tmp6_ = _tmp5_;
	geary_mime_content_disposition_set_params (self, _tmp6_);
	_g_object_unref0 (_tmp6_);
	return self;
}

GearyMimeContentDisposition*
geary_mime_content_disposition_new_from_gmime (GMimeContentDisposition* content_disposition)
{
	return geary_mime_content_disposition_construct_from_gmime (GEARY_MIME_TYPE_CONTENT_DISPOSITION, content_disposition);
}

static void
geary_mime_content_disposition_class_init (GearyMimeContentDispositionClass * klass,
                                           gpointer klass_data)
{
	geary_mime_content_disposition_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyMimeContentDisposition_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_mime_content_disposition_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_mime_content_disposition_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_mime_content_disposition_finalize;
	/**
	     * The {@link DispositionType}, which is {@link DispositionType.UNSPECIFIED} if not specified.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MIME_CONTENT_DISPOSITION_DISPOSITION_TYPE_PROPERTY, geary_mime_content_disposition_properties[GEARY_MIME_CONTENT_DISPOSITION_DISPOSITION_TYPE_PROPERTY] = g_param_spec_enum ("disposition-type", "disposition-type", "disposition-type", GEARY_MIME_TYPE_DISPOSITION_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * True if the original DispositionType was unknown.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MIME_CONTENT_DISPOSITION_IS_UNKNOWN_DISPOSITION_TYPE_PROPERTY, geary_mime_content_disposition_properties[GEARY_MIME_CONTENT_DISPOSITION_IS_UNKNOWN_DISPOSITION_TYPE_PROPERTY] = g_param_spec_boolean ("is-unknown-disposition-type", "is-unknown-disposition-type", "is-unknown-disposition-type", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The original disposition type string.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MIME_CONTENT_DISPOSITION_ORIGINAL_DISPOSITION_TYPE_STRING_PROPERTY, geary_mime_content_disposition_properties[GEARY_MIME_CONTENT_DISPOSITION_ORIGINAL_DISPOSITION_TYPE_STRING_PROPERTY] = g_param_spec_string ("original-disposition-type-string", "original-disposition-type-string", "original-disposition-type-string", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Various parameters associated with the content's disposition.
	     *
	     * This is never null.  Rather, an empty ContentParameters is held if the Content-Type has
	     * no parameters.
	     *
	     * @see FILENAME
	     * @see CREATION_DATE
	     * @see MODIFICATION_DATE
	     * @see READ_DATE
	     * @see SIZE
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MIME_CONTENT_DISPOSITION_PARAMS_PROPERTY, geary_mime_content_disposition_properties[GEARY_MIME_CONTENT_DISPOSITION_PARAMS_PROPERTY] = g_param_spec_object ("params", "params", "params", GEARY_MIME_TYPE_CONTENT_PARAMETERS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_mime_content_disposition_instance_init (GearyMimeContentDisposition * self,
                                              gpointer klass)
{
	self->priv = geary_mime_content_disposition_get_instance_private (self);
}

static void
geary_mime_content_disposition_finalize (GObject * obj)
{
	GearyMimeContentDisposition * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_MIME_TYPE_CONTENT_DISPOSITION, GearyMimeContentDisposition);
	_g_free0 (self->priv->_original_disposition_type_string);
	_g_object_unref0 (self->priv->_params);
	G_OBJECT_CLASS (geary_mime_content_disposition_parent_class)->finalize (obj);
}

/**
 * A representation of the RFC 2183 Content-Disposition field.
 *
 * See [[https://tools.ietf.org/html/rfc2183]]
 */
 G_GNUC_NO_INLINE static GType
geary_mime_content_disposition_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyMimeContentDispositionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_mime_content_disposition_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyMimeContentDisposition), 0, (GInstanceInitFunc) geary_mime_content_disposition_instance_init, NULL };
	GType geary_mime_content_disposition_type_id;
	geary_mime_content_disposition_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyMimeContentDisposition", &g_define_type_info, 0);
	GearyMimeContentDisposition_private_offset = g_type_add_instance_private (geary_mime_content_disposition_type_id, sizeof (GearyMimeContentDispositionPrivate));
	return geary_mime_content_disposition_type_id;
}

GType
geary_mime_content_disposition_get_type (void)
{
	static gsize geary_mime_content_disposition_type_id__once = 0;
	if (g_once_init_enter (&geary_mime_content_disposition_type_id__once)) {
		GType geary_mime_content_disposition_type_id;
		geary_mime_content_disposition_type_id = geary_mime_content_disposition_get_type_once ();
		g_once_init_leave (&geary_mime_content_disposition_type_id__once, geary_mime_content_disposition_type_id);
	}
	return geary_mime_content_disposition_type_id__once;
}

static void
_vala_geary_mime_content_disposition_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	GearyMimeContentDisposition * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_MIME_TYPE_CONTENT_DISPOSITION, GearyMimeContentDisposition);
	switch (property_id) {
		case GEARY_MIME_CONTENT_DISPOSITION_DISPOSITION_TYPE_PROPERTY:
		g_value_set_enum (value, geary_mime_content_disposition_get_disposition_type (self));
		break;
		case GEARY_MIME_CONTENT_DISPOSITION_IS_UNKNOWN_DISPOSITION_TYPE_PROPERTY:
		g_value_set_boolean (value, geary_mime_content_disposition_get_is_unknown_disposition_type (self));
		break;
		case GEARY_MIME_CONTENT_DISPOSITION_ORIGINAL_DISPOSITION_TYPE_STRING_PROPERTY:
		g_value_set_string (value, geary_mime_content_disposition_get_original_disposition_type_string (self));
		break;
		case GEARY_MIME_CONTENT_DISPOSITION_PARAMS_PROPERTY:
		g_value_set_object (value, geary_mime_content_disposition_get_params (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_mime_content_disposition_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	GearyMimeContentDisposition * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_MIME_TYPE_CONTENT_DISPOSITION, GearyMimeContentDisposition);
	switch (property_id) {
		case GEARY_MIME_CONTENT_DISPOSITION_DISPOSITION_TYPE_PROPERTY:
		geary_mime_content_disposition_set_disposition_type (self, g_value_get_enum (value));
		break;
		case GEARY_MIME_CONTENT_DISPOSITION_IS_UNKNOWN_DISPOSITION_TYPE_PROPERTY:
		geary_mime_content_disposition_set_is_unknown_disposition_type (self, g_value_get_boolean (value));
		break;
		case GEARY_MIME_CONTENT_DISPOSITION_ORIGINAL_DISPOSITION_TYPE_STRING_PROPERTY:
		geary_mime_content_disposition_set_original_disposition_type_string (self, g_value_get_string (value));
		break;
		case GEARY_MIME_CONTENT_DISPOSITION_PARAMS_PROPERTY:
		geary_mime_content_disposition_set_params (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

