/* imap-message-set.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-message-set.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gee.h>

#define GEARY_IMAP_MESSAGE_SET_MAX_SPARSE_VALUES_PER_SET 50
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_IMAP_MESSAGE_SET_0_PROPERTY,
	GEARY_IMAP_MESSAGE_SET_IS_UID_PROPERTY,
	GEARY_IMAP_MESSAGE_SET_NUM_PROPERTIES
};
static GParamSpec* geary_imap_message_set_properties[GEARY_IMAP_MESSAGE_SET_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block29Data Block29Data;
typedef void (*GearyImapMessageSetParserCallback) (gint64 value, gpointer user_data, GError** error);
typedef struct _Block30Data Block30Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GearyImapMessageSetPrivate {
	gboolean _is_uid;
	gchar* _value;
};

struct _Block29Data {
	int _ref_count_;
	GeeList* seq_nums;
};

struct _Block30Data {
	int _ref_count_;
	GeeList* uids;
};

static gint GearyImapMessageSet_private_offset;
static gpointer geary_imap_message_set_parent_class = NULL;

static void geary_imap_message_set_set_is_uid (GearyImapMessageSet* self,
                                        gboolean value);
static const gchar* geary_imap_message_set_get_value (GearyImapMessageSet* self);
static void geary_imap_message_set_set_value (GearyImapMessageSet* self,
                                       const gchar* value);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
static void geary_imap_message_set_parse_string (const gchar* str,
                                          GearyImapMessageSetParserCallback cb,
                                          gpointer cb_target,
                                          GError** error);
static void __lambda42_ (Block29Data* _data29_,
                  gint64 value,
                  GError** error);
static void ___lambda42__geary_imap_message_set_parser_callback (gint64 value,
                                                          gpointer self,
                                                          GError** error);
static Block30Data* block30_data_ref (Block30Data* _data30_);
static void block30_data_unref (void * _userdata_);
static void __lambda43_ (Block30Data* _data30_,
                  gint64 value,
                  GError** error);
static void ___lambda43__geary_imap_message_set_parser_callback (gint64 value,
                                                          gpointer self,
                                                          GError** error);
static void geary_imap_message_set_process_range (gint64 start,
                                           gint64 end,
                                           GearyImapMessageSetParserCallback cb,
                                           gpointer cb_target,
                                           GError** error);
static GeeList* geary_imap_message_set_build_sparse_sets (gint64* sorted,
                                                   gint sorted_length1,
                                                   gboolean is_uid);
static gint64* geary_imap_message_set_seq_array_to_int64 (GeeCollection* seq_nums,
                                                   gint* result_length1);
static gint64* geary_imap_message_set_uid_array_to_int64 (GeeCollection* msg_uids,
                                                   gint* result_length1);
static gchar* geary_imap_message_set_build_sparse_range (gint64* seq_nums,
                                                  gint seq_nums_length1);
static gint __lambda44_ (GearyImapSequenceNumber* a,
                  GearyImapSequenceNumber* b);
static gint ___lambda44__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static gint __lambda45_ (GearyImapUID* a,
                  GearyImapUID* b);
static gint ___lambda45__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static void geary_imap_message_set_finalize (GObject * obj);
static GType geary_imap_message_set_get_type_once (void);
static void _vala_geary_imap_message_set_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_geary_imap_message_set_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
geary_imap_message_set_get_instance_private (GearyImapMessageSet* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapMessageSet_private_offset);
}

gboolean
geary_imap_message_set_get_is_uid (GearyImapMessageSet* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_MESSAGE_SET (self), FALSE);
	result = self->priv->_is_uid;
	return result;
}

static void
geary_imap_message_set_set_is_uid (GearyImapMessageSet* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (GEARY_IMAP_IS_MESSAGE_SET (self));
	old_value = geary_imap_message_set_get_is_uid (self);
	if (old_value != value) {
		self->priv->_is_uid = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_message_set_properties[GEARY_IMAP_MESSAGE_SET_IS_UID_PROPERTY]);
	}
}

static const gchar*
geary_imap_message_set_get_value (GearyImapMessageSet* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_MESSAGE_SET (self), NULL);
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}

static void
geary_imap_message_set_set_value (GearyImapMessageSet* self,
                                  const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (GEARY_IMAP_IS_MESSAGE_SET (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_value);
	self->priv->_value = _tmp0_;
}

GearyImapMessageSet*
geary_imap_message_set_construct (GType object_type,
                                  GearyImapSequenceNumber* seq_num)
{
	GearyImapMessageSet * self = NULL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (GEARY_IMAP_IS_SEQUENCE_NUMBER (seq_num), NULL);
	self = (GearyImapMessageSet*) geary_base_object_construct (object_type);
	_tmp0_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (seq_num, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_ > ((gint64) 0), "seq_num.value > 0");
	_tmp2_ = geary_imap_sequence_number_serialize (seq_num);
	_tmp3_ = _tmp2_;
	geary_imap_message_set_set_value (self, _tmp3_);
	_g_free0 (_tmp3_);
	return self;
}

GearyImapMessageSet*
geary_imap_message_set_new (GearyImapSequenceNumber* seq_num)
{
	return geary_imap_message_set_construct (GEARY_IMAP_TYPE_MESSAGE_SET, seq_num);
}

GearyImapMessageSet*
geary_imap_message_set_construct_uid (GType object_type,
                                      GearyImapUID* uid)
{
	GearyImapMessageSet * self = NULL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (GEARY_IMAP_IS_UID (uid), NULL);
	self = (GearyImapMessageSet*) geary_base_object_construct (object_type);
	_tmp0_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (uid, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_ > ((gint64) 0), "uid.value > 0");
	_tmp2_ = geary_imap_uid_serialize (uid);
	_tmp3_ = _tmp2_;
	geary_imap_message_set_set_value (self, _tmp3_);
	_g_free0 (_tmp3_);
	geary_imap_message_set_set_is_uid (self, TRUE);
	return self;
}

GearyImapMessageSet*
geary_imap_message_set_new_uid (GearyImapUID* uid)
{
	return geary_imap_message_set_construct_uid (GEARY_IMAP_TYPE_MESSAGE_SET, uid);
}

GearyImapMessageSet*
geary_imap_message_set_construct_range_by_count (GType object_type,
                                                 GearyImapSequenceNumber* low_seq_num,
                                                 gint count)
{
	GearyImapMessageSet * self = NULL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (GEARY_IMAP_IS_SEQUENCE_NUMBER (low_seq_num), NULL);
	self = (GearyImapMessageSet*) geary_base_object_construct (object_type);
	_tmp0_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (low_seq_num, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_ > ((gint64) 0), "low_seq_num.value > 0");
	_vala_assert (count > 0, "count > 0");
	if (count > 1) {
		gint64 _tmp3_;
		gint64 _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gint64 _tmp7_;
		gint64 _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp3_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (low_seq_num, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (low_seq_num, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, (_tmp8_ + count) - 1);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup_printf ("%s:%s", _tmp6_, _tmp10_);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp11_;
		_g_free0 (_tmp10_);
		_g_free0 (_tmp6_);
	} else {
		gchar* _tmp12_;
		_tmp12_ = geary_imap_sequence_number_serialize (low_seq_num);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp12_;
	}
	geary_imap_message_set_set_value (self, _tmp2_);
	_g_free0 (_tmp2_);
	return self;
}

GearyImapMessageSet*
geary_imap_message_set_new_range_by_count (GearyImapSequenceNumber* low_seq_num,
                                           gint count)
{
	return geary_imap_message_set_construct_range_by_count (GEARY_IMAP_TYPE_MESSAGE_SET, low_seq_num, count);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyImapMessageSet*
geary_imap_message_set_construct_range_by_first_last (GType object_type,
                                                      GearyImapSequenceNumber* low_seq_num,
                                                      GearyImapSequenceNumber* high_seq_num)
{
	GearyImapMessageSet * self = NULL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	gint64 _tmp5_;
	gint64 _tmp6_;
	gint64 _tmp7_;
	gchar* _tmp10_ = NULL;
	g_return_val_if_fail (GEARY_IMAP_IS_SEQUENCE_NUMBER (low_seq_num), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_SEQUENCE_NUMBER (high_seq_num), NULL);
	self = (GearyImapMessageSet*) geary_base_object_construct (object_type);
	_tmp0_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (low_seq_num, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_ > ((gint64) 0), "low_seq_num.value > 0");
	_tmp2_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (high_seq_num, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp3_ = _tmp2_;
	_vala_assert (_tmp3_ > ((gint64) 0), "high_seq_num.value > 0");
	_tmp4_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (low_seq_num, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp5_ = _tmp4_;
	_tmp6_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (high_seq_num, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp7_ = _tmp6_;
	if (_tmp5_ > _tmp7_) {
		GearyImapSequenceNumber* swap = NULL;
		GearyImapSequenceNumber* _tmp8_;
		GearyImapSequenceNumber* _tmp9_;
		_tmp8_ = _g_object_ref0 (low_seq_num);
		swap = _tmp8_;
		low_seq_num = high_seq_num;
		_tmp9_ = swap;
		high_seq_num = _tmp9_;
		_g_object_unref0 (swap);
	}
	if (!geary_message_data_int64_message_data_equal_to (G_TYPE_CHECK_INSTANCE_CAST (low_seq_num, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData), G_TYPE_CHECK_INSTANCE_CAST (high_seq_num, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData))) {
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp11_ = geary_imap_sequence_number_serialize (low_seq_num);
		_tmp12_ = _tmp11_;
		_tmp13_ = geary_imap_sequence_number_serialize (high_seq_num);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup_printf ("%s:%s", _tmp12_, _tmp14_);
		_g_free0 (_tmp10_);
		_tmp10_ = _tmp15_;
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
	} else {
		gchar* _tmp16_;
		_tmp16_ = geary_imap_sequence_number_serialize (low_seq_num);
		_g_free0 (_tmp10_);
		_tmp10_ = _tmp16_;
	}
	geary_imap_message_set_set_value (self, _tmp10_);
	_g_free0 (_tmp10_);
	return self;
}

GearyImapMessageSet*
geary_imap_message_set_new_range_by_first_last (GearyImapSequenceNumber* low_seq_num,
                                                GearyImapSequenceNumber* high_seq_num)
{
	return geary_imap_message_set_construct_range_by_first_last (GEARY_IMAP_TYPE_MESSAGE_SET, low_seq_num, high_seq_num);
}

GearyImapMessageSet*
geary_imap_message_set_construct_uid_range (GType object_type,
                                            GearyImapUID* low,
                                            GearyImapUID* high)
{
	GearyImapMessageSet * self = NULL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	gint64 _tmp5_;
	gint64 _tmp6_;
	gint64 _tmp7_;
	g_return_val_if_fail (GEARY_IMAP_IS_UID (low), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_UID (high), NULL);
	self = (GearyImapMessageSet*) geary_base_object_construct (object_type);
	_tmp0_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (low, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_ > ((gint64) 0), "low.value > 0");
	_tmp2_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (high, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp3_ = _tmp2_;
	_vala_assert (_tmp3_ > ((gint64) 0), "high.value > 0");
	_tmp4_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (low, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp5_ = _tmp4_;
	_tmp6_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (high, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp7_ = _tmp6_;
	if (_tmp5_ > _tmp7_) {
		GearyImapUID* swap = NULL;
		GearyImapUID* _tmp8_;
		GearyImapUID* _tmp9_;
		_tmp8_ = _g_object_ref0 (low);
		swap = _tmp8_;
		low = high;
		_tmp9_ = swap;
		high = _tmp9_;
		_g_object_unref0 (swap);
	}
	if (geary_message_data_int64_message_data_equal_to (G_TYPE_CHECK_INSTANCE_CAST (low, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData), G_TYPE_CHECK_INSTANCE_CAST (high, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData))) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = geary_imap_uid_serialize (low);
		_tmp11_ = _tmp10_;
		geary_imap_message_set_set_value (self, _tmp11_);
		_g_free0 (_tmp11_);
	} else {
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp12_ = geary_imap_uid_serialize (low);
		_tmp13_ = _tmp12_;
		_tmp14_ = geary_imap_uid_serialize (high);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf ("%s:%s", _tmp13_, _tmp15_);
		_tmp17_ = _tmp16_;
		geary_imap_message_set_set_value (self, _tmp17_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
	}
	geary_imap_message_set_set_is_uid (self, TRUE);
	return self;
}

GearyImapMessageSet*
geary_imap_message_set_new_uid_range (GearyImapUID* low,
                                      GearyImapUID* high)
{
	return geary_imap_message_set_construct_uid_range (GEARY_IMAP_TYPE_MESSAGE_SET, low, high);
}

GearyImapMessageSet*
geary_imap_message_set_construct_range_to_highest (GType object_type,
                                                   GearyImapSequenceNumber* low_seq_num)
{
	GearyImapMessageSet * self = NULL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (GEARY_IMAP_IS_SEQUENCE_NUMBER (low_seq_num), NULL);
	self = (GearyImapMessageSet*) geary_base_object_construct (object_type);
	_tmp0_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (low_seq_num, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_ > ((gint64) 0), "low_seq_num.value > 0");
	_tmp2_ = geary_imap_sequence_number_serialize (low_seq_num);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s:*", _tmp3_);
	_tmp5_ = _tmp4_;
	geary_imap_message_set_set_value (self, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	return self;
}

GearyImapMessageSet*
geary_imap_message_set_new_range_to_highest (GearyImapSequenceNumber* low_seq_num)
{
	return geary_imap_message_set_construct_range_to_highest (GEARY_IMAP_TYPE_MESSAGE_SET, low_seq_num);
}

GearyImapMessageSet*
geary_imap_message_set_construct_uid_range_to_highest (GType object_type,
                                                       GearyImapUID* low)
{
	GearyImapMessageSet * self = NULL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (GEARY_IMAP_IS_UID (low), NULL);
	self = (GearyImapMessageSet*) geary_base_object_construct (object_type);
	_tmp0_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (low, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_ > ((gint64) 0), "low.value > 0");
	_tmp2_ = geary_imap_uid_serialize (low);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s:*", _tmp3_);
	_tmp5_ = _tmp4_;
	geary_imap_message_set_set_value (self, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	geary_imap_message_set_set_is_uid (self, TRUE);
	return self;
}

GearyImapMessageSet*
geary_imap_message_set_new_uid_range_to_highest (GearyImapUID* low)
{
	return geary_imap_message_set_construct_uid_range_to_highest (GEARY_IMAP_TYPE_MESSAGE_SET, low);
}

GearyImapMessageSet*
geary_imap_message_set_construct_custom (GType object_type,
                                         const gchar* custom)
{
	GearyImapMessageSet * self = NULL;
	g_return_val_if_fail (custom != NULL, NULL);
	self = (GearyImapMessageSet*) geary_base_object_construct (object_type);
	geary_imap_message_set_set_value (self, custom);
	return self;
}

GearyImapMessageSet*
geary_imap_message_set_new_custom (const gchar* custom)
{
	return geary_imap_message_set_construct_custom (GEARY_IMAP_TYPE_MESSAGE_SET, custom);
}

GearyImapMessageSet*
geary_imap_message_set_construct_uid_custom (GType object_type,
                                             const gchar* custom)
{
	GearyImapMessageSet * self = NULL;
	g_return_val_if_fail (custom != NULL, NULL);
	self = (GearyImapMessageSet*) geary_base_object_construct (object_type);
	geary_imap_message_set_set_value (self, custom);
	geary_imap_message_set_set_is_uid (self, TRUE);
	return self;
}

GearyImapMessageSet*
geary_imap_message_set_new_uid_custom (const gchar* custom)
{
	return geary_imap_message_set_construct_uid_custom (GEARY_IMAP_TYPE_MESSAGE_SET, custom);
}

/**
     * Parses a string representing a {@link MessageSet} into a List of {@link SequenceNumber}s.
     *
     * See the note at {@link uid_parse} about limitations of this method.
     *
     * Returns null if the string or parsed set is empty.
     *
     * @see uid_parse
     */
static Block29Data*
block29_data_ref (Block29Data* _data29_)
{
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}

static void
block29_data_unref (void * _userdata_)
{
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		_g_object_unref0 (_data29_->seq_nums);
		g_slice_free (Block29Data, _data29_);
	}
}

static void
__lambda42_ (Block29Data* _data29_,
             gint64 value,
             GError** error)
{
	GearyImapSequenceNumber* _tmp0_ = NULL;
	GearyImapSequenceNumber* _tmp1_;
	GError* _inner_error0_ = NULL;
	_tmp1_ = geary_imap_sequence_number_new_checked (value, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data29_->seq_nums, GEE_TYPE_COLLECTION, GeeCollection), _tmp0_);
	_g_object_unref0 (_tmp0_);
}

static void
___lambda42__geary_imap_message_set_parser_callback (gint64 value,
                                                     gpointer self,
                                                     GError** error)
{
	__lambda42_ (self, value, error);
}

GeeList*
geary_imap_message_set_parse (const gchar* str,
                              GError** error)
{
	Block29Data* _data29_;
	GeeArrayList* _tmp0_;
	GeeList* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	GeeList* _tmp4_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (str != NULL, NULL);
	_data29_ = g_slice_new0 (Block29Data);
	_data29_->_ref_count_ = 1;
	_tmp0_ = gee_array_list_new (GEARY_IMAP_TYPE_SEQUENCE_NUMBER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data29_->seq_nums = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
	geary_imap_message_set_parse_string (str, ___lambda42__geary_imap_message_set_parser_callback, _data29_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			block29_data_unref (_data29_);
			_data29_ = NULL;
			return NULL;
		} else {
			block29_data_unref (_data29_);
			_data29_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data29_->seq_nums, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		_tmp1_ = _data29_->seq_nums;
	} else {
		_tmp1_ = NULL;
	}
	_tmp4_ = _g_object_ref0 (_tmp1_);
	result = _tmp4_;
	block29_data_unref (_data29_);
	_data29_ = NULL;
	return result;
}

/**
     * Parses a string representing a {@link MessageSet} into a List of {@link UID}s.
     *
     * Note that this is currently designed for parsing message set responses from the server,
     * specifically for COPYUID, which has some limitations in what may be returned.  Notably, the
     * asterisk ("*") symbol may not be returned.  Thus, this method does not properly parse
     * the full range of message set notation and can't even be trusted to reverse-parse the output
     * of this class.  A full implementation might be considered later.
     *
     * Because COPYUID returns values in the order copied, this method returns a List, not a Set,
     * of values.  They are in the order received (and properly deal with ranges in backwards
     * order, i.e. "12:10").  This means duplicates may be encountered multiple times if the server
     * returns those values.
     *
     * Returns null if the string or parsed set is empty.
     */
static Block30Data*
block30_data_ref (Block30Data* _data30_)
{
	g_atomic_int_inc (&_data30_->_ref_count_);
	return _data30_;
}

static void
block30_data_unref (void * _userdata_)
{
	Block30Data* _data30_;
	_data30_ = (Block30Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data30_->_ref_count_)) {
		_g_object_unref0 (_data30_->uids);
		g_slice_free (Block30Data, _data30_);
	}
}

static void
__lambda43_ (Block30Data* _data30_,
             gint64 value,
             GError** error)
{
	GearyImapUID* _tmp0_ = NULL;
	GearyImapUID* _tmp1_;
	GError* _inner_error0_ = NULL;
	_tmp1_ = geary_imap_uid_new_checked (value, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data30_->uids, GEE_TYPE_COLLECTION, GeeCollection), _tmp0_);
	_g_object_unref0 (_tmp0_);
}

static void
___lambda43__geary_imap_message_set_parser_callback (gint64 value,
                                                     gpointer self,
                                                     GError** error)
{
	__lambda43_ (self, value, error);
}

GeeList*
geary_imap_message_set_uid_parse (const gchar* str,
                                  GError** error)
{
	Block30Data* _data30_;
	GeeArrayList* _tmp0_;
	GeeList* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	GeeList* _tmp4_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (str != NULL, NULL);
	_data30_ = g_slice_new0 (Block30Data);
	_data30_->_ref_count_ = 1;
	_tmp0_ = gee_array_list_new (GEARY_IMAP_TYPE_UID, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data30_->uids = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
	geary_imap_message_set_parse_string (str, ___lambda43__geary_imap_message_set_parser_callback, _data30_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			block30_data_unref (_data30_);
			_data30_ = NULL;
			return NULL;
		} else {
			block30_data_unref (_data30_);
			_data30_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data30_->uids, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		_tmp1_ = _data30_->uids;
	} else {
		_tmp1_ = NULL;
	}
	_tmp4_ = _g_object_ref0 (_tmp1_);
	result = _tmp4_;
	block30_data_unref (_data30_);
	_data30_ = NULL;
	return result;
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, _base);
	return result;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static void
geary_imap_message_set_parse_string (const gchar* str,
                                     GearyImapMessageSetParserCallback cb,
                                     gpointer cb_target,
                                     GError** error)
{
	GString* acc = NULL;
	GString* _tmp0_;
	gint64 start_range = 0LL;
	gboolean in_range = FALSE;
	gunichar ch = 0U;
	gint index = 0;
	GString* _tmp22_;
	const gchar* _tmp23_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (str != NULL);
	_tmp0_ = g_string_new ("");
	acc = _tmp0_;
	start_range = (gint64) -1;
	in_range = FALSE;
	index = 0;
	while (TRUE) {
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_;
		_tmp2_ = string_get_next_char (str, &index, &_tmp1_);
		ch = _tmp1_;
		if (!_tmp2_) {
			break;
		}
		if (g_unichar_isdigit (ch)) {
			GString* _tmp3_;
			_tmp3_ = acc;
			g_string_append_unichar (_tmp3_, ch);
			continue;
		}
		switch (ch) {
			case ':':
			{
				GString* _tmp5_;
				const gchar* _tmp6_;
				GString* _tmp7_;
				if (in_range) {
					GError* _tmp4_;
					_tmp4_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Bad range specifier in message set \"%s\"", str);
					_inner_error0_ = _tmp4_;
					if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_string_free0 (acc);
						return;
					} else {
						_g_string_free0 (acc);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				in_range = TRUE;
				_tmp5_ = acc;
				_tmp6_ = _tmp5_->str;
				start_range = int64_parse (_tmp6_, (guint) 0);
				_tmp7_ = g_string_new ("");
				_g_string_free0 (acc);
				acc = _tmp7_;
				break;
			}
			case ',':
			{
				GString* _tmp17_;
				if (in_range) {
					GString* _tmp8_;
					const gchar* _tmp9_;
					GString* _tmp11_;
					const gchar* _tmp12_;
					_tmp8_ = acc;
					_tmp9_ = _tmp8_->str;
					if (geary_string_is_empty (_tmp9_)) {
						GError* _tmp10_;
						_tmp10_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Bad range specifier in message set \"%s\"", str);
						_inner_error0_ = _tmp10_;
						if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_string_free0 (acc);
							return;
						} else {
							_g_string_free0 (acc);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
					_tmp11_ = acc;
					_tmp12_ = _tmp11_->str;
					geary_imap_message_set_process_range (start_range, int64_parse (_tmp12_, (guint) 0), cb, cb_target, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_string_free0 (acc);
							return;
						} else {
							_g_string_free0 (acc);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
					in_range = FALSE;
				} else {
					GString* _tmp13_;
					const gchar* _tmp14_;
					GString* _tmp15_;
					const gchar* _tmp16_;
					_tmp13_ = acc;
					_tmp14_ = _tmp13_->str;
					if (geary_string_is_empty (_tmp14_)) {
						continue;
					}
					_tmp15_ = acc;
					_tmp16_ = _tmp15_->str;
					cb (int64_parse (_tmp16_, (guint) 0), cb_target, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_string_free0 (acc);
							return;
						} else {
							_g_string_free0 (acc);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
				}
				_tmp17_ = g_string_new ("");
				_g_string_free0 (acc);
				acc = _tmp17_;
				break;
			}
			default:
			{
				gchar* _tmp18_;
				gchar* _tmp19_;
				GError* _tmp20_;
				GError* _tmp21_;
				_tmp18_ = g_unichar_to_string (ch);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Bad character '%s' in message set \"%s\"", _tmp19_, str);
				_tmp21_ = _tmp20_;
				_g_free0 (_tmp19_);
				_inner_error0_ = _tmp21_;
				if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_string_free0 (acc);
					return;
				} else {
					_g_string_free0 (acc);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
	}
	_tmp22_ = acc;
	_tmp23_ = _tmp22_->str;
	if (!geary_string_is_empty (_tmp23_)) {
		if (in_range) {
			GString* _tmp24_;
			const gchar* _tmp25_;
			_tmp24_ = acc;
			_tmp25_ = _tmp24_->str;
			geary_imap_message_set_process_range (start_range, int64_parse (_tmp25_, (guint) 0), cb, cb_target, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_string_free0 (acc);
					return;
				} else {
					_g_string_free0 (acc);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		} else {
			GString* _tmp26_;
			const gchar* _tmp27_;
			_tmp26_ = acc;
			_tmp27_ = _tmp26_->str;
			cb (int64_parse (_tmp27_, (guint) 0), cb_target, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_string_free0 (acc);
					return;
				} else {
					_g_string_free0 (acc);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
	} else {
		if (in_range) {
			GError* _tmp28_;
			_tmp28_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Incomplete range specifier in message set \"%s\"", str);
			_inner_error0_ = _tmp28_;
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_string_free0 (acc);
				return;
			} else {
				_g_string_free0 (acc);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_g_string_free0 (acc);
}

static void
geary_imap_message_set_process_range (gint64 start,
                                      gint64 end,
                                      GearyImapMessageSetParserCallback cb,
                                      gpointer cb_target,
                                      GError** error)
{
	gint _tmp0_ = 0;
	gint64 count_by = 0LL;
	GError* _inner_error0_ = NULL;
	if (start <= end) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = -1;
	}
	count_by = (gint64) _tmp0_;
	{
		gint64 ctr = 0LL;
		ctr = start;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					ctr += count_by;
				}
				_tmp1_ = FALSE;
				if (!(ctr != (end + count_by))) {
					break;
				}
				cb (ctr, cb_target, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
		}
	}
}

/**
     * Convert a collection of {@link SequenceNumber}s into a list of {@link MessageSet}s.
     *
     * Although this could return a single MessageSet, large collections could create an IMAP
     * command beyond the server maximum, and so they will be broken up into multiple sets.
     */
GeeList*
geary_imap_message_set_sparse (GeeCollection* seq_nums)
{
	gint _tmp0_ = 0;
	gint64* _tmp1_;
	gint64* _tmp2_;
	gint _tmp2__length1;
	GeeList* _tmp3_;
	GeeList* _tmp4_;
	GeeList* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (seq_nums, GEE_TYPE_COLLECTION), NULL);
	_tmp1_ = geary_imap_message_set_seq_array_to_int64 (seq_nums, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	_tmp3_ = geary_imap_message_set_build_sparse_sets (_tmp2_, (gint) _tmp0_, FALSE);
	_tmp4_ = _tmp3_;
	_tmp2_ = (g_free (_tmp2_), NULL);
	result = _tmp4_;
	return result;
}

/**
     * Convert a collection of {@link UID}s into a list of {@link MessageSet}s.
     *
     * Although this could return a single MessageSet, large collections could create an IMAP
     * command beyond the server maximum, and so they will be broken up into multiple sets.
     */
GeeList*
geary_imap_message_set_uid_sparse (GeeCollection* msg_uids)
{
	gint _tmp0_ = 0;
	gint64* _tmp1_;
	gint64* _tmp2_;
	gint _tmp2__length1;
	GeeList* _tmp3_;
	GeeList* _tmp4_;
	GeeList* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (msg_uids, GEE_TYPE_COLLECTION), NULL);
	_tmp1_ = geary_imap_message_set_uid_array_to_int64 (msg_uids, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	_tmp3_ = geary_imap_message_set_build_sparse_sets (_tmp2_, (gint) _tmp0_, TRUE);
	_tmp4_ = _tmp3_;
	_tmp2_ = (g_free (_tmp2_), NULL);
	result = _tmp4_;
	return result;
}

static GeeList*
geary_imap_message_set_build_sparse_sets (gint64* sorted,
                                          gint sorted_length1,
                                          gboolean is_uid)
{
	GeeList* list = NULL;
	GeeArrayList* _tmp0_;
	gint start = 0;
	GeeList* result;
	_tmp0_ = gee_array_list_new (GEARY_IMAP_TYPE_MESSAGE_SET, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
	start = 0;
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = TRUE;
		while (TRUE) {
			gint end = 0;
			gint64* slice = NULL;
			gint slice_length1;
			gint _slice_size_;
			gchar* sparse_range = NULL;
			gint64* _tmp2_;
			gint _tmp2__length1;
			gchar* _tmp3_;
			GearyImapMessageSet* _tmp4_ = NULL;
			GeeList* _tmp9_;
			if (!_tmp1_) {
			}
			_tmp1_ = FALSE;
			if (start >= sorted_length1) {
				break;
			}
			end = CLAMP (start + GEARY_IMAP_MESSAGE_SET_MAX_SPARSE_VALUES_PER_SET, 0, sorted_length1);
			slice = sorted + start;
			slice_length1 = end - start;
			_slice_size_ = slice_length1;
			_tmp2_ = slice;
			_tmp2__length1 = slice_length1;
			_tmp3_ = geary_imap_message_set_build_sparse_range (_tmp2_, (gint) _tmp2__length1);
			sparse_range = _tmp3_;
			if (is_uid) {
				const gchar* _tmp5_;
				GearyImapMessageSet* _tmp6_;
				_tmp5_ = sparse_range;
				_tmp6_ = geary_imap_message_set_new_uid_custom (_tmp5_);
				_g_object_unref0 (_tmp4_);
				_tmp4_ = _tmp6_;
			} else {
				const gchar* _tmp7_;
				GearyImapMessageSet* _tmp8_;
				_tmp7_ = sparse_range;
				_tmp8_ = geary_imap_message_set_new_custom (_tmp7_);
				_g_object_unref0 (_tmp4_);
				_tmp4_ = _tmp8_;
			}
			_tmp9_ = list;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_COLLECTION, GeeCollection), _tmp4_);
			start = end;
			_g_object_unref0 (_tmp4_);
			_g_free0 (sparse_range);
		}
	}
	result = list;
	return result;
}

static gchar*
geary_imap_message_set_build_sparse_range (gint64* seq_nums,
                                           gint seq_nums_length1)
{
	gint64 start_of_span = 0LL;
	gint64 last_seq_num = 0LL;
	gint span_count = 0;
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* result;
	_vala_assert (seq_nums_length1 > 0, "seq_nums.length > 0");
	start_of_span = (gint64) -1;
	last_seq_num = (gint64) -1;
	span_count = 0;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	{
		gint64* seq_num_collection = NULL;
		gint seq_num_collection_length1 = 0;
		gint _seq_num_collection_size_ = 0;
		gint seq_num_it = 0;
		seq_num_collection = seq_nums;
		seq_num_collection_length1 = seq_nums_length1;
		for (seq_num_it = 0; seq_num_it < seq_num_collection_length1; seq_num_it = seq_num_it + 1) {
			gint64 seq_num = 0LL;
			seq_num = seq_num_collection[seq_num_it];
			{
				_vala_assert (seq_num >= ((gint64) 0), "seq_num >= 0");
				if (start_of_span < ((gint64) 0)) {
					GString* _tmp1_;
					gchar* _tmp2_;
					gchar* _tmp3_;
					_tmp1_ = builder;
					_tmp2_ = g_strdup_printf ("%" G_GINT64_FORMAT, seq_num);
					_tmp3_ = _tmp2_;
					g_string_append (_tmp1_, _tmp3_);
					_g_free0 (_tmp3_);
					start_of_span = seq_num;
					span_count = 1;
				} else {
					if ((start_of_span + span_count) == seq_num) {
						gint _tmp4_;
						_tmp4_ = span_count;
						span_count = _tmp4_ + 1;
					} else {
						_vala_assert (span_count >= 1, "span_count >= 1");
						if (span_count == 1) {
							GString* _tmp5_;
							gchar* _tmp6_;
							gchar* _tmp7_;
							_tmp5_ = builder;
							_tmp6_ = g_strdup_printf ("%" G_GINT64_FORMAT, seq_num);
							_tmp7_ = _tmp6_;
							g_string_append_printf (_tmp5_, ",%s", _tmp7_);
							_g_free0 (_tmp7_);
						} else {
							if (span_count == 2) {
								GString* _tmp8_;
								gchar* _tmp9_;
								gchar* _tmp10_;
								gchar* _tmp11_;
								gchar* _tmp12_;
								_tmp8_ = builder;
								_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, start_of_span + 1);
								_tmp10_ = _tmp9_;
								_tmp11_ = g_strdup_printf ("%" G_GINT64_FORMAT, seq_num);
								_tmp12_ = _tmp11_;
								g_string_append_printf (_tmp8_, ",%s,%s", _tmp10_, _tmp12_);
								_g_free0 (_tmp12_);
								_g_free0 (_tmp10_);
							} else {
								GString* _tmp13_;
								gchar* _tmp14_;
								gchar* _tmp15_;
								gchar* _tmp16_;
								gchar* _tmp17_;
								_tmp13_ = builder;
								_tmp14_ = g_strdup_printf ("%" G_GINT64_FORMAT, (start_of_span + span_count) - 1);
								_tmp15_ = _tmp14_;
								_tmp16_ = g_strdup_printf ("%" G_GINT64_FORMAT, seq_num);
								_tmp17_ = _tmp16_;
								g_string_append_printf (_tmp13_, ":%s,%s", _tmp15_, _tmp17_);
								_g_free0 (_tmp17_);
								_g_free0 (_tmp15_);
							}
						}
						start_of_span = seq_num;
						span_count = 1;
					}
				}
				last_seq_num = seq_num;
			}
		}
	}
	_vala_assert (start_of_span >= ((gint64) 0), "start_of_span >= 0");
	_vala_assert (span_count > 0, "span_count > 0");
	_vala_assert (last_seq_num >= ((gint64) 0), "last_seq_num >= 0");
	if (span_count == 2) {
		GString* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = builder;
		_tmp19_ = g_strdup_printf ("%" G_GINT64_FORMAT, last_seq_num);
		_tmp20_ = _tmp19_;
		g_string_append_printf (_tmp18_, ",%s", _tmp20_);
		_g_free0 (_tmp20_);
	} else {
		if (last_seq_num != start_of_span) {
			GString* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp21_ = builder;
			_tmp22_ = g_strdup_printf ("%" G_GINT64_FORMAT, last_seq_num);
			_tmp23_ = _tmp22_;
			g_string_append_printf (_tmp21_, ":%s", _tmp23_);
			_g_free0 (_tmp23_);
		}
	}
	_tmp24_ = builder;
	_tmp25_ = _tmp24_->str;
	_tmp26_ = g_strdup (_tmp25_);
	result = _tmp26_;
	_g_string_free0 (builder);
	return result;
}

static gint
__lambda44_ (GearyImapSequenceNumber* a,
             GearyImapSequenceNumber* b)
{
	gint result;
	g_return_val_if_fail (GEARY_IMAP_IS_SEQUENCE_NUMBER (a), 0);
	g_return_val_if_fail (GEARY_IMAP_IS_SEQUENCE_NUMBER (b), 0);
	result = geary_imap_sequence_number_compare_to (a, b);
	return result;
}

static gint
___lambda44__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda44_ ((GearyImapSequenceNumber*) a, (GearyImapSequenceNumber*) b);
	return result;
}

static gint64*
geary_imap_message_set_seq_array_to_int64 (GeeCollection* seq_nums,
                                           gint* result_length1)
{
	GeeArrayList* sorted = NULL;
	GearyIterable* _tmp0_;
	GearyIterable* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	gint64* ret = NULL;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint64* _tmp7_;
	gint ret_length1;
	gint _ret_size_;
	gint index = 0;
	gint64* _tmp21_;
	gint _tmp21__length1;
	gint64* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (seq_nums, GEE_TYPE_COLLECTION), NULL);
	_tmp0_ = geary_traverse (GEARY_IMAP_TYPE_SEQUENCE_NUMBER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (seq_nums, GEE_TYPE_ITERABLE, GeeIterable));
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_iterable_to_sorted_list (_tmp1_, ___lambda44__gcompare_data_func, NULL, NULL, NULL, NULL, NULL);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	sorted = _tmp3_;
	_tmp4_ = sorted;
	_tmp5_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp6_ = _tmp5_;
	_tmp7_ = g_new0 (gint64, _tmp6_);
	ret = _tmp7_;
	ret_length1 = _tmp6_;
	_ret_size_ = ret_length1;
	index = 0;
	{
		GeeArrayList* _seq_num_list = NULL;
		GeeArrayList* _tmp8_;
		gint _seq_num_size = 0;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _seq_num_index = 0;
		_tmp8_ = sorted;
		_seq_num_list = _tmp8_;
		_tmp9_ = _seq_num_list;
		_tmp10_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp11_ = _tmp10_;
		_seq_num_size = _tmp11_;
		_seq_num_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			GearyImapSequenceNumber* seq_num = NULL;
			GeeArrayList* _tmp14_;
			gpointer _tmp15_;
			gint64* _tmp16_;
			gint _tmp16__length1;
			gint _tmp17_;
			GearyImapSequenceNumber* _tmp18_;
			gint64 _tmp19_;
			gint64 _tmp20_;
			_seq_num_index = _seq_num_index + 1;
			_tmp12_ = _seq_num_index;
			_tmp13_ = _seq_num_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _seq_num_list;
			_tmp15_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _seq_num_index);
			seq_num = (GearyImapSequenceNumber*) _tmp15_;
			_tmp16_ = ret;
			_tmp16__length1 = ret_length1;
			_tmp17_ = index;
			index = _tmp17_ + 1;
			_tmp18_ = seq_num;
			_tmp19_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
			_tmp20_ = _tmp19_;
			_tmp16_[_tmp17_] = (gint64) _tmp20_;
			_g_object_unref0 (seq_num);
		}
	}
	_tmp21_ = ret;
	_tmp21__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp21__length1;
	}
	result = _tmp21_;
	_g_object_unref0 (sorted);
	return result;
}

static gint
__lambda45_ (GearyImapUID* a,
             GearyImapUID* b)
{
	gint result;
	g_return_val_if_fail (GEARY_IMAP_IS_UID (a), 0);
	g_return_val_if_fail (GEARY_IMAP_IS_UID (b), 0);
	result = geary_imap_uid_compare_to (a, b);
	return result;
}

static gint
___lambda45__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda45_ ((GearyImapUID*) a, (GearyImapUID*) b);
	return result;
}

static gint64*
geary_imap_message_set_uid_array_to_int64 (GeeCollection* msg_uids,
                                           gint* result_length1)
{
	GeeArrayList* sorted = NULL;
	GearyIterable* _tmp0_;
	GearyIterable* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	gint64* ret = NULL;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint64* _tmp7_;
	gint ret_length1;
	gint _ret_size_;
	gint index = 0;
	gint64* _tmp21_;
	gint _tmp21__length1;
	gint64* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (msg_uids, GEE_TYPE_COLLECTION), NULL);
	_tmp0_ = geary_traverse (GEARY_IMAP_TYPE_UID, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (msg_uids, GEE_TYPE_ITERABLE, GeeIterable));
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_iterable_to_sorted_list (_tmp1_, ___lambda45__gcompare_data_func, NULL, NULL, NULL, NULL, NULL);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	sorted = _tmp3_;
	_tmp4_ = sorted;
	_tmp5_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp6_ = _tmp5_;
	_tmp7_ = g_new0 (gint64, _tmp6_);
	ret = _tmp7_;
	ret_length1 = _tmp6_;
	_ret_size_ = ret_length1;
	index = 0;
	{
		GeeArrayList* _uid_list = NULL;
		GeeArrayList* _tmp8_;
		gint _uid_size = 0;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _uid_index = 0;
		_tmp8_ = sorted;
		_uid_list = _tmp8_;
		_tmp9_ = _uid_list;
		_tmp10_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp11_ = _tmp10_;
		_uid_size = _tmp11_;
		_uid_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			GearyImapUID* uid = NULL;
			GeeArrayList* _tmp14_;
			gpointer _tmp15_;
			gint64* _tmp16_;
			gint _tmp16__length1;
			gint _tmp17_;
			GearyImapUID* _tmp18_;
			gint64 _tmp19_;
			gint64 _tmp20_;
			_uid_index = _uid_index + 1;
			_tmp12_ = _uid_index;
			_tmp13_ = _uid_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _uid_list;
			_tmp15_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _uid_index);
			uid = (GearyImapUID*) _tmp15_;
			_tmp16_ = ret;
			_tmp16__length1 = ret_length1;
			_tmp17_ = index;
			index = _tmp17_ + 1;
			_tmp18_ = uid;
			_tmp19_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
			_tmp20_ = _tmp19_;
			_tmp16_[_tmp17_] = _tmp20_;
			_g_object_unref0 (uid);
		}
	}
	_tmp21_ = ret;
	_tmp21__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp21__length1;
	}
	result = _tmp21_;
	_g_object_unref0 (sorted);
	return result;
}

/**
     * Returns the {@link MessageSet} as a {@link Parameter} suitable for inclusion in a
     * {@link Command}.
     */
GearyImapParameter*
geary_imap_message_set_to_parameter (GearyImapMessageSet* self)
{
	const gchar* _tmp0_;
	GearyImapUnquotedStringParameter* _tmp1_;
	GearyImapParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_MESSAGE_SET (self), NULL);
	_tmp0_ = self->priv->_value;
	_tmp1_ = geary_imap_unquoted_string_parameter_new (_tmp0_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter);
	return result;
}

/**
     * Returns the {@link MessageSet} in a Gee.List.
     */
GeeList*
geary_imap_message_set_to_list (GearyImapMessageSet* self)
{
	GearyIterable* _tmp0_;
	GearyIterable* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeList* _tmp3_;
	GeeList* result;
	g_return_val_if_fail (GEARY_IMAP_IS_MESSAGE_SET (self), NULL);
	_tmp0_ = geary_iterate (GEARY_IMAP_TYPE_MESSAGE_SET, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, self, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_iterable_to_array_list (_tmp1_, NULL, NULL, NULL);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_LIST, GeeList);
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gchar*
geary_imap_message_set_to_string (GearyImapMessageSet* self)
{
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (GEARY_IMAP_IS_MESSAGE_SET (self), NULL);
	_tmp1_ = self->priv->_is_uid;
	if (_tmp1_) {
		_tmp0_ = "UID";
	} else {
		_tmp0_ = "pos";
	}
	_tmp2_ = self->priv->_value;
	_tmp3_ = g_strdup_printf ("%s::%s", _tmp0_, _tmp2_);
	result = _tmp3_;
	return result;
}

static void
geary_imap_message_set_class_init (GearyImapMessageSetClass * klass,
                                   gpointer klass_data)
{
	geary_imap_message_set_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapMessageSet_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_message_set_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_message_set_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_message_set_finalize;
	/**
	     * True if the {@link MessageSet} was created with a UID or a UID range.
	     *
	     * For {@link Command}s that accept MessageSets, they will use a UID variant
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_MESSAGE_SET_IS_UID_PROPERTY, geary_imap_message_set_properties[GEARY_IMAP_MESSAGE_SET_IS_UID_PROPERTY] = g_param_spec_boolean ("is-uid", "is-uid", "is-uid", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_message_set_instance_init (GearyImapMessageSet * self,
                                      gpointer klass)
{
	self->priv = geary_imap_message_set_get_instance_private (self);
	self->priv->_is_uid = FALSE;
}

static void
geary_imap_message_set_finalize (GObject * obj)
{
	GearyImapMessageSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_MESSAGE_SET, GearyImapMessageSet);
	_g_free0 (self->priv->_value);
	G_OBJECT_CLASS (geary_imap_message_set_parent_class)->finalize (obj);
}

/**
 * A representation of an IMAP message range specifier.
 *
 * A MessageSet can be for {@link SequenceNumber}s (which use positional addressing) or
 * {@link UID}s.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-9]], "sequence-set" and "seq-range".
 */
 G_GNUC_NO_INLINE static GType
geary_imap_message_set_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapMessageSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_message_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapMessageSet), 0, (GInstanceInitFunc) geary_imap_message_set_instance_init, NULL };
	GType geary_imap_message_set_type_id;
	geary_imap_message_set_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyImapMessageSet", &g_define_type_info, 0);
	GearyImapMessageSet_private_offset = g_type_add_instance_private (geary_imap_message_set_type_id, sizeof (GearyImapMessageSetPrivate));
	return geary_imap_message_set_type_id;
}

GType
geary_imap_message_set_get_type (void)
{
	static gsize geary_imap_message_set_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_message_set_type_id__once)) {
		GType geary_imap_message_set_type_id;
		geary_imap_message_set_type_id = geary_imap_message_set_get_type_once ();
		g_once_init_leave (&geary_imap_message_set_type_id__once, geary_imap_message_set_type_id);
	}
	return geary_imap_message_set_type_id__once;
}

static void
_vala_geary_imap_message_set_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GearyImapMessageSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_MESSAGE_SET, GearyImapMessageSet);
	switch (property_id) {
		case GEARY_IMAP_MESSAGE_SET_IS_UID_PROPERTY:
		g_value_set_boolean (value, geary_imap_message_set_get_is_uid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_message_set_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GearyImapMessageSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_MESSAGE_SET, GearyImapMessageSet);
	switch (property_id) {
		case GEARY_IMAP_MESSAGE_SET_IS_UID_PROPERTY:
		geary_imap_message_set_set_is_uid (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

