
// This file is generated by src/Tools/generateTemplates/templateClassPyExport.py out of the .XML file
// Every change you make here gets lost in the next full rebuild!
// This File is normally built as an include in MaterialPyImp.cpp! It's not intended to be in a project!

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/exception.hpp>
#include <Base/PyObjectBase.h>
#include <Base/Console.h>
#include <Base/Exception.h>
#include <CXX/Objects.hxx>

#if defined(__clang__)
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

using Base::streq;
using namespace Materials;

/// Type structure of MaterialPy
PyTypeObject MaterialPy::Type = {
    PyVarObject_HEAD_INIT(&PyType_Type,0)
    "Materials.Material",     /*tp_name*/
    sizeof(MaterialPy),                       /*tp_basicsize*/
    0,                                                /*tp_itemsize*/
    /* methods */
    PyDestructor,                                     /*tp_dealloc*/
#if PY_VERSION_HEX >= 0x03080000
    0,                                                /*tp_vectorcall_offset*/
#else
    nullptr,                                          /*tp_print*/
#endif
    nullptr,                                          /*tp_getattr*/
    nullptr,                                          /*tp_setattr*/
    nullptr,                                          /*tp_compare*/
    __repr,                                           /*tp_repr*/
    nullptr,                                          /*tp_as_number*/
    nullptr,                                          /*tp_as_sequence*/
    nullptr,                                          /*tp_as_mapping*/
    nullptr,                                          /*tp_hash*/
    nullptr,                                          /*tp_call */
    nullptr,                                          /*tp_str  */
    __getattro,                                       /*tp_getattro*/
    __setattro,                                       /*tp_setattro*/
    /* --- Functions to access object as input/output buffer ---------*/
    nullptr,                                          /* tp_as_buffer */
    /* --- Flags to define presence of optional/expanded features */
    Py_TPFLAGS_BASETYPE|Py_TPFLAGS_DEFAULT,        /*tp_flags */
    "Material descriptions.",           /*tp_doc */
    nullptr,                                          /*tp_traverse */
    nullptr,                                          /*tp_clear */
    nullptr,                                          /*tp_richcompare */
    0,                                                /*tp_weaklistoffset */
    nullptr,                                          /*tp_iter */
    nullptr,                                          /*tp_iternext */
    Materials::MaterialPy::Methods,                     /*tp_methods */
    nullptr,                                          /*tp_members */
    Materials::MaterialPy::GetterSetter,                     /*tp_getset */
    &Base::BaseClassPy::Type,                        /*tp_base */
    nullptr,                                          /*tp_dict */
    nullptr,                                          /*tp_descr_get */
    nullptr,                                          /*tp_descr_set */
    0,                                                /*tp_dictoffset */
    __PyInit,                                         /*tp_init */
    nullptr,                                          /*tp_alloc */
    Materials::MaterialPy::PyMake,/*tp_new */
    nullptr,                                          /*tp_free   Low-level free-memory routine */
    nullptr,                                          /*tp_is_gc  For PyObject_IS_GC */
    nullptr,                                          /*tp_bases */
    nullptr,                                          /*tp_mro    method resolution order */
    nullptr,                                          /*tp_cache */
    nullptr,                                          /*tp_subclasses */
    nullptr,                                          /*tp_weaklist */
    nullptr,                                          /*tp_del */
    0,                                                /*tp_version_tag */
    nullptr                                           /*tp_finalize */
#if PY_VERSION_HEX >= 0x03090000
    ,nullptr                                          /*tp_vectorcall */
#if PY_VERSION_HEX >= 0x030c0000
    ,0                                                /*tp_watched */
#endif
#elif PY_VERSION_HEX >= 0x03080000
    ,nullptr                                          /*tp_vectorcall */
    /* bpo-37250: kept for backwards compatibility in CPython 3.8 only */
    ,nullptr                                          /*tp_print */
#endif
};

/// Methods structure of MaterialPy
PyMethodDef MaterialPy::Methods[] = {
    {"addPhysicalModel",
        reinterpret_cast<PyCFunction>( staticCallback_addPhysicalModel ),
        METH_VARARGS,
        "Add the physical model with the given UUID"
    },
    {"removePhysicalModel",
        reinterpret_cast<PyCFunction>( staticCallback_removePhysicalModel ),
        METH_VARARGS,
        "Remove the physical model with the given UUID"
    },
    {"hasPhysicalModel",
        reinterpret_cast<PyCFunction>( staticCallback_hasPhysicalModel ),
        METH_VARARGS,
        "Check if the material implements the physical model with the given UUID"
    },
    {"addAppearanceModel",
        reinterpret_cast<PyCFunction>( staticCallback_addAppearanceModel ),
        METH_VARARGS,
        "Add the appearance model with the given UUID"
    },
    {"removeAppearanceModel",
        reinterpret_cast<PyCFunction>( staticCallback_removeAppearanceModel ),
        METH_VARARGS,
        "Remove the appearance model with the given UUID"
    },
    {"hasAppearanceModel",
        reinterpret_cast<PyCFunction>( staticCallback_hasAppearanceModel ),
        METH_VARARGS,
        "Check if the material implements the appearance model with the given UUID"
    },
    {"isPhysicalModelComplete",
        reinterpret_cast<PyCFunction>( staticCallback_isPhysicalModelComplete ),
        METH_VARARGS,
        "Check if the material implements the physical model with the given UUID, and has values defined for each property"
    },
    {"isAppearanceModelComplete",
        reinterpret_cast<PyCFunction>( staticCallback_isAppearanceModelComplete ),
        METH_VARARGS,
        "Check if the material implements the appearance model with the given UUID, and has values defined for each property"
    },
    {"hasPhysicalProperty",
        reinterpret_cast<PyCFunction>( staticCallback_hasPhysicalProperty ),
        METH_VARARGS,
        "Check if the material implements the physical property with the given name"
    },
    {"hasAppearanceProperty",
        reinterpret_cast<PyCFunction>( staticCallback_hasAppearanceProperty ),
        METH_VARARGS,
        "Check if the material implements the appearance property with the given name"
    },
    {"hasLegacyProperties",
        reinterpret_cast<PyCFunction>( staticCallback_hasLegacyProperties ),
        METH_VARARGS,
        "Returns true of there are legacy properties"
    },
    {"getPhysicalValue",
        reinterpret_cast<PyCFunction>( staticCallback_getPhysicalValue ),
        METH_VARARGS,
        "Get the value associated with the property"
    },
    {"setPhysicalValue",
        reinterpret_cast<PyCFunction>( staticCallback_setPhysicalValue ),
        METH_VARARGS,
        "Set the value associated with the property"
    },
    {"getAppearanceValue",
        reinterpret_cast<PyCFunction>( staticCallback_getAppearanceValue ),
        METH_VARARGS,
        "Get the value associated with the property"
    },
    {"setAppearanceValue",
        reinterpret_cast<PyCFunction>( staticCallback_setAppearanceValue ),
        METH_VARARGS,
        "Set the value associated with the property"
    },
    {nullptr, nullptr, 0, nullptr}		/* Sentinel */
};



/// Attribute structure of MaterialPy
PyGetSetDef MaterialPy::GetterSetter[] = {
    {"LibraryName",
        (getter) staticCallback_getLibraryName,
        (setter) staticCallback_setLibraryName,
        "Model library name.",
        nullptr
    },
    {"LibraryRoot",
        (getter) staticCallback_getLibraryRoot,
        (setter) staticCallback_setLibraryRoot,
        "Model library path.",
        nullptr
    },
    {"LibraryIcon",
        (getter) staticCallback_getLibraryIcon,
        (setter) staticCallback_setLibraryIcon,
        "Model icon path.",
        nullptr
    },
    {"Name",
        (getter) staticCallback_getName,
        (setter) staticCallback_setName,
        "Model name.",
        nullptr
    },
    {"Directory",
        (getter) staticCallback_getDirectory,
        (setter) staticCallback_setDirectory,
        "Model directory relative to the library root.",
        nullptr
    },
    {"UUID",
        (getter) staticCallback_getUUID,
        (setter) staticCallback_setUUID,
        "Unique model identifier. This is only valid after the material is saved.",
        nullptr
    },
    {"Description",
        (getter) staticCallback_getDescription,
        (setter) staticCallback_setDescription,
        "Description of the material.",
        nullptr
    },
    {"URL",
        (getter) staticCallback_getURL,
        (setter) staticCallback_setURL,
        "URL to a material reference.",
        nullptr
    },
    {"Reference",
        (getter) staticCallback_getReference,
        (setter) staticCallback_setReference,
        "Reference for material data.",
        nullptr
    },
    {"Parent",
        (getter) staticCallback_getParent,
        (setter) staticCallback_setParent,
        "Parent material UUID.",
        nullptr
    },
    {"AuthorAndLicense",
        (getter) staticCallback_getAuthorAndLicense,
        (setter) staticCallback_setAuthorAndLicense,
        "deprecated -- Author and license information.",
        nullptr
    },
    {"Author",
        (getter) staticCallback_getAuthor,
        (setter) staticCallback_setAuthor,
        "Author information.",
        nullptr
    },
    {"License",
        (getter) staticCallback_getLicense,
        (setter) staticCallback_setLicense,
        "License information.",
        nullptr
    },
    {"PhysicalModels",
        (getter) staticCallback_getPhysicalModels,
        (setter) staticCallback_setPhysicalModels,
        "List of implemented models.",
        nullptr
    },
    {"AppearanceModels",
        (getter) staticCallback_getAppearanceModels,
        (setter) staticCallback_setAppearanceModels,
        "List of implemented models.",
        nullptr
    },
    {"Tags",
        (getter) staticCallback_getTags,
        (setter) staticCallback_setTags,
        "List of searchable tags.",
        nullptr
    },
    {"Properties",
        (getter) staticCallback_getProperties,
        (setter) staticCallback_setProperties,
        "deprecated -- Dictionary of all material properties.",
        nullptr
    },
    {"PhysicalProperties",
        (getter) staticCallback_getPhysicalProperties,
        (setter) staticCallback_setPhysicalProperties,
        "deprecated -- Dictionary of material physical properties.",
        nullptr
    },
    {"AppearanceProperties",
        (getter) staticCallback_getAppearanceProperties,
        (setter) staticCallback_setAppearanceProperties,
        "deprecated -- Dictionary of material appearance properties.",
        nullptr
    },
    {"LegacyProperties",
        (getter) staticCallback_getLegacyProperties,
        (setter) staticCallback_setLegacyProperties,
        "deprecated -- Dictionary of material legacy properties.",
        nullptr
    },
    {nullptr, nullptr, nullptr, nullptr, nullptr}		/* Sentinel */
};

// addPhysicalModel() callback and implementer
// PyObject*  MaterialPy::addPhysicalModel(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_addPhysicalModel (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'addPhysicalModel' of 'Materials.Material' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MaterialPy*>(self)->addPhysicalModel(args);
        if (ret != nullptr)
            static_cast<MaterialPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// removePhysicalModel() callback and implementer
// PyObject*  MaterialPy::removePhysicalModel(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_removePhysicalModel (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'removePhysicalModel' of 'Materials.Material' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MaterialPy*>(self)->removePhysicalModel(args);
        if (ret != nullptr)
            static_cast<MaterialPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// hasPhysicalModel() callback and implementer
// PyObject*  MaterialPy::hasPhysicalModel(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_hasPhysicalModel (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'hasPhysicalModel' of 'Materials.Material' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MaterialPy*>(self)->hasPhysicalModel(args);
        if (ret != nullptr)
            static_cast<MaterialPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// addAppearanceModel() callback and implementer
// PyObject*  MaterialPy::addAppearanceModel(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_addAppearanceModel (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'addAppearanceModel' of 'Materials.Material' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MaterialPy*>(self)->addAppearanceModel(args);
        if (ret != nullptr)
            static_cast<MaterialPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// removeAppearanceModel() callback and implementer
// PyObject*  MaterialPy::removeAppearanceModel(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_removeAppearanceModel (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'removeAppearanceModel' of 'Materials.Material' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MaterialPy*>(self)->removeAppearanceModel(args);
        if (ret != nullptr)
            static_cast<MaterialPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// hasAppearanceModel() callback and implementer
// PyObject*  MaterialPy::hasAppearanceModel(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_hasAppearanceModel (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'hasAppearanceModel' of 'Materials.Material' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MaterialPy*>(self)->hasAppearanceModel(args);
        if (ret != nullptr)
            static_cast<MaterialPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isPhysicalModelComplete() callback and implementer
// PyObject*  MaterialPy::isPhysicalModelComplete(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_isPhysicalModelComplete (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isPhysicalModelComplete' of 'Materials.Material' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MaterialPy*>(self)->isPhysicalModelComplete(args);
        if (ret != nullptr)
            static_cast<MaterialPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isAppearanceModelComplete() callback and implementer
// PyObject*  MaterialPy::isAppearanceModelComplete(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_isAppearanceModelComplete (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isAppearanceModelComplete' of 'Materials.Material' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MaterialPy*>(self)->isAppearanceModelComplete(args);
        if (ret != nullptr)
            static_cast<MaterialPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// hasPhysicalProperty() callback and implementer
// PyObject*  MaterialPy::hasPhysicalProperty(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_hasPhysicalProperty (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'hasPhysicalProperty' of 'Materials.Material' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MaterialPy*>(self)->hasPhysicalProperty(args);
        if (ret != nullptr)
            static_cast<MaterialPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// hasAppearanceProperty() callback and implementer
// PyObject*  MaterialPy::hasAppearanceProperty(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_hasAppearanceProperty (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'hasAppearanceProperty' of 'Materials.Material' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MaterialPy*>(self)->hasAppearanceProperty(args);
        if (ret != nullptr)
            static_cast<MaterialPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// hasLegacyProperties() callback and implementer
// PyObject*  MaterialPy::hasLegacyProperties(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_hasLegacyProperties (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'hasLegacyProperties' of 'Materials.Material' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MaterialPy*>(self)->hasLegacyProperties(args);
        if (ret != nullptr)
            static_cast<MaterialPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getPhysicalValue() callback and implementer
// PyObject*  MaterialPy::getPhysicalValue(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_getPhysicalValue (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getPhysicalValue' of 'Materials.Material' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MaterialPy*>(self)->getPhysicalValue(args);
        if (ret != nullptr)
            static_cast<MaterialPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setPhysicalValue() callback and implementer
// PyObject*  MaterialPy::setPhysicalValue(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_setPhysicalValue (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setPhysicalValue' of 'Materials.Material' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MaterialPy*>(self)->setPhysicalValue(args);
        if (ret != nullptr)
            static_cast<MaterialPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getAppearanceValue() callback and implementer
// PyObject*  MaterialPy::getAppearanceValue(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_getAppearanceValue (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getAppearanceValue' of 'Materials.Material' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MaterialPy*>(self)->getAppearanceValue(args);
        if (ret != nullptr)
            static_cast<MaterialPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setAppearanceValue() callback and implementer
// PyObject*  MaterialPy::setAppearanceValue(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_setAppearanceValue (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setAppearanceValue' of 'Materials.Material' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MaterialPy*>(self)->setAppearanceValue(args);
        if (ret != nullptr)
            static_cast<MaterialPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// LibraryName() callback and implementer
// PyObject*  MaterialPy::LibraryName(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_getLibraryName (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MaterialPy*>(self)->getLibraryName());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'LibraryName' of object 'Material'");
        return nullptr;
    }
}

int MaterialPy::staticCallback_setLibraryName (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'LibraryName' of object 'Material' is read-only");
    return -1;
}

// LibraryRoot() callback and implementer
// PyObject*  MaterialPy::LibraryRoot(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_getLibraryRoot (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MaterialPy*>(self)->getLibraryRoot());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'LibraryRoot' of object 'Material'");
        return nullptr;
    }
}

int MaterialPy::staticCallback_setLibraryRoot (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'LibraryRoot' of object 'Material' is read-only");
    return -1;
}

// LibraryIcon() callback and implementer
// PyObject*  MaterialPy::LibraryIcon(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_getLibraryIcon (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MaterialPy*>(self)->getLibraryIcon());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'LibraryIcon' of object 'Material'");
        return nullptr;
    }
}

int MaterialPy::staticCallback_setLibraryIcon (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'LibraryIcon' of object 'Material' is read-only");
    return -1;
}

// Name() callback and implementer
// PyObject*  MaterialPy::Name(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_getName (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MaterialPy*>(self)->getName());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Name' of object 'Material'");
        return nullptr;
    }
}

int MaterialPy::staticCallback_setName (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<MaterialPy*>(self)->setName(Py::String(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'Name' of object 'Material'");
        return -1;
    }
}

// Directory() callback and implementer
// PyObject*  MaterialPy::Directory(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_getDirectory (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MaterialPy*>(self)->getDirectory());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Directory' of object 'Material'");
        return nullptr;
    }
}

int MaterialPy::staticCallback_setDirectory (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Directory' of object 'Material' is read-only");
    return -1;
}

// UUID() callback and implementer
// PyObject*  MaterialPy::UUID(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_getUUID (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MaterialPy*>(self)->getUUID());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'UUID' of object 'Material'");
        return nullptr;
    }
}

int MaterialPy::staticCallback_setUUID (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'UUID' of object 'Material' is read-only");
    return -1;
}

// Description() callback and implementer
// PyObject*  MaterialPy::Description(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_getDescription (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MaterialPy*>(self)->getDescription());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Description' of object 'Material'");
        return nullptr;
    }
}

int MaterialPy::staticCallback_setDescription (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<MaterialPy*>(self)->setDescription(Py::String(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'Description' of object 'Material'");
        return -1;
    }
}

// URL() callback and implementer
// PyObject*  MaterialPy::URL(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_getURL (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MaterialPy*>(self)->getURL());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'URL' of object 'Material'");
        return nullptr;
    }
}

int MaterialPy::staticCallback_setURL (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<MaterialPy*>(self)->setURL(Py::String(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'URL' of object 'Material'");
        return -1;
    }
}

// Reference() callback and implementer
// PyObject*  MaterialPy::Reference(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_getReference (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MaterialPy*>(self)->getReference());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Reference' of object 'Material'");
        return nullptr;
    }
}

int MaterialPy::staticCallback_setReference (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<MaterialPy*>(self)->setReference(Py::String(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'Reference' of object 'Material'");
        return -1;
    }
}

// Parent() callback and implementer
// PyObject*  MaterialPy::Parent(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_getParent (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MaterialPy*>(self)->getParent());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Parent' of object 'Material'");
        return nullptr;
    }
}

int MaterialPy::staticCallback_setParent (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Parent' of object 'Material' is read-only");
    return -1;
}

// AuthorAndLicense() callback and implementer
// PyObject*  MaterialPy::AuthorAndLicense(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_getAuthorAndLicense (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MaterialPy*>(self)->getAuthorAndLicense());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'AuthorAndLicense' of object 'Material'");
        return nullptr;
    }
}

int MaterialPy::staticCallback_setAuthorAndLicense (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'AuthorAndLicense' of object 'Material' is read-only");
    return -1;
}

// Author() callback and implementer
// PyObject*  MaterialPy::Author(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_getAuthor (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MaterialPy*>(self)->getAuthor());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Author' of object 'Material'");
        return nullptr;
    }
}

int MaterialPy::staticCallback_setAuthor (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<MaterialPy*>(self)->setAuthor(Py::String(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'Author' of object 'Material'");
        return -1;
    }
}

// License() callback and implementer
// PyObject*  MaterialPy::License(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_getLicense (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MaterialPy*>(self)->getLicense());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'License' of object 'Material'");
        return nullptr;
    }
}

int MaterialPy::staticCallback_setLicense (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<MaterialPy*>(self)->setLicense(Py::String(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'License' of object 'Material'");
        return -1;
    }
}

// PhysicalModels() callback and implementer
// PyObject*  MaterialPy::PhysicalModels(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_getPhysicalModels (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MaterialPy*>(self)->getPhysicalModels());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'PhysicalModels' of object 'Material'");
        return nullptr;
    }
}

int MaterialPy::staticCallback_setPhysicalModels (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'PhysicalModels' of object 'Material' is read-only");
    return -1;
}

// AppearanceModels() callback and implementer
// PyObject*  MaterialPy::AppearanceModels(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_getAppearanceModels (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MaterialPy*>(self)->getAppearanceModels());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'AppearanceModels' of object 'Material'");
        return nullptr;
    }
}

int MaterialPy::staticCallback_setAppearanceModels (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'AppearanceModels' of object 'Material' is read-only");
    return -1;
}

// Tags() callback and implementer
// PyObject*  MaterialPy::Tags(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_getTags (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MaterialPy*>(self)->getTags());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Tags' of object 'Material'");
        return nullptr;
    }
}

int MaterialPy::staticCallback_setTags (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Tags' of object 'Material' is read-only");
    return -1;
}

// Properties() callback and implementer
// PyObject*  MaterialPy::Properties(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_getProperties (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MaterialPy*>(self)->getProperties());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Properties' of object 'Material'");
        return nullptr;
    }
}

int MaterialPy::staticCallback_setProperties (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Properties' of object 'Material' is read-only");
    return -1;
}

// PhysicalProperties() callback and implementer
// PyObject*  MaterialPy::PhysicalProperties(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_getPhysicalProperties (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MaterialPy*>(self)->getPhysicalProperties());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'PhysicalProperties' of object 'Material'");
        return nullptr;
    }
}

int MaterialPy::staticCallback_setPhysicalProperties (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'PhysicalProperties' of object 'Material' is read-only");
    return -1;
}

// AppearanceProperties() callback and implementer
// PyObject*  MaterialPy::AppearanceProperties(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_getAppearanceProperties (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MaterialPy*>(self)->getAppearanceProperties());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'AppearanceProperties' of object 'Material'");
        return nullptr;
    }
}

int MaterialPy::staticCallback_setAppearanceProperties (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'AppearanceProperties' of object 'Material' is read-only");
    return -1;
}

// LegacyProperties() callback and implementer
// PyObject*  MaterialPy::LegacyProperties(PyObject *args){};
// has to be implemented in MaterialPyImp.cpp
PyObject * MaterialPy::staticCallback_getLegacyProperties (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MaterialPy*>(self)->getLegacyProperties());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'LegacyProperties' of object 'Material'");
        return nullptr;
    }
}

int MaterialPy::staticCallback_setLegacyProperties (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'LegacyProperties' of object 'Material' is read-only");
    return -1;
}




//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
MaterialPy::MaterialPy(Material *pcObject, PyTypeObject *T)
    : BaseClassPy(static_cast<BaseClassPy::PointerType>(pcObject), T)
{
}


//--------------------------------------------------------------------------
// destructor
//--------------------------------------------------------------------------
MaterialPy::~MaterialPy()                                // Everything handled in parent
{
    // delete the handled object when the PyObject dies
    MaterialPy::PointerType ptr = static_cast<MaterialPy::PointerType>(_pcTwinPointer);
    delete ptr;
}

//--------------------------------------------------------------------------
// MaterialPy representation
//--------------------------------------------------------------------------
PyObject *MaterialPy::_repr()
{
    return Py_BuildValue("s", representation().c_str());
}

//--------------------------------------------------------------------------
// MaterialPy Attributes
//--------------------------------------------------------------------------
PyObject *MaterialPy::_getattr(const char *attr)			// __getattr__ function: note only need to handle new state
{
    try {
        // getter method for special Attributes (e.g. dynamic ones)
        PyObject *r = getCustomAttributes(attr);
        if(r) return r;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError,"Unknown C++ exception");
        return nullptr;
    }
#endif

    PyMethodDef *ml = Methods;
    for (; ml->ml_name != nullptr; ml++) {
        if (attr[0] == ml->ml_name[0] &&
            strcmp(attr+1, ml->ml_name+1) == 0)
            return PyCFunction_New(ml, this);
    }

    PyErr_Clear();
    return BaseClassPy::_getattr(attr);
}

int MaterialPy::_setattr(const char *attr, PyObject *value) // __setattr__ function: note only need to handle new state
{
    try {
        // setter for special Attributes (e.g. dynamic ones)
        int r = setCustomAttributes(attr, value);
        // r = 1: handled
        // r = -1: error
        // r = 0: ignore
        if (r == 1)
            return 0;
        else if (r == -1)
            return -1;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return -1;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return -1;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return -1;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return -1;
    }
#endif

    return BaseClassPy::_setattr(attr, value);
}

Material *MaterialPy::getMaterialPtr() const
{
    return static_cast<Material *>(_pcTwinPointer);
}

#if defined(__clang__)
# pragma clang diagnostic pop
#endif

#if 0
/* From here on come the methods you have to implement, but NOT in this module. Implement in MaterialPyImp.cpp! This prototypes
 * are just for convenience when you add a new method.
 */

PyObject *MaterialPy::PyMake(PyTypeObject* /*type*/, PyObject* /*args*/, PyObject* /*kwds*/)
{
    // create a new instance of MaterialPy and the Twin object
    return new MaterialPy(new Material);
}

// constructor method
int MaterialPy::PyInit(PyObject* /*args*/, PyObject* /*kwd*/)
{
    return 0;
}


// returns a string which represents the object e.g. when printed in python
std::string MaterialPy::representation() const
{
    return {"<Material object>"};
}

PyObject* MaterialPy::addPhysicalModel(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MaterialPy::removePhysicalModel(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MaterialPy::hasPhysicalModel(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MaterialPy::addAppearanceModel(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MaterialPy::removeAppearanceModel(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MaterialPy::hasAppearanceModel(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MaterialPy::isPhysicalModelComplete(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MaterialPy::isAppearanceModelComplete(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MaterialPy::hasPhysicalProperty(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MaterialPy::hasAppearanceProperty(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MaterialPy::hasLegacyProperties(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MaterialPy::getPhysicalValue(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MaterialPy::setPhysicalValue(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MaterialPy::getAppearanceValue(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MaterialPy::setAppearanceValue(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}



Py::String MaterialPy::getLibraryName() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

Py::String MaterialPy::getLibraryRoot() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

Py::String MaterialPy::getLibraryIcon() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

Py::String MaterialPy::getName() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

void  MaterialPy::setName(Py::String arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::String MaterialPy::getDirectory() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

Py::String MaterialPy::getUUID() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

Py::String MaterialPy::getDescription() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

void  MaterialPy::setDescription(Py::String arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::String MaterialPy::getURL() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

void  MaterialPy::setURL(Py::String arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::String MaterialPy::getReference() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

void  MaterialPy::setReference(Py::String arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::String MaterialPy::getParent() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

Py::String MaterialPy::getAuthorAndLicense() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

Py::String MaterialPy::getAuthor() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

void  MaterialPy::setAuthor(Py::String arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::String MaterialPy::getLicense() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

void  MaterialPy::setLicense(Py::String arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::List MaterialPy::getPhysicalModels() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::List MaterialPy::getAppearanceModels() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::List MaterialPy::getTags() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::Dict MaterialPy::getProperties() const
{
    //return Py::Dict();
    throw Py::AttributeError("Not yet implemented");
}

Py::Dict MaterialPy::getPhysicalProperties() const
{
    //return Py::Dict();
    throw Py::AttributeError("Not yet implemented");
}

Py::Dict MaterialPy::getAppearanceProperties() const
{
    //return Py::Dict();
    throw Py::AttributeError("Not yet implemented");
}

Py::Dict MaterialPy::getLegacyProperties() const
{
    //return Py::Dict();
    throw Py::AttributeError("Not yet implemented");
}

PyObject *MaterialPy::getCustomAttributes(const char* /*attr*/) const
{
    return nullptr;
}

int MaterialPy::setCustomAttributes(const char* /*attr*/, PyObject* /*obj*/)
{
    return 0;
}


#endif



