//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.10
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef ICEGRID_API_EXPORTS
#   define ICEGRID_API_EXPORTS
#endif
#include <IceGrid/Admin.h>
#include <IceUtil/PushDisableWarnings.h>
#include <Ice/LocalException.h>
#include <Ice/ValueFactory.h>
#include <Ice/OutgoingAsync.h>
#include <Ice/InputStream.h>
#include <Ice/OutputStream.h>
#include <Ice/LocalException.h>
#include <Ice/SlicedData.h>
#include <IceUtil/PopDisableWarnings.h>

#if defined(_MSC_VER)
#   pragma warning(disable:4458) // declaration of ... hides class member
#elif defined(__clang__)
#   pragma clang diagnostic ignored "-Wshadow"
#elif defined(__GNUC__)
#   pragma GCC diagnostic ignored "-Wshadow"
#endif

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 10
#       error Ice patch level mismatch!
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace
{

const ::std::string iceC_IceGrid_Admin_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::Admin"
};
const ::std::string iceC_IceGrid_Admin_ops[] =
{
    "addApplication",
    "addObject",
    "addObjectWithType",
    "enableServer",
    "getAdapterInfo",
    "getAllAdapterIds",
    "getAllApplicationNames",
    "getAllNodeNames",
    "getAllObjectInfos",
    "getAllRegistryNames",
    "getAllServerIds",
    "getApplicationInfo",
    "getDefaultApplicationDescriptor",
    "getNodeAdmin",
    "getNodeHostname",
    "getNodeInfo",
    "getNodeLoad",
    "getNodeProcessorSocketCount",
    "getObjectInfo",
    "getObjectInfosByType",
    "getRegistryAdmin",
    "getRegistryInfo",
    "getServerAdmin",
    "getServerAdminCategory",
    "getServerInfo",
    "getServerPid",
    "getServerState",
    "getSliceChecksums",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "instantiateServer",
    "isServerEnabled",
    "patchApplication",
    "patchServer",
    "pingNode",
    "pingRegistry",
    "removeAdapter",
    "removeApplication",
    "removeObject",
    "sendSignal",
    "shutdown",
    "shutdownNode",
    "shutdownRegistry",
    "startServer",
    "stopServer",
    "syncApplication",
    "syncApplicationWithoutRestart",
    "updateApplication",
    "updateApplicationWithoutRestart",
    "updateObject"
};
const ::std::string iceC_IceGrid_Admin_addApplication_name = "addApplication";
const ::std::string iceC_IceGrid_Admin_syncApplication_name = "syncApplication";
const ::std::string iceC_IceGrid_Admin_updateApplication_name = "updateApplication";
const ::std::string iceC_IceGrid_Admin_syncApplicationWithoutRestart_name = "syncApplicationWithoutRestart";
const ::std::string iceC_IceGrid_Admin_updateApplicationWithoutRestart_name = "updateApplicationWithoutRestart";
const ::std::string iceC_IceGrid_Admin_removeApplication_name = "removeApplication";
const ::std::string iceC_IceGrid_Admin_instantiateServer_name = "instantiateServer";
const ::std::string iceC_IceGrid_Admin_patchApplication_name = "patchApplication";
const ::std::string iceC_IceGrid_Admin_getApplicationInfo_name = "getApplicationInfo";
const ::std::string iceC_IceGrid_Admin_getDefaultApplicationDescriptor_name = "getDefaultApplicationDescriptor";
const ::std::string iceC_IceGrid_Admin_getAllApplicationNames_name = "getAllApplicationNames";
const ::std::string iceC_IceGrid_Admin_getServerInfo_name = "getServerInfo";
const ::std::string iceC_IceGrid_Admin_getServerState_name = "getServerState";
const ::std::string iceC_IceGrid_Admin_getServerPid_name = "getServerPid";
const ::std::string iceC_IceGrid_Admin_getServerAdminCategory_name = "getServerAdminCategory";
const ::std::string iceC_IceGrid_Admin_getServerAdmin_name = "getServerAdmin";
const ::std::string iceC_IceGrid_Admin_enableServer_name = "enableServer";
const ::std::string iceC_IceGrid_Admin_isServerEnabled_name = "isServerEnabled";
const ::std::string iceC_IceGrid_Admin_startServer_name = "startServer";
const ::std::string iceC_IceGrid_Admin_stopServer_name = "stopServer";
const ::std::string iceC_IceGrid_Admin_patchServer_name = "patchServer";
const ::std::string iceC_IceGrid_Admin_sendSignal_name = "sendSignal";
const ::std::string iceC_IceGrid_Admin_getAllServerIds_name = "getAllServerIds";
const ::std::string iceC_IceGrid_Admin_getAdapterInfo_name = "getAdapterInfo";
const ::std::string iceC_IceGrid_Admin_removeAdapter_name = "removeAdapter";
const ::std::string iceC_IceGrid_Admin_getAllAdapterIds_name = "getAllAdapterIds";
const ::std::string iceC_IceGrid_Admin_addObject_name = "addObject";
const ::std::string iceC_IceGrid_Admin_updateObject_name = "updateObject";
const ::std::string iceC_IceGrid_Admin_addObjectWithType_name = "addObjectWithType";
const ::std::string iceC_IceGrid_Admin_removeObject_name = "removeObject";
const ::std::string iceC_IceGrid_Admin_getObjectInfo_name = "getObjectInfo";
const ::std::string iceC_IceGrid_Admin_getObjectInfosByType_name = "getObjectInfosByType";
const ::std::string iceC_IceGrid_Admin_getAllObjectInfos_name = "getAllObjectInfos";
const ::std::string iceC_IceGrid_Admin_pingNode_name = "pingNode";
const ::std::string iceC_IceGrid_Admin_getNodeLoad_name = "getNodeLoad";
const ::std::string iceC_IceGrid_Admin_getNodeInfo_name = "getNodeInfo";
const ::std::string iceC_IceGrid_Admin_getNodeAdmin_name = "getNodeAdmin";
const ::std::string iceC_IceGrid_Admin_getNodeProcessorSocketCount_name = "getNodeProcessorSocketCount";
const ::std::string iceC_IceGrid_Admin_shutdownNode_name = "shutdownNode";
const ::std::string iceC_IceGrid_Admin_getNodeHostname_name = "getNodeHostname";
const ::std::string iceC_IceGrid_Admin_getAllNodeNames_name = "getAllNodeNames";
const ::std::string iceC_IceGrid_Admin_pingRegistry_name = "pingRegistry";
const ::std::string iceC_IceGrid_Admin_getRegistryInfo_name = "getRegistryInfo";
const ::std::string iceC_IceGrid_Admin_getRegistryAdmin_name = "getRegistryAdmin";
const ::std::string iceC_IceGrid_Admin_shutdownRegistry_name = "shutdownRegistry";
const ::std::string iceC_IceGrid_Admin_getAllRegistryNames_name = "getAllRegistryNames";
const ::std::string iceC_IceGrid_Admin_shutdown_name = "shutdown";
const ::std::string iceC_IceGrid_Admin_getSliceChecksums_name = "getSliceChecksums";

const ::std::string iceC_IceGrid_FileIterator_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::FileIterator"
};
const ::std::string iceC_IceGrid_FileIterator_ops[] =
{
    "destroy",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "read"
};
const ::std::string iceC_IceGrid_FileIterator_read_name = "read";
const ::std::string iceC_IceGrid_FileIterator_destroy_name = "destroy";

const ::std::string iceC_IceGrid_RegistryObserver_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::RegistryObserver"
};
const ::std::string iceC_IceGrid_RegistryObserver_ops[] =
{
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "registryDown",
    "registryInit",
    "registryUp"
};
const ::std::string iceC_IceGrid_RegistryObserver_registryInit_name = "registryInit";
const ::std::string iceC_IceGrid_RegistryObserver_registryUp_name = "registryUp";
const ::std::string iceC_IceGrid_RegistryObserver_registryDown_name = "registryDown";

const ::std::string iceC_IceGrid_NodeObserver_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::NodeObserver"
};
const ::std::string iceC_IceGrid_NodeObserver_ops[] =
{
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "nodeDown",
    "nodeInit",
    "nodeUp",
    "updateAdapter",
    "updateServer"
};
const ::std::string iceC_IceGrid_NodeObserver_nodeInit_name = "nodeInit";
const ::std::string iceC_IceGrid_NodeObserver_nodeUp_name = "nodeUp";
const ::std::string iceC_IceGrid_NodeObserver_nodeDown_name = "nodeDown";
const ::std::string iceC_IceGrid_NodeObserver_updateServer_name = "updateServer";
const ::std::string iceC_IceGrid_NodeObserver_updateAdapter_name = "updateAdapter";

const ::std::string iceC_IceGrid_ApplicationObserver_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::ApplicationObserver"
};
const ::std::string iceC_IceGrid_ApplicationObserver_ops[] =
{
    "applicationAdded",
    "applicationInit",
    "applicationRemoved",
    "applicationUpdated",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};
const ::std::string iceC_IceGrid_ApplicationObserver_applicationInit_name = "applicationInit";
const ::std::string iceC_IceGrid_ApplicationObserver_applicationAdded_name = "applicationAdded";
const ::std::string iceC_IceGrid_ApplicationObserver_applicationRemoved_name = "applicationRemoved";
const ::std::string iceC_IceGrid_ApplicationObserver_applicationUpdated_name = "applicationUpdated";

const ::std::string iceC_IceGrid_AdapterObserver_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::AdapterObserver"
};
const ::std::string iceC_IceGrid_AdapterObserver_ops[] =
{
    "adapterAdded",
    "adapterInit",
    "adapterRemoved",
    "adapterUpdated",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};
const ::std::string iceC_IceGrid_AdapterObserver_adapterInit_name = "adapterInit";
const ::std::string iceC_IceGrid_AdapterObserver_adapterAdded_name = "adapterAdded";
const ::std::string iceC_IceGrid_AdapterObserver_adapterUpdated_name = "adapterUpdated";
const ::std::string iceC_IceGrid_AdapterObserver_adapterRemoved_name = "adapterRemoved";

const ::std::string iceC_IceGrid_ObjectObserver_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::ObjectObserver"
};
const ::std::string iceC_IceGrid_ObjectObserver_ops[] =
{
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "objectAdded",
    "objectInit",
    "objectRemoved",
    "objectUpdated"
};
const ::std::string iceC_IceGrid_ObjectObserver_objectInit_name = "objectInit";
const ::std::string iceC_IceGrid_ObjectObserver_objectAdded_name = "objectAdded";
const ::std::string iceC_IceGrid_ObjectObserver_objectUpdated_name = "objectUpdated";
const ::std::string iceC_IceGrid_ObjectObserver_objectRemoved_name = "objectRemoved";

const ::std::string iceC_IceGrid_AdminSession_ids[3] =
{
    "::Glacier2::Session",
    "::Ice::Object",
    "::IceGrid::AdminSession"
};
const ::std::string iceC_IceGrid_AdminSession_ops[] =
{
    "destroy",
    "finishUpdate",
    "getAdmin",
    "getAdminCallbackTemplate",
    "getReplicaName",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "keepAlive",
    "openNodeStdErr",
    "openNodeStdOut",
    "openRegistryStdErr",
    "openRegistryStdOut",
    "openServerLog",
    "openServerStdErr",
    "openServerStdOut",
    "setObservers",
    "setObserversByIdentity",
    "startUpdate"
};
const ::std::string iceC_IceGrid_AdminSession_keepAlive_name = "keepAlive";
const ::std::string iceC_IceGrid_AdminSession_getAdmin_name = "getAdmin";
const ::std::string iceC_IceGrid_AdminSession_getAdminCallbackTemplate_name = "getAdminCallbackTemplate";
const ::std::string iceC_IceGrid_AdminSession_setObservers_name = "setObservers";
const ::std::string iceC_IceGrid_AdminSession_setObserversByIdentity_name = "setObserversByIdentity";
const ::std::string iceC_IceGrid_AdminSession_startUpdate_name = "startUpdate";
const ::std::string iceC_IceGrid_AdminSession_finishUpdate_name = "finishUpdate";
const ::std::string iceC_IceGrid_AdminSession_getReplicaName_name = "getReplicaName";
const ::std::string iceC_IceGrid_AdminSession_openServerLog_name = "openServerLog";
const ::std::string iceC_IceGrid_AdminSession_openServerStdErr_name = "openServerStdErr";
const ::std::string iceC_IceGrid_AdminSession_openServerStdOut_name = "openServerStdOut";
const ::std::string iceC_IceGrid_AdminSession_openNodeStdErr_name = "openNodeStdErr";
const ::std::string iceC_IceGrid_AdminSession_openNodeStdOut_name = "openNodeStdOut";
const ::std::string iceC_IceGrid_AdminSession_openRegistryStdErr_name = "openRegistryStdErr";
const ::std::string iceC_IceGrid_AdminSession_openRegistryStdOut_name = "openRegistryStdOut";

}

bool
IceGrid::Admin::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_Admin_ids, iceC_IceGrid_Admin_ids + 2, s);
}

::std::vector<::std::string>
IceGrid::Admin::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceGrid_Admin_ids[0], &iceC_IceGrid_Admin_ids[2]);
}

::std::string
IceGrid::Admin::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::Admin::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::Admin";
    return typeId;
}

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_addApplication(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ApplicationDescriptor iceP_descriptor;
    istr->readAll(iceP_descriptor);
    istr->readPendingValues();
    inS.endReadParams();
    this->addApplication(::std::move(iceP_descriptor), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_syncApplication(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ApplicationDescriptor iceP_descriptor;
    istr->readAll(iceP_descriptor);
    istr->readPendingValues();
    inS.endReadParams();
    this->syncApplication(::std::move(iceP_descriptor), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_updateApplication(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ApplicationUpdateDescriptor iceP_descriptor;
    istr->readAll(iceP_descriptor);
    istr->readPendingValues();
    inS.endReadParams();
    this->updateApplication(::std::move(iceP_descriptor), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_syncApplicationWithoutRestart(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ApplicationDescriptor iceP_descriptor;
    istr->readAll(iceP_descriptor);
    istr->readPendingValues();
    inS.endReadParams();
    this->syncApplicationWithoutRestart(::std::move(iceP_descriptor), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_updateApplicationWithoutRestart(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ApplicationUpdateDescriptor iceP_descriptor;
    istr->readAll(iceP_descriptor);
    istr->readPendingValues();
    inS.endReadParams();
    this->updateApplicationWithoutRestart(::std::move(iceP_descriptor), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_removeApplication(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->readAll(iceP_name);
    inS.endReadParams();
    this->removeApplication(::std::move(iceP_name), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_instantiateServer(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_application;
    ::std::string iceP_node;
    ServerInstanceDescriptor iceP_desc;
    istr->readAll(iceP_application, iceP_node, iceP_desc);
    inS.endReadParams();
    this->instantiateServer(::std::move(iceP_application), ::std::move(iceP_node), ::std::move(iceP_desc), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_patchApplication(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    bool iceP_shutdown;
    istr->readAll(iceP_name, iceP_shutdown);
    inS.endReadParams();
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    this->patchApplicationAsync(::std::move(iceP_name), iceP_shutdown, inA->response(), inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getApplicationInfo(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->readAll(iceP_name);
    inS.endReadParams();
    ApplicationInfo ret = this->getApplicationInfo(::std::move(iceP_name), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    ostr->writePendingValues();
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getDefaultApplicationDescriptor(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ApplicationDescriptor ret = this->getDefaultApplicationDescriptor(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    ostr->writePendingValues();
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getAllApplicationNames(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::StringSeq ret = this->getAllApplicationNames(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getServerInfo(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_id;
    istr->readAll(iceP_id);
    inS.endReadParams();
    ServerInfo ret = this->getServerInfo(::std::move(iceP_id), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    ostr->writePendingValues();
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getServerState(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_id;
    istr->readAll(iceP_id);
    inS.endReadParams();
    ServerState ret = this->getServerState(::std::move(iceP_id), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getServerPid(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_id;
    istr->readAll(iceP_id);
    inS.endReadParams();
    int ret = this->getServerPid(::std::move(iceP_id), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getServerAdminCategory(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::std::string ret = this->getServerAdminCategory(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getServerAdmin(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_id;
    istr->readAll(iceP_id);
    inS.endReadParams();
    ::std::shared_ptr<::Ice::ObjectPrx> ret = this->getServerAdmin(::std::move(iceP_id), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_enableServer(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_id;
    bool iceP_enabled;
    istr->readAll(iceP_id, iceP_enabled);
    inS.endReadParams();
    this->enableServer(::std::move(iceP_id), iceP_enabled, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_isServerEnabled(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_id;
    istr->readAll(iceP_id);
    inS.endReadParams();
    bool ret = this->isServerEnabled(::std::move(iceP_id), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_startServer(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_id;
    istr->readAll(iceP_id);
    inS.endReadParams();
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    this->startServerAsync(::std::move(iceP_id), inA->response(), inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_stopServer(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_id;
    istr->readAll(iceP_id);
    inS.endReadParams();
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    this->stopServerAsync(::std::move(iceP_id), inA->response(), inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_patchServer(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_id;
    bool iceP_shutdown;
    istr->readAll(iceP_id, iceP_shutdown);
    inS.endReadParams();
    auto inA = ::IceInternal::IncomingAsync::create(inS);
    this->patchServerAsync(::std::move(iceP_id), iceP_shutdown, inA->response(), inA->exception(), current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_sendSignal(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_id;
    ::std::string iceP_signal;
    istr->readAll(iceP_id, iceP_signal);
    inS.endReadParams();
    this->sendSignal(::std::move(iceP_id), ::std::move(iceP_signal), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getAllServerIds(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::StringSeq ret = this->getAllServerIds(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getAdapterInfo(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_id;
    istr->readAll(iceP_id);
    inS.endReadParams();
    AdapterInfoSeq ret = this->getAdapterInfo(::std::move(iceP_id), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_removeAdapter(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_id;
    istr->readAll(iceP_id);
    inS.endReadParams();
    this->removeAdapter(::std::move(iceP_id), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getAllAdapterIds(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::StringSeq ret = this->getAllAdapterIds(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_addObject(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::shared_ptr<::Ice::ObjectPrx> iceP_obj;
    istr->readAll(iceP_obj);
    inS.endReadParams();
    this->addObject(::std::move(iceP_obj), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_updateObject(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::shared_ptr<::Ice::ObjectPrx> iceP_obj;
    istr->readAll(iceP_obj);
    inS.endReadParams();
    this->updateObject(::std::move(iceP_obj), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_addObjectWithType(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::shared_ptr<::Ice::ObjectPrx> iceP_obj;
    ::std::string iceP_type;
    istr->readAll(iceP_obj, iceP_type);
    inS.endReadParams();
    this->addObjectWithType(::std::move(iceP_obj), ::std::move(iceP_type), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_removeObject(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::Ice::Identity iceP_id;
    istr->readAll(iceP_id);
    inS.endReadParams();
    this->removeObject(::std::move(iceP_id), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getObjectInfo(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::Ice::Identity iceP_id;
    istr->readAll(iceP_id);
    inS.endReadParams();
    ObjectInfo ret = this->getObjectInfo(::std::move(iceP_id), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getObjectInfosByType(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_type;
    istr->readAll(iceP_type);
    inS.endReadParams();
    ObjectInfoSeq ret = this->getObjectInfosByType(::std::move(iceP_type), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getAllObjectInfos(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_expr;
    istr->readAll(iceP_expr);
    inS.endReadParams();
    ObjectInfoSeq ret = this->getAllObjectInfos(::std::move(iceP_expr), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_pingNode(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->readAll(iceP_name);
    inS.endReadParams();
    bool ret = this->pingNode(::std::move(iceP_name), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getNodeLoad(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->readAll(iceP_name);
    inS.endReadParams();
    LoadInfo ret = this->getNodeLoad(::std::move(iceP_name), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getNodeInfo(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->readAll(iceP_name);
    inS.endReadParams();
    NodeInfo ret = this->getNodeInfo(::std::move(iceP_name), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getNodeAdmin(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->readAll(iceP_name);
    inS.endReadParams();
    ::std::shared_ptr<::Ice::ObjectPrx> ret = this->getNodeAdmin(::std::move(iceP_name), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getNodeProcessorSocketCount(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->readAll(iceP_name);
    inS.endReadParams();
    int ret = this->getNodeProcessorSocketCount(::std::move(iceP_name), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_shutdownNode(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->readAll(iceP_name);
    inS.endReadParams();
    this->shutdownNode(::std::move(iceP_name), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getNodeHostname(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->readAll(iceP_name);
    inS.endReadParams();
    ::std::string ret = this->getNodeHostname(::std::move(iceP_name), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getAllNodeNames(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::StringSeq ret = this->getAllNodeNames(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_pingRegistry(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->readAll(iceP_name);
    inS.endReadParams();
    bool ret = this->pingRegistry(::std::move(iceP_name), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getRegistryInfo(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->readAll(iceP_name);
    inS.endReadParams();
    RegistryInfo ret = this->getRegistryInfo(::std::move(iceP_name), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getRegistryAdmin(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->readAll(iceP_name);
    inS.endReadParams();
    ::std::shared_ptr<::Ice::ObjectPrx> ret = this->getRegistryAdmin(::std::move(iceP_name), current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_shutdownRegistry(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->readAll(iceP_name);
    inS.endReadParams();
    this->shutdownRegistry(::std::move(iceP_name), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getAllRegistryNames(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::StringSeq ret = this->getAllRegistryNames(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_shutdown(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    this->shutdown(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getSliceChecksums(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::SliceChecksumDict ret = this->getSliceChecksums(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_Admin_ops, iceC_IceGrid_Admin_ops + 52, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_Admin_ops)
    {
        case 0:
        {
            return _iceD_addApplication(in, current);
        }
        case 1:
        {
            return _iceD_addObject(in, current);
        }
        case 2:
        {
            return _iceD_addObjectWithType(in, current);
        }
        case 3:
        {
            return _iceD_enableServer(in, current);
        }
        case 4:
        {
            return _iceD_getAdapterInfo(in, current);
        }
        case 5:
        {
            return _iceD_getAllAdapterIds(in, current);
        }
        case 6:
        {
            return _iceD_getAllApplicationNames(in, current);
        }
        case 7:
        {
            return _iceD_getAllNodeNames(in, current);
        }
        case 8:
        {
            return _iceD_getAllObjectInfos(in, current);
        }
        case 9:
        {
            return _iceD_getAllRegistryNames(in, current);
        }
        case 10:
        {
            return _iceD_getAllServerIds(in, current);
        }
        case 11:
        {
            return _iceD_getApplicationInfo(in, current);
        }
        case 12:
        {
            return _iceD_getDefaultApplicationDescriptor(in, current);
        }
        case 13:
        {
            return _iceD_getNodeAdmin(in, current);
        }
        case 14:
        {
            return _iceD_getNodeHostname(in, current);
        }
        case 15:
        {
            return _iceD_getNodeInfo(in, current);
        }
        case 16:
        {
            return _iceD_getNodeLoad(in, current);
        }
        case 17:
        {
            return _iceD_getNodeProcessorSocketCount(in, current);
        }
        case 18:
        {
            return _iceD_getObjectInfo(in, current);
        }
        case 19:
        {
            return _iceD_getObjectInfosByType(in, current);
        }
        case 20:
        {
            return _iceD_getRegistryAdmin(in, current);
        }
        case 21:
        {
            return _iceD_getRegistryInfo(in, current);
        }
        case 22:
        {
            return _iceD_getServerAdmin(in, current);
        }
        case 23:
        {
            return _iceD_getServerAdminCategory(in, current);
        }
        case 24:
        {
            return _iceD_getServerInfo(in, current);
        }
        case 25:
        {
            return _iceD_getServerPid(in, current);
        }
        case 26:
        {
            return _iceD_getServerState(in, current);
        }
        case 27:
        {
            return _iceD_getSliceChecksums(in, current);
        }
        case 28:
        {
            return _iceD_ice_id(in, current);
        }
        case 29:
        {
            return _iceD_ice_ids(in, current);
        }
        case 30:
        {
            return _iceD_ice_isA(in, current);
        }
        case 31:
        {
            return _iceD_ice_ping(in, current);
        }
        case 32:
        {
            return _iceD_instantiateServer(in, current);
        }
        case 33:
        {
            return _iceD_isServerEnabled(in, current);
        }
        case 34:
        {
            return _iceD_patchApplication(in, current);
        }
        case 35:
        {
            return _iceD_patchServer(in, current);
        }
        case 36:
        {
            return _iceD_pingNode(in, current);
        }
        case 37:
        {
            return _iceD_pingRegistry(in, current);
        }
        case 38:
        {
            return _iceD_removeAdapter(in, current);
        }
        case 39:
        {
            return _iceD_removeApplication(in, current);
        }
        case 40:
        {
            return _iceD_removeObject(in, current);
        }
        case 41:
        {
            return _iceD_sendSignal(in, current);
        }
        case 42:
        {
            return _iceD_shutdown(in, current);
        }
        case 43:
        {
            return _iceD_shutdownNode(in, current);
        }
        case 44:
        {
            return _iceD_shutdownRegistry(in, current);
        }
        case 45:
        {
            return _iceD_startServer(in, current);
        }
        case 46:
        {
            return _iceD_stopServer(in, current);
        }
        case 47:
        {
            return _iceD_syncApplication(in, current);
        }
        case 48:
        {
            return _iceD_syncApplicationWithoutRestart(in, current);
        }
        case 49:
        {
            return _iceD_updateApplication(in, current);
        }
        case 50:
        {
            return _iceD_updateApplicationWithoutRestart(in, current);
        }
        case 51:
        {
            return _iceD_updateObject(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
IceGrid::FileIterator::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_FileIterator_ids, iceC_IceGrid_FileIterator_ids + 2, s);
}

::std::vector<::std::string>
IceGrid::FileIterator::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceGrid_FileIterator_ids[0], &iceC_IceGrid_FileIterator_ids[2]);
}

::std::string
IceGrid::FileIterator::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::FileIterator::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::FileIterator";
    return typeId;
}

/// \cond INTERNAL
bool
IceGrid::FileIterator::_iceD_read(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    int iceP_size;
    istr->readAll(iceP_size);
    inS.endReadParams();
    ::Ice::StringSeq iceP_lines;
    bool ret = this->read(iceP_size, iceP_lines, current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(iceP_lines, ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::FileIterator::_iceD_destroy(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    this->destroy(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::FileIterator::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_FileIterator_ops, iceC_IceGrid_FileIterator_ops + 6, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_FileIterator_ops)
    {
        case 0:
        {
            return _iceD_destroy(in, current);
        }
        case 1:
        {
            return _iceD_ice_id(in, current);
        }
        case 2:
        {
            return _iceD_ice_ids(in, current);
        }
        case 3:
        {
            return _iceD_ice_isA(in, current);
        }
        case 4:
        {
            return _iceD_ice_ping(in, current);
        }
        case 5:
        {
            return _iceD_read(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
IceGrid::RegistryObserver::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_RegistryObserver_ids, iceC_IceGrid_RegistryObserver_ids + 2, s);
}

::std::vector<::std::string>
IceGrid::RegistryObserver::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceGrid_RegistryObserver_ids[0], &iceC_IceGrid_RegistryObserver_ids[2]);
}

::std::string
IceGrid::RegistryObserver::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::RegistryObserver::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::RegistryObserver";
    return typeId;
}

/// \cond INTERNAL
bool
IceGrid::RegistryObserver::_iceD_registryInit(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    RegistryInfoSeq iceP_registries;
    istr->readAll(iceP_registries);
    inS.endReadParams();
    this->registryInit(::std::move(iceP_registries), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::RegistryObserver::_iceD_registryUp(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    RegistryInfo iceP_node;
    istr->readAll(iceP_node);
    inS.endReadParams();
    this->registryUp(::std::move(iceP_node), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::RegistryObserver::_iceD_registryDown(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->readAll(iceP_name);
    inS.endReadParams();
    this->registryDown(::std::move(iceP_name), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::RegistryObserver::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_RegistryObserver_ops, iceC_IceGrid_RegistryObserver_ops + 7, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_RegistryObserver_ops)
    {
        case 0:
        {
            return _iceD_ice_id(in, current);
        }
        case 1:
        {
            return _iceD_ice_ids(in, current);
        }
        case 2:
        {
            return _iceD_ice_isA(in, current);
        }
        case 3:
        {
            return _iceD_ice_ping(in, current);
        }
        case 4:
        {
            return _iceD_registryDown(in, current);
        }
        case 5:
        {
            return _iceD_registryInit(in, current);
        }
        case 6:
        {
            return _iceD_registryUp(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
IceGrid::NodeObserver::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_NodeObserver_ids, iceC_IceGrid_NodeObserver_ids + 2, s);
}

::std::vector<::std::string>
IceGrid::NodeObserver::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceGrid_NodeObserver_ids[0], &iceC_IceGrid_NodeObserver_ids[2]);
}

::std::string
IceGrid::NodeObserver::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::NodeObserver::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::NodeObserver";
    return typeId;
}

/// \cond INTERNAL
bool
IceGrid::NodeObserver::_iceD_nodeInit(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    NodeDynamicInfoSeq iceP_nodes;
    istr->readAll(iceP_nodes);
    inS.endReadParams();
    this->nodeInit(::std::move(iceP_nodes), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeObserver::_iceD_nodeUp(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    NodeDynamicInfo iceP_node;
    istr->readAll(iceP_node);
    inS.endReadParams();
    this->nodeUp(::std::move(iceP_node), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeObserver::_iceD_nodeDown(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->readAll(iceP_name);
    inS.endReadParams();
    this->nodeDown(::std::move(iceP_name), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeObserver::_iceD_updateServer(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_node;
    ServerDynamicInfo iceP_updatedInfo;
    istr->readAll(iceP_node, iceP_updatedInfo);
    inS.endReadParams();
    this->updateServer(::std::move(iceP_node), ::std::move(iceP_updatedInfo), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeObserver::_iceD_updateAdapter(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_node;
    AdapterDynamicInfo iceP_updatedInfo;
    istr->readAll(iceP_node, iceP_updatedInfo);
    inS.endReadParams();
    this->updateAdapter(::std::move(iceP_node), ::std::move(iceP_updatedInfo), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeObserver::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_NodeObserver_ops, iceC_IceGrid_NodeObserver_ops + 9, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_NodeObserver_ops)
    {
        case 0:
        {
            return _iceD_ice_id(in, current);
        }
        case 1:
        {
            return _iceD_ice_ids(in, current);
        }
        case 2:
        {
            return _iceD_ice_isA(in, current);
        }
        case 3:
        {
            return _iceD_ice_ping(in, current);
        }
        case 4:
        {
            return _iceD_nodeDown(in, current);
        }
        case 5:
        {
            return _iceD_nodeInit(in, current);
        }
        case 6:
        {
            return _iceD_nodeUp(in, current);
        }
        case 7:
        {
            return _iceD_updateAdapter(in, current);
        }
        case 8:
        {
            return _iceD_updateServer(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
IceGrid::ApplicationObserver::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_ApplicationObserver_ids, iceC_IceGrid_ApplicationObserver_ids + 2, s);
}

::std::vector<::std::string>
IceGrid::ApplicationObserver::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceGrid_ApplicationObserver_ids[0], &iceC_IceGrid_ApplicationObserver_ids[2]);
}

::std::string
IceGrid::ApplicationObserver::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::ApplicationObserver::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::ApplicationObserver";
    return typeId;
}

/// \cond INTERNAL
bool
IceGrid::ApplicationObserver::_iceD_applicationInit(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    int iceP_serial;
    ApplicationInfoSeq iceP_applications;
    istr->readAll(iceP_serial, iceP_applications);
    istr->readPendingValues();
    inS.endReadParams();
    this->applicationInit(iceP_serial, ::std::move(iceP_applications), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ApplicationObserver::_iceD_applicationAdded(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    int iceP_serial;
    ApplicationInfo iceP_desc;
    istr->readAll(iceP_serial, iceP_desc);
    istr->readPendingValues();
    inS.endReadParams();
    this->applicationAdded(iceP_serial, ::std::move(iceP_desc), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ApplicationObserver::_iceD_applicationRemoved(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    int iceP_serial;
    ::std::string iceP_name;
    istr->readAll(iceP_serial, iceP_name);
    inS.endReadParams();
    this->applicationRemoved(iceP_serial, ::std::move(iceP_name), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ApplicationObserver::_iceD_applicationUpdated(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    int iceP_serial;
    ApplicationUpdateInfo iceP_desc;
    istr->readAll(iceP_serial, iceP_desc);
    istr->readPendingValues();
    inS.endReadParams();
    this->applicationUpdated(iceP_serial, ::std::move(iceP_desc), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ApplicationObserver::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_ApplicationObserver_ops, iceC_IceGrid_ApplicationObserver_ops + 8, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_ApplicationObserver_ops)
    {
        case 0:
        {
            return _iceD_applicationAdded(in, current);
        }
        case 1:
        {
            return _iceD_applicationInit(in, current);
        }
        case 2:
        {
            return _iceD_applicationRemoved(in, current);
        }
        case 3:
        {
            return _iceD_applicationUpdated(in, current);
        }
        case 4:
        {
            return _iceD_ice_id(in, current);
        }
        case 5:
        {
            return _iceD_ice_ids(in, current);
        }
        case 6:
        {
            return _iceD_ice_isA(in, current);
        }
        case 7:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
IceGrid::AdapterObserver::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_AdapterObserver_ids, iceC_IceGrid_AdapterObserver_ids + 2, s);
}

::std::vector<::std::string>
IceGrid::AdapterObserver::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceGrid_AdapterObserver_ids[0], &iceC_IceGrid_AdapterObserver_ids[2]);
}

::std::string
IceGrid::AdapterObserver::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::AdapterObserver::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::AdapterObserver";
    return typeId;
}

/// \cond INTERNAL
bool
IceGrid::AdapterObserver::_iceD_adapterInit(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    AdapterInfoSeq iceP_adpts;
    istr->readAll(iceP_adpts);
    inS.endReadParams();
    this->adapterInit(::std::move(iceP_adpts), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdapterObserver::_iceD_adapterAdded(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    AdapterInfo iceP_info;
    istr->readAll(iceP_info);
    inS.endReadParams();
    this->adapterAdded(::std::move(iceP_info), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdapterObserver::_iceD_adapterUpdated(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    AdapterInfo iceP_info;
    istr->readAll(iceP_info);
    inS.endReadParams();
    this->adapterUpdated(::std::move(iceP_info), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdapterObserver::_iceD_adapterRemoved(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_id;
    istr->readAll(iceP_id);
    inS.endReadParams();
    this->adapterRemoved(::std::move(iceP_id), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdapterObserver::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_AdapterObserver_ops, iceC_IceGrid_AdapterObserver_ops + 8, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_AdapterObserver_ops)
    {
        case 0:
        {
            return _iceD_adapterAdded(in, current);
        }
        case 1:
        {
            return _iceD_adapterInit(in, current);
        }
        case 2:
        {
            return _iceD_adapterRemoved(in, current);
        }
        case 3:
        {
            return _iceD_adapterUpdated(in, current);
        }
        case 4:
        {
            return _iceD_ice_id(in, current);
        }
        case 5:
        {
            return _iceD_ice_ids(in, current);
        }
        case 6:
        {
            return _iceD_ice_isA(in, current);
        }
        case 7:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
IceGrid::ObjectObserver::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_ObjectObserver_ids, iceC_IceGrid_ObjectObserver_ids + 2, s);
}

::std::vector<::std::string>
IceGrid::ObjectObserver::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceGrid_ObjectObserver_ids[0], &iceC_IceGrid_ObjectObserver_ids[2]);
}

::std::string
IceGrid::ObjectObserver::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::ObjectObserver::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::ObjectObserver";
    return typeId;
}

/// \cond INTERNAL
bool
IceGrid::ObjectObserver::_iceD_objectInit(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ObjectInfoSeq iceP_objects;
    istr->readAll(iceP_objects);
    inS.endReadParams();
    this->objectInit(::std::move(iceP_objects), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ObjectObserver::_iceD_objectAdded(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ObjectInfo iceP_info;
    istr->readAll(iceP_info);
    inS.endReadParams();
    this->objectAdded(::std::move(iceP_info), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ObjectObserver::_iceD_objectUpdated(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ObjectInfo iceP_info;
    istr->readAll(iceP_info);
    inS.endReadParams();
    this->objectUpdated(::std::move(iceP_info), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ObjectObserver::_iceD_objectRemoved(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::Ice::Identity iceP_id;
    istr->readAll(iceP_id);
    inS.endReadParams();
    this->objectRemoved(::std::move(iceP_id), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ObjectObserver::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_ObjectObserver_ops, iceC_IceGrid_ObjectObserver_ops + 8, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_ObjectObserver_ops)
    {
        case 0:
        {
            return _iceD_ice_id(in, current);
        }
        case 1:
        {
            return _iceD_ice_ids(in, current);
        }
        case 2:
        {
            return _iceD_ice_isA(in, current);
        }
        case 3:
        {
            return _iceD_ice_ping(in, current);
        }
        case 4:
        {
            return _iceD_objectAdded(in, current);
        }
        case 5:
        {
            return _iceD_objectInit(in, current);
        }
        case 6:
        {
            return _iceD_objectRemoved(in, current);
        }
        case 7:
        {
            return _iceD_objectUpdated(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
IceGrid::AdminSession::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_AdminSession_ids, iceC_IceGrid_AdminSession_ids + 3, s);
}

::std::vector<::std::string>
IceGrid::AdminSession::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceGrid_AdminSession_ids[0], &iceC_IceGrid_AdminSession_ids[3]);
}

::std::string
IceGrid::AdminSession::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::AdminSession::ice_staticId()
{
    static const ::std::string typeId = "::IceGrid::AdminSession";
    return typeId;
}

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_keepAlive(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    this->keepAlive(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_getAdmin(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::std::shared_ptr<AdminPrx> ret = this->getAdmin(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_getAdminCallbackTemplate(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::std::shared_ptr<::Ice::ObjectPrx> ret = this->getAdminCallbackTemplate(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_setObservers(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::std::shared_ptr<RegistryObserverPrx> iceP_registryObs;
    ::std::shared_ptr<NodeObserverPrx> iceP_nodeObs;
    ::std::shared_ptr<ApplicationObserverPrx> iceP_appObs;
    ::std::shared_ptr<AdapterObserverPrx> iceP_adptObs;
    ::std::shared_ptr<ObjectObserverPrx> iceP_objObs;
    istr->readAll(iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs);
    inS.endReadParams();
    this->setObservers(::std::move(iceP_registryObs), ::std::move(iceP_nodeObs), ::std::move(iceP_appObs), ::std::move(iceP_adptObs), ::std::move(iceP_objObs), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_setObserversByIdentity(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    auto istr = inS.startReadParams();
    ::Ice::Identity iceP_registryObs;
    ::Ice::Identity iceP_nodeObs;
    ::Ice::Identity iceP_appObs;
    ::Ice::Identity iceP_adptObs;
    ::Ice::Identity iceP_objObs;
    istr->readAll(iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs);
    inS.endReadParams();
    this->setObserversByIdentity(::std::move(iceP_registryObs), ::std::move(iceP_nodeObs), ::std::move(iceP_appObs), ::std::move(iceP_adptObs), ::std::move(iceP_objObs), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_startUpdate(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    int ret = this->startUpdate(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_finishUpdate(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    inS.readEmptyParams();
    this->finishUpdate(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_getReplicaName(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::std::string ret = this->getReplicaName(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_openServerLog(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_id;
    ::std::string iceP_path;
    int iceP_count;
    istr->readAll(iceP_id, iceP_path, iceP_count);
    inS.endReadParams();
    ::std::shared_ptr<FileIteratorPrx> ret = this->openServerLog(::std::move(iceP_id), ::std::move(iceP_path), iceP_count, current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_openServerStdErr(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_id;
    int iceP_count;
    istr->readAll(iceP_id, iceP_count);
    inS.endReadParams();
    ::std::shared_ptr<FileIteratorPrx> ret = this->openServerStdErr(::std::move(iceP_id), iceP_count, current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_openServerStdOut(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_id;
    int iceP_count;
    istr->readAll(iceP_id, iceP_count);
    inS.endReadParams();
    ::std::shared_ptr<FileIteratorPrx> ret = this->openServerStdOut(::std::move(iceP_id), iceP_count, current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_openNodeStdErr(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    int iceP_count;
    istr->readAll(iceP_name, iceP_count);
    inS.endReadParams();
    ::std::shared_ptr<FileIteratorPrx> ret = this->openNodeStdErr(::std::move(iceP_name), iceP_count, current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_openNodeStdOut(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    int iceP_count;
    istr->readAll(iceP_name, iceP_count);
    inS.endReadParams();
    ::std::shared_ptr<FileIteratorPrx> ret = this->openNodeStdOut(::std::move(iceP_name), iceP_count, current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_openRegistryStdErr(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    int iceP_count;
    istr->readAll(iceP_name, iceP_count);
    inS.endReadParams();
    ::std::shared_ptr<FileIteratorPrx> ret = this->openRegistryStdErr(::std::move(iceP_name), iceP_count, current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_openRegistryStdOut(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::std::string iceP_name;
    int iceP_count;
    istr->readAll(iceP_name, iceP_count);
    inS.endReadParams();
    ::std::shared_ptr<FileIteratorPrx> ret = this->openRegistryStdOut(::std::move(iceP_name), iceP_count, current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_AdminSession_ops, iceC_IceGrid_AdminSession_ops + 20, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_AdminSession_ops)
    {
        case 0:
        {
            return _iceD_destroy(in, current);
        }
        case 1:
        {
            return _iceD_finishUpdate(in, current);
        }
        case 2:
        {
            return _iceD_getAdmin(in, current);
        }
        case 3:
        {
            return _iceD_getAdminCallbackTemplate(in, current);
        }
        case 4:
        {
            return _iceD_getReplicaName(in, current);
        }
        case 5:
        {
            return _iceD_ice_id(in, current);
        }
        case 6:
        {
            return _iceD_ice_ids(in, current);
        }
        case 7:
        {
            return _iceD_ice_isA(in, current);
        }
        case 8:
        {
            return _iceD_ice_ping(in, current);
        }
        case 9:
        {
            return _iceD_keepAlive(in, current);
        }
        case 10:
        {
            return _iceD_openNodeStdErr(in, current);
        }
        case 11:
        {
            return _iceD_openNodeStdOut(in, current);
        }
        case 12:
        {
            return _iceD_openRegistryStdErr(in, current);
        }
        case 13:
        {
            return _iceD_openRegistryStdOut(in, current);
        }
        case 14:
        {
            return _iceD_openServerLog(in, current);
        }
        case 15:
        {
            return _iceD_openServerStdErr(in, current);
        }
        case 16:
        {
            return _iceD_openServerStdOut(in, current);
        }
        case 17:
        {
            return _iceD_setObservers(in, current);
        }
        case 18:
        {
            return _iceD_setObserversByIdentity(in, current);
        }
        case 19:
        {
            return _iceD_startUpdate(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_addApplication(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_addApplication_name);
    outAsync->invoke(iceC_IceGrid_Admin_addApplication_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_descriptor);
            ostr->writePendingValues();
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const AccessDeniedException&)
            {
                throw;
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_syncApplication(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_syncApplication_name);
    outAsync->invoke(iceC_IceGrid_Admin_syncApplication_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_descriptor);
            ostr->writePendingValues();
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const AccessDeniedException&)
            {
                throw;
            }
            catch(const ApplicationNotExistException&)
            {
                throw;
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_updateApplication(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ApplicationUpdateDescriptor& iceP_descriptor, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_updateApplication_name);
    outAsync->invoke(iceC_IceGrid_Admin_updateApplication_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_descriptor);
            ostr->writePendingValues();
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const AccessDeniedException&)
            {
                throw;
            }
            catch(const ApplicationNotExistException&)
            {
                throw;
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_syncApplicationWithoutRestart(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_syncApplicationWithoutRestart_name);
    outAsync->invoke(iceC_IceGrid_Admin_syncApplicationWithoutRestart_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_descriptor);
            ostr->writePendingValues();
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const AccessDeniedException&)
            {
                throw;
            }
            catch(const ApplicationNotExistException&)
            {
                throw;
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_updateApplicationWithoutRestart(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ApplicationUpdateDescriptor& iceP_descriptor, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_updateApplicationWithoutRestart_name);
    outAsync->invoke(iceC_IceGrid_Admin_updateApplicationWithoutRestart_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_descriptor);
            ostr->writePendingValues();
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const AccessDeniedException&)
            {
                throw;
            }
            catch(const ApplicationNotExistException&)
            {
                throw;
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_removeApplication(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_name, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_removeApplication_name);
    outAsync->invoke(iceC_IceGrid_Admin_removeApplication_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const AccessDeniedException&)
            {
                throw;
            }
            catch(const ApplicationNotExistException&)
            {
                throw;
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_instantiateServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_application, const ::std::string& iceP_node, const ServerInstanceDescriptor& iceP_desc, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_instantiateServer_name);
    outAsync->invoke(iceC_IceGrid_Admin_instantiateServer_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_application, iceP_node, iceP_desc);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const AccessDeniedException&)
            {
                throw;
            }
            catch(const ApplicationNotExistException&)
            {
                throw;
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_patchApplication(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_name, bool iceP_shutdown, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_patchApplication_name);
    outAsync->invoke(iceC_IceGrid_Admin_patchApplication_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name, iceP_shutdown);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const ApplicationNotExistException&)
            {
                throw;
            }
            catch(const PatchException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getApplicationInfo(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ApplicationInfo>>& outAsync, const ::std::string& iceP_name, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getApplicationInfo_name);
    outAsync->invoke(iceC_IceGrid_Admin_getApplicationInfo_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const ApplicationNotExistException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        },
        [](::Ice::InputStream* istr)
        {
            ApplicationInfo ret;
            istr->readAll(ret);
            istr->readPendingValues();
            return ret;
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getDefaultApplicationDescriptor(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ApplicationDescriptor>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getDefaultApplicationDescriptor_name);
    outAsync->invoke(iceC_IceGrid_Admin_getDefaultApplicationDescriptor_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        },
        [](::Ice::InputStream* istr)
        {
            ApplicationDescriptor ret;
            istr->readAll(ret);
            istr->readPendingValues();
            return ret;
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getAllApplicationNames(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::StringSeq>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getAllApplicationNames_name);
    outAsync->invoke(iceC_IceGrid_Admin_getAllApplicationNames_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getServerInfo(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ServerInfo>>& outAsync, const ::std::string& iceP_id, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getServerInfo_name);
    outAsync->invoke(iceC_IceGrid_Admin_getServerInfo_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_id);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const ServerNotExistException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        },
        [](::Ice::InputStream* istr)
        {
            ServerInfo ret;
            istr->readAll(ret);
            istr->readPendingValues();
            return ret;
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getServerState(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ServerState>>& outAsync, const ::std::string& iceP_id, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getServerState_name);
    outAsync->invoke(iceC_IceGrid_Admin_getServerState_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_id);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const NodeUnreachableException&)
            {
                throw;
            }
            catch(const ServerNotExistException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getServerPid(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>& outAsync, const ::std::string& iceP_id, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getServerPid_name);
    outAsync->invoke(iceC_IceGrid_Admin_getServerPid_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_id);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const NodeUnreachableException&)
            {
                throw;
            }
            catch(const ServerNotExistException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getServerAdminCategory(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getServerAdminCategory_name);
    outAsync->invoke(iceC_IceGrid_Admin_getServerAdminCategory_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getServerAdmin(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>& outAsync, const ::std::string& iceP_id, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getServerAdmin_name);
    outAsync->invoke(iceC_IceGrid_Admin_getServerAdmin_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_id);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const NodeUnreachableException&)
            {
                throw;
            }
            catch(const ServerNotExistException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_enableServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_id, bool iceP_enabled, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_enableServer_name);
    outAsync->invoke(iceC_IceGrid_Admin_enableServer_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_id, iceP_enabled);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const NodeUnreachableException&)
            {
                throw;
            }
            catch(const ServerNotExistException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_isServerEnabled(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<bool>>& outAsync, const ::std::string& iceP_id, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_isServerEnabled_name);
    outAsync->invoke(iceC_IceGrid_Admin_isServerEnabled_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_id);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const NodeUnreachableException&)
            {
                throw;
            }
            catch(const ServerNotExistException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_startServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_id, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_startServer_name);
    outAsync->invoke(iceC_IceGrid_Admin_startServer_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_id);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const NodeUnreachableException&)
            {
                throw;
            }
            catch(const ServerNotExistException&)
            {
                throw;
            }
            catch(const ServerStartException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_stopServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_id, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_stopServer_name);
    outAsync->invoke(iceC_IceGrid_Admin_stopServer_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_id);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const NodeUnreachableException&)
            {
                throw;
            }
            catch(const ServerNotExistException&)
            {
                throw;
            }
            catch(const ServerStopException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_patchServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_id, bool iceP_shutdown, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_patchServer_name);
    outAsync->invoke(iceC_IceGrid_Admin_patchServer_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_id, iceP_shutdown);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const NodeUnreachableException&)
            {
                throw;
            }
            catch(const PatchException&)
            {
                throw;
            }
            catch(const ServerNotExistException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_sendSignal(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_id, const ::std::string& iceP_signal, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_sendSignal_name);
    outAsync->invoke(iceC_IceGrid_Admin_sendSignal_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_id, iceP_signal);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const BadSignalException&)
            {
                throw;
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const NodeUnreachableException&)
            {
                throw;
            }
            catch(const ServerNotExistException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getAllServerIds(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::StringSeq>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getAllServerIds_name);
    outAsync->invoke(iceC_IceGrid_Admin_getAllServerIds_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getAdapterInfo(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::AdapterInfoSeq>>& outAsync, const ::std::string& iceP_id, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getAdapterInfo_name);
    outAsync->invoke(iceC_IceGrid_Admin_getAdapterInfo_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_id);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const AdapterNotExistException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_removeAdapter(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_id, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_removeAdapter_name);
    outAsync->invoke(iceC_IceGrid_Admin_removeAdapter_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_id);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const AdapterNotExistException&)
            {
                throw;
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getAllAdapterIds(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::StringSeq>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getAllAdapterIds_name);
    outAsync->invoke(iceC_IceGrid_Admin_getAllAdapterIds_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_addObject(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_obj, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_addObject_name);
    outAsync->invoke(iceC_IceGrid_Admin_addObject_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_obj);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const ObjectExistsException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_updateObject(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_obj, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_updateObject_name);
    outAsync->invoke(iceC_IceGrid_Admin_updateObject_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_obj);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const ObjectNotRegisteredException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_addObjectWithType(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_obj, const ::std::string& iceP_type, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_addObjectWithType_name);
    outAsync->invoke(iceC_IceGrid_Admin_addObjectWithType_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_obj, iceP_type);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const ObjectExistsException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_removeObject(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::Identity& iceP_id, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_removeObject_name);
    outAsync->invoke(iceC_IceGrid_Admin_removeObject_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_id);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const ObjectNotRegisteredException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getObjectInfo(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ObjectInfo>>& outAsync, const ::Ice::Identity& iceP_id, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getObjectInfo_name);
    outAsync->invoke(iceC_IceGrid_Admin_getObjectInfo_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_id);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const ObjectNotRegisteredException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getObjectInfosByType(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ObjectInfoSeq>>& outAsync, const ::std::string& iceP_type, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getObjectInfosByType_name);
    outAsync->invoke(iceC_IceGrid_Admin_getObjectInfosByType_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_type);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getAllObjectInfos(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ObjectInfoSeq>>& outAsync, const ::std::string& iceP_expr, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getAllObjectInfos_name);
    outAsync->invoke(iceC_IceGrid_Admin_getAllObjectInfos_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_expr);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_pingNode(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<bool>>& outAsync, const ::std::string& iceP_name, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_pingNode_name);
    outAsync->invoke(iceC_IceGrid_Admin_pingNode_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const NodeNotExistException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getNodeLoad(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::LoadInfo>>& outAsync, const ::std::string& iceP_name, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getNodeLoad_name);
    outAsync->invoke(iceC_IceGrid_Admin_getNodeLoad_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const NodeNotExistException&)
            {
                throw;
            }
            catch(const NodeUnreachableException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getNodeInfo(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::NodeInfo>>& outAsync, const ::std::string& iceP_name, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getNodeInfo_name);
    outAsync->invoke(iceC_IceGrid_Admin_getNodeInfo_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const NodeNotExistException&)
            {
                throw;
            }
            catch(const NodeUnreachableException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getNodeAdmin(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>& outAsync, const ::std::string& iceP_name, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getNodeAdmin_name);
    outAsync->invoke(iceC_IceGrid_Admin_getNodeAdmin_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const NodeNotExistException&)
            {
                throw;
            }
            catch(const NodeUnreachableException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getNodeProcessorSocketCount(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>& outAsync, const ::std::string& iceP_name, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getNodeProcessorSocketCount_name);
    outAsync->invoke(iceC_IceGrid_Admin_getNodeProcessorSocketCount_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const NodeNotExistException&)
            {
                throw;
            }
            catch(const NodeUnreachableException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_shutdownNode(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_name, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_shutdownNode_name);
    outAsync->invoke(iceC_IceGrid_Admin_shutdownNode_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const NodeNotExistException&)
            {
                throw;
            }
            catch(const NodeUnreachableException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getNodeHostname(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>& outAsync, const ::std::string& iceP_name, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getNodeHostname_name);
    outAsync->invoke(iceC_IceGrid_Admin_getNodeHostname_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const NodeNotExistException&)
            {
                throw;
            }
            catch(const NodeUnreachableException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getAllNodeNames(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::StringSeq>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getAllNodeNames_name);
    outAsync->invoke(iceC_IceGrid_Admin_getAllNodeNames_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_pingRegistry(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<bool>>& outAsync, const ::std::string& iceP_name, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_pingRegistry_name);
    outAsync->invoke(iceC_IceGrid_Admin_pingRegistry_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const RegistryNotExistException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getRegistryInfo(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::RegistryInfo>>& outAsync, const ::std::string& iceP_name, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getRegistryInfo_name);
    outAsync->invoke(iceC_IceGrid_Admin_getRegistryInfo_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const RegistryNotExistException&)
            {
                throw;
            }
            catch(const RegistryUnreachableException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getRegistryAdmin(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>& outAsync, const ::std::string& iceP_name, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getRegistryAdmin_name);
    outAsync->invoke(iceC_IceGrid_Admin_getRegistryAdmin_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const RegistryNotExistException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_shutdownRegistry(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_name, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_shutdownRegistry_name);
    outAsync->invoke(iceC_IceGrid_Admin_shutdownRegistry_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const RegistryNotExistException&)
            {
                throw;
            }
            catch(const RegistryUnreachableException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getAllRegistryNames(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::StringSeq>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getAllRegistryNames_name);
    outAsync->invoke(iceC_IceGrid_Admin_getAllRegistryNames_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_shutdown(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_Admin_shutdown_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminPrx::_iceI_getSliceChecksums(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::SliceChecksumDict>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getSliceChecksums_name);
    outAsync->invoke(iceC_IceGrid_Admin_getSliceChecksums_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceGrid::AdminPrx::_newInstance() const
{
    return ::IceInternal::createProxy<AdminPrx>();
}
/// \endcond

const ::std::string&
IceGrid::AdminPrx::ice_staticId()
{
    return Admin::ice_staticId();
}

/// \cond INTERNAL
void
IceGrid::FileIteratorPrx::_iceI_read(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<FileIterator::ReadResult>>& outAsync, int iceP_size, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_FileIterator_read_name);
    outAsync->invoke(iceC_IceGrid_FileIterator_read_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_size);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const FileNotAvailableException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        },
        [](::Ice::InputStream* istr)
        {
            FileIterator::ReadResult v;
            istr->readAll(v.lines, v.returnValue);
            return v;
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::FileIteratorPrx::_iceI_destroy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_FileIterator_destroy_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceGrid::FileIteratorPrx::_newInstance() const
{
    return ::IceInternal::createProxy<FileIteratorPrx>();
}
/// \endcond

const ::std::string&
IceGrid::FileIteratorPrx::ice_staticId()
{
    return FileIterator::ice_staticId();
}

/// \cond INTERNAL
void
IceGrid::RegistryObserverPrx::_iceI_registryInit(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const RegistryInfoSeq& iceP_registries, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_RegistryObserver_registryInit_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_registries);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::RegistryObserverPrx::_iceI_registryUp(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const RegistryInfo& iceP_node, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_RegistryObserver_registryUp_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_node);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::RegistryObserverPrx::_iceI_registryDown(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_name, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_RegistryObserver_registryDown_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceGrid::RegistryObserverPrx::_newInstance() const
{
    return ::IceInternal::createProxy<RegistryObserverPrx>();
}
/// \endcond

const ::std::string&
IceGrid::RegistryObserverPrx::ice_staticId()
{
    return RegistryObserver::ice_staticId();
}

/// \cond INTERNAL
void
IceGrid::NodeObserverPrx::_iceI_nodeInit(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const NodeDynamicInfoSeq& iceP_nodes, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_NodeObserver_nodeInit_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_nodes);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::NodeObserverPrx::_iceI_nodeUp(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const NodeDynamicInfo& iceP_node, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_NodeObserver_nodeUp_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_node);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::NodeObserverPrx::_iceI_nodeDown(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_name, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_NodeObserver_nodeDown_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::NodeObserverPrx::_iceI_updateServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_node, const ServerDynamicInfo& iceP_updatedInfo, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_NodeObserver_updateServer_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_node, iceP_updatedInfo);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::NodeObserverPrx::_iceI_updateAdapter(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_node, const AdapterDynamicInfo& iceP_updatedInfo, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_NodeObserver_updateAdapter_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_node, iceP_updatedInfo);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceGrid::NodeObserverPrx::_newInstance() const
{
    return ::IceInternal::createProxy<NodeObserverPrx>();
}
/// \endcond

const ::std::string&
IceGrid::NodeObserverPrx::ice_staticId()
{
    return NodeObserver::ice_staticId();
}

/// \cond INTERNAL
void
IceGrid::ApplicationObserverPrx::_iceI_applicationInit(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, int iceP_serial, const ApplicationInfoSeq& iceP_applications, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_ApplicationObserver_applicationInit_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_serial, iceP_applications);
            ostr->writePendingValues();
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ApplicationObserverPrx::_iceI_applicationAdded(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, int iceP_serial, const ApplicationInfo& iceP_desc, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_ApplicationObserver_applicationAdded_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_serial, iceP_desc);
            ostr->writePendingValues();
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ApplicationObserverPrx::_iceI_applicationRemoved(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, int iceP_serial, const ::std::string& iceP_name, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_ApplicationObserver_applicationRemoved_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_serial, iceP_name);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ApplicationObserverPrx::_iceI_applicationUpdated(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, int iceP_serial, const ApplicationUpdateInfo& iceP_desc, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_ApplicationObserver_applicationUpdated_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_serial, iceP_desc);
            ostr->writePendingValues();
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceGrid::ApplicationObserverPrx::_newInstance() const
{
    return ::IceInternal::createProxy<ApplicationObserverPrx>();
}
/// \endcond

const ::std::string&
IceGrid::ApplicationObserverPrx::ice_staticId()
{
    return ApplicationObserver::ice_staticId();
}

/// \cond INTERNAL
void
IceGrid::AdapterObserverPrx::_iceI_adapterInit(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const AdapterInfoSeq& iceP_adpts, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_AdapterObserver_adapterInit_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_adpts);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdapterObserverPrx::_iceI_adapterAdded(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const AdapterInfo& iceP_info, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_AdapterObserver_adapterAdded_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_info);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdapterObserverPrx::_iceI_adapterUpdated(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const AdapterInfo& iceP_info, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_AdapterObserver_adapterUpdated_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_info);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdapterObserverPrx::_iceI_adapterRemoved(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::string& iceP_id, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_AdapterObserver_adapterRemoved_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_id);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceGrid::AdapterObserverPrx::_newInstance() const
{
    return ::IceInternal::createProxy<AdapterObserverPrx>();
}
/// \endcond

const ::std::string&
IceGrid::AdapterObserverPrx::ice_staticId()
{
    return AdapterObserver::ice_staticId();
}

/// \cond INTERNAL
void
IceGrid::ObjectObserverPrx::_iceI_objectInit(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ObjectInfoSeq& iceP_objects, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_ObjectObserver_objectInit_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_objects);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ObjectObserverPrx::_iceI_objectAdded(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ObjectInfo& iceP_info, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_ObjectObserver_objectAdded_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_info);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ObjectObserverPrx::_iceI_objectUpdated(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ObjectInfo& iceP_info, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_ObjectObserver_objectUpdated_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_info);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::ObjectObserverPrx::_iceI_objectRemoved(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::Identity& iceP_id, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_ObjectObserver_objectRemoved_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_id);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceGrid::ObjectObserverPrx::_newInstance() const
{
    return ::IceInternal::createProxy<ObjectObserverPrx>();
}
/// \endcond

const ::std::string&
IceGrid::ObjectObserverPrx::ice_staticId()
{
    return ObjectObserver::ice_staticId();
}

/// \cond INTERNAL
void
IceGrid::AdminSessionPrx::_iceI_keepAlive(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceGrid_AdminSession_keepAlive_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminSessionPrx::_iceI_getAdmin(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::AdminPrx>>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_getAdmin_name);
    outAsync->invoke(iceC_IceGrid_AdminSession_getAdmin_name, ::Ice::OperationMode::Nonmutating, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminSessionPrx::_iceI_getAdminCallbackTemplate(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_getAdminCallbackTemplate_name);
    outAsync->invoke(iceC_IceGrid_AdminSession_getAdminCallbackTemplate_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminSessionPrx::_iceI_setObservers(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::std::shared_ptr<RegistryObserverPrx>& iceP_registryObs, const ::std::shared_ptr<NodeObserverPrx>& iceP_nodeObs, const ::std::shared_ptr<ApplicationObserverPrx>& iceP_appObs, const ::std::shared_ptr<AdapterObserverPrx>& iceP_adptObs, const ::std::shared_ptr<ObjectObserverPrx>& iceP_objObs, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_setObservers_name);
    outAsync->invoke(iceC_IceGrid_AdminSession_setObservers_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const ObserverAlreadyRegisteredException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminSessionPrx::_iceI_setObserversByIdentity(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::Identity& iceP_registryObs, const ::Ice::Identity& iceP_nodeObs, const ::Ice::Identity& iceP_appObs, const ::Ice::Identity& iceP_adptObs, const ::Ice::Identity& iceP_objObs, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_setObserversByIdentity_name);
    outAsync->invoke(iceC_IceGrid_AdminSession_setObserversByIdentity_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const ObserverAlreadyRegisteredException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminSessionPrx::_iceI_startUpdate(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_startUpdate_name);
    outAsync->invoke(iceC_IceGrid_AdminSession_startUpdate_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const AccessDeniedException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminSessionPrx::_iceI_finishUpdate(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_finishUpdate_name);
    outAsync->invoke(iceC_IceGrid_AdminSession_finishUpdate_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const AccessDeniedException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminSessionPrx::_iceI_getReplicaName(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_getReplicaName_name);
    outAsync->invoke(iceC_IceGrid_AdminSession_getReplicaName_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminSessionPrx::_iceI_openServerLog(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>& outAsync, const ::std::string& iceP_id, const ::std::string& iceP_path, int iceP_count, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_openServerLog_name);
    outAsync->invoke(iceC_IceGrid_AdminSession_openServerLog_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_id, iceP_path, iceP_count);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const FileNotAvailableException&)
            {
                throw;
            }
            catch(const NodeUnreachableException&)
            {
                throw;
            }
            catch(const ServerNotExistException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminSessionPrx::_iceI_openServerStdErr(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>& outAsync, const ::std::string& iceP_id, int iceP_count, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_openServerStdErr_name);
    outAsync->invoke(iceC_IceGrid_AdminSession_openServerStdErr_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_id, iceP_count);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const FileNotAvailableException&)
            {
                throw;
            }
            catch(const NodeUnreachableException&)
            {
                throw;
            }
            catch(const ServerNotExistException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminSessionPrx::_iceI_openServerStdOut(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>& outAsync, const ::std::string& iceP_id, int iceP_count, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_openServerStdOut_name);
    outAsync->invoke(iceC_IceGrid_AdminSession_openServerStdOut_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_id, iceP_count);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const DeploymentException&)
            {
                throw;
            }
            catch(const FileNotAvailableException&)
            {
                throw;
            }
            catch(const NodeUnreachableException&)
            {
                throw;
            }
            catch(const ServerNotExistException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminSessionPrx::_iceI_openNodeStdErr(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>& outAsync, const ::std::string& iceP_name, int iceP_count, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_openNodeStdErr_name);
    outAsync->invoke(iceC_IceGrid_AdminSession_openNodeStdErr_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name, iceP_count);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const FileNotAvailableException&)
            {
                throw;
            }
            catch(const NodeNotExistException&)
            {
                throw;
            }
            catch(const NodeUnreachableException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminSessionPrx::_iceI_openNodeStdOut(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>& outAsync, const ::std::string& iceP_name, int iceP_count, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_openNodeStdOut_name);
    outAsync->invoke(iceC_IceGrid_AdminSession_openNodeStdOut_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name, iceP_count);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const FileNotAvailableException&)
            {
                throw;
            }
            catch(const NodeNotExistException&)
            {
                throw;
            }
            catch(const NodeUnreachableException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminSessionPrx::_iceI_openRegistryStdErr(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>& outAsync, const ::std::string& iceP_name, int iceP_count, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_openRegistryStdErr_name);
    outAsync->invoke(iceC_IceGrid_AdminSession_openRegistryStdErr_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name, iceP_count);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const FileNotAvailableException&)
            {
                throw;
            }
            catch(const RegistryNotExistException&)
            {
                throw;
            }
            catch(const RegistryUnreachableException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::AdminSessionPrx::_iceI_openRegistryStdOut(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>& outAsync, const ::std::string& iceP_name, int iceP_count, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_openRegistryStdOut_name);
    outAsync->invoke(iceC_IceGrid_AdminSession_openRegistryStdOut_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_name, iceP_count);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const FileNotAvailableException&)
            {
                throw;
            }
            catch(const RegistryNotExistException&)
            {
                throw;
            }
            catch(const RegistryUnreachableException&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceGrid::AdminSessionPrx::_newInstance() const
{
    return ::IceInternal::createProxy<AdminSessionPrx>();
}
/// \endcond

const ::std::string&
IceGrid::AdminSessionPrx::ice_staticId()
{
    return AdminSession::ice_staticId();
}

namespace Ice
{
}

#else // C++98 mapping

namespace
{

const ::std::string iceC_IceGrid_Admin_addApplication_name = "addApplication";

const ::std::string iceC_IceGrid_Admin_syncApplication_name = "syncApplication";

const ::std::string iceC_IceGrid_Admin_updateApplication_name = "updateApplication";

const ::std::string iceC_IceGrid_Admin_syncApplicationWithoutRestart_name = "syncApplicationWithoutRestart";

const ::std::string iceC_IceGrid_Admin_updateApplicationWithoutRestart_name = "updateApplicationWithoutRestart";

const ::std::string iceC_IceGrid_Admin_removeApplication_name = "removeApplication";

const ::std::string iceC_IceGrid_Admin_instantiateServer_name = "instantiateServer";

const ::std::string iceC_IceGrid_Admin_patchApplication_name = "patchApplication";

const ::std::string iceC_IceGrid_Admin_getApplicationInfo_name = "getApplicationInfo";

const ::std::string iceC_IceGrid_Admin_getDefaultApplicationDescriptor_name = "getDefaultApplicationDescriptor";

const ::std::string iceC_IceGrid_Admin_getAllApplicationNames_name = "getAllApplicationNames";

const ::std::string iceC_IceGrid_Admin_getServerInfo_name = "getServerInfo";

const ::std::string iceC_IceGrid_Admin_getServerState_name = "getServerState";

const ::std::string iceC_IceGrid_Admin_getServerPid_name = "getServerPid";

const ::std::string iceC_IceGrid_Admin_getServerAdminCategory_name = "getServerAdminCategory";

const ::std::string iceC_IceGrid_Admin_getServerAdmin_name = "getServerAdmin";

const ::std::string iceC_IceGrid_Admin_enableServer_name = "enableServer";

const ::std::string iceC_IceGrid_Admin_isServerEnabled_name = "isServerEnabled";

const ::std::string iceC_IceGrid_Admin_startServer_name = "startServer";

const ::std::string iceC_IceGrid_Admin_stopServer_name = "stopServer";

const ::std::string iceC_IceGrid_Admin_patchServer_name = "patchServer";

const ::std::string iceC_IceGrid_Admin_sendSignal_name = "sendSignal";

const ::std::string iceC_IceGrid_Admin_getAllServerIds_name = "getAllServerIds";

const ::std::string iceC_IceGrid_Admin_getAdapterInfo_name = "getAdapterInfo";

const ::std::string iceC_IceGrid_Admin_removeAdapter_name = "removeAdapter";

const ::std::string iceC_IceGrid_Admin_getAllAdapterIds_name = "getAllAdapterIds";

const ::std::string iceC_IceGrid_Admin_addObject_name = "addObject";

const ::std::string iceC_IceGrid_Admin_updateObject_name = "updateObject";

const ::std::string iceC_IceGrid_Admin_addObjectWithType_name = "addObjectWithType";

const ::std::string iceC_IceGrid_Admin_removeObject_name = "removeObject";

const ::std::string iceC_IceGrid_Admin_getObjectInfo_name = "getObjectInfo";

const ::std::string iceC_IceGrid_Admin_getObjectInfosByType_name = "getObjectInfosByType";

const ::std::string iceC_IceGrid_Admin_getAllObjectInfos_name = "getAllObjectInfos";

const ::std::string iceC_IceGrid_Admin_pingNode_name = "pingNode";

const ::std::string iceC_IceGrid_Admin_getNodeLoad_name = "getNodeLoad";

const ::std::string iceC_IceGrid_Admin_getNodeInfo_name = "getNodeInfo";

const ::std::string iceC_IceGrid_Admin_getNodeAdmin_name = "getNodeAdmin";

const ::std::string iceC_IceGrid_Admin_getNodeProcessorSocketCount_name = "getNodeProcessorSocketCount";

const ::std::string iceC_IceGrid_Admin_shutdownNode_name = "shutdownNode";

const ::std::string iceC_IceGrid_Admin_getNodeHostname_name = "getNodeHostname";

const ::std::string iceC_IceGrid_Admin_getAllNodeNames_name = "getAllNodeNames";

const ::std::string iceC_IceGrid_Admin_pingRegistry_name = "pingRegistry";

const ::std::string iceC_IceGrid_Admin_getRegistryInfo_name = "getRegistryInfo";

const ::std::string iceC_IceGrid_Admin_getRegistryAdmin_name = "getRegistryAdmin";

const ::std::string iceC_IceGrid_Admin_shutdownRegistry_name = "shutdownRegistry";

const ::std::string iceC_IceGrid_Admin_getAllRegistryNames_name = "getAllRegistryNames";

const ::std::string iceC_IceGrid_Admin_shutdown_name = "shutdown";

const ::std::string iceC_IceGrid_Admin_getSliceChecksums_name = "getSliceChecksums";

const ::std::string iceC_IceGrid_FileIterator_read_name = "read";

const ::std::string iceC_IceGrid_FileIterator_destroy_name = "destroy";

const ::std::string iceC_IceGrid_RegistryObserver_registryInit_name = "registryInit";

const ::std::string iceC_IceGrid_RegistryObserver_registryUp_name = "registryUp";

const ::std::string iceC_IceGrid_RegistryObserver_registryDown_name = "registryDown";

const ::std::string iceC_IceGrid_NodeObserver_nodeInit_name = "nodeInit";

const ::std::string iceC_IceGrid_NodeObserver_nodeUp_name = "nodeUp";

const ::std::string iceC_IceGrid_NodeObserver_nodeDown_name = "nodeDown";

const ::std::string iceC_IceGrid_NodeObserver_updateServer_name = "updateServer";

const ::std::string iceC_IceGrid_NodeObserver_updateAdapter_name = "updateAdapter";

const ::std::string iceC_IceGrid_ApplicationObserver_applicationInit_name = "applicationInit";

const ::std::string iceC_IceGrid_ApplicationObserver_applicationAdded_name = "applicationAdded";

const ::std::string iceC_IceGrid_ApplicationObserver_applicationRemoved_name = "applicationRemoved";

const ::std::string iceC_IceGrid_ApplicationObserver_applicationUpdated_name = "applicationUpdated";

const ::std::string iceC_IceGrid_AdapterObserver_adapterInit_name = "adapterInit";

const ::std::string iceC_IceGrid_AdapterObserver_adapterAdded_name = "adapterAdded";

const ::std::string iceC_IceGrid_AdapterObserver_adapterUpdated_name = "adapterUpdated";

const ::std::string iceC_IceGrid_AdapterObserver_adapterRemoved_name = "adapterRemoved";

const ::std::string iceC_IceGrid_ObjectObserver_objectInit_name = "objectInit";

const ::std::string iceC_IceGrid_ObjectObserver_objectAdded_name = "objectAdded";

const ::std::string iceC_IceGrid_ObjectObserver_objectUpdated_name = "objectUpdated";

const ::std::string iceC_IceGrid_ObjectObserver_objectRemoved_name = "objectRemoved";

const ::std::string iceC_IceGrid_AdminSession_keepAlive_name = "keepAlive";

const ::std::string iceC_IceGrid_AdminSession_getAdmin_name = "getAdmin";

const ::std::string iceC_IceGrid_AdminSession_getAdminCallbackTemplate_name = "getAdminCallbackTemplate";

const ::std::string iceC_IceGrid_AdminSession_setObservers_name = "setObservers";

const ::std::string iceC_IceGrid_AdminSession_setObserversByIdentity_name = "setObserversByIdentity";

const ::std::string iceC_IceGrid_AdminSession_startUpdate_name = "startUpdate";

const ::std::string iceC_IceGrid_AdminSession_finishUpdate_name = "finishUpdate";

const ::std::string iceC_IceGrid_AdminSession_getReplicaName_name = "getReplicaName";

const ::std::string iceC_IceGrid_AdminSession_openServerLog_name = "openServerLog";

const ::std::string iceC_IceGrid_AdminSession_openServerStdErr_name = "openServerStdErr";

const ::std::string iceC_IceGrid_AdminSession_openServerStdOut_name = "openServerStdOut";

const ::std::string iceC_IceGrid_AdminSession_openNodeStdErr_name = "openNodeStdErr";

const ::std::string iceC_IceGrid_AdminSession_openNodeStdOut_name = "openNodeStdOut";

const ::std::string iceC_IceGrid_AdminSession_openRegistryStdErr_name = "openRegistryStdErr";

const ::std::string iceC_IceGrid_AdminSession_openRegistryStdOut_name = "openRegistryStdOut";

}

IceGrid::AMD_Admin_patchApplication::~AMD_Admin_patchApplication()
{
}

IceGrid::AMD_Admin_startServer::~AMD_Admin_startServer()
{
}

IceGrid::AMD_Admin_stopServer::~AMD_Admin_stopServer()
{
}

IceGrid::AMD_Admin_patchServer::~AMD_Admin_patchServer()
{
}

/// \cond INTERNAL
IceAsync::IceGrid::AMD_Admin_patchApplication::AMD_Admin_patchApplication(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::IceGrid::AMD_Admin_patchApplication::ice_response()
{
    writeEmptyParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
IceAsync::IceGrid::AMD_Admin_startServer::AMD_Admin_startServer(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::IceGrid::AMD_Admin_startServer::ice_response()
{
    writeEmptyParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
IceAsync::IceGrid::AMD_Admin_stopServer::AMD_Admin_stopServer(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::IceGrid::AMD_Admin_stopServer::ice_response()
{
    writeEmptyParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
IceAsync::IceGrid::AMD_Admin_patchServer::AMD_Admin_patchServer(::IceInternal::Incoming& in) :
    ::IceInternal::IncomingAsync(in)
{
}

void
IceAsync::IceGrid::AMD_Admin_patchServer::ice_response()
{
    writeEmptyParams();
    completed();
}
/// \endcond

/// \cond INTERNAL
ICEGRID_API ::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(Admin* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< Admin>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new Admin;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_addApplication(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_addApplication_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_addApplication_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_addApplication_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_descriptor);
        ostr->writePendingValues();
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_addApplication_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Admin::end_addApplication(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_addApplication_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::AccessDeniedException&)
        {
            throw;
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_syncApplication(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_syncApplication_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_syncApplication_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_syncApplication_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_descriptor);
        ostr->writePendingValues();
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_syncApplication_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Admin::end_syncApplication(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_syncApplication_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::AccessDeniedException&)
        {
            throw;
        }
        catch(const ::IceGrid::ApplicationNotExistException&)
        {
            throw;
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_updateApplication(const ::IceGrid::ApplicationUpdateDescriptor& iceP_descriptor, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_updateApplication_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_updateApplication_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_updateApplication_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_descriptor);
        ostr->writePendingValues();
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_updateApplication_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Admin::end_updateApplication(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_updateApplication_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::AccessDeniedException&)
        {
            throw;
        }
        catch(const ::IceGrid::ApplicationNotExistException&)
        {
            throw;
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_syncApplicationWithoutRestart(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_syncApplicationWithoutRestart_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_syncApplicationWithoutRestart_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_syncApplicationWithoutRestart_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_descriptor);
        ostr->writePendingValues();
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_syncApplicationWithoutRestart_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Admin::end_syncApplicationWithoutRestart(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_syncApplicationWithoutRestart_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::AccessDeniedException&)
        {
            throw;
        }
        catch(const ::IceGrid::ApplicationNotExistException&)
        {
            throw;
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_updateApplicationWithoutRestart(const ::IceGrid::ApplicationUpdateDescriptor& iceP_descriptor, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_updateApplicationWithoutRestart_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_updateApplicationWithoutRestart_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_updateApplicationWithoutRestart_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_descriptor);
        ostr->writePendingValues();
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_updateApplicationWithoutRestart_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Admin::end_updateApplicationWithoutRestart(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_updateApplicationWithoutRestart_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::AccessDeniedException&)
        {
            throw;
        }
        catch(const ::IceGrid::ApplicationNotExistException&)
        {
            throw;
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_removeApplication(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_removeApplication_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_removeApplication_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_removeApplication_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_removeApplication_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Admin::end_removeApplication(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_removeApplication_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::AccessDeniedException&)
        {
            throw;
        }
        catch(const ::IceGrid::ApplicationNotExistException&)
        {
            throw;
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_instantiateServer(const ::std::string& iceP_application, const ::std::string& iceP_node, const ::IceGrid::ServerInstanceDescriptor& iceP_desc, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_instantiateServer_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_instantiateServer_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_instantiateServer_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_application);
        ostr->write(iceP_node);
        ostr->write(iceP_desc);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_instantiateServer_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Admin::end_instantiateServer(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_instantiateServer_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::AccessDeniedException&)
        {
            throw;
        }
        catch(const ::IceGrid::ApplicationNotExistException&)
        {
            throw;
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_patchApplication(const ::std::string& iceP_name, bool iceP_shutdown, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_patchApplication_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_patchApplication_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_patchApplication_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        ostr->write(iceP_shutdown);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_patchApplication_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Admin::end_patchApplication(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_patchApplication_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::ApplicationNotExistException&)
        {
            throw;
        }
        catch(const ::IceGrid::PatchException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getApplicationInfo(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getApplicationInfo_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getApplicationInfo_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getApplicationInfo_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_getApplicationInfo_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::ApplicationInfo
IceProxy::IceGrid::Admin::end_getApplicationInfo(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getApplicationInfo_name);
    ::IceGrid::ApplicationInfo ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::ApplicationNotExistException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    istr->readPendingValues();
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getDefaultApplicationDescriptor(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getDefaultApplicationDescriptor_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getDefaultApplicationDescriptor_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getDefaultApplicationDescriptor_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Admin_getDefaultApplicationDescriptor_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::ApplicationDescriptor
IceProxy::IceGrid::Admin::end_getDefaultApplicationDescriptor(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getDefaultApplicationDescriptor_name);
    ::IceGrid::ApplicationDescriptor ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    istr->readPendingValues();
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getAllApplicationNames(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getAllApplicationNames_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getAllApplicationNames_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getAllApplicationNames_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Admin_getAllApplicationNames_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::StringSeq
IceProxy::IceGrid::Admin::end_getAllApplicationNames(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getAllApplicationNames_name);
    ::Ice::StringSeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getServerInfo(const ::std::string& iceP_id, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getServerInfo_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getServerInfo_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getServerInfo_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_getServerInfo_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::ServerInfo
IceProxy::IceGrid::Admin::end_getServerInfo(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getServerInfo_name);
    ::IceGrid::ServerInfo ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::ServerNotExistException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    istr->readPendingValues();
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getServerState(const ::std::string& iceP_id, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getServerState_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getServerState_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getServerState_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_getServerState_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::ServerState
IceProxy::IceGrid::Admin::end_getServerState(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getServerState_name);
    ::IceGrid::ServerState ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::IceGrid::NodeUnreachableException&)
        {
            throw;
        }
        catch(const ::IceGrid::ServerNotExistException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getServerPid(const ::std::string& iceP_id, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getServerPid_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getServerPid_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getServerPid_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_getServerPid_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::Int
IceProxy::IceGrid::Admin::end_getServerPid(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getServerPid_name);
    ::Ice::Int ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::IceGrid::NodeUnreachableException&)
        {
            throw;
        }
        catch(const ::IceGrid::ServerNotExistException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getServerAdminCategory(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getServerAdminCategory_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getServerAdminCategory_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getServerAdminCategory_name, ::Ice::Idempotent, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Admin_getServerAdminCategory_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::std::string
IceProxy::IceGrid::Admin::end_getServerAdminCategory(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getServerAdminCategory_name);
    ::std::string ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getServerAdmin(const ::std::string& iceP_id, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getServerAdmin_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getServerAdmin_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getServerAdmin_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_getServerAdmin_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::ObjectPrx
IceProxy::IceGrid::Admin::end_getServerAdmin(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getServerAdmin_name);
    ::Ice::ObjectPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::IceGrid::NodeUnreachableException&)
        {
            throw;
        }
        catch(const ::IceGrid::ServerNotExistException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_enableServer(const ::std::string& iceP_id, bool iceP_enabled, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_enableServer_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_enableServer_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_enableServer_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        ostr->write(iceP_enabled);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_enableServer_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Admin::end_enableServer(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_enableServer_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::IceGrid::NodeUnreachableException&)
        {
            throw;
        }
        catch(const ::IceGrid::ServerNotExistException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_isServerEnabled(const ::std::string& iceP_id, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_isServerEnabled_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_isServerEnabled_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_isServerEnabled_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_isServerEnabled_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

bool
IceProxy::IceGrid::Admin::end_isServerEnabled(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_isServerEnabled_name);
    bool ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::IceGrid::NodeUnreachableException&)
        {
            throw;
        }
        catch(const ::IceGrid::ServerNotExistException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_startServer(const ::std::string& iceP_id, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_startServer_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_startServer_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_startServer_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_startServer_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Admin::end_startServer(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_startServer_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::IceGrid::NodeUnreachableException&)
        {
            throw;
        }
        catch(const ::IceGrid::ServerNotExistException&)
        {
            throw;
        }
        catch(const ::IceGrid::ServerStartException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_stopServer(const ::std::string& iceP_id, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_stopServer_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_stopServer_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_stopServer_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_stopServer_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Admin::end_stopServer(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_stopServer_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::IceGrid::NodeUnreachableException&)
        {
            throw;
        }
        catch(const ::IceGrid::ServerNotExistException&)
        {
            throw;
        }
        catch(const ::IceGrid::ServerStopException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_patchServer(const ::std::string& iceP_id, bool iceP_shutdown, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_patchServer_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_patchServer_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_patchServer_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        ostr->write(iceP_shutdown);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_patchServer_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Admin::end_patchServer(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_patchServer_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::IceGrid::NodeUnreachableException&)
        {
            throw;
        }
        catch(const ::IceGrid::PatchException&)
        {
            throw;
        }
        catch(const ::IceGrid::ServerNotExistException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_sendSignal(const ::std::string& iceP_id, const ::std::string& iceP_signal, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_sendSignal_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_sendSignal_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_sendSignal_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        ostr->write(iceP_signal);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_sendSignal_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Admin::end_sendSignal(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_sendSignal_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::BadSignalException&)
        {
            throw;
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::IceGrid::NodeUnreachableException&)
        {
            throw;
        }
        catch(const ::IceGrid::ServerNotExistException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getAllServerIds(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getAllServerIds_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getAllServerIds_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getAllServerIds_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Admin_getAllServerIds_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::StringSeq
IceProxy::IceGrid::Admin::end_getAllServerIds(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getAllServerIds_name);
    ::Ice::StringSeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getAdapterInfo(const ::std::string& iceP_id, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getAdapterInfo_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getAdapterInfo_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getAdapterInfo_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_getAdapterInfo_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::AdapterInfoSeq
IceProxy::IceGrid::Admin::end_getAdapterInfo(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getAdapterInfo_name);
    ::IceGrid::AdapterInfoSeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::AdapterNotExistException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_removeAdapter(const ::std::string& iceP_id, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_removeAdapter_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_removeAdapter_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_removeAdapter_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_removeAdapter_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Admin::end_removeAdapter(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_removeAdapter_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::AdapterNotExistException&)
        {
            throw;
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getAllAdapterIds(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getAllAdapterIds_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getAllAdapterIds_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getAllAdapterIds_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Admin_getAllAdapterIds_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::StringSeq
IceProxy::IceGrid::Admin::end_getAllAdapterIds(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getAllAdapterIds_name);
    ::Ice::StringSeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_addObject(const ::Ice::ObjectPrx& iceP_obj, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_addObject_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_addObject_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_addObject_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_obj);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_addObject_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Admin::end_addObject(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_addObject_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::IceGrid::ObjectExistsException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_updateObject(const ::Ice::ObjectPrx& iceP_obj, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_updateObject_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_updateObject_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_updateObject_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_obj);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_updateObject_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Admin::end_updateObject(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_updateObject_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::IceGrid::ObjectNotRegisteredException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_addObjectWithType(const ::Ice::ObjectPrx& iceP_obj, const ::std::string& iceP_type, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_addObjectWithType_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_addObjectWithType_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_addObjectWithType_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_obj);
        ostr->write(iceP_type);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_addObjectWithType_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Admin::end_addObjectWithType(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_addObjectWithType_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::IceGrid::ObjectExistsException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_removeObject(const ::Ice::Identity& iceP_id, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_removeObject_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_removeObject_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_removeObject_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_removeObject_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Admin::end_removeObject(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_removeObject_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::IceGrid::ObjectNotRegisteredException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getObjectInfo(const ::Ice::Identity& iceP_id, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getObjectInfo_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getObjectInfo_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getObjectInfo_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_getObjectInfo_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::ObjectInfo
IceProxy::IceGrid::Admin::end_getObjectInfo(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getObjectInfo_name);
    ::IceGrid::ObjectInfo ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::ObjectNotRegisteredException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getObjectInfosByType(const ::std::string& iceP_type, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getObjectInfosByType_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getObjectInfosByType_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getObjectInfosByType_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_type);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_getObjectInfosByType_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::ObjectInfoSeq
IceProxy::IceGrid::Admin::end_getObjectInfosByType(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getObjectInfosByType_name);
    ::IceGrid::ObjectInfoSeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getAllObjectInfos(const ::std::string& iceP_expr, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getAllObjectInfos_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getAllObjectInfos_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getAllObjectInfos_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_expr);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_getAllObjectInfos_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::ObjectInfoSeq
IceProxy::IceGrid::Admin::end_getAllObjectInfos(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getAllObjectInfos_name);
    ::IceGrid::ObjectInfoSeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_pingNode(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_pingNode_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_pingNode_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_pingNode_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_pingNode_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

bool
IceProxy::IceGrid::Admin::end_pingNode(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_pingNode_name);
    bool ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::NodeNotExistException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getNodeLoad(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getNodeLoad_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getNodeLoad_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getNodeLoad_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_getNodeLoad_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::LoadInfo
IceProxy::IceGrid::Admin::end_getNodeLoad(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getNodeLoad_name);
    ::IceGrid::LoadInfo ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::NodeNotExistException&)
        {
            throw;
        }
        catch(const ::IceGrid::NodeUnreachableException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getNodeInfo(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getNodeInfo_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getNodeInfo_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getNodeInfo_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_getNodeInfo_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::NodeInfo
IceProxy::IceGrid::Admin::end_getNodeInfo(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getNodeInfo_name);
    ::IceGrid::NodeInfo ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::NodeNotExistException&)
        {
            throw;
        }
        catch(const ::IceGrid::NodeUnreachableException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getNodeAdmin(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getNodeAdmin_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getNodeAdmin_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getNodeAdmin_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_getNodeAdmin_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::ObjectPrx
IceProxy::IceGrid::Admin::end_getNodeAdmin(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getNodeAdmin_name);
    ::Ice::ObjectPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::NodeNotExistException&)
        {
            throw;
        }
        catch(const ::IceGrid::NodeUnreachableException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getNodeProcessorSocketCount(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getNodeProcessorSocketCount_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getNodeProcessorSocketCount_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getNodeProcessorSocketCount_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_getNodeProcessorSocketCount_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::Int
IceProxy::IceGrid::Admin::end_getNodeProcessorSocketCount(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getNodeProcessorSocketCount_name);
    ::Ice::Int ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::NodeNotExistException&)
        {
            throw;
        }
        catch(const ::IceGrid::NodeUnreachableException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_shutdownNode(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_shutdownNode_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_shutdownNode_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_shutdownNode_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_shutdownNode_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Admin::end_shutdownNode(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_shutdownNode_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::NodeNotExistException&)
        {
            throw;
        }
        catch(const ::IceGrid::NodeUnreachableException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getNodeHostname(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getNodeHostname_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getNodeHostname_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getNodeHostname_name, ::Ice::Nonmutating, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_getNodeHostname_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::std::string
IceProxy::IceGrid::Admin::end_getNodeHostname(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getNodeHostname_name);
    ::std::string ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::NodeNotExistException&)
        {
            throw;
        }
        catch(const ::IceGrid::NodeUnreachableException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getAllNodeNames(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getAllNodeNames_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getAllNodeNames_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getAllNodeNames_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Admin_getAllNodeNames_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::StringSeq
IceProxy::IceGrid::Admin::end_getAllNodeNames(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getAllNodeNames_name);
    ::Ice::StringSeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_pingRegistry(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_pingRegistry_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_pingRegistry_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_pingRegistry_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_pingRegistry_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

bool
IceProxy::IceGrid::Admin::end_pingRegistry(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_pingRegistry_name);
    bool ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::RegistryNotExistException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getRegistryInfo(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getRegistryInfo_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getRegistryInfo_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getRegistryInfo_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_getRegistryInfo_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::RegistryInfo
IceProxy::IceGrid::Admin::end_getRegistryInfo(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getRegistryInfo_name);
    ::IceGrid::RegistryInfo ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::RegistryNotExistException&)
        {
            throw;
        }
        catch(const ::IceGrid::RegistryUnreachableException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getRegistryAdmin(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getRegistryAdmin_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getRegistryAdmin_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getRegistryAdmin_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_getRegistryAdmin_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::ObjectPrx
IceProxy::IceGrid::Admin::end_getRegistryAdmin(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getRegistryAdmin_name);
    ::Ice::ObjectPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::RegistryNotExistException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_shutdownRegistry(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_shutdownRegistry_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_shutdownRegistry_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_shutdownRegistry_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_Admin_shutdownRegistry_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Admin::end_shutdownRegistry(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_shutdownRegistry_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::RegistryNotExistException&)
        {
            throw;
        }
        catch(const ::IceGrid::RegistryUnreachableException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getAllRegistryNames(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getAllRegistryNames_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getAllRegistryNames_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getAllRegistryNames_name, ::Ice::Idempotent, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Admin_getAllRegistryNames_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::StringSeq
IceProxy::IceGrid::Admin::end_getAllRegistryNames(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getAllRegistryNames_name);
    ::Ice::StringSeq ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_shutdown(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_shutdown_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_shutdown_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Admin_shutdown_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::Admin::end_shutdown(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_Admin_shutdown_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::Admin::_iceI_begin_getSliceChecksums(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_Admin_getSliceChecksums_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_Admin_getSliceChecksums_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_Admin_getSliceChecksums_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_Admin_getSliceChecksums_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::SliceChecksumDict
IceProxy::IceGrid::Admin::end_getSliceChecksums(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_Admin_getSliceChecksums_name);
    ::Ice::SliceChecksumDict ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::Admin::_newInstance() const
{
    return new Admin;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::Admin::ice_staticId()
{
    return ::IceGrid::Admin::ice_staticId();
}

/// \cond INTERNAL
ICEGRID_API ::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(FileIterator* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< FileIterator>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new FileIterator;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceGrid::FileIterator::_iceI_begin_read(::Ice::Int iceP_size, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_FileIterator_read_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_FileIterator_read_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_FileIterator_read_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_size);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_FileIterator_read_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

bool
IceProxy::IceGrid::FileIterator::end_read(::Ice::StringSeq& iceP_lines, const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_FileIterator_read_name);
    bool ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::FileNotAvailableException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(iceP_lines);
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

void IceProxy::IceGrid::FileIterator::_iceI_end_read(::Ice::StringSeq& iceP_lines, bool& ret, const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_FileIterator_read_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::FileNotAvailableException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(iceP_lines);
    istr->read(ret);
    result->_endReadParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::FileIterator::_iceI_begin_destroy(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_FileIterator_destroy_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_FileIterator_destroy_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_FileIterator_destroy_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::FileIterator::end_destroy(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_FileIterator_destroy_name);
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::FileIterator::_newInstance() const
{
    return new FileIterator;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::FileIterator::ice_staticId()
{
    return ::IceGrid::FileIterator::ice_staticId();
}

/// \cond INTERNAL
ICEGRID_API ::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(RegistryObserver* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< RegistryObserver>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new RegistryObserver;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceGrid::RegistryObserver::_iceI_begin_registryInit(const ::IceGrid::RegistryInfoSeq& iceP_registries, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_RegistryObserver_registryInit_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_RegistryObserver_registryInit_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_registries);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_RegistryObserver_registryInit_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::RegistryObserver::end_registryInit(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_RegistryObserver_registryInit_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::RegistryObserver::_iceI_begin_registryUp(const ::IceGrid::RegistryInfo& iceP_node, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_RegistryObserver_registryUp_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_RegistryObserver_registryUp_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_node);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_RegistryObserver_registryUp_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::RegistryObserver::end_registryUp(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_RegistryObserver_registryUp_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::RegistryObserver::_iceI_begin_registryDown(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_RegistryObserver_registryDown_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_RegistryObserver_registryDown_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_RegistryObserver_registryDown_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::RegistryObserver::end_registryDown(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_RegistryObserver_registryDown_name);
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::RegistryObserver::_newInstance() const
{
    return new RegistryObserver;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::RegistryObserver::ice_staticId()
{
    return ::IceGrid::RegistryObserver::ice_staticId();
}

/// \cond INTERNAL
ICEGRID_API ::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(NodeObserver* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< NodeObserver>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new NodeObserver;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceGrid::NodeObserver::_iceI_begin_nodeInit(const ::IceGrid::NodeDynamicInfoSeq& iceP_nodes, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_NodeObserver_nodeInit_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_NodeObserver_nodeInit_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_nodes);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_NodeObserver_nodeInit_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::NodeObserver::end_nodeInit(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_NodeObserver_nodeInit_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::NodeObserver::_iceI_begin_nodeUp(const ::IceGrid::NodeDynamicInfo& iceP_node, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_NodeObserver_nodeUp_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_NodeObserver_nodeUp_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_node);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_NodeObserver_nodeUp_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::NodeObserver::end_nodeUp(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_NodeObserver_nodeUp_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::NodeObserver::_iceI_begin_nodeDown(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_NodeObserver_nodeDown_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_NodeObserver_nodeDown_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_NodeObserver_nodeDown_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::NodeObserver::end_nodeDown(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_NodeObserver_nodeDown_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::NodeObserver::_iceI_begin_updateServer(const ::std::string& iceP_node, const ::IceGrid::ServerDynamicInfo& iceP_updatedInfo, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_NodeObserver_updateServer_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_NodeObserver_updateServer_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_node);
        ostr->write(iceP_updatedInfo);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_NodeObserver_updateServer_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::NodeObserver::end_updateServer(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_NodeObserver_updateServer_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::NodeObserver::_iceI_begin_updateAdapter(const ::std::string& iceP_node, const ::IceGrid::AdapterDynamicInfo& iceP_updatedInfo, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_NodeObserver_updateAdapter_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_NodeObserver_updateAdapter_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_node);
        ostr->write(iceP_updatedInfo);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_NodeObserver_updateAdapter_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::NodeObserver::end_updateAdapter(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_NodeObserver_updateAdapter_name);
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::NodeObserver::_newInstance() const
{
    return new NodeObserver;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::NodeObserver::ice_staticId()
{
    return ::IceGrid::NodeObserver::ice_staticId();
}

/// \cond INTERNAL
ICEGRID_API ::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(ApplicationObserver* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< ApplicationObserver>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new ApplicationObserver;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceGrid::ApplicationObserver::_iceI_begin_applicationInit(::Ice::Int iceP_serial, const ::IceGrid::ApplicationInfoSeq& iceP_applications, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_ApplicationObserver_applicationInit_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_ApplicationObserver_applicationInit_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_serial);
        ostr->write(iceP_applications);
        ostr->writePendingValues();
        result->endWriteParams();
        result->invoke(iceC_IceGrid_ApplicationObserver_applicationInit_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::ApplicationObserver::end_applicationInit(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_ApplicationObserver_applicationInit_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::ApplicationObserver::_iceI_begin_applicationAdded(::Ice::Int iceP_serial, const ::IceGrid::ApplicationInfo& iceP_desc, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_ApplicationObserver_applicationAdded_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_ApplicationObserver_applicationAdded_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_serial);
        ostr->write(iceP_desc);
        ostr->writePendingValues();
        result->endWriteParams();
        result->invoke(iceC_IceGrid_ApplicationObserver_applicationAdded_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::ApplicationObserver::end_applicationAdded(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_ApplicationObserver_applicationAdded_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::ApplicationObserver::_iceI_begin_applicationRemoved(::Ice::Int iceP_serial, const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_ApplicationObserver_applicationRemoved_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_ApplicationObserver_applicationRemoved_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_serial);
        ostr->write(iceP_name);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_ApplicationObserver_applicationRemoved_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::ApplicationObserver::end_applicationRemoved(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_ApplicationObserver_applicationRemoved_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::ApplicationObserver::_iceI_begin_applicationUpdated(::Ice::Int iceP_serial, const ::IceGrid::ApplicationUpdateInfo& iceP_desc, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_ApplicationObserver_applicationUpdated_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_ApplicationObserver_applicationUpdated_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_serial);
        ostr->write(iceP_desc);
        ostr->writePendingValues();
        result->endWriteParams();
        result->invoke(iceC_IceGrid_ApplicationObserver_applicationUpdated_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::ApplicationObserver::end_applicationUpdated(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_ApplicationObserver_applicationUpdated_name);
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::ApplicationObserver::_newInstance() const
{
    return new ApplicationObserver;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::ApplicationObserver::ice_staticId()
{
    return ::IceGrid::ApplicationObserver::ice_staticId();
}

/// \cond INTERNAL
ICEGRID_API ::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(AdapterObserver* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< AdapterObserver>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new AdapterObserver;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceGrid::AdapterObserver::_iceI_begin_adapterInit(const ::IceGrid::AdapterInfoSeq& iceP_adpts, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_AdapterObserver_adapterInit_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_AdapterObserver_adapterInit_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_adpts);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_AdapterObserver_adapterInit_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::AdapterObserver::end_adapterInit(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_AdapterObserver_adapterInit_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::AdapterObserver::_iceI_begin_adapterAdded(const ::IceGrid::AdapterInfo& iceP_info, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_AdapterObserver_adapterAdded_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_AdapterObserver_adapterAdded_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_info);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_AdapterObserver_adapterAdded_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::AdapterObserver::end_adapterAdded(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_AdapterObserver_adapterAdded_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::AdapterObserver::_iceI_begin_adapterUpdated(const ::IceGrid::AdapterInfo& iceP_info, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_AdapterObserver_adapterUpdated_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_AdapterObserver_adapterUpdated_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_info);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_AdapterObserver_adapterUpdated_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::AdapterObserver::end_adapterUpdated(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_AdapterObserver_adapterUpdated_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::AdapterObserver::_iceI_begin_adapterRemoved(const ::std::string& iceP_id, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_AdapterObserver_adapterRemoved_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_AdapterObserver_adapterRemoved_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_AdapterObserver_adapterRemoved_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::AdapterObserver::end_adapterRemoved(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_AdapterObserver_adapterRemoved_name);
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::AdapterObserver::_newInstance() const
{
    return new AdapterObserver;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::AdapterObserver::ice_staticId()
{
    return ::IceGrid::AdapterObserver::ice_staticId();
}

/// \cond INTERNAL
ICEGRID_API ::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(ObjectObserver* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< ObjectObserver>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new ObjectObserver;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceGrid::ObjectObserver::_iceI_begin_objectInit(const ::IceGrid::ObjectInfoSeq& iceP_objects, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_ObjectObserver_objectInit_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_ObjectObserver_objectInit_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_objects);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_ObjectObserver_objectInit_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::ObjectObserver::end_objectInit(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_ObjectObserver_objectInit_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::ObjectObserver::_iceI_begin_objectAdded(const ::IceGrid::ObjectInfo& iceP_info, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_ObjectObserver_objectAdded_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_ObjectObserver_objectAdded_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_info);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_ObjectObserver_objectAdded_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::ObjectObserver::end_objectAdded(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_ObjectObserver_objectAdded_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::ObjectObserver::_iceI_begin_objectUpdated(const ::IceGrid::ObjectInfo& iceP_info, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_ObjectObserver_objectUpdated_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_ObjectObserver_objectUpdated_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_info);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_ObjectObserver_objectUpdated_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::ObjectObserver::end_objectUpdated(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_ObjectObserver_objectUpdated_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::ObjectObserver::_iceI_begin_objectRemoved(const ::Ice::Identity& iceP_id, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_ObjectObserver_objectRemoved_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_ObjectObserver_objectRemoved_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_ObjectObserver_objectRemoved_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::ObjectObserver::end_objectRemoved(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_ObjectObserver_objectRemoved_name);
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::ObjectObserver::_newInstance() const
{
    return new ObjectObserver;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::ObjectObserver::ice_staticId()
{
    return ::IceGrid::ObjectObserver::ice_staticId();
}

/// \cond INTERNAL
ICEGRID_API ::IceProxy::Ice::Object* ::IceProxy::IceGrid::upCast(AdminSession* p) { return p; }

void
::IceProxy::IceGrid::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< AdminSession>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new AdminSession;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceGrid::AdminSession::_iceI_begin_keepAlive(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_AdminSession_keepAlive_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_AdminSession_keepAlive_name, ::Ice::Idempotent, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_AdminSession_keepAlive_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::AdminSession::end_keepAlive(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceGrid_AdminSession_keepAlive_name);
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::AdminSession::_iceI_begin_getAdmin(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_getAdmin_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_AdminSession_getAdmin_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_AdminSession_getAdmin_name, ::Ice::Nonmutating, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_AdminSession_getAdmin_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::AdminPrx
IceProxy::IceGrid::AdminSession::end_getAdmin(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_AdminSession_getAdmin_name);
    ::IceGrid::AdminPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::AdminSession::_iceI_begin_getAdminCallbackTemplate(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_getAdminCallbackTemplate_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_AdminSession_getAdminCallbackTemplate_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_AdminSession_getAdminCallbackTemplate_name, ::Ice::Idempotent, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_AdminSession_getAdminCallbackTemplate_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::ObjectPrx
IceProxy::IceGrid::AdminSession::end_getAdminCallbackTemplate(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_AdminSession_getAdminCallbackTemplate_name);
    ::Ice::ObjectPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::AdminSession::_iceI_begin_setObservers(const ::IceGrid::RegistryObserverPrx& iceP_registryObs, const ::IceGrid::NodeObserverPrx& iceP_nodeObs, const ::IceGrid::ApplicationObserverPrx& iceP_appObs, const ::IceGrid::AdapterObserverPrx& iceP_adptObs, const ::IceGrid::ObjectObserverPrx& iceP_objObs, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_setObservers_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_AdminSession_setObservers_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_AdminSession_setObservers_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_registryObs);
        ostr->write(iceP_nodeObs);
        ostr->write(iceP_appObs);
        ostr->write(iceP_adptObs);
        ostr->write(iceP_objObs);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_AdminSession_setObservers_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::AdminSession::end_setObservers(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_AdminSession_setObservers_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::ObserverAlreadyRegisteredException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::AdminSession::_iceI_begin_setObserversByIdentity(const ::Ice::Identity& iceP_registryObs, const ::Ice::Identity& iceP_nodeObs, const ::Ice::Identity& iceP_appObs, const ::Ice::Identity& iceP_adptObs, const ::Ice::Identity& iceP_objObs, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_setObserversByIdentity_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_AdminSession_setObserversByIdentity_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_AdminSession_setObserversByIdentity_name, ::Ice::Idempotent, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_registryObs);
        ostr->write(iceP_nodeObs);
        ostr->write(iceP_appObs);
        ostr->write(iceP_adptObs);
        ostr->write(iceP_objObs);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_AdminSession_setObserversByIdentity_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::AdminSession::end_setObserversByIdentity(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_AdminSession_setObserversByIdentity_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::ObserverAlreadyRegisteredException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::AdminSession::_iceI_begin_startUpdate(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_startUpdate_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_AdminSession_startUpdate_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_AdminSession_startUpdate_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_AdminSession_startUpdate_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::Ice::Int
IceProxy::IceGrid::AdminSession::end_startUpdate(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_AdminSession_startUpdate_name);
    ::Ice::Int ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::AccessDeniedException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::AdminSession::_iceI_begin_finishUpdate(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_finishUpdate_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_AdminSession_finishUpdate_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_AdminSession_finishUpdate_name, ::Ice::Normal, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_AdminSession_finishUpdate_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceGrid::AdminSession::end_finishUpdate(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_AdminSession_finishUpdate_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::AccessDeniedException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::AdminSession::_iceI_begin_getReplicaName(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_getReplicaName_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_AdminSession_getReplicaName_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_AdminSession_getReplicaName_name, ::Ice::Idempotent, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceGrid_AdminSession_getReplicaName_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::std::string
IceProxy::IceGrid::AdminSession::end_getReplicaName(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_AdminSession_getReplicaName_name);
    ::std::string ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::AdminSession::_iceI_begin_openServerLog(const ::std::string& iceP_id, const ::std::string& iceP_path, ::Ice::Int iceP_count, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_openServerLog_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_AdminSession_openServerLog_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_AdminSession_openServerLog_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        ostr->write(iceP_path);
        ostr->write(iceP_count);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_AdminSession_openServerLog_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::FileIteratorPrx
IceProxy::IceGrid::AdminSession::end_openServerLog(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_AdminSession_openServerLog_name);
    ::IceGrid::FileIteratorPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::IceGrid::FileNotAvailableException&)
        {
            throw;
        }
        catch(const ::IceGrid::NodeUnreachableException&)
        {
            throw;
        }
        catch(const ::IceGrid::ServerNotExistException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::AdminSession::_iceI_begin_openServerStdErr(const ::std::string& iceP_id, ::Ice::Int iceP_count, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_openServerStdErr_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_AdminSession_openServerStdErr_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_AdminSession_openServerStdErr_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        ostr->write(iceP_count);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_AdminSession_openServerStdErr_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::FileIteratorPrx
IceProxy::IceGrid::AdminSession::end_openServerStdErr(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_AdminSession_openServerStdErr_name);
    ::IceGrid::FileIteratorPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::IceGrid::FileNotAvailableException&)
        {
            throw;
        }
        catch(const ::IceGrid::NodeUnreachableException&)
        {
            throw;
        }
        catch(const ::IceGrid::ServerNotExistException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::AdminSession::_iceI_begin_openServerStdOut(const ::std::string& iceP_id, ::Ice::Int iceP_count, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_openServerStdOut_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_AdminSession_openServerStdOut_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_AdminSession_openServerStdOut_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        ostr->write(iceP_count);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_AdminSession_openServerStdOut_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::FileIteratorPrx
IceProxy::IceGrid::AdminSession::end_openServerStdOut(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_AdminSession_openServerStdOut_name);
    ::IceGrid::FileIteratorPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::DeploymentException&)
        {
            throw;
        }
        catch(const ::IceGrid::FileNotAvailableException&)
        {
            throw;
        }
        catch(const ::IceGrid::NodeUnreachableException&)
        {
            throw;
        }
        catch(const ::IceGrid::ServerNotExistException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::AdminSession::_iceI_begin_openNodeStdErr(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_openNodeStdErr_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_AdminSession_openNodeStdErr_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_AdminSession_openNodeStdErr_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        ostr->write(iceP_count);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_AdminSession_openNodeStdErr_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::FileIteratorPrx
IceProxy::IceGrid::AdminSession::end_openNodeStdErr(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_AdminSession_openNodeStdErr_name);
    ::IceGrid::FileIteratorPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::FileNotAvailableException&)
        {
            throw;
        }
        catch(const ::IceGrid::NodeNotExistException&)
        {
            throw;
        }
        catch(const ::IceGrid::NodeUnreachableException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::AdminSession::_iceI_begin_openNodeStdOut(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_openNodeStdOut_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_AdminSession_openNodeStdOut_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_AdminSession_openNodeStdOut_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        ostr->write(iceP_count);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_AdminSession_openNodeStdOut_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::FileIteratorPrx
IceProxy::IceGrid::AdminSession::end_openNodeStdOut(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_AdminSession_openNodeStdOut_name);
    ::IceGrid::FileIteratorPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::FileNotAvailableException&)
        {
            throw;
        }
        catch(const ::IceGrid::NodeNotExistException&)
        {
            throw;
        }
        catch(const ::IceGrid::NodeUnreachableException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::AdminSession::_iceI_begin_openRegistryStdErr(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_openRegistryStdErr_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_AdminSession_openRegistryStdErr_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_AdminSession_openRegistryStdErr_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        ostr->write(iceP_count);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_AdminSession_openRegistryStdErr_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::FileIteratorPrx
IceProxy::IceGrid::AdminSession::end_openRegistryStdErr(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_AdminSession_openRegistryStdErr_name);
    ::IceGrid::FileIteratorPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::FileNotAvailableException&)
        {
            throw;
        }
        catch(const ::IceGrid::RegistryNotExistException&)
        {
            throw;
        }
        catch(const ::IceGrid::RegistryUnreachableException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceGrid::AdminSession::_iceI_begin_openRegistryStdOut(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceGrid_AdminSession_openRegistryStdOut_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceGrid_AdminSession_openRegistryStdOut_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceGrid_AdminSession_openRegistryStdOut_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_name);
        ostr->write(iceP_count);
        result->endWriteParams();
        result->invoke(iceC_IceGrid_AdminSession_openRegistryStdOut_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceGrid::FileIteratorPrx
IceProxy::IceGrid::AdminSession::end_openRegistryStdOut(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceGrid_AdminSession_openRegistryStdOut_name);
    ::IceGrid::FileIteratorPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceGrid::FileNotAvailableException&)
        {
            throw;
        }
        catch(const ::IceGrid::RegistryNotExistException&)
        {
            throw;
        }
        catch(const ::IceGrid::RegistryUnreachableException&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceGrid::AdminSession::_newInstance() const
{
    return new AdminSession;
}
/// \endcond

const ::std::string&
IceProxy::IceGrid::AdminSession::ice_staticId()
{
    return ::IceGrid::AdminSession::ice_staticId();
}

IceGrid::Admin::~Admin()
{
}

/// \cond INTERNAL
ICEGRID_API ::Ice::Object* IceGrid::upCast(Admin* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceGrid_Admin_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::Admin"
};

}

bool
IceGrid::Admin::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_Admin_ids, iceC_IceGrid_Admin_ids + 2, s);
}

::std::vector< ::std::string>
IceGrid::Admin::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_Admin_ids[0], &iceC_IceGrid_Admin_ids[2]);
}

const ::std::string&
IceGrid::Admin::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::Admin::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::Admin";
    return typeId;
#else
    return iceC_IceGrid_Admin_ids[1];
#endif
}

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_addApplication(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ApplicationDescriptor iceP_descriptor;
    istr->read(iceP_descriptor);
    istr->readPendingValues();
    inS.endReadParams();
    this->addApplication(iceP_descriptor, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_syncApplication(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ApplicationDescriptor iceP_descriptor;
    istr->read(iceP_descriptor);
    istr->readPendingValues();
    inS.endReadParams();
    this->syncApplication(iceP_descriptor, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_updateApplication(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ApplicationUpdateDescriptor iceP_descriptor;
    istr->read(iceP_descriptor);
    istr->readPendingValues();
    inS.endReadParams();
    this->updateApplication(iceP_descriptor, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_syncApplicationWithoutRestart(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ApplicationDescriptor iceP_descriptor;
    istr->read(iceP_descriptor);
    istr->readPendingValues();
    inS.endReadParams();
    this->syncApplicationWithoutRestart(iceP_descriptor, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_updateApplicationWithoutRestart(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ApplicationUpdateDescriptor iceP_descriptor;
    istr->read(iceP_descriptor);
    istr->readPendingValues();
    inS.endReadParams();
    this->updateApplicationWithoutRestart(iceP_descriptor, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_removeApplication(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->read(iceP_name);
    inS.endReadParams();
    this->removeApplication(iceP_name, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_instantiateServer(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_application;
    ::std::string iceP_node;
    ServerInstanceDescriptor iceP_desc;
    istr->read(iceP_application);
    istr->read(iceP_node);
    istr->read(iceP_desc);
    inS.endReadParams();
    this->instantiateServer(iceP_application, iceP_node, iceP_desc, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_patchApplication(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    bool iceP_shutdown;
    istr->read(iceP_name);
    istr->read(iceP_shutdown);
    inS.endReadParams();
    this->patchApplication_async(new IceAsync::IceGrid::AMD_Admin_patchApplication(inS), iceP_name, iceP_shutdown, current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getApplicationInfo(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->read(iceP_name);
    inS.endReadParams();
    ApplicationInfo ret = this->getApplicationInfo(iceP_name, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    ostr->writePendingValues();
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getDefaultApplicationDescriptor(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ApplicationDescriptor ret = this->getDefaultApplicationDescriptor(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    ostr->writePendingValues();
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getAllApplicationNames(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::StringSeq ret = this->getAllApplicationNames(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getServerInfo(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_id;
    istr->read(iceP_id);
    inS.endReadParams();
    ServerInfo ret = this->getServerInfo(iceP_id, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    ostr->writePendingValues();
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getServerState(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_id;
    istr->read(iceP_id);
    inS.endReadParams();
    ServerState ret = this->getServerState(iceP_id, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getServerPid(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_id;
    istr->read(iceP_id);
    inS.endReadParams();
    ::Ice::Int ret = this->getServerPid(iceP_id, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getServerAdminCategory(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::std::string ret = this->getServerAdminCategory(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getServerAdmin(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_id;
    istr->read(iceP_id);
    inS.endReadParams();
    ::Ice::ObjectPrx ret = this->getServerAdmin(iceP_id, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_enableServer(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_id;
    bool iceP_enabled;
    istr->read(iceP_id);
    istr->read(iceP_enabled);
    inS.endReadParams();
    this->enableServer(iceP_id, iceP_enabled, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_isServerEnabled(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_id;
    istr->read(iceP_id);
    inS.endReadParams();
    bool ret = this->isServerEnabled(iceP_id, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_startServer(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_id;
    istr->read(iceP_id);
    inS.endReadParams();
    this->startServer_async(new IceAsync::IceGrid::AMD_Admin_startServer(inS), iceP_id, current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_stopServer(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_id;
    istr->read(iceP_id);
    inS.endReadParams();
    this->stopServer_async(new IceAsync::IceGrid::AMD_Admin_stopServer(inS), iceP_id, current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_patchServer(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_id;
    bool iceP_shutdown;
    istr->read(iceP_id);
    istr->read(iceP_shutdown);
    inS.endReadParams();
    this->patchServer_async(new IceAsync::IceGrid::AMD_Admin_patchServer(inS), iceP_id, iceP_shutdown, current);
    return false;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_sendSignal(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_id;
    ::std::string iceP_signal;
    istr->read(iceP_id);
    istr->read(iceP_signal);
    inS.endReadParams();
    this->sendSignal(iceP_id, iceP_signal, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getAllServerIds(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::StringSeq ret = this->getAllServerIds(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getAdapterInfo(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_id;
    istr->read(iceP_id);
    inS.endReadParams();
    AdapterInfoSeq ret = this->getAdapterInfo(iceP_id, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_removeAdapter(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_id;
    istr->read(iceP_id);
    inS.endReadParams();
    this->removeAdapter(iceP_id, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getAllAdapterIds(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::StringSeq ret = this->getAllAdapterIds(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_addObject(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::ObjectPrx iceP_obj;
    istr->read(iceP_obj);
    inS.endReadParams();
    this->addObject(iceP_obj, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_updateObject(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::ObjectPrx iceP_obj;
    istr->read(iceP_obj);
    inS.endReadParams();
    this->updateObject(iceP_obj, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_addObjectWithType(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::ObjectPrx iceP_obj;
    ::std::string iceP_type;
    istr->read(iceP_obj);
    istr->read(iceP_type);
    inS.endReadParams();
    this->addObjectWithType(iceP_obj, iceP_type, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_removeObject(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::Identity iceP_id;
    istr->read(iceP_id);
    inS.endReadParams();
    this->removeObject(iceP_id, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getObjectInfo(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::Identity iceP_id;
    istr->read(iceP_id);
    inS.endReadParams();
    ObjectInfo ret = this->getObjectInfo(iceP_id, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getObjectInfosByType(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_type;
    istr->read(iceP_type);
    inS.endReadParams();
    ObjectInfoSeq ret = this->getObjectInfosByType(iceP_type, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getAllObjectInfos(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_expr;
    istr->read(iceP_expr);
    inS.endReadParams();
    ObjectInfoSeq ret = this->getAllObjectInfos(iceP_expr, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_pingNode(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->read(iceP_name);
    inS.endReadParams();
    bool ret = this->pingNode(iceP_name, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getNodeLoad(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->read(iceP_name);
    inS.endReadParams();
    LoadInfo ret = this->getNodeLoad(iceP_name, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getNodeInfo(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->read(iceP_name);
    inS.endReadParams();
    NodeInfo ret = this->getNodeInfo(iceP_name, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getNodeAdmin(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->read(iceP_name);
    inS.endReadParams();
    ::Ice::ObjectPrx ret = this->getNodeAdmin(iceP_name, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getNodeProcessorSocketCount(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->read(iceP_name);
    inS.endReadParams();
    ::Ice::Int ret = this->getNodeProcessorSocketCount(iceP_name, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_shutdownNode(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->read(iceP_name);
    inS.endReadParams();
    this->shutdownNode(iceP_name, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getNodeHostname(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->read(iceP_name);
    inS.endReadParams();
    ::std::string ret = this->getNodeHostname(iceP_name, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getAllNodeNames(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::StringSeq ret = this->getAllNodeNames(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_pingRegistry(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->read(iceP_name);
    inS.endReadParams();
    bool ret = this->pingRegistry(iceP_name, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getRegistryInfo(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->read(iceP_name);
    inS.endReadParams();
    RegistryInfo ret = this->getRegistryInfo(iceP_name, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getRegistryAdmin(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->read(iceP_name);
    inS.endReadParams();
    ::Ice::ObjectPrx ret = this->getRegistryAdmin(iceP_name, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_shutdownRegistry(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->read(iceP_name);
    inS.endReadParams();
    this->shutdownRegistry(iceP_name, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getAllRegistryNames(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::StringSeq ret = this->getAllRegistryNames(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_shutdown(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    this->shutdown(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::Admin::_iceD_getSliceChecksums(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::SliceChecksumDict ret = this->getSliceChecksums(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceGrid_Admin_all[] =
{
    "addApplication",
    "addObject",
    "addObjectWithType",
    "enableServer",
    "getAdapterInfo",
    "getAllAdapterIds",
    "getAllApplicationNames",
    "getAllNodeNames",
    "getAllObjectInfos",
    "getAllRegistryNames",
    "getAllServerIds",
    "getApplicationInfo",
    "getDefaultApplicationDescriptor",
    "getNodeAdmin",
    "getNodeHostname",
    "getNodeInfo",
    "getNodeLoad",
    "getNodeProcessorSocketCount",
    "getObjectInfo",
    "getObjectInfosByType",
    "getRegistryAdmin",
    "getRegistryInfo",
    "getServerAdmin",
    "getServerAdminCategory",
    "getServerInfo",
    "getServerPid",
    "getServerState",
    "getSliceChecksums",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "instantiateServer",
    "isServerEnabled",
    "patchApplication",
    "patchServer",
    "pingNode",
    "pingRegistry",
    "removeAdapter",
    "removeApplication",
    "removeObject",
    "sendSignal",
    "shutdown",
    "shutdownNode",
    "shutdownRegistry",
    "startServer",
    "stopServer",
    "syncApplication",
    "syncApplicationWithoutRestart",
    "updateApplication",
    "updateApplicationWithoutRestart",
    "updateObject"
};

}

/// \cond INTERNAL
bool
IceGrid::Admin::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_Admin_all, iceC_IceGrid_Admin_all + 52, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_Admin_all)
    {
        case 0:
        {
            return _iceD_addApplication(in, current);
        }
        case 1:
        {
            return _iceD_addObject(in, current);
        }
        case 2:
        {
            return _iceD_addObjectWithType(in, current);
        }
        case 3:
        {
            return _iceD_enableServer(in, current);
        }
        case 4:
        {
            return _iceD_getAdapterInfo(in, current);
        }
        case 5:
        {
            return _iceD_getAllAdapterIds(in, current);
        }
        case 6:
        {
            return _iceD_getAllApplicationNames(in, current);
        }
        case 7:
        {
            return _iceD_getAllNodeNames(in, current);
        }
        case 8:
        {
            return _iceD_getAllObjectInfos(in, current);
        }
        case 9:
        {
            return _iceD_getAllRegistryNames(in, current);
        }
        case 10:
        {
            return _iceD_getAllServerIds(in, current);
        }
        case 11:
        {
            return _iceD_getApplicationInfo(in, current);
        }
        case 12:
        {
            return _iceD_getDefaultApplicationDescriptor(in, current);
        }
        case 13:
        {
            return _iceD_getNodeAdmin(in, current);
        }
        case 14:
        {
            return _iceD_getNodeHostname(in, current);
        }
        case 15:
        {
            return _iceD_getNodeInfo(in, current);
        }
        case 16:
        {
            return _iceD_getNodeLoad(in, current);
        }
        case 17:
        {
            return _iceD_getNodeProcessorSocketCount(in, current);
        }
        case 18:
        {
            return _iceD_getObjectInfo(in, current);
        }
        case 19:
        {
            return _iceD_getObjectInfosByType(in, current);
        }
        case 20:
        {
            return _iceD_getRegistryAdmin(in, current);
        }
        case 21:
        {
            return _iceD_getRegistryInfo(in, current);
        }
        case 22:
        {
            return _iceD_getServerAdmin(in, current);
        }
        case 23:
        {
            return _iceD_getServerAdminCategory(in, current);
        }
        case 24:
        {
            return _iceD_getServerInfo(in, current);
        }
        case 25:
        {
            return _iceD_getServerPid(in, current);
        }
        case 26:
        {
            return _iceD_getServerState(in, current);
        }
        case 27:
        {
            return _iceD_getSliceChecksums(in, current);
        }
        case 28:
        {
            return _iceD_ice_id(in, current);
        }
        case 29:
        {
            return _iceD_ice_ids(in, current);
        }
        case 30:
        {
            return _iceD_ice_isA(in, current);
        }
        case 31:
        {
            return _iceD_ice_ping(in, current);
        }
        case 32:
        {
            return _iceD_instantiateServer(in, current);
        }
        case 33:
        {
            return _iceD_isServerEnabled(in, current);
        }
        case 34:
        {
            return _iceD_patchApplication(in, current);
        }
        case 35:
        {
            return _iceD_patchServer(in, current);
        }
        case 36:
        {
            return _iceD_pingNode(in, current);
        }
        case 37:
        {
            return _iceD_pingRegistry(in, current);
        }
        case 38:
        {
            return _iceD_removeAdapter(in, current);
        }
        case 39:
        {
            return _iceD_removeApplication(in, current);
        }
        case 40:
        {
            return _iceD_removeObject(in, current);
        }
        case 41:
        {
            return _iceD_sendSignal(in, current);
        }
        case 42:
        {
            return _iceD_shutdown(in, current);
        }
        case 43:
        {
            return _iceD_shutdownNode(in, current);
        }
        case 44:
        {
            return _iceD_shutdownRegistry(in, current);
        }
        case 45:
        {
            return _iceD_startServer(in, current);
        }
        case 46:
        {
            return _iceD_stopServer(in, current);
        }
        case 47:
        {
            return _iceD_syncApplication(in, current);
        }
        case 48:
        {
            return _iceD_syncApplicationWithoutRestart(in, current);
        }
        case 49:
        {
            return _iceD_updateApplication(in, current);
        }
        case 50:
        {
            return _iceD_updateApplicationWithoutRestart(in, current);
        }
        case 51:
        {
            return _iceD_updateObject(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceGrid::Admin::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< Admin, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::Admin::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< Admin, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(AdminPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = AdminPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(Admin::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::FileIterator::~FileIterator()
{
}

/// \cond INTERNAL
ICEGRID_API ::Ice::Object* IceGrid::upCast(FileIterator* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceGrid_FileIterator_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::FileIterator"
};

}

bool
IceGrid::FileIterator::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_FileIterator_ids, iceC_IceGrid_FileIterator_ids + 2, s);
}

::std::vector< ::std::string>
IceGrid::FileIterator::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_FileIterator_ids[0], &iceC_IceGrid_FileIterator_ids[2]);
}

const ::std::string&
IceGrid::FileIterator::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::FileIterator::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::FileIterator";
    return typeId;
#else
    return iceC_IceGrid_FileIterator_ids[1];
#endif
}

/// \cond INTERNAL
bool
IceGrid::FileIterator::_iceD_read(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::Int iceP_size;
    istr->read(iceP_size);
    inS.endReadParams();
    ::Ice::StringSeq iceP_lines;
    bool ret = this->read(iceP_size, iceP_lines, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(iceP_lines);
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::FileIterator::_iceD_destroy(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    this->destroy(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceGrid_FileIterator_all[] =
{
    "destroy",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "read"
};

}

/// \cond INTERNAL
bool
IceGrid::FileIterator::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_FileIterator_all, iceC_IceGrid_FileIterator_all + 6, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_FileIterator_all)
    {
        case 0:
        {
            return _iceD_destroy(in, current);
        }
        case 1:
        {
            return _iceD_ice_id(in, current);
        }
        case 2:
        {
            return _iceD_ice_ids(in, current);
        }
        case 3:
        {
            return _iceD_ice_isA(in, current);
        }
        case 4:
        {
            return _iceD_ice_ping(in, current);
        }
        case 5:
        {
            return _iceD_read(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceGrid::FileIterator::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< FileIterator, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::FileIterator::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< FileIterator, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(FileIteratorPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = FileIteratorPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(FileIterator::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::RegistryObserver::~RegistryObserver()
{
}

/// \cond INTERNAL
ICEGRID_API ::Ice::Object* IceGrid::upCast(RegistryObserver* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceGrid_RegistryObserver_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::RegistryObserver"
};

}

bool
IceGrid::RegistryObserver::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_RegistryObserver_ids, iceC_IceGrid_RegistryObserver_ids + 2, s);
}

::std::vector< ::std::string>
IceGrid::RegistryObserver::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_RegistryObserver_ids[0], &iceC_IceGrid_RegistryObserver_ids[2]);
}

const ::std::string&
IceGrid::RegistryObserver::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::RegistryObserver::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::RegistryObserver";
    return typeId;
#else
    return iceC_IceGrid_RegistryObserver_ids[1];
#endif
}

/// \cond INTERNAL
bool
IceGrid::RegistryObserver::_iceD_registryInit(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    RegistryInfoSeq iceP_registries;
    istr->read(iceP_registries);
    inS.endReadParams();
    this->registryInit(iceP_registries, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::RegistryObserver::_iceD_registryUp(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    RegistryInfo iceP_node;
    istr->read(iceP_node);
    inS.endReadParams();
    this->registryUp(iceP_node, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::RegistryObserver::_iceD_registryDown(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->read(iceP_name);
    inS.endReadParams();
    this->registryDown(iceP_name, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceGrid_RegistryObserver_all[] =
{
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "registryDown",
    "registryInit",
    "registryUp"
};

}

/// \cond INTERNAL
bool
IceGrid::RegistryObserver::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_RegistryObserver_all, iceC_IceGrid_RegistryObserver_all + 7, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_RegistryObserver_all)
    {
        case 0:
        {
            return _iceD_ice_id(in, current);
        }
        case 1:
        {
            return _iceD_ice_ids(in, current);
        }
        case 2:
        {
            return _iceD_ice_isA(in, current);
        }
        case 3:
        {
            return _iceD_ice_ping(in, current);
        }
        case 4:
        {
            return _iceD_registryDown(in, current);
        }
        case 5:
        {
            return _iceD_registryInit(in, current);
        }
        case 6:
        {
            return _iceD_registryUp(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceGrid::RegistryObserver::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< RegistryObserver, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::RegistryObserver::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< RegistryObserver, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(RegistryObserverPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = RegistryObserverPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(RegistryObserver::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::NodeObserver::~NodeObserver()
{
}

/// \cond INTERNAL
ICEGRID_API ::Ice::Object* IceGrid::upCast(NodeObserver* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceGrid_NodeObserver_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::NodeObserver"
};

}

bool
IceGrid::NodeObserver::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_NodeObserver_ids, iceC_IceGrid_NodeObserver_ids + 2, s);
}

::std::vector< ::std::string>
IceGrid::NodeObserver::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_NodeObserver_ids[0], &iceC_IceGrid_NodeObserver_ids[2]);
}

const ::std::string&
IceGrid::NodeObserver::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::NodeObserver::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::NodeObserver";
    return typeId;
#else
    return iceC_IceGrid_NodeObserver_ids[1];
#endif
}

/// \cond INTERNAL
bool
IceGrid::NodeObserver::_iceD_nodeInit(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    NodeDynamicInfoSeq iceP_nodes;
    istr->read(iceP_nodes);
    inS.endReadParams();
    this->nodeInit(iceP_nodes, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeObserver::_iceD_nodeUp(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    NodeDynamicInfo iceP_node;
    istr->read(iceP_node);
    inS.endReadParams();
    this->nodeUp(iceP_node, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeObserver::_iceD_nodeDown(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    istr->read(iceP_name);
    inS.endReadParams();
    this->nodeDown(iceP_name, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeObserver::_iceD_updateServer(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_node;
    ServerDynamicInfo iceP_updatedInfo;
    istr->read(iceP_node);
    istr->read(iceP_updatedInfo);
    inS.endReadParams();
    this->updateServer(iceP_node, iceP_updatedInfo, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::NodeObserver::_iceD_updateAdapter(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_node;
    AdapterDynamicInfo iceP_updatedInfo;
    istr->read(iceP_node);
    istr->read(iceP_updatedInfo);
    inS.endReadParams();
    this->updateAdapter(iceP_node, iceP_updatedInfo, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceGrid_NodeObserver_all[] =
{
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "nodeDown",
    "nodeInit",
    "nodeUp",
    "updateAdapter",
    "updateServer"
};

}

/// \cond INTERNAL
bool
IceGrid::NodeObserver::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_NodeObserver_all, iceC_IceGrid_NodeObserver_all + 9, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_NodeObserver_all)
    {
        case 0:
        {
            return _iceD_ice_id(in, current);
        }
        case 1:
        {
            return _iceD_ice_ids(in, current);
        }
        case 2:
        {
            return _iceD_ice_isA(in, current);
        }
        case 3:
        {
            return _iceD_ice_ping(in, current);
        }
        case 4:
        {
            return _iceD_nodeDown(in, current);
        }
        case 5:
        {
            return _iceD_nodeInit(in, current);
        }
        case 6:
        {
            return _iceD_nodeUp(in, current);
        }
        case 7:
        {
            return _iceD_updateAdapter(in, current);
        }
        case 8:
        {
            return _iceD_updateServer(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceGrid::NodeObserver::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< NodeObserver, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::NodeObserver::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< NodeObserver, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(NodeObserverPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = NodeObserverPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(NodeObserver::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::ApplicationObserver::~ApplicationObserver()
{
}

/// \cond INTERNAL
ICEGRID_API ::Ice::Object* IceGrid::upCast(ApplicationObserver* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceGrid_ApplicationObserver_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::ApplicationObserver"
};

}

bool
IceGrid::ApplicationObserver::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_ApplicationObserver_ids, iceC_IceGrid_ApplicationObserver_ids + 2, s);
}

::std::vector< ::std::string>
IceGrid::ApplicationObserver::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_ApplicationObserver_ids[0], &iceC_IceGrid_ApplicationObserver_ids[2]);
}

const ::std::string&
IceGrid::ApplicationObserver::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::ApplicationObserver::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::ApplicationObserver";
    return typeId;
#else
    return iceC_IceGrid_ApplicationObserver_ids[1];
#endif
}

/// \cond INTERNAL
bool
IceGrid::ApplicationObserver::_iceD_applicationInit(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::Int iceP_serial;
    ApplicationInfoSeq iceP_applications;
    istr->read(iceP_serial);
    istr->read(iceP_applications);
    istr->readPendingValues();
    inS.endReadParams();
    this->applicationInit(iceP_serial, iceP_applications, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ApplicationObserver::_iceD_applicationAdded(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::Int iceP_serial;
    ApplicationInfo iceP_desc;
    istr->read(iceP_serial);
    istr->read(iceP_desc);
    istr->readPendingValues();
    inS.endReadParams();
    this->applicationAdded(iceP_serial, iceP_desc, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ApplicationObserver::_iceD_applicationRemoved(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::Int iceP_serial;
    ::std::string iceP_name;
    istr->read(iceP_serial);
    istr->read(iceP_name);
    inS.endReadParams();
    this->applicationRemoved(iceP_serial, iceP_name, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ApplicationObserver::_iceD_applicationUpdated(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::Int iceP_serial;
    ApplicationUpdateInfo iceP_desc;
    istr->read(iceP_serial);
    istr->read(iceP_desc);
    istr->readPendingValues();
    inS.endReadParams();
    this->applicationUpdated(iceP_serial, iceP_desc, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceGrid_ApplicationObserver_all[] =
{
    "applicationAdded",
    "applicationInit",
    "applicationRemoved",
    "applicationUpdated",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};

}

/// \cond INTERNAL
bool
IceGrid::ApplicationObserver::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_ApplicationObserver_all, iceC_IceGrid_ApplicationObserver_all + 8, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_ApplicationObserver_all)
    {
        case 0:
        {
            return _iceD_applicationAdded(in, current);
        }
        case 1:
        {
            return _iceD_applicationInit(in, current);
        }
        case 2:
        {
            return _iceD_applicationRemoved(in, current);
        }
        case 3:
        {
            return _iceD_applicationUpdated(in, current);
        }
        case 4:
        {
            return _iceD_ice_id(in, current);
        }
        case 5:
        {
            return _iceD_ice_ids(in, current);
        }
        case 6:
        {
            return _iceD_ice_isA(in, current);
        }
        case 7:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceGrid::ApplicationObserver::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< ApplicationObserver, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::ApplicationObserver::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< ApplicationObserver, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(ApplicationObserverPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = ApplicationObserverPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(ApplicationObserver::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::AdapterObserver::~AdapterObserver()
{
}

/// \cond INTERNAL
ICEGRID_API ::Ice::Object* IceGrid::upCast(AdapterObserver* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceGrid_AdapterObserver_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::AdapterObserver"
};

}

bool
IceGrid::AdapterObserver::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_AdapterObserver_ids, iceC_IceGrid_AdapterObserver_ids + 2, s);
}

::std::vector< ::std::string>
IceGrid::AdapterObserver::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_AdapterObserver_ids[0], &iceC_IceGrid_AdapterObserver_ids[2]);
}

const ::std::string&
IceGrid::AdapterObserver::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::AdapterObserver::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::AdapterObserver";
    return typeId;
#else
    return iceC_IceGrid_AdapterObserver_ids[1];
#endif
}

/// \cond INTERNAL
bool
IceGrid::AdapterObserver::_iceD_adapterInit(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    AdapterInfoSeq iceP_adpts;
    istr->read(iceP_adpts);
    inS.endReadParams();
    this->adapterInit(iceP_adpts, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdapterObserver::_iceD_adapterAdded(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    AdapterInfo iceP_info;
    istr->read(iceP_info);
    inS.endReadParams();
    this->adapterAdded(iceP_info, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdapterObserver::_iceD_adapterUpdated(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    AdapterInfo iceP_info;
    istr->read(iceP_info);
    inS.endReadParams();
    this->adapterUpdated(iceP_info, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdapterObserver::_iceD_adapterRemoved(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_id;
    istr->read(iceP_id);
    inS.endReadParams();
    this->adapterRemoved(iceP_id, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceGrid_AdapterObserver_all[] =
{
    "adapterAdded",
    "adapterInit",
    "adapterRemoved",
    "adapterUpdated",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};

}

/// \cond INTERNAL
bool
IceGrid::AdapterObserver::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_AdapterObserver_all, iceC_IceGrid_AdapterObserver_all + 8, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_AdapterObserver_all)
    {
        case 0:
        {
            return _iceD_adapterAdded(in, current);
        }
        case 1:
        {
            return _iceD_adapterInit(in, current);
        }
        case 2:
        {
            return _iceD_adapterRemoved(in, current);
        }
        case 3:
        {
            return _iceD_adapterUpdated(in, current);
        }
        case 4:
        {
            return _iceD_ice_id(in, current);
        }
        case 5:
        {
            return _iceD_ice_ids(in, current);
        }
        case 6:
        {
            return _iceD_ice_isA(in, current);
        }
        case 7:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceGrid::AdapterObserver::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< AdapterObserver, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::AdapterObserver::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< AdapterObserver, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(AdapterObserverPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = AdapterObserverPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(AdapterObserver::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::ObjectObserver::~ObjectObserver()
{
}

/// \cond INTERNAL
ICEGRID_API ::Ice::Object* IceGrid::upCast(ObjectObserver* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceGrid_ObjectObserver_ids[2] =
{
    "::Ice::Object",
    "::IceGrid::ObjectObserver"
};

}

bool
IceGrid::ObjectObserver::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_ObjectObserver_ids, iceC_IceGrid_ObjectObserver_ids + 2, s);
}

::std::vector< ::std::string>
IceGrid::ObjectObserver::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_ObjectObserver_ids[0], &iceC_IceGrid_ObjectObserver_ids[2]);
}

const ::std::string&
IceGrid::ObjectObserver::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::ObjectObserver::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::ObjectObserver";
    return typeId;
#else
    return iceC_IceGrid_ObjectObserver_ids[1];
#endif
}

/// \cond INTERNAL
bool
IceGrid::ObjectObserver::_iceD_objectInit(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ObjectInfoSeq iceP_objects;
    istr->read(iceP_objects);
    inS.endReadParams();
    this->objectInit(iceP_objects, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ObjectObserver::_iceD_objectAdded(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ObjectInfo iceP_info;
    istr->read(iceP_info);
    inS.endReadParams();
    this->objectAdded(iceP_info, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ObjectObserver::_iceD_objectUpdated(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ObjectInfo iceP_info;
    istr->read(iceP_info);
    inS.endReadParams();
    this->objectUpdated(iceP_info, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::ObjectObserver::_iceD_objectRemoved(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::Identity iceP_id;
    istr->read(iceP_id);
    inS.endReadParams();
    this->objectRemoved(iceP_id, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceGrid_ObjectObserver_all[] =
{
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "objectAdded",
    "objectInit",
    "objectRemoved",
    "objectUpdated"
};

}

/// \cond INTERNAL
bool
IceGrid::ObjectObserver::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_ObjectObserver_all, iceC_IceGrid_ObjectObserver_all + 8, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_ObjectObserver_all)
    {
        case 0:
        {
            return _iceD_ice_id(in, current);
        }
        case 1:
        {
            return _iceD_ice_ids(in, current);
        }
        case 2:
        {
            return _iceD_ice_isA(in, current);
        }
        case 3:
        {
            return _iceD_ice_ping(in, current);
        }
        case 4:
        {
            return _iceD_objectAdded(in, current);
        }
        case 5:
        {
            return _iceD_objectInit(in, current);
        }
        case 6:
        {
            return _iceD_objectRemoved(in, current);
        }
        case 7:
        {
            return _iceD_objectUpdated(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceGrid::ObjectObserver::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< ObjectObserver, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::ObjectObserver::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< ObjectObserver, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(ObjectObserverPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = ObjectObserverPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(ObjectObserver::ice_staticId(), v);
    }
}
/// \endcond

IceGrid::AdminSession::~AdminSession()
{
}

/// \cond INTERNAL
ICEGRID_API ::Ice::Object* IceGrid::upCast(AdminSession* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceGrid_AdminSession_ids[3] =
{
    "::Glacier2::Session",
    "::Ice::Object",
    "::IceGrid::AdminSession"
};

}

bool
IceGrid::AdminSession::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceGrid_AdminSession_ids, iceC_IceGrid_AdminSession_ids + 3, s);
}

::std::vector< ::std::string>
IceGrid::AdminSession::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceGrid_AdminSession_ids[0], &iceC_IceGrid_AdminSession_ids[3]);
}

const ::std::string&
IceGrid::AdminSession::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceGrid::AdminSession::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceGrid::AdminSession";
    return typeId;
#else
    return iceC_IceGrid_AdminSession_ids[2];
#endif
}

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_keepAlive(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    this->keepAlive(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_getAdmin(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    AdminPrx ret = this->getAdmin(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_getAdminCallbackTemplate(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::Ice::ObjectPrx ret = this->getAdminCallbackTemplate(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_setObservers(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    RegistryObserverPrx iceP_registryObs;
    NodeObserverPrx iceP_nodeObs;
    ApplicationObserverPrx iceP_appObs;
    AdapterObserverPrx iceP_adptObs;
    ObjectObserverPrx iceP_objObs;
    istr->read(iceP_registryObs);
    istr->read(iceP_nodeObs);
    istr->read(iceP_appObs);
    istr->read(iceP_adptObs);
    istr->read(iceP_objObs);
    inS.endReadParams();
    this->setObservers(iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_setObserversByIdentity(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::Identity iceP_registryObs;
    ::Ice::Identity iceP_nodeObs;
    ::Ice::Identity iceP_appObs;
    ::Ice::Identity iceP_adptObs;
    ::Ice::Identity iceP_objObs;
    istr->read(iceP_registryObs);
    istr->read(iceP_nodeObs);
    istr->read(iceP_appObs);
    istr->read(iceP_adptObs);
    istr->read(iceP_objObs);
    inS.endReadParams();
    this->setObserversByIdentity(iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_startUpdate(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    ::Ice::Int ret = this->startUpdate(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_finishUpdate(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    inS.readEmptyParams();
    this->finishUpdate(current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_getReplicaName(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::std::string ret = this->getReplicaName(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_openServerLog(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_id;
    ::std::string iceP_path;
    ::Ice::Int iceP_count;
    istr->read(iceP_id);
    istr->read(iceP_path);
    istr->read(iceP_count);
    inS.endReadParams();
    FileIteratorPrx ret = this->openServerLog(iceP_id, iceP_path, iceP_count, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_openServerStdErr(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_id;
    ::Ice::Int iceP_count;
    istr->read(iceP_id);
    istr->read(iceP_count);
    inS.endReadParams();
    FileIteratorPrx ret = this->openServerStdErr(iceP_id, iceP_count, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_openServerStdOut(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_id;
    ::Ice::Int iceP_count;
    istr->read(iceP_id);
    istr->read(iceP_count);
    inS.endReadParams();
    FileIteratorPrx ret = this->openServerStdOut(iceP_id, iceP_count, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_openNodeStdErr(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    ::Ice::Int iceP_count;
    istr->read(iceP_name);
    istr->read(iceP_count);
    inS.endReadParams();
    FileIteratorPrx ret = this->openNodeStdErr(iceP_name, iceP_count, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_openNodeStdOut(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    ::Ice::Int iceP_count;
    istr->read(iceP_name);
    istr->read(iceP_count);
    inS.endReadParams();
    FileIteratorPrx ret = this->openNodeStdOut(iceP_name, iceP_count, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_openRegistryStdErr(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    ::Ice::Int iceP_count;
    istr->read(iceP_name);
    istr->read(iceP_count);
    inS.endReadParams();
    FileIteratorPrx ret = this->openRegistryStdErr(iceP_name, iceP_count, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceD_openRegistryStdOut(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::std::string iceP_name;
    ::Ice::Int iceP_count;
    istr->read(iceP_name);
    istr->read(iceP_count);
    inS.endReadParams();
    FileIteratorPrx ret = this->openRegistryStdOut(iceP_name, iceP_count, current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceGrid_AdminSession_all[] =
{
    "destroy",
    "finishUpdate",
    "getAdmin",
    "getAdminCallbackTemplate",
    "getReplicaName",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "keepAlive",
    "openNodeStdErr",
    "openNodeStdOut",
    "openRegistryStdErr",
    "openRegistryStdOut",
    "openServerLog",
    "openServerStdErr",
    "openServerStdOut",
    "setObservers",
    "setObserversByIdentity",
    "startUpdate"
};

}

/// \cond INTERNAL
bool
IceGrid::AdminSession::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceGrid_AdminSession_all, iceC_IceGrid_AdminSession_all + 20, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceGrid_AdminSession_all)
    {
        case 0:
        {
            return _iceD_destroy(in, current);
        }
        case 1:
        {
            return _iceD_finishUpdate(in, current);
        }
        case 2:
        {
            return _iceD_getAdmin(in, current);
        }
        case 3:
        {
            return _iceD_getAdminCallbackTemplate(in, current);
        }
        case 4:
        {
            return _iceD_getReplicaName(in, current);
        }
        case 5:
        {
            return _iceD_ice_id(in, current);
        }
        case 6:
        {
            return _iceD_ice_ids(in, current);
        }
        case 7:
        {
            return _iceD_ice_isA(in, current);
        }
        case 8:
        {
            return _iceD_ice_ping(in, current);
        }
        case 9:
        {
            return _iceD_keepAlive(in, current);
        }
        case 10:
        {
            return _iceD_openNodeStdErr(in, current);
        }
        case 11:
        {
            return _iceD_openNodeStdOut(in, current);
        }
        case 12:
        {
            return _iceD_openRegistryStdErr(in, current);
        }
        case 13:
        {
            return _iceD_openRegistryStdOut(in, current);
        }
        case 14:
        {
            return _iceD_openServerLog(in, current);
        }
        case 15:
        {
            return _iceD_openServerStdErr(in, current);
        }
        case 16:
        {
            return _iceD_openServerStdOut(in, current);
        }
        case 17:
        {
            return _iceD_setObservers(in, current);
        }
        case 18:
        {
            return _iceD_setObserversByIdentity(in, current);
        }
        case 19:
        {
            return _iceD_startUpdate(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceGrid::AdminSession::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< AdminSession, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceGrid::AdminSession::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< AdminSession, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceGrid::_icePatchObjectPtr(AdminSessionPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = AdminSessionPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(AdminSession::ice_staticId(), v);
    }
}
/// \endcond

namespace Ice
{
}

#endif
