//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.10
//
// <auto-generated>
//
// Generated from file `Internal.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IceGrid_Internal_h__
#define __IceGrid_Internal_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/IncomingAsync.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/SlicedDataF.h>
#include <Ice/Identity.h>
#include <Ice/BuiltinSequences.h>
#include <Ice/ProcessF.h>
#include <Ice/Properties.h>
#include <Glacier2/Session.h>
#include <IceGrid/Admin.h>
#include <IceGrid/Registry.h>
#include <IceUtil/UndefSysMacros.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 10
#       error Ice patch level mismatch!
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceGrid
{

class InternalDbEnvDescriptor;
class InternalAdapterDescriptor;
class InternalDistributionDescriptor;
class InternalServerDescriptor;
class Adapter;
class AdapterPrx;
class FileReader;
class FileReaderPrx;
class Server;
class ServerPrx;
class InternalRegistry;
class InternalRegistryPrx;
class ReplicaObserver;
class ReplicaObserverPrx;
class PatcherFeedback;
class PatcherFeedbackPrx;
class Node;
class NodePrx;
class NodeSession;
class NodeSessionPrx;
class DatabaseObserver;
class DatabaseObserverPrx;
class ReplicaSession;
class ReplicaSessionPrx;
class InternalNodeInfo;
class InternalReplicaInfo;

}

namespace IceGrid
{

class SynchronizationException : public ::Ice::LocalExceptionHelper<SynchronizationException, ::Ice::LocalException>
{
public:

    virtual ~SynchronizationException();

    SynchronizationException(const SynchronizationException&) = default;

    /**
     * The file and line number are required for all local exceptions.
     * @param file The file name in which the exception was raised, typically __FILE__.
     * @param line The line number at which the exception was raised, typically __LINE__.
     */
    SynchronizationException(const char* file, int line) : ::Ice::LocalExceptionHelper<SynchronizationException, ::Ice::LocalException>(file, line)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();
};

using InternalDbEnvDescriptorSeq = ::std::vector<::std::shared_ptr<InternalDbEnvDescriptor>>;

using InternalAdapterDescriptorSeq = ::std::vector<::std::shared_ptr<InternalAdapterDescriptor>>;

using PropertyDescriptorSeqDict = ::std::map<::std::string, PropertyDescriptorSeq>;

/**
 * This exception is raised if an adapter is active.
 */
class AdapterActiveException : public ::Ice::UserExceptionHelper<AdapterActiveException, ::Ice::UserException>
{
public:

    virtual ~AdapterActiveException();

    AdapterActiveException(const AdapterActiveException&) = default;

    AdapterActiveException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();
};

/// \cond INTERNAL
static AdapterActiveException _iceS_AdapterActiveException_init;
/// \endcond

class AdapterNotActiveException : public ::Ice::UserExceptionHelper<AdapterNotActiveException, ::Ice::UserException>
{
public:

    virtual ~AdapterNotActiveException();

    AdapterNotActiveException(const AdapterNotActiveException&) = default;

    AdapterNotActiveException() = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param activatable True if the adapter can be activated on demand.
     */
    AdapterNotActiveException(bool activatable) :
        activatable(activatable)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const bool&> ice_tuple() const
    {
        return std::tie(activatable);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * True if the adapter can be activated on demand.
     */
    bool activatable;
};

/**
 * This exception is raised if an adapter with the same name already
 * exists.
 */
class AdapterExistsException : public ::Ice::UserExceptionHelper<AdapterExistsException, ::Ice::UserException>
{
public:

    virtual ~AdapterExistsException();

    AdapterExistsException(const AdapterExistsException&) = default;

    AdapterExistsException() = default;

    /**
     * One-shot constructor to initialize all data members.
     */
    AdapterExistsException(const ::std::string& id) :
        id(id)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(id);
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    ::std::string id;
};

using AdapterPrxDict = ::std::map<::std::string, ::std::shared_ptr<AdapterPrx>>;

using InternalRegistryPrxSeq = ::std::vector<::std::shared_ptr<InternalRegistryPrx>>;

using NodePrxSeq = ::std::vector<::std::shared_ptr<NodePrx>>;

/**
 * This exception is raised if a node is already registered and
 * active.
 */
class NodeActiveException : public ::Ice::UserExceptionHelper<NodeActiveException, ::Ice::UserException>
{
public:

    virtual ~NodeActiveException();

    NodeActiveException(const NodeActiveException&) = default;

    NodeActiveException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();
};

/**
 * This exception is raised if a replica is already registered and
 * active.
 */
class ReplicaActiveException : public ::Ice::UserExceptionHelper<ReplicaActiveException, ::Ice::UserException>
{
public:

    virtual ~ReplicaActiveException();

    ReplicaActiveException(const ReplicaActiveException&) = default;

    ReplicaActiveException() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();
};

enum class TopicName : unsigned char
{
    RegistryObserverTopicName,
    NodeObserverTopicName,
    ApplicationObserverTopicName,
    AdapterObserverTopicName,
    ObjectObserverTopicName
};

using StringLongDict = ::std::map<::std::string, long long int>;

}

namespace IceGrid
{

class Adapter : public virtual ::Ice::Object
{
public:

    using ProxyType = AdapterPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Activate this adapter. If this adapter can be activated, this
     * will activate the adapter and return the direct proxy of the
     * adapter once it's active. If this adapter can be activated on
     * demand, this will return 0 if the adapter is inactive or the
     * adapter direct proxy it's active.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void activateAsync(::std::function<void(const ::std::shared_ptr<::Ice::ObjectPrx>& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_activate(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get the adapter direct proxy. The adapter direct proxy is a
     * proxy created with the object adapter. The proxy contains the
     * last known adapter endpoints.
     * @param current The Current object for the invocation.
     * @return A direct proxy containing the last known adapter
     * endpoints if the adapter is already active.
     */
    virtual ::std::shared_ptr<::Ice::ObjectPrx> getDirectProxy(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getDirectProxy(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Set the direct proxy for this adapter.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AdapterActiveException The adapter is already
     * active. It's not possible to override the direct proxy of an
     * active adapter.
     */
    virtual void setDirectProxy(::std::shared_ptr<::Ice::ObjectPrx> proxy, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setDirectProxy(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

class FileReader : public virtual ::Ice::Object
{
public:

    using ProxyType = FileReaderPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Count the number of given lines from the end of the file and
     * return the file offset.
     * @param current The Current object for the invocation.
     */
    virtual long long int getOffsetFromEnd(::std::string filename, int lines, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getOffsetFromEnd(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Encapsulates the results of a call to read.
     */
    struct ReadResult
    {
        bool returnValue;
        long long int newPos;
        ::Ice::StringSeq lines;
    };

    /**
     * Read lines (or size bytes) at the specified position from the given file.
     * @param current The Current object for the invocation.
     */
    virtual bool read(::std::string filename, long long int pos, int size, long long int& newPos, ::Ice::StringSeq& lines, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_read(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

class Server : public virtual FileReader
{
public:

    using ProxyType = ServerPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Start the server.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void startAsync(::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_start(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Stop the server. This methods returns only when the server is
     * deactivated. If the server doesn't stop after a configurable
     * amount of time, it will be killed.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void stopAsync(::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_stop(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Check if the given server can be loaded on this node.
     * @param current The Current object for the invocation.
     * @return True if the server is inactive.
     * @throws IceGrid::DeploymentException Raised if the server can't be updated.
     */
    virtual bool checkUpdate(::std::shared_ptr<InternalServerDescriptor> svr, bool noRestart, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_checkUpdate(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Enable or disable the server.
     * @param current The Current object for the invocation.
     */
    virtual void setEnabled(bool enable, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setEnabled(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Check if the server is enabled.
     * @param current The Current object for the invocation.
     */
    virtual bool isEnabled(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_isEnabled(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Send signal to the server
     * @param current The Current object for the invocation.
     */
    virtual void sendSignal(::std::string signal, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_sendSignal(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Write message on servers' stdout or stderr.
     * @param current The Current object for the invocation.
     */
    virtual void writeMessage(::std::string message, int fd, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_writeMessage(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Return the server state.
     * @param current The Current object for the invocation.
     * @return The server state.
     * @see ServerState
     */
    virtual ServerState getState(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getState(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the server pid. Note that the value returned by this method
     * is system dependant. On Unix operating systems, it's the pid
     * value returned by the fork() system call and converted to an
     * integer.
     * @param current The Current object for the invocation.
     */
    virtual int getPid(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getPid(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Set the process proxy.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void setProcessAsync(::std::shared_ptr<::Ice::ProcessPrx> proc, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setProcess(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

class ReplicaObserver : public virtual ::Ice::Object
{
public:

    using ProxyType = ReplicaObserverPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Initialization of the replica observer.
     * @param current The Current object for the invocation.
     */
    virtual void replicaInit(InternalRegistryPrxSeq replicas, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_replicaInit(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Notification that a replica has been added. The node should
     * establish a session with this new replica.
     * @param current The Current object for the invocation.
     */
    virtual void replicaAdded(::std::shared_ptr<InternalRegistryPrx> replica, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_replicaAdded(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Notification that a replica has been removed. The node should
     * destroy the session to this replica.
     * @param current The Current object for the invocation.
     */
    virtual void replicaRemoved(::std::shared_ptr<InternalRegistryPrx> replica, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_replicaRemoved(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

class PatcherFeedback : public virtual ::Ice::Object
{
public:

    using ProxyType = PatcherFeedbackPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * The patch completed successfully.
     * @param current The Current object for the invocation.
     */
    virtual void finished(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_finished(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The patch on the given node failed for the given reason.
     * @param current The Current object for the invocation.
     */
    virtual void failed(::std::string reason, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_failed(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

class Node : public virtual FileReader,
             public virtual ReplicaObserver
{
public:

    using ProxyType = NodePrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Encapsulates the results of a call to loadServer.
     */
    struct LoadServerResult
    {
        ::std::shared_ptr<ServerPrx> returnValue;
        AdapterPrxDict adapters;
        int actTimeout;
        int deactTimeout;
    };

    /**
     * Load the given server. If the server resources weren't already
     * created (database environment directories, property files, etc),
     * they will be created.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void loadServerAsync(::std::shared_ptr<InternalServerDescriptor> svr, ::std::string replicaName, ::std::function<void(const ::std::shared_ptr<ServerPrx>& returnValue, const AdapterPrxDict& adapters, int actTimeout, int deactTimeout)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_loadServer(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Encapsulates the results of a call to loadServerWithoutRestart.
     */
    struct LoadServerWithoutRestartResult
    {
        ::std::shared_ptr<ServerPrx> returnValue;
        AdapterPrxDict adapters;
        int actTimeout;
        int deactTimeout;
    };

    /**
     * Load the given server and ensure the server won't be
     * restarted. If the server resources weren't already created
     * (database environment directories, property files, etc), they
     * will be created. If the server can't be updated without a
     * restart, a DeploymentException is raised.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void loadServerWithoutRestartAsync(::std::shared_ptr<InternalServerDescriptor> svr, ::std::string replicaName, ::std::function<void(const ::std::shared_ptr<ServerPrx>& returnValue, const AdapterPrxDict& adapters, int actTimeout, int deactTimeout)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_loadServerWithoutRestart(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Destroy the given server.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void destroyServerAsync(::std::string name, ::std::string uuid, int revision, ::std::string replicaName, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_destroyServer(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Destroy the server if it's not active.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void destroyServerWithoutRestartAsync(::std::string name, ::std::string uuid, int revision, ::std::string replicaName, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_destroyServerWithoutRestart(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Patch application and server distributions. If some servers
     * using a distribution directory to patch are active, this method
     * will raise a PatchException unless shutdown is set to true. In
     * which case the servers will be shutdown.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void patchAsync(::std::shared_ptr<PatcherFeedbackPrx> feedback, ::std::string application, ::std::string server, ::std::shared_ptr<InternalDistributionDescriptor> appDistrib, bool shutdown, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_patch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Establish a session to the given replica, this method only
     * returns once the registration was attempted (unlike
     * replicaAdded below).
     * @param current The Current object for the invocation.
     */
    virtual void registerWithReplica(::std::shared_ptr<InternalRegistryPrx> replica, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_registerWithReplica(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get the node name.
     * @param current The Current object for the invocation.
     */
    virtual ::std::string getName(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getName(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the node hostname.
     * @param current The Current object for the invocation.
     */
    virtual ::std::string getHostname(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getHostname(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the node load.
     * @param current The Current object for the invocation.
     */
    virtual LoadInfo getLoad(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getLoad(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the number of processor sockets for the machine where this
     * node is running.
     * @param current The Current object for the invocation.
     */
    virtual int getProcessorSocketCount(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getProcessorSocketCount(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Shutdown the node.
     * @param current The Current object for the invocation.
     */
    virtual void shutdown(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_shutdown(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

class NodeSession : public virtual ::Ice::Object
{
public:

    using ProxyType = NodeSessionPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * The node call this method to keep the session alive.
     * @param current The Current object for the invocation.
     */
    virtual void keepAlive(LoadInfo load, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_keepAlive(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set the replica observer. The node calls this method when it's
     * ready to receive notifications for the replicas. It only calls
     * this for the session with the master.
     * @param current The Current object for the invocation.
     */
    virtual void setReplicaObserver(::std::shared_ptr<ReplicaObserverPrx> observer, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setReplicaObserver(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Return the node session timeout.
     * @param current The Current object for the invocation.
     */
    virtual int getTimeout(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getTimeout(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Return the node observer.
     * @param current The Current object for the invocation.
     */
    virtual ::std::shared_ptr<NodeObserverPrx> getObserver(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getObserver(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Ask the registry to load the servers on the node.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void loadServersAsync(::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_loadServers(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the name of the servers deployed on the node.
     * @param current The Current object for the invocation.
     */
    virtual ::Ice::StringSeq getServers(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getServers(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Wait for the application update to complete (the application is
     * completely updated once all the registry replicas have been
     * updated). This is used by the node to ensure that before to
     * start a server all the replicas have the up-to-date descriptor
     * of the server.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     */
    virtual void waitForApplicationUpdateAsync(::std::string application, int revision, ::std::function<void()> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_waitForApplicationUpdate(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Destroy the session.
     * @param current The Current object for the invocation.
     */
    virtual void destroy(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_destroy(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

class DatabaseObserver : public virtual ApplicationObserver,
                         public virtual ObjectObserver,
                         public virtual AdapterObserver
{
public:

    using ProxyType = DatabaseObserverPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

class ReplicaSession : public virtual ::Ice::Object
{
public:

    using ProxyType = ReplicaSessionPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * The replica call this method to keep the session alive.
     * @param current The Current object for the invocation.
     */
    virtual void keepAlive(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_keepAlive(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Return the replica session timeout.
     * @param current The Current object for the invocation.
     */
    virtual int getTimeout(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getTimeout(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Set the database observer. Once the observer is subscribed, it
     * will receive the database and database updates.
     * @param current The Current object for the invocation.
     */
    virtual void setDatabaseObserver(::std::shared_ptr<DatabaseObserverPrx> dbObs, Ice::optional<StringLongDict> serials, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setDatabaseObserver(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * This method sets the endpoints of the replica. This allows the
     * master to create proxies with multiple endpoints for replicated
     * objects (e.g.: IceGrid::Query object).
     * @param current The Current object for the invocation.
     */
    virtual void setEndpoints(StringObjectProxyDict endpoints, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setEndpoints(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Registers the replica well-known objects with the master.
     * @param current The Current object for the invocation.
     */
    virtual void registerWellKnownObjects(ObjectInfoSeq objects, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_registerWellKnownObjects(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set the adapter direct proxy of the given adapter in the
     * master. This is used to support dynamic registration with
     * the locator registry interface.
     * @param current The Current object for the invocation.
     */
    virtual void setAdapterDirectProxy(::std::string adapterId, ::std::string replicaGroupId, ::std::shared_ptr<::Ice::ObjectPrx> proxy, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setAdapterDirectProxy(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Notify the master that an update was received. The master might
     * wait for replication updates to be received by all the replicas
     * before to continue.
     * @param current The Current object for the invocation.
     */
    virtual void receivedUpdate(TopicName name, int serial, ::std::string failure, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_receivedUpdate(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Destroy the session.
     * @param current The Current object for the invocation.
     */
    virtual void destroy(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_destroy(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

class InternalRegistry : public virtual FileReader
{
public:

    using ProxyType = InternalRegistryPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Register a node with the registry. If a node with the same name
     * is already registered, [registerNode] will overide the previous
     * node only if it's not active.
     * @param info Some information on the node.
     * @param prx The proxy of the node.
     * @param loadInf The load information of the node.
     * @param current The Current object for the invocation.
     * @return The node session proxy.
     * @throws IceGrid::NodeActiveException Raised if the node is already
     * registered and currently active.
     */
    virtual ::std::shared_ptr<NodeSessionPrx> registerNode(::std::shared_ptr<InternalNodeInfo> info, ::std::shared_ptr<NodePrx> prx, LoadInfo loadInf, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_registerNode(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Register a replica with the registry. If a replica with the
     * same name is already registered, [registerReplica] will overide
     * the previous replica only if it's not active.
     * @param info Some information on the replica.
     * @param prx The proxy of the replica.
     * @param current The Current object for the invocation.
     * @return The replica session proxy.
     * @throws IceGrid::ReplicaActiveException Raised if the replica is already
     * registered and currently active.
     */
    virtual ::std::shared_ptr<ReplicaSessionPrx> registerReplica(::std::shared_ptr<InternalReplicaInfo> info, ::std::shared_ptr<InternalRegistryPrx> prx, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_registerReplica(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Create a session with the given registry replica. This method
     * returns only once the session creation has been attempted.
     * @param current The Current object for the invocation.
     */
    virtual void registerWithReplica(::std::shared_ptr<InternalRegistryPrx> prx, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_registerWithReplica(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Return the proxies of all the nodes known by this registry.
     * @param current The Current object for the invocation.
     */
    virtual NodePrxSeq getNodes(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getNodes(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Return the proxies of all the registry replicas known by this
     * registry.
     * @param current The Current object for the invocation.
     */
    virtual InternalRegistryPrxSeq getReplicas(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getReplicas(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Encapsulates the results of a call to getApplications.
     */
    struct GetApplicationsResult
    {
        ApplicationInfoSeq returnValue;
        long long int serial;
    };

    /**
     * Return applications, adapters, objects from this replica.
     * @param current The Current object for the invocation.
     */
    virtual ApplicationInfoSeq getApplications(long long int& serial, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getApplications(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Encapsulates the results of a call to getAdapters.
     */
    struct GetAdaptersResult
    {
        AdapterInfoSeq returnValue;
        long long int serial;
    };

    virtual AdapterInfoSeq getAdapters(long long int& serial, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getAdapters(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Encapsulates the results of a call to getObjects.
     */
    struct GetObjectsResult
    {
        ObjectInfoSeq returnValue;
        long long int serial;
    };

    virtual ObjectInfoSeq getObjects(long long int& serial, const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getObjects(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Shutdown this registry.
     * @param current The Current object for the invocation.
     */
    virtual void shutdown(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_shutdown(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

}

namespace IceGrid
{

class InternalDbEnvDescriptor : public ::Ice::ValueHelper<InternalDbEnvDescriptor, ::Ice::Value>
{
public:

    virtual ~InternalDbEnvDescriptor();

    InternalDbEnvDescriptor() = default;

    InternalDbEnvDescriptor(const InternalDbEnvDescriptor&) = default;
    InternalDbEnvDescriptor(InternalDbEnvDescriptor&&) = default;
    InternalDbEnvDescriptor& operator=(const InternalDbEnvDescriptor&) = default;
    InternalDbEnvDescriptor& operator=(InternalDbEnvDescriptor&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param name The name of the database environment.
     * @param properties The database properties.
     */
    InternalDbEnvDescriptor(const ::std::string& name, const ::IceGrid::PropertyDescriptorSeq& properties) :
        name(name),
        properties(properties)
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&, const ::IceGrid::PropertyDescriptorSeq&> ice_tuple() const
    {
        return std::tie(name, properties);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * The name of the database environment.
     */
    ::std::string name;
    /**
     * The database properties.
     */
    ::IceGrid::PropertyDescriptorSeq properties;
};

/// \cond INTERNAL
static InternalDbEnvDescriptor _iceS_InternalDbEnvDescriptor_init;
/// \endcond

class InternalAdapterDescriptor : public ::Ice::ValueHelper<InternalAdapterDescriptor, ::Ice::Value>
{
public:

    virtual ~InternalAdapterDescriptor();

    InternalAdapterDescriptor() = default;

    InternalAdapterDescriptor(const InternalAdapterDescriptor&) = default;
    InternalAdapterDescriptor(InternalAdapterDescriptor&&) = default;
    InternalAdapterDescriptor& operator=(const InternalAdapterDescriptor&) = default;
    InternalAdapterDescriptor& operator=(InternalAdapterDescriptor&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param id The identifier of the server.
     * @param serverLifetime Specifies if the lifetime of the adapter is the same as the server.
     */
    InternalAdapterDescriptor(const ::std::string& id, bool serverLifetime) :
        id(id),
        serverLifetime(serverLifetime)
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&, const bool&> ice_tuple() const
    {
        return std::tie(id, serverLifetime);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * The identifier of the server.
     */
    ::std::string id;
    /**
     * Specifies if the lifetime of the adapter is the same as the server.
     */
    bool serverLifetime;
};

class InternalDistributionDescriptor : public ::Ice::ValueHelper<InternalDistributionDescriptor, ::Ice::Value>
{
public:

    virtual ~InternalDistributionDescriptor();

    InternalDistributionDescriptor() = default;

    InternalDistributionDescriptor(const InternalDistributionDescriptor&) = default;
    InternalDistributionDescriptor(InternalDistributionDescriptor&&) = default;
    InternalDistributionDescriptor& operator=(const InternalDistributionDescriptor&) = default;
    InternalDistributionDescriptor& operator=(InternalDistributionDescriptor&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param icepatch The proxy of the IcePatch2 server.
     * @param directories The source directories.
     */
    InternalDistributionDescriptor(const ::std::string& icepatch, const ::Ice::StringSeq& directories) :
        icepatch(icepatch),
        directories(directories)
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&, const ::Ice::StringSeq&> ice_tuple() const
    {
        return std::tie(icepatch, directories);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * The proxy of the IcePatch2 server.
     */
    ::std::string icepatch;
    /**
     * The source directories.
     */
    ::Ice::StringSeq directories;
};

class InternalServerDescriptor : public ::Ice::ValueHelper<InternalServerDescriptor, ::Ice::Value>
{
public:

    virtual ~InternalServerDescriptor();

    InternalServerDescriptor() = default;

    InternalServerDescriptor(const InternalServerDescriptor&) = default;
    InternalServerDescriptor(InternalServerDescriptor&&) = default;
    InternalServerDescriptor& operator=(const InternalServerDescriptor&) = default;
    InternalServerDescriptor& operator=(InternalServerDescriptor&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param id The server ID.
     * @param application The server application
     * @param uuid The application uuid.
     * @param revision The application revision.
     * @param sessionId The id of the session which allocated the server.
     * @param exe The server executable.
     * @param pwd The server working directory.
     * @param user The user ID to use to run the server.
     * @param activation The server activation mode.
     * @param activationTimeout The server activation timeout.
     * @param deactivationTimeout The server deactivation timeout.
     * @param applicationDistrib Specifies if the server depends on the application distrib.
     * @param distrib The distribution descriptor of this server.
     * @param processRegistered Specifies if a process object is registered.
     * @param options The server command line options.
     * @param envs The server environment variables.
     * @param logs The path of the server logs.
     * @param adapters The indirect object adapters.
     * @param dbEnvs The database environments.
     * @param properties The configuration files of the server.
     * @param services IceBox service names
     */
    InternalServerDescriptor(const ::std::string& id, const ::std::string& application, const ::std::string& uuid, int revision, const ::std::string& sessionId, const ::std::string& exe, const ::std::string& pwd, const ::std::string& user, const ::std::string& activation, const ::std::string& activationTimeout, const ::std::string& deactivationTimeout, bool applicationDistrib, const ::std::shared_ptr<::IceGrid::InternalDistributionDescriptor>& distrib, bool processRegistered, const ::Ice::StringSeq& options, const ::Ice::StringSeq& envs, const ::Ice::StringSeq& logs, const ::IceGrid::InternalAdapterDescriptorSeq& adapters, const ::IceGrid::InternalDbEnvDescriptorSeq& dbEnvs, const ::IceGrid::PropertyDescriptorSeqDict& properties, const Ice::optional<::Ice::StringSeq>& services) :
        id(id),
        application(application),
        uuid(uuid),
        revision(revision),
        sessionId(sessionId),
        exe(exe),
        pwd(pwd),
        user(user),
        activation(activation),
        activationTimeout(activationTimeout),
        deactivationTimeout(deactivationTimeout),
        applicationDistrib(applicationDistrib),
        distrib(distrib),
        processRegistered(processRegistered),
        options(options),
        envs(envs),
        logs(logs),
        adapters(adapters),
        dbEnvs(dbEnvs),
        properties(properties),
        services(services)
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&, const ::std::string&, const ::std::string&, const int&, const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const bool&, const ::std::shared_ptr<::IceGrid::InternalDistributionDescriptor>&, const bool&, const ::Ice::StringSeq&, const ::Ice::StringSeq&, const ::Ice::StringSeq&, const ::IceGrid::InternalAdapterDescriptorSeq&, const ::IceGrid::InternalDbEnvDescriptorSeq&, const ::IceGrid::PropertyDescriptorSeqDict&, const Ice::optional<::Ice::StringSeq>&> ice_tuple() const
    {
        return std::tie(id, application, uuid, revision, sessionId, exe, pwd, user, activation, activationTimeout, deactivationTimeout, applicationDistrib, distrib, processRegistered, options, envs, logs, adapters, dbEnvs, properties, services);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * The server ID.
     */
    ::std::string id;
    /**
     * The server application
     */
    ::std::string application;
    /**
     * The application uuid.
     */
    ::std::string uuid;
    /**
     * The application revision.
     */
    int revision;
    /**
     * The id of the session which allocated the server.
     */
    ::std::string sessionId;
    /**
     * The server executable.
     */
    ::std::string exe;
    /**
     * The server working directory.
     */
    ::std::string pwd;
    /**
     * The user ID to use to run the server.
     */
    ::std::string user;
    /**
     * The server activation mode.
     */
    ::std::string activation;
    /**
     * The server activation timeout.
     */
    ::std::string activationTimeout;
    /**
     * The server deactivation timeout.
     */
    ::std::string deactivationTimeout;
    /**
     * Specifies if the server depends on the application distrib.
     */
    bool applicationDistrib;
    /**
     * The distribution descriptor of this server.
     */
    ::std::shared_ptr<::IceGrid::InternalDistributionDescriptor> distrib;
    /**
     * Specifies if a process object is registered.
     */
    bool processRegistered;
    /**
     * The server command line options.
     */
    ::Ice::StringSeq options;
    /**
     * The server environment variables.
     */
    ::Ice::StringSeq envs;
    /**
     * The path of the server logs.
     */
    ::Ice::StringSeq logs;
    /**
     * The indirect object adapters.
     */
    ::IceGrid::InternalAdapterDescriptorSeq adapters;
    /**
     * The database environments.
     */
    ::IceGrid::InternalDbEnvDescriptorSeq dbEnvs;
    /**
     * The configuration files of the server.
     */
    ::IceGrid::PropertyDescriptorSeqDict properties;
    /**
     * IceBox service names
     */
    Ice::optional<::Ice::StringSeq> services;
};

/**
 * Information about an IceGrid node.
 */
class InternalNodeInfo : public ::Ice::ValueHelper<InternalNodeInfo, ::Ice::Value>
{
public:

    virtual ~InternalNodeInfo();

    InternalNodeInfo() = default;

    InternalNodeInfo(const InternalNodeInfo&) = default;
    InternalNodeInfo(InternalNodeInfo&&) = default;
    InternalNodeInfo& operator=(const InternalNodeInfo&) = default;
    InternalNodeInfo& operator=(InternalNodeInfo&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param name The name of the node.
     * @param os The operating system name.
     * @param hostname The network name of the host running this node (as defined in uname()).
     * @param release The operation system release level (as defined in uname()).
     * @param version The operation system version (as defined in uname()).
     * @param machine The machine hardware type (as defined in uname()).
     * @param nProcessors The number of processor threads (e.g.
     * @param dataDir The path to the node data directory.
     */
    InternalNodeInfo(const ::std::string& name, const ::std::string& os, const ::std::string& hostname, const ::std::string& release, const ::std::string& version, const ::std::string& machine, int nProcessors, const ::std::string& dataDir) :
        name(name),
        os(os),
        hostname(hostname),
        release(release),
        version(version),
        machine(machine),
        nProcessors(nProcessors),
        dataDir(dataDir)
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const int&, const ::std::string&> ice_tuple() const
    {
        return std::tie(name, os, hostname, release, version, machine, nProcessors, dataDir);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * The name of the node.
     */
    ::std::string name;
    /**
     * The operating system name.
     */
    ::std::string os;
    /**
     * The network name of the host running this node (as defined in
     * uname()).
     */
    ::std::string hostname;
    /**
     * The operation system release level (as defined in uname()).
     */
    ::std::string release;
    /**
     * The operation system version (as defined in uname()).
     */
    ::std::string version;
    /**
     * The machine hardware type (as defined in uname()).
     */
    ::std::string machine;
    /**
     * The number of processor threads (e.g. 8 on
     * system with 1 quad-core CPU, with 2 threads per core)
     */
    int nProcessors;
    /**
     * The path to the node data directory.
     */
    ::std::string dataDir;
};

/**
 * Information about an IceGrid registry replica.
 */
class InternalReplicaInfo : public ::Ice::ValueHelper<InternalReplicaInfo, ::Ice::Value>
{
public:

    virtual ~InternalReplicaInfo();

    InternalReplicaInfo() = default;

    InternalReplicaInfo(const InternalReplicaInfo&) = default;
    InternalReplicaInfo(InternalReplicaInfo&&) = default;
    InternalReplicaInfo& operator=(const InternalReplicaInfo&) = default;
    InternalReplicaInfo& operator=(InternalReplicaInfo&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param name The name of the registry.
     * @param hostname The network name of the host running this registry (as defined in uname()).
     */
    InternalReplicaInfo(const ::std::string& name, const ::std::string& hostname) :
        name(name),
        hostname(hostname)
    {
    }

    /**
     * Obtains a tuple containing all of the value's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(name, hostname);
    }

    /**
     * Obtains the Slice type ID of this value.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * The name of the registry.
     */
    ::std::string name;
    /**
     * The network name of the host running this registry (as defined in
     * uname()).
     */
    ::std::string hostname;
};

}

namespace IceGrid
{

class AdapterPrx : public virtual ::Ice::Proxy<AdapterPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Activate this adapter. If this adapter can be activated, this
     * will activate the adapter and return the direct proxy of the
     * adapter once it's active. If this adapter can be activated on
     * demand, this will return 0 if the adapter is inactive or the
     * adapter direct proxy it's active.
     * @param context The Context map to send with the invocation.
     */
    ::std::shared_ptr<::Ice::ObjectPrx> activate(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &AdapterPrx::_iceI_activate, context).get();
    }

    /**
     * Activate this adapter. If this adapter can be activated, this
     * will activate the adapter and return the direct proxy of the
     * adapter once it's active. If this adapter can be activated on
     * demand, this will return 0 if the adapter is inactive or the
     * adapter direct proxy it's active.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto activateAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &AdapterPrx::_iceI_activate, context);
    }

    /**
     * Activate this adapter. If this adapter can be activated, this
     * will activate the adapter and return the direct proxy of the
     * adapter once it's active. If this adapter can be activated on
     * demand, this will return 0 if the adapter is inactive or the
     * adapter direct proxy it's active.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    activateAsync(::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdapterPrx::_iceI_activate, context);
    }

    /// \cond INTERNAL
    void _iceI_activate(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the adapter direct proxy. The adapter direct proxy is a
     * proxy created with the object adapter. The proxy contains the
     * last known adapter endpoints.
     * @param context The Context map to send with the invocation.
     * @return A direct proxy containing the last known adapter
     * endpoints if the adapter is already active.
     */
    ::std::shared_ptr<::Ice::ObjectPrx> getDirectProxy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &AdapterPrx::_iceI_getDirectProxy, context).get();
    }

    /**
     * Get the adapter direct proxy. The adapter direct proxy is a
     * proxy created with the object adapter. The proxy contains the
     * last known adapter endpoints.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getDirectProxyAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &AdapterPrx::_iceI_getDirectProxy, context);
    }

    /**
     * Get the adapter direct proxy. The adapter direct proxy is a
     * proxy created with the object adapter. The proxy contains the
     * last known adapter endpoints.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getDirectProxyAsync(::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdapterPrx::_iceI_getDirectProxy, context);
    }

    /// \cond INTERNAL
    void _iceI_getDirectProxy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Set the direct proxy for this adapter.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::AdapterActiveException The adapter is already
     * active. It's not possible to override the direct proxy of an
     * active adapter.
     */
    void setDirectProxy(const ::std::shared_ptr<::Ice::ObjectPrx>& proxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &AdapterPrx::_iceI_setDirectProxy, proxy, context).get();
    }

    /**
     * Set the direct proxy for this adapter.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto setDirectProxyAsync(const ::std::shared_ptr<::Ice::ObjectPrx>& proxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &AdapterPrx::_iceI_setDirectProxy, proxy, context);
    }

    /**
     * Set the direct proxy for this adapter.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    setDirectProxyAsync(const ::std::shared_ptr<::Ice::ObjectPrx>& proxy,
                        ::std::function<void()> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::AdapterPrx::_iceI_setDirectProxy, proxy, context);
    }

    /// \cond INTERNAL
    void _iceI_setDirectProxy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    AdapterPrx() = default;
    friend ::std::shared_ptr<AdapterPrx> IceInternal::createProxy<AdapterPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

class FileReaderPrx : public virtual ::Ice::Proxy<FileReaderPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Count the number of given lines from the end of the file and
     * return the file offset.
     * @param context The Context map to send with the invocation.
     */
    long long int getOffsetFromEnd(const ::std::string& filename, int lines, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<long long int>(true, this, &FileReaderPrx::_iceI_getOffsetFromEnd, filename, lines, context).get();
    }

    /**
     * Count the number of given lines from the end of the file and
     * return the file offset.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getOffsetFromEndAsync(const ::std::string& filename, int lines, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<long long int>>().get_future())
    {
        return _makePromiseOutgoing<long long int, P>(false, this, &FileReaderPrx::_iceI_getOffsetFromEnd, filename, lines, context);
    }

    /**
     * Count the number of given lines from the end of the file and
     * return the file offset.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getOffsetFromEndAsync(const ::std::string& filename, int lines,
                          ::std::function<void(long long int)> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<long long int>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::FileReaderPrx::_iceI_getOffsetFromEnd, filename, lines, context);
    }

    /// \cond INTERNAL
    void _iceI_getOffsetFromEnd(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<long long int>>&, const ::std::string&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Read lines (or size bytes) at the specified position from the given file.
     * @param context The Context map to send with the invocation.
     */
    bool read(const ::std::string& filename, long long int pos, int size, long long int& newPos, ::Ice::StringSeq& lines, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _result = _makePromiseOutgoing<FileReader::ReadResult>(true, this, &FileReaderPrx::_iceI_read, filename, pos, size, context).get();
        newPos = _result.newPos;
        lines = ::std::move(_result.lines);
        return _result.returnValue;
    }

    /**
     * Read lines (or size bytes) at the specified position from the given file.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto readAsync(const ::std::string& filename, long long int pos, int size, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<FileReader::ReadResult>>().get_future())
    {
        return _makePromiseOutgoing<FileReader::ReadResult, P>(false, this, &FileReaderPrx::_iceI_read, filename, pos, size, context);
    }

    /**
     * Read lines (or size bytes) at the specified position from the given file.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    readAsync(const ::std::string& filename, long long int pos, int size,
              ::std::function<void(bool, long long int, ::Ice::StringSeq)> response,
              ::std::function<void(::std::exception_ptr)> ex = nullptr,
              ::std::function<void(bool)> sent = nullptr,
              const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _responseCb = [response](FileReader::ReadResult&& _result)
        {
            response(_result.returnValue, _result.newPos, ::std::move(_result.lines));
        };
        return _makeLamdaOutgoing<FileReader::ReadResult>(std::move(_responseCb), std::move(ex), std::move(sent), this, &IceGrid::FileReaderPrx::_iceI_read, filename, pos, size, context);
    }

    /// \cond INTERNAL
    void _iceI_read(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<FileReader::ReadResult>>&, const ::std::string&, long long int, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    FileReaderPrx() = default;
    friend ::std::shared_ptr<FileReaderPrx> IceInternal::createProxy<FileReaderPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

class ServerPrx : public virtual ::Ice::Proxy<ServerPrx, FileReaderPrx>
{
public:

    /**
     * Start the server.
     * @param context The Context map to send with the invocation.
     */
    void start(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_start, context).get();
    }

    /**
     * Start the server.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto startAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_start, context);
    }

    /**
     * Start the server.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    startAsync(::std::function<void()> response,
               ::std::function<void(::std::exception_ptr)> ex = nullptr,
               ::std::function<void(bool)> sent = nullptr,
               const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ServerPrx::_iceI_start, context);
    }

    /// \cond INTERNAL
    void _iceI_start(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Stop the server. This methods returns only when the server is
     * deactivated. If the server doesn't stop after a configurable
     * amount of time, it will be killed.
     * @param context The Context map to send with the invocation.
     */
    void stop(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_stop, context).get();
    }

    /**
     * Stop the server. This methods returns only when the server is
     * deactivated. If the server doesn't stop after a configurable
     * amount of time, it will be killed.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto stopAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_stop, context);
    }

    /**
     * Stop the server. This methods returns only when the server is
     * deactivated. If the server doesn't stop after a configurable
     * amount of time, it will be killed.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    stopAsync(::std::function<void()> response,
              ::std::function<void(::std::exception_ptr)> ex = nullptr,
              ::std::function<void(bool)> sent = nullptr,
              const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ServerPrx::_iceI_stop, context);
    }

    /// \cond INTERNAL
    void _iceI_stop(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Check if the given server can be loaded on this node.
     * @param context The Context map to send with the invocation.
     * @return True if the server is inactive.
     * @throws IceGrid::DeploymentException Raised if the server can't be updated.
     */
    bool checkUpdate(const ::std::shared_ptr<InternalServerDescriptor>& svr, bool noRestart, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<bool>(true, this, &ServerPrx::_iceI_checkUpdate, svr, noRestart, context).get();
    }

    /**
     * Check if the given server can be loaded on this node.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto checkUpdateAsync(const ::std::shared_ptr<InternalServerDescriptor>& svr, bool noRestart, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<bool>>().get_future())
    {
        return _makePromiseOutgoing<bool, P>(false, this, &ServerPrx::_iceI_checkUpdate, svr, noRestart, context);
    }

    /**
     * Check if the given server can be loaded on this node.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    checkUpdateAsync(const ::std::shared_ptr<InternalServerDescriptor>& svr, bool noRestart,
                     ::std::function<void(bool)> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<bool>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ServerPrx::_iceI_checkUpdate, svr, noRestart, context);
    }

    /// \cond INTERNAL
    void _iceI_checkUpdate(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<bool>>&, const ::std::shared_ptr<InternalServerDescriptor>&, bool, const ::Ice::Context&);
    /// \endcond

    /**
     * Enable or disable the server.
     * @param context The Context map to send with the invocation.
     */
    void setEnabled(bool enable, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_setEnabled, enable, context).get();
    }

    /**
     * Enable or disable the server.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto setEnabledAsync(bool enable, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_setEnabled, enable, context);
    }

    /**
     * Enable or disable the server.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    setEnabledAsync(bool enable,
                    ::std::function<void()> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ServerPrx::_iceI_setEnabled, enable, context);
    }

    /// \cond INTERNAL
    void _iceI_setEnabled(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, bool, const ::Ice::Context&);
    /// \endcond

    /**
     * Check if the server is enabled.
     * @param context The Context map to send with the invocation.
     */
    bool isEnabled(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<bool>(true, this, &ServerPrx::_iceI_isEnabled, context).get();
    }

    /**
     * Check if the server is enabled.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto isEnabledAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<bool>>().get_future())
    {
        return _makePromiseOutgoing<bool, P>(false, this, &ServerPrx::_iceI_isEnabled, context);
    }

    /**
     * Check if the server is enabled.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    isEnabledAsync(::std::function<void(bool)> response,
                   ::std::function<void(::std::exception_ptr)> ex = nullptr,
                   ::std::function<void(bool)> sent = nullptr,
                   const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<bool>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ServerPrx::_iceI_isEnabled, context);
    }

    /// \cond INTERNAL
    void _iceI_isEnabled(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<bool>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Send signal to the server
     * @param context The Context map to send with the invocation.
     */
    void sendSignal(const ::std::string& signal, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_sendSignal, signal, context).get();
    }

    /**
     * Send signal to the server
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto sendSignalAsync(const ::std::string& signal, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_sendSignal, signal, context);
    }

    /**
     * Send signal to the server
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    sendSignalAsync(const ::std::string& signal,
                    ::std::function<void()> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ServerPrx::_iceI_sendSignal, signal, context);
    }

    /// \cond INTERNAL
    void _iceI_sendSignal(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Write message on servers' stdout or stderr.
     * @param context The Context map to send with the invocation.
     */
    void writeMessage(const ::std::string& message, int fd, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_writeMessage, message, fd, context).get();
    }

    /**
     * Write message on servers' stdout or stderr.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto writeMessageAsync(const ::std::string& message, int fd, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_writeMessage, message, fd, context);
    }

    /**
     * Write message on servers' stdout or stderr.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    writeMessageAsync(const ::std::string& message, int fd,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ServerPrx::_iceI_writeMessage, message, fd, context);
    }

    /// \cond INTERNAL
    void _iceI_writeMessage(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Return the server state.
     * @param context The Context map to send with the invocation.
     * @return The server state.
     * @see ServerState
     */
    ServerState getState(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::ServerState>(true, this, &ServerPrx::_iceI_getState, context).get();
    }

    /**
     * Return the server state.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see ServerState
     */
    template<template<typename> class P = ::std::promise>
    auto getStateAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::ServerState>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::ServerState, P>(false, this, &ServerPrx::_iceI_getState, context);
    }

    /**
     * Return the server state.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see ServerState
     */
    ::std::function<void()>
    getStateAsync(::std::function<void(::IceGrid::ServerState)> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::ServerState>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ServerPrx::_iceI_getState, context);
    }

    /// \cond INTERNAL
    void _iceI_getState(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ServerState>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the server pid. Note that the value returned by this method
     * is system dependant. On Unix operating systems, it's the pid
     * value returned by the fork() system call and converted to an
     * integer.
     * @param context The Context map to send with the invocation.
     */
    int getPid(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &ServerPrx::_iceI_getPid, context).get();
    }

    /**
     * Get the server pid. Note that the value returned by this method
     * is system dependant. On Unix operating systems, it's the pid
     * value returned by the fork() system call and converted to an
     * integer.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getPidAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &ServerPrx::_iceI_getPid, context);
    }

    /**
     * Get the server pid. Note that the value returned by this method
     * is system dependant. On Unix operating systems, it's the pid
     * value returned by the fork() system call and converted to an
     * integer.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getPidAsync(::std::function<void(int)> response,
                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                ::std::function<void(bool)> sent = nullptr,
                const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ServerPrx::_iceI_getPid, context);
    }

    /// \cond INTERNAL
    void _iceI_getPid(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Set the process proxy.
     * @param context The Context map to send with the invocation.
     */
    void setProcess(const ::std::shared_ptr<::Ice::ProcessPrx>& proc, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ServerPrx::_iceI_setProcess, proc, context).get();
    }

    /**
     * Set the process proxy.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto setProcessAsync(const ::std::shared_ptr<::Ice::ProcessPrx>& proc, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ServerPrx::_iceI_setProcess, proc, context);
    }

    /**
     * Set the process proxy.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    setProcessAsync(const ::std::shared_ptr<::Ice::ProcessPrx>& proc,
                    ::std::function<void()> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ServerPrx::_iceI_setProcess, proc, context);
    }

    /// \cond INTERNAL
    void _iceI_setProcess(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<::Ice::ProcessPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    ServerPrx() = default;
    friend ::std::shared_ptr<ServerPrx> IceInternal::createProxy<ServerPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

class ReplicaObserverPrx : public virtual ::Ice::Proxy<ReplicaObserverPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Initialization of the replica observer.
     * @param context The Context map to send with the invocation.
     */
    void replicaInit(const InternalRegistryPrxSeq& replicas, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ReplicaObserverPrx::_iceI_replicaInit, replicas, context).get();
    }

    /**
     * Initialization of the replica observer.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto replicaInitAsync(const InternalRegistryPrxSeq& replicas, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ReplicaObserverPrx::_iceI_replicaInit, replicas, context);
    }

    /**
     * Initialization of the replica observer.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    replicaInitAsync(const InternalRegistryPrxSeq& replicas,
                     ::std::function<void()> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ReplicaObserverPrx::_iceI_replicaInit, replicas, context);
    }

    /// \cond INTERNAL
    void _iceI_replicaInit(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const InternalRegistryPrxSeq&, const ::Ice::Context&);
    /// \endcond

    /**
     * Notification that a replica has been added. The node should
     * establish a session with this new replica.
     * @param context The Context map to send with the invocation.
     */
    void replicaAdded(const ::std::shared_ptr<InternalRegistryPrx>& replica, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ReplicaObserverPrx::_iceI_replicaAdded, replica, context).get();
    }

    /**
     * Notification that a replica has been added. The node should
     * establish a session with this new replica.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto replicaAddedAsync(const ::std::shared_ptr<InternalRegistryPrx>& replica, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ReplicaObserverPrx::_iceI_replicaAdded, replica, context);
    }

    /**
     * Notification that a replica has been added. The node should
     * establish a session with this new replica.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    replicaAddedAsync(const ::std::shared_ptr<InternalRegistryPrx>& replica,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ReplicaObserverPrx::_iceI_replicaAdded, replica, context);
    }

    /// \cond INTERNAL
    void _iceI_replicaAdded(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<InternalRegistryPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Notification that a replica has been removed. The node should
     * destroy the session to this replica.
     * @param context The Context map to send with the invocation.
     */
    void replicaRemoved(const ::std::shared_ptr<InternalRegistryPrx>& replica, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ReplicaObserverPrx::_iceI_replicaRemoved, replica, context).get();
    }

    /**
     * Notification that a replica has been removed. The node should
     * destroy the session to this replica.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto replicaRemovedAsync(const ::std::shared_ptr<InternalRegistryPrx>& replica, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ReplicaObserverPrx::_iceI_replicaRemoved, replica, context);
    }

    /**
     * Notification that a replica has been removed. The node should
     * destroy the session to this replica.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    replicaRemovedAsync(const ::std::shared_ptr<InternalRegistryPrx>& replica,
                        ::std::function<void()> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ReplicaObserverPrx::_iceI_replicaRemoved, replica, context);
    }

    /// \cond INTERNAL
    void _iceI_replicaRemoved(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<InternalRegistryPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    ReplicaObserverPrx() = default;
    friend ::std::shared_ptr<ReplicaObserverPrx> IceInternal::createProxy<ReplicaObserverPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

class PatcherFeedbackPrx : public virtual ::Ice::Proxy<PatcherFeedbackPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * The patch completed successfully.
     * @param context The Context map to send with the invocation.
     */
    void finished(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &PatcherFeedbackPrx::_iceI_finished, context).get();
    }

    /**
     * The patch completed successfully.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto finishedAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &PatcherFeedbackPrx::_iceI_finished, context);
    }

    /**
     * The patch completed successfully.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    finishedAsync(::std::function<void()> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::PatcherFeedbackPrx::_iceI_finished, context);
    }

    /// \cond INTERNAL
    void _iceI_finished(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * The patch on the given node failed for the given reason.
     * @param context The Context map to send with the invocation.
     */
    void failed(const ::std::string& reason, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &PatcherFeedbackPrx::_iceI_failed, reason, context).get();
    }

    /**
     * The patch on the given node failed for the given reason.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto failedAsync(const ::std::string& reason, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &PatcherFeedbackPrx::_iceI_failed, reason, context);
    }

    /**
     * The patch on the given node failed for the given reason.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    failedAsync(const ::std::string& reason,
                ::std::function<void()> response,
                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                ::std::function<void(bool)> sent = nullptr,
                const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::PatcherFeedbackPrx::_iceI_failed, reason, context);
    }

    /// \cond INTERNAL
    void _iceI_failed(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    PatcherFeedbackPrx() = default;
    friend ::std::shared_ptr<PatcherFeedbackPrx> IceInternal::createProxy<PatcherFeedbackPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

class NodePrx : public virtual ::Ice::Proxy<NodePrx, FileReaderPrx, ReplicaObserverPrx>
{
public:

    /**
     * Load the given server. If the server resources weren't already
     * created (database environment directories, property files, etc),
     * they will be created.
     * @param context The Context map to send with the invocation.
     */
    ::std::shared_ptr<ServerPrx> loadServer(const ::std::shared_ptr<InternalServerDescriptor>& svr, const ::std::string& replicaName, AdapterPrxDict& adapters, int& actTimeout, int& deactTimeout, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _result = _makePromiseOutgoing<Node::LoadServerResult>(true, this, &NodePrx::_iceI_loadServer, svr, replicaName, context).get();
        adapters = ::std::move(_result.adapters);
        actTimeout = _result.actTimeout;
        deactTimeout = _result.deactTimeout;
        return ::std::move(_result.returnValue);
    }

    /**
     * Load the given server. If the server resources weren't already
     * created (database environment directories, property files, etc),
     * they will be created.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto loadServerAsync(const ::std::shared_ptr<InternalServerDescriptor>& svr, const ::std::string& replicaName, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<Node::LoadServerResult>>().get_future())
    {
        return _makePromiseOutgoing<Node::LoadServerResult, P>(false, this, &NodePrx::_iceI_loadServer, svr, replicaName, context);
    }

    /**
     * Load the given server. If the server resources weren't already
     * created (database environment directories, property files, etc),
     * they will be created.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    loadServerAsync(const ::std::shared_ptr<InternalServerDescriptor>& svr, const ::std::string& replicaName,
                    ::std::function<void(::std::shared_ptr<::IceGrid::ServerPrx>, ::IceGrid::AdapterPrxDict, int, int)> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _responseCb = [response](Node::LoadServerResult&& _result)
        {
            response(::std::move(_result.returnValue), ::std::move(_result.adapters), _result.actTimeout, _result.deactTimeout);
        };
        return _makeLamdaOutgoing<Node::LoadServerResult>(std::move(_responseCb), std::move(ex), std::move(sent), this, &IceGrid::NodePrx::_iceI_loadServer, svr, replicaName, context);
    }

    /// \cond INTERNAL
    void _iceI_loadServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<Node::LoadServerResult>>&, const ::std::shared_ptr<InternalServerDescriptor>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Load the given server and ensure the server won't be
     * restarted. If the server resources weren't already created
     * (database environment directories, property files, etc), they
     * will be created. If the server can't be updated without a
     * restart, a DeploymentException is raised.
     * @param context The Context map to send with the invocation.
     */
    ::std::shared_ptr<ServerPrx> loadServerWithoutRestart(const ::std::shared_ptr<InternalServerDescriptor>& svr, const ::std::string& replicaName, AdapterPrxDict& adapters, int& actTimeout, int& deactTimeout, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _result = _makePromiseOutgoing<Node::LoadServerWithoutRestartResult>(true, this, &NodePrx::_iceI_loadServerWithoutRestart, svr, replicaName, context).get();
        adapters = ::std::move(_result.adapters);
        actTimeout = _result.actTimeout;
        deactTimeout = _result.deactTimeout;
        return ::std::move(_result.returnValue);
    }

    /**
     * Load the given server and ensure the server won't be
     * restarted. If the server resources weren't already created
     * (database environment directories, property files, etc), they
     * will be created. If the server can't be updated without a
     * restart, a DeploymentException is raised.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto loadServerWithoutRestartAsync(const ::std::shared_ptr<InternalServerDescriptor>& svr, const ::std::string& replicaName, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<Node::LoadServerWithoutRestartResult>>().get_future())
    {
        return _makePromiseOutgoing<Node::LoadServerWithoutRestartResult, P>(false, this, &NodePrx::_iceI_loadServerWithoutRestart, svr, replicaName, context);
    }

    /**
     * Load the given server and ensure the server won't be
     * restarted. If the server resources weren't already created
     * (database environment directories, property files, etc), they
     * will be created. If the server can't be updated without a
     * restart, a DeploymentException is raised.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    loadServerWithoutRestartAsync(const ::std::shared_ptr<InternalServerDescriptor>& svr, const ::std::string& replicaName,
                                  ::std::function<void(::std::shared_ptr<::IceGrid::ServerPrx>, ::IceGrid::AdapterPrxDict, int, int)> response,
                                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                  ::std::function<void(bool)> sent = nullptr,
                                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _responseCb = [response](Node::LoadServerWithoutRestartResult&& _result)
        {
            response(::std::move(_result.returnValue), ::std::move(_result.adapters), _result.actTimeout, _result.deactTimeout);
        };
        return _makeLamdaOutgoing<Node::LoadServerWithoutRestartResult>(std::move(_responseCb), std::move(ex), std::move(sent), this, &IceGrid::NodePrx::_iceI_loadServerWithoutRestart, svr, replicaName, context);
    }

    /// \cond INTERNAL
    void _iceI_loadServerWithoutRestart(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<Node::LoadServerWithoutRestartResult>>&, const ::std::shared_ptr<InternalServerDescriptor>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Destroy the given server.
     * @param context The Context map to send with the invocation.
     */
    void destroyServer(const ::std::string& name, const ::std::string& uuid, int revision, const ::std::string& replicaName, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &NodePrx::_iceI_destroyServer, name, uuid, revision, replicaName, context).get();
    }

    /**
     * Destroy the given server.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto destroyServerAsync(const ::std::string& name, const ::std::string& uuid, int revision, const ::std::string& replicaName, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &NodePrx::_iceI_destroyServer, name, uuid, revision, replicaName, context);
    }

    /**
     * Destroy the given server.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    destroyServerAsync(const ::std::string& name, const ::std::string& uuid, int revision, const ::std::string& replicaName,
                       ::std::function<void()> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::NodePrx::_iceI_destroyServer, name, uuid, revision, replicaName, context);
    }

    /// \cond INTERNAL
    void _iceI_destroyServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::std::string&, int, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Destroy the server if it's not active.
     * @param context The Context map to send with the invocation.
     */
    void destroyServerWithoutRestart(const ::std::string& name, const ::std::string& uuid, int revision, const ::std::string& replicaName, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &NodePrx::_iceI_destroyServerWithoutRestart, name, uuid, revision, replicaName, context).get();
    }

    /**
     * Destroy the server if it's not active.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto destroyServerWithoutRestartAsync(const ::std::string& name, const ::std::string& uuid, int revision, const ::std::string& replicaName, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &NodePrx::_iceI_destroyServerWithoutRestart, name, uuid, revision, replicaName, context);
    }

    /**
     * Destroy the server if it's not active.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    destroyServerWithoutRestartAsync(const ::std::string& name, const ::std::string& uuid, int revision, const ::std::string& replicaName,
                                     ::std::function<void()> response,
                                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                     ::std::function<void(bool)> sent = nullptr,
                                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::NodePrx::_iceI_destroyServerWithoutRestart, name, uuid, revision, replicaName, context);
    }

    /// \cond INTERNAL
    void _iceI_destroyServerWithoutRestart(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::std::string&, int, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Patch application and server distributions. If some servers
     * using a distribution directory to patch are active, this method
     * will raise a PatchException unless shutdown is set to true. In
     * which case the servers will be shutdown.
     * @param context The Context map to send with the invocation.
     */
    void patch(const ::std::shared_ptr<PatcherFeedbackPrx>& feedback, const ::std::string& application, const ::std::string& server, const ::std::shared_ptr<InternalDistributionDescriptor>& appDistrib, bool shutdown, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &NodePrx::_iceI_patch, feedback, application, server, appDistrib, shutdown, context).get();
    }

    /**
     * Patch application and server distributions. If some servers
     * using a distribution directory to patch are active, this method
     * will raise a PatchException unless shutdown is set to true. In
     * which case the servers will be shutdown.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto patchAsync(const ::std::shared_ptr<PatcherFeedbackPrx>& feedback, const ::std::string& application, const ::std::string& server, const ::std::shared_ptr<InternalDistributionDescriptor>& appDistrib, bool shutdown, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &NodePrx::_iceI_patch, feedback, application, server, appDistrib, shutdown, context);
    }

    /**
     * Patch application and server distributions. If some servers
     * using a distribution directory to patch are active, this method
     * will raise a PatchException unless shutdown is set to true. In
     * which case the servers will be shutdown.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    patchAsync(const ::std::shared_ptr<PatcherFeedbackPrx>& feedback, const ::std::string& application, const ::std::string& server, const ::std::shared_ptr<InternalDistributionDescriptor>& appDistrib, bool shutdown,
               ::std::function<void()> response,
               ::std::function<void(::std::exception_ptr)> ex = nullptr,
               ::std::function<void(bool)> sent = nullptr,
               const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::NodePrx::_iceI_patch, feedback, application, server, appDistrib, shutdown, context);
    }

    /// \cond INTERNAL
    void _iceI_patch(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<PatcherFeedbackPrx>&, const ::std::string&, const ::std::string&, const ::std::shared_ptr<InternalDistributionDescriptor>&, bool, const ::Ice::Context&);
    /// \endcond

    /**
     * Establish a session to the given replica, this method only
     * returns once the registration was attempted (unlike
     * replicaAdded below).
     * @param context The Context map to send with the invocation.
     */
    void registerWithReplica(const ::std::shared_ptr<InternalRegistryPrx>& replica, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &NodePrx::_iceI_registerWithReplica, replica, context).get();
    }

    /**
     * Establish a session to the given replica, this method only
     * returns once the registration was attempted (unlike
     * replicaAdded below).
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto registerWithReplicaAsync(const ::std::shared_ptr<InternalRegistryPrx>& replica, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &NodePrx::_iceI_registerWithReplica, replica, context);
    }

    /**
     * Establish a session to the given replica, this method only
     * returns once the registration was attempted (unlike
     * replicaAdded below).
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    registerWithReplicaAsync(const ::std::shared_ptr<InternalRegistryPrx>& replica,
                             ::std::function<void()> response,
                             ::std::function<void(::std::exception_ptr)> ex = nullptr,
                             ::std::function<void(bool)> sent = nullptr,
                             const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::NodePrx::_iceI_registerWithReplica, replica, context);
    }

    /// \cond INTERNAL
    void _iceI_registerWithReplica(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<InternalRegistryPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the node name.
     * @param context The Context map to send with the invocation.
     */
    ::std::string getName(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::string>(true, this, &NodePrx::_iceI_getName, context).get();
    }

    /**
     * Get the node name.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getNameAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::string>>().get_future())
    {
        return _makePromiseOutgoing<::std::string, P>(false, this, &NodePrx::_iceI_getName, context);
    }

    /**
     * Get the node name.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getNameAsync(::std::function<void(::std::string)> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::string>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::NodePrx::_iceI_getName, context);
    }

    /// \cond INTERNAL
    void _iceI_getName(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the node hostname.
     * @param context The Context map to send with the invocation.
     */
    ::std::string getHostname(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::string>(true, this, &NodePrx::_iceI_getHostname, context).get();
    }

    /**
     * Get the node hostname.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getHostnameAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::string>>().get_future())
    {
        return _makePromiseOutgoing<::std::string, P>(false, this, &NodePrx::_iceI_getHostname, context);
    }

    /**
     * Get the node hostname.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getHostnameAsync(::std::function<void(::std::string)> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::string>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::NodePrx::_iceI_getHostname, context);
    }

    /// \cond INTERNAL
    void _iceI_getHostname(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the node load.
     * @param context The Context map to send with the invocation.
     */
    LoadInfo getLoad(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::LoadInfo>(true, this, &NodePrx::_iceI_getLoad, context).get();
    }

    /**
     * Get the node load.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getLoadAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::LoadInfo>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::LoadInfo, P>(false, this, &NodePrx::_iceI_getLoad, context);
    }

    /**
     * Get the node load.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getLoadAsync(::std::function<void(::IceGrid::LoadInfo)> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::LoadInfo>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::NodePrx::_iceI_getLoad, context);
    }

    /// \cond INTERNAL
    void _iceI_getLoad(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::LoadInfo>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the number of processor sockets for the machine where this
     * node is running.
     * @param context The Context map to send with the invocation.
     */
    int getProcessorSocketCount(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &NodePrx::_iceI_getProcessorSocketCount, context).get();
    }

    /**
     * Get the number of processor sockets for the machine where this
     * node is running.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getProcessorSocketCountAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &NodePrx::_iceI_getProcessorSocketCount, context);
    }

    /**
     * Get the number of processor sockets for the machine where this
     * node is running.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getProcessorSocketCountAsync(::std::function<void(int)> response,
                                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                 ::std::function<void(bool)> sent = nullptr,
                                 const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::NodePrx::_iceI_getProcessorSocketCount, context);
    }

    /// \cond INTERNAL
    void _iceI_getProcessorSocketCount(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Shutdown the node.
     * @param context The Context map to send with the invocation.
     */
    void shutdown(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &NodePrx::_iceI_shutdown, context).get();
    }

    /**
     * Shutdown the node.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto shutdownAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &NodePrx::_iceI_shutdown, context);
    }

    /**
     * Shutdown the node.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    shutdownAsync(::std::function<void()> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::NodePrx::_iceI_shutdown, context);
    }

    /// \cond INTERNAL
    void _iceI_shutdown(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    NodePrx() = default;
    friend ::std::shared_ptr<NodePrx> IceInternal::createProxy<NodePrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

class NodeSessionPrx : public virtual ::Ice::Proxy<NodeSessionPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * The node call this method to keep the session alive.
     * @param context The Context map to send with the invocation.
     */
    void keepAlive(const LoadInfo& load, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &NodeSessionPrx::_iceI_keepAlive, load, context).get();
    }

    /**
     * The node call this method to keep the session alive.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto keepAliveAsync(const LoadInfo& load, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &NodeSessionPrx::_iceI_keepAlive, load, context);
    }

    /**
     * The node call this method to keep the session alive.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    keepAliveAsync(const LoadInfo& load,
                   ::std::function<void()> response,
                   ::std::function<void(::std::exception_ptr)> ex = nullptr,
                   ::std::function<void(bool)> sent = nullptr,
                   const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::NodeSessionPrx::_iceI_keepAlive, load, context);
    }

    /// \cond INTERNAL
    void _iceI_keepAlive(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const LoadInfo&, const ::Ice::Context&);
    /// \endcond

    /**
     * Set the replica observer. The node calls this method when it's
     * ready to receive notifications for the replicas. It only calls
     * this for the session with the master.
     * @param context The Context map to send with the invocation.
     */
    void setReplicaObserver(const ::std::shared_ptr<ReplicaObserverPrx>& observer, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &NodeSessionPrx::_iceI_setReplicaObserver, observer, context).get();
    }

    /**
     * Set the replica observer. The node calls this method when it's
     * ready to receive notifications for the replicas. It only calls
     * this for the session with the master.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto setReplicaObserverAsync(const ::std::shared_ptr<ReplicaObserverPrx>& observer, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &NodeSessionPrx::_iceI_setReplicaObserver, observer, context);
    }

    /**
     * Set the replica observer. The node calls this method when it's
     * ready to receive notifications for the replicas. It only calls
     * this for the session with the master.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    setReplicaObserverAsync(const ::std::shared_ptr<ReplicaObserverPrx>& observer,
                            ::std::function<void()> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::NodeSessionPrx::_iceI_setReplicaObserver, observer, context);
    }

    /// \cond INTERNAL
    void _iceI_setReplicaObserver(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<ReplicaObserverPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Return the node session timeout.
     * @param context The Context map to send with the invocation.
     */
    int getTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &NodeSessionPrx::_iceI_getTimeout, context).get();
    }

    /**
     * Return the node session timeout.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getTimeoutAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &NodeSessionPrx::_iceI_getTimeout, context);
    }

    /**
     * Return the node session timeout.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getTimeoutAsync(::std::function<void(int)> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::NodeSessionPrx::_iceI_getTimeout, context);
    }

    /// \cond INTERNAL
    void _iceI_getTimeout(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Return the node observer.
     * @param context The Context map to send with the invocation.
     */
    ::std::shared_ptr<NodeObserverPrx> getObserver(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::NodeObserverPrx>>(true, this, &NodeSessionPrx::_iceI_getObserver, context).get();
    }

    /**
     * Return the node observer.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getObserverAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::NodeObserverPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::NodeObserverPrx>, P>(false, this, &NodeSessionPrx::_iceI_getObserver, context);
    }

    /**
     * Return the node observer.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getObserverAsync(::std::function<void(::std::shared_ptr<::IceGrid::NodeObserverPrx>)> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::NodeObserverPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::NodeSessionPrx::_iceI_getObserver, context);
    }

    /// \cond INTERNAL
    void _iceI_getObserver(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::NodeObserverPrx>>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Ask the registry to load the servers on the node.
     * @param context The Context map to send with the invocation.
     */
    void loadServers(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &NodeSessionPrx::_iceI_loadServers, context).get();
    }

    /**
     * Ask the registry to load the servers on the node.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto loadServersAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &NodeSessionPrx::_iceI_loadServers, context);
    }

    /**
     * Ask the registry to load the servers on the node.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    loadServersAsync(::std::function<void()> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::NodeSessionPrx::_iceI_loadServers, context);
    }

    /// \cond INTERNAL
    void _iceI_loadServers(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Get the name of the servers deployed on the node.
     * @param context The Context map to send with the invocation.
     */
    ::Ice::StringSeq getServers(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::StringSeq>(true, this, &NodeSessionPrx::_iceI_getServers, context).get();
    }

    /**
     * Get the name of the servers deployed on the node.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getServersAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::StringSeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::StringSeq, P>(false, this, &NodeSessionPrx::_iceI_getServers, context);
    }

    /**
     * Get the name of the servers deployed on the node.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getServersAsync(::std::function<void(::Ice::StringSeq)> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::StringSeq>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::NodeSessionPrx::_iceI_getServers, context);
    }

    /// \cond INTERNAL
    void _iceI_getServers(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::StringSeq>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Wait for the application update to complete (the application is
     * completely updated once all the registry replicas have been
     * updated). This is used by the node to ensure that before to
     * start a server all the replicas have the up-to-date descriptor
     * of the server.
     * @param context The Context map to send with the invocation.
     */
    void waitForApplicationUpdate(const ::std::string& application, int revision, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &NodeSessionPrx::_iceI_waitForApplicationUpdate, application, revision, context).get();
    }

    /**
     * Wait for the application update to complete (the application is
     * completely updated once all the registry replicas have been
     * updated). This is used by the node to ensure that before to
     * start a server all the replicas have the up-to-date descriptor
     * of the server.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto waitForApplicationUpdateAsync(const ::std::string& application, int revision, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &NodeSessionPrx::_iceI_waitForApplicationUpdate, application, revision, context);
    }

    /**
     * Wait for the application update to complete (the application is
     * completely updated once all the registry replicas have been
     * updated). This is used by the node to ensure that before to
     * start a server all the replicas have the up-to-date descriptor
     * of the server.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    waitForApplicationUpdateAsync(const ::std::string& application, int revision,
                                  ::std::function<void()> response,
                                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                  ::std::function<void(bool)> sent = nullptr,
                                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::NodeSessionPrx::_iceI_waitForApplicationUpdate, application, revision, context);
    }

    /// \cond INTERNAL
    void _iceI_waitForApplicationUpdate(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Destroy the session.
     * @param context The Context map to send with the invocation.
     */
    void destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &NodeSessionPrx::_iceI_destroy, context).get();
    }

    /**
     * Destroy the session.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto destroyAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &NodeSessionPrx::_iceI_destroy, context);
    }

    /**
     * Destroy the session.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    destroyAsync(::std::function<void()> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::NodeSessionPrx::_iceI_destroy, context);
    }

    /// \cond INTERNAL
    void _iceI_destroy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    NodeSessionPrx() = default;
    friend ::std::shared_ptr<NodeSessionPrx> IceInternal::createProxy<NodeSessionPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

class DatabaseObserverPrx : public virtual ::Ice::Proxy<DatabaseObserverPrx, ApplicationObserverPrx, ObjectObserverPrx, AdapterObserverPrx>
{
public:

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    DatabaseObserverPrx() = default;
    friend ::std::shared_ptr<DatabaseObserverPrx> IceInternal::createProxy<DatabaseObserverPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

class ReplicaSessionPrx : public virtual ::Ice::Proxy<ReplicaSessionPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * The replica call this method to keep the session alive.
     * @param context The Context map to send with the invocation.
     */
    void keepAlive(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ReplicaSessionPrx::_iceI_keepAlive, context).get();
    }

    /**
     * The replica call this method to keep the session alive.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto keepAliveAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ReplicaSessionPrx::_iceI_keepAlive, context);
    }

    /**
     * The replica call this method to keep the session alive.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    keepAliveAsync(::std::function<void()> response,
                   ::std::function<void(::std::exception_ptr)> ex = nullptr,
                   ::std::function<void(bool)> sent = nullptr,
                   const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ReplicaSessionPrx::_iceI_keepAlive, context);
    }

    /// \cond INTERNAL
    void _iceI_keepAlive(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Return the replica session timeout.
     * @param context The Context map to send with the invocation.
     */
    int getTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &ReplicaSessionPrx::_iceI_getTimeout, context).get();
    }

    /**
     * Return the replica session timeout.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getTimeoutAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &ReplicaSessionPrx::_iceI_getTimeout, context);
    }

    /**
     * Return the replica session timeout.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getTimeoutAsync(::std::function<void(int)> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ReplicaSessionPrx::_iceI_getTimeout, context);
    }

    /// \cond INTERNAL
    void _iceI_getTimeout(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Set the database observer. Once the observer is subscribed, it
     * will receive the database and database updates.
     * @param context The Context map to send with the invocation.
     */
    void setDatabaseObserver(const ::std::shared_ptr<DatabaseObserverPrx>& dbObs, const Ice::optional<StringLongDict>& serials, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ReplicaSessionPrx::_iceI_setDatabaseObserver, dbObs, serials, context).get();
    }

    /**
     * Set the database observer. Once the observer is subscribed, it
     * will receive the database and database updates.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto setDatabaseObserverAsync(const ::std::shared_ptr<DatabaseObserverPrx>& dbObs, const Ice::optional<StringLongDict>& serials, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ReplicaSessionPrx::_iceI_setDatabaseObserver, dbObs, serials, context);
    }

    /**
     * Set the database observer. Once the observer is subscribed, it
     * will receive the database and database updates.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    setDatabaseObserverAsync(const ::std::shared_ptr<DatabaseObserverPrx>& dbObs, const Ice::optional<StringLongDict>& serials,
                             ::std::function<void()> response,
                             ::std::function<void(::std::exception_ptr)> ex = nullptr,
                             ::std::function<void(bool)> sent = nullptr,
                             const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ReplicaSessionPrx::_iceI_setDatabaseObserver, dbObs, serials, context);
    }

    /// \cond INTERNAL
    void _iceI_setDatabaseObserver(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<DatabaseObserverPrx>&, const Ice::optional<StringLongDict>&, const ::Ice::Context&);
    /// \endcond

    /**
     * This method sets the endpoints of the replica. This allows the
     * master to create proxies with multiple endpoints for replicated
     * objects (e.g.: IceGrid::Query object).
     * @param context The Context map to send with the invocation.
     */
    void setEndpoints(const StringObjectProxyDict& endpoints, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ReplicaSessionPrx::_iceI_setEndpoints, endpoints, context).get();
    }

    /**
     * This method sets the endpoints of the replica. This allows the
     * master to create proxies with multiple endpoints for replicated
     * objects (e.g.: IceGrid::Query object).
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto setEndpointsAsync(const StringObjectProxyDict& endpoints, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ReplicaSessionPrx::_iceI_setEndpoints, endpoints, context);
    }

    /**
     * This method sets the endpoints of the replica. This allows the
     * master to create proxies with multiple endpoints for replicated
     * objects (e.g.: IceGrid::Query object).
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    setEndpointsAsync(const StringObjectProxyDict& endpoints,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ReplicaSessionPrx::_iceI_setEndpoints, endpoints, context);
    }

    /// \cond INTERNAL
    void _iceI_setEndpoints(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const StringObjectProxyDict&, const ::Ice::Context&);
    /// \endcond

    /**
     * Registers the replica well-known objects with the master.
     * @param context The Context map to send with the invocation.
     */
    void registerWellKnownObjects(const ObjectInfoSeq& objects, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ReplicaSessionPrx::_iceI_registerWellKnownObjects, objects, context).get();
    }

    /**
     * Registers the replica well-known objects with the master.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto registerWellKnownObjectsAsync(const ObjectInfoSeq& objects, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ReplicaSessionPrx::_iceI_registerWellKnownObjects, objects, context);
    }

    /**
     * Registers the replica well-known objects with the master.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    registerWellKnownObjectsAsync(const ObjectInfoSeq& objects,
                                  ::std::function<void()> response,
                                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                  ::std::function<void(bool)> sent = nullptr,
                                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ReplicaSessionPrx::_iceI_registerWellKnownObjects, objects, context);
    }

    /// \cond INTERNAL
    void _iceI_registerWellKnownObjects(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ObjectInfoSeq&, const ::Ice::Context&);
    /// \endcond

    /**
     * Set the adapter direct proxy of the given adapter in the
     * master. This is used to support dynamic registration with
     * the locator registry interface.
     * @param context The Context map to send with the invocation.
     */
    void setAdapterDirectProxy(const ::std::string& adapterId, const ::std::string& replicaGroupId, const ::std::shared_ptr<::Ice::ObjectPrx>& proxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ReplicaSessionPrx::_iceI_setAdapterDirectProxy, adapterId, replicaGroupId, proxy, context).get();
    }

    /**
     * Set the adapter direct proxy of the given adapter in the
     * master. This is used to support dynamic registration with
     * the locator registry interface.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto setAdapterDirectProxyAsync(const ::std::string& adapterId, const ::std::string& replicaGroupId, const ::std::shared_ptr<::Ice::ObjectPrx>& proxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ReplicaSessionPrx::_iceI_setAdapterDirectProxy, adapterId, replicaGroupId, proxy, context);
    }

    /**
     * Set the adapter direct proxy of the given adapter in the
     * master. This is used to support dynamic registration with
     * the locator registry interface.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    setAdapterDirectProxyAsync(const ::std::string& adapterId, const ::std::string& replicaGroupId, const ::std::shared_ptr<::Ice::ObjectPrx>& proxy,
                               ::std::function<void()> response,
                               ::std::function<void(::std::exception_ptr)> ex = nullptr,
                               ::std::function<void(bool)> sent = nullptr,
                               const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ReplicaSessionPrx::_iceI_setAdapterDirectProxy, adapterId, replicaGroupId, proxy, context);
    }

    /// \cond INTERNAL
    void _iceI_setAdapterDirectProxy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::std::string&, const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Notify the master that an update was received. The master might
     * wait for replication updates to be received by all the replicas
     * before to continue.
     * @param context The Context map to send with the invocation.
     */
    void receivedUpdate(TopicName name, int serial, const ::std::string& failure, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ReplicaSessionPrx::_iceI_receivedUpdate, name, serial, failure, context).get();
    }

    /**
     * Notify the master that an update was received. The master might
     * wait for replication updates to be received by all the replicas
     * before to continue.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto receivedUpdateAsync(TopicName name, int serial, const ::std::string& failure, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ReplicaSessionPrx::_iceI_receivedUpdate, name, serial, failure, context);
    }

    /**
     * Notify the master that an update was received. The master might
     * wait for replication updates to be received by all the replicas
     * before to continue.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    receivedUpdateAsync(TopicName name, int serial, const ::std::string& failure,
                        ::std::function<void()> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ReplicaSessionPrx::_iceI_receivedUpdate, name, serial, failure, context);
    }

    /// \cond INTERNAL
    void _iceI_receivedUpdate(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, TopicName, int, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Destroy the session.
     * @param context The Context map to send with the invocation.
     */
    void destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &ReplicaSessionPrx::_iceI_destroy, context).get();
    }

    /**
     * Destroy the session.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto destroyAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &ReplicaSessionPrx::_iceI_destroy, context);
    }

    /**
     * Destroy the session.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    destroyAsync(::std::function<void()> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::ReplicaSessionPrx::_iceI_destroy, context);
    }

    /// \cond INTERNAL
    void _iceI_destroy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    ReplicaSessionPrx() = default;
    friend ::std::shared_ptr<ReplicaSessionPrx> IceInternal::createProxy<ReplicaSessionPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

class InternalRegistryPrx : public virtual ::Ice::Proxy<InternalRegistryPrx, FileReaderPrx>
{
public:

    /**
     * Register a node with the registry. If a node with the same name
     * is already registered, [registerNode] will overide the previous
     * node only if it's not active.
     * @param info Some information on the node.
     * @param prx The proxy of the node.
     * @param loadInf The load information of the node.
     * @param context The Context map to send with the invocation.
     * @return The node session proxy.
     * @throws IceGrid::NodeActiveException Raised if the node is already
     * registered and currently active.
     */
    ::std::shared_ptr<NodeSessionPrx> registerNode(const ::std::shared_ptr<InternalNodeInfo>& info, const ::std::shared_ptr<NodePrx>& prx, const LoadInfo& loadInf, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::NodeSessionPrx>>(true, this, &InternalRegistryPrx::_iceI_registerNode, info, prx, loadInf, context).get();
    }

    /**
     * Register a node with the registry. If a node with the same name
     * is already registered, [registerNode] will overide the previous
     * node only if it's not active.
     * @param info Some information on the node.
     * @param prx The proxy of the node.
     * @param loadInf The load information of the node.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto registerNodeAsync(const ::std::shared_ptr<InternalNodeInfo>& info, const ::std::shared_ptr<NodePrx>& prx, const LoadInfo& loadInf, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::NodeSessionPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::NodeSessionPrx>, P>(false, this, &InternalRegistryPrx::_iceI_registerNode, info, prx, loadInf, context);
    }

    /**
     * Register a node with the registry. If a node with the same name
     * is already registered, [registerNode] will overide the previous
     * node only if it's not active.
     * @param info Some information on the node.
     * @param prx The proxy of the node.
     * @param loadInf The load information of the node.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    registerNodeAsync(const ::std::shared_ptr<InternalNodeInfo>& info, const ::std::shared_ptr<NodePrx>& prx, const LoadInfo& loadInf,
                      ::std::function<void(::std::shared_ptr<::IceGrid::NodeSessionPrx>)> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::NodeSessionPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::InternalRegistryPrx::_iceI_registerNode, info, prx, loadInf, context);
    }

    /// \cond INTERNAL
    void _iceI_registerNode(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::NodeSessionPrx>>>&, const ::std::shared_ptr<InternalNodeInfo>&, const ::std::shared_ptr<NodePrx>&, const LoadInfo&, const ::Ice::Context&);
    /// \endcond

    /**
     * Register a replica with the registry. If a replica with the
     * same name is already registered, [registerReplica] will overide
     * the previous replica only if it's not active.
     * @param info Some information on the replica.
     * @param prx The proxy of the replica.
     * @param context The Context map to send with the invocation.
     * @return The replica session proxy.
     * @throws IceGrid::ReplicaActiveException Raised if the replica is already
     * registered and currently active.
     */
    ::std::shared_ptr<ReplicaSessionPrx> registerReplica(const ::std::shared_ptr<InternalReplicaInfo>& info, const ::std::shared_ptr<InternalRegistryPrx>& prx, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::ReplicaSessionPrx>>(true, this, &InternalRegistryPrx::_iceI_registerReplica, info, prx, context).get();
    }

    /**
     * Register a replica with the registry. If a replica with the
     * same name is already registered, [registerReplica] will overide
     * the previous replica only if it's not active.
     * @param info Some information on the replica.
     * @param prx The proxy of the replica.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto registerReplicaAsync(const ::std::shared_ptr<InternalReplicaInfo>& info, const ::std::shared_ptr<InternalRegistryPrx>& prx, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::ReplicaSessionPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::ReplicaSessionPrx>, P>(false, this, &InternalRegistryPrx::_iceI_registerReplica, info, prx, context);
    }

    /**
     * Register a replica with the registry. If a replica with the
     * same name is already registered, [registerReplica] will overide
     * the previous replica only if it's not active.
     * @param info Some information on the replica.
     * @param prx The proxy of the replica.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    registerReplicaAsync(const ::std::shared_ptr<InternalReplicaInfo>& info, const ::std::shared_ptr<InternalRegistryPrx>& prx,
                         ::std::function<void(::std::shared_ptr<::IceGrid::ReplicaSessionPrx>)> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::ReplicaSessionPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::InternalRegistryPrx::_iceI_registerReplica, info, prx, context);
    }

    /// \cond INTERNAL
    void _iceI_registerReplica(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::ReplicaSessionPrx>>>&, const ::std::shared_ptr<InternalReplicaInfo>&, const ::std::shared_ptr<InternalRegistryPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Create a session with the given registry replica. This method
     * returns only once the session creation has been attempted.
     * @param context The Context map to send with the invocation.
     */
    void registerWithReplica(const ::std::shared_ptr<InternalRegistryPrx>& prx, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &InternalRegistryPrx::_iceI_registerWithReplica, prx, context).get();
    }

    /**
     * Create a session with the given registry replica. This method
     * returns only once the session creation has been attempted.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto registerWithReplicaAsync(const ::std::shared_ptr<InternalRegistryPrx>& prx, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &InternalRegistryPrx::_iceI_registerWithReplica, prx, context);
    }

    /**
     * Create a session with the given registry replica. This method
     * returns only once the session creation has been attempted.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    registerWithReplicaAsync(const ::std::shared_ptr<InternalRegistryPrx>& prx,
                             ::std::function<void()> response,
                             ::std::function<void(::std::exception_ptr)> ex = nullptr,
                             ::std::function<void(bool)> sent = nullptr,
                             const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::InternalRegistryPrx::_iceI_registerWithReplica, prx, context);
    }

    /// \cond INTERNAL
    void _iceI_registerWithReplica(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<InternalRegistryPrx>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Return the proxies of all the nodes known by this registry.
     * @param context The Context map to send with the invocation.
     */
    NodePrxSeq getNodes(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::NodePrxSeq>(true, this, &InternalRegistryPrx::_iceI_getNodes, context).get();
    }

    /**
     * Return the proxies of all the nodes known by this registry.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getNodesAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::NodePrxSeq>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::NodePrxSeq, P>(false, this, &InternalRegistryPrx::_iceI_getNodes, context);
    }

    /**
     * Return the proxies of all the nodes known by this registry.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getNodesAsync(::std::function<void(::IceGrid::NodePrxSeq)> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::NodePrxSeq>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::InternalRegistryPrx::_iceI_getNodes, context);
    }

    /// \cond INTERNAL
    void _iceI_getNodes(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::NodePrxSeq>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Return the proxies of all the registry replicas known by this
     * registry.
     * @param context The Context map to send with the invocation.
     */
    InternalRegistryPrxSeq getReplicas(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::InternalRegistryPrxSeq>(true, this, &InternalRegistryPrx::_iceI_getReplicas, context).get();
    }

    /**
     * Return the proxies of all the registry replicas known by this
     * registry.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getReplicasAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::InternalRegistryPrxSeq>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::InternalRegistryPrxSeq, P>(false, this, &InternalRegistryPrx::_iceI_getReplicas, context);
    }

    /**
     * Return the proxies of all the registry replicas known by this
     * registry.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getReplicasAsync(::std::function<void(::IceGrid::InternalRegistryPrxSeq)> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::InternalRegistryPrxSeq>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::InternalRegistryPrx::_iceI_getReplicas, context);
    }

    /// \cond INTERNAL
    void _iceI_getReplicas(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::InternalRegistryPrxSeq>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Return applications, adapters, objects from this replica.
     * @param context The Context map to send with the invocation.
     */
    ApplicationInfoSeq getApplications(long long int& serial, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _result = _makePromiseOutgoing<InternalRegistry::GetApplicationsResult>(true, this, &InternalRegistryPrx::_iceI_getApplications, context).get();
        serial = _result.serial;
        return ::std::move(_result.returnValue);
    }

    /**
     * Return applications, adapters, objects from this replica.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getApplicationsAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<InternalRegistry::GetApplicationsResult>>().get_future())
    {
        return _makePromiseOutgoing<InternalRegistry::GetApplicationsResult, P>(false, this, &InternalRegistryPrx::_iceI_getApplications, context);
    }

    /**
     * Return applications, adapters, objects from this replica.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getApplicationsAsync(::std::function<void(::IceGrid::ApplicationInfoSeq, long long int)> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _responseCb = [response](InternalRegistry::GetApplicationsResult&& _result)
        {
            response(::std::move(_result.returnValue), _result.serial);
        };
        return _makeLamdaOutgoing<InternalRegistry::GetApplicationsResult>(std::move(_responseCb), std::move(ex), std::move(sent), this, &IceGrid::InternalRegistryPrx::_iceI_getApplications, context);
    }

    /// \cond INTERNAL
    void _iceI_getApplications(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<InternalRegistry::GetApplicationsResult>>&, const ::Ice::Context&);
    /// \endcond

    AdapterInfoSeq getAdapters(long long int& serial, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _result = _makePromiseOutgoing<InternalRegistry::GetAdaptersResult>(true, this, &InternalRegistryPrx::_iceI_getAdapters, context).get();
        serial = _result.serial;
        return ::std::move(_result.returnValue);
    }

    template<template<typename> class P = ::std::promise>
    auto getAdaptersAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<InternalRegistry::GetAdaptersResult>>().get_future())
    {
        return _makePromiseOutgoing<InternalRegistry::GetAdaptersResult, P>(false, this, &InternalRegistryPrx::_iceI_getAdapters, context);
    }

    ::std::function<void()>
    getAdaptersAsync(::std::function<void(::IceGrid::AdapterInfoSeq, long long int)> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _responseCb = [response](InternalRegistry::GetAdaptersResult&& _result)
        {
            response(::std::move(_result.returnValue), _result.serial);
        };
        return _makeLamdaOutgoing<InternalRegistry::GetAdaptersResult>(std::move(_responseCb), std::move(ex), std::move(sent), this, &IceGrid::InternalRegistryPrx::_iceI_getAdapters, context);
    }

    /// \cond INTERNAL
    void _iceI_getAdapters(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<InternalRegistry::GetAdaptersResult>>&, const ::Ice::Context&);
    /// \endcond

    ObjectInfoSeq getObjects(long long int& serial, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _result = _makePromiseOutgoing<InternalRegistry::GetObjectsResult>(true, this, &InternalRegistryPrx::_iceI_getObjects, context).get();
        serial = _result.serial;
        return ::std::move(_result.returnValue);
    }

    template<template<typename> class P = ::std::promise>
    auto getObjectsAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<InternalRegistry::GetObjectsResult>>().get_future())
    {
        return _makePromiseOutgoing<InternalRegistry::GetObjectsResult, P>(false, this, &InternalRegistryPrx::_iceI_getObjects, context);
    }

    ::std::function<void()>
    getObjectsAsync(::std::function<void(::IceGrid::ObjectInfoSeq, long long int)> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        auto _responseCb = [response](InternalRegistry::GetObjectsResult&& _result)
        {
            response(::std::move(_result.returnValue), _result.serial);
        };
        return _makeLamdaOutgoing<InternalRegistry::GetObjectsResult>(std::move(_responseCb), std::move(ex), std::move(sent), this, &IceGrid::InternalRegistryPrx::_iceI_getObjects, context);
    }

    /// \cond INTERNAL
    void _iceI_getObjects(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<InternalRegistry::GetObjectsResult>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Shutdown this registry.
     * @param context The Context map to send with the invocation.
     */
    void shutdown(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &InternalRegistryPrx::_iceI_shutdown, context).get();
    }

    /**
     * Shutdown this registry.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto shutdownAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &InternalRegistryPrx::_iceI_shutdown, context);
    }

    /**
     * Shutdown this registry.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    shutdownAsync(::std::function<void()> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::InternalRegistryPrx::_iceI_shutdown, context);
    }

    /// \cond INTERNAL
    void _iceI_shutdown(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    InternalRegistryPrx() = default;
    friend ::std::shared_ptr<InternalRegistryPrx> IceInternal::createProxy<InternalRegistryPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

}

/// \cond STREAM
namespace Ice
{

template<typename S>
struct StreamReader<::IceGrid::InternalDbEnvDescriptor, S>
{
    static void read(S* istr, ::IceGrid::InternalDbEnvDescriptor& v)
    {
        istr->readAll(v.name, v.properties);
    }
};

template<typename S>
struct StreamReader<::IceGrid::InternalAdapterDescriptor, S>
{
    static void read(S* istr, ::IceGrid::InternalAdapterDescriptor& v)
    {
        istr->readAll(v.id, v.serverLifetime);
    }
};

template<typename S>
struct StreamReader<::IceGrid::InternalDistributionDescriptor, S>
{
    static void read(S* istr, ::IceGrid::InternalDistributionDescriptor& v)
    {
        istr->readAll(v.icepatch, v.directories);
    }
};

template<typename S>
struct StreamWriter<::IceGrid::InternalServerDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::InternalServerDescriptor& v)
    {
        ostr->writeAll(v.id, v.application, v.uuid, v.revision, v.sessionId, v.exe, v.pwd, v.user, v.activation, v.activationTimeout, v.deactivationTimeout, v.applicationDistrib, v.distrib, v.processRegistered, v.options, v.envs, v.logs, v.adapters, v.dbEnvs, v.properties);
        ostr->writeAll({1}, v.services);
    }
};

template<typename S>
struct StreamReader<::IceGrid::InternalServerDescriptor, S>
{
    static void read(S* istr, ::IceGrid::InternalServerDescriptor& v)
    {
        istr->readAll(v.id, v.application, v.uuid, v.revision, v.sessionId, v.exe, v.pwd, v.user, v.activation, v.activationTimeout, v.deactivationTimeout, v.applicationDistrib, v.distrib, v.processRegistered, v.options, v.envs, v.logs, v.adapters, v.dbEnvs, v.properties);
        istr->readAll({1}, v.services);
    }
};

template<typename S>
struct StreamReader<::IceGrid::AdapterNotActiveException, S>
{
    static void read(S* istr, ::IceGrid::AdapterNotActiveException& v)
    {
        istr->readAll(v.activatable);
    }
};

template<typename S>
struct StreamReader<::IceGrid::AdapterExistsException, S>
{
    static void read(S* istr, ::IceGrid::AdapterExistsException& v)
    {
        istr->readAll(v.id);
    }
};

template<>
struct StreamableTraits< ::IceGrid::TopicName>
{
    static const StreamHelperCategory helper = StreamHelperCategoryEnum;
    static const int minValue = 0;
    static const int maxValue = 4;
    static const int minWireSize = 1;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::InternalNodeInfo, S>
{
    static void read(S* istr, ::IceGrid::InternalNodeInfo& v)
    {
        istr->readAll(v.name, v.os, v.hostname, v.release, v.version, v.machine, v.nProcessors, v.dataDir);
    }
};

template<typename S>
struct StreamReader<::IceGrid::InternalReplicaInfo, S>
{
    static void read(S* istr, ::IceGrid::InternalReplicaInfo& v)
    {
        istr->readAll(v.name, v.hostname);
    }
};

}
/// \endcond

/// \cond INTERNAL
namespace IceGrid
{

using InternalDbEnvDescriptorPtr = ::std::shared_ptr<InternalDbEnvDescriptor>;

using InternalAdapterDescriptorPtr = ::std::shared_ptr<InternalAdapterDescriptor>;

using InternalDistributionDescriptorPtr = ::std::shared_ptr<InternalDistributionDescriptor>;

using InternalServerDescriptorPtr = ::std::shared_ptr<InternalServerDescriptor>;

using AdapterPtr = ::std::shared_ptr<Adapter>;
using AdapterPrxPtr = ::std::shared_ptr<AdapterPrx>;

using FileReaderPtr = ::std::shared_ptr<FileReader>;
using FileReaderPrxPtr = ::std::shared_ptr<FileReaderPrx>;

using ServerPtr = ::std::shared_ptr<Server>;
using ServerPrxPtr = ::std::shared_ptr<ServerPrx>;

using InternalRegistryPtr = ::std::shared_ptr<InternalRegistry>;
using InternalRegistryPrxPtr = ::std::shared_ptr<InternalRegistryPrx>;

using ReplicaObserverPtr = ::std::shared_ptr<ReplicaObserver>;
using ReplicaObserverPrxPtr = ::std::shared_ptr<ReplicaObserverPrx>;

using PatcherFeedbackPtr = ::std::shared_ptr<PatcherFeedback>;
using PatcherFeedbackPrxPtr = ::std::shared_ptr<PatcherFeedbackPrx>;

using NodePtr = ::std::shared_ptr<Node>;
using NodePrxPtr = ::std::shared_ptr<NodePrx>;

using NodeSessionPtr = ::std::shared_ptr<NodeSession>;
using NodeSessionPrxPtr = ::std::shared_ptr<NodeSessionPrx>;

using DatabaseObserverPtr = ::std::shared_ptr<DatabaseObserver>;
using DatabaseObserverPrxPtr = ::std::shared_ptr<DatabaseObserverPrx>;

using ReplicaSessionPtr = ::std::shared_ptr<ReplicaSession>;
using ReplicaSessionPrxPtr = ::std::shared_ptr<ReplicaSessionPrx>;

using InternalNodeInfoPtr = ::std::shared_ptr<InternalNodeInfo>;

using InternalReplicaInfoPtr = ::std::shared_ptr<InternalReplicaInfo>;

}
/// \endcond

#else // C++98 mapping

namespace IceProxy
{

namespace IceGrid
{

class InternalDbEnvDescriptor;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< InternalDbEnvDescriptor>&);
::IceProxy::Ice::Object* upCast(InternalDbEnvDescriptor*);
/// \endcond

class InternalAdapterDescriptor;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< InternalAdapterDescriptor>&);
::IceProxy::Ice::Object* upCast(InternalAdapterDescriptor*);
/// \endcond

class InternalDistributionDescriptor;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< InternalDistributionDescriptor>&);
::IceProxy::Ice::Object* upCast(InternalDistributionDescriptor*);
/// \endcond

class InternalServerDescriptor;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< InternalServerDescriptor>&);
::IceProxy::Ice::Object* upCast(InternalServerDescriptor*);
/// \endcond

class Adapter;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< Adapter>&);
::IceProxy::Ice::Object* upCast(Adapter*);
/// \endcond

class FileReader;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< FileReader>&);
::IceProxy::Ice::Object* upCast(FileReader*);
/// \endcond

class Server;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< Server>&);
::IceProxy::Ice::Object* upCast(Server*);
/// \endcond

class InternalRegistry;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< InternalRegistry>&);
::IceProxy::Ice::Object* upCast(InternalRegistry*);
/// \endcond

class ReplicaObserver;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ReplicaObserver>&);
::IceProxy::Ice::Object* upCast(ReplicaObserver*);
/// \endcond

class PatcherFeedback;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< PatcherFeedback>&);
::IceProxy::Ice::Object* upCast(PatcherFeedback*);
/// \endcond

class Node;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< Node>&);
::IceProxy::Ice::Object* upCast(Node*);
/// \endcond

class NodeSession;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< NodeSession>&);
::IceProxy::Ice::Object* upCast(NodeSession*);
/// \endcond

class DatabaseObserver;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< DatabaseObserver>&);
::IceProxy::Ice::Object* upCast(DatabaseObserver*);
/// \endcond

class ReplicaSession;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ReplicaSession>&);
::IceProxy::Ice::Object* upCast(ReplicaSession*);
/// \endcond

class InternalNodeInfo;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< InternalNodeInfo>&);
::IceProxy::Ice::Object* upCast(InternalNodeInfo*);
/// \endcond

class InternalReplicaInfo;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< InternalReplicaInfo>&);
::IceProxy::Ice::Object* upCast(InternalReplicaInfo*);
/// \endcond

}

}

namespace IceGrid
{

class InternalDbEnvDescriptor;
/// \cond INTERNAL
::Ice::Object* upCast(InternalDbEnvDescriptor*);
/// \endcond
typedef ::IceInternal::Handle< InternalDbEnvDescriptor> InternalDbEnvDescriptorPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::InternalDbEnvDescriptor> InternalDbEnvDescriptorPrx;
typedef InternalDbEnvDescriptorPrx InternalDbEnvDescriptorPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(InternalDbEnvDescriptorPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class InternalAdapterDescriptor;
/// \cond INTERNAL
::Ice::Object* upCast(InternalAdapterDescriptor*);
/// \endcond
typedef ::IceInternal::Handle< InternalAdapterDescriptor> InternalAdapterDescriptorPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::InternalAdapterDescriptor> InternalAdapterDescriptorPrx;
typedef InternalAdapterDescriptorPrx InternalAdapterDescriptorPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(InternalAdapterDescriptorPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class InternalDistributionDescriptor;
/// \cond INTERNAL
::Ice::Object* upCast(InternalDistributionDescriptor*);
/// \endcond
typedef ::IceInternal::Handle< InternalDistributionDescriptor> InternalDistributionDescriptorPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::InternalDistributionDescriptor> InternalDistributionDescriptorPrx;
typedef InternalDistributionDescriptorPrx InternalDistributionDescriptorPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(InternalDistributionDescriptorPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class InternalServerDescriptor;
/// \cond INTERNAL
::Ice::Object* upCast(InternalServerDescriptor*);
/// \endcond
typedef ::IceInternal::Handle< InternalServerDescriptor> InternalServerDescriptorPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::InternalServerDescriptor> InternalServerDescriptorPrx;
typedef InternalServerDescriptorPrx InternalServerDescriptorPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(InternalServerDescriptorPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class Adapter;
/// \cond INTERNAL
::Ice::Object* upCast(Adapter*);
/// \endcond
typedef ::IceInternal::Handle< Adapter> AdapterPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::Adapter> AdapterPrx;
typedef AdapterPrx AdapterPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(AdapterPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class FileReader;
/// \cond INTERNAL
::Ice::Object* upCast(FileReader*);
/// \endcond
typedef ::IceInternal::Handle< FileReader> FileReaderPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::FileReader> FileReaderPrx;
typedef FileReaderPrx FileReaderPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(FileReaderPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class Server;
/// \cond INTERNAL
::Ice::Object* upCast(Server*);
/// \endcond
typedef ::IceInternal::Handle< Server> ServerPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::Server> ServerPrx;
typedef ServerPrx ServerPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(ServerPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class InternalRegistry;
/// \cond INTERNAL
::Ice::Object* upCast(InternalRegistry*);
/// \endcond
typedef ::IceInternal::Handle< InternalRegistry> InternalRegistryPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::InternalRegistry> InternalRegistryPrx;
typedef InternalRegistryPrx InternalRegistryPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(InternalRegistryPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class ReplicaObserver;
/// \cond INTERNAL
::Ice::Object* upCast(ReplicaObserver*);
/// \endcond
typedef ::IceInternal::Handle< ReplicaObserver> ReplicaObserverPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::ReplicaObserver> ReplicaObserverPrx;
typedef ReplicaObserverPrx ReplicaObserverPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(ReplicaObserverPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class PatcherFeedback;
/// \cond INTERNAL
::Ice::Object* upCast(PatcherFeedback*);
/// \endcond
typedef ::IceInternal::Handle< PatcherFeedback> PatcherFeedbackPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::PatcherFeedback> PatcherFeedbackPrx;
typedef PatcherFeedbackPrx PatcherFeedbackPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(PatcherFeedbackPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class Node;
/// \cond INTERNAL
::Ice::Object* upCast(Node*);
/// \endcond
typedef ::IceInternal::Handle< Node> NodePtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::Node> NodePrx;
typedef NodePrx NodePrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(NodePtr&, const ::Ice::ObjectPtr&);
/// \endcond

class NodeSession;
/// \cond INTERNAL
::Ice::Object* upCast(NodeSession*);
/// \endcond
typedef ::IceInternal::Handle< NodeSession> NodeSessionPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::NodeSession> NodeSessionPrx;
typedef NodeSessionPrx NodeSessionPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(NodeSessionPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class DatabaseObserver;
/// \cond INTERNAL
::Ice::Object* upCast(DatabaseObserver*);
/// \endcond
typedef ::IceInternal::Handle< DatabaseObserver> DatabaseObserverPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::DatabaseObserver> DatabaseObserverPrx;
typedef DatabaseObserverPrx DatabaseObserverPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(DatabaseObserverPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class ReplicaSession;
/// \cond INTERNAL
::Ice::Object* upCast(ReplicaSession*);
/// \endcond
typedef ::IceInternal::Handle< ReplicaSession> ReplicaSessionPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::ReplicaSession> ReplicaSessionPrx;
typedef ReplicaSessionPrx ReplicaSessionPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(ReplicaSessionPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class InternalNodeInfo;
/// \cond INTERNAL
::Ice::Object* upCast(InternalNodeInfo*);
/// \endcond
typedef ::IceInternal::Handle< InternalNodeInfo> InternalNodeInfoPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::InternalNodeInfo> InternalNodeInfoPrx;
typedef InternalNodeInfoPrx InternalNodeInfoPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(InternalNodeInfoPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class InternalReplicaInfo;
/// \cond INTERNAL
::Ice::Object* upCast(InternalReplicaInfo*);
/// \endcond
typedef ::IceInternal::Handle< InternalReplicaInfo> InternalReplicaInfoPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::InternalReplicaInfo> InternalReplicaInfoPrx;
typedef InternalReplicaInfoPrx InternalReplicaInfoPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(InternalReplicaInfoPtr&, const ::Ice::ObjectPtr&);
/// \endcond

}

namespace IceGrid
{

class SynchronizationException : public ::Ice::LocalException
{
public:

    /**
     * The file and line number are required for all local exceptions.
     * @param file The file name in which the exception was raised, typically __FILE__.
     * @param line The line number at which the exception was raised, typically __LINE__.
     */
    SynchronizationException(const char* file, int line);

#ifdef ICE_CPP11_COMPILER
    SynchronizationException(const SynchronizationException&) = default;
    virtual ~SynchronizationException();
#else
    virtual ~SynchronizationException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual SynchronizationException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;
};

typedef ::std::vector<InternalDbEnvDescriptorPtr> InternalDbEnvDescriptorSeq;

typedef ::std::vector<InternalAdapterDescriptorPtr> InternalAdapterDescriptorSeq;

typedef ::std::map< ::std::string, PropertyDescriptorSeq> PropertyDescriptorSeqDict;

/**
 * This exception is raised if an adapter is active.
 */
class AdapterActiveException : public ::Ice::UserException
{
public:

    AdapterActiveException() {}

#ifdef ICE_CPP11_COMPILER
    AdapterActiveException(const AdapterActiveException&) = default;
    virtual ~AdapterActiveException();
#else
    virtual ~AdapterActiveException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual AdapterActiveException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
static AdapterActiveException _iceS_AdapterActiveException_init;
/// \endcond

class AdapterNotActiveException : public ::Ice::UserException
{
public:

    AdapterNotActiveException() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param activatable True if the adapter can be activated on demand.
     */
    explicit AdapterNotActiveException(bool activatable);

#ifdef ICE_CPP11_COMPILER
    AdapterNotActiveException(const AdapterNotActiveException&) = default;
    virtual ~AdapterNotActiveException();
#else
    virtual ~AdapterNotActiveException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual AdapterNotActiveException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    /**
     * True if the adapter can be activated on demand.
     */
    bool activatable;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception is raised if an adapter with the same name already
 * exists.
 */
class AdapterExistsException : public ::Ice::UserException
{
public:

    AdapterExistsException() {}
    /**
     * One-shot constructor to initialize all data members.
     */
    explicit AdapterExistsException(const ::std::string& id);

#ifdef ICE_CPP11_COMPILER
    AdapterExistsException(const AdapterExistsException&) = default;
    virtual ~AdapterExistsException();
#else
    virtual ~AdapterExistsException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual AdapterExistsException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

    ::std::string id;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

typedef ::std::map< ::std::string, AdapterPrx> AdapterPrxDict;

typedef ::std::vector<InternalRegistryPrx> InternalRegistryPrxSeq;

typedef ::std::vector<NodePrx> NodePrxSeq;

/**
 * This exception is raised if a node is already registered and
 * active.
 */
class NodeActiveException : public ::Ice::UserException
{
public:

    NodeActiveException() {}

#ifdef ICE_CPP11_COMPILER
    NodeActiveException(const NodeActiveException&) = default;
    virtual ~NodeActiveException();
#else
    virtual ~NodeActiveException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual NodeActiveException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/**
 * This exception is raised if a replica is already registered and
 * active.
 */
class ReplicaActiveException : public ::Ice::UserException
{
public:

    ReplicaActiveException() {}

#ifdef ICE_CPP11_COMPILER
    ReplicaActiveException(const ReplicaActiveException&) = default;
    virtual ~ReplicaActiveException();
#else
    virtual ~ReplicaActiveException() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual ReplicaActiveException* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

enum TopicName
{
    RegistryObserverTopicName,
    NodeObserverTopicName,
    ApplicationObserverTopicName,
    AdapterObserverTopicName,
    ObjectObserverTopicName
};

typedef ::std::map< ::std::string, ::Ice::Long> StringLongDict;

}

namespace IceGrid
{

/**
 * AMD callback class for IceGrid::Adapter::activate_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Adapter_activate : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Adapter_activate();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response(const ::Ice::ObjectPrx& result) = 0;
};

typedef ::IceUtil::Handle< ::IceGrid::AMD_Adapter_activate> AMD_Adapter_activatePtr;

/**
 * AMD callback class for IceGrid::Server::start_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_start : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_start();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::IceGrid::AMD_Server_start> AMD_Server_startPtr;

/**
 * AMD callback class for IceGrid::Server::stop_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_stop : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_stop();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::IceGrid::AMD_Server_stop> AMD_Server_stopPtr;

/**
 * AMD callback class for IceGrid::Server::setProcess_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Server_setProcess : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Server_setProcess();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::IceGrid::AMD_Server_setProcess> AMD_Server_setProcessPtr;

/**
 * AMD callback class for IceGrid::Node::loadServer_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Node_loadServer : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Node_loadServer();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response(const ServerPrx& result, const AdapterPrxDict& adapters, ::Ice::Int actTimeout, ::Ice::Int deactTimeout) = 0;
};

typedef ::IceUtil::Handle< ::IceGrid::AMD_Node_loadServer> AMD_Node_loadServerPtr;

/**
 * AMD callback class for IceGrid::Node::loadServerWithoutRestart_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Node_loadServerWithoutRestart : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Node_loadServerWithoutRestart();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response(const ServerPrx& result, const AdapterPrxDict& adapters, ::Ice::Int actTimeout, ::Ice::Int deactTimeout) = 0;
};

typedef ::IceUtil::Handle< ::IceGrid::AMD_Node_loadServerWithoutRestart> AMD_Node_loadServerWithoutRestartPtr;

/**
 * AMD callback class for IceGrid::Node::destroyServer_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Node_destroyServer : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Node_destroyServer();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::IceGrid::AMD_Node_destroyServer> AMD_Node_destroyServerPtr;

/**
 * AMD callback class for IceGrid::Node::destroyServerWithoutRestart_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Node_destroyServerWithoutRestart : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Node_destroyServerWithoutRestart();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::IceGrid::AMD_Node_destroyServerWithoutRestart> AMD_Node_destroyServerWithoutRestartPtr;

/**
 * AMD callback class for IceGrid::Node::patch_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_Node_patch : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Node_patch();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::IceGrid::AMD_Node_patch> AMD_Node_patchPtr;

/**
 * AMD callback class for IceGrid::NodeSession::loadServers_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_NodeSession_loadServers : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_NodeSession_loadServers();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::IceGrid::AMD_NodeSession_loadServers> AMD_NodeSession_loadServersPtr;

/**
 * AMD callback class for IceGrid::NodeSession::waitForApplicationUpdate_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class AMD_NodeSession_waitForApplicationUpdate : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_NodeSession_waitForApplicationUpdate();

    /**
     * Call ice_response for a successful completion.
     */
    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::IceGrid::AMD_NodeSession_waitForApplicationUpdate> AMD_NodeSession_waitForApplicationUpdatePtr;

}

/// \cond INTERNAL
namespace IceAsync
{

namespace IceGrid
{

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Adapter_activate : public ::IceGrid::AMD_Adapter_activate, public ::IceInternal::IncomingAsync
{
public:

    AMD_Adapter_activate(::IceInternal::Incoming&);

    virtual void ice_response(const ::Ice::ObjectPrx&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_start : public ::IceGrid::AMD_Server_start, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_start(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_stop : public ::IceGrid::AMD_Server_stop, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_stop(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Server_setProcess : public ::IceGrid::AMD_Server_setProcess, public ::IceInternal::IncomingAsync
{
public:

    AMD_Server_setProcess(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Node_loadServer : public ::IceGrid::AMD_Node_loadServer, public ::IceInternal::IncomingAsync
{
public:

    AMD_Node_loadServer(::IceInternal::Incoming&);

    virtual void ice_response(const ::IceGrid::ServerPrx&, const ::IceGrid::AdapterPrxDict&, ::Ice::Int, ::Ice::Int);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Node_loadServerWithoutRestart : public ::IceGrid::AMD_Node_loadServerWithoutRestart, public ::IceInternal::IncomingAsync
{
public:

    AMD_Node_loadServerWithoutRestart(::IceInternal::Incoming&);

    virtual void ice_response(const ::IceGrid::ServerPrx&, const ::IceGrid::AdapterPrxDict&, ::Ice::Int, ::Ice::Int);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Node_destroyServer : public ::IceGrid::AMD_Node_destroyServer, public ::IceInternal::IncomingAsync
{
public:

    AMD_Node_destroyServer(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Node_destroyServerWithoutRestart : public ::IceGrid::AMD_Node_destroyServerWithoutRestart, public ::IceInternal::IncomingAsync
{
public:

    AMD_Node_destroyServerWithoutRestart(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_Node_patch : public ::IceGrid::AMD_Node_patch, public ::IceInternal::IncomingAsync
{
public:

    AMD_Node_patch(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_NodeSession_loadServers : public ::IceGrid::AMD_NodeSession_loadServers, public ::IceInternal::IncomingAsync
{
public:

    AMD_NodeSession_loadServers(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class AMD_NodeSession_waitForApplicationUpdate : public ::IceGrid::AMD_NodeSession_waitForApplicationUpdate, public ::IceInternal::IncomingAsync
{
public:

    AMD_NodeSession_waitForApplicationUpdate(::IceInternal::Incoming&);

    virtual void ice_response();
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

}

}
/// \endcond

namespace IceGrid
{

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Adapter::begin_activate.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Adapter_activate.
 */
class Callback_Adapter_activate_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Adapter_activate_Base> Callback_Adapter_activatePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Adapter::begin_getDirectProxy.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Adapter_getDirectProxy.
 */
class Callback_Adapter_getDirectProxy_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Adapter_getDirectProxy_Base> Callback_Adapter_getDirectProxyPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Adapter::begin_setDirectProxy.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Adapter_setDirectProxy.
 */
class Callback_Adapter_setDirectProxy_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Adapter_setDirectProxy_Base> Callback_Adapter_setDirectProxyPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::FileReader::begin_getOffsetFromEnd.
 * Create a wrapper instance by calling ::IceGrid::newCallback_FileReader_getOffsetFromEnd.
 */
class Callback_FileReader_getOffsetFromEnd_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_FileReader_getOffsetFromEnd_Base> Callback_FileReader_getOffsetFromEndPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::FileReader::begin_read.
 * Create a wrapper instance by calling ::IceGrid::newCallback_FileReader_read.
 */
class Callback_FileReader_read_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_FileReader_read_Base> Callback_FileReader_readPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Server::begin_start.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_start.
 */
class Callback_Server_start_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_start_Base> Callback_Server_startPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Server::begin_stop.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_stop.
 */
class Callback_Server_stop_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_stop_Base> Callback_Server_stopPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Server::begin_checkUpdate.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_checkUpdate.
 */
class Callback_Server_checkUpdate_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_checkUpdate_Base> Callback_Server_checkUpdatePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Server::begin_setEnabled.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_setEnabled.
 */
class Callback_Server_setEnabled_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_setEnabled_Base> Callback_Server_setEnabledPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Server::begin_isEnabled.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_isEnabled.
 */
class Callback_Server_isEnabled_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_isEnabled_Base> Callback_Server_isEnabledPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Server::begin_sendSignal.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_sendSignal.
 */
class Callback_Server_sendSignal_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_sendSignal_Base> Callback_Server_sendSignalPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Server::begin_writeMessage.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_writeMessage.
 */
class Callback_Server_writeMessage_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_writeMessage_Base> Callback_Server_writeMessagePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Server::begin_getState.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_getState.
 */
class Callback_Server_getState_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_getState_Base> Callback_Server_getStatePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Server::begin_getPid.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_getPid.
 */
class Callback_Server_getPid_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_getPid_Base> Callback_Server_getPidPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Server::begin_setProcess.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_setProcess.
 */
class Callback_Server_setProcess_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Server_setProcess_Base> Callback_Server_setProcessPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::ReplicaObserver::begin_replicaInit.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaObserver_replicaInit.
 */
class Callback_ReplicaObserver_replicaInit_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ReplicaObserver_replicaInit_Base> Callback_ReplicaObserver_replicaInitPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::ReplicaObserver::begin_replicaAdded.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaObserver_replicaAdded.
 */
class Callback_ReplicaObserver_replicaAdded_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ReplicaObserver_replicaAdded_Base> Callback_ReplicaObserver_replicaAddedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::ReplicaObserver::begin_replicaRemoved.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaObserver_replicaRemoved.
 */
class Callback_ReplicaObserver_replicaRemoved_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ReplicaObserver_replicaRemoved_Base> Callback_ReplicaObserver_replicaRemovedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::PatcherFeedback::begin_finished.
 * Create a wrapper instance by calling ::IceGrid::newCallback_PatcherFeedback_finished.
 */
class Callback_PatcherFeedback_finished_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_PatcherFeedback_finished_Base> Callback_PatcherFeedback_finishedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::PatcherFeedback::begin_failed.
 * Create a wrapper instance by calling ::IceGrid::newCallback_PatcherFeedback_failed.
 */
class Callback_PatcherFeedback_failed_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_PatcherFeedback_failed_Base> Callback_PatcherFeedback_failedPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Node::begin_loadServer.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_loadServer.
 */
class Callback_Node_loadServer_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Node_loadServer_Base> Callback_Node_loadServerPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Node::begin_loadServerWithoutRestart.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_loadServerWithoutRestart.
 */
class Callback_Node_loadServerWithoutRestart_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Node_loadServerWithoutRestart_Base> Callback_Node_loadServerWithoutRestartPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Node::begin_destroyServer.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_destroyServer.
 */
class Callback_Node_destroyServer_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Node_destroyServer_Base> Callback_Node_destroyServerPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Node::begin_destroyServerWithoutRestart.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_destroyServerWithoutRestart.
 */
class Callback_Node_destroyServerWithoutRestart_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Node_destroyServerWithoutRestart_Base> Callback_Node_destroyServerWithoutRestartPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Node::begin_patch.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_patch.
 */
class Callback_Node_patch_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Node_patch_Base> Callback_Node_patchPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Node::begin_registerWithReplica.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_registerWithReplica.
 */
class Callback_Node_registerWithReplica_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Node_registerWithReplica_Base> Callback_Node_registerWithReplicaPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Node::begin_getName.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_getName.
 */
class Callback_Node_getName_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Node_getName_Base> Callback_Node_getNamePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Node::begin_getHostname.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_getHostname.
 */
class Callback_Node_getHostname_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Node_getHostname_Base> Callback_Node_getHostnamePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Node::begin_getLoad.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_getLoad.
 */
class Callback_Node_getLoad_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Node_getLoad_Base> Callback_Node_getLoadPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Node::begin_getProcessorSocketCount.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_getProcessorSocketCount.
 */
class Callback_Node_getProcessorSocketCount_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Node_getProcessorSocketCount_Base> Callback_Node_getProcessorSocketCountPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Node::begin_shutdown.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_shutdown.
 */
class Callback_Node_shutdown_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Node_shutdown_Base> Callback_Node_shutdownPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::NodeSession::begin_keepAlive.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_keepAlive.
 */
class Callback_NodeSession_keepAlive_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_NodeSession_keepAlive_Base> Callback_NodeSession_keepAlivePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::NodeSession::begin_setReplicaObserver.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_setReplicaObserver.
 */
class Callback_NodeSession_setReplicaObserver_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_NodeSession_setReplicaObserver_Base> Callback_NodeSession_setReplicaObserverPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::NodeSession::begin_getTimeout.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_getTimeout.
 */
class Callback_NodeSession_getTimeout_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_NodeSession_getTimeout_Base> Callback_NodeSession_getTimeoutPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::NodeSession::begin_getObserver.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_getObserver.
 */
class Callback_NodeSession_getObserver_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_NodeSession_getObserver_Base> Callback_NodeSession_getObserverPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::NodeSession::begin_loadServers.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_loadServers.
 */
class Callback_NodeSession_loadServers_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_NodeSession_loadServers_Base> Callback_NodeSession_loadServersPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::NodeSession::begin_getServers.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_getServers.
 */
class Callback_NodeSession_getServers_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_NodeSession_getServers_Base> Callback_NodeSession_getServersPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::NodeSession::begin_waitForApplicationUpdate.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_waitForApplicationUpdate.
 */
class Callback_NodeSession_waitForApplicationUpdate_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_NodeSession_waitForApplicationUpdate_Base> Callback_NodeSession_waitForApplicationUpdatePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::NodeSession::begin_destroy.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_destroy.
 */
class Callback_NodeSession_destroy_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_NodeSession_destroy_Base> Callback_NodeSession_destroyPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_keepAlive.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_keepAlive.
 */
class Callback_ReplicaSession_keepAlive_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ReplicaSession_keepAlive_Base> Callback_ReplicaSession_keepAlivePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_getTimeout.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_getTimeout.
 */
class Callback_ReplicaSession_getTimeout_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ReplicaSession_getTimeout_Base> Callback_ReplicaSession_getTimeoutPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_setDatabaseObserver.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_setDatabaseObserver.
 */
class Callback_ReplicaSession_setDatabaseObserver_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ReplicaSession_setDatabaseObserver_Base> Callback_ReplicaSession_setDatabaseObserverPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_setEndpoints.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_setEndpoints.
 */
class Callback_ReplicaSession_setEndpoints_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ReplicaSession_setEndpoints_Base> Callback_ReplicaSession_setEndpointsPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_registerWellKnownObjects.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_registerWellKnownObjects.
 */
class Callback_ReplicaSession_registerWellKnownObjects_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ReplicaSession_registerWellKnownObjects_Base> Callback_ReplicaSession_registerWellKnownObjectsPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_setAdapterDirectProxy.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_setAdapterDirectProxy.
 */
class Callback_ReplicaSession_setAdapterDirectProxy_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ReplicaSession_setAdapterDirectProxy_Base> Callback_ReplicaSession_setAdapterDirectProxyPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_receivedUpdate.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_receivedUpdate.
 */
class Callback_ReplicaSession_receivedUpdate_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ReplicaSession_receivedUpdate_Base> Callback_ReplicaSession_receivedUpdatePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_destroy.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_destroy.
 */
class Callback_ReplicaSession_destroy_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ReplicaSession_destroy_Base> Callback_ReplicaSession_destroyPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_registerNode.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_registerNode.
 */
class Callback_InternalRegistry_registerNode_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_InternalRegistry_registerNode_Base> Callback_InternalRegistry_registerNodePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_registerReplica.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_registerReplica.
 */
class Callback_InternalRegistry_registerReplica_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_InternalRegistry_registerReplica_Base> Callback_InternalRegistry_registerReplicaPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_registerWithReplica.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_registerWithReplica.
 */
class Callback_InternalRegistry_registerWithReplica_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_InternalRegistry_registerWithReplica_Base> Callback_InternalRegistry_registerWithReplicaPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_getNodes.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_getNodes.
 */
class Callback_InternalRegistry_getNodes_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_InternalRegistry_getNodes_Base> Callback_InternalRegistry_getNodesPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_getReplicas.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_getReplicas.
 */
class Callback_InternalRegistry_getReplicas_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_InternalRegistry_getReplicas_Base> Callback_InternalRegistry_getReplicasPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_getApplications.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_getApplications.
 */
class Callback_InternalRegistry_getApplications_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_InternalRegistry_getApplications_Base> Callback_InternalRegistry_getApplicationsPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_getAdapters.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_getAdapters.
 */
class Callback_InternalRegistry_getAdapters_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_InternalRegistry_getAdapters_Base> Callback_InternalRegistry_getAdaptersPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_getObjects.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_getObjects.
 */
class Callback_InternalRegistry_getObjects_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_InternalRegistry_getObjects_Base> Callback_InternalRegistry_getObjectsPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_shutdown.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_shutdown.
 */
class Callback_InternalRegistry_shutdown_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_InternalRegistry_shutdown_Base> Callback_InternalRegistry_shutdownPtr;

}

namespace IceProxy
{

namespace IceGrid
{

class InternalDbEnvDescriptor : public virtual ::Ice::Proxy<InternalDbEnvDescriptor, ::IceProxy::Ice::Object>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class InternalAdapterDescriptor : public virtual ::Ice::Proxy<InternalAdapterDescriptor, ::IceProxy::Ice::Object>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class InternalDistributionDescriptor : public virtual ::Ice::Proxy<InternalDistributionDescriptor, ::IceProxy::Ice::Object>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class InternalServerDescriptor : public virtual ::Ice::Proxy<InternalServerDescriptor, ::IceProxy::Ice::Object>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class Adapter : public virtual ::Ice::Proxy<Adapter, ::IceProxy::Ice::Object>
{
public:

    /**
     * Activate this adapter. If this adapter can be activated, this
     * will activate the adapter and return the direct proxy of the
     * adapter once it's active. If this adapter can be activated on
     * demand, this will return 0 if the adapter is inactive or the
     * adapter direct proxy it's active.
     * @param context The Context map to send with the invocation.
     */
    ::Ice::ObjectPrx activate(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_activate(_iceI_begin_activate(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Activate this adapter. If this adapter can be activated, this
     * will activate the adapter and return the direct proxy of the
     * adapter once it's active. If this adapter can be activated on
     * demand, this will return 0 if the adapter is inactive or the
     * adapter direct proxy it's active.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_activate(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_activate(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Activate this adapter. If this adapter can be activated, this
     * will activate the adapter and return the direct proxy of the
     * adapter once it's active. If this adapter can be activated on
     * demand, this will return 0 if the adapter is inactive or the
     * adapter direct proxy it's active.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_activate(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_activate(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Activate this adapter. If this adapter can be activated, this
     * will activate the adapter and return the direct proxy of the
     * adapter once it's active. If this adapter can be activated on
     * demand, this will return 0 if the adapter is inactive or the
     * adapter direct proxy it's active.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_activate(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_activate(context, cb, cookie);
    }

    /**
     * Activate this adapter. If this adapter can be activated, this
     * will activate the adapter and return the direct proxy of the
     * adapter once it's active. If this adapter can be activated on
     * demand, this will return 0 if the adapter is inactive or the
     * adapter direct proxy it's active.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_activate(const ::IceGrid::Callback_Adapter_activatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_activate(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Activate this adapter. If this adapter can be activated, this
     * will activate the adapter and return the direct proxy of the
     * adapter once it's active. If this adapter can be activated on
     * demand, this will return 0 if the adapter is inactive or the
     * adapter direct proxy it's active.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_activate(const ::Ice::Context& context, const ::IceGrid::Callback_Adapter_activatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_activate(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_activate.
     * @param result The asynchronous result object for the invocation.
     */
    ::Ice::ObjectPrx end_activate(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_activate(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the adapter direct proxy. The adapter direct proxy is a
     * proxy created with the object adapter. The proxy contains the
     * last known adapter endpoints.
     * @param context The Context map to send with the invocation.
     * @return A direct proxy containing the last known adapter
     * endpoints if the adapter is already active.
     */
    ::Ice::ObjectPrx getDirectProxy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getDirectProxy(_iceI_begin_getDirectProxy(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the adapter direct proxy. The adapter direct proxy is a
     * proxy created with the object adapter. The proxy contains the
     * last known adapter endpoints.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getDirectProxy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getDirectProxy(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the adapter direct proxy. The adapter direct proxy is a
     * proxy created with the object adapter. The proxy contains the
     * last known adapter endpoints.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getDirectProxy(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getDirectProxy(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the adapter direct proxy. The adapter direct proxy is a
     * proxy created with the object adapter. The proxy contains the
     * last known adapter endpoints.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getDirectProxy(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getDirectProxy(context, cb, cookie);
    }

    /**
     * Get the adapter direct proxy. The adapter direct proxy is a
     * proxy created with the object adapter. The proxy contains the
     * last known adapter endpoints.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getDirectProxy(const ::IceGrid::Callback_Adapter_getDirectProxyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getDirectProxy(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the adapter direct proxy. The adapter direct proxy is a
     * proxy created with the object adapter. The proxy contains the
     * last known adapter endpoints.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getDirectProxy(const ::Ice::Context& context, const ::IceGrid::Callback_Adapter_getDirectProxyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getDirectProxy(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getDirectProxy.
     * @param result The asynchronous result object for the invocation.
     * @return A direct proxy containing the last known adapter
     * endpoints if the adapter is already active.
     */
    ::Ice::ObjectPrx end_getDirectProxy(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getDirectProxy(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Set the direct proxy for this adapter.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::AdapterActiveException The adapter is already
     * active. It's not possible to override the direct proxy of an
     * active adapter.
     */
    void setDirectProxy(const ::Ice::ObjectPrx& proxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setDirectProxy(_iceI_begin_setDirectProxy(proxy, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Set the direct proxy for this adapter.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setDirectProxy(const ::Ice::ObjectPrx& proxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setDirectProxy(proxy, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Set the direct proxy for this adapter.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setDirectProxy(const ::Ice::ObjectPrx& proxy, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setDirectProxy(proxy, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set the direct proxy for this adapter.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setDirectProxy(const ::Ice::ObjectPrx& proxy, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setDirectProxy(proxy, context, cb, cookie);
    }

    /**
     * Set the direct proxy for this adapter.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setDirectProxy(const ::Ice::ObjectPrx& proxy, const ::IceGrid::Callback_Adapter_setDirectProxyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setDirectProxy(proxy, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set the direct proxy for this adapter.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setDirectProxy(const ::Ice::ObjectPrx& proxy, const ::Ice::Context& context, const ::IceGrid::Callback_Adapter_setDirectProxyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setDirectProxy(proxy, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setDirectProxy.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::AdapterActiveException The adapter is already
     * active. It's not possible to override the direct proxy of an
     * active adapter.
     */
    void end_setDirectProxy(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_setDirectProxy(const ::Ice::ObjectPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class FileReader : public virtual ::Ice::Proxy<FileReader, ::IceProxy::Ice::Object>
{
public:

    /**
     * Count the number of given lines from the end of the file and
     * return the file offset.
     * @param context The Context map to send with the invocation.
     */
    ::Ice::Long getOffsetFromEnd(const ::std::string& filename, ::Ice::Int lines, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getOffsetFromEnd(_iceI_begin_getOffsetFromEnd(filename, lines, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Count the number of given lines from the end of the file and
     * return the file offset.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getOffsetFromEnd(const ::std::string& filename, ::Ice::Int lines, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getOffsetFromEnd(filename, lines, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Count the number of given lines from the end of the file and
     * return the file offset.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getOffsetFromEnd(const ::std::string& filename, ::Ice::Int lines, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getOffsetFromEnd(filename, lines, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Count the number of given lines from the end of the file and
     * return the file offset.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getOffsetFromEnd(const ::std::string& filename, ::Ice::Int lines, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getOffsetFromEnd(filename, lines, context, cb, cookie);
    }

    /**
     * Count the number of given lines from the end of the file and
     * return the file offset.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getOffsetFromEnd(const ::std::string& filename, ::Ice::Int lines, const ::IceGrid::Callback_FileReader_getOffsetFromEndPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getOffsetFromEnd(filename, lines, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Count the number of given lines from the end of the file and
     * return the file offset.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getOffsetFromEnd(const ::std::string& filename, ::Ice::Int lines, const ::Ice::Context& context, const ::IceGrid::Callback_FileReader_getOffsetFromEndPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getOffsetFromEnd(filename, lines, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getOffsetFromEnd.
     * @param result The asynchronous result object for the invocation.
     */
    ::Ice::Long end_getOffsetFromEnd(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getOffsetFromEnd(const ::std::string&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Read lines (or size bytes) at the specified position from the given file.
     * @param context The Context map to send with the invocation.
     */
    bool read(const ::std::string& filename, ::Ice::Long pos, ::Ice::Int size, ::Ice::Long& newPos, ::Ice::StringSeq& lines, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_read(newPos, lines, _iceI_begin_read(filename, pos, size, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Read lines (or size bytes) at the specified position from the given file.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_read(const ::std::string& filename, ::Ice::Long pos, ::Ice::Int size, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_read(filename, pos, size, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Read lines (or size bytes) at the specified position from the given file.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_read(const ::std::string& filename, ::Ice::Long pos, ::Ice::Int size, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_read(filename, pos, size, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Read lines (or size bytes) at the specified position from the given file.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_read(const ::std::string& filename, ::Ice::Long pos, ::Ice::Int size, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_read(filename, pos, size, context, cb, cookie);
    }

    /**
     * Read lines (or size bytes) at the specified position from the given file.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_read(const ::std::string& filename, ::Ice::Long pos, ::Ice::Int size, const ::IceGrid::Callback_FileReader_readPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_read(filename, pos, size, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Read lines (or size bytes) at the specified position from the given file.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_read(const ::std::string& filename, ::Ice::Long pos, ::Ice::Int size, const ::Ice::Context& context, const ::IceGrid::Callback_FileReader_readPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_read(filename, pos, size, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_read.
     * @param result The asynchronous result object for the invocation.
     */
    bool end_read(::Ice::Long& newPos, ::Ice::StringSeq& lines, const ::Ice::AsyncResultPtr& result);
    /// \cond INTERNAL

    void _iceI_end_read(::Ice::Long& iceP_newPos, ::Ice::StringSeq& iceP_lines, bool& ret, const ::Ice::AsyncResultPtr&);
    /// \endcond

private:

    ::Ice::AsyncResultPtr _iceI_begin_read(const ::std::string&, ::Ice::Long, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class Server : public virtual ::Ice::Proxy<Server, ::IceProxy::IceGrid::FileReader>
{
public:

    /**
     * Start the server.
     * @param context The Context map to send with the invocation.
     */
    void start(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_start(_iceI_begin_start(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Start the server.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_start(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_start(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Start the server.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_start(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_start(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Start the server.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_start(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_start(context, cb, cookie);
    }

    /**
     * Start the server.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_start(const ::IceGrid::Callback_Server_startPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_start(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Start the server.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_start(const ::Ice::Context& context, const ::IceGrid::Callback_Server_startPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_start(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_start.
     * @param result The asynchronous result object for the invocation.
     */
    void end_start(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_start(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Stop the server. This methods returns only when the server is
     * deactivated. If the server doesn't stop after a configurable
     * amount of time, it will be killed.
     * @param context The Context map to send with the invocation.
     */
    void stop(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_stop(_iceI_begin_stop(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Stop the server. This methods returns only when the server is
     * deactivated. If the server doesn't stop after a configurable
     * amount of time, it will be killed.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stop(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_stop(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Stop the server. This methods returns only when the server is
     * deactivated. If the server doesn't stop after a configurable
     * amount of time, it will be killed.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stop(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stop(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Stop the server. This methods returns only when the server is
     * deactivated. If the server doesn't stop after a configurable
     * amount of time, it will be killed.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stop(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stop(context, cb, cookie);
    }

    /**
     * Stop the server. This methods returns only when the server is
     * deactivated. If the server doesn't stop after a configurable
     * amount of time, it will be killed.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stop(const ::IceGrid::Callback_Server_stopPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stop(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Stop the server. This methods returns only when the server is
     * deactivated. If the server doesn't stop after a configurable
     * amount of time, it will be killed.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_stop(const ::Ice::Context& context, const ::IceGrid::Callback_Server_stopPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stop(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_stop.
     * @param result The asynchronous result object for the invocation.
     */
    void end_stop(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_stop(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Check if the given server can be loaded on this node.
     * @param context The Context map to send with the invocation.
     * @return True if the server is inactive.
     * @throws IceGrid::DeploymentException Raised if the server can't be updated.
     */
    bool checkUpdate(const ::IceGrid::InternalServerDescriptorPtr& svr, bool noRestart, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_checkUpdate(_iceI_begin_checkUpdate(svr, noRestart, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Check if the given server can be loaded on this node.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_checkUpdate(const ::IceGrid::InternalServerDescriptorPtr& svr, bool noRestart, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_checkUpdate(svr, noRestart, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Check if the given server can be loaded on this node.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_checkUpdate(const ::IceGrid::InternalServerDescriptorPtr& svr, bool noRestart, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_checkUpdate(svr, noRestart, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Check if the given server can be loaded on this node.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_checkUpdate(const ::IceGrid::InternalServerDescriptorPtr& svr, bool noRestart, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_checkUpdate(svr, noRestart, context, cb, cookie);
    }

    /**
     * Check if the given server can be loaded on this node.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_checkUpdate(const ::IceGrid::InternalServerDescriptorPtr& svr, bool noRestart, const ::IceGrid::Callback_Server_checkUpdatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_checkUpdate(svr, noRestart, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Check if the given server can be loaded on this node.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_checkUpdate(const ::IceGrid::InternalServerDescriptorPtr& svr, bool noRestart, const ::Ice::Context& context, const ::IceGrid::Callback_Server_checkUpdatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_checkUpdate(svr, noRestart, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_checkUpdate.
     * @param result The asynchronous result object for the invocation.
     * @return True if the server is inactive.
     * @throws IceGrid::DeploymentException Raised if the server can't be updated.
     */
    bool end_checkUpdate(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_checkUpdate(const ::IceGrid::InternalServerDescriptorPtr&, bool, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Enable or disable the server.
     * @param context The Context map to send with the invocation.
     */
    void setEnabled(bool enable, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setEnabled(_iceI_begin_setEnabled(enable, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Enable or disable the server.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setEnabled(bool enable, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setEnabled(enable, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Enable or disable the server.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setEnabled(bool enable, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setEnabled(enable, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Enable or disable the server.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setEnabled(bool enable, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setEnabled(enable, context, cb, cookie);
    }

    /**
     * Enable or disable the server.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setEnabled(bool enable, const ::IceGrid::Callback_Server_setEnabledPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setEnabled(enable, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Enable or disable the server.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setEnabled(bool enable, const ::Ice::Context& context, const ::IceGrid::Callback_Server_setEnabledPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setEnabled(enable, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setEnabled.
     * @param result The asynchronous result object for the invocation.
     */
    void end_setEnabled(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_setEnabled(bool, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Check if the server is enabled.
     * @param context The Context map to send with the invocation.
     */
    bool isEnabled(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_isEnabled(_iceI_begin_isEnabled(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Check if the server is enabled.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_isEnabled(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_isEnabled(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Check if the server is enabled.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_isEnabled(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_isEnabled(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Check if the server is enabled.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_isEnabled(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_isEnabled(context, cb, cookie);
    }

    /**
     * Check if the server is enabled.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_isEnabled(const ::IceGrid::Callback_Server_isEnabledPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_isEnabled(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Check if the server is enabled.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_isEnabled(const ::Ice::Context& context, const ::IceGrid::Callback_Server_isEnabledPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_isEnabled(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_isEnabled.
     * @param result The asynchronous result object for the invocation.
     */
    bool end_isEnabled(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_isEnabled(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Send signal to the server
     * @param context The Context map to send with the invocation.
     */
    void sendSignal(const ::std::string& signal, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_sendSignal(_iceI_begin_sendSignal(signal, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Send signal to the server
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_sendSignal(const ::std::string& signal, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_sendSignal(signal, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Send signal to the server
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_sendSignal(const ::std::string& signal, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendSignal(signal, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Send signal to the server
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_sendSignal(const ::std::string& signal, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendSignal(signal, context, cb, cookie);
    }

    /**
     * Send signal to the server
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_sendSignal(const ::std::string& signal, const ::IceGrid::Callback_Server_sendSignalPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendSignal(signal, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Send signal to the server
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_sendSignal(const ::std::string& signal, const ::Ice::Context& context, const ::IceGrid::Callback_Server_sendSignalPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendSignal(signal, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_sendSignal.
     * @param result The asynchronous result object for the invocation.
     */
    void end_sendSignal(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_sendSignal(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Write message on servers' stdout or stderr.
     * @param context The Context map to send with the invocation.
     */
    void writeMessage(const ::std::string& message, ::Ice::Int fd, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_writeMessage(_iceI_begin_writeMessage(message, fd, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Write message on servers' stdout or stderr.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_writeMessage(const ::std::string& message, ::Ice::Int fd, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_writeMessage(message, fd, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Write message on servers' stdout or stderr.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_writeMessage(const ::std::string& message, ::Ice::Int fd, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_writeMessage(message, fd, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Write message on servers' stdout or stderr.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_writeMessage(const ::std::string& message, ::Ice::Int fd, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_writeMessage(message, fd, context, cb, cookie);
    }

    /**
     * Write message on servers' stdout or stderr.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_writeMessage(const ::std::string& message, ::Ice::Int fd, const ::IceGrid::Callback_Server_writeMessagePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_writeMessage(message, fd, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Write message on servers' stdout or stderr.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_writeMessage(const ::std::string& message, ::Ice::Int fd, const ::Ice::Context& context, const ::IceGrid::Callback_Server_writeMessagePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_writeMessage(message, fd, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_writeMessage.
     * @param result The asynchronous result object for the invocation.
     */
    void end_writeMessage(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_writeMessage(const ::std::string&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Return the server state.
     * @param context The Context map to send with the invocation.
     * @return The server state.
     * @see ServerState
     */
    ::IceGrid::ServerState getState(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getState(_iceI_begin_getState(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Return the server state.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see ServerState
     */
    ::Ice::AsyncResultPtr begin_getState(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getState(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Return the server state.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see ServerState
     */
    ::Ice::AsyncResultPtr begin_getState(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getState(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return the server state.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see ServerState
     */
    ::Ice::AsyncResultPtr begin_getState(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getState(context, cb, cookie);
    }

    /**
     * Return the server state.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see ServerState
     */
    ::Ice::AsyncResultPtr begin_getState(const ::IceGrid::Callback_Server_getStatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getState(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return the server state.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see ServerState
     */
    ::Ice::AsyncResultPtr begin_getState(const ::Ice::Context& context, const ::IceGrid::Callback_Server_getStatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getState(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getState.
     * @param result The asynchronous result object for the invocation.
     * @return The server state.
     */
    ::IceGrid::ServerState end_getState(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getState(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the server pid. Note that the value returned by this method
     * is system dependant. On Unix operating systems, it's the pid
     * value returned by the fork() system call and converted to an
     * integer.
     * @param context The Context map to send with the invocation.
     */
    ::Ice::Int getPid(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getPid(_iceI_begin_getPid(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the server pid. Note that the value returned by this method
     * is system dependant. On Unix operating systems, it's the pid
     * value returned by the fork() system call and converted to an
     * integer.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getPid(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getPid(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the server pid. Note that the value returned by this method
     * is system dependant. On Unix operating systems, it's the pid
     * value returned by the fork() system call and converted to an
     * integer.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getPid(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getPid(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the server pid. Note that the value returned by this method
     * is system dependant. On Unix operating systems, it's the pid
     * value returned by the fork() system call and converted to an
     * integer.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getPid(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getPid(context, cb, cookie);
    }

    /**
     * Get the server pid. Note that the value returned by this method
     * is system dependant. On Unix operating systems, it's the pid
     * value returned by the fork() system call and converted to an
     * integer.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getPid(const ::IceGrid::Callback_Server_getPidPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getPid(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the server pid. Note that the value returned by this method
     * is system dependant. On Unix operating systems, it's the pid
     * value returned by the fork() system call and converted to an
     * integer.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getPid(const ::Ice::Context& context, const ::IceGrid::Callback_Server_getPidPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getPid(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getPid.
     * @param result The asynchronous result object for the invocation.
     */
    ::Ice::Int end_getPid(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getPid(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Set the process proxy.
     * @param context The Context map to send with the invocation.
     */
    void setProcess(const ::Ice::ProcessPrx& proc, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setProcess(_iceI_begin_setProcess(proc, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Set the process proxy.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setProcess(const ::Ice::ProcessPrx& proc, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setProcess(proc, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Set the process proxy.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setProcess(const ::Ice::ProcessPrx& proc, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setProcess(proc, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set the process proxy.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setProcess(const ::Ice::ProcessPrx& proc, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setProcess(proc, context, cb, cookie);
    }

    /**
     * Set the process proxy.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setProcess(const ::Ice::ProcessPrx& proc, const ::IceGrid::Callback_Server_setProcessPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setProcess(proc, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set the process proxy.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setProcess(const ::Ice::ProcessPrx& proc, const ::Ice::Context& context, const ::IceGrid::Callback_Server_setProcessPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setProcess(proc, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setProcess.
     * @param result The asynchronous result object for the invocation.
     */
    void end_setProcess(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_setProcess(const ::Ice::ProcessPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ReplicaObserver : public virtual ::Ice::Proxy<ReplicaObserver, ::IceProxy::Ice::Object>
{
public:

    /**
     * Initialization of the replica observer.
     * @param context The Context map to send with the invocation.
     */
    void replicaInit(const ::IceGrid::InternalRegistryPrxSeq& replicas, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_replicaInit(_iceI_begin_replicaInit(replicas, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Initialization of the replica observer.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_replicaInit(const ::IceGrid::InternalRegistryPrxSeq& replicas, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_replicaInit(replicas, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Initialization of the replica observer.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_replicaInit(const ::IceGrid::InternalRegistryPrxSeq& replicas, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_replicaInit(replicas, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Initialization of the replica observer.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_replicaInit(const ::IceGrid::InternalRegistryPrxSeq& replicas, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_replicaInit(replicas, context, cb, cookie);
    }

    /**
     * Initialization of the replica observer.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_replicaInit(const ::IceGrid::InternalRegistryPrxSeq& replicas, const ::IceGrid::Callback_ReplicaObserver_replicaInitPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_replicaInit(replicas, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Initialization of the replica observer.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_replicaInit(const ::IceGrid::InternalRegistryPrxSeq& replicas, const ::Ice::Context& context, const ::IceGrid::Callback_ReplicaObserver_replicaInitPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_replicaInit(replicas, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_replicaInit.
     * @param result The asynchronous result object for the invocation.
     */
    void end_replicaInit(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_replicaInit(const ::IceGrid::InternalRegistryPrxSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Notification that a replica has been added. The node should
     * establish a session with this new replica.
     * @param context The Context map to send with the invocation.
     */
    void replicaAdded(const ::IceGrid::InternalRegistryPrx& replica, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_replicaAdded(_iceI_begin_replicaAdded(replica, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Notification that a replica has been added. The node should
     * establish a session with this new replica.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_replicaAdded(const ::IceGrid::InternalRegistryPrx& replica, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_replicaAdded(replica, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Notification that a replica has been added. The node should
     * establish a session with this new replica.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_replicaAdded(const ::IceGrid::InternalRegistryPrx& replica, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_replicaAdded(replica, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Notification that a replica has been added. The node should
     * establish a session with this new replica.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_replicaAdded(const ::IceGrid::InternalRegistryPrx& replica, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_replicaAdded(replica, context, cb, cookie);
    }

    /**
     * Notification that a replica has been added. The node should
     * establish a session with this new replica.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_replicaAdded(const ::IceGrid::InternalRegistryPrx& replica, const ::IceGrid::Callback_ReplicaObserver_replicaAddedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_replicaAdded(replica, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Notification that a replica has been added. The node should
     * establish a session with this new replica.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_replicaAdded(const ::IceGrid::InternalRegistryPrx& replica, const ::Ice::Context& context, const ::IceGrid::Callback_ReplicaObserver_replicaAddedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_replicaAdded(replica, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_replicaAdded.
     * @param result The asynchronous result object for the invocation.
     */
    void end_replicaAdded(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_replicaAdded(const ::IceGrid::InternalRegistryPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Notification that a replica has been removed. The node should
     * destroy the session to this replica.
     * @param context The Context map to send with the invocation.
     */
    void replicaRemoved(const ::IceGrid::InternalRegistryPrx& replica, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_replicaRemoved(_iceI_begin_replicaRemoved(replica, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Notification that a replica has been removed. The node should
     * destroy the session to this replica.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_replicaRemoved(const ::IceGrid::InternalRegistryPrx& replica, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_replicaRemoved(replica, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Notification that a replica has been removed. The node should
     * destroy the session to this replica.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_replicaRemoved(const ::IceGrid::InternalRegistryPrx& replica, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_replicaRemoved(replica, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Notification that a replica has been removed. The node should
     * destroy the session to this replica.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_replicaRemoved(const ::IceGrid::InternalRegistryPrx& replica, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_replicaRemoved(replica, context, cb, cookie);
    }

    /**
     * Notification that a replica has been removed. The node should
     * destroy the session to this replica.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_replicaRemoved(const ::IceGrid::InternalRegistryPrx& replica, const ::IceGrid::Callback_ReplicaObserver_replicaRemovedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_replicaRemoved(replica, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Notification that a replica has been removed. The node should
     * destroy the session to this replica.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_replicaRemoved(const ::IceGrid::InternalRegistryPrx& replica, const ::Ice::Context& context, const ::IceGrid::Callback_ReplicaObserver_replicaRemovedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_replicaRemoved(replica, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_replicaRemoved.
     * @param result The asynchronous result object for the invocation.
     */
    void end_replicaRemoved(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_replicaRemoved(const ::IceGrid::InternalRegistryPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class PatcherFeedback : public virtual ::Ice::Proxy<PatcherFeedback, ::IceProxy::Ice::Object>
{
public:

    /**
     * The patch completed successfully.
     * @param context The Context map to send with the invocation.
     */
    void finished(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_finished(_iceI_begin_finished(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * The patch completed successfully.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_finished(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_finished(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * The patch completed successfully.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_finished(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_finished(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The patch completed successfully.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_finished(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_finished(context, cb, cookie);
    }

    /**
     * The patch completed successfully.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_finished(const ::IceGrid::Callback_PatcherFeedback_finishedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_finished(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The patch completed successfully.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_finished(const ::Ice::Context& context, const ::IceGrid::Callback_PatcherFeedback_finishedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_finished(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_finished.
     * @param result The asynchronous result object for the invocation.
     */
    void end_finished(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_finished(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * The patch on the given node failed for the given reason.
     * @param context The Context map to send with the invocation.
     */
    void failed(const ::std::string& reason, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_failed(_iceI_begin_failed(reason, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * The patch on the given node failed for the given reason.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_failed(const ::std::string& reason, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_failed(reason, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * The patch on the given node failed for the given reason.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_failed(const ::std::string& reason, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_failed(reason, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The patch on the given node failed for the given reason.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_failed(const ::std::string& reason, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_failed(reason, context, cb, cookie);
    }

    /**
     * The patch on the given node failed for the given reason.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_failed(const ::std::string& reason, const ::IceGrid::Callback_PatcherFeedback_failedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_failed(reason, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The patch on the given node failed for the given reason.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_failed(const ::std::string& reason, const ::Ice::Context& context, const ::IceGrid::Callback_PatcherFeedback_failedPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_failed(reason, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_failed.
     * @param result The asynchronous result object for the invocation.
     */
    void end_failed(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_failed(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

/// \cond INTERNAL
class _NodeBase : public virtual ::IceProxy::IceGrid::FileReader, 
                  public virtual ::IceProxy::IceGrid::ReplicaObserver
{
public:

    virtual ~_NodeBase();

protected:

    virtual Object* _newInstance() const = 0;
};
/// \endcond

class Node : public virtual ::Ice::Proxy<Node, _NodeBase>
{
public:

    /**
     * Load the given server. If the server resources weren't already
     * created (database environment directories, property files, etc),
     * they will be created.
     * @param context The Context map to send with the invocation.
     */
    ::IceGrid::ServerPrx loadServer(const ::IceGrid::InternalServerDescriptorPtr& svr, const ::std::string& replicaName, ::IceGrid::AdapterPrxDict& adapters, ::Ice::Int& actTimeout, ::Ice::Int& deactTimeout, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_loadServer(adapters, actTimeout, deactTimeout, _iceI_begin_loadServer(svr, replicaName, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Load the given server. If the server resources weren't already
     * created (database environment directories, property files, etc),
     * they will be created.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_loadServer(const ::IceGrid::InternalServerDescriptorPtr& svr, const ::std::string& replicaName, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_loadServer(svr, replicaName, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Load the given server. If the server resources weren't already
     * created (database environment directories, property files, etc),
     * they will be created.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_loadServer(const ::IceGrid::InternalServerDescriptorPtr& svr, const ::std::string& replicaName, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_loadServer(svr, replicaName, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Load the given server. If the server resources weren't already
     * created (database environment directories, property files, etc),
     * they will be created.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_loadServer(const ::IceGrid::InternalServerDescriptorPtr& svr, const ::std::string& replicaName, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_loadServer(svr, replicaName, context, cb, cookie);
    }

    /**
     * Load the given server. If the server resources weren't already
     * created (database environment directories, property files, etc),
     * they will be created.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_loadServer(const ::IceGrid::InternalServerDescriptorPtr& svr, const ::std::string& replicaName, const ::IceGrid::Callback_Node_loadServerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_loadServer(svr, replicaName, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Load the given server. If the server resources weren't already
     * created (database environment directories, property files, etc),
     * they will be created.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_loadServer(const ::IceGrid::InternalServerDescriptorPtr& svr, const ::std::string& replicaName, const ::Ice::Context& context, const ::IceGrid::Callback_Node_loadServerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_loadServer(svr, replicaName, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_loadServer.
     * @param result The asynchronous result object for the invocation.
     */
    ::IceGrid::ServerPrx end_loadServer(::IceGrid::AdapterPrxDict& adapters, ::Ice::Int& actTimeout, ::Ice::Int& deactTimeout, const ::Ice::AsyncResultPtr& result);
    /// \cond INTERNAL

    void _iceI_end_loadServer(::IceGrid::AdapterPrxDict& iceP_adapters, ::Ice::Int& iceP_actTimeout, ::Ice::Int& iceP_deactTimeout, ::IceGrid::ServerPrx& ret, const ::Ice::AsyncResultPtr&);
    /// \endcond

private:

    ::Ice::AsyncResultPtr _iceI_begin_loadServer(const ::IceGrid::InternalServerDescriptorPtr&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Load the given server and ensure the server won't be
     * restarted. If the server resources weren't already created
     * (database environment directories, property files, etc), they
     * will be created. If the server can't be updated without a
     * restart, a DeploymentException is raised.
     * @param context The Context map to send with the invocation.
     */
    ::IceGrid::ServerPrx loadServerWithoutRestart(const ::IceGrid::InternalServerDescriptorPtr& svr, const ::std::string& replicaName, ::IceGrid::AdapterPrxDict& adapters, ::Ice::Int& actTimeout, ::Ice::Int& deactTimeout, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_loadServerWithoutRestart(adapters, actTimeout, deactTimeout, _iceI_begin_loadServerWithoutRestart(svr, replicaName, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Load the given server and ensure the server won't be
     * restarted. If the server resources weren't already created
     * (database environment directories, property files, etc), they
     * will be created. If the server can't be updated without a
     * restart, a DeploymentException is raised.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_loadServerWithoutRestart(const ::IceGrid::InternalServerDescriptorPtr& svr, const ::std::string& replicaName, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_loadServerWithoutRestart(svr, replicaName, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Load the given server and ensure the server won't be
     * restarted. If the server resources weren't already created
     * (database environment directories, property files, etc), they
     * will be created. If the server can't be updated without a
     * restart, a DeploymentException is raised.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_loadServerWithoutRestart(const ::IceGrid::InternalServerDescriptorPtr& svr, const ::std::string& replicaName, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_loadServerWithoutRestart(svr, replicaName, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Load the given server and ensure the server won't be
     * restarted. If the server resources weren't already created
     * (database environment directories, property files, etc), they
     * will be created. If the server can't be updated without a
     * restart, a DeploymentException is raised.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_loadServerWithoutRestart(const ::IceGrid::InternalServerDescriptorPtr& svr, const ::std::string& replicaName, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_loadServerWithoutRestart(svr, replicaName, context, cb, cookie);
    }

    /**
     * Load the given server and ensure the server won't be
     * restarted. If the server resources weren't already created
     * (database environment directories, property files, etc), they
     * will be created. If the server can't be updated without a
     * restart, a DeploymentException is raised.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_loadServerWithoutRestart(const ::IceGrid::InternalServerDescriptorPtr& svr, const ::std::string& replicaName, const ::IceGrid::Callback_Node_loadServerWithoutRestartPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_loadServerWithoutRestart(svr, replicaName, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Load the given server and ensure the server won't be
     * restarted. If the server resources weren't already created
     * (database environment directories, property files, etc), they
     * will be created. If the server can't be updated without a
     * restart, a DeploymentException is raised.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_loadServerWithoutRestart(const ::IceGrid::InternalServerDescriptorPtr& svr, const ::std::string& replicaName, const ::Ice::Context& context, const ::IceGrid::Callback_Node_loadServerWithoutRestartPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_loadServerWithoutRestart(svr, replicaName, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_loadServerWithoutRestart.
     * @param result The asynchronous result object for the invocation.
     */
    ::IceGrid::ServerPrx end_loadServerWithoutRestart(::IceGrid::AdapterPrxDict& adapters, ::Ice::Int& actTimeout, ::Ice::Int& deactTimeout, const ::Ice::AsyncResultPtr& result);
    /// \cond INTERNAL

    void _iceI_end_loadServerWithoutRestart(::IceGrid::AdapterPrxDict& iceP_adapters, ::Ice::Int& iceP_actTimeout, ::Ice::Int& iceP_deactTimeout, ::IceGrid::ServerPrx& ret, const ::Ice::AsyncResultPtr&);
    /// \endcond

private:

    ::Ice::AsyncResultPtr _iceI_begin_loadServerWithoutRestart(const ::IceGrid::InternalServerDescriptorPtr&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Destroy the given server.
     * @param context The Context map to send with the invocation.
     */
    void destroyServer(const ::std::string& name, const ::std::string& uuid, ::Ice::Int revision, const ::std::string& replicaName, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_destroyServer(_iceI_begin_destroyServer(name, uuid, revision, replicaName, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Destroy the given server.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroyServer(const ::std::string& name, const ::std::string& uuid, ::Ice::Int revision, const ::std::string& replicaName, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_destroyServer(name, uuid, revision, replicaName, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Destroy the given server.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroyServer(const ::std::string& name, const ::std::string& uuid, ::Ice::Int revision, const ::std::string& replicaName, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroyServer(name, uuid, revision, replicaName, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Destroy the given server.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroyServer(const ::std::string& name, const ::std::string& uuid, ::Ice::Int revision, const ::std::string& replicaName, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroyServer(name, uuid, revision, replicaName, context, cb, cookie);
    }

    /**
     * Destroy the given server.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroyServer(const ::std::string& name, const ::std::string& uuid, ::Ice::Int revision, const ::std::string& replicaName, const ::IceGrid::Callback_Node_destroyServerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroyServer(name, uuid, revision, replicaName, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Destroy the given server.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroyServer(const ::std::string& name, const ::std::string& uuid, ::Ice::Int revision, const ::std::string& replicaName, const ::Ice::Context& context, const ::IceGrid::Callback_Node_destroyServerPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroyServer(name, uuid, revision, replicaName, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_destroyServer.
     * @param result The asynchronous result object for the invocation.
     */
    void end_destroyServer(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_destroyServer(const ::std::string&, const ::std::string&, ::Ice::Int, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Destroy the server if it's not active.
     * @param context The Context map to send with the invocation.
     */
    void destroyServerWithoutRestart(const ::std::string& name, const ::std::string& uuid, ::Ice::Int revision, const ::std::string& replicaName, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_destroyServerWithoutRestart(_iceI_begin_destroyServerWithoutRestart(name, uuid, revision, replicaName, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Destroy the server if it's not active.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroyServerWithoutRestart(const ::std::string& name, const ::std::string& uuid, ::Ice::Int revision, const ::std::string& replicaName, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_destroyServerWithoutRestart(name, uuid, revision, replicaName, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Destroy the server if it's not active.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroyServerWithoutRestart(const ::std::string& name, const ::std::string& uuid, ::Ice::Int revision, const ::std::string& replicaName, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroyServerWithoutRestart(name, uuid, revision, replicaName, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Destroy the server if it's not active.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroyServerWithoutRestart(const ::std::string& name, const ::std::string& uuid, ::Ice::Int revision, const ::std::string& replicaName, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroyServerWithoutRestart(name, uuid, revision, replicaName, context, cb, cookie);
    }

    /**
     * Destroy the server if it's not active.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroyServerWithoutRestart(const ::std::string& name, const ::std::string& uuid, ::Ice::Int revision, const ::std::string& replicaName, const ::IceGrid::Callback_Node_destroyServerWithoutRestartPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroyServerWithoutRestart(name, uuid, revision, replicaName, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Destroy the server if it's not active.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroyServerWithoutRestart(const ::std::string& name, const ::std::string& uuid, ::Ice::Int revision, const ::std::string& replicaName, const ::Ice::Context& context, const ::IceGrid::Callback_Node_destroyServerWithoutRestartPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroyServerWithoutRestart(name, uuid, revision, replicaName, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_destroyServerWithoutRestart.
     * @param result The asynchronous result object for the invocation.
     */
    void end_destroyServerWithoutRestart(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_destroyServerWithoutRestart(const ::std::string&, const ::std::string&, ::Ice::Int, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Patch application and server distributions. If some servers
     * using a distribution directory to patch are active, this method
     * will raise a PatchException unless shutdown is set to true. In
     * which case the servers will be shutdown.
     * @param context The Context map to send with the invocation.
     */
    void patch(const ::IceGrid::PatcherFeedbackPrx& feedback, const ::std::string& application, const ::std::string& server, const ::IceGrid::InternalDistributionDescriptorPtr& appDistrib, bool shutdown, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_patch(_iceI_begin_patch(feedback, application, server, appDistrib, shutdown, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Patch application and server distributions. If some servers
     * using a distribution directory to patch are active, this method
     * will raise a PatchException unless shutdown is set to true. In
     * which case the servers will be shutdown.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_patch(const ::IceGrid::PatcherFeedbackPrx& feedback, const ::std::string& application, const ::std::string& server, const ::IceGrid::InternalDistributionDescriptorPtr& appDistrib, bool shutdown, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_patch(feedback, application, server, appDistrib, shutdown, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Patch application and server distributions. If some servers
     * using a distribution directory to patch are active, this method
     * will raise a PatchException unless shutdown is set to true. In
     * which case the servers will be shutdown.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_patch(const ::IceGrid::PatcherFeedbackPrx& feedback, const ::std::string& application, const ::std::string& server, const ::IceGrid::InternalDistributionDescriptorPtr& appDistrib, bool shutdown, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_patch(feedback, application, server, appDistrib, shutdown, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Patch application and server distributions. If some servers
     * using a distribution directory to patch are active, this method
     * will raise a PatchException unless shutdown is set to true. In
     * which case the servers will be shutdown.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_patch(const ::IceGrid::PatcherFeedbackPrx& feedback, const ::std::string& application, const ::std::string& server, const ::IceGrid::InternalDistributionDescriptorPtr& appDistrib, bool shutdown, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_patch(feedback, application, server, appDistrib, shutdown, context, cb, cookie);
    }

    /**
     * Patch application and server distributions. If some servers
     * using a distribution directory to patch are active, this method
     * will raise a PatchException unless shutdown is set to true. In
     * which case the servers will be shutdown.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_patch(const ::IceGrid::PatcherFeedbackPrx& feedback, const ::std::string& application, const ::std::string& server, const ::IceGrid::InternalDistributionDescriptorPtr& appDistrib, bool shutdown, const ::IceGrid::Callback_Node_patchPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_patch(feedback, application, server, appDistrib, shutdown, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Patch application and server distributions. If some servers
     * using a distribution directory to patch are active, this method
     * will raise a PatchException unless shutdown is set to true. In
     * which case the servers will be shutdown.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_patch(const ::IceGrid::PatcherFeedbackPrx& feedback, const ::std::string& application, const ::std::string& server, const ::IceGrid::InternalDistributionDescriptorPtr& appDistrib, bool shutdown, const ::Ice::Context& context, const ::IceGrid::Callback_Node_patchPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_patch(feedback, application, server, appDistrib, shutdown, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_patch.
     * @param result The asynchronous result object for the invocation.
     */
    void end_patch(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_patch(const ::IceGrid::PatcherFeedbackPrx&, const ::std::string&, const ::std::string&, const ::IceGrid::InternalDistributionDescriptorPtr&, bool, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Establish a session to the given replica, this method only
     * returns once the registration was attempted (unlike
     * replicaAdded below).
     * @param context The Context map to send with the invocation.
     */
    void registerWithReplica(const ::IceGrid::InternalRegistryPrx& replica, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_registerWithReplica(_iceI_begin_registerWithReplica(replica, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Establish a session to the given replica, this method only
     * returns once the registration was attempted (unlike
     * replicaAdded below).
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerWithReplica(const ::IceGrid::InternalRegistryPrx& replica, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_registerWithReplica(replica, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Establish a session to the given replica, this method only
     * returns once the registration was attempted (unlike
     * replicaAdded below).
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerWithReplica(const ::IceGrid::InternalRegistryPrx& replica, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerWithReplica(replica, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Establish a session to the given replica, this method only
     * returns once the registration was attempted (unlike
     * replicaAdded below).
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerWithReplica(const ::IceGrid::InternalRegistryPrx& replica, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerWithReplica(replica, context, cb, cookie);
    }

    /**
     * Establish a session to the given replica, this method only
     * returns once the registration was attempted (unlike
     * replicaAdded below).
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerWithReplica(const ::IceGrid::InternalRegistryPrx& replica, const ::IceGrid::Callback_Node_registerWithReplicaPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerWithReplica(replica, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Establish a session to the given replica, this method only
     * returns once the registration was attempted (unlike
     * replicaAdded below).
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerWithReplica(const ::IceGrid::InternalRegistryPrx& replica, const ::Ice::Context& context, const ::IceGrid::Callback_Node_registerWithReplicaPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerWithReplica(replica, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_registerWithReplica.
     * @param result The asynchronous result object for the invocation.
     */
    void end_registerWithReplica(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_registerWithReplica(const ::IceGrid::InternalRegistryPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the node name.
     * @param context The Context map to send with the invocation.
     */
    ::std::string getName(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getName(_iceI_begin_getName(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the node name.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getName(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getName(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the node name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getName(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getName(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the node name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getName(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getName(context, cb, cookie);
    }

    /**
     * Get the node name.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getName(const ::IceGrid::Callback_Node_getNamePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getName(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the node name.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getName(const ::Ice::Context& context, const ::IceGrid::Callback_Node_getNamePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getName(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getName.
     * @param result The asynchronous result object for the invocation.
     */
    ::std::string end_getName(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getName(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the node hostname.
     * @param context The Context map to send with the invocation.
     */
    ::std::string getHostname(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getHostname(_iceI_begin_getHostname(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the node hostname.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getHostname(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getHostname(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the node hostname.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getHostname(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getHostname(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the node hostname.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getHostname(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getHostname(context, cb, cookie);
    }

    /**
     * Get the node hostname.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getHostname(const ::IceGrid::Callback_Node_getHostnamePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getHostname(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the node hostname.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getHostname(const ::Ice::Context& context, const ::IceGrid::Callback_Node_getHostnamePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getHostname(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getHostname.
     * @param result The asynchronous result object for the invocation.
     */
    ::std::string end_getHostname(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getHostname(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the node load.
     * @param context The Context map to send with the invocation.
     */
    ::IceGrid::LoadInfo getLoad(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getLoad(_iceI_begin_getLoad(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the node load.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLoad(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getLoad(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the node load.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLoad(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLoad(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the node load.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLoad(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLoad(context, cb, cookie);
    }

    /**
     * Get the node load.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLoad(const ::IceGrid::Callback_Node_getLoadPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLoad(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the node load.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLoad(const ::Ice::Context& context, const ::IceGrid::Callback_Node_getLoadPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLoad(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getLoad.
     * @param result The asynchronous result object for the invocation.
     */
    ::IceGrid::LoadInfo end_getLoad(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getLoad(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the number of processor sockets for the machine where this
     * node is running.
     * @param context The Context map to send with the invocation.
     */
    ::Ice::Int getProcessorSocketCount(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getProcessorSocketCount(_iceI_begin_getProcessorSocketCount(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the number of processor sockets for the machine where this
     * node is running.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getProcessorSocketCount(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getProcessorSocketCount(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the number of processor sockets for the machine where this
     * node is running.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getProcessorSocketCount(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getProcessorSocketCount(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the number of processor sockets for the machine where this
     * node is running.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getProcessorSocketCount(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getProcessorSocketCount(context, cb, cookie);
    }

    /**
     * Get the number of processor sockets for the machine where this
     * node is running.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getProcessorSocketCount(const ::IceGrid::Callback_Node_getProcessorSocketCountPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getProcessorSocketCount(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the number of processor sockets for the machine where this
     * node is running.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getProcessorSocketCount(const ::Ice::Context& context, const ::IceGrid::Callback_Node_getProcessorSocketCountPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getProcessorSocketCount(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getProcessorSocketCount.
     * @param result The asynchronous result object for the invocation.
     */
    ::Ice::Int end_getProcessorSocketCount(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getProcessorSocketCount(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Shutdown the node.
     * @param context The Context map to send with the invocation.
     */
    void shutdown(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_shutdown(_iceI_begin_shutdown(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Shutdown the node.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_shutdown(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Shutdown the node.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Shutdown the node.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(context, cb, cookie);
    }

    /**
     * Shutdown the node.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdown(const ::IceGrid::Callback_Node_shutdownPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Shutdown the node.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::Context& context, const ::IceGrid::Callback_Node_shutdownPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_shutdown.
     * @param result The asynchronous result object for the invocation.
     */
    void end_shutdown(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_shutdown(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class NodeSession : public virtual ::Ice::Proxy<NodeSession, ::IceProxy::Ice::Object>
{
public:

    /**
     * The node call this method to keep the session alive.
     * @param context The Context map to send with the invocation.
     */
    void keepAlive(const ::IceGrid::LoadInfo& load, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_keepAlive(_iceI_begin_keepAlive(load, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * The node call this method to keep the session alive.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_keepAlive(const ::IceGrid::LoadInfo& load, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_keepAlive(load, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * The node call this method to keep the session alive.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_keepAlive(const ::IceGrid::LoadInfo& load, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(load, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The node call this method to keep the session alive.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_keepAlive(const ::IceGrid::LoadInfo& load, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(load, context, cb, cookie);
    }

    /**
     * The node call this method to keep the session alive.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_keepAlive(const ::IceGrid::LoadInfo& load, const ::IceGrid::Callback_NodeSession_keepAlivePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(load, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The node call this method to keep the session alive.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_keepAlive(const ::IceGrid::LoadInfo& load, const ::Ice::Context& context, const ::IceGrid::Callback_NodeSession_keepAlivePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(load, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_keepAlive.
     * @param result The asynchronous result object for the invocation.
     */
    void end_keepAlive(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_keepAlive(const ::IceGrid::LoadInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Set the replica observer. The node calls this method when it's
     * ready to receive notifications for the replicas. It only calls
     * this for the session with the master.
     * @param context The Context map to send with the invocation.
     */
    void setReplicaObserver(const ::IceGrid::ReplicaObserverPrx& observer, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setReplicaObserver(_iceI_begin_setReplicaObserver(observer, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Set the replica observer. The node calls this method when it's
     * ready to receive notifications for the replicas. It only calls
     * this for the session with the master.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setReplicaObserver(const ::IceGrid::ReplicaObserverPrx& observer, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setReplicaObserver(observer, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Set the replica observer. The node calls this method when it's
     * ready to receive notifications for the replicas. It only calls
     * this for the session with the master.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setReplicaObserver(const ::IceGrid::ReplicaObserverPrx& observer, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setReplicaObserver(observer, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set the replica observer. The node calls this method when it's
     * ready to receive notifications for the replicas. It only calls
     * this for the session with the master.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setReplicaObserver(const ::IceGrid::ReplicaObserverPrx& observer, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setReplicaObserver(observer, context, cb, cookie);
    }

    /**
     * Set the replica observer. The node calls this method when it's
     * ready to receive notifications for the replicas. It only calls
     * this for the session with the master.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setReplicaObserver(const ::IceGrid::ReplicaObserverPrx& observer, const ::IceGrid::Callback_NodeSession_setReplicaObserverPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setReplicaObserver(observer, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set the replica observer. The node calls this method when it's
     * ready to receive notifications for the replicas. It only calls
     * this for the session with the master.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setReplicaObserver(const ::IceGrid::ReplicaObserverPrx& observer, const ::Ice::Context& context, const ::IceGrid::Callback_NodeSession_setReplicaObserverPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setReplicaObserver(observer, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setReplicaObserver.
     * @param result The asynchronous result object for the invocation.
     */
    void end_setReplicaObserver(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_setReplicaObserver(const ::IceGrid::ReplicaObserverPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Return the node session timeout.
     * @param context The Context map to send with the invocation.
     */
    ::Ice::Int getTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getTimeout(_iceI_begin_getTimeout(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Return the node session timeout.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getTimeout(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Return the node session timeout.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTimeout(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTimeout(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return the node session timeout.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTimeout(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTimeout(context, cb, cookie);
    }

    /**
     * Return the node session timeout.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTimeout(const ::IceGrid::Callback_NodeSession_getTimeoutPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTimeout(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return the node session timeout.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTimeout(const ::Ice::Context& context, const ::IceGrid::Callback_NodeSession_getTimeoutPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTimeout(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getTimeout.
     * @param result The asynchronous result object for the invocation.
     */
    ::Ice::Int end_getTimeout(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getTimeout(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Return the node observer.
     * @param context The Context map to send with the invocation.
     */
    ::IceGrid::NodeObserverPrx getObserver(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getObserver(_iceI_begin_getObserver(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Return the node observer.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getObserver(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getObserver(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Return the node observer.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getObserver(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObserver(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return the node observer.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getObserver(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObserver(context, cb, cookie);
    }

    /**
     * Return the node observer.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getObserver(const ::IceGrid::Callback_NodeSession_getObserverPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObserver(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return the node observer.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getObserver(const ::Ice::Context& context, const ::IceGrid::Callback_NodeSession_getObserverPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObserver(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getObserver.
     * @param result The asynchronous result object for the invocation.
     */
    ::IceGrid::NodeObserverPrx end_getObserver(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getObserver(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Ask the registry to load the servers on the node.
     * @param context The Context map to send with the invocation.
     */
    void loadServers(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_loadServers(_iceI_begin_loadServers(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Ask the registry to load the servers on the node.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_loadServers(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_loadServers(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Ask the registry to load the servers on the node.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_loadServers(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_loadServers(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Ask the registry to load the servers on the node.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_loadServers(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_loadServers(context, cb, cookie);
    }

    /**
     * Ask the registry to load the servers on the node.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_loadServers(const ::IceGrid::Callback_NodeSession_loadServersPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_loadServers(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Ask the registry to load the servers on the node.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_loadServers(const ::Ice::Context& context, const ::IceGrid::Callback_NodeSession_loadServersPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_loadServers(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_loadServers.
     * @param result The asynchronous result object for the invocation.
     */
    void end_loadServers(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_loadServers(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get the name of the servers deployed on the node.
     * @param context The Context map to send with the invocation.
     */
    ::Ice::StringSeq getServers(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getServers(_iceI_begin_getServers(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get the name of the servers deployed on the node.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServers(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getServers(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get the name of the servers deployed on the node.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServers(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServers(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the name of the servers deployed on the node.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServers(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServers(context, cb, cookie);
    }

    /**
     * Get the name of the servers deployed on the node.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServers(const ::IceGrid::Callback_NodeSession_getServersPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServers(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get the name of the servers deployed on the node.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getServers(const ::Ice::Context& context, const ::IceGrid::Callback_NodeSession_getServersPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServers(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getServers.
     * @param result The asynchronous result object for the invocation.
     */
    ::Ice::StringSeq end_getServers(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getServers(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Wait for the application update to complete (the application is
     * completely updated once all the registry replicas have been
     * updated). This is used by the node to ensure that before to
     * start a server all the replicas have the up-to-date descriptor
     * of the server.
     * @param context The Context map to send with the invocation.
     */
    void waitForApplicationUpdate(const ::std::string& application, ::Ice::Int revision, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_waitForApplicationUpdate(_iceI_begin_waitForApplicationUpdate(application, revision, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Wait for the application update to complete (the application is
     * completely updated once all the registry replicas have been
     * updated). This is used by the node to ensure that before to
     * start a server all the replicas have the up-to-date descriptor
     * of the server.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_waitForApplicationUpdate(const ::std::string& application, ::Ice::Int revision, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_waitForApplicationUpdate(application, revision, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Wait for the application update to complete (the application is
     * completely updated once all the registry replicas have been
     * updated). This is used by the node to ensure that before to
     * start a server all the replicas have the up-to-date descriptor
     * of the server.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_waitForApplicationUpdate(const ::std::string& application, ::Ice::Int revision, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_waitForApplicationUpdate(application, revision, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Wait for the application update to complete (the application is
     * completely updated once all the registry replicas have been
     * updated). This is used by the node to ensure that before to
     * start a server all the replicas have the up-to-date descriptor
     * of the server.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_waitForApplicationUpdate(const ::std::string& application, ::Ice::Int revision, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_waitForApplicationUpdate(application, revision, context, cb, cookie);
    }

    /**
     * Wait for the application update to complete (the application is
     * completely updated once all the registry replicas have been
     * updated). This is used by the node to ensure that before to
     * start a server all the replicas have the up-to-date descriptor
     * of the server.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_waitForApplicationUpdate(const ::std::string& application, ::Ice::Int revision, const ::IceGrid::Callback_NodeSession_waitForApplicationUpdatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_waitForApplicationUpdate(application, revision, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Wait for the application update to complete (the application is
     * completely updated once all the registry replicas have been
     * updated). This is used by the node to ensure that before to
     * start a server all the replicas have the up-to-date descriptor
     * of the server.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_waitForApplicationUpdate(const ::std::string& application, ::Ice::Int revision, const ::Ice::Context& context, const ::IceGrid::Callback_NodeSession_waitForApplicationUpdatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_waitForApplicationUpdate(application, revision, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_waitForApplicationUpdate.
     * @param result The asynchronous result object for the invocation.
     */
    void end_waitForApplicationUpdate(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_waitForApplicationUpdate(const ::std::string&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Destroy the session.
     * @param context The Context map to send with the invocation.
     */
    void destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_destroy(_iceI_begin_destroy(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Destroy the session.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_destroy(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Destroy the session.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Destroy the session.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(context, cb, cookie);
    }

    /**
     * Destroy the session.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::IceGrid::Callback_NodeSession_destroyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Destroy the session.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context, const ::IceGrid::Callback_NodeSession_destroyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_destroy.
     * @param result The asynchronous result object for the invocation.
     */
    void end_destroy(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_destroy(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

/// \cond INTERNAL
class _DatabaseObserverBase : public virtual ::IceProxy::IceGrid::ApplicationObserver, 
                              public virtual ::IceProxy::IceGrid::ObjectObserver, 
                              public virtual ::IceProxy::IceGrid::AdapterObserver
{
public:

    virtual ~_DatabaseObserverBase();

protected:

    virtual Object* _newInstance() const = 0;
};
/// \endcond

class DatabaseObserver : public virtual ::Ice::Proxy<DatabaseObserver, _DatabaseObserverBase>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class ReplicaSession : public virtual ::Ice::Proxy<ReplicaSession, ::IceProxy::Ice::Object>
{
public:

    /**
     * The replica call this method to keep the session alive.
     * @param context The Context map to send with the invocation.
     */
    void keepAlive(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_keepAlive(_iceI_begin_keepAlive(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * The replica call this method to keep the session alive.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_keepAlive(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_keepAlive(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * The replica call this method to keep the session alive.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_keepAlive(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The replica call this method to keep the session alive.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_keepAlive(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(context, cb, cookie);
    }

    /**
     * The replica call this method to keep the session alive.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_keepAlive(const ::IceGrid::Callback_ReplicaSession_keepAlivePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * The replica call this method to keep the session alive.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_keepAlive(const ::Ice::Context& context, const ::IceGrid::Callback_ReplicaSession_keepAlivePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_keepAlive.
     * @param result The asynchronous result object for the invocation.
     */
    void end_keepAlive(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_keepAlive(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Return the replica session timeout.
     * @param context The Context map to send with the invocation.
     */
    ::Ice::Int getTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getTimeout(_iceI_begin_getTimeout(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Return the replica session timeout.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getTimeout(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Return the replica session timeout.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTimeout(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTimeout(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return the replica session timeout.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTimeout(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTimeout(context, cb, cookie);
    }

    /**
     * Return the replica session timeout.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTimeout(const ::IceGrid::Callback_ReplicaSession_getTimeoutPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTimeout(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return the replica session timeout.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getTimeout(const ::Ice::Context& context, const ::IceGrid::Callback_ReplicaSession_getTimeoutPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getTimeout(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getTimeout.
     * @param result The asynchronous result object for the invocation.
     */
    ::Ice::Int end_getTimeout(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getTimeout(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Set the database observer. Once the observer is subscribed, it
     * will receive the database and database updates.
     * @param context The Context map to send with the invocation.
     */
    void setDatabaseObserver(const ::IceGrid::DatabaseObserverPrx& dbObs, const IceUtil::Optional< ::IceGrid::StringLongDict>& serials, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setDatabaseObserver(_iceI_begin_setDatabaseObserver(dbObs, serials, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Set the database observer. Once the observer is subscribed, it
     * will receive the database and database updates.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setDatabaseObserver(const ::IceGrid::DatabaseObserverPrx& dbObs, const IceUtil::Optional< ::IceGrid::StringLongDict>& serials, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setDatabaseObserver(dbObs, serials, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Set the database observer. Once the observer is subscribed, it
     * will receive the database and database updates.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setDatabaseObserver(const ::IceGrid::DatabaseObserverPrx& dbObs, const IceUtil::Optional< ::IceGrid::StringLongDict>& serials, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setDatabaseObserver(dbObs, serials, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set the database observer. Once the observer is subscribed, it
     * will receive the database and database updates.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setDatabaseObserver(const ::IceGrid::DatabaseObserverPrx& dbObs, const IceUtil::Optional< ::IceGrid::StringLongDict>& serials, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setDatabaseObserver(dbObs, serials, context, cb, cookie);
    }

    /**
     * Set the database observer. Once the observer is subscribed, it
     * will receive the database and database updates.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setDatabaseObserver(const ::IceGrid::DatabaseObserverPrx& dbObs, const IceUtil::Optional< ::IceGrid::StringLongDict>& serials, const ::IceGrid::Callback_ReplicaSession_setDatabaseObserverPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setDatabaseObserver(dbObs, serials, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set the database observer. Once the observer is subscribed, it
     * will receive the database and database updates.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setDatabaseObserver(const ::IceGrid::DatabaseObserverPrx& dbObs, const IceUtil::Optional< ::IceGrid::StringLongDict>& serials, const ::Ice::Context& context, const ::IceGrid::Callback_ReplicaSession_setDatabaseObserverPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setDatabaseObserver(dbObs, serials, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setDatabaseObserver.
     * @param result The asynchronous result object for the invocation.
     */
    void end_setDatabaseObserver(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_setDatabaseObserver(const ::IceGrid::DatabaseObserverPrx&, const IceUtil::Optional< ::IceGrid::StringLongDict>&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * This method sets the endpoints of the replica. This allows the
     * master to create proxies with multiple endpoints for replicated
     * objects (e.g.: IceGrid::Query object).
     * @param context The Context map to send with the invocation.
     */
    void setEndpoints(const ::IceGrid::StringObjectProxyDict& endpoints, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setEndpoints(_iceI_begin_setEndpoints(endpoints, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * This method sets the endpoints of the replica. This allows the
     * master to create proxies with multiple endpoints for replicated
     * objects (e.g.: IceGrid::Query object).
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setEndpoints(const ::IceGrid::StringObjectProxyDict& endpoints, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setEndpoints(endpoints, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * This method sets the endpoints of the replica. This allows the
     * master to create proxies with multiple endpoints for replicated
     * objects (e.g.: IceGrid::Query object).
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setEndpoints(const ::IceGrid::StringObjectProxyDict& endpoints, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setEndpoints(endpoints, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * This method sets the endpoints of the replica. This allows the
     * master to create proxies with multiple endpoints for replicated
     * objects (e.g.: IceGrid::Query object).
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setEndpoints(const ::IceGrid::StringObjectProxyDict& endpoints, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setEndpoints(endpoints, context, cb, cookie);
    }

    /**
     * This method sets the endpoints of the replica. This allows the
     * master to create proxies with multiple endpoints for replicated
     * objects (e.g.: IceGrid::Query object).
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setEndpoints(const ::IceGrid::StringObjectProxyDict& endpoints, const ::IceGrid::Callback_ReplicaSession_setEndpointsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setEndpoints(endpoints, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * This method sets the endpoints of the replica. This allows the
     * master to create proxies with multiple endpoints for replicated
     * objects (e.g.: IceGrid::Query object).
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setEndpoints(const ::IceGrid::StringObjectProxyDict& endpoints, const ::Ice::Context& context, const ::IceGrid::Callback_ReplicaSession_setEndpointsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setEndpoints(endpoints, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setEndpoints.
     * @param result The asynchronous result object for the invocation.
     */
    void end_setEndpoints(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_setEndpoints(const ::IceGrid::StringObjectProxyDict&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Registers the replica well-known objects with the master.
     * @param context The Context map to send with the invocation.
     */
    void registerWellKnownObjects(const ::IceGrid::ObjectInfoSeq& objects, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_registerWellKnownObjects(_iceI_begin_registerWellKnownObjects(objects, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Registers the replica well-known objects with the master.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerWellKnownObjects(const ::IceGrid::ObjectInfoSeq& objects, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_registerWellKnownObjects(objects, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Registers the replica well-known objects with the master.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerWellKnownObjects(const ::IceGrid::ObjectInfoSeq& objects, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerWellKnownObjects(objects, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Registers the replica well-known objects with the master.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerWellKnownObjects(const ::IceGrid::ObjectInfoSeq& objects, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerWellKnownObjects(objects, context, cb, cookie);
    }

    /**
     * Registers the replica well-known objects with the master.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerWellKnownObjects(const ::IceGrid::ObjectInfoSeq& objects, const ::IceGrid::Callback_ReplicaSession_registerWellKnownObjectsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerWellKnownObjects(objects, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Registers the replica well-known objects with the master.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerWellKnownObjects(const ::IceGrid::ObjectInfoSeq& objects, const ::Ice::Context& context, const ::IceGrid::Callback_ReplicaSession_registerWellKnownObjectsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerWellKnownObjects(objects, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_registerWellKnownObjects.
     * @param result The asynchronous result object for the invocation.
     */
    void end_registerWellKnownObjects(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_registerWellKnownObjects(const ::IceGrid::ObjectInfoSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Set the adapter direct proxy of the given adapter in the
     * master. This is used to support dynamic registration with
     * the locator registry interface.
     * @param context The Context map to send with the invocation.
     */
    void setAdapterDirectProxy(const ::std::string& adapterId, const ::std::string& replicaGroupId, const ::Ice::ObjectPrx& proxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setAdapterDirectProxy(_iceI_begin_setAdapterDirectProxy(adapterId, replicaGroupId, proxy, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Set the adapter direct proxy of the given adapter in the
     * master. This is used to support dynamic registration with
     * the locator registry interface.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setAdapterDirectProxy(const ::std::string& adapterId, const ::std::string& replicaGroupId, const ::Ice::ObjectPrx& proxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setAdapterDirectProxy(adapterId, replicaGroupId, proxy, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Set the adapter direct proxy of the given adapter in the
     * master. This is used to support dynamic registration with
     * the locator registry interface.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setAdapterDirectProxy(const ::std::string& adapterId, const ::std::string& replicaGroupId, const ::Ice::ObjectPrx& proxy, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAdapterDirectProxy(adapterId, replicaGroupId, proxy, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set the adapter direct proxy of the given adapter in the
     * master. This is used to support dynamic registration with
     * the locator registry interface.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setAdapterDirectProxy(const ::std::string& adapterId, const ::std::string& replicaGroupId, const ::Ice::ObjectPrx& proxy, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAdapterDirectProxy(adapterId, replicaGroupId, proxy, context, cb, cookie);
    }

    /**
     * Set the adapter direct proxy of the given adapter in the
     * master. This is used to support dynamic registration with
     * the locator registry interface.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setAdapterDirectProxy(const ::std::string& adapterId, const ::std::string& replicaGroupId, const ::Ice::ObjectPrx& proxy, const ::IceGrid::Callback_ReplicaSession_setAdapterDirectProxyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAdapterDirectProxy(adapterId, replicaGroupId, proxy, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set the adapter direct proxy of the given adapter in the
     * master. This is used to support dynamic registration with
     * the locator registry interface.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setAdapterDirectProxy(const ::std::string& adapterId, const ::std::string& replicaGroupId, const ::Ice::ObjectPrx& proxy, const ::Ice::Context& context, const ::IceGrid::Callback_ReplicaSession_setAdapterDirectProxyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAdapterDirectProxy(adapterId, replicaGroupId, proxy, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setAdapterDirectProxy.
     * @param result The asynchronous result object for the invocation.
     */
    void end_setAdapterDirectProxy(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_setAdapterDirectProxy(const ::std::string&, const ::std::string&, const ::Ice::ObjectPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Notify the master that an update was received. The master might
     * wait for replication updates to be received by all the replicas
     * before to continue.
     * @param context The Context map to send with the invocation.
     */
    void receivedUpdate(::IceGrid::TopicName name, ::Ice::Int serial, const ::std::string& failure, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_receivedUpdate(_iceI_begin_receivedUpdate(name, serial, failure, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Notify the master that an update was received. The master might
     * wait for replication updates to be received by all the replicas
     * before to continue.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_receivedUpdate(::IceGrid::TopicName name, ::Ice::Int serial, const ::std::string& failure, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_receivedUpdate(name, serial, failure, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Notify the master that an update was received. The master might
     * wait for replication updates to be received by all the replicas
     * before to continue.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_receivedUpdate(::IceGrid::TopicName name, ::Ice::Int serial, const ::std::string& failure, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_receivedUpdate(name, serial, failure, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Notify the master that an update was received. The master might
     * wait for replication updates to be received by all the replicas
     * before to continue.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_receivedUpdate(::IceGrid::TopicName name, ::Ice::Int serial, const ::std::string& failure, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_receivedUpdate(name, serial, failure, context, cb, cookie);
    }

    /**
     * Notify the master that an update was received. The master might
     * wait for replication updates to be received by all the replicas
     * before to continue.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_receivedUpdate(::IceGrid::TopicName name, ::Ice::Int serial, const ::std::string& failure, const ::IceGrid::Callback_ReplicaSession_receivedUpdatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_receivedUpdate(name, serial, failure, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Notify the master that an update was received. The master might
     * wait for replication updates to be received by all the replicas
     * before to continue.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_receivedUpdate(::IceGrid::TopicName name, ::Ice::Int serial, const ::std::string& failure, const ::Ice::Context& context, const ::IceGrid::Callback_ReplicaSession_receivedUpdatePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_receivedUpdate(name, serial, failure, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_receivedUpdate.
     * @param result The asynchronous result object for the invocation.
     */
    void end_receivedUpdate(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_receivedUpdate(::IceGrid::TopicName, ::Ice::Int, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Destroy the session.
     * @param context The Context map to send with the invocation.
     */
    void destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_destroy(_iceI_begin_destroy(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Destroy the session.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_destroy(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Destroy the session.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Destroy the session.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(context, cb, cookie);
    }

    /**
     * Destroy the session.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::IceGrid::Callback_ReplicaSession_destroyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Destroy the session.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context, const ::IceGrid::Callback_ReplicaSession_destroyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_destroy.
     * @param result The asynchronous result object for the invocation.
     */
    void end_destroy(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_destroy(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class InternalNodeInfo : public virtual ::Ice::Proxy<InternalNodeInfo, ::IceProxy::Ice::Object>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class InternalReplicaInfo : public virtual ::Ice::Proxy<InternalReplicaInfo, ::IceProxy::Ice::Object>
{
public:

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class InternalRegistry : public virtual ::Ice::Proxy<InternalRegistry, ::IceProxy::IceGrid::FileReader>
{
public:

    /**
     * Register a node with the registry. If a node with the same name
     * is already registered, [registerNode] will overide the previous
     * node only if it's not active.
     * @param info Some information on the node.
     * @param prx The proxy of the node.
     * @param loadInf The load information of the node.
     * @param context The Context map to send with the invocation.
     * @return The node session proxy.
     * @throws IceGrid::NodeActiveException Raised if the node is already
     * registered and currently active.
     */
    ::IceGrid::NodeSessionPrx registerNode(const ::IceGrid::InternalNodeInfoPtr& info, const ::IceGrid::NodePrx& prx, const ::IceGrid::LoadInfo& loadInf, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_registerNode(_iceI_begin_registerNode(info, prx, loadInf, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Register a node with the registry. If a node with the same name
     * is already registered, [registerNode] will overide the previous
     * node only if it's not active.
     * @param info Some information on the node.
     * @param prx The proxy of the node.
     * @param loadInf The load information of the node.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerNode(const ::IceGrid::InternalNodeInfoPtr& info, const ::IceGrid::NodePrx& prx, const ::IceGrid::LoadInfo& loadInf, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_registerNode(info, prx, loadInf, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Register a node with the registry. If a node with the same name
     * is already registered, [registerNode] will overide the previous
     * node only if it's not active.
     * @param info Some information on the node.
     * @param prx The proxy of the node.
     * @param loadInf The load information of the node.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerNode(const ::IceGrid::InternalNodeInfoPtr& info, const ::IceGrid::NodePrx& prx, const ::IceGrid::LoadInfo& loadInf, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerNode(info, prx, loadInf, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Register a node with the registry. If a node with the same name
     * is already registered, [registerNode] will overide the previous
     * node only if it's not active.
     * @param info Some information on the node.
     * @param prx The proxy of the node.
     * @param loadInf The load information of the node.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerNode(const ::IceGrid::InternalNodeInfoPtr& info, const ::IceGrid::NodePrx& prx, const ::IceGrid::LoadInfo& loadInf, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerNode(info, prx, loadInf, context, cb, cookie);
    }

    /**
     * Register a node with the registry. If a node with the same name
     * is already registered, [registerNode] will overide the previous
     * node only if it's not active.
     * @param info Some information on the node.
     * @param prx The proxy of the node.
     * @param loadInf The load information of the node.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerNode(const ::IceGrid::InternalNodeInfoPtr& info, const ::IceGrid::NodePrx& prx, const ::IceGrid::LoadInfo& loadInf, const ::IceGrid::Callback_InternalRegistry_registerNodePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerNode(info, prx, loadInf, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Register a node with the registry. If a node with the same name
     * is already registered, [registerNode] will overide the previous
     * node only if it's not active.
     * @param info Some information on the node.
     * @param prx The proxy of the node.
     * @param loadInf The load information of the node.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerNode(const ::IceGrid::InternalNodeInfoPtr& info, const ::IceGrid::NodePrx& prx, const ::IceGrid::LoadInfo& loadInf, const ::Ice::Context& context, const ::IceGrid::Callback_InternalRegistry_registerNodePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerNode(info, prx, loadInf, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_registerNode.
     * @param result The asynchronous result object for the invocation.
     * @return The node session proxy.
     * @throws IceGrid::NodeActiveException Raised if the node is already
     * registered and currently active.
     */
    ::IceGrid::NodeSessionPrx end_registerNode(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_registerNode(const ::IceGrid::InternalNodeInfoPtr&, const ::IceGrid::NodePrx&, const ::IceGrid::LoadInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Register a replica with the registry. If a replica with the
     * same name is already registered, [registerReplica] will overide
     * the previous replica only if it's not active.
     * @param info Some information on the replica.
     * @param prx The proxy of the replica.
     * @param context The Context map to send with the invocation.
     * @return The replica session proxy.
     * @throws IceGrid::ReplicaActiveException Raised if the replica is already
     * registered and currently active.
     */
    ::IceGrid::ReplicaSessionPrx registerReplica(const ::IceGrid::InternalReplicaInfoPtr& info, const ::IceGrid::InternalRegistryPrx& prx, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_registerReplica(_iceI_begin_registerReplica(info, prx, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Register a replica with the registry. If a replica with the
     * same name is already registered, [registerReplica] will overide
     * the previous replica only if it's not active.
     * @param info Some information on the replica.
     * @param prx The proxy of the replica.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerReplica(const ::IceGrid::InternalReplicaInfoPtr& info, const ::IceGrid::InternalRegistryPrx& prx, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_registerReplica(info, prx, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Register a replica with the registry. If a replica with the
     * same name is already registered, [registerReplica] will overide
     * the previous replica only if it's not active.
     * @param info Some information on the replica.
     * @param prx The proxy of the replica.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerReplica(const ::IceGrid::InternalReplicaInfoPtr& info, const ::IceGrid::InternalRegistryPrx& prx, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerReplica(info, prx, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Register a replica with the registry. If a replica with the
     * same name is already registered, [registerReplica] will overide
     * the previous replica only if it's not active.
     * @param info Some information on the replica.
     * @param prx The proxy of the replica.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerReplica(const ::IceGrid::InternalReplicaInfoPtr& info, const ::IceGrid::InternalRegistryPrx& prx, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerReplica(info, prx, context, cb, cookie);
    }

    /**
     * Register a replica with the registry. If a replica with the
     * same name is already registered, [registerReplica] will overide
     * the previous replica only if it's not active.
     * @param info Some information on the replica.
     * @param prx The proxy of the replica.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerReplica(const ::IceGrid::InternalReplicaInfoPtr& info, const ::IceGrid::InternalRegistryPrx& prx, const ::IceGrid::Callback_InternalRegistry_registerReplicaPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerReplica(info, prx, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Register a replica with the registry. If a replica with the
     * same name is already registered, [registerReplica] will overide
     * the previous replica only if it's not active.
     * @param info Some information on the replica.
     * @param prx The proxy of the replica.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerReplica(const ::IceGrid::InternalReplicaInfoPtr& info, const ::IceGrid::InternalRegistryPrx& prx, const ::Ice::Context& context, const ::IceGrid::Callback_InternalRegistry_registerReplicaPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerReplica(info, prx, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_registerReplica.
     * @param result The asynchronous result object for the invocation.
     * @return The replica session proxy.
     * @throws IceGrid::ReplicaActiveException Raised if the replica is already
     * registered and currently active.
     */
    ::IceGrid::ReplicaSessionPrx end_registerReplica(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_registerReplica(const ::IceGrid::InternalReplicaInfoPtr&, const ::IceGrid::InternalRegistryPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Create a session with the given registry replica. This method
     * returns only once the session creation has been attempted.
     * @param context The Context map to send with the invocation.
     */
    void registerWithReplica(const ::IceGrid::InternalRegistryPrx& prx, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_registerWithReplica(_iceI_begin_registerWithReplica(prx, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Create a session with the given registry replica. This method
     * returns only once the session creation has been attempted.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerWithReplica(const ::IceGrid::InternalRegistryPrx& prx, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_registerWithReplica(prx, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Create a session with the given registry replica. This method
     * returns only once the session creation has been attempted.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerWithReplica(const ::IceGrid::InternalRegistryPrx& prx, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerWithReplica(prx, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create a session with the given registry replica. This method
     * returns only once the session creation has been attempted.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerWithReplica(const ::IceGrid::InternalRegistryPrx& prx, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerWithReplica(prx, context, cb, cookie);
    }

    /**
     * Create a session with the given registry replica. This method
     * returns only once the session creation has been attempted.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerWithReplica(const ::IceGrid::InternalRegistryPrx& prx, const ::IceGrid::Callback_InternalRegistry_registerWithReplicaPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerWithReplica(prx, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Create a session with the given registry replica. This method
     * returns only once the session creation has been attempted.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_registerWithReplica(const ::IceGrid::InternalRegistryPrx& prx, const ::Ice::Context& context, const ::IceGrid::Callback_InternalRegistry_registerWithReplicaPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registerWithReplica(prx, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_registerWithReplica.
     * @param result The asynchronous result object for the invocation.
     */
    void end_registerWithReplica(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_registerWithReplica(const ::IceGrid::InternalRegistryPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Return the proxies of all the nodes known by this registry.
     * @param context The Context map to send with the invocation.
     */
    ::IceGrid::NodePrxSeq getNodes(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getNodes(_iceI_begin_getNodes(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Return the proxies of all the nodes known by this registry.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodes(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getNodes(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Return the proxies of all the nodes known by this registry.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodes(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodes(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return the proxies of all the nodes known by this registry.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodes(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodes(context, cb, cookie);
    }

    /**
     * Return the proxies of all the nodes known by this registry.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodes(const ::IceGrid::Callback_InternalRegistry_getNodesPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodes(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return the proxies of all the nodes known by this registry.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getNodes(const ::Ice::Context& context, const ::IceGrid::Callback_InternalRegistry_getNodesPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodes(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getNodes.
     * @param result The asynchronous result object for the invocation.
     */
    ::IceGrid::NodePrxSeq end_getNodes(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getNodes(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Return the proxies of all the registry replicas known by this
     * registry.
     * @param context The Context map to send with the invocation.
     */
    ::IceGrid::InternalRegistryPrxSeq getReplicas(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getReplicas(_iceI_begin_getReplicas(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Return the proxies of all the registry replicas known by this
     * registry.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getReplicas(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getReplicas(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Return the proxies of all the registry replicas known by this
     * registry.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getReplicas(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getReplicas(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return the proxies of all the registry replicas known by this
     * registry.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getReplicas(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getReplicas(context, cb, cookie);
    }

    /**
     * Return the proxies of all the registry replicas known by this
     * registry.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getReplicas(const ::IceGrid::Callback_InternalRegistry_getReplicasPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getReplicas(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return the proxies of all the registry replicas known by this
     * registry.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getReplicas(const ::Ice::Context& context, const ::IceGrid::Callback_InternalRegistry_getReplicasPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getReplicas(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getReplicas.
     * @param result The asynchronous result object for the invocation.
     */
    ::IceGrid::InternalRegistryPrxSeq end_getReplicas(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getReplicas(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Return applications, adapters, objects from this replica.
     * @param context The Context map to send with the invocation.
     */
    ::IceGrid::ApplicationInfoSeq getApplications(::Ice::Long& serial, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getApplications(serial, _iceI_begin_getApplications(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Return applications, adapters, objects from this replica.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getApplications(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getApplications(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Return applications, adapters, objects from this replica.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getApplications(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getApplications(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return applications, adapters, objects from this replica.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getApplications(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getApplications(context, cb, cookie);
    }

    /**
     * Return applications, adapters, objects from this replica.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getApplications(const ::IceGrid::Callback_InternalRegistry_getApplicationsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getApplications(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return applications, adapters, objects from this replica.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getApplications(const ::Ice::Context& context, const ::IceGrid::Callback_InternalRegistry_getApplicationsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getApplications(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getApplications.
     * @param result The asynchronous result object for the invocation.
     */
    ::IceGrid::ApplicationInfoSeq end_getApplications(::Ice::Long& serial, const ::Ice::AsyncResultPtr& result);
    /// \cond INTERNAL

    void _iceI_end_getApplications(::Ice::Long& iceP_serial, ::IceGrid::ApplicationInfoSeq& ret, const ::Ice::AsyncResultPtr&);
    /// \endcond

private:

    ::Ice::AsyncResultPtr _iceI_begin_getApplications(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ::IceGrid::AdapterInfoSeq getAdapters(::Ice::Long& serial, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getAdapters(serial, _iceI_begin_getAdapters(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getAdapters(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getAdapters(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getAdapters(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdapters(::Ice::noExplicitContext, cb, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAdapters(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdapters(context, cb, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAdapters(const ::IceGrid::Callback_InternalRegistry_getAdaptersPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdapters(::Ice::noExplicitContext, cb, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAdapters(const ::Ice::Context& context, const ::IceGrid::Callback_InternalRegistry_getAdaptersPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdapters(context, cb, cookie);
    }

    ::IceGrid::AdapterInfoSeq end_getAdapters(::Ice::Long& serial, const ::Ice::AsyncResultPtr& result);
    /// \cond INTERNAL

    void _iceI_end_getAdapters(::Ice::Long& iceP_serial, ::IceGrid::AdapterInfoSeq& ret, const ::Ice::AsyncResultPtr&);
    /// \endcond

private:

    ::Ice::AsyncResultPtr _iceI_begin_getAdapters(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ::IceGrid::ObjectInfoSeq getObjects(::Ice::Long& serial, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getObjects(serial, _iceI_begin_getObjects(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getObjects(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getObjects(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getObjects(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObjects(::Ice::noExplicitContext, cb, cookie);
    }

    ::Ice::AsyncResultPtr begin_getObjects(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObjects(context, cb, cookie);
    }

    ::Ice::AsyncResultPtr begin_getObjects(const ::IceGrid::Callback_InternalRegistry_getObjectsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObjects(::Ice::noExplicitContext, cb, cookie);
    }

    ::Ice::AsyncResultPtr begin_getObjects(const ::Ice::Context& context, const ::IceGrid::Callback_InternalRegistry_getObjectsPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObjects(context, cb, cookie);
    }

    ::IceGrid::ObjectInfoSeq end_getObjects(::Ice::Long& serial, const ::Ice::AsyncResultPtr& result);
    /// \cond INTERNAL

    void _iceI_end_getObjects(::Ice::Long& iceP_serial, ::IceGrid::ObjectInfoSeq& ret, const ::Ice::AsyncResultPtr&);
    /// \endcond

private:

    ::Ice::AsyncResultPtr _iceI_begin_getObjects(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Shutdown this registry.
     * @param context The Context map to send with the invocation.
     */
    void shutdown(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_shutdown(_iceI_begin_shutdown(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Shutdown this registry.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_shutdown(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Shutdown this registry.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Shutdown this registry.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(context, cb, cookie);
    }

    /**
     * Shutdown this registry.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdown(const ::IceGrid::Callback_InternalRegistry_shutdownPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Shutdown this registry.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::Context& context, const ::IceGrid::Callback_InternalRegistry_shutdownPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_shutdown.
     * @param result The asynchronous result object for the invocation.
     */
    void end_shutdown(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_shutdown(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

}

}

namespace IceGrid
{

class InternalDbEnvDescriptor : public virtual ::Ice::Object
{
public:

    typedef InternalDbEnvDescriptorPrx ProxyType;
    typedef InternalDbEnvDescriptorPtr PointerType;

    virtual ~InternalDbEnvDescriptor();

    InternalDbEnvDescriptor()
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param name The name of the database environment.
     * @param properties The database properties.
     */
    InternalDbEnvDescriptor(const ::std::string& name, const ::IceGrid::PropertyDescriptorSeq& properties) :
        name(name),
        properties(properties)
    {
    }

#ifdef ICE_CPP11_COMPILER
    InternalDbEnvDescriptor(const InternalDbEnvDescriptor&) = default;
    InternalDbEnvDescriptor& operator=(const InternalDbEnvDescriptor&) = default;
#endif

    /**
     * Polymorphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond

public:

    /**
     * The name of the database environment.
     */
    ::std::string name;
    /**
     * The database properties.
     */
    ::IceGrid::PropertyDescriptorSeq properties;
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_InternalDbEnvDescriptor_init = ::IceGrid::InternalDbEnvDescriptor::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const InternalDbEnvDescriptor& lhs, const InternalDbEnvDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const InternalDbEnvDescriptor& lhs, const InternalDbEnvDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

class InternalAdapterDescriptor : public virtual ::Ice::Object
{
public:

    typedef InternalAdapterDescriptorPrx ProxyType;
    typedef InternalAdapterDescriptorPtr PointerType;

    virtual ~InternalAdapterDescriptor();

    InternalAdapterDescriptor()
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param id The identifier of the server.
     * @param serverLifetime Specifies if the lifetime of the adapter is the same as the server.
     */
    InternalAdapterDescriptor(const ::std::string& id, bool serverLifetime) :
        id(id),
        serverLifetime(serverLifetime)
    {
    }

#ifdef ICE_CPP11_COMPILER
    InternalAdapterDescriptor(const InternalAdapterDescriptor&) = default;
    InternalAdapterDescriptor& operator=(const InternalAdapterDescriptor&) = default;
#endif

    /**
     * Polymorphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond

public:

    /**
     * The identifier of the server.
     */
    ::std::string id;
    /**
     * Specifies if the lifetime of the adapter is the same as the server.
     */
    bool serverLifetime;
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_InternalAdapterDescriptor_init = ::IceGrid::InternalAdapterDescriptor::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const InternalAdapterDescriptor& lhs, const InternalAdapterDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const InternalAdapterDescriptor& lhs, const InternalAdapterDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

class InternalDistributionDescriptor : public virtual ::Ice::Object
{
public:

    typedef InternalDistributionDescriptorPrx ProxyType;
    typedef InternalDistributionDescriptorPtr PointerType;

    virtual ~InternalDistributionDescriptor();

    InternalDistributionDescriptor()
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param icepatch The proxy of the IcePatch2 server.
     * @param directories The source directories.
     */
    InternalDistributionDescriptor(const ::std::string& icepatch, const ::Ice::StringSeq& directories) :
        icepatch(icepatch),
        directories(directories)
    {
    }

#ifdef ICE_CPP11_COMPILER
    InternalDistributionDescriptor(const InternalDistributionDescriptor&) = default;
    InternalDistributionDescriptor& operator=(const InternalDistributionDescriptor&) = default;
#endif

    /**
     * Polymorphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond

public:

    /**
     * The proxy of the IcePatch2 server.
     */
    ::std::string icepatch;
    /**
     * The source directories.
     */
    ::Ice::StringSeq directories;
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_InternalDistributionDescriptor_init = ::IceGrid::InternalDistributionDescriptor::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const InternalDistributionDescriptor& lhs, const InternalDistributionDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const InternalDistributionDescriptor& lhs, const InternalDistributionDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

class InternalServerDescriptor : public virtual ::Ice::Object, public ::IceInternal::GCObject
{
public:

    typedef InternalServerDescriptorPrx ProxyType;
    typedef InternalServerDescriptorPtr PointerType;

    virtual ~InternalServerDescriptor();

    InternalServerDescriptor()
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param id The server ID.
     * @param application The server application
     * @param uuid The application uuid.
     * @param revision The application revision.
     * @param sessionId The id of the session which allocated the server.
     * @param exe The server executable.
     * @param pwd The server working directory.
     * @param user The user ID to use to run the server.
     * @param activation The server activation mode.
     * @param activationTimeout The server activation timeout.
     * @param deactivationTimeout The server deactivation timeout.
     * @param applicationDistrib Specifies if the server depends on the application distrib.
     * @param distrib The distribution descriptor of this server.
     * @param processRegistered Specifies if a process object is registered.
     * @param options The server command line options.
     * @param envs The server environment variables.
     * @param logs The path of the server logs.
     * @param adapters The indirect object adapters.
     * @param dbEnvs The database environments.
     * @param properties The configuration files of the server.
     * @param services IceBox service names
     */
    InternalServerDescriptor(const ::std::string& id, const ::std::string& application, const ::std::string& uuid, ::Ice::Int revision, const ::std::string& sessionId, const ::std::string& exe, const ::std::string& pwd, const ::std::string& user, const ::std::string& activation, const ::std::string& activationTimeout, const ::std::string& deactivationTimeout, bool applicationDistrib, const ::IceGrid::InternalDistributionDescriptorPtr& distrib, bool processRegistered, const ::Ice::StringSeq& options, const ::Ice::StringSeq& envs, const ::Ice::StringSeq& logs, const ::IceGrid::InternalAdapterDescriptorSeq& adapters, const ::IceGrid::InternalDbEnvDescriptorSeq& dbEnvs, const ::IceGrid::PropertyDescriptorSeqDict& properties, const IceUtil::Optional< ::Ice::StringSeq>& services) :
        id(id),
        application(application),
        uuid(uuid),
        revision(revision),
        sessionId(sessionId),
        exe(exe),
        pwd(pwd),
        user(user),
        activation(activation),
        activationTimeout(activationTimeout),
        deactivationTimeout(deactivationTimeout),
        applicationDistrib(applicationDistrib),
        distrib(distrib),
        processRegistered(processRegistered),
        options(options),
        envs(envs),
        logs(logs),
        adapters(adapters),
        dbEnvs(dbEnvs),
        properties(properties),
        services(services)
    {
    }

#ifdef ICE_CPP11_COMPILER
    InternalServerDescriptor(const InternalServerDescriptor&) = default;
    InternalServerDescriptor& operator=(const InternalServerDescriptor&) = default;
#endif

    /**
     * Polymorphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();
    /// \cond INTERNAL
    virtual void _iceGcVisitMembers(::IceInternal::GCVisitor&);
    /// \endcond

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond

public:

    /**
     * The server ID.
     */
    ::std::string id;
    /**
     * The server application
     */
    ::std::string application;
    /**
     * The application uuid.
     */
    ::std::string uuid;
    /**
     * The application revision.
     */
    ::Ice::Int revision;
    /**
     * The id of the session which allocated the server.
     */
    ::std::string sessionId;
    /**
     * The server executable.
     */
    ::std::string exe;
    /**
     * The server working directory.
     */
    ::std::string pwd;
    /**
     * The user ID to use to run the server.
     */
    ::std::string user;
    /**
     * The server activation mode.
     */
    ::std::string activation;
    /**
     * The server activation timeout.
     */
    ::std::string activationTimeout;
    /**
     * The server deactivation timeout.
     */
    ::std::string deactivationTimeout;
    /**
     * Specifies if the server depends on the application distrib.
     */
    bool applicationDistrib;
    /**
     * The distribution descriptor of this server.
     */
    ::IceGrid::InternalDistributionDescriptorPtr distrib;
    /**
     * Specifies if a process object is registered.
     */
    bool processRegistered;
    /**
     * The server command line options.
     */
    ::Ice::StringSeq options;
    /**
     * The server environment variables.
     */
    ::Ice::StringSeq envs;
    /**
     * The path of the server logs.
     */
    ::Ice::StringSeq logs;
    /**
     * The indirect object adapters.
     */
    ::IceGrid::InternalAdapterDescriptorSeq adapters;
    /**
     * The database environments.
     */
    ::IceGrid::InternalDbEnvDescriptorSeq dbEnvs;
    /**
     * The configuration files of the server.
     */
    ::IceGrid::PropertyDescriptorSeqDict properties;
    /**
     * IceBox service names
     */
    IceUtil::Optional< ::Ice::StringSeq> services;
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_InternalServerDescriptor_init = ::IceGrid::InternalServerDescriptor::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const InternalServerDescriptor& lhs, const InternalServerDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const InternalServerDescriptor& lhs, const InternalServerDescriptor& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

class Adapter : public virtual ::Ice::Object
{
public:

    typedef AdapterPrx ProxyType;
    typedef AdapterPtr PointerType;

    virtual ~Adapter();

#ifdef ICE_CPP11_COMPILER
    Adapter() = default;
    Adapter(const Adapter&) = default;
    Adapter& operator=(const Adapter&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Activate this adapter. If this adapter can be activated, this
     * will activate the adapter and return the direct proxy of the
     * adapter once it's active. If this adapter can be activated on
     * demand, this will return 0 if the adapter is inactive or the
     * adapter direct proxy it's active.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void activate_async(const ::IceGrid::AMD_Adapter_activatePtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_activate(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get the adapter direct proxy. The adapter direct proxy is a
     * proxy created with the object adapter. The proxy contains the
     * last known adapter endpoints.
     * @param current The Current object for the invocation.
     * @return A direct proxy containing the last known adapter
     * endpoints if the adapter is already active.
     */
    virtual ::Ice::ObjectPrx getDirectProxy(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getDirectProxy(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Set the direct proxy for this adapter.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AdapterActiveException The adapter is already
     * active. It's not possible to override the direct proxy of an
     * active adapter.
     */
    virtual void setDirectProxy(const ::Ice::ObjectPrx& proxy, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setDirectProxy(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const Adapter& lhs, const Adapter& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Adapter& lhs, const Adapter& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

class FileReader : public virtual ::Ice::Object
{
public:

    typedef FileReaderPrx ProxyType;
    typedef FileReaderPtr PointerType;

    virtual ~FileReader();

#ifdef ICE_CPP11_COMPILER
    FileReader() = default;
    FileReader(const FileReader&) = default;
    FileReader& operator=(const FileReader&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Count the number of given lines from the end of the file and
     * return the file offset.
     * @param current The Current object for the invocation.
     */
    virtual ::Ice::Long getOffsetFromEnd(const ::std::string& filename, ::Ice::Int lines, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getOffsetFromEnd(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Read lines (or size bytes) at the specified position from the given file.
     * @param current The Current object for the invocation.
     */
    virtual bool read(const ::std::string& filename, ::Ice::Long pos, ::Ice::Int size, ::Ice::Long& newPos, ::Ice::StringSeq& lines, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_read(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const FileReader& lhs, const FileReader& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const FileReader& lhs, const FileReader& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

class Server : virtual public FileReader
{
public:

    typedef ServerPrx ProxyType;
    typedef ServerPtr PointerType;

    virtual ~Server();

#ifdef ICE_CPP11_COMPILER
    Server() = default;
    Server(const Server&) = default;
    Server& operator=(const Server&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Start the server.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void start_async(const ::IceGrid::AMD_Server_startPtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_start(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Stop the server. This methods returns only when the server is
     * deactivated. If the server doesn't stop after a configurable
     * amount of time, it will be killed.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void stop_async(const ::IceGrid::AMD_Server_stopPtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_stop(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Check if the given server can be loaded on this node.
     * @param current The Current object for the invocation.
     * @return True if the server is inactive.
     * @throws IceGrid::DeploymentException Raised if the server can't be updated.
     */
    virtual bool checkUpdate(const InternalServerDescriptorPtr& svr, bool noRestart, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_checkUpdate(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Enable or disable the server.
     * @param current The Current object for the invocation.
     */
    virtual void setEnabled(bool enable, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setEnabled(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Check if the server is enabled.
     * @param current The Current object for the invocation.
     */
    virtual bool isEnabled(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_isEnabled(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Send signal to the server
     * @param current The Current object for the invocation.
     */
    virtual void sendSignal(const ::std::string& signal, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_sendSignal(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Write message on servers' stdout or stderr.
     * @param current The Current object for the invocation.
     */
    virtual void writeMessage(const ::std::string& message, ::Ice::Int fd, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_writeMessage(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Return the server state.
     * @param current The Current object for the invocation.
     * @return The server state.
     * @see ServerState
     */
    virtual ServerState getState(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getState(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the server pid. Note that the value returned by this method
     * is system dependant. On Unix operating systems, it's the pid
     * value returned by the fork() system call and converted to an
     * integer.
     * @param current The Current object for the invocation.
     */
    virtual ::Ice::Int getPid(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getPid(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Set the process proxy.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void setProcess_async(const ::IceGrid::AMD_Server_setProcessPtr& cb, const ::Ice::ProcessPrx& proc, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setProcess(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const Server& lhs, const Server& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Server& lhs, const Server& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

class ReplicaObserver : public virtual ::Ice::Object
{
public:

    typedef ReplicaObserverPrx ProxyType;
    typedef ReplicaObserverPtr PointerType;

    virtual ~ReplicaObserver();

#ifdef ICE_CPP11_COMPILER
    ReplicaObserver() = default;
    ReplicaObserver(const ReplicaObserver&) = default;
    ReplicaObserver& operator=(const ReplicaObserver&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Initialization of the replica observer.
     * @param current The Current object for the invocation.
     */
    virtual void replicaInit(const InternalRegistryPrxSeq& replicas, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_replicaInit(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Notification that a replica has been added. The node should
     * establish a session with this new replica.
     * @param current The Current object for the invocation.
     */
    virtual void replicaAdded(const InternalRegistryPrx& replica, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_replicaAdded(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Notification that a replica has been removed. The node should
     * destroy the session to this replica.
     * @param current The Current object for the invocation.
     */
    virtual void replicaRemoved(const InternalRegistryPrx& replica, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_replicaRemoved(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const ReplicaObserver& lhs, const ReplicaObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ReplicaObserver& lhs, const ReplicaObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

class PatcherFeedback : public virtual ::Ice::Object
{
public:

    typedef PatcherFeedbackPrx ProxyType;
    typedef PatcherFeedbackPtr PointerType;

    virtual ~PatcherFeedback();

#ifdef ICE_CPP11_COMPILER
    PatcherFeedback() = default;
    PatcherFeedback(const PatcherFeedback&) = default;
    PatcherFeedback& operator=(const PatcherFeedback&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * The patch completed successfully.
     * @param current The Current object for the invocation.
     */
    virtual void finished(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_finished(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * The patch on the given node failed for the given reason.
     * @param current The Current object for the invocation.
     */
    virtual void failed(const ::std::string& reason, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_failed(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const PatcherFeedback& lhs, const PatcherFeedback& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const PatcherFeedback& lhs, const PatcherFeedback& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

class Node : virtual public FileReader,
             virtual public ReplicaObserver
{
public:

    typedef NodePrx ProxyType;
    typedef NodePtr PointerType;

    virtual ~Node();

#ifdef ICE_CPP11_COMPILER
    Node() = default;
    Node(const Node&) = default;
    Node& operator=(const Node&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Load the given server. If the server resources weren't already
     * created (database environment directories, property files, etc),
     * they will be created.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void loadServer_async(const ::IceGrid::AMD_Node_loadServerPtr& cb, const InternalServerDescriptorPtr& svr, const ::std::string& replicaName, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_loadServer(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Load the given server and ensure the server won't be
     * restarted. If the server resources weren't already created
     * (database environment directories, property files, etc), they
     * will be created. If the server can't be updated without a
     * restart, a DeploymentException is raised.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void loadServerWithoutRestart_async(const ::IceGrid::AMD_Node_loadServerWithoutRestartPtr& cb, const InternalServerDescriptorPtr& svr, const ::std::string& replicaName, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_loadServerWithoutRestart(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Destroy the given server.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void destroyServer_async(const ::IceGrid::AMD_Node_destroyServerPtr& cb, const ::std::string& name, const ::std::string& uuid, ::Ice::Int revision, const ::std::string& replicaName, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_destroyServer(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Destroy the server if it's not active.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void destroyServerWithoutRestart_async(const ::IceGrid::AMD_Node_destroyServerWithoutRestartPtr& cb, const ::std::string& name, const ::std::string& uuid, ::Ice::Int revision, const ::std::string& replicaName, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_destroyServerWithoutRestart(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Patch application and server distributions. If some servers
     * using a distribution directory to patch are active, this method
     * will raise a PatchException unless shutdown is set to true. In
     * which case the servers will be shutdown.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void patch_async(const ::IceGrid::AMD_Node_patchPtr& cb, const PatcherFeedbackPrx& feedback, const ::std::string& application, const ::std::string& server, const InternalDistributionDescriptorPtr& appDistrib, bool shutdown, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_patch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Establish a session to the given replica, this method only
     * returns once the registration was attempted (unlike
     * replicaAdded below).
     * @param current The Current object for the invocation.
     */
    virtual void registerWithReplica(const InternalRegistryPrx& replica, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_registerWithReplica(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get the node name.
     * @param current The Current object for the invocation.
     */
    virtual ::std::string getName(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getName(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the node hostname.
     * @param current The Current object for the invocation.
     */
    virtual ::std::string getHostname(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getHostname(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the node load.
     * @param current The Current object for the invocation.
     */
    virtual LoadInfo getLoad(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getLoad(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the number of processor sockets for the machine where this
     * node is running.
     * @param current The Current object for the invocation.
     */
    virtual ::Ice::Int getProcessorSocketCount(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getProcessorSocketCount(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Shutdown the node.
     * @param current The Current object for the invocation.
     */
    virtual void shutdown(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_shutdown(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const Node& lhs, const Node& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Node& lhs, const Node& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

class NodeSession : public virtual ::Ice::Object
{
public:

    typedef NodeSessionPrx ProxyType;
    typedef NodeSessionPtr PointerType;

    virtual ~NodeSession();

#ifdef ICE_CPP11_COMPILER
    NodeSession() = default;
    NodeSession(const NodeSession&) = default;
    NodeSession& operator=(const NodeSession&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * The node call this method to keep the session alive.
     * @param current The Current object for the invocation.
     */
    virtual void keepAlive(const LoadInfo& load, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_keepAlive(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set the replica observer. The node calls this method when it's
     * ready to receive notifications for the replicas. It only calls
     * this for the session with the master.
     * @param current The Current object for the invocation.
     */
    virtual void setReplicaObserver(const ReplicaObserverPrx& observer, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setReplicaObserver(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Return the node session timeout.
     * @param current The Current object for the invocation.
     */
    virtual ::Ice::Int getTimeout(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getTimeout(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Return the node observer.
     * @param current The Current object for the invocation.
     */
    virtual NodeObserverPrx getObserver(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getObserver(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Ask the registry to load the servers on the node.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void loadServers_async(const ::IceGrid::AMD_NodeSession_loadServersPtr& cb, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_loadServers(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Get the name of the servers deployed on the node.
     * @param current The Current object for the invocation.
     */
    virtual ::Ice::StringSeq getServers(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getServers(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Wait for the application update to complete (the application is
     * completely updated once all the registry replicas have been
     * updated). This is used by the node to ensure that before to
     * start a server all the replicas have the up-to-date descriptor
     * of the server.
     * @param cb The AMD callback object for the invocation.
     * @param current The Current object for the invocation.
     */
    virtual void waitForApplicationUpdate_async(const ::IceGrid::AMD_NodeSession_waitForApplicationUpdatePtr& cb, const ::std::string& application, ::Ice::Int revision, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_waitForApplicationUpdate(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Destroy the session.
     * @param current The Current object for the invocation.
     */
    virtual void destroy(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_destroy(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const NodeSession& lhs, const NodeSession& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const NodeSession& lhs, const NodeSession& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

class DatabaseObserver : virtual public ApplicationObserver,
                         virtual public ObjectObserver,
                         virtual public AdapterObserver
{
public:

    typedef DatabaseObserverPrx ProxyType;
    typedef DatabaseObserverPtr PointerType;

    virtual ~DatabaseObserver();

#ifdef ICE_CPP11_COMPILER
    DatabaseObserver() = default;
    DatabaseObserver(const DatabaseObserver&) = default;
    DatabaseObserver& operator=(const DatabaseObserver&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const DatabaseObserver& lhs, const DatabaseObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const DatabaseObserver& lhs, const DatabaseObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

class ReplicaSession : public virtual ::Ice::Object
{
public:

    typedef ReplicaSessionPrx ProxyType;
    typedef ReplicaSessionPtr PointerType;

    virtual ~ReplicaSession();

#ifdef ICE_CPP11_COMPILER
    ReplicaSession() = default;
    ReplicaSession(const ReplicaSession&) = default;
    ReplicaSession& operator=(const ReplicaSession&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * The replica call this method to keep the session alive.
     * @param current The Current object for the invocation.
     */
    virtual void keepAlive(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_keepAlive(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Return the replica session timeout.
     * @param current The Current object for the invocation.
     */
    virtual ::Ice::Int getTimeout(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getTimeout(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Set the database observer. Once the observer is subscribed, it
     * will receive the database and database updates.
     * @param current The Current object for the invocation.
     */
    virtual void setDatabaseObserver(const DatabaseObserverPrx& dbObs, const IceUtil::Optional<StringLongDict>& serials, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setDatabaseObserver(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * This method sets the endpoints of the replica. This allows the
     * master to create proxies with multiple endpoints for replicated
     * objects (e.g.: IceGrid::Query object).
     * @param current The Current object for the invocation.
     */
    virtual void setEndpoints(const StringObjectProxyDict& endpoints, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setEndpoints(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Registers the replica well-known objects with the master.
     * @param current The Current object for the invocation.
     */
    virtual void registerWellKnownObjects(const ObjectInfoSeq& objects, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_registerWellKnownObjects(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set the adapter direct proxy of the given adapter in the
     * master. This is used to support dynamic registration with
     * the locator registry interface.
     * @param current The Current object for the invocation.
     */
    virtual void setAdapterDirectProxy(const ::std::string& adapterId, const ::std::string& replicaGroupId, const ::Ice::ObjectPrx& proxy, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setAdapterDirectProxy(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Notify the master that an update was received. The master might
     * wait for replication updates to be received by all the replicas
     * before to continue.
     * @param current The Current object for the invocation.
     */
    virtual void receivedUpdate(TopicName name, ::Ice::Int serial, const ::std::string& failure, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_receivedUpdate(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Destroy the session.
     * @param current The Current object for the invocation.
     */
    virtual void destroy(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_destroy(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const ReplicaSession& lhs, const ReplicaSession& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ReplicaSession& lhs, const ReplicaSession& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Information about an IceGrid node.
 */
class InternalNodeInfo : public virtual ::Ice::Object
{
public:

    typedef InternalNodeInfoPrx ProxyType;
    typedef InternalNodeInfoPtr PointerType;

    virtual ~InternalNodeInfo();

    InternalNodeInfo()
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param name The name of the node.
     * @param os The operating system name.
     * @param hostname The network name of the host running this node (as defined in uname()).
     * @param release The operation system release level (as defined in uname()).
     * @param version The operation system version (as defined in uname()).
     * @param machine The machine hardware type (as defined in uname()).
     * @param nProcessors The number of processor threads (e.g.
     * @param dataDir The path to the node data directory.
     */
    InternalNodeInfo(const ::std::string& name, const ::std::string& os, const ::std::string& hostname, const ::std::string& release, const ::std::string& version, const ::std::string& machine, ::Ice::Int nProcessors, const ::std::string& dataDir) :
        name(name),
        os(os),
        hostname(hostname),
        release(release),
        version(version),
        machine(machine),
        nProcessors(nProcessors),
        dataDir(dataDir)
    {
    }

#ifdef ICE_CPP11_COMPILER
    InternalNodeInfo(const InternalNodeInfo&) = default;
    InternalNodeInfo& operator=(const InternalNodeInfo&) = default;
#endif

    /**
     * Polymorphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond

public:

    /**
     * The name of the node.
     */
    ::std::string name;
    /**
     * The operating system name.
     */
    ::std::string os;
    /**
     * The network name of the host running this node (as defined in
     * uname()).
     */
    ::std::string hostname;
    /**
     * The operation system release level (as defined in uname()).
     */
    ::std::string release;
    /**
     * The operation system version (as defined in uname()).
     */
    ::std::string version;
    /**
     * The machine hardware type (as defined in uname()).
     */
    ::std::string machine;
    /**
     * The number of processor threads (e.g. 8 on
     * system with 1 quad-core CPU, with 2 threads per core)
     */
    ::Ice::Int nProcessors;
    /**
     * The path to the node data directory.
     */
    ::std::string dataDir;
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_InternalNodeInfo_init = ::IceGrid::InternalNodeInfo::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const InternalNodeInfo& lhs, const InternalNodeInfo& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const InternalNodeInfo& lhs, const InternalNodeInfo& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Information about an IceGrid registry replica.
 */
class InternalReplicaInfo : public virtual ::Ice::Object
{
public:

    typedef InternalReplicaInfoPrx ProxyType;
    typedef InternalReplicaInfoPtr PointerType;

    virtual ~InternalReplicaInfo();

    InternalReplicaInfo()
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param name The name of the registry.
     * @param hostname The network name of the host running this registry (as defined in uname()).
     */
    InternalReplicaInfo(const ::std::string& name, const ::std::string& hostname) :
        name(name),
        hostname(hostname)
    {
    }

#ifdef ICE_CPP11_COMPILER
    InternalReplicaInfo(const InternalReplicaInfo&) = default;
    InternalReplicaInfo& operator=(const InternalReplicaInfo&) = default;
#endif

    /**
     * Polymorphically clones this object.
     * @return A shallow copy of this object.
     */
    virtual ::Ice::ObjectPtr ice_clone() const;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Obtains a value factory that instantiates this class.
     * @return The value factory.
     */
    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond

public:

    /**
     * The name of the registry.
     */
    ::std::string name;
    /**
     * The network name of the host running this registry (as defined in
     * uname()).
     */
    ::std::string hostname;
};
/// \cond INTERNAL
static ::Ice::ValueFactoryPtr _iceS_InternalReplicaInfo_init = ::IceGrid::InternalReplicaInfo::ice_factory();
/// \endcond

/// \cond INTERNAL
inline bool operator==(const InternalReplicaInfo& lhs, const InternalReplicaInfo& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const InternalReplicaInfo& lhs, const InternalReplicaInfo& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

class InternalRegistry : virtual public FileReader
{
public:

    typedef InternalRegistryPrx ProxyType;
    typedef InternalRegistryPtr PointerType;

    virtual ~InternalRegistry();

#ifdef ICE_CPP11_COMPILER
    InternalRegistry() = default;
    InternalRegistry(const InternalRegistry&) = default;
    InternalRegistry& operator=(const InternalRegistry&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Register a node with the registry. If a node with the same name
     * is already registered, [registerNode] will overide the previous
     * node only if it's not active.
     * @param info Some information on the node.
     * @param prx The proxy of the node.
     * @param loadInf The load information of the node.
     * @param current The Current object for the invocation.
     * @return The node session proxy.
     * @throws IceGrid::NodeActiveException Raised if the node is already
     * registered and currently active.
     */
    virtual NodeSessionPrx registerNode(const InternalNodeInfoPtr& info, const NodePrx& prx, const LoadInfo& loadInf, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_registerNode(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Register a replica with the registry. If a replica with the
     * same name is already registered, [registerReplica] will overide
     * the previous replica only if it's not active.
     * @param info Some information on the replica.
     * @param prx The proxy of the replica.
     * @param current The Current object for the invocation.
     * @return The replica session proxy.
     * @throws IceGrid::ReplicaActiveException Raised if the replica is already
     * registered and currently active.
     */
    virtual ReplicaSessionPrx registerReplica(const InternalReplicaInfoPtr& info, const InternalRegistryPrx& prx, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_registerReplica(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Create a session with the given registry replica. This method
     * returns only once the session creation has been attempted.
     * @param current The Current object for the invocation.
     */
    virtual void registerWithReplica(const InternalRegistryPrx& prx, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_registerWithReplica(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Return the proxies of all the nodes known by this registry.
     * @param current The Current object for the invocation.
     */
    virtual NodePrxSeq getNodes(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getNodes(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Return the proxies of all the registry replicas known by this
     * registry.
     * @param current The Current object for the invocation.
     */
    virtual InternalRegistryPrxSeq getReplicas(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getReplicas(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Return applications, adapters, objects from this replica.
     * @param current The Current object for the invocation.
     */
    virtual ApplicationInfoSeq getApplications(::Ice::Long& serial, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getApplications(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    virtual AdapterInfoSeq getAdapters(::Ice::Long& serial, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getAdapters(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    virtual ObjectInfoSeq getObjects(::Ice::Long& serial, const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getObjects(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /**
     * Shutdown this registry.
     * @param current The Current object for the invocation.
     */
    virtual void shutdown(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_shutdown(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const InternalRegistry& lhs, const InternalRegistry& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const InternalRegistry& lhs, const InternalRegistry& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

template<typename S>
struct StreamWriter< ::IceGrid::InternalDbEnvDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::InternalDbEnvDescriptor& v)
    {
        ostr->write(v.name);
        ostr->write(v.properties);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::InternalDbEnvDescriptor, S>
{
    static void read(S* istr, ::IceGrid::InternalDbEnvDescriptor& v)
    {
        istr->read(v.name);
        istr->read(v.properties);
    }
};

template<typename S>
struct StreamWriter< ::IceGrid::InternalAdapterDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::InternalAdapterDescriptor& v)
    {
        ostr->write(v.id);
        ostr->write(v.serverLifetime);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::InternalAdapterDescriptor, S>
{
    static void read(S* istr, ::IceGrid::InternalAdapterDescriptor& v)
    {
        istr->read(v.id);
        istr->read(v.serverLifetime);
    }
};

template<typename S>
struct StreamWriter< ::IceGrid::InternalDistributionDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::InternalDistributionDescriptor& v)
    {
        ostr->write(v.icepatch);
        ostr->write(v.directories);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::InternalDistributionDescriptor, S>
{
    static void read(S* istr, ::IceGrid::InternalDistributionDescriptor& v)
    {
        istr->read(v.icepatch);
        istr->read(v.directories);
    }
};

template<typename S>
struct StreamWriter< ::IceGrid::InternalServerDescriptor, S>
{
    static void write(S* ostr, const ::IceGrid::InternalServerDescriptor& v)
    {
        ostr->write(v.id);
        ostr->write(v.application);
        ostr->write(v.uuid);
        ostr->write(v.revision);
        ostr->write(v.sessionId);
        ostr->write(v.exe);
        ostr->write(v.pwd);
        ostr->write(v.user);
        ostr->write(v.activation);
        ostr->write(v.activationTimeout);
        ostr->write(v.deactivationTimeout);
        ostr->write(v.applicationDistrib);
        ostr->write(v.distrib);
        ostr->write(v.processRegistered);
        ostr->write(v.options);
        ostr->write(v.envs);
        ostr->write(v.logs);
        ostr->write(v.adapters);
        ostr->write(v.dbEnvs);
        ostr->write(v.properties);
        ostr->write(1, v.services);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::InternalServerDescriptor, S>
{
    static void read(S* istr, ::IceGrid::InternalServerDescriptor& v)
    {
        istr->read(v.id);
        istr->read(v.application);
        istr->read(v.uuid);
        istr->read(v.revision);
        istr->read(v.sessionId);
        istr->read(v.exe);
        istr->read(v.pwd);
        istr->read(v.user);
        istr->read(v.activation);
        istr->read(v.activationTimeout);
        istr->read(v.deactivationTimeout);
        istr->read(v.applicationDistrib);
        istr->read(v.distrib);
        istr->read(v.processRegistered);
        istr->read(v.options);
        istr->read(v.envs);
        istr->read(v.logs);
        istr->read(v.adapters);
        istr->read(v.dbEnvs);
        istr->read(v.properties);
        istr->read(1, v.services);
    }
};

template<>
struct StreamableTraits< ::IceGrid::AdapterActiveException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::IceGrid::AdapterNotActiveException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::AdapterNotActiveException, S>
{
    static void write(S* ostr, const ::IceGrid::AdapterNotActiveException& v)
    {
        ostr->write(v.activatable);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::AdapterNotActiveException, S>
{
    static void read(S* istr, ::IceGrid::AdapterNotActiveException& v)
    {
        istr->read(v.activatable);
    }
};

template<>
struct StreamableTraits< ::IceGrid::AdapterExistsException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceGrid::AdapterExistsException, S>
{
    static void write(S* ostr, const ::IceGrid::AdapterExistsException& v)
    {
        ostr->write(v.id);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::AdapterExistsException, S>
{
    static void read(S* istr, ::IceGrid::AdapterExistsException& v)
    {
        istr->read(v.id);
    }
};

template<>
struct StreamableTraits< ::IceGrid::NodeActiveException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::IceGrid::ReplicaActiveException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<>
struct StreamableTraits< ::IceGrid::TopicName>
{
    static const StreamHelperCategory helper = StreamHelperCategoryEnum;
    static const int minValue = 0;
    static const int maxValue = 4;
    static const int minWireSize = 1;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::InternalNodeInfo, S>
{
    static void write(S* ostr, const ::IceGrid::InternalNodeInfo& v)
    {
        ostr->write(v.name);
        ostr->write(v.os);
        ostr->write(v.hostname);
        ostr->write(v.release);
        ostr->write(v.version);
        ostr->write(v.machine);
        ostr->write(v.nProcessors);
        ostr->write(v.dataDir);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::InternalNodeInfo, S>
{
    static void read(S* istr, ::IceGrid::InternalNodeInfo& v)
    {
        istr->read(v.name);
        istr->read(v.os);
        istr->read(v.hostname);
        istr->read(v.release);
        istr->read(v.version);
        istr->read(v.machine);
        istr->read(v.nProcessors);
        istr->read(v.dataDir);
    }
};

template<typename S>
struct StreamWriter< ::IceGrid::InternalReplicaInfo, S>
{
    static void write(S* ostr, const ::IceGrid::InternalReplicaInfo& v)
    {
        ostr->write(v.name);
        ostr->write(v.hostname);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::InternalReplicaInfo, S>
{
    static void read(S* istr, ::IceGrid::InternalReplicaInfo& v)
    {
        istr->read(v.name);
        istr->read(v.hostname);
    }
};

}
/// \endcond

namespace IceGrid
{

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Adapter::begin_activate.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Adapter_activate.
 */
template<class T>
class CallbackNC_Adapter_activate : public Callback_Adapter_activate_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Adapter_activate(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdapterPrx proxy = AdapterPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_activate(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Adapter::begin_activate.
 */
template<class T> Callback_Adapter_activatePtr
newCallback_Adapter_activate(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Adapter_activate<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Adapter::begin_activate.
 */
template<class T> Callback_Adapter_activatePtr
newCallback_Adapter_activate(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Adapter_activate<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Adapter::begin_activate.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Adapter_activate.
 */
template<class T, typename CT>
class Callback_Adapter_activate : public Callback_Adapter_activate_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Adapter_activate(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdapterPrx proxy = AdapterPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_activate(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Adapter::begin_activate.
 */
template<class T, typename CT> Callback_Adapter_activatePtr
newCallback_Adapter_activate(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Adapter_activate<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Adapter::begin_activate.
 */
template<class T, typename CT> Callback_Adapter_activatePtr
newCallback_Adapter_activate(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Adapter_activate<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Adapter::begin_getDirectProxy.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Adapter_getDirectProxy.
 */
template<class T>
class CallbackNC_Adapter_getDirectProxy : public Callback_Adapter_getDirectProxy_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Adapter_getDirectProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdapterPrx proxy = AdapterPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_getDirectProxy(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Adapter::begin_getDirectProxy.
 */
template<class T> Callback_Adapter_getDirectProxyPtr
newCallback_Adapter_getDirectProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Adapter_getDirectProxy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Adapter::begin_getDirectProxy.
 */
template<class T> Callback_Adapter_getDirectProxyPtr
newCallback_Adapter_getDirectProxy(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Adapter_getDirectProxy<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Adapter::begin_getDirectProxy.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Adapter_getDirectProxy.
 */
template<class T, typename CT>
class Callback_Adapter_getDirectProxy : public Callback_Adapter_getDirectProxy_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Adapter_getDirectProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdapterPrx proxy = AdapterPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_getDirectProxy(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Adapter::begin_getDirectProxy.
 */
template<class T, typename CT> Callback_Adapter_getDirectProxyPtr
newCallback_Adapter_getDirectProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Adapter_getDirectProxy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Adapter::begin_getDirectProxy.
 */
template<class T, typename CT> Callback_Adapter_getDirectProxyPtr
newCallback_Adapter_getDirectProxy(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Adapter_getDirectProxy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Adapter::begin_setDirectProxy.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Adapter_setDirectProxy.
 */
template<class T>
class CallbackNC_Adapter_setDirectProxy : public Callback_Adapter_setDirectProxy_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Adapter_setDirectProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdapterPrx proxy = AdapterPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_setDirectProxy(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Adapter::begin_setDirectProxy.
 */
template<class T> Callback_Adapter_setDirectProxyPtr
newCallback_Adapter_setDirectProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Adapter_setDirectProxy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Adapter::begin_setDirectProxy.
 */
template<class T> Callback_Adapter_setDirectProxyPtr
newCallback_Adapter_setDirectProxy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Adapter_setDirectProxy<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Adapter::begin_setDirectProxy.
 */
template<class T> Callback_Adapter_setDirectProxyPtr
newCallback_Adapter_setDirectProxy(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Adapter_setDirectProxy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Adapter::begin_setDirectProxy.
 */
template<class T> Callback_Adapter_setDirectProxyPtr
newCallback_Adapter_setDirectProxy(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Adapter_setDirectProxy<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Adapter::begin_setDirectProxy.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Adapter_setDirectProxy.
 */
template<class T, typename CT>
class Callback_Adapter_setDirectProxy : public Callback_Adapter_setDirectProxy_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Adapter_setDirectProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        AdapterPrx proxy = AdapterPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_setDirectProxy(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Adapter::begin_setDirectProxy.
 */
template<class T, typename CT> Callback_Adapter_setDirectProxyPtr
newCallback_Adapter_setDirectProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Adapter_setDirectProxy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Adapter::begin_setDirectProxy.
 */
template<class T, typename CT> Callback_Adapter_setDirectProxyPtr
newCallback_Adapter_setDirectProxy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Adapter_setDirectProxy<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Adapter::begin_setDirectProxy.
 */
template<class T, typename CT> Callback_Adapter_setDirectProxyPtr
newCallback_Adapter_setDirectProxy(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Adapter_setDirectProxy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Adapter::begin_setDirectProxy.
 */
template<class T, typename CT> Callback_Adapter_setDirectProxyPtr
newCallback_Adapter_setDirectProxy(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Adapter_setDirectProxy<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::FileReader::begin_getOffsetFromEnd.
 * Create a wrapper instance by calling ::IceGrid::newCallback_FileReader_getOffsetFromEnd.
 */
template<class T>
class CallbackNC_FileReader_getOffsetFromEnd : public Callback_FileReader_getOffsetFromEnd_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(::Ice::Long);

    CallbackNC_FileReader_getOffsetFromEnd(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        FileReaderPrx proxy = FileReaderPrx::uncheckedCast(result->getProxy());
        ::Ice::Long ret;
        try
        {
            ret = proxy->end_getOffsetFromEnd(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::FileReader::begin_getOffsetFromEnd.
 */
template<class T> Callback_FileReader_getOffsetFromEndPtr
newCallback_FileReader_getOffsetFromEnd(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Long), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileReader_getOffsetFromEnd<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::FileReader::begin_getOffsetFromEnd.
 */
template<class T> Callback_FileReader_getOffsetFromEndPtr
newCallback_FileReader_getOffsetFromEnd(T* instance, void (T::*cb)(::Ice::Long), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileReader_getOffsetFromEnd<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::FileReader::begin_getOffsetFromEnd.
 * Create a wrapper instance by calling ::IceGrid::newCallback_FileReader_getOffsetFromEnd.
 */
template<class T, typename CT>
class Callback_FileReader_getOffsetFromEnd : public Callback_FileReader_getOffsetFromEnd_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(::Ice::Long, const CT&);

    Callback_FileReader_getOffsetFromEnd(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        FileReaderPrx proxy = FileReaderPrx::uncheckedCast(result->getProxy());
        ::Ice::Long ret;
        try
        {
            ret = proxy->end_getOffsetFromEnd(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::FileReader::begin_getOffsetFromEnd.
 */
template<class T, typename CT> Callback_FileReader_getOffsetFromEndPtr
newCallback_FileReader_getOffsetFromEnd(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Long, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileReader_getOffsetFromEnd<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::FileReader::begin_getOffsetFromEnd.
 */
template<class T, typename CT> Callback_FileReader_getOffsetFromEndPtr
newCallback_FileReader_getOffsetFromEnd(T* instance, void (T::*cb)(::Ice::Long, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileReader_getOffsetFromEnd<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::FileReader::begin_read.
 * Create a wrapper instance by calling ::IceGrid::newCallback_FileReader_read.
 */
template<class T>
class CallbackNC_FileReader_read : public Callback_FileReader_read_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(bool, ::Ice::Long, const ::Ice::StringSeq&);

    CallbackNC_FileReader_read(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        FileReaderPrx proxy = FileReaderPrx::uncheckedCast(result->getProxy());
        ::Ice::Long iceP_newPos;
        ::Ice::StringSeq iceP_lines;
        bool ret;
        try
        {
            ret = proxy->end_read(iceP_newPos, iceP_lines, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret, iceP_newPos, iceP_lines);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::FileReader::begin_read.
 */
template<class T> Callback_FileReader_readPtr
newCallback_FileReader_read(const IceUtil::Handle<T>& instance, void (T::*cb)(bool, ::Ice::Long, const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileReader_read<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::FileReader::begin_read.
 */
template<class T> Callback_FileReader_readPtr
newCallback_FileReader_read(T* instance, void (T::*cb)(bool, ::Ice::Long, const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileReader_read<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::FileReader::begin_read.
 * Create a wrapper instance by calling ::IceGrid::newCallback_FileReader_read.
 */
template<class T, typename CT>
class Callback_FileReader_read : public Callback_FileReader_read_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(bool, ::Ice::Long, const ::Ice::StringSeq&, const CT&);

    Callback_FileReader_read(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        FileReaderPrx proxy = FileReaderPrx::uncheckedCast(result->getProxy());
        ::Ice::Long iceP_newPos;
        ::Ice::StringSeq iceP_lines;
        bool ret;
        try
        {
            ret = proxy->end_read(iceP_newPos, iceP_lines, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, iceP_newPos, iceP_lines, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::FileReader::begin_read.
 */
template<class T, typename CT> Callback_FileReader_readPtr
newCallback_FileReader_read(const IceUtil::Handle<T>& instance, void (T::*cb)(bool, ::Ice::Long, const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileReader_read<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::FileReader::begin_read.
 */
template<class T, typename CT> Callback_FileReader_readPtr
newCallback_FileReader_read(T* instance, void (T::*cb)(bool, ::Ice::Long, const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileReader_read<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Server::begin_start.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_start.
 */
template<class T>
class CallbackNC_Server_start : public Callback_Server_start_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Server_start(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ServerPrx proxy = ServerPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_start(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_start.
 */
template<class T> Callback_Server_startPtr
newCallback_Server_start(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_start<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_start.
 */
template<class T> Callback_Server_startPtr
newCallback_Server_start(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_start<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_start.
 */
template<class T> Callback_Server_startPtr
newCallback_Server_start(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_start<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_start.
 */
template<class T> Callback_Server_startPtr
newCallback_Server_start(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_start<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Server::begin_start.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_start.
 */
template<class T, typename CT>
class Callback_Server_start : public Callback_Server_start_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Server_start(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ServerPrx proxy = ServerPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_start(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_start.
 */
template<class T, typename CT> Callback_Server_startPtr
newCallback_Server_start(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_start<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_start.
 */
template<class T, typename CT> Callback_Server_startPtr
newCallback_Server_start(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_start<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_start.
 */
template<class T, typename CT> Callback_Server_startPtr
newCallback_Server_start(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_start<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_start.
 */
template<class T, typename CT> Callback_Server_startPtr
newCallback_Server_start(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_start<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Server::begin_stop.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_stop.
 */
template<class T>
class CallbackNC_Server_stop : public Callback_Server_stop_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Server_stop(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ServerPrx proxy = ServerPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_stop(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_stop.
 */
template<class T> Callback_Server_stopPtr
newCallback_Server_stop(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_stop<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_stop.
 */
template<class T> Callback_Server_stopPtr
newCallback_Server_stop(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_stop<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_stop.
 */
template<class T> Callback_Server_stopPtr
newCallback_Server_stop(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_stop<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_stop.
 */
template<class T> Callback_Server_stopPtr
newCallback_Server_stop(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_stop<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Server::begin_stop.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_stop.
 */
template<class T, typename CT>
class Callback_Server_stop : public Callback_Server_stop_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Server_stop(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ServerPrx proxy = ServerPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_stop(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_stop.
 */
template<class T, typename CT> Callback_Server_stopPtr
newCallback_Server_stop(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_stop<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_stop.
 */
template<class T, typename CT> Callback_Server_stopPtr
newCallback_Server_stop(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_stop<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_stop.
 */
template<class T, typename CT> Callback_Server_stopPtr
newCallback_Server_stop(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_stop<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_stop.
 */
template<class T, typename CT> Callback_Server_stopPtr
newCallback_Server_stop(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_stop<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Server::begin_checkUpdate.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_checkUpdate.
 */
template<class T>
class CallbackNC_Server_checkUpdate : public Callback_Server_checkUpdate_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(bool);

    CallbackNC_Server_checkUpdate(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ServerPrx proxy = ServerPrx::uncheckedCast(result->getProxy());
        bool ret;
        try
        {
            ret = proxy->end_checkUpdate(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_checkUpdate.
 */
template<class T> Callback_Server_checkUpdatePtr
newCallback_Server_checkUpdate(const IceUtil::Handle<T>& instance, void (T::*cb)(bool), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_checkUpdate<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_checkUpdate.
 */
template<class T> Callback_Server_checkUpdatePtr
newCallback_Server_checkUpdate(T* instance, void (T::*cb)(bool), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_checkUpdate<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Server::begin_checkUpdate.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_checkUpdate.
 */
template<class T, typename CT>
class Callback_Server_checkUpdate : public Callback_Server_checkUpdate_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(bool, const CT&);

    Callback_Server_checkUpdate(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ServerPrx proxy = ServerPrx::uncheckedCast(result->getProxy());
        bool ret;
        try
        {
            ret = proxy->end_checkUpdate(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_checkUpdate.
 */
template<class T, typename CT> Callback_Server_checkUpdatePtr
newCallback_Server_checkUpdate(const IceUtil::Handle<T>& instance, void (T::*cb)(bool, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_checkUpdate<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_checkUpdate.
 */
template<class T, typename CT> Callback_Server_checkUpdatePtr
newCallback_Server_checkUpdate(T* instance, void (T::*cb)(bool, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_checkUpdate<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Server::begin_setEnabled.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_setEnabled.
 */
template<class T>
class CallbackNC_Server_setEnabled : public Callback_Server_setEnabled_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Server_setEnabled(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_setEnabled.
 */
template<class T> Callback_Server_setEnabledPtr
newCallback_Server_setEnabled(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_setEnabled<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_setEnabled.
 */
template<class T> Callback_Server_setEnabledPtr
newCallback_Server_setEnabled(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_setEnabled<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_setEnabled.
 */
template<class T> Callback_Server_setEnabledPtr
newCallback_Server_setEnabled(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_setEnabled<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_setEnabled.
 */
template<class T> Callback_Server_setEnabledPtr
newCallback_Server_setEnabled(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_setEnabled<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Server::begin_setEnabled.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_setEnabled.
 */
template<class T, typename CT>
class Callback_Server_setEnabled : public Callback_Server_setEnabled_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Server_setEnabled(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_setEnabled.
 */
template<class T, typename CT> Callback_Server_setEnabledPtr
newCallback_Server_setEnabled(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_setEnabled<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_setEnabled.
 */
template<class T, typename CT> Callback_Server_setEnabledPtr
newCallback_Server_setEnabled(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_setEnabled<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_setEnabled.
 */
template<class T, typename CT> Callback_Server_setEnabledPtr
newCallback_Server_setEnabled(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_setEnabled<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_setEnabled.
 */
template<class T, typename CT> Callback_Server_setEnabledPtr
newCallback_Server_setEnabled(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_setEnabled<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Server::begin_isEnabled.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_isEnabled.
 */
template<class T>
class CallbackNC_Server_isEnabled : public Callback_Server_isEnabled_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(bool);

    CallbackNC_Server_isEnabled(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ServerPrx proxy = ServerPrx::uncheckedCast(result->getProxy());
        bool ret;
        try
        {
            ret = proxy->end_isEnabled(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_isEnabled.
 */
template<class T> Callback_Server_isEnabledPtr
newCallback_Server_isEnabled(const IceUtil::Handle<T>& instance, void (T::*cb)(bool), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_isEnabled<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_isEnabled.
 */
template<class T> Callback_Server_isEnabledPtr
newCallback_Server_isEnabled(T* instance, void (T::*cb)(bool), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_isEnabled<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Server::begin_isEnabled.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_isEnabled.
 */
template<class T, typename CT>
class Callback_Server_isEnabled : public Callback_Server_isEnabled_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(bool, const CT&);

    Callback_Server_isEnabled(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ServerPrx proxy = ServerPrx::uncheckedCast(result->getProxy());
        bool ret;
        try
        {
            ret = proxy->end_isEnabled(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_isEnabled.
 */
template<class T, typename CT> Callback_Server_isEnabledPtr
newCallback_Server_isEnabled(const IceUtil::Handle<T>& instance, void (T::*cb)(bool, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_isEnabled<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_isEnabled.
 */
template<class T, typename CT> Callback_Server_isEnabledPtr
newCallback_Server_isEnabled(T* instance, void (T::*cb)(bool, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_isEnabled<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Server::begin_sendSignal.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_sendSignal.
 */
template<class T>
class CallbackNC_Server_sendSignal : public Callback_Server_sendSignal_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Server_sendSignal(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ServerPrx proxy = ServerPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_sendSignal(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_sendSignal.
 */
template<class T> Callback_Server_sendSignalPtr
newCallback_Server_sendSignal(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_sendSignal<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_sendSignal.
 */
template<class T> Callback_Server_sendSignalPtr
newCallback_Server_sendSignal(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_sendSignal<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_sendSignal.
 */
template<class T> Callback_Server_sendSignalPtr
newCallback_Server_sendSignal(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_sendSignal<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_sendSignal.
 */
template<class T> Callback_Server_sendSignalPtr
newCallback_Server_sendSignal(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_sendSignal<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Server::begin_sendSignal.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_sendSignal.
 */
template<class T, typename CT>
class Callback_Server_sendSignal : public Callback_Server_sendSignal_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Server_sendSignal(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ServerPrx proxy = ServerPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_sendSignal(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_sendSignal.
 */
template<class T, typename CT> Callback_Server_sendSignalPtr
newCallback_Server_sendSignal(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_sendSignal<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_sendSignal.
 */
template<class T, typename CT> Callback_Server_sendSignalPtr
newCallback_Server_sendSignal(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_sendSignal<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_sendSignal.
 */
template<class T, typename CT> Callback_Server_sendSignalPtr
newCallback_Server_sendSignal(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_sendSignal<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_sendSignal.
 */
template<class T, typename CT> Callback_Server_sendSignalPtr
newCallback_Server_sendSignal(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_sendSignal<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Server::begin_writeMessage.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_writeMessage.
 */
template<class T>
class CallbackNC_Server_writeMessage : public Callback_Server_writeMessage_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Server_writeMessage(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_writeMessage.
 */
template<class T> Callback_Server_writeMessagePtr
newCallback_Server_writeMessage(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_writeMessage<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_writeMessage.
 */
template<class T> Callback_Server_writeMessagePtr
newCallback_Server_writeMessage(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_writeMessage<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_writeMessage.
 */
template<class T> Callback_Server_writeMessagePtr
newCallback_Server_writeMessage(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_writeMessage<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_writeMessage.
 */
template<class T> Callback_Server_writeMessagePtr
newCallback_Server_writeMessage(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_writeMessage<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Server::begin_writeMessage.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_writeMessage.
 */
template<class T, typename CT>
class Callback_Server_writeMessage : public Callback_Server_writeMessage_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Server_writeMessage(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_writeMessage.
 */
template<class T, typename CT> Callback_Server_writeMessagePtr
newCallback_Server_writeMessage(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_writeMessage<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_writeMessage.
 */
template<class T, typename CT> Callback_Server_writeMessagePtr
newCallback_Server_writeMessage(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_writeMessage<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_writeMessage.
 */
template<class T, typename CT> Callback_Server_writeMessagePtr
newCallback_Server_writeMessage(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_writeMessage<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_writeMessage.
 */
template<class T, typename CT> Callback_Server_writeMessagePtr
newCallback_Server_writeMessage(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_writeMessage<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Server::begin_getState.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_getState.
 */
template<class T>
class CallbackNC_Server_getState : public Callback_Server_getState_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(ServerState);

    CallbackNC_Server_getState(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ServerPrx proxy = ServerPrx::uncheckedCast(result->getProxy());
        ServerState ret;
        try
        {
            ret = proxy->end_getState(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_getState.
 */
template<class T> Callback_Server_getStatePtr
newCallback_Server_getState(const IceUtil::Handle<T>& instance, void (T::*cb)(ServerState), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_getState<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_getState.
 */
template<class T> Callback_Server_getStatePtr
newCallback_Server_getState(T* instance, void (T::*cb)(ServerState), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_getState<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Server::begin_getState.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_getState.
 */
template<class T, typename CT>
class Callback_Server_getState : public Callback_Server_getState_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(ServerState, const CT&);

    Callback_Server_getState(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ServerPrx proxy = ServerPrx::uncheckedCast(result->getProxy());
        ServerState ret;
        try
        {
            ret = proxy->end_getState(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_getState.
 */
template<class T, typename CT> Callback_Server_getStatePtr
newCallback_Server_getState(const IceUtil::Handle<T>& instance, void (T::*cb)(ServerState, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_getState<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_getState.
 */
template<class T, typename CT> Callback_Server_getStatePtr
newCallback_Server_getState(T* instance, void (T::*cb)(ServerState, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_getState<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Server::begin_getPid.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_getPid.
 */
template<class T>
class CallbackNC_Server_getPid : public Callback_Server_getPid_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(::Ice::Int);

    CallbackNC_Server_getPid(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ServerPrx proxy = ServerPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getPid(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_getPid.
 */
template<class T> Callback_Server_getPidPtr
newCallback_Server_getPid(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_getPid<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_getPid.
 */
template<class T> Callback_Server_getPidPtr
newCallback_Server_getPid(T* instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_getPid<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Server::begin_getPid.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_getPid.
 */
template<class T, typename CT>
class Callback_Server_getPid : public Callback_Server_getPid_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(::Ice::Int, const CT&);

    Callback_Server_getPid(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ServerPrx proxy = ServerPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getPid(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_getPid.
 */
template<class T, typename CT> Callback_Server_getPidPtr
newCallback_Server_getPid(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_getPid<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_getPid.
 */
template<class T, typename CT> Callback_Server_getPidPtr
newCallback_Server_getPid(T* instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_getPid<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Server::begin_setProcess.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_setProcess.
 */
template<class T>
class CallbackNC_Server_setProcess : public Callback_Server_setProcess_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Server_setProcess(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_setProcess.
 */
template<class T> Callback_Server_setProcessPtr
newCallback_Server_setProcess(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_setProcess<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_setProcess.
 */
template<class T> Callback_Server_setProcessPtr
newCallback_Server_setProcess(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_setProcess<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_setProcess.
 */
template<class T> Callback_Server_setProcessPtr
newCallback_Server_setProcess(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_setProcess<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_setProcess.
 */
template<class T> Callback_Server_setProcessPtr
newCallback_Server_setProcess(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Server_setProcess<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Server::begin_setProcess.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Server_setProcess.
 */
template<class T, typename CT>
class Callback_Server_setProcess : public Callback_Server_setProcess_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Server_setProcess(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_setProcess.
 */
template<class T, typename CT> Callback_Server_setProcessPtr
newCallback_Server_setProcess(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_setProcess<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_setProcess.
 */
template<class T, typename CT> Callback_Server_setProcessPtr
newCallback_Server_setProcess(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_setProcess<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_setProcess.
 */
template<class T, typename CT> Callback_Server_setProcessPtr
newCallback_Server_setProcess(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_setProcess<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Server::begin_setProcess.
 */
template<class T, typename CT> Callback_Server_setProcessPtr
newCallback_Server_setProcess(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Server_setProcess<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::ReplicaObserver::begin_replicaInit.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaObserver_replicaInit.
 */
template<class T>
class CallbackNC_ReplicaObserver_replicaInit : public Callback_ReplicaObserver_replicaInit_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ReplicaObserver_replicaInit(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaInit.
 */
template<class T> Callback_ReplicaObserver_replicaInitPtr
newCallback_ReplicaObserver_replicaInit(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_replicaInit<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaInit.
 */
template<class T> Callback_ReplicaObserver_replicaInitPtr
newCallback_ReplicaObserver_replicaInit(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_replicaInit<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaInit.
 */
template<class T> Callback_ReplicaObserver_replicaInitPtr
newCallback_ReplicaObserver_replicaInit(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_replicaInit<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaInit.
 */
template<class T> Callback_ReplicaObserver_replicaInitPtr
newCallback_ReplicaObserver_replicaInit(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_replicaInit<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::ReplicaObserver::begin_replicaInit.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaObserver_replicaInit.
 */
template<class T, typename CT>
class Callback_ReplicaObserver_replicaInit : public Callback_ReplicaObserver_replicaInit_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ReplicaObserver_replicaInit(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaInit.
 */
template<class T, typename CT> Callback_ReplicaObserver_replicaInitPtr
newCallback_ReplicaObserver_replicaInit(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_replicaInit<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaInit.
 */
template<class T, typename CT> Callback_ReplicaObserver_replicaInitPtr
newCallback_ReplicaObserver_replicaInit(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_replicaInit<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaInit.
 */
template<class T, typename CT> Callback_ReplicaObserver_replicaInitPtr
newCallback_ReplicaObserver_replicaInit(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_replicaInit<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaInit.
 */
template<class T, typename CT> Callback_ReplicaObserver_replicaInitPtr
newCallback_ReplicaObserver_replicaInit(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_replicaInit<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::ReplicaObserver::begin_replicaAdded.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaObserver_replicaAdded.
 */
template<class T>
class CallbackNC_ReplicaObserver_replicaAdded : public Callback_ReplicaObserver_replicaAdded_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ReplicaObserver_replicaAdded(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaAdded.
 */
template<class T> Callback_ReplicaObserver_replicaAddedPtr
newCallback_ReplicaObserver_replicaAdded(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_replicaAdded<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaAdded.
 */
template<class T> Callback_ReplicaObserver_replicaAddedPtr
newCallback_ReplicaObserver_replicaAdded(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_replicaAdded<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaAdded.
 */
template<class T> Callback_ReplicaObserver_replicaAddedPtr
newCallback_ReplicaObserver_replicaAdded(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_replicaAdded<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaAdded.
 */
template<class T> Callback_ReplicaObserver_replicaAddedPtr
newCallback_ReplicaObserver_replicaAdded(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_replicaAdded<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::ReplicaObserver::begin_replicaAdded.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaObserver_replicaAdded.
 */
template<class T, typename CT>
class Callback_ReplicaObserver_replicaAdded : public Callback_ReplicaObserver_replicaAdded_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ReplicaObserver_replicaAdded(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaAdded.
 */
template<class T, typename CT> Callback_ReplicaObserver_replicaAddedPtr
newCallback_ReplicaObserver_replicaAdded(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_replicaAdded<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaAdded.
 */
template<class T, typename CT> Callback_ReplicaObserver_replicaAddedPtr
newCallback_ReplicaObserver_replicaAdded(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_replicaAdded<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaAdded.
 */
template<class T, typename CT> Callback_ReplicaObserver_replicaAddedPtr
newCallback_ReplicaObserver_replicaAdded(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_replicaAdded<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaAdded.
 */
template<class T, typename CT> Callback_ReplicaObserver_replicaAddedPtr
newCallback_ReplicaObserver_replicaAdded(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_replicaAdded<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::ReplicaObserver::begin_replicaRemoved.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaObserver_replicaRemoved.
 */
template<class T>
class CallbackNC_ReplicaObserver_replicaRemoved : public Callback_ReplicaObserver_replicaRemoved_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ReplicaObserver_replicaRemoved(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaRemoved.
 */
template<class T> Callback_ReplicaObserver_replicaRemovedPtr
newCallback_ReplicaObserver_replicaRemoved(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_replicaRemoved<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaRemoved.
 */
template<class T> Callback_ReplicaObserver_replicaRemovedPtr
newCallback_ReplicaObserver_replicaRemoved(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_replicaRemoved<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaRemoved.
 */
template<class T> Callback_ReplicaObserver_replicaRemovedPtr
newCallback_ReplicaObserver_replicaRemoved(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_replicaRemoved<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaRemoved.
 */
template<class T> Callback_ReplicaObserver_replicaRemovedPtr
newCallback_ReplicaObserver_replicaRemoved(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaObserver_replicaRemoved<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::ReplicaObserver::begin_replicaRemoved.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaObserver_replicaRemoved.
 */
template<class T, typename CT>
class Callback_ReplicaObserver_replicaRemoved : public Callback_ReplicaObserver_replicaRemoved_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ReplicaObserver_replicaRemoved(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaRemoved.
 */
template<class T, typename CT> Callback_ReplicaObserver_replicaRemovedPtr
newCallback_ReplicaObserver_replicaRemoved(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_replicaRemoved<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaRemoved.
 */
template<class T, typename CT> Callback_ReplicaObserver_replicaRemovedPtr
newCallback_ReplicaObserver_replicaRemoved(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_replicaRemoved<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaRemoved.
 */
template<class T, typename CT> Callback_ReplicaObserver_replicaRemovedPtr
newCallback_ReplicaObserver_replicaRemoved(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_replicaRemoved<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaObserver::begin_replicaRemoved.
 */
template<class T, typename CT> Callback_ReplicaObserver_replicaRemovedPtr
newCallback_ReplicaObserver_replicaRemoved(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaObserver_replicaRemoved<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::PatcherFeedback::begin_finished.
 * Create a wrapper instance by calling ::IceGrid::newCallback_PatcherFeedback_finished.
 */
template<class T>
class CallbackNC_PatcherFeedback_finished : public Callback_PatcherFeedback_finished_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_PatcherFeedback_finished(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::PatcherFeedback::begin_finished.
 */
template<class T> Callback_PatcherFeedback_finishedPtr
newCallback_PatcherFeedback_finished(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_PatcherFeedback_finished<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::PatcherFeedback::begin_finished.
 */
template<class T> Callback_PatcherFeedback_finishedPtr
newCallback_PatcherFeedback_finished(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_PatcherFeedback_finished<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::PatcherFeedback::begin_finished.
 */
template<class T> Callback_PatcherFeedback_finishedPtr
newCallback_PatcherFeedback_finished(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_PatcherFeedback_finished<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::PatcherFeedback::begin_finished.
 */
template<class T> Callback_PatcherFeedback_finishedPtr
newCallback_PatcherFeedback_finished(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_PatcherFeedback_finished<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::PatcherFeedback::begin_finished.
 * Create a wrapper instance by calling ::IceGrid::newCallback_PatcherFeedback_finished.
 */
template<class T, typename CT>
class Callback_PatcherFeedback_finished : public Callback_PatcherFeedback_finished_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_PatcherFeedback_finished(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::PatcherFeedback::begin_finished.
 */
template<class T, typename CT> Callback_PatcherFeedback_finishedPtr
newCallback_PatcherFeedback_finished(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_PatcherFeedback_finished<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::PatcherFeedback::begin_finished.
 */
template<class T, typename CT> Callback_PatcherFeedback_finishedPtr
newCallback_PatcherFeedback_finished(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_PatcherFeedback_finished<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::PatcherFeedback::begin_finished.
 */
template<class T, typename CT> Callback_PatcherFeedback_finishedPtr
newCallback_PatcherFeedback_finished(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_PatcherFeedback_finished<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::PatcherFeedback::begin_finished.
 */
template<class T, typename CT> Callback_PatcherFeedback_finishedPtr
newCallback_PatcherFeedback_finished(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_PatcherFeedback_finished<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::PatcherFeedback::begin_failed.
 * Create a wrapper instance by calling ::IceGrid::newCallback_PatcherFeedback_failed.
 */
template<class T>
class CallbackNC_PatcherFeedback_failed : public Callback_PatcherFeedback_failed_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_PatcherFeedback_failed(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::PatcherFeedback::begin_failed.
 */
template<class T> Callback_PatcherFeedback_failedPtr
newCallback_PatcherFeedback_failed(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_PatcherFeedback_failed<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::PatcherFeedback::begin_failed.
 */
template<class T> Callback_PatcherFeedback_failedPtr
newCallback_PatcherFeedback_failed(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_PatcherFeedback_failed<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::PatcherFeedback::begin_failed.
 */
template<class T> Callback_PatcherFeedback_failedPtr
newCallback_PatcherFeedback_failed(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_PatcherFeedback_failed<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::PatcherFeedback::begin_failed.
 */
template<class T> Callback_PatcherFeedback_failedPtr
newCallback_PatcherFeedback_failed(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_PatcherFeedback_failed<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::PatcherFeedback::begin_failed.
 * Create a wrapper instance by calling ::IceGrid::newCallback_PatcherFeedback_failed.
 */
template<class T, typename CT>
class Callback_PatcherFeedback_failed : public Callback_PatcherFeedback_failed_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_PatcherFeedback_failed(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::PatcherFeedback::begin_failed.
 */
template<class T, typename CT> Callback_PatcherFeedback_failedPtr
newCallback_PatcherFeedback_failed(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_PatcherFeedback_failed<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::PatcherFeedback::begin_failed.
 */
template<class T, typename CT> Callback_PatcherFeedback_failedPtr
newCallback_PatcherFeedback_failed(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_PatcherFeedback_failed<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::PatcherFeedback::begin_failed.
 */
template<class T, typename CT> Callback_PatcherFeedback_failedPtr
newCallback_PatcherFeedback_failed(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_PatcherFeedback_failed<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::PatcherFeedback::begin_failed.
 */
template<class T, typename CT> Callback_PatcherFeedback_failedPtr
newCallback_PatcherFeedback_failed(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_PatcherFeedback_failed<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Node::begin_loadServer.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_loadServer.
 */
template<class T>
class CallbackNC_Node_loadServer : public Callback_Node_loadServer_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ServerPrx&, const AdapterPrxDict&, ::Ice::Int, ::Ice::Int);

    CallbackNC_Node_loadServer(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        AdapterPrxDict iceP_adapters;
        ::Ice::Int iceP_actTimeout;
        ::Ice::Int iceP_deactTimeout;
        ServerPrx ret;
        try
        {
            ret = proxy->end_loadServer(iceP_adapters, iceP_actTimeout, iceP_deactTimeout, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret, iceP_adapters, iceP_actTimeout, iceP_deactTimeout);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_loadServer.
 */
template<class T> Callback_Node_loadServerPtr
newCallback_Node_loadServer(const IceUtil::Handle<T>& instance, void (T::*cb)(const ServerPrx&, const AdapterPrxDict&, ::Ice::Int, ::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_loadServer<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_loadServer.
 */
template<class T> Callback_Node_loadServerPtr
newCallback_Node_loadServer(T* instance, void (T::*cb)(const ServerPrx&, const AdapterPrxDict&, ::Ice::Int, ::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_loadServer<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Node::begin_loadServer.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_loadServer.
 */
template<class T, typename CT>
class Callback_Node_loadServer : public Callback_Node_loadServer_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ServerPrx&, const AdapterPrxDict&, ::Ice::Int, ::Ice::Int, const CT&);

    Callback_Node_loadServer(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        AdapterPrxDict iceP_adapters;
        ::Ice::Int iceP_actTimeout;
        ::Ice::Int iceP_deactTimeout;
        ServerPrx ret;
        try
        {
            ret = proxy->end_loadServer(iceP_adapters, iceP_actTimeout, iceP_deactTimeout, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, iceP_adapters, iceP_actTimeout, iceP_deactTimeout, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_loadServer.
 */
template<class T, typename CT> Callback_Node_loadServerPtr
newCallback_Node_loadServer(const IceUtil::Handle<T>& instance, void (T::*cb)(const ServerPrx&, const AdapterPrxDict&, ::Ice::Int, ::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_loadServer<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_loadServer.
 */
template<class T, typename CT> Callback_Node_loadServerPtr
newCallback_Node_loadServer(T* instance, void (T::*cb)(const ServerPrx&, const AdapterPrxDict&, ::Ice::Int, ::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_loadServer<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Node::begin_loadServerWithoutRestart.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_loadServerWithoutRestart.
 */
template<class T>
class CallbackNC_Node_loadServerWithoutRestart : public Callback_Node_loadServerWithoutRestart_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ServerPrx&, const AdapterPrxDict&, ::Ice::Int, ::Ice::Int);

    CallbackNC_Node_loadServerWithoutRestart(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        AdapterPrxDict iceP_adapters;
        ::Ice::Int iceP_actTimeout;
        ::Ice::Int iceP_deactTimeout;
        ServerPrx ret;
        try
        {
            ret = proxy->end_loadServerWithoutRestart(iceP_adapters, iceP_actTimeout, iceP_deactTimeout, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret, iceP_adapters, iceP_actTimeout, iceP_deactTimeout);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_loadServerWithoutRestart.
 */
template<class T> Callback_Node_loadServerWithoutRestartPtr
newCallback_Node_loadServerWithoutRestart(const IceUtil::Handle<T>& instance, void (T::*cb)(const ServerPrx&, const AdapterPrxDict&, ::Ice::Int, ::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_loadServerWithoutRestart<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_loadServerWithoutRestart.
 */
template<class T> Callback_Node_loadServerWithoutRestartPtr
newCallback_Node_loadServerWithoutRestart(T* instance, void (T::*cb)(const ServerPrx&, const AdapterPrxDict&, ::Ice::Int, ::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_loadServerWithoutRestart<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Node::begin_loadServerWithoutRestart.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_loadServerWithoutRestart.
 */
template<class T, typename CT>
class Callback_Node_loadServerWithoutRestart : public Callback_Node_loadServerWithoutRestart_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ServerPrx&, const AdapterPrxDict&, ::Ice::Int, ::Ice::Int, const CT&);

    Callback_Node_loadServerWithoutRestart(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        AdapterPrxDict iceP_adapters;
        ::Ice::Int iceP_actTimeout;
        ::Ice::Int iceP_deactTimeout;
        ServerPrx ret;
        try
        {
            ret = proxy->end_loadServerWithoutRestart(iceP_adapters, iceP_actTimeout, iceP_deactTimeout, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, iceP_adapters, iceP_actTimeout, iceP_deactTimeout, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_loadServerWithoutRestart.
 */
template<class T, typename CT> Callback_Node_loadServerWithoutRestartPtr
newCallback_Node_loadServerWithoutRestart(const IceUtil::Handle<T>& instance, void (T::*cb)(const ServerPrx&, const AdapterPrxDict&, ::Ice::Int, ::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_loadServerWithoutRestart<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_loadServerWithoutRestart.
 */
template<class T, typename CT> Callback_Node_loadServerWithoutRestartPtr
newCallback_Node_loadServerWithoutRestart(T* instance, void (T::*cb)(const ServerPrx&, const AdapterPrxDict&, ::Ice::Int, ::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_loadServerWithoutRestart<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Node::begin_destroyServer.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_destroyServer.
 */
template<class T>
class CallbackNC_Node_destroyServer : public Callback_Node_destroyServer_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Node_destroyServer(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_destroyServer(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_destroyServer.
 */
template<class T> Callback_Node_destroyServerPtr
newCallback_Node_destroyServer(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_destroyServer<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_destroyServer.
 */
template<class T> Callback_Node_destroyServerPtr
newCallback_Node_destroyServer(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_destroyServer<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_destroyServer.
 */
template<class T> Callback_Node_destroyServerPtr
newCallback_Node_destroyServer(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_destroyServer<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_destroyServer.
 */
template<class T> Callback_Node_destroyServerPtr
newCallback_Node_destroyServer(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_destroyServer<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Node::begin_destroyServer.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_destroyServer.
 */
template<class T, typename CT>
class Callback_Node_destroyServer : public Callback_Node_destroyServer_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Node_destroyServer(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_destroyServer(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_destroyServer.
 */
template<class T, typename CT> Callback_Node_destroyServerPtr
newCallback_Node_destroyServer(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_destroyServer<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_destroyServer.
 */
template<class T, typename CT> Callback_Node_destroyServerPtr
newCallback_Node_destroyServer(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_destroyServer<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_destroyServer.
 */
template<class T, typename CT> Callback_Node_destroyServerPtr
newCallback_Node_destroyServer(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_destroyServer<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_destroyServer.
 */
template<class T, typename CT> Callback_Node_destroyServerPtr
newCallback_Node_destroyServer(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_destroyServer<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Node::begin_destroyServerWithoutRestart.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_destroyServerWithoutRestart.
 */
template<class T>
class CallbackNC_Node_destroyServerWithoutRestart : public Callback_Node_destroyServerWithoutRestart_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Node_destroyServerWithoutRestart(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_destroyServerWithoutRestart(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_destroyServerWithoutRestart.
 */
template<class T> Callback_Node_destroyServerWithoutRestartPtr
newCallback_Node_destroyServerWithoutRestart(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_destroyServerWithoutRestart<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_destroyServerWithoutRestart.
 */
template<class T> Callback_Node_destroyServerWithoutRestartPtr
newCallback_Node_destroyServerWithoutRestart(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_destroyServerWithoutRestart<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_destroyServerWithoutRestart.
 */
template<class T> Callback_Node_destroyServerWithoutRestartPtr
newCallback_Node_destroyServerWithoutRestart(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_destroyServerWithoutRestart<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_destroyServerWithoutRestart.
 */
template<class T> Callback_Node_destroyServerWithoutRestartPtr
newCallback_Node_destroyServerWithoutRestart(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_destroyServerWithoutRestart<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Node::begin_destroyServerWithoutRestart.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_destroyServerWithoutRestart.
 */
template<class T, typename CT>
class Callback_Node_destroyServerWithoutRestart : public Callback_Node_destroyServerWithoutRestart_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Node_destroyServerWithoutRestart(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_destroyServerWithoutRestart(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_destroyServerWithoutRestart.
 */
template<class T, typename CT> Callback_Node_destroyServerWithoutRestartPtr
newCallback_Node_destroyServerWithoutRestart(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_destroyServerWithoutRestart<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_destroyServerWithoutRestart.
 */
template<class T, typename CT> Callback_Node_destroyServerWithoutRestartPtr
newCallback_Node_destroyServerWithoutRestart(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_destroyServerWithoutRestart<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_destroyServerWithoutRestart.
 */
template<class T, typename CT> Callback_Node_destroyServerWithoutRestartPtr
newCallback_Node_destroyServerWithoutRestart(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_destroyServerWithoutRestart<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_destroyServerWithoutRestart.
 */
template<class T, typename CT> Callback_Node_destroyServerWithoutRestartPtr
newCallback_Node_destroyServerWithoutRestart(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_destroyServerWithoutRestart<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Node::begin_patch.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_patch.
 */
template<class T>
class CallbackNC_Node_patch : public Callback_Node_patch_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Node_patch(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_patch.
 */
template<class T> Callback_Node_patchPtr
newCallback_Node_patch(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_patch<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_patch.
 */
template<class T> Callback_Node_patchPtr
newCallback_Node_patch(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_patch<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_patch.
 */
template<class T> Callback_Node_patchPtr
newCallback_Node_patch(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_patch<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_patch.
 */
template<class T> Callback_Node_patchPtr
newCallback_Node_patch(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_patch<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Node::begin_patch.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_patch.
 */
template<class T, typename CT>
class Callback_Node_patch : public Callback_Node_patch_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Node_patch(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_patch.
 */
template<class T, typename CT> Callback_Node_patchPtr
newCallback_Node_patch(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_patch<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_patch.
 */
template<class T, typename CT> Callback_Node_patchPtr
newCallback_Node_patch(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_patch<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_patch.
 */
template<class T, typename CT> Callback_Node_patchPtr
newCallback_Node_patch(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_patch<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_patch.
 */
template<class T, typename CT> Callback_Node_patchPtr
newCallback_Node_patch(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_patch<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Node::begin_registerWithReplica.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_registerWithReplica.
 */
template<class T>
class CallbackNC_Node_registerWithReplica : public Callback_Node_registerWithReplica_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Node_registerWithReplica(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_registerWithReplica.
 */
template<class T> Callback_Node_registerWithReplicaPtr
newCallback_Node_registerWithReplica(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_registerWithReplica<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_registerWithReplica.
 */
template<class T> Callback_Node_registerWithReplicaPtr
newCallback_Node_registerWithReplica(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_registerWithReplica<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_registerWithReplica.
 */
template<class T> Callback_Node_registerWithReplicaPtr
newCallback_Node_registerWithReplica(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_registerWithReplica<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_registerWithReplica.
 */
template<class T> Callback_Node_registerWithReplicaPtr
newCallback_Node_registerWithReplica(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_registerWithReplica<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Node::begin_registerWithReplica.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_registerWithReplica.
 */
template<class T, typename CT>
class Callback_Node_registerWithReplica : public Callback_Node_registerWithReplica_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Node_registerWithReplica(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_registerWithReplica.
 */
template<class T, typename CT> Callback_Node_registerWithReplicaPtr
newCallback_Node_registerWithReplica(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_registerWithReplica<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_registerWithReplica.
 */
template<class T, typename CT> Callback_Node_registerWithReplicaPtr
newCallback_Node_registerWithReplica(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_registerWithReplica<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_registerWithReplica.
 */
template<class T, typename CT> Callback_Node_registerWithReplicaPtr
newCallback_Node_registerWithReplica(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_registerWithReplica<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_registerWithReplica.
 */
template<class T, typename CT> Callback_Node_registerWithReplicaPtr
newCallback_Node_registerWithReplica(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_registerWithReplica<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Node::begin_getName.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_getName.
 */
template<class T>
class CallbackNC_Node_getName : public Callback_Node_getName_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::std::string&);

    CallbackNC_Node_getName(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getName(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_getName.
 */
template<class T> Callback_Node_getNamePtr
newCallback_Node_getName(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_getName<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_getName.
 */
template<class T> Callback_Node_getNamePtr
newCallback_Node_getName(T* instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_getName<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Node::begin_getName.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_getName.
 */
template<class T, typename CT>
class Callback_Node_getName : public Callback_Node_getName_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::std::string&, const CT&);

    Callback_Node_getName(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getName(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_getName.
 */
template<class T, typename CT> Callback_Node_getNamePtr
newCallback_Node_getName(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_getName<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_getName.
 */
template<class T, typename CT> Callback_Node_getNamePtr
newCallback_Node_getName(T* instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_getName<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Node::begin_getHostname.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_getHostname.
 */
template<class T>
class CallbackNC_Node_getHostname : public Callback_Node_getHostname_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::std::string&);

    CallbackNC_Node_getHostname(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getHostname(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_getHostname.
 */
template<class T> Callback_Node_getHostnamePtr
newCallback_Node_getHostname(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_getHostname<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_getHostname.
 */
template<class T> Callback_Node_getHostnamePtr
newCallback_Node_getHostname(T* instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_getHostname<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Node::begin_getHostname.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_getHostname.
 */
template<class T, typename CT>
class Callback_Node_getHostname : public Callback_Node_getHostname_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::std::string&, const CT&);

    Callback_Node_getHostname(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getHostname(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_getHostname.
 */
template<class T, typename CT> Callback_Node_getHostnamePtr
newCallback_Node_getHostname(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_getHostname<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_getHostname.
 */
template<class T, typename CT> Callback_Node_getHostnamePtr
newCallback_Node_getHostname(T* instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_getHostname<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Node::begin_getLoad.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_getLoad.
 */
template<class T>
class CallbackNC_Node_getLoad : public Callback_Node_getLoad_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const LoadInfo&);

    CallbackNC_Node_getLoad(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        LoadInfo ret;
        try
        {
            ret = proxy->end_getLoad(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_getLoad.
 */
template<class T> Callback_Node_getLoadPtr
newCallback_Node_getLoad(const IceUtil::Handle<T>& instance, void (T::*cb)(const LoadInfo&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_getLoad<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_getLoad.
 */
template<class T> Callback_Node_getLoadPtr
newCallback_Node_getLoad(T* instance, void (T::*cb)(const LoadInfo&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_getLoad<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Node::begin_getLoad.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_getLoad.
 */
template<class T, typename CT>
class Callback_Node_getLoad : public Callback_Node_getLoad_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const LoadInfo&, const CT&);

    Callback_Node_getLoad(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        LoadInfo ret;
        try
        {
            ret = proxy->end_getLoad(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_getLoad.
 */
template<class T, typename CT> Callback_Node_getLoadPtr
newCallback_Node_getLoad(const IceUtil::Handle<T>& instance, void (T::*cb)(const LoadInfo&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_getLoad<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_getLoad.
 */
template<class T, typename CT> Callback_Node_getLoadPtr
newCallback_Node_getLoad(T* instance, void (T::*cb)(const LoadInfo&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_getLoad<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Node::begin_getProcessorSocketCount.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_getProcessorSocketCount.
 */
template<class T>
class CallbackNC_Node_getProcessorSocketCount : public Callback_Node_getProcessorSocketCount_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(::Ice::Int);

    CallbackNC_Node_getProcessorSocketCount(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getProcessorSocketCount(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_getProcessorSocketCount.
 */
template<class T> Callback_Node_getProcessorSocketCountPtr
newCallback_Node_getProcessorSocketCount(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_getProcessorSocketCount<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_getProcessorSocketCount.
 */
template<class T> Callback_Node_getProcessorSocketCountPtr
newCallback_Node_getProcessorSocketCount(T* instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_getProcessorSocketCount<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Node::begin_getProcessorSocketCount.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_getProcessorSocketCount.
 */
template<class T, typename CT>
class Callback_Node_getProcessorSocketCount : public Callback_Node_getProcessorSocketCount_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(::Ice::Int, const CT&);

    Callback_Node_getProcessorSocketCount(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodePrx proxy = NodePrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getProcessorSocketCount(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_getProcessorSocketCount.
 */
template<class T, typename CT> Callback_Node_getProcessorSocketCountPtr
newCallback_Node_getProcessorSocketCount(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_getProcessorSocketCount<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_getProcessorSocketCount.
 */
template<class T, typename CT> Callback_Node_getProcessorSocketCountPtr
newCallback_Node_getProcessorSocketCount(T* instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_getProcessorSocketCount<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Node::begin_shutdown.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_shutdown.
 */
template<class T>
class CallbackNC_Node_shutdown : public Callback_Node_shutdown_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Node_shutdown(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_shutdown.
 */
template<class T> Callback_Node_shutdownPtr
newCallback_Node_shutdown(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_shutdown<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_shutdown.
 */
template<class T> Callback_Node_shutdownPtr
newCallback_Node_shutdown(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_shutdown<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_shutdown.
 */
template<class T> Callback_Node_shutdownPtr
newCallback_Node_shutdown(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_shutdown<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_shutdown.
 */
template<class T> Callback_Node_shutdownPtr
newCallback_Node_shutdown(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Node_shutdown<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Node::begin_shutdown.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Node_shutdown.
 */
template<class T, typename CT>
class Callback_Node_shutdown : public Callback_Node_shutdown_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Node_shutdown(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_shutdown.
 */
template<class T, typename CT> Callback_Node_shutdownPtr
newCallback_Node_shutdown(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_shutdown<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_shutdown.
 */
template<class T, typename CT> Callback_Node_shutdownPtr
newCallback_Node_shutdown(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_shutdown<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_shutdown.
 */
template<class T, typename CT> Callback_Node_shutdownPtr
newCallback_Node_shutdown(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_shutdown<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Node::begin_shutdown.
 */
template<class T, typename CT> Callback_Node_shutdownPtr
newCallback_Node_shutdown(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Node_shutdown<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::NodeSession::begin_keepAlive.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_keepAlive.
 */
template<class T>
class CallbackNC_NodeSession_keepAlive : public Callback_NodeSession_keepAlive_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_NodeSession_keepAlive(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_keepAlive.
 */
template<class T> Callback_NodeSession_keepAlivePtr
newCallback_NodeSession_keepAlive(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_keepAlive<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_keepAlive.
 */
template<class T> Callback_NodeSession_keepAlivePtr
newCallback_NodeSession_keepAlive(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_keepAlive<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_keepAlive.
 */
template<class T> Callback_NodeSession_keepAlivePtr
newCallback_NodeSession_keepAlive(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_keepAlive<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_keepAlive.
 */
template<class T> Callback_NodeSession_keepAlivePtr
newCallback_NodeSession_keepAlive(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_keepAlive<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::NodeSession::begin_keepAlive.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_keepAlive.
 */
template<class T, typename CT>
class Callback_NodeSession_keepAlive : public Callback_NodeSession_keepAlive_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_NodeSession_keepAlive(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_keepAlive.
 */
template<class T, typename CT> Callback_NodeSession_keepAlivePtr
newCallback_NodeSession_keepAlive(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_keepAlive<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_keepAlive.
 */
template<class T, typename CT> Callback_NodeSession_keepAlivePtr
newCallback_NodeSession_keepAlive(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_keepAlive<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_keepAlive.
 */
template<class T, typename CT> Callback_NodeSession_keepAlivePtr
newCallback_NodeSession_keepAlive(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_keepAlive<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_keepAlive.
 */
template<class T, typename CT> Callback_NodeSession_keepAlivePtr
newCallback_NodeSession_keepAlive(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_keepAlive<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::NodeSession::begin_setReplicaObserver.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_setReplicaObserver.
 */
template<class T>
class CallbackNC_NodeSession_setReplicaObserver : public Callback_NodeSession_setReplicaObserver_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_NodeSession_setReplicaObserver(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_setReplicaObserver.
 */
template<class T> Callback_NodeSession_setReplicaObserverPtr
newCallback_NodeSession_setReplicaObserver(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_setReplicaObserver<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_setReplicaObserver.
 */
template<class T> Callback_NodeSession_setReplicaObserverPtr
newCallback_NodeSession_setReplicaObserver(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_setReplicaObserver<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_setReplicaObserver.
 */
template<class T> Callback_NodeSession_setReplicaObserverPtr
newCallback_NodeSession_setReplicaObserver(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_setReplicaObserver<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_setReplicaObserver.
 */
template<class T> Callback_NodeSession_setReplicaObserverPtr
newCallback_NodeSession_setReplicaObserver(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_setReplicaObserver<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::NodeSession::begin_setReplicaObserver.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_setReplicaObserver.
 */
template<class T, typename CT>
class Callback_NodeSession_setReplicaObserver : public Callback_NodeSession_setReplicaObserver_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_NodeSession_setReplicaObserver(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_setReplicaObserver.
 */
template<class T, typename CT> Callback_NodeSession_setReplicaObserverPtr
newCallback_NodeSession_setReplicaObserver(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_setReplicaObserver<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_setReplicaObserver.
 */
template<class T, typename CT> Callback_NodeSession_setReplicaObserverPtr
newCallback_NodeSession_setReplicaObserver(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_setReplicaObserver<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_setReplicaObserver.
 */
template<class T, typename CT> Callback_NodeSession_setReplicaObserverPtr
newCallback_NodeSession_setReplicaObserver(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_setReplicaObserver<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_setReplicaObserver.
 */
template<class T, typename CT> Callback_NodeSession_setReplicaObserverPtr
newCallback_NodeSession_setReplicaObserver(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_setReplicaObserver<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::NodeSession::begin_getTimeout.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_getTimeout.
 */
template<class T>
class CallbackNC_NodeSession_getTimeout : public Callback_NodeSession_getTimeout_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(::Ice::Int);

    CallbackNC_NodeSession_getTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodeSessionPrx proxy = NodeSessionPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_getTimeout.
 */
template<class T> Callback_NodeSession_getTimeoutPtr
newCallback_NodeSession_getTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_getTimeout<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_getTimeout.
 */
template<class T> Callback_NodeSession_getTimeoutPtr
newCallback_NodeSession_getTimeout(T* instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_getTimeout<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::NodeSession::begin_getTimeout.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_getTimeout.
 */
template<class T, typename CT>
class Callback_NodeSession_getTimeout : public Callback_NodeSession_getTimeout_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(::Ice::Int, const CT&);

    Callback_NodeSession_getTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodeSessionPrx proxy = NodeSessionPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_getTimeout.
 */
template<class T, typename CT> Callback_NodeSession_getTimeoutPtr
newCallback_NodeSession_getTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_getTimeout<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_getTimeout.
 */
template<class T, typename CT> Callback_NodeSession_getTimeoutPtr
newCallback_NodeSession_getTimeout(T* instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_getTimeout<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::NodeSession::begin_getObserver.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_getObserver.
 */
template<class T>
class CallbackNC_NodeSession_getObserver : public Callback_NodeSession_getObserver_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const NodeObserverPrx&);

    CallbackNC_NodeSession_getObserver(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodeSessionPrx proxy = NodeSessionPrx::uncheckedCast(result->getProxy());
        NodeObserverPrx ret;
        try
        {
            ret = proxy->end_getObserver(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_getObserver.
 */
template<class T> Callback_NodeSession_getObserverPtr
newCallback_NodeSession_getObserver(const IceUtil::Handle<T>& instance, void (T::*cb)(const NodeObserverPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_getObserver<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_getObserver.
 */
template<class T> Callback_NodeSession_getObserverPtr
newCallback_NodeSession_getObserver(T* instance, void (T::*cb)(const NodeObserverPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_getObserver<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::NodeSession::begin_getObserver.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_getObserver.
 */
template<class T, typename CT>
class Callback_NodeSession_getObserver : public Callback_NodeSession_getObserver_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const NodeObserverPrx&, const CT&);

    Callback_NodeSession_getObserver(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodeSessionPrx proxy = NodeSessionPrx::uncheckedCast(result->getProxy());
        NodeObserverPrx ret;
        try
        {
            ret = proxy->end_getObserver(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_getObserver.
 */
template<class T, typename CT> Callback_NodeSession_getObserverPtr
newCallback_NodeSession_getObserver(const IceUtil::Handle<T>& instance, void (T::*cb)(const NodeObserverPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_getObserver<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_getObserver.
 */
template<class T, typename CT> Callback_NodeSession_getObserverPtr
newCallback_NodeSession_getObserver(T* instance, void (T::*cb)(const NodeObserverPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_getObserver<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::NodeSession::begin_loadServers.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_loadServers.
 */
template<class T>
class CallbackNC_NodeSession_loadServers : public Callback_NodeSession_loadServers_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_NodeSession_loadServers(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_loadServers.
 */
template<class T> Callback_NodeSession_loadServersPtr
newCallback_NodeSession_loadServers(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_loadServers<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_loadServers.
 */
template<class T> Callback_NodeSession_loadServersPtr
newCallback_NodeSession_loadServers(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_loadServers<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_loadServers.
 */
template<class T> Callback_NodeSession_loadServersPtr
newCallback_NodeSession_loadServers(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_loadServers<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_loadServers.
 */
template<class T> Callback_NodeSession_loadServersPtr
newCallback_NodeSession_loadServers(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_loadServers<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::NodeSession::begin_loadServers.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_loadServers.
 */
template<class T, typename CT>
class Callback_NodeSession_loadServers : public Callback_NodeSession_loadServers_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_NodeSession_loadServers(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_loadServers.
 */
template<class T, typename CT> Callback_NodeSession_loadServersPtr
newCallback_NodeSession_loadServers(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_loadServers<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_loadServers.
 */
template<class T, typename CT> Callback_NodeSession_loadServersPtr
newCallback_NodeSession_loadServers(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_loadServers<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_loadServers.
 */
template<class T, typename CT> Callback_NodeSession_loadServersPtr
newCallback_NodeSession_loadServers(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_loadServers<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_loadServers.
 */
template<class T, typename CT> Callback_NodeSession_loadServersPtr
newCallback_NodeSession_loadServers(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_loadServers<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::NodeSession::begin_getServers.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_getServers.
 */
template<class T>
class CallbackNC_NodeSession_getServers : public Callback_NodeSession_getServers_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::StringSeq&);

    CallbackNC_NodeSession_getServers(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodeSessionPrx proxy = NodeSessionPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq ret;
        try
        {
            ret = proxy->end_getServers(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_getServers.
 */
template<class T> Callback_NodeSession_getServersPtr
newCallback_NodeSession_getServers(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_getServers<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_getServers.
 */
template<class T> Callback_NodeSession_getServersPtr
newCallback_NodeSession_getServers(T* instance, void (T::*cb)(const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_getServers<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::NodeSession::begin_getServers.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_getServers.
 */
template<class T, typename CT>
class Callback_NodeSession_getServers : public Callback_NodeSession_getServers_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::StringSeq&, const CT&);

    Callback_NodeSession_getServers(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        NodeSessionPrx proxy = NodeSessionPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq ret;
        try
        {
            ret = proxy->end_getServers(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_getServers.
 */
template<class T, typename CT> Callback_NodeSession_getServersPtr
newCallback_NodeSession_getServers(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_getServers<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_getServers.
 */
template<class T, typename CT> Callback_NodeSession_getServersPtr
newCallback_NodeSession_getServers(T* instance, void (T::*cb)(const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_getServers<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::NodeSession::begin_waitForApplicationUpdate.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_waitForApplicationUpdate.
 */
template<class T>
class CallbackNC_NodeSession_waitForApplicationUpdate : public Callback_NodeSession_waitForApplicationUpdate_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_NodeSession_waitForApplicationUpdate(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_waitForApplicationUpdate.
 */
template<class T> Callback_NodeSession_waitForApplicationUpdatePtr
newCallback_NodeSession_waitForApplicationUpdate(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_waitForApplicationUpdate<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_waitForApplicationUpdate.
 */
template<class T> Callback_NodeSession_waitForApplicationUpdatePtr
newCallback_NodeSession_waitForApplicationUpdate(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_waitForApplicationUpdate<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_waitForApplicationUpdate.
 */
template<class T> Callback_NodeSession_waitForApplicationUpdatePtr
newCallback_NodeSession_waitForApplicationUpdate(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_waitForApplicationUpdate<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_waitForApplicationUpdate.
 */
template<class T> Callback_NodeSession_waitForApplicationUpdatePtr
newCallback_NodeSession_waitForApplicationUpdate(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_waitForApplicationUpdate<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::NodeSession::begin_waitForApplicationUpdate.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_waitForApplicationUpdate.
 */
template<class T, typename CT>
class Callback_NodeSession_waitForApplicationUpdate : public Callback_NodeSession_waitForApplicationUpdate_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_NodeSession_waitForApplicationUpdate(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_waitForApplicationUpdate.
 */
template<class T, typename CT> Callback_NodeSession_waitForApplicationUpdatePtr
newCallback_NodeSession_waitForApplicationUpdate(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_waitForApplicationUpdate<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_waitForApplicationUpdate.
 */
template<class T, typename CT> Callback_NodeSession_waitForApplicationUpdatePtr
newCallback_NodeSession_waitForApplicationUpdate(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_waitForApplicationUpdate<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_waitForApplicationUpdate.
 */
template<class T, typename CT> Callback_NodeSession_waitForApplicationUpdatePtr
newCallback_NodeSession_waitForApplicationUpdate(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_waitForApplicationUpdate<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_waitForApplicationUpdate.
 */
template<class T, typename CT> Callback_NodeSession_waitForApplicationUpdatePtr
newCallback_NodeSession_waitForApplicationUpdate(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_waitForApplicationUpdate<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::NodeSession::begin_destroy.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_destroy.
 */
template<class T>
class CallbackNC_NodeSession_destroy : public Callback_NodeSession_destroy_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_NodeSession_destroy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_destroy.
 */
template<class T> Callback_NodeSession_destroyPtr
newCallback_NodeSession_destroy(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_destroy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_destroy.
 */
template<class T> Callback_NodeSession_destroyPtr
newCallback_NodeSession_destroy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_destroy<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_destroy.
 */
template<class T> Callback_NodeSession_destroyPtr
newCallback_NodeSession_destroy(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_destroy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_destroy.
 */
template<class T> Callback_NodeSession_destroyPtr
newCallback_NodeSession_destroy(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeSession_destroy<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::NodeSession::begin_destroy.
 * Create a wrapper instance by calling ::IceGrid::newCallback_NodeSession_destroy.
 */
template<class T, typename CT>
class Callback_NodeSession_destroy : public Callback_NodeSession_destroy_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_NodeSession_destroy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_destroy.
 */
template<class T, typename CT> Callback_NodeSession_destroyPtr
newCallback_NodeSession_destroy(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_destroy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_destroy.
 */
template<class T, typename CT> Callback_NodeSession_destroyPtr
newCallback_NodeSession_destroy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_destroy<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_destroy.
 */
template<class T, typename CT> Callback_NodeSession_destroyPtr
newCallback_NodeSession_destroy(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_destroy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::NodeSession::begin_destroy.
 */
template<class T, typename CT> Callback_NodeSession_destroyPtr
newCallback_NodeSession_destroy(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeSession_destroy<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_keepAlive.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_keepAlive.
 */
template<class T>
class CallbackNC_ReplicaSession_keepAlive : public Callback_ReplicaSession_keepAlive_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ReplicaSession_keepAlive(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_keepAlive.
 */
template<class T> Callback_ReplicaSession_keepAlivePtr
newCallback_ReplicaSession_keepAlive(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_keepAlive<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_keepAlive.
 */
template<class T> Callback_ReplicaSession_keepAlivePtr
newCallback_ReplicaSession_keepAlive(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_keepAlive<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_keepAlive.
 */
template<class T> Callback_ReplicaSession_keepAlivePtr
newCallback_ReplicaSession_keepAlive(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_keepAlive<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_keepAlive.
 */
template<class T> Callback_ReplicaSession_keepAlivePtr
newCallback_ReplicaSession_keepAlive(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_keepAlive<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_keepAlive.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_keepAlive.
 */
template<class T, typename CT>
class Callback_ReplicaSession_keepAlive : public Callback_ReplicaSession_keepAlive_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ReplicaSession_keepAlive(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_keepAlive.
 */
template<class T, typename CT> Callback_ReplicaSession_keepAlivePtr
newCallback_ReplicaSession_keepAlive(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_keepAlive<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_keepAlive.
 */
template<class T, typename CT> Callback_ReplicaSession_keepAlivePtr
newCallback_ReplicaSession_keepAlive(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_keepAlive<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_keepAlive.
 */
template<class T, typename CT> Callback_ReplicaSession_keepAlivePtr
newCallback_ReplicaSession_keepAlive(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_keepAlive<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_keepAlive.
 */
template<class T, typename CT> Callback_ReplicaSession_keepAlivePtr
newCallback_ReplicaSession_keepAlive(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_keepAlive<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_getTimeout.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_getTimeout.
 */
template<class T>
class CallbackNC_ReplicaSession_getTimeout : public Callback_ReplicaSession_getTimeout_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(::Ice::Int);

    CallbackNC_ReplicaSession_getTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ReplicaSessionPrx proxy = ReplicaSessionPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_getTimeout.
 */
template<class T> Callback_ReplicaSession_getTimeoutPtr
newCallback_ReplicaSession_getTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_getTimeout<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_getTimeout.
 */
template<class T> Callback_ReplicaSession_getTimeoutPtr
newCallback_ReplicaSession_getTimeout(T* instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_getTimeout<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_getTimeout.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_getTimeout.
 */
template<class T, typename CT>
class Callback_ReplicaSession_getTimeout : public Callback_ReplicaSession_getTimeout_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(::Ice::Int, const CT&);

    Callback_ReplicaSession_getTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ReplicaSessionPrx proxy = ReplicaSessionPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_getTimeout.
 */
template<class T, typename CT> Callback_ReplicaSession_getTimeoutPtr
newCallback_ReplicaSession_getTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_getTimeout<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_getTimeout.
 */
template<class T, typename CT> Callback_ReplicaSession_getTimeoutPtr
newCallback_ReplicaSession_getTimeout(T* instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_getTimeout<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_setDatabaseObserver.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_setDatabaseObserver.
 */
template<class T>
class CallbackNC_ReplicaSession_setDatabaseObserver : public Callback_ReplicaSession_setDatabaseObserver_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ReplicaSession_setDatabaseObserver(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ReplicaSessionPrx proxy = ReplicaSessionPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_setDatabaseObserver(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setDatabaseObserver.
 */
template<class T> Callback_ReplicaSession_setDatabaseObserverPtr
newCallback_ReplicaSession_setDatabaseObserver(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_setDatabaseObserver<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setDatabaseObserver.
 */
template<class T> Callback_ReplicaSession_setDatabaseObserverPtr
newCallback_ReplicaSession_setDatabaseObserver(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_setDatabaseObserver<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setDatabaseObserver.
 */
template<class T> Callback_ReplicaSession_setDatabaseObserverPtr
newCallback_ReplicaSession_setDatabaseObserver(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_setDatabaseObserver<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setDatabaseObserver.
 */
template<class T> Callback_ReplicaSession_setDatabaseObserverPtr
newCallback_ReplicaSession_setDatabaseObserver(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_setDatabaseObserver<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_setDatabaseObserver.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_setDatabaseObserver.
 */
template<class T, typename CT>
class Callback_ReplicaSession_setDatabaseObserver : public Callback_ReplicaSession_setDatabaseObserver_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ReplicaSession_setDatabaseObserver(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ReplicaSessionPrx proxy = ReplicaSessionPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_setDatabaseObserver(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setDatabaseObserver.
 */
template<class T, typename CT> Callback_ReplicaSession_setDatabaseObserverPtr
newCallback_ReplicaSession_setDatabaseObserver(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_setDatabaseObserver<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setDatabaseObserver.
 */
template<class T, typename CT> Callback_ReplicaSession_setDatabaseObserverPtr
newCallback_ReplicaSession_setDatabaseObserver(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_setDatabaseObserver<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setDatabaseObserver.
 */
template<class T, typename CT> Callback_ReplicaSession_setDatabaseObserverPtr
newCallback_ReplicaSession_setDatabaseObserver(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_setDatabaseObserver<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setDatabaseObserver.
 */
template<class T, typename CT> Callback_ReplicaSession_setDatabaseObserverPtr
newCallback_ReplicaSession_setDatabaseObserver(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_setDatabaseObserver<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_setEndpoints.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_setEndpoints.
 */
template<class T>
class CallbackNC_ReplicaSession_setEndpoints : public Callback_ReplicaSession_setEndpoints_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ReplicaSession_setEndpoints(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setEndpoints.
 */
template<class T> Callback_ReplicaSession_setEndpointsPtr
newCallback_ReplicaSession_setEndpoints(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_setEndpoints<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setEndpoints.
 */
template<class T> Callback_ReplicaSession_setEndpointsPtr
newCallback_ReplicaSession_setEndpoints(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_setEndpoints<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setEndpoints.
 */
template<class T> Callback_ReplicaSession_setEndpointsPtr
newCallback_ReplicaSession_setEndpoints(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_setEndpoints<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setEndpoints.
 */
template<class T> Callback_ReplicaSession_setEndpointsPtr
newCallback_ReplicaSession_setEndpoints(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_setEndpoints<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_setEndpoints.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_setEndpoints.
 */
template<class T, typename CT>
class Callback_ReplicaSession_setEndpoints : public Callback_ReplicaSession_setEndpoints_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ReplicaSession_setEndpoints(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setEndpoints.
 */
template<class T, typename CT> Callback_ReplicaSession_setEndpointsPtr
newCallback_ReplicaSession_setEndpoints(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_setEndpoints<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setEndpoints.
 */
template<class T, typename CT> Callback_ReplicaSession_setEndpointsPtr
newCallback_ReplicaSession_setEndpoints(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_setEndpoints<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setEndpoints.
 */
template<class T, typename CT> Callback_ReplicaSession_setEndpointsPtr
newCallback_ReplicaSession_setEndpoints(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_setEndpoints<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setEndpoints.
 */
template<class T, typename CT> Callback_ReplicaSession_setEndpointsPtr
newCallback_ReplicaSession_setEndpoints(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_setEndpoints<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_registerWellKnownObjects.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_registerWellKnownObjects.
 */
template<class T>
class CallbackNC_ReplicaSession_registerWellKnownObjects : public Callback_ReplicaSession_registerWellKnownObjects_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ReplicaSession_registerWellKnownObjects(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_registerWellKnownObjects.
 */
template<class T> Callback_ReplicaSession_registerWellKnownObjectsPtr
newCallback_ReplicaSession_registerWellKnownObjects(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_registerWellKnownObjects<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_registerWellKnownObjects.
 */
template<class T> Callback_ReplicaSession_registerWellKnownObjectsPtr
newCallback_ReplicaSession_registerWellKnownObjects(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_registerWellKnownObjects<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_registerWellKnownObjects.
 */
template<class T> Callback_ReplicaSession_registerWellKnownObjectsPtr
newCallback_ReplicaSession_registerWellKnownObjects(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_registerWellKnownObjects<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_registerWellKnownObjects.
 */
template<class T> Callback_ReplicaSession_registerWellKnownObjectsPtr
newCallback_ReplicaSession_registerWellKnownObjects(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_registerWellKnownObjects<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_registerWellKnownObjects.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_registerWellKnownObjects.
 */
template<class T, typename CT>
class Callback_ReplicaSession_registerWellKnownObjects : public Callback_ReplicaSession_registerWellKnownObjects_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ReplicaSession_registerWellKnownObjects(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_registerWellKnownObjects.
 */
template<class T, typename CT> Callback_ReplicaSession_registerWellKnownObjectsPtr
newCallback_ReplicaSession_registerWellKnownObjects(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_registerWellKnownObjects<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_registerWellKnownObjects.
 */
template<class T, typename CT> Callback_ReplicaSession_registerWellKnownObjectsPtr
newCallback_ReplicaSession_registerWellKnownObjects(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_registerWellKnownObjects<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_registerWellKnownObjects.
 */
template<class T, typename CT> Callback_ReplicaSession_registerWellKnownObjectsPtr
newCallback_ReplicaSession_registerWellKnownObjects(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_registerWellKnownObjects<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_registerWellKnownObjects.
 */
template<class T, typename CT> Callback_ReplicaSession_registerWellKnownObjectsPtr
newCallback_ReplicaSession_registerWellKnownObjects(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_registerWellKnownObjects<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_setAdapterDirectProxy.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_setAdapterDirectProxy.
 */
template<class T>
class CallbackNC_ReplicaSession_setAdapterDirectProxy : public Callback_ReplicaSession_setAdapterDirectProxy_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ReplicaSession_setAdapterDirectProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ReplicaSessionPrx proxy = ReplicaSessionPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_setAdapterDirectProxy(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setAdapterDirectProxy.
 */
template<class T> Callback_ReplicaSession_setAdapterDirectProxyPtr
newCallback_ReplicaSession_setAdapterDirectProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_setAdapterDirectProxy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setAdapterDirectProxy.
 */
template<class T> Callback_ReplicaSession_setAdapterDirectProxyPtr
newCallback_ReplicaSession_setAdapterDirectProxy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_setAdapterDirectProxy<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setAdapterDirectProxy.
 */
template<class T> Callback_ReplicaSession_setAdapterDirectProxyPtr
newCallback_ReplicaSession_setAdapterDirectProxy(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_setAdapterDirectProxy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setAdapterDirectProxy.
 */
template<class T> Callback_ReplicaSession_setAdapterDirectProxyPtr
newCallback_ReplicaSession_setAdapterDirectProxy(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_setAdapterDirectProxy<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_setAdapterDirectProxy.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_setAdapterDirectProxy.
 */
template<class T, typename CT>
class Callback_ReplicaSession_setAdapterDirectProxy : public Callback_ReplicaSession_setAdapterDirectProxy_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ReplicaSession_setAdapterDirectProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ReplicaSessionPrx proxy = ReplicaSessionPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_setAdapterDirectProxy(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setAdapterDirectProxy.
 */
template<class T, typename CT> Callback_ReplicaSession_setAdapterDirectProxyPtr
newCallback_ReplicaSession_setAdapterDirectProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_setAdapterDirectProxy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setAdapterDirectProxy.
 */
template<class T, typename CT> Callback_ReplicaSession_setAdapterDirectProxyPtr
newCallback_ReplicaSession_setAdapterDirectProxy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_setAdapterDirectProxy<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setAdapterDirectProxy.
 */
template<class T, typename CT> Callback_ReplicaSession_setAdapterDirectProxyPtr
newCallback_ReplicaSession_setAdapterDirectProxy(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_setAdapterDirectProxy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_setAdapterDirectProxy.
 */
template<class T, typename CT> Callback_ReplicaSession_setAdapterDirectProxyPtr
newCallback_ReplicaSession_setAdapterDirectProxy(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_setAdapterDirectProxy<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_receivedUpdate.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_receivedUpdate.
 */
template<class T>
class CallbackNC_ReplicaSession_receivedUpdate : public Callback_ReplicaSession_receivedUpdate_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ReplicaSession_receivedUpdate(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_receivedUpdate.
 */
template<class T> Callback_ReplicaSession_receivedUpdatePtr
newCallback_ReplicaSession_receivedUpdate(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_receivedUpdate<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_receivedUpdate.
 */
template<class T> Callback_ReplicaSession_receivedUpdatePtr
newCallback_ReplicaSession_receivedUpdate(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_receivedUpdate<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_receivedUpdate.
 */
template<class T> Callback_ReplicaSession_receivedUpdatePtr
newCallback_ReplicaSession_receivedUpdate(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_receivedUpdate<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_receivedUpdate.
 */
template<class T> Callback_ReplicaSession_receivedUpdatePtr
newCallback_ReplicaSession_receivedUpdate(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_receivedUpdate<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_receivedUpdate.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_receivedUpdate.
 */
template<class T, typename CT>
class Callback_ReplicaSession_receivedUpdate : public Callback_ReplicaSession_receivedUpdate_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ReplicaSession_receivedUpdate(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_receivedUpdate.
 */
template<class T, typename CT> Callback_ReplicaSession_receivedUpdatePtr
newCallback_ReplicaSession_receivedUpdate(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_receivedUpdate<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_receivedUpdate.
 */
template<class T, typename CT> Callback_ReplicaSession_receivedUpdatePtr
newCallback_ReplicaSession_receivedUpdate(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_receivedUpdate<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_receivedUpdate.
 */
template<class T, typename CT> Callback_ReplicaSession_receivedUpdatePtr
newCallback_ReplicaSession_receivedUpdate(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_receivedUpdate<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_receivedUpdate.
 */
template<class T, typename CT> Callback_ReplicaSession_receivedUpdatePtr
newCallback_ReplicaSession_receivedUpdate(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_receivedUpdate<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_destroy.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_destroy.
 */
template<class T>
class CallbackNC_ReplicaSession_destroy : public Callback_ReplicaSession_destroy_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ReplicaSession_destroy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_destroy.
 */
template<class T> Callback_ReplicaSession_destroyPtr
newCallback_ReplicaSession_destroy(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_destroy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_destroy.
 */
template<class T> Callback_ReplicaSession_destroyPtr
newCallback_ReplicaSession_destroy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_destroy<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_destroy.
 */
template<class T> Callback_ReplicaSession_destroyPtr
newCallback_ReplicaSession_destroy(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_destroy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_destroy.
 */
template<class T> Callback_ReplicaSession_destroyPtr
newCallback_ReplicaSession_destroy(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ReplicaSession_destroy<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::ReplicaSession::begin_destroy.
 * Create a wrapper instance by calling ::IceGrid::newCallback_ReplicaSession_destroy.
 */
template<class T, typename CT>
class Callback_ReplicaSession_destroy : public Callback_ReplicaSession_destroy_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ReplicaSession_destroy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_destroy.
 */
template<class T, typename CT> Callback_ReplicaSession_destroyPtr
newCallback_ReplicaSession_destroy(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_destroy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_destroy.
 */
template<class T, typename CT> Callback_ReplicaSession_destroyPtr
newCallback_ReplicaSession_destroy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_destroy<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_destroy.
 */
template<class T, typename CT> Callback_ReplicaSession_destroyPtr
newCallback_ReplicaSession_destroy(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_destroy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::ReplicaSession::begin_destroy.
 */
template<class T, typename CT> Callback_ReplicaSession_destroyPtr
newCallback_ReplicaSession_destroy(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ReplicaSession_destroy<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_registerNode.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_registerNode.
 */
template<class T>
class CallbackNC_InternalRegistry_registerNode : public Callback_InternalRegistry_registerNode_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const NodeSessionPrx&);

    CallbackNC_InternalRegistry_registerNode(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        InternalRegistryPrx proxy = InternalRegistryPrx::uncheckedCast(result->getProxy());
        NodeSessionPrx ret;
        try
        {
            ret = proxy->end_registerNode(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_registerNode.
 */
template<class T> Callback_InternalRegistry_registerNodePtr
newCallback_InternalRegistry_registerNode(const IceUtil::Handle<T>& instance, void (T::*cb)(const NodeSessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_InternalRegistry_registerNode<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_registerNode.
 */
template<class T> Callback_InternalRegistry_registerNodePtr
newCallback_InternalRegistry_registerNode(T* instance, void (T::*cb)(const NodeSessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_InternalRegistry_registerNode<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_registerNode.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_registerNode.
 */
template<class T, typename CT>
class Callback_InternalRegistry_registerNode : public Callback_InternalRegistry_registerNode_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const NodeSessionPrx&, const CT&);

    Callback_InternalRegistry_registerNode(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        InternalRegistryPrx proxy = InternalRegistryPrx::uncheckedCast(result->getProxy());
        NodeSessionPrx ret;
        try
        {
            ret = proxy->end_registerNode(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_registerNode.
 */
template<class T, typename CT> Callback_InternalRegistry_registerNodePtr
newCallback_InternalRegistry_registerNode(const IceUtil::Handle<T>& instance, void (T::*cb)(const NodeSessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_InternalRegistry_registerNode<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_registerNode.
 */
template<class T, typename CT> Callback_InternalRegistry_registerNodePtr
newCallback_InternalRegistry_registerNode(T* instance, void (T::*cb)(const NodeSessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_InternalRegistry_registerNode<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_registerReplica.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_registerReplica.
 */
template<class T>
class CallbackNC_InternalRegistry_registerReplica : public Callback_InternalRegistry_registerReplica_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ReplicaSessionPrx&);

    CallbackNC_InternalRegistry_registerReplica(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        InternalRegistryPrx proxy = InternalRegistryPrx::uncheckedCast(result->getProxy());
        ReplicaSessionPrx ret;
        try
        {
            ret = proxy->end_registerReplica(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_registerReplica.
 */
template<class T> Callback_InternalRegistry_registerReplicaPtr
newCallback_InternalRegistry_registerReplica(const IceUtil::Handle<T>& instance, void (T::*cb)(const ReplicaSessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_InternalRegistry_registerReplica<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_registerReplica.
 */
template<class T> Callback_InternalRegistry_registerReplicaPtr
newCallback_InternalRegistry_registerReplica(T* instance, void (T::*cb)(const ReplicaSessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_InternalRegistry_registerReplica<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_registerReplica.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_registerReplica.
 */
template<class T, typename CT>
class Callback_InternalRegistry_registerReplica : public Callback_InternalRegistry_registerReplica_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ReplicaSessionPrx&, const CT&);

    Callback_InternalRegistry_registerReplica(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        InternalRegistryPrx proxy = InternalRegistryPrx::uncheckedCast(result->getProxy());
        ReplicaSessionPrx ret;
        try
        {
            ret = proxy->end_registerReplica(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_registerReplica.
 */
template<class T, typename CT> Callback_InternalRegistry_registerReplicaPtr
newCallback_InternalRegistry_registerReplica(const IceUtil::Handle<T>& instance, void (T::*cb)(const ReplicaSessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_InternalRegistry_registerReplica<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_registerReplica.
 */
template<class T, typename CT> Callback_InternalRegistry_registerReplicaPtr
newCallback_InternalRegistry_registerReplica(T* instance, void (T::*cb)(const ReplicaSessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_InternalRegistry_registerReplica<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_registerWithReplica.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_registerWithReplica.
 */
template<class T>
class CallbackNC_InternalRegistry_registerWithReplica : public Callback_InternalRegistry_registerWithReplica_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_InternalRegistry_registerWithReplica(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_registerWithReplica.
 */
template<class T> Callback_InternalRegistry_registerWithReplicaPtr
newCallback_InternalRegistry_registerWithReplica(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_InternalRegistry_registerWithReplica<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_registerWithReplica.
 */
template<class T> Callback_InternalRegistry_registerWithReplicaPtr
newCallback_InternalRegistry_registerWithReplica(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_InternalRegistry_registerWithReplica<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_registerWithReplica.
 */
template<class T> Callback_InternalRegistry_registerWithReplicaPtr
newCallback_InternalRegistry_registerWithReplica(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_InternalRegistry_registerWithReplica<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_registerWithReplica.
 */
template<class T> Callback_InternalRegistry_registerWithReplicaPtr
newCallback_InternalRegistry_registerWithReplica(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_InternalRegistry_registerWithReplica<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_registerWithReplica.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_registerWithReplica.
 */
template<class T, typename CT>
class Callback_InternalRegistry_registerWithReplica : public Callback_InternalRegistry_registerWithReplica_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_InternalRegistry_registerWithReplica(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_registerWithReplica.
 */
template<class T, typename CT> Callback_InternalRegistry_registerWithReplicaPtr
newCallback_InternalRegistry_registerWithReplica(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_InternalRegistry_registerWithReplica<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_registerWithReplica.
 */
template<class T, typename CT> Callback_InternalRegistry_registerWithReplicaPtr
newCallback_InternalRegistry_registerWithReplica(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_InternalRegistry_registerWithReplica<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_registerWithReplica.
 */
template<class T, typename CT> Callback_InternalRegistry_registerWithReplicaPtr
newCallback_InternalRegistry_registerWithReplica(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_InternalRegistry_registerWithReplica<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_registerWithReplica.
 */
template<class T, typename CT> Callback_InternalRegistry_registerWithReplicaPtr
newCallback_InternalRegistry_registerWithReplica(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_InternalRegistry_registerWithReplica<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_getNodes.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_getNodes.
 */
template<class T>
class CallbackNC_InternalRegistry_getNodes : public Callback_InternalRegistry_getNodes_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const NodePrxSeq&);

    CallbackNC_InternalRegistry_getNodes(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        InternalRegistryPrx proxy = InternalRegistryPrx::uncheckedCast(result->getProxy());
        NodePrxSeq ret;
        try
        {
            ret = proxy->end_getNodes(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_getNodes.
 */
template<class T> Callback_InternalRegistry_getNodesPtr
newCallback_InternalRegistry_getNodes(const IceUtil::Handle<T>& instance, void (T::*cb)(const NodePrxSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_InternalRegistry_getNodes<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_getNodes.
 */
template<class T> Callback_InternalRegistry_getNodesPtr
newCallback_InternalRegistry_getNodes(T* instance, void (T::*cb)(const NodePrxSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_InternalRegistry_getNodes<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_getNodes.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_getNodes.
 */
template<class T, typename CT>
class Callback_InternalRegistry_getNodes : public Callback_InternalRegistry_getNodes_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const NodePrxSeq&, const CT&);

    Callback_InternalRegistry_getNodes(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        InternalRegistryPrx proxy = InternalRegistryPrx::uncheckedCast(result->getProxy());
        NodePrxSeq ret;
        try
        {
            ret = proxy->end_getNodes(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_getNodes.
 */
template<class T, typename CT> Callback_InternalRegistry_getNodesPtr
newCallback_InternalRegistry_getNodes(const IceUtil::Handle<T>& instance, void (T::*cb)(const NodePrxSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_InternalRegistry_getNodes<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_getNodes.
 */
template<class T, typename CT> Callback_InternalRegistry_getNodesPtr
newCallback_InternalRegistry_getNodes(T* instance, void (T::*cb)(const NodePrxSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_InternalRegistry_getNodes<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_getReplicas.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_getReplicas.
 */
template<class T>
class CallbackNC_InternalRegistry_getReplicas : public Callback_InternalRegistry_getReplicas_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const InternalRegistryPrxSeq&);

    CallbackNC_InternalRegistry_getReplicas(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        InternalRegistryPrx proxy = InternalRegistryPrx::uncheckedCast(result->getProxy());
        InternalRegistryPrxSeq ret;
        try
        {
            ret = proxy->end_getReplicas(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_getReplicas.
 */
template<class T> Callback_InternalRegistry_getReplicasPtr
newCallback_InternalRegistry_getReplicas(const IceUtil::Handle<T>& instance, void (T::*cb)(const InternalRegistryPrxSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_InternalRegistry_getReplicas<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_getReplicas.
 */
template<class T> Callback_InternalRegistry_getReplicasPtr
newCallback_InternalRegistry_getReplicas(T* instance, void (T::*cb)(const InternalRegistryPrxSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_InternalRegistry_getReplicas<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_getReplicas.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_getReplicas.
 */
template<class T, typename CT>
class Callback_InternalRegistry_getReplicas : public Callback_InternalRegistry_getReplicas_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const InternalRegistryPrxSeq&, const CT&);

    Callback_InternalRegistry_getReplicas(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        InternalRegistryPrx proxy = InternalRegistryPrx::uncheckedCast(result->getProxy());
        InternalRegistryPrxSeq ret;
        try
        {
            ret = proxy->end_getReplicas(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_getReplicas.
 */
template<class T, typename CT> Callback_InternalRegistry_getReplicasPtr
newCallback_InternalRegistry_getReplicas(const IceUtil::Handle<T>& instance, void (T::*cb)(const InternalRegistryPrxSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_InternalRegistry_getReplicas<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_getReplicas.
 */
template<class T, typename CT> Callback_InternalRegistry_getReplicasPtr
newCallback_InternalRegistry_getReplicas(T* instance, void (T::*cb)(const InternalRegistryPrxSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_InternalRegistry_getReplicas<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_getApplications.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_getApplications.
 */
template<class T>
class CallbackNC_InternalRegistry_getApplications : public Callback_InternalRegistry_getApplications_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ApplicationInfoSeq&, ::Ice::Long);

    CallbackNC_InternalRegistry_getApplications(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        InternalRegistryPrx proxy = InternalRegistryPrx::uncheckedCast(result->getProxy());
        ::Ice::Long iceP_serial;
        ApplicationInfoSeq ret;
        try
        {
            ret = proxy->end_getApplications(iceP_serial, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret, iceP_serial);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_getApplications.
 */
template<class T> Callback_InternalRegistry_getApplicationsPtr
newCallback_InternalRegistry_getApplications(const IceUtil::Handle<T>& instance, void (T::*cb)(const ApplicationInfoSeq&, ::Ice::Long), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_InternalRegistry_getApplications<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_getApplications.
 */
template<class T> Callback_InternalRegistry_getApplicationsPtr
newCallback_InternalRegistry_getApplications(T* instance, void (T::*cb)(const ApplicationInfoSeq&, ::Ice::Long), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_InternalRegistry_getApplications<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_getApplications.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_getApplications.
 */
template<class T, typename CT>
class Callback_InternalRegistry_getApplications : public Callback_InternalRegistry_getApplications_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ApplicationInfoSeq&, ::Ice::Long, const CT&);

    Callback_InternalRegistry_getApplications(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        InternalRegistryPrx proxy = InternalRegistryPrx::uncheckedCast(result->getProxy());
        ::Ice::Long iceP_serial;
        ApplicationInfoSeq ret;
        try
        {
            ret = proxy->end_getApplications(iceP_serial, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, iceP_serial, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_getApplications.
 */
template<class T, typename CT> Callback_InternalRegistry_getApplicationsPtr
newCallback_InternalRegistry_getApplications(const IceUtil::Handle<T>& instance, void (T::*cb)(const ApplicationInfoSeq&, ::Ice::Long, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_InternalRegistry_getApplications<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_getApplications.
 */
template<class T, typename CT> Callback_InternalRegistry_getApplicationsPtr
newCallback_InternalRegistry_getApplications(T* instance, void (T::*cb)(const ApplicationInfoSeq&, ::Ice::Long, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_InternalRegistry_getApplications<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_getAdapters.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_getAdapters.
 */
template<class T>
class CallbackNC_InternalRegistry_getAdapters : public Callback_InternalRegistry_getAdapters_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const AdapterInfoSeq&, ::Ice::Long);

    CallbackNC_InternalRegistry_getAdapters(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        InternalRegistryPrx proxy = InternalRegistryPrx::uncheckedCast(result->getProxy());
        ::Ice::Long iceP_serial;
        AdapterInfoSeq ret;
        try
        {
            ret = proxy->end_getAdapters(iceP_serial, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret, iceP_serial);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_getAdapters.
 */
template<class T> Callback_InternalRegistry_getAdaptersPtr
newCallback_InternalRegistry_getAdapters(const IceUtil::Handle<T>& instance, void (T::*cb)(const AdapterInfoSeq&, ::Ice::Long), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_InternalRegistry_getAdapters<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_getAdapters.
 */
template<class T> Callback_InternalRegistry_getAdaptersPtr
newCallback_InternalRegistry_getAdapters(T* instance, void (T::*cb)(const AdapterInfoSeq&, ::Ice::Long), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_InternalRegistry_getAdapters<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_getAdapters.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_getAdapters.
 */
template<class T, typename CT>
class Callback_InternalRegistry_getAdapters : public Callback_InternalRegistry_getAdapters_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const AdapterInfoSeq&, ::Ice::Long, const CT&);

    Callback_InternalRegistry_getAdapters(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        InternalRegistryPrx proxy = InternalRegistryPrx::uncheckedCast(result->getProxy());
        ::Ice::Long iceP_serial;
        AdapterInfoSeq ret;
        try
        {
            ret = proxy->end_getAdapters(iceP_serial, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, iceP_serial, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_getAdapters.
 */
template<class T, typename CT> Callback_InternalRegistry_getAdaptersPtr
newCallback_InternalRegistry_getAdapters(const IceUtil::Handle<T>& instance, void (T::*cb)(const AdapterInfoSeq&, ::Ice::Long, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_InternalRegistry_getAdapters<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_getAdapters.
 */
template<class T, typename CT> Callback_InternalRegistry_getAdaptersPtr
newCallback_InternalRegistry_getAdapters(T* instance, void (T::*cb)(const AdapterInfoSeq&, ::Ice::Long, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_InternalRegistry_getAdapters<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_getObjects.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_getObjects.
 */
template<class T>
class CallbackNC_InternalRegistry_getObjects : public Callback_InternalRegistry_getObjects_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ObjectInfoSeq&, ::Ice::Long);

    CallbackNC_InternalRegistry_getObjects(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        InternalRegistryPrx proxy = InternalRegistryPrx::uncheckedCast(result->getProxy());
        ::Ice::Long iceP_serial;
        ObjectInfoSeq ret;
        try
        {
            ret = proxy->end_getObjects(iceP_serial, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret, iceP_serial);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_getObjects.
 */
template<class T> Callback_InternalRegistry_getObjectsPtr
newCallback_InternalRegistry_getObjects(const IceUtil::Handle<T>& instance, void (T::*cb)(const ObjectInfoSeq&, ::Ice::Long), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_InternalRegistry_getObjects<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_getObjects.
 */
template<class T> Callback_InternalRegistry_getObjectsPtr
newCallback_InternalRegistry_getObjects(T* instance, void (T::*cb)(const ObjectInfoSeq&, ::Ice::Long), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_InternalRegistry_getObjects<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_getObjects.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_getObjects.
 */
template<class T, typename CT>
class Callback_InternalRegistry_getObjects : public Callback_InternalRegistry_getObjects_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ObjectInfoSeq&, ::Ice::Long, const CT&);

    Callback_InternalRegistry_getObjects(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        InternalRegistryPrx proxy = InternalRegistryPrx::uncheckedCast(result->getProxy());
        ::Ice::Long iceP_serial;
        ObjectInfoSeq ret;
        try
        {
            ret = proxy->end_getObjects(iceP_serial, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, iceP_serial, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_getObjects.
 */
template<class T, typename CT> Callback_InternalRegistry_getObjectsPtr
newCallback_InternalRegistry_getObjects(const IceUtil::Handle<T>& instance, void (T::*cb)(const ObjectInfoSeq&, ::Ice::Long, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_InternalRegistry_getObjects<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_getObjects.
 */
template<class T, typename CT> Callback_InternalRegistry_getObjectsPtr
newCallback_InternalRegistry_getObjects(T* instance, void (T::*cb)(const ObjectInfoSeq&, ::Ice::Long, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_InternalRegistry_getObjects<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_shutdown.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_shutdown.
 */
template<class T>
class CallbackNC_InternalRegistry_shutdown : public Callback_InternalRegistry_shutdown_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_InternalRegistry_shutdown(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_shutdown.
 */
template<class T> Callback_InternalRegistry_shutdownPtr
newCallback_InternalRegistry_shutdown(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_InternalRegistry_shutdown<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_shutdown.
 */
template<class T> Callback_InternalRegistry_shutdownPtr
newCallback_InternalRegistry_shutdown(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_InternalRegistry_shutdown<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_shutdown.
 */
template<class T> Callback_InternalRegistry_shutdownPtr
newCallback_InternalRegistry_shutdown(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_InternalRegistry_shutdown<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_shutdown.
 */
template<class T> Callback_InternalRegistry_shutdownPtr
newCallback_InternalRegistry_shutdown(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_InternalRegistry_shutdown<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::InternalRegistry::begin_shutdown.
 * Create a wrapper instance by calling ::IceGrid::newCallback_InternalRegistry_shutdown.
 */
template<class T, typename CT>
class Callback_InternalRegistry_shutdown : public Callback_InternalRegistry_shutdown_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_InternalRegistry_shutdown(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_shutdown.
 */
template<class T, typename CT> Callback_InternalRegistry_shutdownPtr
newCallback_InternalRegistry_shutdown(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_InternalRegistry_shutdown<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_shutdown.
 */
template<class T, typename CT> Callback_InternalRegistry_shutdownPtr
newCallback_InternalRegistry_shutdown(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_InternalRegistry_shutdown<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_shutdown.
 */
template<class T, typename CT> Callback_InternalRegistry_shutdownPtr
newCallback_InternalRegistry_shutdown(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_InternalRegistry_shutdown<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::InternalRegistry::begin_shutdown.
 */
template<class T, typename CT> Callback_InternalRegistry_shutdownPtr
newCallback_InternalRegistry_shutdown(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_InternalRegistry_shutdown<T, CT>(instance, 0, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
