// MidiLearnUI.h
// generated by Fast Light User Interface Designer (fluid) version 1.0404

#ifndef MidiLearnUI_h
#define MidiLearnUI_h
#include <FL/Fl.H>
// Copyright (C) 2016-2024, Will Godfrey

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.


#include "UI/MiscGui.h"
    #include "EffUI.h"
    #include "BankUI.h"
    #include "ADnoteUI.h"
    #include "SUBnoteUI.h"
    #include "PADnoteUI.h"
    #include "UI/WidgetMWSlider.h"
    #include "UI/WidgetSpinner.h"
    #include "UI/WidgetCheckButton.h"
    #include "UI/ScaleTrackedWindow.h"
    #include "Params/Controller.h"
#include <FL/Fl_Group.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Choice.H>

class MidiLearnKitItem : public Fl_Group {
public:
  Fl_Group* make_window();
  Fl_Group *midilearnkititem;
  Fl_Group *midilearnkititemgroup;
  WidgetSpinner *CCcounter;
private:
  inline void cb_CCcounter_i(WidgetSpinner*, void*);
  static void cb_CCcounter(WidgetSpinner*, void*);
  inline void cb__i(Fl_Button*, void*);
  static void cb_(Fl_Button*, void*);
public:
  Fl_Button *nrpn;
  Fl_Button *sevenbit;
private:
  inline void cb_sevenbit_i(Fl_Button*, void*);
  static void cb_sevenbit(Fl_Button*, void*);
public:
  Fl_Choice *channelchoice;
private:
  inline void cb_channelchoice_i(Fl_Choice*, void*);
  static void cb_channelchoice(Fl_Choice*, void*);
  static Fl_Menu_Item menu_channelchoice[];
public:
  static Fl_Menu_Item *chan1;
  static Fl_Menu_Item *chan2;
  static Fl_Menu_Item *chan3;
  static Fl_Menu_Item *chan4;
  static Fl_Menu_Item *chan5;
  static Fl_Menu_Item *chan6;
  static Fl_Menu_Item *chan7;
  static Fl_Menu_Item *chan8;
  static Fl_Menu_Item *chan9;
  static Fl_Menu_Item *chan10;
  static Fl_Menu_Item *chan11;
  static Fl_Menu_Item *chan12;
  static Fl_Menu_Item *chan13;
  static Fl_Menu_Item *chan14;
  static Fl_Menu_Item *chan15;
  static Fl_Menu_Item *chan16;
  static Fl_Menu_Item *chanAll;
  Fl_Check_Button2 *compresscheck;
private:
  inline void cb_compresscheck_i(Fl_Check_Button2*, void*);
  static void cb_compresscheck(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *blockcheck;
private:
  inline void cb_blockcheck_i(Fl_Check_Button2*, void*);
  static void cb_blockcheck(Fl_Check_Button2*, void*);
public:
  Fl_Button *activity;
private:
  inline void cb_activity_i(Fl_Button*, void*);
  static void cb_activity(Fl_Button*, void*);
public:
  WidgetSpinner *minval;
private:
  inline void cb_minval_i(WidgetSpinner*, void*);
  static void cb_minval(WidgetSpinner*, void*);
  inline void cb_1_i(Fl_Button*, void*);
  static void cb_1(Fl_Button*, void*);
public:
  WidgetSpinner *maxval;
private:
  inline void cb_maxval_i(WidgetSpinner*, void*);
  static void cb_maxval(WidgetSpinner*, void*);
  inline void cb_2_i(Fl_Button*, void*);
  static void cb_2(Fl_Button*, void*);
public:
  Fl_Button *commandName;
private:
  inline void cb_commandName_i(Fl_Button*, void*);
  static void cb_commandName(Fl_Button*, void*);
public:
  Fl_Check_Button2 *mutecheck;
private:
  inline void cb_mutecheck_i(Fl_Check_Button2*, void*);
  static void cb_mutecheck(Fl_Check_Button2*, void*);
public:
  void send_data(int action, int control);
  MidiLearnKitItem(int x,int y, int w, int h, const char *label=0);
  ~MidiLearnKitItem();
  void init(SynthEngine *synth_, int n_);
private:
  int n;
  SynthEngine *synth;
public:
  unsigned char stat;
  void kitRscale(float dScale);
};
#include <FL/Fl_Scroll.H>
#include <FL/Fl_Box.H>

class MidiLearnUI {
public:
  ScaleTrackedWindow* make_window();
  ScaleTrackedWindow *midilearnwindow;
private:
  inline void cb_midilearnwindow_i(ScaleTrackedWindow*, void*);
  static void cb_midilearnwindow(ScaleTrackedWindow*, void*);
public:
  Fl_Scroll *kitlist;
  Fl_Box *none;
  Fl_Box *mutebox;
  Fl_Box *ccbox;
  Fl_Box *chanbox;
  Fl_Box *blockbox;
  Fl_Box *limitbox;
  Fl_Box *controlbox;
  Fl_Box *minbox;
  Fl_Box *maxbox;
  Fl_Button *close;
private:
  inline void cb_close_i(Fl_Button*, void*);
  static void cb_close(Fl_Button*, void*);
public:
  Fl_Button *load;
private:
  inline void cb_load_i(Fl_Button*, void*);
  static void cb_load(Fl_Button*, void*);
public:
  Fl_Button *save;
private:
  inline void cb_save_i(Fl_Button*, void*);
  static void cb_save(Fl_Button*, void*);
public:
  Fl_Button *clear;
private:
  inline void cb_clear_i(Fl_Button*, void*);
  static void cb_clear(Fl_Button*, void*);
public:
  Fl_Button *recent;
private:
  inline void cb_recent_i(Fl_Button*, void*);
  static void cb_recent(Fl_Button*, void*);
public:
  void showLearn();
  void send_data(int action, int control, float value, int type, int kititem = UNUSED, int engine = UNUSED, int insert = UNUSED, int parameter = UNUSED, int miscmsg = UNUSED);
  void returns_update(CommandBlock *getData);
  void addLine(CommandBlock *getData);
  MidiLearnUI(SynthEngine *_synth);
  ~MidiLearnUI();
  void clearAll(bool empty);
  void loadMidi(string file);
  void setWindowTitle(string name = "");
  void learnRtext();
  int lastkititem;
private:
  SynthEngine *synth;
  MidiLearnKitItem *midilearnkititem[MIDI_LEARN_BLOCK];
  int learnDW;
  int learnDH;
public:
  int learnW;
private:
  bool learnSeen;
};
#endif
