/* Session.c generated by valac 0.56.17, the Vala compiler
 * generated from Session.vala, do not modify */

/*-
 * Copyright 2015-2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* This class is meant to remember the
 * notifications from the current session
 * and restore them in the next session.
 *
 */

#include "notifications.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <glib/gstdio.h>

#define NOTIFICATIONS_SESSION_SESSION_FILE_NAME ".notifications.session"
#define NOTIFICATIONS_SESSION_ACTIONS_KEY "Actions"
#define NOTIFICATIONS_SESSION_APP_ICON_KEY "AppIcon"
#define NOTIFICATIONS_SESSION_APP_NAME_KEY "AppName"
#define NOTIFICATIONS_SESSION_BODY_KEY "Body"
#define NOTIFICATIONS_SESSION_IMAGE_KEY "Image"
#define NOTIFICATIONS_SESSION_DESKTOP_ID_KEY "DesktopID"
#define NOTIFICATIONS_SESSION_REPLACES_ID_KEY "ReplacesID"
#define NOTIFICATIONS_SESSION_SENDER_KEY "Sender"
#define NOTIFICATIONS_SESSION_SUMMARY_KEY "Summary"
#define NOTIFICATIONS_SESSION_UNIX_TIME_KEY "UnixTime"
#define NOTIFICATIONS_SESSION_HAS_TEMP_FILE_KEY "HasTempFile"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NOTIFICATIONS_SESSION_0_PROPERTY,
	NOTIFICATIONS_SESSION_NUM_PROPERTIES
};
static GParamSpec* notifications_session_properties[NOTIFICATIONS_SESSION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _NotificationsSessionPrivate {
	GFile* session_file;
	GKeyFile* key;
	guint write_timeout_id;
};

static gint NotificationsSession_private_offset;
static gpointer notifications_session_parent_class = NULL;
static NotificationsSession* notifications_session_instance;
static NotificationsSession* notifications_session_instance = NULL;

static NotificationsSession* notifications_session_new (void);
static NotificationsSession* notifications_session_construct (GType object_type);
static void notifications_session_create_session_file (NotificationsSession* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void notifications_session_write_contents (NotificationsSession* self);
static gboolean __lambda11_ (NotificationsSession* self);
static gboolean ___lambda11__gsource_func (gpointer self);
static void notifications_session_finalize (GObject * obj);
static GType notifications_session_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
notifications_session_get_instance_private (NotificationsSession* self)
{
	return G_STRUCT_MEMBER_P (self, NotificationsSession_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

NotificationsSession*
notifications_session_get_instance (void)
{
	NotificationsSession* _tmp0_;
	NotificationsSession* _tmp2_;
	NotificationsSession* _tmp3_;
	NotificationsSession* result;
	_tmp0_ = notifications_session_instance;
	if (_tmp0_ == NULL) {
		NotificationsSession* _tmp1_;
		_tmp1_ = notifications_session_new ();
		_g_object_unref0 (notifications_session_instance);
		notifications_session_instance = _tmp1_;
	}
	_tmp2_ = notifications_session_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static NotificationsSession*
notifications_session_construct (GType object_type)
{
	NotificationsSession * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GKeyFile* _tmp5_;
	GKeyFile* _tmp6_;
	self = (NotificationsSession*) g_object_new (object_type, NULL);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, NOTIFICATIONS_SESSION_SESSION_FILE_NAME, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	_g_object_unref0 (self->priv->session_file);
	self->priv->session_file = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp4_ = self->priv->session_file;
	if (!g_file_query_exists (_tmp4_, NULL)) {
		notifications_session_create_session_file (self);
	}
	_tmp5_ = g_key_file_new ();
	_g_key_file_unref0 (self->priv->key);
	self->priv->key = _tmp5_;
	_tmp6_ = self->priv->key;
	g_key_file_set_list_separator (_tmp6_, ';');
	return self;
}

static NotificationsSession*
notifications_session_new (void)
{
	return notifications_session_construct (NOTIFICATIONS_TYPE_SESSION);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

GList*
notifications_session_get_session_notifications (NotificationsSession* self)
{
	GList* list = NULL;
	GError* _inner_error0_ = NULL;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	list = NULL;
	{
		GKeyFile* _tmp0_;
		GFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GKeyFile* _tmp4_;
		gsize _tmp5_ = 0;
		gchar** _tmp6_;
		_tmp0_ = self->priv->key;
		_tmp1_ = self->priv->session_file;
		_tmp2_ = g_file_get_path (_tmp1_);
		_tmp3_ = _tmp2_;
		g_key_file_load_from_file (_tmp0_, _tmp3_, G_KEY_FILE_NONE, &_inner_error0_);
		_g_free0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp4_ = self->priv->key;
		_tmp6_ = g_key_file_get_groups (_tmp4_, &_tmp5_);
		{
			gchar** group_collection = NULL;
			gint group_collection_length1 = 0;
			gint _group_collection_size_ = 0;
			gint group_it = 0;
			group_collection = _tmp6_;
			group_collection_length1 = _tmp5_;
			for (group_it = 0; group_it < group_collection_length1; group_it = group_it + 1) {
				const gchar* group = NULL;
				group = group_collection[group_it];
				{
					gchar* _tmp7_ = NULL;
					GKeyFile* _tmp8_;
					const gchar* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_ = NULL;
					GKeyFile* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_ = NULL;
					GKeyFile* _tmp16_;
					const gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_ = NULL;
					GKeyFile* _tmp20_;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_ = NULL;
					GKeyFile* _tmp24_;
					const gchar* _tmp25_;
					gchar* _tmp26_;
					gchar** _tmp27_ = NULL;
					GKeyFile* _tmp28_;
					const gchar* _tmp29_;
					gsize _tmp30_ = 0;
					gchar** _tmp31_;
					gint _tmp27__length1;
					gint __tmp27__size_;
					gchar* _tmp32_ = NULL;
					GKeyFile* _tmp33_;
					const gchar* _tmp34_;
					gchar* _tmp35_;
					gint64 _tmp36_ = 0LL;
					GKeyFile* _tmp37_;
					const gchar* _tmp38_;
					guint64 _tmp39_ = 0ULL;
					GKeyFile* _tmp40_;
					const gchar* _tmp41_;
					gchar* _tmp42_ = NULL;
					GKeyFile* _tmp43_;
					const gchar* _tmp44_;
					gchar* _tmp45_;
					gboolean _tmp46_ = FALSE;
					GKeyFile* _tmp47_;
					const gchar* _tmp48_;
					NotificationsNotification* notification = NULL;
					const gchar* _tmp49_;
					NotificationsNotification* _tmp50_;
					NotificationsNotification* _tmp51_;
					NotificationsNotification* _tmp52_;
					_tmp8_ = self->priv->key;
					_tmp9_ = group;
					_tmp10_ = g_key_file_get_string (_tmp8_, _tmp9_, NOTIFICATIONS_SESSION_APP_NAME_KEY, &_inner_error0_);
					_tmp7_ = _tmp10_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch0_g_key_file_error;
						}
						if (_inner_error0_->domain == G_FILE_ERROR) {
							goto __catch0_g_file_error;
						}
						(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp12_ = self->priv->key;
					_tmp13_ = group;
					_tmp14_ = g_key_file_get_string (_tmp12_, _tmp13_, NOTIFICATIONS_SESSION_APP_ICON_KEY, &_inner_error0_);
					_tmp11_ = _tmp14_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (_tmp7_);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch0_g_key_file_error;
						}
						if (_inner_error0_->domain == G_FILE_ERROR) {
							goto __catch0_g_file_error;
						}
						(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp16_ = self->priv->key;
					_tmp17_ = group;
					_tmp18_ = g_key_file_get_string (_tmp16_, _tmp17_, NOTIFICATIONS_SESSION_SUMMARY_KEY, &_inner_error0_);
					_tmp15_ = _tmp18_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (_tmp11_);
						_g_free0 (_tmp7_);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch0_g_key_file_error;
						}
						if (_inner_error0_->domain == G_FILE_ERROR) {
							goto __catch0_g_file_error;
						}
						(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp20_ = self->priv->key;
					_tmp21_ = group;
					_tmp22_ = g_key_file_get_string (_tmp20_, _tmp21_, NOTIFICATIONS_SESSION_BODY_KEY, &_inner_error0_);
					_tmp19_ = _tmp22_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (_tmp15_);
						_g_free0 (_tmp11_);
						_g_free0 (_tmp7_);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch0_g_key_file_error;
						}
						if (_inner_error0_->domain == G_FILE_ERROR) {
							goto __catch0_g_file_error;
						}
						(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp24_ = self->priv->key;
					_tmp25_ = group;
					_tmp26_ = g_key_file_get_string (_tmp24_, _tmp25_, NOTIFICATIONS_SESSION_IMAGE_KEY, &_inner_error0_);
					_tmp23_ = _tmp26_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (_tmp19_);
						_g_free0 (_tmp15_);
						_g_free0 (_tmp11_);
						_g_free0 (_tmp7_);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch0_g_key_file_error;
						}
						if (_inner_error0_->domain == G_FILE_ERROR) {
							goto __catch0_g_file_error;
						}
						(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp28_ = self->priv->key;
					_tmp29_ = group;
					_tmp31_ = g_key_file_get_string_list (_tmp28_, _tmp29_, NOTIFICATIONS_SESSION_ACTIONS_KEY, &_tmp30_, &_inner_error0_);
					_tmp27_ = _tmp31_;
					_tmp27__length1 = _tmp30_;
					__tmp27__size_ = _tmp27__length1;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (_tmp23_);
						_g_free0 (_tmp19_);
						_g_free0 (_tmp15_);
						_g_free0 (_tmp11_);
						_g_free0 (_tmp7_);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch0_g_key_file_error;
						}
						if (_inner_error0_->domain == G_FILE_ERROR) {
							goto __catch0_g_file_error;
						}
						(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp33_ = self->priv->key;
					_tmp34_ = group;
					_tmp35_ = g_key_file_get_string (_tmp33_, _tmp34_, NOTIFICATIONS_SESSION_DESKTOP_ID_KEY, &_inner_error0_);
					_tmp32_ = _tmp35_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (_tmp23_);
						_g_free0 (_tmp19_);
						_g_free0 (_tmp15_);
						_g_free0 (_tmp11_);
						_g_free0 (_tmp7_);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch0_g_key_file_error;
						}
						if (_inner_error0_->domain == G_FILE_ERROR) {
							goto __catch0_g_file_error;
						}
						(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp37_ = self->priv->key;
					_tmp38_ = group;
					_tmp36_ = g_key_file_get_int64 (_tmp37_, _tmp38_, NOTIFICATIONS_SESSION_UNIX_TIME_KEY, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (_tmp32_);
						_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (_tmp23_);
						_g_free0 (_tmp19_);
						_g_free0 (_tmp15_);
						_g_free0 (_tmp11_);
						_g_free0 (_tmp7_);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch0_g_key_file_error;
						}
						if (_inner_error0_->domain == G_FILE_ERROR) {
							goto __catch0_g_file_error;
						}
						(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp40_ = self->priv->key;
					_tmp41_ = group;
					_tmp39_ = g_key_file_get_uint64 (_tmp40_, _tmp41_, NOTIFICATIONS_SESSION_REPLACES_ID_KEY, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (_tmp32_);
						_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (_tmp23_);
						_g_free0 (_tmp19_);
						_g_free0 (_tmp15_);
						_g_free0 (_tmp11_);
						_g_free0 (_tmp7_);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch0_g_key_file_error;
						}
						if (_inner_error0_->domain == G_FILE_ERROR) {
							goto __catch0_g_file_error;
						}
						(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp43_ = self->priv->key;
					_tmp44_ = group;
					_tmp45_ = g_key_file_get_string (_tmp43_, _tmp44_, NOTIFICATIONS_SESSION_SENDER_KEY, &_inner_error0_);
					_tmp42_ = _tmp45_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (_tmp32_);
						_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (_tmp23_);
						_g_free0 (_tmp19_);
						_g_free0 (_tmp15_);
						_g_free0 (_tmp11_);
						_g_free0 (_tmp7_);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch0_g_key_file_error;
						}
						if (_inner_error0_->domain == G_FILE_ERROR) {
							goto __catch0_g_file_error;
						}
						(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp47_ = self->priv->key;
					_tmp48_ = group;
					_tmp46_ = g_key_file_get_boolean (_tmp47_, _tmp48_, NOTIFICATIONS_SESSION_HAS_TEMP_FILE_KEY, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (_tmp42_);
						_g_free0 (_tmp32_);
						_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (_tmp23_);
						_g_free0 (_tmp19_);
						_g_free0 (_tmp15_);
						_g_free0 (_tmp11_);
						_g_free0 (_tmp7_);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch0_g_key_file_error;
						}
						if (_inner_error0_->domain == G_FILE_ERROR) {
							goto __catch0_g_file_error;
						}
						(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp49_ = group;
					_tmp50_ = notifications_notification_new (_tmp49_, _tmp7_, _tmp11_, _tmp15_, _tmp19_, _tmp23_, _tmp27_, _tmp27__length1, _tmp32_, _tmp36_, _tmp39_, _tmp42_, _tmp46_);
					notification = _tmp50_;
					_tmp51_ = notification;
					_tmp52_ = _g_object_ref0 (_tmp51_);
					list = g_list_prepend (list, _tmp52_);
					_g_object_unref0 (notification);
					_g_free0 (_tmp42_);
					_g_free0 (_tmp32_);
					_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_tmp23_);
					_g_free0 (_tmp19_);
					_g_free0 (_tmp15_);
					_g_free0 (_tmp11_);
					_g_free0 (_tmp7_);
				}
			}
			group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp53_;
		const gchar* _tmp54_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp53_ = e;
		_tmp54_ = _tmp53_->message;
		g_warning ("Session.vala:84: %s", _tmp54_);
		notifications_session_create_session_file (self);
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp55_;
		const gchar* _tmp56_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp55_ = e;
		_tmp56_ = _tmp55_->message;
		g_warning ("Session.vala:87: %s", _tmp56_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	list = g_list_reverse (list);
	result = list;
	return result;
}

void
notifications_session_add_notification (NotificationsSession* self,
                                        NotificationsNotification* notification,
                                        gboolean write_file)
{
	gchar* id = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GKeyFile* _tmp3_;
	const gchar* _tmp4_;
	GDateTime* _tmp5_;
	GKeyFile* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GKeyFile* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GKeyFile* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GKeyFile* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GKeyFile* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GKeyFile* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	GKeyFile* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	GKeyFile* _tmp28_;
	const gchar* _tmp29_;
	gchar** _tmp30_;
	gint _tmp30__length1;
	GKeyFile* _tmp31_;
	const gchar* _tmp32_;
	GKeyFile* _tmp33_;
	const gchar* _tmp34_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	_tmp0_ = notifications_notification_get_internal_id (notification);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	id = _tmp2_;
	_tmp3_ = self->priv->key;
	_tmp4_ = id;
	_tmp5_ = notification->timestamp;
	g_key_file_set_int64 (_tmp3_, _tmp4_, NOTIFICATIONS_SESSION_UNIX_TIME_KEY, g_date_time_to_unix (_tmp5_));
	_tmp6_ = self->priv->key;
	_tmp7_ = id;
	_tmp8_ = notification->app_icon;
	g_key_file_set_string (_tmp6_, _tmp7_, NOTIFICATIONS_SESSION_APP_ICON_KEY, _tmp8_);
	_tmp9_ = self->priv->key;
	_tmp10_ = id;
	_tmp11_ = notification->app_name;
	g_key_file_set_string (_tmp9_, _tmp10_, NOTIFICATIONS_SESSION_APP_NAME_KEY, _tmp11_);
	_tmp12_ = self->priv->key;
	_tmp13_ = id;
	_tmp14_ = notification->message_body;
	g_key_file_set_string (_tmp12_, _tmp13_, NOTIFICATIONS_SESSION_BODY_KEY, _tmp14_);
	_tmp15_ = self->priv->key;
	_tmp16_ = id;
	_tmp17_ = notifications_notification_get_image_path (notification);
	_tmp18_ = _tmp17_;
	g_key_file_set_string (_tmp15_, _tmp16_, NOTIFICATIONS_SESSION_IMAGE_KEY, _tmp18_);
	_tmp19_ = self->priv->key;
	_tmp20_ = id;
	_tmp21_ = notification->desktop_id;
	g_key_file_set_string (_tmp19_, _tmp20_, NOTIFICATIONS_SESSION_DESKTOP_ID_KEY, _tmp21_);
	_tmp22_ = self->priv->key;
	_tmp23_ = id;
	_tmp24_ = notification->sender;
	g_key_file_set_string (_tmp22_, _tmp23_, NOTIFICATIONS_SESSION_SENDER_KEY, _tmp24_);
	_tmp25_ = self->priv->key;
	_tmp26_ = id;
	_tmp27_ = notification->summary;
	g_key_file_set_string (_tmp25_, _tmp26_, NOTIFICATIONS_SESSION_SUMMARY_KEY, _tmp27_);
	_tmp28_ = self->priv->key;
	_tmp29_ = id;
	_tmp30_ = notification->actions;
	_tmp30__length1 = notification->actions_length1;
	g_key_file_set_string_list (_tmp28_, _tmp29_, NOTIFICATIONS_SESSION_ACTIONS_KEY, (const gchar* const*) _tmp30_, (gint) _tmp30__length1);
	_tmp31_ = self->priv->key;
	_tmp32_ = id;
	g_key_file_set_uint64 (_tmp31_, _tmp32_, NOTIFICATIONS_SESSION_REPLACES_ID_KEY, (guint64) notification->replaces_id);
	_tmp33_ = self->priv->key;
	_tmp34_ = id;
	g_key_file_set_boolean (_tmp33_, _tmp34_, NOTIFICATIONS_SESSION_HAS_TEMP_FILE_KEY, notification->has_temp_file);
	if (write_file) {
		notifications_session_write_contents (self);
	}
	_g_free0 (id);
}

void
notifications_session_remove_notification (NotificationsSession* self,
                                           NotificationsNotification* notification,
                                           gboolean write_file)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	{
		GKeyFile* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		if (notification->has_temp_file) {
			GFile* file = NULL;
			const gchar* _tmp0_;
			const gchar* _tmp1_;
			GFile* _tmp2_;
			_tmp0_ = notifications_notification_get_image_path (notification);
			_tmp1_ = _tmp0_;
			_tmp2_ = g_file_new_for_path (_tmp1_);
			file = _tmp2_;
			{
				GFile* _tmp3_;
				_tmp3_ = file;
				g_file_delete (_tmp3_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				g_clear_error (&_inner_error0_);
				_tmp4_ = notifications_notification_get_image_path (notification);
				_tmp5_ = _tmp4_;
				g_critical ("Session.vala:120: Unable to delete tmpfile: %s", _tmp5_);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch0_g_key_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_object_unref0 (file);
		}
		_tmp6_ = self->priv->key;
		_tmp7_ = notifications_notification_get_internal_id (notification);
		_tmp8_ = _tmp7_;
		g_key_file_remove_group (_tmp6_, _tmp8_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("Session.vala:125: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (write_file) {
		notifications_session_write_contents (self);
	}
}

void
notifications_session_remove_notifications (NotificationsSession* self,
                                            NotificationsNotification** notifications,
                                            gint notifications_length1)
{
	g_return_if_fail (self != NULL);
	{
		NotificationsNotification** notification_collection = NULL;
		gint notification_collection_length1 = 0;
		gint _notification_collection_size_ = 0;
		gint notification_it = 0;
		notification_collection = notifications;
		notification_collection_length1 = notifications_length1;
		for (notification_it = 0; notification_it < notification_collection_length1; notification_it = notification_it + 1) {
			NotificationsNotification* notification = NULL;
			notification = notification_collection[notification_it];
			{
				NotificationsNotification* _tmp0_;
				_tmp0_ = notification;
				notifications_session_remove_notification (self, _tmp0_, FALSE);
			}
		}
	}
	notifications_session_write_contents (self);
}

void
notifications_session_clear (NotificationsSession* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GFile* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->session_file;
		_tmp1_ = g_file_get_path (_tmp0_);
		_tmp2_ = _tmp1_;
		g_file_set_contents (_tmp2_, "", (gssize) -1, &_inner_error0_);
		_g_free0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("Session.vala:145: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
notifications_session_create_session_file (NotificationsSession* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GFile* _tmp0_;
		GFileOutputStream* _tmp1_;
		GFileOutputStream* _tmp2_;
		_tmp0_ = self->priv->session_file;
		_tmp1_ = g_file_create (_tmp0_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
		_tmp2_ = _tmp1_;
		_g_object_unref0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("Session.vala:153: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gboolean
__lambda11_ (NotificationsSession* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	self->priv->write_timeout_id = (guint) 0;
	{
		GFile* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		GKeyFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp0_ = self->priv->session_file;
		_tmp1_ = g_file_get_path (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->key;
		_tmp4_ = g_key_file_to_data (_tmp3_, NULL, NULL);
		_tmp5_ = _tmp4_;
		g_file_set_contents (_tmp2_, _tmp5_, (gssize) -1, &_inner_error0_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp6_ = FALSE;
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("Session.vala:168: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda11__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda11_ ((NotificationsSession*) self);
	return result;
}

static void
notifications_session_write_contents (NotificationsSession* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->write_timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->write_timeout_id);
	}
	self->priv->write_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, ___lambda11__gsource_func, g_object_ref (self), g_object_unref);
}

static void
notifications_session_class_init (NotificationsSessionClass * klass,
                                  gpointer klass_data)
{
	notifications_session_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NotificationsSession_private_offset);
	G_OBJECT_CLASS (klass)->finalize = notifications_session_finalize;
}

static void
notifications_session_instance_init (NotificationsSession * self,
                                     gpointer klass)
{
	self->priv = notifications_session_get_instance_private (self);
	self->priv->session_file = NULL;
	self->priv->write_timeout_id = (guint) 0;
}

static void
notifications_session_finalize (GObject * obj)
{
	NotificationsSession * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NOTIFICATIONS_TYPE_SESSION, NotificationsSession);
	_g_object_unref0 (self->priv->session_file);
	_g_key_file_unref0 (self->priv->key);
	G_OBJECT_CLASS (notifications_session_parent_class)->finalize (obj);
}

static GType
notifications_session_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotificationsSessionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notifications_session_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotificationsSession), 0, (GInstanceInitFunc) notifications_session_instance_init, NULL };
	GType notifications_session_type_id;
	notifications_session_type_id = g_type_register_static (G_TYPE_OBJECT, "NotificationsSession", &g_define_type_info, 0);
	NotificationsSession_private_offset = g_type_add_instance_private (notifications_session_type_id, sizeof (NotificationsSessionPrivate));
	return notifications_session_type_id;
}

GType
notifications_session_get_type (void)
{
	static volatile gsize notifications_session_type_id__once = 0;
	if (g_once_init_enter (&notifications_session_type_id__once)) {
		GType notifications_session_type_id;
		notifications_session_type_id = notifications_session_get_type_once ();
		g_once_init_leave (&notifications_session_type_id__once, notifications_session_type_id);
	}
	return notifications_session_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

