/* PopoverWidget.c generated by valac 0.56.17, the Vala compiler
 * generated from PopoverWidget.vala, do not modify */

/*
* Copyright 2015-2021 elementary, Inc. (https://elementary.io)
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU Library General Public License as published by
* the Free Software Foundation, either version 2.1 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Library General Public License for more details.
*
* You should have received a copy of the GNU Library General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/

#include "network.h"
#include <NetworkManager.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <granite.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_WIDGETS_POPOVER_WIDGET_0_PROPERTY,
	NETWORK_WIDGETS_POPOVER_WIDGET_NM_CLIENT_PROPERTY,
	NETWORK_WIDGETS_POPOVER_WIDGET_NETWORK_INTERFACE_PROPERTY,
	NETWORK_WIDGETS_POPOVER_WIDGET_SECURE_PROPERTY,
	NETWORK_WIDGETS_POPOVER_WIDGET_EXTRA_INFO_PROPERTY,
	NETWORK_WIDGETS_POPOVER_WIDGET_STATE_PROPERTY,
	NETWORK_WIDGETS_POPOVER_WIDGET_IS_IN_SESSION_PROPERTY,
	NETWORK_WIDGETS_POPOVER_WIDGET_NUM_PROPERTIES
};
static GParamSpec* network_widgets_popover_widget_properties[NETWORK_WIDGETS_POPOVER_WIDGET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
enum  {
	NETWORK_WIDGETS_POPOVER_WIDGET_SETTINGS_SHOWN_SIGNAL,
	NETWORK_WIDGETS_POPOVER_WIDGET_NUM_SIGNALS
};
static guint network_widgets_popover_widget_signals[NETWORK_WIDGETS_POPOVER_WIDGET_NUM_SIGNALS] = {0};

struct _NetworkWidgetsPopoverWidgetPrivate {
	NMClient* _nm_client;
	GList* _network_interface;
	gboolean _secure;
	gchar* _extra_info;
	NetworkState _state;
	GtkFlowBox* other_box;
	GtkBox* wifi_box;
	GtkBox* vpn_box;
	GtkModelButton* hidden_item;
	GtkRevealer* toggle_revealer;
	gboolean _is_in_session;
};

struct _Block4Data {
	int _ref_count_;
	NetworkWidgetsPopoverWidget* self;
	GtkToggleButton* airplane_toggle;
};

static gint NetworkWidgetsPopoverWidget_private_offset;
static gpointer network_widgets_popover_widget_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void network_widgets_popover_widget_add_interface (NetworkWidgetsPopoverWidget* self,
                                                   NetworkWidgetNMInterface* widget_interface);
static void ___lambda22_ (NetworkWidgetsPopoverWidget* self);
static void ____lambda22__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void network_widgets_popover_widget_show_settings (NetworkWidgetsPopoverWidget* self);
static void network_widgets_popover_widget_device_removed_cb (NetworkWidgetsPopoverWidget* self,
                                                       NMDevice* device);
static void network_widgets_popover_widget_set_network_interface (NetworkWidgetsPopoverWidget* self,
                                                           GList* value);
static void network_widgets_popover_widget_update_interfaces_names (NetworkWidgetsPopoverWidget* self);
static void network_widgets_popover_widget_update_state (NetworkWidgetsPopoverWidget* self);
static void _vala_array_add1 (NMDevice** * array,
                       gint* length,
                       gint* size,
                       NMDevice* value);
static void network_widgets_popover_widget_device_added_cb (NetworkWidgetsPopoverWidget* self,
                                                     NMDevice* device);
static void _network_widgets_popover_widget_update_state_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void network_widgets_popover_widget_set_state (NetworkWidgetsPopoverWidget* self,
                                               NetworkState value);
static void network_widgets_popover_widget_set_extra_info (NetworkWidgetsPopoverWidget* self,
                                                    const gchar* value);
static void network_widgets_popover_widget_update_vpn_connection (NetworkWidgetsPopoverWidget* self);
static void network_widgets_popover_widget_set_secure (NetworkWidgetsPopoverWidget* self,
                                                gboolean value);
static void __lambda30_ (NetworkWidgetsPopoverWidget* self,
                  NMActiveConnection* ac);
static void _network_widgets_popover_widget_update_vpn_connection_nm_vpn_connection_vpn_state_changed (NMVpnConnection* _sender,
                                                                                                guint object,
                                                                                                guint p0,
                                                                                                gpointer self);
static void _network_widgets_popover_widget_update_vpn_connection_nm_active_connection_state_changed (NMActiveConnection* _sender,
                                                                                               guint state,
                                                                                               guint reason,
                                                                                               gpointer self);
static void ___lambda30__gfunc (gconstpointer data,
                         gpointer self);
static GObject * network_widgets_popover_widget_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void _network_widgets_popover_widget____lambda31_ (Block4Data* _data4_);
static void __lambda32_ (NetworkWidgetsPopoverWidget* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda32__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void __network_widgets_popover_widget____lambda31__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                              gpointer self);
static void _network_widgets_popover_widget_show_settings_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void _network_widgets_popover_widget___lambda33_ (NetworkWidgetsPopoverWidget* self);
static void __network_widgets_popover_widget___lambda33__gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self);
static void _network_widgets_popover_widget_device_added_cb_nm_client_device_added (NMClient* _sender,
                                                                             NMDevice* device,
                                                                             gpointer self);
static void _network_widgets_popover_widget_device_removed_cb_nm_client_device_removed (NMClient* _sender,
                                                                                 NMDevice* device,
                                                                                 gpointer self);
static void _network_widgets_popover_widget_update_vpn_connection_g_object_notify (GObject* _sender,
                                                                            GParamSpec* pspec,
                                                                            gpointer self);
static void network_widgets_popover_widget_finalize (GObject * obj);
static GType network_widgets_popover_widget_get_type_once (void);
static void _vala_network_widgets_popover_widget_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_network_widgets_popover_widget_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
network_widgets_popover_widget_get_instance_private (NetworkWidgetsPopoverWidget* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkWidgetsPopoverWidget_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

NetworkWidgetsPopoverWidget*
network_widgets_popover_widget_construct (GType object_type,
                                          gboolean is_in_session)
{
	NetworkWidgetsPopoverWidget * self = NULL;
	self = (NetworkWidgetsPopoverWidget*) g_object_new (object_type, "is-in-session", is_in_session, NULL);
	return self;
}

NetworkWidgetsPopoverWidget*
network_widgets_popover_widget_new (gboolean is_in_session)
{
	return network_widgets_popover_widget_construct (NETWORK_WIDGETS_TYPE_POPOVER_WIDGET, is_in_session);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
___lambda22_ (NetworkWidgetsPopoverWidget* self)
{
	gboolean hidden_sensitivity = FALSE;
	GList* _tmp0_;
	hidden_sensitivity = FALSE;
	_tmp0_ = self->priv->_network_interface;
	{
		GList* iface_collection = NULL;
		GList* iface_it = NULL;
		iface_collection = _tmp0_;
		for (iface_it = iface_collection; iface_it != NULL; iface_it = iface_it->next) {
			NetworkWidgetNMInterface* iface = NULL;
			iface = (NetworkWidgetNMInterface*) iface_it->data;
			{
				NetworkWidgetNMInterface* _tmp1_;
				GtkModelButton* _tmp6_;
				_tmp1_ = iface;
				if (NETWORK_IS_WIFI_INTERFACE (_tmp1_)) {
					gboolean _tmp2_ = FALSE;
					if (hidden_sensitivity) {
						_tmp2_ = TRUE;
					} else {
						NetworkWidgetNMInterface* _tmp3_;
						gboolean _tmp4_;
						gboolean _tmp5_;
						_tmp3_ = iface;
						_tmp4_ = network_wifi_interface_get_hidden_sensitivity (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, NETWORK_TYPE_WIFI_INTERFACE, NetworkWifiInterface));
						_tmp5_ = _tmp4_;
						_tmp2_ = _tmp5_;
					}
					hidden_sensitivity = _tmp2_;
				}
				_tmp6_ = self->priv->hidden_item;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, hidden_sensitivity);
			}
		}
	}
}

static void
____lambda22__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda22_ ((NetworkWidgetsPopoverWidget*) self);
}

static void
network_widgets_popover_widget_add_interface (NetworkWidgetsPopoverWidget* self,
                                              NetworkWidgetNMInterface* widget_interface)
{
	gboolean _tmp0_ = FALSE;
	GtkBox* container_box = NULL;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_;
	GtkBox* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget_interface != NULL);
	if (NETWORK_IS_ETHER_INTERFACE (widget_interface)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = NETWORK_IS_MODEM_INTERFACE (widget_interface);
	}
	if (_tmp0_) {
		GtkFlowBoxChild* flowboxchild = NULL;
		GtkFlowBoxChild* _tmp1_ = NULL;
		GtkFlowBoxChild* _tmp2_;
		GtkFlowBox* _tmp3_;
		GtkFlowBoxChild* _tmp4_;
		_tmp1_ = (GtkFlowBoxChild*) gtk_flow_box_child_new ();
		gtk_widget_set_can_focus ((GtkWidget*) _tmp1_, FALSE);
		g_object_ref_sink (_tmp1_);
		flowboxchild = _tmp1_;
		_tmp2_ = flowboxchild;
		gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) widget_interface);
		_tmp3_ = self->priv->other_box;
		_tmp4_ = flowboxchild;
		gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
		_g_object_unref0 (flowboxchild);
		return;
	}
	_tmp5_ = self->priv->wifi_box;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	container_box = _tmp6_;
	if (NETWORK_IS_WIFI_INTERFACE (widget_interface)) {
		GtkBox* _tmp7_;
		GtkBox* _tmp8_;
		GtkModelButton* _tmp9_;
		GtkModelButton* _tmp10_;
		_tmp7_ = self->priv->wifi_box;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (container_box);
		container_box = _tmp8_;
		_tmp9_ = self->priv->hidden_item;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp9_, FALSE);
		_tmp10_ = self->priv->hidden_item;
		gtk_widget_show_all ((GtkWidget*) _tmp10_);
		g_signal_connect_object ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (widget_interface, NETWORK_TYPE_WIFI_INTERFACE, NetworkWifiInterface), "notify::hidden-sensitivity", (GCallback) ____lambda22__g_object_notify, self, 0);
	}
	if (NETWORK_IS_VPN_INTERFACE (widget_interface)) {
		GtkBox* _tmp11_;
		GtkBox* _tmp12_;
		_tmp11_ = self->priv->vpn_box;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_g_object_unref0 (container_box);
		container_box = _tmp12_;
	}
	_tmp14_ = self->priv->_is_in_session;
	if (_tmp14_) {
		GList* _tmp15_;
		GList* _tmp16_;
		_tmp15_ = gtk_container_get_children ((GtkContainer*) self);
		_tmp16_ = _tmp15_;
		_tmp13_ = g_list_length (_tmp16_) > ((guint) 0);
		(_tmp16_ == NULL) ? NULL : (_tmp16_ = (g_list_free (_tmp16_), NULL));
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		GtkBox* _tmp17_;
		GtkSeparator* _tmp18_;
		GtkSeparator* _tmp19_;
		_tmp17_ = container_box;
		_tmp18_ = network_widget_nm_interface_get_sep (widget_interface);
		_tmp19_ = _tmp18_;
		gtk_box_pack_end (_tmp17_, (GtkWidget*) _tmp19_, TRUE, TRUE, (guint) 0);
	}
	_tmp20_ = container_box;
	gtk_box_pack_end (_tmp20_, (GtkWidget*) widget_interface, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (container_box);
}

void
network_widgets_popover_widget_opened (NetworkWidgetsPopoverWidget* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_network_interface;
	{
		GList* iface_collection = NULL;
		GList* iface_it = NULL;
		iface_collection = _tmp0_;
		for (iface_it = iface_collection; iface_it != NULL; iface_it = iface_it->next) {
			NetworkWidgetNMInterface* iface = NULL;
			iface = (NetworkWidgetNMInterface*) iface_it->data;
			{
				NetworkWidgetNMInterface* _tmp1_;
				_tmp1_ = iface;
				if (NETWORK_IS_WIFI_INTERFACE (_tmp1_)) {
					NetworkWidgetNMInterface* _tmp2_;
					_tmp2_ = iface;
					network_wifi_interface_start_scanning (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, NETWORK_TYPE_WIFI_INTERFACE, NetworkWifiInterface));
				}
			}
		}
	}
}

void
network_widgets_popover_widget_closed (NetworkWidgetsPopoverWidget* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_network_interface;
	{
		GList* iface_collection = NULL;
		GList* iface_it = NULL;
		iface_collection = _tmp0_;
		for (iface_it = iface_collection; iface_it != NULL; iface_it = iface_it->next) {
			NetworkWidgetNMInterface* iface = NULL;
			iface = (NetworkWidgetNMInterface*) iface_it->data;
			{
				NetworkWidgetNMInterface* _tmp1_;
				_tmp1_ = iface;
				if (NETWORK_IS_WIFI_INTERFACE (_tmp1_)) {
					NetworkWidgetNMInterface* _tmp2_;
					_tmp2_ = iface;
					network_wifi_interface_cancel_scanning (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, NETWORK_TYPE_WIFI_INTERFACE, NetworkWifiInterface));
				}
			}
		}
	}
}

static void
network_widgets_popover_widget_show_settings (NetworkWidgetsPopoverWidget* self)
{
	gboolean _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_is_in_session;
	if (_tmp0_) {
		{
			g_app_info_launch_default_for_uri ("settings://network", NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp1_;
			const gchar* _tmp2_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp1_ = e;
			_tmp2_ = _tmp1_->message;
			g_warning ("PopoverWidget.vala:239: Failed to open network settings: %s", _tmp2_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		g_signal_emit (self, network_widgets_popover_widget_signals[NETWORK_WIDGETS_POPOVER_WIDGET_SETTINGS_SHOWN_SIGNAL], 0);
	}
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static void
network_widgets_popover_widget_device_removed_cb (NetworkWidgetsPopoverWidget* self,
                                                  NMDevice* device)
{
	GList* _tmp0_;
	GtkRevealer* _tmp15_;
	GtkFlowBox* _tmp16_;
	GList* _tmp17_;
	GList* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = self->priv->_network_interface;
	{
		GList* widget_interface_collection = NULL;
		GList* widget_interface_it = NULL;
		widget_interface_collection = _tmp0_;
		for (widget_interface_it = widget_interface_collection; widget_interface_it != NULL; widget_interface_it = widget_interface_it->next) {
			NetworkWidgetNMInterface* _tmp1_;
			NetworkWidgetNMInterface* widget_interface = NULL;
			_tmp1_ = _g_object_ref0 ((NetworkWidgetNMInterface*) widget_interface_it->data);
			widget_interface = _tmp1_;
			{
				NetworkWidgetNMInterface* _tmp2_;
				NMDevice* _tmp3_;
				NMDevice* _tmp4_;
				_tmp2_ = widget_interface;
				_tmp3_ = network_widget_nm_interface_get_device (_tmp2_);
				_tmp4_ = _tmp3_;
				if (_tmp4_ == device) {
					GList* _tmp5_;
					NetworkWidgetNMInterface* _tmp6_;
					GtkContainer* parent = NULL;
					NetworkWidgetNMInterface* _tmp7_;
					GtkContainer* _tmp8_;
					GtkContainer* _tmp9_;
					NetworkWidgetNMInterface* _tmp11_;
					GtkSeparator* _tmp12_;
					GtkSeparator* _tmp13_;
					NetworkWidgetNMInterface* _tmp14_;
					_tmp5_ = self->priv->_network_interface;
					_tmp6_ = widget_interface;
					network_widgets_popover_widget_set_network_interface (self, vala_g_list_remove_full (_tmp5_, _tmp6_, _g_object_unref0_));
					_tmp7_ = widget_interface;
					_tmp8_ = gtk_widget_get_parent ((GtkWidget*) _tmp7_);
					parent = _tmp8_;
					_tmp9_ = parent;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, gtk_flow_box_child_get_type ())) {
						GtkContainer* _tmp10_;
						_tmp10_ = parent;
						gtk_widget_destroy ((GtkWidget*) _tmp10_);
					}
					_tmp11_ = widget_interface;
					_tmp12_ = network_widget_nm_interface_get_sep (_tmp11_);
					_tmp13_ = _tmp12_;
					gtk_widget_destroy ((GtkWidget*) _tmp13_);
					_tmp14_ = widget_interface;
					gtk_widget_destroy ((GtkWidget*) _tmp14_);
					_g_object_unref0 (widget_interface);
					break;
				}
				_g_object_unref0 (widget_interface);
			}
		}
	}
	_tmp15_ = self->priv->toggle_revealer;
	_tmp16_ = self->priv->other_box;
	_tmp17_ = gtk_container_get_children ((GtkContainer*) _tmp16_);
	_tmp18_ = _tmp17_;
	gtk_revealer_set_reveal_child (_tmp15_, _tmp18_ != NULL);
	(_tmp18_ == NULL) ? NULL : (_tmp18_ = (g_list_free (_tmp18_), NULL));
	network_widgets_popover_widget_update_interfaces_names (self);
	network_widgets_popover_widget_update_state (self);
}

static void
_vala_array_add1 (NMDevice** * array,
                  gint* length,
                  gint* size,
                  NMDevice* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (NMDevice*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
network_widgets_popover_widget_update_interfaces_names (NetworkWidgetsPopoverWidget* self)
{
	NMDevice** devices = NULL;
	NMDevice** _tmp0_;
	gint devices_length1;
	gint _devices_size_;
	GList* _tmp1_;
	gchar** names = NULL;
	NMDevice** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint names_length1;
	gint _names_size_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (NMDevice*, 0 + 1);
	devices = _tmp0_;
	devices_length1 = 0;
	_devices_size_ = devices_length1;
	_tmp1_ = self->priv->_network_interface;
	{
		GList* iface_collection = NULL;
		GList* iface_it = NULL;
		iface_collection = _tmp1_;
		for (iface_it = iface_collection; iface_it != NULL; iface_it = iface_it->next) {
			NetworkWidgetNMInterface* iface = NULL;
			iface = (NetworkWidgetNMInterface*) iface_it->data;
			{
				NetworkWidgetNMInterface* _tmp2_;
				NMDevice* _tmp3_;
				NMDevice* _tmp4_;
				NMDevice* _tmp5_;
				_tmp2_ = iface;
				_tmp3_ = network_widget_nm_interface_get_device (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = _g_object_ref0 (_tmp4_);
				_vala_array_add1 (&devices, &devices_length1, &_devices_size_, _tmp5_);
			}
		}
	}
	_tmp6_ = devices;
	_tmp6__length1 = devices_length1;
	_tmp8_ = _tmp7_ = nm_device_disambiguate_names (_tmp6_, (gint) _tmp6__length1);
	names = _tmp8_;
	names_length1 = _vala_array_length (_tmp7_);
	_names_size_ = names_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				GList* _tmp11_;
				GList* _tmp12_;
				gconstpointer _tmp13_;
				gchar** _tmp14_;
				gint _tmp14__length1;
				const gchar* _tmp15_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = self->priv->_network_interface;
				if (!(((guint) i) < g_list_length (_tmp11_))) {
					break;
				}
				_tmp12_ = self->priv->_network_interface;
				_tmp13_ = g_list_nth_data (_tmp12_, (guint) i);
				_tmp14_ = names;
				_tmp14__length1 = names_length1;
				_tmp15_ = _tmp14_[i];
				network_widget_nm_interface_set_display_title ((NetworkWidgetNMInterface*) _tmp13_, _tmp15_);
			}
		}
	}
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	devices = (_vala_array_free (devices, devices_length1, (GDestroyNotify) g_object_unref), NULL);
}

static void
_network_widgets_popover_widget_update_state_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	network_widgets_popover_widget_update_state ((NetworkWidgetsPopoverWidget*) self);
}

static void
network_widgets_popover_widget_device_added_cb (NetworkWidgetsPopoverWidget* self,
                                                NMDevice* device)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	NetworkWidgetNMInterface* widget_interface = NULL;
	NetworkWidgetNMInterface* _tmp15_;
	GtkRevealer* _tmp21_;
	GtkFlowBox* _tmp22_;
	GList* _tmp23_;
	GList* _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp3_ = nm_device_get_iface (device);
	if (g_str_has_prefix (_tmp3_, "vmnet")) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = nm_device_get_iface (device);
		_tmp2_ = g_str_has_prefix (_tmp4_, "lo");
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = nm_device_get_iface (device);
		_tmp1_ = g_str_has_prefix (_tmp5_, "veth");
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = nm_device_get_iface (device);
		_tmp0_ = g_str_has_prefix (_tmp6_, "vboxnet");
	}
	if (_tmp0_) {
		return;
	}
	widget_interface = NULL;
	if (G_TYPE_CHECK_INSTANCE_TYPE (device, nm_device_wifi_get_type ())) {
		NMClient* _tmp7_;
		NetworkWifiInterface* _tmp8_;
		_tmp7_ = self->priv->_nm_client;
		_tmp8_ = network_wifi_interface_new (_tmp7_, device);
		g_object_ref_sink (_tmp8_);
		_g_object_unref0 (widget_interface);
		widget_interface = (NetworkWidgetNMInterface*) _tmp8_;
		g_debug ("PopoverWidget.vala:292: Wifi interface added");
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (device, nm_device_ethernet_get_type ())) {
			NMClient* _tmp9_;
			NetworkEtherInterface* _tmp10_;
			_tmp9_ = self->priv->_nm_client;
			_tmp10_ = network_ether_interface_new (_tmp9_, device);
			g_object_ref_sink (_tmp10_);
			_g_object_unref0 (widget_interface);
			widget_interface = (NetworkWidgetNMInterface*) _tmp10_;
			g_debug ("PopoverWidget.vala:295: Wired interface added");
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (device, nm_device_modem_get_type ())) {
				NMClient* _tmp11_;
				NetworkModemInterface* _tmp12_;
				NetworkWidgetNMInterface* _tmp13_;
				_tmp11_ = self->priv->_nm_client;
				_tmp12_ = network_modem_interface_new (_tmp11_, device);
				g_object_ref_sink (_tmp12_);
				_g_object_unref0 (widget_interface);
				widget_interface = (NetworkWidgetNMInterface*) _tmp12_;
				_tmp13_ = widget_interface;
				g_signal_connect_object ((GObject*) _tmp13_, "notify::extra-info", (GCallback) _network_widgets_popover_widget_update_state_g_object_notify, self, 0);
				g_debug ("PopoverWidget.vala:299: Modem interface added");
			} else {
				GEnumValue* _tmp14_;
				_tmp14_ = g_enum_get_value (g_type_class_ref (nm_device_type_get_type ()), nm_device_get_device_type (device));
				g_debug ("PopoverWidget.vala:301: Unknown device: %s\n", (_tmp14_ != NULL) ? _tmp14_->value_name : NULL);
			}
		}
	}
	_tmp15_ = widget_interface;
	if (_tmp15_ != NULL) {
		GList* _tmp16_;
		NetworkWidgetNMInterface* _tmp17_;
		NetworkWidgetNMInterface* _tmp18_;
		NetworkWidgetNMInterface* _tmp19_;
		NetworkWidgetNMInterface* _tmp20_;
		_tmp16_ = self->priv->_network_interface;
		_tmp17_ = widget_interface;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		network_widgets_popover_widget_set_network_interface (self, g_list_append (_tmp16_, _tmp18_));
		_tmp19_ = widget_interface;
		network_widgets_popover_widget_add_interface (self, _tmp19_);
		_tmp20_ = widget_interface;
		g_signal_connect_object ((GObject*) _tmp20_, "notify::state", (GCallback) _network_widgets_popover_widget_update_state_g_object_notify, self, 0);
	}
	network_widgets_popover_widget_update_interfaces_names (self);
	_tmp21_ = self->priv->toggle_revealer;
	_tmp22_ = self->priv->other_box;
	_tmp23_ = gtk_container_get_children ((GtkContainer*) _tmp22_);
	_tmp24_ = _tmp23_;
	gtk_revealer_set_reveal_child (_tmp21_, _tmp24_ != NULL);
	(_tmp24_ == NULL) ? NULL : (_tmp24_ = (g_list_free (_tmp24_), NULL));
	network_widgets_popover_widget_update_state (self);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (widget_interface);
}

static void
network_widgets_popover_widget_update_state (NetworkWidgetsPopoverWidget* self)
{
	NMClient* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_nm_client;
	if (!nm_client_networking_get_enabled (_tmp0_)) {
		network_widgets_popover_widget_set_state (self, NETWORK_STATE_DISCONNECTED_AIRPLANE_MODE);
	} else {
		NetworkState next_state = 0;
		gint best_score = 0;
		GList* _tmp1_;
		next_state = NETWORK_STATE_DISCONNECTED;
		best_score = G_MAXINT;
		_tmp1_ = self->priv->_network_interface;
		{
			GList* inter_collection = NULL;
			GList* inter_it = NULL;
			inter_collection = _tmp1_;
			for (inter_it = inter_collection; inter_it != NULL; inter_it = inter_it->next) {
				NetworkWidgetNMInterface* _tmp2_;
				NetworkWidgetNMInterface* inter = NULL;
				_tmp2_ = _g_object_ref0 ((NetworkWidgetNMInterface*) inter_it->data);
				inter = _tmp2_;
				{
					gint score = 0;
					NetworkWidgetNMInterface* _tmp3_;
					NetworkState _tmp4_;
					NetworkState _tmp5_;
					_tmp3_ = inter;
					_tmp4_ = network_widget_nm_interface_get_state (_tmp3_);
					_tmp5_ = _tmp4_;
					score = network_state_get_priority (_tmp5_);
					if (score < best_score) {
						NetworkWidgetNMInterface* _tmp6_;
						NetworkState _tmp7_;
						NetworkState _tmp8_;
						NetworkWidgetNMInterface* _tmp9_;
						_tmp6_ = inter;
						_tmp7_ = network_widget_nm_interface_get_state (_tmp6_);
						_tmp8_ = _tmp7_;
						next_state = _tmp8_;
						best_score = score;
						_tmp9_ = inter;
						if (NETWORK_IS_MODEM_INTERFACE (_tmp9_)) {
							NetworkWidgetNMInterface* _tmp10_;
							const gchar* _tmp11_;
							const gchar* _tmp12_;
							_tmp10_ = inter;
							_tmp11_ = network_modem_interface_get_extra_info (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, NETWORK_TYPE_MODEM_INTERFACE, NetworkModemInterface));
							_tmp12_ = _tmp11_;
							network_widgets_popover_widget_set_extra_info (self, _tmp12_);
						}
					}
					_g_object_unref0 (inter);
				}
			}
		}
		network_widgets_popover_widget_set_state (self, next_state);
	}
}

static void
_network_widgets_popover_widget_update_vpn_connection_nm_vpn_connection_vpn_state_changed (NMVpnConnection* _sender,
                                                                                           guint object,
                                                                                           guint p0,
                                                                                           gpointer self)
{
	network_widgets_popover_widget_update_vpn_connection ((NetworkWidgetsPopoverWidget*) self);
}

static void
_network_widgets_popover_widget_update_vpn_connection_nm_active_connection_state_changed (NMActiveConnection* _sender,
                                                                                          guint state,
                                                                                          guint reason,
                                                                                          gpointer self)
{
	network_widgets_popover_widget_update_vpn_connection ((NetworkWidgetsPopoverWidget*) self);
}

static void
__lambda30_ (NetworkWidgetsPopoverWidget* self,
             NMActiveConnection* ac)
{
	const gchar* connection_type = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (ac != NULL);
	_tmp0_ = nm_active_connection_get_connection_type (ac);
	connection_type = _tmp0_;
	_tmp1_ = connection_type;
	if (g_strcmp0 (_tmp1_, NM_SETTING_VPN_SETTING_NAME) == 0) {
		NMVpnConnection* _connection = NULL;
		NMVpnConnection* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
		NMVpnConnection* _tmp6_;
		guint _tmp7_;
		NMVpnConnection* _tmp8_;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (ac, nm_vpn_connection_get_type (), NMVpnConnection));
		_connection = _tmp2_;
		_tmp4_ = self->priv->_secure;
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			NMVpnConnection* _tmp5_;
			_tmp5_ = _connection;
			_tmp3_ = nm_vpn_connection_get_vpn_state (_tmp5_) == NM_VPN_CONNECTION_STATE_ACTIVATED;
		}
		network_widgets_popover_widget_set_secure (self, _tmp3_);
		_tmp6_ = _connection;
		g_signal_parse_name ("vpn-state-changed", nm_vpn_connection_get_type (), &_tmp7_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _network_widgets_popover_widget_update_vpn_connection_nm_vpn_connection_vpn_state_changed, self);
		_tmp8_ = _connection;
		g_signal_connect_object (_tmp8_, "vpn-state-changed", (GCallback) _network_widgets_popover_widget_update_vpn_connection_nm_vpn_connection_vpn_state_changed, self, 0);
		_g_object_unref0 (_connection);
	} else {
		const gchar* _tmp9_;
		_tmp9_ = connection_type;
		if (g_strcmp0 (_tmp9_, NM_SETTING_WIREGUARD_SETTING_NAME) == 0) {
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_;
			guint _tmp12_;
			_tmp11_ = self->priv->_secure;
			if (_tmp11_) {
				_tmp10_ = TRUE;
			} else {
				_tmp10_ = nm_active_connection_get_state (ac) == NM_ACTIVE_CONNECTION_STATE_ACTIVATED;
			}
			network_widgets_popover_widget_set_secure (self, _tmp10_);
			g_signal_parse_name ("state-changed", nm_active_connection_get_type (), &_tmp12_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (ac, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _network_widgets_popover_widget_update_vpn_connection_nm_active_connection_state_changed, self);
			g_signal_connect_object (ac, "state-changed", (GCallback) _network_widgets_popover_widget_update_vpn_connection_nm_active_connection_state_changed, self, 0);
		}
	}
}

static void
___lambda30__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda30_ ((NetworkWidgetsPopoverWidget*) self, (NMActiveConnection*) data);
}

static void
network_widgets_popover_widget_update_vpn_connection (NetworkWidgetsPopoverWidget* self)
{
	NMClient* _tmp0_;
	GPtrArray* _tmp1_;
	g_return_if_fail (self != NULL);
	network_widgets_popover_widget_set_secure (self, FALSE);
	_tmp0_ = self->priv->_nm_client;
	_tmp1_ = nm_client_get_active_connections (_tmp0_);
	g_ptr_array_foreach (_tmp1_, ___lambda30__gfunc, self);
}

NMClient*
network_widgets_popover_widget_get_nm_client (NetworkWidgetsPopoverWidget* self)
{
	NMClient* result;
	NMClient* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nm_client;
	result = _tmp0_;
	return result;
}

static void
network_widgets_popover_widget_set_nm_client (NetworkWidgetsPopoverWidget* self,
                                              NMClient* value)
{
	NMClient* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_widgets_popover_widget_get_nm_client (self);
	if (old_value != value) {
		NMClient* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_nm_client);
		self->priv->_nm_client = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_widgets_popover_widget_properties[NETWORK_WIDGETS_POPOVER_WIDGET_NM_CLIENT_PROPERTY]);
	}
}

GList*
network_widgets_popover_widget_get_network_interface (NetworkWidgetsPopoverWidget* self)
{
	GList* result;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_network_interface;
	result = _tmp0_;
	return result;
}

static void
network_widgets_popover_widget_set_network_interface (NetworkWidgetsPopoverWidget* self,
                                                      GList* value)
{
	GList* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_widgets_popover_widget_get_network_interface (self);
	if (old_value != value) {
		GList* _tmp0_;
		_tmp0_ = value;
		value = NULL;
		(self->priv->_network_interface == NULL) ? NULL : (self->priv->_network_interface = (_g_list_free__g_object_unref0_ (self->priv->_network_interface), NULL));
		self->priv->_network_interface = _tmp0_;
		(value == NULL) ? NULL : (value = (_g_list_free__g_object_unref0_ (value), NULL));
		g_object_notify_by_pspec ((GObject *) self, network_widgets_popover_widget_properties[NETWORK_WIDGETS_POPOVER_WIDGET_NETWORK_INTERFACE_PROPERTY]);
	}
}

gboolean
network_widgets_popover_widget_get_secure (NetworkWidgetsPopoverWidget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_secure;
	return result;
}

static void
network_widgets_popover_widget_set_secure (NetworkWidgetsPopoverWidget* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = network_widgets_popover_widget_get_secure (self);
	if (old_value != value) {
		self->priv->_secure = value;
		g_object_notify_by_pspec ((GObject *) self, network_widgets_popover_widget_properties[NETWORK_WIDGETS_POPOVER_WIDGET_SECURE_PROPERTY]);
	}
}

const gchar*
network_widgets_popover_widget_get_extra_info (NetworkWidgetsPopoverWidget* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_extra_info;
	result = _tmp0_;
	return result;
}

static void
network_widgets_popover_widget_set_extra_info (NetworkWidgetsPopoverWidget* self,
                                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_widgets_popover_widget_get_extra_info (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_extra_info);
		self->priv->_extra_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_widgets_popover_widget_properties[NETWORK_WIDGETS_POPOVER_WIDGET_EXTRA_INFO_PROPERTY]);
	}
}

NetworkState
network_widgets_popover_widget_get_state (NetworkWidgetsPopoverWidget* self)
{
	NetworkState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

static void
network_widgets_popover_widget_set_state (NetworkWidgetsPopoverWidget* self,
                                          NetworkState value)
{
	NetworkState old_value;
	g_return_if_fail (self != NULL);
	old_value = network_widgets_popover_widget_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, network_widgets_popover_widget_properties[NETWORK_WIDGETS_POPOVER_WIDGET_STATE_PROPERTY]);
	}
}

gboolean
network_widgets_popover_widget_get_is_in_session (NetworkWidgetsPopoverWidget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_in_session;
	return result;
}

static void
network_widgets_popover_widget_set_is_in_session (NetworkWidgetsPopoverWidget* self,
                                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = network_widgets_popover_widget_get_is_in_session (self);
	if (old_value != value) {
		self->priv->_is_in_session = value;
		g_object_notify_by_pspec ((GObject *) self, network_widgets_popover_widget_properties[NETWORK_WIDGETS_POPOVER_WIDGET_IS_IN_SESSION_PROPERTY]);
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		NetworkWidgetsPopoverWidget* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->airplane_toggle);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda32_ (NetworkWidgetsPopoverWidget* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		nm_client_dbus_set_property_finish (G_TYPE_CHECK_INSTANCE_CAST (obj, nm_client_get_type (), NMClient), res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("PopoverWidget.vala:101: Error setting airplane mode: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda32__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda32_ ((NetworkWidgetsPopoverWidget*) self, source_object, res);
	g_object_unref (self);
}

static void
_network_widgets_popover_widget____lambda31_ (Block4Data* _data4_)
{
	NetworkWidgetsPopoverWidget* self;
	NMClient* _tmp0_;
	GtkToggleButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GVariant* _tmp4_;
	GVariant** _tmp5_;
	GVariant** _tmp6_;
	gint _tmp6__length1;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	self = _data4_->self;
	_tmp0_ = self->priv->_nm_client;
	_tmp1_ = _data4_->airplane_toggle;
	_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_new_boolean (!_tmp3_);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = g_new0 (GVariant*, 1 + 1);
	_tmp5_[0] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 1;
	_tmp7_ = g_variant_new_tuple (_tmp6_, 1);
	g_variant_ref_sink (_tmp7_);
	_tmp8_ = _tmp7_;
	nm_client_dbus_call (_tmp0_, NM_DBUS_PATH, NM_DBUS_INTERFACE, "Enable", _tmp8_, NULL, -1, NULL, ___lambda32__gasync_ready_callback, g_object_ref (self));
	_g_variant_unref0 (_tmp8_);
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_variant_unref), NULL);
}

static void
__network_widgets_popover_widget____lambda31__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                         gpointer self)
{
	_network_widgets_popover_widget____lambda31_ (self);
}

static void
_network_widgets_popover_widget_show_settings_gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	network_widgets_popover_widget_show_settings ((NetworkWidgetsPopoverWidget*) self);
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
_network_widgets_popover_widget___lambda33_ (NetworkWidgetsPopoverWidget* self)
{
	gboolean found = FALSE;
	GList* _tmp0_;
	found = FALSE;
	_tmp0_ = self->priv->_network_interface;
	{
		GList* iface_collection = NULL;
		GList* iface_it = NULL;
		iface_collection = _tmp0_;
		for (iface_it = iface_collection; iface_it != NULL; iface_it = iface_it->next) {
			NetworkWidgetNMInterface* iface = NULL;
			iface = (NetworkWidgetNMInterface*) iface_it->data;
			{
				gboolean _tmp1_ = FALSE;
				gboolean _tmp2_ = FALSE;
				NetworkWidgetNMInterface* _tmp3_;
				_tmp3_ = iface;
				if (NETWORK_IS_WIFI_INTERFACE (_tmp3_)) {
					NetworkWidgetNMInterface* _tmp4_;
					gboolean _tmp5_;
					gboolean _tmp6_;
					_tmp4_ = iface;
					_tmp5_ = network_wifi_interface_get_hidden_sensitivity (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, NETWORK_TYPE_WIFI_INTERFACE, NetworkWifiInterface));
					_tmp6_ = _tmp5_;
					_tmp2_ = _tmp6_;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					_tmp1_ = !found;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					NetworkWidgetNMInterface* _tmp7_;
					_tmp7_ = iface;
					network_wifi_interface_connect_to_hidden (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, NETWORK_TYPE_WIFI_INTERFACE, NetworkWifiInterface));
					found = TRUE;
				}
			}
		}
	}
}

static void
__network_widgets_popover_widget___lambda33__gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self)
{
	_network_widgets_popover_widget___lambda33_ ((NetworkWidgetsPopoverWidget*) self);
}

static void
_network_widgets_popover_widget_device_added_cb_nm_client_device_added (NMClient* _sender,
                                                                        NMDevice* device,
                                                                        gpointer self)
{
	network_widgets_popover_widget_device_added_cb ((NetworkWidgetsPopoverWidget*) self, device);
}

static void
_network_widgets_popover_widget_device_removed_cb_nm_client_device_removed (NMClient* _sender,
                                                                            NMDevice* device,
                                                                            gpointer self)
{
	network_widgets_popover_widget_device_removed_cb ((NetworkWidgetsPopoverWidget*) self, device);
}

static void
_network_widgets_popover_widget_update_vpn_connection_g_object_notify (GObject* _sender,
                                                                       GParamSpec* pspec,
                                                                       gpointer self)
{
	network_widgets_popover_widget_update_vpn_connection ((NetworkWidgetsPopoverWidget*) self);
}

static GObject *
network_widgets_popover_widget_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NetworkWidgetsPopoverWidget * self;
	GtkFlowBox* _tmp0_ = NULL;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	gboolean _tmp7_;
	GtkSeparator* other_sep = NULL;
	GtkSeparator* _tmp37_ = NULL;
	GtkBox* toggle_box = NULL;
	GtkBox* _tmp38_;
	GtkBox* _tmp39_;
	GtkFlowBox* _tmp40_;
	GtkBox* _tmp41_;
	GtkSeparator* _tmp42_;
	GtkRevealer* _tmp43_;
	GtkRevealer* _tmp44_;
	GtkBox* _tmp45_;
	GtkRevealer* _tmp46_;
	GtkBox* _tmp47_;
	GtkBox* _tmp48_;
	gboolean _tmp49_;
	NetworkVpnInterface* vpn_interface = NULL;
	NMClient* _tmp58_;
	NetworkVpnInterface* _tmp59_;
	GList* _tmp60_;
	NetworkVpnInterface* _tmp61_;
	NetworkWidgetNMInterface* _tmp62_;
	NetworkVpnInterface* _tmp63_;
	GPtrArray* devices = NULL;
	NMClient* _tmp64_;
	GPtrArray* _tmp65_;
	GPtrArray* _tmp66_;
	GtkRevealer* _tmp74_;
	GtkFlowBox* _tmp75_;
	GList* _tmp76_;
	GList* _tmp77_;
	GtkModelButton* _tmp78_;
	NMClient* _tmp79_;
	NMClient* _tmp80_;
	NMClient* _tmp81_;
	NMClient* _tmp82_;
	NetworkVpnInterface* _tmp83_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (network_widgets_popover_widget_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_WIDGETS_TYPE_POPOVER_WIDGET, NetworkWidgetsPopoverWidget);
	network_widgets_popover_widget_set_network_interface (self, NULL);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp0_ = (GtkFlowBox*) gtk_flow_box_new ();
	gtk_flow_box_set_column_spacing (_tmp0_, (guint) 6);
	gtk_flow_box_set_row_spacing (_tmp0_, (guint) 12);
	gtk_flow_box_set_homogeneous (_tmp0_, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp0_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp0_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp0_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp0_, 12);
	gtk_flow_box_set_max_children_per_line (_tmp0_, (guint) 3);
	gtk_flow_box_set_selection_mode (_tmp0_, GTK_SELECTION_NONE);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->other_box);
	self->priv->other_box = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->wifi_box);
	self->priv->wifi_box = _tmp1_;
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->vpn_box);
	self->priv->vpn_box = _tmp2_;
	{
		NMClient* _tmp3_ = NULL;
		NMClient* _tmp4_;
		_tmp4_ = nm_client_new (NULL, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		network_widgets_popover_widget_set_nm_client (self, _tmp3_);
		_g_object_unref0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_critical ("PopoverWidget.vala:64: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp7_ = self->priv->_is_in_session;
	if (_tmp7_) {
		Block4Data* _data4_;
		GtkCssProvider* provider = NULL;
		GtkCssProvider* _tmp8_;
		GtkCssProvider* _tmp9_;
		GtkImage* _tmp10_;
		GtkToggleButton* _tmp11_ = NULL;
		GtkToggleButton* _tmp12_;
		GtkStyleContext* _tmp13_;
		GtkToggleButton* _tmp14_;
		GtkStyleContext* _tmp15_;
		GtkCssProvider* _tmp16_;
		GtkLabel* airplane_label = NULL;
		GtkLabel* _tmp17_;
		GtkLabel* _tmp18_;
		GtkStyleContext* _tmp19_;
		GtkBox* airplane_box = NULL;
		GtkBox* _tmp20_;
		GtkBox* _tmp21_;
		GtkToggleButton* _tmp22_;
		GtkBox* _tmp23_;
		GtkLabel* _tmp24_;
		GtkFlowBoxChild* airplane_child = NULL;
		GtkFlowBoxChild* _tmp25_ = NULL;
		GtkFlowBoxChild* _tmp26_;
		GtkBox* _tmp27_;
		GtkFlowBox* _tmp28_;
		GtkFlowBoxChild* _tmp29_;
		GtkToggleButton* _tmp30_;
		gboolean _tmp31_ = FALSE;
		GtkToggleButton* _tmp32_;
		gboolean _tmp33_;
		gboolean _tmp34_;
		_data4_ = g_slice_new0 (Block4Data);
		_data4_->_ref_count_ = 1;
		_data4_->self = g_object_ref (self);
		_tmp8_ = gtk_css_provider_new ();
		provider = _tmp8_;
		_tmp9_ = provider;
		gtk_css_provider_load_from_resource (_tmp9_, "io/elementary/wingpanel/network/Indicator.css");
		_tmp10_ = (GtkImage*) gtk_image_new_from_icon_name ("airplane-mode-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
		g_object_ref_sink (_tmp10_);
		_tmp11_ = (GtkToggleButton*) gtk_toggle_button_new ();
		gtk_widget_set_halign ((GtkWidget*) _tmp11_, GTK_ALIGN_CENTER);
		gtk_button_set_image ((GtkButton*) _tmp11_, (GtkWidget*) _tmp10_);
		_g_object_unref0 (_tmp10_);
		g_object_ref_sink (_tmp11_);
		_data4_->airplane_toggle = _tmp11_;
		_tmp12_ = _data4_->airplane_toggle;
		_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
		gtk_style_context_add_class (_tmp13_, "circular");
		_tmp14_ = _data4_->airplane_toggle;
		_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) _tmp14_);
		_tmp16_ = provider;
		gtk_style_context_add_provider (_tmp15_, (GtkStyleProvider*) _tmp16_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		_tmp17_ = (GtkLabel*) gtk_label_new (_ ("Airplane Mode"));
		g_object_ref_sink (_tmp17_);
		airplane_label = _tmp17_;
		_tmp18_ = airplane_label;
		_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) _tmp18_);
		gtk_style_context_add_class (_tmp19_, GRANITE_STYLE_CLASS_SMALL_LABEL);
		_tmp20_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 3);
		g_object_ref_sink (_tmp20_);
		airplane_box = _tmp20_;
		_tmp21_ = airplane_box;
		_tmp22_ = _data4_->airplane_toggle;
		gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
		_tmp23_ = airplane_box;
		_tmp24_ = airplane_label;
		gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
		_tmp25_ = (GtkFlowBoxChild*) gtk_flow_box_child_new ();
		gtk_widget_set_can_focus ((GtkWidget*) _tmp25_, FALSE);
		g_object_ref_sink (_tmp25_);
		airplane_child = _tmp25_;
		_tmp26_ = airplane_child;
		_tmp27_ = airplane_box;
		gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
		_tmp28_ = self->priv->other_box;
		_tmp29_ = airplane_child;
		gtk_container_add ((GtkContainer*) _tmp28_, (GtkWidget*) _tmp29_);
		_tmp30_ = _data4_->airplane_toggle;
		g_signal_connect_data (_tmp30_, "toggled", (GCallback) __network_widgets_popover_widget____lambda31__gtk_toggle_button_toggled, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
		_tmp32_ = _data4_->airplane_toggle;
		_tmp33_ = gtk_toggle_button_get_active (_tmp32_);
		_tmp34_ = _tmp33_;
		if (!_tmp34_) {
			NMClient* _tmp35_;
			_tmp35_ = self->priv->_nm_client;
			_tmp31_ = !nm_client_networking_get_enabled (_tmp35_);
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			GtkToggleButton* _tmp36_;
			_tmp36_ = _data4_->airplane_toggle;
			g_signal_emit_by_name ((GtkButton*) _tmp36_, "activate");
		}
		_g_object_unref0 (airplane_child);
		_g_object_unref0 (airplane_box);
		_g_object_unref0 (airplane_label);
		_g_object_unref0 (provider);
		block4_data_unref (_data4_);
		_data4_ = NULL;
	}
	_tmp37_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp37_, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp37_, 3);
	g_object_ref_sink (_tmp37_);
	other_sep = _tmp37_;
	_tmp38_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp38_);
	toggle_box = _tmp38_;
	_tmp39_ = toggle_box;
	_tmp40_ = self->priv->other_box;
	gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) _tmp40_);
	_tmp41_ = toggle_box;
	_tmp42_ = other_sep;
	gtk_container_add ((GtkContainer*) _tmp41_, (GtkWidget*) _tmp42_);
	_tmp43_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (self->priv->toggle_revealer);
	self->priv->toggle_revealer = _tmp43_;
	_tmp44_ = self->priv->toggle_revealer;
	_tmp45_ = toggle_box;
	gtk_container_add ((GtkContainer*) _tmp44_, (GtkWidget*) _tmp45_);
	_tmp46_ = self->priv->toggle_revealer;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp46_);
	_tmp47_ = self->priv->vpn_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp47_);
	_tmp48_ = self->priv->wifi_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp48_);
	_tmp49_ = self->priv->_is_in_session;
	if (_tmp49_) {
		GtkModelButton* _tmp50_;
		GtkModelButton* _tmp51_;
		GtkModelButton* _tmp52_;
		GtkModelButton* show_settings_button = NULL;
		GtkModelButton* _tmp53_;
		GtkModelButton* _tmp54_;
		GtkModelButton* _tmp55_;
		GtkModelButton* _tmp56_;
		GtkModelButton* _tmp57_;
		_tmp50_ = (GtkModelButton*) gtk_model_button_new ();
		g_object_ref_sink (_tmp50_);
		_g_object_unref0 (self->priv->hidden_item);
		self->priv->hidden_item = _tmp50_;
		_tmp51_ = self->priv->hidden_item;
		g_object_set (_tmp51_, "text", _ ("Connect to Hidden Network…"), NULL);
		_tmp52_ = self->priv->hidden_item;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp52_, TRUE);
		_tmp53_ = (GtkModelButton*) gtk_model_button_new ();
		g_object_ref_sink (_tmp53_);
		show_settings_button = _tmp53_;
		_tmp54_ = show_settings_button;
		g_object_set (_tmp54_, "text", _ ("Network Settings…"), NULL);
		_tmp55_ = self->priv->hidden_item;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp55_);
		_tmp56_ = show_settings_button;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp56_);
		_tmp57_ = show_settings_button;
		g_signal_connect_object ((GtkButton*) _tmp57_, "clicked", (GCallback) _network_widgets_popover_widget_show_settings_gtk_button_clicked, self, 0);
		_g_object_unref0 (show_settings_button);
	}
	_tmp58_ = self->priv->_nm_client;
	_tmp59_ = network_vpn_interface_new (_tmp58_);
	g_object_ref_sink (_tmp59_);
	vpn_interface = _tmp59_;
	_tmp60_ = self->priv->_network_interface;
	_tmp61_ = vpn_interface;
	_tmp62_ = _g_object_ref0 ((NetworkWidgetNMInterface*) _tmp61_);
	network_widgets_popover_widget_set_network_interface (self, g_list_append (_tmp60_, _tmp62_));
	_tmp63_ = vpn_interface;
	network_widgets_popover_widget_add_interface (self, (NetworkWidgetNMInterface*) _tmp63_);
	_tmp64_ = self->priv->_nm_client;
	_tmp65_ = nm_client_get_devices (_tmp64_);
	_tmp66_ = _g_ptr_array_ref0 (_tmp65_);
	devices = _tmp66_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp67_ = FALSE;
			_tmp67_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp69_;
				gint _tmp70_;
				gint _tmp71_;
				GPtrArray* _tmp72_;
				gconstpointer _tmp73_;
				if (!_tmp67_) {
					gint _tmp68_;
					_tmp68_ = i;
					i = _tmp68_ + 1;
				}
				_tmp67_ = FALSE;
				_tmp69_ = devices;
				_tmp70_ = vala_g_ptr_array_get_length (_tmp69_);
				_tmp71_ = _tmp70_;
				if (!(i < _tmp71_)) {
					break;
				}
				_tmp72_ = devices;
				_tmp73_ = g_ptr_array_index (_tmp72_, (guint) i);
				network_widgets_popover_widget_device_added_cb (self, (NMDevice*) _tmp73_);
			}
		}
	}
	_tmp74_ = self->priv->toggle_revealer;
	_tmp75_ = self->priv->other_box;
	_tmp76_ = gtk_container_get_children ((GtkContainer*) _tmp75_);
	_tmp77_ = _tmp76_;
	gtk_revealer_set_reveal_child (_tmp74_, _tmp77_ != NULL);
	(_tmp77_ == NULL) ? NULL : (_tmp77_ = (g_list_free (_tmp77_), NULL));
	gtk_widget_show_all ((GtkWidget*) self);
	network_widgets_popover_widget_update_vpn_connection (self);
	_tmp78_ = self->priv->hidden_item;
	g_signal_connect_object ((GtkButton*) _tmp78_, "clicked", (GCallback) __network_widgets_popover_widget___lambda33__gtk_button_clicked, self, 0);
	_tmp79_ = self->priv->_nm_client;
	g_signal_connect_object (_tmp79_, "device-added", (GCallback) _network_widgets_popover_widget_device_added_cb_nm_client_device_added, self, 0);
	_tmp80_ = self->priv->_nm_client;
	g_signal_connect_object (_tmp80_, "device-removed", (GCallback) _network_widgets_popover_widget_device_removed_cb_nm_client_device_removed, self, 0);
	_tmp81_ = self->priv->_nm_client;
	g_signal_connect_object ((GObject*) _tmp81_, "notify::active-connections", (GCallback) _network_widgets_popover_widget_update_vpn_connection_g_object_notify, self, 0);
	_tmp82_ = self->priv->_nm_client;
	g_signal_connect_object ((GObject*) _tmp82_, "notify::networking-enabled", (GCallback) _network_widgets_popover_widget_update_state_g_object_notify, self, 0);
	_tmp83_ = vpn_interface;
	g_signal_connect_object ((GObject*) _tmp83_, "notify::state", (GCallback) _network_widgets_popover_widget_update_state_g_object_notify, self, 0);
	_g_ptr_array_unref0 (devices);
	_g_object_unref0 (vpn_interface);
	_g_object_unref0 (toggle_box);
	_g_object_unref0 (other_sep);
	return obj;
}

static void
network_widgets_popover_widget_class_init (NetworkWidgetsPopoverWidgetClass * klass,
                                           gpointer klass_data)
{
	network_widgets_popover_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkWidgetsPopoverWidget_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_network_widgets_popover_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_network_widgets_popover_widget_set_property;
	G_OBJECT_CLASS (klass)->constructor = network_widgets_popover_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = network_widgets_popover_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIDGETS_POPOVER_WIDGET_NM_CLIENT_PROPERTY, network_widgets_popover_widget_properties[NETWORK_WIDGETS_POPOVER_WIDGET_NM_CLIENT_PROPERTY] = g_param_spec_object ("nm-client", "nm-client", "nm-client", nm_client_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIDGETS_POPOVER_WIDGET_NETWORK_INTERFACE_PROPERTY, network_widgets_popover_widget_properties[NETWORK_WIDGETS_POPOVER_WIDGET_NETWORK_INTERFACE_PROPERTY] = g_param_spec_pointer ("network-interface", "network-interface", "network-interface", G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIDGETS_POPOVER_WIDGET_SECURE_PROPERTY, network_widgets_popover_widget_properties[NETWORK_WIDGETS_POPOVER_WIDGET_SECURE_PROPERTY] = g_param_spec_boolean ("secure", "secure", "secure", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIDGETS_POPOVER_WIDGET_EXTRA_INFO_PROPERTY, network_widgets_popover_widget_properties[NETWORK_WIDGETS_POPOVER_WIDGET_EXTRA_INFO_PROPERTY] = g_param_spec_string ("extra-info", "extra-info", "extra-info", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIDGETS_POPOVER_WIDGET_STATE_PROPERTY, network_widgets_popover_widget_properties[NETWORK_WIDGETS_POPOVER_WIDGET_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", NETWORK_TYPE_STATE, NETWORK_STATE_CONNECTING_WIRED, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_WIDGETS_POPOVER_WIDGET_IS_IN_SESSION_PROPERTY, network_widgets_popover_widget_properties[NETWORK_WIDGETS_POPOVER_WIDGET_IS_IN_SESSION_PROPERTY] = g_param_spec_boolean ("is-in-session", "is-in-session", "is-in-session", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	network_widgets_popover_widget_signals[NETWORK_WIDGETS_POPOVER_WIDGET_SETTINGS_SHOWN_SIGNAL] = g_signal_new ("settings-shown", NETWORK_WIDGETS_TYPE_POPOVER_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
network_widgets_popover_widget_instance_init (NetworkWidgetsPopoverWidget * self,
                                              gpointer klass)
{
	self->priv = network_widgets_popover_widget_get_instance_private (self);
	self->priv->_secure = FALSE;
	self->priv->_extra_info = NULL;
	self->priv->_state = NETWORK_STATE_CONNECTING_WIRED;
}

static void
network_widgets_popover_widget_finalize (GObject * obj)
{
	NetworkWidgetsPopoverWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_WIDGETS_TYPE_POPOVER_WIDGET, NetworkWidgetsPopoverWidget);
	_g_object_unref0 (self->priv->_nm_client);
	(self->priv->_network_interface == NULL) ? NULL : (self->priv->_network_interface = (_g_list_free__g_object_unref0_ (self->priv->_network_interface), NULL));
	_g_free0 (self->priv->_extra_info);
	_g_object_unref0 (self->priv->other_box);
	_g_object_unref0 (self->priv->wifi_box);
	_g_object_unref0 (self->priv->vpn_box);
	_g_object_unref0 (self->priv->hidden_item);
	_g_object_unref0 (self->priv->toggle_revealer);
	G_OBJECT_CLASS (network_widgets_popover_widget_parent_class)->finalize (obj);
}

static GType
network_widgets_popover_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkWidgetsPopoverWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_widgets_popover_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkWidgetsPopoverWidget), 0, (GInstanceInitFunc) network_widgets_popover_widget_instance_init, NULL };
	GType network_widgets_popover_widget_type_id;
	network_widgets_popover_widget_type_id = g_type_register_static (gtk_grid_get_type (), "NetworkWidgetsPopoverWidget", &g_define_type_info, 0);
	NetworkWidgetsPopoverWidget_private_offset = g_type_add_instance_private (network_widgets_popover_widget_type_id, sizeof (NetworkWidgetsPopoverWidgetPrivate));
	return network_widgets_popover_widget_type_id;
}

GType
network_widgets_popover_widget_get_type (void)
{
	static volatile gsize network_widgets_popover_widget_type_id__once = 0;
	if (g_once_init_enter (&network_widgets_popover_widget_type_id__once)) {
		GType network_widgets_popover_widget_type_id;
		network_widgets_popover_widget_type_id = network_widgets_popover_widget_get_type_once ();
		g_once_init_leave (&network_widgets_popover_widget_type_id__once, network_widgets_popover_widget_type_id);
	}
	return network_widgets_popover_widget_type_id__once;
}

static void
_vala_network_widgets_popover_widget_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	NetworkWidgetsPopoverWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_WIDGETS_TYPE_POPOVER_WIDGET, NetworkWidgetsPopoverWidget);
	switch (property_id) {
		case NETWORK_WIDGETS_POPOVER_WIDGET_NM_CLIENT_PROPERTY:
		g_value_set_object (value, network_widgets_popover_widget_get_nm_client (self));
		break;
		case NETWORK_WIDGETS_POPOVER_WIDGET_NETWORK_INTERFACE_PROPERTY:
		g_value_set_pointer (value, network_widgets_popover_widget_get_network_interface (self));
		break;
		case NETWORK_WIDGETS_POPOVER_WIDGET_SECURE_PROPERTY:
		g_value_set_boolean (value, network_widgets_popover_widget_get_secure (self));
		break;
		case NETWORK_WIDGETS_POPOVER_WIDGET_EXTRA_INFO_PROPERTY:
		g_value_set_string (value, network_widgets_popover_widget_get_extra_info (self));
		break;
		case NETWORK_WIDGETS_POPOVER_WIDGET_STATE_PROPERTY:
		g_value_set_enum (value, network_widgets_popover_widget_get_state (self));
		break;
		case NETWORK_WIDGETS_POPOVER_WIDGET_IS_IN_SESSION_PROPERTY:
		g_value_set_boolean (value, network_widgets_popover_widget_get_is_in_session (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_network_widgets_popover_widget_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	NetworkWidgetsPopoverWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_WIDGETS_TYPE_POPOVER_WIDGET, NetworkWidgetsPopoverWidget);
	switch (property_id) {
		case NETWORK_WIDGETS_POPOVER_WIDGET_NM_CLIENT_PROPERTY:
		network_widgets_popover_widget_set_nm_client (self, g_value_get_object (value));
		break;
		case NETWORK_WIDGETS_POPOVER_WIDGET_NETWORK_INTERFACE_PROPERTY:
		network_widgets_popover_widget_set_network_interface (self, g_value_get_pointer (value));
		break;
		case NETWORK_WIDGETS_POPOVER_WIDGET_SECURE_PROPERTY:
		network_widgets_popover_widget_set_secure (self, g_value_get_boolean (value));
		break;
		case NETWORK_WIDGETS_POPOVER_WIDGET_EXTRA_INFO_PROPERTY:
		network_widgets_popover_widget_set_extra_info (self, g_value_get_string (value));
		break;
		case NETWORK_WIDGETS_POPOVER_WIDGET_STATE_PROPERTY:
		network_widgets_popover_widget_set_state (self, g_value_get_enum (value));
		break;
		case NETWORK_WIDGETS_POPOVER_WIDGET_IS_IN_SESSION_PROPERTY:
		network_widgets_popover_widget_set_is_in_session (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

