/* PopoverWidget.c generated by valac 0.56.17, the Vala compiler
 * generated from PopoverWidget.vala, do not modify */

/*-
 * Copyright (c) 2015-2023 elementary LLC. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "bluetooth.h"
#include <glib.h>
#include <granite.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_0_PROPERTY,
	BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_OBJECT_MANAGER_PROPERTY,
	BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_OBEX_MANAGER_PROPERTY,
	BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_IS_IN_SESSION_PROPERTY,
	BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_NUM_PROPERTIES
};
static GParamSpec* bluetooth_indicator_widgets_popover_widget_properties[BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block11Data Block11Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_DEVICE_REQUESTED_SIGNAL,
	BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_DISCOVERY_REQUESTED_SIGNAL,
	BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_NUM_SIGNALS
};
static guint bluetooth_indicator_widgets_popover_widget_signals[BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_NUM_SIGNALS] = {0};

struct _BluetoothIndicatorWidgetsPopoverWidgetPrivate {
	BluetoothIndicatorServicesObjectManager* _object_manager;
	BluetoothIndicatorServicesObexManager* _obex_manager;
	gboolean _is_in_session;
	GraniteSwitchModelButton* main_switch;
	GtkListBox* devices_list;
	GtkRevealer* revealer;
};

struct _Block11Data {
	int _ref_count_;
	BluetoothIndicatorWidgetsPopoverWidget* self;
	BluetoothIndicatorServicesDevice* device;
};

static gint BluetoothIndicatorWidgetsPopoverWidget_private_offset;
static gpointer bluetooth_indicator_widgets_popover_widget_parent_class = NULL;

static gint bluetooth_indicator_widgets_popover_widget_compare_rows (GtkListBoxRow* row1,
                                                              GtkListBoxRow* row2,
                                                              BluetoothIndicatorWidgetsPopoverWidget* self);
static void bluetooth_indicator_widgets_popover_widget_update_ui_state (BluetoothIndicatorWidgetsPopoverWidget* self,
                                                                 gboolean state);
static void bluetooth_indicator_widgets_popover_widget_update_devices_box_visible (BluetoothIndicatorWidgetsPopoverWidget* self);
static void bluetooth_indicator_widgets_popover_widget_add_device (BluetoothIndicatorWidgetsPopoverWidget* self,
                                                            BluetoothIndicatorServicesDevice* device);
static void __lambda23_ (BluetoothIndicatorWidgetsPopoverWidget* self,
                  BluetoothIndicatorServicesDevice* device_service);
static void ___lambda23__bluetooth_indicator_widgets_device_show_device (BluetoothIndicatorWidgetsDevice* _sender,
                                                                  BluetoothIndicatorServicesDevice* device,
                                                                  gpointer self);
static void bluetooth_indicator_widgets_popover_widget_remove_device (BluetoothIndicatorWidgetsPopoverWidget* self,
                                                               BluetoothIndicatorServicesDevice* device);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void __lambda24_ (Block11Data* _data11_,
                  GtkWidget* row);
static void ___lambda24__gfunc (gconstpointer data,
                         gpointer self);
static GObject * bluetooth_indicator_widgets_popover_widget_constructor (GType type,
                                                                  guint n_construct_properties,
                                                                  GObjectConstructParam * construct_properties);
static void _bluetooth_indicator_widgets_popover_widget___lambda25_ (BluetoothIndicatorWidgetsPopoverWidget* self,
                                                              GtkListBoxRow* row);
static void __bluetooth_indicator_widgets_popover_widget___lambda25__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                                          GtkListBoxRow* row,
                                                                                          gpointer self);
static void _bluetooth_indicator_widgets_popover_widget___lambda26_ (BluetoothIndicatorWidgetsPopoverWidget* self);
static void __bluetooth_indicator_widgets_popover_widget___lambda26__g_object_notify (GObject* _sender,
                                                                               GParamSpec* pspec,
                                                                               gpointer self);
static void _bluetooth_indicator_widgets_popover_widget___lambda27_ (BluetoothIndicatorWidgetsPopoverWidget* self);
static void __bluetooth_indicator_widgets_popover_widget___lambda27__gtk_button_clicked (GtkButton* _sender,
                                                                                  gpointer self);
static void _bluetooth_indicator_widgets_popover_widget___lambda28_ (BluetoothIndicatorWidgetsPopoverWidget* self,
                                                              gboolean state,
                                                              gboolean paired);
static void __bluetooth_indicator_widgets_popover_widget___lambda28__bluetooth_indicator_services_object_manager_global_state_changed (BluetoothIndicatorServicesObjectManager* _sender,
                                                                                                                                gboolean enabled,
                                                                                                                                gboolean connected,
                                                                                                                                gpointer self);
static void _bluetooth_indicator_widgets_popover_widget___lambda29_ (BluetoothIndicatorWidgetsPopoverWidget* self,
                                                              BluetoothIndicatorServicesDevice* device);
static void __bluetooth_indicator_widgets_popover_widget___lambda29__bluetooth_indicator_services_object_manager_device_added (BluetoothIndicatorServicesObjectManager* _sender,
                                                                                                                        BluetoothIndicatorServicesDevice* adapter,
                                                                                                                        gpointer self);
static void _bluetooth_indicator_widgets_popover_widget___lambda30_ (BluetoothIndicatorWidgetsPopoverWidget* self,
                                                              BluetoothIndicatorServicesDevice* device);
static void __bluetooth_indicator_widgets_popover_widget___lambda30__bluetooth_indicator_services_object_manager_device_removed (BluetoothIndicatorServicesObjectManager* _sender,
                                                                                                                          BluetoothIndicatorServicesDevice* adapter,
                                                                                                                          gpointer self);
static void bluetooth_indicator_widgets_popover_widget_finalize (GObject * obj);
static GType bluetooth_indicator_widgets_popover_widget_get_type_once (void);
static void _vala_bluetooth_indicator_widgets_popover_widget_get_property (GObject * object,
                                                                    guint property_id,
                                                                    GValue * value,
                                                                    GParamSpec * pspec);
static void _vala_bluetooth_indicator_widgets_popover_widget_set_property (GObject * object,
                                                                    guint property_id,
                                                                    const GValue * value,
                                                                    GParamSpec * pspec);

static inline gpointer
bluetooth_indicator_widgets_popover_widget_get_instance_private (BluetoothIndicatorWidgetsPopoverWidget* self)
{
	return G_STRUCT_MEMBER_P (self, BluetoothIndicatorWidgetsPopoverWidget_private_offset);
}

BluetoothIndicatorWidgetsPopoverWidget*
bluetooth_indicator_widgets_popover_widget_construct (GType object_type,
                                                      BluetoothIndicatorServicesObjectManager* object_manager,
                                                      BluetoothIndicatorServicesObexManager* obex_manager,
                                                      gboolean is_in_session)
{
	BluetoothIndicatorWidgetsPopoverWidget * self = NULL;
	g_return_val_if_fail (object_manager != NULL, NULL);
	g_return_val_if_fail (obex_manager != NULL, NULL);
	self = (BluetoothIndicatorWidgetsPopoverWidget*) g_object_new (object_type, "object-manager", object_manager, "obex-manager", obex_manager, "is-in-session", is_in_session, NULL);
	return self;
}

BluetoothIndicatorWidgetsPopoverWidget*
bluetooth_indicator_widgets_popover_widget_new (BluetoothIndicatorServicesObjectManager* object_manager,
                                                BluetoothIndicatorServicesObexManager* obex_manager,
                                                gboolean is_in_session)
{
	return bluetooth_indicator_widgets_popover_widget_construct (BLUETOOTH_INDICATOR_WIDGETS_TYPE_POPOVER_WIDGET, object_manager, obex_manager, is_in_session);
}

static gint
bluetooth_indicator_widgets_popover_widget_compare_rows (GtkListBoxRow* row1,
                                                         GtkListBoxRow* row2,
                                                         BluetoothIndicatorWidgetsPopoverWidget* self)
{
	BluetoothIndicatorServicesDevice* device1 = NULL;
	BluetoothIndicatorServicesDevice* _tmp0_;
	BluetoothIndicatorServicesDevice* _tmp1_;
	BluetoothIndicatorServicesDevice* device2 = NULL;
	BluetoothIndicatorServicesDevice* _tmp2_;
	BluetoothIndicatorServicesDevice* _tmp3_;
	gboolean _tmp4_ = FALSE;
	BluetoothIndicatorServicesDevice* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp14_ = FALSE;
	BluetoothIndicatorServicesDevice* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gboolean _tmp19_;
	gchar* _tmp24_ = NULL;
	BluetoothIndicatorServicesDevice* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* name1 = NULL;
	gchar* _tmp31_;
	gchar* _tmp32_ = NULL;
	BluetoothIndicatorServicesDevice* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* name2 = NULL;
	gchar* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = bluetooth_indicator_widgets_device_get_device (G_TYPE_CHECK_INSTANCE_CAST (row1, BLUETOOTH_INDICATOR_WIDGETS_TYPE_DEVICE, BluetoothIndicatorWidgetsDevice));
	_tmp1_ = _tmp0_;
	device1 = _tmp1_;
	_tmp2_ = bluetooth_indicator_widgets_device_get_device (G_TYPE_CHECK_INSTANCE_CAST (row2, BLUETOOTH_INDICATOR_WIDGETS_TYPE_DEVICE, BluetoothIndicatorWidgetsDevice));
	_tmp3_ = _tmp2_;
	device2 = _tmp3_;
	_tmp5_ = device1;
	_tmp6_ = bluetooth_indicator_services_device_get_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ != NULL;
	_g_free0 (_tmp8_);
	if (_tmp9_) {
		BluetoothIndicatorServicesDevice* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp10_ = device2;
		_tmp11_ = bluetooth_indicator_services_device_get_name (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp4_ = _tmp13_ == NULL;
		_g_free0 (_tmp13_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = -1;
		return result;
	}
	_tmp15_ = device1;
	_tmp16_ = bluetooth_indicator_services_device_get_name (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp17_;
	_tmp19_ = _tmp18_ == NULL;
	_g_free0 (_tmp18_);
	if (_tmp19_) {
		BluetoothIndicatorServicesDevice* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp20_ = device2;
		_tmp21_ = bluetooth_indicator_services_device_get_name (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_;
		_tmp14_ = _tmp23_ != NULL;
		_g_free0 (_tmp23_);
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		result = 1;
		return result;
	}
	_tmp25_ = device1;
	_tmp26_ = bluetooth_indicator_services_device_get_name (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp24_ = _tmp27_;
	if (_tmp24_ == NULL) {
		BluetoothIndicatorServicesDevice* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp28_ = device1;
		_tmp29_ = bluetooth_indicator_services_device_get_address (_tmp28_);
		_tmp30_ = _tmp29_;
		_g_free0 (_tmp24_);
		_tmp24_ = _tmp30_;
	}
	_tmp31_ = _tmp24_;
	_tmp24_ = NULL;
	name1 = _tmp31_;
	_tmp33_ = device2;
	_tmp34_ = bluetooth_indicator_services_device_get_name (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp32_ = _tmp35_;
	if (_tmp32_ == NULL) {
		BluetoothIndicatorServicesDevice* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		_tmp36_ = device2;
		_tmp37_ = bluetooth_indicator_services_device_get_address (_tmp36_);
		_tmp38_ = _tmp37_;
		_g_free0 (_tmp32_);
		_tmp32_ = _tmp38_;
	}
	_tmp39_ = _tmp32_;
	_tmp32_ = NULL;
	name2 = _tmp39_;
	_tmp40_ = name1;
	_tmp41_ = name2;
	result = g_utf8_collate (_tmp40_, _tmp41_);
	_g_free0 (name2);
	_g_free0 (_tmp32_);
	_g_free0 (name1);
	_g_free0 (_tmp24_);
	return result;
}

static void
bluetooth_indicator_widgets_popover_widget_update_ui_state (BluetoothIndicatorWidgetsPopoverWidget* self,
                                                            gboolean state)
{
	GraniteSwitchModelButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkListBox* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_switch;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != state) {
		GraniteSwitchModelButton* _tmp3_;
		_tmp3_ = self->priv->main_switch;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp3_, state);
	}
	_tmp4_ = self->priv->devices_list;
	gtk_list_box_invalidate_sort (_tmp4_);
	bluetooth_indicator_widgets_popover_widget_update_devices_box_visible (self);
}

static void
bluetooth_indicator_widgets_popover_widget_update_devices_box_visible (BluetoothIndicatorWidgetsPopoverWidget* self)
{
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->devices_list;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_list_free (_tmp2_), NULL));
	if (_tmp3_) {
		GtkRevealer* _tmp4_;
		GraniteSwitchModelButton* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = self->priv->revealer;
		_tmp5_ = self->priv->main_switch;
		_tmp6_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp5_);
		_tmp7_ = _tmp6_;
		gtk_revealer_set_reveal_child (_tmp4_, _tmp7_);
	} else {
		GtkRevealer* _tmp8_;
		_tmp8_ = self->priv->revealer;
		gtk_revealer_set_reveal_child (_tmp8_, FALSE);
	}
}

static void
__lambda23_ (BluetoothIndicatorWidgetsPopoverWidget* self,
             BluetoothIndicatorServicesDevice* device_service)
{
	g_return_if_fail (device_service != NULL);
	g_signal_emit (self, bluetooth_indicator_widgets_popover_widget_signals[BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_DEVICE_REQUESTED_SIGNAL], 0, device_service);
}

static void
___lambda23__bluetooth_indicator_widgets_device_show_device (BluetoothIndicatorWidgetsDevice* _sender,
                                                             BluetoothIndicatorServicesDevice* device,
                                                             gpointer self)
{
	__lambda23_ ((BluetoothIndicatorWidgetsPopoverWidget*) self, device);
}

static void
bluetooth_indicator_widgets_popover_widget_add_device (BluetoothIndicatorWidgetsPopoverWidget* self,
                                                       BluetoothIndicatorServicesDevice* device)
{
	BluetoothIndicatorWidgetsDevice* device_widget = NULL;
	BluetoothIndicatorServicesObexManager* _tmp0_;
	BluetoothIndicatorWidgetsDevice* _tmp1_;
	GtkListBox* _tmp2_;
	GtkListBox* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = self->priv->_obex_manager;
	_tmp1_ = bluetooth_indicator_widgets_device_new (device, _tmp0_);
	g_object_ref_sink (_tmp1_);
	device_widget = _tmp1_;
	_tmp2_ = self->priv->devices_list;
	gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) device_widget);
	_tmp3_ = self->priv->devices_list;
	gtk_widget_show_all ((GtkWidget*) _tmp3_);
	bluetooth_indicator_widgets_popover_widget_update_devices_box_visible (self);
	g_signal_connect_object (device_widget, "show-device", (GCallback) ___lambda23__bluetooth_indicator_widgets_device_show_device, self, 0);
	_g_object_unref0 (device_widget);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		BluetoothIndicatorWidgetsPopoverWidget* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->device);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static void
__lambda24_ (Block11Data* _data11_,
             GtkWidget* row)
{
	BluetoothIndicatorWidgetsPopoverWidget* self;
	BluetoothIndicatorWidgetsDevice* device_child = NULL;
	BluetoothIndicatorWidgetsDevice* _tmp0_;
	gboolean _tmp1_ = FALSE;
	BluetoothIndicatorWidgetsDevice* _tmp2_;
	self = _data11_->self;
	g_return_if_fail (row != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (row, gtk_list_box_row_get_type (), GtkListBoxRow), BLUETOOTH_INDICATOR_WIDGETS_TYPE_DEVICE, BluetoothIndicatorWidgetsDevice));
	device_child = _tmp0_;
	_tmp2_ = device_child;
	if (_tmp2_ != NULL) {
		BluetoothIndicatorWidgetsDevice* _tmp3_;
		BluetoothIndicatorServicesDevice* _tmp4_;
		BluetoothIndicatorServicesDevice* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp3_ = device_child;
		_tmp4_ = bluetooth_indicator_widgets_device_get_device (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = bluetooth_indicator_services_device_get_address (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = bluetooth_indicator_services_device_get_address (_data11_->device);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_;
		_tmp1_ = g_strcmp0 (_tmp8_, _tmp11_) == 0;
		_g_free0 (_tmp11_);
		_g_free0 (_tmp8_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gtk_widget_destroy (row);
	}
	_g_object_unref0 (device_child);
}

static void
___lambda24__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda24_ (self, (GtkWidget*) data);
}

static void
bluetooth_indicator_widgets_popover_widget_remove_device (BluetoothIndicatorWidgetsPopoverWidget* self,
                                                          BluetoothIndicatorServicesDevice* device)
{
	Block11Data* _data11_;
	BluetoothIndicatorServicesDevice* _tmp0_;
	GtkListBox* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (device);
	_g_object_unref0 (_data11_->device);
	_data11_->device = _tmp0_;
	_tmp1_ = self->priv->devices_list;
	_tmp2_ = gtk_container_get_children ((GtkContainer*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_list_foreach (_tmp3_, ___lambda24__gfunc, _data11_);
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (g_list_free (_tmp3_), NULL));
	block11_data_unref (_data11_);
	_data11_ = NULL;
}

BluetoothIndicatorServicesObjectManager*
bluetooth_indicator_widgets_popover_widget_get_object_manager (BluetoothIndicatorWidgetsPopoverWidget* self)
{
	BluetoothIndicatorServicesObjectManager* result;
	BluetoothIndicatorServicesObjectManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_object_manager;
	result = _tmp0_;
	return result;
}

static void
bluetooth_indicator_widgets_popover_widget_set_object_manager (BluetoothIndicatorWidgetsPopoverWidget* self,
                                                               BluetoothIndicatorServicesObjectManager* value)
{
	BluetoothIndicatorServicesObjectManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = bluetooth_indicator_widgets_popover_widget_get_object_manager (self);
	if (old_value != value) {
		BluetoothIndicatorServicesObjectManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_object_manager);
		self->priv->_object_manager = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, bluetooth_indicator_widgets_popover_widget_properties[BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_OBJECT_MANAGER_PROPERTY]);
	}
}

BluetoothIndicatorServicesObexManager*
bluetooth_indicator_widgets_popover_widget_get_obex_manager (BluetoothIndicatorWidgetsPopoverWidget* self)
{
	BluetoothIndicatorServicesObexManager* result;
	BluetoothIndicatorServicesObexManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_obex_manager;
	result = _tmp0_;
	return result;
}

static void
bluetooth_indicator_widgets_popover_widget_set_obex_manager (BluetoothIndicatorWidgetsPopoverWidget* self,
                                                             BluetoothIndicatorServicesObexManager* value)
{
	BluetoothIndicatorServicesObexManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = bluetooth_indicator_widgets_popover_widget_get_obex_manager (self);
	if (old_value != value) {
		BluetoothIndicatorServicesObexManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_obex_manager);
		self->priv->_obex_manager = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, bluetooth_indicator_widgets_popover_widget_properties[BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_OBEX_MANAGER_PROPERTY]);
	}
}

gboolean
bluetooth_indicator_widgets_popover_widget_get_is_in_session (BluetoothIndicatorWidgetsPopoverWidget* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_in_session;
	return result;
}

static void
bluetooth_indicator_widgets_popover_widget_set_is_in_session (BluetoothIndicatorWidgetsPopoverWidget* self,
                                                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = bluetooth_indicator_widgets_popover_widget_get_is_in_session (self);
	if (old_value != value) {
		self->priv->_is_in_session = value;
		g_object_notify_by_pspec ((GObject *) self, bluetooth_indicator_widgets_popover_widget_properties[BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_IS_IN_SESSION_PROPERTY]);
	}
}

static void
_bluetooth_indicator_widgets_popover_widget___lambda25_ (BluetoothIndicatorWidgetsPopoverWidget* self,
                                                         GtkListBoxRow* row)
{
	g_return_if_fail (row != NULL);
	bluetooth_indicator_widgets_device_toggle_device (G_TYPE_CHECK_INSTANCE_CAST (row, BLUETOOTH_INDICATOR_WIDGETS_TYPE_DEVICE, BluetoothIndicatorWidgetsDevice), NULL, NULL);
}

static void
__bluetooth_indicator_widgets_popover_widget___lambda25__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                                     GtkListBoxRow* row,
                                                                                     gpointer self)
{
	_bluetooth_indicator_widgets_popover_widget___lambda25_ ((BluetoothIndicatorWidgetsPopoverWidget*) self, row);
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static void
_bluetooth_indicator_widgets_popover_widget___lambda26_ (BluetoothIndicatorWidgetsPopoverWidget* self)
{
	GraniteSwitchModelButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	BluetoothIndicatorServicesObjectManager* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GraniteSwitchModelButton* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	_tmp0_ = self->priv->main_switch;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = bool_to_string (_tmp2_);
	_tmp4_ = _tmp3_;
	g_warning ("PopoverWidget.vala:95: main switch toggle - active %s", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->_object_manager;
	_tmp6_ = bluetooth_indicator_services_object_manager_get_settings (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->main_switch;
	_tmp9_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp8_);
	_tmp10_ = _tmp9_;
	g_settings_set_boolean (_tmp7_, "bluetooth-enabled", _tmp10_);
}

static void
__bluetooth_indicator_widgets_popover_widget___lambda26__g_object_notify (GObject* _sender,
                                                                          GParamSpec* pspec,
                                                                          gpointer self)
{
	_bluetooth_indicator_widgets_popover_widget___lambda26_ ((BluetoothIndicatorWidgetsPopoverWidget*) self);
}

static void
_bluetooth_indicator_widgets_popover_widget___lambda27_ (BluetoothIndicatorWidgetsPopoverWidget* self)
{
	GError* _inner_error0_ = NULL;
	{
		g_app_info_launch_default_for_uri ("settings://network/bluetooth", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("PopoverWidget.vala:103: Failed to open bluetooth settings: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__bluetooth_indicator_widgets_popover_widget___lambda27__gtk_button_clicked (GtkButton* _sender,
                                                                             gpointer self)
{
	_bluetooth_indicator_widgets_popover_widget___lambda27_ ((BluetoothIndicatorWidgetsPopoverWidget*) self);
}

static void
_bluetooth_indicator_widgets_popover_widget___lambda28_ (BluetoothIndicatorWidgetsPopoverWidget* self,
                                                         gboolean state,
                                                         gboolean paired)
{
	bluetooth_indicator_widgets_popover_widget_update_ui_state (self, state);
}

static void
__bluetooth_indicator_widgets_popover_widget___lambda28__bluetooth_indicator_services_object_manager_global_state_changed (BluetoothIndicatorServicesObjectManager* _sender,
                                                                                                                           gboolean enabled,
                                                                                                                           gboolean connected,
                                                                                                                           gpointer self)
{
	_bluetooth_indicator_widgets_popover_widget___lambda28_ ((BluetoothIndicatorWidgetsPopoverWidget*) self, enabled, connected);
}

static void
_bluetooth_indicator_widgets_popover_widget___lambda29_ (BluetoothIndicatorWidgetsPopoverWidget* self,
                                                         BluetoothIndicatorServicesDevice* device)
{
	g_return_if_fail (device != NULL);
	bluetooth_indicator_widgets_popover_widget_remove_device (self, device);
	bluetooth_indicator_widgets_popover_widget_add_device (self, device);
}

static void
__bluetooth_indicator_widgets_popover_widget___lambda29__bluetooth_indicator_services_object_manager_device_added (BluetoothIndicatorServicesObjectManager* _sender,
                                                                                                                   BluetoothIndicatorServicesDevice* adapter,
                                                                                                                   gpointer self)
{
	_bluetooth_indicator_widgets_popover_widget___lambda29_ ((BluetoothIndicatorWidgetsPopoverWidget*) self, adapter);
}

static void
_bluetooth_indicator_widgets_popover_widget___lambda30_ (BluetoothIndicatorWidgetsPopoverWidget* self,
                                                         BluetoothIndicatorServicesDevice* device)
{
	g_return_if_fail (device != NULL);
	bluetooth_indicator_widgets_popover_widget_remove_device (self, device);
	bluetooth_indicator_widgets_popover_widget_update_devices_box_visible (self);
}

static void
__bluetooth_indicator_widgets_popover_widget___lambda30__bluetooth_indicator_services_object_manager_device_removed (BluetoothIndicatorServicesObjectManager* _sender,
                                                                                                                     BluetoothIndicatorServicesDevice* adapter,
                                                                                                                     gpointer self)
{
	_bluetooth_indicator_widgets_popover_widget___lambda30_ ((BluetoothIndicatorWidgetsPopoverWidget*) self, adapter);
}

static GObject *
bluetooth_indicator_widgets_popover_widget_constructor (GType type,
                                                        guint n_construct_properties,
                                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BluetoothIndicatorWidgetsPopoverWidget * self;
	BluetoothIndicatorServicesObjectManager* _tmp0_;
	GraniteSwitchModelButton* _tmp1_ = NULL;
	GraniteSwitchModelButton* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkListBox* _tmp4_;
	GtkListBox* _tmp5_;
	GtkScrolledWindow* scroll_box = NULL;
	GtkScrolledWindow* _tmp6_;
	GtkScrolledWindow* _tmp7_;
	GtkScrolledWindow* _tmp8_;
	GtkScrolledWindow* _tmp9_;
	GtkScrolledWindow* _tmp10_;
	GtkListBox* _tmp11_;
	GtkSeparator* revealer_content_separator = NULL;
	GtkSeparator* _tmp12_ = NULL;
	GtkBox* revealer_content = NULL;
	GtkBox* _tmp13_;
	GtkBox* _tmp14_;
	GtkSeparator* _tmp15_;
	GtkBox* _tmp16_;
	GtkScrolledWindow* _tmp17_;
	GtkRevealer* _tmp18_;
	GtkRevealer* _tmp19_;
	GtkBox* _tmp20_;
	GtkModelButton* show_settings_button = NULL;
	GtkModelButton* _tmp21_;
	GtkModelButton* _tmp22_;
	GraniteSwitchModelButton* _tmp23_;
	GtkRevealer* _tmp24_;
	gboolean _tmp25_;
	GraniteSwitchModelButton* _tmp29_;
	BluetoothIndicatorServicesObjectManager* _tmp30_;
	BluetoothIndicatorServicesObjectManager* _tmp31_;
	GtkListBox* _tmp32_;
	GraniteSwitchModelButton* _tmp33_;
	GtkModelButton* _tmp34_;
	BluetoothIndicatorServicesObjectManager* _tmp35_;
	BluetoothIndicatorServicesObjectManager* _tmp36_;
	BluetoothIndicatorServicesObjectManager* _tmp37_;
	gboolean _tmp38_ = FALSE;
	BluetoothIndicatorServicesObjectManager* _tmp39_;
	gboolean _tmp40_;
	gboolean _tmp41_;
	parent_class = G_OBJECT_CLASS (bluetooth_indicator_widgets_popover_widget_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BLUETOOTH_INDICATOR_WIDGETS_TYPE_POPOVER_WIDGET, BluetoothIndicatorWidgetsPopoverWidget);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp0_ = self->priv->_object_manager;
	_tmp1_ = granite_switch_model_button_new (_ ("Bluetooth"));
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp1_, bluetooth_indicator_services_object_manager_get_global_state (_tmp0_));
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->main_switch);
	self->priv->main_switch = _tmp1_;
	_tmp2_ = self->priv->main_switch;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_add_class (_tmp3_, GRANITE_STYLE_CLASS_H4_LABEL);
	_tmp4_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->devices_list);
	self->priv->devices_list = _tmp4_;
	_tmp5_ = self->priv->devices_list;
	gtk_list_box_set_sort_func (_tmp5_, (GtkListBoxSortFunc) bluetooth_indicator_widgets_popover_widget_compare_rows, g_object_ref (self), g_object_unref);
	_tmp6_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp6_);
	scroll_box = _tmp6_;
	_tmp7_ = scroll_box;
	gtk_scrolled_window_set_max_content_height (_tmp7_, 512);
	_tmp8_ = scroll_box;
	gtk_scrolled_window_set_propagate_natural_height (_tmp8_, TRUE);
	_tmp9_ = scroll_box;
	g_object_set (_tmp9_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	_tmp10_ = scroll_box;
	_tmp11_ = self->priv->devices_list;
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp12_, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp12_, 3);
	g_object_ref_sink (_tmp12_);
	revealer_content_separator = _tmp12_;
	_tmp13_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp13_);
	revealer_content = _tmp13_;
	_tmp14_ = revealer_content;
	_tmp15_ = revealer_content_separator;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = revealer_content;
	_tmp17_ = scroll_box;
	gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->revealer);
	self->priv->revealer = _tmp18_;
	_tmp19_ = self->priv->revealer;
	_tmp20_ = revealer_content;
	gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = (GtkModelButton*) gtk_model_button_new ();
	g_object_ref_sink (_tmp21_);
	show_settings_button = _tmp21_;
	_tmp22_ = show_settings_button;
	g_object_set (_tmp22_, "text", _ ("Bluetooth Settings…"), NULL);
	_tmp23_ = self->priv->main_switch;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp23_);
	_tmp24_ = self->priv->revealer;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp24_);
	_tmp25_ = self->priv->_is_in_session;
	if (_tmp25_) {
		GtkSeparator* settings_button_separator = NULL;
		GtkSeparator* _tmp26_ = NULL;
		GtkSeparator* _tmp27_;
		GtkModelButton* _tmp28_;
		_tmp26_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
		gtk_widget_set_margin_top ((GtkWidget*) _tmp26_, 3);
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp26_, 3);
		g_object_ref_sink (_tmp26_);
		settings_button_separator = _tmp26_;
		_tmp27_ = settings_button_separator;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp27_);
		_tmp28_ = show_settings_button;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp28_);
		_g_object_unref0 (settings_button_separator);
	}
	_tmp29_ = self->priv->main_switch;
	_tmp30_ = self->priv->_object_manager;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp29_, bluetooth_indicator_services_object_manager_get_global_state (_tmp30_));
	_tmp31_ = self->priv->_object_manager;
	bluetooth_indicator_widgets_popover_widget_update_ui_state (self, bluetooth_indicator_services_object_manager_get_global_state (_tmp31_));
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp32_ = self->priv->devices_list;
	g_signal_connect_object (_tmp32_, "row-activated", (GCallback) __bluetooth_indicator_widgets_popover_widget___lambda25__gtk_list_box_row_activated, self, 0);
	_tmp33_ = self->priv->main_switch;
	g_signal_connect_object ((GObject*) _tmp33_, "notify::active", (GCallback) __bluetooth_indicator_widgets_popover_widget___lambda26__g_object_notify, self, 0);
	_tmp34_ = show_settings_button;
	g_signal_connect_object ((GtkButton*) _tmp34_, "clicked", (GCallback) __bluetooth_indicator_widgets_popover_widget___lambda27__gtk_button_clicked, self, 0);
	_tmp35_ = self->priv->_object_manager;
	g_signal_connect_object (_tmp35_, "global-state-changed", (GCallback) __bluetooth_indicator_widgets_popover_widget___lambda28__bluetooth_indicator_services_object_manager_global_state_changed, self, 0);
	_tmp36_ = self->priv->_object_manager;
	g_signal_connect_object (_tmp36_, "device-added", (GCallback) __bluetooth_indicator_widgets_popover_widget___lambda29__bluetooth_indicator_services_object_manager_device_added, self, 0);
	_tmp37_ = self->priv->_object_manager;
	g_signal_connect_object (_tmp37_, "device-removed", (GCallback) __bluetooth_indicator_widgets_popover_widget___lambda30__bluetooth_indicator_services_object_manager_device_removed, self, 0);
	_tmp39_ = self->priv->_object_manager;
	_tmp40_ = bluetooth_indicator_services_object_manager_get_has_object (_tmp39_);
	_tmp41_ = _tmp40_;
	if (_tmp41_) {
		BluetoothIndicatorServicesObjectManager* _tmp42_;
		gboolean _tmp43_;
		gboolean _tmp44_;
		_tmp42_ = self->priv->_object_manager;
		_tmp43_ = bluetooth_indicator_services_object_manager_get_retrieve_finished (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp38_ = _tmp44_;
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		{
			GeeIterator* _device_it = NULL;
			BluetoothIndicatorServicesObjectManager* _tmp45_;
			GeeCollection* _tmp46_;
			GeeCollection* _tmp47_;
			GeeIterator* _tmp48_;
			GeeIterator* _tmp49_;
			_tmp45_ = self->priv->_object_manager;
			_tmp46_ = bluetooth_indicator_services_object_manager_get_devices (_tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = gee_iterable_iterator ((GeeIterable*) _tmp47_);
			_tmp49_ = _tmp48_;
			_g_object_unref0 (_tmp47_);
			_device_it = _tmp49_;
			while (TRUE) {
				GeeIterator* _tmp50_;
				BluetoothIndicatorServicesDevice* device = NULL;
				GeeIterator* _tmp51_;
				gpointer _tmp52_;
				BluetoothIndicatorServicesDevice* _tmp53_;
				_tmp50_ = _device_it;
				if (!gee_iterator_next (_tmp50_)) {
					break;
				}
				_tmp51_ = _device_it;
				_tmp52_ = gee_iterator_get (_tmp51_);
				device = (BluetoothIndicatorServicesDevice*) _tmp52_;
				_tmp53_ = device;
				bluetooth_indicator_widgets_popover_widget_add_device (self, _tmp53_);
				_g_object_unref0 (device);
			}
			_g_object_unref0 (_device_it);
		}
	}
	bluetooth_indicator_widgets_popover_widget_update_devices_box_visible (self);
	_g_object_unref0 (show_settings_button);
	_g_object_unref0 (revealer_content);
	_g_object_unref0 (revealer_content_separator);
	_g_object_unref0 (scroll_box);
	return obj;
}

static void
bluetooth_indicator_widgets_popover_widget_class_init (BluetoothIndicatorWidgetsPopoverWidgetClass * klass,
                                                       gpointer klass_data)
{
	bluetooth_indicator_widgets_popover_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BluetoothIndicatorWidgetsPopoverWidget_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_bluetooth_indicator_widgets_popover_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bluetooth_indicator_widgets_popover_widget_set_property;
	G_OBJECT_CLASS (klass)->constructor = bluetooth_indicator_widgets_popover_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = bluetooth_indicator_widgets_popover_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_OBJECT_MANAGER_PROPERTY, bluetooth_indicator_widgets_popover_widget_properties[BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_OBJECT_MANAGER_PROPERTY] = g_param_spec_object ("object-manager", "object-manager", "object-manager", BLUETOOTH_INDICATOR_SERVICES_TYPE_OBJECT_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_OBEX_MANAGER_PROPERTY, bluetooth_indicator_widgets_popover_widget_properties[BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_OBEX_MANAGER_PROPERTY] = g_param_spec_object ("obex-manager", "obex-manager", "obex-manager", BLUETOOTH_INDICATOR_SERVICES_TYPE_OBEX_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_IS_IN_SESSION_PROPERTY, bluetooth_indicator_widgets_popover_widget_properties[BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_IS_IN_SESSION_PROPERTY] = g_param_spec_boolean ("is-in-session", "is-in-session", "is-in-session", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	bluetooth_indicator_widgets_popover_widget_signals[BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_DEVICE_REQUESTED_SIGNAL] = g_signal_new ("device-requested", BLUETOOTH_INDICATOR_WIDGETS_TYPE_POPOVER_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BLUETOOTH_INDICATOR_SERVICES_TYPE_DEVICE);
	bluetooth_indicator_widgets_popover_widget_signals[BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_DISCOVERY_REQUESTED_SIGNAL] = g_signal_new ("discovery-requested", BLUETOOTH_INDICATOR_WIDGETS_TYPE_POPOVER_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
bluetooth_indicator_widgets_popover_widget_instance_init (BluetoothIndicatorWidgetsPopoverWidget * self,
                                                          gpointer klass)
{
	self->priv = bluetooth_indicator_widgets_popover_widget_get_instance_private (self);
}

static void
bluetooth_indicator_widgets_popover_widget_finalize (GObject * obj)
{
	BluetoothIndicatorWidgetsPopoverWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BLUETOOTH_INDICATOR_WIDGETS_TYPE_POPOVER_WIDGET, BluetoothIndicatorWidgetsPopoverWidget);
	_g_object_unref0 (self->priv->_object_manager);
	_g_object_unref0 (self->priv->_obex_manager);
	_g_object_unref0 (self->priv->main_switch);
	_g_object_unref0 (self->priv->devices_list);
	_g_object_unref0 (self->priv->revealer);
	G_OBJECT_CLASS (bluetooth_indicator_widgets_popover_widget_parent_class)->finalize (obj);
}

static GType
bluetooth_indicator_widgets_popover_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BluetoothIndicatorWidgetsPopoverWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bluetooth_indicator_widgets_popover_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BluetoothIndicatorWidgetsPopoverWidget), 0, (GInstanceInitFunc) bluetooth_indicator_widgets_popover_widget_instance_init, NULL };
	GType bluetooth_indicator_widgets_popover_widget_type_id;
	bluetooth_indicator_widgets_popover_widget_type_id = g_type_register_static (gtk_box_get_type (), "BluetoothIndicatorWidgetsPopoverWidget", &g_define_type_info, 0);
	BluetoothIndicatorWidgetsPopoverWidget_private_offset = g_type_add_instance_private (bluetooth_indicator_widgets_popover_widget_type_id, sizeof (BluetoothIndicatorWidgetsPopoverWidgetPrivate));
	return bluetooth_indicator_widgets_popover_widget_type_id;
}

GType
bluetooth_indicator_widgets_popover_widget_get_type (void)
{
	static volatile gsize bluetooth_indicator_widgets_popover_widget_type_id__once = 0;
	if (g_once_init_enter (&bluetooth_indicator_widgets_popover_widget_type_id__once)) {
		GType bluetooth_indicator_widgets_popover_widget_type_id;
		bluetooth_indicator_widgets_popover_widget_type_id = bluetooth_indicator_widgets_popover_widget_get_type_once ();
		g_once_init_leave (&bluetooth_indicator_widgets_popover_widget_type_id__once, bluetooth_indicator_widgets_popover_widget_type_id);
	}
	return bluetooth_indicator_widgets_popover_widget_type_id__once;
}

static void
_vala_bluetooth_indicator_widgets_popover_widget_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec)
{
	BluetoothIndicatorWidgetsPopoverWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BLUETOOTH_INDICATOR_WIDGETS_TYPE_POPOVER_WIDGET, BluetoothIndicatorWidgetsPopoverWidget);
	switch (property_id) {
		case BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_OBJECT_MANAGER_PROPERTY:
		g_value_set_object (value, bluetooth_indicator_widgets_popover_widget_get_object_manager (self));
		break;
		case BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_OBEX_MANAGER_PROPERTY:
		g_value_set_object (value, bluetooth_indicator_widgets_popover_widget_get_obex_manager (self));
		break;
		case BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_IS_IN_SESSION_PROPERTY:
		g_value_set_boolean (value, bluetooth_indicator_widgets_popover_widget_get_is_in_session (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bluetooth_indicator_widgets_popover_widget_set_property (GObject * object,
                                                               guint property_id,
                                                               const GValue * value,
                                                               GParamSpec * pspec)
{
	BluetoothIndicatorWidgetsPopoverWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BLUETOOTH_INDICATOR_WIDGETS_TYPE_POPOVER_WIDGET, BluetoothIndicatorWidgetsPopoverWidget);
	switch (property_id) {
		case BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_OBJECT_MANAGER_PROPERTY:
		bluetooth_indicator_widgets_popover_widget_set_object_manager (self, g_value_get_object (value));
		break;
		case BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_OBEX_MANAGER_PROPERTY:
		bluetooth_indicator_widgets_popover_widget_set_obex_manager (self, g_value_get_object (value));
		break;
		case BLUETOOTH_INDICATOR_WIDGETS_POPOVER_WIDGET_IS_IN_SESSION_PROPERTY:
		bluetooth_indicator_widgets_popover_widget_set_is_in_session (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

