/* SessionWidget.c generated by valac 0.56.17, the Vala compiler
 * generated from SessionWidget.vala, do not modify */

/*
 * Copyright (c) 2011-2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include "a11y.h"
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <granite.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	A11_Y_SESSION_WIDGET_0_PROPERTY,
	A11_Y_SESSION_WIDGET_NUM_PROPERTIES
};
static GParamSpec* a11_y_session_widget_properties[A11_Y_SESSION_WIDGET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _A11YSessionWidgetPrivate {
	GtkButton* zoom_default_button;
	GtkButton* zoom_in_button;
	GtkButton* zoom_out_button;
	GSettings* interface_settings;
};

static gint A11YSessionWidget_private_offset;
static gpointer a11_y_session_widget_parent_class = NULL;

static void a11_y_session_widget_update_zoom_buttons (A11YSessionWidget* self);
static GObject * a11_y_session_widget_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void _a11_y_session_widget___lambda5_ (A11YSessionWidget* self);
static void __a11_y_session_widget___lambda5__gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self);
static void _a11_y_session_widget___lambda6_ (A11YSessionWidget* self);
static void __a11_y_session_widget___lambda6__gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self);
static void _a11_y_session_widget___lambda7_ (A11YSessionWidget* self);
static void __a11_y_session_widget___lambda7__gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self);
static void _a11_y_session_widget___lambda8_ (A11YSessionWidget* self);
static void __a11_y_session_widget___lambda8__gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self);
static void _a11_y_session_widget_update_zoom_buttons_g_settings_changed (GSettings* _sender,
                                                                   const gchar* key,
                                                                   gpointer self);
static void a11_y_session_widget_finalize (GObject * obj);
static GType a11_y_session_widget_get_type_once (void);

static inline gpointer
a11_y_session_widget_get_instance_private (A11YSessionWidget* self)
{
	return G_STRUCT_MEMBER_P (self, A11YSessionWidget_private_offset);
}

static void
a11_y_session_widget_update_zoom_buttons (A11YSessionWidget* self)
{
	gdouble scaling_factor = 0.0;
	GSettings* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->interface_settings;
	scaling_factor = g_settings_get_double (_tmp0_, "text-scaling-factor");
	_tmp1_ = self->priv->zoom_in_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, scaling_factor < 1.5);
	_tmp2_ = self->priv->zoom_out_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, scaling_factor > 0.75);
	_tmp3_ = self->priv->zoom_default_button;
	_tmp4_ = g_strdup_printf ("%.0f%%", scaling_factor * 100);
	_tmp5_ = _tmp4_;
	gtk_button_set_label (_tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
}

A11YSessionWidget*
a11_y_session_widget_construct (GType object_type)
{
	A11YSessionWidget * self = NULL;
	self = (A11YSessionWidget*) g_object_new (object_type, NULL);
	return self;
}

A11YSessionWidget*
a11_y_session_widget_new (void)
{
	return a11_y_session_widget_construct (A11_Y_TYPE_SESSION_WIDGET);
}

static void
_a11_y_session_widget___lambda5_ (A11YSessionWidget* self)
{
	GError* _inner_error0_ = NULL;
	{
		g_app_info_launch_default_for_uri ("settings://universal-access", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("SessionWidget.vala:81: Failed to open universal access settings: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__a11_y_session_widget___lambda5__gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self)
{
	_a11_y_session_widget___lambda5_ ((A11YSessionWidget*) self);
}

static void
_a11_y_session_widget___lambda6_ (A11YSessionWidget* self)
{
	GSettings* _tmp0_;
	_tmp0_ = self->priv->interface_settings;
	g_settings_reset (_tmp0_, "text-scaling-factor");
}

static void
__a11_y_session_widget___lambda6__gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self)
{
	_a11_y_session_widget___lambda6_ ((A11YSessionWidget*) self);
}

static void
_a11_y_session_widget___lambda7_ (A11YSessionWidget* self)
{
	gdouble scaling_factor = 0.0;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	_tmp0_ = self->priv->interface_settings;
	scaling_factor = g_settings_get_double (_tmp0_, "text-scaling-factor");
	_tmp1_ = self->priv->interface_settings;
	g_settings_set_double (_tmp1_, "text-scaling-factor", scaling_factor + 0.25);
}

static void
__a11_y_session_widget___lambda7__gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self)
{
	_a11_y_session_widget___lambda7_ ((A11YSessionWidget*) self);
}

static void
_a11_y_session_widget___lambda8_ (A11YSessionWidget* self)
{
	gdouble scaling_factor = 0.0;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	_tmp0_ = self->priv->interface_settings;
	scaling_factor = g_settings_get_double (_tmp0_, "text-scaling-factor");
	_tmp1_ = self->priv->interface_settings;
	g_settings_set_double (_tmp1_, "text-scaling-factor", scaling_factor - 0.25);
}

static void
__a11_y_session_widget___lambda8__gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self)
{
	_a11_y_session_widget___lambda8_ ((A11YSessionWidget*) self);
}

static void
_a11_y_session_widget_update_zoom_buttons_g_settings_changed (GSettings* _sender,
                                                              const gchar* key,
                                                              gpointer self)
{
	a11_y_session_widget_update_zoom_buttons ((A11YSessionWidget*) self);
}

static GObject *
a11_y_session_widget_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	A11YSessionWidget * self;
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkGrid* font_size_grid = NULL;
	GtkGrid* _tmp6_;
	GtkGrid* _tmp7_;
	GtkGrid* _tmp8_;
	GtkGrid* _tmp9_;
	GtkGrid* _tmp10_;
	GtkGrid* _tmp11_;
	GtkGrid* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkGrid* _tmp14_;
	GtkButton* _tmp15_;
	GtkGrid* _tmp16_;
	GtkButton* _tmp17_;
	GtkGrid* _tmp18_;
	GtkButton* _tmp19_;
	GraniteSwitchModelButton* screen_reader = NULL;
	GraniteSwitchModelButton* _tmp20_;
	GraniteSwitchModelButton* onscreen_keyboard = NULL;
	GraniteSwitchModelButton* _tmp21_;
	GraniteSwitchModelButton* slow_keys = NULL;
	GraniteSwitchModelButton* _tmp22_;
	GraniteSwitchModelButton* bounce_keys = NULL;
	GraniteSwitchModelButton* _tmp23_;
	GraniteSwitchModelButton* sticky_keys = NULL;
	GraniteSwitchModelButton* _tmp24_;
	GraniteSwitchModelButton* hover_click = NULL;
	GraniteSwitchModelButton* _tmp25_;
	GtkSeparator* separator = NULL;
	GtkSeparator* _tmp26_ = NULL;
	GtkModelButton* settings_button = NULL;
	GtkModelButton* _tmp27_;
	GtkModelButton* _tmp28_;
	GtkGrid* _tmp29_;
	GraniteSwitchModelButton* _tmp30_;
	GraniteSwitchModelButton* _tmp31_;
	GraniteSwitchModelButton* _tmp32_;
	GraniteSwitchModelButton* _tmp33_;
	GraniteSwitchModelButton* _tmp34_;
	GraniteSwitchModelButton* _tmp35_;
	GtkSeparator* _tmp36_;
	GtkModelButton* _tmp37_;
	GtkModelButton* _tmp38_;
	GtkButton* _tmp39_;
	GtkButton* _tmp40_;
	GtkButton* _tmp41_;
	GSettings* applications_settings = NULL;
	GSettings* _tmp42_;
	GSettings* _tmp43_;
	GraniteSwitchModelButton* _tmp44_;
	GSettings* _tmp45_;
	GraniteSwitchModelButton* _tmp46_;
	GSettings* _tmp47_;
	GSettings* _tmp48_;
	GSettings* keyboard_settings = NULL;
	GSettings* _tmp49_;
	GSettings* _tmp50_;
	GraniteSwitchModelButton* _tmp51_;
	GSettings* _tmp52_;
	GraniteSwitchModelButton* _tmp53_;
	GSettings* _tmp54_;
	GraniteSwitchModelButton* _tmp55_;
	GSettings* mouse_settings = NULL;
	GSettings* _tmp56_;
	GSettings* _tmp57_;
	GraniteSwitchModelButton* _tmp58_;
	parent_class = G_OBJECT_CLASS (a11_y_session_widget_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, A11_Y_TYPE_SESSION_WIDGET, A11YSessionWidget);
	_tmp0_ = (GtkButton*) gtk_button_new_from_icon_name ("zoom-out-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->zoom_out_button);
	self->priv->zoom_out_button = _tmp0_;
	_tmp1_ = self->priv->zoom_out_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp1_, _ ("Decrease text size"));
	_tmp2_ = (GtkButton*) gtk_button_new_with_label ("100%");
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->zoom_default_button);
	self->priv->zoom_default_button = _tmp2_;
	_tmp3_ = self->priv->zoom_default_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp3_, _ ("Default text size"));
	_tmp4_ = (GtkButton*) gtk_button_new_from_icon_name ("zoom-in-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->zoom_in_button);
	self->priv->zoom_in_button = _tmp4_;
	_tmp5_ = self->priv->zoom_in_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp5_, _ ("Increase text size"));
	_tmp6_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp6_);
	font_size_grid = _tmp6_;
	_tmp7_ = font_size_grid;
	gtk_grid_set_column_homogeneous (_tmp7_, TRUE);
	_tmp8_ = font_size_grid;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp8_, TRUE);
	_tmp9_ = font_size_grid;
	g_object_set ((GtkWidget*) _tmp9_, "margin", 12, NULL);
	_tmp10_ = font_size_grid;
	_tmp11_ = font_size_grid;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp11_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp10_, 6);
	_tmp12_ = font_size_grid;
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
	gtk_style_context_add_class (_tmp13_, GTK_STYLE_CLASS_LINKED);
	_tmp14_ = font_size_grid;
	_tmp15_ = self->priv->zoom_out_button;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = font_size_grid;
	_tmp17_ = self->priv->zoom_default_button;
	gtk_container_add ((GtkContainer*) _tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = font_size_grid;
	_tmp19_ = self->priv->zoom_in_button;
	gtk_container_add ((GtkContainer*) _tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = granite_switch_model_button_new (_ ("Screen Reader"));
	g_object_ref_sink (_tmp20_);
	screen_reader = _tmp20_;
	_tmp21_ = granite_switch_model_button_new (_ ("Onscreen Keyboard"));
	g_object_ref_sink (_tmp21_);
	onscreen_keyboard = _tmp21_;
	_tmp22_ = granite_switch_model_button_new (_ ("Slow Keys"));
	g_object_ref_sink (_tmp22_);
	slow_keys = _tmp22_;
	_tmp23_ = granite_switch_model_button_new (_ ("Bounce Keys"));
	g_object_ref_sink (_tmp23_);
	bounce_keys = _tmp23_;
	_tmp24_ = granite_switch_model_button_new (_ ("Sticky Keys"));
	g_object_ref_sink (_tmp24_);
	sticky_keys = _tmp24_;
	_tmp25_ = granite_switch_model_button_new (_ ("Dwell Click"));
	g_object_ref_sink (_tmp25_);
	hover_click = _tmp25_;
	_tmp26_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp26_, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp26_, 3);
	g_object_ref_sink (_tmp26_);
	separator = _tmp26_;
	_tmp27_ = (GtkModelButton*) gtk_model_button_new ();
	g_object_ref_sink (_tmp27_);
	settings_button = _tmp27_;
	_tmp28_ = settings_button;
	g_object_set (_tmp28_, "text", _ ("Universal Access Settings…"), NULL);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp29_ = font_size_grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp29_);
	_tmp30_ = screen_reader;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp30_);
	_tmp31_ = onscreen_keyboard;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp31_);
	_tmp32_ = slow_keys;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp32_);
	_tmp33_ = bounce_keys;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp33_);
	_tmp34_ = sticky_keys;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp34_);
	_tmp35_ = hover_click;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp35_);
	_tmp36_ = separator;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp36_);
	_tmp37_ = settings_button;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp37_);
	_tmp38_ = settings_button;
	g_signal_connect_object ((GtkButton*) _tmp38_, "clicked", (GCallback) __a11_y_session_widget___lambda5__gtk_button_clicked, self, 0);
	_tmp39_ = self->priv->zoom_default_button;
	g_signal_connect_object (_tmp39_, "clicked", (GCallback) __a11_y_session_widget___lambda6__gtk_button_clicked, self, 0);
	_tmp40_ = self->priv->zoom_in_button;
	g_signal_connect_object (_tmp40_, "clicked", (GCallback) __a11_y_session_widget___lambda7__gtk_button_clicked, self, 0);
	_tmp41_ = self->priv->zoom_out_button;
	g_signal_connect_object (_tmp41_, "clicked", (GCallback) __a11_y_session_widget___lambda8__gtk_button_clicked, self, 0);
	_tmp42_ = g_settings_new ("org.gnome.desktop.a11y.applications");
	applications_settings = _tmp42_;
	_tmp43_ = applications_settings;
	_tmp44_ = onscreen_keyboard;
	g_settings_bind (_tmp43_, "screen-keyboard-enabled", (GObject*) _tmp44_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp45_ = applications_settings;
	_tmp46_ = screen_reader;
	g_settings_bind (_tmp45_, "screen-reader-enabled", (GObject*) _tmp46_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp47_ = g_settings_new ("org.gnome.desktop.interface");
	_g_object_unref0 (self->priv->interface_settings);
	self->priv->interface_settings = _tmp47_;
	_tmp48_ = self->priv->interface_settings;
	g_signal_connect_object (_tmp48_, "changed::text-scaling-factor", (GCallback) _a11_y_session_widget_update_zoom_buttons_g_settings_changed, self, 0);
	a11_y_session_widget_update_zoom_buttons (self);
	_tmp49_ = g_settings_new ("org.gnome.desktop.a11y.keyboard");
	keyboard_settings = _tmp49_;
	_tmp50_ = keyboard_settings;
	_tmp51_ = bounce_keys;
	g_settings_bind (_tmp50_, "bouncekeys-enable", (GObject*) _tmp51_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp52_ = keyboard_settings;
	_tmp53_ = slow_keys;
	g_settings_bind (_tmp52_, "slowkeys-enable", (GObject*) _tmp53_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp54_ = keyboard_settings;
	_tmp55_ = sticky_keys;
	g_settings_bind (_tmp54_, "stickykeys-enable", (GObject*) _tmp55_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp56_ = g_settings_new ("org.gnome.desktop.a11y.mouse");
	mouse_settings = _tmp56_;
	_tmp57_ = mouse_settings;
	_tmp58_ = hover_click;
	g_settings_bind (_tmp57_, "dwell-click-enabled", (GObject*) _tmp58_, "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (mouse_settings);
	_g_object_unref0 (keyboard_settings);
	_g_object_unref0 (applications_settings);
	_g_object_unref0 (settings_button);
	_g_object_unref0 (separator);
	_g_object_unref0 (hover_click);
	_g_object_unref0 (sticky_keys);
	_g_object_unref0 (bounce_keys);
	_g_object_unref0 (slow_keys);
	_g_object_unref0 (onscreen_keyboard);
	_g_object_unref0 (screen_reader);
	_g_object_unref0 (font_size_grid);
	return obj;
}

static void
a11_y_session_widget_class_init (A11YSessionWidgetClass * klass,
                                 gpointer klass_data)
{
	a11_y_session_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &A11YSessionWidget_private_offset);
	G_OBJECT_CLASS (klass)->constructor = a11_y_session_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = a11_y_session_widget_finalize;
}

static void
a11_y_session_widget_instance_init (A11YSessionWidget * self,
                                    gpointer klass)
{
	self->priv = a11_y_session_widget_get_instance_private (self);
}

static void
a11_y_session_widget_finalize (GObject * obj)
{
	A11YSessionWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, A11_Y_TYPE_SESSION_WIDGET, A11YSessionWidget);
	_g_object_unref0 (self->priv->zoom_default_button);
	_g_object_unref0 (self->priv->zoom_in_button);
	_g_object_unref0 (self->priv->zoom_out_button);
	_g_object_unref0 (self->priv->interface_settings);
	G_OBJECT_CLASS (a11_y_session_widget_parent_class)->finalize (obj);
}

static GType
a11_y_session_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (A11YSessionWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) a11_y_session_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (A11YSessionWidget), 0, (GInstanceInitFunc) a11_y_session_widget_instance_init, NULL };
	GType a11_y_session_widget_type_id;
	a11_y_session_widget_type_id = g_type_register_static (gtk_grid_get_type (), "A11YSessionWidget", &g_define_type_info, 0);
	A11YSessionWidget_private_offset = g_type_add_instance_private (a11_y_session_widget_type_id, sizeof (A11YSessionWidgetPrivate));
	return a11_y_session_widget_type_id;
}

GType
a11_y_session_widget_get_type (void)
{
	static volatile gsize a11_y_session_widget_type_id__once = 0;
	if (g_once_init_enter (&a11_y_session_widget_type_id__once)) {
		GType a11_y_session_widget_type_id;
		a11_y_session_widget_type_id = a11_y_session_widget_get_type_once ();
		g_once_init_leave (&a11_y_session_widget_type_id__once, a11_y_session_widget_type_id);
	}
	return a11_y_session_widget_type_id__once;
}

