// java wrapper for vtkRenderWindow object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkRenderWindow.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkWindow_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkRenderWindow_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkRenderWindow",dType)) { return me; }
  if ((res= vtkWindow_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderWindow_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderWindow_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_AddRenderer_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderer * temp0;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddRenderer(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_RemoveRenderer_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderer * temp0;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveRenderer(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_HasRenderer_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderer * temp0;
  int   temp20;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasRenderer(temp0);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderWindow_GetRenderLibrary_17(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderLibrary();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderWindow_GetRenderingBackend_18(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderingBackend();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderWindow_GetRenderTimer_19(JNIEnv* env, jobject obj)
{
  vtkRenderTimerLog * temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderTimer();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderWindow_GetRenderers_110(JNIEnv* env, jobject obj)
{
  vtkRendererCollection * temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderers();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_CaptureGL2PSSpecialProps_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCollection * temp0;
  temp0 = static_cast<vtkCollection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->CaptureGL2PSSpecialProps(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetCapturingGL2PSSpecialProps_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCapturingGL2PSSpecialProps();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_Render_113(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_Start_114(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->Start();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_End_115(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->End();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_Initialize_116(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderWindow_GetInitialized_117(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInitialized();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_Finalize_118(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->Finalize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_Frame_119(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->Frame();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_WaitForCompletion_120(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->WaitForCompletion();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_CopyResultFrame_121(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyResultFrame();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderWindow_MakeRenderWindowInteractor_122(JNIEnv* env, jobject obj)
{
  vtkRenderWindowInteractor * temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MakeRenderWindowInteractor();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_HideCursor_123(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->HideCursor();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_ShowCursor_124(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShowCursor();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetCursorPosition_125(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCursorPosition(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetCurrentCursor_126(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCurrentCursor(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetCurrentCursor_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCurrentCursor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetCursorFileName_128(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCursorFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderWindow_GetCursorFileName_129(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCursorFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetFullScreen_130(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFullScreen(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetFullScreen_131(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFullScreen();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_FullScreenOn_132(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->FullScreenOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_FullScreenOff_133(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->FullScreenOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetBorders_134(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBorders(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetBorders_135(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBorders();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_BordersOn_136(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->BordersOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_BordersOff_137(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->BordersOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetCoverable_138(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoverable();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_CoverableOn_139(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->CoverableOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_CoverableOff_140(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->CoverableOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetCoverable_141(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoverable(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetStereoCapableWindow_142(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStereoCapableWindow();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_StereoCapableWindowOn_143(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->StereoCapableWindowOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_StereoCapableWindowOff_144(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->StereoCapableWindowOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetStereoCapableWindow_145(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStereoCapableWindow(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetStereoType_146(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStereoType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetStereoType_147(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStereoType(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetStereoTypeToCrystalEyes_148(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStereoTypeToCrystalEyes();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetStereoTypeToRedBlue_149(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStereoTypeToRedBlue();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetStereoTypeToInterlaced_150(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStereoTypeToInterlaced();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetStereoTypeToLeft_151(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStereoTypeToLeft();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetStereoTypeToRight_152(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStereoTypeToRight();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetStereoTypeToDresden_153(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStereoTypeToDresden();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetStereoTypeToAnaglyph_154(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStereoTypeToAnaglyph();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetStereoTypeToCheckerboard_155(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStereoTypeToCheckerboard();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetStereoTypeToSplitViewportHorizontal_156(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStereoTypeToSplitViewportHorizontal();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetStereoTypeToFake_157(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStereoTypeToFake();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetStereoTypeToEmulate_158(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStereoTypeToEmulate();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderWindow_GetStereoTypeAsString_159(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStereoTypeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderWindow_GetStereoTypeAsString_160(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStereoTypeAsString(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetStereoRender_161(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStereoRender();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetStereoRender_162(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStereoRender(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_StereoRenderOn_163(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->StereoRenderOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_StereoRenderOff_164(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->StereoRenderOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetAlphaBitPlanes_165(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAlphaBitPlanes(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetAlphaBitPlanes_166(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAlphaBitPlanes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_AlphaBitPlanesOn_167(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->AlphaBitPlanesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_AlphaBitPlanesOff_168(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->AlphaBitPlanesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetPointSmoothing_169(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointSmoothing(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetPointSmoothing_170(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointSmoothing();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_PointSmoothingOn_171(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->PointSmoothingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_PointSmoothingOff_172(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->PointSmoothingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetLineSmoothing_173(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLineSmoothing(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetLineSmoothing_174(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLineSmoothing();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_LineSmoothingOn_175(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->LineSmoothingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_LineSmoothingOff_176(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->LineSmoothingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetPolygonSmoothing_177(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolygonSmoothing(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetPolygonSmoothing_178(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolygonSmoothing();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_PolygonSmoothingOn_179(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->PolygonSmoothingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_PolygonSmoothingOff_180(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->PolygonSmoothingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_StereoUpdate_181(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->StereoUpdate();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_StereoMidpoint_182(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->StereoMidpoint();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_StereoRenderComplete_183(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->StereoRenderComplete();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetAnaglyphColorSaturation_184(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAnaglyphColorSaturation(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkRenderWindow_GetAnaglyphColorSaturationMinValue_185(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAnaglyphColorSaturationMinValue();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkRenderWindow_GetAnaglyphColorSaturationMaxValue_186(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAnaglyphColorSaturationMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkRenderWindow_GetAnaglyphColorSaturation_187(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAnaglyphColorSaturation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetAnaglyphColorMask_188(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAnaglyphColorMask(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetAnaglyphColorMask_189(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAnaglyphColorMask(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkRenderWindow_GetAnaglyphColorMask_190(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAnaglyphColorMask();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_WindowRemap_191(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->WindowRemap();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetSwapBuffers_192(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSwapBuffers(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetSwapBuffers_193(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSwapBuffers();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SwapBuffersOn_194(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SwapBuffersOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SwapBuffersOff_195(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SwapBuffersOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_SetPixelData_196(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jobject id4,jint id5,jint id6)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  vtkUnsignedCharArray * temp4;
  int   temp5;
  int   temp6;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = id5;
  temp6 = id6;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetPixelData(temp0,temp1,temp2,temp3,temp4,temp5,temp6);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetRGBAPixelData_197(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jobject id5,jint id6)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  vtkFloatArray * temp5;
  int   temp6;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = id6;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRGBAPixelData(temp0,temp1,temp2,temp3,temp4,temp5,temp6);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_SetRGBAPixelData_198(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jobject id4,jint id5,jint id6,jint id7)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  vtkFloatArray * temp4;
  int   temp5;
  int   temp6;
  int   temp7;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetRGBAPixelData(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetRGBACharPixelData_199(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jobject id5,jint id6)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  vtkUnsignedCharArray * temp5;
  int   temp6;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = id6;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRGBACharPixelData(temp0,temp1,temp2,temp3,temp4,temp5,temp6);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_SetRGBACharPixelData_1100(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jobject id4,jint id5,jint id6,jint id7)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  vtkUnsignedCharArray * temp4;
  int   temp5;
  int   temp6;
  int   temp7;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetRGBACharPixelData(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetZbufferData_1101(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jobject id4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  vtkFloatArray * temp4;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, id4));

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZbufferData(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_SetZbufferData_1102(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jobject id4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  vtkFloatArray * temp4;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkFloatArray*>(vtkJavaGetPointerFromObject(env, id4));

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetZbufferData(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkRenderWindow_GetZbufferDataAtPoint_1103(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  float   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZbufferDataAtPoint(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetNeverRendered_1104(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNeverRendered();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetAbortRender_1105(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAbortRender();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetAbortRender_1106(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAbortRender(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetInAbortCheck_1107(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInAbortCheck();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetInAbortCheck_1108(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInAbortCheck(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_CheckAbortStatus_1109(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CheckAbortStatus();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetEventPending_1110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEventPending();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_CheckInRenderStatus_1111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CheckInRenderStatus();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_ClearInRenderStatus_1112(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearInRenderStatus();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetDesiredUpdateRate_1113(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDesiredUpdateRate(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderWindow_GetDesiredUpdateRate_1114(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDesiredUpdateRate();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetNumberOfLayers_1115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLayers();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetNumberOfLayers_1116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfLayers(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetNumberOfLayersMinValue_1117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLayersMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetNumberOfLayersMaxValue_1118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLayersMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderWindow_GetInteractor_1119(JNIEnv* env, jobject obj)
{
  vtkRenderWindowInteractor * temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInteractor();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetInteractor_1120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindowInteractor * temp0;
  temp0 = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteractor(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_UnRegister_1121(JNIEnv* env, jobject obj,jobject id0)
{
  vtkObjectBase * temp0;
  temp0 = static_cast<vtkObjectBase*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnRegister(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetWindowInfo_1122(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWindowInfo(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetNextWindowInfo_1123(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNextWindowInfo(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetParentInfo_1124(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetParentInfo(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderWindow_InitializeFromCurrentContext_1125(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InitializeFromCurrentContext();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetSharedRenderWindow_1126(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindow * temp0;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSharedRenderWindow(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderWindow_GetSharedRenderWindow_1127(JNIEnv* env, jobject obj)
{
  vtkRenderWindow * temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSharedRenderWindow();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderWindow_GetPlatformSupportsRenderWindowSharing_1128(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPlatformSupportsRenderWindowSharing();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderWindow_IsCurrent_1129(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsCurrent();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetForceMakeCurrent_1130(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForceMakeCurrent();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRenderWindow_ReportCapabilities_1131(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReportCapabilities();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_SupportsOpenGL_1132(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SupportsOpenGL();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_IsDirect_1133(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsDirect();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetDepthBufferSize_1134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDepthBufferSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetMultiSamples_1135(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMultiSamples(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetMultiSamples_1136(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMultiSamples();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetStencilCapable_1137(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStencilCapable(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetStencilCapable_1138(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStencilCapable();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_StencilCapableOn_1139(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->StencilCapableOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_StencilCapableOff_1140(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->StencilCapableOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetDeviceIndex_1141(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDeviceIndex(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetDeviceIndex_1142(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDeviceIndex();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderWindow_GetNumberOfDevices_1143(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfDevices();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderWindow_GetUseSRGBColorSpace_1144(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseSRGBColorSpace();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetUseSRGBColorSpace_1145(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseSRGBColorSpace(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_UseSRGBColorSpaceOn_1146(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseSRGBColorSpaceOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_UseSRGBColorSpaceOff_1147(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseSRGBColorSpaceOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetPhysicalViewDirection_1148(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPhysicalViewDirection(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetPhysicalViewDirection_1149(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPhysicalViewDirection(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkRenderWindow_GetPhysicalViewDirection_1150(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPhysicalViewDirection();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetPhysicalViewUp_1151(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPhysicalViewUp(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetPhysicalViewUp_1152(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPhysicalViewUp(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkRenderWindow_GetPhysicalViewUp_1153(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPhysicalViewUp();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetPhysicalTranslation_1154(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPhysicalTranslation(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetPhysicalTranslation_1155(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPhysicalTranslation(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkRenderWindow_GetPhysicalTranslation_1156(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPhysicalTranslation();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetPhysicalScale_1157(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPhysicalScale(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRenderWindow_GetPhysicalScale_1158(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPhysicalScale();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetPhysicalToWorldMatrix_1159(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPhysicalToWorldMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_GetPhysicalToWorldMatrix_1160(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPhysicalToWorldMatrix(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderWindow_GetEnableTranslucentSurface_1161(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnableTranslucentSurface();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_SetEnableTranslucentSurface_1162(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnableTranslucentSurface(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_EnableTranslucentSurfaceOn_1163(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableTranslucentSurfaceOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderWindow_EnableTranslucentSurfaceOff_1164(JNIEnv* env, jobject obj)
{

  vtkRenderWindow* op = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableTranslucentSurfaceOff();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkRenderWindow_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkRenderWindow::New());
}

#include "vtkJavaAwt.h"

