// java wrapper for vtkImageMapper3D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageMapper3D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAbstractMapper3D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageMapper3D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageMapper3D",dType)) { return me; }
  if ((res= vtkAbstractMapper3D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageMapper3D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageMapper3D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageMapper3D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageMapper3D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageMapper3D_Render_14(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkRenderer * temp0;
  vtkImageSlice * temp1;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkImageSlice*>(vtkJavaGetPointerFromObject(env, id1));

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageMapper3D_ReleaseGraphicsResources_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageMapper3D_SetInputData_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageData * temp0;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageMapper3D_GetInput_17(JNIEnv* env, jobject obj)
{
  vtkImageData * temp20;

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageMapper3D_GetDataSetInput_18(JNIEnv* env, jobject obj)
{
  vtkDataSet * temp20;

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataSetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageMapper3D_GetDataObjectInput_19(JNIEnv* env, jobject obj)
{
  vtkDataObject * temp20;

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageMapper3D_SetBorder_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBorder(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageMapper3D_BorderOn_111(JNIEnv* env, jobject obj)
{

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->BorderOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageMapper3D_BorderOff_112(JNIEnv* env, jobject obj)
{

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->BorderOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageMapper3D_GetBorder_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBorder();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageMapper3D_SetBackground_114(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackground(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageMapper3D_BackgroundOn_115(JNIEnv* env, jobject obj)
{

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->BackgroundOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageMapper3D_BackgroundOff_116(JNIEnv* env, jobject obj)
{

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->BackgroundOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageMapper3D_GetBackground_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackground();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageMapper3D_SetSliceAtFocalPoint_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSliceAtFocalPoint(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageMapper3D_SliceAtFocalPointOn_119(JNIEnv* env, jobject obj)
{

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SliceAtFocalPointOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageMapper3D_SliceAtFocalPointOff_120(JNIEnv* env, jobject obj)
{

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SliceAtFocalPointOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageMapper3D_GetSliceAtFocalPoint_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSliceAtFocalPoint();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageMapper3D_SetSliceFacesCamera_122(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSliceFacesCamera(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageMapper3D_SliceFacesCameraOn_123(JNIEnv* env, jobject obj)
{

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SliceFacesCameraOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageMapper3D_SliceFacesCameraOff_124(JNIEnv* env, jobject obj)
{

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SliceFacesCameraOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageMapper3D_GetSliceFacesCamera_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSliceFacesCamera();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageMapper3D_GetSlicePlane_126(JNIEnv* env, jobject obj)
{
  vtkPlane * temp20;

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSlicePlane();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageMapper3D_GetSlicePlaneInDataCoords_127(JNIEnv* env, jobject obj,jobject id0,jdoubleArray id1)
{
  vtkMatrix4x4 * temp0;
  double temp1[4];
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetSlicePlaneInDataCoords(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageMapper3D_SetNumberOfThreads_128(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfThreads(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageMapper3D_GetNumberOfThreadsMinValue_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfThreadsMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageMapper3D_GetNumberOfThreadsMaxValue_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfThreadsMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageMapper3D_GetNumberOfThreads_131(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfThreads();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageMapper3D_SetStreaming_132(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStreaming(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageMapper3D_GetStreaming_133(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStreaming();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageMapper3D_StreamingOn_134(JNIEnv* env, jobject obj)
{

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->StreamingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageMapper3D_StreamingOff_135(JNIEnv* env, jobject obj)
{

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->StreamingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageMapper3D_GetIndexBounds_136(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkImageMapper3D* op = static_cast<vtkImageMapper3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetIndexBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}
