// java wrapper for vtkCompositePolyDataMapper object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCompositePolyDataMapper.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataMapper_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCompositePolyDataMapper_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCompositePolyDataMapper",dType)) { return me; }
  if ((res= vtkPolyDataMapper_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCompositePolyDataMapper_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCompositePolyDataMapper_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCompositePolyDataMapper_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCompositePolyDataMapper_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_Render_14(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkRenderer * temp0;
  vtkActor * temp1;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkActor*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render(temp0,temp1);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCompositePolyDataMapper_GetBounds_15(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_GetBounds_16(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_ShallowCopy_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractMapper * temp0;
  temp0 = static_cast<vtkAbstractMapper*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_ReleaseGraphicsResources_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositePolyDataMapper_HasOpaqueGeometry_19(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasOpaqueGeometry();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositePolyDataMapper_HasTranslucentPolygonalGeometry_110(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_SetCompositeDataDisplayAttributes_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCompositeDataDisplayAttributes * temp0;
  temp0 = static_cast<vtkCompositeDataDisplayAttributes*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCompositeDataDisplayAttributes(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCompositePolyDataMapper_GetCompositeDataDisplayAttributes_112(JNIEnv* env, jobject obj)
{
  vtkCompositeDataDisplayAttributes * temp20;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCompositeDataDisplayAttributes();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_SetBlockVisibility_113(JNIEnv* env, jobject obj,jint id0,jboolean id1)
{
   unsigned int   temp0;
  bool   temp1;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockVisibility(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositePolyDataMapper_GetBlockVisibility_114(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlockVisibility(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_RemoveBlockVisibility_115(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockVisibility(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_RemoveBlockVisibilities_116(JNIEnv* env, jobject obj)
{

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockVisibilities();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_SetBlockColor_117(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
   unsigned int   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockColor(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_SetBlockColor_118(JNIEnv* env, jobject obj,jint id0,jdouble id1,jdouble id2,jdouble id3)
{
   unsigned int   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockColor(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_GetBlockColor_119(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
   unsigned int   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBlockColor(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_RemoveBlockColor_120(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockColor(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_RemoveBlockColors_121(JNIEnv* env, jobject obj)
{

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockColors();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_SetBlockOpacity_122(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
   unsigned int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockOpacity(temp0,temp1);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCompositePolyDataMapper_GetBlockOpacity_123(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  double   temp20;
  temp0 = id0;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlockOpacity(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_RemoveBlockOpacity_124(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockOpacity(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_RemoveBlockOpacities_125(JNIEnv* env, jobject obj)
{

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockOpacities();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_SetBlockScalarMode_126(JNIEnv* env, jobject obj,jint id0,jint id1)
{
   unsigned int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockScalarMode(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCompositePolyDataMapper_GetBlockScalarMode_127(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  int   temp20;
  temp0 = id0;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlockScalarMode(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_RemoveBlockScalarMode_128(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockScalarMode(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_RemoveBlockScalarModes_129(JNIEnv* env, jobject obj)
{

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockScalarModes();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_SetBlockArrayAccessMode_130(JNIEnv* env, jobject obj,jint id0,jint id1)
{
   unsigned int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockArrayAccessMode(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCompositePolyDataMapper_GetBlockArrayAccessMode_131(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  int   temp20;
  temp0 = id0;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlockArrayAccessMode(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_RemoveBlockArrayAccessMode_132(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockArrayAccessMode(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_RemoveBlockArrayAccessModes_133(JNIEnv* env, jobject obj)
{

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockArrayAccessModes();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_SetBlockArrayComponent_134(JNIEnv* env, jobject obj,jint id0,jint id1)
{
   unsigned int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockArrayComponent(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCompositePolyDataMapper_GetBlockArrayComponent_135(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  int   temp20;
  temp0 = id0;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlockArrayComponent(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_RemoveBlockArrayComponent_136(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockArrayComponent(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_RemoveBlockArrayComponents_137(JNIEnv* env, jobject obj)
{

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockArrayComponents();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_SetBlockArrayId_138(JNIEnv* env, jobject obj,jint id0,jint id1)
{
   unsigned int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockArrayId(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCompositePolyDataMapper_GetBlockArrayId_139(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  int   temp20;
  temp0 = id0;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlockArrayId(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_RemoveBlockArrayId_140(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockArrayId(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_RemoveBlockArrayIds_141(JNIEnv* env, jobject obj)
{

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockArrayIds();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_SetBlockArrayName_142(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1)
{
   unsigned int   temp0;
  std::string temp1;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToString(env, id1, len1);

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockArrayName(temp0,temp1);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCompositePolyDataMapper_GetBlockArrayName_143(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  std::string   temp20;
  temp0 = id0;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlockArrayName(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_RemoveBlockArrayName_144(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockArrayName(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_RemoveBlockArrayNames_145(JNIEnv* env, jobject obj)
{

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockArrayNames();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_SetBlockFieldDataTupleId_146(JNIEnv* env, jobject obj,jint id0,jlong id1)
{
   unsigned int   temp0;
  long long   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlockFieldDataTupleId(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCompositePolyDataMapper_GetBlockFieldDataTupleId_147(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  long long   temp20;
  temp0 = id0;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlockFieldDataTupleId(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_RemoveBlockFieldDataTupleId_148(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockFieldDataTupleId(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_RemoveBlockFieldDataTupleIds_149(JNIEnv* env, jobject obj)
{

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveBlockFieldDataTupleIds();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_SetColorMissingArraysWithNanColor_150(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorMissingArraysWithNanColor(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCompositePolyDataMapper_GetColorMissingArraysWithNanColor_151(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorMissingArraysWithNanColor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_ColorMissingArraysWithNanColorOn_152(JNIEnv* env, jobject obj)
{

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ColorMissingArraysWithNanColorOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_ColorMissingArraysWithNanColorOff_153(JNIEnv* env, jobject obj)
{

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ColorMissingArraysWithNanColorOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_SetInputArrayToProcess_154(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3, jbyteArray id4, jint len4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  char * temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = vtkJavaUTF8ToChars(env, id4, len4);

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputArrayToProcess(temp0,temp1,temp2,temp3,temp4);
  delete[] temp4;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_SetInputArrayToProcess_155(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputArrayToProcess(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_SetInputArrayToProcess_156(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkInformation * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputArrayToProcess(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_SetVBOShiftScaleMethod_157(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVBOShiftScaleMethod(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_SetPauseShiftScale_158(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPauseShiftScale(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCompositePolyDataMapper_GetMTime_159(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_SetInputArrayToProcess_160(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputArrayToProcess(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCompositePolyDataMapper_SetInputArrayToProcess_161(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2, jbyteArray id3, jint len3, jbyteArray id4, jint len4)
{
  int   temp0;
  int   temp1;
  int   temp2;
  char * temp3;
  char * temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = vtkJavaUTF8ToChars(env, id3, len3);
  temp4 = vtkJavaUTF8ToChars(env, id4, len4);

  vtkCompositePolyDataMapper* op = static_cast<vtkCompositePolyDataMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputArrayToProcess(temp0,temp1,temp2,temp3,temp4);
  delete[] temp3;
  delete[] temp4;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkCompositePolyDataMapper_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkCompositePolyDataMapper::New());
}
