// java wrapper for vtkLightRepresentation object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkLightRepresentation.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkWidgetRepresentation_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkLightRepresentation_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkLightRepresentation",dType)) { return me; }
  if ((res= vtkWidgetRepresentation_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLightRepresentation_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLightRepresentation_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLightRepresentation_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLightRepresentation_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightRepresentation_SetPositional_14(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPositional(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkLightRepresentation_GetPositional_15(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPositional();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightRepresentation_PositionalOn_16(JNIEnv* env, jobject obj)
{

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->PositionalOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightRepresentation_PositionalOff_17(JNIEnv* env, jobject obj)
{

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->PositionalOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightRepresentation_SetLightPosition_18(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLightPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLightRepresentation_GetLightPosition_19(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLightPosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightRepresentation_SetFocalPoint_110(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFocalPoint(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLightRepresentation_GetFocalPoint_111(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFocalPoint();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightRepresentation_SetConeAngle_112(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetConeAngle(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkLightRepresentation_GetConeAngle_113(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConeAngle();
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLightRepresentation_GetLightColor_114(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLightColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightRepresentation_SetInteractionState_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteractionState(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLightRepresentation_GetInteractionStateMinValue_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInteractionStateMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLightRepresentation_GetInteractionStateMaxValue_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInteractionStateMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLightRepresentation_GetProperty_118(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightRepresentation_BuildRepresentation_119(JNIEnv* env, jobject obj)
{

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildRepresentation();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLightRepresentation_ComputeInteractionState_120(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeInteractionState(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightRepresentation_StartWidgetInteraction_121(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartWidgetInteraction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightRepresentation_WidgetInteraction_122(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->WidgetInteraction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightRepresentation_ReleaseGraphicsResources_123(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLightRepresentation_RenderOpaqueGeometry_124(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLightRepresentation_RenderTranslucentPolygonalGeometry_125(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentPolygonalGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightRepresentation_GetActors_126(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPropCollection * temp0;
  temp0 = static_cast<vtkPropCollection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLightRepresentation* op = static_cast<vtkLightRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetActors(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkLightRepresentation_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkLightRepresentation::New());
}
