// java wrapper for vtkImageCheckerboard object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageCheckerboard.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkThreadedImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageCheckerboard_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageCheckerboard",dType)) { return me; }
  if ((res= vtkThreadedImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageCheckerboard_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageCheckerboard* op = static_cast<vtkImageCheckerboard*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageCheckerboard_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageCheckerboard* op = static_cast<vtkImageCheckerboard*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageCheckerboard_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageCheckerboard* op = static_cast<vtkImageCheckerboard*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageCheckerboard_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageCheckerboard* op = static_cast<vtkImageCheckerboard*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCheckerboard_SetNumberOfDivisions_14(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageCheckerboard* op = static_cast<vtkImageCheckerboard*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfDivisions(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCheckerboard_SetNumberOfDivisions_15(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageCheckerboard* op = static_cast<vtkImageCheckerboard*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfDivisions(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImageCheckerboard_GetNumberOfDivisions_16(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImageCheckerboard* op = static_cast<vtkImageCheckerboard*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfDivisions();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCheckerboard_SetInput1Data_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageCheckerboard* op = static_cast<vtkImageCheckerboard*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInput1Data(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageCheckerboard_SetInput2Data_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageCheckerboard* op = static_cast<vtkImageCheckerboard*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInput2Data(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageCheckerboard_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageCheckerboard::New());
}
