// java wrapper for vtkDataObjectWriter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDataObjectWriter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkWriter_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDataObjectWriter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDataObjectWriter",dType)) { return me; }
  if ((res= vtkWriter_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectWriter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataObjectWriter* op = static_cast<vtkDataObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectWriter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataObjectWriter* op = static_cast<vtkDataObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectWriter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataObjectWriter* op = static_cast<vtkDataObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectWriter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataObjectWriter* op = static_cast<vtkDataObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectWriter_SetFileName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataObjectWriter* op = static_cast<vtkDataObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataObjectWriter_GetFileName_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataObjectWriter* op = static_cast<vtkDataObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectWriter_SetHeader_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataObjectWriter* op = static_cast<vtkDataObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHeader(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataObjectWriter_GetHeader_17(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataObjectWriter* op = static_cast<vtkDataObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHeader();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectWriter_SetFileType_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDataObjectWriter* op = static_cast<vtkDataObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectWriter_GetFileType_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObjectWriter* op = static_cast<vtkDataObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectWriter_SetFileTypeToASCII_110(JNIEnv* env, jobject obj)
{

  vtkDataObjectWriter* op = static_cast<vtkDataObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileTypeToASCII();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectWriter_SetFileTypeToBinary_111(JNIEnv* env, jobject obj)
{

  vtkDataObjectWriter* op = static_cast<vtkDataObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileTypeToBinary();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectWriter_SetWriteToOutputString_112(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDataObjectWriter* op = static_cast<vtkDataObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWriteToOutputString(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectWriter_WriteToOutputStringOn_113(JNIEnv* env, jobject obj)
{

  vtkDataObjectWriter* op = static_cast<vtkDataObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->WriteToOutputStringOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectWriter_WriteToOutputStringOff_114(JNIEnv* env, jobject obj)
{

  vtkDataObjectWriter* op = static_cast<vtkDataObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->WriteToOutputStringOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectWriter_GetWriteToOutputString_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObjectWriter* op = static_cast<vtkDataObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWriteToOutputString();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataObjectWriter_GetOutputString_116(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataObjectWriter* op = static_cast<vtkDataObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataObjectWriter_GetOutputStdString_117(JNIEnv* env, jobject obj)
{
  vtkStdString   temp20;

  vtkDataObjectWriter* op = static_cast<vtkDataObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputStdString();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectWriter_GetOutputStringLength_118(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkDataObjectWriter* op = static_cast<vtkDataObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputStringLength();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectWriter_SetFieldDataName_119(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataObjectWriter* op = static_cast<vtkDataObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFieldDataName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataObjectWriter_GetFieldDataName_120(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkDataObjectWriter* op = static_cast<vtkDataObjectWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldDataName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkDataObjectWriter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkDataObjectWriter::New());
}
