// java wrapper for vtkNIFTIImageReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkNIFTIImageReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageReader2_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkNIFTIImageReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkNIFTIImageReader",dType)) { return me; }
  if ((res= vtkImageReader2_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkNIFTIImageReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkNIFTIImageReader* op = static_cast<vtkNIFTIImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkNIFTIImageReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkNIFTIImageReader* op = static_cast<vtkNIFTIImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkNIFTIImageReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkNIFTIImageReader* op = static_cast<vtkNIFTIImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkNIFTIImageReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkNIFTIImageReader* op = static_cast<vtkNIFTIImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkNIFTIImageReader_GetFileExtensions_14(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkNIFTIImageReader* op = static_cast<vtkNIFTIImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileExtensions();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkNIFTIImageReader_GetDescriptiveName_15(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkNIFTIImageReader* op = static_cast<vtkNIFTIImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDescriptiveName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkNIFTIImageReader_CanReadFile_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkNIFTIImageReader* op = static_cast<vtkNIFTIImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanReadFile(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkNIFTIImageReader_GetTimeAsVector_17(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkNIFTIImageReader* op = static_cast<vtkNIFTIImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeAsVector();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkNIFTIImageReader_SetTimeAsVector_18(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkNIFTIImageReader* op = static_cast<vtkNIFTIImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTimeAsVector(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkNIFTIImageReader_TimeAsVectorOn_19(JNIEnv* env, jobject obj)
{

  vtkNIFTIImageReader* op = static_cast<vtkNIFTIImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->TimeAsVectorOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkNIFTIImageReader_TimeAsVectorOff_110(JNIEnv* env, jobject obj)
{

  vtkNIFTIImageReader* op = static_cast<vtkNIFTIImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->TimeAsVectorOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkNIFTIImageReader_GetTimeDimension_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkNIFTIImageReader* op = static_cast<vtkNIFTIImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeDimension();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkNIFTIImageReader_GetTimeSpacing_112(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkNIFTIImageReader* op = static_cast<vtkNIFTIImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeSpacing();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkNIFTIImageReader_GetRescaleSlope_113(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkNIFTIImageReader* op = static_cast<vtkNIFTIImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRescaleSlope();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkNIFTIImageReader_GetRescaleIntercept_114(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkNIFTIImageReader* op = static_cast<vtkNIFTIImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRescaleIntercept();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkNIFTIImageReader_GetPlanarRGB_115(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkNIFTIImageReader* op = static_cast<vtkNIFTIImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPlanarRGB();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkNIFTIImageReader_SetPlanarRGB_116(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkNIFTIImageReader* op = static_cast<vtkNIFTIImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlanarRGB(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkNIFTIImageReader_PlanarRGBOn_117(JNIEnv* env, jobject obj)
{

  vtkNIFTIImageReader* op = static_cast<vtkNIFTIImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->PlanarRGBOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkNIFTIImageReader_PlanarRGBOff_118(JNIEnv* env, jobject obj)
{

  vtkNIFTIImageReader* op = static_cast<vtkNIFTIImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->PlanarRGBOff();

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkNIFTIImageReader_GetQFac_119(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkNIFTIImageReader* op = static_cast<vtkNIFTIImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetQFac();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkNIFTIImageReader_GetQFormMatrix_120(JNIEnv* env, jobject obj)
{
  vtkMatrix4x4 * temp20;

  vtkNIFTIImageReader* op = static_cast<vtkNIFTIImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetQFormMatrix();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkNIFTIImageReader_GetSFormMatrix_121(JNIEnv* env, jobject obj)
{
  vtkMatrix4x4 * temp20;

  vtkNIFTIImageReader* op = static_cast<vtkNIFTIImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSFormMatrix();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkNIFTIImageReader_GetNIFTIHeader_122(JNIEnv* env, jobject obj)
{
  vtkNIFTIImageHeader * temp20;

  vtkNIFTIImageReader* op = static_cast<vtkNIFTIImageReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNIFTIHeader();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkNIFTIImageReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkNIFTIImageReader::New());
}
