// java wrapper for vtkTransformToGrid object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkTransformToGrid.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkTransformToGrid_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkTransformToGrid",dType)) { return me; }
  if ((res= vtkAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTransformToGrid_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTransformToGrid_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTransformToGrid_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTransformToGrid_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransformToGrid_SetInput_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractTransform * temp0;
  temp0 = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInput(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTransformToGrid_GetInput_15(JNIEnv* env, jobject obj)
{
  vtkAbstractTransform * temp20;

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransformToGrid_SetGridExtent_16(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridExtent(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransformToGrid_SetGridExtent_17(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridExtent(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkTransformToGrid_GetGridExtent_18(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridExtent();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransformToGrid_SetGridOrigin_19(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridOrigin(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransformToGrid_SetGridOrigin_110(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridOrigin(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkTransformToGrid_GetGridOrigin_111(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridOrigin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransformToGrid_SetGridSpacing_112(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridSpacing(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransformToGrid_SetGridSpacing_113(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridSpacing(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkTransformToGrid_GetGridSpacing_114(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridSpacing();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransformToGrid_SetGridScalarType_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridScalarType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTransformToGrid_GetGridScalarType_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridScalarType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransformToGrid_SetGridScalarTypeToDouble_117(JNIEnv* env, jobject obj)
{

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridScalarTypeToDouble();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransformToGrid_SetGridScalarTypeToFloat_118(JNIEnv* env, jobject obj)
{

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridScalarTypeToFloat();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransformToGrid_SetGridScalarTypeToShort_119(JNIEnv* env, jobject obj)
{

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridScalarTypeToShort();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransformToGrid_SetGridScalarTypeToUnsignedShort_120(JNIEnv* env, jobject obj)
{

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridScalarTypeToUnsignedShort();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransformToGrid_SetGridScalarTypeToUnsignedChar_121(JNIEnv* env, jobject obj)
{

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridScalarTypeToUnsignedChar();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTransformToGrid_SetGridScalarTypeToChar_122(JNIEnv* env, jobject obj)
{

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridScalarTypeToChar();

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTransformToGrid_GetDisplacementScale_123(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDisplacementScale();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkTransformToGrid_GetDisplacementShift_124(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDisplacementShift();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTransformToGrid_GetOutput_125(JNIEnv* env, jobject obj)
{
  vtkImageData * temp20;

  vtkTransformToGrid* op = static_cast<vtkTransformToGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkTransformToGrid_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkTransformToGrid::New());
}
