// java wrapper for vtkPointLocator object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPointLocator.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkIncrementalPointLocator_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPointLocator_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPointLocator",dType)) { return me; }
  if ((res= vtkIncrementalPointLocator_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointLocator_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointLocator_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointLocator_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointLocator_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointLocator_SetDivisions_14(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDivisions(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointLocator_SetDivisions_15(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDivisions(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkPointLocator_GetDivisions_16(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDivisions();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointLocator_SetNumberOfPointsPerBucket_17(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfPointsPerBucket(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointLocator_GetNumberOfPointsPerBucketMinValue_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointsPerBucketMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointLocator_GetNumberOfPointsPerBucketMaxValue_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointsPerBucketMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointLocator_GetNumberOfPointsPerBucket_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointsPerBucket();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointLocator_FindClosestPoint_111(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindClosestPoint(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointLocator_InitPointInsertion_112(JNIEnv* env, jobject obj,jobject id0,jdoubleArray id1)
{
  vtkPoints * temp0;
  double temp1[6];
  int   temp20;
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InitPointInsertion(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointLocator_InitPointInsertion_113(JNIEnv* env, jobject obj,jobject id0,jdoubleArray id1,jlong id2)
{
  vtkPoints * temp0;
  double temp1[6];
  long long   temp2;
  int   temp20;
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);
  temp2 = id2;

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InitPointInsertion(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointLocator_InsertPoint_114(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertPoint(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointLocator_InsertNextPoint_115(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextPoint(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointLocator_IsInsertedPoint_116(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  long long   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsInsertedPoint(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointLocator_IsInsertedPoint_117(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsInsertedPoint(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointLocator_FindClosestInsertedPoint_118(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindClosestInsertedPoint(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointLocator_FindClosestNPoints_119(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1,jobject id2)
{
  int   temp0;
  double temp1[3];
  vtkIdList * temp2;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->FindClosestNPoints(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointLocator_FindDistributedPoints_120(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1,jobject id2,jint id3)
{
  int   temp0;
  double temp1[3];
  vtkIdList * temp2;
  int   temp3;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = id3;

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->FindDistributedPoints(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointLocator_FindDistributedPoints_121(JNIEnv* env, jobject obj,jint id0,jdouble id1,jdouble id2,jdouble id3,jobject id4,jint id5)
{
  int   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  vtkIdList * temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = id5;

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->FindDistributedPoints(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointLocator_FindPointsWithinRadius_122(JNIEnv* env, jobject obj,jdouble id0,jdoubleArray id1,jobject id2)
{
  double   temp0;
  double temp1[3];
  vtkIdList * temp2;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->FindPointsWithinRadius(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointLocator_GetPointsInBucket_123(JNIEnv* env, jobject obj,jdoubleArray id0,jintArray id1)
{
  double temp0[3];
  int temp1[3];
  vtkIdList * temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointsInBucket(temp0,temp1);
  env->SetIntArrayRegion(id1, 0, 3, reinterpret_cast<jint*>(&temp1[0]));
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointLocator_GetPoints_124(JNIEnv* env, jobject obj)
{
  vtkPoints * temp20;

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoints();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointLocator_Initialize_125(JNIEnv* env, jobject obj)
{

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointLocator_FreeSearchStructure_126(JNIEnv* env, jobject obj)
{

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->FreeSearchStructure();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointLocator_BuildLocator_127(JNIEnv* env, jobject obj)
{

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildLocator();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointLocator_ForceBuildLocator_128(JNIEnv* env, jobject obj)
{

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceBuildLocator();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointLocator_GenerateRepresentation_129(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkPolyData * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateRepresentation(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointLocator_FindClosestPoint_130(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  long long   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPointLocator* op = static_cast<vtkPointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindClosestPoint(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPointLocator_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPointLocator::New());
}
