// java wrapper for vtkLagrangeWedge object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkLagrangeWedge.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkHigherOrderWedge_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkLagrangeWedge_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkLagrangeWedge",dType)) { return me; }
  if ((res= vtkHigherOrderWedge_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLagrangeWedge_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLagrangeWedge* op = static_cast<vtkLagrangeWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLagrangeWedge_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLagrangeWedge* op = static_cast<vtkLagrangeWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLagrangeWedge_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLagrangeWedge* op = static_cast<vtkLagrangeWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLagrangeWedge_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLagrangeWedge* op = static_cast<vtkLagrangeWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLagrangeWedge_GetCellType_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLagrangeWedge* op = static_cast<vtkLagrangeWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLagrangeWedge_GetEdge_15(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkLagrangeWedge* op = static_cast<vtkLagrangeWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdge(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLagrangeWedge_GetFace_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkLagrangeWedge* op = static_cast<vtkLagrangeWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFace(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLagrangeWedge_GetBoundaryQuad_17(JNIEnv* env, jobject obj)
{
  vtkHigherOrderQuadrilateral * temp20;

  vtkLagrangeWedge* op = static_cast<vtkLagrangeWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBoundaryQuad();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLagrangeWedge_GetBoundaryTri_18(JNIEnv* env, jobject obj)
{
  vtkHigherOrderTriangle * temp20;

  vtkLagrangeWedge* op = static_cast<vtkLagrangeWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBoundaryTri();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLagrangeWedge_GetEdgeCell_19(JNIEnv* env, jobject obj)
{
  vtkHigherOrderCurve * temp20;

  vtkLagrangeWedge* op = static_cast<vtkLagrangeWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeCell();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLagrangeWedge_GetInterpolation_110(JNIEnv* env, jobject obj)
{
  vtkHigherOrderInterpolation * temp20;

  vtkLagrangeWedge* op = static_cast<vtkLagrangeWedge*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolation();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkLagrangeWedge_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkLagrangeWedge::New());
}
