// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause

#ifndef vtkIOParallelXdmf3ObjectFactory_h
#define vtkIOParallelXdmf3ObjectFactory_h

#include "vtkIOParallelXdmf3Module.h" // For export macro
#include "vtkObjectFactory.h"

VTK_ABI_NAMESPACE_BEGIN

class VTKIOPARALLELXDMF3_EXPORT vtkIOParallelXdmf3ObjectFactory : public vtkObjectFactory
{
public:
  static vtkIOParallelXdmf3ObjectFactory * New();
  vtkTypeMacro(vtkIOParallelXdmf3ObjectFactory, vtkObjectFactory);

  const char * GetDescription() VTK_FUTURE_CONST override { return "vtkIOParallelXdmf3 factory overrides."; }

  const char * GetVTKSourceVersion() VTK_FUTURE_CONST override;

  void PrintSelf(ostream &os, vtkIndent indent) override;

protected:
  vtkIOParallelXdmf3ObjectFactory();

private:
  vtkIOParallelXdmf3ObjectFactory(const vtkIOParallelXdmf3ObjectFactory&) = delete;
  void operator=(const vtkIOParallelXdmf3ObjectFactory&) = delete;
};

VTK_ABI_NAMESPACE_END

#endif // vtkIOParallelXdmf3ObjectFactory_h
