// java wrapper for vtkGridAxesActor2D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkGridAxesActor2D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkProp3D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkGridAxesActor2D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkGridAxesActor2D",dType)) { return me; }
  if ((res= vtkProp3D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridAxesActor2D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridAxesActor2D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGridAxesActor2D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGridAxesActor2D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_SetGridBounds_14(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridBounds(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_SetGridBounds_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridBounds(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkGridAxesActor2D_GetGridBounds_16(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_SetFace_17(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFace(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridAxesActor2D_GetFaceMinValue_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridAxesActor2D_GetFaceMaxValue_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridAxesActor2D_GetFace_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFace();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_SetLabelMask_111(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelMask(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridAxesActor2D_GetLabelMask_112(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelMask();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_GetActors_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPropCollection * temp0;
  temp0 = static_cast<vtkPropCollection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetActors(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_UpdateGeometry_114(JNIEnv* env, jobject obj,jobject id0,jboolean id1)
{
  vtkViewport * temp0;
  bool   temp1;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = (id1 != 0) ? true : false;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateGeometry(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_SetProperty_115(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGridAxesActor2D_GetProperty_116(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_SetTitleTextProperty_117(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkTextProperty * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id1));

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleTextProperty(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGridAxesActor2D_GetTitleTextProperty_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkTextProperty * temp20;
  temp0 = id0;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitleTextProperty(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_SetLabelTextProperty_119(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkTextProperty * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id1));

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelTextProperty(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGridAxesActor2D_GetLabelTextProperty_120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkTextProperty * temp20;
  temp0 = id0;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelTextProperty(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_SetTitle_121(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1)
{
  int   temp0;
  std::string temp1;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToString(env, id1, len1);

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitle(temp0,temp1);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGridAxesActor2D_GetTitle_122(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const std::string * temp20;
  temp0 = id0;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = &(op)->GetTitle(temp0);
  return vtkJavaStringToUTF8(env, *temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_SetNotation_123(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNotation(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridAxesActor2D_GetNotation_124(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNotation(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_SetPrecision_125(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPrecision(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridAxesActor2D_GetPrecision_126(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPrecision(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_SetCustomTickPositions_127(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkDoubleArray * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkDoubleArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCustomTickPositions(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_SetGenerateGrid_128(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateGrid(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGridAxesActor2D_GetGenerateGrid_129(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateGrid();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_GenerateGridOn_130(JNIEnv* env, jobject obj)
{

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateGridOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_GenerateGridOff_131(JNIEnv* env, jobject obj)
{

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateGridOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_SetGenerateEdges_132(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateEdges(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGridAxesActor2D_GetGenerateEdges_133(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateEdges();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_GenerateEdgesOn_134(JNIEnv* env, jobject obj)
{

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateEdgesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_GenerateEdgesOff_135(JNIEnv* env, jobject obj)
{

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateEdgesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_SetGenerateTicks_136(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateTicks(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGridAxesActor2D_GetGenerateTicks_137(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateTicks();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_GenerateTicksOn_138(JNIEnv* env, jobject obj)
{

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateTicksOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_GenerateTicksOff_139(JNIEnv* env, jobject obj)
{

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateTicksOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_SetForceOpaque_140(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForceOpaque(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGridAxesActor2D_GetForceOpaque_141(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetForceOpaque();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_ForceOpaqueOn_142(JNIEnv* env, jobject obj)
{

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceOpaqueOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_ForceOpaqueOff_143(JNIEnv* env, jobject obj)
{

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceOpaqueOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridAxesActor2D_RenderOpaqueGeometry_144(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridAxesActor2D_RenderTranslucentPolygonalGeometry_145(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentPolygonalGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridAxesActor2D_RenderOverlay_146(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOverlay(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridAxesActor2D_HasTranslucentPolygonalGeometry_147(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_ReleaseGraphicsResources_148(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGridAxesActor2D_GetMTime_149(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_SetLabelDisplayOffset_150(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelDisplayOffset(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridAxesActor2D_SetLabelDisplayOffset_151(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelDisplayOffset(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkGridAxesActor2D_GetLabelDisplayOffset_152(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkGridAxesActor2D* op = static_cast<vtkGridAxesActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelDisplayOffset();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkGridAxesActor2D_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkGridAxesActor2D::New());
}
