// java wrapper for vtkPolarAxesActor object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPolarAxesActor.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkActor_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPolarAxesActor_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPolarAxesActor",dType)) { return me; }
  if ((res= vtkActor_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolarAxesActor_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolarAxesActor_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolarAxesActor_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolarAxesActor_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolarAxesActor_RenderOpaqueGeometry_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolarAxesActor_RenderOverlay_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOverlay(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolarAxesActor_RenderTranslucentPolygonalGeometry_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentPolygonalGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetPole_17(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPole(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetPole_18(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPole(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkPolarAxesActor_GetPole_19(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPole();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetLog_110(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLog(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolarAxesActor_GetLog_111(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLog();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_LogOn_112(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->LogOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_LogOff_113(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->LogOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetRequestedNumberOfRadialAxes_114(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRequestedNumberOfRadialAxes(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolarAxesActor_GetRequestedNumberOfRadialAxesMinValue_115(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRequestedNumberOfRadialAxesMinValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolarAxesActor_GetRequestedNumberOfRadialAxesMaxValue_116(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRequestedNumberOfRadialAxesMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolarAxesActor_GetRequestedNumberOfRadialAxes_117(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRequestedNumberOfRadialAxes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetRequestedNumberOfPolarAxes_118(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRequestedNumberOfPolarAxes(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolarAxesActor_GetRequestedNumberOfPolarAxesMinValue_119(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRequestedNumberOfPolarAxesMinValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolarAxesActor_GetRequestedNumberOfPolarAxesMaxValue_120(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRequestedNumberOfPolarAxesMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolarAxesActor_GetRequestedNumberOfPolarAxes_121(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRequestedNumberOfPolarAxes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetRange_122(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetRange_123(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRange(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkPolarAxesActor_GetRange_124(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetMinimumRadius_125(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinimumRadius(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetMinimumRadius_126(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinimumRadius();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetMaximumRadius_127(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumRadius(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetMaximumRadius_128(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumRadius();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetMinimumAngle_129(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinimumAngle(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetMinimumAngle_130(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinimumAngle();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetMaximumAngle_131(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumAngle(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetMaximumAngle_132(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumAngle();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetSmallestVisiblePolarAngle_133(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSmallestVisiblePolarAngle(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetSmallestVisiblePolarAngleMinValue_134(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSmallestVisiblePolarAngleMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetSmallestVisiblePolarAngleMaxValue_135(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSmallestVisiblePolarAngleMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetSmallestVisiblePolarAngle_136(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSmallestVisiblePolarAngle();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetTickLocation_137(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTickLocation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolarAxesActor_GetTickLocationMinValue_138(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickLocationMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolarAxesActor_GetTickLocationMaxValue_139(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickLocationMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolarAxesActor_GetTickLocation_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickLocation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetRadialUnits_141(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRadialUnits(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolarAxesActor_GetRadialUnits_142(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadialUnits();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetScreenSize_143(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScreenSize(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetScreenSize_144(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScreenSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetPolarTitleOffset_145(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolarTitleOffset(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetPolarTitleOffset_146(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolarTitleOffset(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarTitleOffset_147(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarTitleOffset();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetRadialTitleOffset_148(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRadialTitleOffset(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetRadialTitleOffset_149(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRadialTitleOffset(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkPolarAxesActor_GetRadialTitleOffset_150(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadialTitleOffset();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarLabelOffset_151(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarLabelOffset();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetPolarLabelOffset_152(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolarLabelOffset(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarExponentOffset_153(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarExponentOffset();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetPolarExponentOffset_154(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolarExponentOffset(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetCamera_155(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCamera * temp0;
  temp0 = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCamera(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolarAxesActor_GetCamera_156(JNIEnv* env, jobject obj)
{
  vtkCamera * temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCamera();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarAxisTitle_157(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarAxisTitle();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetPolarAxisTitle_158(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string   temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolarAxisTitle(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetPolarLabelFormat_159(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolarLabelFormat(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarLabelFormat_160(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarLabelFormat();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetExponentLocation_161(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExponentLocation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolarAxesActor_GetExponentLocationMinValue_162(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExponentLocationMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolarAxesActor_GetExponentLocationMaxValue_163(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExponentLocationMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolarAxesActor_GetExponentLocation_164(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExponentLocation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetRadialAngleFormat_165(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRadialAngleFormat(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPolarAxesActor_GetRadialAngleFormat_166(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadialAngleFormat();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_ReleaseGraphicsResources_167(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetEnableDistanceLOD_168(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnableDistanceLOD(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolarAxesActor_GetEnableDistanceLOD_169(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnableDistanceLOD();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetDistanceLODThreshold_170(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDistanceLODThreshold(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetDistanceLODThresholdMinValue_171(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistanceLODThresholdMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetDistanceLODThresholdMaxValue_172(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistanceLODThresholdMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetDistanceLODThreshold_173(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistanceLODThreshold();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetEnableViewAngleLOD_174(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnableViewAngleLOD(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolarAxesActor_GetEnableViewAngleLOD_175(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnableViewAngleLOD();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetViewAngleLODThreshold_176(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetViewAngleLODThreshold(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetViewAngleLODThresholdMinValue_177(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetViewAngleLODThresholdMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetViewAngleLODThresholdMaxValue_178(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetViewAngleLODThresholdMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetViewAngleLODThreshold_179(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetViewAngleLODThreshold();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetPolarAxisVisibility_180(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolarAxisVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarAxisVisibility_181(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarAxisVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_PolarAxisVisibilityOn_182(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->PolarAxisVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_PolarAxisVisibilityOff_183(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->PolarAxisVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetDrawRadialGridlines_184(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawRadialGridlines(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolarAxesActor_GetDrawRadialGridlines_185(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawRadialGridlines();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_DrawRadialGridlinesOn_186(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawRadialGridlinesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_DrawRadialGridlinesOff_187(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawRadialGridlinesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetDrawPolarArcsGridlines_188(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawPolarArcsGridlines(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolarAxesActor_GetDrawPolarArcsGridlines_189(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawPolarArcsGridlines();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_DrawPolarArcsGridlinesOn_190(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawPolarArcsGridlinesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_DrawPolarArcsGridlinesOff_191(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawPolarArcsGridlinesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetPolarTitleVisibility_192(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolarTitleVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarTitleVisibility_193(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarTitleVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_PolarTitleVisibilityOn_194(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->PolarTitleVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_PolarTitleVisibilityOff_195(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->PolarTitleVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetRadialAxisTitleLocation_196(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRadialAxisTitleLocation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolarAxesActor_GetRadialAxisTitleLocationMinValue_197(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadialAxisTitleLocationMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolarAxesActor_GetRadialAxisTitleLocationMaxValue_198(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadialAxisTitleLocationMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolarAxesActor_GetRadialAxisTitleLocation_199(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadialAxisTitleLocation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetPolarAxisTitleLocation_1100(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolarAxisTitleLocation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarAxisTitleLocationMinValue_1101(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarAxisTitleLocationMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarAxisTitleLocationMaxValue_1102(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarAxisTitleLocationMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarAxisTitleLocation_1103(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarAxisTitleLocation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetPolarLabelVisibility_1104(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolarLabelVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarLabelVisibility_1105(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarLabelVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_PolarLabelVisibilityOn_1106(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->PolarLabelVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_PolarLabelVisibilityOff_1107(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->PolarLabelVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetArcTicksOriginToPolarAxis_1108(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArcTicksOriginToPolarAxis(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolarAxesActor_GetArcTicksOriginToPolarAxis_1109(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArcTicksOriginToPolarAxis();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_ArcTicksOriginToPolarAxisOn_1110(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ArcTicksOriginToPolarAxisOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_ArcTicksOriginToPolarAxisOff_1111(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ArcTicksOriginToPolarAxisOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetRadialAxesOriginToPolarAxis_1112(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRadialAxesOriginToPolarAxis(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolarAxesActor_GetRadialAxesOriginToPolarAxis_1113(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadialAxesOriginToPolarAxis();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_RadialAxesOriginToPolarAxisOn_1114(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->RadialAxesOriginToPolarAxisOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_RadialAxesOriginToPolarAxisOff_1115(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->RadialAxesOriginToPolarAxisOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetPolarTickVisibility_1116(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolarTickVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarTickVisibility_1117(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarTickVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_PolarTickVisibilityOn_1118(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->PolarTickVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_PolarTickVisibilityOff_1119(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->PolarTickVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetAxisTickVisibility_1120(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisTickVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolarAxesActor_GetAxisTickVisibility_1121(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisTickVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_AxisTickVisibilityOn_1122(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->AxisTickVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_AxisTickVisibilityOff_1123(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->AxisTickVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetAxisMinorTickVisibility_1124(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisMinorTickVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolarAxesActor_GetAxisMinorTickVisibility_1125(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisMinorTickVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_AxisMinorTickVisibilityOn_1126(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->AxisMinorTickVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_AxisMinorTickVisibilityOff_1127(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->AxisMinorTickVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetAxisTickMatchesPolarAxes_1128(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisTickMatchesPolarAxes(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolarAxesActor_GetAxisTickMatchesPolarAxes_1129(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisTickMatchesPolarAxes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_AxisTickMatchesPolarAxesOn_1130(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->AxisTickMatchesPolarAxesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_AxisTickMatchesPolarAxesOff_1131(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->AxisTickMatchesPolarAxesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetArcTickVisibility_1132(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArcTickVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolarAxesActor_GetArcTickVisibility_1133(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArcTickVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_ArcTickVisibilityOn_1134(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ArcTickVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_ArcTickVisibilityOff_1135(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ArcTickVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetArcMinorTickVisibility_1136(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArcMinorTickVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolarAxesActor_GetArcMinorTickVisibility_1137(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArcMinorTickVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_ArcMinorTickVisibilityOn_1138(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ArcMinorTickVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_ArcMinorTickVisibilityOff_1139(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ArcMinorTickVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetArcTickMatchesRadialAxes_1140(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArcTickMatchesRadialAxes(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolarAxesActor_GetArcTickMatchesRadialAxes_1141(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArcTickMatchesRadialAxes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_ArcTickMatchesRadialAxesOn_1142(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ArcTickMatchesRadialAxesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_ArcTickMatchesRadialAxesOff_1143(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ArcTickMatchesRadialAxesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetArcMajorTickSize_1144(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArcMajorTickSize(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetArcMajorTickSize_1145(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArcMajorTickSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetPolarAxisMajorTickSize_1146(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolarAxisMajorTickSize(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarAxisMajorTickSize_1147(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarAxisMajorTickSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetLastRadialAxisMajorTickSize_1148(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLastRadialAxisMajorTickSize(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetLastRadialAxisMajorTickSize_1149(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLastRadialAxisMajorTickSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetPolarAxisTickRatioSize_1150(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolarAxisTickRatioSize(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarAxisTickRatioSize_1151(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarAxisTickRatioSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetLastAxisTickRatioSize_1152(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLastAxisTickRatioSize(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetLastAxisTickRatioSize_1153(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLastAxisTickRatioSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetArcTickRatioSize_1154(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArcTickRatioSize(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetArcTickRatioSize_1155(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArcTickRatioSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetTickRatioRadiusSize_1156(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTickRatioRadiusSize(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetTickRatioRadiusSize_1157(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickRatioRadiusSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetPolarAxisMajorTickThickness_1158(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolarAxisMajorTickThickness(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarAxisMajorTickThickness_1159(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarAxisMajorTickThickness();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetLastRadialAxisMajorTickThickness_1160(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLastRadialAxisMajorTickThickness(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetLastRadialAxisMajorTickThickness_1161(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLastRadialAxisMajorTickThickness();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetArcMajorTickThickness_1162(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArcMajorTickThickness(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetArcMajorTickThickness_1163(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArcMajorTickThickness();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetPolarAxisTickRatioThickness_1164(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolarAxisTickRatioThickness(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarAxisTickRatioThickness_1165(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarAxisTickRatioThickness();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetLastAxisTickRatioThickness_1166(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLastAxisTickRatioThickness(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetLastAxisTickRatioThickness_1167(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLastAxisTickRatioThickness();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetArcTickRatioThickness_1168(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArcTickRatioThickness(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetArcTickRatioThickness_1169(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArcTickRatioThickness();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetDeltaRangeMajor_1170(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDeltaRangeMajor(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetDeltaRangeMajor_1171(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDeltaRangeMajor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetDeltaRangeMinor_1172(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDeltaRangeMinor(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetDeltaRangeMinor_1173(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDeltaRangeMinor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetRequestedDeltaRangePolarAxes_1174(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRequestedDeltaRangePolarAxes(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetRequestedDeltaRangePolarAxes_1175(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRequestedDeltaRangePolarAxes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetDeltaAngleMajor_1176(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDeltaAngleMajor(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetDeltaAngleMajor_1177(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDeltaAngleMajor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetDeltaAngleMinor_1178(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDeltaAngleMinor(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetDeltaAngleMinor_1179(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDeltaAngleMinor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetRequestedDeltaAngleRadialAxes_1180(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRequestedDeltaAngleRadialAxes(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetRequestedDeltaAngleRadialAxes_1181(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRequestedDeltaAngleRadialAxes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetRadialAxesVisibility_1182(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRadialAxesVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolarAxesActor_GetRadialAxesVisibility_1183(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadialAxesVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_RadialAxesVisibilityOn_1184(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->RadialAxesVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_RadialAxesVisibilityOff_1185(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->RadialAxesVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetRadialTitleVisibility_1186(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRadialTitleVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolarAxesActor_GetRadialTitleVisibility_1187(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadialTitleVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_RadialTitleVisibilityOn_1188(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->RadialTitleVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_RadialTitleVisibilityOff_1189(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->RadialTitleVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetPolarArcsVisibility_1190(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolarArcsVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarArcsVisibility_1191(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarArcsVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_PolarArcsVisibilityOn_1192(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->PolarArcsVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_PolarArcsVisibilityOff_1193(JNIEnv* env, jobject obj)
{

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->PolarArcsVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetUse2DMode_1194(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUse2DMode(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolarAxesActor_GetUse2DMode_1195(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUse2DMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetPolarAxisTitleTextProperty_1196(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolarAxisTitleTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarAxisTitleTextProperty_1197(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarAxisTitleTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetPolarAxisLabelTextProperty_1198(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolarAxisLabelTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarAxisLabelTextProperty_1199(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarAxisLabelTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetLastRadialAxisTextProperty_1200(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLastRadialAxisTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolarAxesActor_GetLastRadialAxisTextProperty_1201(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLastRadialAxisTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetSecondaryRadialAxesTextProperty_1202(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSecondaryRadialAxesTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolarAxesActor_GetSecondaryRadialAxesTextProperty_1203(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSecondaryRadialAxesTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetPolarAxisProperty_1204(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolarAxisProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarAxisProperty_1205(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarAxisProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetLastRadialAxisProperty_1206(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLastRadialAxisProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolarAxesActor_GetLastRadialAxisProperty_1207(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLastRadialAxisProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetSecondaryRadialAxesProperty_1208(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSecondaryRadialAxesProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolarAxesActor_GetSecondaryRadialAxesProperty_1209(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSecondaryRadialAxesProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetPolarArcsProperty_1210(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolarArcsProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarArcsProperty_1211(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarArcsProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetSecondaryPolarArcsProperty_1212(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSecondaryPolarArcsProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolarAxesActor_GetSecondaryPolarArcsProperty_1213(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSecondaryPolarArcsProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetBounds_1214(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBounds(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetBounds_1215(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBounds(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_GetBounds_1216(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetRatio_1217(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRatio(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetRatioMinValue_1218(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRatioMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetRatioMaxValue_1219(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRatioMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetRatio_1220(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRatio();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolarAxesActor_SetPolarArcResolutionPerDegree_1221(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolarArcResolutionPerDegree(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarArcResolutionPerDegreeMinValue_1222(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarArcResolutionPerDegreeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarArcResolutionPerDegreeMaxValue_1223(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarArcResolutionPerDegreeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPolarAxesActor_GetPolarArcResolutionPerDegree_1224(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPolarAxesActor* op = static_cast<vtkPolarAxesActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolarArcResolutionPerDegree();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPolarAxesActor_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPolarAxesActor::New());
}
