// java wrapper for vtkCurveRepresentation object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCurveRepresentation.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkWidgetRepresentation_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCurveRepresentation_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCurveRepresentation",dType)) { return me; }
  if ((res= vtkWidgetRepresentation_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCurveRepresentation_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCurveRepresentation_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCurveRepresentation_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCurveRepresentation_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetInteractionState_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteractionState(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetProjectToPlane_15(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProjectToPlane(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCurveRepresentation_GetProjectToPlane_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProjectToPlane();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_ProjectToPlaneOn_17(JNIEnv* env, jobject obj)
{

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ProjectToPlaneOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_ProjectToPlaneOff_18(JNIEnv* env, jobject obj)
{

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ProjectToPlaneOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetPlaneSource_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPlaneSource * temp0;
  temp0 = static_cast<vtkPlaneSource*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlaneSource(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetProjectionNormal_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProjectionNormal(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCurveRepresentation_GetProjectionNormalMinValue_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProjectionNormalMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCurveRepresentation_GetProjectionNormalMaxValue_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProjectionNormalMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCurveRepresentation_GetProjectionNormal_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProjectionNormal();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetProjectionNormalToXAxes_114(JNIEnv* env, jobject obj)
{

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProjectionNormalToXAxes();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetProjectionNormalToYAxes_115(JNIEnv* env, jobject obj)
{

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProjectionNormalToYAxes();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetProjectionNormalToZAxes_116(JNIEnv* env, jobject obj)
{

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProjectionNormalToZAxes();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetProjectionNormalToOblique_117(JNIEnv* env, jobject obj)
{

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProjectionNormalToOblique();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetProjectionPosition_118(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProjectionPosition(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCurveRepresentation_GetProjectionPosition_119(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProjectionPosition();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_GetPolyData_120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPolyData * temp0;
  temp0 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPolyData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCurveRepresentation_GetHandleProperty_121(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHandleProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCurveRepresentation_GetSelectedHandleProperty_122(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectedHandleProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCurveRepresentation_GetLineProperty_123(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLineProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCurveRepresentation_GetSelectedLineProperty_124(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectedLineProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetNumberOfHandles_125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfHandles(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCurveRepresentation_GetNumberOfHandles_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfHandles();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetDirectional_127(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDirectional(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCurveRepresentation_GetDirectional_128(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDirectional();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_DirectionalOn_129(JNIEnv* env, jobject obj)
{

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->DirectionalOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_DirectionalOff_130(JNIEnv* env, jobject obj)
{

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->DirectionalOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetHandlePosition_131(JNIEnv* env, jobject obj,jint id0,jdouble id1,jdouble id2,jdouble id3)
{
  int   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHandlePosition(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetHandlePosition_132(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHandlePosition(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_GetHandlePosition_133(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetHandlePosition(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCurveRepresentation_GetHandlePositions_134(JNIEnv* env, jobject obj)
{
  vtkDoubleArray * temp20;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHandlePositions();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetClosed_135(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetClosed(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCurveRepresentation_GetClosed_136(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetClosed();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_ClosedOn_137(JNIEnv* env, jobject obj)
{

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClosedOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_ClosedOff_138(JNIEnv* env, jobject obj)
{

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClosedOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCurveRepresentation_IsClosed_139(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsClosed();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCurveRepresentation_GetSummedLength_140(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSummedLength();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_InitializeHandles_141(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPoints * temp0;
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitializeHandles(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_BuildRepresentation_142(JNIEnv* env, jobject obj)
{

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildRepresentation();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCurveRepresentation_ComputeInteractionState_143(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeInteractionState(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_StartWidgetInteraction_144(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartWidgetInteraction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_WidgetInteraction_145(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->WidgetInteraction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_EndWidgetInteraction_146(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->EndWidgetInteraction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_ReleaseGraphicsResources_147(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCurveRepresentation_RenderOpaqueGeometry_148(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCurveRepresentation_RenderTranslucentPolygonalGeometry_149(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentPolygonalGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCurveRepresentation_RenderOverlay_150(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOverlay(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCurveRepresentation_HasTranslucentPolygonalGeometry_151(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetLineColor_152(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLineColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetInteractionColor_153(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteractionColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetInteractionColor_154(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteractionColor(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetForegroundColor_155(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForegroundColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetForegroundColor_156(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForegroundColor(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_RegisterPickers_157(JNIEnv* env, jobject obj)
{

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->RegisterPickers();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetCurrentHandleIndex_158(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCurrentHandleIndex(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCurveRepresentation_GetCurrentHandleIndex_159(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCurrentHandleIndex();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCurveRepresentation_GetTranslationAxis_160(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTranslationAxis();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetTranslationAxis_161(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTranslationAxis(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCurveRepresentation_GetTranslationAxisMinValue_162(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTranslationAxisMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCurveRepresentation_GetTranslationAxisMaxValue_163(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTranslationAxisMaxValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetXTranslationAxisOn_164(JNIEnv* env, jobject obj)
{

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXTranslationAxisOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetYTranslationAxisOn_165(JNIEnv* env, jobject obj)
{

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYTranslationAxisOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetZTranslationAxisOn_166(JNIEnv* env, jobject obj)
{

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZTranslationAxisOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_SetTranslationAxisOff_167(JNIEnv* env, jobject obj)
{

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTranslationAxisOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCurveRepresentation_IsTranslationConstrained_168(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTranslationConstrained();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCurveRepresentation_GetActors_169(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPropCollection * temp0;
  temp0 = static_cast<vtkPropCollection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCurveRepresentation* op = static_cast<vtkCurveRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetActors(temp0);

}
