// java wrapper for vtkImageReader2 object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageReader2.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageReader2_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageReader2",dType)) { return me; }
  if ((res= vtkImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReader2_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReader2_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageReader2_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageReader2_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetFileName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageReader2_GetFileName_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetFileNames_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkStringArray * temp0;
  temp0 = static_cast<vtkStringArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileNames(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageReader2_GetFileNames_17(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileNames();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetFilePrefix_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFilePrefix(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageReader2_GetFilePrefix_19(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFilePrefix();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetFilePattern_110(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFilePattern(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageReader2_GetFilePattern_111(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFilePattern();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetMemoryBufferLength_112(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMemoryBufferLength(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageReader2_GetMemoryBufferLength_113(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMemoryBufferLength();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetDataScalarType_114(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataScalarType(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetDataScalarTypeToFloat_115(JNIEnv* env, jobject obj)
{

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataScalarTypeToFloat();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetDataScalarTypeToDouble_116(JNIEnv* env, jobject obj)
{

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataScalarTypeToDouble();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetDataScalarTypeToInt_117(JNIEnv* env, jobject obj)
{

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataScalarTypeToInt();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetDataScalarTypeToUnsignedInt_118(JNIEnv* env, jobject obj)
{

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataScalarTypeToUnsignedInt();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetDataScalarTypeToShort_119(JNIEnv* env, jobject obj)
{

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataScalarTypeToShort();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetDataScalarTypeToUnsignedShort_120(JNIEnv* env, jobject obj)
{

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataScalarTypeToUnsignedShort();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetDataScalarTypeToChar_121(JNIEnv* env, jobject obj)
{

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataScalarTypeToChar();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetDataScalarTypeToSignedChar_122(JNIEnv* env, jobject obj)
{

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataScalarTypeToSignedChar();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetDataScalarTypeToUnsignedChar_123(JNIEnv* env, jobject obj)
{

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataScalarTypeToUnsignedChar();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReader2_GetDataScalarType_124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataScalarType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetNumberOfScalarComponents_125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfScalarComponents(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReader2_GetNumberOfScalarComponents_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfScalarComponents();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetDataExtent_127(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataExtent(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetDataExtent_128(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataExtent(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImageReader2_GetDataExtent_129(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataExtent();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetFileDimensionality_130(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileDimensionality(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReader2_GetFileDimensionality_131(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileDimensionality();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetDataSpacing_132(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSpacing(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetDataSpacing_133(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSpacing(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageReader2_GetDataSpacing_134(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataSpacing();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetDataOrigin_135(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataOrigin(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetDataOrigin_136(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataOrigin(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageReader2_GetDataOrigin_137(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataOrigin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageReader2_GetDataDirection_138(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataDirection();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 9);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageReader2_GetHeaderSize_139(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHeaderSize();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageReader2_GetHeaderSize_140(JNIEnv* env, jobject obj,jlong id0)
{
   unsigned long   temp0;
   unsigned long   temp20;
  temp0 = id0;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHeaderSize(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetHeaderSize_141(JNIEnv* env, jobject obj,jlong id0)
{
   unsigned long   temp0;
  temp0 = id0;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHeaderSize(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetDataByteOrderToBigEndian_142(JNIEnv* env, jobject obj)
{

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataByteOrderToBigEndian();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetDataByteOrderToLittleEndian_143(JNIEnv* env, jobject obj)
{

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataByteOrderToLittleEndian();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReader2_GetDataByteOrder_144(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataByteOrder();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetDataByteOrder_145(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataByteOrder(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageReader2_GetDataByteOrderAsString_146(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataByteOrderAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetFileNameSliceOffset_147(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileNameSliceOffset(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReader2_GetFileNameSliceOffset_148(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileNameSliceOffset();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetFileNameSliceSpacing_149(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileNameSliceSpacing(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReader2_GetFileNameSliceSpacing_150(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileNameSliceSpacing();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetSwapBytes_151(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSwapBytes(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReader2_GetSwapBytes_152(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSwapBytes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SwapBytesOn_153(JNIEnv* env, jobject obj)
{

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SwapBytesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SwapBytesOff_154(JNIEnv* env, jobject obj)
{

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SwapBytesOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReader2_OpenFile_155(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->OpenFile();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_CloseFile_156(JNIEnv* env, jobject obj)
{

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->CloseFile();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SeekFile_157(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SeekFile(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_FileLowerLeftOn_158(JNIEnv* env, jobject obj)
{

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->FileLowerLeftOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_FileLowerLeftOff_159(JNIEnv* env, jobject obj)
{

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->FileLowerLeftOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReader2_GetFileLowerLeft_160(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileLowerLeft();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_SetFileLowerLeft_161(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileLowerLeft(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageReader2_ComputeInternalFileName_162(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeInternalFileName(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageReader2_GetInternalFileName_163(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInternalFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageReader2_CanReadFile_164(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanReadFile(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageReader2_GetFileExtensions_165(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileExtensions();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageReader2_GetDescriptiveName_166(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkImageReader2* op = static_cast<vtkImageReader2*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDescriptiveName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageReader2_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageReader2::New());
}
