// java wrapper for vtkMatrix4x4 object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkMatrix4x4.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkMatrix4x4_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkMatrix4x4",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMatrix4x4_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMatrix4x4_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMatrix4x4_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMatrix4x4_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_DeepCopy_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_DeepCopy_15(JNIEnv* env, jobject obj,jdoubleArray id0,jobject id1)
{
  double temp0[16];
  vtkMatrix4x4 * temp1;
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);
  temp1 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id1));

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 16, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_DeepCopy_16(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[16];
  double temp1[16];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 16, &temp1[0]);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 16, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_DeepCopy_17(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[16];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_Zero_18(JNIEnv* env, jobject obj)
{

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->Zero();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_Zero_19(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[16];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->Zero(temp0);
  env->SetDoubleArrayRegion(id0, 0, 16, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_Identity_110(JNIEnv* env, jobject obj)
{

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->Identity();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_Identity_111(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[16];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->Identity(temp0);
  env->SetDoubleArrayRegion(id0, 0, 16, &temp0[0]);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMatrix4x4_IsIdentity_112(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsIdentity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_Invert_113(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkMatrix4x4 * temp0;
  vtkMatrix4x4 * temp1;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id1));

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->Invert(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_Invert_114(JNIEnv* env, jobject obj)
{

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->Invert();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_Invert_115(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[16];
  double temp1[16];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 16, &temp1[0]);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->Invert(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 16, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_Transpose_116(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkMatrix4x4 * temp0;
  vtkMatrix4x4 * temp1;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id1));

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->Transpose(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_Transpose_117(JNIEnv* env, jobject obj)
{

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->Transpose();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_Transpose_118(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[16];
  double temp1[16];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 16, &temp1[0]);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->Transpose(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 16, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_MatrixFromRotation_119(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jobject id4)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  vtkMatrix4x4 * temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id4));

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->MatrixFromRotation(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_MatrixFromRotation_120(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdoubleArray id4)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double temp4[16];
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  env->GetDoubleArrayRegion(id4, 0, 16, &temp4[0]);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->MatrixFromRotation(temp0,temp1,temp2,temp3,temp4);
  env->SetDoubleArrayRegion(id4, 0, 16, &temp4[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_PoseToMatrix_121(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jobject id2)
{
  double temp0[3];
  double temp1[4];
  vtkMatrix4x4 * temp2;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);
  temp2 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id2));

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->PoseToMatrix(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_MultiplyPoint_122(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[4];
  float temp1[4];
  env->GetFloatArrayRegion(id0, 0, 4, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 4, &temp1[0]);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->MultiplyPoint(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 4, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_MultiplyPoint_123(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[4];
  double temp1[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->MultiplyPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_MultiplyPoint_124(JNIEnv* env, jobject obj,jdoubleArray id0,jfloatArray id1,jfloatArray id2)
{
  double temp0[16];
  float temp1[4];
  float temp2[4];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 4, &temp1[0]);
  env->GetFloatArrayRegion(id2, 0, 4, &temp2[0]);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->MultiplyPoint(temp0,temp1,temp2);
  env->SetFloatArrayRegion(id2, 0, 4, &temp2[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_MultiplyPoint_125(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[16];
  double temp1[4];
  double temp2[4];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 4, &temp2[0]);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->MultiplyPoint(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id2, 0, 4, &temp2[0]);

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkMatrix4x4_MultiplyPoint_126(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[4];
  float * temp20;
  env->GetFloatArrayRegion(id0, 0, 4, &temp0[0]);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MultiplyPoint(temp0);
  return vtkJavaMakeJArrayOfFloat(env, temp20, 4);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkMatrix4x4_MultiplyPoint_127(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  double * temp20;
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MultiplyPoint(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 4);

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkMatrix4x4_MultiplyFloatPoint_128(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[4];
  float * temp20;
  env->GetFloatArrayRegion(id0, 0, 4, &temp0[0]);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MultiplyFloatPoint(temp0);
  return vtkJavaMakeJArrayOfFloat(env, temp20, 4);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkMatrix4x4_MultiplyDoublePoint_129(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  double * temp20;
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MultiplyDoublePoint(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_Multiply4x4_130(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkMatrix4x4 * temp0;
  vtkMatrix4x4 * temp1;
  vtkMatrix4x4 * temp2;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id2));

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->Multiply4x4(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_Multiply4x4_131(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[16];
  double temp1[16];
  double temp2[16];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 16, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 16, &temp2[0]);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->Multiply4x4(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id2, 0, 16, &temp2[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_Multiply4x4_132(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jfloatArray id2)
{
  double temp0[16];
  double temp1[16];
  float temp2[16];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 16, &temp1[0]);
  env->GetFloatArrayRegion(id2, 0, 16, &temp2[0]);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->Multiply4x4(temp0,temp1,temp2);
  env->SetFloatArrayRegion(id2, 0, 16, &temp2[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_MultiplyAndTranspose4x4_133(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jfloatArray id2)
{
  double temp0[16];
  double temp1[16];
  float temp2[16];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 16, &temp1[0]);
  env->GetFloatArrayRegion(id2, 0, 16, &temp2[0]);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->MultiplyAndTranspose4x4(temp0,temp1,temp2);
  env->SetFloatArrayRegion(id2, 0, 16, &temp2[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_Adjoint_134(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkMatrix4x4 * temp0;
  vtkMatrix4x4 * temp1;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id1));

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->Adjoint(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_Adjoint_135(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[16];
  double temp1[16];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 16, &temp1[0]);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->Adjoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 16, &temp1[0]);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMatrix4x4_Determinant_136(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Determinant();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMatrix4x4_Determinant_137(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[16];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Determinant(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_SetElement_138(JNIEnv* env, jobject obj,jint id0,jint id1,jdouble id2)
{
  int   temp0;
  int   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetElement(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMatrix4x4_GetElement_139(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  double   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElement(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkMatrix4x4_GetData_140(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 16);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMatrix4x4_SetData_141(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[16];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);

  vtkMatrix4x4* op = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetData(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkMatrix4x4_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkMatrix4x4::New());
}
