// java wrapper for vtkPolyhedron object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPolyhedron.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkCell3D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPolyhedron_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPolyhedron",dType)) { return me; }
  if ((res= vtkCell3D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyhedron_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyhedron_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyhedron_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyhedron_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolyhedron_GetCentroid_14(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  bool   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCentroid(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyhedron_GetCellType_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyhedron_RequiresInitialization_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RequiresInitialization();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyhedron_Initialize_17(JNIEnv* env, jobject obj)
{

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyhedron_GetNumberOfEdges_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdges();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyhedron_GetEdge_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdge(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyhedron_GetNumberOfFaces_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFaces();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyhedron_GetFace_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFace(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyhedron_Contour_112(JNIEnv* env, jobject obj,jdouble id0,jobject id1,jobject id2,jobject id3,jobject id4,jobject id5,jobject id6,jobject id7,jobject id8,jlong id9,jobject id10)
{
  double   temp0;
  vtkDataArray * temp1;
  vtkIncrementalPointLocator * temp2;
  vtkCellArray * temp3;
  vtkCellArray * temp4;
  vtkCellArray * temp5;
  vtkPointData * temp6;
  vtkPointData * temp7;
  vtkCellData * temp8;
  long long   temp9;
  vtkCellData * temp10;
  temp0 = id0;
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id6));
  temp7 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id7));
  temp8 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id8));
  temp9 = id9;
  temp10 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id10));

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  op->Contour(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9,temp10);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyhedron_Clip_113(JNIEnv* env, jobject obj,jdouble id0,jobject id1,jobject id2,jobject id3,jobject id4,jobject id5,jobject id6,jlong id7,jobject id8,jint id9)
{
  double   temp0;
  vtkDataArray * temp1;
  vtkIncrementalPointLocator * temp2;
  vtkCellArray * temp3;
  vtkPointData * temp4;
  vtkPointData * temp5;
  vtkCellData * temp6;
  long long   temp7;
  vtkCellData * temp8;
  int   temp9;
  temp0 = id0;
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id6));
  temp7 = id7;
  temp8 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id8));
  temp9 = id9;

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  op->Clip(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyhedron_TriangulateLocalIds_114(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkIdList * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TriangulateLocalIds(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyhedron_TriangulateFaces_115(JNIEnv* env, jobject obj,jobject id0)
{
  vtkIdList * temp0;
  int   temp20;
  temp0 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TriangulateFaces(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyhedron_TriangulateFaces_116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCellArray * temp0;
  int   temp20;
  temp0 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TriangulateFaces(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyhedron_CellBoundary_117(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1,jobject id2)
{
  int   temp0;
  double temp1[3];
  vtkIdList * temp2;
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CellBoundary(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyhedron_GetParametricCenter_118(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParametricCenter(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyhedron_IsPrimaryCell_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsPrimaryCell();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyhedron_RequiresExplicitFaceRepresentation_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RequiresExplicitFaceRepresentation();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyhedron_SetCellFaces_121(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCellArray * temp0;
  int   temp20;
  temp0 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetCellFaces(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyhedron_GetCellFaces_122(JNIEnv* env, jobject obj)
{
  vtkCellArray * temp20;

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellFaces();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyhedron_GetCellFaces_123(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCellArray * temp0;
  temp0 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellFaces(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyhedron_IsInside_124(JNIEnv* env, jobject obj,jdoubleArray id0,jdouble id1)
{
  double temp0[3];
  double   temp1;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = id1;

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsInside(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolyhedron_IsConvex_125(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsConvex();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyhedron_GetPolyData_126(JNIEnv* env, jobject obj)
{
  vtkPolyData * temp20;

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolyData();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyhedron_ShallowCopy_127(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCell * temp0;
  temp0 = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyhedron_DeepCopy_128(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCell * temp0;
  temp0 = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolyhedron* op = static_cast<vtkPolyhedron*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPolyhedron_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPolyhedron::New());
}
