// java wrapper for vtkCellArray object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCellArray.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAbstractCellArray_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCellArray_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCellArray",dType)) { return me; }
  if ((res= vtkAbstractCellArray_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCellArray_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCellArray_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCellArray_Allocate_14(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Allocate(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellArray_AllocateEstimate_15(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AllocateEstimate(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellArray_AllocateExact_16(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AllocateExact(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellArray_AllocateCopy_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCellArray * temp0;
  bool   temp20;
  temp0 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AllocateCopy(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellArray_ResizeExact_18(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ResizeExact(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_Initialize_19(JNIEnv* env, jobject obj)
{

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_Reset_110(JNIEnv* env, jobject obj)
{

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->Reset();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_Squeeze_111(JNIEnv* env, jobject obj)
{

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->Squeeze();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellArray_IsValid_112(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsValid();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_GetNumberOfCells_113(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCells();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_GetNumberOfOffsets_114(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfOffsets();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_GetOffset_115(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOffset(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_SetOffset_116(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOffset(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_GetNumberOfConnectivityIds_117(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfConnectivityIds();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_NewIterator_118(JNIEnv* env, jobject obj)
{
  vtkCellArrayIterator * temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewIterator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_SetData_119(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkIdTypeArray * temp0;
  vtkIdTypeArray * temp1;
  temp0 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetData(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_SetData_120(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkTypeInt32Array * temp0;
  vtkTypeInt32Array * temp1;
  temp0 = static_cast<vtkTypeInt32Array*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkTypeInt32Array*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetData(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_SetData_121(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkTypeInt64Array * temp0;
  vtkTypeInt64Array * temp1;
  temp0 = static_cast<vtkTypeInt64Array*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkTypeInt64Array*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetData(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellArray_SetData_122(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkDataArray * temp0;
  vtkDataArray * temp1;
  bool   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetData(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellArray_SetData_123(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkDataArray * temp1;
  bool   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetData(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellArray_IsStorage64Bit_124(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsStorage64Bit();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellArray_IsStorageShareable_125(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsStorageShareable();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_Use32BitStorage_126(JNIEnv* env, jobject obj)
{

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->Use32BitStorage();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_Use64BitStorage_127(JNIEnv* env, jobject obj)
{

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->Use64BitStorage();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_UseDefaultStorage_128(JNIEnv* env, jobject obj)
{

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseDefaultStorage();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellArray_CanConvertTo32BitStorage_129(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanConvertTo32BitStorage();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellArray_CanConvertTo64BitStorage_130(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanConvertTo64BitStorage();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellArray_CanConvertToDefaultStorage_131(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanConvertToDefaultStorage();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellArray_ConvertTo32BitStorage_132(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ConvertTo32BitStorage();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellArray_ConvertTo64BitStorage_133(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ConvertTo64BitStorage();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellArray_ConvertToDefaultStorage_134(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ConvertToDefaultStorage();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellArray_ConvertToSmallestStorage_135(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ConvertToSmallestStorage();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_GetOffsetsArray_136(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOffsetsArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_GetOffsetsArray32_137(JNIEnv* env, jobject obj)
{
  vtkTypeInt32Array * temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOffsetsArray32();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_GetOffsetsArray64_138(JNIEnv* env, jobject obj)
{
  vtkTypeInt64Array * temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOffsetsArray64();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_GetConnectivityArray_139(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConnectivityArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_GetConnectivityArray32_140(JNIEnv* env, jobject obj)
{
  vtkTypeInt32Array * temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConnectivityArray32();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_GetConnectivityArray64_141(JNIEnv* env, jobject obj)
{
  vtkTypeInt64Array * temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConnectivityArray64();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_IsHomogeneous_142(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsHomogeneous();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_InitTraversal_143(JNIEnv* env, jobject obj)
{

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitTraversal();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCellArray_GetNextCell_144(JNIEnv* env, jobject obj,jobject id0)
{
  vtkIdList * temp0;
  int   temp20;
  temp0 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNextCell(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_GetCellAtId_145(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellAtId(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_GetCellPointAtId_146(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  long long   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellPointAtId(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_GetCellSize_147(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellSize(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_InsertNextCell_148(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCell * temp0;
  long long   temp20;
  temp0 = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextCell(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_InsertNextCell_149(JNIEnv* env, jobject obj,jobject id0)
{
  vtkIdList * temp0;
  long long   temp20;
  temp0 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextCell(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_InsertNextCell_150(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  long long   temp20;
  temp0 = id0;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextCell(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_InsertCellPoint_151(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertCellPoint(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_UpdateCellCount_152(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateCellCount(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_GetTraversalCellId_153(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTraversalCellId();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_SetTraversalCellId_154(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTraversalCellId(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_ReverseCellAtId_155(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReverseCellAtId(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_ReplaceCellAtId_156(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReplaceCellAtId(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_ReplaceCellPointAtId_157(JNIEnv* env, jobject obj,jlong id0,jlong id1,jlong id2)
{
  long long   temp0;
  long long   temp1;
  long long   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReplaceCellPointAtId(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCellArray_GetMaxCellSize_158(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxCellSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_DeepCopy_159(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractCellArray * temp0;
  temp0 = static_cast<vtkAbstractCellArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_ShallowCopy_160(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractCellArray * temp0;
  temp0 = static_cast<vtkAbstractCellArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_Append_161(JNIEnv* env, jobject obj,jobject id0,jlong id1)
{
  vtkCellArray * temp0;
  long long   temp1;
  temp0 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->Append(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_ExportLegacyFormat_162(JNIEnv* env, jobject obj,jobject id0)
{
  vtkIdTypeArray * temp0;
  temp0 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->ExportLegacyFormat(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_ImportLegacyFormat_163(JNIEnv* env, jobject obj,jobject id0)
{
  vtkIdTypeArray * temp0;
  temp0 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->ImportLegacyFormat(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_AppendLegacyFormat_164(JNIEnv* env, jobject obj,jobject id0,jlong id1)
{
  vtkIdTypeArray * temp0;
  long long   temp1;
  temp0 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->AppendLegacyFormat(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_GetActualMemorySize_165(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCellArray_GetDefaultStorageIs64Bit_166(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDefaultStorageIs64Bit();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_SetDefaultStorageIs64Bit_167(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDefaultStorageIs64Bit(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_SetNumberOfCells_168(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfCells(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_EstimateSize_169(JNIEnv* env, jobject obj,jlong id0,jint id1)
{
  long long   temp0;
  int   temp1;
  long long   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EstimateSize(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_GetSize_170(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSize();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_GetNumberOfConnectivityEntries_171(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfConnectivityEntries();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_GetCell_172(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCell(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_GetInsertLocation_173(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  long long   temp20;
  temp0 = id0;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInsertLocation(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_GetTraversalLocation_174(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTraversalLocation();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_GetTraversalLocation_175(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTraversalLocation(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_SetTraversalLocation_176(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTraversalLocation(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_ReverseCell_177(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReverseCell(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCellArray_SetCells_178(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdTypeArray * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCells(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCellArray_GetData_179(JNIEnv* env, jobject obj)
{
  vtkIdTypeArray * temp20;

  vtkCellArray* op = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkCellArray_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkCellArray::New());
}
