// java wrapper for vtkUnsignedShortArray object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkUnsignedShortArray.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataArray_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkUnsignedShortArray_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkUnsignedShortArray",dType)) { return me; }
  if ((res= vtkDataArray_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}

// Array conversion routines
extern "C" JNIEXPORT jshortArray JNICALL Java_vtk_vtkUnsignedShortArray_GetJavaArray_10(JNIEnv* env, jobject obj)
{
  vtkUnsignedShortArray* op = static_cast<vtkUnsignedShortArray*>(vtkJavaGetPointerFromObject(env, obj));
  unsigned short* buffer = op->GetPointer(0);
  return vtkJavaMakeJArrayOfShort(env, reinterpret_cast<jshort*>(buffer), op->GetSize());
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnsignedShortArray_SetJavaArray_10(JNIEnv* env, jobject obj, jshortArray id0, jint len0)
{
  vtkUnsignedShortArray* op = static_cast<vtkUnsignedShortArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfTuples(len0 / op->GetNumberOfComponents());
  unsigned short* buffer = op->GetPointer(0);
  env->GetShortArrayRegion(id0, 0, len0, reinterpret_cast<jshort*>(buffer));
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnsignedShortArray_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnsignedShortArray* op = static_cast<vtkUnsignedShortArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnsignedShortArray_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnsignedShortArray* op = static_cast<vtkUnsignedShortArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnsignedShortArray_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnsignedShortArray* op = static_cast<vtkUnsignedShortArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnsignedShortArray_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnsignedShortArray* op = static_cast<vtkUnsignedShortArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnsignedShortArray_ExtendedNew_14(JNIEnv* env, jobject obj)
{
  vtkUnsignedShortArray * temp20;

  vtkUnsignedShortArray* op = static_cast<vtkUnsignedShortArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ExtendedNew();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnsignedShortArray_GetDataType_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkUnsignedShortArray* op = static_cast<vtkUnsignedShortArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataType();
  return temp20;

}

extern "C" JNIEXPORT jshort  JNICALL Java_vtk_vtkUnsignedShortArray_GetValue_16(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
   unsigned short   temp20;
  temp0 = id0;

  vtkUnsignedShortArray* op = static_cast<vtkUnsignedShortArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnsignedShortArray_SetValue_17(JNIEnv* env, jobject obj,jlong id0,jshort id1)
{
  long long   temp0;
   unsigned short   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkUnsignedShortArray* op = static_cast<vtkUnsignedShortArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetValue(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkUnsignedShortArray_SetNumberOfValues_18(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  bool   temp20;
  temp0 = id0;

  vtkUnsignedShortArray* op = static_cast<vtkUnsignedShortArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetNumberOfValues(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnsignedShortArray_InsertValue_19(JNIEnv* env, jobject obj,jlong id0,jshort id1)
{
  long long   temp0;
   unsigned short   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkUnsignedShortArray* op = static_cast<vtkUnsignedShortArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertValue(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnsignedShortArray_InsertNextValue_110(JNIEnv* env, jobject obj,jshort id0)
{
   unsigned short   temp0;
  long long   temp20;
  temp0 = id0;

  vtkUnsignedShortArray* op = static_cast<vtkUnsignedShortArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnsignedShortArray_FastDownCast_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractArray * temp0;
  vtkUnsignedShortArray * temp20;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkUnsignedShortArray* op = static_cast<vtkUnsignedShortArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FastDownCast(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jshort  JNICALL Java_vtk_vtkUnsignedShortArray_GetDataTypeValueMin_112(JNIEnv* env, jobject obj)
{
   unsigned short   temp20;

  vtkUnsignedShortArray* op = static_cast<vtkUnsignedShortArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeValueMin();
  return temp20;

}

extern "C" JNIEXPORT jshort  JNICALL Java_vtk_vtkUnsignedShortArray_GetDataTypeValueMax_113(JNIEnv* env, jobject obj)
{
   unsigned short   temp20;

  vtkUnsignedShortArray* op = static_cast<vtkUnsignedShortArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeValueMax();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkUnsignedShortArray_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkUnsignedShortArray::New());
}
