// java wrapper for vtkAxis object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkAxis.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkContextItem_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkAxis_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkAxis",dType)) { return me; }
  if ((res= vtkContextItem_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxis_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxis_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxis_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxis_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetPosition_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxis_GetPosition_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPosition();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetPoint1_16(JNIEnv* env, jobject obj,jfloat id0,jfloat id1)
{
  float   temp0;
  float   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint1(temp0,temp1);

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkAxis_GetPoint1_17(JNIEnv* env, jobject obj)
{
  float * temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint1();
  return vtkJavaMakeJArrayOfFloat(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetPoint2_18(JNIEnv* env, jobject obj,jfloat id0,jfloat id1)
{
  float   temp0;
  float   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint2(temp0,temp1);

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkAxis_GetPoint2_19(JNIEnv* env, jobject obj)
{
  float * temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint2();
  return vtkJavaMakeJArrayOfFloat(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetNumberOfTicks_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfTicks(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxis_GetNumberOfTicks_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfTicks();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetTickLength_112(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTickLength(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkAxis_GetTickLength_113(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickLength();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxis_GetLabelProperties_114(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelProperties();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetMinimum_115(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinimum(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxis_GetMinimum_116(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinimum();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetMaximum_117(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximum(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxis_GetMaximum_118(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximum();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetUnscaledMinimum_119(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUnscaledMinimum(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxis_GetUnscaledMinimum_120(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUnscaledMinimum();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetUnscaledMaximum_121(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUnscaledMaximum(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxis_GetUnscaledMaximum_122(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUnscaledMaximum();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetRange_123(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetRange_124(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRange(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetUnscaledRange_125(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUnscaledRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetUnscaledRange_126(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUnscaledRange(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetMinimumLimit_127(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinimumLimit(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxis_GetMinimumLimit_128(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinimumLimit();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetMaximumLimit_129(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumLimit(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxis_GetMaximumLimit_130(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumLimit();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetUnscaledMinimumLimit_131(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUnscaledMinimumLimit(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxis_GetUnscaledMinimumLimit_132(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUnscaledMinimumLimit();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetUnscaledMaximumLimit_133(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUnscaledMaximumLimit(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxis_GetUnscaledMaximumLimit_134(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUnscaledMaximumLimit();
  return temp20;

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkAxis_GetMargins_135(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMargins();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetMargins_136(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMargins(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetMargins_137(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMargins(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetTitle_138(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  vtkStdString temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitle(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkAxis_GetTitle_139(JNIEnv* env, jobject obj)
{
  vtkStdString   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitle();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxis_GetTitleProperties_140(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitleProperties();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxis_GetLogScaleActive_141(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLogScaleActive();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxis_GetLogScale_142(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLogScale();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetLogScale_143(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLogScale(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_LogScaleOn_144(JNIEnv* env, jobject obj)
{

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->LogScaleOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_LogScaleOff_145(JNIEnv* env, jobject obj)
{

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->LogScaleOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetGridVisible_146(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridVisible(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxis_GetGridVisible_147(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridVisible();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetLabelsVisible_148(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelsVisible(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxis_GetLabelsVisible_149(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelsVisible();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetRangeLabelsVisible_150(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRangeLabelsVisible(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxis_GetRangeLabelsVisible_151(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRangeLabelsVisible();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetLabelOffset_152(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelOffset(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkAxis_GetLabelOffset_153(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelOffset();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetTicksVisible_154(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTicksVisible(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxis_GetTicksVisible_155(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTicksVisible();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetAxisVisible_156(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisVisible(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxis_GetAxisVisible_157(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisVisible();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetTitleVisible_158(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleVisible(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxis_GetTitleVisible_159(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitleVisible();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetPrecision_160(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPrecision(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxis_GetPrecision_161(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPrecision();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetLabelFormat_162(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelFormat(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkAxis_GetLabelFormat_163(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelFormat();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetRangeLabelFormat_164(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string   temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRangeLabelFormat(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkAxis_GetRangeLabelFormat_165(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRangeLabelFormat();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetNotation_166(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNotation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxis_GetNotation_167(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNotation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetBehavior_168(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBehavior(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxis_GetBehavior_169(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBehavior();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetPen_170(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPen * temp0;
  temp0 = static_cast<vtkPen*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPen(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxis_GetPen_171(JNIEnv* env, jobject obj)
{
  vtkPen * temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPen();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetGridPen_172(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPen * temp0;
  temp0 = static_cast<vtkPen*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridPen(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxis_GetGridPen_173(JNIEnv* env, jobject obj)
{
  vtkPen * temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridPen();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetTickLabelAlgorithm_174(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTickLabelAlgorithm(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxis_GetTickLabelAlgorithm_175(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickLabelAlgorithm();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetScalingFactor_176(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalingFactor(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxis_GetScalingFactor_177(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalingFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_SetShift_178(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShift(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxis_GetShift_179(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShift();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_Update_180(JNIEnv* env, jobject obj)
{

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->Update();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxis_Paint_181(JNIEnv* env, jobject obj,jobject id0)
{
  vtkContext2D * temp0;
  bool   temp20;
  temp0 = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Paint(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_AutoScale_182(JNIEnv* env, jobject obj)
{

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutoScale();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxis_RecalculateTickSpacing_183(JNIEnv* env, jobject obj)
{

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  op->RecalculateTickSpacing();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxis_GetTickPositions_184(JNIEnv* env, jobject obj)
{
  vtkDoubleArray * temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickPositions();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxis_GetTickScenePositions_185(JNIEnv* env, jobject obj)
{
  vtkFloatArray * temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickScenePositions();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxis_GetTickLabels_186(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickLabels();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxis_SetCustomTickPositions_187(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkDoubleArray * temp0;
  vtkStringArray * temp1;
  bool   temp20;
  temp0 = static_cast<vtkDoubleArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkStringArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetCustomTickPositions(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxis_NiceNumber_188(JNIEnv* env, jobject obj,jdouble id0,jboolean id1)
{
  double   temp0;
  bool   temp1;
  double   temp20;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NiceNumber(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkAxis_GenerateSimpleLabel_189(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  vtkStdString   temp20;
  temp0 = id0;

  vtkAxis* op = static_cast<vtkAxis*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GenerateSimpleLabel(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkAxis_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkAxis::New());
}
