// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "raycasterfs.h"

const char *raycasterfs =
"//VTK::System::Dec\n"
"\n"
"// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen\n"
"// SPDX-License-Identifier: BSD-3-Clause\n"
"\n"
"//////////////////////////////////////////////////////////////////////////////\n"
"///\n"
"/// Inputs\n"
"///\n"
"//////////////////////////////////////////////////////////////////////////////\n"
"\n"
"/// 3D texture coordinates form vertex shader\n"
"in vec3 ip_textureCoords;\n"
"in vec3 ip_vertexPos;\n"
"\n"
"//////////////////////////////////////////////////////////////////////////////\n"
"///\n"
"/// Outputs\n"
"///\n"
"//////////////////////////////////////////////////////////////////////////////\n"
"\n"
"vec4 g_fragColor = vec4(0.0);\n"
"\n"
"//////////////////////////////////////////////////////////////////////////////\n"
"///\n"
"/// Uniforms, attributes, and globals\n"
"///\n"
"//////////////////////////////////////////////////////////////////////////////\n"
"vec3 g_dirStep;\n"
"float g_lengthStep = 0.0;\n"
"vec4 g_srcColor;\n"
"vec4 g_eyePosObj;\n"
"bool g_exit;\n"
"bool g_skip;\n"
"float g_currentT;\n"
"float g_terminatePointMax;\n"
"\n"
"// These describe the entire ray for this scene, not just the current depth\n"
"// peeling segment. These are texture coordinates.\n"
"vec3 g_rayOrigin; // Entry point of volume or clip point\n"
"vec3 g_rayTermination; // Termination point (depth, clip, etc)\n"
"\n"
"// These describe the current segment. If not peeling, they are initialized to\n"
"// the ray endpoints.\n"
"vec3 g_dataPos;\n"
"vec3 g_terminatePos;\n"
"\n"
"float g_jitterValue = 0.0;\n"
"\n"
"//VTK::CustomUniforms::Dec\n"
"\n"
"//VTK::Output::Dec\n"
"\n"
"//VTK::Base::Dec\n"
"\n"
"//VTK::Termination::Dec\n"
"\n"
"//VTK::Cropping::Dec\n"
"\n"
"//VTK::Clipping::Dec\n"
"\n"
"#define EPSILON 0.001\n"
"\n"
"// Computes the intersection between a ray and a box\n"
"// The box should be axis aligned so we only give two arguments\n"
"struct Hit\n"
"{\n"
"  float tmin;\n"
"  float tmax;\n"
"};\n"
"\n"
"struct Ray\n"
"{\n"
"  vec3 origin;\n"
"  vec3 dir;\n"
"  vec3 invDir;\n"
"};\n"
"\n"
"bool BBoxIntersect(const vec3 boxMin, const vec3 boxMax, const Ray r, out Hit hit)\n"
"{\n"
"  vec3 tbot = r.invDir * (boxMin - r.origin);\n"
"  vec3 ttop = r.invDir * (boxMax - r.origin);\n"
"  vec3 tmin = min(ttop, tbot);\n"
"  vec3 tmax = max(ttop, tbot);\n"
"  vec2 t = max(tmin.xx, tmin.yz);\n"
"  float t0 = max(t.x, t.y);\n"
"  t = min(tmax.xx, tmax.yz);\n"
"  float t1 = min(t.x, t.y);\n"
"  hit.tmin = t0;\n"
"  hit.tmax = t1;\n"
"  return t1 > max(t0, 0.0);\n"
"}\n"
"\n"
"// As BBoxIntersect requires the inverse of the ray coords,\n"
"// this function is used to avoid numerical issues\n"
"void safe_0_vector(inout Ray ray)\n"
"{\n"
"  if(abs(ray.dir.x) < EPSILON) ray.dir.x = sign(ray.dir.x) * EPSILON;\n"
"  if(abs(ray.dir.y) < EPSILON) ray.dir.y = sign(ray.dir.y) * EPSILON;\n"
"  if(abs(ray.dir.z) < EPSILON) ray.dir.z = sign(ray.dir.z) * EPSILON;\n"
"}\n"
"\n"
"// the phase function should be normalized to 4pi for compatibility with surface rendering\n"
"//VTK::PhaseFunction::Dec\n"
"\n"
"//VTK::ComputeColor::Unif\n"
"\n"
"//VTK::Shading::Dec\n"
"\n"
"//VTK::BinaryMask::Dec\n"
"\n"
"//VTK::CompositeMask::Dec\n"
"\n"
"//VTK::GradientCache::Dec\n"
"\n"
"//VTK::Transfer2D::Dec\n"
"\n"
"//VTK::ComputeGradientOpacity1D::Dec\n"
"\n"
"//VTK::ComputeOpacity::Dec\n"
"\n"
"//VTK::ComputeRGBA2DWithGradient::Dec\n"
"\n"
"//VTK::ComputeGradient::Dec\n"
"\n"
"//VTK::ComputeDensityGradient::Dec\n"
"\n"
"//VTK::ComputeVolumetricShadow::Dec\n"
"\n"
"//VTK::ComputeLighting::Dec\n"
"\n"
"//VTK::ComputeColor::Dec\n"
"\n"
"//VTK::ComputeRayDirection::Dec\n"
"\n"
"//VTK::Picking::Dec\n"
"\n"
"//VTK::RenderToImage::Dec\n"
"\n"
"//VTK::DepthPeeling::Dec\n"
"\n"
"uniform float in_scale;\n"
"uniform float in_bias;\n"
"\n"
"//////////////////////////////////////////////////////////////////////////////\n"
"///\n"
"/// Helper functions\n"
"///\n"
"//////////////////////////////////////////////////////////////////////////////\n"
"\n"
"/**\n"
" * Transform window coordinate to NDC.\n"
" */\n"
"vec4 WindowToNDC(const float xCoord, const float yCoord, const float zCoord)\n"
"{\n"
"  vec4 NDCCoord = vec4(0.0, 0.0, 0.0, 1.0);\n"
"\n"
"  NDCCoord.x = (xCoord - in_windowLowerLeftCorner.x) * 2.0 *\n"
"    in_inverseWindowSize.x - 1.0;\n"
"  NDCCoord.y = (yCoord - in_windowLowerLeftCorner.y) * 2.0 *\n"
"    in_inverseWindowSize.y - 1.0;\n"
"  NDCCoord.z = (2.0 * zCoord - (gl_DepthRange.near + gl_DepthRange.far)) /\n"
"    gl_DepthRange.diff;\n"
"\n"
"  return NDCCoord;\n"
"}\n"
"\n"
"/**\n"
" * Transform NDC coordinate to window coordinates.\n"
" */\n"
"vec4 NDCToWindow(const float xNDC, const float yNDC, const float zNDC)\n"
"{\n"
"  vec4 WinCoord = vec4(0.0, 0.0, 0.0, 1.0);\n"
"\n"
"  WinCoord.x = (xNDC + 1.f) / (2.f * in_inverseWindowSize.x) +\n"
"    in_windowLowerLeftCorner.x;\n"
"  WinCoord.y = (yNDC + 1.f) / (2.f * in_inverseWindowSize.y) +\n"
"    in_windowLowerLeftCorner.y;\n"
"  WinCoord.z = (zNDC * gl_DepthRange.diff +\n"
"    (gl_DepthRange.near + gl_DepthRange.far)) / 2.f;\n"
"\n"
"  return WinCoord;\n"
"}\n"
"\n"
"/**\n"
" * Clamps the texture coordinate vector @a pos to a new position in the set\n"
" * { start + i * step }, where i is an integer. If @a ceiling\n"
" * is true, the sample located further in the direction of @a step is used,\n"
" * otherwise the sample location closer to the eye is used.\n"
" * This function assumes both start and pos already have jittering applied.\n"
" */\n"
"vec3 ClampToSampleLocation(vec3 start, vec3 step, vec3 pos, bool ceiling)\n"
"{\n"
"  vec3 offset = pos - start;\n"
"  float stepLength = length(step);\n"
"\n"
"  // Scalar projection of offset on step:\n"
"  float dist = dot(offset, step / stepLength);\n"
"  if (dist < 0.) // Don't move before the start position:\n"
"  {\n"
"    return start;\n"
"  }\n"
"\n"
"  // Number of steps\n"
"  float steps = dist / stepLength;\n"
"\n"
"  // If we're reeaaaaallly close, just round -- it's likely just numerical noise\n"
"  // and the value should be considered exact.\n"
"  if (abs(mod(steps, 1.)) > 1e-5)\n"
"  {\n"
"    if (ceiling)\n"
"    {\n"
"      steps = ceil(steps);\n"
"    }\n"
"    else\n"
"    {\n"
"      steps = floor(steps);\n"
"    }\n"
"  }\n"
"  else\n"
"  {\n"
"    steps = floor(steps + 0.5);\n"
"  }\n"
"\n"
"  return start + steps * step;\n"
"}\n"
"\n"
"//////////////////////////////////////////////////////////////////////////////\n"
"///\n"
"/// Ray-casting\n"
"///\n"
"//////////////////////////////////////////////////////////////////////////////\n"
"\n"
"/**\n"
" * Global initialization. This method should only be called once per shader\n"
" * invocation regardless of whether castRay() is called several times (e.g.\n"
" * vtkDualDepthPeelingPass). Any castRay() specific initialization should be\n"
" * placed within that function.\n"
" */\n"
"void initializeRayCast()\n"
"{\n"
"  /// Initialize g_fragColor (output) to 0\n"
"  g_fragColor = vec4(0.0);\n"
"  g_dirStep = vec3(0.0);\n"
"  g_srcColor = vec4(0.0);\n"
"  g_exit = false;\n"
"\n"
"  //VTK::Base::Init\n"
"\n"
"  //VTK::Cropping::Init\n"
"\n"
"  //VTK::Terminate::Init\n"
"\n"
"  //VTK::Clipping::Init\n"
"\n"
"  //VTK::RenderToImage::Init\n"
"\n"
"  //VTK::DepthPass::Init\n"
"\n"
"  //VTK::Matrices::Init\n"
"\n"
"  g_jitterValue = jitterValue;\n"
"}\n"
"\n"
"/**\n"
" * March along the ray direction sampling the volume texture.  This function\n"
" * takes a start and end point as arguments but it is up to the specific render\n"
" * pass implementation to use these values (e.g. vtkDualDepthPeelingPass). The\n"
" * mapper does not use these values by default, instead it uses the number of\n"
" * steps defined by g_terminatePointMax.\n"
" */\n"
"vec4 castRay(const float zStart, const float zEnd)\n"
"{\n"
"  //VTK::DepthPeeling::Ray::Init\n"
"\n"
"  //VTK::Clipping::Impl\n"
"\n"
"  //VTK::DepthPeeling::Ray::PathCheck\n"
"\n"
"  //VTK::Shading::Init\n"
"\n"
"  /// For all samples along the ray\n"
"  while (!g_exit)\n"
"  {\n"
"    //VTK::Base::Impl\n"
"\n"
"    //VTK::Cropping::Impl\n"
"\n"
"    //VTK::BinaryMask::Impl\n"
"\n"
"    //VTK::CompositeMask::Impl\n"
"\n"
"    //VTK::PreComputeGradients::Impl\n"
"\n"
"    //VTK::Shading::Impl\n"
"\n"
"    //VTK::RenderToImage::Impl\n"
"\n"
"    //VTK::DepthPass::Impl\n"
"\n"
"    /// Advance ray\n"
"    g_dataPos += g_dirStep;\n"
"\n"
"    //VTK::Terminate::Impl\n"
"  }\n"
"\n"
"  //VTK::Shading::Exit\n"
"\n"
"  return g_fragColor;\n"
"}\n"
"\n"
"/**\n"
" * Finalize specific modes and set output data.\n"
" */\n"
"void finalizeRayCast()\n"
"{\n"
"  //VTK::Base::Exit\n"
"\n"
"  //VTK::Terminate::Exit\n"
"\n"
"  //VTK::Cropping::Exit\n"
"\n"
"  //VTK::Clipping::Exit\n"
"\n"
"  //VTK::Picking::Exit\n"
"\n"
"  g_fragColor.r = g_fragColor.r * in_scale + in_bias * g_fragColor.a;\n"
"  g_fragColor.g = g_fragColor.g * in_scale + in_bias * g_fragColor.a;\n"
"  g_fragColor.b = g_fragColor.b * in_scale + in_bias * g_fragColor.a;\n"
"  gl_FragData[0] = g_fragColor;\n"
"\n"
"  //VTK::RenderToImage::Exit\n"
"\n"
"  //VTK::DepthPass::Exit\n"
"}\n"
"\n"
"//////////////////////////////////////////////////////////////////////////////\n"
"///\n"
"/// Main\n"
"///\n"
"//////////////////////////////////////////////////////////////////////////////\n"
"void main()\n"
"{\n"
"  //VTK::CallWorker::Impl\n"
"}\n"
"";
